"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const dynamodb = require("@aws-cdk/aws-dynamodb");
const cdk = require("@aws-cdk/core");
const _1 = require(".");
const ruleList = {
    DYNAMODB_TABLE_ENCRYPTED_KMS: true,
    DYNAMODB_PITR_ENABLED: true,
    BACKUP_RECOVERY_POINT_MANUAL_DELETION_DISABLED: true,
};
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'my-demo-stack', { env });
        new _1.CompliantDynamoDb(stack, 'compliantdynamodb', {
            tableName: 'mytesttable',
            contributorInsightsEnabled: true,
            partitionKey: {
                name: 'id',
                type: dynamodb.AttributeType.STRING,
            },
            configRuleList: ruleList,
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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