"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompliantDynamoDb = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const backup = require("@aws-cdk/aws-backup");
const dynamodb = require("@aws-cdk/aws-dynamodb");
const aws_events_1 = require("@aws-cdk/aws-events");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * Creates a DynamoDB table that is secured by an AWS backup plan und with point in time recovery enabled by default.
 *
 * @stability stable
 */
class CompliantDynamoDb extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        this.dynamodbTable = new dynamodb.Table(this, 'DynamoDBTable', {
            tableName: props.tableName,
            billingMode: dynamodb.BillingMode.PAY_PER_REQUEST,
            partitionKey: (_b = props.partitionKey) !== null && _b !== void 0 ? _b : {
                name: 'id',
                type: dynamodb.AttributeType.STRING,
            },
            sortKey: props.sortKey,
            pointInTimeRecovery: props.configRuleList.DYNAMODB_PITR_ENABLED == true
                ? true
                : props.pointInTimeRecovery,
            encryption: props.configRuleList.DYNAMODB_TABLE_ENCRYPTED_KMS == true
                ? dynamodb.TableEncryption.CUSTOMER_MANAGED
                : props.encryption,
            encryptionKey: props.encryptionKey,
            contributorInsightsEnabled: props.contributorInsightsEnabled,
            kinesisStream: props.kinesisStream,
            replicationRegions: props.replicationRegions,
            replicationTimeout: props.replicationTimeout,
            timeToLiveAttribute: props.timeToLiveAttribute,
        });
        if (props.configRuleList.BACKUP_RECOVERY_POINT_MANUAL_DELETION_DISABLED ==
            true) {
            this.backupVault = new backup.BackupVault(this, 'BackupVault', {
                backupVaultName: `${props.tableName}-backup-vault`,
                accessPolicy: new iam.PolicyDocument({
                    statements: [
                        new iam.PolicyStatement({
                            sid: 'backup-recovery-point-manual-deletion-disabled',
                            effect: iam.Effect.DENY,
                            principals: [new iam.AnyPrincipal()],
                            actions: [
                                'backup:DeleteRecoveryPoint',
                                'backup:PutBackupVaultAccessPolicy',
                                'backup:UpdateRecoveryPointLifecycle',
                            ],
                            resources: ['*'],
                        }),
                    ],
                }),
            });
        }
        else {
            this.backupVault = new backup.BackupVault(this, 'BackupVault', {
                backupVaultName: `${props.tableName}-backup-vault`,
            });
        }
        this.backupPlan = new backup.BackupPlan(this, 'DynamoDbBackupPlan', {
            backupPlanName: `${this.dynamodbTable.tableName}-backup-plan`,
            backupVault: this.backupVault,
            backupPlanRules: [
                new backup.BackupPlanRule({
                    ruleName: 'daily-dynamodb-backup',
                    scheduleExpression: (_c = props.backupPlanStartTime) !== null && _c !== void 0 ? _c : aws_events_1.Schedule.cron({
                        hour: '21',
                        minute: '0',
                    }),
                    deleteAfter: cdk.Duration.days(35),
                }),
            ],
        });
        this.backupPlan.addSelection('DynamoDB', {
            resources: [backup.BackupResource.fromDynamoDbTable(this.dynamodbTable)],
        });
    }
}
exports.CompliantDynamoDb = CompliantDynamoDb;
_a = JSII_RTTI_SYMBOL_1;
CompliantDynamoDb[_a] = { fqn: "compliantdynamodb.CompliantDynamoDb", version: "0.0.23" };
//# sourceMappingURL=data:application/json;base64,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