import * as backup from '@aws-cdk/aws-backup';
import * as dynamodb from '@aws-cdk/aws-dynamodb';
import { Schedule } from '@aws-cdk/aws-events';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface CompliantDynamoDbProps extends dynamodb.TableProps {
    /**
     * @stability stable
     */
    readonly backupVaultName?: string;
    /**
     * @stability stable
     */
    readonly backupPlanStartTime?: Schedule;
    /**
     * interface parameter description test.
     *
     * @stability stable
     */
    readonly configRuleList?: any;
}
/**
 * Creates a DynamoDB table that is secured by an AWS backup plan und with point in time recovery enabled by default.
 *
 * @stability stable
 */
export declare class CompliantDynamoDb extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly dynamodbTable: dynamodb.Table;
    /**
     * @stability stable
     */
    readonly backupPlan: backup.BackupPlan;
    /**
     * @stability stable
     */
    readonly backupVault: backup.BackupVault;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: CompliantDynamoDbProps);
}
