from enum import Enum

class DevicePropertyType(Enum):
    Undefined                       = 0x5000
    BatteryLevel                    = 0x5001
    FunctionalMode                  = 0x5002 # @see FunctionalMode
    ImageSize                       = 0x5003
    CompressionSetting              = 0x5004
    WhiteBalance                    = 0x5005 # @see WhiteBalance
    RGBGain                         = 0x5006
    FNumber                         = 0x5007
    FocalLength                     = 0x5008
    FocusDistance                   = 0x5009
    FocusMode                       = 0x500A # @see FocusMode
    ExposureMeteringMode            = 0x500B # @see ExposureMeteringMode
    FlashMode                       = 0x500C # @see FlashMode
    ExposureTime                    = 0x500D # @see ExposureTime
    ExposureProgramMode             = 0x500E # @see ExposureProgramMode
    ExposureIndex                   = 0x500F # @see ExposureIndex
    ExposureBiasCompensation        = 0x5010
    DateTime                        = 0x5011
    CaptureDelay                    = 0x5012
    StillCaptureMode                = 0x5013 # @see StillCaptureMode
    Contrast                        = 0x5014
    Sharpness                       = 0x5015
    DigitalZoom                     = 0x5016
    EffectMode                      = 0x5017
    BurstNumber                     = 0x5018
    BurstInterval                   = 0x5019
    TimelapseNumber                 = 0x501A
    TimelapseInterval               = 0x501B
    FocusMeteringMode               = 0x501C # @see FocusMeteringMode
    UploadUrl                       = 0x501D
    Artist                          = 0x501E
    CopyrightInfo                   = 0x501F

    AudioVolume                     = 0x502C

    ErrorInfo                       = 0xD006
    ShutterSpeed                    = 0xD00F # @see ShutterSpeed

    WBTuneAuto                      = 0xD017
    WBTuneIncandescent              = 0xD018
    WBTuneFluorescent               = 0xD019 # @see WBTuneFluorescent
    WBTuneSunny                     = 0xD01A
    WBTuneFlash                     = 0xD01B
    WBTuneCloudy                    = 0xD01C
    WBTuneShade                     = 0xD01D
    WBPresetDataNo                  = 0xD01F
    WBPresetDataValue0              = 0xD025
    WBPresetDataValue1              = 0xD026
    ColorSpace                      = 0xD032
    ResetCustomSetting              = 0xD045
    ISOAutoControl                  = 0xD054 # @see OnOffProperty
    ExposureEVStep                  = 0xD056 # @see ExposureEVStep
    AfAtLiveView                    = 0xD05D
    AELockRelease                   = 0xD05E # @see OnOffProperty
    AEAFLockSetting                 = 0xD05F # @see AEAFLockSetting
    AutoMeterOffDelay               = 0xD062 # @see AutoMeterOffDelay
    SelfTimerDelay                  = 0xD063 # @see SelfTimerDelay
    LCDPowerOff                     = 0xD064 # @see LCDPowerOff
    ImageConfirmTimeAfterPhoto      = 0xD065
    AutoOffTime                     = 0xD066 # @see AutoOffTime
    ExposureDelay                   = 0xD06A # @see ExposureDelay
    NoiseReduction                  = 0xD06B
    NumberingMode                   = 0xD06C # @see NumberingMode
    NoiseReductionHiIso             = 0xD070
    BracketingType                  = 0xD078 # @see BracketingType
    FunctionButton                  = 0xD084 # @see FunctionButton
    CommandDialRotation             = 0xD085 # @see CommandDialRotation
    EnableShutter                   = 0xD08A # @see OnOffProperty
    CommentString                   = 0xD090
    EnableComment                   = 0xD091 # @see OnOffProperty
    OrientationSensorMode           = 0xD092 # @see OnOffProperty
    MovieRecordScreenSize           = 0xD0A0
    MovieRecordWithVoice            = 0xD0A1
    LiveViewScreenDisplaySetting    = 0xD0B2 # @see LiveViewScreenDisplaySetting
    EnableBracketing                = 0xD0C0 # @see OnOffProperty
    AEBracketingStep                = 0xD0C1 # @see AEBracketingStep
    AEBracketingCount               = 0xD0C3
    WBBracketingStep                = 0xD0C4 # @see WBBracketingStep
    LensID                          = 0xD0E0
    LensSort                        = 0xD0E1 # @see LensSort
    LensType                        = 0xD0E2
    LensFocalMin                    = 0xD0E3
    LensFocalMax                    = 0xD0E4
    LensApatureMin                  = 0xD0E5
    LensApatureMax                  = 0xD0E6
    FinderISODisplay                = 0xD0F0 # @see OnOffProperty
    SelfTimerShootExpose            = 0xD0F5 # @see SelfTimerShootExpose
    AutoDistortion                  = 0xD0F8
    SceneMode                       = 0xD0F9
    ShutterSpeed2                   = 0xD100 # @see ShutterSpeed
    ExternalDCIn                    = 0xD101 # @see OnOffProperty
    WarningStatus                   = 0xD102 # @see WarningStatus
    RemainingExposure               = 0xD103
    AFLockStatus                    = 0xD104 # @see OnOffProperty
    AELockStatus                    = 0xD105 # @see OnOffProperty
    FocusArea                       = 0xD108 # @see FocusArea
    FlexibleProgram                 = 0xD109 # @see FlexibleProgram
    RecordingMedia                  = 0xD10B # @see RecordingMedia
    USBSpeed                        = 0xD10C
    CCDNumber                       = 0xD10D
    Orientation                     = 0xD10E # @see Orientation
    ExternalSpeedLightExist         = 0xD120 # @see OnOffProperty
    ExternalSpeedLightStatus        = 0xD121 # @see ExternalSpeedLightStatus
    ExternalSpeedLightSort          = 0xD122 # @see ExternalSpeedLightSort
    FlashCompensation               = 0xD124 # @see FlashCompensation
    NewExternalSpeedLightMode       = 0xD125 # @see NewExternalSpeedLightMode
    InternalFlashCompensation       = 0xD126 # @see InternalFlashCompensation
    ActiveDLighting                 = 0xD14E
    WBTuneFluorescentType           = 0xD14F
    Beep                            = 0xD160 # @see Beep
    AFModeSelect                    = 0xD161 # @see AFModeSelect
    AFSubLight                      = 0xD163
    ISOAutoShutterTime              = 0xD164 # @see ExposureTime
    InternalFlashMode               = 0xD167 # @see InternalFlashMode
    ISOAutoSetting                  = 0xD16A
    RemoteControlDelay              = 0xD16B # @see RemoteControlDelay
    GridDisplay                     = 0xD16C # @see OnOffProperty
    InternalFlashManual             = 0xD16D # @see InternalFlashManual
    DateImprintSetting              = 0xD170 # @see DateImprintSetting
    DateCounterSelect               = 0xD171 # @see DateCounterSelect
    DateCountData                   = 0xD172
    DateCountDisplaySetting         = 0xD173 # @see DateCountDisplaySetting
    RangeFinderSetting              = 0xD174
    ISOAutoHighLimit                = 0xD183 # @see ExposureIndex
    IndicatorDisplay                = 0xD18D # @see IndicatorDisplay
    LiveViewStatus                  = 0xD1A2
    LiveViewImageZoomRatio          = 0xD1A3
    LiveViewProhibitionCondition    = 0xD1A4
    ExposureDisplayStatus           = 0xD1B0 # @see ExposureDisplayStatus
    ExposureIndicateStatus          = 0xD1B1 # @see ExposureIndicateStatus
    InfoDisplayErrorStatus          = 0xD1B2 # @see OnOffProperty
    ExposureIndicateLightup         = 0xD1B3 # @see OnOffProperty
    InternalFlashPopup              = 0xD1C0 # @see OnOffProperty
    InternalFlashStatus             = 0xD1C1 # @see InternalFlashStatus

    ActivePicCtrlItem               = 0xD200 # @see ActivePicCtrlItem
    ChangePicCtrlItem               = 0xD201
    DeviceEUI64                     = 0xD210

    FunctionalID                    = 0xD301
    ModelID                         = 0xD302
    UseDeviceStageFlag              = 0xD303

    SynchronizationPartner          = 0xD401
    DeviceFriendlyName              = 0xD402
    Volume                          = 0xD403
    SupportedFormatsOrdered         = 0xD404
    DeviceIcon                      = 0xD405
    SessionInitiatorVersionInfo     = 0xD406
    PerceivedDeviceType             = 0xD407
    PlaybackRate                    = 0xD410
    PlaybackObject                  = 0xD411
    PlaybackContainerIndex          = 0xD412
    PlaybackPosition                = 0xD413

    GpsInfo                         = 0xD801
    AutoPowerOffDelay               = 0xD802
    SleepDelay                      = 0xD803
    ChannelNumber                   = 0xD807
    CaptureStatus                   = 0xD808
    RecordingTime                   = 0xD809
    RemainingRecordingTime          = 0xD80A
