# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from Tea.converter import TeaConverter


class AddAgentDeviceRequest(TeaModel):
    def __init__(self, instance_id=None, client_ip=None, client_port=None, browser_version=None, remark=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.client_ip = TeaConverter.to_unicode(client_ip)  # type: unicode
        self.client_port = TeaConverter.to_unicode(client_port)  # type: unicode
        self.browser_version = TeaConverter.to_unicode(browser_version)  # type: unicode
        self.remark = TeaConverter.to_unicode(remark)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.client_port is not None:
            result['ClientPort'] = self.client_port
        if self.browser_version is not None:
            result['BrowserVersion'] = self.browser_version
        if self.remark is not None:
            result['Remark'] = self.remark
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('ClientPort') is not None:
            self.client_port = m.get('ClientPort')
        if m.get('BrowserVersion') is not None:
            self.browser_version = m.get('BrowserVersion')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        return self


class AddAgentDeviceResponseBody(TeaModel):
    def __init__(self, request_id=None, message=None, agent_device_id=None, http_status_code=None, code=None,
                 success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.agent_device_id = agent_device_id  # type: long
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.message is not None:
            result['Message'] = self.message
        if self.agent_device_id is not None:
            result['AgentDeviceId'] = self.agent_device_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('AgentDeviceId') is not None:
            self.agent_device_id = m.get('AgentDeviceId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddAgentDeviceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: AddAgentDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddAgentDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddBulkPhoneNumbersRequest(TeaModel):
    def __init__(self, instance_id=None, usage=None, contact_flow_id=None, phone_number=None, skill_group_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.usage = TeaConverter.to_unicode(usage)  # type: unicode
        self.contact_flow_id = TeaConverter.to_unicode(contact_flow_id)  # type: unicode
        self.phone_number = phone_number  # type: list[unicode]
        self.skill_group_id = skill_group_id  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class AddBulkPhoneNumbersResponseBodyArrearagePhoneNumbers(TeaModel):
    def __init__(self, arrearage_phone_number=None):
        self.arrearage_phone_number = arrearage_phone_number  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.arrearage_phone_number is not None:
            result['ArrearagePhoneNumber'] = self.arrearage_phone_number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ArrearagePhoneNumber') is not None:
            self.arrearage_phone_number = m.get('ArrearagePhoneNumber')
        return self


class AddBulkPhoneNumbersResponseBodyPhoneNumbersPhoneNumberSkillGroupsSkillGroup(TeaModel):
    def __init__(self, skill_group_name=None, skill_group_id=None):
        self.skill_group_name = TeaConverter.to_unicode(skill_group_name)  # type: unicode
        self.skill_group_id = TeaConverter.to_unicode(skill_group_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class AddBulkPhoneNumbersResponseBodyPhoneNumbersPhoneNumberSkillGroups(TeaModel):
    def __init__(self, skill_group=None):
        self.skill_group = skill_group  # type: list[AddBulkPhoneNumbersResponseBodyPhoneNumbersPhoneNumberSkillGroupsSkillGroup]

    def validate(self):
        if self.skill_group:
            for k in self.skill_group:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SkillGroup'] = []
        if self.skill_group is not None:
            for k in self.skill_group:
                result['SkillGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.skill_group = []
        if m.get('SkillGroup') is not None:
            for k in m.get('SkillGroup'):
                temp_model = AddBulkPhoneNumbersResponseBodyPhoneNumbersPhoneNumberSkillGroupsSkillGroup()
                self.skill_group.append(temp_model.from_map(k))
        return self


class AddBulkPhoneNumbersResponseBodyPhoneNumbersPhoneNumberContactFlow(TeaModel):
    def __init__(self, type=None, contact_flow_description=None, contact_flow_name=None, instance_id=None,
                 contact_flow_id=None):
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.contact_flow_description = TeaConverter.to_unicode(contact_flow_description)  # type: unicode
        self.contact_flow_name = TeaConverter.to_unicode(contact_flow_name)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.contact_flow_id = TeaConverter.to_unicode(contact_flow_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.contact_flow_description is not None:
            result['ContactFlowDescription'] = self.contact_flow_description
        if self.contact_flow_name is not None:
            result['ContactFlowName'] = self.contact_flow_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ContactFlowDescription') is not None:
            self.contact_flow_description = m.get('ContactFlowDescription')
        if m.get('ContactFlowName') is not None:
            self.contact_flow_name = m.get('ContactFlowName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        return self


class AddBulkPhoneNumbersResponseBodyPhoneNumbersPhoneNumber(TeaModel):
    def __init__(self, skill_groups=None, test_only=None, trunks=None, remaining_time=None, number=None,
                 instance_id=None, usage=None, allow_outbound=None, phone_number_description=None, contact_flow=None,
                 phone_number_id=None):
        self.skill_groups = skill_groups  # type: AddBulkPhoneNumbersResponseBodyPhoneNumbersPhoneNumberSkillGroups
        self.test_only = test_only  # type: bool
        self.trunks = trunks  # type: int
        self.remaining_time = remaining_time  # type: int
        self.number = TeaConverter.to_unicode(number)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.usage = TeaConverter.to_unicode(usage)  # type: unicode
        self.allow_outbound = allow_outbound  # type: bool
        self.phone_number_description = TeaConverter.to_unicode(phone_number_description)  # type: unicode
        self.contact_flow = contact_flow  # type: AddBulkPhoneNumbersResponseBodyPhoneNumbersPhoneNumberContactFlow
        self.phone_number_id = TeaConverter.to_unicode(phone_number_id)  # type: unicode

    def validate(self):
        if self.skill_groups:
            self.skill_groups.validate()
        if self.contact_flow:
            self.contact_flow.validate()

    def to_map(self):
        result = dict()
        if self.skill_groups is not None:
            result['SkillGroups'] = self.skill_groups.to_map()
        if self.test_only is not None:
            result['TestOnly'] = self.test_only
        if self.trunks is not None:
            result['Trunks'] = self.trunks
        if self.remaining_time is not None:
            result['RemainingTime'] = self.remaining_time
        if self.number is not None:
            result['Number'] = self.number
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.allow_outbound is not None:
            result['AllowOutbound'] = self.allow_outbound
        if self.phone_number_description is not None:
            result['PhoneNumberDescription'] = self.phone_number_description
        if self.contact_flow is not None:
            result['ContactFlow'] = self.contact_flow.to_map()
        if self.phone_number_id is not None:
            result['PhoneNumberId'] = self.phone_number_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SkillGroups') is not None:
            temp_model = AddBulkPhoneNumbersResponseBodyPhoneNumbersPhoneNumberSkillGroups()
            self.skill_groups = temp_model.from_map(m['SkillGroups'])
        if m.get('TestOnly') is not None:
            self.test_only = m.get('TestOnly')
        if m.get('Trunks') is not None:
            self.trunks = m.get('Trunks')
        if m.get('RemainingTime') is not None:
            self.remaining_time = m.get('RemainingTime')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('AllowOutbound') is not None:
            self.allow_outbound = m.get('AllowOutbound')
        if m.get('PhoneNumberDescription') is not None:
            self.phone_number_description = m.get('PhoneNumberDescription')
        if m.get('ContactFlow') is not None:
            temp_model = AddBulkPhoneNumbersResponseBodyPhoneNumbersPhoneNumberContactFlow()
            self.contact_flow = temp_model.from_map(m['ContactFlow'])
        if m.get('PhoneNumberId') is not None:
            self.phone_number_id = m.get('PhoneNumberId')
        return self


class AddBulkPhoneNumbersResponseBodyPhoneNumbers(TeaModel):
    def __init__(self, phone_number=None):
        self.phone_number = phone_number  # type: list[AddBulkPhoneNumbersResponseBodyPhoneNumbersPhoneNumber]

    def validate(self):
        if self.phone_number:
            for k in self.phone_number:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PhoneNumber'] = []
        if self.phone_number is not None:
            for k in self.phone_number:
                result['PhoneNumber'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.phone_number = []
        if m.get('PhoneNumber') is not None:
            for k in m.get('PhoneNumber'):
                temp_model = AddBulkPhoneNumbersResponseBodyPhoneNumbersPhoneNumber()
                self.phone_number.append(temp_model.from_map(k))
        return self


class AddBulkPhoneNumbersResponseBodyFailedPhoneNumbers(TeaModel):
    def __init__(self, failed_phone_number=None):
        self.failed_phone_number = failed_phone_number  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.failed_phone_number is not None:
            result['FailedPhoneNumber'] = self.failed_phone_number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FailedPhoneNumber') is not None:
            self.failed_phone_number = m.get('FailedPhoneNumber')
        return self


class AddBulkPhoneNumbersResponseBodyUserdPhoneNumbers(TeaModel):
    def __init__(self, userd_phone_number=None):
        self.userd_phone_number = userd_phone_number  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.userd_phone_number is not None:
            result['UserdPhoneNumber'] = self.userd_phone_number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('UserdPhoneNumber') is not None:
            self.userd_phone_number = m.get('UserdPhoneNumber')
        return self


class AddBulkPhoneNumbersResponseBody(TeaModel):
    def __init__(self, arrearage_phone_numbers=None, phone_numbers=None, message=None, request_id=None,
                 http_status_code=None, failed_phone_numbers=None, userd_phone_numbers=None, code=None, success=None):
        self.arrearage_phone_numbers = arrearage_phone_numbers  # type: AddBulkPhoneNumbersResponseBodyArrearagePhoneNumbers
        self.phone_numbers = phone_numbers  # type: AddBulkPhoneNumbersResponseBodyPhoneNumbers
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.failed_phone_numbers = failed_phone_numbers  # type: AddBulkPhoneNumbersResponseBodyFailedPhoneNumbers
        self.userd_phone_numbers = userd_phone_numbers  # type: AddBulkPhoneNumbersResponseBodyUserdPhoneNumbers
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.arrearage_phone_numbers:
            self.arrearage_phone_numbers.validate()
        if self.phone_numbers:
            self.phone_numbers.validate()
        if self.failed_phone_numbers:
            self.failed_phone_numbers.validate()
        if self.userd_phone_numbers:
            self.userd_phone_numbers.validate()

    def to_map(self):
        result = dict()
        if self.arrearage_phone_numbers is not None:
            result['ArrearagePhoneNumbers'] = self.arrearage_phone_numbers.to_map()
        if self.phone_numbers is not None:
            result['PhoneNumbers'] = self.phone_numbers.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.failed_phone_numbers is not None:
            result['FailedPhoneNumbers'] = self.failed_phone_numbers.to_map()
        if self.userd_phone_numbers is not None:
            result['UserdPhoneNumbers'] = self.userd_phone_numbers.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ArrearagePhoneNumbers') is not None:
            temp_model = AddBulkPhoneNumbersResponseBodyArrearagePhoneNumbers()
            self.arrearage_phone_numbers = temp_model.from_map(m['ArrearagePhoneNumbers'])
        if m.get('PhoneNumbers') is not None:
            temp_model = AddBulkPhoneNumbersResponseBodyPhoneNumbers()
            self.phone_numbers = temp_model.from_map(m['PhoneNumbers'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('FailedPhoneNumbers') is not None:
            temp_model = AddBulkPhoneNumbersResponseBodyFailedPhoneNumbers()
            self.failed_phone_numbers = temp_model.from_map(m['FailedPhoneNumbers'])
        if m.get('UserdPhoneNumbers') is not None:
            temp_model = AddBulkPhoneNumbersResponseBodyUserdPhoneNumbers()
            self.userd_phone_numbers = temp_model.from_map(m['UserdPhoneNumbers'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddBulkPhoneNumbersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: AddBulkPhoneNumbersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddBulkPhoneNumbersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPhoneNumberRequest(TeaModel):
    def __init__(self, instance_id=None, phone_number=None, usage=None, contact_flow_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.phone_number = TeaConverter.to_unicode(phone_number)  # type: unicode
        self.usage = TeaConverter.to_unicode(usage)  # type: unicode
        self.contact_flow_id = TeaConverter.to_unicode(contact_flow_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        return self


class AddPhoneNumberResponseBodyPhoneNumberContactFlow(TeaModel):
    def __init__(self, type=None, contact_flow_description=None, contact_flow_name=None, instance_id=None,
                 contact_flow_id=None):
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.contact_flow_description = TeaConverter.to_unicode(contact_flow_description)  # type: unicode
        self.contact_flow_name = TeaConverter.to_unicode(contact_flow_name)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.contact_flow_id = TeaConverter.to_unicode(contact_flow_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.contact_flow_description is not None:
            result['ContactFlowDescription'] = self.contact_flow_description
        if self.contact_flow_name is not None:
            result['ContactFlowName'] = self.contact_flow_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ContactFlowDescription') is not None:
            self.contact_flow_description = m.get('ContactFlowDescription')
        if m.get('ContactFlowName') is not None:
            self.contact_flow_name = m.get('ContactFlowName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        return self


class AddPhoneNumberResponseBodyPhoneNumber(TeaModel):
    def __init__(self, test_only=None, trunks=None, remaining_time=None, number=None, instance_id=None, usage=None,
                 allow_outbound=None, phone_number_description=None, contact_flow=None, phone_number_id=None):
        self.test_only = test_only  # type: bool
        self.trunks = trunks  # type: int
        self.remaining_time = remaining_time  # type: int
        self.number = TeaConverter.to_unicode(number)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.usage = TeaConverter.to_unicode(usage)  # type: unicode
        self.allow_outbound = allow_outbound  # type: bool
        self.phone_number_description = TeaConverter.to_unicode(phone_number_description)  # type: unicode
        self.contact_flow = contact_flow  # type: AddPhoneNumberResponseBodyPhoneNumberContactFlow
        self.phone_number_id = TeaConverter.to_unicode(phone_number_id)  # type: unicode

    def validate(self):
        if self.contact_flow:
            self.contact_flow.validate()

    def to_map(self):
        result = dict()
        if self.test_only is not None:
            result['TestOnly'] = self.test_only
        if self.trunks is not None:
            result['Trunks'] = self.trunks
        if self.remaining_time is not None:
            result['RemainingTime'] = self.remaining_time
        if self.number is not None:
            result['Number'] = self.number
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.allow_outbound is not None:
            result['AllowOutbound'] = self.allow_outbound
        if self.phone_number_description is not None:
            result['PhoneNumberDescription'] = self.phone_number_description
        if self.contact_flow is not None:
            result['ContactFlow'] = self.contact_flow.to_map()
        if self.phone_number_id is not None:
            result['PhoneNumberId'] = self.phone_number_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TestOnly') is not None:
            self.test_only = m.get('TestOnly')
        if m.get('Trunks') is not None:
            self.trunks = m.get('Trunks')
        if m.get('RemainingTime') is not None:
            self.remaining_time = m.get('RemainingTime')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('AllowOutbound') is not None:
            self.allow_outbound = m.get('AllowOutbound')
        if m.get('PhoneNumberDescription') is not None:
            self.phone_number_description = m.get('PhoneNumberDescription')
        if m.get('ContactFlow') is not None:
            temp_model = AddPhoneNumberResponseBodyPhoneNumberContactFlow()
            self.contact_flow = temp_model.from_map(m['ContactFlow'])
        if m.get('PhoneNumberId') is not None:
            self.phone_number_id = m.get('PhoneNumberId')
        return self


class AddPhoneNumberResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, phone_number=None, code=None,
                 success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.phone_number = phone_number  # type: AddPhoneNumberResponseBodyPhoneNumber
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.phone_number:
            self.phone_number.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('PhoneNumber') is not None:
            temp_model = AddPhoneNumberResponseBodyPhoneNumber()
            self.phone_number = temp_model.from_map(m['PhoneNumber'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddPhoneNumberResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: AddPhoneNumberResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddPhoneNumberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPhoneTagsRequest(TeaModel):
    def __init__(self, service_tag=None, region_name_province=None, region_name_city=None, type=None,
                 concurrency=None, instance_id=None, provider=None, sip_tag=None, phone_number_list=None):
        self.service_tag = TeaConverter.to_unicode(service_tag)  # type: unicode
        self.region_name_province = TeaConverter.to_unicode(region_name_province)  # type: unicode
        self.region_name_city = TeaConverter.to_unicode(region_name_city)  # type: unicode
        self.type = type  # type: int
        self.concurrency = concurrency  # type: int
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.provider = TeaConverter.to_unicode(provider)  # type: unicode
        self.sip_tag = TeaConverter.to_unicode(sip_tag)  # type: unicode
        self.phone_number_list = phone_number_list  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.service_tag is not None:
            result['ServiceTag'] = self.service_tag
        if self.region_name_province is not None:
            result['RegionNameProvince'] = self.region_name_province
        if self.region_name_city is not None:
            result['RegionNameCity'] = self.region_name_city
        if self.type is not None:
            result['Type'] = self.type
        if self.concurrency is not None:
            result['Concurrency'] = self.concurrency
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.provider is not None:
            result['Provider'] = self.provider
        if self.sip_tag is not None:
            result['SipTag'] = self.sip_tag
        if self.phone_number_list is not None:
            result['PhoneNumberList'] = self.phone_number_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ServiceTag') is not None:
            self.service_tag = m.get('ServiceTag')
        if m.get('RegionNameProvince') is not None:
            self.region_name_province = m.get('RegionNameProvince')
        if m.get('RegionNameCity') is not None:
            self.region_name_city = m.get('RegionNameCity')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Concurrency') is not None:
            self.concurrency = m.get('Concurrency')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Provider') is not None:
            self.provider = m.get('Provider')
        if m.get('SipTag') is not None:
            self.sip_tag = m.get('SipTag')
        if m.get('PhoneNumberList') is not None:
            self.phone_number_list = m.get('PhoneNumberList')
        return self


class AddPhoneTagsResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddPhoneTagsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: AddPhoneTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddPhoneTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssignJobsRequest(TeaModel):
    def __init__(self, instance_id=None, group_id=None, scenario_id=None, strategy_json=None, calling_number=None,
                 jobs_json=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.strategy_json = TeaConverter.to_unicode(strategy_json)  # type: unicode
        self.calling_number = calling_number  # type: list[unicode]
        self.jobs_json = jobs_json  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.strategy_json is not None:
            result['StrategyJson'] = self.strategy_json
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.jobs_json is not None:
            result['JobsJson'] = self.jobs_json
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('StrategyJson') is not None:
            self.strategy_json = m.get('StrategyJson')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('JobsJson') is not None:
            self.jobs_json = m.get('JobsJson')
        return self


class AssignJobsResponseBody(TeaModel):
    def __init__(self, request_id=None, message=None, http_status_code=None, code=None, success=None, group_id=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.message is not None:
            result['Message'] = self.message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class AssignJobsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: AssignJobsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AssignJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssignUsersRequest(TeaModel):
    def __init__(self, instance_id=None, user_ram_id=None, role_id=None, skill_group_id=None, skill_level=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.user_ram_id = user_ram_id  # type: list[unicode]
        self.role_id = role_id  # type: list[unicode]
        self.skill_group_id = skill_group_id  # type: list[unicode]
        self.skill_level = skill_level  # type: list[int]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_ram_id is not None:
            result['UserRamId'] = self.user_ram_id
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_level is not None:
            result['SkillLevel'] = self.skill_level
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserRamId') is not None:
            self.user_ram_id = m.get('UserRamId')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillLevel') is not None:
            self.skill_level = m.get('SkillLevel')
        return self


class AssignUsersResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AssignUsersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: AssignUsersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AssignUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CallOnlinePrivacyNumberRequest(TeaModel):
    def __init__(self, instance_id=None, tel_a=None, tel_b=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.tel_a = TeaConverter.to_unicode(tel_a)  # type: unicode
        self.tel_b = TeaConverter.to_unicode(tel_b)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.tel_a is not None:
            result['TelA'] = self.tel_a
        if self.tel_b is not None:
            result['TelB'] = self.tel_b
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TelA') is not None:
            self.tel_a = m.get('TelA')
        if m.get('TelB') is not None:
            self.tel_b = m.get('TelB')
        return self


class CallOnlinePrivacyNumberResponseBodyData(TeaModel):
    def __init__(self, represent=None, status_code=None, call_id=None, date_created=None, tel_x=None):
        self.represent = TeaConverter.to_unicode(represent)  # type: unicode
        self.status_code = TeaConverter.to_unicode(status_code)  # type: unicode
        self.call_id = TeaConverter.to_unicode(call_id)  # type: unicode
        self.date_created = TeaConverter.to_unicode(date_created)  # type: unicode
        self.tel_x = TeaConverter.to_unicode(tel_x)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.represent is not None:
            result['Represent'] = self.represent
        if self.status_code is not None:
            result['StatusCode'] = self.status_code
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.date_created is not None:
            result['DateCreated'] = self.date_created
        if self.tel_x is not None:
            result['TelX'] = self.tel_x
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Represent') is not None:
            self.represent = m.get('Represent')
        if m.get('StatusCode') is not None:
            self.status_code = m.get('StatusCode')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('DateCreated') is not None:
            self.date_created = m.get('DateCreated')
        if m.get('TelX') is not None:
            self.tel_x = m.get('TelX')
        return self


class CallOnlinePrivacyNumberResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, data=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: CallOnlinePrivacyNumberResponseBodyData
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            temp_model = CallOnlinePrivacyNumberResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CallOnlinePrivacyNumberResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CallOnlinePrivacyNumberResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CallOnlinePrivacyNumberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelJobsRequest(TeaModel):
    def __init__(self, instance_id=None, all=None, scenario_id=None, group_id=None, job_id=None,
                 job_reference_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.all = all  # type: bool
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.job_id = job_id  # type: list[unicode]
        self.job_reference_id = job_reference_id  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.all is not None:
            result['All'] = self.all
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_reference_id is not None:
            result['JobReferenceId'] = self.job_reference_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('All') is not None:
            self.all = m.get('All')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobReferenceId') is not None:
            self.job_reference_id = m.get('JobReferenceId')
        return self


class CancelJobsResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelJobsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CancelJobsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckNumberAvaliableRequest(TeaModel):
    def __init__(self, instance_id=None, callee=None, caller=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.callee = TeaConverter.to_unicode(callee)  # type: unicode
        self.caller = TeaConverter.to_unicode(caller)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.callee is not None:
            result['Callee'] = self.callee
        if self.caller is not None:
            result['Caller'] = self.caller
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Callee') is not None:
            self.callee = m.get('Callee')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        return self


class CheckNumberAvaliableResponseBodyCallerAvaliable(TeaModel):
    def __init__(self, avaliable=None, reason=None):
        self.avaliable = avaliable  # type: bool
        self.reason = TeaConverter.to_unicode(reason)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.avaliable is not None:
            result['Avaliable'] = self.avaliable
        if self.reason is not None:
            result['Reason'] = self.reason
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Avaliable') is not None:
            self.avaliable = m.get('Avaliable')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        return self


class CheckNumberAvaliableResponseBodyCalleeAvaliable(TeaModel):
    def __init__(self, avaliable=None, reason=None):
        self.avaliable = avaliable  # type: bool
        self.reason = TeaConverter.to_unicode(reason)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.avaliable is not None:
            result['Avaliable'] = self.avaliable
        if self.reason is not None:
            result['Reason'] = self.reason
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Avaliable') is not None:
            self.avaliable = m.get('Avaliable')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        return self


class CheckNumberAvaliableResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, caller_avaliable=None,
                 success=None, callee_avaliable=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.caller_avaliable = caller_avaliable  # type: CheckNumberAvaliableResponseBodyCallerAvaliable
        self.success = success  # type: bool
        self.callee_avaliable = callee_avaliable  # type: CheckNumberAvaliableResponseBodyCalleeAvaliable

    def validate(self):
        if self.caller_avaliable:
            self.caller_avaliable.validate()
        if self.callee_avaliable:
            self.callee_avaliable.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.caller_avaliable is not None:
            result['CallerAvaliable'] = self.caller_avaliable.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.callee_avaliable is not None:
            result['CalleeAvaliable'] = self.callee_avaliable.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CallerAvaliable') is not None:
            temp_model = CheckNumberAvaliableResponseBodyCallerAvaliable()
            self.caller_avaliable = temp_model.from_map(m['CallerAvaliable'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('CalleeAvaliable') is not None:
            temp_model = CheckNumberAvaliableResponseBodyCalleeAvaliable()
            self.callee_avaliable = temp_model.from_map(m['CalleeAvaliable'])
        return self


class CheckNumberAvaliableResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CheckNumberAvaliableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckNumberAvaliableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CommitContactFlowVersionModificationRequest(TeaModel):
    def __init__(self, instance_id=None, contact_flow_version_id=None, canvas=None, content=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.contact_flow_version_id = TeaConverter.to_unicode(contact_flow_version_id)  # type: unicode
        self.canvas = TeaConverter.to_unicode(canvas)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.contact_flow_version_id is not None:
            result['ContactFlowVersionId'] = self.contact_flow_version_id
        if self.canvas is not None:
            result['Canvas'] = self.canvas
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ContactFlowVersionId') is not None:
            self.contact_flow_version_id = m.get('ContactFlowVersionId')
        if m.get('Canvas') is not None:
            self.canvas = m.get('Canvas')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class CommitContactFlowVersionModificationResponseBodyContactFlowVersion(TeaModel):
    def __init__(self, status=None, last_modified=None, canvas=None, locked_by=None, version=None,
                 contact_flow_version_id=None, last_modified_by=None, contact_flow_version_description=None, content=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.last_modified = TeaConverter.to_unicode(last_modified)  # type: unicode
        self.canvas = TeaConverter.to_unicode(canvas)  # type: unicode
        self.locked_by = TeaConverter.to_unicode(locked_by)  # type: unicode
        self.version = TeaConverter.to_unicode(version)  # type: unicode
        self.contact_flow_version_id = TeaConverter.to_unicode(contact_flow_version_id)  # type: unicode
        self.last_modified_by = TeaConverter.to_unicode(last_modified_by)  # type: unicode
        self.contact_flow_version_description = TeaConverter.to_unicode(contact_flow_version_description)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.last_modified is not None:
            result['LastModified'] = self.last_modified
        if self.canvas is not None:
            result['Canvas'] = self.canvas
        if self.locked_by is not None:
            result['LockedBy'] = self.locked_by
        if self.version is not None:
            result['Version'] = self.version
        if self.contact_flow_version_id is not None:
            result['ContactFlowVersionId'] = self.contact_flow_version_id
        if self.last_modified_by is not None:
            result['LastModifiedBy'] = self.last_modified_by
        if self.contact_flow_version_description is not None:
            result['ContactFlowVersionDescription'] = self.contact_flow_version_description
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('LastModified') is not None:
            self.last_modified = m.get('LastModified')
        if m.get('Canvas') is not None:
            self.canvas = m.get('Canvas')
        if m.get('LockedBy') is not None:
            self.locked_by = m.get('LockedBy')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('ContactFlowVersionId') is not None:
            self.contact_flow_version_id = m.get('ContactFlowVersionId')
        if m.get('LastModifiedBy') is not None:
            self.last_modified_by = m.get('LastModifiedBy')
        if m.get('ContactFlowVersionDescription') is not None:
            self.contact_flow_version_description = m.get('ContactFlowVersionDescription')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class CommitContactFlowVersionModificationResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, contact_flow_version=None, http_status_code=None, code=None,
                 success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.contact_flow_version = contact_flow_version  # type: CommitContactFlowVersionModificationResponseBodyContactFlowVersion
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.contact_flow_version:
            self.contact_flow_version.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.contact_flow_version is not None:
            result['ContactFlowVersion'] = self.contact_flow_version.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ContactFlowVersion') is not None:
            temp_model = CommitContactFlowVersionModificationResponseBodyContactFlowVersion()
            self.contact_flow_version = temp_model.from_map(m['ContactFlowVersion'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CommitContactFlowVersionModificationResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CommitContactFlowVersionModificationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CommitContactFlowVersionModificationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBatchJobsRequest(TeaModel):
    def __init__(self, instance_id=None, name=None, description=None, scenario_id=None, strategy_json=None,
                 job_file_path=None, submitted=None, calling_number=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.strategy_json = TeaConverter.to_unicode(strategy_json)  # type: unicode
        self.job_file_path = TeaConverter.to_unicode(job_file_path)  # type: unicode
        self.submitted = submitted  # type: bool
        self.calling_number = calling_number  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.strategy_json is not None:
            result['StrategyJson'] = self.strategy_json
        if self.job_file_path is not None:
            result['JobFilePath'] = self.job_file_path
        if self.submitted is not None:
            result['Submitted'] = self.submitted
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('StrategyJson') is not None:
            self.strategy_json = m.get('StrategyJson')
        if m.get('JobFilePath') is not None:
            self.job_file_path = m.get('JobFilePath')
        if m.get('Submitted') is not None:
            self.submitted = m.get('Submitted')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        return self


class CreateBatchJobsResponseBodyJobGroupStrategyWorkingTime(TeaModel):
    def __init__(self, end_time=None, begin_time=None):
        self.end_time = TeaConverter.to_unicode(end_time)  # type: unicode
        self.begin_time = TeaConverter.to_unicode(begin_time)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.begin_time is not None:
            result['BeginTime'] = self.begin_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('BeginTime') is not None:
            self.begin_time = m.get('BeginTime')
        return self


class CreateBatchJobsResponseBodyJobGroupStrategy(TeaModel):
    def __init__(self, type=None, strategy_name=None, max_attempts_per_day=None, working_time=None,
                 follow_up_strategy=None, end_time=None, customized=None, start_time=None, is_template=None, strategy_id=None,
                 repeat_days=None, routing_strategy=None, strategy_description=None, min_attempt_interval=None, repeat_by=None):
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.strategy_name = TeaConverter.to_unicode(strategy_name)  # type: unicode
        self.max_attempts_per_day = max_attempts_per_day  # type: int
        self.working_time = working_time  # type: list[CreateBatchJobsResponseBodyJobGroupStrategyWorkingTime]
        self.follow_up_strategy = TeaConverter.to_unicode(follow_up_strategy)  # type: unicode
        self.end_time = end_time  # type: long
        self.customized = TeaConverter.to_unicode(customized)  # type: unicode
        self.start_time = start_time  # type: long
        self.is_template = is_template  # type: bool
        self.strategy_id = TeaConverter.to_unicode(strategy_id)  # type: unicode
        self.repeat_days = repeat_days  # type: list[unicode]
        self.routing_strategy = TeaConverter.to_unicode(routing_strategy)  # type: unicode
        self.strategy_description = TeaConverter.to_unicode(strategy_description)  # type: unicode
        self.min_attempt_interval = min_attempt_interval  # type: int
        self.repeat_by = TeaConverter.to_unicode(repeat_by)  # type: unicode

    def validate(self):
        if self.working_time:
            for k in self.working_time:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.strategy_name is not None:
            result['StrategyName'] = self.strategy_name
        if self.max_attempts_per_day is not None:
            result['MaxAttemptsPerDay'] = self.max_attempts_per_day
        result['WorkingTime'] = []
        if self.working_time is not None:
            for k in self.working_time:
                result['WorkingTime'].append(k.to_map() if k else None)
        if self.follow_up_strategy is not None:
            result['FollowUpStrategy'] = self.follow_up_strategy
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.customized is not None:
            result['Customized'] = self.customized
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.is_template is not None:
            result['IsTemplate'] = self.is_template
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.repeat_days is not None:
            result['RepeatDays'] = self.repeat_days
        if self.routing_strategy is not None:
            result['RoutingStrategy'] = self.routing_strategy
        if self.strategy_description is not None:
            result['StrategyDescription'] = self.strategy_description
        if self.min_attempt_interval is not None:
            result['MinAttemptInterval'] = self.min_attempt_interval
        if self.repeat_by is not None:
            result['RepeatBy'] = self.repeat_by
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('StrategyName') is not None:
            self.strategy_name = m.get('StrategyName')
        if m.get('MaxAttemptsPerDay') is not None:
            self.max_attempts_per_day = m.get('MaxAttemptsPerDay')
        self.working_time = []
        if m.get('WorkingTime') is not None:
            for k in m.get('WorkingTime'):
                temp_model = CreateBatchJobsResponseBodyJobGroupStrategyWorkingTime()
                self.working_time.append(temp_model.from_map(k))
        if m.get('FollowUpStrategy') is not None:
            self.follow_up_strategy = m.get('FollowUpStrategy')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Customized') is not None:
            self.customized = m.get('Customized')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('IsTemplate') is not None:
            self.is_template = m.get('IsTemplate')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('RepeatDays') is not None:
            self.repeat_days = m.get('RepeatDays')
        if m.get('RoutingStrategy') is not None:
            self.routing_strategy = m.get('RoutingStrategy')
        if m.get('StrategyDescription') is not None:
            self.strategy_description = m.get('StrategyDescription')
        if m.get('MinAttemptInterval') is not None:
            self.min_attempt_interval = m.get('MinAttemptInterval')
        if m.get('RepeatBy') is not None:
            self.repeat_by = m.get('RepeatBy')
        return self


class CreateBatchJobsResponseBodyJobGroup(TeaModel):
    def __init__(self, job_group_id=None, scenario_id=None, creation_time=None, strategy=None, calling_numbers=None,
                 job_group_name=None, job_file_path=None, job_group_description=None):
        self.job_group_id = TeaConverter.to_unicode(job_group_id)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.creation_time = creation_time  # type: long
        self.strategy = strategy  # type: CreateBatchJobsResponseBodyJobGroupStrategy
        self.calling_numbers = calling_numbers  # type: list[unicode]
        self.job_group_name = TeaConverter.to_unicode(job_group_name)  # type: unicode
        self.job_file_path = TeaConverter.to_unicode(job_file_path)  # type: unicode
        self.job_group_description = TeaConverter.to_unicode(job_group_description)  # type: unicode

    def validate(self):
        if self.strategy:
            self.strategy.validate()

    def to_map(self):
        result = dict()
        if self.job_group_id is not None:
            result['JobGroupId'] = self.job_group_id
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.strategy is not None:
            result['Strategy'] = self.strategy.to_map()
        if self.calling_numbers is not None:
            result['CallingNumbers'] = self.calling_numbers
        if self.job_group_name is not None:
            result['JobGroupName'] = self.job_group_name
        if self.job_file_path is not None:
            result['JobFilePath'] = self.job_file_path
        if self.job_group_description is not None:
            result['JobGroupDescription'] = self.job_group_description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobGroupId') is not None:
            self.job_group_id = m.get('JobGroupId')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Strategy') is not None:
            temp_model = CreateBatchJobsResponseBodyJobGroupStrategy()
            self.strategy = temp_model.from_map(m['Strategy'])
        if m.get('CallingNumbers') is not None:
            self.calling_numbers = m.get('CallingNumbers')
        if m.get('JobGroupName') is not None:
            self.job_group_name = m.get('JobGroupName')
        if m.get('JobFilePath') is not None:
            self.job_file_path = m.get('JobFilePath')
        if m.get('JobGroupDescription') is not None:
            self.job_group_description = m.get('JobGroupDescription')
        return self


class CreateBatchJobsResponseBody(TeaModel):
    def __init__(self, job_group=None, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.job_group = job_group  # type: CreateBatchJobsResponseBodyJobGroup
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.job_group:
            self.job_group.validate()

    def to_map(self):
        result = dict()
        if self.job_group is not None:
            result['JobGroup'] = self.job_group.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobGroup') is not None:
            temp_model = CreateBatchJobsResponseBodyJobGroup()
            self.job_group = temp_model.from_map(m['JobGroup'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateBatchJobsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateBatchJobsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateBatchJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCabInstanceRequest(TeaModel):
    def __init__(self, instance_name=None, instance_description=None, max_concurrent_conversation=None,
                 call_center_instance_id=None):
        self.instance_name = TeaConverter.to_unicode(instance_name)  # type: unicode
        self.instance_description = TeaConverter.to_unicode(instance_description)  # type: unicode
        self.max_concurrent_conversation = max_concurrent_conversation  # type: int
        self.call_center_instance_id = TeaConverter.to_unicode(call_center_instance_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.instance_description is not None:
            result['InstanceDescription'] = self.instance_description
        if self.max_concurrent_conversation is not None:
            result['MaxConcurrentConversation'] = self.max_concurrent_conversation
        if self.call_center_instance_id is not None:
            result['CallCenterInstanceId'] = self.call_center_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InstanceDescription') is not None:
            self.instance_description = m.get('InstanceDescription')
        if m.get('MaxConcurrentConversation') is not None:
            self.max_concurrent_conversation = m.get('MaxConcurrentConversation')
        if m.get('CallCenterInstanceId') is not None:
            self.call_center_instance_id = m.get('CallCenterInstanceId')
        return self


class CreateCabInstanceResponseBodyInstance(TeaModel):
    def __init__(self, creation_time=None, call_center_instance_id=None, owner=None, instance_name=None,
                 max_concurrent_conversation=None, instance_id=None, instance_description=None):
        self.creation_time = creation_time  # type: long
        self.call_center_instance_id = TeaConverter.to_unicode(call_center_instance_id)  # type: unicode
        self.owner = TeaConverter.to_unicode(owner)  # type: unicode
        self.instance_name = TeaConverter.to_unicode(instance_name)  # type: unicode
        self.max_concurrent_conversation = max_concurrent_conversation  # type: int
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.instance_description = TeaConverter.to_unicode(instance_description)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.call_center_instance_id is not None:
            result['CallCenterInstanceId'] = self.call_center_instance_id
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.max_concurrent_conversation is not None:
            result['MaxConcurrentConversation'] = self.max_concurrent_conversation
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_description is not None:
            result['InstanceDescription'] = self.instance_description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('CallCenterInstanceId') is not None:
            self.call_center_instance_id = m.get('CallCenterInstanceId')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('MaxConcurrentConversation') is not None:
            self.max_concurrent_conversation = m.get('MaxConcurrentConversation')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceDescription') is not None:
            self.instance_description = m.get('InstanceDescription')
        return self


class CreateCabInstanceResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, instance=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.instance = instance  # type: CreateCabInstanceResponseBodyInstance
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.instance:
            self.instance.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance is not None:
            result['Instance'] = self.instance.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Instance') is not None:
            temp_model = CreateCabInstanceResponseBodyInstance()
            self.instance = temp_model.from_map(m['Instance'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateCabInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateCabInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateCabInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateContactFlowRequest(TeaModel):
    def __init__(self, instance_id=None, name=None, description=None, type=None, canvas=None, content=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.canvas = TeaConverter.to_unicode(canvas)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        if self.canvas is not None:
            result['Canvas'] = self.canvas
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Canvas') is not None:
            self.canvas = m.get('Canvas')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class CreateContactFlowResponseBodyContactFlowPhoneNumbersPhoneNumber(TeaModel):
    def __init__(self, test_only=None, trunks=None, remaining_time=None, number=None, instance_id=None, usage=None,
                 allow_outbound=None, phone_number_description=None, phone_number_id=None):
        self.test_only = test_only  # type: bool
        self.trunks = trunks  # type: int
        self.remaining_time = remaining_time  # type: int
        self.number = TeaConverter.to_unicode(number)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.usage = TeaConverter.to_unicode(usage)  # type: unicode
        self.allow_outbound = allow_outbound  # type: bool
        self.phone_number_description = TeaConverter.to_unicode(phone_number_description)  # type: unicode
        self.phone_number_id = TeaConverter.to_unicode(phone_number_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.test_only is not None:
            result['TestOnly'] = self.test_only
        if self.trunks is not None:
            result['Trunks'] = self.trunks
        if self.remaining_time is not None:
            result['RemainingTime'] = self.remaining_time
        if self.number is not None:
            result['Number'] = self.number
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.allow_outbound is not None:
            result['AllowOutbound'] = self.allow_outbound
        if self.phone_number_description is not None:
            result['PhoneNumberDescription'] = self.phone_number_description
        if self.phone_number_id is not None:
            result['PhoneNumberId'] = self.phone_number_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TestOnly') is not None:
            self.test_only = m.get('TestOnly')
        if m.get('Trunks') is not None:
            self.trunks = m.get('Trunks')
        if m.get('RemainingTime') is not None:
            self.remaining_time = m.get('RemainingTime')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('AllowOutbound') is not None:
            self.allow_outbound = m.get('AllowOutbound')
        if m.get('PhoneNumberDescription') is not None:
            self.phone_number_description = m.get('PhoneNumberDescription')
        if m.get('PhoneNumberId') is not None:
            self.phone_number_id = m.get('PhoneNumberId')
        return self


class CreateContactFlowResponseBodyContactFlowPhoneNumbers(TeaModel):
    def __init__(self, phone_number=None):
        self.phone_number = phone_number  # type: list[CreateContactFlowResponseBodyContactFlowPhoneNumbersPhoneNumber]

    def validate(self):
        if self.phone_number:
            for k in self.phone_number:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PhoneNumber'] = []
        if self.phone_number is not None:
            for k in self.phone_number:
                result['PhoneNumber'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.phone_number = []
        if m.get('PhoneNumber') is not None:
            for k in m.get('PhoneNumber'):
                temp_model = CreateContactFlowResponseBodyContactFlowPhoneNumbersPhoneNumber()
                self.phone_number.append(temp_model.from_map(k))
        return self


class CreateContactFlowResponseBodyContactFlowVersionsContactFlowVersion(TeaModel):
    def __init__(self, status=None, last_modified=None, canvas=None, locked_by=None, version=None,
                 contact_flow_version_id=None, last_modified_by=None, contact_flow_version_description=None, content=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.last_modified = TeaConverter.to_unicode(last_modified)  # type: unicode
        self.canvas = TeaConverter.to_unicode(canvas)  # type: unicode
        self.locked_by = TeaConverter.to_unicode(locked_by)  # type: unicode
        self.version = TeaConverter.to_unicode(version)  # type: unicode
        self.contact_flow_version_id = TeaConverter.to_unicode(contact_flow_version_id)  # type: unicode
        self.last_modified_by = TeaConverter.to_unicode(last_modified_by)  # type: unicode
        self.contact_flow_version_description = TeaConverter.to_unicode(contact_flow_version_description)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.last_modified is not None:
            result['LastModified'] = self.last_modified
        if self.canvas is not None:
            result['Canvas'] = self.canvas
        if self.locked_by is not None:
            result['LockedBy'] = self.locked_by
        if self.version is not None:
            result['Version'] = self.version
        if self.contact_flow_version_id is not None:
            result['ContactFlowVersionId'] = self.contact_flow_version_id
        if self.last_modified_by is not None:
            result['LastModifiedBy'] = self.last_modified_by
        if self.contact_flow_version_description is not None:
            result['ContactFlowVersionDescription'] = self.contact_flow_version_description
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('LastModified') is not None:
            self.last_modified = m.get('LastModified')
        if m.get('Canvas') is not None:
            self.canvas = m.get('Canvas')
        if m.get('LockedBy') is not None:
            self.locked_by = m.get('LockedBy')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('ContactFlowVersionId') is not None:
            self.contact_flow_version_id = m.get('ContactFlowVersionId')
        if m.get('LastModifiedBy') is not None:
            self.last_modified_by = m.get('LastModifiedBy')
        if m.get('ContactFlowVersionDescription') is not None:
            self.contact_flow_version_description = m.get('ContactFlowVersionDescription')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class CreateContactFlowResponseBodyContactFlowVersions(TeaModel):
    def __init__(self, contact_flow_version=None):
        self.contact_flow_version = contact_flow_version  # type: list[CreateContactFlowResponseBodyContactFlowVersionsContactFlowVersion]

    def validate(self):
        if self.contact_flow_version:
            for k in self.contact_flow_version:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ContactFlowVersion'] = []
        if self.contact_flow_version is not None:
            for k in self.contact_flow_version:
                result['ContactFlowVersion'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.contact_flow_version = []
        if m.get('ContactFlowVersion') is not None:
            for k in m.get('ContactFlowVersion'):
                temp_model = CreateContactFlowResponseBodyContactFlowVersionsContactFlowVersion()
                self.contact_flow_version.append(temp_model.from_map(k))
        return self


class CreateContactFlowResponseBodyContactFlow(TeaModel):
    def __init__(self, contact_flow_description=None, type=None, phone_numbers=None, contact_flow_name=None,
                 versions=None, instance_id=None, contact_flow_id=None, applied_version=None):
        self.contact_flow_description = TeaConverter.to_unicode(contact_flow_description)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.phone_numbers = phone_numbers  # type: CreateContactFlowResponseBodyContactFlowPhoneNumbers
        self.contact_flow_name = TeaConverter.to_unicode(contact_flow_name)  # type: unicode
        self.versions = versions  # type: CreateContactFlowResponseBodyContactFlowVersions
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.contact_flow_id = TeaConverter.to_unicode(contact_flow_id)  # type: unicode
        self.applied_version = TeaConverter.to_unicode(applied_version)  # type: unicode

    def validate(self):
        if self.phone_numbers:
            self.phone_numbers.validate()
        if self.versions:
            self.versions.validate()

    def to_map(self):
        result = dict()
        if self.contact_flow_description is not None:
            result['ContactFlowDescription'] = self.contact_flow_description
        if self.type is not None:
            result['Type'] = self.type
        if self.phone_numbers is not None:
            result['PhoneNumbers'] = self.phone_numbers.to_map()
        if self.contact_flow_name is not None:
            result['ContactFlowName'] = self.contact_flow_name
        if self.versions is not None:
            result['Versions'] = self.versions.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.applied_version is not None:
            result['AppliedVersion'] = self.applied_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactFlowDescription') is not None:
            self.contact_flow_description = m.get('ContactFlowDescription')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('PhoneNumbers') is not None:
            temp_model = CreateContactFlowResponseBodyContactFlowPhoneNumbers()
            self.phone_numbers = temp_model.from_map(m['PhoneNumbers'])
        if m.get('ContactFlowName') is not None:
            self.contact_flow_name = m.get('ContactFlowName')
        if m.get('Versions') is not None:
            temp_model = CreateContactFlowResponseBodyContactFlowVersions()
            self.versions = temp_model.from_map(m['Versions'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('AppliedVersion') is not None:
            self.applied_version = m.get('AppliedVersion')
        return self


class CreateContactFlowResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, contact_flow=None,
                 success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.contact_flow = contact_flow  # type: CreateContactFlowResponseBodyContactFlow
        self.success = success  # type: bool

    def validate(self):
        if self.contact_flow:
            self.contact_flow.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.contact_flow is not None:
            result['ContactFlow'] = self.contact_flow.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ContactFlow') is not None:
            temp_model = CreateContactFlowResponseBodyContactFlow()
            self.contact_flow = temp_model.from_map(m['ContactFlow'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateContactFlowResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateContactFlowResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateContactFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFaultRequest(TeaModel):
    def __init__(self, instance_id=None, agent_id=None, connect_id=None, agent_oss_file_name=None,
                 agent_file_path=None, custom_oss_file_name=None, custom_file_path=None, description=None, client_ip=None,
                 client_port=None, operating_system_version=None, browser_version=None, microphone_list=None,
                 microphone_equipment=None, speaker_list=None, speaker_equipment=None, start_time=None, end_time=None, service_ip=None,
                 service_port=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.agent_id = agent_id  # type: long
        self.connect_id = TeaConverter.to_unicode(connect_id)  # type: unicode
        self.agent_oss_file_name = TeaConverter.to_unicode(agent_oss_file_name)  # type: unicode
        self.agent_file_path = TeaConverter.to_unicode(agent_file_path)  # type: unicode
        self.custom_oss_file_name = TeaConverter.to_unicode(custom_oss_file_name)  # type: unicode
        self.custom_file_path = TeaConverter.to_unicode(custom_file_path)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.client_ip = TeaConverter.to_unicode(client_ip)  # type: unicode
        self.client_port = TeaConverter.to_unicode(client_port)  # type: unicode
        self.operating_system_version = TeaConverter.to_unicode(operating_system_version)  # type: unicode
        self.browser_version = TeaConverter.to_unicode(browser_version)  # type: unicode
        self.microphone_list = TeaConverter.to_unicode(microphone_list)  # type: unicode
        self.microphone_equipment = TeaConverter.to_unicode(microphone_equipment)  # type: unicode
        self.speaker_list = TeaConverter.to_unicode(speaker_list)  # type: unicode
        self.speaker_equipment = TeaConverter.to_unicode(speaker_equipment)  # type: unicode
        self.start_time = start_time  # type: long
        self.end_time = end_time  # type: long
        self.service_ip = TeaConverter.to_unicode(service_ip)  # type: unicode
        self.service_port = TeaConverter.to_unicode(service_port)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.connect_id is not None:
            result['ConnectId'] = self.connect_id
        if self.agent_oss_file_name is not None:
            result['AgentOssFileName'] = self.agent_oss_file_name
        if self.agent_file_path is not None:
            result['AgentFilePath'] = self.agent_file_path
        if self.custom_oss_file_name is not None:
            result['CustomOssFileName'] = self.custom_oss_file_name
        if self.custom_file_path is not None:
            result['CustomFilePath'] = self.custom_file_path
        if self.description is not None:
            result['Description'] = self.description
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.client_port is not None:
            result['ClientPort'] = self.client_port
        if self.operating_system_version is not None:
            result['OperatingSystemVersion'] = self.operating_system_version
        if self.browser_version is not None:
            result['BrowserVersion'] = self.browser_version
        if self.microphone_list is not None:
            result['MicrophoneList'] = self.microphone_list
        if self.microphone_equipment is not None:
            result['MicrophoneEquipment'] = self.microphone_equipment
        if self.speaker_list is not None:
            result['SpeakerList'] = self.speaker_list
        if self.speaker_equipment is not None:
            result['SpeakerEquipment'] = self.speaker_equipment
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.service_ip is not None:
            result['ServiceIp'] = self.service_ip
        if self.service_port is not None:
            result['ServicePort'] = self.service_port
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('ConnectId') is not None:
            self.connect_id = m.get('ConnectId')
        if m.get('AgentOssFileName') is not None:
            self.agent_oss_file_name = m.get('AgentOssFileName')
        if m.get('AgentFilePath') is not None:
            self.agent_file_path = m.get('AgentFilePath')
        if m.get('CustomOssFileName') is not None:
            self.custom_oss_file_name = m.get('CustomOssFileName')
        if m.get('CustomFilePath') is not None:
            self.custom_file_path = m.get('CustomFilePath')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('ClientPort') is not None:
            self.client_port = m.get('ClientPort')
        if m.get('OperatingSystemVersion') is not None:
            self.operating_system_version = m.get('OperatingSystemVersion')
        if m.get('BrowserVersion') is not None:
            self.browser_version = m.get('BrowserVersion')
        if m.get('MicrophoneList') is not None:
            self.microphone_list = m.get('MicrophoneList')
        if m.get('MicrophoneEquipment') is not None:
            self.microphone_equipment = m.get('MicrophoneEquipment')
        if m.get('SpeakerList') is not None:
            self.speaker_list = m.get('SpeakerList')
        if m.get('SpeakerEquipment') is not None:
            self.speaker_equipment = m.get('SpeakerEquipment')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ServiceIp') is not None:
            self.service_ip = m.get('ServiceIp')
        if m.get('ServicePort') is not None:
            self.service_port = m.get('ServicePort')
        return self


class CreateFaultResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateFaultResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateFaultResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFaultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInstanceRequest(TeaModel):
    def __init__(self, name=None, description=None, domain_name=None, storage_max_days=None, storage_max_size=None,
                 directory_id=None, phone_number=None, admin_ram_id=None, phone_numbers=None, user_object=None):
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.domain_name = TeaConverter.to_unicode(domain_name)  # type: unicode
        self.storage_max_days = storage_max_days  # type: int
        self.storage_max_size = storage_max_size  # type: int
        self.directory_id = TeaConverter.to_unicode(directory_id)  # type: unicode
        self.phone_number = TeaConverter.to_unicode(phone_number)  # type: unicode
        self.admin_ram_id = admin_ram_id  # type: list[unicode]
        self.phone_numbers = phone_numbers  # type: list[unicode]
        self.user_object = user_object  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.storage_max_days is not None:
            result['StorageMaxDays'] = self.storage_max_days
        if self.storage_max_size is not None:
            result['StorageMaxSize'] = self.storage_max_size
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.admin_ram_id is not None:
            result['AdminRamId'] = self.admin_ram_id
        if self.phone_numbers is not None:
            result['PhoneNumbers'] = self.phone_numbers
        if self.user_object is not None:
            result['UserObject'] = self.user_object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StorageMaxDays') is not None:
            self.storage_max_days = m.get('StorageMaxDays')
        if m.get('StorageMaxSize') is not None:
            self.storage_max_size = m.get('StorageMaxSize')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('AdminRamId') is not None:
            self.admin_ram_id = m.get('AdminRamId')
        if m.get('PhoneNumbers') is not None:
            self.phone_numbers = m.get('PhoneNumbers')
        if m.get('UserObject') is not None:
            self.user_object = m.get('UserObject')
        return self


class CreateInstanceResponseBodyInstanceSuccessLoginNames(TeaModel):
    def __init__(self, success_login_name=None):
        self.success_login_name = success_login_name  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.success_login_name is not None:
            result['SuccessLoginName'] = self.success_login_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SuccessLoginName') is not None:
            self.success_login_name = m.get('SuccessLoginName')
        return self


class CreateInstanceResponseBodyInstancePhoneNumbersPhoneNumber(TeaModel):
    def __init__(self, test_only=None, trunks=None, remaining_time=None, number=None, instance_id=None, usage=None,
                 allow_outbound=None, phone_number_description=None, phone_number_id=None):
        self.test_only = test_only  # type: bool
        self.trunks = trunks  # type: int
        self.remaining_time = remaining_time  # type: int
        self.number = TeaConverter.to_unicode(number)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.usage = TeaConverter.to_unicode(usage)  # type: unicode
        self.allow_outbound = allow_outbound  # type: bool
        self.phone_number_description = TeaConverter.to_unicode(phone_number_description)  # type: unicode
        self.phone_number_id = TeaConverter.to_unicode(phone_number_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.test_only is not None:
            result['TestOnly'] = self.test_only
        if self.trunks is not None:
            result['Trunks'] = self.trunks
        if self.remaining_time is not None:
            result['RemainingTime'] = self.remaining_time
        if self.number is not None:
            result['Number'] = self.number
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.allow_outbound is not None:
            result['AllowOutbound'] = self.allow_outbound
        if self.phone_number_description is not None:
            result['PhoneNumberDescription'] = self.phone_number_description
        if self.phone_number_id is not None:
            result['PhoneNumberId'] = self.phone_number_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TestOnly') is not None:
            self.test_only = m.get('TestOnly')
        if m.get('Trunks') is not None:
            self.trunks = m.get('Trunks')
        if m.get('RemainingTime') is not None:
            self.remaining_time = m.get('RemainingTime')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('AllowOutbound') is not None:
            self.allow_outbound = m.get('AllowOutbound')
        if m.get('PhoneNumberDescription') is not None:
            self.phone_number_description = m.get('PhoneNumberDescription')
        if m.get('PhoneNumberId') is not None:
            self.phone_number_id = m.get('PhoneNumberId')
        return self


class CreateInstanceResponseBodyInstancePhoneNumbers(TeaModel):
    def __init__(self, phone_number=None):
        self.phone_number = phone_number  # type: list[CreateInstanceResponseBodyInstancePhoneNumbersPhoneNumber]

    def validate(self):
        if self.phone_number:
            for k in self.phone_number:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PhoneNumber'] = []
        if self.phone_number is not None:
            for k in self.phone_number:
                result['PhoneNumber'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.phone_number = []
        if m.get('PhoneNumber') is not None:
            for k in m.get('PhoneNumber'):
                temp_model = CreateInstanceResponseBodyInstancePhoneNumbersPhoneNumber()
                self.phone_number.append(temp_model.from_map(k))
        return self


class CreateInstanceResponseBodyInstanceSuccessPhoneNumbers(TeaModel):
    def __init__(self, success_phone_number=None):
        self.success_phone_number = success_phone_number  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.success_phone_number is not None:
            result['SuccessPhoneNumber'] = self.success_phone_number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SuccessPhoneNumber') is not None:
            self.success_phone_number = m.get('SuccessPhoneNumber')
        return self


class CreateInstanceResponseBodyInstanceFailLoginNames(TeaModel):
    def __init__(self, fail_login_name=None):
        self.fail_login_name = fail_login_name  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.fail_login_name is not None:
            result['FailLoginName'] = self.fail_login_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FailLoginName') is not None:
            self.fail_login_name = m.get('FailLoginName')
        return self


class CreateInstanceResponseBodyInstanceFailPhoneNumbers(TeaModel):
    def __init__(self, fail_phone_number=None):
        self.fail_phone_number = fail_phone_number  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.fail_phone_number is not None:
            result['FailPhoneNumber'] = self.fail_phone_number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FailPhoneNumber') is not None:
            self.fail_phone_number = m.get('FailPhoneNumber')
        return self


class CreateInstanceResponseBodyInstanceAdminUserDetail(TeaModel):
    def __init__(self, display_name=None, email=None, login_name=None, department=None, phone=None):
        self.display_name = TeaConverter.to_unicode(display_name)  # type: unicode
        self.email = TeaConverter.to_unicode(email)  # type: unicode
        self.login_name = TeaConverter.to_unicode(login_name)  # type: unicode
        self.department = TeaConverter.to_unicode(department)  # type: unicode
        self.phone = TeaConverter.to_unicode(phone)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.department is not None:
            result['Department'] = self.department
        if self.phone is not None:
            result['Phone'] = self.phone
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('Phone') is not None:
            self.phone = m.get('Phone')
        return self


class CreateInstanceResponseBodyInstanceAdminUser(TeaModel):
    def __init__(self, user_id=None, instance_id=None, ram_id=None, detail=None):
        self.user_id = TeaConverter.to_unicode(user_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.ram_id = TeaConverter.to_unicode(ram_id)  # type: unicode
        self.detail = detail  # type: CreateInstanceResponseBodyInstanceAdminUserDetail

    def validate(self):
        if self.detail:
            self.detail.validate()

    def to_map(self):
        result = dict()
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ram_id is not None:
            result['RamId'] = self.ram_id
        if self.detail is not None:
            result['Detail'] = self.detail.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RamId') is not None:
            self.ram_id = m.get('RamId')
        if m.get('Detail') is not None:
            temp_model = CreateInstanceResponseBodyInstanceAdminUserDetail()
            self.detail = temp_model.from_map(m['Detail'])
        return self


class CreateInstanceResponseBodyInstanceAdmin(TeaModel):
    def __init__(self, user=None):
        self.user = user  # type: list[CreateInstanceResponseBodyInstanceAdminUser]

    def validate(self):
        if self.user:
            for k in self.user:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['User'] = []
        if self.user is not None:
            for k in self.user:
                result['User'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.user = []
        if m.get('User') is not None:
            for k in m.get('User'):
                temp_model = CreateInstanceResponseBodyInstanceAdminUser()
                self.user.append(temp_model.from_map(k))
        return self


class CreateInstanceResponseBodyInstance(TeaModel):
    def __init__(self, status=None, owner=None, storage_max_size=None, storage_max_days=None,
                 max_online_agents=None, success_login_names=None, instance_id=None, domain_name=None, instance_description=None,
                 phone_numbers=None, console_url=None, success_phone_numbers=None, fail_login_names=None, instance_name=None,
                 storage_bucket=None, fail_phone_numbers=None, created_time=None, directory_id=None, admin=None, tenant_id=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.owner = TeaConverter.to_unicode(owner)  # type: unicode
        self.storage_max_size = storage_max_size  # type: int
        self.storage_max_days = storage_max_days  # type: int
        self.max_online_agents = max_online_agents  # type: int
        self.success_login_names = success_login_names  # type: CreateInstanceResponseBodyInstanceSuccessLoginNames
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.domain_name = TeaConverter.to_unicode(domain_name)  # type: unicode
        self.instance_description = TeaConverter.to_unicode(instance_description)  # type: unicode
        self.phone_numbers = phone_numbers  # type: CreateInstanceResponseBodyInstancePhoneNumbers
        self.console_url = TeaConverter.to_unicode(console_url)  # type: unicode
        self.success_phone_numbers = success_phone_numbers  # type: CreateInstanceResponseBodyInstanceSuccessPhoneNumbers
        self.fail_login_names = fail_login_names  # type: CreateInstanceResponseBodyInstanceFailLoginNames
        self.instance_name = TeaConverter.to_unicode(instance_name)  # type: unicode
        self.storage_bucket = TeaConverter.to_unicode(storage_bucket)  # type: unicode
        self.fail_phone_numbers = fail_phone_numbers  # type: CreateInstanceResponseBodyInstanceFailPhoneNumbers
        self.created_time = created_time  # type: long
        self.directory_id = TeaConverter.to_unicode(directory_id)  # type: unicode
        self.admin = admin  # type: CreateInstanceResponseBodyInstanceAdmin
        self.tenant_id = TeaConverter.to_unicode(tenant_id)  # type: unicode

    def validate(self):
        if self.success_login_names:
            self.success_login_names.validate()
        if self.phone_numbers:
            self.phone_numbers.validate()
        if self.success_phone_numbers:
            self.success_phone_numbers.validate()
        if self.fail_login_names:
            self.fail_login_names.validate()
        if self.fail_phone_numbers:
            self.fail_phone_numbers.validate()
        if self.admin:
            self.admin.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.storage_max_size is not None:
            result['StorageMaxSize'] = self.storage_max_size
        if self.storage_max_days is not None:
            result['StorageMaxDays'] = self.storage_max_days
        if self.max_online_agents is not None:
            result['MaxOnlineAgents'] = self.max_online_agents
        if self.success_login_names is not None:
            result['SuccessLoginNames'] = self.success_login_names.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.instance_description is not None:
            result['InstanceDescription'] = self.instance_description
        if self.phone_numbers is not None:
            result['PhoneNumbers'] = self.phone_numbers.to_map()
        if self.console_url is not None:
            result['ConsoleUrl'] = self.console_url
        if self.success_phone_numbers is not None:
            result['SuccessPhoneNumbers'] = self.success_phone_numbers.to_map()
        if self.fail_login_names is not None:
            result['FailLoginNames'] = self.fail_login_names.to_map()
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.storage_bucket is not None:
            result['StorageBucket'] = self.storage_bucket
        if self.fail_phone_numbers is not None:
            result['FailPhoneNumbers'] = self.fail_phone_numbers.to_map()
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.admin is not None:
            result['Admin'] = self.admin.to_map()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('StorageMaxSize') is not None:
            self.storage_max_size = m.get('StorageMaxSize')
        if m.get('StorageMaxDays') is not None:
            self.storage_max_days = m.get('StorageMaxDays')
        if m.get('MaxOnlineAgents') is not None:
            self.max_online_agents = m.get('MaxOnlineAgents')
        if m.get('SuccessLoginNames') is not None:
            temp_model = CreateInstanceResponseBodyInstanceSuccessLoginNames()
            self.success_login_names = temp_model.from_map(m['SuccessLoginNames'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('InstanceDescription') is not None:
            self.instance_description = m.get('InstanceDescription')
        if m.get('PhoneNumbers') is not None:
            temp_model = CreateInstanceResponseBodyInstancePhoneNumbers()
            self.phone_numbers = temp_model.from_map(m['PhoneNumbers'])
        if m.get('ConsoleUrl') is not None:
            self.console_url = m.get('ConsoleUrl')
        if m.get('SuccessPhoneNumbers') is not None:
            temp_model = CreateInstanceResponseBodyInstanceSuccessPhoneNumbers()
            self.success_phone_numbers = temp_model.from_map(m['SuccessPhoneNumbers'])
        if m.get('FailLoginNames') is not None:
            temp_model = CreateInstanceResponseBodyInstanceFailLoginNames()
            self.fail_login_names = temp_model.from_map(m['FailLoginNames'])
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('StorageBucket') is not None:
            self.storage_bucket = m.get('StorageBucket')
        if m.get('FailPhoneNumbers') is not None:
            temp_model = CreateInstanceResponseBodyInstanceFailPhoneNumbers()
            self.fail_phone_numbers = temp_model.from_map(m['FailPhoneNumbers'])
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('Admin') is not None:
            temp_model = CreateInstanceResponseBodyInstanceAdmin()
            self.admin = temp_model.from_map(m['Admin'])
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class CreateInstanceResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, instance=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.instance = instance  # type: CreateInstanceResponseBodyInstance
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.instance:
            self.instance.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance is not None:
            result['Instance'] = self.instance.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Instance') is not None:
            temp_model = CreateInstanceResponseBodyInstance()
            self.instance = temp_model.from_map(m['Instance'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateJobGroupRequest(TeaModel):
    def __init__(self, instance_id=None, name=None, description=None, scenario_id=None, strategy_json=None,
                 calling_number=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.strategy_json = TeaConverter.to_unicode(strategy_json)  # type: unicode
        self.calling_number = calling_number  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.strategy_json is not None:
            result['StrategyJson'] = self.strategy_json
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('StrategyJson') is not None:
            self.strategy_json = m.get('StrategyJson')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        return self


class CreateJobGroupResponseBodyJobGroupStrategyWorkingTime(TeaModel):
    def __init__(self, from_=None, to=None):
        self.from_ = TeaConverter.to_unicode(from_)  # type: unicode
        self.to = TeaConverter.to_unicode(to)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.from_ is not None:
            result['From'] = self.from_
        if self.to is not None:
            result['To'] = self.to
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('To') is not None:
            self.to = m.get('To')
        return self


class CreateJobGroupResponseBodyJobGroupStrategy(TeaModel):
    def __init__(self, type=None, strategy_name=None, max_attempts_per_day=None, working_time=None,
                 follow_up_strategy=None, end_time=None, customized=None, start_time=None, is_template=None, strategy_id=None,
                 repeat_days=None, routing_strategy=None, strategy_description=None, min_attempt_interval=None, repeat_by=None):
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.strategy_name = TeaConverter.to_unicode(strategy_name)  # type: unicode
        self.max_attempts_per_day = max_attempts_per_day  # type: int
        self.working_time = working_time  # type: list[CreateJobGroupResponseBodyJobGroupStrategyWorkingTime]
        self.follow_up_strategy = TeaConverter.to_unicode(follow_up_strategy)  # type: unicode
        self.end_time = end_time  # type: long
        self.customized = TeaConverter.to_unicode(customized)  # type: unicode
        self.start_time = start_time  # type: long
        self.is_template = is_template  # type: bool
        self.strategy_id = TeaConverter.to_unicode(strategy_id)  # type: unicode
        self.repeat_days = repeat_days  # type: list[unicode]
        self.routing_strategy = TeaConverter.to_unicode(routing_strategy)  # type: unicode
        self.strategy_description = TeaConverter.to_unicode(strategy_description)  # type: unicode
        self.min_attempt_interval = min_attempt_interval  # type: int
        self.repeat_by = TeaConverter.to_unicode(repeat_by)  # type: unicode

    def validate(self):
        if self.working_time:
            for k in self.working_time:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.strategy_name is not None:
            result['StrategyName'] = self.strategy_name
        if self.max_attempts_per_day is not None:
            result['MaxAttemptsPerDay'] = self.max_attempts_per_day
        result['WorkingTime'] = []
        if self.working_time is not None:
            for k in self.working_time:
                result['WorkingTime'].append(k.to_map() if k else None)
        if self.follow_up_strategy is not None:
            result['FollowUpStrategy'] = self.follow_up_strategy
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.customized is not None:
            result['Customized'] = self.customized
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.is_template is not None:
            result['IsTemplate'] = self.is_template
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.repeat_days is not None:
            result['RepeatDays'] = self.repeat_days
        if self.routing_strategy is not None:
            result['RoutingStrategy'] = self.routing_strategy
        if self.strategy_description is not None:
            result['StrategyDescription'] = self.strategy_description
        if self.min_attempt_interval is not None:
            result['MinAttemptInterval'] = self.min_attempt_interval
        if self.repeat_by is not None:
            result['RepeatBy'] = self.repeat_by
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('StrategyName') is not None:
            self.strategy_name = m.get('StrategyName')
        if m.get('MaxAttemptsPerDay') is not None:
            self.max_attempts_per_day = m.get('MaxAttemptsPerDay')
        self.working_time = []
        if m.get('WorkingTime') is not None:
            for k in m.get('WorkingTime'):
                temp_model = CreateJobGroupResponseBodyJobGroupStrategyWorkingTime()
                self.working_time.append(temp_model.from_map(k))
        if m.get('FollowUpStrategy') is not None:
            self.follow_up_strategy = m.get('FollowUpStrategy')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Customized') is not None:
            self.customized = m.get('Customized')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('IsTemplate') is not None:
            self.is_template = m.get('IsTemplate')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('RepeatDays') is not None:
            self.repeat_days = m.get('RepeatDays')
        if m.get('RoutingStrategy') is not None:
            self.routing_strategy = m.get('RoutingStrategy')
        if m.get('StrategyDescription') is not None:
            self.strategy_description = m.get('StrategyDescription')
        if m.get('MinAttemptInterval') is not None:
            self.min_attempt_interval = m.get('MinAttemptInterval')
        if m.get('RepeatBy') is not None:
            self.repeat_by = m.get('RepeatBy')
        return self


class CreateJobGroupResponseBodyJobGroup(TeaModel):
    def __init__(self, job_group_id=None, scenario_id=None, creation_time=None, strategy=None, calling_numbers=None,
                 job_group_name=None, job_file_path=None, job_group_description=None):
        self.job_group_id = TeaConverter.to_unicode(job_group_id)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.creation_time = creation_time  # type: long
        self.strategy = strategy  # type: CreateJobGroupResponseBodyJobGroupStrategy
        self.calling_numbers = calling_numbers  # type: list[unicode]
        self.job_group_name = TeaConverter.to_unicode(job_group_name)  # type: unicode
        self.job_file_path = TeaConverter.to_unicode(job_file_path)  # type: unicode
        self.job_group_description = TeaConverter.to_unicode(job_group_description)  # type: unicode

    def validate(self):
        if self.strategy:
            self.strategy.validate()

    def to_map(self):
        result = dict()
        if self.job_group_id is not None:
            result['JobGroupId'] = self.job_group_id
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.strategy is not None:
            result['Strategy'] = self.strategy.to_map()
        if self.calling_numbers is not None:
            result['CallingNumbers'] = self.calling_numbers
        if self.job_group_name is not None:
            result['JobGroupName'] = self.job_group_name
        if self.job_file_path is not None:
            result['JobFilePath'] = self.job_file_path
        if self.job_group_description is not None:
            result['JobGroupDescription'] = self.job_group_description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobGroupId') is not None:
            self.job_group_id = m.get('JobGroupId')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Strategy') is not None:
            temp_model = CreateJobGroupResponseBodyJobGroupStrategy()
            self.strategy = temp_model.from_map(m['Strategy'])
        if m.get('CallingNumbers') is not None:
            self.calling_numbers = m.get('CallingNumbers')
        if m.get('JobGroupName') is not None:
            self.job_group_name = m.get('JobGroupName')
        if m.get('JobFilePath') is not None:
            self.job_file_path = m.get('JobFilePath')
        if m.get('JobGroupDescription') is not None:
            self.job_group_description = m.get('JobGroupDescription')
        return self


class CreateJobGroupResponseBody(TeaModel):
    def __init__(self, job_group=None, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.job_group = job_group  # type: CreateJobGroupResponseBodyJobGroup
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.job_group:
            self.job_group.validate()

    def to_map(self):
        result = dict()
        if self.job_group is not None:
            result['JobGroup'] = self.job_group.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobGroup') is not None:
            temp_model = CreateJobGroupResponseBodyJobGroup()
            self.job_group = temp_model.from_map(m['JobGroup'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateJobGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateJobGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateJobGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMediaRequest(TeaModel):
    def __init__(self, instance_id=None, name=None, description=None, file_name=None, type=None, content=None,
                 oss_file_name=None, oss_file_path=None, upload_result=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.file_name = TeaConverter.to_unicode(file_name)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode
        self.oss_file_name = TeaConverter.to_unicode(oss_file_name)  # type: unicode
        self.oss_file_path = TeaConverter.to_unicode(oss_file_path)  # type: unicode
        self.upload_result = TeaConverter.to_unicode(upload_result)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.type is not None:
            result['Type'] = self.type
        if self.content is not None:
            result['Content'] = self.content
        if self.oss_file_name is not None:
            result['OssFileName'] = self.oss_file_name
        if self.oss_file_path is not None:
            result['OssFilePath'] = self.oss_file_path
        if self.upload_result is not None:
            result['UploadResult'] = self.upload_result
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('OssFileName') is not None:
            self.oss_file_name = m.get('OssFileName')
        if m.get('OssFilePath') is not None:
            self.oss_file_path = m.get('OssFilePath')
        if m.get('UploadResult') is not None:
            self.upload_result = m.get('UploadResult')
        return self


class CreateMediaResponseBodyMediaUploadParam(TeaModel):
    def __init__(self, instance=None, oss_file_path=None, file_name=None, name=None, id=None, oss_file_name=None):
        self.instance = TeaConverter.to_unicode(instance)  # type: unicode
        self.oss_file_path = TeaConverter.to_unicode(oss_file_path)  # type: unicode
        self.file_name = TeaConverter.to_unicode(file_name)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.id = TeaConverter.to_unicode(id)  # type: unicode
        self.oss_file_name = TeaConverter.to_unicode(oss_file_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance is not None:
            result['Instance'] = self.instance
        if self.oss_file_path is not None:
            result['OssFilePath'] = self.oss_file_path
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        if self.oss_file_name is not None:
            result['OssFileName'] = self.oss_file_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Instance') is not None:
            self.instance = m.get('Instance')
        if m.get('OssFilePath') is not None:
            self.oss_file_path = m.get('OssFilePath')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('OssFileName') is not None:
            self.oss_file_name = m.get('OssFileName')
        return self


class CreateMediaResponseBody(TeaModel):
    def __init__(self, media_upload_param=None, message=None, request_id=None, http_status_code=None, code=None,
                 success=None):
        self.media_upload_param = media_upload_param  # type: CreateMediaResponseBodyMediaUploadParam
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.media_upload_param:
            self.media_upload_param.validate()

    def to_map(self):
        result = dict()
        if self.media_upload_param is not None:
            result['MediaUploadParam'] = self.media_upload_param.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaUploadParam') is not None:
            temp_model = CreateMediaResponseBodyMediaUploadParam()
            self.media_upload_param = temp_model.from_map(m['MediaUploadParam'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMediaResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateMediaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateMediaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePredictiveJobGroupRequest(TeaModel):
    def __init__(self, instance_id=None, skill_group_id=None, strategy_json=None, name=None, description=None,
                 timing_schedule=None, job_file_path=None, is_draft=None, jobs_json=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.skill_group_id = TeaConverter.to_unicode(skill_group_id)  # type: unicode
        self.strategy_json = TeaConverter.to_unicode(strategy_json)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.timing_schedule = timing_schedule  # type: bool
        self.job_file_path = TeaConverter.to_unicode(job_file_path)  # type: unicode
        self.is_draft = is_draft  # type: bool
        self.jobs_json = jobs_json  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.strategy_json is not None:
            result['StrategyJson'] = self.strategy_json
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.timing_schedule is not None:
            result['TimingSchedule'] = self.timing_schedule
        if self.job_file_path is not None:
            result['JobFilePath'] = self.job_file_path
        if self.is_draft is not None:
            result['IsDraft'] = self.is_draft
        if self.jobs_json is not None:
            result['JobsJson'] = self.jobs_json
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('StrategyJson') is not None:
            self.strategy_json = m.get('StrategyJson')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('TimingSchedule') is not None:
            self.timing_schedule = m.get('TimingSchedule')
        if m.get('JobFilePath') is not None:
            self.job_file_path = m.get('JobFilePath')
        if m.get('IsDraft') is not None:
            self.is_draft = m.get('IsDraft')
        if m.get('JobsJson') is not None:
            self.jobs_json = m.get('JobsJson')
        return self


class CreatePredictiveJobGroupResponseBody(TeaModel):
    def __init__(self, job_group_id=None, request_id=None, message=None, http_status_code=None, code=None,
                 success=None):
        self.job_group_id = TeaConverter.to_unicode(job_group_id)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.job_group_id is not None:
            result['JobGroupId'] = self.job_group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.message is not None:
            result['Message'] = self.message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobGroupId') is not None:
            self.job_group_id = m.get('JobGroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreatePredictiveJobGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreatePredictiveJobGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreatePredictiveJobGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateScenarioRequest(TeaModel):
    def __init__(self, instance_id=None, name=None, description=None, strategy_json=None, type=None,
                 surveys_json=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.strategy_json = TeaConverter.to_unicode(strategy_json)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.surveys_json = surveys_json  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.strategy_json is not None:
            result['StrategyJson'] = self.strategy_json
        if self.type is not None:
            result['Type'] = self.type
        if self.surveys_json is not None:
            result['SurveysJson'] = self.surveys_json
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('StrategyJson') is not None:
            self.strategy_json = m.get('StrategyJson')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('SurveysJson') is not None:
            self.surveys_json = m.get('SurveysJson')
        return self


class CreateScenarioResponseBodyScenarioStrategyWorkingTime(TeaModel):
    def __init__(self, end_time=None, begin_time=None):
        self.end_time = TeaConverter.to_unicode(end_time)  # type: unicode
        self.begin_time = TeaConverter.to_unicode(begin_time)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.begin_time is not None:
            result['BeginTime'] = self.begin_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('BeginTime') is not None:
            self.begin_time = m.get('BeginTime')
        return self


class CreateScenarioResponseBodyScenarioStrategy(TeaModel):
    def __init__(self, type=None, strategy_name=None, max_attempts_per_day=None, working_time=None,
                 follow_up_strategy=None, end_time=None, customized=None, start_time=None, is_template=None, strategy_id=None,
                 repeat_days=None, routing_strategy=None, strategy_description=None, min_attempt_interval=None, repeat_by=None):
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.strategy_name = TeaConverter.to_unicode(strategy_name)  # type: unicode
        self.max_attempts_per_day = max_attempts_per_day  # type: int
        self.working_time = working_time  # type: list[CreateScenarioResponseBodyScenarioStrategyWorkingTime]
        self.follow_up_strategy = TeaConverter.to_unicode(follow_up_strategy)  # type: unicode
        self.end_time = end_time  # type: long
        self.customized = TeaConverter.to_unicode(customized)  # type: unicode
        self.start_time = start_time  # type: long
        self.is_template = is_template  # type: bool
        self.strategy_id = TeaConverter.to_unicode(strategy_id)  # type: unicode
        self.repeat_days = repeat_days  # type: list[unicode]
        self.routing_strategy = TeaConverter.to_unicode(routing_strategy)  # type: unicode
        self.strategy_description = TeaConverter.to_unicode(strategy_description)  # type: unicode
        self.min_attempt_interval = min_attempt_interval  # type: int
        self.repeat_by = TeaConverter.to_unicode(repeat_by)  # type: unicode

    def validate(self):
        if self.working_time:
            for k in self.working_time:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.strategy_name is not None:
            result['StrategyName'] = self.strategy_name
        if self.max_attempts_per_day is not None:
            result['MaxAttemptsPerDay'] = self.max_attempts_per_day
        result['WorkingTime'] = []
        if self.working_time is not None:
            for k in self.working_time:
                result['WorkingTime'].append(k.to_map() if k else None)
        if self.follow_up_strategy is not None:
            result['FollowUpStrategy'] = self.follow_up_strategy
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.customized is not None:
            result['Customized'] = self.customized
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.is_template is not None:
            result['IsTemplate'] = self.is_template
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.repeat_days is not None:
            result['RepeatDays'] = self.repeat_days
        if self.routing_strategy is not None:
            result['RoutingStrategy'] = self.routing_strategy
        if self.strategy_description is not None:
            result['StrategyDescription'] = self.strategy_description
        if self.min_attempt_interval is not None:
            result['MinAttemptInterval'] = self.min_attempt_interval
        if self.repeat_by is not None:
            result['RepeatBy'] = self.repeat_by
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('StrategyName') is not None:
            self.strategy_name = m.get('StrategyName')
        if m.get('MaxAttemptsPerDay') is not None:
            self.max_attempts_per_day = m.get('MaxAttemptsPerDay')
        self.working_time = []
        if m.get('WorkingTime') is not None:
            for k in m.get('WorkingTime'):
                temp_model = CreateScenarioResponseBodyScenarioStrategyWorkingTime()
                self.working_time.append(temp_model.from_map(k))
        if m.get('FollowUpStrategy') is not None:
            self.follow_up_strategy = m.get('FollowUpStrategy')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Customized') is not None:
            self.customized = m.get('Customized')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('IsTemplate') is not None:
            self.is_template = m.get('IsTemplate')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('RepeatDays') is not None:
            self.repeat_days = m.get('RepeatDays')
        if m.get('RoutingStrategy') is not None:
            self.routing_strategy = m.get('RoutingStrategy')
        if m.get('StrategyDescription') is not None:
            self.strategy_description = m.get('StrategyDescription')
        if m.get('MinAttemptInterval') is not None:
            self.min_attempt_interval = m.get('MinAttemptInterval')
        if m.get('RepeatBy') is not None:
            self.repeat_by = m.get('RepeatBy')
        return self


class CreateScenarioResponseBodyScenarioSurveysIntents(TeaModel):
    def __init__(self, node_id=None, intent_id=None):
        self.node_id = TeaConverter.to_unicode(node_id)  # type: unicode
        self.intent_id = TeaConverter.to_unicode(intent_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.intent_id is not None:
            result['IntentId'] = self.intent_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('IntentId') is not None:
            self.intent_id = m.get('IntentId')
        return self


class CreateScenarioResponseBodyScenarioSurveys(TeaModel):
    def __init__(self, round=None, survey_description=None, beebot_id=None, intents=None, survey_name=None,
                 role=None, survey_id=None):
        self.round = round  # type: int
        self.survey_description = TeaConverter.to_unicode(survey_description)  # type: unicode
        self.beebot_id = TeaConverter.to_unicode(beebot_id)  # type: unicode
        self.intents = intents  # type: list[CreateScenarioResponseBodyScenarioSurveysIntents]
        self.survey_name = TeaConverter.to_unicode(survey_name)  # type: unicode
        self.role = TeaConverter.to_unicode(role)  # type: unicode
        self.survey_id = TeaConverter.to_unicode(survey_id)  # type: unicode

    def validate(self):
        if self.intents:
            for k in self.intents:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.round is not None:
            result['Round'] = self.round
        if self.survey_description is not None:
            result['SurveyDescription'] = self.survey_description
        if self.beebot_id is not None:
            result['BeebotId'] = self.beebot_id
        result['Intents'] = []
        if self.intents is not None:
            for k in self.intents:
                result['Intents'].append(k.to_map() if k else None)
        if self.survey_name is not None:
            result['SurveyName'] = self.survey_name
        if self.role is not None:
            result['Role'] = self.role
        if self.survey_id is not None:
            result['SurveyId'] = self.survey_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Round') is not None:
            self.round = m.get('Round')
        if m.get('SurveyDescription') is not None:
            self.survey_description = m.get('SurveyDescription')
        if m.get('BeebotId') is not None:
            self.beebot_id = m.get('BeebotId')
        self.intents = []
        if m.get('Intents') is not None:
            for k in m.get('Intents'):
                temp_model = CreateScenarioResponseBodyScenarioSurveysIntents()
                self.intents.append(temp_model.from_map(k))
        if m.get('SurveyName') is not None:
            self.survey_name = m.get('SurveyName')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('SurveyId') is not None:
            self.survey_id = m.get('SurveyId')
        return self


class CreateScenarioResponseBodyScenarioVariables(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateScenarioResponseBodyScenario(TeaModel):
    def __init__(self, type=None, scenario_id=None, strategy=None, is_template=None, scenario_description=None,
                 scenario_name=None, surveys=None, variables=None):
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.strategy = strategy  # type: CreateScenarioResponseBodyScenarioStrategy
        self.is_template = is_template  # type: bool
        self.scenario_description = TeaConverter.to_unicode(scenario_description)  # type: unicode
        self.scenario_name = TeaConverter.to_unicode(scenario_name)  # type: unicode
        self.surveys = surveys  # type: list[CreateScenarioResponseBodyScenarioSurveys]
        self.variables = variables  # type: list[CreateScenarioResponseBodyScenarioVariables]

    def validate(self):
        if self.strategy:
            self.strategy.validate()
        if self.surveys:
            for k in self.surveys:
                if k:
                    k.validate()
        if self.variables:
            for k in self.variables:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.strategy is not None:
            result['Strategy'] = self.strategy.to_map()
        if self.is_template is not None:
            result['IsTemplate'] = self.is_template
        if self.scenario_description is not None:
            result['ScenarioDescription'] = self.scenario_description
        if self.scenario_name is not None:
            result['ScenarioName'] = self.scenario_name
        result['Surveys'] = []
        if self.surveys is not None:
            for k in self.surveys:
                result['Surveys'].append(k.to_map() if k else None)
        result['Variables'] = []
        if self.variables is not None:
            for k in self.variables:
                result['Variables'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('Strategy') is not None:
            temp_model = CreateScenarioResponseBodyScenarioStrategy()
            self.strategy = temp_model.from_map(m['Strategy'])
        if m.get('IsTemplate') is not None:
            self.is_template = m.get('IsTemplate')
        if m.get('ScenarioDescription') is not None:
            self.scenario_description = m.get('ScenarioDescription')
        if m.get('ScenarioName') is not None:
            self.scenario_name = m.get('ScenarioName')
        self.surveys = []
        if m.get('Surveys') is not None:
            for k in m.get('Surveys'):
                temp_model = CreateScenarioResponseBodyScenarioSurveys()
                self.surveys.append(temp_model.from_map(k))
        self.variables = []
        if m.get('Variables') is not None:
            for k in m.get('Variables'):
                temp_model = CreateScenarioResponseBodyScenarioVariables()
                self.variables.append(temp_model.from_map(k))
        return self


class CreateScenarioResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None, scenario=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool
        self.scenario = scenario  # type: CreateScenarioResponseBodyScenario

    def validate(self):
        if self.scenario:
            self.scenario.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        if self.scenario is not None:
            result['Scenario'] = self.scenario.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Scenario') is not None:
            temp_model = CreateScenarioResponseBodyScenario()
            self.scenario = temp_model.from_map(m['Scenario'])
        return self


class CreateScenarioResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateScenarioResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateScenarioResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateScenarioFromTemplateRequest(TeaModel):
    def __init__(self, instance_id=None, name=None, description=None, template_id=None, variables=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.template_id = TeaConverter.to_unicode(template_id)  # type: unicode
        self.variables = TeaConverter.to_unicode(variables)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.variables is not None:
            result['Variables'] = self.variables
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Variables') is not None:
            self.variables = m.get('Variables')
        return self


class CreateScenarioFromTemplateResponseBodyScenarioStrategyWorkingTime(TeaModel):
    def __init__(self, end_time=None, begin_time=None):
        self.end_time = TeaConverter.to_unicode(end_time)  # type: unicode
        self.begin_time = TeaConverter.to_unicode(begin_time)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.begin_time is not None:
            result['BeginTime'] = self.begin_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('BeginTime') is not None:
            self.begin_time = m.get('BeginTime')
        return self


class CreateScenarioFromTemplateResponseBodyScenarioStrategy(TeaModel):
    def __init__(self, type=None, strategy_name=None, max_attempts_per_day=None, working_time=None,
                 follow_up_strategy=None, end_time=None, customized=None, start_time=None, is_template=None, strategy_id=None,
                 repeat_days=None, routing_strategy=None, strategy_description=None, min_attempt_interval=None, repeat_by=None):
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.strategy_name = TeaConverter.to_unicode(strategy_name)  # type: unicode
        self.max_attempts_per_day = max_attempts_per_day  # type: int
        self.working_time = working_time  # type: list[CreateScenarioFromTemplateResponseBodyScenarioStrategyWorkingTime]
        self.follow_up_strategy = TeaConverter.to_unicode(follow_up_strategy)  # type: unicode
        self.end_time = end_time  # type: long
        self.customized = TeaConverter.to_unicode(customized)  # type: unicode
        self.start_time = start_time  # type: long
        self.is_template = is_template  # type: bool
        self.strategy_id = TeaConverter.to_unicode(strategy_id)  # type: unicode
        self.repeat_days = repeat_days  # type: list[unicode]
        self.routing_strategy = TeaConverter.to_unicode(routing_strategy)  # type: unicode
        self.strategy_description = TeaConverter.to_unicode(strategy_description)  # type: unicode
        self.min_attempt_interval = min_attempt_interval  # type: int
        self.repeat_by = TeaConverter.to_unicode(repeat_by)  # type: unicode

    def validate(self):
        if self.working_time:
            for k in self.working_time:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.strategy_name is not None:
            result['StrategyName'] = self.strategy_name
        if self.max_attempts_per_day is not None:
            result['MaxAttemptsPerDay'] = self.max_attempts_per_day
        result['WorkingTime'] = []
        if self.working_time is not None:
            for k in self.working_time:
                result['WorkingTime'].append(k.to_map() if k else None)
        if self.follow_up_strategy is not None:
            result['FollowUpStrategy'] = self.follow_up_strategy
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.customized is not None:
            result['Customized'] = self.customized
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.is_template is not None:
            result['IsTemplate'] = self.is_template
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.repeat_days is not None:
            result['RepeatDays'] = self.repeat_days
        if self.routing_strategy is not None:
            result['RoutingStrategy'] = self.routing_strategy
        if self.strategy_description is not None:
            result['StrategyDescription'] = self.strategy_description
        if self.min_attempt_interval is not None:
            result['MinAttemptInterval'] = self.min_attempt_interval
        if self.repeat_by is not None:
            result['RepeatBy'] = self.repeat_by
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('StrategyName') is not None:
            self.strategy_name = m.get('StrategyName')
        if m.get('MaxAttemptsPerDay') is not None:
            self.max_attempts_per_day = m.get('MaxAttemptsPerDay')
        self.working_time = []
        if m.get('WorkingTime') is not None:
            for k in m.get('WorkingTime'):
                temp_model = CreateScenarioFromTemplateResponseBodyScenarioStrategyWorkingTime()
                self.working_time.append(temp_model.from_map(k))
        if m.get('FollowUpStrategy') is not None:
            self.follow_up_strategy = m.get('FollowUpStrategy')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Customized') is not None:
            self.customized = m.get('Customized')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('IsTemplate') is not None:
            self.is_template = m.get('IsTemplate')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('RepeatDays') is not None:
            self.repeat_days = m.get('RepeatDays')
        if m.get('RoutingStrategy') is not None:
            self.routing_strategy = m.get('RoutingStrategy')
        if m.get('StrategyDescription') is not None:
            self.strategy_description = m.get('StrategyDescription')
        if m.get('MinAttemptInterval') is not None:
            self.min_attempt_interval = m.get('MinAttemptInterval')
        if m.get('RepeatBy') is not None:
            self.repeat_by = m.get('RepeatBy')
        return self


class CreateScenarioFromTemplateResponseBodyScenarioSurveysIntents(TeaModel):
    def __init__(self, node_id=None, intent_id=None):
        self.node_id = TeaConverter.to_unicode(node_id)  # type: unicode
        self.intent_id = TeaConverter.to_unicode(intent_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.intent_id is not None:
            result['IntentId'] = self.intent_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('IntentId') is not None:
            self.intent_id = m.get('IntentId')
        return self


class CreateScenarioFromTemplateResponseBodyScenarioSurveys(TeaModel):
    def __init__(self, round=None, survey_description=None, beebot_id=None, intents=None, survey_name=None,
                 role=None, survey_id=None):
        self.round = round  # type: int
        self.survey_description = TeaConverter.to_unicode(survey_description)  # type: unicode
        self.beebot_id = TeaConverter.to_unicode(beebot_id)  # type: unicode
        self.intents = intents  # type: list[CreateScenarioFromTemplateResponseBodyScenarioSurveysIntents]
        self.survey_name = TeaConverter.to_unicode(survey_name)  # type: unicode
        self.role = TeaConverter.to_unicode(role)  # type: unicode
        self.survey_id = TeaConverter.to_unicode(survey_id)  # type: unicode

    def validate(self):
        if self.intents:
            for k in self.intents:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.round is not None:
            result['Round'] = self.round
        if self.survey_description is not None:
            result['SurveyDescription'] = self.survey_description
        if self.beebot_id is not None:
            result['BeebotId'] = self.beebot_id
        result['Intents'] = []
        if self.intents is not None:
            for k in self.intents:
                result['Intents'].append(k.to_map() if k else None)
        if self.survey_name is not None:
            result['SurveyName'] = self.survey_name
        if self.role is not None:
            result['Role'] = self.role
        if self.survey_id is not None:
            result['SurveyId'] = self.survey_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Round') is not None:
            self.round = m.get('Round')
        if m.get('SurveyDescription') is not None:
            self.survey_description = m.get('SurveyDescription')
        if m.get('BeebotId') is not None:
            self.beebot_id = m.get('BeebotId')
        self.intents = []
        if m.get('Intents') is not None:
            for k in m.get('Intents'):
                temp_model = CreateScenarioFromTemplateResponseBodyScenarioSurveysIntents()
                self.intents.append(temp_model.from_map(k))
        if m.get('SurveyName') is not None:
            self.survey_name = m.get('SurveyName')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('SurveyId') is not None:
            self.survey_id = m.get('SurveyId')
        return self


class CreateScenarioFromTemplateResponseBodyScenarioVariables(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateScenarioFromTemplateResponseBodyScenario(TeaModel):
    def __init__(self, type=None, scenario_id=None, strategy=None, is_template=None, scenario_description=None,
                 scenario_name=None, surveys=None, variables=None):
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.strategy = strategy  # type: CreateScenarioFromTemplateResponseBodyScenarioStrategy
        self.is_template = is_template  # type: bool
        self.scenario_description = TeaConverter.to_unicode(scenario_description)  # type: unicode
        self.scenario_name = TeaConverter.to_unicode(scenario_name)  # type: unicode
        self.surveys = surveys  # type: list[CreateScenarioFromTemplateResponseBodyScenarioSurveys]
        self.variables = variables  # type: list[CreateScenarioFromTemplateResponseBodyScenarioVariables]

    def validate(self):
        if self.strategy:
            self.strategy.validate()
        if self.surveys:
            for k in self.surveys:
                if k:
                    k.validate()
        if self.variables:
            for k in self.variables:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.strategy is not None:
            result['Strategy'] = self.strategy.to_map()
        if self.is_template is not None:
            result['IsTemplate'] = self.is_template
        if self.scenario_description is not None:
            result['ScenarioDescription'] = self.scenario_description
        if self.scenario_name is not None:
            result['ScenarioName'] = self.scenario_name
        result['Surveys'] = []
        if self.surveys is not None:
            for k in self.surveys:
                result['Surveys'].append(k.to_map() if k else None)
        result['Variables'] = []
        if self.variables is not None:
            for k in self.variables:
                result['Variables'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('Strategy') is not None:
            temp_model = CreateScenarioFromTemplateResponseBodyScenarioStrategy()
            self.strategy = temp_model.from_map(m['Strategy'])
        if m.get('IsTemplate') is not None:
            self.is_template = m.get('IsTemplate')
        if m.get('ScenarioDescription') is not None:
            self.scenario_description = m.get('ScenarioDescription')
        if m.get('ScenarioName') is not None:
            self.scenario_name = m.get('ScenarioName')
        self.surveys = []
        if m.get('Surveys') is not None:
            for k in m.get('Surveys'):
                temp_model = CreateScenarioFromTemplateResponseBodyScenarioSurveys()
                self.surveys.append(temp_model.from_map(k))
        self.variables = []
        if m.get('Variables') is not None:
            for k in m.get('Variables'):
                temp_model = CreateScenarioFromTemplateResponseBodyScenarioVariables()
                self.variables.append(temp_model.from_map(k))
        return self


class CreateScenarioFromTemplateResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None, scenario=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool
        self.scenario = scenario  # type: CreateScenarioFromTemplateResponseBodyScenario

    def validate(self):
        if self.scenario:
            self.scenario.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        if self.scenario is not None:
            result['Scenario'] = self.scenario.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Scenario') is not None:
            temp_model = CreateScenarioFromTemplateResponseBodyScenario()
            self.scenario = temp_model.from_map(m['Scenario'])
        return self


class CreateScenarioFromTemplateResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateScenarioFromTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateScenarioFromTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSkillGroupRequest(TeaModel):
    def __init__(self, instance_id=None, name=None, description=None, routing_strategy=None,
                 allow_private_outbound_number=None, outbound_phone_number_id=None, user_id=None, skill_level=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.routing_strategy = TeaConverter.to_unicode(routing_strategy)  # type: unicode
        self.allow_private_outbound_number = allow_private_outbound_number  # type: bool
        self.outbound_phone_number_id = outbound_phone_number_id  # type: list[unicode]
        self.user_id = user_id  # type: list[unicode]
        self.skill_level = skill_level  # type: list[int]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.routing_strategy is not None:
            result['RoutingStrategy'] = self.routing_strategy
        if self.allow_private_outbound_number is not None:
            result['AllowPrivateOutboundNumber'] = self.allow_private_outbound_number
        if self.outbound_phone_number_id is not None:
            result['OutboundPhoneNumberId'] = self.outbound_phone_number_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.skill_level is not None:
            result['SkillLevel'] = self.skill_level
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RoutingStrategy') is not None:
            self.routing_strategy = m.get('RoutingStrategy')
        if m.get('AllowPrivateOutboundNumber') is not None:
            self.allow_private_outbound_number = m.get('AllowPrivateOutboundNumber')
        if m.get('OutboundPhoneNumberId') is not None:
            self.outbound_phone_number_id = m.get('OutboundPhoneNumberId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('SkillLevel') is not None:
            self.skill_level = m.get('SkillLevel')
        return self


class CreateSkillGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, message=None, http_status_code=None, skill_group_id=None, code=None,
                 success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.skill_group_id = TeaConverter.to_unicode(skill_group_id)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.message is not None:
            result['Message'] = self.message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSurveyRequest(TeaModel):
    def __init__(self, instance_id=None, scenario_id=None, name=None, description=None, flow_json=None, corpora=None,
                 speech_optimization_param=None, global_questions=None, role=None, round=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.flow_json = TeaConverter.to_unicode(flow_json)  # type: unicode
        self.corpora = TeaConverter.to_unicode(corpora)  # type: unicode
        self.speech_optimization_param = TeaConverter.to_unicode(speech_optimization_param)  # type: unicode
        self.global_questions = TeaConverter.to_unicode(global_questions)  # type: unicode
        self.role = TeaConverter.to_unicode(role)  # type: unicode
        self.round = round  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.flow_json is not None:
            result['FlowJson'] = self.flow_json
        if self.corpora is not None:
            result['Corpora'] = self.corpora
        if self.speech_optimization_param is not None:
            result['SpeechOptimizationParam'] = self.speech_optimization_param
        if self.global_questions is not None:
            result['GlobalQuestions'] = self.global_questions
        if self.role is not None:
            result['Role'] = self.role
        if self.round is not None:
            result['Round'] = self.round
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FlowJson') is not None:
            self.flow_json = m.get('FlowJson')
        if m.get('Corpora') is not None:
            self.corpora = m.get('Corpora')
        if m.get('SpeechOptimizationParam') is not None:
            self.speech_optimization_param = m.get('SpeechOptimizationParam')
        if m.get('GlobalQuestions') is not None:
            self.global_questions = m.get('GlobalQuestions')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Round') is not None:
            self.round = m.get('Round')
        return self


class CreateSurveyResponseBodySurveyAsrCustomModel(TeaModel):
    def __init__(self, custom_model_status=None, corpora=None):
        self.custom_model_status = custom_model_status  # type: int
        self.corpora = TeaConverter.to_unicode(corpora)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.custom_model_status is not None:
            result['CustomModelStatus'] = self.custom_model_status
        if self.corpora is not None:
            result['Corpora'] = self.corpora
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomModelStatus') is not None:
            self.custom_model_status = m.get('CustomModelStatus')
        if m.get('Corpora') is not None:
            self.corpora = m.get('Corpora')
        return self


class CreateSurveyResponseBodySurveyFlow(TeaModel):
    def __init__(self, is_published=None, flow_json=None, flow_id=None):
        self.is_published = is_published  # type: bool
        self.flow_json = TeaConverter.to_unicode(flow_json)  # type: unicode
        self.flow_id = TeaConverter.to_unicode(flow_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.is_published is not None:
            result['IsPublished'] = self.is_published
        if self.flow_json is not None:
            result['FlowJson'] = self.flow_json
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsPublished') is not None:
            self.is_published = m.get('IsPublished')
        if m.get('FlowJson') is not None:
            self.flow_json = m.get('FlowJson')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        return self


class CreateSurveyResponseBodySurvey(TeaModel):
    def __init__(self, global_questions=None, round=None, speech_optimization_param=None, description=None,
                 hot_words=None, asr_custom_model=None, flow=None, role=None, name=None, scenario_uuid=None, id=None):
        self.global_questions = TeaConverter.to_unicode(global_questions)  # type: unicode
        self.round = round  # type: int
        self.speech_optimization_param = TeaConverter.to_unicode(speech_optimization_param)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.hot_words = TeaConverter.to_unicode(hot_words)  # type: unicode
        self.asr_custom_model = asr_custom_model  # type: CreateSurveyResponseBodySurveyAsrCustomModel
        self.flow = flow  # type: CreateSurveyResponseBodySurveyFlow
        self.role = TeaConverter.to_unicode(role)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.scenario_uuid = TeaConverter.to_unicode(scenario_uuid)  # type: unicode
        self.id = TeaConverter.to_unicode(id)  # type: unicode

    def validate(self):
        if self.asr_custom_model:
            self.asr_custom_model.validate()
        if self.flow:
            self.flow.validate()

    def to_map(self):
        result = dict()
        if self.global_questions is not None:
            result['GlobalQuestions'] = self.global_questions
        if self.round is not None:
            result['Round'] = self.round
        if self.speech_optimization_param is not None:
            result['SpeechOptimizationParam'] = self.speech_optimization_param
        if self.description is not None:
            result['Description'] = self.description
        if self.hot_words is not None:
            result['HotWords'] = self.hot_words
        if self.asr_custom_model is not None:
            result['AsrCustomModel'] = self.asr_custom_model.to_map()
        if self.flow is not None:
            result['Flow'] = self.flow.to_map()
        if self.role is not None:
            result['Role'] = self.role
        if self.name is not None:
            result['Name'] = self.name
        if self.scenario_uuid is not None:
            result['ScenarioUuid'] = self.scenario_uuid
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GlobalQuestions') is not None:
            self.global_questions = m.get('GlobalQuestions')
        if m.get('Round') is not None:
            self.round = m.get('Round')
        if m.get('SpeechOptimizationParam') is not None:
            self.speech_optimization_param = m.get('SpeechOptimizationParam')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('HotWords') is not None:
            self.hot_words = m.get('HotWords')
        if m.get('AsrCustomModel') is not None:
            temp_model = CreateSurveyResponseBodySurveyAsrCustomModel()
            self.asr_custom_model = temp_model.from_map(m['AsrCustomModel'])
        if m.get('Flow') is not None:
            temp_model = CreateSurveyResponseBodySurveyFlow()
            self.flow = temp_model.from_map(m['Flow'])
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ScenarioUuid') is not None:
            self.scenario_uuid = m.get('ScenarioUuid')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class CreateSurveyResponseBody(TeaModel):
    def __init__(self, survey=None, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.survey = survey  # type: CreateSurveyResponseBodySurvey
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.survey:
            self.survey.validate()

    def to_map(self):
        result = dict()
        if self.survey is not None:
            result['Survey'] = self.survey.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Survey') is not None:
            temp_model = CreateSurveyResponseBodySurvey()
            self.survey = temp_model.from_map(m['Survey'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSurveyResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateSurveyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSurveyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUserRequest(TeaModel):
    def __init__(self, display_name=None, instance_id=None, login_name=None, phone=None, email=None,
                 private_outbound_number_id=None, role_id=None, skill_group_id=None, skill_level=None):
        self.display_name = TeaConverter.to_unicode(display_name)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.login_name = TeaConverter.to_unicode(login_name)  # type: unicode
        self.phone = TeaConverter.to_unicode(phone)  # type: unicode
        self.email = TeaConverter.to_unicode(email)  # type: unicode
        self.private_outbound_number_id = TeaConverter.to_unicode(private_outbound_number_id)  # type: unicode
        self.role_id = role_id  # type: list[unicode]
        self.skill_group_id = skill_group_id  # type: list[unicode]
        self.skill_level = skill_level  # type: list[int]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.phone is not None:
            result['Phone'] = self.phone
        if self.email is not None:
            result['Email'] = self.email
        if self.private_outbound_number_id is not None:
            result['PrivateOutboundNumberId'] = self.private_outbound_number_id
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_level is not None:
            result['SkillLevel'] = self.skill_level
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Phone') is not None:
            self.phone = m.get('Phone')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('PrivateOutboundNumberId') is not None:
            self.private_outbound_number_id = m.get('PrivateOutboundNumberId')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillLevel') is not None:
            self.skill_level = m.get('SkillLevel')
        return self


class CreateUserResponseBody(TeaModel):
    def __init__(self, request_id=None, message=None, user_id=None, http_status_code=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.user_id = TeaConverter.to_unicode(user_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.message is not None:
            result['Message'] = self.message
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVoiceAppraiseRequest(TeaModel):
    def __init__(self, instance_id=None, contact_flow_version_id=None, content=None, is_appraise=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.contact_flow_version_id = TeaConverter.to_unicode(contact_flow_version_id)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode
        self.is_appraise = is_appraise  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.contact_flow_version_id is not None:
            result['ContactFlowVersionId'] = self.contact_flow_version_id
        if self.content is not None:
            result['Content'] = self.content
        if self.is_appraise is not None:
            result['IsAppraise'] = self.is_appraise
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ContactFlowVersionId') is not None:
            self.contact_flow_version_id = m.get('ContactFlowVersionId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('IsAppraise') is not None:
            self.is_appraise = m.get('IsAppraise')
        return self


class CreateVoiceAppraiseResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateVoiceAppraiseResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateVoiceAppraiseResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateVoiceAppraiseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInstanceRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteInstanceResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteJobGroupRequest(TeaModel):
    def __init__(self, instance_id=None, job_group_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.job_group_id = TeaConverter.to_unicode(job_group_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_group_id is not None:
            result['JobGroupId'] = self.job_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobGroupId') is not None:
            self.job_group_id = m.get('JobGroupId')
        return self


class DeleteJobGroupResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteJobGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteJobGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteJobGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMediaRequest(TeaModel):
    def __init__(self, instance_id=None, name=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DeleteMediaResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMediaResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteMediaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteMediaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePhoneTagsRequest(TeaModel):
    def __init__(self, instance_id=None, phone_number_list=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.phone_number_list = phone_number_list  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.phone_number_list is not None:
            result['PhoneNumberList'] = self.phone_number_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PhoneNumberList') is not None:
            self.phone_number_list = m.get('PhoneNumberList')
        return self


class DeletePhoneTagsResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeletePhoneTagsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeletePhoneTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeletePhoneTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSkillGroupRequest(TeaModel):
    def __init__(self, instance_id=None, skill_group_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.skill_group_id = TeaConverter.to_unicode(skill_group_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class DeleteSkillGroupResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSurveyRequest(TeaModel):
    def __init__(self, instance_id=None, scenario_id=None, survey_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.survey_id = TeaConverter.to_unicode(survey_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.survey_id is not None:
            result['SurveyId'] = self.survey_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('SurveyId') is not None:
            self.survey_id = m.get('SurveyId')
        return self


class DeleteSurveyResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSurveyResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteSurveyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSurveyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DialExRequest(TeaModel):
    def __init__(self, instance_id=None, caller=None, callee=None, rout_point=None, answer_mode=None, provider=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.caller = TeaConverter.to_unicode(caller)  # type: unicode
        self.callee = TeaConverter.to_unicode(callee)  # type: unicode
        self.rout_point = TeaConverter.to_unicode(rout_point)  # type: unicode
        self.answer_mode = answer_mode  # type: int
        self.provider = TeaConverter.to_unicode(provider)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.callee is not None:
            result['Callee'] = self.callee
        if self.rout_point is not None:
            result['RoutPoint'] = self.rout_point
        if self.answer_mode is not None:
            result['AnswerMode'] = self.answer_mode
        if self.provider is not None:
            result['Provider'] = self.provider
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('Callee') is not None:
            self.callee = m.get('Callee')
        if m.get('RoutPoint') is not None:
            self.rout_point = m.get('RoutPoint')
        if m.get('AnswerMode') is not None:
            self.answer_mode = m.get('AnswerMode')
        if m.get('Provider') is not None:
            self.provider = m.get('Provider')
        return self


class DialExResponseBody(TeaModel):
    def __init__(self, status_desc=None, task_id=None, request_id=None, message=None, http_status_code=None,
                 status_code=None, code=None, success=None, time_stamp=None):
        self.status_desc = TeaConverter.to_unicode(status_desc)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.status_code = TeaConverter.to_unicode(status_code)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool
        self.time_stamp = TeaConverter.to_unicode(time_stamp)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status_desc is not None:
            result['StatusDesc'] = self.status_desc
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.message is not None:
            result['Message'] = self.message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.status_code is not None:
            result['StatusCode'] = self.status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('StatusDesc') is not None:
            self.status_desc = m.get('StatusDesc')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('StatusCode') is not None:
            self.status_code = m.get('StatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DialExResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DialExResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DialExResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DialogueRequest(TeaModel):
    def __init__(self, instance_id=None, call_id=None, call_type=None, scenario_id=None, task_id=None,
                 utterance=None, action_key=None, action_params=None, calling_number=None, called_number=None,
                 instance_owner_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.call_id = TeaConverter.to_unicode(call_id)  # type: unicode
        self.call_type = TeaConverter.to_unicode(call_type)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.utterance = TeaConverter.to_unicode(utterance)  # type: unicode
        self.action_key = TeaConverter.to_unicode(action_key)  # type: unicode
        self.action_params = TeaConverter.to_unicode(action_params)  # type: unicode
        self.calling_number = TeaConverter.to_unicode(calling_number)  # type: unicode
        self.called_number = TeaConverter.to_unicode(called_number)  # type: unicode
        self.instance_owner_id = instance_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.utterance is not None:
            result['Utterance'] = self.utterance
        if self.action_key is not None:
            result['ActionKey'] = self.action_key
        if self.action_params is not None:
            result['ActionParams'] = self.action_params
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.instance_owner_id is not None:
            result['InstanceOwnerId'] = self.instance_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Utterance') is not None:
            self.utterance = m.get('Utterance')
        if m.get('ActionKey') is not None:
            self.action_key = m.get('ActionKey')
        if m.get('ActionParams') is not None:
            self.action_params = m.get('ActionParams')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('InstanceOwnerId') is not None:
            self.instance_owner_id = m.get('InstanceOwnerId')
        return self


class DialogueResponseBodyFeedback(TeaModel):
    def __init__(self, action=None, interruptible=None, action_params=None, content=None):
        self.action = TeaConverter.to_unicode(action)  # type: unicode
        self.interruptible = interruptible  # type: bool
        self.action_params = TeaConverter.to_unicode(action_params)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.interruptible is not None:
            result['Interruptible'] = self.interruptible
        if self.action_params is not None:
            result['ActionParams'] = self.action_params
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('Interruptible') is not None:
            self.interruptible = m.get('Interruptible')
        if m.get('ActionParams') is not None:
            self.action_params = m.get('ActionParams')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class DialogueResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, feedback=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.feedback = feedback  # type: DialogueResponseBodyFeedback
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.feedback:
            self.feedback.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.feedback is not None:
            result['Feedback'] = self.feedback.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Feedback') is not None:
            temp_model = DialogueResponseBodyFeedback()
            self.feedback = temp_model.from_map(m['Feedback'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DialogueResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DialogueResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DialogueResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableTrunkProvidersRequest(TeaModel):
    def __init__(self, provider_name=None):
        self.provider_name = provider_name  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.provider_name is not None:
            result['ProviderName'] = self.provider_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProviderName') is not None:
            self.provider_name = m.get('ProviderName')
        return self


class DisableTrunkProvidersResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DisableTrunkProvidersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DisableTrunkProvidersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisableTrunkProvidersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DownloadAllTypeRecordingRequest(TeaModel):
    def __init__(self, instance_id=None, contact_id=None, channel=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.contact_id = TeaConverter.to_unicode(contact_id)  # type: unicode
        self.channel = TeaConverter.to_unicode(channel)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.channel is not None:
            result['Channel'] = self.channel
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('Channel') is not None:
            self.channel = m.get('Channel')
        return self


class DownloadAllTypeRecordingResponseBodyMediaDownloadParamListMediaDownloadParam(TeaModel):
    def __init__(self, signature_url=None, file_name=None):
        self.signature_url = TeaConverter.to_unicode(signature_url)  # type: unicode
        self.file_name = TeaConverter.to_unicode(file_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.signature_url is not None:
            result['SignatureUrl'] = self.signature_url
        if self.file_name is not None:
            result['FileName'] = self.file_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SignatureUrl') is not None:
            self.signature_url = m.get('SignatureUrl')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        return self


class DownloadAllTypeRecordingResponseBodyMediaDownloadParamList(TeaModel):
    def __init__(self, media_download_param=None):
        self.media_download_param = media_download_param  # type: list[DownloadAllTypeRecordingResponseBodyMediaDownloadParamListMediaDownloadParam]

    def validate(self):
        if self.media_download_param:
            for k in self.media_download_param:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['MediaDownloadParam'] = []
        if self.media_download_param is not None:
            for k in self.media_download_param:
                result['MediaDownloadParam'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.media_download_param = []
        if m.get('MediaDownloadParam') is not None:
            for k in m.get('MediaDownloadParam'):
                temp_model = DownloadAllTypeRecordingResponseBodyMediaDownloadParamListMediaDownloadParam()
                self.media_download_param.append(temp_model.from_map(k))
        return self


class DownloadAllTypeRecordingResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, media_download_param_list=None,
                 code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.media_download_param_list = media_download_param_list  # type: DownloadAllTypeRecordingResponseBodyMediaDownloadParamList
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.media_download_param_list:
            self.media_download_param_list.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.media_download_param_list is not None:
            result['MediaDownloadParamList'] = self.media_download_param_list.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('MediaDownloadParamList') is not None:
            temp_model = DownloadAllTypeRecordingResponseBodyMediaDownloadParamList()
            self.media_download_param_list = temp_model.from_map(m['MediaDownloadParamList'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DownloadAllTypeRecordingResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DownloadAllTypeRecordingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DownloadAllTypeRecordingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DownloadCabRecordingRequest(TeaModel):
    def __init__(self, instance_id=None, task_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DownloadCabRecordingResponseBodyMediaDownloadParam(TeaModel):
    def __init__(self, signature_url=None, file_name=None):
        self.signature_url = TeaConverter.to_unicode(signature_url)  # type: unicode
        self.file_name = TeaConverter.to_unicode(file_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.signature_url is not None:
            result['SignatureUrl'] = self.signature_url
        if self.file_name is not None:
            result['FileName'] = self.file_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SignatureUrl') is not None:
            self.signature_url = m.get('SignatureUrl')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        return self


class DownloadCabRecordingResponseBody(TeaModel):
    def __init__(self, media_download_param=None, message=None, request_id=None, http_status_code=None, code=None,
                 success=None):
        self.media_download_param = media_download_param  # type: DownloadCabRecordingResponseBodyMediaDownloadParam
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.media_download_param:
            self.media_download_param.validate()

    def to_map(self):
        result = dict()
        if self.media_download_param is not None:
            result['MediaDownloadParam'] = self.media_download_param.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaDownloadParam') is not None:
            temp_model = DownloadCabRecordingResponseBodyMediaDownloadParam()
            self.media_download_param = temp_model.from_map(m['MediaDownloadParam'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DownloadCabRecordingResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DownloadCabRecordingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DownloadCabRecordingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DownloadOriginalStatisticsReportRequest(TeaModel):
    def __init__(self, instance_id=None, job_group_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.job_group_id = TeaConverter.to_unicode(job_group_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_group_id is not None:
            result['JobGroupId'] = self.job_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobGroupId') is not None:
            self.job_group_id = m.get('JobGroupId')
        return self


class DownloadOriginalStatisticsReportResponseBodyDownloadParams(TeaModel):
    def __init__(self, signature_url=None):
        self.signature_url = TeaConverter.to_unicode(signature_url)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.signature_url is not None:
            result['SignatureUrl'] = self.signature_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SignatureUrl') is not None:
            self.signature_url = m.get('SignatureUrl')
        return self


class DownloadOriginalStatisticsReportResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, download_params=None, http_status_code=None, code=None,
                 success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.download_params = download_params  # type: DownloadOriginalStatisticsReportResponseBodyDownloadParams
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.download_params:
            self.download_params.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.download_params is not None:
            result['DownloadParams'] = self.download_params.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DownloadParams') is not None:
            temp_model = DownloadOriginalStatisticsReportResponseBodyDownloadParams()
            self.download_params = temp_model.from_map(m['DownloadParams'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DownloadOriginalStatisticsReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DownloadOriginalStatisticsReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DownloadOriginalStatisticsReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DownloadRecordingRequest(TeaModel):
    def __init__(self, instance_id=None, file_name=None, channel=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.file_name = TeaConverter.to_unicode(file_name)  # type: unicode
        self.channel = TeaConverter.to_unicode(channel)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.channel is not None:
            result['Channel'] = self.channel
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Channel') is not None:
            self.channel = m.get('Channel')
        return self


class DownloadRecordingResponseBodyMediaDownloadParam(TeaModel):
    def __init__(self, signature_url=None, file_name=None):
        self.signature_url = TeaConverter.to_unicode(signature_url)  # type: unicode
        self.file_name = TeaConverter.to_unicode(file_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.signature_url is not None:
            result['SignatureUrl'] = self.signature_url
        if self.file_name is not None:
            result['FileName'] = self.file_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SignatureUrl') is not None:
            self.signature_url = m.get('SignatureUrl')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        return self


class DownloadRecordingResponseBody(TeaModel):
    def __init__(self, media_download_param=None, message=None, request_id=None, http_status_code=None, code=None,
                 success=None):
        self.media_download_param = media_download_param  # type: DownloadRecordingResponseBodyMediaDownloadParam
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.media_download_param:
            self.media_download_param.validate()

    def to_map(self):
        result = dict()
        if self.media_download_param is not None:
            result['MediaDownloadParam'] = self.media_download_param.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaDownloadParam') is not None:
            temp_model = DownloadRecordingResponseBodyMediaDownloadParam()
            self.media_download_param = temp_model.from_map(m['MediaDownloadParam'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DownloadRecordingResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DownloadRecordingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DownloadRecordingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DownloadUnreachableContactsRequest(TeaModel):
    def __init__(self, instance_id=None, job_group_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.job_group_id = TeaConverter.to_unicode(job_group_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_group_id is not None:
            result['JobGroupId'] = self.job_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobGroupId') is not None:
            self.job_group_id = m.get('JobGroupId')
        return self


class DownloadUnreachableContactsResponseBodyDownloadParams(TeaModel):
    def __init__(self, signature_url=None):
        self.signature_url = TeaConverter.to_unicode(signature_url)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.signature_url is not None:
            result['SignatureUrl'] = self.signature_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SignatureUrl') is not None:
            self.signature_url = m.get('SignatureUrl')
        return self


class DownloadUnreachableContactsResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, download_params=None, http_status_code=None, code=None,
                 success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.download_params = download_params  # type: DownloadUnreachableContactsResponseBodyDownloadParams
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.download_params:
            self.download_params.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.download_params is not None:
            result['DownloadParams'] = self.download_params.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DownloadParams') is not None:
            temp_model = DownloadUnreachableContactsResponseBodyDownloadParams()
            self.download_params = temp_model.from_map(m['DownloadParams'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DownloadUnreachableContactsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DownloadUnreachableContactsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DownloadUnreachableContactsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FindUsersRequest(TeaModel):
    def __init__(self, instance_id=None, criteria=None, page_number=None, page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.criteria = TeaConverter.to_unicode(criteria)  # type: unicode
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class FindUsersResponseBodyUsersListUserSkillLevelsSkillLevelSkill(TeaModel):
    def __init__(self, skill_group_id=None, skill_group_name=None, instance_id=None, skill_group_description=None):
        self.skill_group_id = TeaConverter.to_unicode(skill_group_id)  # type: unicode
        self.skill_group_name = TeaConverter.to_unicode(skill_group_name)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.skill_group_description = TeaConverter.to_unicode(skill_group_description)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_description is not None:
            result['SkillGroupDescription'] = self.skill_group_description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupDescription') is not None:
            self.skill_group_description = m.get('SkillGroupDescription')
        return self


class FindUsersResponseBodyUsersListUserSkillLevelsSkillLevel(TeaModel):
    def __init__(self, skill=None, skill_level_id=None, level=None):
        self.skill = skill  # type: FindUsersResponseBodyUsersListUserSkillLevelsSkillLevelSkill
        self.skill_level_id = TeaConverter.to_unicode(skill_level_id)  # type: unicode
        self.level = level  # type: int

    def validate(self):
        if self.skill:
            self.skill.validate()

    def to_map(self):
        result = dict()
        if self.skill is not None:
            result['Skill'] = self.skill.to_map()
        if self.skill_level_id is not None:
            result['SkillLevelId'] = self.skill_level_id
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Skill') is not None:
            temp_model = FindUsersResponseBodyUsersListUserSkillLevelsSkillLevelSkill()
            self.skill = temp_model.from_map(m['Skill'])
        if m.get('SkillLevelId') is not None:
            self.skill_level_id = m.get('SkillLevelId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class FindUsersResponseBodyUsersListUserSkillLevels(TeaModel):
    def __init__(self, skill_level=None):
        self.skill_level = skill_level  # type: list[FindUsersResponseBodyUsersListUserSkillLevelsSkillLevel]

    def validate(self):
        if self.skill_level:
            for k in self.skill_level:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SkillLevel'] = []
        if self.skill_level is not None:
            for k in self.skill_level:
                result['SkillLevel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.skill_level = []
        if m.get('SkillLevel') is not None:
            for k in m.get('SkillLevel'):
                temp_model = FindUsersResponseBodyUsersListUserSkillLevelsSkillLevel()
                self.skill_level.append(temp_model.from_map(k))
        return self


class FindUsersResponseBodyUsersListUserRolesRole(TeaModel):
    def __init__(self, role_description=None, instance_id=None, role_name=None, role_id=None):
        self.role_description = TeaConverter.to_unicode(role_description)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.role_name = TeaConverter.to_unicode(role_name)  # type: unicode
        self.role_id = TeaConverter.to_unicode(role_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.role_description is not None:
            result['RoleDescription'] = self.role_description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RoleDescription') is not None:
            self.role_description = m.get('RoleDescription')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        return self


class FindUsersResponseBodyUsersListUserRoles(TeaModel):
    def __init__(self, role=None):
        self.role = role  # type: list[FindUsersResponseBodyUsersListUserRolesRole]

    def validate(self):
        if self.role:
            for k in self.role:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Role'] = []
        if self.role is not None:
            for k in self.role:
                result['Role'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.role = []
        if m.get('Role') is not None:
            for k in m.get('Role'):
                temp_model = FindUsersResponseBodyUsersListUserRolesRole()
                self.role.append(temp_model.from_map(k))
        return self


class FindUsersResponseBodyUsersListUserDetail(TeaModel):
    def __init__(self, display_name=None, email=None, login_name=None, department=None, phone=None):
        self.display_name = TeaConverter.to_unicode(display_name)  # type: unicode
        self.email = TeaConverter.to_unicode(email)  # type: unicode
        self.login_name = TeaConverter.to_unicode(login_name)  # type: unicode
        self.department = TeaConverter.to_unicode(department)  # type: unicode
        self.phone = TeaConverter.to_unicode(phone)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.department is not None:
            result['Department'] = self.department
        if self.phone is not None:
            result['Phone'] = self.phone
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('Phone') is not None:
            self.phone = m.get('Phone')
        return self


class FindUsersResponseBodyUsersListUser(TeaModel):
    def __init__(self, skill_levels=None, private_outbound_number_id=None, user_id=None, roles=None,
                 instance_id=None, ram_id=None, detail=None):
        self.skill_levels = skill_levels  # type: FindUsersResponseBodyUsersListUserSkillLevels
        self.private_outbound_number_id = TeaConverter.to_unicode(private_outbound_number_id)  # type: unicode
        self.user_id = TeaConverter.to_unicode(user_id)  # type: unicode
        self.roles = roles  # type: FindUsersResponseBodyUsersListUserRoles
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.ram_id = TeaConverter.to_unicode(ram_id)  # type: unicode
        self.detail = detail  # type: FindUsersResponseBodyUsersListUserDetail

    def validate(self):
        if self.skill_levels:
            self.skill_levels.validate()
        if self.roles:
            self.roles.validate()
        if self.detail:
            self.detail.validate()

    def to_map(self):
        result = dict()
        if self.skill_levels is not None:
            result['SkillLevels'] = self.skill_levels.to_map()
        if self.private_outbound_number_id is not None:
            result['PrivateOutboundNumberId'] = self.private_outbound_number_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.roles is not None:
            result['Roles'] = self.roles.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ram_id is not None:
            result['RamId'] = self.ram_id
        if self.detail is not None:
            result['Detail'] = self.detail.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SkillLevels') is not None:
            temp_model = FindUsersResponseBodyUsersListUserSkillLevels()
            self.skill_levels = temp_model.from_map(m['SkillLevels'])
        if m.get('PrivateOutboundNumberId') is not None:
            self.private_outbound_number_id = m.get('PrivateOutboundNumberId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Roles') is not None:
            temp_model = FindUsersResponseBodyUsersListUserRoles()
            self.roles = temp_model.from_map(m['Roles'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RamId') is not None:
            self.ram_id = m.get('RamId')
        if m.get('Detail') is not None:
            temp_model = FindUsersResponseBodyUsersListUserDetail()
            self.detail = temp_model.from_map(m['Detail'])
        return self


class FindUsersResponseBodyUsersList(TeaModel):
    def __init__(self, user=None):
        self.user = user  # type: list[FindUsersResponseBodyUsersListUser]

    def validate(self):
        if self.user:
            for k in self.user:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['User'] = []
        if self.user is not None:
            for k in self.user:
                result['User'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.user = []
        if m.get('User') is not None:
            for k in m.get('User'):
                temp_model = FindUsersResponseBodyUsersListUser()
                self.user.append(temp_model.from_map(k))
        return self


class FindUsersResponseBodyUsers(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: FindUsersResponseBodyUsersList
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = FindUsersResponseBodyUsersList()
            self.list = temp_model.from_map(m['List'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class FindUsersResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, users=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.users = users  # type: FindUsersResponseBodyUsers
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.users:
            self.users.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.users is not None:
            result['Users'] = self.users.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Users') is not None:
            temp_model = FindUsersResponseBodyUsers()
            self.users = temp_model.from_map(m['Users'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class FindUsersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: FindUsersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = FindUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateAgentStatisticReportRequest(TeaModel):
    def __init__(self, instance_id=None, agent_id=None, start_date=None, end_date=None, page_number=None,
                 page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.agent_id = TeaConverter.to_unicode(agent_id)  # type: unicode
        self.start_date = TeaConverter.to_unicode(start_date)  # type: unicode
        self.end_date = TeaConverter.to_unicode(end_date)  # type: unicode
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GenerateAgentStatisticReportResponseBodyDataListListGenerateAgentStatisticInbound(TeaModel):
    def __init__(self, total_talk_time=None, max_talk_time=None, average_talk_time=None, total_hold_time=None,
                 max_hold_time=None, average_hold_time=None, total_work_time=None, max_work_time=None, average_work_time=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, satisfaction_index=None, calls_offered=None,
                 calls_handled=None, handle_rate=None, total_ring_time=None, max_ring_time=None, average_ring_time=None):
        self.total_talk_time = total_talk_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.average_hold_time = average_hold_time  # type: long
        self.total_work_time = total_work_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.calls_offered = calls_offered  # type: long
        self.calls_handled = calls_handled  # type: long
        self.handle_rate = handle_rate  # type: float
        self.total_ring_time = total_ring_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.average_ring_time = average_ring_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        return self


class GenerateAgentStatisticReportResponseBodyDataListListGenerateAgentStatisticOutbound(TeaModel):
    def __init__(self, total_talk_time=None, max_talk_time=None, average_talk_time=None, total_hold_time=None,
                 max_hold_time=None, average_hold_time=None, total_work_time=None, max_work_time=None, average_work_time=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, satisfaction_index=None, calls_dialed=None,
                 calls_answered=None, answer_rate=None, total_dialing_time=None, max_dialing_time=None, average_dialing_time=None):
        self.total_talk_time = total_talk_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.average_hold_time = average_hold_time  # type: long
        self.total_work_time = total_work_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.calls_dialed = calls_dialed  # type: long
        self.calls_answered = calls_answered  # type: long
        self.answer_rate = answer_rate  # type: float
        self.total_dialing_time = total_dialing_time  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.average_dialing_time = average_dialing_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        return self


class GenerateAgentStatisticReportResponseBodyDataListListGenerateAgentStatisticOverall(TeaModel):
    def __init__(self, total_talk_time=None, max_talk_time=None, average_talk_time=None, total_hold_time=None,
                 max_hold_time=None, average_hold_time=None, total_work_time=None, max_work_time=None, average_work_time=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, satisfaction_index=None, total_calls=None):
        self.total_talk_time = total_talk_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.average_hold_time = average_hold_time  # type: long
        self.total_work_time = total_work_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class GenerateAgentStatisticReportResponseBodyDataListListGenerateAgentStatistic(TeaModel):
    def __init__(self, agent_id=None, login_name=None, agent_name=None, skill_group_ids=None,
                 skill_group_names=None, instance_id=None, record_date=None, total_logged_in_time=None, total_break_time=None,
                 occupancy_rate=None, total_ready_time=None, max_ready_time=None, average_ready_time=None, inbound=None,
                 outbound=None, overall=None):
        self.agent_id = TeaConverter.to_unicode(agent_id)  # type: unicode
        self.login_name = TeaConverter.to_unicode(login_name)  # type: unicode
        self.agent_name = TeaConverter.to_unicode(agent_name)  # type: unicode
        self.skill_group_ids = TeaConverter.to_unicode(skill_group_ids)  # type: unicode
        self.skill_group_names = TeaConverter.to_unicode(skill_group_names)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.record_date = TeaConverter.to_unicode(record_date)  # type: unicode
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.total_break_time = total_break_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.total_ready_time = total_ready_time  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.average_ready_time = average_ready_time  # type: long
        self.inbound = inbound  # type: GenerateAgentStatisticReportResponseBodyDataListListGenerateAgentStatisticInbound
        self.outbound = outbound  # type: GenerateAgentStatisticReportResponseBodyDataListListGenerateAgentStatisticOutbound
        self.overall = overall  # type: GenerateAgentStatisticReportResponseBodyDataListListGenerateAgentStatisticOverall

    def validate(self):
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()
        if self.overall:
            self.overall.validate()

    def to_map(self):
        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        if self.skill_group_ids is not None:
            result['SkillGroupIds'] = self.skill_group_ids
        if self.skill_group_names is not None:
            result['SkillGroupNames'] = self.skill_group_names
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.record_date is not None:
            result['RecordDate'] = self.record_date
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        if m.get('SkillGroupIds') is not None:
            self.skill_group_ids = m.get('SkillGroupIds')
        if m.get('SkillGroupNames') is not None:
            self.skill_group_names = m.get('SkillGroupNames')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RecordDate') is not None:
            self.record_date = m.get('RecordDate')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('Inbound') is not None:
            temp_model = GenerateAgentStatisticReportResponseBodyDataListListGenerateAgentStatisticInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = GenerateAgentStatisticReportResponseBodyDataListListGenerateAgentStatisticOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('Overall') is not None:
            temp_model = GenerateAgentStatisticReportResponseBodyDataListListGenerateAgentStatisticOverall()
            self.overall = temp_model.from_map(m['Overall'])
        return self


class GenerateAgentStatisticReportResponseBodyDataListList(TeaModel):
    def __init__(self, generate_agent_statistic=None):
        self.generate_agent_statistic = generate_agent_statistic  # type: list[GenerateAgentStatisticReportResponseBodyDataListListGenerateAgentStatistic]

    def validate(self):
        if self.generate_agent_statistic:
            for k in self.generate_agent_statistic:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['GenerateAgentStatistic'] = []
        if self.generate_agent_statistic is not None:
            for k in self.generate_agent_statistic:
                result['GenerateAgentStatistic'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.generate_agent_statistic = []
        if m.get('GenerateAgentStatistic') is not None:
            for k in m.get('GenerateAgentStatistic'):
                temp_model = GenerateAgentStatisticReportResponseBodyDataListListGenerateAgentStatistic()
                self.generate_agent_statistic.append(temp_model.from_map(k))
        return self


class GenerateAgentStatisticReportResponseBodyDataList(TeaModel):
    def __init__(self, total_count=None, page_number=None, page_size=None, list=None):
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.list = list  # type: GenerateAgentStatisticReportResponseBodyDataListList

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('List') is not None:
            temp_model = GenerateAgentStatisticReportResponseBodyDataListList()
            self.list = temp_model.from_map(m['List'])
        return self


class GenerateAgentStatisticReportResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, message=None, http_status_code=None, data_list=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.data_list = data_list  # type: GenerateAgentStatisticReportResponseBodyDataList

    def validate(self):
        if self.data_list:
            self.data_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data_list is not None:
            result['DataList'] = self.data_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('DataList') is not None:
            temp_model = GenerateAgentStatisticReportResponseBodyDataList()
            self.data_list = temp_model.from_map(m['DataList'])
        return self


class GenerateAgentStatisticReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GenerateAgentStatisticReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GenerateAgentStatisticReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAgentDataRequest(TeaModel):
    def __init__(self, instance_id=None, start_day=None, end_day=None, user_id=None, page_number=None,
                 page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.start_day = TeaConverter.to_unicode(start_day)  # type: unicode
        self.end_day = TeaConverter.to_unicode(end_day)  # type: unicode
        self.user_id = TeaConverter.to_unicode(user_id)  # type: unicode
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_day is not None:
            result['StartDay'] = self.start_day
        if self.end_day is not None:
            result['EndDay'] = self.end_day
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartDay') is not None:
            self.start_day = m.get('StartDay')
        if m.get('EndDay') is not None:
            self.end_day = m.get('EndDay')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetAgentDataResponseBodyDataListListInbound(TeaModel):
    def __init__(self, total_talk_time=None, max_talk_time=None, average_talk_time=None, total_hold_time=None,
                 max_hold_time=None, average_hold_time=None, total_work_time=None, max_work_time=None, average_work_time=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, satisfaction_index=None, calls_offered=None,
                 calls_handled=None, handle_rate=None, total_ring_time=None, max_ring_time=None, average_ring_time=None):
        self.total_talk_time = total_talk_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.average_hold_time = average_hold_time  # type: long
        self.total_work_time = total_work_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.calls_offered = calls_offered  # type: long
        self.calls_handled = calls_handled  # type: long
        self.handle_rate = handle_rate  # type: float
        self.total_ring_time = total_ring_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.average_ring_time = average_ring_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        return self


class GetAgentDataResponseBodyDataListListOutbound(TeaModel):
    def __init__(self, total_talk_time=None, max_talk_time=None, average_talk_time=None, total_hold_time=None,
                 max_hold_time=None, average_hold_time=None, total_work_time=None, max_work_time=None, average_work_time=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, satisfaction_index=None, calls_dialed=None,
                 calls_answered=None, answer_rate=None, total_dialing_time=None, max_dialing_time=None, average_dialing_time=None):
        self.total_talk_time = total_talk_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.average_hold_time = average_hold_time  # type: long
        self.total_work_time = total_work_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.calls_dialed = calls_dialed  # type: long
        self.calls_answered = calls_answered  # type: long
        self.answer_rate = answer_rate  # type: float
        self.total_dialing_time = total_dialing_time  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.average_dialing_time = average_dialing_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        return self


class GetAgentDataResponseBodyDataListListOverall(TeaModel):
    def __init__(self, total_talk_time=None, max_talk_time=None, average_talk_time=None, total_hold_time=None,
                 max_hold_time=None, average_hold_time=None, total_work_time=None, max_work_time=None, average_work_time=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, satisfaction_index=None, total_calls=None):
        self.total_talk_time = total_talk_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.average_hold_time = average_hold_time  # type: long
        self.total_work_time = total_work_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class GetAgentDataResponseBodyDataListList(TeaModel):
    def __init__(self, agent_id=None, login_name=None, agent_name=None, skill_group_ids=None,
                 skill_group_names=None, instance_id=None, record_date=None, total_logged_in_time=None, total_break_time=None,
                 occupancy_rate=None, total_ready_time=None, max_ready_time=None, average_ready_time=None, inbound=None,
                 outbound=None, overall=None):
        self.agent_id = TeaConverter.to_unicode(agent_id)  # type: unicode
        self.login_name = TeaConverter.to_unicode(login_name)  # type: unicode
        self.agent_name = TeaConverter.to_unicode(agent_name)  # type: unicode
        self.skill_group_ids = TeaConverter.to_unicode(skill_group_ids)  # type: unicode
        self.skill_group_names = TeaConverter.to_unicode(skill_group_names)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.record_date = TeaConverter.to_unicode(record_date)  # type: unicode
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.total_break_time = total_break_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.total_ready_time = total_ready_time  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.average_ready_time = average_ready_time  # type: long
        self.inbound = inbound  # type: GetAgentDataResponseBodyDataListListInbound
        self.outbound = outbound  # type: GetAgentDataResponseBodyDataListListOutbound
        self.overall = overall  # type: GetAgentDataResponseBodyDataListListOverall

    def validate(self):
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()
        if self.overall:
            self.overall.validate()

    def to_map(self):
        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        if self.skill_group_ids is not None:
            result['SkillGroupIds'] = self.skill_group_ids
        if self.skill_group_names is not None:
            result['SkillGroupNames'] = self.skill_group_names
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.record_date is not None:
            result['RecordDate'] = self.record_date
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        if m.get('SkillGroupIds') is not None:
            self.skill_group_ids = m.get('SkillGroupIds')
        if m.get('SkillGroupNames') is not None:
            self.skill_group_names = m.get('SkillGroupNames')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RecordDate') is not None:
            self.record_date = m.get('RecordDate')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('Inbound') is not None:
            temp_model = GetAgentDataResponseBodyDataListListInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = GetAgentDataResponseBodyDataListListOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('Overall') is not None:
            temp_model = GetAgentDataResponseBodyDataListListOverall()
            self.overall = temp_model.from_map(m['Overall'])
        return self


class GetAgentDataResponseBodyDataList(TeaModel):
    def __init__(self, total_count=None, page_number=None, page_size=None, list=None):
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.list = list  # type: list[GetAgentDataResponseBodyDataListList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetAgentDataResponseBodyDataListList()
                self.list.append(temp_model.from_map(k))
        return self


class GetAgentDataResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, message=None, http_status_code=None, data_list=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.data_list = data_list  # type: GetAgentDataResponseBodyDataList

    def validate(self):
        if self.data_list:
            self.data_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data_list is not None:
            result['DataList'] = self.data_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('DataList') is not None:
            temp_model = GetAgentDataResponseBodyDataList()
            self.data_list = temp_model.from_map(m['DataList'])
        return self


class GetAgentDataResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetAgentDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetAgentDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCallMeasureSummaryReportRequest(TeaModel):
    def __init__(self, interval_type=None, year=None, month=None, day=None, page_number=None, page_size=None):
        self.interval_type = TeaConverter.to_unicode(interval_type)  # type: unicode
        self.year = year  # type: int
        self.month = month  # type: int
        self.day = day  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.interval_type is not None:
            result['IntervalType'] = self.interval_type
        if self.year is not None:
            result['Year'] = self.year
        if self.month is not None:
            result['Month'] = self.month
        if self.day is not None:
            result['Day'] = self.day
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IntervalType') is not None:
            self.interval_type = m.get('IntervalType')
        if m.get('Year') is not None:
            self.year = m.get('Year')
        if m.get('Month') is not None:
            self.month = m.get('Month')
        if m.get('Day') is not None:
            self.day = m.get('Day')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetCallMeasureSummaryReportResponseBodyNumberReportsListNumberReport(TeaModel):
    def __init__(self, day=None, year=None, inbound_duration_by_minute=None, outbound_count=None,
                 outbound_duration_by_minute=None, number=None, inbound_count=None, month=None):
        self.day = day  # type: int
        self.year = year  # type: int
        self.inbound_duration_by_minute = inbound_duration_by_minute  # type: long
        self.outbound_count = outbound_count  # type: long
        self.outbound_duration_by_minute = outbound_duration_by_minute  # type: long
        self.number = TeaConverter.to_unicode(number)  # type: unicode
        self.inbound_count = inbound_count  # type: long
        self.month = month  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.day is not None:
            result['Day'] = self.day
        if self.year is not None:
            result['Year'] = self.year
        if self.inbound_duration_by_minute is not None:
            result['InboundDurationByMinute'] = self.inbound_duration_by_minute
        if self.outbound_count is not None:
            result['OutboundCount'] = self.outbound_count
        if self.outbound_duration_by_minute is not None:
            result['OutboundDurationByMinute'] = self.outbound_duration_by_minute
        if self.number is not None:
            result['Number'] = self.number
        if self.inbound_count is not None:
            result['InboundCount'] = self.inbound_count
        if self.month is not None:
            result['Month'] = self.month
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Day') is not None:
            self.day = m.get('Day')
        if m.get('Year') is not None:
            self.year = m.get('Year')
        if m.get('InboundDurationByMinute') is not None:
            self.inbound_duration_by_minute = m.get('InboundDurationByMinute')
        if m.get('OutboundCount') is not None:
            self.outbound_count = m.get('OutboundCount')
        if m.get('OutboundDurationByMinute') is not None:
            self.outbound_duration_by_minute = m.get('OutboundDurationByMinute')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('InboundCount') is not None:
            self.inbound_count = m.get('InboundCount')
        if m.get('Month') is not None:
            self.month = m.get('Month')
        return self


class GetCallMeasureSummaryReportResponseBodyNumberReportsList(TeaModel):
    def __init__(self, number_report=None):
        self.number_report = number_report  # type: list[GetCallMeasureSummaryReportResponseBodyNumberReportsListNumberReport]

    def validate(self):
        if self.number_report:
            for k in self.number_report:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['NumberReport'] = []
        if self.number_report is not None:
            for k in self.number_report:
                result['NumberReport'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.number_report = []
        if m.get('NumberReport') is not None:
            for k in m.get('NumberReport'):
                temp_model = GetCallMeasureSummaryReportResponseBodyNumberReportsListNumberReport()
                self.number_report.append(temp_model.from_map(k))
        return self


class GetCallMeasureSummaryReportResponseBodyNumberReports(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: GetCallMeasureSummaryReportResponseBodyNumberReportsList
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = GetCallMeasureSummaryReportResponseBodyNumberReportsList()
            self.list = temp_model.from_map(m['List'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetCallMeasureSummaryReportResponseBodySummaryReport(TeaModel):
    def __init__(self, day=None, year=None, inbound_duration_by_minute=None, outbound_count=None,
                 outbound_duration_by_minute=None, inbound_count=None, month=None):
        self.day = day  # type: int
        self.year = year  # type: int
        self.inbound_duration_by_minute = inbound_duration_by_minute  # type: long
        self.outbound_count = outbound_count  # type: long
        self.outbound_duration_by_minute = outbound_duration_by_minute  # type: long
        self.inbound_count = inbound_count  # type: long
        self.month = month  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.day is not None:
            result['Day'] = self.day
        if self.year is not None:
            result['Year'] = self.year
        if self.inbound_duration_by_minute is not None:
            result['InboundDurationByMinute'] = self.inbound_duration_by_minute
        if self.outbound_count is not None:
            result['OutboundCount'] = self.outbound_count
        if self.outbound_duration_by_minute is not None:
            result['OutboundDurationByMinute'] = self.outbound_duration_by_minute
        if self.inbound_count is not None:
            result['InboundCount'] = self.inbound_count
        if self.month is not None:
            result['Month'] = self.month
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Day') is not None:
            self.day = m.get('Day')
        if m.get('Year') is not None:
            self.year = m.get('Year')
        if m.get('InboundDurationByMinute') is not None:
            self.inbound_duration_by_minute = m.get('InboundDurationByMinute')
        if m.get('OutboundCount') is not None:
            self.outbound_count = m.get('OutboundCount')
        if m.get('OutboundDurationByMinute') is not None:
            self.outbound_duration_by_minute = m.get('OutboundDurationByMinute')
        if m.get('InboundCount') is not None:
            self.inbound_count = m.get('InboundCount')
        if m.get('Month') is not None:
            self.month = m.get('Month')
        return self


class GetCallMeasureSummaryReportResponseBody(TeaModel):
    def __init__(self, number_reports=None, summary_report=None, message=None, request_id=None,
                 http_status_code=None, code=None, success=None):
        self.number_reports = number_reports  # type: GetCallMeasureSummaryReportResponseBodyNumberReports
        self.summary_report = summary_report  # type: GetCallMeasureSummaryReportResponseBodySummaryReport
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.number_reports:
            self.number_reports.validate()
        if self.summary_report:
            self.summary_report.validate()

    def to_map(self):
        result = dict()
        if self.number_reports is not None:
            result['NumberReports'] = self.number_reports.to_map()
        if self.summary_report is not None:
            result['SummaryReport'] = self.summary_report.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NumberReports') is not None:
            temp_model = GetCallMeasureSummaryReportResponseBodyNumberReports()
            self.number_reports = temp_model.from_map(m['NumberReports'])
        if m.get('SummaryReport') is not None:
            temp_model = GetCallMeasureSummaryReportResponseBodySummaryReport()
            self.summary_report = temp_model.from_map(m['SummaryReport'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetCallMeasureSummaryReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetCallMeasureSummaryReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetCallMeasureSummaryReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetConfigRequest(TeaModel):
    def __init__(self, instance_id=None, name=None, object_id=None, object_type=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.object_id = TeaConverter.to_unicode(object_id)  # type: unicode
        self.object_type = TeaConverter.to_unicode(object_type)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.object_id is not None:
            result['ObjectId'] = self.object_id
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ObjectId') is not None:
            self.object_id = m.get('ObjectId')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        return self


class GetConfigResponseBodyConfigItem(TeaModel):
    def __init__(self, value=None, name=None):
        self.value = TeaConverter.to_unicode(value)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetConfigResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, config_item=None, code=None,
                 success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.config_item = config_item  # type: GetConfigResponseBodyConfigItem
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.config_item:
            self.config_item.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.config_item is not None:
            result['ConfigItem'] = self.config_item.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ConfigItem') is not None:
            temp_model = GetConfigResponseBodyConfigItem()
            self.config_item = temp_model.from_map(m['ConfigItem'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetConversationDetailByContactIdRequest(TeaModel):
    def __init__(self, instance_id=None, contact_id=None, page_number=None, page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.contact_id = TeaConverter.to_unicode(contact_id)  # type: unicode
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetConversationDetailByContactIdResponseBodyDataListListQualityCheckPhrase(TeaModel):
    def __init__(self, words=None, begin=None, identity=None, end=None, role=None):
        self.words = TeaConverter.to_unicode(words)  # type: unicode
        self.begin = begin  # type: long
        self.identity = TeaConverter.to_unicode(identity)  # type: unicode
        self.end = end  # type: long
        self.role = TeaConverter.to_unicode(role)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.words is not None:
            result['Words'] = self.words
        if self.begin is not None:
            result['Begin'] = self.begin
        if self.identity is not None:
            result['Identity'] = self.identity
        if self.end is not None:
            result['End'] = self.end
        if self.role is not None:
            result['Role'] = self.role
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Words') is not None:
            self.words = m.get('Words')
        if m.get('Begin') is not None:
            self.begin = m.get('Begin')
        if m.get('Identity') is not None:
            self.identity = m.get('Identity')
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        return self


class GetConversationDetailByContactIdResponseBodyDataListList(TeaModel):
    def __init__(self, quality_check_phrase=None):
        self.quality_check_phrase = quality_check_phrase  # type: list[GetConversationDetailByContactIdResponseBodyDataListListQualityCheckPhrase]

    def validate(self):
        if self.quality_check_phrase:
            for k in self.quality_check_phrase:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['QualityCheckPhrase'] = []
        if self.quality_check_phrase is not None:
            for k in self.quality_check_phrase:
                result['QualityCheckPhrase'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.quality_check_phrase = []
        if m.get('QualityCheckPhrase') is not None:
            for k in m.get('QualityCheckPhrase'):
                temp_model = GetConversationDetailByContactIdResponseBodyDataListListQualityCheckPhrase()
                self.quality_check_phrase.append(temp_model.from_map(k))
        return self


class GetConversationDetailByContactIdResponseBodyDataList(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: GetConversationDetailByContactIdResponseBodyDataListList
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = GetConversationDetailByContactIdResponseBodyDataListList()
            self.list = temp_model.from_map(m['List'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetConversationDetailByContactIdResponseBody(TeaModel):
    def __init__(self, data_list=None, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.data_list = data_list  # type: GetConversationDetailByContactIdResponseBodyDataList
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data_list:
            self.data_list.validate()

    def to_map(self):
        result = dict()
        if self.data_list is not None:
            result['DataList'] = self.data_list.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataList') is not None:
            temp_model = GetConversationDetailByContactIdResponseBodyDataList()
            self.data_list = temp_model.from_map(m['DataList'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetConversationDetailByContactIdResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetConversationDetailByContactIdResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetConversationDetailByContactIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetConversationListRequest(TeaModel):
    def __init__(self, instance_id=None, task_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetConversationListResponseBodyConversationsSummary(TeaModel):
    def __init__(self, summary_name=None, category=None, content=None):
        self.summary_name = TeaConverter.to_unicode(summary_name)  # type: unicode
        self.category = TeaConverter.to_unicode(category)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.summary_name is not None:
            result['SummaryName'] = self.summary_name
        if self.category is not None:
            result['Category'] = self.category
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SummaryName') is not None:
            self.summary_name = m.get('SummaryName')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class GetConversationListResponseBodyConversations(TeaModel):
    def __init__(self, summary=None, speaker=None, timestamp=None, script=None):
        self.summary = summary  # type: list[GetConversationListResponseBodyConversationsSummary]
        self.speaker = TeaConverter.to_unicode(speaker)  # type: unicode
        self.timestamp = timestamp  # type: long
        self.script = TeaConverter.to_unicode(script)  # type: unicode

    def validate(self):
        if self.summary:
            for k in self.summary:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Summary'] = []
        if self.summary is not None:
            for k in self.summary:
                result['Summary'].append(k.to_map() if k else None)
        if self.speaker is not None:
            result['Speaker'] = self.speaker
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.script is not None:
            result['Script'] = self.script
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.summary = []
        if m.get('Summary') is not None:
            for k in m.get('Summary'):
                temp_model = GetConversationListResponseBodyConversationsSummary()
                self.summary.append(temp_model.from_map(k))
        if m.get('Speaker') is not None:
            self.speaker = m.get('Speaker')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Script') is not None:
            self.script = m.get('Script')
        return self


class GetConversationListResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, conversations=None, code=None,
                 success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.conversations = conversations  # type: list[GetConversationListResponseBodyConversations]
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.conversations:
            for k in self.conversations:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        result['Conversations'] = []
        if self.conversations is not None:
            for k in self.conversations:
                result['Conversations'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        self.conversations = []
        if m.get('Conversations') is not None:
            for k in m.get('Conversations'):
                temp_model = GetConversationListResponseBodyConversations()
                self.conversations.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetConversationListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetConversationListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetConversationListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetInstanceResponseBodyInstancePhoneNumbersPhoneNumber(TeaModel):
    def __init__(self, test_only=None, trunks=None, remaining_time=None, number=None, instance_id=None, usage=None,
                 allow_outbound=None, phone_number_description=None, phone_number_id=None):
        self.test_only = test_only  # type: bool
        self.trunks = trunks  # type: int
        self.remaining_time = remaining_time  # type: int
        self.number = TeaConverter.to_unicode(number)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.usage = TeaConverter.to_unicode(usage)  # type: unicode
        self.allow_outbound = allow_outbound  # type: bool
        self.phone_number_description = TeaConverter.to_unicode(phone_number_description)  # type: unicode
        self.phone_number_id = TeaConverter.to_unicode(phone_number_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.test_only is not None:
            result['TestOnly'] = self.test_only
        if self.trunks is not None:
            result['Trunks'] = self.trunks
        if self.remaining_time is not None:
            result['RemainingTime'] = self.remaining_time
        if self.number is not None:
            result['Number'] = self.number
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.allow_outbound is not None:
            result['AllowOutbound'] = self.allow_outbound
        if self.phone_number_description is not None:
            result['PhoneNumberDescription'] = self.phone_number_description
        if self.phone_number_id is not None:
            result['PhoneNumberId'] = self.phone_number_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TestOnly') is not None:
            self.test_only = m.get('TestOnly')
        if m.get('Trunks') is not None:
            self.trunks = m.get('Trunks')
        if m.get('RemainingTime') is not None:
            self.remaining_time = m.get('RemainingTime')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('AllowOutbound') is not None:
            self.allow_outbound = m.get('AllowOutbound')
        if m.get('PhoneNumberDescription') is not None:
            self.phone_number_description = m.get('PhoneNumberDescription')
        if m.get('PhoneNumberId') is not None:
            self.phone_number_id = m.get('PhoneNumberId')
        return self


class GetInstanceResponseBodyInstancePhoneNumbers(TeaModel):
    def __init__(self, phone_number=None):
        self.phone_number = phone_number  # type: list[GetInstanceResponseBodyInstancePhoneNumbersPhoneNumber]

    def validate(self):
        if self.phone_number:
            for k in self.phone_number:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PhoneNumber'] = []
        if self.phone_number is not None:
            for k in self.phone_number:
                result['PhoneNumber'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.phone_number = []
        if m.get('PhoneNumber') is not None:
            for k in m.get('PhoneNumber'):
                temp_model = GetInstanceResponseBodyInstancePhoneNumbersPhoneNumber()
                self.phone_number.append(temp_model.from_map(k))
        return self


class GetInstanceResponseBodyInstanceAdminUserDetail(TeaModel):
    def __init__(self, display_name=None, email=None, login_name=None, department=None, phone=None):
        self.display_name = TeaConverter.to_unicode(display_name)  # type: unicode
        self.email = TeaConverter.to_unicode(email)  # type: unicode
        self.login_name = TeaConverter.to_unicode(login_name)  # type: unicode
        self.department = TeaConverter.to_unicode(department)  # type: unicode
        self.phone = TeaConverter.to_unicode(phone)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.department is not None:
            result['Department'] = self.department
        if self.phone is not None:
            result['Phone'] = self.phone
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('Phone') is not None:
            self.phone = m.get('Phone')
        return self


class GetInstanceResponseBodyInstanceAdminUser(TeaModel):
    def __init__(self, user_id=None, instance_id=None, ram_id=None, detail=None):
        self.user_id = TeaConverter.to_unicode(user_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.ram_id = TeaConverter.to_unicode(ram_id)  # type: unicode
        self.detail = detail  # type: GetInstanceResponseBodyInstanceAdminUserDetail

    def validate(self):
        if self.detail:
            self.detail.validate()

    def to_map(self):
        result = dict()
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ram_id is not None:
            result['RamId'] = self.ram_id
        if self.detail is not None:
            result['Detail'] = self.detail.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RamId') is not None:
            self.ram_id = m.get('RamId')
        if m.get('Detail') is not None:
            temp_model = GetInstanceResponseBodyInstanceAdminUserDetail()
            self.detail = temp_model.from_map(m['Detail'])
        return self


class GetInstanceResponseBodyInstanceAdmin(TeaModel):
    def __init__(self, user=None):
        self.user = user  # type: list[GetInstanceResponseBodyInstanceAdminUser]

    def validate(self):
        if self.user:
            for k in self.user:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['User'] = []
        if self.user is not None:
            for k in self.user:
                result['User'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.user = []
        if m.get('User') is not None:
            for k in m.get('User'):
                temp_model = GetInstanceResponseBodyInstanceAdminUser()
                self.user.append(temp_model.from_map(k))
        return self


class GetInstanceResponseBodyInstance(TeaModel):
    def __init__(self, status=None, owner=None, storage_max_size=None, storage_max_days=None,
                 max_online_agents=None, instance_id=None, domain_name=None, instance_description=None, phone_numbers=None,
                 console_url=None, storage_bucket=None, instance_name=None, created_time=None, directory_id=None, admin=None,
                 tenant_id=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.owner = TeaConverter.to_unicode(owner)  # type: unicode
        self.storage_max_size = storage_max_size  # type: int
        self.storage_max_days = storage_max_days  # type: int
        self.max_online_agents = max_online_agents  # type: int
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.domain_name = TeaConverter.to_unicode(domain_name)  # type: unicode
        self.instance_description = TeaConverter.to_unicode(instance_description)  # type: unicode
        self.phone_numbers = phone_numbers  # type: GetInstanceResponseBodyInstancePhoneNumbers
        self.console_url = TeaConverter.to_unicode(console_url)  # type: unicode
        self.storage_bucket = TeaConverter.to_unicode(storage_bucket)  # type: unicode
        self.instance_name = TeaConverter.to_unicode(instance_name)  # type: unicode
        self.created_time = created_time  # type: long
        self.directory_id = TeaConverter.to_unicode(directory_id)  # type: unicode
        self.admin = admin  # type: GetInstanceResponseBodyInstanceAdmin
        self.tenant_id = TeaConverter.to_unicode(tenant_id)  # type: unicode

    def validate(self):
        if self.phone_numbers:
            self.phone_numbers.validate()
        if self.admin:
            self.admin.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.storage_max_size is not None:
            result['StorageMaxSize'] = self.storage_max_size
        if self.storage_max_days is not None:
            result['StorageMaxDays'] = self.storage_max_days
        if self.max_online_agents is not None:
            result['MaxOnlineAgents'] = self.max_online_agents
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.instance_description is not None:
            result['InstanceDescription'] = self.instance_description
        if self.phone_numbers is not None:
            result['PhoneNumbers'] = self.phone_numbers.to_map()
        if self.console_url is not None:
            result['ConsoleUrl'] = self.console_url
        if self.storage_bucket is not None:
            result['StorageBucket'] = self.storage_bucket
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.admin is not None:
            result['Admin'] = self.admin.to_map()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('StorageMaxSize') is not None:
            self.storage_max_size = m.get('StorageMaxSize')
        if m.get('StorageMaxDays') is not None:
            self.storage_max_days = m.get('StorageMaxDays')
        if m.get('MaxOnlineAgents') is not None:
            self.max_online_agents = m.get('MaxOnlineAgents')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('InstanceDescription') is not None:
            self.instance_description = m.get('InstanceDescription')
        if m.get('PhoneNumbers') is not None:
            temp_model = GetInstanceResponseBodyInstancePhoneNumbers()
            self.phone_numbers = temp_model.from_map(m['PhoneNumbers'])
        if m.get('ConsoleUrl') is not None:
            self.console_url = m.get('ConsoleUrl')
        if m.get('StorageBucket') is not None:
            self.storage_bucket = m.get('StorageBucket')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('Admin') is not None:
            temp_model = GetInstanceResponseBodyInstanceAdmin()
            self.admin = temp_model.from_map(m['Admin'])
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetInstanceResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, instance=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.instance = instance  # type: GetInstanceResponseBodyInstance
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.instance:
            self.instance.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance is not None:
            result['Instance'] = self.instance.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Instance') is not None:
            temp_model = GetInstanceResponseBodyInstance()
            self.instance = temp_model.from_map(m['Instance'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceStateRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetInstanceStateResponseBodyRealTimeInstanceStateAgentStateDistributionsAgentStateCount(TeaModel):
    def __init__(self, state=None, count=None):
        self.state = TeaConverter.to_unicode(state)  # type: unicode
        self.count = count  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.state is not None:
            result['State'] = self.state
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetInstanceStateResponseBodyRealTimeInstanceStateAgentStateDistributions(TeaModel):
    def __init__(self, agent_state_count=None):
        self.agent_state_count = agent_state_count  # type: list[GetInstanceStateResponseBodyRealTimeInstanceStateAgentStateDistributionsAgentStateCount]

    def validate(self):
        if self.agent_state_count:
            for k in self.agent_state_count:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['AgentStateCount'] = []
        if self.agent_state_count is not None:
            for k in self.agent_state_count:
                result['AgentStateCount'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.agent_state_count = []
        if m.get('AgentStateCount') is not None:
            for k in m.get('AgentStateCount'):
                temp_model = GetInstanceStateResponseBodyRealTimeInstanceStateAgentStateDistributionsAgentStateCount()
                self.agent_state_count.append(temp_model.from_map(k))
        return self


class GetInstanceStateResponseBodyRealTimeInstanceState(TeaModel):
    def __init__(self, agent_state_distributions=None):
        self.agent_state_distributions = agent_state_distributions  # type: GetInstanceStateResponseBodyRealTimeInstanceStateAgentStateDistributions

    def validate(self):
        if self.agent_state_distributions:
            self.agent_state_distributions.validate()

    def to_map(self):
        result = dict()
        if self.agent_state_distributions is not None:
            result['AgentStateDistributions'] = self.agent_state_distributions.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentStateDistributions') is not None:
            temp_model = GetInstanceStateResponseBodyRealTimeInstanceStateAgentStateDistributions()
            self.agent_state_distributions = temp_model.from_map(m['AgentStateDistributions'])
        return self


class GetInstanceStateResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None,
                 real_time_instance_state=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool
        self.real_time_instance_state = real_time_instance_state  # type: GetInstanceStateResponseBodyRealTimeInstanceState

    def validate(self):
        if self.real_time_instance_state:
            self.real_time_instance_state.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        if self.real_time_instance_state is not None:
            result['RealTimeInstanceState'] = self.real_time_instance_state.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RealTimeInstanceState') is not None:
            temp_model = GetInstanceStateResponseBodyRealTimeInstanceState()
            self.real_time_instance_state = temp_model.from_map(m['RealTimeInstanceState'])
        return self


class GetInstanceStateResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetInstanceStateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceStateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceSummaryReportRequest(TeaModel):
    def __init__(self, instance_id=None, start_time=None, end_time=None, page_number=None, page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.start_time = TeaConverter.to_unicode(start_time)  # type: unicode
        self.end_time = TeaConverter.to_unicode(end_time)  # type: unicode
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetInstanceSummaryReportResponseBodyInstanceSummaryReportOverall(TeaModel):
    def __init__(self, total_talk_time=None, total_logged_in_time=None, occupancy_rate=None, total_work_time=None,
                 max_work_time=None, average_talk_time=None, average_work_time=None, satisfaction_index=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, average_ready_time=None, max_ready_time=None,
                 total_break_time=None, total_ready_time=None, max_talk_time=None, total_calls=None):
        self.total_talk_time = total_talk_time  # type: long
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.total_work_time = total_work_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.average_ready_time = average_ready_time  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.total_break_time = total_break_time  # type: long
        self.total_ready_time = total_ready_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class GetInstanceSummaryReportResponseBodyInstanceSummaryReportInbound(TeaModel):
    def __init__(self, calls_incoming_line=None, average_ring_time=None, calls_handled=None, total_work_time=None,
                 calls_abandoned_in_ivr=None, max_work_time=None, average_wait_time=None, calls_incoming_queue=None,
                 average_work_time=None, satisfaction_index=None, total_wait_time=None, total_ring_time=None, max_talk_time=None,
                 max_ring_time=None, total_talk_time=None, calls_incoming_ivr=None, calls_offered=None, max_wait_time=None,
                 service_level_20=None, average_talk_time=None, satisfaction_surveys_offered=None, handle_rate=None,
                 satisfaction_surveys_responded=None, calls_abandoned_in_queue=None):
        self.calls_incoming_line = calls_incoming_line  # type: long
        self.average_ring_time = average_ring_time  # type: long
        self.calls_handled = calls_handled  # type: long
        self.total_work_time = total_work_time  # type: long
        self.calls_abandoned_in_ivr = calls_abandoned_in_ivr  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_wait_time = average_wait_time  # type: long
        self.calls_incoming_queue = calls_incoming_queue  # type: long
        self.average_work_time = average_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.total_wait_time = total_wait_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.max_talk_time = TeaConverter.to_unicode(max_talk_time)  # type: unicode
        self.max_ring_time = max_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.calls_incoming_ivr = calls_incoming_ivr  # type: long
        self.calls_offered = calls_offered  # type: long
        self.max_wait_time = max_wait_time  # type: long
        self.service_level_20 = service_level_20  # type: float
        self.average_talk_time = average_talk_time  # type: long
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.handle_rate = handle_rate  # type: float
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.calls_abandoned_in_queue = calls_abandoned_in_queue  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.calls_incoming_line is not None:
            result['CallsIncomingLine'] = self.calls_incoming_line
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.calls_abandoned_in_ivr is not None:
            result['CallsAbandonedInIVR'] = self.calls_abandoned_in_ivr
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_wait_time is not None:
            result['AverageWaitTime'] = self.average_wait_time
        if self.calls_incoming_queue is not None:
            result['CallsIncomingQueue'] = self.calls_incoming_queue
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.total_wait_time is not None:
            result['TotalWaitTime'] = self.total_wait_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.calls_incoming_ivr is not None:
            result['CallsIncomingIVR'] = self.calls_incoming_ivr
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.max_wait_time is not None:
            result['MaxWaitTime'] = self.max_wait_time
        if self.service_level_20 is not None:
            result['ServiceLevel20'] = self.service_level_20
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.calls_abandoned_in_queue is not None:
            result['CallsAbandonedInQueue'] = self.calls_abandoned_in_queue
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallsIncomingLine') is not None:
            self.calls_incoming_line = m.get('CallsIncomingLine')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('CallsAbandonedInIVR') is not None:
            self.calls_abandoned_in_ivr = m.get('CallsAbandonedInIVR')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageWaitTime') is not None:
            self.average_wait_time = m.get('AverageWaitTime')
        if m.get('CallsIncomingQueue') is not None:
            self.calls_incoming_queue = m.get('CallsIncomingQueue')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('TotalWaitTime') is not None:
            self.total_wait_time = m.get('TotalWaitTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('CallsIncomingIVR') is not None:
            self.calls_incoming_ivr = m.get('CallsIncomingIVR')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('MaxWaitTime') is not None:
            self.max_wait_time = m.get('MaxWaitTime')
        if m.get('ServiceLevel20') is not None:
            self.service_level_20 = m.get('ServiceLevel20')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('CallsAbandonedInQueue') is not None:
            self.calls_abandoned_in_queue = m.get('CallsAbandonedInQueue')
        return self


class GetInstanceSummaryReportResponseBodyInstanceSummaryReportOutbound(TeaModel):
    def __init__(self, total_talk_time=None, max_dialing_time=None, calls_dialed=None, calls_answered=None,
                 total_work_time=None, answer_rate=None, max_work_time=None, total_dialing_time=None, average_work_time=None,
                 average_talk_time=None, satisfaction_index=None, satisfaction_surveys_offered=None,
                 satisfaction_surveys_responded=None, max_talk_time=None, average_dialing_time=None):
        self.total_talk_time = total_talk_time  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.calls_answered = calls_answered  # type: long
        self.total_work_time = total_work_time  # type: long
        self.answer_rate = answer_rate  # type: float
        self.max_work_time = max_work_time  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.average_dialing_time = average_dialing_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        return self


class GetInstanceSummaryReportResponseBodyInstanceSummaryReport(TeaModel):
    def __init__(self, overall=None, inbound=None, outbound=None, instance_id=None):
        self.overall = overall  # type: GetInstanceSummaryReportResponseBodyInstanceSummaryReportOverall
        self.inbound = inbound  # type: GetInstanceSummaryReportResponseBodyInstanceSummaryReportInbound
        self.outbound = outbound  # type: GetInstanceSummaryReportResponseBodyInstanceSummaryReportOutbound
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode

    def validate(self):
        if self.overall:
            self.overall.validate()
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()

    def to_map(self):
        result = dict()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Overall') is not None:
            temp_model = GetInstanceSummaryReportResponseBodyInstanceSummaryReportOverall()
            self.overall = temp_model.from_map(m['Overall'])
        if m.get('Inbound') is not None:
            temp_model = GetInstanceSummaryReportResponseBodyInstanceSummaryReportInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = GetInstanceSummaryReportResponseBodyInstanceSummaryReportOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetInstanceSummaryReportResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, instance_summary_report=None,
                 code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.instance_summary_report = instance_summary_report  # type: GetInstanceSummaryReportResponseBodyInstanceSummaryReport
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.instance_summary_report:
            self.instance_summary_report.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.instance_summary_report is not None:
            result['InstanceSummaryReport'] = self.instance_summary_report.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('InstanceSummaryReport') is not None:
            temp_model = GetInstanceSummaryReportResponseBodyInstanceSummaryReport()
            self.instance_summary_report = temp_model.from_map(m['InstanceSummaryReport'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetInstanceSummaryReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetInstanceSummaryReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceSummaryReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceSummaryReportByIntervalRequest(TeaModel):
    def __init__(self, instance_id=None, interval=None, start_time=None, end_time=None, page_number=None,
                 page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.interval = TeaConverter.to_unicode(interval)  # type: unicode
        self.start_time = TeaConverter.to_unicode(start_time)  # type: unicode
        self.end_time = TeaConverter.to_unicode(end_time)  # type: unicode
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetInstanceSummaryReportByIntervalResponseBodyInstanceTimeIntervalReportIntervalListInstanceSummaryReportOverall(TeaModel):
    def __init__(self, total_talk_time=None, total_logged_in_time=None, occupancy_rate=None, total_work_time=None,
                 max_work_time=None, average_talk_time=None, average_work_time=None, satisfaction_index=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, average_ready_time=None, max_ready_time=None,
                 total_break_time=None, total_ready_time=None, max_talk_time=None, total_calls=None):
        self.total_talk_time = total_talk_time  # type: long
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.total_work_time = total_work_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.average_ready_time = average_ready_time  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.total_break_time = total_break_time  # type: long
        self.total_ready_time = total_ready_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class GetInstanceSummaryReportByIntervalResponseBodyInstanceTimeIntervalReportIntervalListInstanceSummaryReportInbound(TeaModel):
    def __init__(self, calls_incoming_line=None, average_ring_time=None, calls_handled=None, total_work_time=None,
                 calls_abandoned_in_ivr=None, max_work_time=None, average_wait_time=None, calls_incoming_queue=None,
                 average_work_time=None, satisfaction_index=None, total_wait_time=None, total_ring_time=None, max_talk_time=None,
                 max_ring_time=None, total_talk_time=None, calls_incoming_ivr=None, calls_offered=None, max_wait_time=None,
                 service_level_20=None, average_talk_time=None, satisfaction_surveys_offered=None, handle_rate=None,
                 satisfaction_surveys_responded=None, calls_abandoned_in_queue=None):
        self.calls_incoming_line = calls_incoming_line  # type: long
        self.average_ring_time = average_ring_time  # type: long
        self.calls_handled = calls_handled  # type: long
        self.total_work_time = total_work_time  # type: long
        self.calls_abandoned_in_ivr = calls_abandoned_in_ivr  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_wait_time = average_wait_time  # type: long
        self.calls_incoming_queue = calls_incoming_queue  # type: long
        self.average_work_time = average_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.total_wait_time = total_wait_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.max_talk_time = TeaConverter.to_unicode(max_talk_time)  # type: unicode
        self.max_ring_time = max_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.calls_incoming_ivr = calls_incoming_ivr  # type: long
        self.calls_offered = calls_offered  # type: long
        self.max_wait_time = max_wait_time  # type: long
        self.service_level_20 = service_level_20  # type: float
        self.average_talk_time = average_talk_time  # type: long
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.handle_rate = handle_rate  # type: float
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.calls_abandoned_in_queue = calls_abandoned_in_queue  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.calls_incoming_line is not None:
            result['CallsIncomingLine'] = self.calls_incoming_line
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.calls_abandoned_in_ivr is not None:
            result['CallsAbandonedInIVR'] = self.calls_abandoned_in_ivr
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_wait_time is not None:
            result['AverageWaitTime'] = self.average_wait_time
        if self.calls_incoming_queue is not None:
            result['CallsIncomingQueue'] = self.calls_incoming_queue
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.total_wait_time is not None:
            result['TotalWaitTime'] = self.total_wait_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.calls_incoming_ivr is not None:
            result['CallsIncomingIVR'] = self.calls_incoming_ivr
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.max_wait_time is not None:
            result['MaxWaitTime'] = self.max_wait_time
        if self.service_level_20 is not None:
            result['ServiceLevel20'] = self.service_level_20
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.calls_abandoned_in_queue is not None:
            result['CallsAbandonedInQueue'] = self.calls_abandoned_in_queue
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallsIncomingLine') is not None:
            self.calls_incoming_line = m.get('CallsIncomingLine')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('CallsAbandonedInIVR') is not None:
            self.calls_abandoned_in_ivr = m.get('CallsAbandonedInIVR')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageWaitTime') is not None:
            self.average_wait_time = m.get('AverageWaitTime')
        if m.get('CallsIncomingQueue') is not None:
            self.calls_incoming_queue = m.get('CallsIncomingQueue')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('TotalWaitTime') is not None:
            self.total_wait_time = m.get('TotalWaitTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('CallsIncomingIVR') is not None:
            self.calls_incoming_ivr = m.get('CallsIncomingIVR')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('MaxWaitTime') is not None:
            self.max_wait_time = m.get('MaxWaitTime')
        if m.get('ServiceLevel20') is not None:
            self.service_level_20 = m.get('ServiceLevel20')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('CallsAbandonedInQueue') is not None:
            self.calls_abandoned_in_queue = m.get('CallsAbandonedInQueue')
        return self


class GetInstanceSummaryReportByIntervalResponseBodyInstanceTimeIntervalReportIntervalListInstanceSummaryReportOutbound(TeaModel):
    def __init__(self, total_talk_time=None, max_dialing_time=None, calls_dialed=None, calls_answered=None,
                 total_work_time=None, answer_rate=None, max_work_time=None, total_dialing_time=None, average_work_time=None,
                 average_talk_time=None, satisfaction_index=None, satisfaction_surveys_offered=None,
                 satisfaction_surveys_responded=None, max_talk_time=None, average_dialing_time=None):
        self.total_talk_time = total_talk_time  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.calls_answered = calls_answered  # type: long
        self.total_work_time = total_work_time  # type: long
        self.answer_rate = answer_rate  # type: float
        self.max_work_time = max_work_time  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.average_dialing_time = average_dialing_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        return self


class GetInstanceSummaryReportByIntervalResponseBodyInstanceTimeIntervalReportIntervalListInstanceSummaryReport(TeaModel):
    def __init__(self, overall=None, inbound=None, outbound=None, instance_id=None, timestamp=None):
        self.overall = overall  # type: GetInstanceSummaryReportByIntervalResponseBodyInstanceTimeIntervalReportIntervalListInstanceSummaryReportOverall
        self.inbound = inbound  # type: GetInstanceSummaryReportByIntervalResponseBodyInstanceTimeIntervalReportIntervalListInstanceSummaryReportInbound
        self.outbound = outbound  # type: GetInstanceSummaryReportByIntervalResponseBodyInstanceTimeIntervalReportIntervalListInstanceSummaryReportOutbound
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.timestamp = TeaConverter.to_unicode(timestamp)  # type: unicode

    def validate(self):
        if self.overall:
            self.overall.validate()
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()

    def to_map(self):
        result = dict()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Overall') is not None:
            temp_model = GetInstanceSummaryReportByIntervalResponseBodyInstanceTimeIntervalReportIntervalListInstanceSummaryReportOverall()
            self.overall = temp_model.from_map(m['Overall'])
        if m.get('Inbound') is not None:
            temp_model = GetInstanceSummaryReportByIntervalResponseBodyInstanceTimeIntervalReportIntervalListInstanceSummaryReportInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = GetInstanceSummaryReportByIntervalResponseBodyInstanceTimeIntervalReportIntervalListInstanceSummaryReportOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class GetInstanceSummaryReportByIntervalResponseBodyInstanceTimeIntervalReportIntervalList(TeaModel):
    def __init__(self, instance_summary_report=None):
        self.instance_summary_report = instance_summary_report  # type: list[GetInstanceSummaryReportByIntervalResponseBodyInstanceTimeIntervalReportIntervalListInstanceSummaryReport]

    def validate(self):
        if self.instance_summary_report:
            for k in self.instance_summary_report:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['InstanceSummaryReport'] = []
        if self.instance_summary_report is not None:
            for k in self.instance_summary_report:
                result['InstanceSummaryReport'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.instance_summary_report = []
        if m.get('InstanceSummaryReport') is not None:
            for k in m.get('InstanceSummaryReport'):
                temp_model = GetInstanceSummaryReportByIntervalResponseBodyInstanceTimeIntervalReportIntervalListInstanceSummaryReport()
                self.instance_summary_report.append(temp_model.from_map(k))
        return self


class GetInstanceSummaryReportByIntervalResponseBodyInstanceTimeIntervalReport(TeaModel):
    def __init__(self, instance_id=None, interval_list=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.interval_list = interval_list  # type: GetInstanceSummaryReportByIntervalResponseBodyInstanceTimeIntervalReportIntervalList

    def validate(self):
        if self.interval_list:
            self.interval_list.validate()

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.interval_list is not None:
            result['IntervalList'] = self.interval_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IntervalList') is not None:
            temp_model = GetInstanceSummaryReportByIntervalResponseBodyInstanceTimeIntervalReportIntervalList()
            self.interval_list = temp_model.from_map(m['IntervalList'])
        return self


class GetInstanceSummaryReportByIntervalResponseBody(TeaModel):
    def __init__(self, instance_time_interval_report=None, message=None, request_id=None, http_status_code=None,
                 code=None, success=None):
        self.instance_time_interval_report = instance_time_interval_report  # type: GetInstanceSummaryReportByIntervalResponseBodyInstanceTimeIntervalReport
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.instance_time_interval_report:
            self.instance_time_interval_report.validate()

    def to_map(self):
        result = dict()
        if self.instance_time_interval_report is not None:
            result['InstanceTimeIntervalReport'] = self.instance_time_interval_report.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceTimeIntervalReport') is not None:
            temp_model = GetInstanceSummaryReportByIntervalResponseBodyInstanceTimeIntervalReport()
            self.instance_time_interval_report = temp_model.from_map(m['InstanceTimeIntervalReport'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetInstanceSummaryReportByIntervalResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetInstanceSummaryReportByIntervalResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceSummaryReportByIntervalResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceSummaryReportSinceMidnightRequest(TeaModel):
    def __init__(self, instance_id=None, page_number=None, page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetInstanceSummaryReportSinceMidnightResponseBodyInstanceSummaryReportOverall(TeaModel):
    def __init__(self, total_talk_time=None, total_logged_in_time=None, occupancy_rate=None, total_work_time=None,
                 max_work_time=None, average_talk_time=None, average_work_time=None, satisfaction_index=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, average_ready_time=None, max_ready_time=None,
                 total_break_time=None, total_ready_time=None, max_talk_time=None, total_calls=None):
        self.total_talk_time = total_talk_time  # type: long
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.total_work_time = total_work_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.average_ready_time = average_ready_time  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.total_break_time = total_break_time  # type: long
        self.total_ready_time = total_ready_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class GetInstanceSummaryReportSinceMidnightResponseBodyInstanceSummaryReportInbound(TeaModel):
    def __init__(self, calls_incoming_line=None, average_ring_time=None, calls_handled=None, total_work_time=None,
                 calls_abandoned_in_ivr=None, max_work_time=None, average_wait_time=None, calls_incoming_queue=None,
                 average_work_time=None, satisfaction_index=None, total_wait_time=None, total_ring_time=None, max_talk_time=None,
                 max_ring_time=None, total_talk_time=None, calls_incoming_ivr=None, calls_offered=None, max_wait_time=None,
                 service_level_20=None, average_talk_time=None, satisfaction_surveys_offered=None, handle_rate=None,
                 satisfaction_surveys_responded=None, calls_abandoned_in_queue=None):
        self.calls_incoming_line = calls_incoming_line  # type: long
        self.average_ring_time = average_ring_time  # type: long
        self.calls_handled = calls_handled  # type: long
        self.total_work_time = total_work_time  # type: long
        self.calls_abandoned_in_ivr = calls_abandoned_in_ivr  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_wait_time = average_wait_time  # type: long
        self.calls_incoming_queue = calls_incoming_queue  # type: long
        self.average_work_time = average_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.total_wait_time = total_wait_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.max_talk_time = TeaConverter.to_unicode(max_talk_time)  # type: unicode
        self.max_ring_time = max_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.calls_incoming_ivr = calls_incoming_ivr  # type: long
        self.calls_offered = calls_offered  # type: long
        self.max_wait_time = max_wait_time  # type: long
        self.service_level_20 = service_level_20  # type: float
        self.average_talk_time = average_talk_time  # type: long
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.handle_rate = handle_rate  # type: float
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.calls_abandoned_in_queue = calls_abandoned_in_queue  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.calls_incoming_line is not None:
            result['CallsIncomingLine'] = self.calls_incoming_line
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.calls_abandoned_in_ivr is not None:
            result['CallsAbandonedInIVR'] = self.calls_abandoned_in_ivr
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_wait_time is not None:
            result['AverageWaitTime'] = self.average_wait_time
        if self.calls_incoming_queue is not None:
            result['CallsIncomingQueue'] = self.calls_incoming_queue
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.total_wait_time is not None:
            result['TotalWaitTime'] = self.total_wait_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.calls_incoming_ivr is not None:
            result['CallsIncomingIVR'] = self.calls_incoming_ivr
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.max_wait_time is not None:
            result['MaxWaitTime'] = self.max_wait_time
        if self.service_level_20 is not None:
            result['ServiceLevel20'] = self.service_level_20
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.calls_abandoned_in_queue is not None:
            result['CallsAbandonedInQueue'] = self.calls_abandoned_in_queue
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallsIncomingLine') is not None:
            self.calls_incoming_line = m.get('CallsIncomingLine')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('CallsAbandonedInIVR') is not None:
            self.calls_abandoned_in_ivr = m.get('CallsAbandonedInIVR')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageWaitTime') is not None:
            self.average_wait_time = m.get('AverageWaitTime')
        if m.get('CallsIncomingQueue') is not None:
            self.calls_incoming_queue = m.get('CallsIncomingQueue')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('TotalWaitTime') is not None:
            self.total_wait_time = m.get('TotalWaitTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('CallsIncomingIVR') is not None:
            self.calls_incoming_ivr = m.get('CallsIncomingIVR')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('MaxWaitTime') is not None:
            self.max_wait_time = m.get('MaxWaitTime')
        if m.get('ServiceLevel20') is not None:
            self.service_level_20 = m.get('ServiceLevel20')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('CallsAbandonedInQueue') is not None:
            self.calls_abandoned_in_queue = m.get('CallsAbandonedInQueue')
        return self


class GetInstanceSummaryReportSinceMidnightResponseBodyInstanceSummaryReportOutbound(TeaModel):
    def __init__(self, total_talk_time=None, max_dialing_time=None, calls_dialed=None, calls_answered=None,
                 total_work_time=None, answer_rate=None, max_work_time=None, total_dialing_time=None, average_work_time=None,
                 average_talk_time=None, satisfaction_index=None, satisfaction_surveys_offered=None,
                 satisfaction_surveys_responded=None, max_talk_time=None, average_dialing_time=None):
        self.total_talk_time = total_talk_time  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.calls_answered = calls_answered  # type: long
        self.total_work_time = total_work_time  # type: long
        self.answer_rate = answer_rate  # type: float
        self.max_work_time = max_work_time  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.average_dialing_time = average_dialing_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        return self


class GetInstanceSummaryReportSinceMidnightResponseBodyInstanceSummaryReport(TeaModel):
    def __init__(self, overall=None, inbound=None, outbound=None, instance_id=None, timestamp=None):
        self.overall = overall  # type: GetInstanceSummaryReportSinceMidnightResponseBodyInstanceSummaryReportOverall
        self.inbound = inbound  # type: GetInstanceSummaryReportSinceMidnightResponseBodyInstanceSummaryReportInbound
        self.outbound = outbound  # type: GetInstanceSummaryReportSinceMidnightResponseBodyInstanceSummaryReportOutbound
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.timestamp = TeaConverter.to_unicode(timestamp)  # type: unicode

    def validate(self):
        if self.overall:
            self.overall.validate()
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()

    def to_map(self):
        result = dict()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Overall') is not None:
            temp_model = GetInstanceSummaryReportSinceMidnightResponseBodyInstanceSummaryReportOverall()
            self.overall = temp_model.from_map(m['Overall'])
        if m.get('Inbound') is not None:
            temp_model = GetInstanceSummaryReportSinceMidnightResponseBodyInstanceSummaryReportInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = GetInstanceSummaryReportSinceMidnightResponseBodyInstanceSummaryReportOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class GetInstanceSummaryReportSinceMidnightResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, instance_summary_report=None,
                 code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.instance_summary_report = instance_summary_report  # type: GetInstanceSummaryReportSinceMidnightResponseBodyInstanceSummaryReport
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.instance_summary_report:
            self.instance_summary_report.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.instance_summary_report is not None:
            result['InstanceSummaryReport'] = self.instance_summary_report.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('InstanceSummaryReport') is not None:
            temp_model = GetInstanceSummaryReportSinceMidnightResponseBodyInstanceSummaryReport()
            self.instance_summary_report = temp_model.from_map(m['InstanceSummaryReport'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetInstanceSummaryReportSinceMidnightResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetInstanceSummaryReportSinceMidnightResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceSummaryReportSinceMidnightResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetJobRequest(TeaModel):
    def __init__(self, instance_id=None, job_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetJobResponseBodyJobContacts(TeaModel):
    def __init__(self, phone_number=None, contact_id=None, state=None, honorific=None, contact_name=None, role=None,
                 reference_id=None):
        self.phone_number = TeaConverter.to_unicode(phone_number)  # type: unicode
        self.contact_id = TeaConverter.to_unicode(contact_id)  # type: unicode
        self.state = TeaConverter.to_unicode(state)  # type: unicode
        self.honorific = TeaConverter.to_unicode(honorific)  # type: unicode
        self.contact_name = TeaConverter.to_unicode(contact_name)  # type: unicode
        self.role = TeaConverter.to_unicode(role)  # type: unicode
        self.reference_id = TeaConverter.to_unicode(reference_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.state is not None:
            result['State'] = self.state
        if self.honorific is not None:
            result['Honorific'] = self.honorific
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        if self.role is not None:
            result['Role'] = self.role
        if self.reference_id is not None:
            result['ReferenceId'] = self.reference_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Honorific') is not None:
            self.honorific = m.get('Honorific')
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('ReferenceId') is not None:
            self.reference_id = m.get('ReferenceId')
        return self


class GetJobResponseBodyJobSummary(TeaModel):
    def __init__(self, summary_name=None, category=None, content=None):
        self.summary_name = TeaConverter.to_unicode(summary_name)  # type: unicode
        self.category = TeaConverter.to_unicode(category)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.summary_name is not None:
            result['SummaryName'] = self.summary_name
        if self.category is not None:
            result['Category'] = self.category
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SummaryName') is not None:
            self.summary_name = m.get('SummaryName')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class GetJobResponseBodyJobExtras(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetJobResponseBodyJobTasksContact(TeaModel):
    def __init__(self, phone_number=None, contact_id=None, state=None, honorific=None, contact_name=None, role=None,
                 reference_id=None):
        self.phone_number = TeaConverter.to_unicode(phone_number)  # type: unicode
        self.contact_id = TeaConverter.to_unicode(contact_id)  # type: unicode
        self.state = TeaConverter.to_unicode(state)  # type: unicode
        self.honorific = TeaConverter.to_unicode(honorific)  # type: unicode
        self.contact_name = TeaConverter.to_unicode(contact_name)  # type: unicode
        self.role = TeaConverter.to_unicode(role)  # type: unicode
        self.reference_id = TeaConverter.to_unicode(reference_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.state is not None:
            result['State'] = self.state
        if self.honorific is not None:
            result['Honorific'] = self.honorific
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        if self.role is not None:
            result['Role'] = self.role
        if self.reference_id is not None:
            result['ReferenceId'] = self.reference_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Honorific') is not None:
            self.honorific = m.get('Honorific')
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('ReferenceId') is not None:
            self.reference_id = m.get('ReferenceId')
        return self


class GetJobResponseBodyJobTasksConversationSummary(TeaModel):
    def __init__(self, summary_name=None, category=None, content=None):
        self.summary_name = TeaConverter.to_unicode(summary_name)  # type: unicode
        self.category = TeaConverter.to_unicode(category)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.summary_name is not None:
            result['SummaryName'] = self.summary_name
        if self.category is not None:
            result['Category'] = self.category
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SummaryName') is not None:
            self.summary_name = m.get('SummaryName')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class GetJobResponseBodyJobTasksConversation(TeaModel):
    def __init__(self, summary=None, speaker=None, timestamp=None, script=None):
        self.summary = summary  # type: list[GetJobResponseBodyJobTasksConversationSummary]
        self.speaker = TeaConverter.to_unicode(speaker)  # type: unicode
        self.timestamp = timestamp  # type: long
        self.script = TeaConverter.to_unicode(script)  # type: unicode

    def validate(self):
        if self.summary:
            for k in self.summary:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Summary'] = []
        if self.summary is not None:
            for k in self.summary:
                result['Summary'].append(k.to_map() if k else None)
        if self.speaker is not None:
            result['Speaker'] = self.speaker
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.script is not None:
            result['Script'] = self.script
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.summary = []
        if m.get('Summary') is not None:
            for k in m.get('Summary'):
                temp_model = GetJobResponseBodyJobTasksConversationSummary()
                self.summary.append(temp_model.from_map(k))
        if m.get('Speaker') is not None:
            self.speaker = m.get('Speaker')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Script') is not None:
            self.script = m.get('Script')
        return self


class GetJobResponseBodyJobTasks(TeaModel):
    def __init__(self, status=None, planed_time=None, chatbot_id=None, actual_time=None, called_number=None,
                 scenario_id=None, contact=None, job_id=None, call_id=None, calling_number=None, brief=None, duration=None,
                 task_id=None, conversation=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.planed_time = planed_time  # type: long
        self.chatbot_id = TeaConverter.to_unicode(chatbot_id)  # type: unicode
        self.actual_time = actual_time  # type: long
        self.called_number = TeaConverter.to_unicode(called_number)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.contact = contact  # type: GetJobResponseBodyJobTasksContact
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.call_id = TeaConverter.to_unicode(call_id)  # type: unicode
        self.calling_number = TeaConverter.to_unicode(calling_number)  # type: unicode
        self.brief = TeaConverter.to_unicode(brief)  # type: unicode
        self.duration = duration  # type: int
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.conversation = conversation  # type: list[GetJobResponseBodyJobTasksConversation]

    def validate(self):
        if self.contact:
            self.contact.validate()
        if self.conversation:
            for k in self.conversation:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.planed_time is not None:
            result['PlanedTime'] = self.planed_time
        if self.chatbot_id is not None:
            result['ChatbotId'] = self.chatbot_id
        if self.actual_time is not None:
            result['ActualTime'] = self.actual_time
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.contact is not None:
            result['Contact'] = self.contact.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.brief is not None:
            result['Brief'] = self.brief
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        result['Conversation'] = []
        if self.conversation is not None:
            for k in self.conversation:
                result['Conversation'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PlanedTime') is not None:
            self.planed_time = m.get('PlanedTime')
        if m.get('ChatbotId') is not None:
            self.chatbot_id = m.get('ChatbotId')
        if m.get('ActualTime') is not None:
            self.actual_time = m.get('ActualTime')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('Contact') is not None:
            temp_model = GetJobResponseBodyJobTasksContact()
            self.contact = temp_model.from_map(m['Contact'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('Brief') is not None:
            self.brief = m.get('Brief')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        self.conversation = []
        if m.get('Conversation') is not None:
            for k in m.get('Conversation'):
                temp_model = GetJobResponseBodyJobTasksConversation()
                self.conversation.append(temp_model.from_map(k))
        return self


class GetJobResponseBodyJob(TeaModel):
    def __init__(self, status=None, calling_numbers=None, contacts=None, summary=None, priority=None,
                 failure_reason=None, system_priority=None, extras=None, reference_id=None, scenario_id=None, tasks=None,
                 strategy_id=None, group_id=None, job_id=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.calling_numbers = calling_numbers  # type: list[unicode]
        self.contacts = contacts  # type: list[GetJobResponseBodyJobContacts]
        self.summary = summary  # type: list[GetJobResponseBodyJobSummary]
        self.priority = priority  # type: int
        self.failure_reason = TeaConverter.to_unicode(failure_reason)  # type: unicode
        self.system_priority = system_priority  # type: int
        self.extras = extras  # type: list[GetJobResponseBodyJobExtras]
        self.reference_id = TeaConverter.to_unicode(reference_id)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.tasks = tasks  # type: list[GetJobResponseBodyJobTasks]
        self.strategy_id = TeaConverter.to_unicode(strategy_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        if self.contacts:
            for k in self.contacts:
                if k:
                    k.validate()
        if self.summary:
            for k in self.summary:
                if k:
                    k.validate()
        if self.extras:
            for k in self.extras:
                if k:
                    k.validate()
        if self.tasks:
            for k in self.tasks:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.calling_numbers is not None:
            result['CallingNumbers'] = self.calling_numbers
        result['Contacts'] = []
        if self.contacts is not None:
            for k in self.contacts:
                result['Contacts'].append(k.to_map() if k else None)
        result['Summary'] = []
        if self.summary is not None:
            for k in self.summary:
                result['Summary'].append(k.to_map() if k else None)
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.failure_reason is not None:
            result['FailureReason'] = self.failure_reason
        if self.system_priority is not None:
            result['SystemPriority'] = self.system_priority
        result['Extras'] = []
        if self.extras is not None:
            for k in self.extras:
                result['Extras'].append(k.to_map() if k else None)
        if self.reference_id is not None:
            result['ReferenceId'] = self.reference_id
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        result['Tasks'] = []
        if self.tasks is not None:
            for k in self.tasks:
                result['Tasks'].append(k.to_map() if k else None)
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CallingNumbers') is not None:
            self.calling_numbers = m.get('CallingNumbers')
        self.contacts = []
        if m.get('Contacts') is not None:
            for k in m.get('Contacts'):
                temp_model = GetJobResponseBodyJobContacts()
                self.contacts.append(temp_model.from_map(k))
        self.summary = []
        if m.get('Summary') is not None:
            for k in m.get('Summary'):
                temp_model = GetJobResponseBodyJobSummary()
                self.summary.append(temp_model.from_map(k))
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('FailureReason') is not None:
            self.failure_reason = m.get('FailureReason')
        if m.get('SystemPriority') is not None:
            self.system_priority = m.get('SystemPriority')
        self.extras = []
        if m.get('Extras') is not None:
            for k in m.get('Extras'):
                temp_model = GetJobResponseBodyJobExtras()
                self.extras.append(temp_model.from_map(k))
        if m.get('ReferenceId') is not None:
            self.reference_id = m.get('ReferenceId')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        self.tasks = []
        if m.get('Tasks') is not None:
            for k in m.get('Tasks'):
                temp_model = GetJobResponseBodyJobTasks()
                self.tasks.append(temp_model.from_map(k))
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetJobResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, job=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.job = job  # type: GetJobResponseBodyJob
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.job:
            self.job.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.job is not None:
            result['Job'] = self.job.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Job') is not None:
            temp_model = GetJobResponseBodyJob()
            self.job = temp_model.from_map(m['Job'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetJobDataUploadParamsRequest(TeaModel):
    def __init__(self, instance_id=None, file_name=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.file_name = TeaConverter.to_unicode(file_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        return self


class GetJobDataUploadParamsResponseBodyUploadParams(TeaModel):
    def __init__(self, signature=None, host=None, policy=None, folder=None, access_id=None, expire=None):
        self.signature = TeaConverter.to_unicode(signature)  # type: unicode
        self.host = TeaConverter.to_unicode(host)  # type: unicode
        self.policy = TeaConverter.to_unicode(policy)  # type: unicode
        self.folder = TeaConverter.to_unicode(folder)  # type: unicode
        self.access_id = TeaConverter.to_unicode(access_id)  # type: unicode
        self.expire = expire  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.host is not None:
            result['Host'] = self.host
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.folder is not None:
            result['Folder'] = self.folder
        if self.access_id is not None:
            result['AccessId'] = self.access_id
        if self.expire is not None:
            result['Expire'] = self.expire
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Folder') is not None:
            self.folder = m.get('Folder')
        if m.get('AccessId') is not None:
            self.access_id = m.get('AccessId')
        if m.get('Expire') is not None:
            self.expire = m.get('Expire')
        return self


class GetJobDataUploadParamsResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, upload_params=None, http_status_code=None, code=None,
                 success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.upload_params = upload_params  # type: GetJobDataUploadParamsResponseBodyUploadParams
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.upload_params:
            self.upload_params.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.upload_params is not None:
            result['UploadParams'] = self.upload_params.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UploadParams') is not None:
            temp_model = GetJobDataUploadParamsResponseBodyUploadParams()
            self.upload_params = temp_model.from_map(m['UploadParams'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetJobDataUploadParamsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetJobDataUploadParamsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetJobDataUploadParamsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetJobFileUploadUrlRequest(TeaModel):
    def __init__(self, instance_id=None, file_name=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.file_name = TeaConverter.to_unicode(file_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        return self


class GetJobFileUploadUrlResponseBody(TeaModel):
    def __init__(self, file_path=None, upload_url=None, request_id=None, message=None, http_status_code=None,
                 code=None, success=None):
        self.file_path = TeaConverter.to_unicode(file_path)  # type: unicode
        self.upload_url = TeaConverter.to_unicode(upload_url)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.upload_url is not None:
            result['UploadUrl'] = self.upload_url
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.message is not None:
            result['Message'] = self.message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('UploadUrl') is not None:
            self.upload_url = m.get('UploadUrl')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetJobFileUploadUrlResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetJobFileUploadUrlResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetJobFileUploadUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetJobGroupRequest(TeaModel):
    def __init__(self, instance_id=None, job_group_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.job_group_id = TeaConverter.to_unicode(job_group_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_group_id is not None:
            result['JobGroupId'] = self.job_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobGroupId') is not None:
            self.job_group_id = m.get('JobGroupId')
        return self


class GetJobGroupResponseBodyJobGroupStrategyWorkingTime(TeaModel):
    def __init__(self, end_time=None, begin_time=None):
        self.end_time = TeaConverter.to_unicode(end_time)  # type: unicode
        self.begin_time = TeaConverter.to_unicode(begin_time)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.begin_time is not None:
            result['BeginTime'] = self.begin_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('BeginTime') is not None:
            self.begin_time = m.get('BeginTime')
        return self


class GetJobGroupResponseBodyJobGroupStrategy(TeaModel):
    def __init__(self, type=None, max_attempts_per_day=None, working_time=None, follow_up_strategy=None,
                 end_time=None, customized=None, start_time=None, is_template=None, repeat_days=None, routing_strategy=None,
                 description=None, min_attempt_interval=None, repeat_by=None, name=None, id=None):
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.max_attempts_per_day = max_attempts_per_day  # type: int
        self.working_time = working_time  # type: list[GetJobGroupResponseBodyJobGroupStrategyWorkingTime]
        self.follow_up_strategy = TeaConverter.to_unicode(follow_up_strategy)  # type: unicode
        self.end_time = end_time  # type: long
        self.customized = TeaConverter.to_unicode(customized)  # type: unicode
        self.start_time = start_time  # type: long
        self.is_template = is_template  # type: bool
        self.repeat_days = repeat_days  # type: list[unicode]
        self.routing_strategy = TeaConverter.to_unicode(routing_strategy)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.min_attempt_interval = min_attempt_interval  # type: int
        self.repeat_by = TeaConverter.to_unicode(repeat_by)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.id = TeaConverter.to_unicode(id)  # type: unicode

    def validate(self):
        if self.working_time:
            for k in self.working_time:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.max_attempts_per_day is not None:
            result['MaxAttemptsPerDay'] = self.max_attempts_per_day
        result['WorkingTime'] = []
        if self.working_time is not None:
            for k in self.working_time:
                result['WorkingTime'].append(k.to_map() if k else None)
        if self.follow_up_strategy is not None:
            result['FollowUpStrategy'] = self.follow_up_strategy
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.customized is not None:
            result['Customized'] = self.customized
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.is_template is not None:
            result['IsTemplate'] = self.is_template
        if self.repeat_days is not None:
            result['RepeatDays'] = self.repeat_days
        if self.routing_strategy is not None:
            result['RoutingStrategy'] = self.routing_strategy
        if self.description is not None:
            result['Description'] = self.description
        if self.min_attempt_interval is not None:
            result['MinAttemptInterval'] = self.min_attempt_interval
        if self.repeat_by is not None:
            result['RepeatBy'] = self.repeat_by
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('MaxAttemptsPerDay') is not None:
            self.max_attempts_per_day = m.get('MaxAttemptsPerDay')
        self.working_time = []
        if m.get('WorkingTime') is not None:
            for k in m.get('WorkingTime'):
                temp_model = GetJobGroupResponseBodyJobGroupStrategyWorkingTime()
                self.working_time.append(temp_model.from_map(k))
        if m.get('FollowUpStrategy') is not None:
            self.follow_up_strategy = m.get('FollowUpStrategy')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Customized') is not None:
            self.customized = m.get('Customized')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('IsTemplate') is not None:
            self.is_template = m.get('IsTemplate')
        if m.get('RepeatDays') is not None:
            self.repeat_days = m.get('RepeatDays')
        if m.get('RoutingStrategy') is not None:
            self.routing_strategy = m.get('RoutingStrategy')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MinAttemptInterval') is not None:
            self.min_attempt_interval = m.get('MinAttemptInterval')
        if m.get('RepeatBy') is not None:
            self.repeat_by = m.get('RepeatBy')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetJobGroupResponseBodyJobGroupProgressCategories(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetJobGroupResponseBodyJobGroupProgress(TeaModel):
    def __init__(self, status=None, total_not_answered=None, start_time=None, categories=None, total_jobs=None,
                 total_completed=None, duration=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.total_not_answered = total_not_answered  # type: int
        self.start_time = start_time  # type: long
        self.categories = categories  # type: list[GetJobGroupResponseBodyJobGroupProgressCategories]
        self.total_jobs = total_jobs  # type: int
        self.total_completed = total_completed  # type: int
        self.duration = duration  # type: int

    def validate(self):
        if self.categories:
            for k in self.categories:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.total_not_answered is not None:
            result['TotalNotAnswered'] = self.total_not_answered
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        result['Categories'] = []
        if self.categories is not None:
            for k in self.categories:
                result['Categories'].append(k.to_map() if k else None)
        if self.total_jobs is not None:
            result['TotalJobs'] = self.total_jobs
        if self.total_completed is not None:
            result['TotalCompleted'] = self.total_completed
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TotalNotAnswered') is not None:
            self.total_not_answered = m.get('TotalNotAnswered')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        self.categories = []
        if m.get('Categories') is not None:
            for k in m.get('Categories'):
                temp_model = GetJobGroupResponseBodyJobGroupProgressCategories()
                self.categories.append(temp_model.from_map(k))
        if m.get('TotalJobs') is not None:
            self.total_jobs = m.get('TotalJobs')
        if m.get('TotalCompleted') is not None:
            self.total_completed = m.get('TotalCompleted')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class GetJobGroupResponseBodyJobGroup(TeaModel):
    def __init__(self, scenario_id=None, creation_time=None, strategy=None, calling_numbers=None, progress=None,
                 description=None, job_file_path=None, name=None, id=None):
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.creation_time = creation_time  # type: long
        self.strategy = strategy  # type: GetJobGroupResponseBodyJobGroupStrategy
        self.calling_numbers = calling_numbers  # type: list[unicode]
        self.progress = progress  # type: GetJobGroupResponseBodyJobGroupProgress
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.job_file_path = TeaConverter.to_unicode(job_file_path)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.id = TeaConverter.to_unicode(id)  # type: unicode

    def validate(self):
        if self.strategy:
            self.strategy.validate()
        if self.progress:
            self.progress.validate()

    def to_map(self):
        result = dict()
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.strategy is not None:
            result['Strategy'] = self.strategy.to_map()
        if self.calling_numbers is not None:
            result['CallingNumbers'] = self.calling_numbers
        if self.progress is not None:
            result['Progress'] = self.progress.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.job_file_path is not None:
            result['JobFilePath'] = self.job_file_path
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Strategy') is not None:
            temp_model = GetJobGroupResponseBodyJobGroupStrategy()
            self.strategy = temp_model.from_map(m['Strategy'])
        if m.get('CallingNumbers') is not None:
            self.calling_numbers = m.get('CallingNumbers')
        if m.get('Progress') is not None:
            temp_model = GetJobGroupResponseBodyJobGroupProgress()
            self.progress = temp_model.from_map(m['Progress'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('JobFilePath') is not None:
            self.job_file_path = m.get('JobFilePath')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetJobGroupResponseBody(TeaModel):
    def __init__(self, job_group=None, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.job_group = job_group  # type: GetJobGroupResponseBodyJobGroup
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.job_group:
            self.job_group.validate()

    def to_map(self):
        result = dict()
        if self.job_group is not None:
            result['JobGroup'] = self.job_group.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobGroup') is not None:
            temp_model = GetJobGroupResponseBodyJobGroup()
            self.job_group = temp_model.from_map(m['JobGroup'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetJobGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetJobGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetJobGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetJobListRequest(TeaModel):
    def __init__(self, instance_id=None, job_group_id=None, status=None, query_all=None, page_number=None,
                 page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.job_group_id = TeaConverter.to_unicode(job_group_id)  # type: unicode
        self.status = status  # type: int
        self.query_all = query_all  # type: bool
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_group_id is not None:
            result['JobGroupId'] = self.job_group_id
        if self.status is not None:
            result['Status'] = self.status
        if self.query_all is not None:
            result['QueryAll'] = self.query_all
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobGroupId') is not None:
            self.job_group_id = m.get('JobGroupId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('QueryAll') is not None:
            self.query_all = m.get('QueryAll')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetJobListResponseBodyJobsListSummary(TeaModel):
    def __init__(self, summary_name=None, group_id=None, job_id=None, category=None, content=None, summary_id=None,
                 task_id=None, conversation_detail_id=None):
        self.summary_name = TeaConverter.to_unicode(summary_name)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.category = TeaConverter.to_unicode(category)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode
        self.summary_id = TeaConverter.to_unicode(summary_id)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.conversation_detail_id = TeaConverter.to_unicode(conversation_detail_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.summary_name is not None:
            result['SummaryName'] = self.summary_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.category is not None:
            result['Category'] = self.category
        if self.content is not None:
            result['Content'] = self.content
        if self.summary_id is not None:
            result['SummaryId'] = self.summary_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.conversation_detail_id is not None:
            result['ConversationDetailId'] = self.conversation_detail_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SummaryName') is not None:
            self.summary_name = m.get('SummaryName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('SummaryId') is not None:
            self.summary_id = m.get('SummaryId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ConversationDetailId') is not None:
            self.conversation_detail_id = m.get('ConversationDetailId')
        return self


class GetJobListResponseBodyJobsListContacts(TeaModel):
    def __init__(self, phone_number=None, contact_id=None, state=None, job_id=None, honorific=None,
                 contact_name=None, role=None, reference_id=None):
        self.phone_number = TeaConverter.to_unicode(phone_number)  # type: unicode
        self.contact_id = TeaConverter.to_unicode(contact_id)  # type: unicode
        self.state = TeaConverter.to_unicode(state)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.honorific = TeaConverter.to_unicode(honorific)  # type: unicode
        self.contact_name = TeaConverter.to_unicode(contact_name)  # type: unicode
        self.role = TeaConverter.to_unicode(role)  # type: unicode
        self.reference_id = TeaConverter.to_unicode(reference_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.state is not None:
            result['State'] = self.state
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.honorific is not None:
            result['Honorific'] = self.honorific
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        if self.role is not None:
            result['Role'] = self.role
        if self.reference_id is not None:
            result['ReferenceId'] = self.reference_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Honorific') is not None:
            self.honorific = m.get('Honorific')
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('ReferenceId') is not None:
            self.reference_id = m.get('ReferenceId')
        return self


class GetJobListResponseBodyJobsListExtras(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetJobListResponseBodyJobsList(TeaModel):
    def __init__(self, status=None, calling_numbers=None, summary=None, contacts=None, priority=None,
                 failure_reason=None, system_priority=None, extras=None, reference_id=None, scenario_id=None, strategy_id=None,
                 group_id=None, job_id=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.calling_numbers = calling_numbers  # type: list[unicode]
        self.summary = summary  # type: list[GetJobListResponseBodyJobsListSummary]
        self.contacts = contacts  # type: list[GetJobListResponseBodyJobsListContacts]
        self.priority = priority  # type: int
        self.failure_reason = TeaConverter.to_unicode(failure_reason)  # type: unicode
        self.system_priority = system_priority  # type: int
        self.extras = extras  # type: list[GetJobListResponseBodyJobsListExtras]
        self.reference_id = TeaConverter.to_unicode(reference_id)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.strategy_id = TeaConverter.to_unicode(strategy_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        if self.summary:
            for k in self.summary:
                if k:
                    k.validate()
        if self.contacts:
            for k in self.contacts:
                if k:
                    k.validate()
        if self.extras:
            for k in self.extras:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.calling_numbers is not None:
            result['CallingNumbers'] = self.calling_numbers
        result['Summary'] = []
        if self.summary is not None:
            for k in self.summary:
                result['Summary'].append(k.to_map() if k else None)
        result['Contacts'] = []
        if self.contacts is not None:
            for k in self.contacts:
                result['Contacts'].append(k.to_map() if k else None)
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.failure_reason is not None:
            result['FailureReason'] = self.failure_reason
        if self.system_priority is not None:
            result['SystemPriority'] = self.system_priority
        result['Extras'] = []
        if self.extras is not None:
            for k in self.extras:
                result['Extras'].append(k.to_map() if k else None)
        if self.reference_id is not None:
            result['ReferenceId'] = self.reference_id
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CallingNumbers') is not None:
            self.calling_numbers = m.get('CallingNumbers')
        self.summary = []
        if m.get('Summary') is not None:
            for k in m.get('Summary'):
                temp_model = GetJobListResponseBodyJobsListSummary()
                self.summary.append(temp_model.from_map(k))
        self.contacts = []
        if m.get('Contacts') is not None:
            for k in m.get('Contacts'):
                temp_model = GetJobListResponseBodyJobsListContacts()
                self.contacts.append(temp_model.from_map(k))
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('FailureReason') is not None:
            self.failure_reason = m.get('FailureReason')
        if m.get('SystemPriority') is not None:
            self.system_priority = m.get('SystemPriority')
        self.extras = []
        if m.get('Extras') is not None:
            for k in m.get('Extras'):
                temp_model = GetJobListResponseBodyJobsListExtras()
                self.extras.append(temp_model.from_map(k))
        if m.get('ReferenceId') is not None:
            self.reference_id = m.get('ReferenceId')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetJobListResponseBodyJobs(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[GetJobListResponseBodyJobsList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetJobListResponseBodyJobsList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetJobListResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, jobs=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.jobs = jobs  # type: GetJobListResponseBodyJobs
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.jobs:
            self.jobs.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.jobs is not None:
            result['Jobs'] = self.jobs.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Jobs') is not None:
            temp_model = GetJobListResponseBodyJobs()
            self.jobs = temp_model.from_map(m['Jobs'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetJobListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetJobListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetJobStatusByCallIdRequest(TeaModel):
    def __init__(self, instance_id=None, call_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.call_id = TeaConverter.to_unicode(call_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.call_id is not None:
            result['CallId'] = self.call_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        return self


class GetJobStatusByCallIdResponseBodyJobContacts(TeaModel):
    def __init__(self, phone_number=None, contact_id=None, state=None, job_id=None, honorific=None,
                 contact_name=None, role=None, reference_id=None):
        self.phone_number = TeaConverter.to_unicode(phone_number)  # type: unicode
        self.contact_id = TeaConverter.to_unicode(contact_id)  # type: unicode
        self.state = TeaConverter.to_unicode(state)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.honorific = TeaConverter.to_unicode(honorific)  # type: unicode
        self.contact_name = TeaConverter.to_unicode(contact_name)  # type: unicode
        self.role = TeaConverter.to_unicode(role)  # type: unicode
        self.reference_id = TeaConverter.to_unicode(reference_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.state is not None:
            result['State'] = self.state
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.honorific is not None:
            result['Honorific'] = self.honorific
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        if self.role is not None:
            result['Role'] = self.role
        if self.reference_id is not None:
            result['ReferenceId'] = self.reference_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Honorific') is not None:
            self.honorific = m.get('Honorific')
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('ReferenceId') is not None:
            self.reference_id = m.get('ReferenceId')
        return self


class GetJobStatusByCallIdResponseBodyJobSummary(TeaModel):
    def __init__(self, summary_name=None, category=None, content=None, summary_id=None):
        self.summary_name = TeaConverter.to_unicode(summary_name)  # type: unicode
        self.category = TeaConverter.to_unicode(category)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode
        self.summary_id = TeaConverter.to_unicode(summary_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.summary_name is not None:
            result['SummaryName'] = self.summary_name
        if self.category is not None:
            result['Category'] = self.category
        if self.content is not None:
            result['Content'] = self.content
        if self.summary_id is not None:
            result['SummaryId'] = self.summary_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SummaryName') is not None:
            self.summary_name = m.get('SummaryName')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('SummaryId') is not None:
            self.summary_id = m.get('SummaryId')
        return self


class GetJobStatusByCallIdResponseBodyJobExtras(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetJobStatusByCallIdResponseBodyJobTasksContact(TeaModel):
    def __init__(self, phone_number=None, contact_id=None, state=None, job_id=None, honorific=None,
                 contact_name=None, role=None, reference_id=None):
        self.phone_number = TeaConverter.to_unicode(phone_number)  # type: unicode
        self.contact_id = TeaConverter.to_unicode(contact_id)  # type: unicode
        self.state = TeaConverter.to_unicode(state)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.honorific = TeaConverter.to_unicode(honorific)  # type: unicode
        self.contact_name = TeaConverter.to_unicode(contact_name)  # type: unicode
        self.role = TeaConverter.to_unicode(role)  # type: unicode
        self.reference_id = TeaConverter.to_unicode(reference_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.state is not None:
            result['State'] = self.state
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.honorific is not None:
            result['Honorific'] = self.honorific
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        if self.role is not None:
            result['Role'] = self.role
        if self.reference_id is not None:
            result['ReferenceId'] = self.reference_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Honorific') is not None:
            self.honorific = m.get('Honorific')
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('ReferenceId') is not None:
            self.reference_id = m.get('ReferenceId')
        return self


class GetJobStatusByCallIdResponseBodyJobTasksConversationSummary(TeaModel):
    def __init__(self, summary_name=None, category=None, content=None, summary_id=None):
        self.summary_name = TeaConverter.to_unicode(summary_name)  # type: unicode
        self.category = TeaConverter.to_unicode(category)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode
        self.summary_id = TeaConverter.to_unicode(summary_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.summary_name is not None:
            result['SummaryName'] = self.summary_name
        if self.category is not None:
            result['Category'] = self.category
        if self.content is not None:
            result['Content'] = self.content
        if self.summary_id is not None:
            result['SummaryId'] = self.summary_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SummaryName') is not None:
            self.summary_name = m.get('SummaryName')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('SummaryId') is not None:
            self.summary_id = m.get('SummaryId')
        return self


class GetJobStatusByCallIdResponseBodyJobTasksConversation(TeaModel):
    def __init__(self, summary=None, speaker=None, timestamp=None, script=None, task_id=None,
                 conversation_detail_id=None):
        self.summary = summary  # type: list[GetJobStatusByCallIdResponseBodyJobTasksConversationSummary]
        self.speaker = TeaConverter.to_unicode(speaker)  # type: unicode
        self.timestamp = timestamp  # type: long
        self.script = TeaConverter.to_unicode(script)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.conversation_detail_id = TeaConverter.to_unicode(conversation_detail_id)  # type: unicode

    def validate(self):
        if self.summary:
            for k in self.summary:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Summary'] = []
        if self.summary is not None:
            for k in self.summary:
                result['Summary'].append(k.to_map() if k else None)
        if self.speaker is not None:
            result['Speaker'] = self.speaker
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.script is not None:
            result['Script'] = self.script
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.conversation_detail_id is not None:
            result['ConversationDetailId'] = self.conversation_detail_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.summary = []
        if m.get('Summary') is not None:
            for k in m.get('Summary'):
                temp_model = GetJobStatusByCallIdResponseBodyJobTasksConversationSummary()
                self.summary.append(temp_model.from_map(k))
        if m.get('Speaker') is not None:
            self.speaker = m.get('Speaker')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Script') is not None:
            self.script = m.get('Script')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ConversationDetailId') is not None:
            self.conversation_detail_id = m.get('ConversationDetailId')
        return self


class GetJobStatusByCallIdResponseBodyJobTasks(TeaModel):
    def __init__(self, status=None, planed_time=None, chatbot_id=None, actual_time=None, called_number=None,
                 end_time=None, scenario_id=None, contact=None, job_id=None, call_id=None, calling_number=None, brief=None,
                 duration=None, task_id=None, conversation=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.planed_time = planed_time  # type: long
        self.chatbot_id = TeaConverter.to_unicode(chatbot_id)  # type: unicode
        self.actual_time = actual_time  # type: long
        self.called_number = TeaConverter.to_unicode(called_number)  # type: unicode
        self.end_time = end_time  # type: long
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.contact = contact  # type: GetJobStatusByCallIdResponseBodyJobTasksContact
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.call_id = TeaConverter.to_unicode(call_id)  # type: unicode
        self.calling_number = TeaConverter.to_unicode(calling_number)  # type: unicode
        self.brief = TeaConverter.to_unicode(brief)  # type: unicode
        self.duration = duration  # type: int
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.conversation = conversation  # type: list[GetJobStatusByCallIdResponseBodyJobTasksConversation]

    def validate(self):
        if self.contact:
            self.contact.validate()
        if self.conversation:
            for k in self.conversation:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.planed_time is not None:
            result['PlanedTime'] = self.planed_time
        if self.chatbot_id is not None:
            result['ChatbotId'] = self.chatbot_id
        if self.actual_time is not None:
            result['ActualTime'] = self.actual_time
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.contact is not None:
            result['Contact'] = self.contact.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.brief is not None:
            result['Brief'] = self.brief
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        result['Conversation'] = []
        if self.conversation is not None:
            for k in self.conversation:
                result['Conversation'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PlanedTime') is not None:
            self.planed_time = m.get('PlanedTime')
        if m.get('ChatbotId') is not None:
            self.chatbot_id = m.get('ChatbotId')
        if m.get('ActualTime') is not None:
            self.actual_time = m.get('ActualTime')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('Contact') is not None:
            temp_model = GetJobStatusByCallIdResponseBodyJobTasksContact()
            self.contact = temp_model.from_map(m['Contact'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('Brief') is not None:
            self.brief = m.get('Brief')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        self.conversation = []
        if m.get('Conversation') is not None:
            for k in m.get('Conversation'):
                temp_model = GetJobStatusByCallIdResponseBodyJobTasksConversation()
                self.conversation.append(temp_model.from_map(k))
        return self


class GetJobStatusByCallIdResponseBodyJob(TeaModel):
    def __init__(self, status=None, calling_numbers=None, contacts=None, summary=None, priority=None,
                 failure_reason=None, extras=None, reference_id=None, scenario_id=None, tasks=None, strategy_id=None, group_id=None,
                 job_id=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.calling_numbers = calling_numbers  # type: list[unicode]
        self.contacts = contacts  # type: list[GetJobStatusByCallIdResponseBodyJobContacts]
        self.summary = summary  # type: list[GetJobStatusByCallIdResponseBodyJobSummary]
        self.priority = priority  # type: int
        self.failure_reason = TeaConverter.to_unicode(failure_reason)  # type: unicode
        self.extras = extras  # type: list[GetJobStatusByCallIdResponseBodyJobExtras]
        self.reference_id = TeaConverter.to_unicode(reference_id)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.tasks = tasks  # type: list[GetJobStatusByCallIdResponseBodyJobTasks]
        self.strategy_id = TeaConverter.to_unicode(strategy_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        if self.contacts:
            for k in self.contacts:
                if k:
                    k.validate()
        if self.summary:
            for k in self.summary:
                if k:
                    k.validate()
        if self.extras:
            for k in self.extras:
                if k:
                    k.validate()
        if self.tasks:
            for k in self.tasks:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.calling_numbers is not None:
            result['CallingNumbers'] = self.calling_numbers
        result['Contacts'] = []
        if self.contacts is not None:
            for k in self.contacts:
                result['Contacts'].append(k.to_map() if k else None)
        result['Summary'] = []
        if self.summary is not None:
            for k in self.summary:
                result['Summary'].append(k.to_map() if k else None)
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.failure_reason is not None:
            result['FailureReason'] = self.failure_reason
        result['Extras'] = []
        if self.extras is not None:
            for k in self.extras:
                result['Extras'].append(k.to_map() if k else None)
        if self.reference_id is not None:
            result['ReferenceId'] = self.reference_id
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        result['Tasks'] = []
        if self.tasks is not None:
            for k in self.tasks:
                result['Tasks'].append(k.to_map() if k else None)
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CallingNumbers') is not None:
            self.calling_numbers = m.get('CallingNumbers')
        self.contacts = []
        if m.get('Contacts') is not None:
            for k in m.get('Contacts'):
                temp_model = GetJobStatusByCallIdResponseBodyJobContacts()
                self.contacts.append(temp_model.from_map(k))
        self.summary = []
        if m.get('Summary') is not None:
            for k in m.get('Summary'):
                temp_model = GetJobStatusByCallIdResponseBodyJobSummary()
                self.summary.append(temp_model.from_map(k))
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('FailureReason') is not None:
            self.failure_reason = m.get('FailureReason')
        self.extras = []
        if m.get('Extras') is not None:
            for k in m.get('Extras'):
                temp_model = GetJobStatusByCallIdResponseBodyJobExtras()
                self.extras.append(temp_model.from_map(k))
        if m.get('ReferenceId') is not None:
            self.reference_id = m.get('ReferenceId')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        self.tasks = []
        if m.get('Tasks') is not None:
            for k in m.get('Tasks'):
                temp_model = GetJobStatusByCallIdResponseBodyJobTasks()
                self.tasks.append(temp_model.from_map(k))
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetJobStatusByCallIdResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, job=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.job = job  # type: GetJobStatusByCallIdResponseBodyJob
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.job:
            self.job.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.job is not None:
            result['Job'] = self.job.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Job') is not None:
            temp_model = GetJobStatusByCallIdResponseBodyJob()
            self.job = temp_model.from_map(m['Job'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetJobStatusByCallIdResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetJobStatusByCallIdResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetJobStatusByCallIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetJobTemplateDownloadParamsRequest(TeaModel):
    def __init__(self, instance_id=None, scenario_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        return self


class GetJobTemplateDownloadParamsResponseBodyDownloadParams(TeaModel):
    def __init__(self, signature_url=None):
        self.signature_url = TeaConverter.to_unicode(signature_url)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.signature_url is not None:
            result['SignatureUrl'] = self.signature_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SignatureUrl') is not None:
            self.signature_url = m.get('SignatureUrl')
        return self


class GetJobTemplateDownloadParamsResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, download_params=None, http_status_code=None, code=None,
                 success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.download_params = download_params  # type: GetJobTemplateDownloadParamsResponseBodyDownloadParams
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.download_params:
            self.download_params.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.download_params is not None:
            result['DownloadParams'] = self.download_params.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DownloadParams') is not None:
            temp_model = GetJobTemplateDownloadParamsResponseBodyDownloadParams()
            self.download_params = temp_model.from_map(m['DownloadParams'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetJobTemplateDownloadParamsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetJobTemplateDownloadParamsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetJobTemplateDownloadParamsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNumberRegionInfoRequest(TeaModel):
    def __init__(self, instance_id=None, number=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.number = TeaConverter.to_unicode(number)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number is not None:
            result['Number'] = self.number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        return self


class GetNumberRegionInfoResponseBodyPhoneNumber(TeaModel):
    def __init__(self, number=None, city=None, province=None):
        self.number = TeaConverter.to_unicode(number)  # type: unicode
        self.city = TeaConverter.to_unicode(city)  # type: unicode
        self.province = TeaConverter.to_unicode(province)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.number is not None:
            result['Number'] = self.number
        if self.city is not None:
            result['City'] = self.city
        if self.province is not None:
            result['Province'] = self.province
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        return self


class GetNumberRegionInfoResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, phone_number=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.phone_number = phone_number  # type: GetNumberRegionInfoResponseBodyPhoneNumber
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.phone_number:
            self.phone_number.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PhoneNumber') is not None:
            temp_model = GetNumberRegionInfoResponseBodyPhoneNumber()
            self.phone_number = temp_model.from_map(m['PhoneNumber'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetNumberRegionInfoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetNumberRegionInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNumberRegionInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRecordOssUploadParamRequest(TeaModel):
    def __init__(self, instance_id=None, file_name=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.file_name = TeaConverter.to_unicode(file_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        return self


class GetRecordOssUploadParamResponseBody(TeaModel):
    def __init__(self, policy=None, message=None, request_id=None, signature=None, http_status_code=None,
                 oss_file_name=None, host=None, expires=None, dir=None, code=None, oss_access_key_id=None, success=None):
        self.policy = TeaConverter.to_unicode(policy)  # type: unicode
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.signature = TeaConverter.to_unicode(signature)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.oss_file_name = TeaConverter.to_unicode(oss_file_name)  # type: unicode
        self.host = TeaConverter.to_unicode(host)  # type: unicode
        self.expires = TeaConverter.to_unicode(expires)  # type: unicode
        self.dir = TeaConverter.to_unicode(dir)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.oss_access_key_id = TeaConverter.to_unicode(oss_access_key_id)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.oss_file_name is not None:
            result['OssFileName'] = self.oss_file_name
        if self.host is not None:
            result['Host'] = self.host
        if self.expires is not None:
            result['Expires'] = self.expires
        if self.dir is not None:
            result['Dir'] = self.dir
        if self.code is not None:
            result['Code'] = self.code
        if self.oss_access_key_id is not None:
            result['OssAccessKeyId'] = self.oss_access_key_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('OssFileName') is not None:
            self.oss_file_name = m.get('OssFileName')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Expires') is not None:
            self.expires = m.get('Expires')
        if m.get('Dir') is not None:
            self.dir = m.get('Dir')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('OssAccessKeyId') is not None:
            self.oss_access_key_id = m.get('OssAccessKeyId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetRecordOssUploadParamResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetRecordOssUploadParamResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetRecordOssUploadParamResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRoutePointRequest(TeaModel):
    def __init__(self, instance_id=None, contact_flow_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.contact_flow_id = TeaConverter.to_unicode(contact_flow_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        return self


class GetRoutePointResponseBody(TeaModel):
    def __init__(self, status_desc=None, route_point=None, request_id=None, message=None, http_status_code=None,
                 status_code=None, code=None, success=None):
        self.status_desc = TeaConverter.to_unicode(status_desc)  # type: unicode
        self.route_point = TeaConverter.to_unicode(route_point)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.status_code = TeaConverter.to_unicode(status_code)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status_desc is not None:
            result['StatusDesc'] = self.status_desc
        if self.route_point is not None:
            result['RoutePoint'] = self.route_point
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.message is not None:
            result['Message'] = self.message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.status_code is not None:
            result['StatusCode'] = self.status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('StatusDesc') is not None:
            self.status_desc = m.get('StatusDesc')
        if m.get('RoutePoint') is not None:
            self.route_point = m.get('RoutePoint')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('StatusCode') is not None:
            self.status_code = m.get('StatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetRoutePointResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetRoutePointResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetRoutePointResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetScenarioRequest(TeaModel):
    def __init__(self, instance_id=None, scenario_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        return self


class GetScenarioResponseBodyScenarioStrategyWorkingTime(TeaModel):
    def __init__(self, end_time=None, begin_time=None):
        self.end_time = TeaConverter.to_unicode(end_time)  # type: unicode
        self.begin_time = TeaConverter.to_unicode(begin_time)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.begin_time is not None:
            result['BeginTime'] = self.begin_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('BeginTime') is not None:
            self.begin_time = m.get('BeginTime')
        return self


class GetScenarioResponseBodyScenarioStrategy(TeaModel):
    def __init__(self, type=None, max_attempts_per_day=None, working_time=None, follow_up_strategy=None,
                 end_time=None, customized=None, start_time=None, is_template=None, repeat_days=None, routing_strategy=None,
                 description=None, min_attempt_interval=None, repeat_by=None, name=None, id=None):
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.max_attempts_per_day = max_attempts_per_day  # type: int
        self.working_time = working_time  # type: list[GetScenarioResponseBodyScenarioStrategyWorkingTime]
        self.follow_up_strategy = TeaConverter.to_unicode(follow_up_strategy)  # type: unicode
        self.end_time = end_time  # type: long
        self.customized = TeaConverter.to_unicode(customized)  # type: unicode
        self.start_time = start_time  # type: long
        self.is_template = is_template  # type: bool
        self.repeat_days = repeat_days  # type: list[unicode]
        self.routing_strategy = TeaConverter.to_unicode(routing_strategy)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.min_attempt_interval = min_attempt_interval  # type: int
        self.repeat_by = TeaConverter.to_unicode(repeat_by)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.id = TeaConverter.to_unicode(id)  # type: unicode

    def validate(self):
        if self.working_time:
            for k in self.working_time:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.max_attempts_per_day is not None:
            result['MaxAttemptsPerDay'] = self.max_attempts_per_day
        result['WorkingTime'] = []
        if self.working_time is not None:
            for k in self.working_time:
                result['WorkingTime'].append(k.to_map() if k else None)
        if self.follow_up_strategy is not None:
            result['FollowUpStrategy'] = self.follow_up_strategy
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.customized is not None:
            result['Customized'] = self.customized
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.is_template is not None:
            result['IsTemplate'] = self.is_template
        if self.repeat_days is not None:
            result['RepeatDays'] = self.repeat_days
        if self.routing_strategy is not None:
            result['RoutingStrategy'] = self.routing_strategy
        if self.description is not None:
            result['Description'] = self.description
        if self.min_attempt_interval is not None:
            result['MinAttemptInterval'] = self.min_attempt_interval
        if self.repeat_by is not None:
            result['RepeatBy'] = self.repeat_by
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('MaxAttemptsPerDay') is not None:
            self.max_attempts_per_day = m.get('MaxAttemptsPerDay')
        self.working_time = []
        if m.get('WorkingTime') is not None:
            for k in m.get('WorkingTime'):
                temp_model = GetScenarioResponseBodyScenarioStrategyWorkingTime()
                self.working_time.append(temp_model.from_map(k))
        if m.get('FollowUpStrategy') is not None:
            self.follow_up_strategy = m.get('FollowUpStrategy')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Customized') is not None:
            self.customized = m.get('Customized')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('IsTemplate') is not None:
            self.is_template = m.get('IsTemplate')
        if m.get('RepeatDays') is not None:
            self.repeat_days = m.get('RepeatDays')
        if m.get('RoutingStrategy') is not None:
            self.routing_strategy = m.get('RoutingStrategy')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MinAttemptInterval') is not None:
            self.min_attempt_interval = m.get('MinAttemptInterval')
        if m.get('RepeatBy') is not None:
            self.repeat_by = m.get('RepeatBy')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetScenarioResponseBodyScenarioSurveysIntents(TeaModel):
    def __init__(self, node_id=None, intent_id=None):
        self.node_id = TeaConverter.to_unicode(node_id)  # type: unicode
        self.intent_id = TeaConverter.to_unicode(intent_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.intent_id is not None:
            result['IntentId'] = self.intent_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('IntentId') is not None:
            self.intent_id = m.get('IntentId')
        return self


class GetScenarioResponseBodyScenarioSurveys(TeaModel):
    def __init__(self, round=None, description=None, beebot_id=None, intents=None, name=None, role=None, id=None):
        self.round = round  # type: int
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.beebot_id = TeaConverter.to_unicode(beebot_id)  # type: unicode
        self.intents = intents  # type: list[GetScenarioResponseBodyScenarioSurveysIntents]
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.role = TeaConverter.to_unicode(role)  # type: unicode
        self.id = TeaConverter.to_unicode(id)  # type: unicode

    def validate(self):
        if self.intents:
            for k in self.intents:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.round is not None:
            result['Round'] = self.round
        if self.description is not None:
            result['Description'] = self.description
        if self.beebot_id is not None:
            result['BeebotId'] = self.beebot_id
        result['Intents'] = []
        if self.intents is not None:
            for k in self.intents:
                result['Intents'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        if self.role is not None:
            result['Role'] = self.role
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Round') is not None:
            self.round = m.get('Round')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('BeebotId') is not None:
            self.beebot_id = m.get('BeebotId')
        self.intents = []
        if m.get('Intents') is not None:
            for k in m.get('Intents'):
                temp_model = GetScenarioResponseBodyScenarioSurveysIntents()
                self.intents.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetScenarioResponseBodyScenarioVariables(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetScenarioResponseBodyScenario(TeaModel):
    def __init__(self, type=None, strategy=None, is_template=None, description=None, surveys=None, variables=None,
                 name=None, id=None):
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.strategy = strategy  # type: GetScenarioResponseBodyScenarioStrategy
        self.is_template = is_template  # type: bool
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.surveys = surveys  # type: list[GetScenarioResponseBodyScenarioSurveys]
        self.variables = variables  # type: list[GetScenarioResponseBodyScenarioVariables]
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.id = TeaConverter.to_unicode(id)  # type: unicode

    def validate(self):
        if self.strategy:
            self.strategy.validate()
        if self.surveys:
            for k in self.surveys:
                if k:
                    k.validate()
        if self.variables:
            for k in self.variables:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.strategy is not None:
            result['Strategy'] = self.strategy.to_map()
        if self.is_template is not None:
            result['IsTemplate'] = self.is_template
        if self.description is not None:
            result['Description'] = self.description
        result['Surveys'] = []
        if self.surveys is not None:
            for k in self.surveys:
                result['Surveys'].append(k.to_map() if k else None)
        result['Variables'] = []
        if self.variables is not None:
            for k in self.variables:
                result['Variables'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Strategy') is not None:
            temp_model = GetScenarioResponseBodyScenarioStrategy()
            self.strategy = temp_model.from_map(m['Strategy'])
        if m.get('IsTemplate') is not None:
            self.is_template = m.get('IsTemplate')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.surveys = []
        if m.get('Surveys') is not None:
            for k in m.get('Surveys'):
                temp_model = GetScenarioResponseBodyScenarioSurveys()
                self.surveys.append(temp_model.from_map(k))
        self.variables = []
        if m.get('Variables') is not None:
            for k in m.get('Variables'):
                temp_model = GetScenarioResponseBodyScenarioVariables()
                self.variables.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetScenarioResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None, scenario=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool
        self.scenario = scenario  # type: GetScenarioResponseBodyScenario

    def validate(self):
        if self.scenario:
            self.scenario.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        if self.scenario is not None:
            result['Scenario'] = self.scenario.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Scenario') is not None:
            temp_model = GetScenarioResponseBodyScenario()
            self.scenario = temp_model.from_map(m['Scenario'])
        return self


class GetScenarioResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetScenarioResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetScenarioResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetServiceExtensionsRequest(TeaModel):
    def __init__(self, instance_id=None, service_type=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.service_type = TeaConverter.to_unicode(service_type)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.service_type is not None:
            result['ServiceType'] = self.service_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ServiceType') is not None:
            self.service_type = m.get('ServiceType')
        return self


class GetServiceExtensionsResponseBodyServiceExtensionsServiceExtension(TeaModel):
    def __init__(self, number=None, name=None):
        self.number = TeaConverter.to_unicode(number)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.number is not None:
            result['Number'] = self.number
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetServiceExtensionsResponseBodyServiceExtensions(TeaModel):
    def __init__(self, service_extension=None):
        self.service_extension = service_extension  # type: list[GetServiceExtensionsResponseBodyServiceExtensionsServiceExtension]

    def validate(self):
        if self.service_extension:
            for k in self.service_extension:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ServiceExtension'] = []
        if self.service_extension is not None:
            for k in self.service_extension:
                result['ServiceExtension'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.service_extension = []
        if m.get('ServiceExtension') is not None:
            for k in m.get('ServiceExtension'):
                temp_model = GetServiceExtensionsResponseBodyServiceExtensionsServiceExtension()
                self.service_extension.append(temp_model.from_map(k))
        return self


class GetServiceExtensionsResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, service_extensions=None, code=None,
                 success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.service_extensions = service_extensions  # type: GetServiceExtensionsResponseBodyServiceExtensions
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.service_extensions:
            self.service_extensions.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.service_extensions is not None:
            result['ServiceExtensions'] = self.service_extensions.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ServiceExtensions') is not None:
            temp_model = GetServiceExtensionsResponseBodyServiceExtensions()
            self.service_extensions = temp_model.from_map(m['ServiceExtensions'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetServiceExtensionsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetServiceExtensionsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetServiceExtensionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSmsConfigRequest(TeaModel):
    def __init__(self, instance_id=None, scenario=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.scenario = scenario  # type: list[int]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.scenario is not None:
            result['Scenario'] = self.scenario
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Scenario') is not None:
            self.scenario = m.get('Scenario')
        return self


class GetSmsConfigResponseBodySmsConfigsSmsConfig(TeaModel):
    def __init__(self, instance=None, description=None, template_code=None, gmt_create=None, scenario=None,
                 gmt_modified=None, name=None, extra=None, sign_name=None, id=None):
        self.instance = TeaConverter.to_unicode(instance)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.template_code = TeaConverter.to_unicode(template_code)  # type: unicode
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.scenario = scenario  # type: int
        self.gmt_modified = TeaConverter.to_unicode(gmt_modified)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.extra = TeaConverter.to_unicode(extra)  # type: unicode
        self.sign_name = TeaConverter.to_unicode(sign_name)  # type: unicode
        self.id = id  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance is not None:
            result['Instance'] = self.instance
        if self.description is not None:
            result['Description'] = self.description
        if self.template_code is not None:
            result['TemplateCode'] = self.template_code
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.scenario is not None:
            result['Scenario'] = self.scenario
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.name is not None:
            result['Name'] = self.name
        if self.extra is not None:
            result['Extra'] = self.extra
        if self.sign_name is not None:
            result['SignName'] = self.sign_name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Instance') is not None:
            self.instance = m.get('Instance')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('TemplateCode') is not None:
            self.template_code = m.get('TemplateCode')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Scenario') is not None:
            self.scenario = m.get('Scenario')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        if m.get('SignName') is not None:
            self.sign_name = m.get('SignName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetSmsConfigResponseBodySmsConfigs(TeaModel):
    def __init__(self, sms_config=None):
        self.sms_config = sms_config  # type: list[GetSmsConfigResponseBodySmsConfigsSmsConfig]

    def validate(self):
        if self.sms_config:
            for k in self.sms_config:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SmsConfig'] = []
        if self.sms_config is not None:
            for k in self.sms_config:
                result['SmsConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.sms_config = []
        if m.get('SmsConfig') is not None:
            for k in m.get('SmsConfig'):
                temp_model = GetSmsConfigResponseBodySmsConfigsSmsConfig()
                self.sms_config.append(temp_model.from_map(k))
        return self


class GetSmsConfigResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, sms_configs=None, code=None,
                 success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.sms_configs = sms_configs  # type: GetSmsConfigResponseBodySmsConfigs
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.sms_configs:
            self.sms_configs.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.sms_configs is not None:
            result['SmsConfigs'] = self.sms_configs.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('SmsConfigs') is not None:
            temp_model = GetSmsConfigResponseBodySmsConfigs()
            self.sms_configs = temp_model.from_map(m['SmsConfigs'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSmsConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetSmsConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSmsConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSurveyRequest(TeaModel):
    def __init__(self, instance_id=None, scenario_id=None, survey_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.survey_id = TeaConverter.to_unicode(survey_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.survey_id is not None:
            result['SurveyId'] = self.survey_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('SurveyId') is not None:
            self.survey_id = m.get('SurveyId')
        return self


class GetSurveyResponseBodySurveyAsrCustomModel(TeaModel):
    def __init__(self, custom_model_status=None, corpora=None):
        self.custom_model_status = custom_model_status  # type: int
        self.corpora = TeaConverter.to_unicode(corpora)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.custom_model_status is not None:
            result['CustomModelStatus'] = self.custom_model_status
        if self.corpora is not None:
            result['Corpora'] = self.corpora
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomModelStatus') is not None:
            self.custom_model_status = m.get('CustomModelStatus')
        if m.get('Corpora') is not None:
            self.corpora = m.get('Corpora')
        return self


class GetSurveyResponseBodySurveyFlow(TeaModel):
    def __init__(self, is_published=None, flow_json=None, flow_id=None):
        self.is_published = is_published  # type: bool
        self.flow_json = TeaConverter.to_unicode(flow_json)  # type: unicode
        self.flow_id = TeaConverter.to_unicode(flow_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.is_published is not None:
            result['IsPublished'] = self.is_published
        if self.flow_json is not None:
            result['FlowJson'] = self.flow_json
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsPublished') is not None:
            self.is_published = m.get('IsPublished')
        if m.get('FlowJson') is not None:
            self.flow_json = m.get('FlowJson')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        return self


class GetSurveyResponseBodySurvey(TeaModel):
    def __init__(self, global_questions=None, round=None, speech_optimization_param=None, description=None,
                 hot_words=None, asr_custom_model=None, flow=None, role=None, name=None, scenario_uuid=None, id=None):
        self.global_questions = TeaConverter.to_unicode(global_questions)  # type: unicode
        self.round = round  # type: int
        self.speech_optimization_param = TeaConverter.to_unicode(speech_optimization_param)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.hot_words = TeaConverter.to_unicode(hot_words)  # type: unicode
        self.asr_custom_model = asr_custom_model  # type: GetSurveyResponseBodySurveyAsrCustomModel
        self.flow = flow  # type: GetSurveyResponseBodySurveyFlow
        self.role = TeaConverter.to_unicode(role)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.scenario_uuid = TeaConverter.to_unicode(scenario_uuid)  # type: unicode
        self.id = TeaConverter.to_unicode(id)  # type: unicode

    def validate(self):
        if self.asr_custom_model:
            self.asr_custom_model.validate()
        if self.flow:
            self.flow.validate()

    def to_map(self):
        result = dict()
        if self.global_questions is not None:
            result['GlobalQuestions'] = self.global_questions
        if self.round is not None:
            result['Round'] = self.round
        if self.speech_optimization_param is not None:
            result['SpeechOptimizationParam'] = self.speech_optimization_param
        if self.description is not None:
            result['Description'] = self.description
        if self.hot_words is not None:
            result['HotWords'] = self.hot_words
        if self.asr_custom_model is not None:
            result['AsrCustomModel'] = self.asr_custom_model.to_map()
        if self.flow is not None:
            result['Flow'] = self.flow.to_map()
        if self.role is not None:
            result['Role'] = self.role
        if self.name is not None:
            result['Name'] = self.name
        if self.scenario_uuid is not None:
            result['ScenarioUuid'] = self.scenario_uuid
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GlobalQuestions') is not None:
            self.global_questions = m.get('GlobalQuestions')
        if m.get('Round') is not None:
            self.round = m.get('Round')
        if m.get('SpeechOptimizationParam') is not None:
            self.speech_optimization_param = m.get('SpeechOptimizationParam')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('HotWords') is not None:
            self.hot_words = m.get('HotWords')
        if m.get('AsrCustomModel') is not None:
            temp_model = GetSurveyResponseBodySurveyAsrCustomModel()
            self.asr_custom_model = temp_model.from_map(m['AsrCustomModel'])
        if m.get('Flow') is not None:
            temp_model = GetSurveyResponseBodySurveyFlow()
            self.flow = temp_model.from_map(m['Flow'])
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ScenarioUuid') is not None:
            self.scenario_uuid = m.get('ScenarioUuid')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetSurveyResponseBody(TeaModel):
    def __init__(self, survey=None, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.survey = survey  # type: GetSurveyResponseBodySurvey
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.survey:
            self.survey.validate()

    def to_map(self):
        result = dict()
        if self.survey is not None:
            result['Survey'] = self.survey.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Survey') is not None:
            temp_model = GetSurveyResponseBodySurvey()
            self.survey = temp_model.from_map(m['Survey'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSurveyResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetSurveyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSurveyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTaskListRequest(TeaModel):
    def __init__(self, instance_id=None, job_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetTaskListResponseBodyTasksContact(TeaModel):
    def __init__(self, phone_number=None, contact_id=None, state=None, job_id=None, honorific=None,
                 contact_name=None, role=None, reference_id=None):
        self.phone_number = TeaConverter.to_unicode(phone_number)  # type: unicode
        self.contact_id = TeaConverter.to_unicode(contact_id)  # type: unicode
        self.state = TeaConverter.to_unicode(state)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.honorific = TeaConverter.to_unicode(honorific)  # type: unicode
        self.contact_name = TeaConverter.to_unicode(contact_name)  # type: unicode
        self.role = TeaConverter.to_unicode(role)  # type: unicode
        self.reference_id = TeaConverter.to_unicode(reference_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.state is not None:
            result['State'] = self.state
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.honorific is not None:
            result['Honorific'] = self.honorific
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        if self.role is not None:
            result['Role'] = self.role
        if self.reference_id is not None:
            result['ReferenceId'] = self.reference_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Honorific') is not None:
            self.honorific = m.get('Honorific')
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('ReferenceId') is not None:
            self.reference_id = m.get('ReferenceId')
        return self


class GetTaskListResponseBodyTasksConversationSummary(TeaModel):
    def __init__(self, summary_name=None, category=None, content=None):
        self.summary_name = TeaConverter.to_unicode(summary_name)  # type: unicode
        self.category = TeaConverter.to_unicode(category)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.summary_name is not None:
            result['SummaryName'] = self.summary_name
        if self.category is not None:
            result['Category'] = self.category
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SummaryName') is not None:
            self.summary_name = m.get('SummaryName')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class GetTaskListResponseBodyTasksConversation(TeaModel):
    def __init__(self, summary=None, speaker=None, timestamp=None, script=None):
        self.summary = summary  # type: list[GetTaskListResponseBodyTasksConversationSummary]
        self.speaker = TeaConverter.to_unicode(speaker)  # type: unicode
        self.timestamp = timestamp  # type: long
        self.script = TeaConverter.to_unicode(script)  # type: unicode

    def validate(self):
        if self.summary:
            for k in self.summary:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Summary'] = []
        if self.summary is not None:
            for k in self.summary:
                result['Summary'].append(k.to_map() if k else None)
        if self.speaker is not None:
            result['Speaker'] = self.speaker
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.script is not None:
            result['Script'] = self.script
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.summary = []
        if m.get('Summary') is not None:
            for k in m.get('Summary'):
                temp_model = GetTaskListResponseBodyTasksConversationSummary()
                self.summary.append(temp_model.from_map(k))
        if m.get('Speaker') is not None:
            self.speaker = m.get('Speaker')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Script') is not None:
            self.script = m.get('Script')
        return self


class GetTaskListResponseBodyTasks(TeaModel):
    def __init__(self, status=None, planed_time=None, chatbot_id=None, actual_time=None, called_number=None,
                 scenario_id=None, contact=None, job_id=None, call_id=None, calling_number=None, brief=None, duration=None,
                 task_id=None, conversation=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.planed_time = planed_time  # type: long
        self.chatbot_id = TeaConverter.to_unicode(chatbot_id)  # type: unicode
        self.actual_time = actual_time  # type: long
        self.called_number = TeaConverter.to_unicode(called_number)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.contact = contact  # type: GetTaskListResponseBodyTasksContact
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.call_id = TeaConverter.to_unicode(call_id)  # type: unicode
        self.calling_number = TeaConverter.to_unicode(calling_number)  # type: unicode
        self.brief = TeaConverter.to_unicode(brief)  # type: unicode
        self.duration = duration  # type: int
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.conversation = conversation  # type: list[GetTaskListResponseBodyTasksConversation]

    def validate(self):
        if self.contact:
            self.contact.validate()
        if self.conversation:
            for k in self.conversation:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.planed_time is not None:
            result['PlanedTime'] = self.planed_time
        if self.chatbot_id is not None:
            result['ChatbotId'] = self.chatbot_id
        if self.actual_time is not None:
            result['ActualTime'] = self.actual_time
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.contact is not None:
            result['Contact'] = self.contact.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.brief is not None:
            result['Brief'] = self.brief
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        result['Conversation'] = []
        if self.conversation is not None:
            for k in self.conversation:
                result['Conversation'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PlanedTime') is not None:
            self.planed_time = m.get('PlanedTime')
        if m.get('ChatbotId') is not None:
            self.chatbot_id = m.get('ChatbotId')
        if m.get('ActualTime') is not None:
            self.actual_time = m.get('ActualTime')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('Contact') is not None:
            temp_model = GetTaskListResponseBodyTasksContact()
            self.contact = temp_model.from_map(m['Contact'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('Brief') is not None:
            self.brief = m.get('Brief')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        self.conversation = []
        if m.get('Conversation') is not None:
            for k in m.get('Conversation'):
                temp_model = GetTaskListResponseBodyTasksConversation()
                self.conversation.append(temp_model.from_map(k))
        return self


class GetTaskListResponseBody(TeaModel):
    def __init__(self, tasks=None, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.tasks = tasks  # type: list[GetTaskListResponseBodyTasks]
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.tasks:
            for k in self.tasks:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Tasks'] = []
        if self.tasks is not None:
            for k in self.tasks:
                result['Tasks'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tasks = []
        if m.get('Tasks') is not None:
            for k in m.get('Tasks'):
                temp_model = GetTaskListResponseBodyTasks()
                self.tasks.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetTaskListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetTaskListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetTaskListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTURNCredentialsRequest(TeaModel):
    def __init__(self, instance_id=None, user_name=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.user_name = TeaConverter.to_unicode(user_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class GetTURNCredentialsResponseBody(TeaModel):
    def __init__(self, request_id=None, message=None, username=None, http_status_code=None, code=None, success=None,
                 password=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.username = TeaConverter.to_unicode(username)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool
        self.password = TeaConverter.to_unicode(password)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.message is not None:
            result['Message'] = self.message
        if self.username is not None:
            result['Username'] = self.username
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        if self.password is not None:
            result['Password'] = self.password
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        return self


class GetTURNCredentialsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetTURNCredentialsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetTURNCredentialsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTURNServerListRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetTURNServerListResponseBody(TeaModel):
    def __init__(self, request_id=None, message=None, http_status_code=None, code=None,
                 turn_server_list_config=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.turn_server_list_config = TeaConverter.to_unicode(turn_server_list_config)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.message is not None:
            result['Message'] = self.message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.turn_server_list_config is not None:
            result['TurnServerListConfig'] = self.turn_server_list_config
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('TurnServerListConfig') is not None:
            self.turn_server_list_config = m.get('TurnServerListConfig')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetTURNServerListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetTURNServerListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetTURNServerListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUserRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.user_id = TeaConverter.to_unicode(user_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetUserResponseBodyUserSkillLevelsSkillLevelSkill(TeaModel):
    def __init__(self, skill_group_id=None, skill_group_name=None, instance_id=None, skill_group_description=None):
        self.skill_group_id = TeaConverter.to_unicode(skill_group_id)  # type: unicode
        self.skill_group_name = TeaConverter.to_unicode(skill_group_name)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.skill_group_description = TeaConverter.to_unicode(skill_group_description)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_description is not None:
            result['SkillGroupDescription'] = self.skill_group_description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupDescription') is not None:
            self.skill_group_description = m.get('SkillGroupDescription')
        return self


class GetUserResponseBodyUserSkillLevelsSkillLevel(TeaModel):
    def __init__(self, skill=None, skill_level_id=None, level=None):
        self.skill = skill  # type: GetUserResponseBodyUserSkillLevelsSkillLevelSkill
        self.skill_level_id = TeaConverter.to_unicode(skill_level_id)  # type: unicode
        self.level = level  # type: int

    def validate(self):
        if self.skill:
            self.skill.validate()

    def to_map(self):
        result = dict()
        if self.skill is not None:
            result['Skill'] = self.skill.to_map()
        if self.skill_level_id is not None:
            result['SkillLevelId'] = self.skill_level_id
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Skill') is not None:
            temp_model = GetUserResponseBodyUserSkillLevelsSkillLevelSkill()
            self.skill = temp_model.from_map(m['Skill'])
        if m.get('SkillLevelId') is not None:
            self.skill_level_id = m.get('SkillLevelId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class GetUserResponseBodyUserSkillLevels(TeaModel):
    def __init__(self, skill_level=None):
        self.skill_level = skill_level  # type: list[GetUserResponseBodyUserSkillLevelsSkillLevel]

    def validate(self):
        if self.skill_level:
            for k in self.skill_level:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SkillLevel'] = []
        if self.skill_level is not None:
            for k in self.skill_level:
                result['SkillLevel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.skill_level = []
        if m.get('SkillLevel') is not None:
            for k in m.get('SkillLevel'):
                temp_model = GetUserResponseBodyUserSkillLevelsSkillLevel()
                self.skill_level.append(temp_model.from_map(k))
        return self


class GetUserResponseBodyUserRolesRole(TeaModel):
    def __init__(self, role_description=None, instance_id=None, role_name=None, role_id=None):
        self.role_description = TeaConverter.to_unicode(role_description)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.role_name = TeaConverter.to_unicode(role_name)  # type: unicode
        self.role_id = TeaConverter.to_unicode(role_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.role_description is not None:
            result['RoleDescription'] = self.role_description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RoleDescription') is not None:
            self.role_description = m.get('RoleDescription')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        return self


class GetUserResponseBodyUserRoles(TeaModel):
    def __init__(self, role=None):
        self.role = role  # type: list[GetUserResponseBodyUserRolesRole]

    def validate(self):
        if self.role:
            for k in self.role:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Role'] = []
        if self.role is not None:
            for k in self.role:
                result['Role'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.role = []
        if m.get('Role') is not None:
            for k in m.get('Role'):
                temp_model = GetUserResponseBodyUserRolesRole()
                self.role.append(temp_model.from_map(k))
        return self


class GetUserResponseBodyUserDetail(TeaModel):
    def __init__(self, display_name=None, email=None, login_name=None, department=None, phone=None):
        self.display_name = TeaConverter.to_unicode(display_name)  # type: unicode
        self.email = TeaConverter.to_unicode(email)  # type: unicode
        self.login_name = TeaConverter.to_unicode(login_name)  # type: unicode
        self.department = TeaConverter.to_unicode(department)  # type: unicode
        self.phone = TeaConverter.to_unicode(phone)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.department is not None:
            result['Department'] = self.department
        if self.phone is not None:
            result['Phone'] = self.phone
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('Phone') is not None:
            self.phone = m.get('Phone')
        return self


class GetUserResponseBodyUser(TeaModel):
    def __init__(self, skill_levels=None, user_id=None, roles=None, instance_id=None, ram_id=None, detail=None):
        self.skill_levels = skill_levels  # type: GetUserResponseBodyUserSkillLevels
        self.user_id = TeaConverter.to_unicode(user_id)  # type: unicode
        self.roles = roles  # type: GetUserResponseBodyUserRoles
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.ram_id = TeaConverter.to_unicode(ram_id)  # type: unicode
        self.detail = detail  # type: GetUserResponseBodyUserDetail

    def validate(self):
        if self.skill_levels:
            self.skill_levels.validate()
        if self.roles:
            self.roles.validate()
        if self.detail:
            self.detail.validate()

    def to_map(self):
        result = dict()
        if self.skill_levels is not None:
            result['SkillLevels'] = self.skill_levels.to_map()
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.roles is not None:
            result['Roles'] = self.roles.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ram_id is not None:
            result['RamId'] = self.ram_id
        if self.detail is not None:
            result['Detail'] = self.detail.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SkillLevels') is not None:
            temp_model = GetUserResponseBodyUserSkillLevels()
            self.skill_levels = temp_model.from_map(m['SkillLevels'])
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Roles') is not None:
            temp_model = GetUserResponseBodyUserRoles()
            self.roles = temp_model.from_map(m['Roles'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RamId') is not None:
            self.ram_id = m.get('RamId')
        if m.get('Detail') is not None:
            temp_model = GetUserResponseBodyUserDetail()
            self.detail = temp_model.from_map(m['Detail'])
        return self


class GetUserResponseBody(TeaModel):
    def __init__(self, user=None, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.user = user  # type: GetUserResponseBodyUser
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.user:
            self.user.validate()

    def to_map(self):
        result = dict()
        if self.user is not None:
            result['User'] = self.user.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('User') is not None:
            temp_model = GetUserResponseBodyUser()
            self.user = temp_model.from_map(m['User'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUserByExtensionRequest(TeaModel):
    def __init__(self, instance_id=None, extension=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.extension = TeaConverter.to_unicode(extension)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.extension is not None:
            result['Extension'] = self.extension
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        return self


class GetUserByExtensionResponseBodyUserSkillLevelsSkill(TeaModel):
    def __init__(self, skill_group_id=None, skill_group_name=None, instance_id=None, skill_group_description=None):
        self.skill_group_id = TeaConverter.to_unicode(skill_group_id)  # type: unicode
        self.skill_group_name = TeaConverter.to_unicode(skill_group_name)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.skill_group_description = TeaConverter.to_unicode(skill_group_description)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_description is not None:
            result['SkillGroupDescription'] = self.skill_group_description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupDescription') is not None:
            self.skill_group_description = m.get('SkillGroupDescription')
        return self


class GetUserByExtensionResponseBodyUserSkillLevels(TeaModel):
    def __init__(self, skill=None, skill_level_id=None, level=None):
        self.skill = skill  # type: GetUserByExtensionResponseBodyUserSkillLevelsSkill
        self.skill_level_id = TeaConverter.to_unicode(skill_level_id)  # type: unicode
        self.level = level  # type: int

    def validate(self):
        if self.skill:
            self.skill.validate()

    def to_map(self):
        result = dict()
        if self.skill is not None:
            result['Skill'] = self.skill.to_map()
        if self.skill_level_id is not None:
            result['SkillLevelId'] = self.skill_level_id
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Skill') is not None:
            temp_model = GetUserByExtensionResponseBodyUserSkillLevelsSkill()
            self.skill = temp_model.from_map(m['Skill'])
        if m.get('SkillLevelId') is not None:
            self.skill_level_id = m.get('SkillLevelId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class GetUserByExtensionResponseBodyUserRoles(TeaModel):
    def __init__(self, role_description=None, instance_id=None, role_name=None, role_id=None):
        self.role_description = TeaConverter.to_unicode(role_description)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.role_name = TeaConverter.to_unicode(role_name)  # type: unicode
        self.role_id = TeaConverter.to_unicode(role_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.role_description is not None:
            result['RoleDescription'] = self.role_description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RoleDescription') is not None:
            self.role_description = m.get('RoleDescription')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        return self


class GetUserByExtensionResponseBodyUserDetail(TeaModel):
    def __init__(self, display_name=None, extension=None, login_name=None, email=None, department=None, phone=None):
        self.display_name = TeaConverter.to_unicode(display_name)  # type: unicode
        self.extension = TeaConverter.to_unicode(extension)  # type: unicode
        self.login_name = TeaConverter.to_unicode(login_name)  # type: unicode
        self.email = TeaConverter.to_unicode(email)  # type: unicode
        self.department = TeaConverter.to_unicode(department)  # type: unicode
        self.phone = TeaConverter.to_unicode(phone)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.email is not None:
            result['Email'] = self.email
        if self.department is not None:
            result['Department'] = self.department
        if self.phone is not None:
            result['Phone'] = self.phone
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('Phone') is not None:
            self.phone = m.get('Phone')
        return self


class GetUserByExtensionResponseBodyUser(TeaModel):
    def __init__(self, skill_levels=None, user_id=None, roles=None, instance_id=None, ram_id=None, detail=None):
        self.skill_levels = skill_levels  # type: list[GetUserByExtensionResponseBodyUserSkillLevels]
        self.user_id = TeaConverter.to_unicode(user_id)  # type: unicode
        self.roles = roles  # type: list[GetUserByExtensionResponseBodyUserRoles]
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.ram_id = TeaConverter.to_unicode(ram_id)  # type: unicode
        self.detail = detail  # type: GetUserByExtensionResponseBodyUserDetail

    def validate(self):
        if self.skill_levels:
            for k in self.skill_levels:
                if k:
                    k.validate()
        if self.roles:
            for k in self.roles:
                if k:
                    k.validate()
        if self.detail:
            self.detail.validate()

    def to_map(self):
        result = dict()
        result['SkillLevels'] = []
        if self.skill_levels is not None:
            for k in self.skill_levels:
                result['SkillLevels'].append(k.to_map() if k else None)
        if self.user_id is not None:
            result['UserId'] = self.user_id
        result['Roles'] = []
        if self.roles is not None:
            for k in self.roles:
                result['Roles'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ram_id is not None:
            result['RamId'] = self.ram_id
        if self.detail is not None:
            result['Detail'] = self.detail.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.skill_levels = []
        if m.get('SkillLevels') is not None:
            for k in m.get('SkillLevels'):
                temp_model = GetUserByExtensionResponseBodyUserSkillLevels()
                self.skill_levels.append(temp_model.from_map(k))
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        self.roles = []
        if m.get('Roles') is not None:
            for k in m.get('Roles'):
                temp_model = GetUserByExtensionResponseBodyUserRoles()
                self.roles.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RamId') is not None:
            self.ram_id = m.get('RamId')
        if m.get('Detail') is not None:
            temp_model = GetUserByExtensionResponseBodyUserDetail()
            self.detail = temp_model.from_map(m['Detail'])
        return self


class GetUserByExtensionResponseBody(TeaModel):
    def __init__(self, user=None, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.user = user  # type: GetUserByExtensionResponseBodyUser
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.user:
            self.user.validate()

    def to_map(self):
        result = dict()
        if self.user is not None:
            result['User'] = self.user.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('User') is not None:
            temp_model = GetUserByExtensionResponseBodyUser()
            self.user = temp_model.from_map(m['User'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetUserByExtensionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetUserByExtensionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetUserByExtensionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InflightTaskTimeoutRequest(TeaModel):
    def __init__(self, instance_id=None, task_id=None, instance_owner_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.instance_owner_id = instance_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.instance_owner_id is not None:
            result['InstanceOwnerId'] = self.instance_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('InstanceOwnerId') is not None:
            self.instance_owner_id = m.get('InstanceOwnerId')
        return self


class InflightTaskTimeoutResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class InflightTaskTimeoutResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: InflightTaskTimeoutResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InflightTaskTimeoutResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class LaunchAppraiseRequest(TeaModel):
    def __init__(self, instance_id=None, acid=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.acid = TeaConverter.to_unicode(acid)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.acid is not None:
            result['Acid'] = self.acid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        return self


class LaunchAppraiseResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class LaunchAppraiseResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: LaunchAppraiseResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = LaunchAppraiseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class LaunchShortMessageAppraiseRequest(TeaModel):
    def __init__(self, instance_id=None, acid=None, skill_group_id=None, contact_type=None, phone_numbers=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.acid = TeaConverter.to_unicode(acid)  # type: unicode
        self.skill_group_id = TeaConverter.to_unicode(skill_group_id)  # type: unicode
        self.contact_type = contact_type  # type: int
        self.phone_numbers = TeaConverter.to_unicode(phone_numbers)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.contact_type is not None:
            result['ContactType'] = self.contact_type
        if self.phone_numbers is not None:
            result['PhoneNumbers'] = self.phone_numbers
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('ContactType') is not None:
            self.contact_type = m.get('ContactType')
        if m.get('PhoneNumbers') is not None:
            self.phone_numbers = m.get('PhoneNumbers')
        return self


class LaunchShortMessageAppraiseResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class LaunchShortMessageAppraiseResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: LaunchShortMessageAppraiseResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = LaunchShortMessageAppraiseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAgentDevicesRequest(TeaModel):
    def __init__(self, instance_id=None, ram_ids=None, start_time=None, stop_time=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.ram_ids = TeaConverter.to_unicode(ram_ids)  # type: unicode
        self.start_time = start_time  # type: long
        self.stop_time = stop_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ram_ids is not None:
            result['RamIds'] = self.ram_ids
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RamIds') is not None:
            self.ram_ids = m.get('RamIds')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StopTime') is not None:
            self.stop_time = m.get('StopTime')
        return self


class ListAgentDevicesResponseBodyAgentDeviceListAgentDevice(TeaModel):
    def __init__(self, login_time=None, client_port=None, remark=None, browser_version=None, client_ip=None,
                 instance_id=None, is_login=None, ram_id=None):
        self.login_time = login_time  # type: long
        self.client_port = TeaConverter.to_unicode(client_port)  # type: unicode
        self.remark = TeaConverter.to_unicode(remark)  # type: unicode
        self.browser_version = TeaConverter.to_unicode(browser_version)  # type: unicode
        self.client_ip = TeaConverter.to_unicode(client_ip)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.is_login = is_login  # type: int
        self.ram_id = ram_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.login_time is not None:
            result['LoginTime'] = self.login_time
        if self.client_port is not None:
            result['ClientPort'] = self.client_port
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.browser_version is not None:
            result['BrowserVersion'] = self.browser_version
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.is_login is not None:
            result['IsLogin'] = self.is_login
        if self.ram_id is not None:
            result['RamId'] = self.ram_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LoginTime') is not None:
            self.login_time = m.get('LoginTime')
        if m.get('ClientPort') is not None:
            self.client_port = m.get('ClientPort')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('BrowserVersion') is not None:
            self.browser_version = m.get('BrowserVersion')
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IsLogin') is not None:
            self.is_login = m.get('IsLogin')
        if m.get('RamId') is not None:
            self.ram_id = m.get('RamId')
        return self


class ListAgentDevicesResponseBodyAgentDeviceList(TeaModel):
    def __init__(self, agent_device=None):
        self.agent_device = agent_device  # type: list[ListAgentDevicesResponseBodyAgentDeviceListAgentDevice]

    def validate(self):
        if self.agent_device:
            for k in self.agent_device:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['AgentDevice'] = []
        if self.agent_device is not None:
            for k in self.agent_device:
                result['AgentDevice'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.agent_device = []
        if m.get('AgentDevice') is not None:
            for k in m.get('AgentDevice'):
                temp_model = ListAgentDevicesResponseBodyAgentDeviceListAgentDevice()
                self.agent_device.append(temp_model.from_map(k))
        return self


class ListAgentDevicesResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None,
                 agent_device_list=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool
        self.agent_device_list = agent_device_list  # type: ListAgentDevicesResponseBodyAgentDeviceList

    def validate(self):
        if self.agent_device_list:
            self.agent_device_list.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        if self.agent_device_list is not None:
            result['AgentDeviceList'] = self.agent_device_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('AgentDeviceList') is not None:
            temp_model = ListAgentDevicesResponseBodyAgentDeviceList()
            self.agent_device_list = temp_model.from_map(m['AgentDeviceList'])
        return self


class ListAgentDevicesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListAgentDevicesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAgentDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAgentEventsRequest(TeaModel):
    def __init__(self, instance_id=None, start_time=None, stop_time=None, ram_id=None, event=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.start_time = start_time  # type: long
        self.stop_time = stop_time  # type: long
        self.ram_id = ram_id  # type: list[unicode]
        self.event = event  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        if self.ram_id is not None:
            result['RamId'] = self.ram_id
        if self.event is not None:
            result['Event'] = self.event
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StopTime') is not None:
            self.stop_time = m.get('StopTime')
        if m.get('RamId') is not None:
            self.ram_id = m.get('RamId')
        if m.get('Event') is not None:
            self.event = m.get('Event')
        return self


class ListAgentEventsResponseBodyAgentEventListAgentEventSkillGroupIdsSkillGroup(TeaModel):
    def __init__(self, skill_group_name=None, skill_group_id=None):
        self.skill_group_name = TeaConverter.to_unicode(skill_group_name)  # type: unicode
        self.skill_group_id = TeaConverter.to_unicode(skill_group_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class ListAgentEventsResponseBodyAgentEventListAgentEventSkillGroupIds(TeaModel):
    def __init__(self, skill_group=None):
        self.skill_group = skill_group  # type: list[ListAgentEventsResponseBodyAgentEventListAgentEventSkillGroupIdsSkillGroup]

    def validate(self):
        if self.skill_group:
            for k in self.skill_group:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SkillGroup'] = []
        if self.skill_group is not None:
            for k in self.skill_group:
                result['SkillGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.skill_group = []
        if m.get('SkillGroup') is not None:
            for k in m.get('SkillGroup'):
                temp_model = ListAgentEventsResponseBodyAgentEventListAgentEventSkillGroupIdsSkillGroup()
                self.skill_group.append(temp_model.from_map(k))
        return self


class ListAgentEventsResponseBodyAgentEventListAgentEvent(TeaModel):
    def __init__(self, event_time=None, login_name=None, event=None, instance_id=None, ram_id=None,
                 skill_group_ids=None):
        self.event_time = event_time  # type: long
        self.login_name = TeaConverter.to_unicode(login_name)  # type: unicode
        self.event = TeaConverter.to_unicode(event)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.ram_id = ram_id  # type: long
        self.skill_group_ids = skill_group_ids  # type: ListAgentEventsResponseBodyAgentEventListAgentEventSkillGroupIds

    def validate(self):
        if self.skill_group_ids:
            self.skill_group_ids.validate()

    def to_map(self):
        result = dict()
        if self.event_time is not None:
            result['EventTime'] = self.event_time
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.event is not None:
            result['Event'] = self.event
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ram_id is not None:
            result['RamId'] = self.ram_id
        if self.skill_group_ids is not None:
            result['SkillGroupIds'] = self.skill_group_ids.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EventTime') is not None:
            self.event_time = m.get('EventTime')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Event') is not None:
            self.event = m.get('Event')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RamId') is not None:
            self.ram_id = m.get('RamId')
        if m.get('SkillGroupIds') is not None:
            temp_model = ListAgentEventsResponseBodyAgentEventListAgentEventSkillGroupIds()
            self.skill_group_ids = temp_model.from_map(m['SkillGroupIds'])
        return self


class ListAgentEventsResponseBodyAgentEventList(TeaModel):
    def __init__(self, agent_event=None):
        self.agent_event = agent_event  # type: list[ListAgentEventsResponseBodyAgentEventListAgentEvent]

    def validate(self):
        if self.agent_event:
            for k in self.agent_event:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['AgentEvent'] = []
        if self.agent_event is not None:
            for k in self.agent_event:
                result['AgentEvent'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.agent_event = []
        if m.get('AgentEvent') is not None:
            for k in m.get('AgentEvent'):
                temp_model = ListAgentEventsResponseBodyAgentEventListAgentEvent()
                self.agent_event.append(temp_model.from_map(k))
        return self


class ListAgentEventsResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, agent_event_list=None, http_status_code=None, code=None,
                 success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.agent_event_list = agent_event_list  # type: ListAgentEventsResponseBodyAgentEventList
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.agent_event_list:
            self.agent_event_list.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.agent_event_list is not None:
            result['AgentEventList'] = self.agent_event_list.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('AgentEventList') is not None:
            temp_model = ListAgentEventsResponseBodyAgentEventList()
            self.agent_event_list = temp_model.from_map(m['AgentEventList'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListAgentEventsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListAgentEventsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAgentEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAgentStateLogsRequest(TeaModel):
    def __init__(self, instance_id=None, ram_id=None, start_time=None, end_time=None, page_number=None,
                 page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.ram_id = ram_id  # type: long
        self.start_time = start_time  # type: long
        self.end_time = end_time  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ram_id is not None:
            result['RamId'] = self.ram_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RamId') is not None:
            self.ram_id = m.get('RamId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListAgentStateLogsResponseBodyAgentStateLogPageList(TeaModel):
    def __init__(self, state_code=None, contact_id=None, state=None, connect_id=None, state_time=None,
                 instance_id=None, ram_id=None, skill_group_ids=None, counter_party=None):
        self.state_code = TeaConverter.to_unicode(state_code)  # type: unicode
        self.contact_id = TeaConverter.to_unicode(contact_id)  # type: unicode
        self.state = TeaConverter.to_unicode(state)  # type: unicode
        self.connect_id = TeaConverter.to_unicode(connect_id)  # type: unicode
        self.state_time = state_time  # type: long
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.ram_id = ram_id  # type: long
        self.skill_group_ids = TeaConverter.to_unicode(skill_group_ids)  # type: unicode
        self.counter_party = TeaConverter.to_unicode(counter_party)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.state_code is not None:
            result['StateCode'] = self.state_code
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.state is not None:
            result['State'] = self.state
        if self.connect_id is not None:
            result['ConnectId'] = self.connect_id
        if self.state_time is not None:
            result['StateTime'] = self.state_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ram_id is not None:
            result['RamId'] = self.ram_id
        if self.skill_group_ids is not None:
            result['SkillGroupIds'] = self.skill_group_ids
        if self.counter_party is not None:
            result['CounterParty'] = self.counter_party
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('StateCode') is not None:
            self.state_code = m.get('StateCode')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('ConnectId') is not None:
            self.connect_id = m.get('ConnectId')
        if m.get('StateTime') is not None:
            self.state_time = m.get('StateTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RamId') is not None:
            self.ram_id = m.get('RamId')
        if m.get('SkillGroupIds') is not None:
            self.skill_group_ids = m.get('SkillGroupIds')
        if m.get('CounterParty') is not None:
            self.counter_party = m.get('CounterParty')
        return self


class ListAgentStateLogsResponseBodyAgentStateLogPage(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListAgentStateLogsResponseBodyAgentStateLogPageList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListAgentStateLogsResponseBodyAgentStateLogPageList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAgentStateLogsResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None,
                 agent_state_log_page=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool
        self.agent_state_log_page = agent_state_log_page  # type: ListAgentStateLogsResponseBodyAgentStateLogPage

    def validate(self):
        if self.agent_state_log_page:
            self.agent_state_log_page.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        if self.agent_state_log_page is not None:
            result['AgentStateLogPage'] = self.agent_state_log_page.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('AgentStateLogPage') is not None:
            temp_model = ListAgentStateLogsResponseBodyAgentStateLogPage()
            self.agent_state_log_page = temp_model.from_map(m['AgentStateLogPage'])
        return self


class ListAgentStateLogsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListAgentStateLogsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAgentStateLogsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAgentStatesRequest(TeaModel):
    def __init__(self, instance_id=None, skill_group_id=None, agent_ids=None, state=None, page_number=None,
                 page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.skill_group_id = TeaConverter.to_unicode(skill_group_id)  # type: unicode
        self.agent_ids = TeaConverter.to_unicode(agent_ids)  # type: unicode
        self.state = TeaConverter.to_unicode(state)  # type: unicode
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.state is not None:
            result['State'] = self.state
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListAgentStatesResponseBodyDataListRealTimeAgentState(TeaModel):
    def __init__(self, login_name=None, dn=None, state_duration=None, state=None, agent_id=None, agent_name=None,
                 instance_id=None):
        self.login_name = TeaConverter.to_unicode(login_name)  # type: unicode
        self.dn = TeaConverter.to_unicode(dn)  # type: unicode
        self.state_duration = TeaConverter.to_unicode(state_duration)  # type: unicode
        self.state = TeaConverter.to_unicode(state)  # type: unicode
        self.agent_id = TeaConverter.to_unicode(agent_id)  # type: unicode
        self.agent_name = TeaConverter.to_unicode(agent_name)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.dn is not None:
            result['Dn'] = self.dn
        if self.state_duration is not None:
            result['StateDuration'] = self.state_duration
        if self.state is not None:
            result['State'] = self.state
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Dn') is not None:
            self.dn = m.get('Dn')
        if m.get('StateDuration') is not None:
            self.state_duration = m.get('StateDuration')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListAgentStatesResponseBodyDataList(TeaModel):
    def __init__(self, real_time_agent_state=None):
        self.real_time_agent_state = real_time_agent_state  # type: list[ListAgentStatesResponseBodyDataListRealTimeAgentState]

    def validate(self):
        if self.real_time_agent_state:
            for k in self.real_time_agent_state:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RealTimeAgentState'] = []
        if self.real_time_agent_state is not None:
            for k in self.real_time_agent_state:
                result['RealTimeAgentState'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.real_time_agent_state = []
        if m.get('RealTimeAgentState') is not None:
            for k in m.get('RealTimeAgentState'):
                temp_model = ListAgentStatesResponseBodyDataListRealTimeAgentState()
                self.real_time_agent_state.append(temp_model.from_map(k))
        return self


class ListAgentStatesResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: ListAgentStatesResponseBodyDataList
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = ListAgentStatesResponseBodyDataList()
            self.list = temp_model.from_map(m['List'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAgentStatesResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, data=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: ListAgentStatesResponseBodyData
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            temp_model = ListAgentStatesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListAgentStatesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListAgentStatesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAgentStatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAgentSummaryReportsRequest(TeaModel):
    def __init__(self, instance_id=None, skill_group_id=None, agent_ids=None, start_time=None, end_time=None,
                 page_number=None, page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.skill_group_id = TeaConverter.to_unicode(skill_group_id)  # type: unicode
        self.agent_ids = TeaConverter.to_unicode(agent_ids)  # type: unicode
        self.start_time = TeaConverter.to_unicode(start_time)  # type: unicode
        self.end_time = TeaConverter.to_unicode(end_time)  # type: unicode
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListAgentSummaryReportsResponseBodyPagedAgentSummaryReportListAgentSummaryReportOverall(TeaModel):
    def __init__(self, total_logged_in_time=None, total_talk_time=None, occupancy_rate=None,
                 last_log_out_time=None, total_work_time=None, first_log_in_time=None, max_work_time=None, average_talk_time=None,
                 average_work_time=None, satisfaction_index=None, satisfaction_surveys_offered=None,
                 satisfaction_surveys_responded=None, average_ready_time=None, max_ready_time=None, one_transfer_calls=None, max_talk_time=None,
                 total_ready_time=None, total_break_time=None, total_calls=None):
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.last_log_out_time = TeaConverter.to_unicode(last_log_out_time)  # type: unicode
        self.total_work_time = total_work_time  # type: long
        self.first_log_in_time = TeaConverter.to_unicode(first_log_in_time)  # type: unicode
        self.max_work_time = max_work_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.average_ready_time = average_ready_time  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.one_transfer_calls = one_transfer_calls  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.total_ready_time = total_ready_time  # type: long
        self.total_break_time = total_break_time  # type: long
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.last_log_out_time is not None:
            result['LastLogOutTime'] = self.last_log_out_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.first_log_in_time is not None:
            result['FirstLogInTime'] = self.first_log_in_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.one_transfer_calls is not None:
            result['OneTransferCalls'] = self.one_transfer_calls
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('LastLogOutTime') is not None:
            self.last_log_out_time = m.get('LastLogOutTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('FirstLogInTime') is not None:
            self.first_log_in_time = m.get('FirstLogInTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('OneTransferCalls') is not None:
            self.one_transfer_calls = m.get('OneTransferCalls')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class ListAgentSummaryReportsResponseBodyPagedAgentSummaryReportListAgentSummaryReportInbound(TeaModel):
    def __init__(self, total_talk_time=None, average_ring_time=None, calls_offered=None, calls_handled=None,
                 service_level_20=None, total_work_time=None, max_work_time=None, average_talk_time=None, average_work_time=None,
                 satisfaction_index=None, satisfaction_surveys_offered=None, handle_rate=None, satisfaction_surveys_responded=None,
                 total_ring_time=None, max_talk_time=None, max_ring_time=None):
        self.total_talk_time = total_talk_time  # type: long
        self.average_ring_time = average_ring_time  # type: long
        self.calls_offered = calls_offered  # type: long
        self.calls_handled = calls_handled  # type: long
        self.service_level_20 = service_level_20  # type: float
        self.total_work_time = total_work_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.handle_rate = handle_rate  # type: float
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_ring_time = max_ring_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.service_level_20 is not None:
            result['ServiceLevel20'] = self.service_level_20
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('ServiceLevel20') is not None:
            self.service_level_20 = m.get('ServiceLevel20')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        return self


class ListAgentSummaryReportsResponseBodyPagedAgentSummaryReportListAgentSummaryReportOutbound(TeaModel):
    def __init__(self, total_talk_time=None, max_dialing_time=None, calls_dialed=None, calls_answered=None,
                 total_work_time=None, answer_rate=None, max_work_time=None, total_dialing_time=None, average_work_time=None,
                 average_talk_time=None, satisfaction_index=None, satisfaction_surveys_offered=None,
                 satisfaction_surveys_responded=None, max_talk_time=None, average_dialing_time=None):
        self.total_talk_time = total_talk_time  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.calls_answered = calls_answered  # type: long
        self.total_work_time = total_work_time  # type: long
        self.answer_rate = answer_rate  # type: float
        self.max_work_time = TeaConverter.to_unicode(max_work_time)  # type: unicode
        self.total_dialing_time = total_dialing_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.average_dialing_time = average_dialing_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        return self


class ListAgentSummaryReportsResponseBodyPagedAgentSummaryReportListAgentSummaryReport(TeaModel):
    def __init__(self, overall=None, login_name=None, agent_id=None, inbound=None, outbound=None, agent_name=None,
                 instance_id=None, skill_group_names=None, skill_group_ids=None):
        self.overall = overall  # type: ListAgentSummaryReportsResponseBodyPagedAgentSummaryReportListAgentSummaryReportOverall
        self.login_name = TeaConverter.to_unicode(login_name)  # type: unicode
        self.agent_id = TeaConverter.to_unicode(agent_id)  # type: unicode
        self.inbound = inbound  # type: ListAgentSummaryReportsResponseBodyPagedAgentSummaryReportListAgentSummaryReportInbound
        self.outbound = outbound  # type: ListAgentSummaryReportsResponseBodyPagedAgentSummaryReportListAgentSummaryReportOutbound
        self.agent_name = TeaConverter.to_unicode(agent_name)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.skill_group_names = TeaConverter.to_unicode(skill_group_names)  # type: unicode
        self.skill_group_ids = TeaConverter.to_unicode(skill_group_ids)  # type: unicode

    def validate(self):
        if self.overall:
            self.overall.validate()
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()

    def to_map(self):
        result = dict()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_names is not None:
            result['SkillGroupNames'] = self.skill_group_names
        if self.skill_group_ids is not None:
            result['SkillGroupIds'] = self.skill_group_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Overall') is not None:
            temp_model = ListAgentSummaryReportsResponseBodyPagedAgentSummaryReportListAgentSummaryReportOverall()
            self.overall = temp_model.from_map(m['Overall'])
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('Inbound') is not None:
            temp_model = ListAgentSummaryReportsResponseBodyPagedAgentSummaryReportListAgentSummaryReportInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = ListAgentSummaryReportsResponseBodyPagedAgentSummaryReportListAgentSummaryReportOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupNames') is not None:
            self.skill_group_names = m.get('SkillGroupNames')
        if m.get('SkillGroupIds') is not None:
            self.skill_group_ids = m.get('SkillGroupIds')
        return self


class ListAgentSummaryReportsResponseBodyPagedAgentSummaryReportList(TeaModel):
    def __init__(self, agent_summary_report=None):
        self.agent_summary_report = agent_summary_report  # type: list[ListAgentSummaryReportsResponseBodyPagedAgentSummaryReportListAgentSummaryReport]

    def validate(self):
        if self.agent_summary_report:
            for k in self.agent_summary_report:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['AgentSummaryReport'] = []
        if self.agent_summary_report is not None:
            for k in self.agent_summary_report:
                result['AgentSummaryReport'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.agent_summary_report = []
        if m.get('AgentSummaryReport') is not None:
            for k in m.get('AgentSummaryReport'):
                temp_model = ListAgentSummaryReportsResponseBodyPagedAgentSummaryReportListAgentSummaryReport()
                self.agent_summary_report.append(temp_model.from_map(k))
        return self


class ListAgentSummaryReportsResponseBodyPagedAgentSummaryReport(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: ListAgentSummaryReportsResponseBodyPagedAgentSummaryReportList
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = ListAgentSummaryReportsResponseBodyPagedAgentSummaryReportList()
            self.list = temp_model.from_map(m['List'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAgentSummaryReportsResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, paged_agent_summary_report=None, http_status_code=None,
                 code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.paged_agent_summary_report = paged_agent_summary_report  # type: ListAgentSummaryReportsResponseBodyPagedAgentSummaryReport
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.paged_agent_summary_report:
            self.paged_agent_summary_report.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.paged_agent_summary_report is not None:
            result['PagedAgentSummaryReport'] = self.paged_agent_summary_report.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PagedAgentSummaryReport') is not None:
            temp_model = ListAgentSummaryReportsResponseBodyPagedAgentSummaryReport()
            self.paged_agent_summary_report = temp_model.from_map(m['PagedAgentSummaryReport'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListAgentSummaryReportsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListAgentSummaryReportsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAgentSummaryReportsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAgentSummaryReportsByIntervalRequest(TeaModel):
    def __init__(self, instance_id=None, skill_group_id=None, agent_ids=None, interval=None, start_time=None,
                 end_time=None, page_number=None, page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.skill_group_id = TeaConverter.to_unicode(skill_group_id)  # type: unicode
        self.agent_ids = TeaConverter.to_unicode(agent_ids)  # type: unicode
        self.interval = TeaConverter.to_unicode(interval)  # type: unicode
        self.start_time = TeaConverter.to_unicode(start_time)  # type: unicode
        self.end_time = TeaConverter.to_unicode(end_time)  # type: unicode
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportListAgentTimeIntervalReportIntervalListAgentSummaryReportOverall(TeaModel):
    def __init__(self, total_logged_in_time=None, total_talk_time=None, occupancy_rate=None,
                 last_log_out_time=None, total_work_time=None, first_log_in_time=None, max_work_time=None, average_talk_time=None,
                 average_work_time=None, satisfaction_index=None, satisfaction_surveys_offered=None,
                 satisfaction_surveys_responded=None, average_ready_time=None, max_ready_time=None, one_transfer_calls=None, max_talk_time=None,
                 total_ready_time=None, total_break_time=None, total_calls=None):
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.last_log_out_time = TeaConverter.to_unicode(last_log_out_time)  # type: unicode
        self.total_work_time = total_work_time  # type: long
        self.first_log_in_time = TeaConverter.to_unicode(first_log_in_time)  # type: unicode
        self.max_work_time = max_work_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.average_ready_time = average_ready_time  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.one_transfer_calls = one_transfer_calls  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.total_ready_time = total_ready_time  # type: long
        self.total_break_time = total_break_time  # type: long
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.last_log_out_time is not None:
            result['LastLogOutTime'] = self.last_log_out_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.first_log_in_time is not None:
            result['FirstLogInTime'] = self.first_log_in_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.one_transfer_calls is not None:
            result['OneTransferCalls'] = self.one_transfer_calls
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('LastLogOutTime') is not None:
            self.last_log_out_time = m.get('LastLogOutTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('FirstLogInTime') is not None:
            self.first_log_in_time = m.get('FirstLogInTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('OneTransferCalls') is not None:
            self.one_transfer_calls = m.get('OneTransferCalls')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportListAgentTimeIntervalReportIntervalListAgentSummaryReportInbound(TeaModel):
    def __init__(self, total_talk_time=None, average_ring_time=None, calls_offered=None, calls_handled=None,
                 service_level_20=None, total_work_time=None, max_work_time=None, average_talk_time=None, average_work_time=None,
                 satisfaction_index=None, satisfaction_surveys_offered=None, handle_rate=None, satisfaction_surveys_responded=None,
                 total_ring_time=None, max_talk_time=None, max_ring_time=None):
        self.total_talk_time = total_talk_time  # type: long
        self.average_ring_time = average_ring_time  # type: long
        self.calls_offered = calls_offered  # type: long
        self.calls_handled = calls_handled  # type: long
        self.service_level_20 = service_level_20  # type: float
        self.total_work_time = total_work_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.handle_rate = handle_rate  # type: float
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_ring_time = max_ring_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.service_level_20 is not None:
            result['ServiceLevel20'] = self.service_level_20
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('ServiceLevel20') is not None:
            self.service_level_20 = m.get('ServiceLevel20')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        return self


class ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportListAgentTimeIntervalReportIntervalListAgentSummaryReportOutbound(TeaModel):
    def __init__(self, total_talk_time=None, max_dialing_time=None, calls_dialed=None, calls_answered=None,
                 total_work_time=None, answer_rate=None, max_work_time=None, total_dialing_time=None, average_work_time=None,
                 average_talk_time=None, satisfaction_index=None, satisfaction_surveys_offered=None,
                 satisfaction_surveys_responded=None, max_talk_time=None, average_dialing_time=None):
        self.total_talk_time = total_talk_time  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.calls_answered = calls_answered  # type: long
        self.total_work_time = total_work_time  # type: long
        self.answer_rate = answer_rate  # type: float
        self.max_work_time = max_work_time  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.average_dialing_time = average_dialing_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        return self


class ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportListAgentTimeIntervalReportIntervalListAgentSummaryReport(TeaModel):
    def __init__(self, overall=None, login_name=None, agent_id=None, inbound=None, outbound=None, agent_name=None,
                 skill_group_names=None, timestamp=None, instance_id=None, skill_group_ids=None):
        self.overall = overall  # type: ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportListAgentTimeIntervalReportIntervalListAgentSummaryReportOverall
        self.login_name = TeaConverter.to_unicode(login_name)  # type: unicode
        self.agent_id = TeaConverter.to_unicode(agent_id)  # type: unicode
        self.inbound = inbound  # type: ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportListAgentTimeIntervalReportIntervalListAgentSummaryReportInbound
        self.outbound = outbound  # type: ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportListAgentTimeIntervalReportIntervalListAgentSummaryReportOutbound
        self.agent_name = TeaConverter.to_unicode(agent_name)  # type: unicode
        self.skill_group_names = TeaConverter.to_unicode(skill_group_names)  # type: unicode
        self.timestamp = TeaConverter.to_unicode(timestamp)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.skill_group_ids = TeaConverter.to_unicode(skill_group_ids)  # type: unicode

    def validate(self):
        if self.overall:
            self.overall.validate()
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()

    def to_map(self):
        result = dict()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        if self.skill_group_names is not None:
            result['SkillGroupNames'] = self.skill_group_names
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_ids is not None:
            result['SkillGroupIds'] = self.skill_group_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Overall') is not None:
            temp_model = ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportListAgentTimeIntervalReportIntervalListAgentSummaryReportOverall()
            self.overall = temp_model.from_map(m['Overall'])
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('Inbound') is not None:
            temp_model = ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportListAgentTimeIntervalReportIntervalListAgentSummaryReportInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportListAgentTimeIntervalReportIntervalListAgentSummaryReportOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        if m.get('SkillGroupNames') is not None:
            self.skill_group_names = m.get('SkillGroupNames')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupIds') is not None:
            self.skill_group_ids = m.get('SkillGroupIds')
        return self


class ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportListAgentTimeIntervalReportIntervalList(TeaModel):
    def __init__(self, agent_summary_report=None):
        self.agent_summary_report = agent_summary_report  # type: list[ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportListAgentTimeIntervalReportIntervalListAgentSummaryReport]

    def validate(self):
        if self.agent_summary_report:
            for k in self.agent_summary_report:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['AgentSummaryReport'] = []
        if self.agent_summary_report is not None:
            for k in self.agent_summary_report:
                result['AgentSummaryReport'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.agent_summary_report = []
        if m.get('AgentSummaryReport') is not None:
            for k in m.get('AgentSummaryReport'):
                temp_model = ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportListAgentTimeIntervalReportIntervalListAgentSummaryReport()
                self.agent_summary_report.append(temp_model.from_map(k))
        return self


class ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportListAgentTimeIntervalReport(TeaModel):
    def __init__(self, agent_id=None, interval_list=None):
        self.agent_id = TeaConverter.to_unicode(agent_id)  # type: unicode
        self.interval_list = interval_list  # type: ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportListAgentTimeIntervalReportIntervalList

    def validate(self):
        if self.interval_list:
            self.interval_list.validate()

    def to_map(self):
        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.interval_list is not None:
            result['IntervalList'] = self.interval_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('IntervalList') is not None:
            temp_model = ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportListAgentTimeIntervalReportIntervalList()
            self.interval_list = temp_model.from_map(m['IntervalList'])
        return self


class ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportList(TeaModel):
    def __init__(self, agent_time_interval_report=None):
        self.agent_time_interval_report = agent_time_interval_report  # type: list[ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportListAgentTimeIntervalReport]

    def validate(self):
        if self.agent_time_interval_report:
            for k in self.agent_time_interval_report:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['AgentTimeIntervalReport'] = []
        if self.agent_time_interval_report is not None:
            for k in self.agent_time_interval_report:
                result['AgentTimeIntervalReport'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.agent_time_interval_report = []
        if m.get('AgentTimeIntervalReport') is not None:
            for k in m.get('AgentTimeIntervalReport'):
                temp_model = ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportListAgentTimeIntervalReport()
                self.agent_time_interval_report.append(temp_model.from_map(k))
        return self


class ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReport(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportList
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReportList()
            self.list = temp_model.from_map(m['List'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAgentSummaryReportsByIntervalResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, paged_agent_summary_report=None, http_status_code=None,
                 code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.paged_agent_summary_report = paged_agent_summary_report  # type: ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReport
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.paged_agent_summary_report:
            self.paged_agent_summary_report.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.paged_agent_summary_report is not None:
            result['PagedAgentSummaryReport'] = self.paged_agent_summary_report.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PagedAgentSummaryReport') is not None:
            temp_model = ListAgentSummaryReportsByIntervalResponseBodyPagedAgentSummaryReport()
            self.paged_agent_summary_report = temp_model.from_map(m['PagedAgentSummaryReport'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListAgentSummaryReportsByIntervalResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListAgentSummaryReportsByIntervalResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAgentSummaryReportsByIntervalResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAgentSummaryReportsSinceMidnightRequest(TeaModel):
    def __init__(self, instance_id=None, skill_group_id=None, agent_ids=None, page_number=None, page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.skill_group_id = TeaConverter.to_unicode(skill_group_id)  # type: unicode
        self.agent_ids = TeaConverter.to_unicode(agent_ids)  # type: unicode
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListAgentSummaryReportOverall(TeaModel):
    def __init__(self, total_logged_in_time=None, total_talk_time=None, occupancy_rate=None, total_work_time=None,
                 max_work_time=None, average_talk_time=None, average_work_time=None, satisfaction_index=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, max_ready_time=None, average_ready_time=None,
                 one_transfer_calls=None, max_talk_time=None, total_ready_time=None, total_break_time=None, total_calls=None):
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.total_work_time = total_work_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.average_ready_time = average_ready_time  # type: long
        self.one_transfer_calls = one_transfer_calls  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.total_ready_time = total_ready_time  # type: long
        self.total_break_time = total_break_time  # type: long
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.one_transfer_calls is not None:
            result['OneTransferCalls'] = self.one_transfer_calls
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('OneTransferCalls') is not None:
            self.one_transfer_calls = m.get('OneTransferCalls')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListAgentSummaryReportInbound(TeaModel):
    def __init__(self, total_talk_time=None, average_ring_time=None, calls_offered=None, calls_handled=None,
                 service_level_20=None, total_work_time=None, max_work_time=None, average_talk_time=None, average_work_time=None,
                 satisfaction_index=None, satisfaction_surveys_offered=None, handle_rate=None, satisfaction_surveys_responded=None,
                 total_ring_time=None, max_talk_time=None, max_ring_time=None):
        self.total_talk_time = total_talk_time  # type: long
        self.average_ring_time = average_ring_time  # type: long
        self.calls_offered = calls_offered  # type: long
        self.calls_handled = calls_handled  # type: long
        self.service_level_20 = service_level_20  # type: float
        self.total_work_time = total_work_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.handle_rate = handle_rate  # type: float
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_ring_time = max_ring_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.service_level_20 is not None:
            result['ServiceLevel20'] = self.service_level_20
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('ServiceLevel20') is not None:
            self.service_level_20 = m.get('ServiceLevel20')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        return self


class ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListAgentSummaryReportOutbound(TeaModel):
    def __init__(self, total_talk_time=None, max_dialing_time=None, calls_dialed=None, calls_answered=None,
                 total_work_time=None, answer_rate=None, max_work_time=None, total_dialing_time=None, average_work_time=None,
                 average_talk_time=None, satisfaction_index=None, satisfaction_surveys_offered=None,
                 satisfaction_surveys_responded=None, max_talk_time=None, average_dialing_time=None):
        self.total_talk_time = total_talk_time  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.calls_answered = calls_answered  # type: long
        self.total_work_time = total_work_time  # type: long
        self.answer_rate = answer_rate  # type: float
        self.max_work_time = TeaConverter.to_unicode(max_work_time)  # type: unicode
        self.total_dialing_time = total_dialing_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.average_dialing_time = average_dialing_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        return self


class ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListAgentSummaryReport(TeaModel):
    def __init__(self, overall=None, login_name=None, agent_id=None, inbound=None, outbound=None, agent_name=None,
                 skill_group_names=None, timestamp=None, instance_id=None, skill_group_ids=None):
        self.overall = overall  # type: ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListAgentSummaryReportOverall
        self.login_name = TeaConverter.to_unicode(login_name)  # type: unicode
        self.agent_id = TeaConverter.to_unicode(agent_id)  # type: unicode
        self.inbound = inbound  # type: ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListAgentSummaryReportInbound
        self.outbound = outbound  # type: ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListAgentSummaryReportOutbound
        self.agent_name = TeaConverter.to_unicode(agent_name)  # type: unicode
        self.skill_group_names = TeaConverter.to_unicode(skill_group_names)  # type: unicode
        self.timestamp = TeaConverter.to_unicode(timestamp)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.skill_group_ids = TeaConverter.to_unicode(skill_group_ids)  # type: unicode

    def validate(self):
        if self.overall:
            self.overall.validate()
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()

    def to_map(self):
        result = dict()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        if self.skill_group_names is not None:
            result['SkillGroupNames'] = self.skill_group_names
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_ids is not None:
            result['SkillGroupIds'] = self.skill_group_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Overall') is not None:
            temp_model = ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListAgentSummaryReportOverall()
            self.overall = temp_model.from_map(m['Overall'])
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('Inbound') is not None:
            temp_model = ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListAgentSummaryReportInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListAgentSummaryReportOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        if m.get('SkillGroupNames') is not None:
            self.skill_group_names = m.get('SkillGroupNames')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupIds') is not None:
            self.skill_group_ids = m.get('SkillGroupIds')
        return self


class ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportList(TeaModel):
    def __init__(self, agent_summary_report=None):
        self.agent_summary_report = agent_summary_report  # type: list[ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListAgentSummaryReport]

    def validate(self):
        if self.agent_summary_report:
            for k in self.agent_summary_report:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['AgentSummaryReport'] = []
        if self.agent_summary_report is not None:
            for k in self.agent_summary_report:
                result['AgentSummaryReport'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.agent_summary_report = []
        if m.get('AgentSummaryReport') is not None:
            for k in m.get('AgentSummaryReport'):
                temp_model = ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListAgentSummaryReport()
                self.agent_summary_report.append(temp_model.from_map(k))
        return self


class ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReport(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportList
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportList()
            self.list = temp_model.from_map(m['List'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAgentSummaryReportsSinceMidnightResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, paged_agent_summary_report=None, http_status_code=None,
                 code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.paged_agent_summary_report = paged_agent_summary_report  # type: ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReport
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.paged_agent_summary_report:
            self.paged_agent_summary_report.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.paged_agent_summary_report is not None:
            result['PagedAgentSummaryReport'] = self.paged_agent_summary_report.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PagedAgentSummaryReport') is not None:
            temp_model = ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReport()
            self.paged_agent_summary_report = temp_model.from_map(m['PagedAgentSummaryReport'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListAgentSummaryReportsSinceMidnightResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListAgentSummaryReportsSinceMidnightResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAgentSummaryReportsSinceMidnightResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListBasicStatisticsReportSubItemsRequest(TeaModel):
    def __init__(self, instance_id=None, job_group_id=None, title=None, page_number=None, page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.job_group_id = TeaConverter.to_unicode(job_group_id)  # type: unicode
        self.title = TeaConverter.to_unicode(title)  # type: unicode
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_group_id is not None:
            result['JobGroupId'] = self.job_group_id
        if self.title is not None:
            result['Title'] = self.title
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobGroupId') is not None:
            self.job_group_id = m.get('JobGroupId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListBasicStatisticsReportSubItemsResponseBodySubItemsListRow(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListBasicStatisticsReportSubItemsResponseBodySubItemsList(TeaModel):
    def __init__(self, basic_statistics_report_sub_item_name=None, value=None, percentage=None, count=None,
                 row=None):
        self.basic_statistics_report_sub_item_name = TeaConverter.to_unicode(basic_statistics_report_sub_item_name)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode
        self.percentage = percentage  # type: int
        self.count = count  # type: int
        self.row = row  # type: list[ListBasicStatisticsReportSubItemsResponseBodySubItemsListRow]

    def validate(self):
        if self.row:
            for k in self.row:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.basic_statistics_report_sub_item_name is not None:
            result['BasicStatisticsReportSubItemName'] = self.basic_statistics_report_sub_item_name
        if self.value is not None:
            result['Value'] = self.value
        if self.percentage is not None:
            result['Percentage'] = self.percentage
        if self.count is not None:
            result['Count'] = self.count
        result['Row'] = []
        if self.row is not None:
            for k in self.row:
                result['Row'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BasicStatisticsReportSubItemName') is not None:
            self.basic_statistics_report_sub_item_name = m.get('BasicStatisticsReportSubItemName')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Percentage') is not None:
            self.percentage = m.get('Percentage')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.row = []
        if m.get('Row') is not None:
            for k in m.get('Row'):
                temp_model = ListBasicStatisticsReportSubItemsResponseBodySubItemsListRow()
                self.row.append(temp_model.from_map(k))
        return self


class ListBasicStatisticsReportSubItemsResponseBodySubItems(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListBasicStatisticsReportSubItemsResponseBodySubItemsList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListBasicStatisticsReportSubItemsResponseBodySubItemsList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListBasicStatisticsReportSubItemsResponseBody(TeaModel):
    def __init__(self, sub_items=None, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.sub_items = sub_items  # type: ListBasicStatisticsReportSubItemsResponseBodySubItems
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.sub_items:
            self.sub_items.validate()

    def to_map(self):
        result = dict()
        if self.sub_items is not None:
            result['SubItems'] = self.sub_items.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SubItems') is not None:
            temp_model = ListBasicStatisticsReportSubItemsResponseBodySubItems()
            self.sub_items = temp_model.from_map(m['SubItems'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListBasicStatisticsReportSubItemsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListBasicStatisticsReportSubItemsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListBasicStatisticsReportSubItemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCallDetailRecordsRequest(TeaModel):
    def __init__(self, instance_id=None, phone_number=None, start_time=None, stop_time=None, criteria=None,
                 contact_type=None, contact_disposition=None, with_recording=None, contact_id=None, order_by=None,
                 page_number=None, page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.phone_number = TeaConverter.to_unicode(phone_number)  # type: unicode
        self.start_time = start_time  # type: long
        self.stop_time = stop_time  # type: long
        self.criteria = TeaConverter.to_unicode(criteria)  # type: unicode
        self.contact_type = TeaConverter.to_unicode(contact_type)  # type: unicode
        self.contact_disposition = TeaConverter.to_unicode(contact_disposition)  # type: unicode
        self.with_recording = with_recording  # type: bool
        self.contact_id = TeaConverter.to_unicode(contact_id)  # type: unicode
        self.order_by = TeaConverter.to_unicode(order_by)  # type: unicode
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.contact_type is not None:
            result['ContactType'] = self.contact_type
        if self.contact_disposition is not None:
            result['ContactDisposition'] = self.contact_disposition
        if self.with_recording is not None:
            result['WithRecording'] = self.with_recording
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StopTime') is not None:
            self.stop_time = m.get('StopTime')
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('ContactType') is not None:
            self.contact_type = m.get('ContactType')
        if m.get('ContactDisposition') is not None:
            self.contact_disposition = m.get('ContactDisposition')
        if m.get('WithRecording') is not None:
            self.with_recording = m.get('WithRecording')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListCallDetailRecordsResponseBodyCallDetailRecordsListCallDetailRecordRecordingsRecording(TeaModel):
    def __init__(self, start_time=None, contact_id=None, quality_check_task_id=None, agent_id=None,
                 file_description=None, duration=None, agent_name=None, file_name=None, quality_check_tid=None):
        self.start_time = start_time  # type: long
        self.contact_id = TeaConverter.to_unicode(contact_id)  # type: unicode
        self.quality_check_task_id = TeaConverter.to_unicode(quality_check_task_id)  # type: unicode
        self.agent_id = TeaConverter.to_unicode(agent_id)  # type: unicode
        self.file_description = TeaConverter.to_unicode(file_description)  # type: unicode
        self.duration = duration  # type: int
        self.agent_name = TeaConverter.to_unicode(agent_name)  # type: unicode
        self.file_name = TeaConverter.to_unicode(file_name)  # type: unicode
        self.quality_check_tid = TeaConverter.to_unicode(quality_check_tid)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.quality_check_task_id is not None:
            result['QualityCheckTaskId'] = self.quality_check_task_id
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.file_description is not None:
            result['FileDescription'] = self.file_description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.quality_check_tid is not None:
            result['QualityCheckTid'] = self.quality_check_tid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('QualityCheckTaskId') is not None:
            self.quality_check_task_id = m.get('QualityCheckTaskId')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('FileDescription') is not None:
            self.file_description = m.get('FileDescription')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('QualityCheckTid') is not None:
            self.quality_check_tid = m.get('QualityCheckTid')
        return self


class ListCallDetailRecordsResponseBodyCallDetailRecordsListCallDetailRecordRecordings(TeaModel):
    def __init__(self, recording=None):
        self.recording = recording  # type: list[ListCallDetailRecordsResponseBodyCallDetailRecordsListCallDetailRecordRecordingsRecording]

    def validate(self):
        if self.recording:
            for k in self.recording:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Recording'] = []
        if self.recording is not None:
            for k in self.recording:
                result['Recording'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.recording = []
        if m.get('Recording') is not None:
            for k in m.get('Recording'):
                temp_model = ListCallDetailRecordsResponseBodyCallDetailRecordsListCallDetailRecordRecordingsRecording()
                self.recording.append(temp_model.from_map(k))
        return self


class ListCallDetailRecordsResponseBodyCallDetailRecordsListCallDetailRecordAgentsCallDetailAgent(TeaModel):
    def __init__(self, satisfaction=None, agent_id=None, feedback=None):
        self.satisfaction = TeaConverter.to_unicode(satisfaction)  # type: unicode
        self.agent_id = TeaConverter.to_unicode(agent_id)  # type: unicode
        self.feedback = TeaConverter.to_unicode(feedback)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.satisfaction is not None:
            result['Satisfaction'] = self.satisfaction
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.feedback is not None:
            result['Feedback'] = self.feedback
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Satisfaction') is not None:
            self.satisfaction = m.get('Satisfaction')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('Feedback') is not None:
            self.feedback = m.get('Feedback')
        return self


class ListCallDetailRecordsResponseBodyCallDetailRecordsListCallDetailRecordAgents(TeaModel):
    def __init__(self, call_detail_agent=None):
        self.call_detail_agent = call_detail_agent  # type: list[ListCallDetailRecordsResponseBodyCallDetailRecordsListCallDetailRecordAgentsCallDetailAgent]

    def validate(self):
        if self.call_detail_agent:
            for k in self.call_detail_agent:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['CallDetailAgent'] = []
        if self.call_detail_agent is not None:
            for k in self.call_detail_agent:
                result['CallDetailAgent'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.call_detail_agent = []
        if m.get('CallDetailAgent') is not None:
            for k in m.get('CallDetailAgent'):
                temp_model = ListCallDetailRecordsResponseBodyCallDetailRecordsListCallDetailRecordAgentsCallDetailAgent()
                self.call_detail_agent.append(temp_model.from_map(k))
        return self


class ListCallDetailRecordsResponseBodyCallDetailRecordsListCallDetailRecord(TeaModel):
    def __init__(self, contact_disposition=None, contact_type=None, instance_id=None, skill_group_id_list=None,
                 recordings=None, called_number=None, agent_names=None, satisfaction=None, start_time=None, agents=None,
                 satisfaction_desc=None, contact_id=None, calling_number=None, duration=None, skill_group_names=None, feedback=None):
        self.contact_disposition = TeaConverter.to_unicode(contact_disposition)  # type: unicode
        self.contact_type = TeaConverter.to_unicode(contact_type)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.skill_group_id_list = TeaConverter.to_unicode(skill_group_id_list)  # type: unicode
        self.recordings = recordings  # type: ListCallDetailRecordsResponseBodyCallDetailRecordsListCallDetailRecordRecordings
        self.called_number = TeaConverter.to_unicode(called_number)  # type: unicode
        self.agent_names = TeaConverter.to_unicode(agent_names)  # type: unicode
        self.satisfaction = satisfaction  # type: int
        self.start_time = start_time  # type: long
        self.agents = agents  # type: ListCallDetailRecordsResponseBodyCallDetailRecordsListCallDetailRecordAgents
        self.satisfaction_desc = TeaConverter.to_unicode(satisfaction_desc)  # type: unicode
        self.contact_id = TeaConverter.to_unicode(contact_id)  # type: unicode
        self.calling_number = TeaConverter.to_unicode(calling_number)  # type: unicode
        self.duration = duration  # type: int
        self.skill_group_names = TeaConverter.to_unicode(skill_group_names)  # type: unicode
        self.feedback = TeaConverter.to_unicode(feedback)  # type: unicode

    def validate(self):
        if self.recordings:
            self.recordings.validate()
        if self.agents:
            self.agents.validate()

    def to_map(self):
        result = dict()
        if self.contact_disposition is not None:
            result['ContactDisposition'] = self.contact_disposition
        if self.contact_type is not None:
            result['ContactType'] = self.contact_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        if self.recordings is not None:
            result['Recordings'] = self.recordings.to_map()
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.agent_names is not None:
            result['AgentNames'] = self.agent_names
        if self.satisfaction is not None:
            result['Satisfaction'] = self.satisfaction
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.agents is not None:
            result['Agents'] = self.agents.to_map()
        if self.satisfaction_desc is not None:
            result['SatisfactionDesc'] = self.satisfaction_desc
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.skill_group_names is not None:
            result['SkillGroupNames'] = self.skill_group_names
        if self.feedback is not None:
            result['Feedback'] = self.feedback
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactDisposition') is not None:
            self.contact_disposition = m.get('ContactDisposition')
        if m.get('ContactType') is not None:
            self.contact_type = m.get('ContactType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        if m.get('Recordings') is not None:
            temp_model = ListCallDetailRecordsResponseBodyCallDetailRecordsListCallDetailRecordRecordings()
            self.recordings = temp_model.from_map(m['Recordings'])
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('AgentNames') is not None:
            self.agent_names = m.get('AgentNames')
        if m.get('Satisfaction') is not None:
            self.satisfaction = m.get('Satisfaction')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Agents') is not None:
            temp_model = ListCallDetailRecordsResponseBodyCallDetailRecordsListCallDetailRecordAgents()
            self.agents = temp_model.from_map(m['Agents'])
        if m.get('SatisfactionDesc') is not None:
            self.satisfaction_desc = m.get('SatisfactionDesc')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('SkillGroupNames') is not None:
            self.skill_group_names = m.get('SkillGroupNames')
        if m.get('Feedback') is not None:
            self.feedback = m.get('Feedback')
        return self


class ListCallDetailRecordsResponseBodyCallDetailRecordsList(TeaModel):
    def __init__(self, call_detail_record=None):
        self.call_detail_record = call_detail_record  # type: list[ListCallDetailRecordsResponseBodyCallDetailRecordsListCallDetailRecord]

    def validate(self):
        if self.call_detail_record:
            for k in self.call_detail_record:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['CallDetailRecord'] = []
        if self.call_detail_record is not None:
            for k in self.call_detail_record:
                result['CallDetailRecord'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.call_detail_record = []
        if m.get('CallDetailRecord') is not None:
            for k in m.get('CallDetailRecord'):
                temp_model = ListCallDetailRecordsResponseBodyCallDetailRecordsListCallDetailRecord()
                self.call_detail_record.append(temp_model.from_map(k))
        return self


class ListCallDetailRecordsResponseBodyCallDetailRecords(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: ListCallDetailRecordsResponseBodyCallDetailRecordsList
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = ListCallDetailRecordsResponseBodyCallDetailRecordsList()
            self.list = temp_model.from_map(m['List'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListCallDetailRecordsResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, call_detail_records=None, http_status_code=None, code=None,
                 success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.call_detail_records = call_detail_records  # type: ListCallDetailRecordsResponseBodyCallDetailRecords
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.call_detail_records:
            self.call_detail_records.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.call_detail_records is not None:
            result['CallDetailRecords'] = self.call_detail_records.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CallDetailRecords') is not None:
            temp_model = ListCallDetailRecordsResponseBodyCallDetailRecords()
            self.call_detail_records = temp_model.from_map(m['CallDetailRecords'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListCallDetailRecordsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListCallDetailRecordsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListCallDetailRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCallEventDetailByContactIdRequest(TeaModel):
    def __init__(self, instance_id=None, contact_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.contact_id = TeaConverter.to_unicode(contact_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        return self


class ListCallEventDetailByContactIdResponseBodyDataEventsCallEventDetailDetailData(TeaModel):
    def __init__(self, hang_uper=None, event_type=None, helper=None, skill_group=None, satisfactional_research=None):
        self.hang_uper = TeaConverter.to_unicode(hang_uper)  # type: unicode
        self.event_type = TeaConverter.to_unicode(event_type)  # type: unicode
        self.helper = TeaConverter.to_unicode(helper)  # type: unicode
        self.skill_group = TeaConverter.to_unicode(skill_group)  # type: unicode
        self.satisfactional_research = TeaConverter.to_unicode(satisfactional_research)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.hang_uper is not None:
            result['HangUper'] = self.hang_uper
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.helper is not None:
            result['Helper'] = self.helper
        if self.skill_group is not None:
            result['SkillGroup'] = self.skill_group
        if self.satisfactional_research is not None:
            result['SatisfactionalResearch'] = self.satisfactional_research
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HangUper') is not None:
            self.hang_uper = m.get('HangUper')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('Helper') is not None:
            self.helper = m.get('Helper')
        if m.get('SkillGroup') is not None:
            self.skill_group = m.get('SkillGroup')
        if m.get('SatisfactionalResearch') is not None:
            self.satisfactional_research = m.get('SatisfactionalResearch')
        return self


class ListCallEventDetailByContactIdResponseBodyDataEventsCallEventDetail(TeaModel):
    def __init__(self, status=None, call_mode=None, detail_data=None, event=None, time_stamp=None, agent_name=None,
                 duration=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.call_mode = TeaConverter.to_unicode(call_mode)  # type: unicode
        self.detail_data = detail_data  # type: ListCallEventDetailByContactIdResponseBodyDataEventsCallEventDetailDetailData
        self.event = TeaConverter.to_unicode(event)  # type: unicode
        self.time_stamp = TeaConverter.to_unicode(time_stamp)  # type: unicode
        self.agent_name = TeaConverter.to_unicode(agent_name)  # type: unicode
        self.duration = duration  # type: int

    def validate(self):
        if self.detail_data:
            self.detail_data.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.call_mode is not None:
            result['CallMode'] = self.call_mode
        if self.detail_data is not None:
            result['DetailData'] = self.detail_data.to_map()
        if self.event is not None:
            result['Event'] = self.event
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CallMode') is not None:
            self.call_mode = m.get('CallMode')
        if m.get('DetailData') is not None:
            temp_model = ListCallEventDetailByContactIdResponseBodyDataEventsCallEventDetailDetailData()
            self.detail_data = temp_model.from_map(m['DetailData'])
        if m.get('Event') is not None:
            self.event = m.get('Event')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class ListCallEventDetailByContactIdResponseBodyDataEvents(TeaModel):
    def __init__(self, call_event_detail=None):
        self.call_event_detail = call_event_detail  # type: list[ListCallEventDetailByContactIdResponseBodyDataEventsCallEventDetail]

    def validate(self):
        if self.call_event_detail:
            for k in self.call_event_detail:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['CallEventDetail'] = []
        if self.call_event_detail is not None:
            for k in self.call_event_detail:
                result['CallEventDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.call_event_detail = []
        if m.get('CallEventDetail') is not None:
            for k in m.get('CallEventDetail'):
                temp_model = ListCallEventDetailByContactIdResponseBodyDataEventsCallEventDetail()
                self.call_event_detail.append(temp_model.from_map(k))
        return self


class ListCallEventDetailByContactIdResponseBodyData(TeaModel):
    def __init__(self, start_time=None, release_reason=None, call_type=None, release_agent=None, caller=None,
                 callee=None, events=None, privacy_number=None):
        self.start_time = TeaConverter.to_unicode(start_time)  # type: unicode
        self.release_reason = TeaConverter.to_unicode(release_reason)  # type: unicode
        self.call_type = TeaConverter.to_unicode(call_type)  # type: unicode
        self.release_agent = TeaConverter.to_unicode(release_agent)  # type: unicode
        self.caller = TeaConverter.to_unicode(caller)  # type: unicode
        self.callee = TeaConverter.to_unicode(callee)  # type: unicode
        self.events = events  # type: ListCallEventDetailByContactIdResponseBodyDataEvents
        self.privacy_number = TeaConverter.to_unicode(privacy_number)  # type: unicode

    def validate(self):
        if self.events:
            self.events.validate()

    def to_map(self):
        result = dict()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.release_agent is not None:
            result['ReleaseAgent'] = self.release_agent
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.callee is not None:
            result['Callee'] = self.callee
        if self.events is not None:
            result['Events'] = self.events.to_map()
        if self.privacy_number is not None:
            result['PrivacyNumber'] = self.privacy_number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ReleaseAgent') is not None:
            self.release_agent = m.get('ReleaseAgent')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('Callee') is not None:
            self.callee = m.get('Callee')
        if m.get('Events') is not None:
            temp_model = ListCallEventDetailByContactIdResponseBodyDataEvents()
            self.events = temp_model.from_map(m['Events'])
        if m.get('PrivacyNumber') is not None:
            self.privacy_number = m.get('PrivacyNumber')
        return self


class ListCallEventDetailByContactIdResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, data=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: ListCallEventDetailByContactIdResponseBodyData
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            temp_model = ListCallEventDetailByContactIdResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListCallEventDetailByContactIdResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListCallEventDetailByContactIdResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListCallEventDetailByContactIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCallMeasureSummaryReportsRequest(TeaModel):
    def __init__(self, interval_type=None):
        self.interval_type = TeaConverter.to_unicode(interval_type)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.interval_type is not None:
            result['IntervalType'] = self.interval_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IntervalType') is not None:
            self.interval_type = m.get('IntervalType')
        return self


class ListCallMeasureSummaryReportsResponseBodyCallMeasureSummaryReportListCallMeasureSummaryReport(TeaModel):
    def __init__(self, day=None, year=None, inbound_duration_by_minute=None, outbound_count=None,
                 outbound_duration_by_minute=None, inbound_count=None, month=None):
        self.day = TeaConverter.to_unicode(day)  # type: unicode
        self.year = TeaConverter.to_unicode(year)  # type: unicode
        self.inbound_duration_by_minute = inbound_duration_by_minute  # type: long
        self.outbound_count = outbound_count  # type: long
        self.outbound_duration_by_minute = outbound_duration_by_minute  # type: long
        self.inbound_count = inbound_count  # type: long
        self.month = TeaConverter.to_unicode(month)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.day is not None:
            result['Day'] = self.day
        if self.year is not None:
            result['Year'] = self.year
        if self.inbound_duration_by_minute is not None:
            result['InboundDurationByMinute'] = self.inbound_duration_by_minute
        if self.outbound_count is not None:
            result['OutboundCount'] = self.outbound_count
        if self.outbound_duration_by_minute is not None:
            result['OutboundDurationByMinute'] = self.outbound_duration_by_minute
        if self.inbound_count is not None:
            result['InboundCount'] = self.inbound_count
        if self.month is not None:
            result['Month'] = self.month
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Day') is not None:
            self.day = m.get('Day')
        if m.get('Year') is not None:
            self.year = m.get('Year')
        if m.get('InboundDurationByMinute') is not None:
            self.inbound_duration_by_minute = m.get('InboundDurationByMinute')
        if m.get('OutboundCount') is not None:
            self.outbound_count = m.get('OutboundCount')
        if m.get('OutboundDurationByMinute') is not None:
            self.outbound_duration_by_minute = m.get('OutboundDurationByMinute')
        if m.get('InboundCount') is not None:
            self.inbound_count = m.get('InboundCount')
        if m.get('Month') is not None:
            self.month = m.get('Month')
        return self


class ListCallMeasureSummaryReportsResponseBodyCallMeasureSummaryReportList(TeaModel):
    def __init__(self, call_measure_summary_report=None):
        self.call_measure_summary_report = call_measure_summary_report  # type: list[ListCallMeasureSummaryReportsResponseBodyCallMeasureSummaryReportListCallMeasureSummaryReport]

    def validate(self):
        if self.call_measure_summary_report:
            for k in self.call_measure_summary_report:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['CallMeasureSummaryReport'] = []
        if self.call_measure_summary_report is not None:
            for k in self.call_measure_summary_report:
                result['CallMeasureSummaryReport'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.call_measure_summary_report = []
        if m.get('CallMeasureSummaryReport') is not None:
            for k in m.get('CallMeasureSummaryReport'):
                temp_model = ListCallMeasureSummaryReportsResponseBodyCallMeasureSummaryReportListCallMeasureSummaryReport()
                self.call_measure_summary_report.append(temp_model.from_map(k))
        return self


class ListCallMeasureSummaryReportsResponseBody(TeaModel):
    def __init__(self, call_measure_summary_report_list=None, message=None, request_id=None, http_status_code=None,
                 code=None, success=None):
        self.call_measure_summary_report_list = call_measure_summary_report_list  # type: ListCallMeasureSummaryReportsResponseBodyCallMeasureSummaryReportList
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.call_measure_summary_report_list:
            self.call_measure_summary_report_list.validate()

    def to_map(self):
        result = dict()
        if self.call_measure_summary_report_list is not None:
            result['CallMeasureSummaryReportList'] = self.call_measure_summary_report_list.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallMeasureSummaryReportList') is not None:
            temp_model = ListCallMeasureSummaryReportsResponseBodyCallMeasureSummaryReportList()
            self.call_measure_summary_report_list = temp_model.from_map(m['CallMeasureSummaryReportList'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListCallMeasureSummaryReportsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListCallMeasureSummaryReportsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListCallMeasureSummaryReportsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConfigRequest(TeaModel):
    def __init__(self, instance_id=None, config_item=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.config_item = config_item  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.config_item is not None:
            result['ConfigItem'] = self.config_item
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ConfigItem') is not None:
            self.config_item = m.get('ConfigItem')
        return self


class ListConfigResponseBodyConfigItemsConfigItem(TeaModel):
    def __init__(self, value=None, name=None):
        self.value = TeaConverter.to_unicode(value)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ListConfigResponseBodyConfigItems(TeaModel):
    def __init__(self, config_item=None):
        self.config_item = config_item  # type: list[ListConfigResponseBodyConfigItemsConfigItem]

    def validate(self):
        if self.config_item:
            for k in self.config_item:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ConfigItem'] = []
        if self.config_item is not None:
            for k in self.config_item:
                result['ConfigItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.config_item = []
        if m.get('ConfigItem') is not None:
            for k in m.get('ConfigItem'):
                temp_model = ListConfigResponseBodyConfigItemsConfigItem()
                self.config_item.append(temp_model.from_map(k))
        return self


class ListConfigResponseBody(TeaModel):
    def __init__(self, config_items=None, message=None, request_id=None, http_status_code=None, code=None,
                 success=None):
        self.config_items = config_items  # type: ListConfigResponseBodyConfigItems
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.config_items:
            self.config_items.validate()

    def to_map(self):
        result = dict()
        if self.config_items is not None:
            result['ConfigItems'] = self.config_items.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigItems') is not None:
            temp_model = ListConfigResponseBodyConfigItems()
            self.config_items = temp_model.from_map(m['ConfigItems'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListContactFlowsRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListContactFlowsResponseBodyContactFlowsContactFlowPhoneNumbersPhoneNumber(TeaModel):
    def __init__(self, test_only=None, trunks=None, remaining_time=None, number=None, instance_id=None, usage=None,
                 allow_outbound=None, phone_number_description=None, phone_number_id=None):
        self.test_only = test_only  # type: bool
        self.trunks = trunks  # type: int
        self.remaining_time = remaining_time  # type: int
        self.number = TeaConverter.to_unicode(number)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.usage = TeaConverter.to_unicode(usage)  # type: unicode
        self.allow_outbound = allow_outbound  # type: bool
        self.phone_number_description = TeaConverter.to_unicode(phone_number_description)  # type: unicode
        self.phone_number_id = TeaConverter.to_unicode(phone_number_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.test_only is not None:
            result['TestOnly'] = self.test_only
        if self.trunks is not None:
            result['Trunks'] = self.trunks
        if self.remaining_time is not None:
            result['RemainingTime'] = self.remaining_time
        if self.number is not None:
            result['Number'] = self.number
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.allow_outbound is not None:
            result['AllowOutbound'] = self.allow_outbound
        if self.phone_number_description is not None:
            result['PhoneNumberDescription'] = self.phone_number_description
        if self.phone_number_id is not None:
            result['PhoneNumberId'] = self.phone_number_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TestOnly') is not None:
            self.test_only = m.get('TestOnly')
        if m.get('Trunks') is not None:
            self.trunks = m.get('Trunks')
        if m.get('RemainingTime') is not None:
            self.remaining_time = m.get('RemainingTime')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('AllowOutbound') is not None:
            self.allow_outbound = m.get('AllowOutbound')
        if m.get('PhoneNumberDescription') is not None:
            self.phone_number_description = m.get('PhoneNumberDescription')
        if m.get('PhoneNumberId') is not None:
            self.phone_number_id = m.get('PhoneNumberId')
        return self


class ListContactFlowsResponseBodyContactFlowsContactFlowPhoneNumbers(TeaModel):
    def __init__(self, phone_number=None):
        self.phone_number = phone_number  # type: list[ListContactFlowsResponseBodyContactFlowsContactFlowPhoneNumbersPhoneNumber]

    def validate(self):
        if self.phone_number:
            for k in self.phone_number:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PhoneNumber'] = []
        if self.phone_number is not None:
            for k in self.phone_number:
                result['PhoneNumber'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.phone_number = []
        if m.get('PhoneNumber') is not None:
            for k in m.get('PhoneNumber'):
                temp_model = ListContactFlowsResponseBodyContactFlowsContactFlowPhoneNumbersPhoneNumber()
                self.phone_number.append(temp_model.from_map(k))
        return self


class ListContactFlowsResponseBodyContactFlowsContactFlowVersionsContactFlowVersion(TeaModel):
    def __init__(self, status=None, last_modified=None, locked_by=None, version=None, contact_flow_version_id=None,
                 contact_flow_version_description=None, last_modified_by=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.last_modified = TeaConverter.to_unicode(last_modified)  # type: unicode
        self.locked_by = TeaConverter.to_unicode(locked_by)  # type: unicode
        self.version = TeaConverter.to_unicode(version)  # type: unicode
        self.contact_flow_version_id = TeaConverter.to_unicode(contact_flow_version_id)  # type: unicode
        self.contact_flow_version_description = TeaConverter.to_unicode(contact_flow_version_description)  # type: unicode
        self.last_modified_by = TeaConverter.to_unicode(last_modified_by)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.last_modified is not None:
            result['LastModified'] = self.last_modified
        if self.locked_by is not None:
            result['LockedBy'] = self.locked_by
        if self.version is not None:
            result['Version'] = self.version
        if self.contact_flow_version_id is not None:
            result['ContactFlowVersionId'] = self.contact_flow_version_id
        if self.contact_flow_version_description is not None:
            result['ContactFlowVersionDescription'] = self.contact_flow_version_description
        if self.last_modified_by is not None:
            result['LastModifiedBy'] = self.last_modified_by
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('LastModified') is not None:
            self.last_modified = m.get('LastModified')
        if m.get('LockedBy') is not None:
            self.locked_by = m.get('LockedBy')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('ContactFlowVersionId') is not None:
            self.contact_flow_version_id = m.get('ContactFlowVersionId')
        if m.get('ContactFlowVersionDescription') is not None:
            self.contact_flow_version_description = m.get('ContactFlowVersionDescription')
        if m.get('LastModifiedBy') is not None:
            self.last_modified_by = m.get('LastModifiedBy')
        return self


class ListContactFlowsResponseBodyContactFlowsContactFlowVersions(TeaModel):
    def __init__(self, contact_flow_version=None):
        self.contact_flow_version = contact_flow_version  # type: list[ListContactFlowsResponseBodyContactFlowsContactFlowVersionsContactFlowVersion]

    def validate(self):
        if self.contact_flow_version:
            for k in self.contact_flow_version:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ContactFlowVersion'] = []
        if self.contact_flow_version is not None:
            for k in self.contact_flow_version:
                result['ContactFlowVersion'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.contact_flow_version = []
        if m.get('ContactFlowVersion') is not None:
            for k in m.get('ContactFlowVersion'):
                temp_model = ListContactFlowsResponseBodyContactFlowsContactFlowVersionsContactFlowVersion()
                self.contact_flow_version.append(temp_model.from_map(k))
        return self


class ListContactFlowsResponseBodyContactFlowsContactFlow(TeaModel):
    def __init__(self, contact_flow_description=None, type=None, phone_numbers=None, contact_flow_name=None,
                 versions=None, instance_id=None, contact_flow_id=None, applied_version=None):
        self.contact_flow_description = TeaConverter.to_unicode(contact_flow_description)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.phone_numbers = phone_numbers  # type: ListContactFlowsResponseBodyContactFlowsContactFlowPhoneNumbers
        self.contact_flow_name = TeaConverter.to_unicode(contact_flow_name)  # type: unicode
        self.versions = versions  # type: ListContactFlowsResponseBodyContactFlowsContactFlowVersions
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.contact_flow_id = TeaConverter.to_unicode(contact_flow_id)  # type: unicode
        self.applied_version = TeaConverter.to_unicode(applied_version)  # type: unicode

    def validate(self):
        if self.phone_numbers:
            self.phone_numbers.validate()
        if self.versions:
            self.versions.validate()

    def to_map(self):
        result = dict()
        if self.contact_flow_description is not None:
            result['ContactFlowDescription'] = self.contact_flow_description
        if self.type is not None:
            result['Type'] = self.type
        if self.phone_numbers is not None:
            result['PhoneNumbers'] = self.phone_numbers.to_map()
        if self.contact_flow_name is not None:
            result['ContactFlowName'] = self.contact_flow_name
        if self.versions is not None:
            result['Versions'] = self.versions.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.applied_version is not None:
            result['AppliedVersion'] = self.applied_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactFlowDescription') is not None:
            self.contact_flow_description = m.get('ContactFlowDescription')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('PhoneNumbers') is not None:
            temp_model = ListContactFlowsResponseBodyContactFlowsContactFlowPhoneNumbers()
            self.phone_numbers = temp_model.from_map(m['PhoneNumbers'])
        if m.get('ContactFlowName') is not None:
            self.contact_flow_name = m.get('ContactFlowName')
        if m.get('Versions') is not None:
            temp_model = ListContactFlowsResponseBodyContactFlowsContactFlowVersions()
            self.versions = temp_model.from_map(m['Versions'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('AppliedVersion') is not None:
            self.applied_version = m.get('AppliedVersion')
        return self


class ListContactFlowsResponseBodyContactFlows(TeaModel):
    def __init__(self, contact_flow=None):
        self.contact_flow = contact_flow  # type: list[ListContactFlowsResponseBodyContactFlowsContactFlow]

    def validate(self):
        if self.contact_flow:
            for k in self.contact_flow:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ContactFlow'] = []
        if self.contact_flow is not None:
            for k in self.contact_flow:
                result['ContactFlow'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.contact_flow = []
        if m.get('ContactFlow') is not None:
            for k in m.get('ContactFlow'):
                temp_model = ListContactFlowsResponseBodyContactFlowsContactFlow()
                self.contact_flow.append(temp_model.from_map(k))
        return self


class ListContactFlowsResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, contact_flows=None, http_status_code=None, code=None,
                 success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.contact_flows = contact_flows  # type: ListContactFlowsResponseBodyContactFlows
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.contact_flows:
            self.contact_flows.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.contact_flows is not None:
            result['ContactFlows'] = self.contact_flows.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ContactFlows') is not None:
            temp_model = ListContactFlowsResponseBodyContactFlows()
            self.contact_flows = temp_model.from_map(m['ContactFlows'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListContactFlowsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListContactFlowsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListContactFlowsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInstancesOfUserResponseBodyInstancesCallCenterInstancePhoneNumbersPhoneNumber(TeaModel):
    def __init__(self, test_only=None, trunks=None, remaining_time=None, number=None, instance_id=None, usage=None,
                 allow_outbound=None, phone_number_description=None, phone_number_id=None):
        self.test_only = test_only  # type: bool
        self.trunks = trunks  # type: int
        self.remaining_time = remaining_time  # type: int
        self.number = TeaConverter.to_unicode(number)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.usage = TeaConverter.to_unicode(usage)  # type: unicode
        self.allow_outbound = allow_outbound  # type: bool
        self.phone_number_description = TeaConverter.to_unicode(phone_number_description)  # type: unicode
        self.phone_number_id = TeaConverter.to_unicode(phone_number_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.test_only is not None:
            result['TestOnly'] = self.test_only
        if self.trunks is not None:
            result['Trunks'] = self.trunks
        if self.remaining_time is not None:
            result['RemainingTime'] = self.remaining_time
        if self.number is not None:
            result['Number'] = self.number
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.allow_outbound is not None:
            result['AllowOutbound'] = self.allow_outbound
        if self.phone_number_description is not None:
            result['PhoneNumberDescription'] = self.phone_number_description
        if self.phone_number_id is not None:
            result['PhoneNumberId'] = self.phone_number_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TestOnly') is not None:
            self.test_only = m.get('TestOnly')
        if m.get('Trunks') is not None:
            self.trunks = m.get('Trunks')
        if m.get('RemainingTime') is not None:
            self.remaining_time = m.get('RemainingTime')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('AllowOutbound') is not None:
            self.allow_outbound = m.get('AllowOutbound')
        if m.get('PhoneNumberDescription') is not None:
            self.phone_number_description = m.get('PhoneNumberDescription')
        if m.get('PhoneNumberId') is not None:
            self.phone_number_id = m.get('PhoneNumberId')
        return self


class ListInstancesOfUserResponseBodyInstancesCallCenterInstancePhoneNumbers(TeaModel):
    def __init__(self, phone_number=None):
        self.phone_number = phone_number  # type: list[ListInstancesOfUserResponseBodyInstancesCallCenterInstancePhoneNumbersPhoneNumber]

    def validate(self):
        if self.phone_number:
            for k in self.phone_number:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PhoneNumber'] = []
        if self.phone_number is not None:
            for k in self.phone_number:
                result['PhoneNumber'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.phone_number = []
        if m.get('PhoneNumber') is not None:
            for k in m.get('PhoneNumber'):
                temp_model = ListInstancesOfUserResponseBodyInstancesCallCenterInstancePhoneNumbersPhoneNumber()
                self.phone_number.append(temp_model.from_map(k))
        return self


class ListInstancesOfUserResponseBodyInstancesCallCenterInstanceAdminUserDetail(TeaModel):
    def __init__(self, display_name=None, email=None, login_name=None, department=None, phone=None):
        self.display_name = TeaConverter.to_unicode(display_name)  # type: unicode
        self.email = TeaConverter.to_unicode(email)  # type: unicode
        self.login_name = TeaConverter.to_unicode(login_name)  # type: unicode
        self.department = TeaConverter.to_unicode(department)  # type: unicode
        self.phone = TeaConverter.to_unicode(phone)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.department is not None:
            result['Department'] = self.department
        if self.phone is not None:
            result['Phone'] = self.phone
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Department') is not None:
            self.department = m.get('Department')
        if m.get('Phone') is not None:
            self.phone = m.get('Phone')
        return self


class ListInstancesOfUserResponseBodyInstancesCallCenterInstanceAdminUser(TeaModel):
    def __init__(self, user_id=None, instance_id=None, ram_id=None, detail=None):
        self.user_id = TeaConverter.to_unicode(user_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.ram_id = TeaConverter.to_unicode(ram_id)  # type: unicode
        self.detail = detail  # type: ListInstancesOfUserResponseBodyInstancesCallCenterInstanceAdminUserDetail

    def validate(self):
        if self.detail:
            self.detail.validate()

    def to_map(self):
        result = dict()
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ram_id is not None:
            result['RamId'] = self.ram_id
        if self.detail is not None:
            result['Detail'] = self.detail.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RamId') is not None:
            self.ram_id = m.get('RamId')
        if m.get('Detail') is not None:
            temp_model = ListInstancesOfUserResponseBodyInstancesCallCenterInstanceAdminUserDetail()
            self.detail = temp_model.from_map(m['Detail'])
        return self


class ListInstancesOfUserResponseBodyInstancesCallCenterInstanceAdmin(TeaModel):
    def __init__(self, user=None):
        self.user = user  # type: list[ListInstancesOfUserResponseBodyInstancesCallCenterInstanceAdminUser]

    def validate(self):
        if self.user:
            for k in self.user:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['User'] = []
        if self.user is not None:
            for k in self.user:
                result['User'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.user = []
        if m.get('User') is not None:
            for k in m.get('User'):
                temp_model = ListInstancesOfUserResponseBodyInstancesCallCenterInstanceAdminUser()
                self.user.append(temp_model.from_map(k))
        return self


class ListInstancesOfUserResponseBodyInstancesCallCenterInstance(TeaModel):
    def __init__(self, status=None, owner=None, storage_max_size=None, storage_max_days=None,
                 max_online_agents=None, instance_id=None, domain_name=None, instance_description=None, phone_numbers=None,
                 console_url=None, storage_bucket=None, instance_name=None, created_time=None, directory_id=None, admin=None,
                 tenant_id=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.owner = TeaConverter.to_unicode(owner)  # type: unicode
        self.storage_max_size = storage_max_size  # type: int
        self.storage_max_days = storage_max_days  # type: int
        self.max_online_agents = max_online_agents  # type: int
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.domain_name = TeaConverter.to_unicode(domain_name)  # type: unicode
        self.instance_description = TeaConverter.to_unicode(instance_description)  # type: unicode
        self.phone_numbers = phone_numbers  # type: ListInstancesOfUserResponseBodyInstancesCallCenterInstancePhoneNumbers
        self.console_url = TeaConverter.to_unicode(console_url)  # type: unicode
        self.storage_bucket = TeaConverter.to_unicode(storage_bucket)  # type: unicode
        self.instance_name = TeaConverter.to_unicode(instance_name)  # type: unicode
        self.created_time = created_time  # type: long
        self.directory_id = TeaConverter.to_unicode(directory_id)  # type: unicode
        self.admin = admin  # type: ListInstancesOfUserResponseBodyInstancesCallCenterInstanceAdmin
        self.tenant_id = TeaConverter.to_unicode(tenant_id)  # type: unicode

    def validate(self):
        if self.phone_numbers:
            self.phone_numbers.validate()
        if self.admin:
            self.admin.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.storage_max_size is not None:
            result['StorageMaxSize'] = self.storage_max_size
        if self.storage_max_days is not None:
            result['StorageMaxDays'] = self.storage_max_days
        if self.max_online_agents is not None:
            result['MaxOnlineAgents'] = self.max_online_agents
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.instance_description is not None:
            result['InstanceDescription'] = self.instance_description
        if self.phone_numbers is not None:
            result['PhoneNumbers'] = self.phone_numbers.to_map()
        if self.console_url is not None:
            result['ConsoleUrl'] = self.console_url
        if self.storage_bucket is not None:
            result['StorageBucket'] = self.storage_bucket
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.admin is not None:
            result['Admin'] = self.admin.to_map()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('StorageMaxSize') is not None:
            self.storage_max_size = m.get('StorageMaxSize')
        if m.get('StorageMaxDays') is not None:
            self.storage_max_days = m.get('StorageMaxDays')
        if m.get('MaxOnlineAgents') is not None:
            self.max_online_agents = m.get('MaxOnlineAgents')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('InstanceDescription') is not None:
            self.instance_description = m.get('InstanceDescription')
        if m.get('PhoneNumbers') is not None:
            temp_model = ListInstancesOfUserResponseBodyInstancesCallCenterInstancePhoneNumbers()
            self.phone_numbers = temp_model.from_map(m['PhoneNumbers'])
        if m.get('ConsoleUrl') is not None:
            self.console_url = m.get('ConsoleUrl')
        if m.get('StorageBucket') is not None:
            self.storage_bucket = m.get('StorageBucket')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('Admin') is not None:
            temp_model = ListInstancesOfUserResponseBodyInstancesCallCenterInstanceAdmin()
            self.admin = temp_model.from_map(m['Admin'])
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ListInstancesOfUserResponseBodyInstances(TeaModel):
    def __init__(self, call_center_instance=None):
        self.call_center_instance = call_center_instance  # type: list[ListInstancesOfUserResponseBodyInstancesCallCenterInstance]

    def validate(self):
        if self.call_center_instance:
            for k in self.call_center_instance:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['CallCenterInstance'] = []
        if self.call_center_instance is not None:
            for k in self.call_center_instance:
                result['CallCenterInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.call_center_instance = []
        if m.get('CallCenterInstance') is not None:
            for k in m.get('CallCenterInstance'):
                temp_model = ListInstancesOfUserResponseBodyInstancesCallCenterInstance()
                self.call_center_instance.append(temp_model.from_map(k))
        return self


class ListInstancesOfUserResponseBody(TeaModel):
    def __init__(self, instances=None, message=None, request_id=None, http_status_code=None, code=None, success=None):
        self.instances = instances  # type: ListInstancesOfUserResponseBodyInstances
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.instances:
            self.instances.validate()

    def to_map(self):
        result = dict()
        if self.instances is not None:
            result['Instances'] = self.instances.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Instances') is not None:
            temp_model = ListInstancesOfUserResponseBodyInstances()
            self.instances = temp_model.from_map(m['Instances'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListInstancesOfUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListInstancesOfUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListInstancesOfUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListIvrTrackingDetailRequest(TeaModel):
    def __init__(self, instance_id=None, contact_id=None, start_time=None, stop_time=None, calling_number=None,
                 called_number=None, page_number=None, page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.contact_id = TeaConverter.to_unicode(contact_id)  # type: unicode
        self.start_time = start_time  # type: long
        self.stop_time = stop_time  # type: long
        self.calling_number = TeaConverter.to_unicode(calling_number)  # type: unicode
        self.called_number = TeaConverter.to_unicode(called_number)  # type: unicode
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StopTime') is not None:
            self.stop_time = m.get('StopTime')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListIvrTrackingDetailResponseBodyIvrTrackingDetailsListIvrTrackingDetail(TeaModel):
    def __init__(self, status=None, device_id=None, input_data=None, flow_name=None, stop_time=None,
                 called_number=None, start_time=None, description=None, node_type=None, contact_id=None, node_name=None,
                 calling_number=None, output_data=None, tenant_id=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.device_id = TeaConverter.to_unicode(device_id)  # type: unicode
        self.input_data = TeaConverter.to_unicode(input_data)  # type: unicode
        self.flow_name = TeaConverter.to_unicode(flow_name)  # type: unicode
        self.stop_time = stop_time  # type: long
        self.called_number = TeaConverter.to_unicode(called_number)  # type: unicode
        self.start_time = start_time  # type: long
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.node_type = TeaConverter.to_unicode(node_type)  # type: unicode
        self.contact_id = TeaConverter.to_unicode(contact_id)  # type: unicode
        self.node_name = TeaConverter.to_unicode(node_name)  # type: unicode
        self.calling_number = TeaConverter.to_unicode(calling_number)  # type: unicode
        self.output_data = TeaConverter.to_unicode(output_data)  # type: unicode
        self.tenant_id = TeaConverter.to_unicode(tenant_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.device_id is not None:
            result['DeviceID'] = self.device_id
        if self.input_data is not None:
            result['InputData'] = self.input_data
        if self.flow_name is not None:
            result['FlowName'] = self.flow_name
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.description is not None:
            result['Description'] = self.description
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.output_data is not None:
            result['OutputData'] = self.output_data
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('DeviceID') is not None:
            self.device_id = m.get('DeviceID')
        if m.get('InputData') is not None:
            self.input_data = m.get('InputData')
        if m.get('FlowName') is not None:
            self.flow_name = m.get('FlowName')
        if m.get('StopTime') is not None:
            self.stop_time = m.get('StopTime')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('OutputData') is not None:
            self.output_data = m.get('OutputData')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ListIvrTrackingDetailResponseBodyIvrTrackingDetailsList(TeaModel):
    def __init__(self, ivr_tracking_detail=None):
        self.ivr_tracking_detail = ivr_tracking_detail  # type: list[ListIvrTrackingDetailResponseBodyIvrTrackingDetailsListIvrTrackingDetail]

    def validate(self):
        if self.ivr_tracking_detail:
            for k in self.ivr_tracking_detail:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['IvrTrackingDetail'] = []
        if self.ivr_tracking_detail is not None:
            for k in self.ivr_tracking_detail:
                result['IvrTrackingDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.ivr_tracking_detail = []
        if m.get('IvrTrackingDetail') is not None:
            for k in m.get('IvrTrackingDetail'):
                temp_model = ListIvrTrackingDetailResponseBodyIvrTrackingDetailsListIvrTrackingDetail()
                self.ivr_tracking_detail.append(temp_model.from_map(k))
        return self


class ListIvrTrackingDetailResponseBodyIvrTrackingDetails(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: ListIvrTrackingDetailResponseBodyIvrTrackingDetailsList
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = ListIvrTrackingDetailResponseBodyIvrTrackingDetailsList()
            self.list = temp_model.from_map(m['List'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListIvrTrackingDetailResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, ivr_tracking_details=None, code=None,
                 success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.ivr_tracking_details = ivr_tracking_details  # type: ListIvrTrackingDetailResponseBodyIvrTrackingDetails
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.ivr_tracking_details:
            self.ivr_tracking_details.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.ivr_tracking_details is not None:
            result['IvrTrackingDetails'] = self.ivr_tracking_details.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('IvrTrackingDetails') is not None:
            temp_model = ListIvrTrackingDetailResponseBodyIvrTrackingDetails()
            self.ivr_tracking_details = temp_model.from_map(m['IvrTrackingDetails'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListIvrTrackingDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListIvrTrackingDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListIvrTrackingDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListJobGroupsRequest(TeaModel):
    def __init__(self, instance_id=None, start_time=None, end_time=None, page_number=None, page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.start_time = start_time  # type: long
        self.end_time = end_time  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListJobGroupsResponseBodyJobGroupsListStrategyWorkingTime(TeaModel):
    def __init__(self, end_time=None, begin_time=None):
        self.end_time = TeaConverter.to_unicode(end_time)  # type: unicode
        self.begin_time = TeaConverter.to_unicode(begin_time)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.begin_time is not None:
            result['BeginTime'] = self.begin_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('BeginTime') is not None:
            self.begin_time = m.get('BeginTime')
        return self


class ListJobGroupsResponseBodyJobGroupsListStrategy(TeaModel):
    def __init__(self, type=None, max_attempts_per_day=None, working_time=None, follow_up_strategy=None,
                 end_time=None, customized=None, start_time=None, is_template=None, repeat_days=None, routing_strategy=None,
                 description=None, min_attempt_interval=None, repeat_by=None, name=None, id=None):
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.max_attempts_per_day = max_attempts_per_day  # type: int
        self.working_time = working_time  # type: list[ListJobGroupsResponseBodyJobGroupsListStrategyWorkingTime]
        self.follow_up_strategy = TeaConverter.to_unicode(follow_up_strategy)  # type: unicode
        self.end_time = end_time  # type: long
        self.customized = TeaConverter.to_unicode(customized)  # type: unicode
        self.start_time = start_time  # type: long
        self.is_template = is_template  # type: bool
        self.repeat_days = repeat_days  # type: list[unicode]
        self.routing_strategy = TeaConverter.to_unicode(routing_strategy)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.min_attempt_interval = min_attempt_interval  # type: int
        self.repeat_by = TeaConverter.to_unicode(repeat_by)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.id = TeaConverter.to_unicode(id)  # type: unicode

    def validate(self):
        if self.working_time:
            for k in self.working_time:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.max_attempts_per_day is not None:
            result['MaxAttemptsPerDay'] = self.max_attempts_per_day
        result['WorkingTime'] = []
        if self.working_time is not None:
            for k in self.working_time:
                result['WorkingTime'].append(k.to_map() if k else None)
        if self.follow_up_strategy is not None:
            result['FollowUpStrategy'] = self.follow_up_strategy
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.customized is not None:
            result['Customized'] = self.customized
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.is_template is not None:
            result['IsTemplate'] = self.is_template
        if self.repeat_days is not None:
            result['RepeatDays'] = self.repeat_days
        if self.routing_strategy is not None:
            result['RoutingStrategy'] = self.routing_strategy
        if self.description is not None:
            result['Description'] = self.description
        if self.min_attempt_interval is not None:
            result['MinAttemptInterval'] = self.min_attempt_interval
        if self.repeat_by is not None:
            result['RepeatBy'] = self.repeat_by
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('MaxAttemptsPerDay') is not None:
            self.max_attempts_per_day = m.get('MaxAttemptsPerDay')
        self.working_time = []
        if m.get('WorkingTime') is not None:
            for k in m.get('WorkingTime'):
                temp_model = ListJobGroupsResponseBodyJobGroupsListStrategyWorkingTime()
                self.working_time.append(temp_model.from_map(k))
        if m.get('FollowUpStrategy') is not None:
            self.follow_up_strategy = m.get('FollowUpStrategy')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Customized') is not None:
            self.customized = m.get('Customized')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('IsTemplate') is not None:
            self.is_template = m.get('IsTemplate')
        if m.get('RepeatDays') is not None:
            self.repeat_days = m.get('RepeatDays')
        if m.get('RoutingStrategy') is not None:
            self.routing_strategy = m.get('RoutingStrategy')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MinAttemptInterval') is not None:
            self.min_attempt_interval = m.get('MinAttemptInterval')
        if m.get('RepeatBy') is not None:
            self.repeat_by = m.get('RepeatBy')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class ListJobGroupsResponseBodyJobGroupsListProgressCategories(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListJobGroupsResponseBodyJobGroupsListProgress(TeaModel):
    def __init__(self, status=None, total_not_answered=None, start_time=None, categories=None, total_jobs=None,
                 total_completed=None, duration=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.total_not_answered = total_not_answered  # type: int
        self.start_time = start_time  # type: long
        self.categories = categories  # type: list[ListJobGroupsResponseBodyJobGroupsListProgressCategories]
        self.total_jobs = total_jobs  # type: int
        self.total_completed = total_completed  # type: int
        self.duration = duration  # type: int

    def validate(self):
        if self.categories:
            for k in self.categories:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.total_not_answered is not None:
            result['TotalNotAnswered'] = self.total_not_answered
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        result['Categories'] = []
        if self.categories is not None:
            for k in self.categories:
                result['Categories'].append(k.to_map() if k else None)
        if self.total_jobs is not None:
            result['TotalJobs'] = self.total_jobs
        if self.total_completed is not None:
            result['TotalCompleted'] = self.total_completed
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TotalNotAnswered') is not None:
            self.total_not_answered = m.get('TotalNotAnswered')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        self.categories = []
        if m.get('Categories') is not None:
            for k in m.get('Categories'):
                temp_model = ListJobGroupsResponseBodyJobGroupsListProgressCategories()
                self.categories.append(temp_model.from_map(k))
        if m.get('TotalJobs') is not None:
            self.total_jobs = m.get('TotalJobs')
        if m.get('TotalCompleted') is not None:
            self.total_completed = m.get('TotalCompleted')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class ListJobGroupsResponseBodyJobGroupsList(TeaModel):
    def __init__(self, scenario_id=None, creation_time=None, strategy=None, calling_numbers=None, progress=None,
                 description=None, job_file_path=None, name=None, id=None):
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.creation_time = creation_time  # type: long
        self.strategy = strategy  # type: ListJobGroupsResponseBodyJobGroupsListStrategy
        self.calling_numbers = calling_numbers  # type: list[unicode]
        self.progress = progress  # type: ListJobGroupsResponseBodyJobGroupsListProgress
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.job_file_path = TeaConverter.to_unicode(job_file_path)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.id = TeaConverter.to_unicode(id)  # type: unicode

    def validate(self):
        if self.strategy:
            self.strategy.validate()
        if self.progress:
            self.progress.validate()

    def to_map(self):
        result = dict()
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.strategy is not None:
            result['Strategy'] = self.strategy.to_map()
        if self.calling_numbers is not None:
            result['CallingNumbers'] = self.calling_numbers
        if self.progress is not None:
            result['Progress'] = self.progress.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.job_file_path is not None:
            result['JobFilePath'] = self.job_file_path
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Strategy') is not None:
            temp_model = ListJobGroupsResponseBodyJobGroupsListStrategy()
            self.strategy = temp_model.from_map(m['Strategy'])
        if m.get('CallingNumbers') is not None:
            self.calling_numbers = m.get('CallingNumbers')
        if m.get('Progress') is not None:
            temp_model = ListJobGroupsResponseBodyJobGroupsListProgress()
            self.progress = temp_model.from_map(m['Progress'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('JobFilePath') is not None:
            self.job_file_path = m.get('JobFilePath')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class ListJobGroupsResponseBodyJobGroups(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListJobGroupsResponseBodyJobGroupsList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListJobGroupsResponseBodyJobGroupsList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListJobGroupsResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, code=None, success=None,
                 job_groups=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool
        self.job_groups = job_groups  # type: ListJobGroupsResponseBodyJobGroups

    def validate(self):
        if self.job_groups:
            self.job_groups.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        if self.job_groups is not None:
            result['JobGroups'] = self.job_groups.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('JobGroups') is not None:
            temp_model = ListJobGroupsResponseBodyJobGroups()
            self.job_groups = temp_model.from_map(m['JobGroups'])
        return self


class ListJobGroupsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListJobGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListJobGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListJobsByGroupRequest(TeaModel):
    def __init__(self, instance_id=None, job_group_id=None, job_status=None, job_failure_reason=None,
                 page_number=None, page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.job_group_id = TeaConverter.to_unicode(job_group_id)  # type: unicode
        self.job_status = TeaConverter.to_unicode(job_status)  # type: unicode
        self.job_failure_reason = TeaConverter.to_unicode(job_failure_reason)  # type: unicode
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_group_id is not None:
            result['JobGroupId'] = self.job_group_id
        if self.job_status is not None:
            result['JobStatus'] = self.job_status
        if self.job_failure_reason is not None:
            result['JobFailureReason'] = self.job_failure_reason
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobGroupId') is not None:
            self.job_group_id = m.get('JobGroupId')
        if m.get('JobStatus') is not None:
            self.job_status = m.get('JobStatus')
        if m.get('JobFailureReason') is not None:
            self.job_failure_reason = m.get('JobFailureReason')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListJobsByGroupResponseBodyJobsListSummary(TeaModel):
    def __init__(self, summary_name=None, group_id=None, job_id=None, category=None, content=None, summary_id=None,
                 task_id=None, conversation_detail_id=None):
        self.summary_name = TeaConverter.to_unicode(summary_name)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.category = TeaConverter.to_unicode(category)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode
        self.summary_id = TeaConverter.to_unicode(summary_id)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.conversation_detail_id = TeaConverter.to_unicode(conversation_detail_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.summary_name is not None:
            result['SummaryName'] = self.summary_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.category is not None:
            result['Category'] = self.category
        if self.content is not None:
            result['Content'] = self.content
        if self.summary_id is not None:
            result['SummaryId'] = self.summary_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.conversation_detail_id is not None:
            result['ConversationDetailId'] = self.conversation_detail_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SummaryName') is not None:
            self.summary_name = m.get('SummaryName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('SummaryId') is not None:
            self.summary_id = m.get('SummaryId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ConversationDetailId') is not None:
            self.conversation_detail_id = m.get('ConversationDetailId')
        return self


class ListJobsByGroupResponseBodyJobsListContacts(TeaModel):
    def __init__(self, phone_number=None, contact_id=None, state=None, job_id=None, honorific=None,
                 contact_name=None, role=None, reference_id=None):
        self.phone_number = TeaConverter.to_unicode(phone_number)  # type: unicode
        self.contact_id = TeaConverter.to_unicode(contact_id)  # type: unicode
        self.state = TeaConverter.to_unicode(state)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.honorific = TeaConverter.to_unicode(honorific)  # type: unicode
        self.contact_name = TeaConverter.to_unicode(contact_name)  # type: unicode
        self.role = TeaConverter.to_unicode(role)  # type: unicode
        self.reference_id = TeaConverter.to_unicode(reference_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.state is not None:
            result['State'] = self.state
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.honorific is not None:
            result['Honorific'] = self.honorific
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        if self.role is not None:
            result['Role'] = self.role
        if self.reference_id is not None:
            result['ReferenceId'] = self.reference_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Honorific') is not None:
            self.honorific = m.get('Honorific')
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('ReferenceId') is not None:
            self.reference_id = m.get('ReferenceId')
        return self


class ListJobsByGroupResponseBodyJobsListExtras(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListJobsByGroupResponseBodyJobsList(TeaModel):
    def __init__(self, status=None, calling_numbers=None, summary=None, contacts=None, priority=None,
                 failure_reason=None, system_priority=None, extras=None, reference_id=None, scenario_id=None, strategy_id=None,
                 group_id=None, job_id=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.calling_numbers = calling_numbers  # type: list[unicode]
        self.summary = summary  # type: list[ListJobsByGroupResponseBodyJobsListSummary]
        self.contacts = contacts  # type: list[ListJobsByGroupResponseBodyJobsListContacts]
        self.priority = priority  # type: int
        self.failure_reason = TeaConverter.to_unicode(failure_reason)  # type: unicode
        self.system_priority = system_priority  # type: int
        self.extras = extras  # type: list[ListJobsByGroupResponseBodyJobsListExtras]
        self.reference_id = TeaConverter.to_unicode(reference_id)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.strategy_id = TeaConverter.to_unicode(strategy_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        if self.summary:
            for k in self.summary:
                if k:
                    k.validate()
        if self.contacts:
            for k in self.contacts:
                if k:
                    k.validate()
        if self.extras:
            for k in self.extras:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.calling_numbers is not None:
            result['CallingNumbers'] = self.calling_numbers
        result['Summary'] = []
        if self.summary is not None:
            for k in self.summary:
                result['Summary'].append(k.to_map() if k else None)
        result['Contacts'] = []
        if self.contacts is not None:
            for k in self.contacts:
                result['Contacts'].append(k.to_map() if k else None)
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.failure_reason is not None:
            result['FailureReason'] = self.failure_reason
        if self.system_priority is not None:
            result['SystemPriority'] = self.system_priority
        result['Extras'] = []
        if self.extras is not None:
            for k in self.extras:
                result['Extras'].append(k.to_map() if k else None)
        if self.reference_id is not None:
            result['ReferenceId'] = self.reference_id
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CallingNumbers') is not None:
            self.calling_numbers = m.get('CallingNumbers')
        self.summary = []
        if m.get('Summary') is not None:
            for k in m.get('Summary'):
                temp_model = ListJobsByGroupResponseBodyJobsListSummary()
                self.summary.append(temp_model.from_map(k))
        self.contacts = []
        if m.get('Contacts') is not None:
            for k in m.get('Contacts'):
                temp_model = ListJobsByGroupResponseBodyJobsListContacts()
                self.contacts.append(temp_model.from_map(k))
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('FailureReason') is not None:
            self.failure_reason = m.get('FailureReason')
        if m.get('SystemPriority') is not None:
            self.system_priority = m.get('SystemPriority')
        self.extras = []
        if m.get('Extras') is not None:
            for k in m.get('Extras'):
                temp_model = ListJobsByGroupResponseBodyJobsListExtras()
                self.extras.append(temp_model.from_map(k))
        if m.get('ReferenceId') is not None:
            self.reference_id = m.get('ReferenceId')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class ListJobsByGroupResponseBodyJobs(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListJobsByGroupResponseBodyJobsList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListJobsByGroupResponseBodyJobsList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListJobsByGroupResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, jobs=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.jobs = jobs  # type: ListJobsByGroupResponseBodyJobs
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.jobs:
            self.jobs.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.jobs is not None:
            result['Jobs'] = self.jobs.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Jobs') is not None:
            temp_model = ListJobsByGroupResponseBodyJobs()
            self.jobs = temp_model.from_map(m['Jobs'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListJobsByGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListJobsByGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListJobsByGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListJobStatusRequest(TeaModel):
    def __init__(self, instance_id=None, scenario_id=None, group_id=None, start_time=None, end_time=None,
                 time_alignment=None, contact_name=None, phone_number=None, page_number=None, page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.start_time = start_time  # type: long
        self.end_time = end_time  # type: long
        self.time_alignment = TeaConverter.to_unicode(time_alignment)  # type: unicode
        self.contact_name = TeaConverter.to_unicode(contact_name)  # type: unicode
        self.phone_number = TeaConverter.to_unicode(phone_number)  # type: unicode
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.time_alignment is not None:
            result['TimeAlignment'] = self.time_alignment
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('TimeAlignment') is not None:
            self.time_alignment = m.get('TimeAlignment')
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListJobStatusResponseBodyJobsListContacts(TeaModel):
    def __init__(self, phone_number=None, contact_id=None, state=None, job_id=None, honorific=None,
                 contact_name=None, role=None, reference_id=None):
        self.phone_number = TeaConverter.to_unicode(phone_number)  # type: unicode
        self.contact_id = TeaConverter.to_unicode(contact_id)  # type: unicode
        self.state = TeaConverter.to_unicode(state)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.honorific = TeaConverter.to_unicode(honorific)  # type: unicode
        self.contact_name = TeaConverter.to_unicode(contact_name)  # type: unicode
        self.role = TeaConverter.to_unicode(role)  # type: unicode
        self.reference_id = TeaConverter.to_unicode(reference_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.state is not None:
            result['State'] = self.state
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.honorific is not None:
            result['Honorific'] = self.honorific
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        if self.role is not None:
            result['Role'] = self.role
        if self.reference_id is not None:
            result['ReferenceId'] = self.reference_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Honorific') is not None:
            self.honorific = m.get('Honorific')
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('ReferenceId') is not None:
            self.reference_id = m.get('ReferenceId')
        return self


class ListJobStatusResponseBodyJobsListSummary(TeaModel):
    def __init__(self, summary_name=None, group_id=None, job_id=None, category=None, content=None, summary_id=None,
                 task_id=None, conversation_detail_id=None):
        self.summary_name = TeaConverter.to_unicode(summary_name)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.category = TeaConverter.to_unicode(category)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode
        self.summary_id = TeaConverter.to_unicode(summary_id)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.conversation_detail_id = TeaConverter.to_unicode(conversation_detail_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.summary_name is not None:
            result['SummaryName'] = self.summary_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.category is not None:
            result['Category'] = self.category
        if self.content is not None:
            result['Content'] = self.content
        if self.summary_id is not None:
            result['SummaryId'] = self.summary_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.conversation_detail_id is not None:
            result['ConversationDetailId'] = self.conversation_detail_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SummaryName') is not None:
            self.summary_name = m.get('SummaryName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('SummaryId') is not None:
            self.summary_id = m.get('SummaryId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ConversationDetailId') is not None:
            self.conversation_detail_id = m.get('ConversationDetailId')
        return self


class ListJobStatusResponseBodyJobsListExtras(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListJobStatusResponseBodyJobsListTasksContact(TeaModel):
    def __init__(self, phone_number=None, contact_id=None, state=None, job_id=None, honorific=None,
                 contact_name=None, role=None, reference_id=None):
        self.phone_number = TeaConverter.to_unicode(phone_number)  # type: unicode
        self.contact_id = TeaConverter.to_unicode(contact_id)  # type: unicode
        self.state = TeaConverter.to_unicode(state)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.honorific = TeaConverter.to_unicode(honorific)  # type: unicode
        self.contact_name = TeaConverter.to_unicode(contact_name)  # type: unicode
        self.role = TeaConverter.to_unicode(role)  # type: unicode
        self.reference_id = TeaConverter.to_unicode(reference_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.state is not None:
            result['State'] = self.state
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.honorific is not None:
            result['Honorific'] = self.honorific
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        if self.role is not None:
            result['Role'] = self.role
        if self.reference_id is not None:
            result['ReferenceId'] = self.reference_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Honorific') is not None:
            self.honorific = m.get('Honorific')
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('ReferenceId') is not None:
            self.reference_id = m.get('ReferenceId')
        return self


class ListJobStatusResponseBodyJobsListTasks(TeaModel):
    def __init__(self, status=None, planed_time=None, chatbot_id=None, actual_time=None, called_number=None,
                 scenario_id=None, contact=None, job_id=None, call_id=None, calling_number=None, brief=None, duration=None,
                 task_id=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.planed_time = planed_time  # type: long
        self.chatbot_id = TeaConverter.to_unicode(chatbot_id)  # type: unicode
        self.actual_time = actual_time  # type: long
        self.called_number = TeaConverter.to_unicode(called_number)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.contact = contact  # type: ListJobStatusResponseBodyJobsListTasksContact
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.call_id = TeaConverter.to_unicode(call_id)  # type: unicode
        self.calling_number = TeaConverter.to_unicode(calling_number)  # type: unicode
        self.brief = TeaConverter.to_unicode(brief)  # type: unicode
        self.duration = duration  # type: int
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode

    def validate(self):
        if self.contact:
            self.contact.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.planed_time is not None:
            result['PlanedTime'] = self.planed_time
        if self.chatbot_id is not None:
            result['ChatbotId'] = self.chatbot_id
        if self.actual_time is not None:
            result['ActualTime'] = self.actual_time
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        if self.contact is not None:
            result['Contact'] = self.contact.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.brief is not None:
            result['Brief'] = self.brief
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PlanedTime') is not None:
            self.planed_time = m.get('PlanedTime')
        if m.get('ChatbotId') is not None:
            self.chatbot_id = m.get('ChatbotId')
        if m.get('ActualTime') is not None:
            self.actual_time = m.get('ActualTime')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        if m.get('Contact') is not None:
            temp_model = ListJobStatusResponseBodyJobsListTasksContact()
            self.contact = temp_model.from_map(m['Contact'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('Brief') is not None:
            self.brief = m.get('Brief')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ListJobStatusResponseBodyJobsList(TeaModel):
    def __init__(self, status=None, calling_numbers=None, contacts=None, summary=None, priority=None,
                 failure_reason=None, extras=None, reference_id=None, scenario_id=None, tasks=None, strategy_id=None, group_id=None,
                 job_id=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.calling_numbers = calling_numbers  # type: list[unicode]
        self.contacts = contacts  # type: list[ListJobStatusResponseBodyJobsListContacts]
        self.summary = summary  # type: list[ListJobStatusResponseBodyJobsListSummary]
        self.priority = priority  # type: int
        self.failure_reason = TeaConverter.to_unicode(failure_reason)  # type: unicode
        self.extras = extras  # type: list[ListJobStatusResponseBodyJobsListExtras]
        self.reference_id = TeaConverter.to_unicode(reference_id)  # type: unicode
        self.scenario_id = TeaConverter.to_unicode(scenario_id)  # type: unicode
        self.tasks = tasks  # type: list[ListJobStatusResponseBodyJobsListTasks]
        self.strategy_id = TeaConverter.to_unicode(strategy_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        if self.contacts:
            for k in self.contacts:
                if k:
                    k.validate()
        if self.summary:
            for k in self.summary:
                if k:
                    k.validate()
        if self.extras:
            for k in self.extras:
                if k:
                    k.validate()
        if self.tasks:
            for k in self.tasks:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.calling_numbers is not None:
            result['CallingNumbers'] = self.calling_numbers
        result['Contacts'] = []
        if self.contacts is not None:
            for k in self.contacts:
                result['Contacts'].append(k.to_map() if k else None)
        result['Summary'] = []
        if self.summary is not None:
            for k in self.summary:
                result['Summary'].append(k.to_map() if k else None)
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.failure_reason is not None:
            result['FailureReason'] = self.failure_reason
        result['Extras'] = []
        if self.extras is not None:
            for k in self.extras:
                result['Extras'].append(k.to_map() if k else None)
        if self.reference_id is not None:
            result['ReferenceId'] = self.reference_id
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        result['Tasks'] = []
        if self.tasks is not None:
            for k in self.tasks:
                result['Tasks'].append(k.to_map() if k else None)
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CallingNumbers') is not None:
            self.calling_numbers = m.get('CallingNumbers')
        self.contacts = []
        if m.get('Contacts') is not None:
            for k in m.get('Contacts'):
                temp_model = ListJobStatusResponseBodyJobsListContacts()
                self.contacts.append(temp_model.from_map(k))
        self.summary = []
        if m.get('Summary') is not None:
            for k in m.get('Summary'):
                temp_model = ListJobStatusResponseBodyJobsListSummary()
                self.summary.append(temp_model.from_map(k))
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('FailureReason') is not None:
            self.failure_reason = m.get('FailureReason')
        self.extras = []
        if m.get('Extras') is not None:
            for k in m.get('Extras'):
                temp_model = ListJobStatusResponseBodyJobsListExtras()
                self.extras.append(temp_model.from_map(k))
        if m.get('ReferenceId') is not None:
            self.reference_id = m.get('ReferenceId')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        self.tasks = []
        if m.get('Tasks') is not None:
            for k in m.get('Tasks'):
                temp_model = ListJobStatusResponseBodyJobsListTasks()
                self.tasks.append(temp_model.from_map(k))
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class ListJobStatusResponseBodyJobs(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListJobStatusResponseBodyJobsList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListJobStatusResponseBodyJobsList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListJobStatusResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, jobs=None, http_status_code=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.jobs = jobs  # type: ListJobStatusResponseBodyJobs
        self.http_status_code = http_status_code  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.jobs:
            self.jobs.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.jobs is not None:
            result['Jobs'] = self.jobs.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Jobs') is not None:
            temp_model = ListJobStatusResponseBodyJobs()
            self.jobs = temp_model.from_map(m['Jobs'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListJobStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListJobStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListJobStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListMediasRequest(TeaModel):
    def __init__(self, instance_id=None, name_prefix=None, page_number=None, page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.name_prefix = TeaConverter.to_unicode(name_prefix)  # type: unicode
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name_prefix is not None:
            result['NamePrefix'] = self.name_prefix
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NamePrefix') is not None:
            self.name_prefix = m.get('NamePrefix')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListMediasResponseBodyMediasListMedia(TeaModel):
    def __init__(self, status=None, type=None, file_path=None, instance=None, description=None, file_name=None,
                 name=None, content=None, oss_file_name=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.file_path = TeaConverter.to_unicode(file_path)  # type: unicode
        self.instance = TeaConverter.to_unicode(instance)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.file_name = TeaConverter.to_unicode(file_name)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode
        self.oss_file_name = TeaConverter.to_unicode(oss_file_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.instance is not None:
            result['Instance'] = self.instance
        if self.description is not None:
            result['Description'] = self.description
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.name is not None:
            result['Name'] = self.name
        if self.content is not None:
            result['Content'] = self.content
        if self.oss_file_name is not None:
            result['OssFileName'] = self.oss_file_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('Instance') is not None:
            self.instance = m.get('Instance')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('OssFileName') is not None:
            self.oss_file_name = m.get('OssFileName')
        return self


class ListMediasResponseBodyMediasList(TeaModel):
    def __init__(self, media=None):
        self.media = media  # type: list[ListMediasResponseBodyMediasListMedia]

    def validate(self):
        if self.media:
            for k in self.media:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Media'] = []
        if self.media is not None:
            for k in self.media:
                result['Media'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.media = []
        if m.get('Media') is not None:
            for k in m.get('Media'):
                temp_model = ListMediasResponseBodyMediasListMedia()
                self.media.append(temp_model.from_map(k))
        return self


class ListMediasResponseBodyMedias(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: ListMediasResponseBodyMediasList
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = ListMediasResponseBodyMediasList()
            self.list = temp_model.from_map(m['List'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListMediasResponseBody(TeaModel):
    def __init__(self, message=None, request_id=None, http_status_code=None, medias=None, code=None, success=None):
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.http_status_code = http_status_code  # type: int
        self.medias = medias  # type: ListMediasResponseBodyMedias
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.medias:
            self.medias.validate()

    def to_map(self):
        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.medias is not None:
            result['Medias'] = self.medias.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Medias') is not None:
            temp_model = ListMediasResponseBodyMedias()
            self.medias = temp_model.from_map(m['Medias'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListMediasResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListMediasResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListMediasResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOutboundPhoneNumberOfUserRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, page_number=None, page_size=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.user_id = TeaConverter.to_unicode(user_id)  # type: unicode
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListOutboundPhoneNumberOfUserResponseBodyNumberList(TeaModel):
    def __init__(self, number=None):
        self.number = number  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.number is not None:
            result['Number'] = self.number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Number') is not None:
            self.number = m.get('Number')
        return self


class ListOutboundPhoneNumberOfUserResponseBodyOutboundPhoneNumbersPhoneNumberPrivacyNumber(TeaModel):
    def __init__(self, type=None, pool_id=None, sub_id=None, phone_number=None, pool_name=None, biz_id=None,
                 region_name_city=None, extra=None, tel_x=None):
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.pool_id = TeaConverter.to_unicode(pool_id)  # type: unicode
        self.sub_id = TeaConverter.to_unicode(sub_id)  # type: unicode
        self.phone_number = TeaConverter.to_unicode(phone_number)  # type: unicode
        self.pool_name = TeaConverter.to_unicode(pool_name)  # type: unicode
        self.biz_id = TeaConverter.to_unicode(biz_id)  # type: unicode
        self.region_name_city = TeaConverter.to_unicode(region_name_city)  # type: unicode
        self.extra = TeaConverter.to_unicode(extra)  # type: unicode
        self.tel_x = TeaConverter.to_unicode(tel_x)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.pool_id is not None:
            result['PoolId'] = self.pool_id
        if self.sub_id is not None:
            result['SubId'] = self.sub_id
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.pool_name is not None:
            result['PoolName'] = self.pool_name
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.region_name_city is not None:
            result['RegionNameCity'] = self.region_name_city
        if self.extra is not None:
            result['Extra'] = self.extra
        if self.tel_x is not None:
            result['TelX'] = self.tel_x
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('PoolId') is not None:
            self.pool_id = m.get('PoolId')
        if m.get('SubId') is not None:
            self.sub_id = m.get('SubId')
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('PoolName') is not None:
            self.pool_name = m.get('PoolName')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('RegionNameCity') is not None:
            self.region_name_city = m.get('RegionNameCity')
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        if m.get('TelX') is not None:
            self.tel_x = m.get('TelX')
        return self


class ListOutboundPhoneNumberOfUserResponseBodyOutboundPhoneNumbersPhoneNumber(TeaModel):
    def __init__(self, private_flag=None, test_only=None, remaining_time=None, sip_tel_x=None, city=None,
                 instance_id=None, usage=None, allow_outbound=None, phone_number_id=None, trunks=None, number=None,
                 phone_number_description=None, privacy_number=None, province=None):
        self.private_flag = private_flag  # type: bool
        self.test_only = test_only  # type: bool
        self.remaining_time = remaining_time  # type: int
        self.sip_tel_x = TeaConverter.to_unicode(sip_tel_x)  # type: unicode
        self.city = TeaConverter.to_unicode(city)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.usage = TeaConverter.to_unicode(usage)  # type: unicode
        self.allow_outbound = allow_outbound  # type: bool
        self.phone_number_id = TeaConverter.to_unicode(phone_number_id)  # type: unicode
        self.trunks = trunks  # type: int
        self.number = TeaConverter.to_unicode(number)  # type: unicode
        self.phone_number_description = TeaConverter.to_unicode(phone_number_description)  # type: unicode
        self.privacy_number = privacy_number  # type: ListOutboundPhoneNumberOfUserResponseBodyOutboundPhoneNumbersPhoneNumberPrivacyNumber
        self.province = TeaConverter.to_unicode(province)  # type: unicode

    def validate(self):
        if self.privacy_number:
            self.privacy_number.validate()

    def to_map(self):
        result = dict()
        if self.private_flag is not None:
            result['PrivateFlag'] = self.private_flag
        if self.test_only is not None:
            result['TestOnly'] = self.test_only
        if self.remaining_time is not None:
            result['RemainingTime'] = self.remaining_time
        if self.sip_tel_x is not None:
            result['SipTelX'] = self.sip_tel_x
        if self.city is not None:
            result['City'] = self.city
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.allow_outbound is not None:
            result['AllowOutbound'] = self.allow_outbound
        if self.phone_number_id is not None:
            result['PhoneNumberId'] = self.phone_number_id
        if self.trunks is not None:
            result['Trunks'] = self.trunks
        if self.number is not None:
            result['Number'] = self.number
        if self.phone_number_description is not None:
            result['PhoneNumberDescription'] = self.phone_number_description
        if self.privacy_number is not None:
            result['PrivacyNumber'] = self.privacy_number.to_map()
        if self.province is not None:
            result['Province'] = self.province
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PrivateFlag') is not None:
            self.private_flag = m.get('PrivateFlag')
        if m.get('TestOnly') is not None:
            self.test_only = m.get('TestOnly')
        if m.get('RemainingTime') is not None:
            self.remaining_time = m.get('RemainingTime')
        if m.get('SipTelX') is not None:
            self.sip_tel_x = m.get('SipTelX')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('AllowOutbound') is not None:
            self.allow_outbound = m.get('AllowOutbound')
        if m.get('PhoneNumberId') is not None:
            self.phone_number_id = m.get('PhoneNumberId')
        if m.get('Trunks') is not None:
            self.trunks = m.get('Trunks')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('PhoneNumberDescription') is not None:
            self.phone_number_description = m.get('PhoneNumberDescription')
        if m.get('PrivacyNumber') is not None:
            temp_model = ListOutboundPhoneNumberOfUserResponseBodyOutboundPhoneNumbersPhoneNumberPrivacyNumber()
            self.privacy_number = temp_model.from_map(m['PrivacyNumber'])
        if m.get('Province') is not None:
            self.province = m.get('Province')
        return self


class ListOutboundPhoneNumberOfUserResponseBodyOutboundPhoneNumbers(TeaModel):
    def __init__(self, phone_number=None):
        self.phone_number = phone_number  # type: list[ListOutboundP