# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['asymmetric']

package_data = \
{'': ['*']}

install_requires = \
['starlette>=0.13.8,<0.14.0']

setup_kwargs = {
    'name': 'asymmetric',
    'version': '0.0.1',
    'description': 'A powerful tool to enable super fast [async] module-to-API transformations. Learn in minutes, implement in seconds.',
    'long_description': '# Asymmetric\n\n![PyPI - Version](https://img.shields.io/pypi/v/asymmetric?style=for-the-badge&logo=python&color=306998&logoColor=%23fff&label=version)\n\nA powerful tool to enable super fast _[async]_ module-to-**[API](https://en.wikipedia.org/wiki/Web_API)** transformations. Learn in minutes, implement in seconds.\n\n![Linters Workflow](https://img.shields.io/github/workflow/status/daleal/asymmetric/linters?label=linters&logo=github&style=for-the-badge)\n\n## Why Asymmetric?\n\nRaw developing speed and ease of use, that\'s why. `asymmetric` is based on **[Starlette](https://github.com/encode/starlette)** ✨! While `Starlette` is a powerful tool to have, getting it to work from scratch can be a bit of a pain, especially if you have never used it before. The idea behind `asymmetric` is to be able to take any module **already written** and transform it into a working API in a matter of minutes, instead of having to design the module ground-up to work with `Starlette` (it can also be used to build an API from scratch really fast). With `asymmetric`, you will also get some neat features, namely:\n\n- Auto logging.\n- Server-side error detection and exception handling.\n- ~~Auto-generated `/docs` endpoint for your API with **interactive documentation**.~~ **[UNDER CONSTRUCTION]**\n- ~~Auto-generated [OpenAPI Specification](https://swagger.io/docs/specification/about/) documentation files for your API.~~ **[UNDER CONSTRUCTION]**\n\nThe [complete documentation](https://asymmetric.one/docs/) is available on the [official website](https://asymmetric.one/).\n\n## Installing\n\nInstall using pip!\n\n```sh\npip install asymmetric\n```\n\n## Usage\n\n### Running the development server\n\nTo start a server, choose your favorite `ASGI` server and target the `asymmetric` object!\n\n```sh\nuvicorn run:<module>\n```\n\nWhere `<module>` is your module name (in the examples, we will be writing in a file named `module.py`, so the module name will be just `module`). A `Starlette` instance will be spawned immediately and can be reached at [http://127.0.0.1:8000](http://127.0.0.1:8000) by default. We don\'t have any endpoints yet, so we\'ll add some later.\n\n### Defining the API endpoints\n\nThe module consists of a main object called `asymmetric`, which includes an important element: the `router` decorator. Let\'s analyze it:\n\n```py\nfrom asymmetric import asymmetric\n\n@asymmetric.router("/some-route", methods=["post"], response_code=200)\n```\n\nThe decorator recieves 3 arguments: the `route` argument (the endpoint of the API to which the decorated function will map), the `methods` argument (a list of the methods accepted to connect to that endpoint, defaults in only `POST` requests) and the `response_code` argument (the response code of the endpoint if everything goes according to the plan. Defaults to `200`).\n\nNow let\'s imagine that we have the following method:\n\n```py\ndef some_function():\n    """Greets the world."""\n    return "Hello World!"\n```\n\nTo transform that method into an API endpoint, all you need to do is add one line:\n\n```py\n@asymmetric.router("/sample", methods=["get"])\ndef some_function():\n    """Greets the world."""\n    return "Hello World!"\n```\n\nRun `uvicorn run:module` and send a `GET` request to `http://127.0.0.1:8000/sample`. You should get a `Hello World!` in response! (To try it with a browser, make sure to run the above command and click [this link](http://127.0.0.1:8000/sample)).\n\nBut what about methods with arguments? Of course they can be API\'d too! Let\'s now say that you have the following function:\n\n```py\ndef another_function(a, b=372):\n    """\n    Adds :a and :b and returns the result of\n    that operation.\n    """\n    return a + b\n```\n\nTo transform that method into an API endpoint, all you need to do, again, is add one line:\n\n```py\n@asymmetric.router("/add")\ndef another_function(a, b=372):\n    """\n    Adds :a and :b and returns the result of\n    that operation.\n    """\n    return a + b\n```\n\n### Querying API endpoints\n\nTo give parameters to a function, all we need to do is send a `json` body with the names of the parameters as keys. Let\'s see how! Run `symmetric run module` and send a `POST` request (the default `HTTP` method) to `http://127.0.0.1:8000/add`, now using the `httpx` module.\n\n```python\nimport httpx\n\npayload = {\n    "a": 48,\n    "b": 21\n}\nresponse = httpx.post("http://127.0.0.1:8000/add", json=payload)\nprint(response.json())\n```\n\nWe got a `69` response! (`48 + 21 = 69`). Of course, you can return dictionaries from your methods and those will get returned as a `json` body in the response object **automagically**!\n\nWith this in mind, you can transform any existing project into a usable API very quickly!\n\n## What about `async`?\n\nGiven that the underlying framework is `Starlette`, you can use `async` to define your methods, no problem! Here\'s an example:\n\n```py\n@asymmetric.router("/another-add")\nasync def another_async_function(a, b=372):\n    """\n    Adds :a and :b asynchronously and returns the\n    result of that operation.\n    """\n    return a + b\n```\n\n## ~~ReDoc Documentation~~\n\n**[UNDER CONSTRUCTION]**\n\nBy default, you can `GET` the `/docs` endpoint (using a browser) to access to **interactive auto-generated documentation** about your API. It will include request bodies for each endpoint, response codes, authentication required, default values, and much more!\n\n**Tip**: Given that the [ReDoc Documentation](https://github.com/Redocly/redoc) is based on the OpenAPI standard, using **type annotations** in your code will result in a more detailed interactive documentation. Instead of the parameters being allowed to be any type, they will be forced into the type declared in your code. Cool, right?\n\n## Developing\n\nClone the repository:\n\n```sh\ngit clone https://github.com/daleal/asymmetric.git\n\ncd asymmetric\n```\n\nRecreate environment:\n\n```sh\n./environment.sh\n\n. .venv/bin/activate\n```\n\nTest install:\n\n```sh\npoetry install\n```\n\n## Resources\n\n- [Official Website](https://asymmetric.one/)\n- [Issue Tracker](https://github.com/daleal/asymmetric/issues/)\n',
    'author': 'Daniel Leal',
    'author_email': 'dlleal@uc.cl',
    'maintainer': 'Daniel Leal',
    'maintainer_email': 'dlleal@uc.cl',
    'url': 'https://asymmetric.one/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
