# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pytket_qir', 'pytket_qir.gatesets', 'pytket_qir.gatesets.pyqir']

package_data = \
{'': ['*']}

install_requires = \
['keyring>=23.6.0,<24.0.0',
 'keyrings.alt>=4.1.0,<5.0.0',
 'nest-asyncio>=1.5.5,<2.0.0',
 'pyjwt>=2.4,<3.0',
 'pyqir>=0.4.2a1,<0.5.0',
 'pytket>=1.3.0rc1,<2.0.0',
 'requests>=2.28.0,<3.0.0',
 'websockets>=10.3,<11.0']

entry_points = \
{'console_scripts': ['compile-bc-test-files = '
                     'tests.qir_test_files.compile_bc_test_files:compile_to_bc']}

setup_kwargs = {
    'name': 'pytket-qir',
    'version': '0.1.2',
    'description': 'Python module for interfacing QIR with the Quantinuum pytket library.',
    'long_description': '# pytket-qir\n\n`pytket-qir` is a python package, aimed at interafacing QIR programs with `pytket`.\n\nThe source code can be found in the corresponding GitHub repository.\n\n## Installation\n\n`pytket-qir` is tested against Python 3.8, 3.9 and 3.10.\n\nThe main requirements are:\n\n- `pytket`\n- `pyqir`\n\nStandard local installation using `pip`:\n\n```sh\npip install -U .\n```\n\n`pytket-qir` has been packaged using `poetry`:\n\n```sh\npoetry install\n```\n\n_N.B._: `pytket-qir` is tested against x86_64 platforms since `pyqir` is not available for arm64.\n',
    'author': 'Roland Guichard',
    'author_email': 'roland.guichard@cambridgequantum.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/CQCL/pytket-qir',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<3.11',
}


setup(**setup_kwargs)
