"""
AUTOGENERATED USING DOCUMENTATION FROM:
https://api.alpha.antcde.io/docs/2.0/api-docs-v2.json
AT 2025-01-15 14:12:00.556838

FOR AUTO UPDATE OF THE PYTHON PACKAGE, GO TO:
'./dev/generate_models.py
"""


from __future__ import annotations
import requests
from typing import Optional, List, Union

from ant_connect import QueryBuilder
from ant_connect.utils import ModelBaseClass
from ant_connect.enums import HttpMethodType, DataType, Priority
from ant_connect.utils.decorators import preprocess_arguments
from ant_connect.utils.manual_functions import *


__all__ = ['AntPersonalAccessToken', 'Column', 'Download', 'Label', 'License', 'Link', 'Permission', 'Project', 'Record', 'Relation', 'Role', 'SbsRecord', 'Script', 'Table', 'Task', 'User']


class BaseModel(ModelBaseClass):
	"""Python dataclass for the BaseModel schema

	Args:
		id(str): App.Models.BaseModel
		created_at(str): Initial creation timestamp
		updated_at(str): Last update timestamp
		deleted_at(str): Soft delete timestamp
		base64(str): No description available at the moment
		deletedMessage(str): No description available at the moment
		project(dict): No description available at the moment
		table(dict): No description available at the moment
		user(dict): No description available at the moment
		userShort(dict): No description available at the moment
		record(dict): No description available at the moment
	"""
	id: Optional[str] = None
	created_at: Optional[str] = None
	updated_at: Optional[str] = None
	deleted_at: Optional[str] = None
	base64: Optional[str] = None
	deletedMessage: Optional[str] = None
	project: Optional[dict] = None
	table: Optional[dict] = None
	user: Optional[dict] = None
	userShort: Optional[dict] = None
	record: Optional[dict] = None


class Column(ModelBaseClass):
	"""Python dataclass for the Column schema

	Args:
		id(str): Column id
		table(str): table id
		name(str): No description available at the moment
		type(DataType): No description available at the moment
		is_unique(bool): No description available at the moment
		required(bool): No description available at the moment
		default_value(str): No description available at the moment
		options_value(List): No description available at the moment
		order(int): No description available at the moment
		hint(str): No description available at the moment
		field_name(str): No description available at the moment
	"""
	id: str
	table: str
	name: str
	type: DataType
	is_unique: Optional[bool] = None
	required: Optional[bool] = None
	default_value: Optional[str] = None
	options_value: Optional[List[str]] = None
	order: Optional[int] = None
	hint: Optional[str] = None
	field_name: Optional[str] = None

	@classmethod
	def all(cls, table_id: str) -> list[Column]:
		"""Get table columns

		Args:
			table_id(str): ID of table
		"""
		endpoint = f"tables/{table_id}/columns"
		response: requests.Response = Column._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return [Column._from_json(i) for i in response.json()]
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def get(cls, column_id: str) -> Column:
		"""Get table column

		Args:
			column_id(str): ID of column
		"""
		endpoint = f"columns/{column_id}"
		response: requests.Response = Column._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return Column._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def update(cls, column_id: str, name: Optional[str] = None, required: Optional[bool] = None, default_value: Optional[str] = None, order: Optional[int] = None, hint: Optional[str] = None, field_name: Optional[str] = None) -> Column:
		"""Update table column

		Args:
			column_id(str): ID of Column
			name(str): For example 'John Doe'
			required(bool): For example 'false'
			default_value(str): For example 'example'
			order(int): For example '10'
			hint(str): For example 'column 1 hint'
			field_name(str): For example 'friendly name'
		"""
		parameters = {
			'name': name,
			'required': required,
			'default_value': default_value,
			'order': order,
			'hint': hint,
			'field_name': field_name,
			}

		endpoint = f"columns/{column_id}"
		response: requests.Response = Column._call_api(method_type=HttpMethodType.PUT, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return Column._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def delete(cls, column_id: str) -> MessageResponse:
		"""Delete table column

		Args:
			column_id(str): ID of Column
		"""
		endpoint = f"columns/{column_id}"
		response: requests.Response = Column._call_api(method_type=HttpMethodType.DELETE, endpoint=endpoint)
		if response.ok:
			return MessageResponse._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def create(cls, name: str, type: DataType, table_id: str, is_unique: Optional[bool] = False, required: Optional[bool] = False, default_value: Optional[str] = None, options_value: Optional[List[str]] = None, order: Optional[int] = None, hint: Optional[str] = None, field_name: Optional[str] = None) -> Column:
		"""Create table column

		Args:
			name(str): For example 'column_1'
			type(DataType): For example '['text', 'text-field', 'integer', 'boolean', 'date', 'link', 'email', 'dropdown', 'document', 'float', 'sbscode', 'table']'
			is_unique(bool): For example 'false'
			required(bool): For example 'false'
			default_value(str): For example 'example'
			options_value(List): For example '['value_1', 'value_2']'
			order(int): For example '10'
			table_id(str): No example available at the moment
			hint(str): For example 'column 1 hint'
			field_name(str): For example 'friendly name'
		"""
		parameters = {
			'name': name,
			'type': type,
			'is_unique': is_unique,
			'required': required,
			'default_value': default_value,
			'options_value': options_value,
			'order': order,
			'table': table_id,
			'hint': hint,
			'field_name': field_name,
			}

		endpoint = f"columns"
		response: requests.Response = Column._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return Column._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')


class Company(ModelBaseClass):
	"""Python dataclass for the Company schema

	Args:
		id(str): Company id
		name(str): Company name
		created_at(str): created_at id
	"""
	id: str
	name: str
	created_at: Optional[str] = None


class Download(ModelBaseClass):
	"""Python dataclass for the Download schema

	Args:
		id(str): Download id
		downloaded(bool): is true if the file has been downloaded already
		name(str): No description available at the moment
		extension(str): No description available at the moment
		size(int): No description available at the moment
		mimetype(str): No description available at the moment
	"""
	id: str
	downloaded: Optional[bool] = None
	name: str
	extension: str
	size: Optional[int] = None
	mimetype: str

	@classmethod
	def all(cls) -> list[Download]:
		"""Get user downloads
		"""
		endpoint = f"downloads"
		response: requests.Response = Download._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return [Download._from_json(i) for i in response.json()]
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def get(cls, download_id: str, harddelete: Optional[bool] = None) -> Union[str, bytes]:
		"""Fetch and download a file associated with the provided download ID.

		Args:
			download_id(str): ID of the download
			harddelete(bool): Flag to hard delete the file after download
		"""
		parameters = {
			'harddelete': harddelete,
			}

		endpoint = f"downloads/{download_id}"
		response: requests.Response = Download._call_api(method_type=HttpMethodType.GET, endpoint=endpoint, parameters=parameters, stream=True, is_query=True)
		if response.ok:
			return response.content
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')


class Label(ModelBaseClass):
	"""Python dataclass for the Label schema

	Args:
		id(str): Label id
		title(str): No description available at the moment
		color(str): No description available at the moment
	"""
	id: str
	title: str
	color: str

	@classmethod
	@preprocess_arguments
	def all(cls, license_id: str, project_id: Optional[str] = None) -> list[Label]:
		"""Get labels

		Args:
			license_id(str): ID of license
			project_id(str): Filter labels based on project id
		"""
		parameters = {
			'project': project_id,
			}

		endpoint = f"licenses/{license_id}/labels"
		response: requests.Response = Label._call_api(method_type=HttpMethodType.GET, endpoint=endpoint, parameters=parameters, is_query=True)
		if response.ok:
			return [Label._from_json(i) for i in response.json()]
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def create(cls, license_id: str, title: str, color: str, project_id: Optional[str] = None, description: Optional[str] = None) -> Label:
		"""Create label

		Args:
			license_id(str): No example available at the moment
			project_id(str): No example available at the moment
			title(str): For example 'title'
			description(str): For example 'description'
			color(str): For example '#DCDCDC'
		"""
		parameters = {
			'license': license_id,
			'project': project_id,
			'title': title,
			'description': description,
			'color': color,
			}

		endpoint = f"labels"
		response: requests.Response = Label._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return Label._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def update(cls, label_id: str, title: Optional[str] = None, description: Optional[str] = None, color: Optional[str] = None) -> Label:
		"""Update label

		Args:
			label_id(str): ID of Label
			title(str): For example 'title'
			description(str): For example 'description'
			color(str): For example '#DCDCDC'
		"""
		parameters = {
			'title': title,
			'description': description,
			'color': color,
			}

		endpoint = f"labels/{label_id}"
		response: requests.Response = Label._call_api(method_type=HttpMethodType.PUT, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return Label._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def delete(cls, label_id: str) -> MessageResponse:
		"""Delete label

		Args:
			label_id(str): ID of Label
		"""
		endpoint = f"labels/{label_id}"
		response: requests.Response = Label._call_api(method_type=HttpMethodType.DELETE, endpoint=endpoint)
		if response.ok:
			return MessageResponse._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')


class License(ModelBaseClass):
	"""Python dataclass for the License schema

	Args:
		id(str): License id
		name(str): License name
		theme(str): Theme color
		is_admin(bool): has license admin access
	"""
	id: str
	name: str
	theme: str
	is_admin: Optional[bool] = None

	@classmethod
	def all(cls) -> list[License]:
		"""Get auth user active licenses
		"""
		endpoint = f"licenses"
		response: requests.Response = License._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return [License._from_json(i) for i in response.json()]
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def get_users(cls, license_id: str) -> list[UserShort]:
		"""Get all users on current license

		Args:
			license_id(str): ID of license
		"""
		endpoint = f"licenses/{license_id}/users"
		response: requests.Response = License._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return [UserShort._from_json(i) for i in response.json()]
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def add_user(cls, license_id: str, email: str, first_name: Optional[str] = None, last_name: Optional[str] = None) -> MessageResponse:
		"""Add a user to current license

		Args:
			license_id(str): ID of license
			email(str): For example 'user@gmail.com'
			first_name(str): For example 'John'
			last_name(str): For example 'Doe'
		"""
		parameters = {
			'email': email,
			'first_name': first_name,
			'last_name': last_name,
			}

		endpoint = f"licenses/{license_id}/users"
		response: requests.Response = License._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return MessageResponse._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def set_access(cls, license_id: str, user_id: str, access: Optional[bool] = None) -> dict:
		"""Set the license access of a user

		Args:
			license_id(str): ID of license
			user_id(str): ID of user
			access(bool): For example 'True'
		"""
		parameters = {
			'access': access,
			}

		endpoint = f"licenses/{license_id}/users/{user_id}"
		response: requests.Response = License._call_api(method_type=HttpMethodType.PUT, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return response.json()
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def delete_user(cls, license_id: str, user_id: str) -> dict:
		"""Remove a user from the license

		Args:
			license_id(str): ID of license
			user_id(str): ID of user
		"""
		endpoint = f"licenses/{license_id}/users/{user_id}"
		response: requests.Response = License._call_api(method_type=HttpMethodType.DELETE, endpoint=endpoint)
		if response.ok:
			return response.json()
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')


class Link(ModelBaseClass):
	"""Python dataclass for the Link schema

	Args:
		id(str): Link id
		name(str): No description available at the moment
		link(str): No description available at the moment
		color(str): No description available at the moment
	"""
	id: str
	name: str
	link: str
	color: str

	@classmethod
	def all_project(cls, project_id: str) -> list[Link]:
		"""Get project links

		Args:
			project_id(str): ID of project
		"""
		endpoint = f"projects/{project_id}/links"
		response: requests.Response = Link._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return [Link._from_json(i) for i in response.json()]
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def create_project(cls, project_id: str, name: Optional[str] = None, link: Optional[str] = None, color: Optional[str] = None) -> Link:
		"""Create project link

		Args:
			project_id(str): ID of project
			name(str): For example 'Google'
			link(str): For example 'https://www.google.com'
			color(str): For example '#FF0000'
		"""
		parameters = {
			'name': name,
			'link': link,
			'color': color,
			}

		endpoint = f"projects/{project_id}/links"
		response: requests.Response = Link._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return Link._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def update_project(cls, project_id: str, link_id: str, name: Optional[str] = None, color: Optional[str] = None) -> Link:
		"""Update project link

		Args:
			project_id(str): ID of project
			link_id(str): ID of link
			name(str): For example 'Google'
			color(str): For example '#FF0000'
		"""
		parameters = {
			'name': name,
			'link': link_id,
			'color': color,
			}

		endpoint = f"projects/{project_id}/links/{link_id}"
		response: requests.Response = Link._call_api(method_type=HttpMethodType.PUT, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return Link._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def delete_project(cls, project_id: str, link_id: str) -> MessageResponse:
		"""Delete project link

		Args:
			project_id(str): ID of project
			link_id(str): ID of link
		"""
		endpoint = f"projects/{project_id}/links/{link_id}"
		response: requests.Response = Link._call_api(method_type=HttpMethodType.DELETE, endpoint=endpoint)
		if response.ok:
			return MessageResponse._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')


class Member(ModelBaseClass):
	"""Python dataclass for the Member schema

	Args:
		id(str): Member id
		first_name(str): No description available at the moment
		last_name(str): No description available at the moment
		name(str): No description available at the moment
		email(str): User unique email address
		roles(List): No description available at the moment
	"""
	id: Optional[str] = None
	first_name: Optional[str] = None
	last_name: Optional[str] = None
	name: Optional[str] = None
	email: Optional[str] = None
	roles: Optional[List] = None


class MessageResponse(ModelBaseClass):
	"""Python dataclass for the MessageResponse schema

	Args:
		message(str): Success message response
	"""
	message: str


class Module(ModelBaseClass):
	"""Python dataclass for the Module schema

	Args:
		id(str): Module id
		name(str): No description available at the moment
		description(str): No description available at the moment
		icon(str): No description available at the moment
		route(str): No description available at the moment
		category(str): No description available at the moment
	"""
	id: str
	name: str
	description: Optional[str] = None
	icon: str
	route: str
	category: Optional[str] = None


class NewsItem(ModelBaseClass):
	"""Python dataclass for the NewsItem schema

	Args:
		name(str): App.Models.NewsItem
	"""
	name: Optional[str] = None


class Permission(ModelBaseClass):
	"""Python dataclass for the Permission schema

	Args:
		id(str): Permission id
		group(str): group id
		create(bool): No description available at the moment
		read(bool): No description available at the moment
		update(bool): No description available at the moment
		delete(bool): No description available at the moment
		configure(bool): No description available at the moment
	"""
	id: str
	group: Optional[str] = None
	create: bool
	read: bool
	update: bool
	delete: bool
	configure: bool

	@classmethod
	def all(cls, table_id: str) -> list[Permission]:
		"""Get permissions

		Args:
			table_id(str): ID of table
		"""
		endpoint = f"tables/{table_id}/permissions"
		response: requests.Response = Permission._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return [Permission._from_json(i) for i in response.json()]
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def get(cls, permission_id: str) -> Permission:
		"""Get permission

		Args:
			permission_id(str): ID of Permission
		"""
		endpoint = f"permissions/{permission_id}"
		response: requests.Response = Permission._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return Permission._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def delete(cls, permission_id: str) -> MessageResponse:
		"""Delete permission

		Args:
			permission_id(str): ID of Permission
		"""
		endpoint = f"permissions/{permission_id}"
		response: requests.Response = Permission._call_api(method_type=HttpMethodType.DELETE, endpoint=endpoint)
		if response.ok:
			return MessageResponse._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def create_all(cls, table_id: str, role_id: str, create: Optional[bool] = None, read: Optional[bool] = None, update: Optional[bool] = None, delete: Optional[bool] = None, configure: Optional[bool] = None) -> Permission:
		"""Create permissions

		Args:
			create(bool): For example 'true'
			read(bool): For example 'true'
			update(bool): For example 'false'
			delete(bool): For example 'true'
			configure(bool): For example 'false'
			table_id(str): No example available at the moment
			role_id(str): No example available at the moment
		"""
		parameters = {
			'create': create,
			'read': read,
			'update': update,
			'delete': delete,
			'configure': configure,
			'table': table_id,
			'role': role_id,
			}

		endpoint = f"permissions"
		response: requests.Response = Permission._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return Permission._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')


class Project(ModelBaseClass):
	"""Python dataclass for the Project schema

	Args:
		id(str): Project id
		license(str): license id
		name(str): No description available at the moment
		description(str): No description available at the moment
		number(str): No description available at the moment
		slug(str): No description available at the moment
		image(str): image id
		is_master(bool): No description available at the moment
		modules(List): No description available at the moment
		created_at(str): created_at id
	"""
	id: str
	license: Optional[str] = None
	name: str
	description: str
	number: str
	slug: str
	image: Optional[str] = None
	is_master: bool
	modules: Optional[List] = None
	created_at: str

	@classmethod
	@preprocess_arguments
	def all_license(cls, license_id: str, filters: Optional[dict] = None) -> list[Project]:
		"""Get all projects within license

		Args:
			license_id(str): ID of license
			filters(dict): No example available at the moment
		"""
		parameters = {
			'filters': filters,
			}

		endpoint = f"licenses/{license_id}/projects"
		response: requests.Response = Project._call_api(method_type=HttpMethodType.GET, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return [Project._from_json(i) for i in response.json()]
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def get(cls, project_id: str) -> Project:
		"""Get project

		Args:
			project_id(str): ID of project
		"""
		endpoint = f"projects/{project_id}"
		response: requests.Response = Project._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return Project._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def update(cls, project_id: str, name: Optional[str] = None, description: Optional[str] = None, number: Optional[str] = None, is_archive: Optional[bool] = None) -> Project:
		"""Update project information

		Args:
			project_id(str): ID of project
			name(str): For example 'Projects 1'
			description(str): For example 'description'
			number(str): For example '1'
			is_archive(bool): For example 'true'
		"""
		parameters = {
			'name': name,
			'description': description,
			'number': number,
			'is_archive': is_archive,
			}

		endpoint = f"projects/{project_id}"
		response: requests.Response = Project._call_api(method_type=HttpMethodType.PUT, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return Project._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def delete(cls, project_id: str) -> MessageResponse:
		"""Delete project

		Args:
			project_id(str): ID of project
		"""
		endpoint = f"projects/{project_id}"
		response: requests.Response = Project._call_api(method_type=HttpMethodType.DELETE, endpoint=endpoint)
		if response.ok:
			return MessageResponse._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def create(cls, name: str, description: str, number: str, license: str) -> Project:
		"""Create new project

		Args:
			name(str): For example 'Projects 1'
			description(str): For example 'description'
			number(str): For example '1'
			license(str): No example available at the moment
		"""
		parameters = {
			'name': name,
			'description': description,
			'number': number,
			'license': license,
			}

		endpoint = f"projects"
		response: requests.Response = Project._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return Project._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def favorite(cls, project_id: str, favorite: Optional[bool] = None) -> dict:
		"""Marks the specified project as a favorite or removes it from favorites based on the current state.

		Args:
			project_id(str): UUID of the project
			favorite(bool): For example 'True'
		"""
		parameters = {
			'favorite': favorite,
			}

		endpoint = f"projects/{project_id}/favorite"
		response: requests.Response = Project._call_api(method_type=HttpMethodType.PUT, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return response.json()
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def fetch_image(cls, project_id: str) -> Union[str, bytes]:
		"""Fetches the image associated with the specified project. Returns the image file if found.

		Args:
			project_id(str): UUID of the project
		"""
		endpoint = f"projects/{project_id}/image"
		response: requests.Response = Project._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return response.content
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')


class Record(ModelBaseClass):
	"""Python dataclass for the Record schema

	Args:
		id(str): Record id
	"""
	id: Optional[str] = None

	@classmethod
	@preprocess_arguments
	def create(cls, table_id: str, record: Optional[dict] = None) -> Record:
		"""Create record

		Args:
			table_id(str): ID of table
			record(dict): No example available at the moment
		"""
		parameters = {
			'record': record,
			}

		endpoint = f"tables/{table_id}/records"
		response: requests.Response = Record._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return Record._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def delete_all(cls, table_id: str, records: Optional[List] = None) -> MessageResponse:
		"""Delete multiple records

		Args:
			table_id(str): ID of table
			records(List): No example available at the moment
		"""
		parameters = {
			'records': records,
			}

		endpoint = f"tables/{table_id}/records"
		response: requests.Response = Record._call_api(method_type=HttpMethodType.DELETE, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return MessageResponse._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def import_all(cls, table_id: str, records: Optional[str] = None) -> MessageResponse:
		"""Import records

		Args:
			table_id(str): ID of table
			records(str): No example available at the moment
		"""
		parameters = {
			'records': records,
			}

		endpoint = f"tables/{table_id}/records/import"
		response: requests.Response = Record._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return MessageResponse._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def update(cls, table_id: str, record_id: str) -> Record:
		"""Update record

		Args:
			table_id(str): ID of table
			record_id(str): ID of record
		"""
		parameters = {
			'record': record_id,
			}

		endpoint = f"tables/{table_id}/records/{record_id}"
		response: requests.Response = Record._call_api(method_type=HttpMethodType.PUT, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return Record._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def get_history(cls, record_id: str, table_id: str) -> dict:
		"""Get record history

		Args:
			record_id(str): ID of record
			table_id(str): ID of table
		"""
		endpoint = f"tables/{table_id}/records/{record_id}/history"
		response: requests.Response = Record._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return response.json()
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def download_document(cls, document_id: str, record_id: str, table_id: str) -> dict:
		"""Download record document

		Args:
			document_id(str): ID of document
			record_id(str): ID of record
			table_id(str): ID of table
		"""
		endpoint = f"tables/{table_id}/records/{record_id}/documents/{document_id}"
		response: requests.Response = Record._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return response.json()
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')


class Relation(ModelBaseClass):
	"""Python dataclass for the Relation schema

	Args:
		id(str): Relation id
		project(str): project id
		related_project(str): related_project id
		table(dict): table id
		related_table(dict): related_table id
		column(dict): column id
		related_column(dict): related_column id
	"""
	id: str
	project: str
	related_project: str
	table: dict
	related_table: dict
	column: dict
	related_column: dict

	@classmethod
	def all(cls, table_id: str) -> list[Relation]:
		"""Get table relations

		Args:
			table_id(str): ID of table
		"""
		endpoint = f"ables/{table_id}/relations"
		response: requests.Response = Relation._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return [Relation._from_json(i) for i in response.json()]
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def create(cls, table: str, column: str, related_project: str, related_table: str, related_column: Optional[str] = None) -> Relation:
		"""Create table relation

		Args:
			table(str): No example available at the moment
			column(str): No example available at the moment
			related_project(str): No example available at the moment
			related_table(str): No example available at the moment
			related_column(str): No example available at the moment
		"""
		parameters = {
			'table': table,
			'column': column,
			'related_project': related_project,
			'related_table': related_table,
			'related_column': related_column,
			}

		endpoint = f"relations"
		response: requests.Response = Relation._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return Relation._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def delete(cls, relation_id: str) -> MessageResponse:
		"""Delete table relation

		Args:
			relation_id(str): ID of relation
		"""
		endpoint = f"relations/{relation_id}"
		response: requests.Response = Relation._call_api(method_type=HttpMethodType.DELETE, endpoint=endpoint)
		if response.ok:
			return MessageResponse._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')


class Revision(ModelBaseClass):
	"""Python dataclass for the Revision schema

	Args:
		id(str): Revision id
		project(str): project id
		table(str): table id
		reason(str): No description available at the moment
		version(int): No description available at the moment
		timestamp(str): timestamp id
	"""
	id: str
	project: Optional[str] = None
	table: Optional[str] = None
	reason: str
	version: int
	timestamp: str


class Role(ModelBaseClass):
	"""Python dataclass for the Role schema

	Args:
		id(str): Role id
		name(str): License name
		is_admin(bool): No description available at the moment
	"""
	id: str
	name: str
	is_admin: Optional[bool] = None

	@classmethod
	def all_project(cls, project_id: str) -> list[Role]:
		"""Get project roles

		Args:
			project_id(str): ID of project
		"""
		endpoint = f"projects/{project_id}/roles"
		response: requests.Response = Role._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return [Role._from_json(i) for i in response.json()]
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def get_project(cls, role_id: str) -> Role:
		"""Get project role

		Args:
			role_id(str): ID of Role
		"""
		endpoint = f"roles/{role_id}"
		response: requests.Response = Role._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return Role._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def update_project(cls, role_id: str, name: str) -> Role:
		"""Update project role name

		Args:
			role_id(str): ID of Role
			name(str): For example 'role name'
		"""
		parameters = {
			'name': name,
			}

		endpoint = f"roles/{role_id}"
		response: requests.Response = Role._call_api(method_type=HttpMethodType.PUT, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return Role._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def delete_project(cls, role_id: str) -> MessageResponse:
		"""Delete project role

		Args:
			role_id(str): ID of Role
		"""
		endpoint = f"roles/{role_id}"
		response: requests.Response = Role._call_api(method_type=HttpMethodType.DELETE, endpoint=endpoint)
		if response.ok:
			return MessageResponse._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def add_to_project(cls, name: str, project_id: str) -> Role:
		"""Add role to project

		Args:
			name(str): For example 'role 1'
			project_id(str): No example available at the moment
		"""
		parameters = {
			'name': name,
			'project': project_id,
			}

		endpoint = f"roles"
		response: requests.Response = Role._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return Role._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def update_general_permissions(cls, role_id: str, sbs: Optional[bool] = None, workflows: Optional[bool] = None, tables: Optional[bool] = None, tasks: Optional[bool] = None, labels: Optional[bool] = None) -> dict:
		"""Update project role general permissions

		Args:
			role_id(str): ID of Role
			sbs(bool): For example 'true'
			workflows(bool): For example 'true'
			tables(bool): For example 'true'
			tasks(bool): For example 'false'
			labels(bool): For example 'false'
		"""
		parameters = {
			'sbs': sbs,
			'workflows': workflows,
			'tables': tables,
			'tasks': tasks,
			'labels': labels,
			}

		endpoint = f"roles/{role_id}/permissions/general"
		response: requests.Response = Role._call_api(method_type=HttpMethodType.PUT, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return response.json()
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def update_sbs_permissions(cls, role_id: str, create: Optional[bool] = None, update: Optional[bool] = None, delete: Optional[bool] = None, is_import: Optional[bool] = None) -> dict:
		"""Update project role sbs permissions

		Args:
			role_id(str): ID of Role
			create(bool): For example 'true'
			update(bool): For example 'true'
			delete(bool): For example 'true'
			is_import(bool): For example 'false'
		"""
		parameters = {
			'create': create,
			'update': update,
			'delete': delete,
			'is_import': is_import,
			}

		endpoint = f"roles/{role_id}/permissions/sbs"
		response: requests.Response = Role._call_api(method_type=HttpMethodType.PUT, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return response.json()
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def update_workflow_permissions(cls, role_id: str, is_import: Optional[bool] = None, configure: Optional[bool] = None, start_session: Optional[bool] = None) -> dict:
		"""Update project role workflows permissions

		Args:
			role_id(str): ID of Role
			is_import(bool): For example 'false'
			configure(bool): For example 'false'
			start_session(bool): For example 'false'
		"""
		parameters = {
			'is_import': is_import,
			'configure': configure,
			'start_session': start_session,
			}

		endpoint = f"roles/{role_id}/permissions/workflows"
		response: requests.Response = Role._call_api(method_type=HttpMethodType.PUT, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return response.json()
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')


class SbsRecord(ModelBaseClass):
	"""Python dataclass for the SbsRecord schema

	Args:
		code(str): App.Models.SbsRecord
		parent(str): No description available at the moment
		label(str): No description available at the moment
		level(int): No description available at the moment
		hasChildren(bool): No description available at the moment
	"""
	code: str
	parent: Optional[str] = None
	label: Optional[str] = None
	level: Optional[int] = None
	hasChildren: Optional[bool] = None

	@classmethod
	@preprocess_arguments
	def all(cls, project_id: str, code_id: Optional[str] = None, term_id: Optional[str] = None) -> list[SbsRecord]:
		"""Get project sbs records

		Args:
			project_id(str): ID of project
			code_id(str): Sbscode to fetch its children (for top level this should be empty)
			term_id(str): Search term to find sbscodes
		"""
		parameters = {
			'code': code_id,
			'term': term_id,
			}

		endpoint = f"projects/{project_id}/sbs"
		response: requests.Response = SbsRecord._call_api(method_type=HttpMethodType.GET, endpoint=endpoint, parameters=parameters, is_query=True)
		if response.ok:
			return [SbsRecord._from_json(i) for i in response.json()]
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def update_sbs_records(cls, project_id: str, code_id: str, parent: Optional[str] = None, label: Optional[str] = None) -> SbsRecord:
		"""Update sbs record

		Args:
			project_id(str): ID of project
			code_id(str): Sbscode
			parent(str): For example '1'
			label(str): For example 'Code 2'
		"""
		parameters = {
			'code': code_id,
			'parent': parent,
			'label': label,
			}

		endpoint = f"projects/{project_id}/sbs/{code_id}"
		response: requests.Response = SbsRecord._call_api(method_type=HttpMethodType.PUT, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return SbsRecord._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def create_sbs_records(cls, project_id: str, code_id: str, parent: Optional[str] = None, label: Optional[str] = None) -> SbsRecord:
		"""Create sbs record

		Args:
			project_id(str): ID of project
			code_id(str): Sbscode
			parent(str): For example '1'
			label(str): For example 'Code 2'
		"""
		parameters = {
			'parent': parent,
			'label': label,
			}

		endpoint = f"projects/{project_id}/sbs/{code_id}"
		response: requests.Response = SbsRecord._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return SbsRecord._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def delete_sbs_records(cls, project_id: str, code_id: str) -> MessageResponse:
		"""Delete sbs record

		Args:
			project_id(str): ID of project
			code_id(str): Sbscode
		"""
		endpoint = f"projects/{project_id}/sbs/{code_id}"
		response: requests.Response = SbsRecord._call_api(method_type=HttpMethodType.DELETE, endpoint=endpoint)
		if response.ok:
			return MessageResponse._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')


class SbsVersion(ModelBaseClass):
	"""Python dataclass for the SbsVersion schema

	Args:
		id(str): SbsVersion id
		project(str): project id
		user(str): user id
		label(str): No description available at the moment
		created_at(str): created_at id
	"""
	id: str
	project: str
	user: str
	label: str
	created_at: str


class Script(ModelBaseClass):
	"""Python dataclass for the Script schema

	Args:
		id(str): Script id
		license_id(str): license_id id
		user_id(str): user_id id
		genesis_id(str): genesis_id id
		is_genesis(bool): No description available at the moment
		version_code(int): No description available at the moment
		version(str): No description available at the moment
		name(str): No description available at the moment
		content(str): No description available at the moment
		versions(List): No description available at the moment
	"""
	id: str
	license_id: Optional[str] = None
	user_id: Optional[str] = None
	genesis_id: Optional[str] = None
	is_genesis: Optional[bool] = None
	version_code: Optional[int] = None
	version: Optional[str] = None
	name: str
	content: Optional[str] = None
	versions: Optional[List[dict]] = None

	@classmethod
	def get(cls, script_id: str) -> Script:
		"""Get script

		Args:
			script_id(str): ID of Script
		"""
		endpoint = f"scripts/{script_id}"
		response: requests.Response = Script._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return Script._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')


class AntPersonalAccessToken(ModelBaseClass):
	"""Python dataclass for the AntPersonalAccessToken schema

	Args:
		id(str): No description available at the moment
		user_id(str): user_id id
		name(str): No description available at the moment
		revoked(bool): No description available at the moment
		expires_at(str): No description available at the moment
	"""
	id: str
	user_id: Optional[str] = None
	name: Optional[str] = None
	revoked: Optional[bool] = None
	expires_at: Optional[str] = None

	@classmethod
	def get_tokens(cls) -> list[AntPersonalAccessToken]:
		"""Get tokens
		"""
		endpoint = f"oauth/personal-access-tokens"
		response: requests.Response = AntPersonalAccessToken._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return [AntPersonalAccessToken._from_json(i) for i in response.json()]
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def create_token(cls, name: Optional[str] = None, expires_at: Optional[str] = None) -> AntPersonalAccessTokenResult:
		"""Create token

		Args:
			name(str): For example 'title'
			expires_at(str): No example available at the moment
		"""
		parameters = {
			'name': name,
			'expires_at': expires_at,
			}

		endpoint = f"tokens"
		response: requests.Response = AntPersonalAccessToken._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return AntPersonalAccessTokenResult._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def update_token(cls, token_id: str, name: str, expires_at: Optional[str] = None) -> AntPersonalAccessTokenResult:
		"""Update token

		Args:
			token_id(str): ID of token
			name(str): For example 'title'
			expires_at(str): No example available at the moment
		"""
		parameters = {
			'name': name,
			'expires_at': expires_at,
			}

		endpoint = f"tokens/{token_id}"
		response: requests.Response = AntPersonalAccessToken._call_api(method_type=HttpMethodType.PUT, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return AntPersonalAccessTokenResult._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def delete_token(cls, token_id: str) -> MessageResponse:
		"""Delete token

		Args:
			token_id(str): ID of token
		"""
		endpoint = f"oauth/personal-access-tokens/{token_id}"
		response: requests.Response = AntPersonalAccessToken._call_api(method_type=HttpMethodType.DELETE, endpoint=endpoint)
		if response.ok:
			return MessageResponse._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')


class AntPersonalAccessTokenResult(ModelBaseClass):
	"""Python dataclass for the AntPersonalAccessTokenResult schema

	Args:
		token(dict): token id
		accessToken(str): No description available at the moment
	"""
	token: dict
	accessToken: Optional[str] = None


class Table(ModelBaseClass):
	"""Python dataclass for the Table schema

	Args:
		id(str): Table id
		project(str): project id
		name(str): No description available at the moment
		permissions(dict): No description available at the moment
		created_at(str): created_at id
	"""
	id: str
	project: Optional[str] = None
	name: str
	permissions: Optional[dict] = None
	created_at: Optional[str] = None

	@classmethod
	def all(cls, project_id: str) -> list[Table]:
		"""Get project tables

		Args:
			project_id(str): ID of project
		"""
		endpoint = f"projects/{project_id}/tables"
		response: requests.Response = Table._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return [Table._from_json(i) for i in response.json()]
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def get(cls, table_id: str) -> Table:
		"""Get project table

		Args:
			table_id(str): ID of table
		"""
		endpoint = f"tables/{table_id}"
		response: requests.Response = Table._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return Table._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def update(cls, table_id: str, name: str) -> Table:
		"""Update project table

		Args:
			table_id(str): ID of table
			name(str): For example 'Collection 1'
		"""
		parameters = {
			'name': name,
			}

		endpoint = f"tables/{table_id}"
		response: requests.Response = Table._call_api(method_type=HttpMethodType.PUT, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return Table._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def delete(cls, table_id: str) -> MessageResponse:
		"""Delete project table

		Args:
			table_id(str): ID of table
		"""
		endpoint = f"tables/{table_id}"
		response: requests.Response = Table._call_api(method_type=HttpMethodType.DELETE, endpoint=endpoint)
		if response.ok:
			return MessageResponse._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def create(cls, name: str, project_id: str) -> Table:
		"""Create project table

		Args:
			name(str): For example 'Collection 1'
			project_id(str): No example available at the moment
		"""
		parameters = {
			'name': name,
			'project': project_id,
			}

		endpoint = f"tables"
		response: requests.Response = Table._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return Table._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def restore(cls, table_id: str, revision_id: str) -> dict:
		"""Restore project table to a specific revision

		Args:
			table_id(str): ID of table
			revision_id(str): ID of revision
		"""
		endpoint = f"tables/{table_id}/restore/{revision_id}"
		response: requests.Response = Table._call_api(method_type=HttpMethodType.POST, endpoint=endpoint)
		if response.ok:
			return response.json()
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def query_all(cls, tables: List[dict]) -> list[dict]:
		"""Queries records from multiple tables

		Args:
			tables(List): No example available at the moment
		"""
		parameters = {
			'tables': tables,
			}

		endpoint = f"tables/query"
		response: requests.Response = Table._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return response.json()
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def query_export_all(cls, tables: List[dict]) -> dict:
		"""Queries records from a single table

		Args:
			tables(List): No example available at the moment
		"""
		parameters = {
			'tables': tables,
			}

		endpoint = f"tables/query/export"
		response: requests.Response = Table._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return response.json()
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')


class Task(ModelBaseClass):
	"""Python dataclass for the Task schema

	Args:
		id(str): Task id
		license(str): license id
		project(str): project id
		parent(str): parent id
		title(str): No description available at the moment
		description(str): No description available at the moment
		number(int): No description available at the moment
		planned_start(str): No description available at the moment
		planned_end(str): No description available at the moment
		due(str): No description available at the moment
		status(str): No description available at the moment
		priority(Priority): No description available at the moment
		task_type(dict): task_type id
		task_project(dict): No description available at the moment
		sbscode(dict): No description available at the moment
		assigned_to(dict): No description available at the moment
		relations(List): No description available at the moment
		created_by(dict): No description available at the moment
		script(str): script id
		created_at(str): created_at id
	"""
	id: str
	license: Optional[str] = None
	project: Optional[str] = None
	parent: Optional[str] = None
	title: str
	description: Optional[str] = None
	number: Optional[int] = None
	planned_start: Optional[str] = None
	planned_end: Optional[str] = None
	due: Optional[str] = None
	status: Optional[str] = None
	priority: Optional[Priority] = None
	task_type: Optional[dict] = None
	task_project: Optional[dict] = None
	sbscode: Optional[dict] = None
	assigned_to: Optional[dict] = None
	relations: Optional[List] = None
	created_by: Optional[dict] = None
	script: Optional[str] = None
	created_at: Optional[str] = None

	@classmethod
	@preprocess_arguments
	def upload_appendix(cls, task_id: str, name: str, extension: str, data: str) -> Task:
		"""Upload task appendix

		Args:
			task_id(str): ID of task
			name(str): For example 'image'
			extension(str): For example 'jpg'
			data(str): For example 'iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAARklEQVR42u3PQREAAAQAMP761xGNDL5ua7CsmI4=='
		"""
		parameters = {
			'name': name,
			'extension': extension,
			'data': data,
			}

		endpoint = f"tasks/{task_id}/appendixes"
		response: requests.Response = Task._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return Task._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def download_appendix(cls, task_id: str, appendix_id: str) -> TaskFile:
		"""Download task appendix

		Args:
			task_id(str): ID of task
			appendix_id(str): ID of appendix
		"""
		endpoint = f"tasks/{task_id}/appendixes/{appendix_id}"
		response: requests.Response = Task._call_api(method_type=HttpMethodType.POST, endpoint=endpoint)
		if response.ok:
			return TaskFile._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def delete_appendix(cls, task_id: str, appendix_id: str) -> Task:
		"""Delete task appendix

		Args:
			task_id(str): ID of task
			appendix_id(str): ID of appendix
		"""
		endpoint = f"tasks/{task_id}/appendixes/{appendix_id}"
		response: requests.Response = Task._call_api(method_type=HttpMethodType.DELETE, endpoint=endpoint)
		if response.ok:
			return Task._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def create_check(cls, task_id: str, title: str) -> TaskCheck:
		"""Create task check

		Args:
			task_id(str): ID of task
			title(str): For example 'Check 1'
		"""
		parameters = {
			'title': title,
			}

		endpoint = f"tasks/{task_id}/checks"
		response: requests.Response = Task._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return TaskCheck._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def delete_check(cls, task_check_id: str, task_id: str) -> MessageResponse:
		"""Delete task check

		Args:
			task_check_id(str): ID of task
			task_id(str): ID of task
		"""
		endpoint = f"tasks/{task_id}/checks/{task_check_id}"
		response: requests.Response = Task._call_api(method_type=HttpMethodType.DELETE, endpoint=endpoint)
		if response.ok:
			return MessageResponse._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def save_all(cls, objects: List[dict]) -> list[Task]:
		"""Create/Update one or multiple tasks

		Args:
			objects(List): List of objects (see documentation for object properties)
		"""
		parameters = objects

		endpoint = f"tasks"
		response: requests.Response = Task._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return [Task._from_json(i) for i in response.json()]
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def get(cls, task_id: str) -> Task:
		"""Get task

		Args:
			task_id(str): ID of task
		"""
		endpoint = f"tasks/{task_id}"
		response: requests.Response = Task._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return Task._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def query_all(cls, license_id: str, query_string: Union[str, QueryBuilder], is_task: Optional[bool] = None) -> dict:
		"""Get a list of tasks based on user specified query

		Args:
			license_id(str): ID of License
			query_string(Union[str, QueryBuilder]): Filter tasks based on query string
		"""
		if isinstance(query_string, QueryBuilder):
			query_string = query_string.to_query_string()

		parameters = query_string


		endpoint = f"licenses/{license_id}/tasks"
		response: requests.Response = Task._call_api(method_type=HttpMethodType.GET, endpoint=endpoint, parameters=parameters, is_query=True)
		if response.ok:
			return response.json()
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def query(cls, task_id: str, query_string: Union[str, QueryBuilder]) -> dict:
		"""Get a task based on user specified query

		Args:
			task_id(str): ID of Task
			query_string(Union[str, QueryBuilder]): Filter tasks based on query string
		"""
		if isinstance(query_string, QueryBuilder):
			query_string = query_string.to_query_string()

		parameters = query_string


		endpoint = f"task/{task_id}"
		response: requests.Response = Task._call_api(method_type=HttpMethodType.GET, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return response.json()
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def delete_all(cls, tasks: Optional[List[dict]] = None) -> MessageResponse:
		"""Delete multiple tasks

		Args:
			tasks(List): For example '[{'id': '54d7c0bb-a17d-44c4-8e94-f8e5b961ff7d', 'method': 'single'}, {'id': 'ca9912cf-5c59-4424-a5e6-bc86c37ab25a', 'method': 'with-subtasks'}]'
		"""
		parameters = {
			'tasks': tasks,
			}

		endpoint = f"tasks/delete"
		response: requests.Response = Task._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return MessageResponse._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def create_label(cls, task_id: str, label_id: str) -> Label:
		"""Add label to task

		Args:
			task_id(str): ID of task
			label_id(str): ID of label
		"""
		endpoint = f"tasks/{task_id}/labels/{label_id}"
		response: requests.Response = Task._call_api(method_type=HttpMethodType.POST, endpoint=endpoint)
		if response.ok:
			return Label._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	def delete_label(cls, task_id: str, label_id: str) -> MessageResponse:
		"""Delete label from  task

		Args:
			task_id(str): ID of task
			label_id(str): ID of label
		"""
		endpoint = f"tasks/{task_id}/labels/{label_id}"
		response: requests.Response = Task._call_api(method_type=HttpMethodType.DELETE, endpoint=endpoint)
		if response.ok:
			return MessageResponse._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def create_message(cls, task_id: str, message: str) -> TaskActivity:
		"""Create task message

		Args:
			task_id(str): ID of task
			message(str): For example 'message'
		"""
		parameters = {
			'message': message,
			}

		endpoint = f"tasks/{task_id}/messages"
		response: requests.Response = Task._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return TaskActivity._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')


class TaskActivity(ModelBaseClass):
	"""Python dataclass for the TaskActivity schema

	Args:
		id(str): TaskActivity id
		action(str): No description available at the moment
		column(str): No description available at the moment
		value(str): No description available at the moment
		previous_value(str): No description available at the moment
		type(str): No description available at the moment
		user(dict): user id
	"""
	id: Optional[str] = None
	action: Optional[str] = None
	column: Optional[str] = None
	value: Optional[str] = None
	previous_value: Optional[str] = None
	type: Optional[str] = None
	user: Optional[dict] = None


class TaskCheck(ModelBaseClass):
	"""Python dataclass for the TaskCheck schema

	Args:
		id(str): TaskCheck id
		task(str): task id
		title(str): No description available at the moment
		completed(bool): No description available at the moment
	"""
	id: str
	task: Optional[str] = None
	title: str
	completed: Optional[bool] = None


class TaskFile(ModelBaseClass):
	"""Python dataclass for the TaskFile schema

	Args:
		id(str): TaskFile id
		task(str): task id
		name(str): No description available at the moment
		extension(str): No description available at the moment
		size(int): No description available at the moment
		mimetype(str): No description available at the moment
		file(str): base64 encoded file
		created_at(str): created_at id
	"""
	id: str
	task: Optional[str] = None
	name: Optional[str] = None
	extension: Optional[str] = None
	size: Optional[int] = None
	mimetype: Optional[str] = None
	file: Optional[str] = None
	created_at: Optional[str] = None


class TaskRelation(ModelBaseClass):
	"""Python dataclass for the TaskRelation schema

	Args:
		id(str): TaskRelation id
		target(str): target id
		source(str): source id
		type(str): No description available at the moment
	"""
	id: Optional[str] = None
	target: Optional[str] = None
	source: Optional[str] = None
	type: Optional[str] = None


class TaskType(ModelBaseClass):
	"""Python dataclass for the TaskType schema

	Args:
		type(str): App.Models.TaskType
		executable(bool): No description available at the moment
		custom_1(str): No description available at the moment
		custom_2(str): No description available at the moment
		custom_3(str): No description available at the moment
		custom_4(str): No description available at the moment
		custom_5(str): No description available at the moment
		metadata(str): No description available at the moment
	"""
	type: Optional[str] = None
	executable: Optional[bool] = None
	custom_1: Optional[str] = None
	custom_2: Optional[str] = None
	custom_3: Optional[str] = None
	custom_4: Optional[str] = None
	custom_5: Optional[str] = None
	metadata: Optional[str] = None


class User(ModelBaseClass):
	"""Python dataclass for the User schema

	Args:
		id(str): User id
		first_name(str): No description available at the moment
		last_name(str): No description available at the moment
		photo(str): photo id
		name(str): No description available at the moment
		email(str): User unique email address
		task_daily_digest(bool): Receive daily task email
		last_active_at(str): last active timestamp
		two_factor_enabled(bool): two factor authentication status
		password_expires_in(int): days left till password expires
		licenses(List): No description available at the moment
		roles(List): No description available at the moment
		company(dict): company id
		created_at(str): created_at id
	"""
	id: Optional[str] = None
	first_name: Optional[str] = None
	last_name: Optional[str] = None
	photo: Optional[str] = None
	name: Optional[str] = None
	email: Optional[str] = None
	task_daily_digest: Optional[bool] = None
	last_active_at: Optional[str] = None
	two_factor_enabled: Optional[bool] = None
	password_expires_in: Optional[int] = None
	licenses: Optional[List] = None
	roles: Optional[List] = None
	company: Optional[dict] = None
	created_at: Optional[str] = None

	@classmethod
	def get_auth(cls) -> User:
		"""Get authenticated user information
		"""
		endpoint = f"users"
		response: requests.Response = User._call_api(method_type=HttpMethodType.GET, endpoint=endpoint)
		if response.ok:
			return User._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def update(cls, email: str, firstname: Optional[str] = None, lastname: Optional[str] = None, language: Optional[str] = None, company_name: Optional[str] = None, photo: Optional[str] = None) -> User:
		"""Update user profile data including optional profile image.

		Args:
			firstname(str): No example available at the moment
			lastname(str): No example available at the moment
			language(str): No example available at the moment
			email(str): No example available at the moment
			company_name(str): No example available at the moment
			photo(str): No example available at the moment
		"""
		parameters = {
			'firstname': firstname,
			'lastname': lastname,
			'language': language,
			'email': email,
			'company_name': company_name,
			'photo': photo,
			}

		endpoint = f"users"
		response: requests.Response = User._call_api(method_type=HttpMethodType.POST, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return User._from_json(response.json())
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')

	@classmethod
	@preprocess_arguments
	def update_password(cls, currentpassword: str, newpassword: str) -> dict:
		"""Update user password

		Args:
			currentpassword(str): For example '123456'
			newpassword(str): For example '910124'
		"""
		parameters = {
			'currentpassword': currentpassword,
			'newpassword': newpassword,
			}

		endpoint = f"users/password"
		response: requests.Response = User._call_api(method_type=HttpMethodType.PUT, endpoint=endpoint, parameters=parameters)
		if response.ok:
			return response.json()
		else:
			raise ValueError(f'Could not load data from API, response code {response.status_code} with response {response.text}')


class UserShort(ModelBaseClass):
	"""Python dataclass for the UserShort schema

	Args:
		id(str): UserShort id
		first_name(str): No description available at the moment
		last_name(str): No description available at the moment
		name(str): No description available at the moment
		email(str): User unique email address
	"""
	id: Optional[str] = None
	first_name: Optional[str] = None
	last_name: Optional[str] = None
	name: Optional[str] = None
	email: Optional[str] = None


class Workflow(ModelBaseClass):
	"""Python dataclass for the Workflow schema

	Args:
		id(str): Workflow id
		name(str): Collection name
		description(str): Collection description
		created_by(dict): No description available at the moment
		created_at(str): created_at id
	"""
	id: Optional[str] = None
	name: str
	description: Optional[str] = None
	created_by: Optional[dict] = None
	created_at: Optional[str] = None


class WorkflowCollection(ModelBaseClass):
	"""Python dataclass for the WorkflowCollection schema

	Args:
		id(str): WorkflowCollection id
		name(str): Collection name
		description(str): Collection description
		created_by(dict): No description available at the moment
		license(str): license id
		created_at(str): created_at id
	"""
	id: Optional[str] = None
	name: str
	description: Optional[str] = None
	created_by: Optional[dict] = None
	license: str
	created_at: Optional[str] = None