



class ValueParser_ByteWithUnit(object):

	__UNITS = {
		"K": 1024,
		"KB": 1024,
		"M": 1024*1024,
		"MB": 1024*1024,
		"G": 1024*1024*1024,
		"GB": 1024*1024*1024,
		"T": 1024*1024*1024*1024,
		"TB": 1024*1024*1024*1024,
	}

	################################################################################################################################
	## Constructors
	################################################################################################################################

	################################################################################################################################
	## Public Properties
	################################################################################################################################

	################################################################################################################################
	## Helper Methods
	################################################################################################################################

	################################################################################################################################
	## Public Methods
	################################################################################################################################

	def __call__(self, s:str) -> int:
		return ValueParser_ByteWithUnit.parse(s)
	#

	################################################################################################################################
	## Static Methods
	################################################################################################################################

	@staticmethod
	def parse(s:str) -> int:
		assert isinstance(s, str)
		s = s.strip()
		if not s:
			raise ValueError(s)
		s2 = s.upper()

		for k, factor in ValueParser_ByteWithUnit.__UNITS.items():
			if s2.endswith(k):
				s = s[:-len(k)].strip()
				return int(s) * factor

		return int(s)
	#

#


