# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import Optional
from typing_extensions import Literal

from .._models import BaseModel
from .shared.logprobs import Logprobs
from .chat_completion_message import ChatCompletionMessage

__all__ = ["ChatCompletionChoice"]


class ChatCompletionChoice(BaseModel):
    finish_reason: Literal["stop", "length", "content_filter", "tool_calls"]
    """Describes the condition under which the model ceased generating content.

    Common reasons include 'length' (reached the maximum output size), 'stop'
    (encountered a stop sequence), 'content_filter' (harmful content filtered out),
    or 'tool_calls' (encountered tool calls).
    """

    index: int
    """The index of the choice in the list of completions generated by the model."""

    message: ChatCompletionMessage
    """The chat completion message from the model.

    Note: this field is deprecated for streaming. Use `delta` instead.
    """

    logprobs: Optional[Logprobs] = None
    """Log probability information for the choice."""
