# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Optional
from typing_extensions import Literal

from .._models import BaseModel
from .chat_completion_usage import ChatCompletionUsage
from .chat_completion_choice import ChatCompletionChoice

__all__ = ["ChatCompletion"]


class ChatCompletion(BaseModel):
    id: str
    """A globally unique identifier (UUID) for the response generated by the API.

    This ID can be used to reference the specific operation or transaction within
    the system for tracking or debugging purposes.
    """

    choices: List[ChatCompletionChoice]
    """
    An array of objects representing the different outcomes or results produced by
    the model based on the input provided.
    """

    created: int
    """The Unix timestamp (in seconds) when the response was created.

    This timestamp can be used to verify the timing of the response relative to
    other events or operations.
    """

    model: str
    """Identifies the specific model used to generate the response."""

    object: Literal["chat.completion"]
    """
    The type of object returned, which is always `chat.completion` for chat
    responses.
    """

    service_tier: Optional[str] = None
    """The service tier used for processing the request."""

    system_fingerprint: Optional[str] = None
    """A string representing the backend configuration that the model runs with."""

    usage: Optional[ChatCompletionUsage] = None
    """Usage information for the chat completion response.

    Please note that at this time Knowledge Graph tool usage is not included in this
    object.
    """
