"use strict";
var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InfrastructureConfiguration = exports.Tenancy = exports.HttpTokens = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const aws_imagebuilder_1 = require("aws-cdk-lib/aws-imagebuilder");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
const INFRASTRUCTURE_CONFIGURATION_SYMBOL = Symbol.for('@aws-cdk/aws-imagebuilder-alpha.InfrastructureConfiguration');
/**
 * Indicates whether a signed token header is required for instance metadata retrieval requests.
 *
 * @see https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_InstanceMetadataOptions.html#imagebuilder-Type-InstanceMetadataOptions-httpTokens
 */
var HttpTokens;
(function (HttpTokens) {
    /**
     * Allows retrieval of instance metadata with or without a signed token header in the request
     */
    HttpTokens["OPTIONAL"] = "optional";
    /**
     * Requires a signed token header in instance metadata retrieval requests
     */
    HttpTokens["REQUIRED"] = "required";
})(HttpTokens || (exports.HttpTokens = HttpTokens = {}));
/**
 * The tenancy to use for an instance.
 *
 * @see https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_Placement.html#imagebuilder-Type-Placement-tenancy
 */
var Tenancy;
(function (Tenancy) {
    /**
     * Instances will be launched with default tenancy
     */
    Tenancy["DEFAULT"] = "default";
    /**
     * Instances will be launched with dedicated tenancy
     */
    Tenancy["DEDICATED"] = "dedicated";
    /**
     * Instances will be launched on a dedicated host
     */
    Tenancy["HOST"] = "host";
})(Tenancy || (exports.Tenancy = Tenancy = {}));
/**
 * A new or imported Infrastructure Configuration
 */
class InfrastructureConfigurationBase extends cdk.Resource {
    /**
     * Grant custom actions to the given grantee for the infrastructure configuration
     *
     * @param grantee - The principal
     * @param actions - The list of actions
     */
    grant(grantee, ...actions) {
        return iam.Grant.addToPrincipal({
            grantee,
            actions,
            resourceArns: [this.infrastructureConfigurationArn],
            scope: this,
        });
    }
    /**
     * Grant read permissions to the given grantee for the infrastructure configuration
     *
     * @param grantee - The principal
     */
    grantRead(grantee) {
        return this.grant(grantee, 'imagebuilder:GetInfrastructureConfiguration');
    }
}
/**
 * Represents an EC2 Image Builder Infrastructure Configuration.
 *
 * @see https://docs.aws.amazon.com/imagebuilder/latest/userguide/manage-infra-config.html
 */
let InfrastructureConfiguration = (() => {
    let _classDecorators = [prop_injectable_1.propertyInjectable];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = InfrastructureConfigurationBase;
    var InfrastructureConfiguration = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            InfrastructureConfiguration = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
        }
        static [JSII_RTTI_SYMBOL_1] = { fqn: "@aws-cdk/aws-imagebuilder-alpha.InfrastructureConfiguration", version: "2.226.0-alpha.0" };
        /** Uniquely identifies this class. */
        static PROPERTY_INJECTION_ID = '@aws-cdk.aws-imagebuilder-alpha.InfrastructureConfiguration';
        /**
         * Import an existing infrastructure configuration given its ARN.
         */
        static fromInfrastructureConfigurationArn(scope, id, infrastructureConfigurationArn) {
            const infrastructureConfigurationName = cdk.Stack.of(scope).splitArn(infrastructureConfigurationArn, cdk.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
            class Import extends InfrastructureConfigurationBase {
                infrastructureConfigurationArn = infrastructureConfigurationArn;
                infrastructureConfigurationName = infrastructureConfigurationName;
            }
            return new Import(scope, id);
        }
        /**
         * Import an existing infrastructure configuration given its name. The provided name must be normalized by converting
         * all alphabetical characters to lowercase, and replacing all spaces and underscores with hyphens.
         */
        static fromInfrastructureConfigurationName(scope, id, infrastructureConfigurationName) {
            return InfrastructureConfiguration.fromInfrastructureConfigurationArn(scope, id, cdk.Stack.of(scope).formatArn({
                service: 'imagebuilder',
                resource: 'infrastructure-configuration',
                resourceName: infrastructureConfigurationName,
            }));
        }
        /**
         * Return whether the given object is an InfrastructureConfiguration.
         */
        static isInfrastructureConfiguration(x) {
            return x !== null && typeof x === 'object' && INFRASTRUCTURE_CONFIGURATION_SYMBOL in x;
        }
        /**
         * The ARN of the infrastructure configuration
         */
        infrastructureConfigurationArn;
        /**
         * The name of the infrastructure configuration
         */
        infrastructureConfigurationName;
        /**
         * The EC2 instance profile to use for the build
         */
        instanceProfile;
        /**
         * The role associated with the EC2 instance profile used for the build
         */
        role;
        /**
         * The bucket used to upload image build logs
         */
        logBucket;
        autoGeneratedInstanceProfileRole;
        constructor(scope, id, props = {}) {
            super(scope, id, {
                physicalName: props.infrastructureConfigurationName ??
                    cdk.Lazy.string({
                        produce: () => cdk.Names.uniqueResourceName(this, {
                            maxLength: 128,
                            separator: '-',
                            allowedSpecialCharacters: '-',
                        }).toLowerCase(), // Enforce lowercase for the auto-generated fallback
                    }),
            });
            try {
                jsiiDeprecationWarnings._aws_cdk_aws_imagebuilder_alpha_InfrastructureConfigurationProps(props);
            }
            catch (error) {
                if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                    Error.captureStackTrace(error, InfrastructureConfiguration);
                }
                throw error;
            }
            // Enhanced CDK Analytics Telemetry
            (0, metadata_resource_1.addConstructMetadata)(this, props);
            Object.defineProperty(this, INFRASTRUCTURE_CONFIGURATION_SYMBOL, { value: true });
            this.validateInfrastructureConfigurationName();
            if (props.subnetSelection && !props.vpc) {
                throw new cdk.ValidationError('A vpc must be provided when using subnetSelection', this);
            }
            const selectedSubnets = props.vpc?.selectSubnets(props.subnetSelection);
            if (props.vpc && selectedSubnets && selectedSubnets.subnetIds.length === 0) {
                throw new cdk.ValidationError('No subnets matched the given subnetSelection for the provided VPC.', this);
            }
            if (props.instanceProfile && props.role) {
                throw new cdk.ValidationError('Both an instance profile and a role cannot be provided', this);
            }
            if (!cdk.Token.isUnresolved(props.ec2InstanceTenancy)) {
                if (props.ec2InstanceTenancy === Tenancy.HOST) {
                    if (props.ec2InstanceHostId === undefined && props.ec2InstanceHostResourceGroupArn === undefined) {
                        throw new cdk.ValidationError('ec2InstanceHostId or ec2InstanceHostResourceGroupArn must be specified when ec2InstanceTenancy is set to host', this);
                    }
                }
                else {
                    if (props.ec2InstanceHostId !== undefined) {
                        throw new cdk.ValidationError('ec2InstanceHostId cannot be specified unless ec2InstanceTenancy is set to host', this);
                    }
                    if (props.ec2InstanceHostResourceGroupArn !== undefined) {
                        throw new cdk.ValidationError('ec2InstanceHostResourceGroupArn cannot be specified unless ec2InstanceTenancy is set to host', this);
                    }
                }
            }
            if (props.ec2InstanceHostId !== undefined && props.ec2InstanceHostResourceGroupArn !== undefined) {
                throw new cdk.ValidationError('ec2InstanceHostId and ec2InstanceHostResourceGroupArn cannot be used together', this);
            }
            if (props.httpPutResponseHopLimit !== undefined && props.httpPutResponseHopLimit < 1) {
                throw new cdk.ValidationError('httpPutResponseHopLimit must be at least 1', this);
            }
            if (props.httpPutResponseHopLimit !== undefined && props.httpPutResponseHopLimit > 64) {
                throw new cdk.ValidationError('httpPutResponseHopLimit must be at most 64', this);
            }
            if (!props.instanceProfile && !props.role) {
                this.autoGeneratedInstanceProfileRole = new iam.Role(this, 'InstanceProfileRole', {
                    assumedBy: new iam.ServicePrincipal('ec2.amazonaws.com'),
                    managedPolicies: [
                        iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'),
                        iam.ManagedPolicy.fromAwsManagedPolicyName('EC2InstanceProfileForImageBuilder'),
                    ],
                });
                this.role = this.autoGeneratedInstanceProfileRole;
            }
            this.instanceProfile =
                props.instanceProfile ||
                    new iam.InstanceProfile(this, 'InstanceProfile', { role: props.role ?? this.autoGeneratedInstanceProfileRole });
            this.role = this.instanceProfile.role;
            this.logBucket = props.logging?.s3Bucket;
            if (this.logBucket && this.role) {
                this.logBucket.grantPut(this.role, props.logging?.s3KeyPrefix ? `${props.logging.s3KeyPrefix}/*` : '*');
            }
            const hasPlacementOptions = props.ec2InstanceAvailabilityZone !== undefined ||
                props.ec2InstanceHostId !== undefined ||
                props.ec2InstanceHostResourceGroupArn !== undefined ||
                props.ec2InstanceTenancy !== undefined;
            const placement = hasPlacementOptions
                ? {
                    ...(props.ec2InstanceAvailabilityZone !== undefined && {
                        availabilityZone: props.ec2InstanceAvailabilityZone,
                    }),
                    ...(props.ec2InstanceHostId !== undefined && { hostId: props.ec2InstanceHostId }),
                    ...(props.ec2InstanceHostResourceGroupArn !== undefined && {
                        hostResourceGroupArn: props.ec2InstanceHostResourceGroupArn,
                    }),
                    ...(props.ec2InstanceTenancy !== undefined && { tenancy: props.ec2InstanceTenancy }),
                }
                : undefined;
            const infrastructureConfiguration = new aws_imagebuilder_1.CfnInfrastructureConfiguration(this, 'Resource', {
                name: this.physicalName,
                instanceProfileName: this.instanceProfile.instanceProfileName,
                description: props.description,
                instanceMetadataOptions: {
                    httpTokens: props.httpTokens ?? HttpTokens.REQUIRED,
                    httpPutResponseHopLimit: props.httpPutResponseHopLimit ?? 2,
                },
                instanceTypes: props.instanceTypes?.length
                    ? props.instanceTypes?.map((instanceType) => instanceType.toString())
                    : undefined,
                keyPair: props.keyPair?.keyPairName,
                ...(props.logging && {
                    logging: {
                        s3Logs: {
                            s3BucketName: props.logging?.s3Bucket.bucketName,
                            s3KeyPrefix: props.logging?.s3KeyPrefix,
                        },
                    },
                }),
                ...(placement && { placement }),
                resourceTags: props.resourceTags,
                securityGroupIds: props.securityGroups?.length
                    ? props.securityGroups?.map((securityGroup) => securityGroup.securityGroupId)
                    : undefined,
                subnetId: props.vpc?.selectSubnets(props.subnetSelection).subnetIds[0],
                snsTopicArn: props.notificationTopic?.topicArn,
                tags: props.tags,
                terminateInstanceOnFailure: props.terminateInstanceOnFailure,
            });
            this.infrastructureConfigurationName = this.getResourceNameAttribute(infrastructureConfiguration.attrName);
            this.infrastructureConfigurationArn = this.getResourceArnAttribute(infrastructureConfiguration.attrArn, {
                service: 'imagebuilder',
                resource: 'infrastructure-configuration',
                resourceName: this.physicalName,
            });
        }
        validateInfrastructureConfigurationName() {
            if (cdk.Token.isUnresolved(this.physicalName)) {
                return; // Cannot validate unresolved tokens, given their actual value is rendered at deployment time
            }
            if (this.physicalName.length > 128) {
                throw new cdk.ValidationError('The infrastructureConfigurationName cannot be longer than 128 characters', this);
            }
            if (this.physicalName.includes(' ')) {
                throw new cdk.ValidationError('The infrastructureConfigurationName cannot contain spaces', this);
            }
            if (this.physicalName.includes('_')) {
                throw new cdk.ValidationError('The infrastructureConfigurationName cannot contain underscores', this);
            }
            if (this.physicalName !== this.physicalName.toLowerCase()) {
                throw new cdk.ValidationError('The infrastructureConfigurationName must be lowercase', this);
            }
        }
        /**
         * @internal
         */
        _bind(options) {
            if (options.isContainerBuild) {
                this.autoGeneratedInstanceProfileRole?.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('EC2InstanceProfileForImageBuilderECRContainerBuilds'));
            }
        }
        static {
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return InfrastructureConfiguration = _classThis;
})();
exports.InfrastructureConfiguration = InfrastructureConfiguration;
//# sourceMappingURL=data:application/json;base64,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