"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnNrqlConditionStatic = exports.ConditionInputTermsThresholdOccurrences = exports.ConditionInputTermsPriority = exports.ConditionInputTermsOperator = exports.ConditionInputSignalFillOption = exports.ConditionInputSignalAggregationMethod = exports.toJson_ConditionInputTerms = exports.toJson_ConditionInputSignal = exports.toJson_ConditionInputNrql = exports.toJson_ConditionInputExpiration = exports.toJson_ConditionInput = exports.toJson_CfnNrqlConditionStaticProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnNrqlConditionStaticProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnNrqlConditionStaticProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AccountId': obj.accountId,
        'Condition': toJson_ConditionInput(obj.condition),
        'PolicyId': obj.policyId,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnNrqlConditionStaticProps = toJson_CfnNrqlConditionStaticProps;
/**
 * Converts an object of type 'ConditionInput' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ConditionInput(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Description': obj.description,
        'Enabled': obj.enabled,
        'Expiration': toJson_ConditionInputExpiration(obj.expiration),
        'Name': obj.name,
        'Nrql': toJson_ConditionInputNrql(obj.nrql),
        'RunbookUrl': obj.runbookUrl,
        'Signal': toJson_ConditionInputSignal(obj.signal),
        'Terms': toJson_ConditionInputTerms(obj.terms),
        'ViolationTimeLimitSeconds': obj.violationTimeLimitSeconds,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ConditionInput = toJson_ConditionInput;
/**
 * Converts an object of type 'ConditionInputExpiration' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ConditionInputExpiration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'CloseViolationsOnExpiration': obj.closeViolationsOnExpiration,
        'ExpirationDuration': obj.expirationDuration,
        'OpenViolationOnExpiration': obj.openViolationOnExpiration,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ConditionInputExpiration = toJson_ConditionInputExpiration;
/**
 * Converts an object of type 'ConditionInputNrql' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ConditionInputNrql(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Query': obj.query,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ConditionInputNrql = toJson_ConditionInputNrql;
/**
 * Converts an object of type 'ConditionInputSignal' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ConditionInputSignal(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AggregationDelay': obj.aggregationDelay,
        'AggregationMethod': obj.aggregationMethod,
        'AggregationTimer': obj.aggregationTimer,
        'AggregationWindow': obj.aggregationWindow,
        'FillOption': obj.fillOption,
        'FillValue': obj.fillValue,
        'SlideBy': obj.slideBy,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ConditionInputSignal = toJson_ConditionInputSignal;
/**
 * Converts an object of type 'ConditionInputTerms' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ConditionInputTerms(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Operator': obj.operator,
        'Priority': obj.priority,
        'Threshold': obj.threshold,
        'ThresholdDuration': obj.thresholdDuration,
        'ThresholdOccurrences': obj.thresholdOccurrences,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ConditionInputTerms = toJson_ConditionInputTerms;
/* eslint-enable max-len, quote-props */
/**
 * The method that determines when we consider an aggregation window to be complete so that we can evaluate the signal for violations
 *
 * @schema ConditionInputSignalAggregationMethod
 */
var ConditionInputSignalAggregationMethod;
(function (ConditionInputSignalAggregationMethod) {
    /** CADENCE */
    ConditionInputSignalAggregationMethod["CADENCE"] = "CADENCE";
    /** EVENT_FLOW */
    ConditionInputSignalAggregationMethod["EVENT_FLOW"] = "EVENT_FLOW";
    /** EVENT_TIMER */
    ConditionInputSignalAggregationMethod["EVENT_TIMER"] = "EVENT_TIMER";
})(ConditionInputSignalAggregationMethod = exports.ConditionInputSignalAggregationMethod || (exports.ConditionInputSignalAggregationMethod = {}));
/**
 * Option that determines the type of value that should be used to fill gaps (empty windows)
 *
 * @schema ConditionInputSignalFillOption
 */
var ConditionInputSignalFillOption;
(function (ConditionInputSignalFillOption) {
    /** LAST_VALUE */
    ConditionInputSignalFillOption["LAST_VALUE"] = "LAST_VALUE";
    /** NONE */
    ConditionInputSignalFillOption["NONE"] = "NONE";
    /** STATIC */
    ConditionInputSignalFillOption["STATIC"] = "STATIC";
})(ConditionInputSignalFillOption = exports.ConditionInputSignalFillOption || (exports.ConditionInputSignalFillOption = {}));
/**
 * Operator used to compare against the threshold.
 *
 * @schema ConditionInputTermsOperator
 */
var ConditionInputTermsOperator;
(function (ConditionInputTermsOperator) {
    /** ABOVE */
    ConditionInputTermsOperator["ABOVE"] = "ABOVE";
    /** ABOVE_OR_EQUALS */
    ConditionInputTermsOperator["ABOVE_OR_EQUALS"] = "ABOVE_OR_EQUALS";
    /** BELOW */
    ConditionInputTermsOperator["BELOW"] = "BELOW";
    /** BELOW_OR_EQUALS */
    ConditionInputTermsOperator["BELOW_OR_EQUALS"] = "BELOW_OR_EQUALS";
    /** EQUALS */
    ConditionInputTermsOperator["EQUALS"] = "EQUALS";
    /** NOT_EQUALS */
    ConditionInputTermsOperator["NOT_EQUALS"] = "NOT_EQUALS";
})(ConditionInputTermsOperator = exports.ConditionInputTermsOperator || (exports.ConditionInputTermsOperator = {}));
/**
 * Priority determines whether notifications will be sent for violations or not.
 *
 * @schema ConditionInputTermsPriority
 */
var ConditionInputTermsPriority;
(function (ConditionInputTermsPriority) {
    /** CRITICAL */
    ConditionInputTermsPriority["CRITICAL"] = "CRITICAL";
    /** WARNING */
    ConditionInputTermsPriority["WARNING"] = "WARNING";
})(ConditionInputTermsPriority = exports.ConditionInputTermsPriority || (exports.ConditionInputTermsPriority = {}));
/**
 * How many data points must be in violation for the specified thresholdDuration
 *
 * @schema ConditionInputTermsThresholdOccurrences
 */
var ConditionInputTermsThresholdOccurrences;
(function (ConditionInputTermsThresholdOccurrences) {
    /** ALL */
    ConditionInputTermsThresholdOccurrences["ALL"] = "ALL";
    /** AT_LEAST_ONCE */
    ConditionInputTermsThresholdOccurrences["AT_LEAST_ONCE"] = "AT_LEAST_ONCE";
})(ConditionInputTermsThresholdOccurrences = exports.ConditionInputTermsThresholdOccurrences || (exports.ConditionInputTermsThresholdOccurrences = {}));
/**
 * A CloudFormation `NewRelic::Alert::NrqlConditionStatic`
 *
 * @cloudformationResource NewRelic::Alert::NrqlConditionStatic
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-newrelic-resource-providers.git
 */
class CfnNrqlConditionStatic extends cdk.CfnResource {
    /**
     * Create a new `NewRelic::Alert::NrqlConditionStatic`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnNrqlConditionStatic.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnNrqlConditionStaticProps(props) });
        this.props = props;
        this.attrConditionId = cdk.Token.asNumber(this.getAtt('ConditionId'));
    }
}
exports.CfnNrqlConditionStatic = CfnNrqlConditionStatic;
_a = JSII_RTTI_SYMBOL_1;
CfnNrqlConditionStatic[_a] = { fqn: "@cdk-cloudformation/newrelic-alert-nrqlconditionstatic.CfnNrqlConditionStatic", version: "1.1.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnNrqlConditionStatic.CFN_RESOURCE_TYPE_NAME = "NewRelic::Alert::NrqlConditionStatic";
//# sourceMappingURL=data:application/json;base64,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