import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage New Relic NRQL Static Alerts Condition
 *
 * @schema CfnNrqlConditionStaticProps
 */
export interface CfnNrqlConditionStaticProps {
    /**
     * Account ID the alerts condition should belong to.
     *
     * @schema CfnNrqlConditionStaticProps#AccountId
     */
    readonly accountId: number;
    /**
     * @schema CfnNrqlConditionStaticProps#Condition
     */
    readonly condition: ConditionInput;
    /**
     * Policy ID for the condition.
     *
     * @schema CfnNrqlConditionStaticProps#PolicyId
     */
    readonly policyId: number;
}
/**
 * Converts an object of type 'CfnNrqlConditionStaticProps' to JSON representation.
 */
export declare function toJson_CfnNrqlConditionStaticProps(obj: CfnNrqlConditionStaticProps | undefined): Record<string, any> | undefined;
/**
 * Input settings for the static NRQL condition.
 *
 * @schema ConditionInput
 */
export interface ConditionInput {
    /**
     * The custom violation description.
     *
     * @schema ConditionInput#Description
     */
    readonly description?: string;
    /**
     * Whether the NRQL condition is enabled.
     *
     * @schema ConditionInput#Enabled
     */
    readonly enabled: boolean;
    /**
     * Settings for how violations are opened or closed when a signal expires.
     *
     * @schema ConditionInput#Expiration
     */
    readonly expiration?: ConditionInputExpiration;
    /**
     * Name of the NRQL condition.
     *
     * @schema ConditionInput#Name
     */
    readonly name: string;
    /**
     * The NRQL query that defines the signal for the condition.
     *
     * @schema ConditionInput#Nrql
     */
    readonly nrql: ConditionInputNrql;
    /**
     * Runbook URL.
     *
     * @schema ConditionInput#RunbookUrl
     */
    readonly runbookUrl?: string;
    /**
     * Configuration that defines the signal that the NRQL condition will use to evaluate.
     *
     * @schema ConditionInput#Signal
     */
    readonly signal?: ConditionInputSignal;
    /**
     * List of critical and warning terms for the condition
     *
     * @schema ConditionInput#Terms
     */
    readonly terms: ConditionInputTerms;
    /**
     * Duration after which a violation automatically closes in seconds
     *
     * @schema ConditionInput#ViolationTimeLimitSeconds
     */
    readonly violationTimeLimitSeconds?: number;
}
/**
 * Converts an object of type 'ConditionInput' to JSON representation.
 */
export declare function toJson_ConditionInput(obj: ConditionInput | undefined): Record<string, any> | undefined;
/**
 * Settings for how violations are opened or closed when a signal expires.
 *
 * @schema ConditionInputExpiration
 */
export interface ConditionInputExpiration {
    /**
     * Whether to close all open violations when the signal expires. Defaults to true.
     *
     * @default true.
     * @schema ConditionInputExpiration#CloseViolationsOnExpiration
     */
    readonly closeViolationsOnExpiration?: boolean;
    /**
     * The amount of time (in seconds) to wait before considering if the signal has been lost. Max value of 172800 (48 hours).
     *
     * @schema ConditionInputExpiration#ExpirationDuration
     */
    readonly expirationDuration?: number;
    /**
     * Whether to create a new "lost signal" violation to capture that the signal expired. Defaults to false.
     *
     * @default false.
     * @schema ConditionInputExpiration#OpenViolationOnExpiration
     */
    readonly openViolationOnExpiration?: boolean;
}
/**
 * Converts an object of type 'ConditionInputExpiration' to JSON representation.
 */
export declare function toJson_ConditionInputExpiration(obj: ConditionInputExpiration | undefined): Record<string, any> | undefined;
/**
 * The NRQL query that defines the signal for the condition.
 *
 * @schema ConditionInputNrql
 */
export interface ConditionInputNrql {
    /**
     * NRQL syntax that defines the query.
     *
     * @schema ConditionInputNrql#Query
     */
    readonly query: string;
}
/**
 * Converts an object of type 'ConditionInputNrql' to JSON representation.
 */
export declare function toJson_ConditionInputNrql(obj: ConditionInputNrql | undefined): Record<string, any> | undefined;
/**
 * Configuration that defines the signal that the NRQL condition will use to evaluate.
 *
 * @schema ConditionInputSignal
 */
export interface ConditionInputSignal {
    /**
     * How long we wait for data that belongs in each aggregation window
     *
     * @schema ConditionInputSignal#AggregationDelay
     */
    readonly aggregationDelay?: number;
    /**
     * The method that determines when we consider an aggregation window to be complete so that we can evaluate the signal for violations
     *
     * @schema ConditionInputSignal#AggregationMethod
     */
    readonly aggregationMethod?: ConditionInputSignalAggregationMethod;
    /**
     * How long we wait after each data point arrives to make sure we've processed the whole batch
     *
     * @schema ConditionInputSignal#AggregationTimer
     */
    readonly aggregationTimer?: number;
    /**
     * Aggregation window controls the duration of the time window used to evaluate the NRQL query, in seconds
     *
     * @schema ConditionInputSignal#AggregationWindow
     */
    readonly aggregationWindow?: number;
    /**
     * Option that determines the type of value that should be used to fill gaps (empty windows)
     *
     * @schema ConditionInputSignal#FillOption
     */
    readonly fillOption?: ConditionInputSignalFillOption;
    /**
     * If using the static fill option, this the value used for filling
     *
     * @schema ConditionInputSignal#FillValue
     */
    readonly fillValue?: number;
    /**
     * This setting gathers data in overlapping time windows to smooth the chart line, making it easier to spot trends
     *
     * @schema ConditionInputSignal#SlideBy
     */
    readonly slideBy?: number;
}
/**
 * Converts an object of type 'ConditionInputSignal' to JSON representation.
 */
export declare function toJson_ConditionInputSignal(obj: ConditionInputSignal | undefined): Record<string, any> | undefined;
/**
 * List of critical and warning terms for the condition
 *
 * @schema ConditionInputTerms
 */
export interface ConditionInputTerms {
    /**
     * Operator used to compare against the threshold.
     *
     * @schema ConditionInputTerms#Operator
     */
    readonly operator: ConditionInputTermsOperator;
    /**
     * Priority determines whether notifications will be sent for violations or not.
     *
     * @schema ConditionInputTerms#Priority
     */
    readonly priority: ConditionInputTermsPriority;
    /**
     * Value that triggers a violation.
     *
     * @schema ConditionInputTerms#Threshold
     */
    readonly threshold: number;
    /**
     * The duration, in seconds, that the threshold must violate for in order to create a violation
     *
     * @schema ConditionInputTerms#ThresholdDuration
     */
    readonly thresholdDuration: number;
    /**
     * How many data points must be in violation for the specified thresholdDuration
     *
     * @schema ConditionInputTerms#ThresholdOccurrences
     */
    readonly thresholdOccurrences: ConditionInputTermsThresholdOccurrences;
}
/**
 * Converts an object of type 'ConditionInputTerms' to JSON representation.
 */
export declare function toJson_ConditionInputTerms(obj: ConditionInputTerms | undefined): Record<string, any> | undefined;
/**
 * The method that determines when we consider an aggregation window to be complete so that we can evaluate the signal for violations
 *
 * @schema ConditionInputSignalAggregationMethod
 */
export declare enum ConditionInputSignalAggregationMethod {
    /** CADENCE */
    CADENCE = "CADENCE",
    /** EVENT_FLOW */
    EVENT_FLOW = "EVENT_FLOW",
    /** EVENT_TIMER */
    EVENT_TIMER = "EVENT_TIMER"
}
/**
 * Option that determines the type of value that should be used to fill gaps (empty windows)
 *
 * @schema ConditionInputSignalFillOption
 */
export declare enum ConditionInputSignalFillOption {
    /** LAST_VALUE */
    LAST_VALUE = "LAST_VALUE",
    /** NONE */
    NONE = "NONE",
    /** STATIC */
    STATIC = "STATIC"
}
/**
 * Operator used to compare against the threshold.
 *
 * @schema ConditionInputTermsOperator
 */
export declare enum ConditionInputTermsOperator {
    /** ABOVE */
    ABOVE = "ABOVE",
    /** ABOVE_OR_EQUALS */
    ABOVE_OR_EQUALS = "ABOVE_OR_EQUALS",
    /** BELOW */
    BELOW = "BELOW",
    /** BELOW_OR_EQUALS */
    BELOW_OR_EQUALS = "BELOW_OR_EQUALS",
    /** EQUALS */
    EQUALS = "EQUALS",
    /** NOT_EQUALS */
    NOT_EQUALS = "NOT_EQUALS"
}
/**
 * Priority determines whether notifications will be sent for violations or not.
 *
 * @schema ConditionInputTermsPriority
 */
export declare enum ConditionInputTermsPriority {
    /** CRITICAL */
    CRITICAL = "CRITICAL",
    /** WARNING */
    WARNING = "WARNING"
}
/**
 * How many data points must be in violation for the specified thresholdDuration
 *
 * @schema ConditionInputTermsThresholdOccurrences
 */
export declare enum ConditionInputTermsThresholdOccurrences {
    /** ALL */
    ALL = "ALL",
    /** AT_LEAST_ONCE */
    AT_LEAST_ONCE = "AT_LEAST_ONCE"
}
/**
 * A CloudFormation `NewRelic::Alert::NrqlConditionStatic`
 *
 * @cloudformationResource NewRelic::Alert::NrqlConditionStatic
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-newrelic-resource-providers.git
 */
export declare class CfnNrqlConditionStatic extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "NewRelic::Alert::NrqlConditionStatic";
    /**
     * Resource props.
     */
    readonly props: CfnNrqlConditionStaticProps;
    /**
     * Attribute `NewRelic::Alert::NrqlConditionStatic.ConditionId`
     * @link https://github.com/aws-ia/cloudformation-newrelic-resource-providers.git
     */
    readonly attrConditionId: number;
    /**
     * Create a new `NewRelic::Alert::NrqlConditionStatic`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnNrqlConditionStaticProps);
}
