"use strict";
const assert_1 = require("@aws-cdk/assert");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
// tslint:disable-next-line:max-line-length
const lib_1 = require("../lib");
/**
 * A load balancer that can host a VPC Endpoint Service
 */
class DummyEndpointLoadBalacer {
    constructor(arn) {
        this.loadBalancerArn = arn;
    }
}
module.exports = {
    'test vpc endpoint service': {
        'create endpoint service with no principals'(test) {
            // GIVEN
            const stack = new core_1.Stack();
            new lib_1.Vpc(stack, 'MyVPC');
            // WHEN
            const lb = new DummyEndpointLoadBalacer('arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a');
            new lib_1.VpcEndpointService(stack, 'EndpointService', {
                vpcEndpointServiceLoadBalancers: [lb],
                acceptanceRequired: false,
                whitelistedPrincipals: [new aws_iam_1.ArnPrincipal('arn:aws:iam::123456789012:root')],
            });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::VPCEndpointService', {
                NetworkLoadBalancerArns: ['arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a'],
                AcceptanceRequired: false,
            }));
            assert_1.expect(stack).notTo(assert_1.haveResource('AWS::EC2::VPCEndpointServicePermissions', {
                ServiceId: {
                    Ref: 'EndpointServiceED36BE1F',
                },
                AllowedPrincipals: [],
            }));
            test.done();
        },
        'create endpoint service with a principal'(test) {
            // GIVEN
            const stack = new core_1.Stack();
            // WHEN
            const lb = new DummyEndpointLoadBalacer('arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a');
            new lib_1.VpcEndpointService(stack, 'EndpointService', {
                vpcEndpointServiceLoadBalancers: [lb],
                acceptanceRequired: false,
                whitelistedPrincipals: [new aws_iam_1.ArnPrincipal('arn:aws:iam::123456789012:root')],
            });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::VPCEndpointService', {
                NetworkLoadBalancerArns: ['arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a'],
                AcceptanceRequired: false,
            }));
            assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::VPCEndpointServicePermissions', {
                ServiceId: {
                    Ref: 'EndpointServiceED36BE1F',
                },
                AllowedPrincipals: ['arn:aws:iam::123456789012:root'],
            }));
            test.done();
        },
        'with acceptance requried'(test) {
            // GIVEN
            const stack = new core_1.Stack();
            // WHEN
            const lb = new DummyEndpointLoadBalacer('arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a');
            new lib_1.VpcEndpointService(stack, 'EndpointService', {
                vpcEndpointServiceLoadBalancers: [lb],
                acceptanceRequired: true,
                whitelistedPrincipals: [new aws_iam_1.ArnPrincipal('arn:aws:iam::123456789012:root')],
            });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::VPCEndpointService', {
                NetworkLoadBalancerArns: ['arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a'],
                AcceptanceRequired: true,
            }));
            assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::VPCEndpointServicePermissions', {
                ServiceId: {
                    Ref: 'EndpointServiceED36BE1F',
                },
                AllowedPrincipals: ['arn:aws:iam::123456789012:root'],
            }));
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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