"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const ec2 = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-ec2-vpc');
const vpc = new ec2.Vpc(stack, 'MyVpc');
// Test NetworkAcl and rules
const nacl1 = new ec2.NetworkAcl(stack, 'myNACL1', {
    vpc,
    subnetSelection: { subnetType: ec2.SubnetType.PRIVATE },
});
nacl1.addEntry('AllowDNSEgress', {
    ruleNumber: 100,
    traffic: ec2.AclTraffic.udpPort(53),
    cidr: ec2.AclCidr.ipv4('172.16.0.0/24'),
    direction: ec2.TrafficDirection.EGRESS,
});
nacl1.addEntry('AllowDNSIngress', {
    ruleNumber: 100,
    traffic: ec2.AclTraffic.udpPort(53),
    direction: ec2.TrafficDirection.INGRESS,
    cidr: ec2.AclCidr.anyIpv4(),
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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