# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from goodlens_product.models.base_model_ import Model
from goodlens_product.models.food_origin_material import FoodOriginMaterial  # noqa: F401,E501
from goodlens_product.models.nutrient import Nutrient  # noqa: F401,E501
from goodlens_product import util


class ProductFood(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, food_type: str=None, manufacture_date: str=None, expiration_date: str=None, count_per_pack: str=None, origin_materials: List[FoodOriginMaterial]=None, nutrients: List[Nutrient]=None, genetic_recombination: str=None, is_infant_weight_control_food_ad_preview: bool=None, import_declaration_description: str=None, as_owner: str=None, phone_number: str=None, functional_information: str=None, intake: str=None, intake_notice: str=None, possible_side_effects: str=None, is_non_medication_indication: str=None, is_display_ad_preview: bool=None, item_manufacture_mgmt_number: str=None, allergens: List[str]=None, factory_allergens_notice: str=None, function: str=None, step_by_step: str=None, vitamin_type: str=None, min_age: int=None, pack_type: str=None, material: str=None, product_type: str=None, cooking_time: str=None, cooking_capacity: str=None, is_green_certification: bool=None, cetification: str=None, is_no_additives: str=None, is_recycle: str=None, additional_food_type: str=None, item_report_number: str=None, how_to_store: str=None, parent_product_id: str=None):  # noqa: E501
        """ProductFood - a model defined in Swagger

        :param food_type: The food_type of this ProductFood.  # noqa: E501
        :type food_type: str
        :param manufacture_date: The manufacture_date of this ProductFood.  # noqa: E501
        :type manufacture_date: str
        :param expiration_date: The expiration_date of this ProductFood.  # noqa: E501
        :type expiration_date: str
        :param count_per_pack: The count_per_pack of this ProductFood.  # noqa: E501
        :type count_per_pack: str
        :param origin_materials: The origin_materials of this ProductFood.  # noqa: E501
        :type origin_materials: List[FoodOriginMaterial]
        :param nutrients: The nutrients of this ProductFood.  # noqa: E501
        :type nutrients: List[Nutrient]
        :param genetic_recombination: The genetic_recombination of this ProductFood.  # noqa: E501
        :type genetic_recombination: str
        :param is_infant_weight_control_food_ad_preview: The is_infant_weight_control_food_ad_preview of this ProductFood.  # noqa: E501
        :type is_infant_weight_control_food_ad_preview: bool
        :param import_declaration_description: The import_declaration_description of this ProductFood.  # noqa: E501
        :type import_declaration_description: str
        :param as_owner: The as_owner of this ProductFood.  # noqa: E501
        :type as_owner: str
        :param phone_number: The phone_number of this ProductFood.  # noqa: E501
        :type phone_number: str
        :param functional_information: The functional_information of this ProductFood.  # noqa: E501
        :type functional_information: str
        :param intake: The intake of this ProductFood.  # noqa: E501
        :type intake: str
        :param intake_notice: The intake_notice of this ProductFood.  # noqa: E501
        :type intake_notice: str
        :param possible_side_effects: The possible_side_effects of this ProductFood.  # noqa: E501
        :type possible_side_effects: str
        :param is_non_medication_indication: The is_non_medication_indication of this ProductFood.  # noqa: E501
        :type is_non_medication_indication: str
        :param is_display_ad_preview: The is_display_ad_preview of this ProductFood.  # noqa: E501
        :type is_display_ad_preview: bool
        :param item_manufacture_mgmt_number: The item_manufacture_mgmt_number of this ProductFood.  # noqa: E501
        :type item_manufacture_mgmt_number: str
        :param allergens: The allergens of this ProductFood.  # noqa: E501
        :type allergens: List[str]
        :param factory_allergens_notice: The factory_allergens_notice of this ProductFood.  # noqa: E501
        :type factory_allergens_notice: str
        :param function: The function of this ProductFood.  # noqa: E501
        :type function: str
        :param step_by_step: The step_by_step of this ProductFood.  # noqa: E501
        :type step_by_step: str
        :param vitamin_type: The vitamin_type of this ProductFood.  # noqa: E501
        :type vitamin_type: str
        :param min_age: The min_age of this ProductFood.  # noqa: E501
        :type min_age: int
        :param pack_type: The pack_type of this ProductFood.  # noqa: E501
        :type pack_type: str
        :param material: The material of this ProductFood.  # noqa: E501
        :type material: str
        :param product_type: The product_type of this ProductFood.  # noqa: E501
        :type product_type: str
        :param cooking_time: The cooking_time of this ProductFood.  # noqa: E501
        :type cooking_time: str
        :param cooking_capacity: The cooking_capacity of this ProductFood.  # noqa: E501
        :type cooking_capacity: str
        :param is_green_certification: The is_green_certification of this ProductFood.  # noqa: E501
        :type is_green_certification: bool
        :param cetification: The cetification of this ProductFood.  # noqa: E501
        :type cetification: str
        :param is_no_additives: The is_no_additives of this ProductFood.  # noqa: E501
        :type is_no_additives: str
        :param is_recycle: The is_recycle of this ProductFood.  # noqa: E501
        :type is_recycle: str
        :param additional_food_type: The additional_food_type of this ProductFood.  # noqa: E501
        :type additional_food_type: str
        :param item_report_number: The item_report_number of this ProductFood.  # noqa: E501
        :type item_report_number: str
        :param how_to_store: The how_to_store of this ProductFood.  # noqa: E501
        :type how_to_store: str
        :param parent_product_id: The parent_product_id of this ProductFood.  # noqa: E501
        :type parent_product_id: str
        """
        self.swagger_types = {
            'food_type': str,
            'manufacture_date': str,
            'expiration_date': str,
            'count_per_pack': str,
            'origin_materials': List[FoodOriginMaterial],
            'nutrients': List[Nutrient],
            'genetic_recombination': str,
            'is_infant_weight_control_food_ad_preview': bool,
            'import_declaration_description': str,
            'as_owner': str,
            'phone_number': str,
            'functional_information': str,
            'intake': str,
            'intake_notice': str,
            'possible_side_effects': str,
            'is_non_medication_indication': str,
            'is_display_ad_preview': bool,
            'item_manufacture_mgmt_number': str,
            'allergens': List[str],
            'factory_allergens_notice': str,
            'function': str,
            'step_by_step': str,
            'vitamin_type': str,
            'min_age': int,
            'pack_type': str,
            'material': str,
            'product_type': str,
            'cooking_time': str,
            'cooking_capacity': str,
            'is_green_certification': bool,
            'cetification': str,
            'is_no_additives': str,
            'is_recycle': str,
            'additional_food_type': str,
            'item_report_number': str,
            'how_to_store': str,
            'parent_product_id': str
        }

        self.attribute_map = {
            'food_type': 'food_type',
            'manufacture_date': 'manufacture_date',
            'expiration_date': 'expiration_date',
            'count_per_pack': 'count_per_pack',
            'origin_materials': 'origin_materials',
            'nutrients': 'nutrients',
            'genetic_recombination': 'genetic_recombination',
            'is_infant_weight_control_food_ad_preview': 'is_infant_weight_control_food_ad_preview',
            'import_declaration_description': 'import_declaration_description',
            'as_owner': 'as_owner',
            'phone_number': 'phone_number',
            'functional_information': 'functional_information',
            'intake': 'intake',
            'intake_notice': 'intake_notice',
            'possible_side_effects': 'possible_side_effects',
            'is_non_medication_indication': 'is_non_medication_indication',
            'is_display_ad_preview': 'is_display_ad_preview',
            'item_manufacture_mgmt_number': 'item_manufacture_mgmt_number',
            'allergens': 'allergens',
            'factory_allergens_notice': 'factory_allergens_notice',
            'function': 'function',
            'step_by_step': 'step_by_step',
            'vitamin_type': 'vitamin_type',
            'min_age': 'min_age',
            'pack_type': 'pack_type',
            'material': 'material',
            'product_type': 'product_type',
            'cooking_time': 'cooking_time',
            'cooking_capacity': 'cooking_capacity',
            'is_green_certification': 'is_green_certification',
            'cetification': 'cetification',
            'is_no_additives': 'is_no_additives',
            'is_recycle': 'is_recycle',
            'additional_food_type': 'additional_food_type',
            'item_report_number': 'item_report_number',
            'how_to_store': 'how_to_store',
            'parent_product_id': 'parent_product_id'
        }

        self._food_type = food_type
        self._manufacture_date = manufacture_date
        self._expiration_date = expiration_date
        self._count_per_pack = count_per_pack
        self._origin_materials = origin_materials
        self._nutrients = nutrients
        self._genetic_recombination = genetic_recombination
        self._is_infant_weight_control_food_ad_preview = is_infant_weight_control_food_ad_preview
        self._import_declaration_description = import_declaration_description
        self._as_owner = as_owner
        self._phone_number = phone_number
        self._functional_information = functional_information
        self._intake = intake
        self._intake_notice = intake_notice
        self._possible_side_effects = possible_side_effects
        self._is_non_medication_indication = is_non_medication_indication
        self._is_display_ad_preview = is_display_ad_preview
        self._item_manufacture_mgmt_number = item_manufacture_mgmt_number
        self._allergens = allergens
        self._factory_allergens_notice = factory_allergens_notice
        self._function = function
        self._step_by_step = step_by_step
        self._vitamin_type = vitamin_type
        self._min_age = min_age
        self._pack_type = pack_type
        self._material = material
        self._product_type = product_type
        self._cooking_time = cooking_time
        self._cooking_capacity = cooking_capacity
        self._is_green_certification = is_green_certification
        self._cetification = cetification
        self._is_no_additives = is_no_additives
        self._is_recycle = is_recycle
        self._additional_food_type = additional_food_type
        self._item_report_number = item_report_number
        self._how_to_store = how_to_store
        self._parent_product_id = parent_product_id

    @classmethod
    def from_dict(cls, dikt) -> 'ProductFood':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ProductFood of this ProductFood.  # noqa: E501
        :rtype: ProductFood
        """
        return util.deserialize_model(dikt, cls)

    @property
    def food_type(self) -> str:
        """Gets the food_type of this ProductFood.

        식품의 유형  # noqa: E501

        :return: The food_type of this ProductFood.
        :rtype: str
        """
        return self._food_type

    @food_type.setter
    def food_type(self, food_type: str):
        """Sets the food_type of this ProductFood.

        식품의 유형  # noqa: E501

        :param food_type: The food_type of this ProductFood.
        :type food_type: str
        """

        self._food_type = food_type

    @property
    def manufacture_date(self) -> str:
        """Gets the manufacture_date of this ProductFood.

        제조연월일  # noqa: E501

        :return: The manufacture_date of this ProductFood.
        :rtype: str
        """
        return self._manufacture_date

    @manufacture_date.setter
    def manufacture_date(self, manufacture_date: str):
        """Sets the manufacture_date of this ProductFood.

        제조연월일  # noqa: E501

        :param manufacture_date: The manufacture_date of this ProductFood.
        :type manufacture_date: str
        """

        self._manufacture_date = manufacture_date

    @property
    def expiration_date(self) -> str:
        """Gets the expiration_date of this ProductFood.

        유통기한  # noqa: E501

        :return: The expiration_date of this ProductFood.
        :rtype: str
        """
        return self._expiration_date

    @expiration_date.setter
    def expiration_date(self, expiration_date: str):
        """Sets the expiration_date of this ProductFood.

        유통기한  # noqa: E501

        :param expiration_date: The expiration_date of this ProductFood.
        :type expiration_date: str
        """

        self._expiration_date = expiration_date

    @property
    def count_per_pack(self) -> str:
        """Gets the count_per_pack of this ProductFood.

        포장단위별 수량  # noqa: E501

        :return: The count_per_pack of this ProductFood.
        :rtype: str
        """
        return self._count_per_pack

    @count_per_pack.setter
    def count_per_pack(self, count_per_pack: str):
        """Sets the count_per_pack of this ProductFood.

        포장단위별 수량  # noqa: E501

        :param count_per_pack: The count_per_pack of this ProductFood.
        :type count_per_pack: str
        """

        self._count_per_pack = count_per_pack

    @property
    def origin_materials(self) -> List[FoodOriginMaterial]:
        """Gets the origin_materials of this ProductFood.

        원재료명/함량  # noqa: E501

        :return: The origin_materials of this ProductFood.
        :rtype: List[FoodOriginMaterial]
        """
        return self._origin_materials

    @origin_materials.setter
    def origin_materials(self, origin_materials: List[FoodOriginMaterial]):
        """Sets the origin_materials of this ProductFood.

        원재료명/함량  # noqa: E501

        :param origin_materials: The origin_materials of this ProductFood.
        :type origin_materials: List[FoodOriginMaterial]
        """

        self._origin_materials = origin_materials

    @property
    def nutrients(self) -> List[Nutrient]:
        """Gets the nutrients of this ProductFood.

        영양성분  # noqa: E501

        :return: The nutrients of this ProductFood.
        :rtype: List[Nutrient]
        """
        return self._nutrients

    @nutrients.setter
    def nutrients(self, nutrients: List[Nutrient]):
        """Sets the nutrients of this ProductFood.

        영양성분  # noqa: E501

        :param nutrients: The nutrients of this ProductFood.
        :type nutrients: List[Nutrient]
        """

        self._nutrients = nutrients

    @property
    def genetic_recombination(self) -> str:
        """Gets the genetic_recombination of this ProductFood.

        유전자재조합식품의 경우 표시  # noqa: E501

        :return: The genetic_recombination of this ProductFood.
        :rtype: str
        """
        return self._genetic_recombination

    @genetic_recombination.setter
    def genetic_recombination(self, genetic_recombination: str):
        """Sets the genetic_recombination of this ProductFood.

        유전자재조합식품의 경우 표시  # noqa: E501

        :param genetic_recombination: The genetic_recombination of this ProductFood.
        :type genetic_recombination: str
        """

        self._genetic_recombination = genetic_recombination

    @property
    def is_infant_weight_control_food_ad_preview(self) -> bool:
        """Gets the is_infant_weight_control_food_ad_preview of this ProductFood.

        영유아식/체중조절식품 표시광고 사전심의필  # noqa: E501

        :return: The is_infant_weight_control_food_ad_preview of this ProductFood.
        :rtype: bool
        """
        return self._is_infant_weight_control_food_ad_preview

    @is_infant_weight_control_food_ad_preview.setter
    def is_infant_weight_control_food_ad_preview(self, is_infant_weight_control_food_ad_preview: bool):
        """Sets the is_infant_weight_control_food_ad_preview of this ProductFood.

        영유아식/체중조절식품 표시광고 사전심의필  # noqa: E501

        :param is_infant_weight_control_food_ad_preview: The is_infant_weight_control_food_ad_preview of this ProductFood.
        :type is_infant_weight_control_food_ad_preview: bool
        """

        self._is_infant_weight_control_food_ad_preview = is_infant_weight_control_food_ad_preview

    @property
    def import_declaration_description(self) -> str:
        """Gets the import_declaration_description of this ProductFood.

        식품위생법에 따른 수입신고를 필함 문구  # noqa: E501

        :return: The import_declaration_description of this ProductFood.
        :rtype: str
        """
        return self._import_declaration_description

    @import_declaration_description.setter
    def import_declaration_description(self, import_declaration_description: str):
        """Sets the import_declaration_description of this ProductFood.

        식품위생법에 따른 수입신고를 필함 문구  # noqa: E501

        :param import_declaration_description: The import_declaration_description of this ProductFood.
        :type import_declaration_description: str
        """

        self._import_declaration_description = import_declaration_description

    @property
    def as_owner(self) -> str:
        """Gets the as_owner of this ProductFood.

        A/S 책임자  # noqa: E501

        :return: The as_owner of this ProductFood.
        :rtype: str
        """
        return self._as_owner

    @as_owner.setter
    def as_owner(self, as_owner: str):
        """Sets the as_owner of this ProductFood.

        A/S 책임자  # noqa: E501

        :param as_owner: The as_owner of this ProductFood.
        :type as_owner: str
        """

        self._as_owner = as_owner

    @property
    def phone_number(self) -> str:
        """Gets the phone_number of this ProductFood.

        전화번호  # noqa: E501

        :return: The phone_number of this ProductFood.
        :rtype: str
        """
        return self._phone_number

    @phone_number.setter
    def phone_number(self, phone_number: str):
        """Sets the phone_number of this ProductFood.

        전화번호  # noqa: E501

        :param phone_number: The phone_number of this ProductFood.
        :type phone_number: str
        """

        self._phone_number = phone_number

    @property
    def functional_information(self) -> str:
        """Gets the functional_information of this ProductFood.

        기능정보  # noqa: E501

        :return: The functional_information of this ProductFood.
        :rtype: str
        """
        return self._functional_information

    @functional_information.setter
    def functional_information(self, functional_information: str):
        """Sets the functional_information of this ProductFood.

        기능정보  # noqa: E501

        :param functional_information: The functional_information of this ProductFood.
        :type functional_information: str
        """

        self._functional_information = functional_information

    @property
    def intake(self) -> str:
        """Gets the intake of this ProductFood.

        섭취량, 섭취방법  # noqa: E501

        :return: The intake of this ProductFood.
        :rtype: str
        """
        return self._intake

    @intake.setter
    def intake(self, intake: str):
        """Sets the intake of this ProductFood.

        섭취량, 섭취방법  # noqa: E501

        :param intake: The intake of this ProductFood.
        :type intake: str
        """

        self._intake = intake

    @property
    def intake_notice(self) -> str:
        """Gets the intake_notice of this ProductFood.

        섭취 시 주의사항  # noqa: E501

        :return: The intake_notice of this ProductFood.
        :rtype: str
        """
        return self._intake_notice

    @intake_notice.setter
    def intake_notice(self, intake_notice: str):
        """Sets the intake_notice of this ProductFood.

        섭취 시 주의사항  # noqa: E501

        :param intake_notice: The intake_notice of this ProductFood.
        :type intake_notice: str
        """

        self._intake_notice = intake_notice

    @property
    def possible_side_effects(self) -> str:
        """Gets the possible_side_effects of this ProductFood.

        부작용 발생 가능성  # noqa: E501

        :return: The possible_side_effects of this ProductFood.
        :rtype: str
        """
        return self._possible_side_effects

    @possible_side_effects.setter
    def possible_side_effects(self, possible_side_effects: str):
        """Sets the possible_side_effects of this ProductFood.

        부작용 발생 가능성  # noqa: E501

        :param possible_side_effects: The possible_side_effects of this ProductFood.
        :type possible_side_effects: str
        """

        self._possible_side_effects = possible_side_effects

    @property
    def is_non_medication_indication(self) -> str:
        """Gets the is_non_medication_indication of this ProductFood.

        질병의 예방/치료를 위한 의약품이 아님 표시  # noqa: E501

        :return: The is_non_medication_indication of this ProductFood.
        :rtype: str
        """
        return self._is_non_medication_indication

    @is_non_medication_indication.setter
    def is_non_medication_indication(self, is_non_medication_indication: str):
        """Sets the is_non_medication_indication of this ProductFood.

        질병의 예방/치료를 위한 의약품이 아님 표시  # noqa: E501

        :param is_non_medication_indication: The is_non_medication_indication of this ProductFood.
        :type is_non_medication_indication: str
        """

        self._is_non_medication_indication = is_non_medication_indication

    @property
    def is_display_ad_preview(self) -> bool:
        """Gets the is_display_ad_preview of this ProductFood.

        표시광고 사전심의필  # noqa: E501

        :return: The is_display_ad_preview of this ProductFood.
        :rtype: bool
        """
        return self._is_display_ad_preview

    @is_display_ad_preview.setter
    def is_display_ad_preview(self, is_display_ad_preview: bool):
        """Sets the is_display_ad_preview of this ProductFood.

        표시광고 사전심의필  # noqa: E501

        :param is_display_ad_preview: The is_display_ad_preview of this ProductFood.
        :type is_display_ad_preview: bool
        """

        self._is_display_ad_preview = is_display_ad_preview

    @property
    def item_manufacture_mgmt_number(self) -> str:
        """Gets the item_manufacture_mgmt_number of this ProductFood.

        품목제조관리번호  # noqa: E501

        :return: The item_manufacture_mgmt_number of this ProductFood.
        :rtype: str
        """
        return self._item_manufacture_mgmt_number

    @item_manufacture_mgmt_number.setter
    def item_manufacture_mgmt_number(self, item_manufacture_mgmt_number: str):
        """Sets the item_manufacture_mgmt_number of this ProductFood.

        품목제조관리번호  # noqa: E501

        :param item_manufacture_mgmt_number: The item_manufacture_mgmt_number of this ProductFood.
        :type item_manufacture_mgmt_number: str
        """

        self._item_manufacture_mgmt_number = item_manufacture_mgmt_number

    @property
    def allergens(self) -> List[str]:
        """Gets the allergens of this ProductFood.

        알레르기성분  # noqa: E501

        :return: The allergens of this ProductFood.
        :rtype: List[str]
        """
        return self._allergens

    @allergens.setter
    def allergens(self, allergens: List[str]):
        """Sets the allergens of this ProductFood.

        알레르기성분  # noqa: E501

        :param allergens: The allergens of this ProductFood.
        :type allergens: List[str]
        """

        self._allergens = allergens

    @property
    def factory_allergens_notice(self) -> str:
        """Gets the factory_allergens_notice of this ProductFood.

        제조시설 알레르기 성분 안내  # noqa: E501

        :return: The factory_allergens_notice of this ProductFood.
        :rtype: str
        """
        return self._factory_allergens_notice

    @factory_allergens_notice.setter
    def factory_allergens_notice(self, factory_allergens_notice: str):
        """Sets the factory_allergens_notice of this ProductFood.

        제조시설 알레르기 성분 안내  # noqa: E501

        :param factory_allergens_notice: The factory_allergens_notice of this ProductFood.
        :type factory_allergens_notice: str
        """

        self._factory_allergens_notice = factory_allergens_notice

    @property
    def function(self) -> str:
        """Gets the function of this ProductFood.

        기능  # noqa: E501

        :return: The function of this ProductFood.
        :rtype: str
        """
        return self._function

    @function.setter
    def function(self, function: str):
        """Sets the function of this ProductFood.

        기능  # noqa: E501

        :param function: The function of this ProductFood.
        :type function: str
        """

        self._function = function

    @property
    def step_by_step(self) -> str:
        """Gets the step_by_step of this ProductFood.

        단계별  # noqa: E501

        :return: The step_by_step of this ProductFood.
        :rtype: str
        """
        return self._step_by_step

    @step_by_step.setter
    def step_by_step(self, step_by_step: str):
        """Sets the step_by_step of this ProductFood.

        단계별  # noqa: E501

        :param step_by_step: The step_by_step of this ProductFood.
        :type step_by_step: str
        """

        self._step_by_step = step_by_step

    @property
    def vitamin_type(self) -> str:
        """Gets the vitamin_type of this ProductFood.

        비타민종류  # noqa: E501

        :return: The vitamin_type of this ProductFood.
        :rtype: str
        """
        return self._vitamin_type

    @vitamin_type.setter
    def vitamin_type(self, vitamin_type: str):
        """Sets the vitamin_type of this ProductFood.

        비타민종류  # noqa: E501

        :param vitamin_type: The vitamin_type of this ProductFood.
        :type vitamin_type: str
        """

        self._vitamin_type = vitamin_type

    @property
    def min_age(self) -> int:
        """Gets the min_age of this ProductFood.

        비타민종류  # noqa: E501

        :return: The min_age of this ProductFood.
        :rtype: int
        """
        return self._min_age

    @min_age.setter
    def min_age(self, min_age: int):
        """Sets the min_age of this ProductFood.

        비타민종류  # noqa: E501

        :param min_age: The min_age of this ProductFood.
        :type min_age: int
        """

        self._min_age = min_age

    @property
    def pack_type(self) -> str:
        """Gets the pack_type of this ProductFood.

        포장형태 (ex. 육면체/상자형, 기둥형/캔형  # noqa: E501

        :return: The pack_type of this ProductFood.
        :rtype: str
        """
        return self._pack_type

    @pack_type.setter
    def pack_type(self, pack_type: str):
        """Sets the pack_type of this ProductFood.

        포장형태 (ex. 육면체/상자형, 기둥형/캔형  # noqa: E501

        :param pack_type: The pack_type of this ProductFood.
        :type pack_type: str
        """

        self._pack_type = pack_type

    @property
    def material(self) -> str:
        """Gets the material of this ProductFood.

        재료  # noqa: E501

        :return: The material of this ProductFood.
        :rtype: str
        """
        return self._material

    @material.setter
    def material(self, material: str):
        """Sets the material of this ProductFood.

        재료  # noqa: E501

        :param material: The material of this ProductFood.
        :type material: str
        """

        self._material = material

    @property
    def product_type(self) -> str:
        """Gets the product_type of this ProductFood.

        제품형태  # noqa: E501

        :return: The product_type of this ProductFood.
        :rtype: str
        """
        return self._product_type

    @product_type.setter
    def product_type(self, product_type: str):
        """Sets the product_type of this ProductFood.

        제품형태  # noqa: E501

        :param product_type: The product_type of this ProductFood.
        :type product_type: str
        """

        self._product_type = product_type

    @property
    def cooking_time(self) -> str:
        """Gets the cooking_time of this ProductFood.

        조리시간  # noqa: E501

        :return: The cooking_time of this ProductFood.
        :rtype: str
        """
        return self._cooking_time

    @cooking_time.setter
    def cooking_time(self, cooking_time: str):
        """Sets the cooking_time of this ProductFood.

        조리시간  # noqa: E501

        :param cooking_time: The cooking_time of this ProductFood.
        :type cooking_time: str
        """

        self._cooking_time = cooking_time

    @property
    def cooking_capacity(self) -> str:
        """Gets the cooking_capacity of this ProductFood.

        조리양  # noqa: E501

        :return: The cooking_capacity of this ProductFood.
        :rtype: str
        """
        return self._cooking_capacity

    @cooking_capacity.setter
    def cooking_capacity(self, cooking_capacity: str):
        """Sets the cooking_capacity of this ProductFood.

        조리양  # noqa: E501

        :param cooking_capacity: The cooking_capacity of this ProductFood.
        :type cooking_capacity: str
        """

        self._cooking_capacity = cooking_capacity

    @property
    def is_green_certification(self) -> bool:
        """Gets the is_green_certification of this ProductFood.

        친환경인증  # noqa: E501

        :return: The is_green_certification of this ProductFood.
        :rtype: bool
        """
        return self._is_green_certification

    @is_green_certification.setter
    def is_green_certification(self, is_green_certification: bool):
        """Sets the is_green_certification of this ProductFood.

        친환경인증  # noqa: E501

        :param is_green_certification: The is_green_certification of this ProductFood.
        :type is_green_certification: bool
        """

        self._is_green_certification = is_green_certification

    @property
    def cetification(self) -> str:
        """Gets the cetification of this ProductFood.

        인증  # noqa: E501

        :return: The cetification of this ProductFood.
        :rtype: str
        """
        return self._cetification

    @cetification.setter
    def cetification(self, cetification: str):
        """Sets the cetification of this ProductFood.

        인증  # noqa: E501

        :param cetification: The cetification of this ProductFood.
        :type cetification: str
        """

        self._cetification = cetification

    @property
    def is_no_additives(self) -> str:
        """Gets the is_no_additives of this ProductFood.

        무첨가  # noqa: E501

        :return: The is_no_additives of this ProductFood.
        :rtype: str
        """
        return self._is_no_additives

    @is_no_additives.setter
    def is_no_additives(self, is_no_additives: str):
        """Sets the is_no_additives of this ProductFood.

        무첨가  # noqa: E501

        :param is_no_additives: The is_no_additives of this ProductFood.
        :type is_no_additives: str
        """

        self._is_no_additives = is_no_additives

    @property
    def is_recycle(self) -> str:
        """Gets the is_recycle of this ProductFood.

        분리배출 표시  # noqa: E501

        :return: The is_recycle of this ProductFood.
        :rtype: str
        """
        return self._is_recycle

    @is_recycle.setter
    def is_recycle(self, is_recycle: str):
        """Sets the is_recycle of this ProductFood.

        분리배출 표시  # noqa: E501

        :param is_recycle: The is_recycle of this ProductFood.
        :type is_recycle: str
        """

        self._is_recycle = is_recycle

    @property
    def additional_food_type(self) -> str:
        """Gets the additional_food_type of this ProductFood.

        추가식품유형/개별표시  # noqa: E501

        :return: The additional_food_type of this ProductFood.
        :rtype: str
        """
        return self._additional_food_type

    @additional_food_type.setter
    def additional_food_type(self, additional_food_type: str):
        """Sets the additional_food_type of this ProductFood.

        추가식품유형/개별표시  # noqa: E501

        :param additional_food_type: The additional_food_type of this ProductFood.
        :type additional_food_type: str
        """

        self._additional_food_type = additional_food_type

    @property
    def item_report_number(self) -> str:
        """Gets the item_report_number of this ProductFood.

        품목보고번호  # noqa: E501

        :return: The item_report_number of this ProductFood.
        :rtype: str
        """
        return self._item_report_number

    @item_report_number.setter
    def item_report_number(self, item_report_number: str):
        """Sets the item_report_number of this ProductFood.

        품목보고번호  # noqa: E501

        :param item_report_number: The item_report_number of this ProductFood.
        :type item_report_number: str
        """

        self._item_report_number = item_report_number

    @property
    def how_to_store(self) -> str:
        """Gets the how_to_store of this ProductFood.

        보관방법  # noqa: E501

        :return: The how_to_store of this ProductFood.
        :rtype: str
        """
        return self._how_to_store

    @how_to_store.setter
    def how_to_store(self, how_to_store: str):
        """Sets the how_to_store of this ProductFood.

        보관방법  # noqa: E501

        :param how_to_store: The how_to_store of this ProductFood.
        :type how_to_store: str
        """

        self._how_to_store = how_to_store

    @property
    def parent_product_id(self) -> str:
        """Gets the parent_product_id of this ProductFood.

        Parent product ID  # noqa: E501

        :return: The parent_product_id of this ProductFood.
        :rtype: str
        """
        return self._parent_product_id

    @parent_product_id.setter
    def parent_product_id(self, parent_product_id: str):
        """Sets the parent_product_id of this ProductFood.

        Parent product ID  # noqa: E501

        :param parent_product_id: The parent_product_id of this ProductFood.
        :type parent_product_id: str
        """

        self._parent_product_id = parent_product_id
