# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from goodlens_product.models.base_model_ import Model
from goodlens_product import util


class ProductCommon(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, product_id: str=None, kan: str=None, kan_code: str=None, gtin: str=None, product_name: str=None, product_name_en: str=None, product_name_extra: str=None, brand_manufacturer: str=None, brand_main: str=None, brand_extra: str=None, image_revised: List[str]=None, image_front: str=None, image_front_angle: str=None, image_barcode: str=None, image_labels: List[str]=None, origin_place: str=None, manufacturer: str=None, manufacture_seller: str=None, is_imported: bool=None, import_trader: str=None, weight_total: int=None, weight_pure: int=None, weight_unit: str=None, width: int=None, depth: int=None, height: int=None, standard_length_unit: str=None, pack_material: str=None, pack_type: str=None, product_number: str=None, model_name: str=None, product_unit: int=None, product_capacity: str=None, product_capacity_unit: str=None, is_adult_product: str=None, is_child_product: str=None, create_date: int=None, update_date: int=None, seller_code: str=None, company_address: str=None, phone_number: str=None, child_product_id: str=None, is_completed: bool=None):  # noqa: E501
        """ProductCommon - a model defined in Swagger

        :param product_id: The product_id of this ProductCommon.  # noqa: E501
        :type product_id: str
        :param kan: The kan of this ProductCommon.  # noqa: E501
        :type kan: str
        :param kan_code: The kan_code of this ProductCommon.  # noqa: E501
        :type kan_code: str
        :param gtin: The gtin of this ProductCommon.  # noqa: E501
        :type gtin: str
        :param product_name: The product_name of this ProductCommon.  # noqa: E501
        :type product_name: str
        :param product_name_en: The product_name_en of this ProductCommon.  # noqa: E501
        :type product_name_en: str
        :param product_name_extra: The product_name_extra of this ProductCommon.  # noqa: E501
        :type product_name_extra: str
        :param brand_manufacturer: The brand_manufacturer of this ProductCommon.  # noqa: E501
        :type brand_manufacturer: str
        :param brand_main: The brand_main of this ProductCommon.  # noqa: E501
        :type brand_main: str
        :param brand_extra: The brand_extra of this ProductCommon.  # noqa: E501
        :type brand_extra: str
        :param image_revised: The image_revised of this ProductCommon.  # noqa: E501
        :type image_revised: List[str]
        :param image_front: The image_front of this ProductCommon.  # noqa: E501
        :type image_front: str
        :param image_front_angle: The image_front_angle of this ProductCommon.  # noqa: E501
        :type image_front_angle: str
        :param image_barcode: The image_barcode of this ProductCommon.  # noqa: E501
        :type image_barcode: str
        :param image_labels: The image_labels of this ProductCommon.  # noqa: E501
        :type image_labels: List[str]
        :param origin_place: The origin_place of this ProductCommon.  # noqa: E501
        :type origin_place: str
        :param manufacturer: The manufacturer of this ProductCommon.  # noqa: E501
        :type manufacturer: str
        :param manufacture_seller: The manufacture_seller of this ProductCommon.  # noqa: E501
        :type manufacture_seller: str
        :param is_imported: The is_imported of this ProductCommon.  # noqa: E501
        :type is_imported: bool
        :param import_trader: The import_trader of this ProductCommon.  # noqa: E501
        :type import_trader: str
        :param weight_total: The weight_total of this ProductCommon.  # noqa: E501
        :type weight_total: int
        :param weight_pure: The weight_pure of this ProductCommon.  # noqa: E501
        :type weight_pure: int
        :param weight_unit: The weight_unit of this ProductCommon.  # noqa: E501
        :type weight_unit: str
        :param width: The width of this ProductCommon.  # noqa: E501
        :type width: int
        :param depth: The depth of this ProductCommon.  # noqa: E501
        :type depth: int
        :param height: The height of this ProductCommon.  # noqa: E501
        :type height: int
        :param standard_length_unit: The standard_length_unit of this ProductCommon.  # noqa: E501
        :type standard_length_unit: str
        :param pack_material: The pack_material of this ProductCommon.  # noqa: E501
        :type pack_material: str
        :param pack_type: The pack_type of this ProductCommon.  # noqa: E501
        :type pack_type: str
        :param product_number: The product_number of this ProductCommon.  # noqa: E501
        :type product_number: str
        :param model_name: The model_name of this ProductCommon.  # noqa: E501
        :type model_name: str
        :param product_unit: The product_unit of this ProductCommon.  # noqa: E501
        :type product_unit: int
        :param product_capacity: The product_capacity of this ProductCommon.  # noqa: E501
        :type product_capacity: str
        :param product_capacity_unit: The product_capacity_unit of this ProductCommon.  # noqa: E501
        :type product_capacity_unit: str
        :param is_adult_product: The is_adult_product of this ProductCommon.  # noqa: E501
        :type is_adult_product: str
        :param is_child_product: The is_child_product of this ProductCommon.  # noqa: E501
        :type is_child_product: str
        :param create_date: The create_date of this ProductCommon.  # noqa: E501
        :type create_date: int
        :param update_date: The update_date of this ProductCommon.  # noqa: E501
        :type update_date: int
        :param seller_code: The seller_code of this ProductCommon.  # noqa: E501
        :type seller_code: str
        :param company_address: The company_address of this ProductCommon.  # noqa: E501
        :type company_address: str
        :param phone_number: The phone_number of this ProductCommon.  # noqa: E501
        :type phone_number: str
        :param child_product_id: The child_product_id of this ProductCommon.  # noqa: E501
        :type child_product_id: str
        :param is_completed: The is_completed of this ProductCommon.  # noqa: E501
        :type is_completed: bool
        """
        self.swagger_types = {
            'product_id': str,
            'kan': str,
            'kan_code': str,
            'gtin': str,
            'product_name': str,
            'product_name_en': str,
            'product_name_extra': str,
            'brand_manufacturer': str,
            'brand_main': str,
            'brand_extra': str,
            'image_revised': List[str],
            'image_front': str,
            'image_front_angle': str,
            'image_barcode': str,
            'image_labels': List[str],
            'origin_place': str,
            'manufacturer': str,
            'manufacture_seller': str,
            'is_imported': bool,
            'import_trader': str,
            'weight_total': int,
            'weight_pure': int,
            'weight_unit': str,
            'width': int,
            'depth': int,
            'height': int,
            'standard_length_unit': str,
            'pack_material': str,
            'pack_type': str,
            'product_number': str,
            'model_name': str,
            'product_unit': int,
            'product_capacity': str,
            'product_capacity_unit': str,
            'is_adult_product': str,
            'is_child_product': str,
            'create_date': int,
            'update_date': int,
            'seller_code': str,
            'company_address': str,
            'phone_number': str,
            'child_product_id': str,
            'is_completed': bool
        }

        self.attribute_map = {
            'product_id': 'product_id',
            'kan': 'kan',
            'kan_code': 'kan_code',
            'gtin': 'gtin',
            'product_name': 'product_name',
            'product_name_en': 'product_name_en',
            'product_name_extra': 'product_name_extra',
            'brand_manufacturer': 'brand_manufacturer',
            'brand_main': 'brand_main',
            'brand_extra': 'brand_extra',
            'image_revised': 'image_revised',
            'image_front': 'image_front',
            'image_front_angle': 'image_front_angle',
            'image_barcode': 'image_barcode',
            'image_labels': 'image_labels',
            'origin_place': 'origin_place',
            'manufacturer': 'manufacturer',
            'manufacture_seller': 'manufacture_seller',
            'is_imported': 'is_imported',
            'import_trader': 'import_trader',
            'weight_total': 'weight_total',
            'weight_pure': 'weight_pure',
            'weight_unit': 'weight_unit',
            'width': 'width',
            'depth': 'depth',
            'height': 'height',
            'standard_length_unit': 'standard_length_unit',
            'pack_material': 'pack_material',
            'pack_type': 'pack_type',
            'product_number': 'product_number',
            'model_name': 'model_name',
            'product_unit': 'product_unit',
            'product_capacity': 'product_capacity',
            'product_capacity_unit': 'product_capacity_unit',
            'is_adult_product': 'is_adult_product',
            'is_child_product': 'is_child_product',
            'create_date': 'create_date',
            'update_date': 'update_date',
            'seller_code': 'seller_code',
            'company_address': 'company_address',
            'phone_number': 'phone_number',
            'child_product_id': 'child_product_id',
            'is_completed': 'is_completed'
        }

        self._product_id = product_id
        self._kan = kan
        self._kan_code = kan_code
        self._gtin = gtin
        self._product_name = product_name
        self._product_name_en = product_name_en
        self._product_name_extra = product_name_extra
        self._brand_manufacturer = brand_manufacturer
        self._brand_main = brand_main
        self._brand_extra = brand_extra
        self._image_revised = image_revised
        self._image_front = image_front
        self._image_front_angle = image_front_angle
        self._image_barcode = image_barcode
        self._image_labels = image_labels
        self._origin_place = origin_place
        self._manufacturer = manufacturer
        self._manufacture_seller = manufacture_seller
        self._is_imported = is_imported
        self._import_trader = import_trader
        self._weight_total = weight_total
        self._weight_pure = weight_pure
        self._weight_unit = weight_unit
        self._width = width
        self._depth = depth
        self._height = height
        self._standard_length_unit = standard_length_unit
        self._pack_material = pack_material
        self._pack_type = pack_type
        self._product_number = product_number
        self._model_name = model_name
        self._product_unit = product_unit
        self._product_capacity = product_capacity
        self._product_capacity_unit = product_capacity_unit
        self._is_adult_product = is_adult_product
        self._is_child_product = is_child_product
        self._create_date = create_date
        self._update_date = update_date
        self._seller_code = seller_code
        self._company_address = company_address
        self._phone_number = phone_number
        self._child_product_id = child_product_id
        self._is_completed = is_completed

    @classmethod
    def from_dict(cls, dikt) -> 'ProductCommon':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ProductCommon of this ProductCommon.  # noqa: E501
        :rtype: ProductCommon
        """
        return util.deserialize_model(dikt, cls)

    @property
    def product_id(self) -> str:
        """Gets the product_id of this ProductCommon.


        :return: The product_id of this ProductCommon.
        :rtype: str
        """
        return self._product_id

    @product_id.setter
    def product_id(self, product_id: str):
        """Sets the product_id of this ProductCommon.


        :param product_id: The product_id of this ProductCommon.
        :type product_id: str
        """

        self._product_id = product_id

    @property
    def kan(self) -> str:
        """Gets the kan of this ProductCommon.

        KAN 상품분류 (ex. 가공식품>분말류>밀가루분말류>핫케익가루)  # noqa: E501

        :return: The kan of this ProductCommon.
        :rtype: str
        """
        return self._kan

    @kan.setter
    def kan(self, kan: str):
        """Sets the kan of this ProductCommon.

        KAN 상품분류 (ex. 가공식품>분말류>밀가루분말류>핫케익가루)  # noqa: E501

        :param kan: The kan of this ProductCommon.
        :type kan: str
        """

        self._kan = kan

    @property
    def kan_code(self) -> str:
        """Gets the kan_code of this ProductCommon.

        KAN 상품분류 코드 (ex. 01110107)  # noqa: E501

        :return: The kan_code of this ProductCommon.
        :rtype: str
        """
        return self._kan_code

    @kan_code.setter
    def kan_code(self, kan_code: str):
        """Sets the kan_code of this ProductCommon.

        KAN 상품분류 코드 (ex. 01110107)  # noqa: E501

        :param kan_code: The kan_code of this ProductCommon.
        :type kan_code: str
        """

        self._kan_code = kan_code

    @property
    def gtin(self) -> str:
        """Gets the gtin of this ProductCommon.

        GTIN (barcode)  # noqa: E501

        :return: The gtin of this ProductCommon.
        :rtype: str
        """
        return self._gtin

    @gtin.setter
    def gtin(self, gtin: str):
        """Sets the gtin of this ProductCommon.

        GTIN (barcode)  # noqa: E501

        :param gtin: The gtin of this ProductCommon.
        :type gtin: str
        """

        self._gtin = gtin

    @property
    def product_name(self) -> str:
        """Gets the product_name of this ProductCommon.

        상품명(한글)  # noqa: E501

        :return: The product_name of this ProductCommon.
        :rtype: str
        """
        return self._product_name

    @product_name.setter
    def product_name(self, product_name: str):
        """Sets the product_name of this ProductCommon.

        상품명(한글)  # noqa: E501

        :param product_name: The product_name of this ProductCommon.
        :type product_name: str
        """

        self._product_name = product_name

    @property
    def product_name_en(self) -> str:
        """Gets the product_name_en of this ProductCommon.

        상품명(영어)  # noqa: E501

        :return: The product_name_en of this ProductCommon.
        :rtype: str
        """
        return self._product_name_en

    @product_name_en.setter
    def product_name_en(self, product_name_en: str):
        """Sets the product_name_en of this ProductCommon.

        상품명(영어)  # noqa: E501

        :param product_name_en: The product_name_en of this ProductCommon.
        :type product_name_en: str
        """

        self._product_name_en = product_name_en

    @property
    def product_name_extra(self) -> str:
        """Gets the product_name_extra of this ProductCommon.

        상품명(추가)  # noqa: E501

        :return: The product_name_extra of this ProductCommon.
        :rtype: str
        """
        return self._product_name_extra

    @product_name_extra.setter
    def product_name_extra(self, product_name_extra: str):
        """Sets the product_name_extra of this ProductCommon.

        상품명(추가)  # noqa: E501

        :param product_name_extra: The product_name_extra of this ProductCommon.
        :type product_name_extra: str
        """

        self._product_name_extra = product_name_extra

    @property
    def brand_manufacturer(self) -> str:
        """Gets the brand_manufacturer of this ProductCommon.

        브랜드명-제조사명 (ex. 대상주식회사)  # noqa: E501

        :return: The brand_manufacturer of this ProductCommon.
        :rtype: str
        """
        return self._brand_manufacturer

    @brand_manufacturer.setter
    def brand_manufacturer(self, brand_manufacturer: str):
        """Sets the brand_manufacturer of this ProductCommon.

        브랜드명-제조사명 (ex. 대상주식회사)  # noqa: E501

        :param brand_manufacturer: The brand_manufacturer of this ProductCommon.
        :type brand_manufacturer: str
        """

        self._brand_manufacturer = brand_manufacturer

    @property
    def brand_main(self) -> str:
        """Gets the brand_main of this ProductCommon.

        브렌드명-메인 (ex. 청정원)  # noqa: E501

        :return: The brand_main of this ProductCommon.
        :rtype: str
        """
        return self._brand_main

    @brand_main.setter
    def brand_main(self, brand_main: str):
        """Sets the brand_main of this ProductCommon.

        브렌드명-메인 (ex. 청정원)  # noqa: E501

        :param brand_main: The brand_main of this ProductCommon.
        :type brand_main: str
        """

        self._brand_main = brand_main

    @property
    def brand_extra(self) -> str:
        """Gets the brand_extra of this ProductCommon.

        브렌드명-추가 (ex. 홍초)  # noqa: E501

        :return: The brand_extra of this ProductCommon.
        :rtype: str
        """
        return self._brand_extra

    @brand_extra.setter
    def brand_extra(self, brand_extra: str):
        """Sets the brand_extra of this ProductCommon.

        브렌드명-추가 (ex. 홍초)  # noqa: E501

        :param brand_extra: The brand_extra of this ProductCommon.
        :type brand_extra: str
        """

        self._brand_extra = brand_extra

    @property
    def image_revised(self) -> List[str]:
        """Gets the image_revised of this ProductCommon.

        보정된 이미지들  # noqa: E501

        :return: The image_revised of this ProductCommon.
        :rtype: List[str]
        """
        return self._image_revised

    @image_revised.setter
    def image_revised(self, image_revised: List[str]):
        """Sets the image_revised of this ProductCommon.

        보정된 이미지들  # noqa: E501

        :param image_revised: The image_revised of this ProductCommon.
        :type image_revised: List[str]
        """

        self._image_revised = image_revised

    @property
    def image_front(self) -> str:
        """Gets the image_front of this ProductCommon.

        정면 이미지  # noqa: E501

        :return: The image_front of this ProductCommon.
        :rtype: str
        """
        return self._image_front

    @image_front.setter
    def image_front(self, image_front: str):
        """Sets the image_front of this ProductCommon.

        정면 이미지  # noqa: E501

        :param image_front: The image_front of this ProductCommon.
        :type image_front: str
        """

        self._image_front = image_front

    @property
    def image_front_angle(self) -> str:
        """Gets the image_front_angle of this ProductCommon.

        정면 앵글 이미지  # noqa: E501

        :return: The image_front_angle of this ProductCommon.
        :rtype: str
        """
        return self._image_front_angle

    @image_front_angle.setter
    def image_front_angle(self, image_front_angle: str):
        """Sets the image_front_angle of this ProductCommon.

        정면 앵글 이미지  # noqa: E501

        :param image_front_angle: The image_front_angle of this ProductCommon.
        :type image_front_angle: str
        """

        self._image_front_angle = image_front_angle

    @property
    def image_barcode(self) -> str:
        """Gets the image_barcode of this ProductCommon.

        바코드 이미지  # noqa: E501

        :return: The image_barcode of this ProductCommon.
        :rtype: str
        """
        return self._image_barcode

    @image_barcode.setter
    def image_barcode(self, image_barcode: str):
        """Sets the image_barcode of this ProductCommon.

        바코드 이미지  # noqa: E501

        :param image_barcode: The image_barcode of this ProductCommon.
        :type image_barcode: str
        """

        self._image_barcode = image_barcode

    @property
    def image_labels(self) -> List[str]:
        """Gets the image_labels of this ProductCommon.

        상품 정보 이미지(ex. 원제료, 내용함량)  # noqa: E501

        :return: The image_labels of this ProductCommon.
        :rtype: List[str]
        """
        return self._image_labels

    @image_labels.setter
    def image_labels(self, image_labels: List[str]):
        """Sets the image_labels of this ProductCommon.

        상품 정보 이미지(ex. 원제료, 내용함량)  # noqa: E501

        :param image_labels: The image_labels of this ProductCommon.
        :type image_labels: List[str]
        """

        self._image_labels = image_labels

    @property
    def origin_place(self) -> str:
        """Gets the origin_place of this ProductCommon.

        원산지  # noqa: E501

        :return: The origin_place of this ProductCommon.
        :rtype: str
        """
        return self._origin_place

    @origin_place.setter
    def origin_place(self, origin_place: str):
        """Sets the origin_place of this ProductCommon.

        원산지  # noqa: E501

        :param origin_place: The origin_place of this ProductCommon.
        :type origin_place: str
        """

        self._origin_place = origin_place

    @property
    def manufacturer(self) -> str:
        """Gets the manufacturer of this ProductCommon.

        제조업자  # noqa: E501

        :return: The manufacturer of this ProductCommon.
        :rtype: str
        """
        return self._manufacturer

    @manufacturer.setter
    def manufacturer(self, manufacturer: str):
        """Sets the manufacturer of this ProductCommon.

        제조업자  # noqa: E501

        :param manufacturer: The manufacturer of this ProductCommon.
        :type manufacturer: str
        """

        self._manufacturer = manufacturer

    @property
    def manufacture_seller(self) -> str:
        """Gets the manufacture_seller of this ProductCommon.

        제조판매업자  # noqa: E501

        :return: The manufacture_seller of this ProductCommon.
        :rtype: str
        """
        return self._manufacture_seller

    @manufacture_seller.setter
    def manufacture_seller(self, manufacture_seller: str):
        """Sets the manufacture_seller of this ProductCommon.

        제조판매업자  # noqa: E501

        :param manufacture_seller: The manufacture_seller of this ProductCommon.
        :type manufacture_seller: str
        """

        self._manufacture_seller = manufacture_seller

    @property
    def is_imported(self) -> bool:
        """Gets the is_imported of this ProductCommon.

        수입 제품 구분  # noqa: E501

        :return: The is_imported of this ProductCommon.
        :rtype: bool
        """
        return self._is_imported

    @is_imported.setter
    def is_imported(self, is_imported: bool):
        """Sets the is_imported of this ProductCommon.

        수입 제품 구분  # noqa: E501

        :param is_imported: The is_imported of this ProductCommon.
        :type is_imported: bool
        """

        self._is_imported = is_imported

    @property
    def import_trader(self) -> str:
        """Gets the import_trader of this ProductCommon.

        수입업자  # noqa: E501

        :return: The import_trader of this ProductCommon.
        :rtype: str
        """
        return self._import_trader

    @import_trader.setter
    def import_trader(self, import_trader: str):
        """Sets the import_trader of this ProductCommon.

        수입업자  # noqa: E501

        :param import_trader: The import_trader of this ProductCommon.
        :type import_trader: str
        """

        self._import_trader = import_trader

    @property
    def weight_total(self) -> int:
        """Gets the weight_total of this ProductCommon.

        총중량  # noqa: E501

        :return: The weight_total of this ProductCommon.
        :rtype: int
        """
        return self._weight_total

    @weight_total.setter
    def weight_total(self, weight_total: int):
        """Sets the weight_total of this ProductCommon.

        총중량  # noqa: E501

        :param weight_total: The weight_total of this ProductCommon.
        :type weight_total: int
        """

        self._weight_total = weight_total

    @property
    def weight_pure(self) -> int:
        """Gets the weight_pure of this ProductCommon.

        순중량  # noqa: E501

        :return: The weight_pure of this ProductCommon.
        :rtype: int
        """
        return self._weight_pure

    @weight_pure.setter
    def weight_pure(self, weight_pure: int):
        """Sets the weight_pure of this ProductCommon.

        순중량  # noqa: E501

        :param weight_pure: The weight_pure of this ProductCommon.
        :type weight_pure: int
        """

        self._weight_pure = weight_pure

    @property
    def weight_unit(self) -> str:
        """Gets the weight_unit of this ProductCommon.

        중량 단위 (ex. g, kg, ...)  # noqa: E501

        :return: The weight_unit of this ProductCommon.
        :rtype: str
        """
        return self._weight_unit

    @weight_unit.setter
    def weight_unit(self, weight_unit: str):
        """Sets the weight_unit of this ProductCommon.

        중량 단위 (ex. g, kg, ...)  # noqa: E501

        :param weight_unit: The weight_unit of this ProductCommon.
        :type weight_unit: str
        """

        self._weight_unit = weight_unit

    @property
    def width(self) -> int:
        """Gets the width of this ProductCommon.

        가로  # noqa: E501

        :return: The width of this ProductCommon.
        :rtype: int
        """
        return self._width

    @width.setter
    def width(self, width: int):
        """Sets the width of this ProductCommon.

        가로  # noqa: E501

        :param width: The width of this ProductCommon.
        :type width: int
        """

        self._width = width

    @property
    def depth(self) -> int:
        """Gets the depth of this ProductCommon.

        세로  # noqa: E501

        :return: The depth of this ProductCommon.
        :rtype: int
        """
        return self._depth

    @depth.setter
    def depth(self, depth: int):
        """Sets the depth of this ProductCommon.

        세로  # noqa: E501

        :param depth: The depth of this ProductCommon.
        :type depth: int
        """

        self._depth = depth

    @property
    def height(self) -> int:
        """Gets the height of this ProductCommon.

        높이  # noqa: E501

        :return: The height of this ProductCommon.
        :rtype: int
        """
        return self._height

    @height.setter
    def height(self, height: int):
        """Sets the height of this ProductCommon.

        높이  # noqa: E501

        :param height: The height of this ProductCommon.
        :type height: int
        """

        self._height = height

    @property
    def standard_length_unit(self) -> str:
        """Gets the standard_length_unit of this ProductCommon.

        규격 단위 (ex. cm, m, ...)  # noqa: E501

        :return: The standard_length_unit of this ProductCommon.
        :rtype: str
        """
        return self._standard_length_unit

    @standard_length_unit.setter
    def standard_length_unit(self, standard_length_unit: str):
        """Sets the standard_length_unit of this ProductCommon.

        규격 단위 (ex. cm, m, ...)  # noqa: E501

        :param standard_length_unit: The standard_length_unit of this ProductCommon.
        :type standard_length_unit: str
        """

        self._standard_length_unit = standard_length_unit

    @property
    def pack_material(self) -> str:
        """Gets the pack_material of this ProductCommon.

        제품포장 재질  # noqa: E501

        :return: The pack_material of this ProductCommon.
        :rtype: str
        """
        return self._pack_material

    @pack_material.setter
    def pack_material(self, pack_material: str):
        """Sets the pack_material of this ProductCommon.

        제품포장 재질  # noqa: E501

        :param pack_material: The pack_material of this ProductCommon.
        :type pack_material: str
        """

        self._pack_material = pack_material

    @property
    def pack_type(self) -> str:
        """Gets the pack_type of this ProductCommon.

        제품포장 타입  # noqa: E501

        :return: The pack_type of this ProductCommon.
        :rtype: str
        """
        return self._pack_type

    @pack_type.setter
    def pack_type(self, pack_type: str):
        """Sets the pack_type of this ProductCommon.

        제품포장 타입  # noqa: E501

        :param pack_type: The pack_type of this ProductCommon.
        :type pack_type: str
        """

        self._pack_type = pack_type

    @property
    def product_number(self) -> str:
        """Gets the product_number of this ProductCommon.

        제품번호  # noqa: E501

        :return: The product_number of this ProductCommon.
        :rtype: str
        """
        return self._product_number

    @product_number.setter
    def product_number(self, product_number: str):
        """Sets the product_number of this ProductCommon.

        제품번호  # noqa: E501

        :param product_number: The product_number of this ProductCommon.
        :type product_number: str
        """

        self._product_number = product_number

    @property
    def model_name(self) -> str:
        """Gets the model_name of this ProductCommon.

        모델명  # noqa: E501

        :return: The model_name of this ProductCommon.
        :rtype: str
        """
        return self._model_name

    @model_name.setter
    def model_name(self, model_name: str):
        """Sets the model_name of this ProductCommon.

        모델명  # noqa: E501

        :param model_name: The model_name of this ProductCommon.
        :type model_name: str
        """

        self._model_name = model_name

    @property
    def product_unit(self) -> int:
        """Gets the product_unit of this ProductCommon.

        상품 단위 (1.단품 2.번들 3.패키지)  # noqa: E501

        :return: The product_unit of this ProductCommon.
        :rtype: int
        """
        return self._product_unit

    @product_unit.setter
    def product_unit(self, product_unit: int):
        """Sets the product_unit of this ProductCommon.

        상품 단위 (1.단품 2.번들 3.패키지)  # noqa: E501

        :param product_unit: The product_unit of this ProductCommon.
        :type product_unit: int
        """

        self._product_unit = product_unit

    @property
    def product_capacity(self) -> str:
        """Gets the product_capacity of this ProductCommon.

        상품 용량  # noqa: E501

        :return: The product_capacity of this ProductCommon.
        :rtype: str
        """
        return self._product_capacity

    @product_capacity.setter
    def product_capacity(self, product_capacity: str):
        """Sets the product_capacity of this ProductCommon.

        상품 용량  # noqa: E501

        :param product_capacity: The product_capacity of this ProductCommon.
        :type product_capacity: str
        """

        self._product_capacity = product_capacity

    @property
    def product_capacity_unit(self) -> str:
        """Gets the product_capacity_unit of this ProductCommon.

        상품 용량 단위  # noqa: E501

        :return: The product_capacity_unit of this ProductCommon.
        :rtype: str
        """
        return self._product_capacity_unit

    @product_capacity_unit.setter
    def product_capacity_unit(self, product_capacity_unit: str):
        """Sets the product_capacity_unit of this ProductCommon.

        상품 용량 단위  # noqa: E501

        :param product_capacity_unit: The product_capacity_unit of this ProductCommon.
        :type product_capacity_unit: str
        """

        self._product_capacity_unit = product_capacity_unit

    @property
    def is_adult_product(self) -> str:
        """Gets the is_adult_product of this ProductCommon.

        성인용 제품구분  # noqa: E501

        :return: The is_adult_product of this ProductCommon.
        :rtype: str
        """
        return self._is_adult_product

    @is_adult_product.setter
    def is_adult_product(self, is_adult_product: str):
        """Sets the is_adult_product of this ProductCommon.

        성인용 제품구분  # noqa: E501

        :param is_adult_product: The is_adult_product of this ProductCommon.
        :type is_adult_product: str
        """

        self._is_adult_product = is_adult_product

    @property
    def is_child_product(self) -> str:
        """Gets the is_child_product of this ProductCommon.

        어린이용 제품구분  # noqa: E501

        :return: The is_child_product of this ProductCommon.
        :rtype: str
        """
        return self._is_child_product

    @is_child_product.setter
    def is_child_product(self, is_child_product: str):
        """Sets the is_child_product of this ProductCommon.

        어린이용 제품구분  # noqa: E501

        :param is_child_product: The is_child_product of this ProductCommon.
        :type is_child_product: str
        """

        self._is_child_product = is_child_product

    @property
    def create_date(self) -> int:
        """Gets the create_date of this ProductCommon.

        상품 생성일 (unix timestamp)  # noqa: E501

        :return: The create_date of this ProductCommon.
        :rtype: int
        """
        return self._create_date

    @create_date.setter
    def create_date(self, create_date: int):
        """Sets the create_date of this ProductCommon.

        상품 생성일 (unix timestamp)  # noqa: E501

        :param create_date: The create_date of this ProductCommon.
        :type create_date: int
        """

        self._create_date = create_date

    @property
    def update_date(self) -> int:
        """Gets the update_date of this ProductCommon.

        상품 수정일 (unix timestamp)  # noqa: E501

        :return: The update_date of this ProductCommon.
        :rtype: int
        """
        return self._update_date

    @update_date.setter
    def update_date(self, update_date: int):
        """Sets the update_date of this ProductCommon.

        상품 수정일 (unix timestamp)  # noqa: E501

        :param update_date: The update_date of this ProductCommon.
        :type update_date: int
        """

        self._update_date = update_date

    @property
    def seller_code(self) -> str:
        """Gets the seller_code of this ProductCommon.

        상품 판매코드 (온라인 몰 별로 별도 관리되는 코드)  # noqa: E501

        :return: The seller_code of this ProductCommon.
        :rtype: str
        """
        return self._seller_code

    @seller_code.setter
    def seller_code(self, seller_code: str):
        """Sets the seller_code of this ProductCommon.

        상품 판매코드 (온라인 몰 별로 별도 관리되는 코드)  # noqa: E501

        :param seller_code: The seller_code of this ProductCommon.
        :type seller_code: str
        """

        self._seller_code = seller_code

    @property
    def company_address(self) -> str:
        """Gets the company_address of this ProductCommon.

        회사주소  # noqa: E501

        :return: The company_address of this ProductCommon.
        :rtype: str
        """
        return self._company_address

    @company_address.setter
    def company_address(self, company_address: str):
        """Sets the company_address of this ProductCommon.

        회사주소  # noqa: E501

        :param company_address: The company_address of this ProductCommon.
        :type company_address: str
        """

        self._company_address = company_address

    @property
    def phone_number(self) -> str:
        """Gets the phone_number of this ProductCommon.

        대표전화  # noqa: E501

        :return: The phone_number of this ProductCommon.
        :rtype: str
        """
        return self._phone_number

    @phone_number.setter
    def phone_number(self, phone_number: str):
        """Sets the phone_number of this ProductCommon.

        대표전화  # noqa: E501

        :param phone_number: The phone_number of this ProductCommon.
        :type phone_number: str
        """

        self._phone_number = phone_number

    @property
    def child_product_id(self) -> str:
        """Gets the child_product_id of this ProductCommon.

        Child product ID  # noqa: E501

        :return: The child_product_id of this ProductCommon.
        :rtype: str
        """
        return self._child_product_id

    @child_product_id.setter
    def child_product_id(self, child_product_id: str):
        """Sets the child_product_id of this ProductCommon.

        Child product ID  # noqa: E501

        :param child_product_id: The child_product_id of this ProductCommon.
        :type child_product_id: str
        """

        self._child_product_id = child_product_id

    @property
    def is_completed(self) -> bool:
        """Gets the is_completed of this ProductCommon.

        Child product ID  # noqa: E501

        :return: The is_completed of this ProductCommon.
        :rtype: bool
        """
        return self._is_completed

    @is_completed.setter
    def is_completed(self, is_completed: bool):
        """Sets the is_completed of this ProductCommon.

        Child product ID  # noqa: E501

        :param is_completed: The is_completed of this ProductCommon.
        :type is_completed: bool
        """

        self._is_completed = is_completed
