# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from goodlens_product.models.base_model_ import Model
from goodlens_product.models.nutrient_sub1 import NutrientSub1  # noqa: F401,E501
from goodlens_product import util


class Nutrient(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, category: str=None, about: str=None, capacity_1: int=None, unit_1: str=None, capacity_2: int=None, unit_2: str=None, calarorie: int=None, calarorie_unit: str=None, amount: int=None, amount_unit: str=None, nutrients: List[NutrientSub1]=None):  # noqa: E501
        """Nutrient - a model defined in Swagger

        :param category: The category of this Nutrient.  # noqa: E501
        :type category: str
        :param about: The about of this Nutrient.  # noqa: E501
        :type about: str
        :param capacity_1: The capacity_1 of this Nutrient.  # noqa: E501
        :type capacity_1: int
        :param unit_1: The unit_1 of this Nutrient.  # noqa: E501
        :type unit_1: str
        :param capacity_2: The capacity_2 of this Nutrient.  # noqa: E501
        :type capacity_2: int
        :param unit_2: The unit_2 of this Nutrient.  # noqa: E501
        :type unit_2: str
        :param calarorie: The calarorie of this Nutrient.  # noqa: E501
        :type calarorie: int
        :param calarorie_unit: The calarorie_unit of this Nutrient.  # noqa: E501
        :type calarorie_unit: str
        :param amount: The amount of this Nutrient.  # noqa: E501
        :type amount: int
        :param amount_unit: The amount_unit of this Nutrient.  # noqa: E501
        :type amount_unit: str
        :param nutrients: The nutrients of this Nutrient.  # noqa: E501
        :type nutrients: List[NutrientSub1]
        """
        self.swagger_types = {
            'category': str,
            'about': str,
            'capacity_1': int,
            'unit_1': str,
            'capacity_2': int,
            'unit_2': str,
            'calarorie': int,
            'calarorie_unit': str,
            'amount': int,
            'amount_unit': str,
            'nutrients': List[NutrientSub1]
        }

        self.attribute_map = {
            'category': 'category',
            'about': 'about',
            'capacity_1': 'capacity_1',
            'unit_1': 'unit_1',
            'capacity_2': 'capacity_2',
            'unit_2': 'unit_2',
            'calarorie': 'calarorie',
            'calarorie_unit': 'calarorie_unit',
            'amount': 'amount',
            'amount_unit': 'amount_unit',
            'nutrients': 'nutrients'
        }

        self._category = category
        self._about = about
        self._capacity_1 = capacity_1
        self._unit_1 = unit_1
        self._capacity_2 = capacity_2
        self._unit_2 = unit_2
        self._calarorie = calarorie
        self._calarorie_unit = calarorie_unit
        self._amount = amount
        self._amount_unit = amount_unit
        self._nutrients = nutrients

    @classmethod
    def from_dict(cls, dikt) -> 'Nutrient':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Nutrient of this Nutrient.  # noqa: E501
        :rtype: Nutrient
        """
        return util.deserialize_model(dikt, cls)

    @property
    def category(self) -> str:
        """Gets the category of this Nutrient.

        영양성분 분류(단위함량, 1회제공량, 총 내용량, 단위내용량당,일일 제공량,총제공량)  # noqa: E501

        :return: The category of this Nutrient.
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category: str):
        """Sets the category of this Nutrient.

        영양성분 분류(단위함량, 1회제공량, 총 내용량, 단위내용량당,일일 제공량,총제공량)  # noqa: E501

        :param category: The category of this Nutrient.
        :type category: str
        """

        self._category = category

    @property
    def about(self) -> str:
        """Gets the about of this Nutrient.

        약  # noqa: E501

        :return: The about of this Nutrient.
        :rtype: str
        """
        return self._about

    @about.setter
    def about(self, about: str):
        """Sets the about of this Nutrient.

        약  # noqa: E501

        :param about: The about of this Nutrient.
        :type about: str
        """

        self._about = about

    @property
    def capacity_1(self) -> int:
        """Gets the capacity_1 of this Nutrient.

        내용량  # noqa: E501

        :return: The capacity_1 of this Nutrient.
        :rtype: int
        """
        return self._capacity_1

    @capacity_1.setter
    def capacity_1(self, capacity_1: int):
        """Sets the capacity_1 of this Nutrient.

        내용량  # noqa: E501

        :param capacity_1: The capacity_1 of this Nutrient.
        :type capacity_1: int
        """

        self._capacity_1 = capacity_1

    @property
    def unit_1(self) -> str:
        """Gets the unit_1 of this Nutrient.

        단위 (mg이상, g미만 ...)  # noqa: E501

        :return: The unit_1 of this Nutrient.
        :rtype: str
        """
        return self._unit_1

    @unit_1.setter
    def unit_1(self, unit_1: str):
        """Sets the unit_1 of this Nutrient.

        단위 (mg이상, g미만 ...)  # noqa: E501

        :param unit_1: The unit_1 of this Nutrient.
        :type unit_1: str
        """

        self._unit_1 = unit_1

    @property
    def capacity_2(self) -> int:
        """Gets the capacity_2 of this Nutrient.

        내용량  # noqa: E501

        :return: The capacity_2 of this Nutrient.
        :rtype: int
        """
        return self._capacity_2

    @capacity_2.setter
    def capacity_2(self, capacity_2: int):
        """Sets the capacity_2 of this Nutrient.

        내용량  # noqa: E501

        :param capacity_2: The capacity_2 of this Nutrient.
        :type capacity_2: int
        """

        self._capacity_2 = capacity_2

    @property
    def unit_2(self) -> str:
        """Gets the unit_2 of this Nutrient.

        단위 (mg이상, g미만 ...)  # noqa: E501

        :return: The unit_2 of this Nutrient.
        :rtype: str
        """
        return self._unit_2

    @unit_2.setter
    def unit_2(self, unit_2: str):
        """Sets the unit_2 of this Nutrient.

        단위 (mg이상, g미만 ...)  # noqa: E501

        :param unit_2: The unit_2 of this Nutrient.
        :type unit_2: str
        """

        self._unit_2 = unit_2

    @property
    def calarorie(self) -> int:
        """Gets the calarorie of this Nutrient.

        칼로리  # noqa: E501

        :return: The calarorie of this Nutrient.
        :rtype: int
        """
        return self._calarorie

    @calarorie.setter
    def calarorie(self, calarorie: int):
        """Sets the calarorie of this Nutrient.

        칼로리  # noqa: E501

        :param calarorie: The calarorie of this Nutrient.
        :type calarorie: int
        """

        self._calarorie = calarorie

    @property
    def calarorie_unit(self) -> str:
        """Gets the calarorie_unit of this Nutrient.

        칼로리 단위(cal, kcal, ...)  # noqa: E501

        :return: The calarorie_unit of this Nutrient.
        :rtype: str
        """
        return self._calarorie_unit

    @calarorie_unit.setter
    def calarorie_unit(self, calarorie_unit: str):
        """Sets the calarorie_unit of this Nutrient.

        칼로리 단위(cal, kcal, ...)  # noqa: E501

        :param calarorie_unit: The calarorie_unit of this Nutrient.
        :type calarorie_unit: str
        """

        self._calarorie_unit = calarorie_unit

    @property
    def amount(self) -> int:
        """Gets the amount of this Nutrient.

        함유량  # noqa: E501

        :return: The amount of this Nutrient.
        :rtype: int
        """
        return self._amount

    @amount.setter
    def amount(self, amount: int):
        """Sets the amount of this Nutrient.

        함유량  # noqa: E501

        :param amount: The amount of this Nutrient.
        :type amount: int
        """

        self._amount = amount

    @property
    def amount_unit(self) -> str:
        """Gets the amount_unit of this Nutrient.

        함유량 단위(g, kg, ...)  # noqa: E501

        :return: The amount_unit of this Nutrient.
        :rtype: str
        """
        return self._amount_unit

    @amount_unit.setter
    def amount_unit(self, amount_unit: str):
        """Sets the amount_unit of this Nutrient.

        함유량 단위(g, kg, ...)  # noqa: E501

        :param amount_unit: The amount_unit of this Nutrient.
        :type amount_unit: str
        """

        self._amount_unit = amount_unit

    @property
    def nutrients(self) -> List[NutrientSub1]:
        """Gets the nutrients of this Nutrient.


        :return: The nutrients of this Nutrient.
        :rtype: List[NutrientSub1]
        """
        return self._nutrients

    @nutrients.setter
    def nutrients(self, nutrients: List[NutrientSub1]):
        """Sets the nutrients of this Nutrient.


        :param nutrients: The nutrients of this Nutrient.
        :type nutrients: List[NutrientSub1]
        """

        self._nutrients = nutrients
