# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['detextify']

package_data = \
{'': ['*'], 'detextify': ['config/*']}

install_requires = \
['absl-py>=1.3.0,<2.0.0',
 'accelerate>=0.15.0,<0.16.0',
 'azure-cognitiveservices-vision-computervision>=0.9.0,<0.10.0',
 'diffusers>=0.10.2,<0.11.0',
 'numpy>=1.23.5,<2.0.0',
 'openai>=0.25.0,<0.26.0',
 'paddleocr>=2.6.1.1,<3.0.0.0',
 'pillow>=9.3.0,<10.0.0',
 'replicate>=0.4.0,<0.5.0',
 'requests>=2.28.1,<3.0.0',
 'torch>=1.13.0,<2.0.0',
 'transformers>=4.25.1,<5.0.0']

setup_kwargs = {
    'name': 'detextify',
    'version': '0.1.2',
    'description': '',
    'long_description': '# Detextify\n\n## What is this?\n\n**TL;DR**: A Python library to remove unwanted pseudo-text from images generated by your favorite generative AI models (Stable Diffusion, Midjourney, DALL·E).\n\n| Before                      | After                                  |\n|-----------------------------|----------------------------------------|\n| ![before](data/octopus.png) | ![after](data/octopus_detextified.png) |\n\n## So, why should I care?\n\nWe all know generative AI is the coolest thing since sliced bread 🍞.\n\nBut try using any off-the-shelf generative vision model and you\'ll quickly see that these systems can get...creative with interpreting\nyour prompts.\n\nSpecifically, you\'ll observe all kinds of weird artifacts on your images from extra fingers on hands, to arms coming out of chests,\nto alien text written in random places.\n\nFor generative systems to actually be usable in downstream applications, we need to better control these outputs\nand mitigate unwanted effects.\n\nWe believe the next frontier for generative AI is about **robustness** and **trust**. In other words, how can we architect\nthese systems to be controllable, relevant, and predictably consistent with our needs?\n\n`Detextify` is the first phase in our vision of robustifying generative AI.\n\nIf we get this right, we will unlock slews of new applications for generative systems that will change the landscape of human-AI collaboration. 🌎\n\n## Cute, but what are you actually doing?\n\n`Detextify` runs text detection on your image, masks the text boxes, and in-paints the masked regions\nuntil your image is text-free. `Detextify` can be run entirely on your local machine (using\n[Paddle](https://github.com/PaddlePaddle/PaddleOCR) for text detection and\n[Stable Diffusion](https://huggingface.co/stabilityai/stable-diffusion-2-inpainting) for in-painting), or can call existing APIs\n([Azure](https://azure.microsoft.com/en-us/products/cognitive-services/computer-vision/) for text detection and\n[OpenAI](https://openai.com/dall-e-2/) or [Replicate](https://replicate.com/) for in-painting).\n\n## Installation\n```commandline\npip install detextify\n```\n\n## Usage\n\nYou can remove unwanted text from your image in just 4 lines 💪:\n```python\nfrom detextify.paddle_text_detector import PaddleTextDetector\nfrom detextify.sd_local_inpainter import DiffusersSDInpainter\n\ndetextifier = Detextifier(PaddleTextDetector(), DiffusersSDInpainter())\ndetextifier.detextify("/my/input/image/path.png", "/my/output/image/path.png")\n```\n\nand 💣💥, just like that, your image is cleared of any bizarre text artifacts.\n\nOr if you want to clean up a directory of PNG images, just wrap it in a for-loop:\n```python\nimport glob\nfrom detextify.paddle_text_detector import PaddleTextDetector\nfrom detextify.sd_local_inpainter import DiffusersSDInpainter\n\ndetextifier = Detextifier(PaddleTextDetector(), DiffusersSDInpainter())\nfor img_file in glob.glob("/path/to/dir/*.png"):\n    detextifier.detextify(img_file, img_file.replace(".png", "_detextified.png")\n```\n\n\nWe provide multiple implementations for text detection and in-painting (both local and API-based), and you are also free to add your own.\n\n### Text Detectors\n1. `PaddleTextDetector` (based on [PaddleOCR](https://github.com/PaddlePaddle/PaddleOCR)) runs locally.\n2. `AzureTextDetector` calls a computer vision API from Microsoft Azure. You will first need to create a\n[Computer Vision resource](https://portal.azure.com/#create/Microsoft.CognitiveServicesComputerVision) via the Azure\nportal. Once created, take note of the endpoint and the key.\n```python\nAZURE_CV_ENDPOINT = "https://your-endpoint.cognitiveservices.azure.com"\nAZURE_CV_KEY = "your-azure-key"\ntext_detector = AzureTextDetector(AZURE_CV_ENDPOINT, AZURE_CV_KEY)\n```\nOur evaluation shows that the two text detectors produce comparable results.\n\n### In-painters\n1. `DiffusersSDInpainter` (implemented via Huggingface\'s `diffusers` library) runs locally. Defaults to\n[Stable Diffusion v2 for in-painting](https://huggingface.co/stabilityai/stable-diffusion-2-inpainting).\n2. `ReplicateInpainter` calls the [Replicate](https://replicate.com) API. Defaults to Stable Diffusion v2 for\nin-painting (and requires  a key).\n3. `DalleInpainter` calls the [DALL·E 2](https://labs.openai.com) API from OpenAI (and requires an API key).\n```python\n# You only need to instantiate one of the following:\nlocal_inpainter = DiffusersSDInpainter()\nreplicate_inpainter = ReplicateInpainter("your-replicate-key")\ndalle_inpainter = DalleInpainter("your-openai-key")\n```\n\n## Contributing\nTo contribute, clone the repository, make your changes, commit and push to your clone, and submit a pull request.\n\nTo build the library, you need to install [poetry](https://python-poetry.org/):\n```commandline\ncurl -sSL https://install.python-poetry.org | python3 -\n# Add poetry to your PATH. Note the specific path will differ depending on your system.\nexport PATH="/home/ubuntu/.local/bin:$PATH"\n# Check the installation was successful:\npoetry --version\n```\nInstall dependencies for `detextify`:\n```commandline\npoetry install\n```\nTo execute a script, run:\n```commandline\npoetry run python your_script.py\n```\nPlease run the unit tests to make sure that your changes are not breaking the codebase:\n```commandline\npoetry run pytest\n```\n\n## Authors\nThis project was authored by [Mihail Eric](https://twitter.com/mihail_eric) and [Julia Turc](https://twitter.com/juliarturc). If you are building in the generative AI space, we want to hear from you!\n',
    'author': 'Julia',
    'author_email': 'turc.raluca@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
