"use strict";
const nodeunit_1 = require("nodeunit");
const lib_1 = require("../lib");
const lambda = require("../lib");
module.exports = nodeunit_1.testCase({
    'runtimes are equal for different instances'(test) {
        // GIVEN
        const runtime1 = new lambda.Runtime('python3.7', lib_1.RuntimeFamily.Python, { supportsInlineCode: true });
        const runtime2 = new lambda.Runtime('python3.7', lib_1.RuntimeFamily.Python, { supportsInlineCode: true });
        // WHEN
        const result = runtime1.runtimeEquals(runtime2);
        // THEN
        test.strictEqual(result, true, 'Runtimes should be equal');
        test.done();
    },
    'runtimes are equal for same instance'(test) {
        // GIVEN
        const runtime = new lambda.Runtime('python3.7', lib_1.RuntimeFamily.Python, { supportsInlineCode: true });
        // WHEN
        const result = runtime.runtimeEquals(runtime);
        // THEN
        test.strictEqual(result, true, 'Runtimes should be equal');
        test.done();
    },
    'unequal when name changes'(test) {
        // GIVEN
        const runtime1 = new lambda.Runtime('python3.7', lib_1.RuntimeFamily.Python, { supportsInlineCode: true });
        const runtime2 = new lambda.Runtime('python3.6', lib_1.RuntimeFamily.Python, { supportsInlineCode: true });
        // WHEN
        const result = runtime1.runtimeEquals(runtime2);
        // THEN
        test.strictEqual(result, false, 'Runtimes should be unequal when name changes');
        test.done();
    },
    'unequal when family changes'(test) {
        // GIVEN
        const runtime1 = new lambda.Runtime('python3.7', lib_1.RuntimeFamily.Python, { supportsInlineCode: true });
        const runtime2 = new lambda.Runtime('python3.7', lib_1.RuntimeFamily.Java, { supportsInlineCode: true });
        // WHEN
        const result = runtime1.runtimeEquals(runtime2);
        // THEN
        test.strictEqual(result, false, 'Runtimes should be unequal when family changes');
        test.done();
    },
    'unequal when supportsInlineCode changes'(test) {
        // GIVEN
        const runtime1 = new lambda.Runtime('python3.7', lib_1.RuntimeFamily.Python, { supportsInlineCode: true });
        const runtime2 = new lambda.Runtime('python3.7', lib_1.RuntimeFamily.Python, { supportsInlineCode: false });
        // WHEN
        const result = runtime1.runtimeEquals(runtime2);
        // THEN
        test.strictEqual(result, false, 'Runtimes should be unequal when supportsInlineCode changes');
        test.done();
    },
});
//# sourceMappingURL=data:application/json;base64,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