export interface LambdaRuntimeProps {
    /**
     * Whether the ``ZipFile`` (aka inline code) property can be used with this runtime.
     * @default false
     */
    readonly supportsInlineCode?: boolean;
}
export declare enum RuntimeFamily {
    NodeJS = 0,
    Java = 1,
    Python = 2,
    DotNetCore = 3,
    Go = 4,
    Ruby = 5,
    Other = 6
}
/**
 * Lambda function runtime environment.
 *
 * If you need to use a runtime name that doesn't exist as a static member, you
 * can instantiate a `Runtime` object, e.g: `new Runtime('nodejs99.99')`.
 */
export declare class Runtime {
    /** A list of all known `Runtime`'s. */
    static readonly All: Runtime[];
    /** @deprecated Use `NodeJS810` or `NodeJS10x` */
    static readonly NodeJS: Runtime;
    /** @deprecated Use `NodeJS810` or `NodeJS10x` */
    static readonly NodeJS43: Runtime;
    /** @deprecated Use `NodeJS810` or `NodeJS10x` */
    static readonly NodeJS610: Runtime;
    static readonly NodeJS810: Runtime;
    static readonly NodeJS10x: Runtime;
    static readonly Python27: Runtime;
    static readonly Python36: Runtime;
    static readonly Python37: Runtime;
    static readonly Java8: Runtime;
    static readonly DotNetCore1: Runtime;
    /** @deprecated Use `DotNetCore21` */
    static readonly DotNetCore2: Runtime;
    static readonly DotNetCore21: Runtime;
    static readonly Go1x: Runtime;
    static readonly Ruby25: Runtime;
    static readonly Provided: Runtime;
    /**
     * The name of this runtime, as expected by the Lambda resource.
     */
    readonly name: string;
    /**
     * Whether the ``ZipFile`` (aka inline code) property can be used with this
     * runtime.
     */
    readonly supportsInlineCode: boolean;
    /**
     * The runtime family.
     */
    readonly family?: RuntimeFamily;
    constructor(name: string, family?: RuntimeFamily, props?: LambdaRuntimeProps);
    toString(): string;
    runtimeEquals(other: Runtime): boolean;
}
