import logs = require('@aws-cdk/aws-logs');
import cdk = require('@aws-cdk/cdk');
/**
 * Construction properties for a LogRetention.
 */
export interface LogRetentionProps {
    /**
     * The log group name.
     */
    readonly logGroupName: string;
    /**
     * The number of days log events are kept in CloudWatch Logs.
     */
    readonly retentionDays: logs.RetentionDays;
}
/**
 * Creates a custom resource to control the retention policy of a CloudWatch Logs
 * log group. The log group is created if it doesn't already exist. The policy
 * is removed when `retentionDays` is `undefined` or equal to `Infinity`.
 */
export declare class LogRetention extends cdk.Construct {
    constructor(scope: cdk.Construct, id: string, props: LogRetentionProps);
}
