"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk_1 = require("@aws-cdk/cdk");
const lambda_generated_1 = require("./lambda.generated");
/**
 * Defines a Lambda EventSourceMapping resource.
 *
 * Usually, you won't need to define the mapping yourself. This will usually be done by
 * event sources. For example, to add an SQS event source to a function:
 *
 *    import { SqsEventSource } from '@aws-cdk/aws-lambda-event-sources';
 *    lambda.addEventSource(new SqsEventSource(sqs));
 *
 * The `SqsEventSource` class will automatically create the mapping, and will also
 * modify the Lambda's execution role so it can consume messages from the queue.
 */
class EventSourceMapping extends cdk_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        new lambda_generated_1.CfnEventSourceMapping(this, 'Resource', {
            batchSize: props.batchSize,
            enabled: props.enabled,
            eventSourceArn: props.eventSourceArn,
            functionName: props.target.functionName,
            startingPosition: props.startingPosition,
        });
    }
}
exports.EventSourceMapping = EventSourceMapping;
/**
 * The position in the DynamoDB or Kinesis stream where AWS Lambda should start
 * reading.
 */
var StartingPosition;
(function (StartingPosition) {
    /**
     * Start reading at the last untrimmed record in the shard in the system,
     * which is the oldest data record in the shard.
     */
    StartingPosition["TrimHorizon"] = "TRIM_HORIZON";
    /**
     * Start reading just after the most recent record in the shard, so that you
     * always read the most recent data in the shard
     */
    StartingPosition["Latest"] = "LATEST";
})(StartingPosition = exports.StartingPosition || (exports.StartingPosition = {}));
//# sourceMappingURL=data:application/json;base64,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