"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTest = exports.IntegTestCaseStack = exports.IntegTestCase = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloud_assembly_schema_1 = require("aws-cdk-lib/cloud-assembly-schema");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const deploy_assert_1 = require("./assertions/private/deploy-assert");
const manifest_synthesizer_1 = require("./manifest-synthesizer");
const TEST_CASE_STACK_SYMBOL = Symbol.for('@aws-cdk/integ-tests.IntegTestCaseStack');
/**
 * An integration test case. Allows the definition of test properties that
 * apply to all stacks under this case.
 *
 * It is recommended that you use the IntegTest construct since that will create
 * a default IntegTestCase
 */
class IntegTestCase extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestCaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTestCase);
            }
            throw error;
        }
        this._assert = new deploy_assert_1.DeployAssert(this);
        this.assertions = this._assert;
    }
    /**
     * The integration test manifest for this test case. Manifests are used
     * by the integration test runner.
     */
    get manifest() {
        return {
            version: cloud_assembly_schema_1.Manifest.version(),
            testCases: { [this.node.path]: this.toTestCase(this.props) },
        };
    }
    toTestCase(props) {
        return {
            ...props,
            assertionStack: this._assert.scope.artifactId,
            stacks: props.stacks.map(s => s.artifactId),
        };
    }
}
exports.IntegTestCase = IntegTestCase;
_a = JSII_RTTI_SYMBOL_1;
IntegTestCase[_a] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTestCase", version: "2.34.1-alpha.0" };
/**
 * An integration test case stack. Allows the definition of test properties
 * that should apply to this stack.
 *
 * This should be used if there are multiple stacks in the integration test
 * and it is necessary to specify different test case option for each. Otherwise
 * normal stacks should be added to IntegTest
 */
class IntegTestCaseStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestCaseStackProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTestCaseStack);
            }
            throw error;
        }
        Object.defineProperty(this, TEST_CASE_STACK_SYMBOL, { value: true });
        // TODO: should we only have a single DeployAssert per test?
        this.assertions = new deploy_assert_1.DeployAssert(this);
        this._testCase = new IntegTestCase(this, `${id}TestCase`, {
            ...props,
            stacks: [this],
        });
    }
    /**
     * Returns whether the construct is a IntegTestCaseStack
     */
    static isIntegTestCaseStack(x) {
        return x !== null && typeof (x) === 'object' && TEST_CASE_STACK_SYMBOL in x;
    }
}
exports.IntegTestCaseStack = IntegTestCaseStack;
_b = JSII_RTTI_SYMBOL_1;
IntegTestCaseStack[_b] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTestCaseStack", version: "2.34.1-alpha.0" };
/**
 * A collection of test cases. Each test case file should contain exactly one
 * instance of this class.
 */
class IntegTest extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTest);
            }
            throw error;
        }
        const defaultTestCase = new IntegTestCase(this, 'DefaultTest', {
            stacks: props.testCases.filter(stack => !IntegTestCaseStack.isIntegTestCaseStack(stack)),
            hooks: props.hooks,
            regions: props.regions,
            diffAssets: props.diffAssets,
            allowDestroy: props.allowDestroy,
            cdkCommandOptions: props.cdkCommandOptions,
            stackUpdateWorkflow: props.stackUpdateWorkflow,
        });
        this.assertions = defaultTestCase.assertions;
        this.testCases = [
            defaultTestCase,
            ...props.testCases
                .filter(stack => IntegTestCaseStack.isIntegTestCaseStack(stack))
                .map(stack => stack._testCase),
        ];
        this.node.addValidation({
            validate: () => {
                aws_cdk_lib_1.attachCustomSynthesis(this, {
                    onSynthesize: (session) => {
                        const synthesizer = new manifest_synthesizer_1.IntegManifestSynthesizer(this.testCases);
                        synthesizer.synthesize(session);
                    },
                });
                return [];
            },
        });
    }
}
exports.IntegTest = IntegTest;
_c = JSII_RTTI_SYMBOL_1;
IntegTest[_c] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTest", version: "2.34.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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