import { CustomResourceHandler } from './base';
import { AwsApiCallRequest, AwsApiCallResult } from './types';
/**
 * Flattens a nested object
 *
 * @param object the object to be flattened
 * @returns a flat object with path as keys
 */
export declare function flatten(object: object): {
    [key: string]: any;
};
export declare class AwsApiCallHandler extends CustomResourceHandler<AwsApiCallRequest, AwsApiCallResult | {
    [key: string]: string;
}> {
    protected processEvent(request: AwsApiCallRequest): Promise<AwsApiCallResult | {
        [key: string]: string;
    } | undefined>;
}
