# generated by datamodel-codegen:
#   filename:  Interaction.json
#   timestamp: 2023-03-09T18:29:06+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Field


class Interaction(BaseModel):
    id: str = Field(..., description='Unqiue BFI source record.')
    CreatedAtTime: str = Field(..., description='UTC of time created')
    SFA_BFI_version: str = Field(..., description='Database version')
    Bacterial_associate_taxa: str = Field(
        ..., description='Bacterial partner in BFI at lowest identified taxonomic level'
    )
    Fungal_host_taxa: str = Field(
        ..., description='Fungal partner in BFI at lowest identified taxonomic level'
    )
    Found_in_16S_CC: Optional[str] = Field(
        None, description='Found in 16S ribosomal RNA data'
    )
    Found_in_BSS: Optional[str] = Field(
        None, description='Found in Bacterial Specific Sequences'
    )
    Found_in_previous_work: Optional[str] = Field(
        None, description='Has relational been described in other work'
    )
    Link: str = Field(..., description='Url for literature source')
    Source: str = Field(..., description='Name literature source')
    Notes: Optional[str] = Field(None, description='Miscellaneous notes')
    
    
class Taxonomy(BaseModel):
    Bacterial_associate_taxa: str = Field(
        ..., description='Bacterial partner in BFI source informing taxonomy'
    )
    Fungal_host_taxa: str = Field(
        ..., description='Fungal partner in BFI source informing taxonomy'
    )
    Informed_by: str = Field(..., description='BFI source used to generate taxonomy')
    Superkingdom: str = Field(..., description='Superkingdom taxonomic rank')
    Phylum: str = Field(..., description='Phylum taxonomic rank')
    Class: str = Field(..., description='Class taxonomic rank')
    Order: str = Field(..., description='Order taxonomic rank')
    Family: str = Field(..., description='Family taxonomic rank')
    Genus: str = Field(..., description='Genus taxonomic rank')
