# Host: 	    Database: 	    Date: 
# ---------------------------------------------------------
#

DROP TABLE IF EXISTS italian_index;
CREATE TABLE italian_index (lemma VARCHAR(255)  NOT NULL PRIMARY KEY,id_n TEXT,id_v TEXT,id_a TEXT,id_r TEXT);

INSERT INTO italian_index VALUES ('intuito','n#04545382 n#04409766 n#04410094 n#04353391 n#03831455',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intuizione','n#04545382 n#04409766 n#04412116 n#05592156',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sospetto','n#04545382 n#04529589 n#07625454',NULL,'a#01847441',NULL);
INSERT INTO italian_index VALUES ('celibato','n#10062925 n#10063146',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scapolaggine','n#10062925',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pietra','n#03419235 n#02463102 n#10534851 n#06669293',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affigliazione','n#00700508',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affiliazione','n#00700508 n#10037776',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disinfestante','n#10749669',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pesticida','n#10749669',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ombrosità','n#03649525 n#05615021 n#10074305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('centrino','n#02586703',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polygonia_comma','n#01780782',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colaggio','n#05532335',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fuga','n#05532335 n#03439283 n#05281448 n#00032687',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fuoriuscita','n#05532335 n#05529123',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fuoruscita','n#05532335 n#05529123',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perdita','n#05532335 n#04022310 n#00039700 n#09594954 n#09595129 n#09731736 n#10077974',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inconvertibilità','n#03722799',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('plesso','n#04066344',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('passeggero_clandestino','n#07614031',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catrame_minerale','n#10700500',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bustina_di_tè','n#05951959 n#03474857',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marciume','n#04206730 n#09734649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('materia','n#04206730 n#04950638 n#00010572 n#04594727 n#05051824 n#10446867',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pus','n#04206730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('studio','n#04438520 n#05284976 n#03434290 n#03434704 n#03433996 n#05391713 n#W0021137 n#03343837 n#W0021138 n#00421016',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('controllo','n#03824809 n#00092823 n#09959274 n#00735967 n#00092615 n#10361817 n#00564770 n#00692004 n#00532423 n#00513665 n#04045365 n#00419850 n#04363387',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corazza','n#02532134 n#02210404 n#01418986',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('porto','n#06362245 n#06361328 n#05924143',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catecù','n#08068433 n#08068190 n#09247787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stratificazione','n#09690534 n#00654032',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('t.i.r.','n#N0002187',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trasporti_internazionali_su_strada','n#N0002187',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('egizio','n#N0000631',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accordo','n#05140872 n#05367418 n#04466733 n#05072418 n#03708023 n#10065762 n#09936000',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('proscenio','n#03179858 n#03180044',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbassalingua','n#03516664',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spatola','n#03516664 n#03377293 n#03191738 n#01518578 n#03080765 n#01518908',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bitume','n#10700221',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colina','n#10624637',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caseina','n#10563574',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('isolamento','n#10343430 n#10343201 n#00778860 n#00529661 n#10343743 n#10343521',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dilatazione','n#00235473',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cipriota','n#07012113',NULL,'a#02808671',NULL);
INSERT INTO italian_index VALUES ('cipriotto','n#07012113',NULL,'a#02808671',NULL);
INSERT INTO italian_index VALUES ('giochi_olimpici','n#05543514',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('olimpiadi','n#05543514 n#00332755',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('olimpiade','n#05543514 n#10918142 n#00332755',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('metatarso','n#04335147',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('batteriologia','n#04625527',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('laico','n#07366529',NULL,'a#01979311',NULL);
INSERT INTO italian_index VALUES ('profano','n#07366529',NULL,'a#01979020',NULL);
INSERT INTO italian_index VALUES ('britannico','n#07013224 n#07004282',NULL,'a#02778599',NULL);
INSERT INTO italian_index VALUES ('pendolo','n#03103907 n#03104153',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forma','n#04753063 n#03952527 n#05306507 n#10430604 n#03008954 n#03856995 n#03685812 n#04554317 n#03857781 n#00015185 n#03683012 n#04048073',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decantazione','n#00162229',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('depurazione','n#00162229 n#09745908',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('epurazione','n#00162229',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('purificazione','n#00162229',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accoltellatore','n#07604678',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pugnalatore','n#07604678',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ranunculus_bulbosus','n#08032343',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ranuncolo_bulboso','n#08032343',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apribottiglie','n#02319401',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('levacapsule','n#02319401',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sturabottiglie','n#02319401 n#02501723',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('appezzamento','n#06385581 n#06384327',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lotto','n#06385581 n#00327464 n#06385742 n#05996779',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orticello','n#06385581',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('terreno','n#06385581 n#10647622 n#10649338 n#06668569',NULL,'a#01131706 a#01130973',NULL);
INSERT INTO italian_index VALUES ('dracunculus_vulgaris','n#08099505',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dragontea','n#08099505',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erba_serpentaria','n#08099505',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mola','n#02772567 n#03000331 n#02772417 n#02146268',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avventore','n#07197309',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cliente','n#07197309 n#07461272 n#10036540 n#03042473 n#07462605 n#07304921 n#07197725',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('committente','n#07197309',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('italsider','n#N0002524',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('precipitazione','n#07825204',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falco_tinnunculus','n#01134118',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gheppio','n#01134118',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('semitono','n#05131715',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('settetto','n#05279989',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calcio_di_punizione','n#00089520',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tempo','n#04776611 n#10952869 n#07847974 n#10969191 n#05283408 n#10960792 n#10851114 n#00015594 n#10850008 n#10850147 n#10861803 n#03900085 n#03939250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crochet','n#02521149 n#02521012 n#00088090',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('uncinetto','n#02521149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('primo_motore','n#06860910',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('competenza','n#04362799 n#06334762 n#04014700 n#10411732 n#04046299',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fico_d''india','n#05804358 n#08161670',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('consolato','n#02489638 n#00388876',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('hippobosca_equina','n#01703182',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assillo','n#01703182 n#01697367 n#04491326 n#01699884',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marito_e_moglie','n#05985550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marcialonga','n#N0001130 n#N0001131',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foie-gras','n#05887227',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ente','n#05972379 n#06002286',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dualista','n#07230496',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('consegna','n#00205135 n#00205632',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('distribuzione','n#00205135 n#04611872 n#00701814 n#00701398 n#03970012 n#00721822',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('destra','n#04311787 n#06354766 n#06224017',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dritta','n#04311787 n#03402811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diritta','n#04311787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teologo','n#07639112',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('circolo_di_canottaggio','n#06110046',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corona','n#09844863 n#04119749 n#W0003021 n#W0003007 n#09844181 n#05152096 n#02525897 n#09845273 n#W0003013 n#09845504 n#02526040 n#04345229 n#03634464 n#09995724 n#W0003012 n#09844529 n#W0003005',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corona_svedese','n#09844863',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pasteurizzazione','n#00163002',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pastorizzazione','n#00163002',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gap!','n#00429326 n#07511394 n#03242031 n#02700778 n#06673713 n#02747956 n#05697754 n#02443613 n#03748312 n#03143584 n#00510953 n#10666737 n#10873037 n#07233225 n#02551563 n#07116336 n#03617888 n#03000592 n#10872420 n#07422194 n#07226995 n#03123666 n#05148100 n#05648124 n#03381748 n#00456812 n#07169157 n#04529867 n#07253418 n#06124720 n#03043330 n#09761564 n#00568642 n#04871173 n#10728051 n#03476849 n#03833567 n#02272434 n#07454380 n#06079857 n#06146806 n#W0003176 n#03729592 n#09532982 n#10641738 n#04863754 n#07503181 n#02881706 n#01143565 n#07349630 n#00187997 n#04788423 n#09756361 n#02545484 n#04961724 n#00081676 n#00692824 n#00593978 n#07541894 n#06368228 n#03305459 n#03651222 n#03474591 n#03510793 n#07501217 n#07655239 n#03357011 n#10437891 n#07835897 n#01419582 n#02867844 n#04316506 n#07122828 n#03333645 n#03559646 n#00203046 n#07224440 n#07135735 n#07551158 n#07207737 n#03235693 n#03108136 n#03589025 n#05454384 n#07340383 n#03306046 n#09934755 n#10735031 n#05971736 n#03360643 n#07121607 n#02738607 n#03627727 n#10580559 n#02803054 n#10864999 n#10884851 n#00578215 n#07570581 n#05591681 n#05539530 n#07799104 n#04733758 n#09645305 n#03140692 n#03398024 n#02175434 n#06737304 n#10871018 n#07481333 n#05907474 n#06131059 n#07191871 n#10584467 n#06298782 n#09556039 n#04361663 n#03291074 n#10644212 n#03078829 n#03553342 n#03900814 n#07642775 n#00372660 n#03040638 n#04923314 n#06196890 n#10834399 n#04733173 n#07404949 n#03865164 n#05227993 n#06281500 n#07490425 n#04790511 n#07582997 n#05914878 n#00196842 n#00389587 n#04915505 n#01631497 n#00795609 n#08988415 n#02608526 n#05420551 n#04994834 n#06144973 n#09644874 n#02775268 n#03900917 n#02696877 n#02971195 n#03502438 n#03757151 n#05658400 n#09596388 n#07490313 n#00862484 n#07632847 n#05297596 n#05645340 n#04326943 n#07116838 n#07223830 n#07609811 n#10259234 n#07345139 n#03612987 n#02904887 n#05491865 n#02852822 n#02518771 n#05554755 n#10956411 n#06329985 n#03584553 n#10847752 n#02590174 n#03537773 n#03535839 n#00460568 n#03419889 n#03110746 n#00098455 n#03985689 n#02972769 n#06299666 n#04957427 n#09632470 n#07447672 n#07274625 n#06324781 n#03156805 n#02806196 n#05077312 n#02336254 n#02615969 n#03473154 n#10600687 n#01901161 n#10872830 n#09753519 n#03280022 n#02795523 n#03246805 n#07501987 n#07651358 n#10023851 n#07192544 n#03248431 n#07621580 n#07806153 n#05760503 n#07683432 n#02817881 n#02585929 n#10653968 n#07528001 n#07614516 n#07340548 n#02510690 n#03242312 n#04705323 n#03062837 n#07246940 n#05506175 n#00564117 n#W0005150 n#04837266 n#02441970 n#07408053 n#00127808 n#02275395 n#03742195 n#05435797 n#03196618 n#02276393 n#05524229 n#00295753 n#02225620 n#02463355 n#07781988 n#03121868 n#07620861 n#04361865 n#03621492 n#02108100 n#03868829 n#05971030 n#02483854 n#06688438 n#07534898 n#10872217 n#03846555 n#07199464 n#02615543 n#02780719 n#04557136 n#00759289 n#06729317 n#03627495 n#07609556 n#01884415 n#07475895 n#04432104 n#05342822 n#07481502 n#09417961 n#03330562 n#02291522 n#02533187 n#03475177 n#03819176 n#10937467 n#06941930 n#05921146 n#05501041 n#00043525 n#03856323 n#02332438 n#06724550 n#05081875 n#05300195 n#01419502 n#02882071 n#07347377 n#02269893 n#02934909 n#05902785 n#05154515 n#07164345 n#02881977 n#03273325 n#04838475 n#00987330 n#03898442 n#10639759 n#00867773 n#06306025 n#02456563 n#07007046 n#03830557 n#04362463 n#09648324 n#05664665 n#06297658 n#05971313 n#07264217 n#07255726 n#06301697 n#02672126 n#00427357 n#02471529 n#03017301 n#07492668 n#02448893 n#07121022 n#06219461 n#04876008 n#07452061 n#03439392 n#03629860 n#06388937 n#06234121 n#00713727 n#03007004 n#03536130 n#09578762 n#10814727 n#02692595 n#06281164 n#04539420 n#06282291 n#00589685 n#02253457 n#07455180 n#02246929 n#07488464 n#10884626 n#07570782 n#04472378 n#00546835 n#02511316 n#02398214 n#02613924 n#04815996 n#06272257 n#03590317 n#05790260 n#00785836 n#10416053 n#10934591 n#07527357 n#00189566 n#02847293 n#03133269 n#05037544 n#01363789 n#01312362 n#07055586 n#07392506 n#03628628 n#07489875 n#10873244 n#02334771 n#05865259 n#03026835 n#07488657 n#06343158 n#07693133 n#00012865 n#04959737 n#03623779 n#03157166 n#10957062 n#02940655 n#05930335 n#07603925 n#07515631 n#03041109 n#02654218 n#01884918 n#09923216 n#03837032 n#07281544 n#02284638 n#03598971 n#07586118 n#07086242 n#03886999 n#03260429 n#04082888 n#02517175 n#02212622 n#01935692 n#04361076 n#00332459 n#00040844 n#05507016 n#02265507 n#10124787 n#05743508 n#00577166 n#05990160 n#05407591 n#10873327 n#02498082 n#10618594 n#06729447 n#02847709 n#02314279 n#05359029 n#10872623 n#10871788 n#07835667 n#05881817 n#06129268 n#07463699 n#00427523 n#02823877 n#00587845 n#10381983 n#01258383 n#03125221 n#01414330 n#00474548 n#02521912 n#03590100 n#06331609 n#06014796 n#02829967 n#10657607 n#10424695 n#02760870 n#03053065 n#09789858 n#00185578 n#07388062 n#03474857 n#03585705 n#04836507 n#10836882 n#09296551 n#04835171 n#07405068 n#10872013 n#04982330 n#02431092 n#07291290 n#05715830 n#05363761 n#07671442 n#07093842 n#05934758 n#02846976 n#03035094 n#07397123 n#03430552 n#06236649 n#04883463 n#06130310 n#07016665 n#10386276 n#01960281 n#03022224 n#07421559 n#03084782 n#04009415 n#00127649 n#05393587 n#02305127 n#02711610 n#03600463 n#06197742 n#03547589 n#04947338 n#05955009 n#07644157 n#04013842 n#W0003175 n#05820214 n#00220668 n#01637313 n#07553642 n#02655469 n#03348436 n#02859006 n#04833947 n#07570678 n#02938670 n#03600914 n#00862617 n#09631620 n#02960001 n#00636658 n#05555560 n#04596907 n#00286691 n#07233744 n#05629849 n#03306765 n#07192927 n#07649819 n#09557092 n#07403616 n#00089168 n#03326163 n#10934383 n#02543251 n#04327039 n#09532891 n#07589131 n#09414432 n#02911901 n#02534535 n#00775725 n#00543456 n#00714523 n#02891680 n#06694768 n#03366551 n#04929853 n#03476224 n#00433094 n#10726706 n#00336981 n#10986484 n#10392609 n#03124153 n#10553458 n#09669123 n#05336177 n#07614163 n#04842095 n#05339710 n#03371879 n#05820117 n#02931570 n#04958656 n#07366078 n#02332354 n#02553916 n#10195977 n#04023878 n#05511707 n#02365895 n#03331991 n#03554654 n#00510620 n#W0003042 n#06730449 n#05640818 n#02504445 n#05335105 n#07434368 n#07571155 n#06663506 n#00392670 n#06309912 n#04960550 n#09378313 n#04570636 n#02867188','v#00527758 v#01608361 v#01532784 v#01259985 v#01308121 v#00425463 v#00432046 v#01323821 v#00289728 v#00538152 v#01782232 v#00423198 v#01297319 v#00004432 v#01691402 v#00644402 v#00695746 v#00580733 v#01334351 v#00801888 v#01195951 v#00550221 v#00452804 v#01687643 v#01455682 v#01805867 v#00692188 v#00569645 v#01766224 v#00650101 v#00635224 v#01687772 v#01605849 v#00769101 v#01166409 v#00149552 v#01828040 v#00277986 v#01172794 v#00969423 v#00798936 v#00727813 v#00800663 v#01033610 v#00566419 v#01225068 v#01574557 v#01817415 v#01395450 v#01850506 v#00604807 v#01396433 v#01331754 v#00226472 v#01390954 v#00661682 v#01605370 v#01172555 v#01196430 v#00302737 v#00776850 v#00053456 v#00615476 v#01572717 v#00151519 v#01105230 v#01503770 v#00590217 v#00679625 v#00768835 v#01492050 v#00191274 v#00020571 v#00262110 v#00247214 v#00735086 v#00146774 v#00969943 v#01388981 v#00227099 v#00735310 v#00730153 v#00937015 v#00291977 v#01577901 v#00802836 v#01693366 v#01309045 v#00841244 v#01660883 v#00945569 v#00122986 v#01406309 v#01809305 v#01597333 v#01808714 v#01806398 v#01498845 v#01218326','a#00271371 a#01288643 a#00268398 a#02670038 a#00715726 a#00605906 a#00526151 a#02323511 a#00546142 a#01545283 a#01670698 a#01290893 a#00948905 a#00030536 a#01663469 a#00895779 a#02182526 a#02305707 a#00888335 a#00735215 a#00739107 a#00939237 a#01326938 a#02235832 a#00813486 a#00894991 a#00749489 a#00875100 a#01647341 a#01630457 a#02226713 a#01637759 a#00315634 a#01435948 a#00245557 a#01710829 a#01330522 a#02169635 a#00426295 a#01507020 a#02285592 a#01003225 a#01708108 a#00432959 a#00862651 a#02186961 a#00257106 a#01187977 a#02451201 a#00744544 a#02251311 a#00708032 a#02491407 a#00152678 a#00538552 a#02059945 a#01126552 a#00011251 a#00787643 a#00937355 a#01879678 a#02682032 a#01444522 a#02871410 a#02083821 a#02221362 a#01240288 a#01651175 a#00375007 a#01021258 a#01356217 a#01677947 a#02224056 a#02314238 a#02561803 a#01639981 a#00183273 a#00150716 a#02243685 a#02286306 a#01402650 a#01291274 a#00210644 a#00785224 a#00306683 a#00526062 a#01542911 a#01659453 a#00607344 a#00062052 a#00573090 a#02463868 a#01046335 a#00222070 a#00823796 a#01251237 a#00582991 a#02320336 a#00739297 a#01330402 a#02000424 a#00650523 a#00635556 a#00332110 a#00842241 a#02319680 a#01543925 a#02674437 a#01699981 a#02340180 a#00051223 a#01432691 a#00967501 a#01263562 a#01436124 a#01544256 a#01146743 a#00728997 a#02347639 a#01340057 a#01880434 a#01605702 a#02039292 a#00969498 a#01549597 a#01837971 a#02227309 a#01016693 a#02024585 a#02404762 a#00723427 a#00635391 a#00721065 a#00496525 a#00166278 a#00291928 a#00178727 a#01157466 a#02454907 a#02388941 a#01342379 a#00693705 a#01399812 a#00585147 a#01335370 a#02389133 a#02147156 a#00630848 a#01389754 a#00233687 a#02304595 a#01800617 a#02684106 a#02045706 a#02435610 a#01105870 a#00860385 a#00241100 a#02374681 a#00647703 a#01897347 a#01063414 a#01233309 a#00802671 a#00651172 a#00031484 a#01246668 a#00012073 a#01488356 a#02274192 a#01799424 a#02247656 a#01862309 a#01545440 a#00400522 a#00785647 a#00060407 a#01585423 a#00843640 a#00773316 a#01475929 a#00938029 a#01637389 a#02295360 a#00635682 a#01689189 a#01965169 a#00098270 a#01595060 a#00226637 a#01726491 a#01361647 a#02426436 a#02075679 a#00825931 a#02003499 a#00060515 a#01016477 a#00088670 a#00466251 a#00192058 a#02384104 a#02285143 a#02242461 a#01930748 a#01724574 a#00555661 a#00880469 a#02608408 a#02626054 a#01176052 a#01462629 a#02017166 a#01543754 a#00895484 a#02614411 a#01827843 a#02164245 a#00318095 a#01544827 a#01032744 a#02024286 a#00906436 a#01813919 a#00525794 a#01327049 a#01840382 a#02074946 a#00159497 a#02460855 a#00988359 a#00784791 a#00844091 a#02408395 a#00273279 a#01589075 a#02294893 a#01998286 a#02405897 a#00038502 a#00012165 a#00526302 a#02070890 a#00699326 a#01842408 a#02445201 a#01965621 a#00146045 a#01841402 a#01345717 a#00477567 a#01020875 a#00560909 a#02355589 a#02409028 a#02380702 a#01431881 a#00122245 a#01598968 a#01873142 a#00107565 a#02440800 a#01304634 a#00784280 a#02146453 a#00656813 a#01026523 a#00720285 a#02283338 a#02423250 a#01156005 a#00034021 a#00030925 a#00488599 a#00480379 a#01671453 a#01930505 a#01955114 a#01647866 a#01402927 a#02285688 a#00387611 a#01397113 a#02019381 a#00874095 a#00673994 a#01496930 a#02003874','r#00293314 r#00380626 r#00336463 r#00365916 r#00197532 r#00063876 r#00090012 r#00123460 r#00317916 r#00417771 r#00497701 r#00315910 r#00401646 r#00290667 r#00158918 r#00205200 r#00317502 r#00410479 r#00253723 r#00320419 r#00132817 r#00132508 r#00322627 r#00253851 r#00441920 r#00398064 r#00464905 r#00242297 r#00189054 r#00194039 r#00333117 r#00173047 r#00286528 r#00365665');
INSERT INTO italian_index VALUES ('tenda','n#03486655 n#02228878 n#02536246',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('valligiano','n#N0002221',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idolo','n#02848651',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portafogli','n#03587013',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portafoglio','n#03587013',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capigliatura','n#04080650',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chioma','n#04080650 n#N0000759 n#01415243 n#09440011 n#06758573',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('testa','n#04080650 n#02805509 n#W0021131 n#04345975 n#04290247 n#W0021129 n#02806030 n#06319446 n#W0021128 n#07311648 n#07996826 n#W0021130 n#09817824',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lessema','n#04759322',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vocabolo','n#04759322',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chelidonium_majus','n#08211325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('celidonia','n#08211325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chelidonia','n#08211325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erba_da_porri','n#08211325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tram','n#03426879',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('atto','n#04894916 n#00215081 n#00017487 n#04913178 n#04904391 n#04859637 n#05258426',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contratto','n#04894916',NULL,'a#00520179',NULL);
INSERT INTO italian_index VALUES ('scrittura','n#04894916 n#04794515 n#00404780 n#04859637 n#04826409',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('appezzato','n#06384327',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_spagnola','n#09852822',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciondolo','n#03103588 n#03103767 n#02707507',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gingillo','n#03103588 n#02247380 n#03144411',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pendaglio','n#03103588',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pendente','n#03103588 n#03103767',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mesopotamia','n#06517421',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('phlebotomus_papatasii','n#01708513',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('flebotomo','n#01708513',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pappataci','n#01708513',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vapore_acqueo','n#10802612',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zattera_di_salvataggio','n#02922712',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orificio','n#04076503',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orifizio','n#04076503',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affettazione','n#00487356',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leziosaggine','n#00487356 n#03650887',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leziosità','n#00487356',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricercatezza','n#00487356 n#03775871 n#03757270',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sciropposità','n#00487356',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('svenia','n#00487356',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vezzosità','n#00487356 n#03692429',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('linea','n#03952527 n#06235683 n#05092420 n#06037572 n#06338451 n#04452090 n#06235973 n#02364710 n#06338089 n#09988142',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sagoma','n#03952527 n#04055717 n#03472826 n#00015185 n#07149819',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mignolo','n#04322015 n#04313611',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cervellata','n#05720372',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cervellato','n#05720372',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elettrochoc','n#00452943 n#00453177',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elettroshock','n#00452943 n#00453177',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trattamento_con_elettroshock','n#00452943',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('batticarne','n#N0000149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('kbyte','n#09797558',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chilobyte','n#09797558',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('k','n#09797558 n#09871867',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('kilobyte','n#09797558',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antiproibizionista','n#W0020868',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colla_di_pesce','n#10540289',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ittiocolla','n#10540289',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('smoderatezza','n#00694694 n#03826302 n#03988853 n#03989021',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buco','n#10014154 n#02824094 n#10024561 n#04116121 n#04339898 n#06698547 n#00208780 n#02200095 n#06736924',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palla_curva','n#00068444',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spugna','n#01421416 n#03488850 n#10458513',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mietitore','n#07310125',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('segatore','n#07310125',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cardiopatico','n#N0000294',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('limite_di_tempo','n#10935385',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('verniero','n#03572797',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dermatozoi','n#00912812',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barba','n#04085290 n#01912914 n#04084808 n#09415516 n#09416750 n#02075218 n#09383959 n#01413618',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('automobilismo','n#N0000112 n#N0000113',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dissenso','n#05368104 n#05367634 n#05367990',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('glycyrrhiza_glabra','n#08833620',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('liquirizia','n#08833620 n#05657812',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paglia','n#10734241',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('epitaffio','n#04828759 n#04828891',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('epitafio','n#04828759 n#04828891',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aerofotografia','n#N0000021',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aerofotogramma','n#N0000021',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('narghilè','n#02828269',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inconveniente','n#03706895 n#00411168 n#04022756 n#05558628',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('preoccupazione','n#03706895 n#05593817 n#04491326 n#04383764 n#05593480 n#05594044',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seccatura','n#03706895 n#04490800 n#05489772',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sceneggiato','n#04966481',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('serial','n#04966481',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('serie','n#04966481 n#05990251 n#00412416 n#06246946 n#00651987 n#06116890 n#04512108',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impazienza','n#10338400 n#05586117 n#03661288',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('insofferenza','n#10338400',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('irrequietezza','n#10338400 n#05585608',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('escrementi','n#10654524',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('escremento','n#10654524 n#10654891 n#10654209',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('feci','n#10654524',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('commediografo','n#N0000414',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banca_di_credito_agrario','n#N0002747',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('istituto_di_credito_agrario','n#N0002747',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbrutimento','n#00174193 n#00174683',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('degradazione','n#00174193 n#10360885 n#00130362',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abituro','n#02839632',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baracca','n#02839632 n#02842105',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bicocca','n#02839632',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capanna','n#02839632',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capanno','n#02839632',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('casipola','n#02839632',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('casotto','n#02839632 n#02316353 n#03615214 n#02362306 n#03301887',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('casupola','n#02839632',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catapecchia','n#02839632',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spelonca','n#02839632 n#06738147',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stamberga','n#02839632',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('topaia','n#02839632',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tugurio','n#02839632',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canzone_marinaresca','n#02839632',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lavapiatti','n#02577956 n#07218068',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lavastoviglie','n#02577956',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gelo','n#07786410 n#03916773 n#05603115 n#10703346',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conformismo','n#04708272 n#00779727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('osso_carpale','n#04091415',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biancheria','n#02928457 n#03560325 n#03613775',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accumulazione','n#00239058 n#00517908',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accumulo','n#00239058 n#09729327 n#05968319 n#05969773 n#05963394',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affardellamento','n#00239058',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammassamento','n#00239058 n#05969773',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cumulazione','n#00239058',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('se_cose','n#00239058',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eucalipto','n#08638127 n#08638587',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eucalitto','n#08638127 n#08638587',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vino_da_tavola','n#05922816',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assistenza_sociale','n#00783549',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('segmentazione','n#09714417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sparide','n#02080305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('razzista','n#07517484',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perseveranza','n#00659771 n#03821553',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perseverazione','n#00659771',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bue','n#05707187 n#07231679 n#01899570 n#01900112 n#01899320',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('manzo','n#05707187 n#01900340 n#01900894',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gelataio','n#N0000821 n#N0000822',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gelatiere','n#N0000821',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lavatoio','n#03592214',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lustrascarpe','n#07120917',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cellula_fotoelettrica','n#03367653',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cellula_solare','n#03367653',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('funzionario_della_pubblica_amministrazione','n#07511394',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esuberanza','n#05617136 n#03989433 n#03655378',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prezzo_di_fabbrica','n#09578052',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vantaggio','n#04017485 n#04016440 n#04017740',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elegia','n#04809253',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bacchetta','n#02611360 n#02265158 n#03247107 n#02974707 n#02437221 n#03211656',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bacchetta_del_tamburo','n#02611360',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('listera_ovata','n#08378981',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('listera_maggiore','n#08378981',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prima_fila','n#03242031',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('languore','n#05587782 n#03935080',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('allocco','n#07231679 n#01144835 n#07618181 n#07271334 n#07156174',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asino','n#07231679 n#01886957 n#05149718 n#07271334 n#01887170',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('broccolo','n#07231679 n#07618181 n#08185016 n#05753270',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('castrone','n#07231679 n#01908966 n#01878145 n#07271334 n#07156174',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciocco','n#07231679 n#10722705',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frescone','n#07231679',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ignorante','n#07231679 n#07464747 n#07334217',NULL,'a#02389816',NULL);
INSERT INTO italian_index VALUES ('rapa','n#07231679 n#08185802',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('somaro','n#07231679 n#01886957 n#01887170',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('testa_di_legno','n#07231679',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('testone','n#07231679',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tonto','n#07231679 n#07618181 n#07333403 n#07156174',NULL,'a#00408403',NULL);
INSERT INTO italian_index VALUES ('zuccone','n#07231679',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aereo_di_linea','n#W0020963',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contrindicazione','n#05091123',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('controindicazione','n#05091123',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interesse','n#09588854 n#04392426 n#04383764 n#04042993 n#09562992 n#04017901',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fastigio','n#03100737 n#10045044',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frontone','n#03100737',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('psicosi_maniaco-depressiva','n#10327371',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arteriografia','n#00581287',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disperazione','n#10392337 n#05606636',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pattino_da_ghiaccio','n#02847503',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oscuramento','n#10073746',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('micene','n#06452723',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interdizione','n#10351617 n#05032638 n#05414897 n#05414813',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conforto','n#00785538 n#04399253 n#05570308',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('consolazione','n#00785538',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bellezza','n#03691417 n#03691117 n#04549741 n#07108564 n#07586543 n#03689966',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prestansa','n#03691417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prestanza','n#03691417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capitalista','n#07138105 n#06941675',NULL,'a#00293268 a#02760203',NULL);
INSERT INTO italian_index VALUES ('residente','n#07530344 n#07636191',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('f.b.i.','n#06060479',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('federal_bureau_of_investigation','n#06060479',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ufficio_federale_investigativo','n#06060479',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deroga','n#05485383',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deviazione','n#05485383 n#05450454 n#03801774 n#02559988',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbandamento','n#05485383 n#00212160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('differenza','n#05485383 n#04513036 n#03731027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('danno','n#10257548 n#00479622 n#05522458 n#05522654',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lesione','n#10257548 n#00258668 n#10212725 n#05451786',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('male','n#10257548 n#05572211 n#04007415 n#10384027 n#10123988 n#00480312 n#10279078 n#00488251 n#10129713 n#04007891',NULL,NULL,'r#00010485');
INSERT INTO italian_index VALUES ('trauma','n#10257548 n#10257434',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ferita','n#10257548 n#10212725 n#10257907',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piaga_da_decubito','n#10213257',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antro','n#06737795 n#06738147 n#06738241 n#04116916',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grotta','n#06737795 n#06738147',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brigantino','n#02338794 n#02339023',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vestito','n#02600401 n#03438739 n#02456798 n#02740446',NULL,'a#00423413',NULL);
INSERT INTO italian_index VALUES ('abito','n#02600401 n#03438739 n#02456798 n#02222774 n#02740446 n#02783002',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('toilette','n#02600401 n#02602127 n#02222774 n#02263808 n#03512626',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veste','n#02600401 n#00462651 n#02740446',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marinatura','n#N0001137',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('favoreggiamento','n#N0000722',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conifera','n#09400235',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tragelaphus_angasi','n#01921091',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aceto','n#05861621 n#10824042',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('validità','n#03773162 n#03753565',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vitello','n#10582102 n#01403819 n#05708659',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bacchettone','n#07471997',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baciapile','n#07471997',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('battipetto','n#07471997',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('beghino','n#07471997',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bigotto','n#07471997',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fariseo','n#07471997 n#07332358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('picchiapetto','n#07471997',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lettore_di_cd','n#02408180',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riproduttore_di_cd','n#02408180',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('appartenente','n#07404067',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('componente','n#07404067 n#09947031 n#09946775 n#02479780 n#04515709',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elemento','n#07404067 n#10040673 n#06316268 n#10473879 n#02479780 n#10646191 n#05460817 n#04481302 n#04515709 n#07149819 n#04764375',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('membro','n#07404067 n#09947031 n#04307034 n#06075183 n#04279799 n#04307370',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imposizione','n#00730090 n#04492223 n#09580808',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bimetallo','n#10595420',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carta_pecora','n#10580063 n#10823733 n#10580207',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cartapecora','n#10580063 n#10823733 n#10580207',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pergamena','n#10580063 n#10745991',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aliquota','n#09565482 n#09889204 n#09771510 n#09593084',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contingente','n#09565482 n#06214922 n#05980149 n#04994041',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('porzione','n#09565482 n#05631178',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anemia','n#10202733 n#10311493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pepsina','n#10748728',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barocciata','n#09913457',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baroccio','n#09913457 n#02393752',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barrocciata','n#09913457',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barroccio','n#09913457 n#02393752',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carrata','n#09913457',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carrettata','n#09913457',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carro','n#09913457 n#03583606 n#02393752 n#02942573',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acquitrino','n#06786994 n#06786505 n#06786830',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lama','n#06786994 n#07260842 n#07361698 n#01933935 n#02295763 n#03457380 n#01933580',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palude','n#06786994 n#06786830',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('controriforma','n#06256615',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('utilità','n#04011108',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vantaggiosità','n#04011108',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intransigenza','n#03810613',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colata','n#00584336',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('getto','n#00584336 n#00064905 n#00066170 n#05531909 n#07773585 n#02875044 n#02401509 n#00808875 n#05757512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('punto_culminante','n#04804834',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coreografia','n#00339297 n#05266677',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ortografia','n#04790339 n#04788790',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compravendita','n#10442714 n#00721968',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contratto_di_compravendita','n#10442714 n#00721968',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vendita','n#10442714 n#00721968 n#00723329 n#00723154 n#04901002 n#00724586',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mobilità','n#03746913 n#03725478 n#03721331 n#03747353',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cresta_dell''onda','n#05477614',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bangkok','n#06590395',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risoluzione','n#04461993 n#04496054 n#04458084 n#07833631 n#07833814 n#00806197',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('concessione','n#05364726 n#06007568 n#05390774 n#04899789',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vomere','n#03146300',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salto_in_lungo','n#00278798 n#05553154',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('peso','n#05604301 n#04028728 n#09855495 n#09854968 n#09853655 n#04491717 n#03327924 n#09855230 n#03605402 n#09854160 n#03925610 n#03605234 n#09853910 n#10356224',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cruna','n#02655320',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dosaggio','n#09918604',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dose','n#09918604 n#03983517 n#02592220',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('collo','n#05997364 n#04296371 n#03033593 n#03074890 n#02240596 n#03498829',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('involto','n#05997364',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malloppo','n#05997364 n#09543577',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pacchetto','n#05997364 n#03074459',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pacco','n#05997364 n#03074890',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brano','n#05282531 n#04740201 n#W0021190',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pezzo','n#05282531 n#W0021191 n#03119215 n#04824319 n#W0021190 n#W0021188 n#04739954 n#W0021189 n#04739838 n#02962635',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('passo','n#05282531 n#00113217 n#05497366 n#04824319 n#W0021203 n#06708950 n#04984123 n#10977461 n#W0021204 n#00107819 n#00343865 n#00184779 n#03908185 n#W0021202 n#09907411 n#03092396 n#W0021207',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('passaggio','n#05282531 n#04824319 n#00131763 n#W0021208 n#05303065 n#06797465 n#05450141 n#00066813 n#00200199 n#W0021205 n#10044643 n#00200531 n#W0021206 n#03092396 n#W0021207',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capoccione','n#07355777',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('puritano','n#07509245 n#07512781',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cane_da_riporto','n#01609478',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('papalina','n#03347535',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zucchetto','n#03347535',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stabilizzazione','n#00750993',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filatore','n#07600308',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monte_premi','n#09548134 n#09608092',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('montepremi','n#09548134 n#09608092',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soldi_del_premio','n#09548134',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pupazzo_di_neve','n#03362517',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('limanda','n#N0001058 n#N0001057',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incorporamento','n#00804120',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incorporazione','n#00804120 n#00239911',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cerchio','n#03241267 n#09995464 n#09995724 n#02829005',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calla','n#08097255 n#08104885',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('periodontite','n#10134140',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cellula','n#00003095 n#06189358 n#02172850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seme_di_papavero','n#05860476',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('braccioli_salvagente','n#03599609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('astuccio_per_matite','n#03103492',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portalapis','n#03103492',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portamatite','n#03103492',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portapenne','n#03103492',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('toccalapis','n#03103492',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cappella_laterale','n#03334466',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giunchiglia','n#08723976 n#08723764',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portassegni','n#N0001546',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('insetto_stecco','n#01735004',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arpista','n#07309754',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arpeggiatore','n#07309754',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coltre','n#02296701 n#06671614',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coperta','n#02296701',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apripista','n#02350401',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bulldozer','n#02350401',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('livellatrice','n#02350401 n#03407394',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ruspa','n#02350401',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affilacoltelli','n#03408089',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cifra','n#04951064 n#09598019 n#04791545 n#05097671 n#09894531 n#05112048 n#09597673',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impianto_di_risalita','n#03347154',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sciovia','n#03347154',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ski-lift','n#03347154',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ski_lift','n#03347154',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pastorizia','n#N0001399',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ghiandaia','n#01102556',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('epigono','n#07246302 n#07183572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pyrola_minor','n#08561140',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piroletta_minore','n#08561140',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caposquadriglia','n#N0000279',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teheran','n#06514815',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sabina','n#07955212',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('penitenziario','n#03104806 n#03174387',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reclusorio','n#03104806',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tursiope','n#01581293 n#01580061 n#01581563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('redazione','n#04844438 n#00654717',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('campanilista','n#N0000253',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('economia_pianificata','n#06194185',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vendita_di_beneficenza','n#00725119',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reparto','n#03588287 n#06101255 n#06097572 n#06049069 n#06098856',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reparto_di_ospedale','n#03588287',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('divisione','n#03588287 n#06102348 n#06095787 n#05368405 n#00247514 n#06102171 n#00255068',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alcova','n#02178496 n#02275625',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('narciso','n#06857688 n#08723332',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavalleggero','n#07144504',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavalleggiero','n#07144504',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soldato_di_cavalleria','n#07144504',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('merluzzo','n#02015220',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colosso','n#07167525 n#07289774',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('titano','n#07167525',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compito','n#00508925 n#00461778 n#00469204',NULL,'a#01403478',NULL);
INSERT INTO italian_index VALUES ('progetto','n#00508925 n#04533598 n#03136211 n#W0003041',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('centralino','n#03456767 n#02413424',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('commutatore','n#03456767 n#02477843',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autodifesa','n#00528304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('saponina','n#10680284',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contraddizione','n#05384517 n#09983447',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contradizione','n#05384517 n#09983447',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('controsenso','n#05384517 n#04956498',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calma','n#10064397 n#05587497 n#05587339 n#03839746 n#10089688 n#10065501',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tranquillità','n#10064397 n#05587339 n#10089688',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('refuso','n#05071831',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('debole','n#03936506 n#05574157 n#05573609 n#10376771',NULL,'a#02214221 a#00878089 a#02213198',NULL);
INSERT INTO italian_index VALUES ('riforma','n#00167178',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pace','n#05075242 n#10065207 n#05587497 n#03893757 n#10064713 n#10365084 n#W0021161',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trattato_di_pace','n#05075242',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accordo_di_pace','n#05075242',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('circumnavigazione','n#00192282',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('periplo','n#00192282',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('regno','n#10962839 n#10962707 n#06308767 n#10411125 n#10355153',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('motore','n#02639670 n#03018224 n#03017435',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ione','n#06689819',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ampiezza','n#04001445 n#05537417 n#03982675 n#09951076 n#03982226',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apertura','n#04001445 n#06699639 n#10021740 n#06699238 n#00246048 n#03354789 n#02738096 n#06698176 n#00153241 n#05540966 n#05437768 n#00217163 n#02200095 n#06736924',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('larghezza','n#04001445 n#09920124 n#04703384 n#03788005',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spaziosità','n#04001445 n#03982226',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cipresso','n#07947710 n#07948092',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bollatura','n#N0002106',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('timbratura','n#N0002106',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mastoidectomia','n#00442122',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attico','n#02222521 n#03105753',NULL,'a#02774862',NULL);
INSERT INTO italian_index VALUES ('soppalco','n#02222521 n#02938992',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biberon','n#03048278 n#09912761',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('poppatoio','n#03048278',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('circuiteria','n#02443985',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accattona','n#07107212',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('segno','n#05089826 n#05419337 n#05085885 n#05146255 n#03696173 n#05097156 n#05106558 n#04984365 n#06393436 n#03684436',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('criterio','n#04543461 n#04348442 n#04549310 n#05418696',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('legge','n#04543461 n#04519159 n#06149385 n#04517355 n#04680638 n#06243906 n#04904589',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('norma','n#04543461 n#04549310 n#04988542 n#04501800 n#05062525 n#05418696 n#04997156 n#04609375 n#09980992',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('principio','n#04543461 n#04519930 n#04515071 n#04570773 n#04988542 n#05459242 n#10965545 n#04991006 n#05437768 n#04518763',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('daltonismo','n#10179445',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spruzzata','n#10803242',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spruzzo','n#10803242',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('porcellone','n#N0001528',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sporcaccione','n#N0001528',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sudicione','n#N0001528',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guida','n#07305031 n#07291722 n#04840928 n#03262777 n#00742277 n#00193637 n#07228242 n#07157042 n#03398515 n#04841370',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciglio','n#10018250 n#06281742 n#00984538 n#04123270 n#02339602 n#04124418 n#10019436',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('estremità','n#10018250 n#03150523 n#04307034 n#06316649 n#06314878 n#04312839 n#06315338',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('follicolo','n#04274529',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erg','n#09881728',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pilota_di_caccia','n#07262499',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('opinione_pubblica','n#04567146',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ripensamento','n#04462527',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lingua','n#05319899 n#04114572 n#04748361 n#05697438 n#05167497',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('linguaggio','n#05319899 n#05296602 n#04370255 n#04748361 n#05296154 n#05353460 n#05167497 n#05353662',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parlare','n#05319899 n#05296602 n#05338816','v#00638109 v#00645075 v#00651246 v#W0021088 v#00652168 v#W0021078',NULL,NULL);
INSERT INTO italian_index VALUES ('parlata','n#05319899 n#05296602 n#05352409',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('beccatello','n#03101272',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavicchio','n#03101272 n#02566421 n#03101643',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dimensione','n#04503850 n#03977358 n#03972175 n#04602448',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rete_di_scarico','n#W0003091',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sciantosa','n#N0001829',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('defogliante','n#10639234',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('defoliante','n#10639234',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('milionesimo','n#09892786 n#09978587',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('settimana_di_pentecoste','n#10950901',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('battello','n#03406281 n#02304226 n#02572035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piroscafo','n#03406281 n#03406768',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vapore','n#03406281 n#03406768',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nave_a_vapore','n#03406281',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leucodermia','n#10223997',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dirham','n#09833672 n#09860429 n#09834659 n#09833029 n#09834373 n#09832628',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dirham_tunisino','n#09833672',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fecondazione','n#05532561',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impregnazione','n#05532561',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bigamo','n#07111730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leccata','n#00097810',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inglese','n#05209017 n#07013773',NULL,'a#02762810',NULL);
INSERT INTO italian_index VALUES ('loranthus_europaeus','n#09037409',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vischio_quercino','n#09037409',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('timoneria','n#03409586',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('midollo_spinale','n#04264160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ave','n#04854756',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avemaria','n#04854756',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avemmaria','n#04854756',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('muso','n#01948277 n#04341094 n#03044524 n#01948450 n#06320385 n#05147533 n#04341235',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('obbligazionista','n#07118931',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antineutrino','n#06679227',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acqua_ossigenata','n#10599447',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alta_tensione','n#W0020894 n#W0020897 n#W0020896 n#W0020895',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catastrofe','n#05484555 n#07782551 n#05452645 n#10384515 n#00141434',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiasco','n#05484555 n#09914297 n#05484900 n#10385774',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('azione','n#00364173 n#09599721 n#09670326 n#10090167 n#00017487 n#09606854 n#00022246 n#00609840 n#00765298',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gioco','n#00364173 n#05990251 n#09607916 n#05084634 n#00289585 n#00295977 n#00289269 n#03144411 n#03747822 n#00330021 n#00325752 n#00291567 n#04544710 n#10959983',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('consegnatario','n#07179735',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('destinatario','n#07179735 n#06954382 n#07463856 n#07062359',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anulare','n#04313373',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spiazzo','n#N0001968 n#06296783',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imposta_sugli_affari','n#N0002793',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idealizzazione','n#00790944 n#04549060',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('declinazione','n#09941651 n#09967239',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bottiglia_incendiaria','n#03010227',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('molotov','n#03010227',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salopette','n#N0001767 n#N0001768',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('statura','n#10358702 n#03907531',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falco_subbuteo','n#01134625',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falchetto','n#01134625',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falco_lodolaio','n#01134625',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lodolaio','n#01134625',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cyclopterus_lumpus','n#02136332',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('difficoltà','n#04394770 n#10339059 n#00411168 n#05385605 n#04396893 n#04396796 n#05409439 n#03705476',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cocco','n#05808738 n#07109169 n#08888049 n#00885620',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bussola','n#02479302 n#03297804',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('discarica','n#06310017',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immondezzaio','n#06310017',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mondezzaio','n#06310017',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scarico','n#06310017 n#02596615 n#00458521',NULL,'a#00348412 a#01367881',NULL);
INSERT INTO italian_index VALUES ('aspartame','n#05887724',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inquietudine','n#05594446 n#05585608 n#04491326',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fildiferro','n#03625583',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filo_di_ferro','n#03625583',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filodiferro','n#03625583',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('legante','n#10541072',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nafta','n#10733026 n#10527763 n#10527233',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ascella','n#09419980 n#04298485',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('islanda','n#06539207 n#06539330',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lancio','n#00064905 n#00066170 n#00155548 n#00081742',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tiro','n#00064905 n#00066170 n#05982639',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('informativa','n#N0000967',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('uccellino','n#01027804 n#01027518',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intorpidimento','n#10278925 n#10094429 n#03657083',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zinjanthropus','n#01971399',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caronte','n#06854490',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corso','n#02510906 n#W0003103 n#W0003097 n#W0003104 n#06390488 n#03584710 n#W0003113 n#02228469 n#W0003106 n#W0003102 n#W0003085 n#04840046 n#00568196',NULL,'a#02781345',NULL);
INSERT INTO italian_index VALUES ('mastalgia','n#10283877',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mastodinia','n#10283877',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sorteggio','n#N0001935',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calcografia','n#N0000238',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('permanenza','n#03944434 n#00683061',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('regolatore_di_tensione','n#03581548',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('igroscopio','n#02844726',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piallatrice','n#03137218',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('commessa','n#04909380',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decreto','n#04909380',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('editto','n#04909380',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intimazione','n#04909380',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ordinanza','n#04909380 n#04997156 n#04919548',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teucrium_chamaedrys','n#09167814',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camedrio_comune','n#09167814',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('querciola','n#09167814',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prunus_laurocerasus','n#08946760',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lauroceraso','n#08946760',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aristocratico','n#07082949',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nobile','n#07082949',NULL,'a#01175863',NULL);
INSERT INTO italian_index VALUES ('patrizio','n#07082949',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coproduzione','n#N0000473',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cicloturismo','n#N0000365',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clock','n#N0002279',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canto','n#00354500 n#05504258 n#04810130 n#02502160 n#05272607 n#05270417 n#04813179 n#05090557 n#05274665 n#02501991',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arrendevolezza','n#03840782 n#03660241 n#00756155 n#03841165 n#10342197 n#03922522',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('docilità','n#03840782 n#03841165 n#03921831',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maneggevolezza','n#03840782 n#03841050',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trattabilità','n#03840782',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moro','n#06960662 n#07030830 n#07128356',NULL,'a#02832322',NULL);
INSERT INTO italian_index VALUES ('negro','n#06960662',NULL,'a#00238676',NULL);
INSERT INTO italian_index VALUES ('negroide','n#06960662',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('satirione','n#N0001789',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interscambio','n#00719451 n#02862021',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricambio','n#00719451 n#04401363 n#00129213 n#03375701',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('collaboratore','n#07181468 n#07164888 n#07087094',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contributore','n#07181468',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('estratto_conto','n#04891517 n#09615594',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tricolore','n#03538846',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('terza','n#03496773 n#00465278 n#05132028',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tassa_società','n#N0002809',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cattolicità','n#03742471',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('generalità','n#03742471 n#03741468 n#03991218 n#04543301',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('universalità','n#03742471 n#03741468',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bourbon','n#05929674',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spadino','n#N0001952',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intercettamento','n#00091213',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intercettazione','n#00091213',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intercezione','n#00091213',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zecca_dura','n#01295717',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ixodide','n#01295717',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zecca_a_corpo_duro','n#01295717',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mortalità_infantile','n#10980026',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malva','n#03885294 n#08476775 n#08476044 n#08476962',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dedizione','n#03821274 n#00675531 n#00781577',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prelievo','n#00253953 n#00656313',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pappagallo','n#01334230 n#07684525',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diploma','n#04864239',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('licenza','n#04864239 n#05015182 n#03802185 n#10864777 n#10864475 n#10865363 n#10082169 n#04916758',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('debitore','n#07205503',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('albero_maestro','n#02959572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('proiettore_elettronico','n#02631938',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lota_lota','n#02016207',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bottatrice','n#02016207',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capitano','n#07398874 n#07138499 n#07138749 n#07138378 n#07138865',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capobarca','n#07398874',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('padrone','n#07398874 n#07451003 n#07241412 n#07451379 n#07451666',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('skipper','n#07398874',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('euphorbia_helioscopia','n#09216145',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erba_verdona','n#09216145',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('euforbia_calenzuola','n#09216145',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('papaveracee','n#08207714',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiodatrice','n#07536057 n#03243526',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ribattitore','n#07536057',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lemure','n#01990923',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spettro','n#07772246 n#04533237 n#06896801',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('copertura','n#03286335 n#00636447 n#00530526 n#00680055 n#05010999 n#02513049 n#09608739',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('schermo','n#03286335 n#03287008 n#03286767',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('degnazione','n#03829111 n#03794578',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavia_porcellus','n#01865933',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('porcellino-d''india','n#01865933',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('miticizzazione','n#N0001200',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mitizzazione','n#N0001200',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interventismo','n#N0000994',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bradypus_tridactylus','n#01953050',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bradipo','n#01953050 n#01952612',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('olio_d''oliva','n#05717210',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inefficienza','n#04368639',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fototropismo','n#00553980',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bastoncino','n#03346197 n#02437221',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bastoncino_da_sci','n#03346197',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('racchetta','n#03346197 n#03200805 n#07636800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('racchetta_da_sci','n#03346197',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pila_a_combustibile','n#02726134',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cella_a_combustione','n#02726134',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mitosi','n#09696686 n#09693894',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cono','n#02486466',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('squilla','n#01502586 n#02513919',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mangiatore_di_fuoco','n#07264318',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('distanza','n#03967504 n#03971230 n#03996081 n#05579445 n#03733698 n#10890499 n#10890324',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lontananza','n#03967504 n#06307377 n#N0001071 n#00801297',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('modo','n#00266480 n#03844273 n#03856995 n#04464225 n#00265102 n#09939326 n#03836008 n#10390345 n#10044353 n#03858557 n#00111872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crema_abbronzante','n#N0000004',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crema_solare','n#N0000004',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sphyrna_zygaena','n#01018486',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('martello_testa_liscia','n#01018486',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pesce_martello','n#01018486 n#01018204',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lumaca_di_mare','n#01463666',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oloturoideo','n#01463666',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pasticcino','n#05679656',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pastina','n#05679656',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canna_fumaria','n#02702797 n#02430052',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carne','n#04055717 n#05694720 n#09388596 n#04088435',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('figura','n#04055717 n#03684305 n#02660325 n#03685812 n#09987377 n#06928932 n#02849808 n#00363615 n#05252535 n#02676671',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('centesimo','n#09827379 n#09892584 n#09644617 n#09827092 n#09828555 n#09978384',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caducità','n#03946351 n#03946031',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fugacità','n#03946351',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('labilità','n#03946351 n#03946031',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polyergus_rufescens','n#01726315',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('formica_amazzone','n#01726315',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tugrik','n#09866103',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tugrik_mongolico','n#09866103',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('promissario','n#07505396',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impulsivo','n#N0000946',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('industria_petrolifera','n#06014078',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('femmina','n#06948278 n#00865075',NULL,'a#01417117',NULL);
INSERT INTO italian_index VALUES ('acquaplano','n#02204078',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('semirimorchio','n#03301557',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monitore','n#03010996',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colpo_di_testa','n#00084802',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ruttino','n#N0001747',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('collocazione','n#00680814',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disposizione','n#00680814 n#10095984 n#03866867 n#04997156 n#05359821 n#02211659 n#03961670',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('furore','n#10070966 n#10110976 n#05588413',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('echinococcosi','n#10370115',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cane_poliziotto','n#01617124',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crusca','n#10621550 n#05624467',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('semola','n#10621550 n#05624467',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esemplificazione','n#05149300',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compilatore','n#07242157 n#04932870',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('estensore','n#07242157 n#04109579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pilastrino_del_cancello','n#02747956',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('consolle','n#02489503',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accoppiamento','n#00544133 n#00542663',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('copula','n#00544133 n#04861501 n#04773700',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alta_società','n#06206464',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('equus_grevyi','n#01889023',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zebra-di_grevy','n#01889023',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moderazione','n#00692149 n#03988388 n#03825241',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('temperanza','n#00692149 n#03825241',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('audiologia','n#04631392',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('optimum','n#04007118',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mestola','n#02574996 n#03545058',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mestolo','n#02574996 n#02900451',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catacomba','n#02402595',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indurimento','n#00258419',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tempra','n#00258419',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('curriculum','n#04859217',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('curriculum_vitae','n#04859217',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbattimento','n#00145565 n#00811339 n#10392521 n#00146336 n#10096823 n#05603932',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ecatombe','n#00145565 n#00145676 n#00808655 n#00145813 n#00147961',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macellamento','n#00145565',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macellazione','n#00145565',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macello','n#00145565 n#02156186 n#00145676 n#00808655 n#10384515 n#10400671',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orfano','n#07448764',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caciaio','n#07199559',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('casaro','n#07199559',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elasticità','n#03920674 n#03672792 n#03908650 n#03922244 n#03921242 n#03672615 n#03921126',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sesta','n#05132449 n#10939959 n#10884479',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guazzo','n#02763868 n#02763976',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dannazione','n#10373458 n#05522274',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cartellino','n#04881368 n#05428310',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biciclo','n#03570009',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('velocipede','n#03570009',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accento','n#05301395 n#05300778 n#10356622 n#05299832 n#05110367 n#05110610 n#05335965 n#10356373',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contrizione','n#00060414',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('correzione','n#00060414 n#00166347',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ravvedimento','n#00060414',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risanamento','n#00060414',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('organizzazione_del_trattato_per_l''asia_sudorientale','n#N0002055',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('s.e.a.t.o.','n#N0002055',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('befana','n#07307226',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('megera','n#07307226 n#07573451 n#07669131',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strega','n#07307226 n#06859873 n#N0002563 n#07669131 n#07241906',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vecchiaccia','n#07307226',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arroccamento','n#00108354',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arrocco','n#00108354',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fotoemissione','n#07765800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('processo','n#00776884 n#00766856 n#00775201 n#04241916 n#04404854 n#09669871 n#00660718',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arboricoltore','n#07274398',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ischia','n#N0002317',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acantopterigi','n#02043221',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('divisione_cellulare','n#09693894',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('silicon_valley','n#06652894 n#W0020824',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inserimento','n#00207301 n#00239677 n#10041978',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inserzione','n#00207301 n#05411061',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('introduzione','n#00207301 n#04822335 n#04834552 n#04821883 n#05391158',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antitesi','n#05313422 n#09981662',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('astuccio','n#02323900 n#02397245',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cassa','n#02323900 n#09913824 n#02517015 n#03430944 n#03370398 n#02399372 n#N0002677 n#06227059 n#09913641 n#02425486',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cassetta','n#02323900 n#02324930 n#02400775',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scatola','n#02323900',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trireme','n#03541867',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paraguaiano','n#07033035',NULL,'a#02734093',NULL);
INSERT INTO italian_index VALUES ('paraguayano','n#07033035',NULL,'a#02734093',NULL);
INSERT INTO italian_index VALUES ('luddista','n#07383927 n#07383754',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banano','n#08655530',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rio','n#06793150',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rivo','n#06793150 n#06793678',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ruscello','n#06793150 n#06793678 n#06780943',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('torrente','n#06793150 n#09921122',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avarizia','n#03868599 n#00489572 n#03788961 n#03788750',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cupidigia','n#03868599 n#00489572 n#03868401 n#05568116',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amico','n#07280379 n#06950629 n#07627913',NULL,'a#W0021063 a#W0021064',NULL);
INSERT INTO italian_index VALUES ('smaltimento','n#N0001913 n#09712272',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('copriteiera','n#02506270',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('convezione','n#09739940 n#09739804',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cinemascope','n#N0000372',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alosa','n#02023163 n#02023855 n#05832482 n#02023740',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('matrice','n#02567881 n#04894478 n#03141069 n#04325178 n#04883929 n#06139195 n#03410765',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mutilazione','n#10433993 n#05530077',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lingua_materna','n#05168195',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('linguamadre','n#05168195',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('madre_lingua','n#05168195',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('madrelingua','n#05168195',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vladimir_putin','n#W0020811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('putin','n#W0020811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('motivazione','n#00013700 n#04485374',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('motivo','n#00013700 n#05271219 n#05051484 n#06659860 n#04546376 n#03016610 n#05271609 n#05051824',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ragione','n#00013700 n#04370938 n#04985978 n#05051484 n#06659860 n#04482668 n#05051824',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bisogno','n#00013700 n#06846731 n#10397595 n#10367157 n#10397144 n#10368006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('movente','n#00013700 n#05051824 n#05460141',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('necessità','n#00013700 n#06846731 n#06846327 n#10367157 n#10397144 n#10368006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciarlatano','n#07514393 n#07421384',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dulcamara','n#07514393 n#09192140',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vendita_televisiva','n#00723694',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ristampa','n#04740751',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riedizione','n#04740751 n#04740930 n#03228023',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('commedia','n#05262451',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('modus_vivendi','n#05366693',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marginatura','n#04817614',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('margine','n#04817614 n#03731940 n#10019175 n#02621671 n#06314081 n#09612489',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prestito','n#04754686 n#09651550 n#00708190',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chip','n#02432404',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('microchip','n#02432404',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chip_al_silicone','n#02432404',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bontà','n#04047189 n#03800378 n#03717355 n#03846037 n#03902647 n#03758747 n#03785996 n#00796730 n#03793754 n#03717983 n#03930785',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('efficacia','n#04047189 n#04047544',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mordente','n#04047189 n#03811208 n#10730541',NULL,'a#01830655',NULL);
INSERT INTO italian_index VALUES ('dichiarazione','n#05049880 n#05043129 n#05045355 n#05049646 n#05040541',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('licitazione','n#05049880 n#05358049',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('integumento','n#04068867',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tegumento','n#04068867',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giuria','n#06222792 n#06222293',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canaglia','n#06213014 n#07666308 n#07538532 n#07537276',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciurmaglia','n#06213014',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gentaglia','n#06213014',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maramaglia','n#06213014',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marmaglia','n#06213014',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('plebaglia','n#06213014',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('plebe','n#06213014',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calendario','n#10891500 n#04870072',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carne_di_cervo','n#05697754',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antigua_e_barbuda','n#06408680',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_irlandese','n#09856698',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sinovite','n#10300293',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('briga','n#04490800 n#00411168 n#05436632 n#05369518 n#05489772',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disturbo','n#04490800 n#10207260 n#00270946 n#10365730 n#10121017 n#05528783',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fastidio','n#04490800 n#10337915 n#04491326 n#05489772',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('noia','n#04490800 n#07121483 n#07453274 n#05489772 n#05605136',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('noiosità','n#04490800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ossessione','n#04490800 n#04403919 n#07453274 n#06663608',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pallosità','n#04490800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piaga','n#04490800 n#10195710 n#07453274',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rogna','n#04490800 n#10247152 n#10247351 n#07453274 n#05489772',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rompiballe','n#04490800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rompipalle','n#04490800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rottura','n#04490800 n#05451946 n#00242022 n#10261267 n#05489772 n#00242436 n#06699090 n#00691454',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scocciatura','n#04490800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scomodo','n#04490800 n#05489772',NULL,'a#00572361',NULL);
INSERT INTO italian_index VALUES ('problema','n#10340761 n#04395081 n#10385041 n#04479710 n#05080756 n#04479997',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risciacquata','n#00164474',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risciacquatura','n#00164474 n#10643538',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sciacquatura','n#00164474 n#10643538',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mazziere','n#07385530',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grandangolare','n#03616635',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grandangolo','n#03616635',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('segnalatore','n#07575603 n#07575759',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rumex_acetosella','n#08904527',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('romice_acetosella','n#08904527',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tularemia','n#10249558',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('metadone','n#02991150',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decano','n#07205140 n#07205244',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('preposto','n#07205140',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('actias_luna','n#01805520',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bruffolo','n#10285955',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brufolo','n#10285955',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pustola','n#10285955 n#10285834',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('legnaia','n#03628136',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('steppa','n#06727618',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pennellata','n#N0001422',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tocco','n#N0001422 n#05514913 n#03858252 n#05518102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('okay','n#05013809',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('implicazione','n#04456470 n#09932827 n#04546552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cortina_fumogena','n#03358784',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('profilo','n#04891157 n#06345780 n#06302245 n#05255005 n#06345554',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salsa_di_menta','n#05856363',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lancia','n#N0002527 n#03378030 n#02800736 n#07362476 n#03484588 n#03378225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leitmotiv','n#05270769 n#04546376 n#05270936',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('metallaro','n#N0001170',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('difensore','n#06945104',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guardiano','n#06945104 n#07675146',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('custode','n#06945104 n#07197056 n#07622026',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('protettore','n#06945104 n#07477156 n#07462736',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avvocato','n#06945104 n#07065692 n#07366159 n#07066331 n#07591764',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tutore','n#06945104',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aspetto','n#03687267 n#00487065 n#03720318 n#04504775 n#09941892 n#00688424 n#04707108 n#03687456 n#03683012 n#03683672 n#04341235',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('versione','n#05362628 n#04787112 n#04497422 n#04830233',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mercato','n#02967394 n#10068579 n#00711063 n#06230917',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strofa','n#04815636',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strofe','n#04815636',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('binocolo','n#02290626',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cannocchiale','n#02290626 n#03480713',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('addis_abeba','n#06448198',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pari','n#07466257 n#06953318',NULL,'a#01354638',NULL);
INSERT INTO italian_index VALUES ('cintura_nera','n#05424910 n#07114684',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scatoletta','n#N0001813 n#N0001814',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cuneese','n#N0000511',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('petrarca','n#07747255',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pneumococco','n#00908644',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disoccupato','n#07655955',NULL,'a#00823051',NULL);
INSERT INTO italian_index VALUES ('senzalavoro','n#07655955',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fogliame','n#N0000759 n#09440011 n#02709108',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fronda','n#N0000759 n#09440981 n#00617685',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('burattino','n#03189020 n#07192274',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marionetta','n#03189020 n#03189222',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pianoforte_a_coda','n#02766298',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nazionalismo','n#04727595 n#03821817',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bagnarola','n#02264436 n#02356871',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tinozza','n#02264436',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vasca','n#02264436 n#03455079 n#03594645',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anthus_pratensis','n#01051500',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pispola','n#01051500 n#05063177',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('labiale','n#05326374',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('volta','n#10952869 n#W0021071 n#05449233 n#03568778 n#04320709 n#W0003171 n#00290820',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corte_di_cassazione','n#W0020942',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cassazione','n#W0020942 n#00150989',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricovero','n#03316185 n#06365607',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('groppa','n#01958984 n#04306040',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pagatore','n#07464113 n#07463938',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dieresi','n#05111883',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('controrivoluzione','n#00618313',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antracite','n#10628495',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guerrigliero','n#07304581',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbaiatore','n#07297035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiacchierone','n#07297035 n#07151584',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comare','n#07297035 n#07294348',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gazzetta','n#07297035 n#04738958',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gazzettino','n#07297035 n#04738958 n#05394227',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lingua_lunga','n#07297035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mal_parlante','n#07297035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mala_lingua','n#07297035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malalingua','n#07297035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maldicente','n#07297035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malparlante','n#07297035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mormoratore','n#07297035 n#07678656',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pettegola','n#07297035 n#01539837',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pettegolo','n#07297035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sparlatore','n#07297035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arrangiatore','n#07084173',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giratubi','n#03130975',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciminiera','n#02430682 n#02727985 n#02430052 n#03358889',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comignolo','n#02430682',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('centro-destra','n#N0000333',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('centrodestra','n#N0000333',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carcerazione','n#10085136 n#00743598 n#00754825',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carcere','n#10085136 n#03174387 n#10042569 n#02872007 n#00743598 n#00754825',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cattività','n#10085136 n#10083885',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('detenzione','n#10085136 n#00743956 n#00743598 n#00743461 n#00754825',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incarcerazione','n#10085136 n#00754825',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prigionia','n#10085136 n#10042569',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reclusione','n#10085136 n#00743598',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agio','n#09625315 n#10364483 n#03747822 n#10396588',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('smegma','n#04206620',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sentiero_di_avvicinamento','n#06266273',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pecora','n#01908461 n#01908755 n#01909863',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavalleria','n#04571025 n#06210014 n#06207957 n#03846796',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('continental','n#N0002494',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('continental_airlines','n#N0002494',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('geum_rivale','n#08931941',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cariofillata_dei_rivi','n#08931941',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stele','n#03410436',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scomparsa','n#00029712 n#05466222',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sparizione','n#00029712 n#05466222',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forno','n#03068591 n#02238961 n#02888833',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abate','n#07053509',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbate','n#07053509',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('archimandrita','n#07053509',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mancanza_di_tensione','n#03748312',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bacino_idrico','n#03231562',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pasta','n#05671312 n#05739733',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esponente','n#04752065 n#04754148 n#05101570 n#07601722 n#07529131',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('magnesio','n#10491747',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('candela','n#03376671 n#02375096 n#09806947',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acume','n#03830400 n#04410094 n#04352743 n#03702778 n#04353391 n#04353633',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perspicacia','n#03830400 n#04410094 n#04352743 n#04353391',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sagacia','n#03830400 n#04352743',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quarzo_rosa','n#10768724',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tungstato','n#10820047',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('wolframato','n#10820047',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nastro_magnetico','n#02956039',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fuoribordo','n#03380382 n#03066305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('feto','n#00985911',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sinagoga','n#03458161',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amorpha_fruticosa','n#08805526',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indaco_bastardo','n#08805526 n#08836790',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marron_glacé','n#N0001140',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bos_taurus','n#01899570',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bestiame','n#01899570 n#01403412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vinca_minor','n#08089125',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pervinca_minore','n#08089125',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mirto','n#08089125 n#08633705',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lavoro_manuale','n#00410579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elettrolita','n#10452627',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elettrolito','n#10452627',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciglione','n#06281742 n#02636122',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('proda','n#06281742',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ipocrisia','n#05065634 n#03814194',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pantaloni_da_cavallerizzo','n#02878328',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calzoni_da_cavallerizzo','n#02878328',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pseudogap!','n#10862458 n#04514703 n#05112836 n#06309747 n#00341852 n#02818640 n#09945970 n#00868028 n#03279024 n#03426653 n#02589341 n#02384604 n#06358701 n#00286286 n#06684175 n#03968991 n#03090721 n#06006256 n#06007316 n#07635239 n#00378829 n#04384656','v#00496485 v#01331981 v#01502454 v#01515833 v#00718531 v#01459903 v#01459012 v#01262245 v#01484077 v#00680967 v#01562883 v#01857545','a#01204132 a#01204365 a#02758644 a#00535306 a#00674295',NULL);
INSERT INTO italian_index VALUES ('bigamia','n#10061658',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('senso','n#04474450 n#09959689 n#04388620 n#04952578 n#04952374 n#04546018 n#04371175 n#04951584',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dalia','n#08267880',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('linguetta','n#02694369 n#N0001060 n#03222395 n#03516340',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rom','n#03216271',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('austral','n#09826145',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('austral_argentino','n#09826145',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('borzoi','n#01601226',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('levriero_russo','n#01601226',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('armonia','n#05367418 n#05269728 n#05365111 n#10064507 n#03707811 n#10065762',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('concordia','n#05367418 n#10064507',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malese','n#07029650 n#05201258',NULL,'a#02828157',NULL);
INSERT INTO italian_index VALUES ('casata','n#09949111 n#05976484',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ceppo','n#09949111 n#02330229 n#06037572 n#10835232 n#02436842 n#09402863 n#06685337',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('discendenza','n#09949111 n#06196140 n#07441400 n#06037572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('figliazione','n#09949111',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filiazione','n#09949111',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lignaggio','n#09949111 n#06037572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('progenie','n#09949111 n#07441400 n#05976484 n#06037572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('schiatta','n#09949111 n#06037572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stirpe','n#09949111 n#06196140 n#06037572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risolino','n#05333508 n#05333415',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risatina_nervosa','n#05333508',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barbine_a_nido','n#05740939',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bassetti','n#05740939 n#N0002481',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capelli_d''angelo','n#05740939',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capellini_d''angelo','n#05740939',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capellini_fini','n#05740939',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capelvenere','n#05740939 n#09492016',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cappellini','n#05740939 n#09431486',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fedelini','n#05740939',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fidelini','n#05740939',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sopracappellini','n#05740939',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tagliolini_a_nido','n#05740939',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bellis_perennis','n#08247382',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('margheritina','n#08247382 n#08233590 n#08247174',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pratolina','n#08247382 n#08247174',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pratolina_comune','n#08247382',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amebiasi','n#10191936',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ameba','n#00919751',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('voce','n#W0021121 n#04867079 n#04754148 n#00117312 n#05272001 n#05321079 n#05496532 n#09940711 n#07669360 n#03893274 n#05297733 n#05394487 n#05507504',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('petraia','n#N0001469 n#N0001468',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pietraia','n#N0001469 n#N0001468 n#N0001784 n#N0001467',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frustino','n#03239217',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scudiscio','n#03239217 n#03611698',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('v','n#N0002270 n#09896331',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antifrasi','n#05313266',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lavasecco','n#N0001034 n#02448030',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ossimoro','n#05318823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('minaccia','n#05395993 n#05047986 n#10428546 n#05047680',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calcolatrice_da_tavolo','n#W0020976',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_ungherese','n#09839349',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('draga','n#02599972 n#03534304 n#02600137',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vicedirettore','n#N0002240 n#N0002241 n#N0002242',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('plurale','n#04753435',NULL,'a#02097385',NULL);
INSERT INTO italian_index VALUES ('economizzatore','n#07547426',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risparmiatore','n#07547426',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('supplicante','n#07471310',NULL,'a#00678984',NULL);
INSERT INTO italian_index VALUES ('supplice','n#07471310',NULL,'a#00678984',NULL);
INSERT INTO italian_index VALUES ('venere','n#06753533 n#06902723',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disgregamento','n#09732623',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disgregazione','n#09732623',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dissoluzione','n#09732623',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('virologia','n#04633565',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('blocco_dei_salari','n#00517297',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aesculus_hippocastanum','n#09067200',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('castagno_d''india','n#09067200',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ippocastano','n#09067200',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cacasenno','n#07683566 n#07359537',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('saputo','n#07683566 n#07359537',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sputasenno','n#07683566 n#07359537',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('duttilità','n#03908807 n#03922099 n#03672615',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('flessuosità','n#03908807',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pieghevolezza','n#03908807',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inghilterra','n#06495688',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('debosciato','n#07371437',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dissoluto','n#07371437',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('libertino','n#07371437',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scapestrato','n#07371437 n#07548466',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scostumato','n#07371437',NULL,'a#01485475',NULL);
INSERT INTO italian_index VALUES ('amo','n#04400452 n#02238637 n#02689196',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esca','n#04400452 n#02238637 n#04400046 n#10835821',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pania','n#04400452 n#04400046 n#10539622 n#03693651 n#00103541',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pegaso','n#06858162 n#06774523',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aneurisma','n#10149864',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lamium_album','n#09147620',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falsa-ortica_bianca','n#09147620',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ortica_morta','n#09147620',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indicativo','n#09939566 n#04791008',NULL,'a#02836978',NULL);
INSERT INTO italian_index VALUES ('gongro','n#02020387',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grongo','n#02020387',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('violazione','n#00492786 n#00492547 n#00472484 n#00480983',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sonniloquo','n#07592268',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('punteria','n#03472491',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mattina','n#10884278',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mattinata','n#10884278',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mattino','n#10884278',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ballerino','n#07098385 n#07200550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esiodo','n#N0000696',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('delichon_urbica','n#01118333',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('balestruccio','n#01118333 n#01117983',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiorino','n#09839497 n#09842781 n#09843048',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forint','n#09839497',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cristallo','n#10673916 n#03141236 n#10676696 n#02529360 n#03083020 n#02756185',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calabrone','n#07684525 n#01717294 n#01717162',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pomicione','n#07684525',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('body-building','n#00412692',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('culturismo','n#00412692',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('appassionato','n#07244924 n#07072137 n#07256227',NULL,'a#01662898 a#01662378',NULL);
INSERT INTO italian_index VALUES ('patito','n#07244924 n#07255925 n#07256227',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imposta_complementare','n#N0002760',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavolo_verza','n#08184417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prateria','n#06351167 n#06357824',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('termosfera','n#06777911',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ministro_delle_politiche_agricole_alimentari_e_forestali','n#Y0005562',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('controdado','n#02937404',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cartellone','n#05057286 n#05087726 n#02288900 n#02303171 n#03337042',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('locandina','n#05057286',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vacuità','n#10371540',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vuotezza','n#10371540',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bob','n#02306286',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scrittoio','n#03636556',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('secretaire','n#03636556 n#03296615',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eroe','n#07415836 n#04553269',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accelerante','n#10556717',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catalizzatore','n#10556717 n#07143593 n#02402854',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salix_herbacea','n#09028242',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salice_erbaceo','n#09028242',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pompa_da_bicicletta','n#02286133',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intimo','n#02929451 n#03560325',NULL,'a#00904509',NULL);
INSERT INTO italian_index VALUES ('giovenca','n#01900832',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('manza','n#01900832',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vacchetta','n#01900832 n#10583016',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ionico','n#05232952',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('economia_domestica','n#04674267',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catasto','n#04880110',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abitazione','n#00682217 n#02618194 n#02837386 n#06309630',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('residenza','n#00682217 n#06309630',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moscato','n#05795755 n#09435305 n#05924757',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sciovinista','n#07151817',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fabbricazione','n#00593550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lavorazione','n#00593550 n#00593220',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('manifattura','n#00593550 n#02662271',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tapiro','n#01891095',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('urna','n#03563683',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('harem','n#02799373',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('serraglio','n#02799373 n#02985143 n#06246575',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prora','n#02321005',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prua','n#02321005',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fotomodello','n#N0000773',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('croton','n#09220325 n#09221213',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('argomento','n#04950638 n#04596256 n#04985978 n#04949838 n#04509083',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oggetto','n#04950638 n#00009457 n#04587307 n#04477801 n#04949838',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soggetto','n#04950638 n#03435902 n#04479710 n#04761687',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tasto','n#04950638 n#02886812',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tema','n#04950638 n#05271219 n#04546376 n#05271609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tematica','n#04950638',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('hordeum_murinum','n#08430488',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orzo_selvatico','n#08430488',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aureomicina','n#02435295',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apartheid','n#06200113',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lucio_dalla','n#W0020996',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inginocchiatoio','n#03172032',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imbottigliatrice','n#N0000922',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riempibottiglie','n#N0000922',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('distorsione','n#10265793 n#05477156 n#00484452 n#07771626',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('slogatura','n#10265793 n#10263149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stiramento','n#10265793 n#10265581',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stiratura','n#10265793',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('storta','n#10265793 n#03235067',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('movimento_per_la_liberazione_dei_gay','n#00510953',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('troia','n#06453262 n#01893422 n#07507944',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tempo_supplementare','n#10943054',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prestanome','n#07281051',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immatricolazione','n#00027235 n#00810945',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intestazione','n#00027235 n#04783598 n#04783153 n#04733360',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iscrizione','n#00027235 n#04828090',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('matricolazione','n#00027235',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('registrazione','n#00027235 n#03112307 n#00584453 n#09655159 n#03220068 n#00646207 n#04984758',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tesseramento','n#00027235',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pertinenza','n#09933378 n#09934263',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diplomato','n#07071944',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciclismo','n#00286443',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('velocipedismo','n#00286443',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('saggezza','n#04020018 n#04350566 n#03830187 n#04550101',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contrattacco','n#00629424',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maometto','n#07741591',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grettezza','n#03797612 n#04704180 n#03789279 n#03788750',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sordidezza','n#03797612 n#10401319',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arrotondamento','n#03957372',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bombatura','n#03957372 n#09988640',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('convessità','n#03957372',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alimentatore','n#07613428 n#07068120 n#03299804',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fochista','n#07613428',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fuochista','n#07613428',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aria','n#03844605 n#03835766 n#10646492 n#03716758 n#06373203 n#05285570 n#00355510 n#05270417 n#03687456 n#07848889 n#03683672',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('atteggiamento','n#03844605 n#03965003 n#04696462 n#03757021',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pane','n#05721638 n#09624494 n#05725764 n#02367574',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abelia','n#08971382',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lolla','n#10621327',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('loppa','n#10621327 n#10793374',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pula','n#10621327 n#09858088',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stoppia','n#10621327',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('espettorazione','n#09717917',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spurgo','n#09717917',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('organico','n#N0001330',NULL,'a#01619269',NULL);
INSERT INTO italian_index VALUES ('personale','n#N0001330 n#06092672',NULL,'a#01702632 a#01557909',NULL);
INSERT INTO italian_index VALUES ('preghiera','n#05371420 n#05371877 n#05373078 n#00673740',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sollecitazione','n#05371420 n#06660574 n#04488721',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('atto_di_vendita','n#04913695',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cannolicchi_piccoli','n#N0002357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canoncetti','n#N0002357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fagioloni','n#N0002357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gnocchetti_di_ziti','n#N0002357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sciviottini','n#N0002357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('svoltini','n#N0002357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('svuotini','n#N0002357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ione_idrogeno','n#06690007',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aeronauta','n#07093172 n#07476655',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aviatore','n#07093172',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pilota','n#07093172 n#07476655',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mal_umore','n#05604436 n#05604874 n#05589301 n#05614356',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malumore','n#05604436 n#05604874 n#05589301 n#05614356',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malcontento','n#05604436 n#05604874',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('luna','n#06765463 n#06765228 n#06297506 n#05614509 n#03651370 n#10920638',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carbonizzazione','n#09678999',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anamnesi','n#04890314 n#04890158',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('franco','n#09840270 n#09841395 n#09865292 n#09841504 n#09840721 n#09841188 n#09841069 n#09840922 n#09840813 n#09824793 n#09840155 n#09840625 n#09841731 n#07004469 n#09841615 n#09840042 n#09840512 n#09839839 n#09841288 n#09841846',NULL,'a#02094165','r#00309575');
INSERT INTO italian_index VALUES ('franco_della_repubblica_centrale_africana','n#09840270',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('massello','n#09390143 n#02856117',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ponte','n#02337359 n#02337589 n#09932435 n#02548913 n#02336596 n#02337484 n#02229576',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orticoltura','n#N0001335',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orticultura','n#N0001335',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risonanza','n#07814762 n#07814439',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fotosintesi','n#09705163',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tronco','n#10722705 n#09450405 n#04298694',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('importazione','n#00721243 n#02852104',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('beatitudine','n#10076837 n#10076721 n#04755317',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('felicità','n#10076837 n#05595732 n#10076479 n#04490585',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('materiale_per_pavimentazioni','n#10666737',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fraternizzazione','n#00700350',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decesso','n#05479076',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('morte','n#05479076 n#10867742 n#10867885 n#07788946 n#10060259',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('roba','n#03495643 n#02987655 n#09534478 n#09528888 n#02476046 n#04384343 n#02656657 n#03608634 n#09530591 n#10446867',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cosa','n#03495643 n#W0021081 n#00020709 n#00009457 n#03643183 n#00001740 n#W0021084 n#04479075 n#09528888 n#W0021082 n#05437110 n#10047614 n#04384343 n#05041775 n#04589662 n#03495843',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panchina','n#02281262 n#02614084 n#03089500',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('centaurea_cyanus','n#08255464',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiordaliso_vero','n#08255464',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ocse','n#N0001352',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('organizzazione_per_la_cooperazione_e_lo_sviluppo_economico','n#N0001352',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('xestobium_rufovillosum','n#01683179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('granito','n#03750247 n#10681812',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accuratezza','n#03768230 n#03682241 n#03768738 n#00416445 n#03682129',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esattezza','n#03768230 n#03767665 n#03768738 n#03940380 n#03768536 n#03768956',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('precisione','n#03768230 n#03768738 n#03768536 n#03768956',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('positura','n#09960294 n#03965003',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('electrolux','n#N0002500',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('butilene','n#10604847',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('annotazione','n#05067461 n#04882396 n#00238852 n#05067694',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('commento','n#05067461 n#04412315 n#05068616',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esano','n#10697472',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giramaschi','n#03472596',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giramaschio','n#03472596',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catenaria','n#09991496',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paratiroide','n#04134463',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('digito','n#04312269',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dito','n#04312269 n#04321501 n#09817148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('permissivismo','n#03657928 n#03677991',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('permissività','n#03657928',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tarantino','n#N0002073',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tarentino','n#N0002073',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fine','n#04011535 n#10442122 n#00521308 n#10966461 n#04587307 n#00137299 n#05438448 n#03811208 n#04588033 n#10966797 n#10867885 n#00137802 n#04586952 n#06314878 n#04515461 n#05438121',NULL,'a#02126746',NULL);
INSERT INTO italian_index VALUES ('funzione','n#04011535 n#00378984 n#00667173 n#00462651 n#00666638 n#00667538 n#00663517 n#09926856 n#00462318',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impiego','n#04011535 n#00383807 n#09599330 n#00605730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ruolo','n#04011535 n#04552661 n#04874637 n#00463745 n#04875789 n#00462318',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scopo','n#04011535 n#04589281 n#04587307 n#04588033 n#04586952',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('formichiere','n#01955442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mangiaformiche','n#01955442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mirmecofago','n#01955442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banco','n#06740258 n#03399509 n#03630034 n#02558014 n#05989701 n#06227059 n#02281030 n#09616845 n#06739355 n#02508379 n#06335649 n#06377915',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barriera','n#06740258 n#02254968 n#06279059 n#00527713 n#06336706 n#06757282 n#04396152 n#04396568 n#02747160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frangente','n#06740258 n#05472145 n#10339565',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('propagatore','n#07506311',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('naiade','n#06899279',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('naide','n#06899279',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cielo','n#06749007 n#06326607 n#10413828 n#W0021178 n#02410004',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leggerezza','n#03926603 n#03721331',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assenza_di_peso','n#03926603',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stravagante','n#07359808 n#07233863',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carestia','n#10367751 n#03988194 n#10367399 n#03988043',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('penuria','n#10367751 n#10367399',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ristrettezza','n#10367751 n#10367399 n#03988043',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fibroide','n#N0000739',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fibroma','n#N0000739',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cessione','n#00139216 n#09537452 n#00718330 n#04913532',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corylus_avellana','n#08593724',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avellano','n#08593724 n#08593114',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nocciolo','n#08593724 n#08593114 n#04546812 n#08002316 n#08593406',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nocciolo_comune','n#08593724',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trafila','n#00661955 n#00660718',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('succo','n#04196137 n#04546812',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('si','n#N0001889 n#N0002449 n#05140084',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('utensileria','n#N0002206 n#N0002205',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perca','n#02047244 n#02048090',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('equipaggio','n#06100864 n#06143274 n#06142758 n#06142955',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('e','n#09964070 n#10485572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('est','n#09964070 n#06311351',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('levante','n#09964070 n#07791597 n#06516452',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sorvegliato','n#N0002253',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vigilato','n#N0002253',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grigliata','n#00157724 n#05630035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('drive','n#00375657 n#02605312',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('isterilimento','n#00179219',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esplodente','n#02652566',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esplosivo','n#02652566',NULL,'a#00442295',NULL);
INSERT INTO italian_index VALUES ('caloscia','n#02207171 n#03071419',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('galoche','n#02207171',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('hyacinthus_orientalis','n#08760079',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giacinto_comune','n#08760079',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('viaggio','n#W0021140 n#W0021139 n#10315893 n#00198579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('economia_agraria','n#N0002721',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('richmondena_cardinalis','n#01063977',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cardinale_rosso','n#01063977',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('umberto_eco','n#W0020832',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eco','n#W0020832 n#03914178',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('feudatario','n#07661487 n#07261032',NULL,'a#02814248',NULL);
INSERT INTO italian_index VALUES ('vassallo','n#07661487',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('boria','n#03828287 n#03828045 n#03778125 n#03792664 n#00489276 n#03828648 n#03828199 n#05581850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('universalismo','n#04696043',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pappo','n#08004037',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anni_ottanta','n#10873037',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bietola','n#05758316 n#05757878 n#08143087',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dolichonyx_oryzivorus','n#01096380',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bobolink','n#01096380',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sigillo','n#05029066',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inumidimento','n#00178766',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('umettazione','n#00178766',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('narcotico','n#03030428',NULL,'a#02651465',NULL);
INSERT INTO italian_index VALUES ('stupefacente','n#03030428',NULL,'a#02381427',NULL);
INSERT INTO italian_index VALUES ('mani_pulite','n#W0020855',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palingenesi','n#09709822',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('collana','n#03034095 n#04945654 n#04946210',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('collier','n#03034095 n#02436398',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('battitoio','n#03617746',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lupo','n#03617746 n#01623366',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lustro','n#00663210 n#03874115 n#03874574 n#10918305 n#10357033',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cartografia','n#00593451',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vena','n#07790084 n#06802182 n#06377915',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soviet','n#06170273',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('padovano','n#N0001359',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nastro','n#06746514 n#03470437 n#03237721 n#03237601',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('irriverenza','n#04705529',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stampa','n#06214250 n#05006705 n#03280931 n#05006313 n#03114349',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('messa','n#05274220 n#00674047',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carta_reattiva','n#03489515',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banca_centrale_europea','n#N0002716',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reykjavik','n#06539542',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disunione','n#10072577 n#10070254 n#00247314',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bilancia_commerciale','n#09658763',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stige','n#06835515',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assomiglianza','n#03727288',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sembianza','n#03727288 n#04341535',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('similarità','n#03727288 n#03728317',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('similitudine','n#03727288 n#05319077',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('somiglianza','n#03727288 n#03730047',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('furto','n#09543286 n#00499179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('punto_e_virgola','n#05127654',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('puntello','n#03178310 n#03326674',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rincalzo','n#03178310 n#07620124 n#06092042 n#03444976',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sopporto','n#03178310 n#03444976',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('supporto','n#03178310 n#00788240 n#03444976',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('influsso','n#04398446',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('influenza','n#04398446 n#04043876 n#10159752 n#04043948 n#00102269 n#07768179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asparago','n#08742749 n#05757288',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('turno_di_battuta','n#00290685',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('californiano','n#07045078',NULL,'a#02803373',NULL);
INSERT INTO italian_index VALUES ('appunto','n#05035217 n#04882396',NULL,NULL,'r#00154389');
INSERT INTO italian_index VALUES ('biasimo','n#05035217 n#05032127 n#00791599 n#05032520',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rimbrotto','n#05035217 n#05033972',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dilettante','n#07072137 n#07072312 n#07199043',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cultore','n#07072137',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amatore','n#07072137 n#07177748 n#07256227 n#07072312',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amateur','n#07072137',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vasectomia','n#00459344',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vasoresezione','n#00459344',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moralista','n#07397448 n#07418901',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lucciola','n#07658724 n#01673696',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('punteggio','n#09768132 n#04429217',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('messaggerie','n#N0001169',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cremlinologo','n#N0000501',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antonomo','n#01683376',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inferno','n#06327882 n#06328392',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('realtà','n#10055422 n#04476879 n#03738112 n#10054966',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ringhio','n#05497808',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mediana','n#04610269',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('valore_mediano','n#04610269',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barca','n#02304226 n#09920124 n#05970926 n#09920939',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('natante','n#02304226',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tucidide','n#07759735',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mimesi','n#04575395',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_algerina','n#09830954',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('poligono_di_tiro','n#03324474',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decisione','n#04496054 n#03810995 n#04887532 n#03809479 n#03811208 n#00768711 n#00105760',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('delibera','n#04496054 n#04887532',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deliberazione','n#04496054',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('determinazione','n#04496054 n#03810995 n#00558391 n#03809479 n#03811208 n#03928681 n#00105760 n#00098543',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conclusione','n#04496054 n#04822648 n#05438448 n#04515461 n#05478207 n#05438613 n#07766144 n#04456658 n#05438121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('promettente','n#07505485',NULL,'a#00824936 a#01355801',NULL);
INSERT INTO italian_index VALUES ('promittente','n#07505485',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acido_ascorbico','n#10828176',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ascorbina','n#10828176',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vitamina_c','n#10828176',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('finalista','n#07263267',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spettrometro','n#02970524',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paprica','n#05857382',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paprika','n#05857382',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piedino','n#N0001464',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dipendente','n#07240707 n#07619562',NULL,'a#02218350',NULL);
INSERT INTO italian_index VALUES ('lavoratore_dipendente','n#07240707',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assunto','n#07240707 n#05060508',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('funzionalità','n#N0000796',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbieco','n#N0001794',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sguincio','n#N0001794',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cenno','n#00216454 n#05094004 n#05085885 n#05428675 n#00796865 n#05148418 n#09919371 n#05069640 n#05069358 n#05357131',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ancoraggio','n#06362896',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fonda','n#06362896 n#03265764',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('addetto','n#07207615 n#W0021067',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('delegato','n#07207615 n#07211391',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deputato','n#07207615 n#07457674 n#07211532 n#07601722',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incaricato','n#07207615 n#07601722',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inviato','n#07207615',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mandatario','n#07207615',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seneca','n#07756278',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('servizio_sanitario_nazionale','n#W0020884',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scintoismo','n#04725965',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('economia_mista','n#N0002724',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monossido','n#10730112',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('drappeggio','n#N0001373',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panneggio','n#N0001373',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avantreno','n#N0000128',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autorizzazione','n#04922001 n#04045518 n#00737978 n#00738404 n#04916758',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mandato','n#04922001 n#10984112 n#04919548 n#04914659',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affidabilità','n#03680488 n#03679549 n#03669235',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attendibilità','n#03680488 n#03679549 n#03753074 n#03817073',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lealtà','n#03680488 n#03813378',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('serietà','n#03680488 n#03933119 n#03663574',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sincerità','n#03680488 n#03813378',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sterlina','n#09857817 n#09856822 n#09849100 n#09855787 n#09856163 n#09857079',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sterlina_siriana','n#09857817',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiliasmo','n#04694671',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('millenarismo','n#04694671',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciccia','n#05694720 n#04089143 n#04089519',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('questionario','n#04862567',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cracking','n#09682098',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ramatura','n#N0001670 n#N0001671',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('presa_di_gola','n#00520617',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ghigliottina','n#02777369',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carbone','n#10255826 n#10628288 n#10526690 n#06688669',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('golpe','n#10255826 n#N0000863 n#00742390',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amministratore','n#07063507 n#07063762',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dispensatore','n#07063507',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elemosiniere','n#07063507',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gestore','n#07063507 n#07063762',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('responsabile','n#07063507 n#07311393',NULL,'a#00316737 a#01923949',NULL);
INSERT INTO italian_index VALUES ('cinturato','n#03201490',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pneumatico_cinturato','n#03201490',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pneumatico_radiale','n#03201490',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radiale','n#03201490',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radiostazione','n#03205120',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stazione_radio','n#03205120',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tatto','n#04373543 n#04349139 n#03795428 n#03795245',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alzata_di_spalle','n#05428590',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spallucciata','n#05428590',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cryptotermes_brevis','n#01729331',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('boliviano','n#09853168 n#07008479',NULL,'a#02734327',NULL);
INSERT INTO italian_index VALUES ('arte','n#06240571 n#02213100 n#00399744 n#04353829 n#04361152 n#00598038 n#04360292 n#04360761',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('estasi','n#10076997 n#10075760',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('berretto_da_cacciatore','n#02551563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trousse','n#02650099',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('passo_falso','n#00045479',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('concessiva','n#N0000427',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frase_concessiva','n#N0000427',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('proposizione_concessiva','n#N0000427',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tayassu_pecari','n#01895225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ministero_dei_trasporti','n#Y0005557',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('partito','n#07143755 n#06131180 n#W0003024 n#W0003022',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impero','n#10987385 n#06001253 n#10362727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reparto_da_sbarco','n#06137802',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('messia','n#06890396',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sarta','n#07227102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conte','n#07232818 n#07187296',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pallone_pilota','n#03124914',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('freccetta','n#02212344 n#N0000776',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('freccia','n#02212344 n#05088636 n#05419915 n#05070533 n#05106879',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('governante','n#07539656 n#07297767 n#07328132 n#07297622 n#07427165',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reggitore','n#07539656',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('boaro','n#07189764 n#07317144',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bovaro','n#07189764 n#07317144',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cappellone','n#07189764',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vaccaio','n#07189764',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vaccaro','n#07189764',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('striatura','n#00169627 n#10022418',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imbrutimento','n#00174683',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erethizon_dorsatum','n#01849460',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ursone','n#01849460',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panamense','n#07032927',NULL,'a#02733522',NULL);
INSERT INTO italian_index VALUES ('disertore','n#07212248 n#07212424',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cabriolet','n#02362070 n#02495126',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scuola','n#03281918 n#04441381 n#10917116 n#W0021060 n#W0021059 n#06145755 n#06145154 n#06144368',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dalmatica','n#N0000516',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lato','n#06370070 n#06369892 n#03333741 n#04505726 n#04504775 n#02621671 n#06037872 n#04300182 n#06315338',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fianco','n#06370070 n#10014616 n#06261108 n#04300182 n#06724958',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fuoco_di_copertura','n#00636447',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('divismo','n#N0000593 n#N0000592',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autore','n#07288141 n#07453414 n#07689380 n#07173042',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deposito','n#06695079 n#03422136 n#09637132 n#03589200 n#00239291 n#02425619 n#03421885 n#06695617 n#02556263 n#06695748 n#05012609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('posatura','n#06695079',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sedimento','n#06695079',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decalcificazione','n#N0000525',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('suffrutice','n#09409635',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ninfea','n#08026088',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capro_espiatorio','n#07548354',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amianto','n#10558339',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asbesto','n#10558339',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('archivista','n#07082571 n#07262602',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quadriennio','n#N0001620',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pseudoscienza','n#04455337',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parco_archeologico','n#W0021007',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('preconcetto','n#04567357 n#04701316 n#04567625',NULL,'a#02883282',NULL);
INSERT INTO italian_index VALUES ('maschera','n#03308030 n#02969632 n#03686637 n#02576738',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('visone','n#10585935 n#03003494 n#01938744',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mandarino','n#07393237 n#09009987 n#09009593',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('estremo','n#06314762 n#06316818 n#03989021 n#07282454 n#03976704',NULL,'a#01449238',NULL);
INSERT INTO italian_index VALUES ('salvadoregno','n#07013083',NULL,'a#02735773',NULL);
INSERT INTO italian_index VALUES ('espressione','n#04765594 n#03779255 n#W0003126 n#05149034 n#05046501 n#05349662 n#03687456 n#05341816',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('confiteor','n#N0000438',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('silofonista','n#07690560',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('xilofonista','n#07690560',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('galletto','n#01310354 n#03624800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pollastro','n#01310354 n#07156174',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giobbe','n#07731752',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elettrone','n#06678414',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brucellosi','n#10241035 n#10132832',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nota','n#04882396 n#W0003132 n#W0003133 n#05067694 n#04866394 n#05137303 n#W0003134 n#04504455 n#W0003131',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('commerciante','n#07646824 n#07572257',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esercente','n#07646824 n#07572257',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mercante','n#07646824 n#07572257 n#07531407 n#07405825',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('negoziante','n#07646824 n#07572257',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('addizionale','n#09585811',NULL,'a#00048219',NULL);
INSERT INTO italian_index VALUES ('imposta_addizionale','n#09585811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sopratassa','n#09585811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soprattassa','n#09585811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sovraimposta','n#09585811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sovrimposta','n#09585811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('criminologia','n#04675763',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anniversario','n#10955913',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('annuale','n#10955913',NULL,'a#02489110',NULL);
INSERT INTO italian_index VALUES ('ricorrenza','n#10955913 n#05471329',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('integrazione','n#00779108 n#03984819 n#00699519 n#00560004 n#00803600',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('annodamento','n#02896406 n#00097058',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nodo','n#02896406 n#10004685 n#06269762 n#04955853 n#02882195 n#04546812 n#10836587',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dogma','n#04573886 n#05085310',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('domma','n#04573886 n#05085310',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('divisa','n#05350422 n#03560722',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('motto','n#05350422 n#05350719 n#05075890 n#05350961',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('slogan','n#05350422',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forchetta_da_dolce','n#W0007448',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('offertorio','n#00669219 n#09549479',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('u.s.l.','n#N0002211',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pressa_tipografica','n#03170463',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stampatrice','n#03170463 n#03173458',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('torchio','n#03170463 n#03170199',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('torchio_da_stampa','n#03170463',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nb','n#10494151',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('niobio','n#10494151',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maldive','n#06547562',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ginevra','n#06588141',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('flatulenza','n#10110433',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pediculus_humanus','n#01689204',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pidocchio','n#01689204 n#01688605',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pizz.','n#N0001487',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pizzicato','n#N0001487 n#N0001488',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raschietto','n#03285824',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chicane','n#02429109',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pterocles_alchata','n#01333483',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grandule','n#01333483',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('walter_gropius','n#07723054',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tribalismo','n#06152795',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('linea_del_cambiamento_di_data','n#06342277',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bibos_gaurus','n#01906771',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gaur','n#01906771',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('onomastico','n#10933322',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spaghettata','n#N0001953',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sopra_mano','n#03612452',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sopraggitto','n#03612452',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sopramano','n#03612452',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soprammano','n#03612452',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filosofia','n#04678959 n#04564119 n#04563224',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mammogramma','n#02962536',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('emettenza','n#07803999',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radianza','n#07803999',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monodia','n#05267811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conduttura_del_gas','n#02744517',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caposcalo','n#N0000277',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiacchiera','n#05394950 n#05339413 n#05338361 n#03666824 n#05394487 n#05394227',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('favola','n#05394950 n#05393346 n#05393724 n#04803601 n#05063391',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lazzaro','n#07366796 n#07366918 n#07369509',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monte_dei_paschi_di_siena','n#N0002590',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('battello_pneumatico','n#02572035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canotto','n#02572035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deriva','n#02572035 n#02682560 n#09679414 n#03573455 n#02412789',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capriccio','n#05568649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('estro','n#05568649 n#04492995 n#04356736 n#04355268 n#03654412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fantasia','n#05568649 n#04357681 n#05282273 n#04356866 n#04531761',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ghiribizzo','n#05568649 n#04545843',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grillo','n#05568649 n#01733061',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ruzzo','n#05568649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('schiribizzo','n#05568649 n#04545843',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfizio','n#05568649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sghiribizzo','n#05568649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ticchio','n#05568649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('afrore','n#04415512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammorbamento','n#04415512 n#05482154',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bestino','n#04415512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('effluvio','n#04415512 n#04415246 n#03892211',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fetidume','n#04415512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fetore','n#04415512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leppo','n#04415512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lezzo','n#04415512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('miasma','n#04415512 n#10412995',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('olezzo','n#04415512 n#04415246',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pestilenza','n#04415512 n#10169961',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('puzza','n#04415512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('puzzo','n#04415512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('puzzore','n#04415512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sito','n#04415512 n#06279834',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tanfo','n#04415512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zaffata','n#04415512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gioiello','n#02751705 n#07348247',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tesoro','n#02751705 n#06054116 n#N0002674 n#07626006 n#06251482 n#09617409',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ferrari','n#N0002509',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vasocostrittore','n#03568168',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('illegalismo','n#03773873',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('illegalità','n#03773873 n#03774303',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grafomania','n#N0000873',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cartina','n#10626396 n#02592220 n#02965788 n#03075275',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parità','n#03730853 n#03730389 n#10049536',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crataegus_monogyna','n#08927923',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biancospino_comune','n#08927923',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('registratore_a_nastro','n#03471806',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('magnetofono','n#03471806',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capo_cannoniere','n#N0000269 n#N0000268',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capocannoniere','n#N0000269 n#N0000268',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('html','n#05084264',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricettario','n#N0001706 n#04833225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('osso_buco','n#05900614',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ossobuco','n#05900614',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dittamo','n#09012258',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frassinella','n#09012258',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frassinello','n#09012258',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cucciolo','n#07195668 n#00866124 n#00866478 n#00866210 n#07512439 n#00866417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('novellino','n#07195668 n#07435971',NULL,'a#00889682',NULL);
INSERT INTO italian_index VALUES ('pischello','n#07195668',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pivello','n#07195668',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('addome','n#04304826',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gozzo','n#04304826 n#01486270 n#10206133 n#04296952',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pancia','n#04304826 n#04304039 n#04194181',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ventre','n#04304826 n#04275292',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cassiere','n#W0005149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elsa','n#02819308',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('considerazione','n#04459519 n#00797991 n#10358350 n#05575841 n#04485138 n#05609011',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assicurazione_sociale','n#00704218',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acquafortista','n#07248516',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piumino','n#02623403 n#03166914 n#N0000617',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piumone','n#02623403 n#03196324 n#03196513',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trapunta','n#02623403 n#03196324',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pavana','n#00338236 n#05290518',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autodidatta','n#07092493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricevitore','n#03217746 n#03204772 n#07143863 n#03479726',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ghiandola_pituitaria','n#04252063',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ipofisi','n#04252063',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('kuwait','n#06524273 n#06523999',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('kuwait_city','n#06524273',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bugiardello','n#07613929',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bugiardo','n#07613929 n#07370590',NULL,'a#02343098',NULL);
INSERT INTO italian_index VALUES ('aerobica','n#00412575',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('modalità','n#00660588 n#03856995',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('procedura','n#00660588 n#00378984 n#00660718',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falangista','n#01397149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('omnibus','n#02832793',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('massima_allerta','n#W0020930 n#W0020929',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('passato_prossimo','n#09943448',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('occasione','n#06660089 n#10046803 n#05538537 n#05519482 n#10390345',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bollito','n#N0001042',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lesso','n#N0001042 n#N0001043',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_indonesiana','n#09863098',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('censura','n#05035457 n#00254803 n#06171035 n#05032520',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('creatura','n#07192170 n#07094006 n#00008019',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tracheotomia','n#00444856',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('torero','n#07099090',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('toreador','n#07099090',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('matador','n#07099090',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('espada','n#07099090',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('continente','n#06741106 n#06835944',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('terra_ferma','n#06741106 n#06667942',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('terraferma','n#06741106 n#06667942',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('illiberalità','n#03789472',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mesozoico','n#10853759',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cooperativa','n#00713097 n#06107474',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('censore','n#07194134 n#07145617 n#07532143 n#07194002',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('critico','n#07194134 n#07194366 n#07194002',NULL,'a#00610721 a#00614865',NULL);
INSERT INTO italian_index VALUES ('angelica','n#09229578 n#09229311',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('profitto_lordo','n#09541774',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caso','n#10388744 n#04481649 n#10047274 n#04762523 n#07769986 n#05447746 n#05443380 n#05448971 n#07618819',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('possibilità','n#10388744 n#04568501 n#04526699 n#10390345 n#04464471',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('franco_della_nigeria','n#09841395',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vescicatorio','n#10843517',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('battitura','n#00252246 n#04825639',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trebbia','n#00252246',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trebbiatura','n#00252246',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giallo','n#03881286 n#04802962 n#04803137',NULL,'a#00364444',NULL);
INSERT INTO italian_index VALUES ('eterosessuale','n#07318983',NULL,'a#01151057',NULL);
INSERT INTO italian_index VALUES ('tipizzazione','n#04446932',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('linfa','n#04199393 n#10658434',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('le','n#N0002414',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lecce','n#N0002414',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('golpista','n#N0000864',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('debilitazione','n#05463089 n#10431905',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('illanguidimento','n#05463089 n#05455349',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfinitezza','n#05463089',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('snervamento','n#05463089',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('obliquità','n#03850525 n#03954441',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bolero','n#02309121 n#05289561',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('montante','n#03563178 n#03433179 n#00761303 n#02759209',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('montante_verticale','n#03563178',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('supporto_verticale','n#03563178',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tovaglia','n#03462134',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capsula','n#02382887 n#02380860 n#04126094 n#02559765 n#02382765 n#07998889 n#03107137',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cassula','n#02382887 n#02380860 n#04126094 n#02559765 n#02382765 n#07998889 n#03107137',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cacata','n#10654789 n#04005013',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cacca','n#10654789',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('merda','n#10654789',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stronzo','n#10654789',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canonica','n#03090389',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pievania','n#03090389',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('casa_parrocchiale','n#03090389',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moda','n#04437019 n#00265102 n#04436610 n#04610174',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ponte_radio','n#03203923',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radiocollegamento','n#03203923',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiocco','n#02321186 n#02876798 n#02321305 n#07836155',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('flocco','n#02321186 n#02876798 n#02321305 n#07836155',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alleggerimento','n#00228188',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alleviamento','n#00228188 n#05570696 n#05480231',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attenuazione','n#00228188 n#00227941 n#00227088 n#00225760',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lenimento','n#00228188',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sgravio','n#00228188',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('podista','n#N0001502 n#N0001503',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('movimento_no_global','n#W0020825',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('presbite','n#07494688',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fondazione','n#06216338 n#00153747',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ecogoniometro','n#03369110',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ecometro','n#03369110',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ecoscandaglio','n#03369110',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sonar','n#03369110',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bahrein','n#06490096',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tragicommedia','n#05263002',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caduta','n#05455763 n#00039842 n#05483545 n#00488126 n#00045686 n#05454273',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crollo','n#05455763 n#05559582 n#10394468',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rovina','n#05455763 n#05465857 n#10441658 n#03261457 n#00141690',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cerfoglio','n#05849715 n#09230111',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cerfuglio','n#05849715 n#09230111',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bombardamento','n#00626813 n#00629628 n#00636753',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incursione_aerea','n#00626813',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tradizione','n#04476782 n#04381279',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dinaro','n#09831065 n#09857563 n#09832220 n#09832490 n#09832911 n#09833267 n#09831427 n#09831972 n#09834042 n#09833550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dinaro_algerino','n#09831065',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gitante','n#07575465',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('borsa_di_parigi','n#02320313',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('terbio','n#10503800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rota','n#06180627',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aizzamento','n#00101901',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fomentazione','n#00101901',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('istigazione','n#00101901 n#00819194',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('energia_solare','n#07836720',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('solare','n#07836720',NULL,'a#02604217',NULL);
INSERT INTO italian_index VALUES ('girello','n#05705997 n#03585100 n#05705747',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mediazione','n#00805906 n#06014906 n#06005684',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capo_supremo','n#07451003',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dominatore','n#07451003',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deserto','n#06273995 n#06273244',NULL,'a#01258382',NULL);
INSERT INTO italian_index VALUES ('autobus','n#02653414 n#02356526',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('battaglia','n#00758807 n#00610417 n#00614914',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('certame','n#00758807 n#00757193',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('combattimento','n#00758807 n#00610417 n#05554348 n#00614914 n#00619159',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lotta','n#00758807 n#00505798 n#00610417 n#00512068 n#00614914 n#05369724 n#00283913',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rissa','n#00758807 n#05369177 n#00762195',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('uria_aalge','n#01559083',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('uria','n#01559083 n#01558437',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tela_rigida','n#02345409',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zampata','n#N0000904',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frazione_propria','n#09890251',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bruma','n#01479580 n#07818537 n#01479366 n#07805661',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('neonato_cianotico','n#07116336',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fucile_da_caccia','n#03328179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inattaccabilità','n#10426162',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('invulnerabilità','n#10426162',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disfattismo','n#05607104',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foto_segnaletica','n#03023146',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anas_discors','n#01365222',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marzaiola_americana','n#01365222',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dentista','n#07210258',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('odontoiatra','n#07210258 n#07210147',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colpa','n#05602697 n#10078983 n#00042411 n#00488251 n#03680230',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('senso_di_colpa','n#05602697',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('testimone','n#07684230 n#07598298 n#02265270',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trealberi','n#N0002154',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('smercio','n#00721968',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pollo','n#01309561 n#05690400 n#07361941 n#07156174',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arpia','n#06855817 n#07669131 n#01136142',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caviale','n#05833705',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('croce','n#02527154 n#02522816 n#10385582 n#03688685 n#02523138',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crocefisso','n#02527154',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crocifisso','n#02527154',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anti-doping','n#N0000067',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antidoping','n#N0000067',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('circonflessione','n#05450454',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incurvatura','n#05450454 n#03959291',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stuello','n#03468277',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tampone','n#03468277 n#03076351 n#10599928',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zaffo','n#03468277 n#02353326',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strada_secondaria','n#03334945 n#02361756',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bacca_di_sambuco','n#05800798',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_tunisina','n#09833403',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiave','n#02886601 n#03619060 n#04465927 n#04872897 n#05134911 n#03634929',NULL,'a#01224859',NULL);
INSERT INTO italian_index VALUES ('viscere','n#04112526 n#06281317 n#04112790 n#05695897',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('terna','n#N0002095 n#N0002096',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crema_depilatoria','n#10641287',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('depilatorio','n#10641287 n#02556156',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reattività','n#04372357 n#10424196',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vermicelli','n#05741368',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lobotes_surinamensis','n#02126121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pesce_foglia','n#02126121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conformità','n#03708250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aerologia','n#04656651',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ruota_di_mulino','n#03000592',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sloveno','n#05207068 n#07051440',NULL,'a#02731765',NULL);
INSERT INTO italian_index VALUES ('oleografia','n#N0001312 n#N0001311',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('secreta','n#N0001849',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('segreta','n#N0001849',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raggio_di_sole','n#07820545',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monumentalità','n#N0001226',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teleinformatica','n#N0002087',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('telematica','n#N0002087',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bambù','n#08453498 n#08453185',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accesso','n#10337658 n#02641840 n#00362034 n#10134893 n#04031707 n#02159544 n#00810466 n#10135947',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bizza','n#10337658',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('washington','n#06606702 n#07762731 n#06644983 n#06188340',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pataca','n#09852626',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pataca_di_macao','n#09852626',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('semestre','n#10936586 n#10917979',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piano_generale','n#04534328',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('progetto_di_massima','n#04534328',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('criolite','n#10517380',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alessandria','n#06507776 n#N0002376',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gesto','n#00215081 n#00796865 n#05146366',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moto','n#00215081 n#00411620 n#00617685',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antispastico','n#02198410',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baggianata','n#04959357 n#00330677',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('boiata','n#04959357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciarpame','n#04959357 n#10656895',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('citrullaggine','n#04959357 n#04366309 n#00810350',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cretineria','n#04959357 n#04366309 n#00810350',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fesseria','n#04959357 n#00810350 n#04483642',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imbecillaggine','n#04959357 n#04367467 n#04366309',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immondizia','n#04959357 n#06213342 n#10656895',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pattume','n#04959357 n#10656895 n#10656657',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sciocchezza','n#04959357 n#03831006 n#04366309 n#00810350',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spazzatura','n#04959357 n#10656895 n#10656657',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fata','n#06892480 n#N0002573 n#N0000714',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spiritello','n#06892480 n#06892899 n#06894980',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polca','n#05290608 n#00347286',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polka','n#05290608 n#00347286',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('equitazione','n#00285479 n#04360982',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deuterio','n#10489093',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('potentino','n#N0001557',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nettapiedi','n#02590495',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stoino','n#02590495',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stuoino','n#02590495',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zerbino','n#02590495',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lisoformio','n#10723551',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ipecacuana','n#02866601',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guardalato','n#02345631',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paglietto','n#02345631',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parabordo','n#02345631',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rangoon','n#06412530',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ratealizzazione','n#N0001681',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rateazione','n#N0001681',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rateizzazione','n#N0001681',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ratizzazione','n#N0001681',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('astensione','n#03824571',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('narcolessia','n#10271937',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('special','n#05263312',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cinghia','n#02441722 n#02280467 n#03425180 n#02280226 n#03425471',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sottopancia','n#02441722',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maga','n#07593963 n#07241906',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('galeopsis_tetrahit','n#09145368',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canapetta_comune','n#09145368',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('repentinità','n#03950179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('repenza','n#03950179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiave_di_sol','n#05135154',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiave_di_violino','n#05135154',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polo','n#06352396 n#03152625 n#04568058 n#03488132 n#00304385 n#03154406',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zingaresco','n#05226279 n#07306569',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scabbiosa','n#08983502 n#08983118',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scabiosa','n#08983502',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riminese','n#N0001719',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cerna','n#05813546 n#02058612 n#02059124 n#00104850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cernia','n#05813546 n#02058612 n#02059124',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lavoro','n#03629197 n#00383807 n#00377835 n#00461778 n#00381958 n#10063469 n#03631348 n#07795444 n#W0021079 n#00408411',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('opera','n#03629197 n#00377835 n#06004173 n#03052506 n#05268918',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cisterna_d''acqua','n#02445178',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('serbatoio_d''acqua','n#02445178',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('desinare','n#05629070 n#05628658','v#00794350',NULL,NULL);
INSERT INTO italian_index VALUES ('cena','n#05629070 n#06130676 n#05629292',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('potere','n#07491804 n#06071657 n#04041746 n#10048361 n#04349777','v#01858855 v#01857455 v#01858531',NULL,NULL);
INSERT INTO italian_index VALUES ('stato_maggiore','n#06215072',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marsigliese','n#05285389 n#N0001141',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giorno_del_giudizio','n#10889566',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('plurilaureato','n#N0001496',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('etrusco','n#N0000676 n#N0000675',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asta','n#03152394 n#04279799 n#03375426 n#00057368 n#03152823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palo','n#03152394 n#03161694 n#02759209',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spettatore','n#07598298 n#06103316',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gabinetto','n#02898427 n#06201641 n#03183996 n#06168226 n#02704831 n#03512626 n#03448680',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('laboratorio','n#02898427 n#03632186',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nerone','n#N0001306',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ghirigogolo','n#05092826 n#04827107 n#02204650 n#N0000834',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ghirigoro','n#05092826 n#04827107 n#02204650 n#N0000834',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bombus','n#01713579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('specialità','n#04407960 n#04019345',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anguilla','n#05819077 n#02018886',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stridulazione','n#05505195',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('detrito','n#10657029 n#10655853',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macerie','n#10657029',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfasciume','n#10657029',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cianfrusaglia','n#10657029 n#02335595',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('yuan','n#09867531',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('yuan_cinese','n#09867531',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('yuan_renminb','n#09867531',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ordine_cronologico','n#W0020990',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('drago','n#01209403',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idromele','n#05915535 n#05915755',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('celere','n#N0000326',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veloce','n#N0000326',NULL,'a#00925538 a#00928268','r#00285860 r#00102338 r#00083181 r#00082992');
INSERT INTO italian_index VALUES ('marasma','n#10206457 n#10068579 n#09730726',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marasmo','n#10206457 n#10068579 n#09730726',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pronome_relativo','n#04774997',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('noctiluca','n#00944417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nottiluca','n#00944417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aix_sponsa','n#01368907',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anatra_sposa','n#01368907',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bilateralità','n#03953653',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('peso_medio','n#07408168 n#07408269',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('faggina','n#05806582',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('faggiola','n#05806582',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sole','n#07797906 n#06765647 n#07621466 n#W0021145 n#06311854 n#07820384 n#W0021142 n#06765862',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imbarbarimento','n#00174855',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comitato_direttivo','n#06174596',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aninga','n#01566157',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sadismo','n#05571062',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cipro','n#06436334 n#06436474',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('azienda_produttrice','n#06007767',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fabbricante','n#06007767',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impresa_industriale','n#06007767',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('produttore','n#06007767 n#07503790 n#07573249 n#07394756',NULL,'a#01796064',NULL);
INSERT INTO italian_index VALUES ('tintoria','n#N0002109 n#02448030',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banda','n#06123389 n#06143363 n#02245210 n#02245671 n#06123956 n#02281793 n#06119534 n#02341276 n#04734266 n#03430059',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('musica','n#06123389 n#05105195 n#W0003184 n#05266809 n#W0021141 n#00351993 n#04417946',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bluff','n#00487962 n#05065298',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ferracavallo','n#07257526',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maniscalco','n#07257526',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rilettura','n#N0001717 n#04552190',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capriola','n#00277973 n#00276981',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coccige','n#04093602',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decenza','n#03816325 n#03837593 n#03836634',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rispettabilità','n#03816325 n#03816122',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pagophilus_groenlandicus','n#01591325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foca_della_groenlandia','n#01591325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monopolio','n#10363684 n#10363824',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acetamide','n#10548181',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sorpresa','n#05442564 n#05582875',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('angolano','n#07005835',NULL,'a#02795206',NULL);
INSERT INTO italian_index VALUES ('crudeltà','n#05579830 n#00270022 n#03787057 n#03797439',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ferocia','n#05579830 n#03786594 n#03933665',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inumanità','n#05579830 n#03786244 n#00270190',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spietatezza','n#05579830 n#03787057',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fuggevolezza','n#03946031',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('precarietà','n#03946031',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfuggevolezza','n#03946031',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('transitorietà','n#03946031 n#03945930',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ben_pensante','n#07178934',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('benpensante','n#07178934',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conformista','n#07178934',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ohio','n#06635061',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capestro','n#02797601 n#03044012 n#02788197',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diffrazione','n#07790706',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('turkmeno','n#07041700 n#05190128',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cane_per_ciechi','n#01618944',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('campione_casuale','n#04613332',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('medusa','n#01424434 n#01424891 n#06856453',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('terzo','n#09891488',NULL,'a#02105047','r#00099777');
INSERT INTO italian_index VALUES ('episodio','n#04821284 n#04966736 n#05447746 n#05432762 n#05437235',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('semeiotica','n#N0001854',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gorilla','n#07117864 n#01975051 n#01975299',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guardia_del_corpo','n#07117864 n#06097890',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scorta','n#07117864 n#09625793 n#00530280 n#07247289',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paramezzale','n#02884362',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scivolo','n#02439738',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cimurro','n#10242660 n#10242523 n#10242809',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attualità','n#03942477 n#10054722',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aostano','n#N0000076',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('manicotto','n#03022572 n#02510482',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lucido','n#10762297 n#03874115 n#03577534 n#03874574',NULL,'a#02131758',NULL);
INSERT INTO italian_index VALUES ('cannella','n#03595967 n#08016232 n#03469972 n#02668719 n#08016493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('data','n#10880601 n#10880047 n#00015594 n#10880228 n#03939250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bronzina','n#02357396 n#10593349',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risicoltore','n#N0001728',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risicultore','n#N0001728',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('curiosità','n#02535416 n#04392100 n#04392619',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rarità','n#02535416 n#03988291',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('straglio','n#03445888 n#03405460',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strallo','n#03445888 n#03405460',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immersione','n#00178533 n#05484185',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alimentazione','n#05625967 n#05617971 n#00537892 n#09707335 n#00684853',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alimento','n#05625967 n#05834217',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nutrimento','n#05625967 n#00684853',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nutrizione','n#05625967 n#00537892 n#09707335 n#00684853',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sostentazione','n#05625967',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('manifestazione','n#05458088 n#00763104 n#05148820 n#05149034 n#04964487 n#05389120',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('difensiva','n#04697205',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('genitori','n#W0021135',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riconoscenza','n#05578355 n#05578169',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mostruosità','n#05485970 n#03695990',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gallese','n#07049309 n#05220666',NULL,'a#02865629',NULL);
INSERT INTO italian_index VALUES ('bisesto','n#10879895',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bissesto','n#10879895',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antieroe','n#07318129',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mitraglia','n#02950759 n#02767115',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mitragliatrice','n#02950759',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aerolinea','n#02173575',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aviolinea','n#02173575',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('linea_aerea','n#02173575 n#06339179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compagnia_aerea','n#02173575',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('commissariato','n#03153264',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gendarmeria','n#03153264 n#06093865',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polizia','n#03153264 n#06093563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('questura','n#03153264 n#06093563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anteprima','n#05154201',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vernissage','n#05154201',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iucca','n#08783514',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('yucca','n#08783514',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autoanalisi','n#00451975 n#04460553',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frutto_dell''albero_del_pane','n#05790501 n#05790260',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('micromyx_minutus','n#01834123',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('topolino_delle_risaie','n#01834123',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trappola_per_topi','n#03020320',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trappola_per_i_topi','n#03020320',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pleistocene','n#10852471',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('efebo','n#N0000629 n#N0000628',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scissura','n#04060594 n#00248000 n#10021740 n#06699238 n#10022307',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dittongo','n#05322316',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('combriccola','n#06143363 n#06117365 n#06126536 n#06119534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('congrega','n#06143363 n#06119534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cricca','n#06143363 n#06117365 n#06117752 n#06119534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gang','n#06143363 n#06119534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ganga','n#06143363 n#06119534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ghenga','n#06143363 n#06119534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intruppamento','n#06143363',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gruppo','n#06143363 n#W0003086 n#06046149 n#W0003073 n#00017954 n#W0003072 n#05968793 n#W0003071 n#W0003070 n#04606861 n#W0003074',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('taglierina_per_carta','n#03086538',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raffilatoio','n#03086538',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('congregazione','n#00799654',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('adobe','n#02166794 n#10627464',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('insonorizzazione','n#N0000978',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('etimo','n#04754049',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calzettaio','n#07326509',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anni_cinquanta','n#10872420',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('atonia','n#10430461',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('meridiana','n#03442091',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sensibilità','n#04372027 n#05584512 n#03795428 n#03796176',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pericolosità','n#10428849',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rischiosità','n#10428849',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cerbottana','n#02301578',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bolla','n#04274363 n#06802591',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('galla','n#04274363 n#09391912',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vescica','n#04274363 n#04269872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incompatibilità','n#03708738',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('peptide','n#10568946',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('para','n#09834170 n#10770273',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('para_yugoslavo','n#09834170',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deuteronomio','n#04848711',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frustrazione','n#05605777 n#05603599',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sconfitta','n#05605777 n#05558471',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ingegneria','n#04660658',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tecnologia','n#04660658 n#00607693',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('articolo','n#04867981 n#04771731 n#04819775 n#00012704 n#04819171 n#04739220 n#00714373 n#02869267',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('notizia','n#04867981 n#04982831 n#05009122 n#04983034 n#06250971',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arrosto_di_manzo','n#05707391',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rosbif','n#05707391',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sottogruppo','n#05992669',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parlamento','n#06169549',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('et','n#06849257',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alieno','n#06849257',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('extraterrestre','n#06849257',NULL,'a#02594502',NULL);
INSERT INTO italian_index VALUES ('scrittore','n#07690416 n#07689380',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intellettualoide','n#N0000982',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('casalinga','n#07328822',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('massaia','n#07328822',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gloria','n#10358076 n#03690420 n#10359466 n#10357033 n#10358202',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('congresso_degli_stati_uniti','n#06069858',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('congresso','n#06069858 n#06168957 n#06169061 n#06240467 n#06166581',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iperglicemia','n#10277060',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contea','n#06308208 n#06300934',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cronista','n#07156088 n#07167670 n#07169294',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cisl','n#W0021033',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('confederazione_italiana_sindacati_lavoratori','n#W0021033',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('politeismo','n#04716413',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marinaio','n#07116457 n#07396425 n#07543103',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gnocchetti_sardi','n#N0002352',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dollaro','n#09836906 n#09836223 n#09835640 n#09835308 n#09834923 n#09837433 n#09834813 n#09836130 n#09835120 n#09824246 n#09836611 n#09835946 n#09836813 n#09648610 n#09836322 n#09836515 n#09835735 n#09836714 n#09835023 n#09837118 n#09835213',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dollaro_di_trinidad_e_tobago','n#09836906',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dizione','n#05402056 n#05298487',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('recita','n#05402056 n#00062703',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('recitazione','n#05402056 n#00358063',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arresto','n#02404024 n#10085503 n#05485275 n#00054269 n#05486357 n#00811760 n#00743956 n#00743598 n#10094970',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scala','n#03398827 n#09951604 n#05967405 n#09951076 n#02899686 n#09978973',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tiro_alla_fune','n#05555687',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('matrice_non_singolare','n#06140549',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('onnipotenza','n#10373995',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('concupiscenza','n#05566935 n#05568116',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fabbrica_d''armi','n#02211136',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('emulsionante','n#10518399',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('andromeda','n#06774645',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arrivo','n#06318648 n#00025788 n#00025919',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('traguardo','n#06318648',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affisso','n#02692001 n#04760693',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pizza','n#05901506 n#07121483 n#03223071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ioga','n#04723635',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('yoga','n#04723635',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comunione','n#00668949 n#09526012 n#05338004 n#00669358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corpo_di_cristo','n#00668949',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eucarestia','n#00668949',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eucaristia','n#00668949',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rollino','n#03247794',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rotolo_di_pellicola_fotografica','n#03247794',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rullino','n#03247794',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('preludio','n#05278787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ferma','n#10986027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aix_galericulata','n#01369165',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anatra_mandarina','n#01369165',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autoadesivo','n#N0000103',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amministrazione','n#06071657 n#00734610 n#00736489 n#00728919',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('organizzazione','n#06071657 n#00650412 n#04423455 n#05997592 n#06142606 n#00737011',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ro','n#N0002445 n#05119423',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rovigo','n#N0002445',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('costruzione','n#03431817 n#00585093 n#02347413 n#04764807',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('struttura','n#03431817 n#03860008 n#04423204 n#02720094 n#03858780 n#03343262',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conquista','n#00036271 n#00054499',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conseguimento','n#00036271 n#00020977 n#00026147',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raggiungimento','n#00036271 n#00020977 n#00026147',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('realizzazione','n#00036271 n#00020977 n#00729882 n#00061811 n#00593220',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('successo','n#00036271 n#05556959 n#10383516 n#00037139 n#05454715 n#00036683',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risultato_ottenuto','n#00036271',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spigolatura','n#N0001969',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interdetto','n#05032638',NULL,'a#01340247',NULL);
INSERT INTO italian_index VALUES ('coppa_campioni','n#W0020802',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coppa_dei_campioni','n#W0020802',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('champions_league','n#W0020802',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frequentatore_di_cinema','n#07422194',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radiologo','n#07518211 n#07518006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gleditsia_triacanthos','n#08796673',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spino_di_giuda','n#08796673',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('berillo','n#10513798',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veronese','n#W0005538',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('levigatrice','n#02345767',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pulitrice','n#02345767',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('concilio','n#06167560',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('consiglio','n#06167560 n#05002688 n#06167708 n#06171035 n#04987832',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mandrillus_sphinx','n#01981102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mandrillo','n#01981102 n#07546984',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cornice','n#02503135 n#10409788 n#03009661 n#03009795 n#06740141 n#03118793',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calcinatura','n#09685002',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calcinazione','n#09685002',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('allarme_rosso','n#W0020929',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arrotino','n#N0000084',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marsupiale','n#01390439',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gruppo_scissionista','n#06126017',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sincizio','n#04344600',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orchestra_sinfonica','n#06123240',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rimessa','n#09573530 n#00205632 n#00066551 n#03421885',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forza_di_vendita','n#06053601',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reparto_vendite','n#06053601',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erba_medica','n#05835708 n#08850067',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dossier','n#04884887',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fascicolo','n#04884887 n#04833775 n#04948541 n#04885060 n#04819060',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incartamento','n#04884887 n#04859637',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inserto','n#04884887 n#04821765 n#02537688',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pratica','n#04884887 n#00469856 n#00574902 n#00415881 n#00263204',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('culto_degli_eroi','n#05576222',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soggettivismo','n#04584390 n#03831862',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('albicocca','n#05786840',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tiraggio','n#N0002111',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piattello','n#02447843',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tubolo','n#04074267',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tubulo','n#04074267',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ionosfera','n#06333615',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('osmio','n#10495044',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('semita','n#06963273',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciclone','n#07788622 n#07848713 n#07294789 n#10415056',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('similpelle','n#02915280',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('skai','n#02915280',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vinilpelle','n#02915280',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('benefattore','n#06941293',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('beneficatore','n#06941293',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filantropo','n#06941293 n#07472469',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbarramento','n#02254968 n#02543705 n#00636753',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('transenna','n#02254968',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brenta','n#N0002298',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('berteroa_incana','n#08182864',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('berteroa_comune','n#08182864',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diceros_bicornis','n#01890676',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rinoceronte_nero','n#01890676',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_giapponese','n#09867021',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ferroviere','n#07648382',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mephitis_macroura','n#01942218',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('criceto_comune','n#01844381',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('precipitato','n#10453574',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fruttosio','n#10669516',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('levulosio','n#10669516',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cocuzzolo','n#04291138 n#06349777 n#10019938',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cucuzzolo','n#04291138 n#06349777 n#10019938',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perodicticus_potto','n#01993326',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('potto','n#01993326',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rachide','n#09418773',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('olio_di_fegato_di_merluzzo','n#10629259',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('defaillance','n#10126818',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stilita','n#07618464',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stilite','n#07618464',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pietra_angolare','n#02502491',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diamante','n#09629713 n#02257745 n#10641843',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clava','n#02302074 n#02854040 n#02458268',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('doppia_negazione','n#05383624 n#05383493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piano_di_incentivazione','n#09551334',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piega','n#10021865 n#04257600 n#03145196',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raschiatura','n#06687879',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eccezione','n#04484227 n#05386564 n#04409604 n#00475542 n#05386266',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chemioterapia','n#00452519',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pantelleria','n#N0002314',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piloro','n#04287454',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('infrarosso','n#03947354 n#07807882',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('microcircuito','n#02861559',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acculturazione','n#00731251 n#04440948',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sopraconduttore','n#N0002037',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('superconduttore','n#N0002037',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('albo','n#04883282 n#02350716 n#03118679 n#04948442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('registro','n#04883282 n#03420412 n#03993852',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('punto','n#03415353 n#W0021101 n#10898122 n#04824319 n#09869507 n#05126526 n#06351684 n#10025218 n#10044643 n#09780630 n#04514257 n#W0021103',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('desinenza','n#09941320 n#04760179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('consob','n#N0002468',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('commissione_nazionale_per_le_società_e_la_borsa','n#N0002468',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vinciglio','n#09449346',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fazzoletto','n#02792499 n#02809295 n#03034006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moccichino','n#02792499',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buttata','n#09710563 n#09449526 n#05757512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('germinazione','n#09710563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('minoranza','n#03991493 n#05973473',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('concentrazione','n#04407475 n#05518168 n#03933851',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('temporeggiamento','n#00690722',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('traccheggio','n#00690722',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riel','n#09859824',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riel_cambogiano','n#09859824',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raccattapalle','n#07098051',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('peregrinazione','n#00192460',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coclearia','n#08191787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('larix_decidua','n#07937361',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('larice_comune','n#07937361',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiave_di_volta','n#02887975',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('puntino_di_sospensione','n#05126790',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbaiata','n#05037290',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canzonatura','n#05037290 n#00331800 n#00331225 n#00331025 n#05076736',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('derisione','n#05037290 n#05037006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dileggio','n#05037290',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('irrisione','n#05037290 n#05037006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ludibrio','n#05037290 n#07133400',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scherno','n#05037290 n#05037006 n#05037154 n#05076385',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grida_di_scherno','n#05037290',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('matricaria_chamomilla','n#08302573',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camomilla','n#08302573 n#05952634 n#08257064',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camomilla_comune','n#08302573',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vanessa','n#01779355',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aden','n#06651118',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('hardware','n#02798795',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maneggio','n#03433912 n#04540345 n#04898507 n#00458033 n#00091972 n#06150029',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esportazione','n#02653164 n#00721409',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('export','n#02653164',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('merce_d''esportazione','n#02653164',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chintz','n#02432308',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('federazione','n#06163798 n#06163641 n#06110607 n#06164721',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anestetico','n#02189046',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('destinazione','n#06302863',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('meta','n#06302863 n#04587307 n#04588033 n#04586952',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rapsodia','n#04811669',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zoofobia','n#10320735',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('regionalismo','n#N0001690',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forzista','n#N0000768',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('euforia','n#10336704 n#10337064 n#05596414 n#05597250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salone','n#03218772',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('destrosio','n#10677408 n#10677210',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('destroso','n#10677408 n#10677210',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prologo','n#05258261',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fusione','n#00804210 n#09741527 n#05490810 n#10345580',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('binomio','n#05982753 n#04621615',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('duo','n#05982753 n#06121915',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coppia','n#05982753 n#06690399 n#05985414 n#05982514 n#07843790 n#05980665',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dollaro_di_hong_kong','n#09836223',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antemurale','n#02333160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diga_frangiflutti','n#02333160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frangiflutti','n#02333160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frangimare','n#02333160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frangionde','n#02333160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gettata','n#02333160 n#00066170',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scogliera','n#02333160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ripresa','n#00157011 n#10961055 n#05521978',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polline','n#07991785',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anacronismo','n#10897970',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prezzo_lettera','n#W0003008',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lettera','n#W0003008 n#05115901 n#W0003011 n#05362432 n#04968965',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pannello_di_rivestimento','n#03586777',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('borghesuccio','n#07472881',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filisteo','n#07472881 n#N0000888',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('circolo_vizioso','n#09744679 n#05061964',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ingiunzione','n#05361072 n#04911797',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avvolgimento','n#00220931',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carica','n#00220931 n#07783247 n#00462982 n#10352475 n#00385376 n#00627257 n#03790494 n#02423572 n#00462318',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('genitali_maschili','n#04272207',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pulcinella','n#N0001600',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bravacciata','n#05398823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bravazzata','n#05398823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gradassata','n#05398823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guasconata','n#05398823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pallonata','n#05398823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rodomontata','n#05398823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbraciata','n#05398823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbruffonata','n#05398823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbruffoneria','n#05398823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spacconata','n#05398823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spacconeria','n#05398823 n#05155126',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spampanata','n#05398823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trombonata','n#05398823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arenosità','n#03871168',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('renosità','n#03871168',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbarco','n#00032054',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panca','n#03305625 n#02281030',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('furbacchione','n#N0000800 n#N0001139',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vecchia_volpe','n#N0000800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('volpone','n#N0000800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('collaterale','n#09613897',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rhagoletis_pomonella','n#01701253',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falsità','n#03814020 n#10058657 n#05062653',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fintaggine','n#03814020',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('finteria','n#03814020',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('insincerità','n#03814020',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piave','n#N0002290',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('isacco','n#07729471',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nord','n#06311701 n#06598407',NULL,'a#01542531 a#01543459',NULL);
INSERT INTO italian_index VALUES ('faziosità','n#04701641',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('settarismo','n#04701641',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tendenziosità','n#04701641',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pouf','n#03065722',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('puf','n#03065722',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vuoto_d''aria','n#07773436',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('licenziamento','n#00140714',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('congedo','n#00140714 n#04813590 n#05478779',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affondamine','n#03001983',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('posamine','n#03001983',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('liquidazione','n#00725239 n#00725730 n#00148447',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('svendita','n#00725239 n#00724768',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vendita_a_stralcio','n#00725239',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vientiane','n#06542195',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('silhouette','n#06345899 n#03337991',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('primula_vulgaris','n#08398464',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('primavera','n#08398464 n#10945917',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('primula_comune','n#08398464',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scoreggia','n#00538647',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scorreggia','n#00538647',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('peto','n#00538647',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sacco','n#03265027 n#09916303 n#00620094 n#03265278 n#W0021162 n#04272719 n#02236345 n#03188033 n#09922518',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cartaginese','n#07010431',NULL,'a#02846214',NULL);
INSERT INTO italian_index VALUES ('pressione','n#00072419 n#07825463 n#04044869 n#10368592 n#05451599',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('omelia','n#05408448',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('omilia','n#05408448',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forza','n#00619852 n#03927465 n#03928263 n#06091419 n#06092672 n#03931784 n#04049691 n#03805961 n#04041746 n#03773297 n#07799815 n#06092519 n#04044314',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('violenza','n#00619852',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('busto','n#02358150 n#02717320 n#02504878 n#04298694 n#02306665',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mezzo_busto','n#02358150',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mezzobusto','n#02358150',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('matriarcato','n#05977234',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fieno','n#05835955',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strame','n#05835955 n#02274436',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orpello','n#03508522 n#10552990',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mescita','n#03474078',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('osteria','n#03474078 n#03183776',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ripassata','n#N0001721 n#00576793',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canopo','n#02377784',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incurabile','n#07336854',NULL,'a#00941774',NULL);
INSERT INTO italian_index VALUES ('gaggia','n#08068850 n#08868570',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arbitro','n#07523840 n#07081670 n#07081299 n#07523999',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avvento','n#10949717 n#00026283 n#05457802',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('margine_di_profitto','n#09542241',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compimento','n#00138106 n#00035222',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coronamento','n#00138106 n#03465039',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ossigenazione','n#09684851',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barbabietola','n#08142896 n#05757878 n#08142630',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lactuca_sativa','n#08294009',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('insalata','n#08294009 n#06211515 n#08293804 n#05839780 n#05761291',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lattuga_coltivata','n#08294009',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('percezione','n#04494228 n#00562902 n#04410319 n#04553717',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('talea','n#09417431',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_uruguaiana','n#09855383',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('galbano','n#10671221',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monomio','n#N0001220',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portaombrelli','n#N0001538',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portombrelli','n#N0001538',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('artemisia','n#08236044',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baratteria','n#00485959 n#00492002',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imbroglio','n#00485959 n#06844887 n#10340224 n#00492002 n#00498592 n#00486495',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frode','n#00485959 n#00492002 n#00486495',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('truffa','n#00485959 n#00496453 n#00492002 n#00498592',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baco_da_seta','n#01803443 n#01803226 n#01805171',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('album','n#02177851 n#03118679',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raccoglitore','n#02177851 n#07475683',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('niagara','n#06825746 n#06843442 n#06632076',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('regalo_di_nozze','n#09548640',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('personificazione','n#00597790 n#05149395',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paraplegico','n#07456242',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('platino','n#10496385',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('istituto_professionale','n#06151342',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barbone','n#07648833 n#01622642 n#07660127 n#08469169',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('girovago','n#07648833 n#07660316 n#07672456',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vagabondo','n#07648833 n#07660316 n#07333550 n#07660127',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfera','n#10016075 n#10410497',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('formola','n#05046657 n#04502282',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('formula','n#05046657 n#04502282 n#05046501 n#05105747 n#05084540',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acciacco','n#10207260',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affezione','n#10207260 n#05608483 n#10129713',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('magagna','n#10207260 n#10377620 n#10376563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malanno','n#10207260 n#05446233 n#05452288',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malattia','n#10207260 n#10123988 n#06661976 n#10129713',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esaurimento_nervoso','n#10126933',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lifting','n#00437687',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ritidectomia','n#00437687',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('emorroidi','n#10281951',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('postulato','n#05060175',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foulard','n#03280442 n#02809295 n#02716749 n#03034006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sciarpa','n#03280442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spazialità','n#03951638',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('musca_domestica','n#01695159',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mosca_domestica','n#01695159',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_dell''honduras','n#09847325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diaconato','n#N0000552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('consegnato','n#N0000445',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bacologo','n#07566348',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sericoltore','n#07566348',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sericultore','n#07566348',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('equisetum_palustre','n#09505565',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('equiseto_palustre','n#09505565',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cosacco','n#N0000486 n#N0000487',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acerbità','n#03662017 n#03902140 n#10350380',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acrimonia','n#03662017',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amarezza','n#03662017 n#05611927 n#05600345',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orso_giocoliere','n#01643047',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('melursus_ursinus','n#01643047',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capofamiglia','n#07462019',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mezza_età','n#10874849',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prevosto','n#N0001578 n#N0001388',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('partenogenesi','n#09702267 n#09703211',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interesse_legale','n#N0002825',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('demografo','n#07208895',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fotografia','n#00580612 n#09674939 n#03280931 n#03113185 n#00408287',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fustagno','n#02731714 n#02500222',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('padova','n#06467552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pd','n#06467552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ovopositore','n#00986828',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vespa_crabro','n#01717294',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cynara_cardunculus','n#08267490',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carciofo','n#08267490 n#05756978 n#08267260',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cardo','n#08267490 n#08251864 n#05767222',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cardone','n#08267490',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mestiere','n#00383807 n#00399744 n#04359865 n#04360292',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('posto','n#00383807 n#06279834 n#06352837 n#00385376 n#06364246 n#04346383 n#06381267 n#06368526',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('posto_di_lavoro','n#00383807 n#03631348',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('boule','n#N0000194',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('professione','n#00399744 n#00402228',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('commercio','n#00399744 n#05340125 n#00711063 n#00707408',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dentatura','n#N0000540 n#06236904',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caracal','n#01636393',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lynx_caracal','n#01636393',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('butat','n#09830850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('butat_gambiano','n#09830850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('butut','n#09830850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('butut_gambiano','n#09830850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiazza_di_petrolio','n#03055508',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salvietta','n#02796259 n#03029664',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('custodia','n#10085503 n#00523477 n#03315097 n#00531481',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('custodia_cautelare','n#10085503',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giuncata','n#05661491',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comportamento','n#10091030 n#03835766 n#00792210 n#00378579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immobilità','n#10089847 n#10089688 n#03749043',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nodello','n#01957889 n#01957774',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('simbolo','n#04446693 n#05097156',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('formaldeide','n#10668420',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('metanale','n#10668420',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esportatore','n#07253113',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immagine','n#04553967 n#04551473 n#03160624 n#02636606 n#03685960 n#04558972 n#03118233',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('opera_d''arte','n#04553967',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coppa','n#02533651 n#05549454 n#02321913 n#05032036 n#02759431',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bonus','n#09551149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('extra','n#09551149',NULL,'a#00048834',NULL);
INSERT INTO italian_index VALUES ('gratifica','n#09551149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gratificazione','n#09551149 n#10075968',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incentivazione','n#09551149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incentivo','n#09551149 n#06660574',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('androne','n#02191831',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anticamera','n#02191831',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('atrio','n#02191831 n#02221784 n#02484305 n#04191921 n#04191249',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foyer','n#02191831',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('hall','n#02191831 n#02964501 n#02786743',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ingresso','n#02191831 n#02641840 n#04892853 n#05421788 n#00026402',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ridotto','n#02191831',NULL,'a#00838646 a#00004481',NULL);
INSERT INTO italian_index VALUES ('vestibolo','n#02191831 n#04117005',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('entrata','n#02191831 n#09539173 n#02641840 n#09538207 n#00155548 n#00026402 n#00810466',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('facciata','n#02659695 n#04731849 n#03683012',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fronte','n#02659695 n#07801145 n#06320533 n#06338451 n#04341992',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('visita_medica','n#00092823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('celebrazione','n#00332566 n#05539623',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('complemento','n#04765869 n#03984666 n#06092042',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corvetta','n#02505005',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('complessità','n#03742947',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tevere','n#06832610',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('babilonia','n#06517793 n#10068579 n#10068349 n#06517616',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esecuzione','n#00729616 n#00359430 n#W0003147 n#00061811 n#00752981 n#W0003148 n#09750253',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('applicazione','n#00729616 n#04931025 n#00457130 n#00607299 n#00416445',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('materializzazione','n#05457964',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('furiere','n#07515261',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quartiermastro','n#07515261',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frenastenia','n#04367378',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idiotismo','n#04367378',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idiozia','n#04367378 n#04366309 n#00810350 n#04956498',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oligofrenia','n#04367378',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('braccio','n#09823285 n#02190772 n#02703412 n#04310435',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fathom','n#09823285',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anaplasmosi','n#10239571',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tsunami','n#05475379',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('onda_anomala','n#05475379',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scavo','n#06303355 n#00602398 n#W0020940',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('operaio','n#07687635',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lavorante','n#07687635',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('galena','n#10519574',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banchiere','n#07100408 n#07100512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biscazziere','n#07100408',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('milano_indici_di_borsa','n#N0002652',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indice_mib','n#N0002652',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mib','n#N0002652 n#N0001265',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('atena','n#06904195',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pallade','n#06904195',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pettinatura','n#00164848 n#04081360',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aspirapolvere','n#03565176',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ineleganza','n#03776772',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('itterizia','n#10277340',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ittero','n#10277340 n#01094393',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orafo','n#07295614 n#07348474 n#07348367',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orefice','n#07295614 n#07348474 n#07348367',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diniego','n#05383758 n#05382699',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rifiuto','n#05383758 n#10656657',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macis','n#05848239',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('medaglia','n#07402624 n#05029668',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('obbrobrio','n#03695990 n#07277959 n#10360525 n#10361358 n#02832377',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pugno_in_un_occhio','n#03695990',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('boccetta','n#03111639 n#N0000755',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiala','n#03111639',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bucatura','n#05452519 n#00602811 n#03188416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foratura','n#05452519 n#00602811 n#03188416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('legione','n#09920569 n#06082453 n#06083098',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moltitudine','n#09920569 n#06082225 n#06080290',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mucchio','n#09920569 n#09920124 n#10402671 n#05969773 n#06082537 n#06081960 n#09922518',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('schiera','n#09920569 n#06237025 n#06083357 n#06082225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gran_numero','n#09920124',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('montagna','n#09920124 n#06711088 n#W0021216',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immensità','n#09920124 n#03982056',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monte','n#09920124 n#06711088',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('massa','n#09920124 n#W0003016 n#06082225 n#N0002421 n#02774628 n#05970032 n#06080290 n#03977751 n#W0003018 n#03923435 n#06674595 n#W0003017',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('subisso','n#09920124 n#09921122',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('phalacrocorax_carbo','n#01565691',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cormorano','n#01565691',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marangone','n#01565691',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('provvisorietà','n#03945930',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('temporaneità','n#03945930',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lino','n#02928626',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coccinello','n#03512056',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('derubato','n#N0000549',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('negus','n#N0001305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sconvolgimento','n#00362255',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frappé','n#05943071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frullato','n#05943071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dinaro_sudanese','n#09857563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camera_del_commercio','n#06169412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camera_di_commercio','n#06169412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ordine','n#06246680 n#04902219 n#10399952 n#W0003123 n#05991008 n#06042229 n#W0003124 n#05359821 n#10063906 n#W0003121 n#W0003130 n#00672215 n#04496504 n#10400315',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('solstizio_d''estate','n#10933616',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pecca','n#04003843',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('archibugio','n#02211539',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ophrys_apifera','n#08382101',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ofride_fior_delle_api','n#08382101',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sistema_neurovegetativo','n#04264958',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('terra','n#06667942 n#06299747 n#10647622 n#10517969 n#06753779 n#02774628 n#05957670 n#10649338 n#09530909 n#06916543 n#06668569 n#06310843 n#06359477 n#10649081',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cappa','n#02381581 n#03473307 n#02514327 n#02451635 n#02383379 n#01471467',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('kappa','n#02381581 n#03473307 n#02514327 n#02451635 n#02383379 n#01471467',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mantella','n#02381581 n#02451635',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mantellina','n#02381581',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mantello','n#02381581 n#05151955 n#03315097 n#01414164 n#06671614 n#02451635',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forma_fisica','n#10430808',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paese_delle_meraviglie','n#06314665',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('occultista','n#07438940',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('neutralismo','n#04996212',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('distruzione','n#05465857 n#05465405 n#00141128',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asciuttezza','n#03906991 n#05303718 n#10425272 n#03848250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esilità','n#03906991 n#03981336 n#03907406 n#03899612',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('magrezza','n#03906991 n#03988043 n#03907406 n#03907274 n#03986337',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pulsante','n#03190702',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('torello','n#01900340 n#02738767',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radiocarbonio','n#10482959',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('melassa','n#05888982 n#05888725',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('blechnum_spicant','n#09469929',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lonchite_maggiore','n#09469929',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('confezione','n#00407010 n#00715158 n#00401149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sartoria','n#00407010',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cartilagine','n#04104335',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fidia','n#N0000807',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pulsione','n#10110247',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('etologia','n#04635168',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cianogeno','n#10638179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arctium_minus','n#08232353',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bardana_minore','n#08232353',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('governime','n#05834217',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mangime','n#05834217 n#05834839 n#05839086',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scorta_alimentare','n#05834217',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eudiometro','n#02649646',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banca_centrale','n#06183328',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('istituto_di_emissione','n#06183328',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conoscenza_pregressa','n#04485764',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conoscenza_di_background','n#04485764',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strumentista','n#07424573',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('musicista','n#07424573 n#07424386',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orchestrale','n#07424573',NULL,'a#02725408',NULL);
INSERT INTO italian_index VALUES ('sonatore','n#07424573',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strumentalista','n#07424573',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('suonatore','n#07424573',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anatocismo','n#09589172',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interesse_composto','n#09589172',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lupara','n#03278158 n#02292034',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('operazione','n#00262937 n#09747131 n#00378984 n#00436664 n#00611703 n#00378579 n#00709934 n#00558701 n#00717352',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giocata','n#00326232 n#09607916 n#05416802 n#00289585',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('poltiglia','n#10541786 n#10793808',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pultiglia','n#10541786 n#10793808',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impasto','n#10541786 n#00244416 n#05491211',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('centaurea_nigra','n#08256318',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiordaliso_scuro','n#08256318',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('addormentamento','n#10107420',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assopimento','n#10107420',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sonno','n#10107420 n#10102311',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sonnolenza','n#10107420',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sopore','n#10107420',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricongiungimento','n#00245609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricongiunzione','n#00245609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riunificazione','n#00245609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riunimento','n#00245609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assistente_di_camerino','n#07226995',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('franco_della_guinea','n#09865292',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zuppa_inglese','n#05660935',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('armaiolo','n#07083670 n#07305624 n#06012120',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('armiere','n#07083670',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nucleo','n#06118015 n#06779937 n#06298384 n#06093198 n#06689681 n#06100095',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inviolabilità','n#03804922',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sacertà','n#03804922',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sacralità','n#03804922',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('venezuela','n#06649698',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cartongesso','n#03138987',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ko','n#00086854',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ileo','n#04287708 n#04094415',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guardia','n#03966466 n#00565801 n#07304325 n#04731752 n#07485319 n#06097890 n#02425740 n#10984939 n#00470577 n#07304133',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grembiale','n#02203236 n#03069114',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grembiule','n#02203236 n#03069114',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arduità','n#03705946',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asprezza','n#03705946 n#03901632 n#03706170 n#03870871 n#03659222 n#04417244 n#03870360 n#03897961 n#03777856 n#03661737 n#03682408 n#03797439 n#03901461 n#04416794',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sala_di_ritrovo','n#02476792',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sala_professori','n#02476792',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sala_dei_professori','n#02476792',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fenotipo','n#03860389',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciclo_vitale','n#07811301 n#09710787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('allargatrice','n#03487226',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capitazione','n#09584993',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intervallo','n#10968320 n#06270582 n#04817735 n#10970897 n#05630827 n#10969750 n#06698176 n#10890324',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antialiseo','n#07775276 n#07844199',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contraliseo','n#07775276 n#07844199',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('controalisei','n#07775276',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('controaliseo','n#07775276 n#07844199',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('general_motors','n#W0020814',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gm','n#W0020814',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ridimensionamento','n#04434211 n#00225760',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intrepidezza','n#03806773 n#03805961',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trucioli_di_legno','n#10746999',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('verde','n#05144786 n#03882559 n#09440702',NULL,'a#00360195 a#01431944',NULL);
INSERT INTO italian_index VALUES ('mezzo_soprano','n#07407933 n#05143484',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mezzosoprano','n#07407933 n#05143484',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('m.c.m.','n#04510850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('minimo_comune_multiplo','n#04510850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('endocardite','n#10289991',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impronta','n#05129243 n#10013828 n#02852222',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prima','n#09974999 n#02688619 n#02688500 n#10939769 n#05461893',NULL,NULL,'r#00254270 r#00064503 r#00064239 r#00058575 r#00058882 r#00100303 r#00116080 r#00099527');
INSERT INTO italian_index VALUES ('europa','n#06838825',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vecchio_continente','n#06838825',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('addio','n#04973475 n#00029442 n#04973257',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('escursionista','n#07645492 n#07320727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('turista','n#07645492',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amebiasi_intestinale','n#10192084',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('telegrafista','n#07633987',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gomma','n#10689735 n#02645157 n#03508995 n#10539758 n#10228703 n#03259558 n#10251730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orecchione','n#10169601 n#01657365',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stranguglione','n#10169601 n#10302188 n#00555891 n#10242809',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leontodon_autumnalis','n#08296585',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dente-di-leone_ramoso','n#08296585',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ripieno','n#05909835 n#05721065',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iterazione','n#00657981',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reiterazione','n#00657981',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ripetizione','n#00657981 n#00571795 n#05380255 n#05470763 n#00657820 n#00576793',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fogliazione','n#09710468',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('robotica','n#04664182',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('singolarità','n#03988291 n#03765172 n#03741160 n#03763706 n#03764875 n#03740993',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('formalismo','n#04574617',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esterno','n#06346008 n#07449884 n#06346129',NULL,'a#00900427 a#00905055 a#01296215',NULL);
INSERT INTO italian_index VALUES ('fuori','n#06346008 n#06346129',NULL,NULL,'r#00229375 r#00108422 r#00100753 r#00184420 r#00108162 r#00184512');
INSERT INTO italian_index VALUES ('sego','n#10807256',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amamelide','n#08618229',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anagallis_arvensis','n#08399669',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anagallide','n#08399669',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('centonchio_dei_campi','n#08399669',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mordigallina','n#08399669',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('terzanella','n#08399669',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parure','n#N0001390 n#02641291',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('livorno','n#N0001088 n#N0002416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perforamento','n#00603960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perforatura','n#00603960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perforazione','n#00603960 n#00602658 n#00592646',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intesa','n#06075689 n#05072418 n#10037482 n#09948376',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('casa_di_importazione','n#N0002687',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pezzo_di_merda','n#07086742',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('testa_di_cazzo','n#07086742',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bastardo','n#07086742 n#07104284 n#01595888',NULL,'a#01834425',NULL);
INSERT INTO italian_index VALUES ('grafica','n#02767256 n#02767450',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crescita','n#09708563 n#09725434 n#03983965',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('embriogenesi','n#09708563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('evoluzione','n#09708563 n#00615775 n#09724860 n#09704382',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ontogenesi','n#09708563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sviluppo','n#09708563 n#09745553 n#09724860 n#00238469 n#05524370 n#00160202 n#09725434 n#00159609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scapolare','n#03280131',NULL,'a#02600444',NULL);
INSERT INTO italian_index VALUES ('fritto','n#N0000784',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frittura','n#N0000784 n#00157874',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sistematica','n#04676534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sillabazione','n#00250509',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('feltrazione','n#09672975',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filtraggio','n#09672975',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filtrazione','n#09672975',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riluttanza','n#03663200 n#07832913',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tentennare','n#03663200 n#03813132 n#04403239 n#04403483 n#00687997','v#01309435 v#01802820',NULL,NULL);
INSERT INTO italian_index VALUES ('tentennio','n#03663200 n#03813132 n#04403239 n#04403483 n#00687997',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giamaica','n#06434745',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fruttificazione','n#09711877',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maresciallato','n#00391669',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tappo','n#02380860 n#02501494 n#07541467',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rendita_ordinaria','n#09569936',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('megaohm','n#09811630',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arabo','n#05242603 n#04789385 n#01880495 n#07036038',NULL,'a#02796795',NULL);
INSERT INTO italian_index VALUES ('incastonatura','n#N0000954',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carato','n#09879828 n#09761387',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dilettantismo','n#04368766 n#04727430',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('faciloneria','n#04368766',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pressapochismo','n#04368766',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pressappochismo','n#04368766',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('superficialità','n#04368766',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acredine','n#05611927',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agro','n#05611927',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amaro','n#05611927 n#05926217',NULL,'a#02316897',NULL);
INSERT INTO italian_index VALUES ('astio','n#05611927',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('astiosità','n#05611927',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cruccio','n#05611927 n#05593817 n#04491326',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiele','n#05611927 n#04201458',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('livore','n#05611927',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mal_animo','n#05611927',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malanimo','n#05611927',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rancore','n#05611927',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rancura','n#05611927',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risentimento','n#05611927',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('distinzione','n#03731593 n#04434776 n#05020360 n#03775722',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('essere_umano','n#01967203 n#00004123',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('uomo','n#01967203 n#07391044 n#07392045 n#05957670 n#W0021065 n#07392643 n#07392266 n#W0021067 n#07567074',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aia','n#02667250 n#03498446 n#06537474',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cortile','n#02667250 n#03638970 n#02511042 n#02713321',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('straccione','n#07518469',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('divano_letto','n#03434577',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('divanoletto','n#03434577',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parola','n#05050587 n#04370255 n#04750884 n#05396749',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ora_di_punta','n#10939148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giudizio','n#00561563 n#00765977 n#00775201 n#04495853 n#04564824 n#04348442 n#00775506 n#04462241 n#03830684 n#00768711 n#00772379',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('irregolarità','n#03745305 n#03734362 n#10406222 n#03746252 n#03745575',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('samovar','n#03272528',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calcolatore_analogico','n#02186972',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oscillogramma','n#03065158',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calzoncini_da_bagno','n#03455265',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('statoreattore','n#03210785',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buccia','n#10579950 n#04256428 n#09427470 n#05774945 n#09447687',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('non_socio','n#07404740',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('allarme','n#05590744 n#05591792 n#02177224 n#05094224 n#05395080',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('smarrimento','n#05590744 n#04393745 n#05581054',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comodità','n#03712053 n#10365399 n#10364483',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disponibilità','n#03712053 n#03795117',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('area','n#06276601 n#06395720 n#10410497 n#04596100 n#03995297 n#06268839',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zona','n#06276601 n#06297080 n#06268839',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fraudolenza','n#05066196 n#00492002 n#03819481',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('birillo','n#02323299 n#03041464',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mn','n#N0002420',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mantova','n#N0002420 n#N0001262',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rivestimento','n#02661961 n#00529919',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apache','n#05182540 n#06971097',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('madrepora','n#01431022',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crataegus_oxyacantha','n#08928442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biancospino_selvatico','n#08928442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sonnifero','n#03350207',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('regolatore','n#03226504',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spillo','n#02803881 n#03503970',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spillone','n#02803881',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('kivi','n#01043602 n#08674722 n#05799233',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('kiwi','n#01043602 n#08674722 n#05799233',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dominazione','n#10362361 n#00730747',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dominio','n#10362361 n#06307482 n#10362727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('egemonia','n#10362361 n#06191189',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leadership','n#10362361',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('predominio','n#10362361 n#10361817',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('primato','n#10362361 n#10356770',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sopravento','n#10362361 n#09961411',NULL,NULL,'r#00092384');
INSERT INTO italian_index VALUES ('sopravvento','n#10362361 n#09961411',NULL,NULL,'r#00092384');
INSERT INTO italian_index VALUES ('sovranità','n#10362361 n#10081021',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('superiorità','n#10362361 n#03717609 n#04018800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('supremazia','n#10362361',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('livello','n#10351768 n#10046013 n#03973686 n#10044643',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tazza_del_gabinetto','n#03513148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('water','n#03513148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vaso_del_gabinetto','n#03513148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baio','n#01886372 n#01886554',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('delicatezza','n#03794865 n#03935946 n#03654008 n#03846037 n#03795428 n#03891794 n#03937780 n#03983249 n#03775320 n#03795245 n#04437396',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('millimetro','n#09821819',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mm','n#09821819 n#09823050',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('magenta','n#03880649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('enoteca','n#N0000641',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('skipass','n#N0001908',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vulvite','n#10301748',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('focosità','n#03674868',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impulsività','n#03674868',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imposta_sul_valore_locativo','n#N0002801',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imposta_incremento_di_valore_degli_immobili','n#N0002773',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aigrette','n#02169490',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asprì','n#02169490',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('egretta','n#02169490 n#01520719',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intelletto','n#04370938',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raziocinio','n#04370938 n#04350992 n#04348442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('causa','n#00765977 n#00003731 n#05051484 n#06659860 n#00509919 n#05051824 n#05460141 n#00765298',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contenzioso','n#00765977',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('controversia','n#00765977 n#05369177',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lite','n#00765977 n#05368498 n#05369860 n#05369724 n#05369518 n#00765298',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vertenza','n#00765977',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alga','n#00924590 n#00924225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('x-terapia','n#00452122',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gammaterapia','n#00452122',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radioterapia','n#00452122',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radiumterapia','n#00452122',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('roentgenterapia','n#00452122',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('röntgenterapia','n#00452122',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gomito_del_tennista','n#10300637',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fosfina','n#10750948',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cabinovia','n#03483382',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('funivia','n#03483382',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vibrato','n#05507208',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('granducato','n#06308549',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fondo_di_beneficenza','n#06004313',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asciugatrice','n#02456140',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('belligeranza','n#00619330 n#03662132',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radiotassì','n#N0001662',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radiotaxi','n#N0001662',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('faringite','n#10190742',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polpetta','n#05894086 n#05899282',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mosca','n#02705926 n#06570227 n#04086060 n#02272635 n#01694570',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chenopodio','n#08138688',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('muezzin','n#07422476',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('muezzino','n#07422476',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('talacimanno','n#07422476',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calamità','n#07782551 n#05452645 n#10384515 n#00141434',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cataclisma','n#07782551 n#05452645 n#10384515',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rubia_tinctorum','n#08961017',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('robbia','n#08961017',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('robbia_domestica','n#08961017',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pulce_di_mare','n#01505286 n#01504845',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biscotto','n#05681148 n#05735305 n#05679877',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biscuit','n#05681148 n#05665229 n#05735305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('appiglio','n#02792301 n#10391300',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricinus_communis','n#09222184',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricino','n#09222184',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('andante','n#10965451',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calmante','n#03297921 n#02917386 n#03529911 n#02186685',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sedativo','n#03297921 n#02917386 n#02186685',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pampana','n#N0001369',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pampano','n#N0001369',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pampino','n#N0001369',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cece','n#08816427 n#08816641 n#05763586',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aftershave','n#02168715',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dopobarba','n#02168715',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monorotaia','n#03012543',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gliceride','n#10678160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lagotrice','n#01988408',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lagotriche','n#01988408',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ripostiglio','n#03422136 n#02534044',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sgabuzzino','n#03422136',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spogliatoio','n#03422136 n#02601691',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stanzino','n#03422136',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('casolare','n#02826287',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cornus_mas','n#09245470',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corniolo_maschio','n#09245470',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('terranova','n#01620650 n#06474320 n#06474524',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gru_a_torre','n#W0007451',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tirannosauro','n#01234391',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('botola','n#03533876 n#02963442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trabocchetto','n#03533876 n#04495302',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('segnacarte','n#02313987',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('segnalibro','n#02313987',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abregé','n#04857759',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abrégé','n#04857759',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('breviario','n#04857759 n#04858460 n#04836043',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compendio','n#04857759 n#04516911 n#04858460 n#04859504',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('condensato','n#04857759',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('outline','n#04857759',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prospetto','n#04857759 n#04555855',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riassunto','n#04857759 n#04858569 n#04858064',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricapitolazione','n#04857759 n#04858064',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riconto','n#04857759',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riepilogazione','n#04857759',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ristretto','n#04857759',NULL,'a#01358077 a#00281802',NULL);
INSERT INTO italian_index VALUES ('sintesi','n#04857759 n#04458960 n#09689446',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sommario','n#04857759 n#04858460',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('summary','n#04857759',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sunto','n#04857759',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('budda','n#06885137',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buddha','n#06885137',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giro_manica','n#02209897',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('blocco','n#02299904 n#00517062 n#06075573 n#10743763 n#02299245 n#00610851',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('credo','n#05084933 n#04573755',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('culto','n#05084933 n#06023733 n#00675531 n#05576115 n#00664071 n#04566113 n#00675116 n#06065981',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('logicismo','n#04581618',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corazzata','n#02267414',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nave_da_guerra','n#02267414 n#03590317',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rifondazione_comunista','n#W0020799',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('punto_di_riferimento','n#05417191',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riferimento','n#05417191 n#05069358 n#04548181',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eccentricità','n#09997475 n#03764763 n#03960215',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('succo_di_limone','n#05944792',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arlecchinata','n#00330677',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buffonaggine','n#00330677 n#00330812',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buffonata','n#00330677 n#00331225 n#00330812 n#05077026',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buffoneria','n#00330677 n#00331225 n#05077026',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('burattinata','n#00330677',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lazzo','n#00330677',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pagliacciata','n#00330677 n#00330812',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quintultimo','n#N0001647',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiodo','n#03027985 n#03133538 n#03382158 n#03243338 n#02822544 n#09649911',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capacità','n#04354522 n#04354376 n#04359865 n#03982530 n#04047716 n#07782099 n#04049240 n#09924294 n#04353158 n#04360292 n#04049589 n#04349777',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('potenzialità','n#04354522 n#10389291 n#04049589',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('valentia','n#04354522 n#04359865 n#04047716 n#03718929 n#04353158 n#04360292',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('policromia','n#N0001512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tam-tam','n#03485532',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tamtam','n#03485532',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lathyrus_tuberosus','n#08842978',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cicerchia_tuberosa','n#08842978',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('glutammina','n#10463241',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pastora','n#07570019',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pastorella','n#07570019',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carpinus_betulus','n#08591279',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carpino_bianco','n#08591279',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carpino_comune','n#08591279',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cugino','n#W0021180 n#07189281',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biogeocenosi','n#06195731',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biosistema','n#06195731',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ecosistema','n#06195731',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('entrate','n#09539173',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incasso','n#09539173',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('introito','n#09539173 n#09538207 n#09542885',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cicatrice','n#10305167',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfregio','n#10305167 n#00794619 n#03696173',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cubo','n#09886515 n#10027013',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bighellone','n#07380186 n#07295019 n#07333550 n#07199951',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perdigiorno','n#07380186 n#07333550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eocene','n#10853431',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('meles_meles','n#01943925',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tasso','n#01943925 n#07978239 n#10980504 n#07978776 n#09593084 n#01943232',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('titillamento','n#05597153',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esaminando','n#07638075',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('difterite','n#10160390',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baby','n#07094006 n#07643338',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bambino','n#07094006 n#07153837 n#07154665 n#07389783 n#07154377',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bebè','n#07094006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bebé','n#07094006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bimbo','n#07094006 n#07153837 n#07389783',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fantolino','n#07094006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('infante','n#07094006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('neonato','n#07094006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piccino','n#07094006',NULL,'a#01336443',NULL);
INSERT INTO italian_index VALUES ('piccolo','n#07094006 n#00865638',NULL,'a#01336443 a#01413178 a#01589390 a#01358565',NULL);
INSERT INTO italian_index VALUES ('pupo','n#07094006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cronaca_rosa','n#W0021026',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sedicenne','n#N0001845',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('goletta','n#03282797 n#02763521',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nastro_trasportatore','n#02389817 n#02495729',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carattere','n#05115901 n#03645312 n#05107649 n#W0003144 n#04826409 n#04504455 n#05113097 n#04496504 n#W0003145',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carattere_alfabetico','n#05115901',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('denominazione','n#06064547 n#04781345 n#04778525',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lindezza','n#10399525',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lindore','n#10399525',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lindura','n#10399525',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pulizia','n#10399525 n#00160717',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('escursione','n#00187619 n#00202291 n#00201294',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('escursione_a_piedi','n#00187619',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scienza','n#04596663 n#04596907',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ginepro','n#07953787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dipendenza','n#10086663 n#05565534 n#10124557',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('thelypteris_palustris','n#09512951',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('felce_palustre','n#09512951',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cabinato','n#02363485',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cruiser','n#02363485',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('battello_da_diporto','n#02363485',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mastello','n#03592587 n#03547711',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ombra','n#05357270 n#10075077 n#06367601 n#04533237 n#10074475 n#10074305 n#10357217',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bilanciamento','n#00121442 n#10087814',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conciliazione','n#00121442 n#05072418 n#05365792',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conguagliamento','n#00121442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conguaglio','n#00121442 n#09658576',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pareggiamento','n#00121442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moderno','n#07416669',NULL,'a#01472209 a#01804618 a#00922745',NULL);
INSERT INTO italian_index VALUES ('avventurismo','n#03674564',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('miniabito','n#N0001189',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('laicato','n#06066687',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('misogino','n#07413971',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ispirazione','n#04543845 n#04467595 n#04492995',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('proposta','n#04543845 n#05356736 n#05355937 n#05355488',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('suggerimento','n#04543845 n#05355937 n#05409138',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cariatide','n#02396909',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('drammatizzazione','n#00577992',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bonzo','n#N0000187',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('berchelio','n#10480745',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('berkelio','n#10480745',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alluminio','n#10478256',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sieronegatività','n#N0001892',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corpo_dei_vigili_del_fuoco','n#06054837 n#06054653',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vigili_del_fuoco','n#06054837 n#06054653',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lonicera_caprifolium','n#08974641',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbracciabosco','n#08974641',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caprifoglio_comune','n#08974641',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('madreselva_comune','n#08974641',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('statica','n#04653128',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('serata','n#10886747',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('serafino','n#06891976',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('serafo','n#06891976',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anno_contabile','n#10917007',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anno_finanziario','n#10917007',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anno_fiscale','n#10917007',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esercizio_finanziario','n#10917007',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dott.','n#07220340',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dott.ssa','n#07220340',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dott.a','n#07220340',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dottore','n#07220340 n#07220720 n#00273222',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dottoressa','n#07220340',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('medico','n#07220340',NULL,'a#01120947 a#02585051 a#02691349',NULL);
INSERT INTO italian_index VALUES ('sanitario','n#07220340',NULL,'a#02038722',NULL);
INSERT INTO italian_index VALUES ('prunaio','n#08952996',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('roveto','n#08952996',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rovo','n#08952996',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spinaio','n#08952996',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spineto','n#08952996',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('azionista','n#07612499',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cointeressato','n#07612499 n#07087841',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gruppo_di_controllo','n#07612499',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('donchisciotte','n#07223052',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bava','n#04206226 n#02356236',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scadenza','n#10897748 n#10874611 n#10967564',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('termine','n#10897748 n#05072928 n#04750884 n#04515461 n#04758968 n#10967564',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incurabilità','n#03726240 n#03805813',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elettrificazione','n#00609704',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('siviglia','n#06584133',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('supplemento','n#03984819 n#04823787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disco_rimovibile','n#03228795',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contrassegno','n#05426040',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marca','n#05426040 n#05128468 n#06279718 n#05128586 n#04501111',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marchio','n#05426040 n#05088890 n#05128586 n#02967192 n#03720188 n#05089641',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cozza','n#01475904 n#05818623',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cozzeca','n#01475904 n#05818623',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mitilo','n#01475904',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('peocio','n#01475904',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('istituto_di_diritto_pubblico','n#N0002751',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stradivario','n#N0002023',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fa','n#05139664',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('partorente','n#N0001389',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('partoriente','n#N0001389',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parturiente','n#N0001389',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quattrino','n#09644617 n#09646443',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canzoniere','n#07592786 n#04837037',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compositore_di_canzoni','n#07592786',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parto_naturale','n#09700808',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sopportabilità','n#N0001927',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comando','n#00816648 n#10053692 n#00816340 n#05359821 n#04046013 n#06215213 n#02492359',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('va','n#N0002459',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('varese','n#N0002459',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interesse_esatto','n#N0002822',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frutto_della_passione','n#05789552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('costa','n#04556567 n#06801063 n#06801422 n#06345702 n#04065902 n#06724958',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('costa_marina','n#04556567',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('costiera','n#04556567',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('litorale','n#04556567 n#06345702',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('littorale','n#04556567 n#06345702',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spilorcio','n#07152250 n#07432782 n#07413689',NULL,'a#01063943',NULL);
INSERT INTO italian_index VALUES ('taccagno','n#07152250 n#07413689',NULL,'a#01063943',NULL);
INSERT INTO italian_index VALUES ('pitocco','n#07152250 n#07432782',NULL,'a#01063943',NULL);
INSERT INTO italian_index VALUES ('successore','n#04401513 n#07620399',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('feltro','n#02670260',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clausola','n#00745088 n#04819775 n#05062525 n#05062190',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carminio','n#03879753',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assegnamento','n#10086957 n#04402313',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conto','n#10086957 n#10395766 n#04470977 n#10036540 n#00558391 n#09839250 n#04891690 n#04892596',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfacelo','n#N0001873 n#05558898 n#10440630',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('afgano','n#05230404',NULL,'a#02763111',NULL);
INSERT INTO italian_index VALUES ('afghano','n#05230404',NULL,'a#02763111',NULL);
INSERT INTO italian_index VALUES ('enhydra_lutris','n#01941260',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lontra_di_mare','n#01941260',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oreficeria','n#02876152 n#06010275',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('posizione_del_loto','n#03965809',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sudafrica','n#06567899',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comunicazione','n#04729537 n#04729099 n#00019671 n#05056012 n#04728675 n#09931984',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('messaggio','n#04729537 n#04949838',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('segmento','n#06686223 n#03296757',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spicchio','n#06686223 n#05783618',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('libro','n#09661243 n#04831824 n#09391307 n#01896973 n#04820634 n#02313137',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tessitore','n#07676465',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('castrismo','n#06195517',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bene_mobile','n#09529953',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('proprietà_privata','n#09529953',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esperto','n#06947056 n#07177748',NULL,'a#00888335 a#02120998 a#02120292',NULL);
INSERT INTO italian_index VALUES ('esperta','n#06947056',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('competente','n#06947056',NULL,'a#00475938',NULL);
INSERT INTO italian_index VALUES ('maestro','n#06947056 n#04507240 n#07632177 n#07791711 n#07551048 n#07551404 n#07175013 n#07386587',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maestra','n#06947056 n#07632177',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perito','n#06947056',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('specialista','n#06947056 n#07597405 n#07597774',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('concorrenza','n#09967975 n#03708941 n#00756855',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attacco','n#W0003110 n#W0003108 n#00625655 n#10134893 n#W0003119 n#02878715 n#03364873 n#10135271 n#06023401 n#00291138 n#05033377 n#05982639',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arctium_lappa','n#08232541',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bardana','n#08232541',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bardana_maggiore','n#08232541',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lappa','n#08232541',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lappa_bardana','n#08232541',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('plasma','n#10388474 n#10758965',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comprimario','n#N0000421',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammogliato','n#07331418',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maritino','n#07331418',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marito','n#07331418',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sposo','n#07331418 n#07302617 n#07302517',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('negritudine','n#04712925',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('negrità','n#04712925',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('numero','n#05156818 n#04841846 n#04774380 n#05097671 n#04842744 n#03975491 n#04948541 n#07149819 n#09765658 n#03990394',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fuoco_di_segnalazione','n#05421212',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('manopola','n#03005936 n#02748946 n#03425661 n#02792702 n#02895368',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('muffola','n#03005936 n#03022660',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('divorzio','n#00778442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lago_di_lesina','n#N0002310',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rappresentazione','n#04551473 n#03229963 n#00359430 n#05265213 n#05156358 n#04550469',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inclusione','n#09933049 n#00239677',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('millenario','n#10957370',NULL,'a#02652850',NULL);
INSERT INTO italian_index VALUES ('induismo','n#04722655 n#06033539',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('celebrante','n#07144993',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('officiante','n#07144993',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ufficiante','n#07144993',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('omofonia','n#05272391 n#05335856',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('igiene','n#10399711 n#10398906 n#10398628 n#04628105 n#03834628',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mondezza','n#10399711 n#10078769 n#10656895',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monnezza','n#10399711 n#10078769 n#10656895',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fanciullezza','n#10870942 n#10870840 n#10870647',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sale','n#05846273 n#10772760',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sale_da_tavola','n#05846273',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sale_fino','n#05846273',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('peso_uruguaiano','n#09855495',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ergastolo','n#03174387 n#02872007',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('galera','n#03174387 n#10042569 n#02872007 n#02735265',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prigione','n#03174387 n#02872007',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('replay','n#00658659 n#05471216',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intervista','n#05377714 n#05344204',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dottore_di_ricerca','n#07220720',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cupola','n#08572330 n#01960867 n#02587986 n#02525778 n#02534342',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fe','n#N0002403',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ferrara','n#N0002403',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiesa_cattolica','n#06024631',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indice_redditività','n#N0002670',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('base','n#04465690 n#02258757 n#06278668 n#06263016 n#02256337 n#02255918 n#02256107 n#02717023 n#02256491 n#09930598 n#04993010',NULL,'a#01784247 a#01784549 a#02184742',NULL);
INSERT INTO italian_index VALUES ('caposaldo','n#04465690 n#04517783',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cardine','n#04465690 n#10047472 n#02819675 n#09930416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fondamento','n#04465690 n#04517783',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sostrato','n#04465690 n#06376858 n#09930416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('substrato','n#04465690 n#06376858 n#09930416 n#10565539',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('siria','n#06588628',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('doppione','n#02616247',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('saccheggiatore','n#07482912',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('predatore','n#07482912 n#07395416 n#01661105',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spogliatore','n#07482912',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('predone','n#07482912 n#07395416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tavolo_da_disegno','n#02596084',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sedia_a_dondolo','n#03246920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quantizzazione','n#00249932',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('meno','n#09759837 n#05101347',NULL,'a#01494191 a#01492632','r#00096529 r#00109254');
INSERT INTO italian_index VALUES ('minimo','n#09759837 n#09911225',NULL,'a#01434385',NULL);
INSERT INTO italian_index VALUES ('istigatore','n#07068013 n#07340973',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sommovitore','n#07068013',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alpe','n#06722463',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('magnificenza','n#03874721 n#03776497 n#10396797 n#03776178 n#03788167',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('splendore','n#03874721 n#03874115 n#03776178',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('articolo_di_fondo','n#04739463',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('editoriale','n#04739463',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fondo','n#04739463 n#09616555 n#06693004 n#W0021197 n#09530734 n#W0021199 n#09618851 n#06278150 n#W0021200 n#09530909 n#04554155 n#W0021198 n#W0021194 n#W0021201 n#04515461 n#06695617 n#06355475 n#06324563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rubrica','n#04739463',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('basamento','n#02258757 n#02258436',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cuneo','n#03604098 n#02435484 n#N0002401',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('credenza','n#09631860 n#04544110 n#04562312 n#02346426 n#05085310 n#02518684',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('credito','n#09631860 n#10358851 n#09634656 n#10357033',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('okapia_johnstoni','n#01935362',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('okapi','n#01935362',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('miliziano','n#07410258',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attonimento','n#05582358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('meraviglia','n#05582358 n#05436975 n#05582577 n#05582729',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbalordimento','n#05582358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbigottimento','n#05582358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sconcerto','n#05582358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stupefazione','n#05582358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stupore','n#05582358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('meteco','n#07407625',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bigliettaio','n#06955402',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('controllore','n#06955402',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impiegato_della_biglietteria','n#06955402',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clausola_di_non_retroattività','n#10420641',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('isola','n#03527430 n#02868999 n#06741251',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salvagente','n#03527430 n#02922523',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spartitraffico','n#03527430',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carrello','n#02796372 n#02904305 n#02587333 n#02392046',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carretto','n#02796372 n#02791167',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dactylopius_coccus','n#01753638',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cocciniglia','n#01753638',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sumatra','n#06513590',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giano','n#06908778',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amburgo','n#06445349',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ritrovamento','n#04475449 n#00098007 n#02865563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scoperta','n#04475449 n#05389592 n#00098007 n#00098543',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bruciore','n#10284932',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('irritazione','n#10284932 n#00270946 n#10337915 n#05589430',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('damigiana','n#02386541',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('manganese','n#10492152',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stradina','n#03096228',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('congo','n#06423723',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('metecno','n#N0002532',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palla_da_basket','n#02260281',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apparato','n#04056989 n#02200827 n#06238814 n#02950954',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('meteorite','n#06759833 n#06759482 n#06759020',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('callosità','n#10305538',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agrume','n#09007491 n#05783252',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('miscelatore','n#03006231',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mixer','n#03006231 n#02298197',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buca','n#06729656 n#06728884 n#10024561 n#02824665',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fossa','n#06729656 n#09994374 n#01645082',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('infossamento','n#06729656',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conferenza_episcopale','n#W0020955',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anione','n#06690304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giovedì_santo','n#10909874',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('permutabilità','n#03723322',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('motoveicolo','n#03018224',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veicolo_a_motore','n#03018224',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('collegio','n#06152363 n#06220151 n#06171035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('collegio_dei_professori','n#06152363',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corpo','n#06152363 n#05966104 n#04055158 n#03931784 n#06673844 n#04056524 n#04056323',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corpo_insegnante','n#06152363',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banca_capofila','n#N0002733',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('termos','n#03494667',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('thermos','n#03494667',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attrezzo_sportivo','n#03389021',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sorriso_compiaciuto','n#05148100',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('psoriasi','n#10224435',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('divertimento','n#00330345 n#00693756 n#00272358 n#05569390 n#05569487 n#00273579 n#00332306 n#05280406',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ingranaggio','n#02750133',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dragaggio','n#00057016',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stigmate','n#10258245',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stimmate','n#10258245',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('necrosi','n#07821115',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lipasi','n#10719097',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forza_armata','n#06091176',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('servizio_militare','n#06091176',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('programma_applicativo','n#04931025',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('adito','n#02641840',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polvere','n#10645613 n#10763217',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riscatto','n#09560583 n#00726999',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ufologia','n#N0002192',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rosicatura','n#00539805',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colazione','n#05628658 n#05628419',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pranzo','n#05628658',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seconda_colazione','n#05628658',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assassino','n#07423684 n#07354173 n#07213561 n#07086477',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('omicida','n#07423684 n#07354173',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pigiatrice','n#03624036',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('levata','n#N0001047 n#05487790',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('levata_della_posta','n#N0001047',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('emmenthal','n#05884802 n#05884633',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biglia','n#02289096 n#02966407',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bilia','n#02289096 n#02966407',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palla_da_biliardo','n#02289096',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_keniota','n#09864009',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capitale_d''esercizio','n#09615173',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('potere_d''acquisto','n#Y0005591',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('complicità','n#10079427',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('saudita','n#07035913',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marmotta','n#01862448 n#07367121 n#07584808 n#07482106',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('richiamato','n#N0001709',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cultura','n#04437483 n#04590255 n#04589767 n#06152585 n#00013243 n#04590750',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dispiacere','n#05605389 n#05602279 n#04492345','v#01239331 v#00575328',NULL,NULL);
INSERT INTO italian_index VALUES ('scontentezza','n#05605389',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('av','n#N0002382',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avellino','n#N0002382',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eliozoo','n#00918134',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gallinula_chloropus','n#01528650',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gallinella_d''acqua','n#01528650',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sciabica','n#01528650',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pronome','n#04772420',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('preparato_per_torta','n#05648124',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pastore_belga_groenendael','n#01615429',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ragazzo','n#07572054 n#07153837 n#07389783 n#07123842 n#07123422 n#07592357 n#07691951',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('emolisi','n#09733928',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arsenico','n#10479441 n#10588227',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('termocoperta','n#02626645',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seggio_elettorale','n#06294665',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oro','n#09629533 n#10487505 n#09614460 n#03881805',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ballo','n#06127075 n#00339532 n#05266564 n#00337330',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('saracinesca','n#N0001779',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nodo_piano','n#03222824',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mergus_albellus','n#01371945',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pesciaiola','n#01371945 n#N0001446',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stravinsky','n#07758102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('igor_stravinsky','n#07758102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riforma_fondiaria','n#00167365',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('provenza','n#06533611',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pista','n#03263282 n#02322833 n#03199633 n#03242176 n#04488073 n#03199185 n#02176087 n#03347066',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caricatore','n#07570975 n#02395801 n#02953569 n#07610890',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dimensioni','n#03977358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grandezza','n#03977358 n#03971772 n#03982056 n#04026591 n#03977593 n#03776178 n#03981562',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grossezza','n#03977358 n#03980963 n#03977593 n#03981562',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('misura','n#03977358 n#00113217 n#03988388 n#10045533 n#03974960 n#03825241 n#03991813 n#03973686 n#05136601 n#03972490',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barilata','n#09912170',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barile','n#09912170 n#09913734 n#09790186 n#02253645 n#02526877',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('botte','n#09912170 n#09913734 n#02253645 n#02298734',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disappetenza','n#N0000569 n#N0000949',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inappetenza','n#N0000569 n#N0000949',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tilia_cordata','n#08508795',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tiglio_selvatico','n#08508795',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arcivescovo','n#07082144',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cretino','n#07383205 n#07333403 n#07216129',NULL,'a#02807809',NULL);
INSERT INTO italian_index VALUES ('stupido','n#07383205 n#07618181 n#07271334 n#07333403 n#07156174',NULL,'a#00408403',NULL);
INSERT INTO italian_index VALUES ('zulù','n#07383205 n#07464747',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammoniaca','n#10569599 n#10569383',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idrossido_di_ammonio','n#10569599',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('secondo_arrivato','n#07541239',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fresa','n#02354530 n#02999508 n#N0000780',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cardiografia','n#00533254',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elettrocardiografia','n#00533254',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('micron','n#09821645',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('culmo','n#09448740',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('meato','n#04075648',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sterlina_irlandese','n#09856822',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capannello','n#N0000265',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('analisi','n#05344583 n#05341168 n#04451818 n#00422134',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('analisi_a_posteriori','n#05344583',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inning','n#10959117',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cineasta','n#07503790 n#07605416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seghetto','n#02783352',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seghetto_per_metalli','n#02783352',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('narcosi','n#10104142 n#04391874',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('groppo','n#07838751 n#06844887',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piovasco','n#07838751 n#07831151',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cuscinetto','n#03127593 n#03076351 n#02271838',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guancialetto','n#03127593',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portaspilli','n#03127593',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('puntaspilli','n#03127593',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('offerta','n#05370271 n#05358049 n#05355066 n#09549012 n#09726614 n#05357635',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accoglienza','n#04974571 n#10342359 n#04974979',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trattamento','n#04974571 n#00430183 n#05439027 n#00735486',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tortora','n#01330747 n#01330893',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pecorino','n#N0001406',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cynodon_dactylon','n#08422500',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gramigna_rampicante','n#08422500',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('innodia','n#00815966',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('litania','n#00815966 n#05406179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salmodia','n#00815966',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prima_attrice','n#07367201',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('primadonna','n#07367201',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stampo','n#03008954 n#07594053',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('errabondo','n#07660316',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('randagio','n#07660316',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anno_in_corso','n#Y0005582',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cuscino','n#03124442 n#02536588',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guanciale','n#03124442 n#02536588',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nube_temporalesca','n#06751294 n#06750131',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mirra','n#08992578 n#10689595',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lampone','n#08955660 n#08956160 n#05781662',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dragone','n#07225454',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dollaro_canadese','n#09835640',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tetano','n#10193175',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trisma','n#10193175',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trismo','n#10193175',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('economia_di_mercato','n#06192562',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('liberalismo_economico','n#06192562',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('liberismo','n#06192562 n#00707691',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bruttezza','n#03693789',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brutto','n#03693789 n#10416169',NULL,'a#00219341 a#01078381',NULL);
INSERT INTO italian_index VALUES ('zebù','n#01901881',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ferro_a_vapore','n#03407083',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ferro_da_stiro_a_vapore','n#03407083',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('matematica','n#04597590',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('andromaca','n#N0000135',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('yiddish','n#05212011',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lanciarazzi','n#02910943',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lanciatore','n#02910943 n#07641053 n#07478795',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spararazzi','n#02910943',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('continuità','n#10347591',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inesauribilità','n#10347591',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('persistenza','n#10347591 n#03945118',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('complesso_di_superiorità','n#03828526',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paranoia','n#10331029',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parallela','n#N0001382',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ischio','n#04094566',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('adacquamento','n#00684743',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('adacquatura','n#00684743',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('irrigazione','n#00684743 n#00446031',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vespa','n#01716866 n#01716135 n#03018070 n#01717598',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cistifellea','n#04185895',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colecisti','n#04185895',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vescichetta_biliare','n#04185895',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cintura_di_sicurezza','n#03294823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apparecchio_elettrico','n#03168791 n#02632837',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monte_dei_pegni','n#03098300',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banco_dei_pegni','n#03098300',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monte_di_pietà','n#03098300',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('animalismo','n#04573063',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('delizia','n#05569060 n#04490585',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diletto','n#05569060 n#07109169 n#04490585',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('godimento','n#05569060 n#05569487 n#04041567',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piacere','n#05569060 n#05568771 n#00795713 n#00693635','v#01247684 v#01213205 v#01244897 v#01213391',NULL,NULL);
INSERT INTO italian_index VALUES ('schiavismo','n#N0001820 n#00266587',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tecnocrate','n#07633802',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gin','n#05927486',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clisma','n#00446454',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clistere','n#00446454',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('enteroclisi','n#00446454',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('enteroclisma','n#00446454',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eteroclisma','n#00446454',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lavativo','n#00446454 n#07295019 n#07583177',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('odocoileus_hemionus','n#01928500',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cervo_mulo','n#01928500',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portorico','n#06434401',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zambia','n#06651693',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('melanitta_nigra','n#01370423',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orchetto_marino','n#01370423',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('adunata_popolare','n#06189096',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comizio','n#06189096',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riunione_generale','n#06189096',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ghiotta','n#02604857',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leccarda','n#02604857',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cucchiaio','n#03387931 n#09917014 n#09917137',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asperula','n#08961310 n#08965032',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mondo','n#04476879 n#06684818 n#05973080 n#06753779 n#06079949 n#05957670 n#06691078 n#W0005495 n#04384026 n#09922518',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rev.','n#04781839',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reverendo','n#04781839',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guinea_francese','n#06535527',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acquisizione','n#00045827',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acquisto','n#00045827 n#00047517 n#09536899 n#00049855',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ottenimento','n#00045827 n#00046576',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nota_dominante','n#05130435',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tonica','n#05130435',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('matriarca','n#N0001147',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rigeneratore','n#02811762',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('confidente','n#07176391 n#07338772',NULL,'a#02343913',NULL);
INSERT INTO italian_index VALUES ('sera','n#10885337 n#10886190',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pipa','n#09915727 n#03129406',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pipata','n#09915727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attaccatura_dei_capelli','n#04080785',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impegno','n#05396507 n#00173872 n#00731811 n#00804778 n#05074715 n#05616909 n#05397001 n#00416445 n#00805460',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('promessa','n#05396507',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tantalite','n#10810224',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orditore','n#N0001327 n#07549346',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fossa_dell''orchestra','n#03061704',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('relativismo','n#04583411',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frustrato','n#N0000787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('investitore','n#07344878',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calzaturificio','n#N0000245',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('enfasi','n#03933280 n#05314834 n#05303183 n#10356373',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('furia','n#03933280 n#10110870 n#10110976 n#03949998 n#05588413 n#00362788 n#10368450 n#03933665',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veemenza','n#03933280 n#05561864',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esecutore_testamentario','n#07251391',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('costante','n#09761890 n#04509502',NULL,'a#00343162 a#00559995 a#02385304',NULL);
INSERT INTO italian_index VALUES ('condom','n#02485388',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('preservativo','n#02485388',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('profilattico','n#02485388',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brasilia','n#06493672',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filetto','n#03359504 n#03540622 n#05115311 n#05699354 n#03288844 n#02328855 n#05425675 n#05703902',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rorippa_amphibia','n#08203522',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crescione_anfibio','n#08203522',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crescione_di_chiana','n#08203522',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sondaggio','n#00602658 n#00592646 n#04470360 n#04470543',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('traforo','n#00602658 n#03550931',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trapanatura','n#00602658 n#00592646',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trapanazione','n#00602658',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trivellamento','n#00602658',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trivellatura','n#00602658',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trivellazione','n#00602658',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('festival','n#00333254',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('kermesse','n#00333254',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sagra','n#00333254',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('precondizione','n#04529130',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('condizione_indispensabile','n#04529130',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sordità','n#10434472',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erboristeria','n#N0000655 n#N0000654',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imam','n#07334477',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iman','n#07334477',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('solfatara','n#N0001921',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zolfatara','n#N0001921 n#03440892',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sparata','n#05393346',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dirittura','n#03783526 n#03423493 n#03816422',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('probità','n#03783526 n#03815289',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rettitudine','n#03783526 n#03783294',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agglutinina','n#10786050',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prunus_armeniaca','n#08940791',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('albicocco','n#08940791 n#08940402',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caracas','n#06649991',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autosufficienza','n#10086400',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ariadne','n#06909845',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('permanganato','n#10749095',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fascia','n#02245210 n#02245671 n#02246011 n#06276818 n#02209374 n#02672366 n#03452180 n#02829005 n#04325500',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nadir','n#06343300',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('kampala','n#06592757',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('megaloblasto','n#04227708',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('identificazione','n#05616407 n#00098857',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immedesimazione','n#05616407',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vignetta','n#05078762',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lobulo','n#04258621',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idea','n#04492484 n#04495746 n#04492995 n#04564355 n#04588594 n#04471938',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pensiero','n#04492484 n#05593817 n#04345975 n#04491326 n#04473075 n#05594044 n#04450733',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('briglia','n#02337935 n#03226864',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immunosoppressione','n#10067721',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amina','n#10565643',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammina','n#10565643',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiocciola','n#01457421 n#04132575',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ascaride','n#01443675 n#01444381',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mastoidite','n#10296116',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cancerologia','n#04629368',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oncologia','n#04629368',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seconda','n#02363314 n#03296309',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('saldatrice','n#N0001762',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alcedo_atthis','n#01344854',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('martin_pescatore','n#01344854 n#01344464',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('desktop','n#02233096',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spiranthes_spiralis','n#08391787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('viticcini_autunnali','n#08391787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diritto_a_un_giusto_processo','n#04038033',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diritto_al_giusto_processo','n#04038033',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fitormone','n#10570528',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ormone_vegetale','n#10570528',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pasciulì','n#03095017 n#09161203',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('patchouli','n#03095017 n#09161203',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anglosassone','n#07014231 n#07014111 n#05210738',NULL,'a#02853025',NULL);
INSERT INTO italian_index VALUES ('paiolo','n#N0001362',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('geremiade','n#05388046',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piagnisteo','n#05388046',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('querimonia','n#05388046',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alpenstock','n#02180075',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lungo_metraggio','n#04961534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lungometraggio','n#04961534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sinapis_alba','n#08204327',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('senape_bianca','n#08204327',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quanto','n#N0001629',NULL,NULL,'r#00107215');
INSERT INTO italian_index VALUES ('cantone','n#06296283 n#02502160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alloro','n#08015110 n#08015534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lauro','n#08015110',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eguaglianza','n#03730389 n#10049536',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('egualità','n#03730389',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ugualità','n#03730389',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diomedea_nigripes','n#01570402',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('albatro_piedi_neri','n#01570402',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('storione','n#02129939',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('passatoia','n#N0001394 n#03398515',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('divisore','n#09888066',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dadaismo','n#06252963',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diplotaxis_erucoides','n#08193366',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ruchetta_violacea','n#08193366',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('galliformi','n#01307245',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gallinacei','n#01307245',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cirrostrato','n#06750000',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sloop','n#03354972',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arciprete','n#07082684',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prelato','n#07082684',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('presule','n#07082684',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('uso','n#04012134 n#00265102 n#00532309 n#00605730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grembo','n#04309381',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('schisto','n#06697651',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scisto','n#06697651',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('libertà','n#10083322 n#10081855 n#10079933 n#10080679',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prodotto','n#04510165 n#05440251 n#02987655 n#03175725 n#10763715',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risultato','n#04510165 n#00020977 n#05440251 n#05438613 n#05053336 n#07766144',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filaria','n#01446787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giunco','n#08054417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ala','n#01660115 n#03624385',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aficionado','n#07255925',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammiratore','n#07255925 n#07064103 n#07621123',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fan','n#07255925',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('habitué','n#07255925',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amante','n#07255925 n#06950629',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interrogativo','n#05376265 n#04394091 n#03736708 n#05378080',NULL,'a#00835722',NULL);
INSERT INTO italian_index VALUES ('canonista','n#07137823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giureconsulto','n#07352677',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giurisperito','n#07352677',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giurisperto','n#07352677',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giurisprudente','n#07352677',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giurista','n#07352677',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leggista','n#07352677',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('legista','n#07352677',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('timpano','n#02886397 n#02732275 n#04130895',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prole','n#00865638',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autogoverno','n#10080831',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('traiettoria','n#07817417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cantina','n#02258579 n#02411112 n#03252760 n#02378820',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cantinato','n#02258579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interrato','n#02258579',NULL,'a#00288350',NULL);
INSERT INTO italian_index VALUES ('piano_interrato','n#02258579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scantinato','n#02258579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('semiinterrato','n#02258579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seminterrato','n#02258579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sotterraneo','n#02258579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sotto_terra','n#02258579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sottoterra','n#02258579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grasso','n#10661323 n#10719247 n#10682322 n#04089143',NULL,'a#00939455 a#00934421',NULL);
INSERT INTO italian_index VALUES ('impeto','n#07791222 n#00234695 n#05261864 n#10075760 n#03933665',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('slancio','n#07791222 n#00076563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('geometria','n#04598408',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('annuncio','n#05592546 n#05056012 n#05009122 n#05370646 n#05435037 n#05411061 n#05056776 n#05434729',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('annunzio','n#05592546 n#05056012 n#05009122 n#05370646 n#05435037 n#05411061 n#05056776 n#05434729',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('presentimento','n#05592546 n#05395603 n#05592156',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marte','n#06754119 n#06903063 n#10883014',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dio_padre','n#06889800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('padre','n#06889800 n#00867076 n#07276210 n#W0021114 n#07258194 n#07272604 n#07258439',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('padre_eterno','n#06889800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('padreterno','n#06889800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quartiere_povero','n#06372133',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esemplare','n#04484940 n#02971058 n#04483764',NULL,'a#01271812',NULL);
INSERT INTO italian_index VALUES ('bengodi','n#N0000151',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('levriero_persiano','n#01602417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('saluki','n#01602417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('naira','n#09851298',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('naira_nigeriano','n#09851298',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('allarme_antincendio','n#05422278 n#02683196',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foglia_di_fico','n#02676557',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ioide','n#04094262',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abboffata','n#05630734',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbuffata','n#05630734',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mangiata','n#05630734',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scorpacciata','n#05630734',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strippata','n#05630734',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sventrata','n#05630734',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ventrata','n#05630734',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('educazione','n#03851637 n#03836008 n#00731545 n#03846037 n#03851783 n#00567704 n#03851978 n#04440488 n#00731443 n#03846287',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('azione_giudiziaria','n#00766856',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iter_parlamentare','n#00766856',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('procedimento','n#00766856 n#00378984 n#00660718',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lesina','n#02228691 n#03788750',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giacobinismo','n#04713404',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falsetto','n#03994238',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spirito_libero','n#07278124',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spirito_indipendente','n#07278124',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disaccordo','n#03895418 n#05368405 n#05368274 n#03731730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disarmonia','n#03895418 n#03895511',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cambio','n#00707799 n#04103182 n#09594438 n#09389743 n#02750625 n#00128951 n#02421790',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vicia_sepium','n#08877065',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veccia_delle_siepi','n#08877065',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crasi','n#09720293',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sineresi','n#09720293 n#09689290',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('naufragio','n#05477947',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caccia_alla_volpe','n#00287734',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diciannove','n#09899636',NULL,'a#02100677',NULL);
INSERT INTO italian_index VALUES ('adattatore','n#02165316',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cucumis_melo','n#08470253',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('delphinus_delphis','n#01580929',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('delfino_comune','n#01580929',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('punto_d''osservazione','n#06387458',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ganglio','n#04110916',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lycaon_pictus','n#01625953',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cane_selvatico_africano','n#01625953',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('licaone','n#01625953',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lolita','n#07437754',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ninfetta','n#07437754',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ortodontia','n#04626868',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tenacità','n#03921518',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('poliedro','n#10002914',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('complesso_di_elettra','n#05563000',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affumicatoio','n#03358511',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trisillabo','n#04756881',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('balordaggine','n#03831006 n#04366643 n#00810350 n#04367590',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('demenza','n#03831006 n#10329126 n#10329235 n#10328922 n#04367590',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fatuità','n#03831006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('follia','n#03831006 n#10329126',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gaglioffaggine','n#03831006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gagliofferia','n#03831006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grullaggine','n#03831006 n#04366309 n#00810350',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mondanità','n#03831006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idoneità_al_volo','n#10431540',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('volvo','n#N0002570',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mostro','n#06853216 n#07277959 n#07418621 n#07059467',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cedro','n#05786435 n#09009041 n#07947238 n#07940601 n#07940800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mosto','n#N0001236',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciprea','n#01466296',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('porcellana','n#01466296 n#02430833 n#03158064',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('centauro','n#06854235',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chimo','n#10447965',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assegno_a_copertura_garantita','n#09638472',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pantano','n#10043245 n#06786753 n#06786380 n#06786505 n#06786830',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dodicesimo','n#09976798',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('invertebrato','n#01420347',NULL,'a#02390141',NULL);
INSERT INTO italian_index VALUES ('mezzo','n#02975720 n#06315998 n#04730468 n#06286659 n#00111872 n#09891093',NULL,'a#00483994',NULL);
INSERT INTO italian_index VALUES ('ipermetropia','n#10437186',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('presbiopia','n#10437186',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('presbitismo','n#10437186',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sostanza','n#00010572 n#04953751',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idrocarburo','n#10699784',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giulebbe','n#05888357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sciroppo','n#05888357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('siroppo','n#05888357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stroma','n#09258809 n#04326705',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('edema','n#10275482',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('casale','n#02666884 n#06383813 n#06107364',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cascina','n#02666884 n#02542958 n#09533404',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cascinale','n#02666884 n#09533404',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fattoria','n#02666884 n#02666240',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('masseria','n#02666884 n#02666240',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acidità','n#03901632 n#10286788 n#03901461 n#04416794',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('serpente','n#01247280 n#07587675',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('serpe','n#01247280 n#07587675',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colubro','n#01247280',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mogol','n#07416858',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('geroglifico','n#04797046 n#04826640',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arpa','n#02800343',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catechista','n#07632624',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ectoderma','n#00988748',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scorpione','n#01289705',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ironia','n#03709437 n#05076385',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intimità','n#05598089 n#03669571 n#10038885 n#03647446',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sifone','n#03341371',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sede','n#02808632 n#06371658 n#06309630 n#06331456 n#06368745',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quartier_generale','n#02808632 n#02475506 n#W0020795',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arbitraggio','n#00708351 n#00771397 n#05349429 n#00772115',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esplorazione','n#00201174 n#00604772 n#00604336 n#00633825 n#00634183',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('appropriazione','n#00051417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rubidio','n#10499606',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cancan','n#04418982 n#00362507 n#00341439 n#00361442 n#05493076 n#05489772',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiasso','n#04418982 n#05498689 n#05502027 n#05329674 n#00361442 n#05493076',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dissonanza','n#04418982 n#03895270 n#03731730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rumore','n#04418982 n#04417716 n#05499597 n#05394487',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asso','n#02160943 n#07059467',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('condiscepolo','n#N0000434',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('martes_martes','n#01946138',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('martora','n#01946138 n#01945877',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('verità','n#04482936 n#05041935 n#03817073 n#10055723',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marciatore','n#07395530 n#N0001132',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pirofila','n#N0001480',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('variometro','n#03567688',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sikh','n#07576871',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zucca','n#04291030 n#08467623 n#08464304 n#05772123 n#08466935',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('segreteria','n#06172324 n#00393890',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('armeno','n#04789537 n#07005621 n#05204897',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imprevidenza','n#03833366',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('improvvidenza','n#03833366',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parnaso','n#06721505',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('neuropsicologia','n#04668458',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compagnia','n#10037091 n#06096711 n#06126536 n#06137388 n#06008236 n#06083786 n#06085732',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('litofita','n#09414592',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conto_passivo','n#10395617',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('debito_a_breve','n#10395617',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('debito_a_breve_termine','n#10395617',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giornata','n#W0021115 n#W0021116 n#10878282 n#10862286 n#10883946 n#W0021117',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accozzaglia','n#06211515 n#10402671 n#06083357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caldarone','n#06211515 n#02368898',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calderone','n#06211515 n#02368898',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carabattole','n#06211515',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cianfrusaglie','n#06211515',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('farragine','n#06211515',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('melange','n#06211515',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('minutaglia','n#06211515',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('miscuglio','n#06211515 n#00244416 n#05491211 n#04569875 n#05909338',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mosaico','n#06211515 n#03015420',NULL,'a#02789683',NULL);
INSERT INTO italian_index VALUES ('musaico','n#06211515 n#03015420',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oggetti_vari','n#06211515',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('umiltà','n#05581967 n#03829724',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scardinius_erythrophthalmus','n#00969232',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scardola','n#00969232',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scardova','n#00969232',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('separazione','n#10342852 n#N0001071 n#00246210',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riserva','n#07620124 n#05067166 n#00684444 n#06092042 n#09922407 n#06332265 n#09626584',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nevaio','n#06727530',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bidente','n#03132833',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forca','n#03132833 n#02735490 n#03044012 n#02804756',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forcone','n#03132833 n#02714941',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tridente','n#03132833 n#03539902',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pattuglia','n#06098274',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pattugliamento','n#06098274 n#00528148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baronessa','n#07104444',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autorità','n#10358851 n#07384250 n#04045518 n#06947830 n#06000383 n#07492073 n#03930426 n#07540044',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('onorabilità','n#10358851 n#03814650',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reputazione','n#10358851 n#04705103',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riputazione','n#10358851 n#04705103',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bancarotta_fraudolenta','n#W0020982',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('traffico','n#00722332 n#06231214',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giro','n#00722332 n#05535152 n#W0003118 n#05966470 n#00199642 n#00191531 n#00189453 n#00290820 n#06117068 n#10890324 n#W0003129',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asse_da_stiro','n#02867988',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pterodattilo','n#01244167',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parigino','n#07019766',NULL,'a#02779635',NULL);
INSERT INTO italian_index VALUES ('lievito_in_polvere','n#10592023',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fumetto','n#05255565',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('striscia','n#05255565 n#03689511 n#03430059',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barra','n#02918897 n#02292928 n#03247107 n#03504804 n#05127816 n#02249024 n#02249246 n#02248511 n#03413217',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leva','n#02918897 n#02795163 n#04488721 n#00750302 n#02919378 n#00750161',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sessantesimo','n#09977988',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grigio','n#03878371',NULL,'a#02572350 a#01586508 a#00366117',NULL);
INSERT INTO italian_index VALUES ('grigiore','n#03878371',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fischiata','n#05329592 n#05498136 n#N0000750',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fischio','n#05329592 n#05498136 n#03613189 n#05507926 n#05096821',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('consigliere_comunale','n#07069747',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('legislatore','n#07368908 n#07365517',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('silofono','n#02966612',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('xilofono','n#02966612',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('babilonese','n#06963475 n#04789830',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('convinzione_sbagliata','n#04529867',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idea_sbagliata','n#04529867',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quartino','n#N0001636 n#N0001635',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mancino','n#07368199',NULL,'a#01956753',NULL);
INSERT INTO italian_index VALUES ('beduino','n#07106593',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiodo_di_garofano','n#05847600 n#08643062',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('davanzale','n#03622225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cappero','n#08174578',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tossicologo','n#07646343',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crisi','n#10040291 n#10394468 n#10134893 n#05520463 n#10135947',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('turno_di_giorno','n#10985159 n#06100509',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fodero','n#03311748 n#02825203 n#03278928',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guaina','n#03311748 n#02717320 n#02504878 n#04068007',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('beneplacito','n#05015182 n#05364269 n#05575439',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('consenso','n#05015182 n#10066318 n#05364269 n#05575439',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('permesso','n#05015182 n#05015367 n#10864475 n#00738404 n#04916758 n#05364269',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavia_cobaya','n#01865766',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavia','n#01865766 n#01865613 n#07618819',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ginocchio','n#04319321',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('valutazione','n#05341168 n#04426384 n#04428566 n#00561814',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cascate_del_niagara','n#06843442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('kyphosus_sectatrix','n#02094165',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pesce_timone','n#02094165',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('campanello','n#02589818',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mandrino','n#03383306',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ronda','n#06275172',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cross','n#N0000508',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('motocross','n#N0000508 n#N0001241',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vanadato','n#10823160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fujitzu','n#N0002513',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('commozione','n#05560878 n#05516232',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('emozione','n#05560878',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('persona_giuridica','n#W0021045',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('epilogo','n#04823138 n#04822935 n#10966797 n#05365642',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ordinata','n#04602657 n#04600736',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('libico','n#07028882',NULL,'a#02826225',NULL);
INSERT INTO italian_index VALUES ('incostituzionalità','n#N0000962',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('finezza','n#03706716 n#04352743 n#10374580 n#04002048 n#04435866 n#03775722',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inafferrabilità','n#03706716',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('facilità','n#03704727 n#04355442 n#04354000 n#03705224',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('semplicità','n#03704727 n#03823333 n#03829724 n#03742785 n#03755770',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incudine','n#02199059 n#04132306',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cannelloni','n#05891691 n#N0002371',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lettore','n#07520729 n#07367702 n#07619854',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('evo','n#N0000686',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spranga','n#N0001978 n#02248511',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('font_proporzionale','n#05113609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carattere_proporzionale','n#05113609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('massimo','n#03992719 n#09908161 n#09921347',NULL,'a#01433642',NULL);
INSERT INTO italian_index VALUES ('malattia_da_carenza','n#10205224',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biografo','n#07113037',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('saldatura','n#00097334 n#03605952',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('equus_hemionus_hemionus','n#01888453',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moderatore','n#07416570 n#10559892',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('germanio','n#10487223',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('peripezie','n#N0001436',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cuneiforme','n#04796279',NULL,'a#02554227',NULL);
INSERT INTO italian_index VALUES ('carbone_coke','n#10527150',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coke','n#10527150',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mezzana','n#02524918 n#03006678 n#07503439',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attrattiva','n#03692429 n#05573752 n#03692813',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('charme','n#03692429',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fascino','n#03692429 n#03693651 n#03692813',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('magia','n#03692429 n#00063210 n#04578926 n#04586141',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malia','n#03692429 n#04586141 n#10338926',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seduzione','n#03692429 n#00104146',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dollaro_del_brunei','n#09835308',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('botton_d''oro','n#08031588',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ranuncolo','n#08031588',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('solario','n#03442944',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('solarium','n#03442944',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cadenza','n#03900196 n#05302022 n#05283288',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('schematizzazione','n#00578611',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portulaca','n#08167244',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('testimone_oculare','n#07254262',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dinaro_giordano','n#09832220',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lagos','n#06553124',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rotta','n#03295441 n#06348591 n#06709272',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rotta_marittima','n#03295441',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ippodromo','n#02820559',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bersaglio','n#03472826 n#06379373 n#02758894',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('obbiettivo','n#03472826 n#04587307 n#04586952',NULL,'a#01556883',NULL);
INSERT INTO italian_index VALUES ('obiettivo','n#03472826 n#04587307 n#04586952 n#02371599',NULL,'a#01556883',NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_della_sierra_leone','n#09847568',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assemblea_degli_azionisti','n#Y0005571',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crimine','n#00490590 n#00491001 n#00491673',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('delitto','n#00490590 n#00491001 n#00491673',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fattaccio','n#00490590',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('illecito','n#00490590 n#00606110',NULL,'a#01487075',NULL);
INSERT INTO italian_index VALUES ('misfatto','n#00490590 n#00491001',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reato','n#00490590 n#00477929',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scolopax_rusticola','n#01543067',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('beccaccia','n#01543067 n#01542765',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pellegrino','n#07476254 n#01133645 n#07476342',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baraggia','n#06273465',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barraggia','n#06273465',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brughiera','n#06273465 n#06727393',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aumento','n#05479891 n#09904938 n#03984405 n#03984543 n#03983965 n#09729055 n#05488220 n#00234220',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fantasma','n#04543186 n#04533237 n#06896801',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('finzione','n#04543186 n#00486869',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bolla_di_accompagnamento','n#04894791',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bolla_di_accompagnamento_merci','n#04894791',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polizza_di_carico','n#04894791',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polizza_di_carico_all''ordine','n#04894791',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mostarda','n#05852339',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quantità','n#03983517 n#03983740 n#00020056',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soprano','n#03896452 n#07593299',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fanfaronata','n#05398653',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gigionata','n#05398653',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('millantamento','n#05398653',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('millanteria','n#05398653 n#05398454 n#00483557 n#03828199',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('smargiassata','n#05398653',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quiz','n#05379363',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('largizione','n#09546008',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('termometria','n#00724003',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autolesionismo','n#00751761',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gruppo_sociale','n#05962976',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cinismo','n#05607640',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ginocchiera','n#02892946 n#N0000846 n#02892839',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('difesa','n#00796391 n#00777065 n#02551913 n#00611021',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('discolpa','n#00796391 n#05052528',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scusante','n#00796391',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('battimento','n#07814228',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lessicografia','n#00596968',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contitolare','n#N0000456',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('codice_oggetto','n#04793927',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eptagono','n#10001597',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ettagono','n#10001597',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cella_campanaria','n#02277408',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('molestatore','n#07416977',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interiorità','n#N0000986 n#03646320',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prefisso','n#04760894',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('termoionica','n#04654855',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imposta_presuntiva','n#N0002783',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chitarrista','n#07305149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acaro','n#01298637 n#01300456',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portabagagli','n#02946676 n#02315972',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portapacchi','n#02946676',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('connotazione','n#04952685 n#04548379',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('addetto_alla_disinfestazione','n#07253418',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mormonismo','n#04721701',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maschera_mortuaria','n#02548508',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sapone','n#03363750',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pezzato','n#N0001451',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bromus_inermis','n#08417828',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forasacco_spuntato','n#08417828',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mutabilità','n#03725478 n#03720732',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mutevolezza','n#03725478 n#03721331',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scampanellata','n#N0001805',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiavaio','n#07379251',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fabbro_ferraio','n#07379251 n#07115121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('magnano','n#07379251 n#07586908',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbafata','n#03989928',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ghiera','n#N0000833 n#02671818',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conigliaia','n#03198816',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conigliera','n#03198816',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cuspide','n#04119237 n#06349777 n#05110203 n#03409281',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('multiproprietà','n#N0001256',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('delfino','n#01580491 n#07202473 n#00374336',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colonna_vertebrale','n#04330266',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spina_dorsale','n#04330266 n#03929314',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spondeo','n#05308605',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cosmo','n#06270582 n#06691078',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spazio_cosmico','n#06270582',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spazio','n#06270582 n#04817735 n#05134551 n#10024194 n#10391618 n#09922737 n#05122762 n#00015975 n#06373003',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guerra_dei_prezzi','n#09968166',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cineteca','n#N0000375 n#N0000374',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filmoteca','n#N0000375',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('galantina','n#05896582',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bacterio','n#00912216 n#00884781',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('batterio','n#00912216 n#00884781',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('microbo','n#00912216',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gracchio','n#05493836 n#01102208',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tursiops_gilli','n#01581760',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riproduzione','n#00658528 n#03229727 n#09698499',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('medagliere','n#N0001155',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bruciatura','n#00259278 n#00243251 n#10260110 n#10260405 n#10281055',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('argentario','n#07577249',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('argentatore','n#07577249',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('argentiere','n#07577249',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inargentatore','n#07577249',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('argomentazione','n#04985978 n#04452090',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attestazione','n#04985978 n#04986836 n#05040541 n#04860581',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fedeltà','n#03821154 n#03769341 n#03821365 n#03820929',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inconfutabilità','n#03735385',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incontestabilità','n#03735385',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incontrovertibilità','n#03735385 n#03735615',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('insindacabilità','n#03735385',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('irrefutabilità','n#03735385',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conduzione','n#00734610 n#04896811 n#00682434 n#07837945',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('direzione','n#00734610 n#09959689 n#06201293 n#06389665 n#04698475 n#04987402 n#00389777 n#06201180',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dirigenza','n#00734610 n#06201293 n#06201180',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gerenza','n#00734610',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gestione','n#00734610 n#00737271 n#00728919 n#00709934 n#06201180 n#00735486',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('management','n#00734610 n#06201180',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grandinata','n#07805461',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cervus_canadensis','n#01927800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cervo_canadese','n#01927800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('wapiti','n#01927800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('madrigalista','n#07386342',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('congelamento','n#09741258 n#10265919',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bioetica','n#N0000165',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bilancia','n#02239342 n#03279530 n#06394725 n#03611496',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bilancino','n#02239342 n#03611496',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sofocle','n#N0002060',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autofficina','n#02738353',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('officina','n#02738353 n#03632186',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leptinotarsa_decemlineata','n#01675425',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dorifora','n#01675425',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bottiglieria','n#02411112',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('infermeria','n#02267975 n#03333250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('listello','n#02909822 n#03430329',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lince_rossa','n#01636197',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lynx_rufus','n#01636197',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('porcellana_fine','n#02312403',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imperatrice','n#07240495',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acrilico','n#10737703',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('delhi','n#06510252',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nicchia_ecologica','n#10033655',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cargo','n#02319546 n#02389043',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mercantile','n#02319546',NULL,'a#02756682',NULL);
INSERT INTO italian_index VALUES ('motetto','n#N0001246',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mottetto','n#N0001246',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impressionabilità','n#04372947 n#N0000941 n#10420858',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chilo','n#04199204 n#09880778',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nervosismo','n#03648944 n#05614842 n#10313853',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('boccaglio','n#03021463 n#03046685',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('islam','n#04722493 n#06032903',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('islamismo','n#04722493 n#06032903',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maomettismo','n#04722493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mezza_luna','n#04722493 n#10013694',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mezzaluna','n#04722493 n#10013694',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mussulmanesimo','n#04722493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('musulmanesimo','n#04722493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alter_ego','n#07071710',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cabrata','n#N0000228',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impennata','n#N0000228 n#N0000931 n#N0000933 n#N0000930 n#N0000932',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bordeaux','n#03880107 n#06527083',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ocimum_basilicum','n#09158918',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('basilico','n#09158918 n#05849073 n#09158741',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('daino','n#10581341 n#01927002 n#01404187 n#01929303 n#01404316',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ailurus_fulgens','n#02003656',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panda','n#02003656 n#02004296',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panda_minore','n#02003656',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('poltroncina','n#N0001519',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('obiettore_di_coscienza','n#07178524',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eptesicus_serotinus','n#01655873',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('serotino_comune','n#01655873 n#01654466',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paffutezza','n#03906706 n#03906560',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavalierato','n#06207397',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piorrea','n#10212368',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gusto','n#05569706 n#04374716 n#05569487 n#04416226 n#05573914',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('podestà','n#07401898',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sindaco','n#07401898',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lisina','n#10723434',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elica','n#03288097 n#03255795 n#08443906 n#09997319 n#03178459',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('commesso','n#07543626',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('patto_suicida','n#05366493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ranunculus_lingua','n#08033250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ranuncolo_delle_canne','n#08033250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('flottazione','n#07850533',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('galleggiamento','n#07850533',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('angolo','n#06684696 n#06378832 n#02621337 n#02501820 n#02502160 n#06299371 n#06299227 n#06299540 n#10005664 n#06365181 n#02501991',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arbitrato','n#00771397 n#05349429',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lodo','n#00771397',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caporedattore','n#07393001',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('redattore_capo','n#07393001',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scenotecnica','n#04364746',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('discredito','n#10360205',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scredito','n#10360205',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('squalifica','n#10360205',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agopuntore','n#N0000031',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agopunturista','n#N0000031',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fine_stagione','n#W0020879',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('halibut','n#05826247 n#02150008 n#02149707',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ippoglosso','n#05826247 n#02149707',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sottobicchiere','n#02460666',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sottobottiglia','n#02460666',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sottocoppa','n#02460666',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('produzione','n#05256705 n#00587304 n#00586441 n#03175725 n#03067661 n#00586701',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ducato','n#10354950 n#06308104 n#09643522',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gioco_di_prestigio','n#00063210',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trucco_magico','n#00063210',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trucco_illusionistico','n#00063210',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caveau','n#03569066 n#03431305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capote','n#02827546',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deriva_dei_continenti','n#07782667',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('certificato_di_diritto_di_opzione','n#05012271',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('certificato_di_diritto_di_sottoscrizione','n#05012271',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('garantia','n#05012271 n#09614018 n#05397001 n#05396854 n#05012923',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('garanzia','n#05012271 n#09614018 n#05397001 n#05396854 n#05012923',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('warrant','n#05012271',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capogiro','n#10311355',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giracapo','n#10311355',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giramento','n#10311355',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giramento_di_testa','n#10311355',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vertigine','n#10311355',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ampere','n#09802552 n#09803016',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('altimetro','n#02181069',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frutti_di_mare','n#05818283',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mollusco','n#05818283 n#01453924',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stratega','n#07614745',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stratego','n#07614745',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('transumanza','n#00205359 n#N0002143',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sigaro','n#02440112 n#03249129',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stagflazione','n#09727812',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('curvatura','n#00260095 n#10214063 n#03980326 n#03959291',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alitosi','n#10646980',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lanolina','n#10629573',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ballo_in_maschera','n#06127756',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ballo_mascherato','n#06127756',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radice_cubica','n#09887038',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bulgaro','n#10581751 n#07009304 n#05207628',NULL,'a#02802458',NULL);
INSERT INTO italian_index VALUES ('spezzatino','n#05644653',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bestemmiatore','n#07115381 n#07625824',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('blasfemo','n#07115381',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fregio','n#02724201 n#02550579 n#05150806',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fermata','n#06376001 n#00688254 n#00696570',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elettricità','n#07793357 n#07793035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('luce','n#07793357 n#03621187 n#10442442 n#04475182 n#04707410 n#07788867 n#03872297 n#06367501 n#03919032 n#07820384 n#02923368 n#07811448 n#10073092',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('progesterone','n#10571549',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monetizzazione','n#04429004',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('per_cento','n#09952143',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('percento','n#09952143',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('percentuale','n#09952143 n#09590667 n#09561632',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('congettura','n#04529589 n#05079860 n#04528519',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('premessa','n#04529589 n#05060508',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('presunzione','n#04529589 n#03792664 n#00489276',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('presupposto','n#04529589',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('estrazione','n#00251679 n#00252144 n#09672777 n#00592125 n#03852754 n#00592521',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('svinatura','n#00251679',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caseificio','n#02517878 n#02517783',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('latteria','n#02517878 n#02542958',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strada_principale','n#02818860',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strada_maestra','n#02818860',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aspidiotus_perniciosus','n#01753167',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cocciniglia_di_san_josé','n#01753167',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erosione','n#09691024',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rodimento','n#09691024 n#06071059',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gomma_a_terra','n#02696078',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corner','n#10364213 n#00089679',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('campanula_medium','n#08345076',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('campanula_toscana','n#08345076',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erba_media','n#08345076',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giulietta','n#08345076',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tappeto','n#03260882',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bustino','n#N0000216',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('microtus_richardsoni','n#01842798',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arvicola','n#01842798 n#01843297 n#01840708',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coscia','n#05693545 n#05699486 n#04309035 n#05693148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('glaucoma','n#10236028',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('direttissimo','n#N0000566',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('infamia','n#10361706 n#10360525 n#10361358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('garibaldino','n#N0000819',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biennio','n#N0000157',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('londinese','n#07016465',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('basto','n#03075917',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spedizione','n#00621864 n#06218497 n#00077583 n#00077753 n#00034968 n#02388459',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('opera_lirica','n#05269375',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oceanografia','n#04656959',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('talassografia','n#04656959',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('talassologia','n#04656959',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cupezza','n#03891888 n#10073287 n#10418192 n#03660911',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('limbo','n#06336501',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('meteo','n#05058402',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('previsioni_del_tempo','n#05058402',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pleurite','n#10190629',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('breitschwanz','n#10585604',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scappamento','n#02650990',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tubo_di_scappamento','n#02650990',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tubo_di_scarico','n#02650990',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gambaletto','n#N0000812',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fideiussione','n#09605100 n#09614018',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calcestruzzo','n#10632664',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conglomerato','n#10632664 n#06225016 n#10660355',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('beton','n#10632664',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veterinaria','n#04633367',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('neodimio','n#10493109',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lathyrus_sativus','n#08842148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cece_nero','n#08842148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cicerchia_comune','n#08842148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impostazione','n#00595211',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pianificazione','n#00595211 n#04466419 n#00741673',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parapendio','n#N0001384 n#N0001383',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('telecomunicazioni','n#04741813',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elettrometro','n#02631537',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piuccheperfetto','n#09943779',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trapassato','n#09943779',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('missilistica','n#04665528',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chicchirichì','n#05495514',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ascoltazione','n#00566847',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ascolto','n#00566847',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('atomo','n#10471843 n#10448670',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('flip-flop','n#00278165',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compare','n#07057368 n#07128451 n#07294238',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('complice','n#07057368 n#07175599',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('correo','n#07057368',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corresponsabile','n#07057368',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('preparato','n#10668740',NULL,'a#01771525 a#01862436',NULL);
INSERT INTO italian_index VALUES ('mutante','n#07425392',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bruchus_pisorum','n#01687366',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frasca','n#09450317 n#03390174',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ramo','n#09450317 n#09448555 n#06037572 n#00710890 n#04594727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('francese','n#05223176 n#07019437',NULL,'a#02727539',NULL);
INSERT INTO italian_index VALUES ('laringoiatra','n#N0001020',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filiale','n#05994237 n#06212528',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('società_affiliata','n#05994237',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('società_sussidiaria','n#05994237',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('succursale','n#05994237',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('armatore','n#07570875',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giubbotto','n#N0000855',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cursorius_cursor','n#01551221',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corrione_biondo','n#01551221',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('necrofilo','n#N0001276 n#N0001277',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crack','n#02514673',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('go-kart','n#02759892',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('retro','n#03236095 n#04732559 n#03217207',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rovescio','n#03236095 n#00371238 n#03189940 n#07831151',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tergo','n#03236095',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('verso','n#03236095 n#04811183 n#05261047 n#05496532 n#03871821 n#04813927',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('logica','n#04379355 n#04681442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stoccafisso','n#05818175',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('boccia','n#02385479 n#09912761 n#02322450',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caraffa','n#02385479 n#03422714 n#02692878',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guastada','n#02385479',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('xeno','n#10507080',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prenome','n#04780273',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dolcificante','n#05887514',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('edulcorante','n#05887514',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compassione','n#05615937 n#05615476 n#03785836',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mercé','n#05615937',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('misericordia','n#05615937 n#03785586 n#05615645 n#03785836',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affastellamento','n#10402671',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coacervo','n#10402671',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('congerie','n#10402671',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('emporio','n#10402671 n#03589200 n#02510180 n#02555949',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fricandò','n#10402671',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guazzabuglio','n#10402671',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pipinara','n#10402671',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pottiniccio','n#10402671',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_britannica','n#09848966',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('finalismo','n#04584771',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teleologia','n#04584771',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teleologismo','n#04584771',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiduciario','n#07261351',NULL,'a#02639315',NULL);
INSERT INTO italian_index VALUES ('eliotropio','n#10599807 n#09246770',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('discontinuità','n#00660117 n#10344737',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interruzione','n#00660117 n#05486357 n#05523649 n#00687670 n#10969750 n#00246501',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ministro_delle_comunicazioni','n#W0005165',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gadolinite','n#10519233',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('siconio','n#09425473',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('onnivoro','n#01586897',NULL,'a#00309193',NULL);
INSERT INTO italian_index VALUES ('omnivoro','n#01586897',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('phytolacca_americana','n#08165601',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cremesina_uva-turca','n#08165601',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('uva_da_colorare','n#08165601',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autodidattismo','n#04441268',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('generalizzazione','n#04453175',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lemna_trisulca','n#08106322',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lenticchia-d''acqua_spatolata','n#08106322',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('campanella','n#03282172 n#08344324 n#02896062 n#02536489',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('romagnolo','n#N0001738',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('burrificio','n#02517783',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('casone','n#02517783',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teak','n#09214259 n#09214047',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teck','n#09214259',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tek','n#09214259',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('massacratore','n#07133057',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('istituzione_educativa','n#06144776',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ethos','n#03714179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('etos','n#03714179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diffusione','n#05463353 n#04729231 n#00546392 n#09754385 n#00236886 n#09736591',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sony','n#N0002561',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('plantago_major','n#08899506',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piantaggine_maggiore','n#08899506',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('workstation','n#03632472',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maraschino','n#05932861',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavallino','n#01877371',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('flocculazione','n#09736466',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('epiploo','n#04216385',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('epiploon','n#04216385',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('omento','n#04216385',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zirbo','n#04216385',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pastore_belga','n#01615254',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('casacca','n#02870166 n#02301305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giacca','n#02870166',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giacchetta','n#02870166 n#N0000835',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gobbo','n#07330311',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiducia','n#10390190 n#05595498 n#03833898 n#04563026',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indice_di_laspeyres','n#N0002661',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nesso','n#09993288 n#09931077 n#00018916',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rapporto','n#09993288 n#09953487 n#10345982 n#05391713 n#00018916 n#10053966 n#10037776 n#10036283',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oscilloscopio','n#03065395',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lattuga','n#08293804',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inflessione','n#05300778 n#05300588',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intonazione','n#05300778 n#05299832 n#03895810',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('psichiatra','n#07509639 n#07070278',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prato','n#06317924 n#N0002438 n#06335561',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('boccale','n#03469025 n#03022988 n#09915071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dentiera','n#02664476 n#03213860',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('precariato','n#N0001563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('olocausto','n#N0001318 n#00808775',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('espressività','n#03779255',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forza_espressiva','n#03779255',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('porcaccione','n#07585182',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asperità','n#03734362 n#03661737',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ineguaglianza','n#03734362 n#03733407 n#03733698',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inuguaglianza','n#03734362 n#03733407 n#03733698',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('senato','n#06069615',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('docenza','n#00570118',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('insegnamento','n#00570118 n#00403367 n#04692147',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('magistero','n#00570118 n#04363387',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('particolare','n#04482016 n#09946426 n#04481751',NULL,'a#01054694 a#00457241 a#00455774 a#00461922 a#01054295',NULL);
INSERT INTO italian_index VALUES ('acutezza','n#03898740 n#04352743 n#03701157 n#03702620 n#03702778 n#04353391 n#04353633 n#03932759',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('società_di_capitali','n#06202704',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('società_per_azioni','n#06202704 n#06083970',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aconito','n#08034157',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caricaturista','n#07140780',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macchiettista','n#07140780 n#07150048',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lago_di_garda','n#N0002302',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nebbione','n#N0001275',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calcestruzzi','n#N0002487',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chilometri_all''ora','n#10976846',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('km/h','n#10976846',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('km_/_h','n#10976846',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('morte_cerebrale','n#07821262',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('morte_clinica','n#07821262',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interesse_anticipato','n#N0002812',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esorbitanza','n#03989219',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('detonatore','n#02559765',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quarti_di_finale','n#05550763',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prataiolo','n#09296873',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mezzo_di_trasporto','n#02495376',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dialogo','n#04800016 n#05259291 n#05339187 n#05347846',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arrampicata','n#00209737',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ascesa','n#00209737 n#00209440 n#05487790 n#00156550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salita','n#00209737 n#00209440 n#00210435 n#06725562',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scalata','n#00209737',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('schizzinoso','n#N0001823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scuola_per_adulti','n#00568642',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('shimon_peres','n#W0020892',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cucitura','n#03293049 n#00459123',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dividendo','n#09657628',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assassinatore','n#07354173',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('micidiale','n#07354173',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('uccisore','n#07354173',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('secessione','n#00246948',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('figurino','n#02667524 n#N0000742',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dissimiglianza','n#03732325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dissomiglianza','n#03732325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('loculo','n#N0001066',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('istituto_di_carità','n#06216453',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imposta_di_successione','n#09584182',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imposta_sulle_successioni','n#09584182',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tassa_di_successione','n#09584182',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('renaissance','n#00678186',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('revival','n#00678186',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rifioritura','n#00678186',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rinascita','n#00678186 n#00678421',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riproposta','n#00678186',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pinguino','n#01567458',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiurlo','n#01545325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('controcultura','n#04437655',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impresa_mercantile','n#N0002705',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('concetto','n#04493671 n#05079660',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nozione','n#04493671 n#04494358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('concezione','n#04493671 n#04495746 n#04357520',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polifonia','n#05267951',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('penetrazione','n#00543689 n#00028196',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indigestione','n#10287668',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cattiva_digestione','n#10287668',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('boia','n#07250654 n#07309438 n#07666308',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carnefice','n#07250654 n#07309438 n#07644570 n#07644713',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giustiziere','n#07250654',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quercus_petraea','n#08580830',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rovere','n#08580830 n#08581931 n#08573299',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('husky','n#01619482',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciclicità','n#03743937',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vicentino','n#N0002243',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tombacco','n#10815102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lavoratore_autonomo','n#07278616',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cobra','n#01268360',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('naia','n#01268360 n#00750161',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reggiseno','n#02331715',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reggipetto','n#02331715',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('massima','n#05350719 n#04991006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('adagio','n#05350719 n#05351147 n#05284374',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('detto','n#05350719 n#05351147 n#05349662',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sentenza','n#05350719 n#04918568 n#00770012 n#00775506 n#00768711',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fontanella','n#04295178 n#02604445',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indovino','n#07506649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('necromante','n#07506649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('negromante','n#07506649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('profeta','n#07506649 n#07506902',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sortilego','n#07506649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vate','n#07506649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vaticinatore','n#07506649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vaticino','n#07506649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cinescopio','n#02405724 n#02889287',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tubo_a_raggi_catodici','n#02405724',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tubo_catodico','n#02405724',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trinomio','n#N0002169',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('odontoiatria','n#06148459 n#04626138',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intercambiabilità','n#03722034 n#03723137',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grillotalpa','n#01733282',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rufola','n#01733282',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alzagola','n#01364892',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alzavola','n#01364892',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arzagola','n#01364892',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arzavola','n#01364892',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('martellamento','n#00761424',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tambureggiamento','n#00761424 n#05515508',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acqua_di_calce','n#10717654',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('de_sica','n#W0020923',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vittorio_de_sica','n#W0020923',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lamiera','n#03508256 n#03313932',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('latta','n#03508256 n#02374411',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capocchia','n#02805509',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cappello','n#02805509 n#07852759 n#04821883 n#02802477',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('passapatate','n#N0001818',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('schiacciapatate','n#N0001818',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mezzena','n#05699589',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('truppa','n#06209853 n#06143628',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('peso_messicano','n#09854968',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mezzo_guanto','n#N0001179 n#02258309',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mezzoguanto','n#N0001179 n#02258309',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imposta','n#03391165 n#03332110 n#09580808 n#09586410 n#02872351',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idratazione','n#09673748 n#N0000912',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('economia','n#04674380 n#03832645 n#04365547 n#00126393 n#03832817 n#06193947',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('economia_politica','n#04674380',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('plastica','n#00444186 n#10454185 n#03139323',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lista_di_controllo','n#04871173',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crostone','n#10650046',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('turbolenza','n#10070345 n#03843213',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('olivo','n#08604301',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ulivo','n#08604301',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciclamino','n#08400581',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciclamo','n#08400581',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pan_porcino','n#08400581',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panporcino','n#08400581',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('poltronissima','n#N0001520',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bocca_di_leone','n#09175035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tonno_bianco','n#02116568',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alalunga','n#02116568',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alalonga','n#02116568',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('albacora','n#02116568',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('thunnus_alalunga','n#02116568',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('curaro','n#10843025',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oocita','n#04233991',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ovocita','n#04233991',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contropalo','n#03433179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('puntone','n#03433179 n#03206491',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guaritore','n#07639577',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('terapista','n#07639577',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mascotte','n#07397886',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portafortuna','n#07397886 n#02424438',NULL,'a#01407421',NULL);
INSERT INTO italian_index VALUES ('emergenza','n#05520260 n#10108387',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('endometrite','n#10296201',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('metrite','n#10296201',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('figlio_naturale','n#07104284',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('illegittimo','n#07104284',NULL,'a#01351390',NULL);
INSERT INTO italian_index VALUES ('ritaglio','n#00231214 n#04959960 n#02638930',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dissolutezza','n#03802185 n#03826302 n#00482125',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lascivia','n#03802185',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('licenziosità','n#03802185',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scostumatezza','n#03802185 n#00482125',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('franco-canadese','n#07010129',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catena','n#02416750 n#06688935 n#06246946 n#03307624 n#03938674 n#03589950 n#06006004 n#02417043 n#06247825 n#06726012',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('regulus_regulus','n#01086452',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('regolo','n#01086452 n#03261562 n#03423792',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anacoluto','n#05311417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incastellatura_a_cavalletto','n#02737861',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guarani','n#09842534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guarani_paraguaiano','n#09842534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quadrante','n#02563344',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carnaio','n#02424581 n#00145676',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ossario','n#02424581 n#N0001341',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tournée','n#N0002134',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calcagno','n#02508964 n#02813812 n#04322123',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tallone','n#02508964 n#04322123',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fattorizzazione','n#04458223',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('culo','n#04306560',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deretano','n#04306560',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('di_dietro','n#04306560 n#03217207 n#06358233',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('didietro','n#04306560 n#03217207 n#06358233',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('popò','n#04306560 n#N0001524',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('posteriore','n#04306560',NULL,'a#00199331 a#00134163',NULL);
INSERT INTO italian_index VALUES ('sedere','n#04306560','v#01352850 v#01837041 v#01061911',NULL,NULL);
INSERT INTO italian_index VALUES ('astrodinamica','n#04642725',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fila','n#06237025 n#06237536 n#06235683 n#03938674 n#06238477 n#06250735 n#06236741 n#06686669',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rango','n#06237025 n#10049681',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capoturno','n#N0000283',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('delirio','n#05407438 n#10326963 n#10323024',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('farneticamento','n#05407438',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('farneticazione','n#05407438',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frenesia','n#05407438 n#10326963',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frenetico','n#05407438',NULL,'a#00089141',NULL);
INSERT INTO italian_index VALUES ('vagellamento','n#05407438',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vaneggiamento','n#05407438',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vaniloquio','n#05407438',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lettura','n#04475899 n#04949385 n#00648353 n#05406019',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scritto','n#04798203 n#04797504',NULL,'a#02173029',NULL);
INSERT INTO italian_index VALUES ('raggio_laser','n#07820644',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('loto','n#08027045 n#08028634',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cancrena','n#03801774 n#00481262 n#10274392',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corruttela','n#03801774',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('depravamento','n#03801774',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('depravazione','n#03801774 n#00481099',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fradiciume','n#03801774',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gangrena','n#03801774 n#00481262',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pervertimento','n#03801774 n#09734957 n#00548323 n#00478287',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('putrido','n#03801774 n#10441111',NULL,'a#02597357',NULL);
INSERT INTO italian_index VALUES ('immigrante','n#07334599',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immigrato','n#07334599',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trapiantato','n#07334599',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piumino_della_cipria','n#03166914',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('costanza','n#03724071 n#04410669 n#03811751 n#03821553 n#03811466',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fermezza','n#03724071 n#03811751 n#03809479 n#03811466 n#03750498',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fissità','n#03724071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immutabilità','n#03724071 n#03723580 n#03725920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('invariabilità','n#03724071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stazionarietà','n#03724071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scia_di_condensazione','n#06751396',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cuculus_canorus','n#01340696',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cuculo','n#01340696 n#01340313',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maggiorazione','n#09904938 n#03984543',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('miglioramento','n#09904938 n#10347699 n#00159157 n#00167494 n#05480347',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incremento','n#09904938 n#09729055',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rumex_scutatus','n#08904912',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acetosa','n#08904912 n#08904295',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('romice_scudato','n#08904912',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ortodontista','n#07448850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ortognatodontista','n#07448850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intervideo','n#N0002250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('videocitofono','n#N0002250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('videofono','n#N0002250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('videotelefono','n#N0002250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gravità','n#03933119 n#03659222 n#03664048 n#07804383',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spezzino','n#N0001964',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compianto','n#05387878 n#04492345',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corrotto','n#05387878',NULL,'a#00585544',NULL);
INSERT INTO italian_index VALUES ('lamentanza','n#05387878',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lamentazione','n#05387878',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lamento','n#05387878 n#05286621 n#05386125 n#05332420 n#05385957 n#00558177',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('urlo','n#05387878 n#05328790 n#05498595 n#05330158 n#05503486 n#05329225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('america_centrale','n#06424551',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sumer','n#06518087',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('campagna_elettorale','n#00511429',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('relazione_sociale','n#00019464',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pelletteria','n#N0001415 n#N0001416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('febbre_gialla','n#10174184',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('celata','n#03271165',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polarizzazione','n#07824381 n#09677690',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('navigatore','n#07542916 n#07428502',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('controcurva','n#N0000461',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('era','n#06908363 n#10954662 n#10988653 n#10955141',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gesso','n#02401647 n#02419477 n#10759377 n#10520893',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ingessatura','n#02401647',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aconito_giallo','n#08050477',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lupaia','n#08050477',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('luparia','n#08050477',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('socialismo','n#04713812',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('blocco_di_carta_da_scrivere','n#10728051',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('blocco_di_carta_da_lettera','n#10728051',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('blocco_di_carta_da_lettere','n#10728051',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('architetto','n#07082393',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sala_d''esposizione','n#03331128',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('showroom','n#03331128',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buono_frazionario','n#09664691',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prosperità','n#10382728 n#10395016 n#03987430',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tifone','n#07844950',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autentica','n#00100102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autenticazione','n#00100102 n#00775106',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('certificazione','n#00100102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('expertise','n#00100102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('legalizzazione','n#00100102 n#00775106',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corno_da_nebbia','n#02707711',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stima','n#09653239 n#04704758 n#04428566 n#10358350 n#00561931 n#04471938 n#05609011',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tassa','n#09653239 n#09590231 n#09580808',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nasale','n#05327988 n#03045391',NULL,'a#02743127',NULL);
INSERT INTO italian_index VALUES ('hermissenda_crassicornis','n#01464548',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('infiltrato','n#07338522',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fatto','n#10055199 n#04955967 n#04978516 n#05432762 n#00022246 n#04481302 n#04384343 n#04804600 n#04527031',NULL,'a#01409211 a#00636055',NULL);
INSERT INTO italian_index VALUES ('braccialetto','n#03593168 n#02328059',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cinturino','n#03593168 n#03425180',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orologio','n#02452507',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gradimento','n#05568771 n#10341656 n#05573285',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pienezza','n#10368895 n#03898172',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('replezione','n#10368895',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mezzomarinaro','n#N0001180',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vendemmia','n#05917231',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coefficiente_di_resistenza','n#09762827',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bramosia','n#00489572 n#05565891',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bramosità','n#00489572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cupidità','n#00489572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('libidine','n#00489572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iris_pseudacorus','n#08716621',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giaggiolo_d''acqua','n#08716621',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('geum_urbanum','n#08932387',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cariofillata_comune','n#08932387',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oriente','n#06311351',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banca_nazionale_del_lavoro','n#N0002582',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bnl','n#N0002582',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('slot_di_espansione','n#03356080',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('olio_di_ricino','n#02402428',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('battito','n#05499044 n#05508389 n#05508979',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colpo','n#05499044 n#05443053 n#00369708 n#10135570 n#00760227 n#03327613 n#00077986 n#05515315 n#00084365 n#05468143 n#05492732',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('subcultura','n#06152890',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mal_di_testa','n#10281696',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('emicrania','n#10281696 n#10282500',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cefalea','n#10281696',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cefalgia','n#10281696',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cefalalgia','n#10281696',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amarraggio','n#00028352',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammarraggio','n#00028352',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attraccaggio','n#00028352',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attracco','n#00028352 n#06363213',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ormeggio','n#00028352 n#06363213',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('urtica_dioica','n#08695142',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ortica','n#08695142 n#08694681',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ortica_comune','n#08695142',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('urtica','n#08695142 n#08694681',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavalletta','n#01730494 n#01729962 n#07599534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('locusta','n#01730494',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affanno','n#00536667 n#05593817 n#04491326 n#05593480',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rantolio','n#00536667',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rantolo','n#00536667 n#05496106',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nigella','n#08047806',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catacresi','n#05313996',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carcassa','n#01278721 n#03860008 n#01278589 n#03634650 n#04327722 n#02840722 n#03343262',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carogna','n#01278721 n#07538532',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ministro_della_difesa','n#W0005175',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spopolamento','n#10413715',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sporofito','n#08000225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vincolo','n#N0002257 n#09931544 n#N0002256',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vt','n#N0002464',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('viterbo','n#N0002464',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monte_rosa','n#N0002332',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('precipitatore','n#03169493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('provvedimento','n#00113217',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calcio','n#02359063 n#00304700 n#00088506 n#10482003',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('estremità_più_grossa','n#02359063',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('balestra','n#02914814 n#02523919',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('molla_a_balestra','n#02914814',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cileno','n#07011261',NULL,'a#02733115',NULL);
INSERT INTO italian_index VALUES ('vulpes_fulva','n#01628605',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('volpe_nordamericana','n#01628605',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sinovia','n#04205071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('siluramento','n#00136632',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cartamodello','n#N0000304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('patron','n#N0000304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('novanta','n#09901759',NULL,'a#02102337',NULL);
INSERT INTO italian_index VALUES ('bunker','n#02354112 n#02353996',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('franamento','n#05482581 n#05557513 n#05512262',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rosa_salmone','n#03886194',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caffeina','n#10581908',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('natura','n#06860237 n#03647591 n#07764306 n#06691078 n#04504076 n#03716446 n#04496504',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('divieto','n#04911144 n#05414688',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('proibizione','n#04911144 n#05414897',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veto','n#04911144',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vietamento','n#04911144',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bollitore_per_il_tè','n#03476849',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asplenium_ruta-muraria','n#09467080',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asplenio_ruta_di_muro','n#09467080',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cambogia','n#06413219',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('netturbino','n#07285138',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spazzaturaio','n#07285138 n#07615158',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cartoccio','n#09996989',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spirale','n#09996989 n#02468610 n#09997171 n#03384760',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arma_da_fuoco','n#02778084',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pistola','n#02778084 n#03131514',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('juniperus_communis','n#07955330',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ginepro_comune','n#07955330',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scioglimento','n#09741527 n#07818171 n#00097160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rigatoni','n#05740848',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pane_integrale','n#05722942',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('birmano','n#05195396 n#07009413',NULL,'a#02803043',NULL);
INSERT INTO italian_index VALUES ('mustelide','n#01937225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agenzia','n#06005430 n#06182017',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('liana','n#09411121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ipnosi','n#10103772',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('allattamento','n#00685030',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incubatrice','n#02853717',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('patibolo','n#02735490 n#03279174',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apporto','n#09548864 n#00684444',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contributo','n#09548864 n#09546905 n#00504440 n#00714373 n#00706536',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sedano','n#05767595 n#09230808',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arca','n#02467080 n#02208360 n#02208476 n#03274680',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cassapanca','n#02467080',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cofano','n#02467080 n#02827297',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forziere','n#02467080 n#03430944 n#03535421',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scrigno','n#02467080 n#02399989',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giamaicano','n#07026800',NULL,'a#02822643',NULL);
INSERT INTO italian_index VALUES ('gorilla_gorilla_beringei','n#01975562',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gorilla_di_montagna','n#01975562',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('passività','n#03656754 n#03842128',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('solitario','n#07380301 n#00316920 n#03368709',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elettrico','n#07492827',NULL,'a#02622421 a#02622245',NULL);
INSERT INTO italian_index VALUES ('siena','n#N0002449',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colonnello','n#07166351',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calvario','n#06457345 n#05447192',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('golgota','n#06457345',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trasportatore','n#02495729 n#06005839 n#07141701',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dottrina_teologica','n#04692325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('doberman','n#01617406',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seguace','n#07270621 n#07217388',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fedele','n#07270621 n#06995978 n#07623193 n#07107595',NULL,'a#00913324 a#00911415',NULL);
INSERT INTO italian_index VALUES ('adepto','n#07270621 n#07217388',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accolito','n#07270621 n#07060072',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trionfo','n#05556959',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vittoria','n#05556959 n#05478453',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('membro_fondatore','n#07151030',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('penultimo','n#N0001429',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('numero_di_identificazione','n#04841846',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indossatore','n#07393866',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indossatrice','n#07393866',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mannequin','n#07393866',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('modella','n#07393866 n#07415419',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('top_model','n#07393866',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pizzardone','n#07117506',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stratosfera','n#06777344',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('primate','n#01964914',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acconto','n#09633002 n#09611330 n#05012609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anticipazione','n#09633002 n#05058536 n#09611633 n#04453620',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anticipo','n#09633002 n#03942952 n#05012609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cipiglio','n#N0001473 n#05147533 n#05147630',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piglio','n#N0001473',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aggiustamento','n#00171220 n#05487652',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aggiustatura','n#00171220',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rassettatura','n#00171220',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riattamento','n#00171220',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riparazione','n#00171220 n#00059926',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ripristino','n#00171220',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incisività','n#04047409',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nervosità','n#04047409 n#10313853',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('punta','n#03150523 n#06349777 n#05110203 n#06745644 n#02292521 n#06380238',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('curva','n#05093301 n#02281683 n#09992072 n#05253576 n#00224643 n#09990997 n#03959291',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('curva_altimetrica','n#05093301',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('isoipsa','n#05093301',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('viverra_zibetha','n#01644237',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gatto_civetta_asiatico','n#01644237',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piedipiatti','n#07129191',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('questurino','n#07129191',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbirro','n#07129191',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('poliziotto','n#07129191 n#07485319',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arlecchino','n#07309622',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zolletta','n#05649066',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zucchero_in_zollette','n#05649066',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('talk-show','n#04965455',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('talk_show','n#04965455',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riconsiderazione','n#05341529 n#04462695',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bel','n#09870645',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('wellington','n#06552424',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ulmus_glabra','n#08709476',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('olmo_montano','n#08709476',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ebridi','n#06505450',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maddalena','n#07739720',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lavavetri','n#07683139 n#07683346',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('espresso','n#05940833 n#02653278',NULL,'a#01057351',NULL);
INSERT INTO italian_index VALUES ('damiera','n#02427366',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('damiere','n#02427366',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scacchiera','n#02427366',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comfort','n#10365399',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comodo','n#10365399',NULL,'a#W0003167 a#00444669 a#01388554 a#00571902 a#W0003166',NULL);
INSERT INTO italian_index VALUES ('confort','n#10365399',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('casco','n#02516855 n#02814860 n#02612191',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('innatismo','n#04582044',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nativismo','n#04582044',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fortificazione','n#00617245 n#02715844',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mistero','n#05264886 n#04394091',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('p.i.l.','n#09539946',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pil','n#09539946',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prodotto_interno_lordo','n#09539946',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vetrina','n#02363665 n#10411897 n#02581231',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('metanolo','n#10528650',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clessidra','n#03595228 n#02837114',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autocrazia','n#04709967 n#06190677',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veccia','n#08875693',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('obsolescenza','n#03854381',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('jugoslavia','n#06468727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coppiola','n#N0000604',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('doppietta','n#N0000604 n#N0000605 n#N0000603 n#N0000607',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('suzuki','n#N0002564',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('retribuzione','n#09560299 n#09555462 n#00726835 n#09556237',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricompensa','n#09560299 n#05441142 n#09550517 n#00166954 n#09558752 n#09560487',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carrello_d''atterraggio','n#02904305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('onore','n#05020724 n#03814900 n#04018531 n#05020360 n#10357889',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('omaggio','n#05020724 n#09548218 n#05036131 n#00797621',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rima','n#04811183 n#05309419',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('internazionalista','n#07342545 n#07342413',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dente_da_latte','n#04118715',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dente_di_latte','n#04118715',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('valerianella_locusta','n#09247252',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gallinella_comune','n#09247252',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comprensione','n#05585222 n#04473075 n#04699267',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('torba','n#10529587',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('manica','n#03350385',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aster','n#08239613',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('astro','n#08239613 n#06757881 n#06762045',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aculeo','n#09383353 n#01416532 n#09383246',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spina','n#09383353 n#01962663 n#02353621',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bagno_turco','n#00166105',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fenditura','n#06699639 n#10021740 n#06699238 n#03354789',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('beveraggio','n#05910050',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filtro','n#05910050 n#02679962 n#02680280 n#05910402',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pozione','n#05910050',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affari','n#00710194',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('membrana','n#02984016 n#04214205',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crauti','n#05903587',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sgravio_fiscale','n#W0005507',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zenzero','n#05847903 n#08658993',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tenente_di_vascello','n#07372823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('meccanica','n#04644931',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paternalismo','n#04697717',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giogo','n#06710597 n#06349777',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('babbo','n#07199293',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pa''','n#07199293',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paparino','n#07199293',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('papi','n#07199293',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('papà','n#07199293',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lordura','n#06213342',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avallo','n#09614018 n#04827703',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malleveria','n#09614018 n#N0001110 n#N0001111',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gente','n#05976176 n#05976077 n#05957883 n#05961082',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oscar','n#05425347',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ulcera_gastrica','n#10213628',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('partito_politico','n#06131180',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('media','n#06218889 n#04610564 n#04609375',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scuola_media','n#06218889',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('afflizione','n#05572211 n#04491326 n#10385041 n#05572909',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dolore','n#05572211 n#04422285 n#05601776 n#05601413 n#10279078 n#05571456 n#05572909 n#04492345',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('patimento','n#05572211',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pena','n#05572211 n#05615645 n#03785836 n#00751324',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maglia_rosa','n#W0021000',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raddirizzatore','n#03221674',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raddrizzatore','n#03221674',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lezione','n#W0021167 n#00573978 n#05036035 n#00571937 n#00469204 n#05003239 n#W0021165 n#W0021166',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monte_viso','n#N0002337',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monviso','n#N0002337',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interdipendendenza','n#09972320',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interdipendenza','n#09972320',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accendigas','n#N0000014',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('facocero','n#01894342',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('facochero','n#01894342',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prova_indiziaria','n#05049209',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aborto','n#07277959 n#05456093 n#00149581 n#00986324',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fenomeno_da_baraccone','n#07277959',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('convalle','n#06732423',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('toro','n#01900416 n#07129077',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scalpello_a_rulli','n#03245796',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('posto_in_piedi','n#03402000',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lorichetto','n#01337845',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tricoglosso','n#01337845',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('hockey','n#00299061 n#00296274',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erpetologia','n#04635307',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lupacchiotto','n#00866339',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lupetto','n#00866339 n#07195773',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scena','n#04961237 n#03397314 n#05258594 n#10042358 n#06367294 n#05482294 n#04555855',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maratona','n#05546075 n#00509451',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eccitamento','n#06664898 n#10111476 n#00547740 n#00819194',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('libia','n#06543687',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spazio_libero','n#03971230',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scontro','n#10072413 n#05443765 n#00610417 n#05369518 n#00081036',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guerra','n#10072413 n#00626011 n#00512068 n#00802991',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pulicaria_dysenterica','n#08313119',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incensaria_comune','n#08313119',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bottiglia','n#09912761 n#02318679',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radiotrasmissione','n#04967491',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avanzo','n#09947509 n#03989688 n#09947291 n#06670589',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rimasuglio','n#09947509',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scampolo','n#09947509 n#02638930',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('danno_biologico','n#W0020851',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('franco_del_ruanda','n#09841504',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cilindro','n#02601009 n#03247872 n#10029497 n#02368979',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tuba','n#02601009 n#04074055 n#02261639',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carragenina','n#10617519',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stato','n#06079469 n#06299747 n#06074189 n#10048803 n#00016185 n#10032130 n#10386919 n#05978135',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('protesi','n#03180401',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rampollo','n#07441400 n#07552177 n#09449526 n#07212065',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('persia','n#06515545 n#06514401 n#09151856',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carie','n#09734785 n#09734649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esopo','n#07694177',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('neuropatico','n#N0001286',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nevropatico','n#N0001286',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('edipo','n#06934910',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acqua_tinta','n#02204406 n#00600491',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acquatinta','n#02204406 n#00600491',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tenue','n#04287089',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('formazione','n#02715450 n#03851783 n#06232231 n#00154800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coupé','n#02510373',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fantasista','n#N0000709',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prunus_cerasifera','n#08943097',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciliegio-susino','n#08943097',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mirabolano','n#08943097',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mirobolano','n#08943097',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('susino_asiatico','n#08943097',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mongolo','n#06966427 n#05191872',NULL,'a#02831203',NULL);
INSERT INTO italian_index VALUES ('falena','n#07615942',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('passeggiatrice','n#07615942',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('peripatetica','n#07615942',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cifosi','n#10405722',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gobba','n#10405722 n#10012108',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('notte','n#10885886 n#10886315 n#10073471 n#10886418',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buio','n#10885886 n#10073287 n#04591692',NULL,'a#00268709',NULL);
INSERT INTO italian_index VALUES ('mansuetudine','n#03829940 n#03841165',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciucca','n#10097920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ebbrezza','n#10097920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ebrezza','n#10097920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inebriamento','n#10097920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbornia','n#10097920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ubbriacatura','n#10097920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ubbriachezza','n#10097920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ubriacatura','n#10097920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ubriachezza','n#10097920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abside','n#02203661 n#02421012',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unno','n#07330469 n#07661237',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('flashback','n#04825277',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amorevolezza','n#03650658 n#00020804',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barrage','n#N0000148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pestarola','n#N0000148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbozzo','n#05094004 n#04818688 n#04528166 n#03343837',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accenno','n#05094004 n#05090749 n#05069640 n#05069358 n#05357131 n#04984365 n#05434729',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indicazione','n#05094004 n#05090749 n#05082722 n#05399540',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esperidi','n#06898281',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ostetrico','n#07438516',NULL,'a#02694027',NULL);
INSERT INTO italian_index VALUES ('rassembranza','n#03728317',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rassomiglianza','n#03728317 n#03730047',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aromaterapia','n#N0000080',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('varsavia','n#06557556',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leucocita','n#04227852',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leucocito','n#04227852',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esposizione','n#W0003153 n#05153478 n#W0003150 n#W0003149 n#09805381 n#W0003151 n#00582077 n#05391410 n#05271737 n#04556661 n#06217283',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buono','n#03800378 n#06948621 n#09665083 n#04892722 n#04005893',NULL,'a#00597129 a#01082452 a#01318368 a#01076114 a#00108860 a#01728957 a#00595353 a#01912069',NULL);
INSERT INTO italian_index VALUES ('scavolini','n#N0002553',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trascendenza','n#10060977 n#10051975',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colabrodo','n#02469202 n#03424410',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colapasta','n#02469202',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scolabrodo','n#02469202',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scolapasta','n#02469202',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giorno_di_mercato','n#10892125',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('passiflora','n#08686692',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tratto','n#03642179 n#10843624 n#04341535 n#05091922',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piridossina','n#10826634',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piridoxina','n#10826634',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fitoplancton','n#00911639',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trapianto','n#00213282',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('metà','n#W0021173 n#04515274 n#09891093',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tritaghiaccio','n#N0002174',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vertice','n#W0003136 n#10045044 n#04514573 n#06387973 n#06197821 n#W0003140',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pesci','n#06395563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frullio','n#05534412 n#N0000786',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sventolata','n#05534412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lamium_amplexicaule','n#09147757',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erba_ruota','n#09147757',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falsa-ortica_reniforme','n#09147757',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('recinto','n#03077744 n#02638575 n#03102571 n#02700478 n#02670460 n#06666964',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fulmicotone','n#10612315',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cimiere','n#02815104 n#02814860 n#02519518',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cimiero','n#02815104 n#02814860 n#02519518',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elmetto','n#02815104 n#02814860',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elmo','n#02815104 n#02814860',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nazione','n#06073126 n#06299747 n#06074189',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paese','n#06073126 n#06299747 n#06074189 n#06107243 n#06382213',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fotomontaggio','n#03114918',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strumento_a_fiato_munito_di_ancia','n#02272434',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stechiometria','n#N0001994',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('medievalistica','n#N0001156',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('medievistica','n#N0001156',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('medioevalistica','n#N0001156',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('medioevistica','n#N0001156',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('occhio_di_vetro','n#02756458',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('penna','n#03102377 n#03116958 n#01411980',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intoppo','n#10339059 n#00411168 n#04396796 n#03435130 n#02819465 n#03051518 n#04396152 n#03051325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raddoppio','n#00513496',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alunno_esterno','n#07202960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('haler','n#09844294',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('haler_ceco','n#09844294',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('essere_soprannaturale','n#06860613',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radioastronomia','n#04643033',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('noria','n#03044367',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anguinaia','n#04338020',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inguine','n#04338020',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiave_di_tenore','n#05135776',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('associazione','n#10347254 n#05971916 n#00700147 n#06114444 n#05999585 n#06164721',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('concorso_nel_reato','n#W0021016',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crespella','n#05686002 n#05686901',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crêpe','n#05686002',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spiritualizzazione','n#00383185',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dichiarante','n#07111645',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('venezia','n#06467659',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ve','n#06467659',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bifolco','n#07691800 n#07464747',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mal_educato','n#07691800 n#07464747',NULL,'a#00606314',NULL);
INSERT INTO italian_index VALUES ('maleducato','n#07691800 n#07464747',NULL,'a#00606314',NULL);
INSERT INTO italian_index VALUES ('tanghero','n#07691800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('villano','n#07691800 n#07464747',NULL,'a#00606314',NULL);
INSERT INTO italian_index VALUES ('irradiamento','n#07828438 n#00814655',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('irradiazione','n#07828438',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('irraggiamento','n#07828438 n#00814655',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radiazione','n#07828438 n#00814655 n#00135765',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ceffata','n#00086637',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ceffone','n#00086637 n#05515595',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sganascione','n#00086637',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sganassone','n#00086637',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sventola','n#00086637 n#05515595',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_colombiana','n#09853797',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tricorno','n#03539206',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sediolo','n#03440780',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sulky','n#03440780',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('blocchista','n#07348907',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grossista','n#07348907',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intermediario','n#07348907 n#06951922 n#07066862',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('jobber','n#07348907',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('categorizzazione','n#00653558',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('classificazione','n#00653558 n#04425786 n#05955891 n#00651881',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calendula_officinalis','n#08251330',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiorrancio_coltivato','n#08251330',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camera','n#02836447 n#W0021126 n#02275625 n#04191627 n#06070449 n#02420001 n#03250788 n#W0021127 n#05997016',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('laccatura','n#02899236',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('detronizzazione','n#00136760',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spodestamento','n#00136760',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('megaciclo','n#10977014',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mc','n#10977014 n#N0002419',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eufrate','n#06820472',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oculistica','n#04629494',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oftalmoiatria','n#04629494',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oftalmologia','n#04629494',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('go','n#N0002408',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gorizia','n#N0002408',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rai','n#N0002546',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eccedenza_di_popolazione','n#06079857',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sesto_senso','n#04410094',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dolomia','n#10644434',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('campeggio_estivo','n#02373172',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colonia_estiva','n#02373172',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pap-test','n#04087300 n#04431917',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('metraggio','n#02709907',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('endotelio','n#04069960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('territorio','n#06294174 n#06334762 n#06304618',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('personal_computer','n#03109520',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clavicordio','n#02447552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clavicordo','n#02447552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pepe_bianco','n#05848865',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agitazione','n#10069389 n#05585608 n#00361901 n#10070620 n#00362507 n#10334876',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fermento','n#10069389 n#10070620 n#07798186',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sommovimento','n#10069389',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tumulto','n#10069389 n#05586494 n#00361901 n#10070121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('turbamento','n#10069389 n#05593480 n#10334876',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dasyprocta_aguti','n#01867095',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aguti','n#01867095',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cellulare','n#03153625 n#02411769',NULL,'a#02538318',NULL);
INSERT INTO italian_index VALUES ('tendenza','n#04436374 n#04697988 n#06390652 n#04698745 n#03867407 n#05574602',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('voga','n#04436374 n#00282390',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('liofilizzato','n#N0001061',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tenore','n#04054531 n#07637062 n#05143179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rotella','n#02401807 n#03258404',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diritto_marittimo','n#06245274',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('culinaria','n#05617228 n#05626343',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gastronomia','n#05617228 n#05626343 n#05626604',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('debolezza','n#03826148 n#10383358 n#03803801 n#04050713 n#10376771',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riassetto','n#00737598 n#00217325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricostituzione','n#00737598',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rifondazione','n#00737598',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riordinamento','n#00737598 n#00217325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riordino','n#00737598',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riorganizzazione','n#00737598',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risistemazione','n#00737598',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ristrutturazione','n#00737598',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vallisneria_spiralis','n#08915288',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vallisneria','n#08915288',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elettrolisi','n#09733570',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('toast','n#N0002116 n#05728383',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavalletto','n#03200533 n#03537430 n#03541314 n#02620657 n#03278250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('supplizio_della_ruota','n#03200533',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alligatore','n#01219193 n#10581251',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asset_management','n#W0020911',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vertice_internazionale','n#W0003176',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caimano','n#01219767',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crac','n#05559582 n#05495688',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alosa_pseudoharengus','n#02023855',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alaccia','n#02023855 n#02023740',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falsa-aringa_atlantica','n#02023855',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marrubium_vulgare','n#09152565',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marrubio_comune','n#09152565',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mentastro','n#09152565',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('robbio','n#09152565',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soffocazione','n#00697514 n#00146677',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('balza','n#02724512 n#06700541',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falbalà','n#02724512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falpalà','n#02724512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frangiatura','n#02724512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frappa','n#02724512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('volant','n#02724512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lista_nera','n#04869955',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('insoddisfazione','n#05604874',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scontento','n#05604874',NULL,'a#01733963',NULL);
INSERT INTO italian_index VALUES ('popolazione','n#06080139 n#06069040 n#05957883 n#06079663',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cautela','n#03830857 n#03676417 n#03832040 n#04349454 n#03676318 n#03676134',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('circospezione','n#03830857 n#03832040 n#04349454 n#03676134',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('precauzione','n#03830857 n#04349454 n#03676318 n#03676134',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prudenza','n#03830857 n#03832040 n#04349454 n#03676134',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baldoria','n#06126979 n#00328944',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bisboccia','n#06126979 n#00328944 n#00329304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('offerta_pubblica_d''acquisto','n#W0021037',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('opa','n#W0021037 n#00507046',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attrezzatura','n#02859872 n#03240788 n#03240500',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strumentazione','n#02859872 n#05278094',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('franco_francese','n#09840721',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fecondità','n#04010532 n#04356143 n#10120373',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('produttività','n#04010532 n#09956992',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('campanaro','n#07643709',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('devozione','n#05608345 n#03783864 n#00675531 n#00674543 n#00675116 n#00781577',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('divozione','n#05608345 n#03783864 n#00675531 n#00674543 n#00675116 n#00781577',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('castoro','n#01864116 n#01864444 n#01864338 n#10585104',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbaciucchiamento','n#00547908',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vezzeggiamento','n#00547908',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camion_bomba','n#W0020779',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('finanziaria','n#06227566 n#06015810 n#06084119',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('società_di_finanziamento','n#06227566',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('società_finanziaria','n#06227566',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('benzene','n#10594059',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('benzolo','n#10594059',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('svincolo','n#N0002047 n#N0002046',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('funzionalismo','n#04666841 n#04574775',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('recusa','n#05385339 n#05382699',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('repulsa','n#05385339',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricusa','n#05385339 n#05382699',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ripulsa','n#05385339',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('secco_rifiuto','n#05385339',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camaleonte','n#01214598',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cassintegrato','n#N0000313',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavallo_a_dondolo','n#02822296',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aggetto','n#03070098',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('flemma','n#05587152 n#03839746',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('freddezza','n#05587152 n#03839987 n#03809871 n#03652203',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impassibilità','n#05587152',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imperturbabilità','n#05587152',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seraficità','n#05587152',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canis_aureus','n#01624311',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sciacallo','n#01624311 n#07300329',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incoercibilità','n#03863459',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incompressibilità','n#03863459',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incomprimibilità','n#03863459',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lisca','n#01962663',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('resta','n#01962663 n#09384108',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cemento','n#10620206 n#10620360 n#10619948 n#10541211 n#04120387',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('astrolatria','n#00676782',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('configurazione','n#04424071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comproprietà','n#09526012',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comunanza','n#09526012',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comunità','n#09526012 n#06105250 n#06104982',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mimica','n#00359000 n#05146366',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mimo','n#00359000 n#07411441 n#01109388',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mimodramma','n#00359000',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pantomima','n#00359000',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comunicativa','n#03666181',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autofluorescenza','n#07777538',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fraga','n#08930013',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fragola','n#08930013',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capitolazione','n#00039842',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('resa','n#00039842 n#09954508 n#00054744 n#00587304 n#00727086',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riso','n#08432637 n#05837941 n#08432831 n#05332704 n#00693866',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('times','n#W0020889',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scuola_di_ballo','n#W0021058',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incidente_mortale','n#05482982 n#05464365',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('demolizione','n#00811339 n#05465405',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ossiacido','n#N0001342',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('set','n#05990251 n#10959680 n#04699755',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('completo','n#05990251 n#03438739 n#02641291',NULL,'a#00487168 a#00489625 a#00523510 a#00481645',NULL);
INSERT INTO italian_index VALUES ('soffiato','n#05875026',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soufflé','n#05875026',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moscardino','n#01854456 n#07200787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('postumi_della_sbornia','n#10365963',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fatto_compiuto','n#00025520',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('re','n#07595596 n#N0002442 n#02889527 n#07354565 n#07355667 n#07102147 n#05139400',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('regnante','n#07595596',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sovrano','n#07595596',NULL,'a#01009075',NULL);
INSERT INTO italian_index VALUES ('monarca','n#07595596 n#07540384',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('commissione','n#09590667 n#04902219 n#00471384 n#06172564 n#06171035 n#W0003130',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('provvigione','n#09590667',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cosa_analoga','n#03729592',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coque','n#06672020',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('uscere','n#07658794',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('usciere','n#07658794',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('porta_tagliafuoco','n#02684758',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fattispecie','n#N0000716 n#04484449',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anemografia','n#00644985',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panicum_capillare','n#08433984',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panico_capillare','n#08433984',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('casistica','n#04679451',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('casuistica','n#04679451',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rosta','n#02665693',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mugil_curema','n#02091663',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cefalo','n#02091663 n#02091509 n#02091100',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('muggine','n#02091663 n#02091509 n#02091100',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imbizzarrimento','n#05585608',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buffer','n#02345884',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('memoria_tampone','n#02345884',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vampiro','n#01658980 n#06895137 n#01651513',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('collo_torto','n#01358513',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('collotorto','n#01358513',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ordinarietà','n#03761864',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dozzinalità','n#03778464',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foraterra','n#02566421',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piantatoio','n#02566421',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('essudato','n#10653829',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bario','n#10480010',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capitale','n#06283013 n#06280000 n#09614621',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piede','n#01824376 n#W0021125 n#04309988 n#02255918 n#06278461 n#09814306 n#05307729',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('controfirma','n#04827561',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('adeguatezza','n#03709813 n#03792988',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('convenevolezza','n#03709813',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('convenienza','n#03709813 n#03836321 n#04017901',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idoneità','n#03709813 n#04014903 n#03710827',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('turno_di_notte','n#10985397 n#06100749',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sovraoccupazione','n#N0001947',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('boa','n#05422811 n#01262664 n#02669202 n#01262435',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gavitello','n#05422811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grippiale','n#05422811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pubblicazione','n#04944010 n#00715056',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disgrazia','n#05522274 n#10384027 n#05443572 n#05452288 n#10342602',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radioregistratore','n#N0001661',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gruppo_musicale','n#06121530',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('divezzamento','n#00129915',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('slattamento','n#00129915',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('svezzamento','n#00129915',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sassaiola','n#N0001786',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contentezza','n#05595732 n#10076479 n#05598833',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contento','n#05595732',NULL,'a#01733361 a#01308059',NULL);
INSERT INTO italian_index VALUES ('gioiosità','n#05595732',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lietezza','n#05595732',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cardite','n#10289857',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bautta','n#02588484 n#02588630',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mascherina','n#02588484 n#03511522',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('uretere','n#04270330',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pediculus_corporis','n#01689451',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pidocchio_del_corpo','n#01689451',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('curatela','n#00393654 n#00531481',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('neanderthal_man','n#01969338',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('uomo_di_neandertal','n#01969338',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('uomo_di_neanderthal','n#01969338',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('promesso','n#07110409',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sposo_promesso','n#07110409',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('liberalismo','n#04712107 n#04703384',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('donatore','n#07222682 n#07222879',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('donante','n#07222682',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('datore','n#07222682 n#07241412 n#07291831',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('geco','n#01195934',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tarantolino','n#01195934',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mangosta','n#01646172',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mangusta','n#01646172',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mantecato','n#N0001125',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lappone','n#05218606 n#05218778',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pettino','n#02567041 n#02285383',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ottocentista','n#N0001347',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calzamaglia','n#03504232 n#03085811 n#02834012',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('collant','n#03504232 n#03085811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bicchierino','n#02931434 n#09919260',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('achillea_millefolium','n#08224340',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('achillea','n#08224340',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('millefoglie','n#08224340',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('millefoglio','n#08224340',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('millefoglio_montano','n#08224340',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('meridionale','n#N0001165 n#N0001164',NULL,'a#01548614',NULL);
INSERT INTO italian_index VALUES ('caffè','n#05948884 n#02366126 n#05948716 n#08962544',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bardotto','n#01887824 n#07080687',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oggettivazione','n#00597227',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lobo','n#04258369',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autocarro','n#03545314',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camion','n#03545314',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filza','n#03263182 n#03429183 n#06247582',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('araneus_cavaticus','n#01292594',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polo_magnetico','n#03152625',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('festa','n#10900974 n#10957449 n#00333978 n#06126536 n#10881507 n#10900799 n#10933200 n#05538738',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vinificazione','n#00729415',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amabilità','n#05614062 n#03846037 n#03793754 n#03669235',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('artemisia_vulgaris','n#08239235',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assenzio_selvatico','n#08239235',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('uccello','n#01026695',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pennuto','n#01026695',NULL,'a#00945545',NULL);
INSERT INTO italian_index VALUES ('volatile','n#01026695',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('volativo','n#01026695',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('volatio','n#01026695',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alesaggio','n#03981138',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calibro','n#03981138 n#07112229 n#03717355 n#02369229',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ulcera_peptica','n#10213499',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('popillia_japonica','n#01678807',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scarabeo_giapponese','n#01678807',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teatro_di_varietà','n#05266449 n#03025798',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affossatura','n#02582973',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cunetta','n#02582973 n#10020180',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fossato','n#02582973 n#03006885',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fosso','n#02582973 n#03006885',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbindolamento','n#00483794',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbindolatura','n#00483794',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bindolo','n#00483794',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inghippo','n#00483794 n#00111383 n#00498592',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raggiro','n#00483794 n#00492002 n#00498592',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('insicurezza','n#05594325 n#10428185',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('farina_di_soia','n#05625138',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catecumeno','n#07617752',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('neofita','n#07617752 n#07435971 n#07431092 n#07182050',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ercolano','n#W0020987',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perl','n#N0002284',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riciclaggio','n#00607051',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lanterna_magica','n#02953993',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aggressività','n#05611552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tunnel','n#03550931',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('galleria','n#03550931 n#02240068 n#02442753 n#02205318 n#02734676 n#02734545 n#02734380',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cunicolo','n#03550931 n#03308408 n#06729187',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sydney','n#06479646',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('neutralità','n#00806104 n#04702275',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apium_graveolens','n#09230679',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sedano_comune','n#09230679',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sgarbatezza','n#03847224 n#03847572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sgarberia','n#03847224 n#03847572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('villania','n#03847224 n#03847741',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maleducazione','n#03847224 n#03847741 n#03847572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eclisse','n#05486800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eclissi','n#05486800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('occultazione','n#05486800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rupia','n#09862181 n#09861839 n#09862954 n#09862435 n#09861369 n#09862692',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rupia_delle_mauritius','n#09862181',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compagnia_di_bandiera','n#W0020973',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reticolo','n#04424486 n#01896830',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cibernetica','n#04669412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macroclima','n#N0001095',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mensa_dei_poveri','n#06004477',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bicchiere','n#02755829 n#09914390',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calcinaccio','n#N0000236',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pechino','n#06418755',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leu','n#09847947',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leu_rumeno','n#09847947',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paradenti','n#03021332',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biscia_d''erba','n#01255729 n#01250547 n#01258383',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piccola_tenuta','n#09532982',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scaldamuscoli','n#N0001800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('narcisismo','n#03790179 n#05599367',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('episcopato','n#N0000648 n#N0000649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calunnia','n#05038666 n#05039384 n#00792102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('denigrazione','n#05038666 n#05037886 n#00792102 n#00791766',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diffamazione','n#05038666 n#05039210 n#00792102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('manganato','n#10725283',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antheraea_polyphemus','n#01806996',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autoinnesto','n#00434204',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autoplastia','n#00434204',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autoplastica','n#00434204',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palermo','n#06466472',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pa','n#06466472',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eleggibilità','n#10342274 n#03711286',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brutta','n#N0000208',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('minuta','n#N0000208',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arum_maculatum','n#08091130',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gigaro_scuro','n#08091130',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reticolo_di_diffrazione','n#02568933',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rappresaglia','n#00802092 n#00802699',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ritorsione','n#00802092',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rivalsa','n#00802092',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vendetta','n#00802092 n#00802243',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deflusso','n#00212248 n#10975138 n#05509328',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiumana','n#00212248 n#10089455',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiume','n#00212248 n#10089455 n#06789983',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cenno_del_capo','n#05428928',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colono','n#07636460 n#07567611',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contadino','n#07636460 n#07464618 n#07464747 n#07188669 n#07256794',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fittavolo','n#07636460 n#07636191 n#07635964',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('telefonata_urbana','n#04743104',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavallo_di_posta','n#01885590',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canale_di_panama','n#03082299',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dimostrazione','n#00763104 n#05148820 n#00336363 n#04985093 n#04985559 n#05148592 n#00336149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corriere','n#07406477 n#06005839',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('messaggero','n#07406477 n#05093861',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('messaggiero','n#07406477 n#05093861',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('messo','n#07406477',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('procaccia','n#07406477',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('procaccino','n#07406477',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('staffetta','n#07406477 n#05549172 n#07218282',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('base_aerea','n#02169993',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiumara','n#N0000754',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('segnalazione','n#05085885',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('segnale','n#05085885',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('berretta','n#02380304 n#09048270 n#02292166',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('berretto','n#02380304 n#02282730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cuffia','n#02380304 n#02809404 n#09416512 n#02313027 n#02263235 n#02380969',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cuffietta','n#02380304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sorellastra','n#07580022',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capofabbrica','n#07622519',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ispettore','n#07622519 n#07340647',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('supervisore','n#07622519',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('passerella','n#02304119 n#02737262 n#02711019',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('passeggiata_a_mare','n#02304119',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('approccio','n#00601680 n#05357456',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cospicuità','n#10355685',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raphanus_raphanistrum','n#08202375',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ravanello_selvatico','n#08202375',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anno_civile','n#10916521',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anno','n#10916521 n#10866312 n#10958298 n#10917509 n#06115327 n#10988653 n#10951137 n#10915598 n#10917791',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('america','n#06835671 n#06593275',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('proforma','n#N0001587',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apparizione','n#04532842 n#05458256 n#06896801 n#00027339 n#05457551',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portiera','n#02387891',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sportello','n#02387891 n#03616007',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('secondo_tempo','n#10961055',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fasciola_hepatica','n#01440235',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('distoma_epatico','n#01440235',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tacchetto','n#N0002066',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('familiarità','n#03762888 n#03669571 n#04481141',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pallone','n#W0021211 n#02243465 n#00304700 n#W0021210 n#W0021209 n#W0021213 n#02240791 n#W0021212',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gorgo','n#05529630',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('molinello','n#05529630 n#07848713 n#05529476 n#03618594',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mulinello','n#05529630 n#07848713 n#05529476 n#03618594',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corsia_di_accelerazione','n#02160238',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raccordo_di_entrata','n#02160238',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rampa_di_accesso','n#02160238',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zig_zag','n#10005528',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pannellatura','n#03083648',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('morfofonema','n#05321661',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('morfonema','n#05321661',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('laringoscopio','n#02907747',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('redini','n#04046959',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('australasia','n#06481768',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stalinismo','n#N0001984',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aridità','n#10425712 n#10425272',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capros_aper','n#00979946',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pesce_tamburo','n#00979946',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('illuminazione','n#10442442 n#04467595',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spia_luminosa','n#05144950',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scippo','n#N0001832',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('materasso_a_molle','n#03391300',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('jingle','n#N0000894',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('atropa_belladonna','n#09195848',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('belladonna','n#09195848 n#09192140 n#02278056',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('welfare','n#00704029',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gerarca','n#N0000828',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sonniloquio','n#00184645',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aerobrigata','n#06101255',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nostalgia','n#05566646 n#05566463',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cosciotto','n#05699486',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sterzata','n#N0002002 n#00820041',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lira_sterlina','n#09849100',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sterlina_inglese','n#09849100',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lavoro_all''uncinetto','n#02521012',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maglia','n#02521012 n#03037597 n#02417403 n#03539306 n#02894468 n#02895297 n#03340699 n#09818221',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('educatore','n#07235322 n#07235207',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('formatore','n#07235322',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pedagogo','n#07235322 n#07162304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('insegnante','n#07235322 n#07632177 n#07551404 n#07550942',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scarto_medio','n#04609994',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reggio_emilia','n#N0002442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('australopithecus_afarensis','n#01970710',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indumenti','n#03512532',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ritrosia','n#03662995 n#05592914',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caprifoglio','n#08520688 n#08973855',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vincibosco','n#08520688',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('proiettore','n#03177396 n#03177201 n#02807978 n#02699703 n#03293342',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('revolverata','n#N0001733 n#N0001702',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rivoltellata','n#N0001733 n#N0001732',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apparecchio','n#02560468 n#02327307 n#02859502 n#02202438 n#02174460',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dispositivo','n#02560468 n#02979815',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('congegno','n#02560468 n#00062253 n#02979815 n#02859502 n#02202438',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arnese','n#02560468 n#02851548 n#02202438',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ingrandimento','n#02641071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coltellata','n#00761046',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pugnalata','n#00761046 n#05443053 n#N0001599',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moda_pronta','n#N0001574',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pret-à-porter','n#N0001574',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sistema_monetario','n#09630661',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veronica_beccabunga','n#09188629',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erba_grassa','n#09188629',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('triodo','n#03540842',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grisou','n#10559535',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dente_del_giudizio','n#04119632',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('toccata','n#05282083',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('definitività','n#03723580',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impermutabilità','n#03723580',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inalterabilità','n#03723580 n#03725920 n#03726109 n#N0000944',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inderogabilità','n#03723580',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cultura_generale','n#04346592',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abulia','n#10103598 n#03656931 n#03656520',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('specie','n#04500860 n#06045216 n#07594053 n#04496504',NULL,NULL,'r#00081536 r#00499119 r#00244868');
INSERT INTO italian_index VALUES ('aphis_pomi','n#01756117',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('afide_verde_del_melo','n#01756117',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mediobanca','n#N0002589',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('informazione','n#04977171 n#04480483',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apice','n#06349777 n#10045044 n#06387973 n#10983867 n#10019938 n#06266980',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cima','n#06349777 n#06380382 n#10045044 n#06381104 n#06380834 n#03252883 n#07288630 n#02804508 n#07059467',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colmo','n#06349777 n#03238619 n#10045044',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('culmine','n#06349777 n#10045044 n#06387973 n#10019938',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('picco','n#06349777',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pizzo','n#06349777 n#04086060',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sommità','n#06349777 n#10045044 n#10019938',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vetta','n#06349777 n#06301604',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('petromyzon_marinus','n#01001689',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lampreda_di_mare','n#01001689',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('isopo','n#05849451 n#09146840',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('issopo','n#05849451 n#09146840',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('materassino','n#02971685 n#02974054',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tazza_da_caffè','n#02465975',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('superstizioso','n#N0002040',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stoccaggio','n#00239542',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('delega','n#04903746',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('galega_officinalis','n#08830216',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avanese','n#08830216',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capraggine','n#08830216',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pigiama','n#03079834',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rastrellamento','n#N0001679 n#N0001680',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stipendiato','n#N0002004',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coltura','n#00591037 n#00589348 n#00588408',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('goccia_di_rugiada','n#10641738',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('papaina','n#10744452',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('luna_di_miele','n#10986189 n#10864266',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bicarbonato_di_sodio','n#10595215',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('luppolo','n#08700478 n#08700688',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiacchierata','n#05337255 n#05338243 n#04958036',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colloquio','n#05337255 n#05339187',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conversare','n#05337255','v#00653048',NULL,NULL);
INSERT INTO italian_index VALUES ('conversazione','n#05337255',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('discorso','n#05337255 n#05404801 n#05320310 n#05406019 n#05338816',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('magazzinaggio','n#00517908',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sala_di_rianimazione','n#03221107',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arto','n#04307034 n#04307370',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('angheria','n#00270946',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dispetto','n#00270946 n#03795824 n#10337915',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('molestia','n#00270946 n#10337915 n#00270514',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mira','n#00521308 n#03336577 n#04588033',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falsario','n#07164714 n#07274727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfumatura','n#04955518 n#03876333',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indice_di_investimento','n#N0002666',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ch','n#N0002396',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chieti','n#N0002396',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teate','n#N0002396',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('verdetto','n#04918568 n#00775506 n#00768711 n#00772379',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impiantistica','n#N0000934',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lato_sopravvento','n#09961411',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('glossite','n#10294147',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arteria','n#04137243 n#02213687',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gradino','n#03262453 n#02711144 n#03410915',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scalino','n#03262453 n#03410915',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agopressione','n#00455637',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pugliese','n#N0001598',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moa','n#01046132',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deflorazione','n#N0000533',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sverginamento','n#N0000533',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monocamera','n#N0001216',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monolocale','n#N0001216',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monovano','n#N0001216',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tessera_del_sindacato','n#04863754',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('collegialità','n#N0000401',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('equanimità','n#04701990',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('equità','n#04701990 n#03792988',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imparzialità','n#04701990 n#04702275',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('obbiettività','n#04701990',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('obiettività','n#04701990',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spassionatezza','n#04701990',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cicca','n#05632099 n#05652708 n#02440492 n#02359166',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ondatra_zibethica','n#01839585',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ondatra','n#01839585',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rat_musquè','n#01839585 n#10586013',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ratto_muschiato','n#01839585',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('topo_muschiato','n#01839585 n#10586013',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macchinetta','n#02451335 n#02327307 n#02924270 n#N0001093 n#N0001092',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tagliaunghie','n#02451335',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tronchesina','n#02451335',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piridina','n#10531308',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vano','n#02267821 n#03250788',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_somala','n#09864241',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agape','n#00663950',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_libanese','n#09832786',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incostanza','n#03720732 n#03721331',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('instabilità','n#03720732 n#03748618 n#03721331',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('variabilità','n#03720732',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carteggio','n#04968827 n#04736897 n#06251336',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sciurus_niger','n#01857997',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coccio','n#03165060 n#03310070 n#02620398 n#02521493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zimbabwe','n#06653085',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diario','n#04825417 n#02565943',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giornale','n#04825417 n#04738466 n#03039218 n#06009637 n#04948875 n#04738867',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('casting','n#00105129',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colorito','n#03897800 n#04043575 n#03683889',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oligarca','n#07443488',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corda_per_saltare','n#02881706',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('non_evento','n#05432627',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caprimulgus_europaeus','n#01352625',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('succiacapre','n#01352625',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moralizzazione','n#N0001229',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intervistatore','n#07487242 n#07343385',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pg','n#N0002430',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perugia','n#N0002430',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiamata','n#04742189 n#05360200 n#04922159',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('telefonata','n#04742189',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tubercolo','n#10212869 n#09382852',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bandiera_di_bompresso','n#02869805',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rete','n#03037848 n#02771524 n#02758894 n#04495302 n#W0003087 n#03037972 n#02482897 n#00123083 n#W0003068 n#03632937 n#02477172 n#W0003075 n#03038207 n#06239044 n#W0003099',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elezione','n#00118200 n#00118873',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pagamento','n#00725730 n#09555462',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('federalismo','n#04711864',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gorilla_gorilla','n#01975051',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tropico','n#06385899',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('micromillimetro','n#09821432',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('millimicron','n#09821432',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nanometro','n#09821432',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imposta_plurifase','n#N0002782',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbraccio','n#00268460 n#00268156 n#10351257',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sonorità','n#03898569',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('displuvio','n#06389295 n#03238619',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spartiacque','n#06389295',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('felis_yagouaroundi','n#01634416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('yaguarondi','n#01634416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spesa','n#09554991 n#09553033 n#00050253 n#09552872 n#00726368 n#09553349',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inarcamento','n#N0000950 n#N0000951',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giovane_gufo','n#01143565',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tac','n#02482539 n#N0002183',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tomografia_assiale_computerizzata','n#02482539',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('suddiacono','n#N0002033',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('galeotto','n#07182455 n#07182598 n#07666308 n#07283862',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carcerato','n#07182455 n#07500774',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giapponese','n#07026907 n#05192293',NULL,'a#02732316',NULL);
INSERT INTO italian_index VALUES ('bichini','n#02287624',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bikini','n#02287624',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('duepezzi','n#02287624 n#03556360',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('virilità','n#03678310 n#03912065',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sgambetto','n#N0001881',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oracolo','n#05058245',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('libro_dei_verbali','n#04884387',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mezzavela','n#02876798',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polaccone','n#02876798',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marsiglia','n#06533779',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fascia_elastica','n#03132130',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chenopodium_ambrosioides','n#08139245',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('farinello_aromatico','n#08139245',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zoonosi','n#10197905',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interno','n#02929304 n#06333091 n#02653971 n#06333215 n#02695905 n#07117284',NULL,'a#00432675 a#00900967 a#00986917',NULL);
INSERT INTO italian_index VALUES ('graffiatura','n#10020481',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('graffio','n#10020481 n#10258533',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intaccatura','n#10020481 n#00248910',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intaglio','n#10020481 n#02861021',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sgraffiatura','n#10020481',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sgraffio','n#10020481 n#10258533',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tacca','n#10020481 n#00248910 n#03045881',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fabbrica','n#02662271 n#W0021171 n#06259028',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('opificio','n#02662271 n#03138429',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stabilimento','n#02662271 n#03138429',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('urologia','n#04633170',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('areometro','n#02844170',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gravimetro','n#02844170 n#02768798',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scarto','n#05516128 n#04463201',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('restaurazione','n#00172698',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('galoppo','n#00187201',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asparagina','n#10461626',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('istruzione','n#04589767 n#00574678 n#03851783 n#05082722 n#00567704 n#04941372',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('benedicite','n#05373820',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ord.','n#04902219',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ordinativo','n#04902219',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ordinazione','n#04902219 n#05084436 n#W0003130',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('plasmodio','n#00954627 n#00951043',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dubbio','n#04402548 n#03736708',NULL,'a#01846136 a#01846862 a#00332689',NULL);
INSERT INTO italian_index VALUES ('dubbiosità','n#04402548',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forse','n#04402548',NULL,NULL,'r#00294418');
INSERT INTO italian_index VALUES ('incertezza','n#04402548 n#03736708 n#03736465',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('problematicità','n#04402548',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tamil','n#05235066',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('simbiosi','n#09972931',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caverna','n#06738147 n#06738241',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agenda','n#04834835 n#04868776',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('libretto','n#04834835 n#04833775 n#09662438 n#05260613',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('memorandum','n#04834835 n#04882660',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quaderno_di_appunti','n#04834835',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alibi','n#05052528 n#05052359',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pretesto','n#05052528 n#03686637 n#05065454',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scusa','n#05052528 n#04976609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tolleranza','n#03658162 n#03929954',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attaccapanni','n#02787196 n#02827974',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portamantello','n#02787196',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lucidatrice','n#N0001075',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nettuno','n#06755463 n#06914135',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bottegaio','n#07572257',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bottegante','n#07572257',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pseudaletia_unipuncta','n#01799978',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('borace','n#10514136',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seracco','n#N0001862',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('faraone','n#07471767 n#00314949',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cinema_d''_essai','n#N0000371',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bussa','n#00761831',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('percossa','n#00761831',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mammuthus_primigenius','n#01998968',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('madrigale','n#05288291',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mozart','n#07743152',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('wolfgang_amadeus_mozart','n#07743152',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('verde_giada','n#03883826',NULL,'a#00360490',NULL);
INSERT INTO italian_index VALUES ('empietà','n#03784740 n#00270022 n#00480675',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stradale','n#N0002019',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_danese','n#09845164',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piano','n#03115608 n#10046013 n#04494752 n#04533598 n#02700186 n#09985988',NULL,'a#00512104','r#00067673 r#00277636');
INSERT INTO italian_index VALUES ('pianoforte','n#03115608',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('andatura_spavalda','n#00187997',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('danaro','n#09639711 n#09534064 n#09639977',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('denaro','n#09639711 n#09534064 n#09639977',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moneta','n#09639711 n#09642587 n#09642357 n#09640689',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soldo','n#09639711',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('homo_rhodesiensis','n#07532838',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esborso','n#09553033 n#09552872 n#00726368',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diavolo','n#05331986 n#06893775 n#07418621 n#06894661',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esecutivo','n#06072206',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('governo','n#06072206 n#00520891 n#06000383 n#00737271 n#00728919',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catalisi','n#09683849',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catalizzazione','n#09683849',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sagittaria','n#N0001759',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('olio_lubrificante','n#10729128',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pianoforte_a_mezza_coda','n#02231088',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alpi','n#06706713',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('misura_di_sicurezza','n#Y0005553',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maschio','n#02884501 n#07391044 n#07392266 n#07592357 n#00865379',NULL,'a#01416261',NULL);
INSERT INTO italian_index VALUES ('mastio','n#02884501',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('civilista','n#N0000389 n#N0000390',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rc','n#N0002441',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reggio_calabria','n#N0002441',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('armadillo','n#01950056 n#01950471 n#01951397',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ematoma','n#10276520',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spionaggio','n#00428003 n#00428272',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gotico','n#05215082 n#04498941',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('valore','n#04003291 n#09911766 n#04508194 n#04025511 n#03805961 n#03891461 n#09662199 n#03806460 n#04548688 n#04951584 n#04003707',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('centrale_elettrica','n#03168190',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camera_d''aria','n#02858210',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('boscaiolo','n#07384106 n#07686782',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('taglialegna','n#07384106 n#07686782',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('proiezione_conica','n#02487777',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caparra','n#09611986 n#09611633 n#05397001 n#09611330 n#05012609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pegno','n#09611986 n#09610891',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bosnia-erzegovina','n#06469243',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maceratoio','n#09672218',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macerazione','n#09672218',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macero','n#09672218',NULL,'a#00878089',NULL);
INSERT INTO italian_index VALUES ('marinaio_d''acqua_dolce','n#07362905',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('circolo','n#02458761 n#06107600 n#09995464 n#07785752 n#06117068',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('club','n#02458761 n#06107600',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canale','n#W0003004 n#06734279 n#04734014 n#02357012 n#04077287 n#09384404 n#02613638 n#W0003099 n#02374666 n#W0003029 n#06795884',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canale_commerciale','n#W0003004',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canale_di_distribuzione','n#W0003004',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canale_di_vendita','n#W0003004',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('picchettamento','n#N0001460',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('picchettatura','n#N0001460',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('picchettazione','n#N0001460',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strix_aluco','n#01144835',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('urano','n#06755330',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('screpolatura','n#06699811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('screpolo','n#06699811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esempio','n#W0021105 n#04549495 n#05003239 n#04483764',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cardium_edule','n#01472571',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conchiglia','n#01472571 n#01418986',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mollusco_bivalve','n#01472571',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('invecchiamento','n#09708216 n#09708369',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maturazione','n#09708216 n#09708081 n#10874611 n#10350062',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stagionamento','n#09708216',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stagionatura','n#09708216',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('superconduttività','n#07765520',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('listino','n#04874191',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('listino_dei_prezzi','n#04874191',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('listino_prezzi','n#04874191',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('preziario','n#04874191',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prezzario','n#04874191',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tariffario','n#04874191',NULL,'a#N0002647',NULL);
INSERT INTO italian_index VALUES ('concorrenza_sleale','n#W0020849',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('revoca','n#00817732',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('revocamento','n#00817732',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rivocamento','n#00817732',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rivocazione','n#00817732',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lista','n#02245671 n#04866394 n#04875428 n#03430059',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riga','n#02245671 n#03261562 n#06238477 n#05261047 n#05261517 n#04080923 n#03689511',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('longitudine','n#N0001070',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tasca','n#04273508 n#03149229',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('musarola','n#N0001259',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('muserola','n#N0001259',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('museruola','n#N0001259',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giainismo','n#04723873',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('jainismo','n#04723873',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disinflazione','n#09728112',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('suono','n#05488770 n#07817228 n#04417716 n#04745575 n#05321341 n#03892643 n#05502523',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('celta','n#07003967',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('slalom_gigante','n#W0020960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gigante','n#W0020960 n#00867448 n#06004802 n#07289774',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sillepsi','n#05319378',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fare','n#03811831','v#00523422 v#01781222 v#01130643 v#01443854 v#01747342 v#00718708 v#00080395 v#01490371 v#01160200 v#00495544 v#01746118 v#01136484 v#00722372 v#01257604 v#01126333 v#01666138 v#01787769 v#01443215 v#01173875 v#01774071 v#01185771 v#01130277 v#01113245 v#01142646 v#01156290 v#01612822 v#01775163 v#01564908 v#01114991 v#01785226 v#00079910 v#01200852 v#00786286 v#00223888 v#01649126 v#01111638 v#00523981',NULL,NULL);
INSERT INTO italian_index VALUES ('industria','n#03811831 n#00592801 n#06011363',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('industriosità','n#03811831',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('laboriosità','n#03811831 n#03655835 n#03706041',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('operosità','n#03811831',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('solerzia','n#03811831',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aula','n#02447403 n#02420363 n#02786743 n#02511574 n#02915911',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('classe','n#02447403 n#W0003111 n#05995901 n#06115327 n#05991008 n#06047005 n#06039237 n#03776654 n#05978135 n#W0003094 n#W0003076 n#W0003112',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciuco','n#01886957 n#07271334 n#01887170',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('voglia_di_fragola','n#03697824',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ecclettismo','n#04461818',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eclettismo','n#04461818',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('società_mirata','n#06019563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('società_vittima','n#06019563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coefficiente','n#09762118',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('culla','n#06277346 n#10867398 n#02515229 n#06277452 n#02520021',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('luogo_di_nascita','n#06277346',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cordone','n#02500398 n#02499699 n#02599409 n#03605952 n#05424528 n#02500847',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cordone_elettrico','n#02500398',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comando_generale','n#W0021040',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('microfotografia','n#03114808 n#N0001186',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('celtico','n#05219647',NULL,'a#02727096',NULL);
INSERT INTO italian_index VALUES ('vulcano','n#06722530 n#06907898 n#06738768 n#N0002321',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gioco_da_bambino','n#00272781',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antipiretico','n#02197619',NULL,'a#01121860',NULL);
INSERT INTO italian_index VALUES ('febbrifugo','n#02197619',NULL,'a#01121860',NULL);
INSERT INTO italian_index VALUES ('chiave_di_basso','n#05135288',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiave_di_fa','n#05135288',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nanerottolo','n#07541467 n#07232039',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('omuncolo','n#07541467',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mytilus_edulis','n#01476598',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contemporaneo','n#07180887',NULL,'a#00629488 a#01472664',NULL);
INSERT INTO italian_index VALUES ('processo_naturale','n#09670326',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attività','n#09670326 n#10090167 n#00381958 n#03655835 n#00261466 n#00378579 n#05973804 n#00709093',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bobina','n#02468712 n#03222943 n#02468210 n#02305960 n#03223071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bobina_d''accensione','n#02468712',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('genealogista','n#07286965',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gotto','n#03022988 n#09915537',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trenta','n#09901036',NULL,'a#02101768',NULL);
INSERT INTO italian_index VALUES ('immediatezza','n#04410209 n#03756011 n#03949507 n#03849886',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gnu','n#01917994',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('luì','n#N0001077',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('plutarco','n#07747911',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calzatoia','n#02435484',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calzolo','n#02435484',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calzuolo','n#02435484',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tacco','n#02435484 n#02813812',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('franco_del_madagascar','n#09841188',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('modulazione','n#04747347 n#05303065',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('libercolo','n#N0001050',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('artefatto','n#00011937',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('distanza_angolare','n#10006398',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calce','n#10607267',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arvicola_amphibius','n#01843297',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('torre_di_perforazione','n#02604225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quantità_definita','n#09756361',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quantità_determinata','n#09756361',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quantità_specifica','n#09756361',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gallinella','n#01310893',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pollastra','n#01310893',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tonico','n#03516005',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tonificante','n#03516005',NULL,'a#01302107',NULL);
INSERT INTO italian_index VALUES ('gadolinio','n#10486747',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falck','n#N0002504',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('taschino','n#02333834',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mutande','n#03559956 n#02301113',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avventatezza','n#03833126 n#03674380',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imprudenza','n#03833126 n#03677179 n#03674380 n#03832977',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('svagatezza','n#03833126 n#03677298',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salpinge','n#04074492',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbinamento','n#04401110 n#00243962',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monetarista','n#07417432',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grampus_griseus','n#01582446',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grampo','n#01582446',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cyclette','n#02650723',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lesotho','n#06543003',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('settuagesima','n#10908951',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bersaglio_per_freccette','n#02545484',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ambulanza','n#02181645 n#02674868',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autoambulanza','n#02181645',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autolettiga','n#02181645',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dindarolo','n#03277560',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salvadanaio','n#03277560',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('improprietà','n#N0000943 n#N0000942',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elettronica','n#04644705',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nobelio','n#10494859',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cartello','n#05088636 n#05087726 n#06114591 n#10345580 n#03337042',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('loris_gracilis','n#01992753',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lori','n#01992753',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cattiveria','n#04007415 n#03803124 n#03844003',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alfabeto','n#04876596',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giordania','n#06522440',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sceneggiatura','n#05260792 n#05258732',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('superteste','n#N0002041',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('supertestimone','n#N0002041',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polisemia','n#03783093',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('innesto_epidermico','n#04069000',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('kilt','n#02889053',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pigmeo','n#07514215',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbattuta','n#02156018',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accelerazione','n#10973517 n#03950360 n#00212943',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('epopea','n#04812566 n#04809352',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('epos','n#04812566',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leuciscus_cephalus','n#00967794',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavedano','n#00967794',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canestraio','n#07103696',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cestaio','n#07103696',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panieraio','n#07103696',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gessetto','n#10621972 n#02419477',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pinicola_enucleator','n#01063693',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciuffolotto_delle_pinete','n#01063693',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forno_a_microonde','n#02996202',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('microonde','n#02996202',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fata_assicurazioni_s.p.a.','n#N0002573',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fondo_assicurativo_tra_agricoltori_s.p.a.','n#N0002573',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('f.a.t.a.','n#N0002573',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fissipedia','n#01593191',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ominide','n#01966690',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tubero','n#09418180',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disdoro','n#10360525',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disonore','n#10360525',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ignominia','n#10360525 n#10361358 n#02832377',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('onta','n#10360525 n#00794619 n#10359961',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vergogna','n#10360525 n#05592914 n#05580420 n#05579963',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carta_moschicida','n#10667811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deficienza','n#04367467 n#03986577 n#04367280 n#03986080 n#10377087',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imbecillità','n#04367467',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corrispondenza','n#04736897 n#04968082 n#09931077 n#06251336 n#03728635',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('watt','n#09809274',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mensola','n#02328448 n#03314483',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cancro','n#10229324 n#10226609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carcinoma','n#10229324 n#10230421 n#10226609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tumore_maligno','n#10229324',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cantante','n#07577957',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cantatore','n#07577957',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità','n#06088087 n#09946775 n#03727089 n#09760609 n#10374942',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('discrezione','n#03988388 n#03825241 n#04349139 n#10083123 n#03830684 n#04046609 n#04348023',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('equilibrio','n#03988388 n#10064507 n#10041089 n#10087814 n#03962596 n#10015195',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('misuratezza','n#03988388 n#03825241',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moderatezza','n#03988388',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('analisi_del_sangue','n#04431571',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piatto_piano','n#02573664',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lenitivo','n#02917386',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('etnologo','n#07248684',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stercorario','n#01555867 n#02967710',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('numero_di_massa','n#09872980',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diodo','n#02574189 n#02574009',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maniera','n#03844273 n#03856995 n#04501454 n#00111872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('modo_di_fare','n#03844273',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chimico','n#07152752',NULL,'a#02543445 a#02543733',NULL);
INSERT INTO italian_index VALUES ('celerità','n#03949337 n#03948579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fulmineità','n#03949337',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prestezza','n#03949337',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rapidezza','n#03949337',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rapidità','n#03949337',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rattezza','n#03949337',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('speditezza','n#03949337 n#03948579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('subitaneità','n#03949337',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('subitezza','n#03949337',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('documentario_di_viaggio','n#04961724',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zona_pranzo','n#02572286',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strombatura','n#03386175',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contingenza','n#10087148 n#09552117 n#10409482',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('argentina','n#06410305 n#02035388 n#02035234',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('repubblica_argentina','n#06410305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('romanico','n#04499253',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stile','n#03856995 n#03775143 n#04500633 n#05293492',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guisa','n#03856995',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('felis_concolor','n#01634046',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('puma','n#01634046',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('urbanista','n#N0002202',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coscienziosità','n#03681770 n#03800085',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ineccepibilità','n#03681770',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('logicità','n#03681770',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scrupolo','n#03681770 n#05594782 n#00416445 n#03682129',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teleobbiettivo','n#03480512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teleobiettivo','n#03480512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zoom','n#03480512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sguaiataggine','n#03838889 n#03777707',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fogna','n#03435353 n#03306252 n#07567791',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('porcile','n#03435353',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stabbio','n#03435353 n#03102571 n#02708549 n#10660827',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stabbiolo','n#03435353',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stalla','n#03435353 n#02513818 n#03395783 n#03399664 n#02252128',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cocchio','n#02459686 n#02424178 n#02424284',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vettura','n#02459686 n#03092927 n#02383458',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sionista','n#07692593',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indizio','n#05090749 n#04983714 n#04984365',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veneziano','n#07026216',NULL,'a#02736884',NULL);
INSERT INTO italian_index VALUES ('fenolftaleina','n#N0000726',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ajuga_chamaepitys','n#09139843',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iva_artritica','n#09139843',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('benetton','n#N0002483',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('benetton_group_spa','n#N0002483',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('benetton_spa','n#N0002483',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('popolo','n#06069040 n#06080290 n#05957883 n#05961082 n#06104886',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('periodo','n#10843624 n#10969191 n#10982844 n#10988653 n#10947841 n#10954173 n#10850147 n#10869183',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('porridge','n#05902479',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbonimento','n#00159157',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lungolago','n#06800664',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gramaglie','n#03604714',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sudore','n#04200725',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('traspirazione','n#04200725 n#09712159',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('midolla','n#N0001210',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mollica','n#N0001210 n#05670563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avvocatura','n#06047281',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inforcatura','n#04337722',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('split_end','n#07601173',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('animalità','n#03647903',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiorino_olandese','n#09842781',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciclo','n#02539381 n#06249613 n#10981743 n#02285672 n#10976183',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abramide_comune','n#02053339',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nomenclatura','n#04759121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('terminologia','n#04759121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anarchico','n#07075067',NULL,'a#02485429',NULL);
INSERT INTO italian_index VALUES ('nichilista','n#07075067 n#07433437',NULL,'a#02689457',NULL);
INSERT INTO italian_index VALUES ('nihilista','n#07075067 n#07433437',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agenzia_di_stampa','n#06186996',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('voduismo','n#04727207',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vodù','n#04727207',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vuduismo','n#04727207',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vudù','n#04727207',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fama','n#04705103 n#10359466 n#10359826 n#10358202',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leccapiatti','n#07278977',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parasita','n#07278977 n#07418757 n#07367906',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parassita','n#07278977 n#00912376 n#07418757 n#07367906',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbafatore','n#07278977 n#07418757',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scroccatore','n#07278977 n#07418757',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scroccone','n#07278977 n#07418757',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esistenza','n#10059583 n#10059340 n#10054265 n#10060845',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vita','n#10059583 n#10865688 n#04477455 n#10866015 n#09575439 n#04303810 n#06659588 n#00002880 n#10059340 n#10060845 n#10866163 n#03653606 n#03857935 n#04890744',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sculacciata','n#00752044',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('animale_da_tiro','n#00863198',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('animale_da_traino','n#00863198',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cuscus','n#N0000513',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cuscussù','n#N0000513',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bastonata','n#N0001150',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('legnata','n#N0001150 n#00752384',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mazzata','n#N0001150',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('randellata','n#N0001150',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cauzione','n#09610891 n#05012503 n#09612224 n#09611158 n#09611330',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carillon','n#03025619',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('xml','n#N0002281',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impressione','n#04544110 n#03684009 n#10013828 n#05006313 n#04413760',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sensazione','n#04544110 n#05586720 n#10418416 n#00014045 n#04419902 n#04413760',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sentimento','n#04544110 n#04564824 n#10418416 n#00014045 n#05562208',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bottacciolo','n#10285834',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('siberia','n#06570440',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sgomberatura','n#00109670',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('traslocamento','n#00109670',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trasloco','n#00109670',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lilla','n#08613795 n#08615006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lillà','n#08613795 n#08615006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('serenella','n#08613795 n#08615006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eiettore','n#02395335',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('espulsore','n#02395335',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('villa','n#02558878 n#02509946',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lessico','n#04839282 n#04370622 n#04370466 n#04378630 n#04837766',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vocabolario','n#04839282 n#04378630 n#04837766',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('letto_caldo','n#02835732',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clorato','n#10465779',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('kodiac','n#01641436',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ursus_arctos_middendorffi','n#01641436',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monte_bianco','n#06720141',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assenteismo','n#00801444',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('slavina','n#N0001911 n#N0001035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mantissa','n#05102381',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impermeabilizzazione','n#00532187',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sigillatura','n#00532187',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raggera','n#N0001667',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raggiera','n#N0001667',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('candeliere','n#03400689 n#02375281',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('armoniosità','n#03894446',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('musicalità','n#03894446 n#03894642',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agrezzza','n#03902140',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affioramento','n#06670003 n#00034867',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cappellaccio','n#06670003',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nume','n#07436551',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lycopus_europaeus','n#09150944',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erba-sega_comune','n#09150944',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mongolfiera','n#02243465 n#02835582',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('insetticida','n#10705981',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polvere_insetticida','n#10705981',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oppressione','n#00269563 n#10083742',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perianzio','n#08003788',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imprecisione','n#03769786 n#03769486',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capitolato','n#05042568',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('specifica','n#05042568 n#N0001959',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affittuario','n#07636278 n#07379510 n#07635964 n#07367609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('metro','n#W0021136 n#05307231 n#05419184 n#09822324',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esercizio','n#00469856 n#00574902 n#00415881 n#00411620 n#03325022 n#00737271 n#06008236',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attenzione','n#04370050 n#04405653 n#04349454 n#04506619 n#00020804 n#04407291',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('economie_di_bilancio','n#N0002727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dipsomania','n#06662394',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('campanula','n#08344324',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('turbina_a_gas','n#02746485',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('subappaltatore','n#07618694',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quadratura','n#N0001619 n#00561436',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antidivo','n#N0000066',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imbottitura','n#03434877 n#03076122 n#03076530',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sterpaglia','n#10603122',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cittadino','n#07157546 n#06952517 n#07645824',NULL,'a#00900967',NULL);
INSERT INTO italian_index VALUES ('individualismo','n#04575675',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corsale','n#02504619',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corsaro','n#02504619 n#07501646 n#03174787 n#07478389 n#07185512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pirata','n#02504619 n#07479395',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_della_malaysia','n#09859947',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abitudinario','n#N0000008',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('consuetudinario','n#N0000008',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('freenet','n#N0002512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('freenet_srl','n#N0002512',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avversità','n#05446233 n#05466557 n#10384234',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contrarietà','n#05446233 n#00411168 n#05466557 n#05577305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disdetta','n#05446233 n#10384027 n#05388537',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fatalità','n#05446233 n#05462231 n#03734831',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guaio','n#05446233 n#00411168 n#04395081 n#10340224',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfortuna','n#05446233 n#10384027 n#07777626',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sventura','n#05446233 n#10384027 n#05452288',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('g.a.t.t.','n#06161263',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accordo_generale_sulle_tariffe_e_sul_commercio','n#06161263',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiammato','n#N0000735',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tastierino','n#N0002077',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tastierino_numerico','n#N0002077',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bs','n#N0002388',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brescia','n#N0002388',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mezza_verità','n#05064304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nardo','n#03030729',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('levanoccioli','n#N0001918',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('snocciolatoio','n#N0001918',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('commentatore','n#07438399',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('opinionista','n#07438399 n#07167670',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('osservatore','n#07438399 n#06953561',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('micropilo','n#07994425',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carlina_acaulis','n#08253195',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carlina_bianca','n#08253195',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apatia','n#03656931 n#05563581',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disamore','n#03656931 n#05579322',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indifferenza','n#03656931 n#05563705 n#05579184 n#05579322',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('letargo','n#03656931 n#10093894 n#10094429 n#10094762 n#10094639',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('artiglieria','n#02215337 n#06207601 n#02779859',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('burrasca_forte','n#07802828',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('commerciante_di_vini','n#07666744',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vinaio','n#07666744',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('circoscrizione','n#06334762 n#06304618',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autosuggestione','n#N0000124',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('condensazione','n#09678560 n#04727755',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bozza','n#04818688 n#04945166 n#10274960 n#10260024',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disegno','n#04818688 n#00598605 n#04588033 n#02598242 n#03136211 n#02557306',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portasigarette','n#02441071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('epifisi','n#04333507 n#04252908',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('merito','n#09911766 n#04546812 n#04003047 n#04003707',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bar','n#02366126 n#02255304 n#09869188',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caffetteria','n#02366126',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immolazione','n#00144654 n#00781421',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gamba','n#04307856 n#04308673 n#04308509 n#02916415 n#02916249',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vena_porta','n#04178702',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('il_giocare_a_golf','n#00081676',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dentale','n#05325201',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amplesso','n#00542663',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('atto_sessuale','n#00542663',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coito','n#00542663',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('concubito','n#00542663',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('copulazione','n#00542663',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rapporti_sessuali','n#00542663',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('egitto','n#06507063 n#06507271',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('standard_di_vita','n#10045850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tenore_di_vita','n#10045850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camelia','n#09226894',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfenoide','n#04098981',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('numero_primo','n#09768017',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('entomologo','n#07245174',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dioniso','n#06905529',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portaghiaccio','n#N0001535',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('secchiello_portaghiaccio','n#N0001535',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scala_a_libretto','n#03411248',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scaleo','n#03411248',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diaframma','n#04281971 n#02565697 n#02565389',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('servizio_di_controllo_del_traffico','n#00692824',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quartetto','n#05279654',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nepalese','n#07031459 n#05229258',NULL,'a#02737705',NULL);
INSERT INTO italian_index VALUES ('velodromo','n#N0002228',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alta_quota','n#W0020903',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comunismo','n#06193315 n#04710553',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('enterobius_vermicularis','n#01445049',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ossiuro','n#01445049',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ossiuro_dei_bambini','n#01445049',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aferesi','n#09721071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chilovolt','n#09808522',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('kilovolt','n#09808522',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camicia','n#02870760 n#03320567 n#02301305 n#02870609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('classe_turistica','n#03522641',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('superlavoro','n#00410787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('surmenage','n#00410787 n#10314018',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anta','n#02914669 n#03332110',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('battente','n#02914669 n#03332110 n#02896062 n#03591564',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fibra','n#03927465 n#02673126 n#10663683',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('verdone','n#N0002232',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assai','n#09921720',NULL,NULL,'r#00057204');
INSERT INTO italian_index VALUES ('molto','n#09921720',NULL,'a#01332909 a#01490743 a#01488913 a#01380813','r#00098325 r#00109105 r#00057118 r#00057204 r#00086681 r#00054768 r#00334911 r#00109505 r#00031812 r#00010099 r#00031106 r#00162139');
INSERT INTO italian_index VALUES ('agenzia_di_pubblicità','n#06185853',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agenzia_pubblicitaria','n#06185853',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('depredatore','n#07395416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('devastatore','n#07395416',NULL,'a#00552895',NULL);
INSERT INTO italian_index VALUES ('razziatore','n#07395416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orientalizzazione','n#N0001331',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fregata','n#01564430 n#00498592 n#00080362 n#02724340',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stella_della_sera','n#06761805',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ceco','n#05206977 n#07115645 n#04288593',NULL,'a#02076031 a#02730257',NULL);
INSERT INTO italian_index VALUES ('cecoslovacco','n#05206977 n#07012239',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ceko','n#05206977',NULL,'a#02730257',NULL);
INSERT INTO italian_index VALUES ('capillarità','n#10375600 n#07782359',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('labrace','n#02055726',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spigola','n#02055726',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spinola','n#02055726',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gesuita','n#07348093',NULL,'a#02822978',NULL);
INSERT INTO italian_index VALUES ('amenità','n#05569841 n#00332189 n#03750643 n#05077026 n#03750976',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gustosità','n#05569841 n#03902647 n#03903280',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('serratula_tinctoria','n#08322222',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cerretta_dei_tintori','n#08322222',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filosofo','n#07473906 n#07473120',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('visita','n#06204513 n#00800256 n#00425999 n#00683152',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barchetta','n#03357161',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imbarcazione','n#03357161',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fortezza','n#03929156 n#03431121 n#02716224',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forza_d''animo','n#03929156',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buon_costume','n#N0000213 n#06094485',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buoncostume','n#N0000213 n#06094485',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soprintendenza','n#00735967',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sorveglianza','n#00735967 n#00428474',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sovrintendenza','n#00735967',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('supervisione','n#00735967',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vigilanza','n#00735967 n#00428474',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seppia','n#01484774',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giratario','n#N0000852',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('artemisia_annua','n#08237435',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assenzio_annuale','n#08237435',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('facoltà','n#04369800 n#03930426 n#04049589',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('livellatore','n#07370070',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('football','n#00304700 n#00299231',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quarzo_affumicato','n#10532902',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('jaculus_jaculus','n#01853574',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scivolata','n#05453812 n#00212053 n#00110741',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baionettata','n#N0000140 n#N0000141',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quindicennale','n#N0001643',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('flash','n#02694994',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lampeggiatore','n#02694994',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lampo','n#02694994 n#07812527 n#10953874 n#05517298 n#03351953 n#05516648',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cribro','n#09391520',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lavorazione_del_metallo','n#00593978',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zanzariera','n#03015875',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('razionalizzazione','n#00785961 n#04466164 n#09722976',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bacio','n#00090133 n#W0021169',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('balaenoptera_musculus','n#01576357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('balenottera_azzurra','n#01576357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('società_di_assicurazione_contro_gli_incendi','n#N0002712',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rasatura','n#00163357 n#00231395',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oricello','n#09284811 n#10756645',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imposta_comunale_sull''incremento_di_valore_degli_immobili','n#N0002763',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ladro_di_bestiame','n#07541894',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deponente','n#07210838',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('depositante','n#07210838',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pieno_inverno','n#10946782',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seggio','n#06352758',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nazista','n#07428898',NULL,'a#02759997',NULL);
INSERT INTO italian_index VALUES ('fideismo','n#N0000741',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('50','n#09901273',NULL,'a#02101957',NULL);
INSERT INTO italian_index VALUES ('l','n#09901273 n#09805933 n#N0001086 n#09794447',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cinquanta','n#09901273',NULL,'a#02101957',NULL);
INSERT INTO italian_index VALUES ('won','n#09866805 n#09866452',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('won_della_corea_del_sud','n#09866805',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('modo_di_parlare','n#05296602',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sopravalutazione','n#04902082',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sopravvalutazione','n#04902082',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sceneggiatore','n#07554016',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scriptwriter','n#07554016',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soggettista','n#07554016',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sanità_mentale','n#10316608',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('adianto','n#09492016',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sgretolamento','n#N0001885 n#00242321 n#N0001886',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('energia','n#03654225 n#03932475 n#10119788 n#03931784 n#07794689 n#03928353 n#07795077 n#03791327',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vigore','n#03654225 n#03932475 n#03928353',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('busta_a_finestra','n#03621589',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('costumista','n#07186496',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('figurinista','n#07186496',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calicetto','n#08003631',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bollino','n#05090280',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bollino_premio','n#05090280',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coenzima','n#10616500',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cofermento','n#10616500',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('armigero','n#07083562',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scudiero','n#07083562 n#07604472',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ansa','n#06794852 n#02281683 n#02792702 n#06848252',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('insenatura','n#06794852',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sacca','n#06794852',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seno','n#06794852 n#04275292 n#04302960 n#09928774 n#04079024',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('beozia','n#06453598',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corsa_coi_sacchi','n#05548578',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('instillazione','n#00571637 n#00207683',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('istillazione','n#00571637 n#00207683',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mulattiere','n#07423434',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('errore','n#04531221 n#03803693 n#05071571 n#00042411 n#03768006 n#00488251 n#00042960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corticosterone','n#10571392',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('induttanza','n#03913314 n#09763521',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cointeressenza','n#09564823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interessenza','n#09564823',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('artigliere','n#07085250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cannoniere','n#07085250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pagina','n#W0021155 n#04824319 n#W0021158 n#04731849 n#W0021154 n#W0021157 n#W0021156 n#04731596 n#W0021159',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_polacca','n#09868054',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cortile_della_scuola','n#06368228',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('uccellagione','n#N0002190',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('graticcio','n#03600078 n#03536378',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('durevolezza','n#03944820',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('resistenza','n#03944820 n#00132311 n#06190366 n#W0003137 n#03232583 n#07831825 n#W0003142 n#03663435 n#00612245 n#03929725 n#03929458',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('volpoca','n#01366437',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attrezzo','n#03516946 n#02644452',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pronto_soccorso','n#00429658 n#02637146',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brogliaccio','n#10780840 n#09655029',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scartafaccio','n#10780840',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interesse_annuo','n#N0002811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('distributore_di_benzina','n#02745229',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stazione_di_rifornimento','n#02745229',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disagio','n#00411168 n#05580651 n#10365540',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gymnadenia_odoratissima','n#08371855',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('manina_profumata','n#08371855',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vento_di_traverso','n#07787990',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nefrite','n#10155437',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('depressione','n#10394468 n#10392521 n#10335731 n#10336031 n#05603287 n#10414642',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('slump','n#10394468',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('movimento','n#06251839 n#03021820 n#N0001247 n#05283408 n#05146366 n#00180278 n#00213518',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('saponificazione','n#09734332',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pazzia','n#10329126 n#10328922',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dibattimento','n#05406961 n#05347125 n#05342315',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dibattito','n#05406961 n#05342032 n#05347125 n#05342315',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('discussione','n#05406961 n#05342032 n#05369177 n#05369518 n#05342315',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('molecola','n#10472898 n#10448670',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rapitore','n#07353959',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rattore','n#07353959',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sequestratore','n#07353959',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('protezione_civile','n#00616416 n#W0020820',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('penna_stilografica','n#02718153',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stilografica','n#02718153',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('last_in_first_out','n#N0001055',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lifo','n#N0001055',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('madera','n#05923941 n#06823907',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('time_out','n#00687814',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ossatura','n#04327906 n#02720094 n#04327722 n#03343262',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('codice_a_barre','n#04791145',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rotativa','n#03254975',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interessamento','n#05578595',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('muscaragno','n#01407519',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('toporagno','n#01407519',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('combutta','n#06083357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('folla_disordinata','n#06083357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('masnada','n#06083357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raccogliticcio','n#06083357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stuolo','n#06083357 n#06082225 n#06081960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('turba','n#06083357 n#10121017',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('confusione_di_gente','n#06083357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cibarie','n#05622219 n#05617971',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prodotto_alimentare','n#05622219',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('refettorio','n#02572558 n#03223213',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('razzia','n#00620675 n#00627831',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idrostatica','n#04653242',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('partita','n#00205632 n#00289585 n#09655159 n#00289269',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sottopentola','n#N0001939',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scilly','n#N0002054',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buca_delle_lettere','n#03162485',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cassetta_delle_lettere','n#03162485',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diverbio','n#05367634 n#05369518',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('squadra_da_disegno','n#03305459',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pellicano','n#01563500 n#01564020',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corpus','n#05966104',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bando','n#00136174 n#05043361 n#05056776',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esilio','n#00136174 n#00135765',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decathlon','n#05543404',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decatlon','n#05543404',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coronazione','n#05541618',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incoronamento','n#05541618',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incoronazione','n#05541618',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baleno','n#07812527 n#10953874 n#05517298 n#03873745',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fulmine','n#07812527 n#07843245',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('astenia','n#10432110',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cereale','n#08447975',NULL,'a#02540620',NULL);
INSERT INTO italian_index VALUES ('lapponia','n#06542342',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lume','n#04590995 n#07810544 n#03872297 n#02923368',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coda','n#03529109 n#06235683 n#10030452 n#01665222',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strascico','n#03529109',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ruscus_aculeatus','n#08764678',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pungitopo','n#08764678',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('persecuzione','n#00269249',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('manca','n#04311998',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mancina','n#04311998',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sinistra','n#04311998 n#06355123',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('proporzione','n#03972175 n#09951183',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contascatti','n#N0000452',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unitarianesimo','n#04720094',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unitarismo','n#04720094',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impanatura','n#N0000927 n#N0000928',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guardacoste','n#06090171 n#03096751',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guardia_costiera','n#06090171',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guardiacoste','n#06090171 n#03096751',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mostra','n#05148820 n#04484702 n#02581231 n#06217283',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbandieramento','n#05148820',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfoggio','n#05148820 n#03833688',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avicoltura','n#N0000129',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avicultura','n#N0000129',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paramagnetismo','n#07816819',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gola','n#02596615 n#06710488 n#02541032 n#04296952 n#03827106 n#06733832',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scolo','n#02596615',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rossetto','n#02931334 n#03256834',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('balconata','n#02240068 n#02442753 n#02239875 n#02734380',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('commissione_d''inchiesta','n#W0020953',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('protestante','n#06026928 n#06997011',NULL,'a#02722262',NULL);
INSERT INTO italian_index VALUES ('calorosità','n#03813760 n#05609617',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('umore_variabile','n#03651222',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affiche','n#05087726',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('manifesto','n#05087726 n#02288900 n#05043559',NULL,'a#00545700',NULL);
INSERT INTO italian_index VALUES ('poster','n#05087726',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('famiglia','n#W0021109 n#07356867 n#05975776 n#06042737 n#05975517 n#06037572 n#05991008 n#06021037 n#06108270',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vaso_sanguigno','n#04207149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sevizie','n#00269778',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rotella_tagliavetro','n#02756286',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pista_di_rullaggio','n#03474591',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canavaccio','n#02617141 n#02577862 n#02577770',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canovaccio','n#02617141 n#02577862 n#02577770',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cencio','n#02617141 n#03206762',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('straccio','n#02617141 n#03206762',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('borsa_per_il_tabacco','n#03510793',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soldato_semplice','n#07501217',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sottofamiglia','n#06043658',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('burro_di_arachidi','n#05885320',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lampada_ad_arco','n#02207006',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('logaritmo','n#05101915',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('codirosso','n#01083968',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alleanza','n#05971916 n#06155266 n#00700029 n#05075069 n#10345722',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('porzana_porzana','n#01527900',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('voltolino','n#01527900',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('neuroanatomia','n#04631300',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mammografia','n#00649306',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mastografia','n#00649306',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('augurio','n#04973864 n#05435037',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salutazione','n#04973864',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('saluto','n#04973864 n#05014889 n#04976353',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('definizione','n#03701336 n#05365792 n#05054071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capostazione','n#07609078',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammalato','n#07574722 n#07461272',NULL,'a#02421145',NULL);
INSERT INTO italian_index VALUES ('malato','n#07574722 n#07461272',NULL,'a#02421145',NULL);
INSERT INTO italian_index VALUES ('capitale_a_rischio','n#09615031',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capitale_di_rischio','n#09615031',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('virgulto','n#07552177',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mummia','n#04056757',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sopraccarico','n#03070607',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sovraccarico','n#03070607',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('larva','n#01813568',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('edizione','n#04944727 n#04948748 n#05968443',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assenzio','n#05931176 n#08237169 n#08236241',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mo','n#N0002424',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('modena','n#N0002424',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diritto','n#04030305 n#02894644 n#00371093 n#03051767 n#04680638 n#06243906 n#00370892',NULL,'a#02366741 a#01184641','r#00050567 r#00056323');
INSERT INTO italian_index VALUES ('mustela_frenata','n#01938567',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ermellino_del_nord_america','n#01938567',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stendardo','n#02247873',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('striscione','n#02247873',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('euromissile','n#N0000680',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eredità','n#09544459 n#00051119 n#04382865 n#03850874 n#09543723 n#03851000 n#09698925',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lascio','n#09544459',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lascito','n#09544459',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('legato','n#09544459',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alitalia','n#N0002474',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('laconicità','n#05304278',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('laconismo','n#05304278',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('direttore_generale','n#07287045',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eracle','n#06921507',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ercole','n#06921507',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('branzino','n#02056987',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ephestia_elutella','n#01792868',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polvere_d''oro','n#10553643',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('campione','n#04613140 n#04087526 n#04484702 n#06671301 n#07147424 n#07147536',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avviamento','n#09598982 n#00574678 n#00155548 n#00153241 n#03403182',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('valore_d''avviamento','n#09598982',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pesce_osseo','n#02007649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riconoscimento','n#04445171 n#05014301 n#10341471',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_marocchina','n#09834262',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sogliola','n#02153209 n#02153639',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sciatore','n#07581238',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fornello','n#03422865 n#02684043 n#02836663',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impertinenza','n#05040370 n#05040252',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('insolenza','n#05040370 n#00794524 n#03828648 n#03848510 n#05040252',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('emberiza_citrinella','n#01060791',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zigolo_giallo','n#01060791',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moca','n#05941231',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moka','n#05941231',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('michelin','n#N0002533',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gallo_bantam','n#01309874',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('glaucomys_volans','n#01862044',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scoiattolo_volante','n#01862044',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fluttuazione','n#05467031',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('variazione','n#05467031 n#05441797 n#00128096 n#03745861 n#05271875',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erba','n#02376183 n#08510637 n#08699755 n#05844811 n#05748229 n#08409338',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('hascisc','n#02376183 n#02802071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('hashish','n#02376183',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mariagiovanna','n#02376183',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marijuana','n#02376183',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sandalo','n#03273160 n#09034954',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sandolo','n#03273160 n#09034954',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('desiderio','n#04464063 n#10112569 n#05564026 n#03868099 n#05568116 n#05564936 n#05565069',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('astrattista','n#07056328',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leonessa','n#01638160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('hyperoodon_ampullatus','n#01580061',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('islamita','n#06999749',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maomettano','n#06999749',NULL,'a#02789519',NULL);
INSERT INTO italian_index VALUES ('mussulmano','n#06999749',NULL,'a#02698564',NULL);
INSERT INTO italian_index VALUES ('musulmano','n#06999749',NULL,'a#02698564',NULL);
INSERT INTO italian_index VALUES ('saraceno','n#06999749',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impermeabilità','n#03866243',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aerografo','n#02170384',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('svalutazione','n#00227728 n#00515372 n#09596000',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('liberalizzazione_del_mercato','n#Y0005577',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('osteitti','n#02007399',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('osteichthyes','n#02007399',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('osteomalacia','n#10211679',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('plutone','n#06755608 n#06914986',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macchina','n#07385642 n#02949521 n#02937872 n#02383458 n#W0021107 n#W0021106',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palla_muro','n#00305651 n#00305357 n#02790047',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pallamuro','n#00305651 n#00305357 n#02790047',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amore','n#05616611 n#04478900 n#05608483 n#05607724 n#07109169 n#07626109 n#05567241 n#07626006 n#07201633',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esaltazione','n#05616611 n#10111097 n#10075760',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('entusiasmo','n#05616611 n#03655506 n#04383528',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stercorarius_parasiticus','n#01556206',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('labbo','n#01556206',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ingrassaggio','n#00459727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lubrificazione','n#00459727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oliatura','n#00459727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ungitura','n#00459727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spirito','n#07600733 n#03645652 n#10418416 n#06895914 n#04533237 n#03648811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rodolia_cardinalis','n#01672286',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coccinella','n#01672286 n#01670916',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eccipiente','n#N0000625',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('voto','n#04429217 n#00120305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lacuna','n#02899596',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spazio_vuoto','n#02899596 n#06698176',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spazio_in_bianco','n#02899596 n#04817735',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capanna_di_legno','n#02939459',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capanna_di_tronchi','n#02939459',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('croce_rossa','n#05998735',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('invalidità','n#03774020 n#10432352',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tabacco','n#03510496',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inevitabile','n#05462436',NULL,'a#00334192 a#00333883',NULL);
INSERT INTO italian_index VALUES ('miniatore','n#07468125 n#07412274',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perfezionista','n#07468125',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('muscicapa_striata','n#01078695',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pigliamosche','n#01078695 n#09081527',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bull_terrier','n#01603642',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banca_per_automobilisti','n#N0002743',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bregma','n#04293959',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compenso','n#05441142 n#09559232 n#09590231 n#09555462 n#09556237',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('premio','n#05441142 n#09547800 n#09575058 n#05020360',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risarcimento','n#05441142 n#09566341 n#00166954',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bey','n#07110840 n#07110730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pioggia_di_meteoriti','n#07834588',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('schiniere','n#02770280',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('belato','n#05493300 n#05387614',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acetilcellulosa','n#10736953',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maremmano','n#N0001134',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agricoltura_mista','n#00590363',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incidente_stradale','n#W0020979',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('commesso_viaggiatore','n#07650329',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piazzista','n#07650329',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salesman','n#07650329',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_costaricana','n#09829835',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('edicolante','n#07431628',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('edicolista','n#07431628',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giornalaio','n#07431628',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strillone','n#07431628',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('war_game','n#00294464',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baia','n#02237611 n#06795196 n#00331800 n#00331225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frivolezza','n#02237611 n#03664422',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('futilità','n#02237611 n#04012751',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risibilità','n#02237611',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prostituta','n#07096855 n#07507944',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('astratto','n#04506767',NULL,'a#00012300',NULL);
INSERT INTO italian_index VALUES ('astrazione','n#04506767 n#00013018 n#04456018',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_cambogiana','n#09859711',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bomba_a_orologeria','n#03505728',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiancata','n#02341415 n#N0000736',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paradontologia','n#04627080',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('discesa','n#05483742 n#06725397 n#05488098 n#03985255 n#00280586 n#00628646 n#00210530 n#00196735',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('di_sopra','n#06380382',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disopra','n#06380382',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aneto','n#09228957',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tassista','n#07631941',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('taxista','n#07631941',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bisogna','n#06846731',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('processo_cognitivo_di_base','n#04405322',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polacco','n#05206804 n#07034349',NULL,'a#02730008',NULL);
INSERT INTO italian_index VALUES ('dente','n#04099962 n#02467603 n#01663740 n#03178082',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mialgia','n#10283373',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('urlatore','n#07536448',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('urlone','n#07536448',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catafalco','n#02286667 n#02402731',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cataletto','n#02286667 n#02286791',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ibernazione','n#10093894',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('automeris_io','n#01806600',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prematuro','n#07494574',NULL,'a#01433488',NULL);
INSERT INTO italian_index VALUES ('e-commerce','n#W0020898',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('commercio_elettronico','n#W0020898',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('meninge','n#04250606',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ingrediente','n#02856309 n#02479780 n#04515709 n#05842639',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imposta_sul_patrimonio_netto','n#N0002797',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pepita','n#06685856',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('posizione','n#03965003 n#04696462 n#04706473 n#06352837 n#06354049 n#00385376 n#10048803 n#06353479 n#00463745 n#10034299',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ubbidienza','n#03841543 n#00755927',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('y','n#10507546',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ittrio','n#10507546',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('yttrio','n#10507546',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lucignolo','n#03615430',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stoppino','n#03615430',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anticima','n#N0000063',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('farsetto','n#02594317 n#02874461',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giunta','n#03386293 n#00047131 n#06167708 n#N0000857 n#00233991',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aplomb','n#03839987',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bardatura','n#02212047 n#02381405 n#02799877',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abiti_da_cerimonia','n#02212047',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abiti_eleganti','n#02212047',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ritualismo','n#00665928',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paramenti','n#03575346',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vista','n#04373924 n#00563576 n#04355068 n#04555681 n#04373072 n#04555855',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vedere','n#04373924','v#01695952 v#01725730 v#00466852 v#01457618 v#00446362 v#00786184 v#01698948 v#01472578 v#01382085 v#01123901 v#W0021093 v#01456984 v#01456625 v#00399152',NULL,NULL);
INSERT INTO italian_index VALUES ('lichene','n#09283301',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tramonto','n#05471927 n#10887892',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fisioterapista','n#07474623',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('visore','n#03577424',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('centinodia','n#08435242',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coreggiola','n#08435242',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('correggiola','n#08435242',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('made_in_italy','n#N0001099',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tangeri','n#06551095',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intellettuale','n#07116625 n#06949872 n#07319346 n#07235934',NULL,'a#02679427',NULL);
INSERT INTO italian_index VALUES ('calamintha_nepeta','n#09141928',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mentuccia_comune','n#09141928',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nepetella','n#09141928',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tradimento','n#00482966 n#00545187',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('condominio','n#02485591 n#05977551',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('schiavina','n#02382258',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deflettore','n#02552564 n#02236216 n#02694691',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cardamine_pratensis','n#08189931',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('billeri_dei_prati','n#08189931',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giustificazione','n#00806644 n#04485374 n#05051677',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('appennini','n#06708349',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mobiliere','n#N0001204 n#N0001203',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riapparizione','n#05457728 n#00027678',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricomparsa','n#05457728 n#00027678',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('evaporazione','n#00142497 n#09738922',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('evaporizzazione','n#00142497',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vaporazione','n#00142497',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vaporizzazione','n#00142497',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('volatilizzazione','n#00142497',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('volatizzazione','n#00142497',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('neutralizzazione','n#00152626 n#00151882',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corniciatura','n#N0000477',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incorniciatura','n#N0000477',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attrezzista','n#07506514',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trovarobe','n#07506514',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quadro_a_olio','n#03054912',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('freddo','n#04422784 n#03916773',NULL,'a#01206050 a#01199751 a#02407953',NULL);
INSERT INTO italian_index VALUES ('corsia','n#02322833 n#W0005546 n#02176672 n#02905606 n#02392360',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cardiospasmo','n#00147358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malaria','n#10133011',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paludismo','n#10133011',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vertebra','n#04101439',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tessuto','n#04087702 n#02656657',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cucchiaiata','n#09917014 n#09917137',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canestro','n#09912572 n#02259850 n#02260127 n#02789725 n#00125430',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cesta','n#09912572 n#02259850 n#02789725',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cesto','n#09912572 n#09422689 n#02259850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panierata','n#09912572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zana','n#09912572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barilotto','n#09915161 n#02884820',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barilozzo','n#09915161 n#02884820',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affrancatura','n#05090163',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affrancazione','n#05090163',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('francatura','n#05090163',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('francobollo','n#05090163',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('finestrino','n#03160086 n#03620585',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oblò','n#03160086',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portellino','n#03160086',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piromane','n#07384803 n#07084582',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orlo','n#03992861 n#02815349 n#06314081',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fachiro','n#07255047',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('menyanthes_trifoliata','n#08786230',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trifoglio_fibrino','n#08786230',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alluvionato','n#N0000044',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salernitano','n#N0001763',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ingegneria_genetica','n#04662428',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('culex_pipiens','n#01706275',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zanzara','n#01706275 n#01704520',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('potassio','n#10497589',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polveriera','n#02953252',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dollaro_delle_bahamas','n#09834923',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('novena','n#N0001297',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elitra','n#01660924',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marocco','n#06550542',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stilton','n#05882750',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leishmaniosi','n#10193399',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('politica','n#04991678 n#04536028 n#04673837 n#09971476',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('retaggio','n#00051119 n#04382865 n#03851000',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raggio','n#03387543 n#06357451 n#09993912 n#07777807',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('medio','n#04313488',NULL,'a#00454025 a#01537375 a#01468318',NULL);
INSERT INTO italian_index VALUES ('eccezionalità','n#03754011',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('favolosità','n#03754011',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incredibilità','n#03754011',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pianta','n#W0021217 n#00008864 n#04321299 n#03368346 n#03136211 n#W0021218',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assetto','n#09960471 n#10399952 n#10087814',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sessa','n#05473712',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rampicante','n#01111718 n#09394860 n#09394711',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rdt','n#N0001751',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('repubblica_democratica_tedesca','n#N0001751',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cremeria','n#02998349',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gelateria','n#02998349',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pasticceria','n#02998349',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pasticcieria','n#02998349',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abdicazione','n#05414215',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dimissioni','n#05414215',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('evento','n#00017297 n#07796465',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('medicatura','n#00445646',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('medicazione','n#00445646 n#02601205',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('direttore','n#07673310 n#07175013 n#07063762',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guardia_carceraria','n#07673310 n#07673430',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arcione','n#03155059 n#03265433',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('previdenza_sociale','n#00704970',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pensilina','n#N0001425 n#N0001426',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tettoia','n#N0001425',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aspic','n#05842226',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('campata','n#N0000254',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('enfatizzazione','n#00820686',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inammissibilità','n#03761574',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('shock','n#10127330 n#05583116',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pettine','n#01478216 n#02474534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sultanato','n#06506698',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('curatore','n#07063319 n#07234892 n#07653395',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('curatore_testamentario','n#07063319',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('turnista','n#N0002182',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abies_alba','n#07939054',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abete_bianco','n#07939054 n#07938536',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ritmo','n#10978422 n#03948875 n#10980504 n#05302217 n#03744098',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eccitabilità','n#04372474',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('irritabilità','n#04372474 n#05614842 n#03661040',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('redditometro','n#N0002673',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carpentiere','n#07140967 n#07571382 n#07142149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falegname','n#07140967 n#07686896',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rottame','n#10349114 n#N0001744',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('curva_sud','n#W0020917',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stilizzazione','n#00751146',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('motovedetta','n#03096751 n#N0001245',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vedetta','n#03096751',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alito','n#07780815 n#00535804 n#07827653 n#10646827',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soffio','n#07780815',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('simpatico','n#04265233',NULL,'a#02264719 a#02766678',NULL);
INSERT INTO italian_index VALUES ('sopraelevata','n#N0001930 n#02407205',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soprelevata','n#N0001930',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canarino','n#01055943 n#01056085',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prisma','n#03174157',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('emolliente','n#02554391 n#02517559',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('thylacinus_cynocephalus','n#01400450',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lupo_marsupiale_della_tasmania','n#01400450',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tilacino','n#01400450',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cordoncino','n#02898925 n#02328855',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('laccio','n#02898925 n#03360120 n#04495302 n#03323271',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('legaccio','n#02898925 n#02599409',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stringa','n#02898925 n#05261517',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('feluca','n#02464333 n#02670359',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('felis_ocreata','n#01634599',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gatto_domestico','n#01634599 n#01630921',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lecca_lecca','n#05658038',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leccalecca','n#05658038',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('a.t.','n#04851992',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antico_testamento','n#04851992',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vecchio_testamento','n#04851992',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavolo_rapa','n#05770365',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trespolo','n#03537430',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('angiologia','n#04625381',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bimbetto','n#07643338',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cristianesimo','n#04717211 n#06024128',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('respirazione','n#00532749',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('respiro','n#00532749 n#00535804 n#10646827 n#10365084',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foce','n#06728126',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfocio','n#06728126',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bocca','n#06728126 n#04115581 n#03020602 n#06797465 n#07421720 n#02779712 n#04115147',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbocco','n#06728126',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cabina_telefonica','n#03478790',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('notazione','n#05098604 n#00238852 n#05067694',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sistema_di_notazione','n#05098604',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sistema_notazionale','n#05098604',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('televisione','n#03482557 n#04745188',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tele','n#03482557 n#04745188',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('televisore','n#03482557',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anthemis_tinctoria','n#08231089',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camomilla_per_tintori','n#08231089',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alternativa','n#04463475',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('opzione','n#04463475',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scelta','n#04463475 n#04462889 n#00105760 n#00104850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('febbre_tifoidea','n#10173328',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tifoidea','n#10173328',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veronica_arvensis','n#09188464',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veronica_dei_campi','n#09188464',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('albero','n#09396070 n#09031560 n#02970751 n#03255317',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('burocrate','n#07130169',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disidratazione','n#10113757',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incidenza','n#09959028',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coscienza','n#03799909 n#04389032 n#05580137 n#03800085 n#04386907 n#06664059 n#04387608',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panico','n#05591377 n#08441869 n#10337390',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('terrore','n#05591377 n#05590260',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('taboga','n#03351837 n#03511044',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('toboga','n#03351837 n#03511044',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pemmican','n#05708507',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('area_della_sterlina','n#06163463',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aerotecnica','n#04661442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('argonauta_argo','n#01482911',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('argonauta','n#01482911 n#06930081',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abitudine','n#00265102 n#04382516 n#00265920 n#00263204',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('consuetudine','n#00265102 n#04382516 n#04906050',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('costume','n#00265102 n#02505744 n#04382516 n#00265920 n#03455370 n#02505567',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prammatica','n#00265102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rito','n#00265102 n#00663366 n#05539741 n#00664709',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('usanza','n#00265102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('osmerus_eperlanus','n#02033413',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sperlano','n#02033413 n#05832997',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maldicenza','n#05039384 n#00792102 n#05394812',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barca_da_pesca','n#03357011',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('hermes','n#N0002520',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canalone','n#06710488',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foggia','n#04500633 n#N0002404',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('collegamento','n#04734393 n#10345982 n#09931077 n#02488140',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('posta','n#09607916 n#04736420',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('puntata','n#09607916 n#04966736',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scommessa','n#09607916',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('posta_in_gioco','n#09607916',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammorbidente','n#02485262',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('osservazione','n#00565102 n#05385605 n#04412315 n#00647699 n#05068616 n#05033972',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malta','n#06548480 n#10731399 n#06548319',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pranzo_conviviale','n#06128171',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('genuinità','n#03756011 n#03755242 n#03753317 n#05584398 n#10056100',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('naturalezza','n#03756011 n#03845743 n#03755242',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('naturalità','n#03756011',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spontaneità','n#03756011',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ptialina','n#10565204',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cognata','n#07580416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cicatrizzazione','n#09718860',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('saldamento','n#09718860',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ipotenusa','n#10014749',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('liberalizzazione','n#00228800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chietino','n#07332358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dissimulatore','n#07332358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('finto','n#07332358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ipocrita','n#07332358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('simulatore','n#07332358 n#03339956',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tartufo','n#07332358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cervelletto','n#04253310',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sciacquio','n#05472404',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammaraggio','n#00198146 n#00028670',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cartina_al_tornasole','n#02932828 n#10721659',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('femminilità','n#03678753 n#03678976',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('femminino','n#03678753',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acceleratore','n#02159201 n#02158929',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('busta-paga','n#09653388 n#09557499',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('busta_paga','n#09653388 n#09557499',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('documento','n#09653388 n#09653682 n#04890442 n#04859637 n#02585552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aerospazio','n#06272005',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spazio_aereo','n#06272005',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavallo','n#W0021215 n#02894296 n#W0021214 n#02832547 n#01875414 n#09809762',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('undicenne','n#N0002199',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rimpallo','n#N0001720',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('castrato','n#01908966 n#07142669 n#05710038',NULL,'a#02061182',NULL);
INSERT INTO italian_index VALUES ('elettrostatica','n#N0000635',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('appellativo','n#04781345 n#05039644 n#04780372 n#04778525',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soprannome','n#04781345 n#04780372',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('beqquadro','n#05138406',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bequadro','n#05138406',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attributo','n#00018604',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('algesimetria','n#00644750',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('algometria','n#00644750',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pasta_asciutta','n#05739733',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pastasciutta','n#05739733',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('batista','n#02370768 n#02265035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('battista','n#02370768 n#02265035 n#07101139',NULL,'a#02724053',NULL);
INSERT INTO italian_index VALUES ('conurbazione','n#06295295',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('noce','n#08621903 n#08621666 n#05806712',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vetraio','n#07292150 n#07292260 n#07292487',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lavoratore_temporaneo','n#07635636',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('temporaneo','n#07635636',NULL,'a#01691661',NULL);
INSERT INTO italian_index VALUES ('fecondazione_artificiale','n#W0020970 n#00542492',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cittadella','n#03431121 n#02163780 n#02262475',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piazza_forte','n#03431121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piazzaforte','n#03431121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rocca','n#03431121 n#02716224 n#02581564',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rocca_forte','n#03431121 n#02716224',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('roccaforte','n#03431121 n#02716224',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('destino','n#07769986 n#05462231',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sorte','n#07769986 n#05462231',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fortuna','n#07769986 n#10383516 n#09628697 n#10382416 n#07770258',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('miriametro','n#09823050',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impudicizia','n#00475782 n#03839110',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palm-top','n#N0002275',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('morbo','n#10162587 n#05531449 n#10129713',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gamma','n#05130350 n#03993027 n#05117929 n#04734266',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vassallaggio','n#10084523 n#10084106 n#10084274',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('separabilità','n#10345035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prussiano','n#07050343',NULL,'a#02845695',NULL);
INSERT INTO italian_index VALUES ('borghese','n#07132046 n#07158529 n#07122697',NULL,'a#00256309',NULL);
INSERT INTO italian_index VALUES ('sarcolemma','n#04214893',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palla_da_tennis','n#03484961',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caligine','n#07818537 n#10610760 n#10413162 n#07799541',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foschia','n#07818537 n#07805661 n#04393348',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nebbia','n#07818537 n#09278211 n#07799541',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nebbiolina','n#07818537',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('muro_di_confine','n#03092141',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('muro_divisorio','n#03092141',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('muro_di_divisorio','n#03092141',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alterazione','n#07767320 n#00483936 n#10393286 n#00131083 n#05441797 n#00255854 n#00491849 n#10335051',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cambiamento','n#07767320 n#00125689 n#09984639 n#00131083 n#05441797 n#00255854',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accusato','n#07059160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('convenuto','n#07059160 n#04466733',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giudicabile','n#07059160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imputato','n#07059160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incriminato','n#07059160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prevenuto','n#07059160',NULL,'a#00221675',NULL);
INSERT INTO italian_index VALUES ('querelato','n#07059160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('echinus_esculentus','n#01821675',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riccio_di_mare','n#01821675 n#01821462',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riccio_marino','n#01821675',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arcata','n#02206091 n#02205153 n#04320709 n#00063957 n#02205453',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esperimento_pilota','n#04469067',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('miglio','n#08442496 n#09815270',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bestia_da_soma','n#00863295',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giumento','n#00863295',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('animale_da_soma','n#00863295',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lisp','n#05166205',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tavolo','n#03461269 n#03461955',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tavola','n#03461269 n#06138367 n#10836071 n#02302683 n#03140950',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zambiano','n#07052841',NULL,'a#02866738',NULL);
INSERT INTO italian_index VALUES ('concittadino','n#07646228',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('terrazzano','n#07646228',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lungofiume','n#06800750',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('glottocronologia','n#04678441',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teleostei','n#02020580',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indice_beta','n#N0002657',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('folletto','n#06893321 n#06892899 n#07335090',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mercurialis_annua','n#09221597',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mercorella_comune','n#09221597',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dizionario_etimologico','n#04838350',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vocabolario_etimologico','n#04838350',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('matrice_scalare','n#06139718',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('meritocrazia','n#N0001166',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esclamazione','n#05331777 n#05332162 n#05314709',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antropoide','n#01965691',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autoimmunità','n#10419484',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricognitore','n#N0001710',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ortaggio','n#08517232 n#05748390',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('verdura','n#08517232',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bancarottiere','n#07100847',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fallito','n#07100847 n#07268912',NULL,'a#02222066',NULL);
INSERT INTO italian_index VALUES ('casino','n#00044751 n#05502027 n#04395081 n#10402349 n#03615214 n#09922518',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diritto_alla_felicità','n#04035908',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quadrimestre','n#N0001625 n#N0001624',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decaffeinato','n#05940726',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caffè_decaffeinato','n#05940726',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caffè_deca','n#05940726',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deca','n#05940726',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('physeter_catodon','n#01578765',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('physeter_macrophalus','n#01578765',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capidoglio','n#01578765',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capodoglio','n#01578765',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fisetere','n#01578765',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disdegno','n#05577544',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dispregio','n#05577544',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disprezzo','n#05577544',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sdegno','n#05577544 n#05037154 n#05588960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chinotto','n#09008346',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('balaenoptera_acutorostrata','n#01576948',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('balenottera-minore','n#01576948',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eremita','n#07526888 n#07526997 n#07317783 n#01498320',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macedonia','n#05841473 n#05637093 n#06516647',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('boxe','n#00282787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pugilato','n#00282787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acquerello','n#03595573 n#03595448',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('consumista','n#N0000449',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brontosauro','n#01230170',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tuberosità','n#04293397',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_delle_filippine','n#09855109',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imbeccata','n#05260480 n#05409138',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mania','n#05565534 n#04403919 n#10326765 n#06661976 n#10314601',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('s.p.a.','n#06083970',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spa','n#06083970',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panteon','n#03084912',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pantheon','n#03084912',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crioidrato','n#10450785',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eutettico','n#10450785',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sudan','n#06585975',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dermacentor_variabilis','n#01298156',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zecca_del_cane','n#01298156',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vescica_natatoria','n#01962753',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('protozoo','n#00916896',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esortazione','n#05341679 n#05409013',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('invito','n#05341679 n#00103904 n#05371036',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammazzatoio','n#02156186',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mattatoio','n#02156186',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scannatoio','n#02156186',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('blocco_motore','n#02639911',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monoblocco','n#02639911',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('turbine','n#07848713',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vortice','n#07848713',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dattilo','n#05308005',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prolissità','n#05304498',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbrodolamento','n#05304498',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbrodolatura','n#05304498',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('verbosità','n#05304498',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pastura','n#00539647',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strisciamento','n#00539647 n#00191288',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arenaria_serpyllifolia','n#08117492',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arenaria_serpillifolia','n#08117492',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('superattico','n#03105753',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canfora','n#10608270',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erigeron_acer','n#08273579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cespica_acre','n#08273579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('messa_cantata','n#00674244',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('messa_solenne','n#00674244',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfoltita','n#N0001877',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('situation_comedy','n#05263511 n#05263166',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trincea','n#03536539',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('luogo','n#04824319 n#06279834 n#00462982 n#06367294 n#00014887',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coltivazione','n#00588408',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tequila','n#05928944',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('neutralista','n#07430985',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affermazione','n#00020977 n#05045355 n#05045783 n#05382066',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attuamento','n#00020977',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attuazione','n#00020977 n#00729882',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('concretizzazione','n#00020977',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('implementation','n#00020977',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rendimento','n#00020977 n#09540718 n#00587304 n#00378579 n#09956992',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cubetto','n#10027013',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('casella','n#03393616 n#10002522 n#02530626',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scacco','n#03393616 n#02427508',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('casa','n#03393616 n#02618194 n#02837386 n#06021037 n#05976600 n#06262813 n#06008236 n#06393436',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aliante','n#02757129',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veleggiatore','n#02757129',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cichorium_endivia','n#08261004',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('endivia','n#08261004',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indivia','n#08261004',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scariola','n#08261004 n#05768426 n#08295009',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scarola','n#08261004 n#05768426 n#08295009',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_del_malawi','n#09845626',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iponimo','n#04757794',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('subordinato','n#04757794 n#07619562',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('galbula','n#01359899',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arco','n#10013595 n#09996119 n#04320709 n#02320783 n#10860372 n#02205453 n#10890324',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('evidenza','n#04983467 n#04485976 n#03780381',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prova','n#04983467 n#05048107 n#05378329 n#04469208 n#04485976 n#00576606 n#00508046 n#00503611 n#04486494',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riva','n#06801063 n#06801422 n#06800223 n#06801748',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sponda','n#06801063',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('martes_pennanti','n#01946669',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('martora_di_pennant','n#01946669',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('papilloma','n#10234612',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corrente_a_getto','n#07808356',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('efficienza','n#09954508 n#04365365',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bangladesh','n#06490404',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bisnipote','n#07301234',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pronipote','n#07301234',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pulsar','n#06764584',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sessanta','n#09901389',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ornitologo','n#07448660',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interfaccia','n#04934365 n#02862795',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('concordato','n#05073898 n#05074858 n#05072418 n#05365792',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frutta','n#09423815',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frutto','n#09423815 n#05440251',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crosta','n#06779132 n#02546515 n#04086690',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indigenza','n#10397595',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('miseria','n#10397595 n#03988043 n#05601051 n#10397492 n#10397144 n#04483642 n#10366675 n#08906612',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accidia','n#03657503 n#03657239 n#00489770',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('infingardaggine','n#03657503',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('neghittosità','n#03657503',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pigrizia','n#03657503 n#03657239 n#03656520',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('poltronaggine','n#03657503 n#03657239 n#00489770',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('poltroneria','n#03657503 n#03657239 n#00489770',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('udibilità','n#03919628',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cola','n#08502477',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('condizione','n#10035141 n#05072928 n#05062525 n#10032130 n#05062190 n#04485138',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('situazione','n#10035141 n#10034299',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vocale','n#05324546 n#05322484',NULL,'a#02621097 a#02621257',NULL);
INSERT INTO italian_index VALUES ('palloncino','n#02243663',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavatorsoli','n#N0000323',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rompighiaccio','n#02847143 n#02846167',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('metonimia','n#05318526',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attraversamento','n#02864766',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bivio','n#02864766 n#04394411 n#04445909',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crocevia','n#02864766',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crocicchio','n#02864766',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incrocio','n#02864766 n#00546649 n#06301980 n#04445909 n#00102506 n#00870405',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('benemerenza','n#03771292 n#04003707',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('petardo','n#03109986 n#02684570',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mescolamento','n#00244416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mescolanza','n#00244416 n#05491211 n#10449119 n#05491579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mescolata','n#00244416 n#00218172',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mescolatura','n#00244416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('miscelatura','n#00244416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('miscelazione','n#00244416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('balia','n#07677919 n#04045518',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nutrice','n#07677919',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('andamento','n#00182418 n#06390652 n#04698745',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avanzamento','n#00182418 n#00159874 n#00159609 n#05480347',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avanzata','n#00182418 n#05489950',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tre','n#09895854',NULL,'a#02099122',NULL);
INSERT INTO italian_index VALUES ('3','n#09895854',NULL,'a#02099122',NULL);
INSERT INTO italian_index VALUES ('alfabetismo','n#04361525',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('il_saper_leggere_e_scrivere','n#04361525',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('talamo','n#N0002069 n#09419736',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corda','n#09996239 n#02499699 n#03429004 n#03252883 n#02927117',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('purificatoio','n#N0001604',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('limonata_amara','n#05947220',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raffigurazione','n#03229963 n#04447804',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raggio_infrarosso','n#07807882',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radiazione_infrarossa','n#07807882',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('luce_infrarossa','n#07807882',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mer.','n#10883142',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('merc.','n#10883142',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mercoledì','n#10883142',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('evasione_fiscale','n#00477691',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mezzo_da_sbarco','n#02904045',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clinico','n#07160983',NULL,'a#02668079',NULL);
INSERT INTO italian_index VALUES ('preposizione','n#04772195',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frullo','n#00110371 n#05507766',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('discarico','n#05052012',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('commissario_di_bordo','n#07512903',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sizigia','n#07842509',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conchiglia_di_ostrica','n#01419582',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pelo','n#03122681 n#01414637 n#01414164 n#03869698 n#04079965',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fondo_svalutazione','n#09628010',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avviso','n#04564824 n#05056012 n#05002688 n#05079660 n#05003120 n#05388537 n#05395080 n#05056776',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('opinione','n#04564824 n#04706473',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parere','n#04564824 n#05002688','v#01505258 v#01461214 v#01460069',NULL,NULL);
INSERT INTO italian_index VALUES ('laccio_emostatico','n#02481265',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gran_bretagna','n#06494850 n#06495315',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diciassettenne','n#N0000556',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cornetto_acustico','n#02810064',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('art.','n#04819775',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iodoformio','n#02865914',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teologia','n#04690672',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scandaglio','n#00648528 n#02914405',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('schiacciata','n#00373026',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('torino','n#06465327',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('to','n#06465327',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vertebrato','n#00995974',NULL,'a#02389958',NULL);
INSERT INTO italian_index VALUES ('dislivello','n#05483545 n#03733407',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acetosella','n#09002636',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ossalide','n#09002636',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pitagora','n#07750043',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rifornimento','n#09625793 n#00051225 n#00684444 n#09922407 n#09626009',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('padre_della_chiesa','n#07156378',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cappelletto','n#05740667',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tortellini','n#05740667',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tortellino','n#05740667',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piffero','n#03129680 n#02675842',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('visigoto','n#07667913',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('desertificazione','n#N0000551',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dispersione','n#00237382 n#05463669 n#00237068',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sparpagliamento','n#00237382 n#05463669 n#00237068',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cenacolo','n#06117365 n#00668619',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiesuola','n#06117365 n#02290498',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('consorteria','n#06117365',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conventicola','n#06117365',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_israeliana','n#09863681',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ritorno','n#00027910 n#05538316',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_ugandese','n#09864725',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('data_di_nascita','n#10957449',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('natale','n#10957449 n#10912064',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attitudine','n#04696462 n#04355442 n#04354000 n#04355649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('punto_di_vista','n#04696462 n#04706473 n#04707108',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('periferia','n#10019310 n#06306119 n#06294952',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('età','n#10955750 n#10850510 n#03853114 n#W0021168 n#10869347 n#10868596',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('generazione','n#10955750 n#06196326 n#06195881',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('visiera','n#02288518 n#03580974',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('epoca','n#10850510 n#10988653 n#10955141 n#10988451 n#10954919',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('duetto','n#05279455',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ranch','n#03211863',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('storico','n#07321477',NULL,'a#02720062 a#02695970',NULL);
INSERT INTO italian_index VALUES ('storiografo','n#07321477',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corsa','n#00471384 n#00190535 n#05544480 n#00284852',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aprile','n#10923938',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbreviazione','n#00230790 n#00230622 n#05305918',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dado','n#02542204 n#03048408 n#02566690 n#05843926',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('plinto','n#02542204 n#03100005',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('curie','n#09810363',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biotite','n#10514002',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('einaudi','n#N0002498',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calosoma_scrutator','n#01673404',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avulsione','n#00246736',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elisio','n#06314352',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eliso','n#06314352',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decadentismo','n#N0000523',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agente','n#07441239 n#07067167 n#07485319 n#10597048 n#07529131 n#07066862',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orientale','n#06965564',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('p._l.','n#04905639',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('naturista','n#07436317 n#07428232 n#07245672',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nudista','n#07436317',NULL,'a#02751634',NULL);
INSERT INTO italian_index VALUES ('mocio_vileda','n#03451869',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tacito','n#N0002184',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('philaenus_spumarius','n#01761373',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sputacchina','n#01761373',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('numero_di_ottani','n#09759033',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('miele','n#05887861',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vestito_da_sera','n#02573170',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perfetto','n#09943184',NULL,'a#01686285',NULL);
INSERT INTO italian_index VALUES ('prova_su_strada','n#04469920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('istituto_di_credito_speciale','n#N0002750',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alluvione','n#09921122 n#06695274 n#05513579 n#07796648',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diluvio','n#09921122 n#07830909',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('profluvio','n#09921122',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scarica','n#09921122 n#05448024 n#00637131',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('valanga','n#09921122',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ottimista','n#07446011',NULL,'a#01604600',NULL);
INSERT INTO italian_index VALUES ('cygnus_atratus','n#01376809',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cigno_nero','n#01376809',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falco','n#01133146 n#01127903 n#07311054',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falcone','n#01133146',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maggiolino','n#01669942 n#01680093',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apparatore','n#07657738',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tappezziere','n#07657738',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pupa','n#01814863 n#01814089',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mala_parata','n#10427326',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malaparata','n#10427326',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pericolo','n#10427326 n#10427605 n#10428324 n#00512734',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guardia_notturna','n#N0001174',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('metronotte','n#N0001174 n#07433339',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carrettiere','n#07141865',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carrettaio','n#07141865 n#07142149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barocciaio','n#07141865',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barrocciaio','n#07141865',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('birocciaio','n#07141865',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cameriera','n#07387889 n#07671746 n#07147268',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('donna','n#07387889 n#03195765 n#07684780 n#07222606 n#03195684 n#07685959',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('domestica','n#07387889',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('donna_di_servizio','n#07387889',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fantesca','n#07387889',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('digitale','n#09180551',NULL,'a#02589597',NULL);
INSERT INTO italian_index VALUES ('bambino_prodigio','n#07124318 n#07686424',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('all''erta','n#10108105',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('allerta','n#10108105',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('preallarme','n#10108105 n#05003120 n#05395080',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('verso_libero','n#04809777',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giocoliere','n#07351691',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stecca','n#04308673 n#02531561',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('porta','n#02588950 n#06708950 n#02758894 n#W0021182 n#02591205 n#02862795 n#04035000 n#W0021183',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('occhio_magico','n#03100968',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spia','n#03100968 n#07338772 n#07603319 n#07262320',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spioncino','n#03100968',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('infantilismo','n#00476218 n#10407097 n#03856888',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('torrione','n#02488702',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('propedeutica','n#N0001591',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nunzio','n#07437400',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pederastia','n#00550448',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antheraea_pernyi','n#01807221',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rivoltoso','n#07401774 n#07341493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bisessuale','n#07113845',NULL,'a#01152489',NULL);
INSERT INTO italian_index VALUES ('bisex','n#07113845',NULL,'a#01152489',NULL);
INSERT INTO italian_index VALUES ('acqua','n#W0021112 n#W0021111 n#10650211 n#W0021110 n#06666185 n#10651368 n#07830260',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('botta','n#05443053 n#10259769 n#00086415 n#05515315 n#05468143 n#10260024 n#05492247 n#05070533 n#05515143',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('torneo','n#05549454 n#05555846',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('columbio','n#10494363',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('obbligazione_a_capitalizzazione_integrale','n#09606130',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('obbligazione_scuponata','n#09606130',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('obbligazione_senza_cedola','n#09606130',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('obbligazione_zero-coupon','n#09606130',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('distributore_automatico','n#03570436',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('specchietto','n#N0001958 n#02791975',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lituano','n#05208220',NULL,'a#02731329',NULL);
INSERT INTO italian_index VALUES ('lupo_di_mare','n#07396425',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('navigante','n#07396425',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incendio','n#05444579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rogo','n#05444579 n#05971194',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fuoco','n#05444579 n#10647499 n#05561864 n#00635718 n#09686541 n#02355821 n#07797250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fustella','n#N0000804',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bisca','n#02735821',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biscazza','n#02735821',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arancia','n#05783752',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portogallo','n#05783752 n#06558391',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cambio_sincronizzato','n#03458582',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ottantenne','n#07438845',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ottuagenario','n#07438845',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inesistenza','n#10058190',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('insussistenza','n#10058190',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dakar','n#06565668',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('enunciazione','n#00601482',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('formulazione','n#00601482',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('estroversione','n#03646431',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('allegrone','n#07350149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baione','n#07350149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('beffatore','n#07350149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('beffeggiatore','n#07350149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bell''umore','n#07350149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bello_spirito','n#07350149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bellospirito','n#07350149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bellumore','n#07350149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bontempone','n#07350149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buffone','n#07350149 n#07347950 n#07161854 n#07162052',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buontempone','n#07350149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('burlatore','n#07350149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('burlone','n#07350149 n#07493431',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('celiatore','n#07350149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giocherellone','n#07350149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giovialone','n#07350149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giullare','n#07350149 n#07347950 n#07413198 n#07162052',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mattacchione','n#07350149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mattaccino','n#07350149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mattacino','n#07350149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pazzerellone','n#07350149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('protele','n#01627385',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impurità','n#10393063 n#10448138',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gnocchi','n#N0002367',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('requisitoria','n#N0001695',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('battibaleno','n#10953874',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frazione_di_secondo','n#10953874',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('istante','n#10953874 n#10952516 n#10848639 n#06940043 n#10953688',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marina','n#06801422 n#06345702 n#06089894 n#03293597',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riva_del_mare','n#06801422',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eruzione','n#05532185 n#10278373 n#10091255',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ipoderma','n#01411835',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('muleta','n#N0001253',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('austriaco','n#07006710',NULL,'a#02729885',NULL);
INSERT INTO italian_index VALUES ('additivo','n#02165931',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('roba_da_stirare','n#02867844',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('società','n#06107600 n#06022330 n#06007068 n#06007961 n#05973283',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chewing-gum','n#05652708',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gomma_americana','n#05652708',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gomma_da_masticare','n#05652708',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('first_lady','n#07265527',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paterasso','n#02234948',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paterazzo','n#02234948',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tendine_del_ginocchio','n#04316506',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imposta_graduale','n#N0002772',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dossale','n#02180600',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('planococcus_citri','n#01754941',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cocciniglia_farinosa','n#01754941',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giocatore_di_bocce','n#07122828',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dettaglio','n#09946426 n#04481751 n#05340304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('razione','n#09562389 n#05621640 n#05631178',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('hawaii','n#06610437 n#06609732',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antimilitarismo','n#05385605',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('obbiezione','n#05385605 n#05409439',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('obiezione','n#05385605 n#05409439',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('replica','n#05385605 n#05470763 n#00657820 n#05380350 n#03229727 n#05055491',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fisarmonica','n#02160825',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trasferimento','n#00718494 n#00718330 n#00132095',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lealista','n#07383615',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mente','n#06949872 n#04345975 n#04588594 n#04351370 n#07288630 n#07411717 n#04444887',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intersezione','n#05991790',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('graduatoria_finale','n#04875135',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rosa_dei_candidati','n#04875135',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rosa','n#04875135 n#08920236 n#03885630 n#03254390 n#03370794',NULL,'a#00362144 a#02598470',NULL);
INSERT INTO italian_index VALUES ('eterozigote','n#N0000673',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anaerobio','n#00870273',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anerobio','n#00870273',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macramè','n#02952973',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frenata','n#N0000777',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colamento','n#05529326',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gocciolamento','n#05529326',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gocciolatura','n#05529326',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gocciolio','n#05529326',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sgocciolamento','n#05529326',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sgocciolio','n#05529326',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stillamento','n#05529326',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stillicidio','n#05529326',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rivalutazione','n#04429107 n#00234364',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incandescenza','n#07806737 n#03919458',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('analfabetismo','n#04368888',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quartetto_d''archi','n#06122257',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('datore_di_lavoro','n#07241412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('titolare','n#07241412 n#07451379 n#07451666','v#00342505','a#00806435',NULL);
INSERT INTO italian_index VALUES ('calzatura','n#02712266 n#02711988',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('equus_asinus','n#01888155 n#01887170',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asino_domestico','n#01888155',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macabro','n#N0001090',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('casseretto','n#03157049',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sacre_scritture','n#04846415',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esame_emocromocitometrico','n#00426726',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('squalus_acanthias','n#01017562',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spinarolo','n#01017562',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stanza_di_malato','n#03333645',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pesapersone','n#N0001443',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corrosività','n#N0000483',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gioielli_della_corona','n#02526273',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavatappi','n#02501723',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavaturaccioli','n#02501723',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tirabusciò','n#02501723',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sorbus_domestica','n#08958637',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sorbo_comune','n#08958637',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sorbolo','n#08958637',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inibizione','n#00692957 n#03825629',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cystopteris_fragilis','n#09480912',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('felcetta_fragile','n#09480912',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brama','n#03868401 n#00966989 n#05565891 n#03790984',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esosità','n#03868401',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ingordigia','n#03868401',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('settimana','n#W0021187 n#W0021185 n#10888430 n#10862128 n#W0021186',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('liceo','n#06218671',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lazo','n#02908600',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clementina','n#09009987 n#05784424 n#09010106',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('secchia','n#N0002294 n#09915634 n#02344831',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('allocuzione','n#05404801',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arringa','n#05404801',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indirizzo','n#05404801 n#05083171 n#04792458 n#06263815 n#06390652 n#04698745',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orazione','n#05404801 n#05407248',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('best_seller','n#04832805',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('best-seller','n#04832805',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('normandia','n#06533214',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('duemila','n#N0000615',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiusa','n#10966461 n#02638575 n#04822648 n#05438448 n#03356658 n#03356809 n#03596238 n#02936580',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiusura','n#10966461 n#04822648 n#00181920 n#10966797 n#02667713 n#00220085 n#00148822 n#05478207 n#02936009 n#05438121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('finale','n#10966461 n#05438448 n#10966797 n#05278374 n#05478207 n#05478779',NULL,'a#01523143 a#00958252 a#01522227',NULL);
INSERT INTO italian_index VALUES ('bacinella','n#09912474 n#02259535',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bacino','n#09912474 n#06283651 n#06780036 n#02259535 n#04337001 n#02585224 n#06378285',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catino','n#09912474 n#02259535',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oculare','n#02656337',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('basket','n#00306597',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pallacanestro','n#00306597',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palla_canestro','n#00306597',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('basketball','n#00306597',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tulio','n#10504620',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('punta_di_petto','n#05701406',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pubblico','n#06103694 n#06103316 n#06079949 n#05972960',NULL,'a#00460814 a#01790261',NULL);
INSERT INTO italian_index VALUES ('rivista','n#05266046 n#04947827 n#04948875 n#05265552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palco_scenico','n#03397314',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palcoscenico','n#03397314',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palco','n#03397314 n#02223097 n#02324723',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('casa_commerciale','n#N0002682',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carnosità','n#03906306',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sciattona','n#07583315 n#05671539',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('genericismo','n#03736960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('genericità','n#03736960 n#03782315',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impersonalità','n#03736960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indefinitezza','n#03736960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indeterminatezza','n#03736960 n#03782315',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbrigatività','n#03736960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sommarietà','n#03736960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sala_da_concerti','n#02483977',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corrente_continua','n#07790907',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teoria','n#04569663 n#04526699 n#04592375',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('collaborazione','n#00264082 n#00779286 n#00504440 n#00780822',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cooperazione','n#00264082 n#00779286',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('casellante','n#07643543',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rotazione','n#05535152 n#00219234 n#00652141',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biglietto','n#04892853 n#09647041 n#04970828 n#10616396 n#W0021170 n#04971341',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dritto','n#02894644 n#03051767',NULL,NULL,'r#00050567 r#00056323');
INSERT INTO italian_index VALUES ('finocchio','n#09236378 n#07254887',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cigno','n#01375485 n#01375081 n#01375546',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cigno_femmina','n#01375485',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('suocero','n#07258856',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('neopositivismo','n#04592983',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('positivismo','n#04592983',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frattura_esposta','n#10261847',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gocciolatoio','n#N0000859',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sortilegio','n#04586055',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stregoneria','n#04586055',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('depilazione','n#N0000545',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bronzo','n#10552050 n#02342693',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gara_di_canottaggio','n#05545307',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('regata','n#05545307 n#05551776',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baionetta','n#02268139',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('saponata','n#N0001778 n#06803300',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dovere','n#00731811 n#00461585','v#01857688 v#01862782 v#01858275 v#01542388 v#01857799 v#01858069',NULL,NULL);
INSERT INTO italian_index VALUES ('obbligo','n#00731811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('responsabilità','n#00731811 n#03679828',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('debito','n#00731811 n#09649911 n#10395421',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crescione','n#05769702 n#08178847 n#08200957',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decreto_legge','n#W0020844',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dopodomani','n#N0000597',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('muratore','n#07126120',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('haydn','n#07724716',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('franz_joseph_haydn','n#07724716',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prosaicità','n#03762583',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incomprensione','n#04473723 n#04531479',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('razza','n#01024872 n#06037572 n#06037015 n#07594053 n#05974106 n#06045417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giappone','n#06519251',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elettrotecnica','n#04663074',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('galvanotecnica','n#04663074',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eliminazione','n#00253361 n#00253227 n#00055579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ermeneutica','n#04691231',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nuova_zelanda','n#06551873 n#06552025',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fonte','n#03372354 n#06275985 n#06792829 n#06276361 n#05005140 n#04493168',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piatto','n#09914065 n#09915947 n#05632416 n#02825985 n#02576928 n#03139880',NULL,'a#00864501',NULL);
INSERT INTO italian_index VALUES ('protio','n#07301441',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prozio','n#07301441',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('messina','n#06462640',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('materiale','n#04799150 n#02644452 n#02973327 n#04977814 n#10446867',NULL,'a#00591892 a#02454328',NULL);
INSERT INTO italian_index VALUES ('semibreve','n#05141439',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('serenità','n#05587497 n#05570169',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('evirato','n#07142669',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bidone_della_spazzatura','n#02215885',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pattumiera','n#02215885',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carovana','n#06233475 n#06124859 n#06224732',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gas','n#10388113 n#10734355 n#10671811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_araba','n#09834520',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catalpa','n#09113138',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trampolino','n#03345597 n#02584544 n#03391054',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('operando','n#04508586',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lychnis_flos-cuculi','n#08122342',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crotonella_fior_di_cuculo','n#08122342',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clono','n#10136162',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fulmarus_glacialis','n#01571770',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fulmaro','n#01571770',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frittata','n#05874333',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('omelette','n#05874333',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calceolaria','n#09177327',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giorno','n#10866312 n#10878116 n#10958298 n#10878282 n#10862286 n#10883946 n#10921306 n#10851114 n#10876395',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tenebra','n#10075077',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bravaccio','n#07129318 n#07625729 n#07124422',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bravazzo','n#07129318 n#07625729 n#07124422',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bullo','n#07129318 n#07645228 n#07615333',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bulo','n#07129318 n#07645228 n#07615333',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teppista','n#07129318 n#07325293',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indumento_intimo','n#03559646',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mendelismo','n#04651061',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pantaloni_a_zampa_d''elefante','n#02278492',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oscurità','n#10073287 n#03781615 n#10074921 n#10073561 n#10442294',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oscuro','n#10073287',NULL,'a#00400770',NULL);
INSERT INTO italian_index VALUES ('turbo','n#10073287',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nobel','n#05425157',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('premio_nobel','n#05425157',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('liquido_seminale','n#04199602',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sborra','n#04199602',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seme','n#04199602 n#09424502 n#03438999',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sperma','n#04199602',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('umanista','n#07329725 n#07329866',NULL,'a#02576037',NULL);
INSERT INTO italian_index VALUES ('luridume','n#10401319 n#10399165',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agrigento','n#N0002375',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ag','n#N0002375',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('itinerario','n#06348591 n#04539082',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('percorso','n#06348591',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palpitazione','n#10304532',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palpitazioni','n#10304532',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tachicardia','n#10304532',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tridacna_gigas','n#01471915',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tripoli','n#06543967 n#06542883',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alcanna','n#10756311',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('enna','n#10756311 n#N0002402',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('henna','n#10756311',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('henné','n#10756311',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assicurazione_sulla_vita','n#09610108',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assicurazione_vita','n#09610108',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('persefone','n#06914252',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cerapteryx_graminis','n#01798797',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dissolvenza_in_apertura','n#N0000587',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cantante_melodico','n#07194631',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giorno_civile','n#10878116',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cynoglossum_officinale','n#09117634',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lingua-di-cane_vellutina','n#09117634',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ortofonia','n#00453915',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tempismo','n#N0002090',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salsa_di_mirtilli','n#05856470',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pelliccia_di_visone','n#03003494',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('podiceps_nigricollis','n#01562241',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('svasso_piccolo','n#01562241',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cassetta_di_sicurezza','n#02399989 n#03266694',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cofanetto','n#02399989',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('martingala','n#02968825',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('blitz','n#00628019 n#00629177',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('muscovite','n#10525347',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('norimberga','n#06445884',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baratto','n#00755465 n#00719653',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scambio','n#00755465 n#00366105 n#00719653 n#03456338',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sterolo','n#10804608',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piattaforma_girevole','n#03554170',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lunatico','n#N0001081',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giudea','n#N0000887',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('loggia','n#03571958 n#06113724 n#02939650',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veranda','n#03571958 n#03158198',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('schermidore','n#07260842',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('schermitore','n#07260842',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spadaccino','n#07260842',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cognizione','n#00013243 n#04046299',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conoscenza','n#00013243 n#07180689 n#10037654 n#04473075 n#04386907',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('episteme','n#00013243',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('la_spezia','n#N0002412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sp','n#N0002412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('merceria','n#03046147',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iettatore','n#07350407',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('jettatore','n#07350407',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('menagramo','n#07350407',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pseudonimo','n#04781090 n#04780733 n#04781008',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('olonimo','n#04758077',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comunicando','n#07171689',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sproporzione','n#10015456',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ampliamento','n#05362177 n#09730422 n#00235235 n#00261237',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rum','n#05928118',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('setter','n#01610827',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cd-rom','n#02408548',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('centro','n#02412359 n#02412996 n#00084365 n#06298647 n#04546812 n#06286659 n#06280000 n#06285699',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affrancatrice','n#02720993 n#03162167',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impresa_di_riassicurazione','n#N0002701',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('distaccamento','n#06097572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piantatore','n#07480247',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('confessore','n#07176267 n#07176161',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('epidemiologo','n#07246160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('creditore','n#07192423',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('laudano','n#02910700',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panna_da_montare','n#05878876 n#05879105',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricchezza','n#09614312 n#10395016 n#10396488 n#03987430 n#03986878 n#10396003 n#09534064',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('censo','n#09614312 n#00427077 n#09534283',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sonchus_oleraceus','n#08326356',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asclepiade','n#08326356 n#09518882',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grespino_comune','n#08326356',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('torpidezza','n#10094429 n#03657083',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('torpore','n#10094429',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('provincialità','n#04704272',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sanguine','n#09243836',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('modello','n#07416028 n#04527384 n#04559362 n#04560561 n#04549495 n#04554317 n#03007566 n#00577745 n#00263204 n#04501544 n#04560437 n#07415419 n#07415674 n#04496504',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impalcatura','n#03279313 n#03860008',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ponteggio','n#03279313',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('armatura','n#03279313 n#03860008 n#02210404 n#01418098 n#02307258 n#03603259 n#03240500',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('castello','n#03279313 n#02402089',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incastellatura','n#03279313',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('liquame','n#10656399 n#N0001063',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giostra','n#02389659 n#05555979',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apprendistato','n#00387618',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('angoscia','n#05593817 n#10367071 n#05593480',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('angustia','n#05593817 n#10367071 n#10397144 n#05572909 n#04001927',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('patema','n#05593817',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seicento','n#N0001850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cresta','n#01310180 n#00869601 n#06301604 n#06726208',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stalattite','n#06738619',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('meccanico','n#07092754',NULL,'a#01439518',NULL);
INSERT INTO italian_index VALUES ('ostacolo','n#04396893 n#02841559 n#04395690 n#02453702 n#03435130 n#04396152 n#03051325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avorio','n#03878065 n#10578609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diligenza','n#03682241 n#03812111 n#03397795',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scrupolosità','n#03682241 n#03681984',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zelo','n#03682241 n#05562060',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pneumatorace','n#N0001499',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pneumotorace','n#N0001499',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('genoma','n#04221080',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('atto_collettivo','n#00698797',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intervento','n#00804778 n#00800467 n#00436664 n#00805766 n#04995117',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coinvolgimento','n#00804778 n#09932591',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('partecipazione','n#00804778',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('circolo_di_golf','n#06109661',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mazza_da_golf','n#06109661 n#02761380 n#07228506',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('viceconsole','n#N0002239',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cane_maggiore','n#06775119',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('viaggio_per_mare','n#00203046',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('goleador','n#N0000860',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('duecento','n#N0000614',NULL,'a#W0003183',NULL);
INSERT INTO italian_index VALUES ('rotella_dello_sperone','n#03258404',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fertilizzazione','n#05530598',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('confluenza','n#06297988 n#00244814',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciottolo','n#06697027 n#02463102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incitamento','n#06660574',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spinta','n#06660574 n#00071795 n#00072619 n#00065905 n#07827878',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sprone','n#06660574',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stimolo','n#06660574 n#04488721',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cucitrice','n#03402655 n#07567791',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('graffatrice','n#03402655',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pinzatrice','n#03402655',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spillatrice','n#03402655',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bancarella','n#03399509',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bancherella','n#03399509',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stand','n#03399509',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('subentro','n#00050836',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catone','n#N0000354',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chinina','n#03197001',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chinino','n#03197001',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baldacchino','n#02377924 n#02240271',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piezometro','n#03121560',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pasqua_delle_rose','n#10950411',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pasqua_rosata','n#10950411',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pasquarosa','n#10950411',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pentecoste','n#10950411 n#10913026',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pasqua_rosa','n#10950411',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oppiomane','n#07445164',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interludio','n#00335706 n#N0000987',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intermezzo','n#00335706 n#05278516',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiore','n#W0021144 n#W0021146 n#07986022 n#07986542 n#04945821 n#06205749',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reminiscenza','n#04445071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('minigolf','n#N0001192 n#00298099',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pallina_di_naftalina','n#03016317',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiosa','n#N0001554 n#05053784',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('postilla','n#N0001554',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canoista','n#07137617',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('socrate','n#07757575',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capocuoco','n#N0000273',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oceanografo','n#07438718',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('midollo_osseo','n#05900756 n#04102587',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiaroscuro','n#02428956',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maggioranza','n#03991218 n#09760262 n#W0020907',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('labbro_leporino','n#10214774',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fittone','n#09416162',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radice_principale','n#09416162',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tappeto_da_preghiera','n#03169228',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('minestra','n#05638174',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zuppa','n#05638174 n#10798023',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sebastopoli','n#06577333',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arseniato','n#10465442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('passione','n#04478900 n#03651126 n#05567643 n#05567241 n#05608042 n#05561474',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('flamenco','n#00343242',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avamposto','n#03067539',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cotonificio','n#02507532',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cantieristica','n#00586357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('costruzione_navale','n#00586357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indicizzazione','n#00515662',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('viola_canina','n#08692032',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('viola_selvatica','n#08692032',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ipervitaminosi','n#10205871',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('don','n#07222387 n#07258439',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falda','n#02339474 n#06376325 n#07836155 n#02815349',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tesa','n#02339474',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('safari','n#00201036',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('meridione','n#09965063',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sud','n#09965063 n#06596424 n#06596872',NULL,'a#01544456',NULL);
INSERT INTO italian_index VALUES ('picchiettio','n#05505515 n#05506384',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piegaciglia','n#N0001465',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pianigiano','n#07479656',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bisaccaride','n#10643329',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disaccaride','n#10643329',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('legalità','n#03773617 n#03773420',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('legittimità','n#03773617',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piano_di_studi','n#05005867',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corso_di_studi','n#05005867',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corso_di_studio','n#05005867',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('programma_di_studi','n#05005867',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('programma_di_studio','n#05005867 n#W0003039',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filmato','n#N0000746',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('videoclip','n#N0000746',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ladreria','n#00499179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ladrocinio','n#00499179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ladroneccio','n#00499179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('latrocinio','n#00499179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mangeria','n#00499179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pappata','n#00499179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ruba','n#00499179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rubamento','n#00499179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ruberia','n#00499179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fondatore','n#07276210',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iniziatore','n#07276210 n#07340845',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('padre_fondatore','n#07276210',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('passato','n#04777321 n#10866655 n#10849142',NULL,'a#02839797 a#01664341',NULL);
INSERT INTO italian_index VALUES ('carboncino','n#02423294 n#02423181',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gravame','n#09653118 n#04491717',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('misantropo','n#07413575',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lessicologia','n#04688678',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ambiente','n#06325667 n#06316112 n#06315687 n#10409788 n#10410497 n#10410402 n#10040804 n#03250788',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('habitat','n#06325667',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('adorazione','n#00790677 n#05576115 n#00664071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('appartamento_in_condominio','n#02485760',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('yankee','n#07431368 n#07435404 n#07048883',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('normalità','n#10402913',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('china','n#08963576 n#06725397 n#08964482 n#06724958',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sigla_musicale','n#05271060',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('descrizione','n#05381542 n#05042407 n#05380994',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falciamento','n#N0000702',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falciatura','n#N0000702 n#N0000703',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mietitura','n#N0000702 n#N0000703 n#00591789',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('olanda','n#06536741',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paesi_bassi','n#06536741',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('concistorio','n#06178243',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('concistoro','n#06178243',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fermione','n#06677022',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('refrigerazione','n#09740944',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('discordia','n#00758285 n#10070254 n#05368405 n#05368274 n#05369724',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eleocharis_acicularis','n#08459801',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giunchina_aghiforme','n#08459801',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sommozzatore','n#07582488 n#07219602 n#07206507',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sub','n#07582488',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('subacqueo','n#07582488',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('distrofia','n#N0000590',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colonia','n#06444669 n#05989951 n#05989847 n#02472080 n#06197924',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calzante','n#03323171',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calzascarpe','n#03323171',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calzatoio','n#03323171',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tascata','n#09916043',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('critica','n#05032854 n#00791599 n#04831383 n#04426783',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammobiliamento','n#02729950',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arredamento','n#02729950 n#00401341 n#02729592',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mobilia','n#02729950',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mobilio','n#02729950',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mobile','n#02729950 n#06021380',NULL,'a#01459945',NULL);
INSERT INTO italian_index VALUES ('segnapunti','n#07552794 n#04884055',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banderese','n#07358831',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('addestramento','n#00574902 n#00574678 n#00186660',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('allenamento','n#00574902 n#00574678',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esercitazione','n#00574902',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zeugma','n#05319528',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ordinativo_estero','n#04902781',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diga','n#02543705',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assortimento','n#06210851',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('varietà','n#06210851 n#03732812 n#06211160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rispondenza','n#10064507 n#03708023',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aggancio','n#07180689 n#02510482',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amicizia','n#07180689 n#10038317',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('condotta','n#03835766 n#03130263 n#00792210 n#03129019 n#00735486',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spinacia_oleracea','n#08145982',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spinace','n#08145982',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spinacio','n#08145982',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spinacio_comune','n#08145982',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lisimachia','n#08402257',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clavicola','n#04093460',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pressione_del_sangue','n#07778884',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pressione_sanguigna','n#07778884',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('saxifraga_aizoides','n#09091885',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sassifraga_gialla','n#09091885',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coalizione','n#06155266 n#06075573',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('schieramento','n#06155266',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monocolo','n#03012098',NULL,'a#00906686',NULL);
INSERT INTO italian_index VALUES ('caramella','n#03012098 n#05650208',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('galletta','n#05736172',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cartografo','n#07141953',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mappatore','n#07141953',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carreggiata','n#10011882 n#03245327 n#02392360',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rotaia','n#10011882',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('retrocucina','n#03290317',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('minorca','n#N0001266',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quiete','n#05587339 n#03893757',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pinzette','n#N0001478',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ripescaggio','n#N0001723',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carbonile','n#10607890',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('atrofia','n#10306568 n#05455221',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deperimento','n#10306568 n#09731479 n#03907274 n#10441344',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trasudazione','n#05529233',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tempo_libero','n#10863399',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('padrigno','n#07610439',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('patrigno','n#07610439',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paris_quadrifolia','n#08771070',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('uva_di_volpe','n#08771070',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('regressione','n#04613673 n#05384105 n#09723191',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('appendiabiti','n#02827974 n#02461775',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arpione','n#02827974 n#02819675 n#02800736 n#03097925 n#03378225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gancio','n#02827974 n#09992230 n#00088090',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antimilitarista','n#07224274',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('irenista','n#07224274',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pacifista','n#07224274 n#07452394',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('errore_di_sistema','n#04941908',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('allacciatura','n#00096382 n#00095872 n#00097058',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('legatura','n#00096382 n#00400568 n#03019252 n#02929916 n#02923244 n#00097058 n#05137875',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('silo','n#03338727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('faccenda','n#00461778 n#10047614 n#04384343',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incarico','n#00461778 n#00462982 n#00385376 n#00471060',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incombente','n#00461778',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incombenza','n#00461778 n#00471060',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mansione','n#00461778',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unghia','n#01662053 n#01664273 n#04324786',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zoccolo','n#01662053 n#02453803 n#02258436 n#03100005',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('potamogeton_crispus','n#08916304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brasca_increspata','n#08916304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('typha_latifolia','n#08461666',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lisca_a_foglie_larghe','n#08461666',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mazzasorda','n#08461666',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imposta_progressiva','n#09585262',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autismo','n#04532324',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fusto','n#03308527 n#07616904 n#09418962 n#09450405 n#04298694 n#02253645 n#03309644 n#02610531',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('endovena','n#00208670',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('endovenosa','n#00208670',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiaroveggenza','n#05415785',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('percezione_extrasensoriale','n#05415785',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('areca','n#08884439',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dondolio','n#00211534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oscillazione','n#00211534 n#03745861',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('traballio','n#00211534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disco','n#09996479 n#02955026 n#02576622 n#03184774',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('segretario_dei_ds','n#Y0005586',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rimprovero','n#05035921 n#05034645 n#05035082 n#05033972',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('emersione','n#00034867 n#00027781',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pennello_da_barba','n#03310968',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('confederazione_elvetica','n#06587357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('svizzera','n#06587357',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('concentramento','n#03970585',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fittezza','n#03970585',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foltezza','n#03970585',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spessezza','n#03970585',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corollario','n#04456898 n#05440088',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbronzamento','n#10260783',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbronzatura','n#10260783',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tintarella','n#10260783',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pelliccia','n#02728682 n#10584548 n#01414164 n#06672286 n#02728611',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bufera','n#07803078 n#10069810 n#07802377',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('burrasca','n#07803078 n#10069810 n#07842673',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fortunale','n#07803078 n#N0000767',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tempesta','n#07803078 n#10069810',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('temporale','n#07803078 n#07843377',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('m','n#09902316',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('migliaio','n#09902316',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mille','n#09902316',NULL,'a#02102663',NULL);
INSERT INTO italian_index VALUES ('autolavaggio','n#N0000108 n#N0000109',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mohicano','n#06981863',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moicano','n#06981863',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lenone','n#07477156',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('magnaccia','n#07477156 n#07290158',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paraninfo','n#07477156 n#07399704',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zirconio','n#10508059',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indennizzo','n#09566341 n#09566876 n#00166954',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indennità','n#09566341 n#09571263 n#09566876 n#09551881 n#09568609 n#09565721',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compensazione','n#09566341 n#09559232 n#00166954',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rifusione','n#09566341 n#09559232 n#00727086 n#09565721',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('probabilità','n#03736155 n#03973089 n#03736278',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fase','n#10387350 n#10983365 n#10044643 n#03684912',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trascendentalità','n#N0002147',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parrocchiano','n#07457364',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vitiligine','n#10225668',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autoassicurazione','n#09609534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gemelli','n#W0020909',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('policlinico_gemelli','n#W0020909',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cesoie','n#03311608',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trancia','n#03311608',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tranciatrice','n#03311608',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forbici_da_tosatore','n#03311608',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('longarone','n#N0001069',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('longherone','n#N0001069',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lungherone','n#N0001069',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lione','n#06534125',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('liutista','n#07385092',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('delatore','n#07338772',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('informatore','n#07338772 n#07338656',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sicofante','n#07338772',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('costo_marginale','n#04008887',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('battiti_del_cuore','n#05508389',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palpito','n#05508389 n#05508979',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polso','n#05508389 n#03928353 n#02531825 n#04327322',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pulsazione','n#05508389 n#05522821 n#05508979',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polyprion_americanus','n#02058612',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cernia_di_fondale','n#02058612',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gnomone','n#02758757',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barcaiolo','n#07116921 n#07260933',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('battellante','n#07116921',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('battelliere','n#07116921',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('navalestro','n#07116921',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('navicellaio','n#07116921',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('navichiere','n#07116921',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('navichiero','n#07116921',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('passatore','n#07116921',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('traghettatore','n#07116921 n#07260933',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gondola','n#03027722 n#02762525',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('epagneul','n#01611535',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zodiaco','n#03641944 n#06392984',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('olandese','n#05212625 n#07023235',NULL,'a#02729490',NULL);
INSERT INTO italian_index VALUES ('calamaio','n#02856972 n#02857610',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rampa','n#03211047 n#02698064',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('manovra','n#00615775 n#00109256 n#00033506',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gluteo','n#04315957',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cartuccia','n#03223449 n#02394559 n#02394984',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('atomica','n#02220668',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bomba_a','n#02220668',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bomba_atomica','n#02220668',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prospettiva','n#04706473 n#10389567 n#04564355 n#04707108',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('visione','n#04706473 n#04448837 n#05436224 n#00566440 n#04373072 n#04555855',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('essenza','n#04953751 n#10842002 n#04546812 n#10683804',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('armamento','n#02208998 n#03601456 n#00749390',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dieta','n#06169147 n#05617971 n#05618089 n#00692553',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('schiettezza','n#03813867 n#03849689',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moretto','n#07475558',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('negretto','n#07475558',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amaretto','n#05682570',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lythrum_hyssopifolia','n#08632050',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salcerella_con_foglie_d''issopo','n#08632050',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catarro','n#10290523',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scesa','n#10290523',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vento_moderato','n#07781311',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bastimento','n#02389043 n#03574037 n#03318070 n#09920939',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prefetto','n#07494308',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('audioleso','n#07204757',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('non_udente','n#07204757',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sordastro','n#07204757',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sordo','n#07204757',NULL,'a#02176106 a#00647484 a#02175566',NULL);
INSERT INTO italian_index VALUES ('a.f.','n#03948032',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alta_frequenza','n#03948032',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trazione','n#N0002153',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('patrimonio','n#04382865 n#09528888 n#09534283 n#03851300',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moscerino','n#01707421 n#07232039',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moscherino','n#01707421 n#07232039',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moschino','n#01707421',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moscino','n#01707421',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('distruttore','n#07213561',NULL,'a#00552895',NULL);
INSERT INTO italian_index VALUES ('accomodamento','n#00126907 n#05072418 n#05365792',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tabella','n#06138367',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ottaedro','n#10027819',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idroaeroporto','n#N0000916',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idroporto','n#N0000916',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idroscalo','n#N0000916',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('artritico','n#N0000087',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accordi_di_camp_david','n#W0020821',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nitrato','n#10775251',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('illibatezza','n#10063030 n#03815181 n#10078596',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('verginità','n#10063030',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rapina_a_mano_armata','n#00499935',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grassazione','n#00499935',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('notaio','n#07435591',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('escudo','n#09839082 n#09838798',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('escudo_portoghese','n#09839082',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trenino','n#N0002158',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bancarotta','n#00767861 n#10386165 n#10385774',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fallimento','n#00767861 n#05454021 n#00038702 n#10386165',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compostezza','n#03839746 n#03836634',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('placidità','n#03839746 n#05587029',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bandiera_bianca','n#03613622',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('linea_di_touche','n#06374015',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('linea_laterale','n#06374015 n#06371515',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inciviltà','n#03848153 n#00270320 n#03847572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ondata','n#00234695 n#05534788 n#06249984 n#05475302 n#00221849',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pianificazione_urbana','n#00595364',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('urbanistica','n#00595364',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alnus_incana','n#08589353',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ontano_bianco','n#08589353',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capolino','n#09422689',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cespo','n#09422689',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avverbio','n#04767588 n#04770802',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('l.p.','n#02945458',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ellepi','n#02945458',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('long_play','n#02945458',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('long_playing','n#02945458',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('microsolco','n#02945458',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('recettività','n#03662705 n#10421816',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricettività','n#03662705 n#10421816',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('individuazione','n#04435723',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decentralizzazione','n#00803947',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decentramento','n#00803947',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dicentramento','n#00803947',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teiera','n#03475917',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sguattero','n#07218068',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('criniera','n#01415243',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('big','n#07112229 n#07312009',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pezzo_grosso','n#07112229',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clinker','n#02450402',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('angina','n#10190883 n#10300803',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('centaurea_solstitialis','n#08256677',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiordaliso_giallo','n#08256677',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('articolo_indeterminativo','n#04772044',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('articolo_indefinito','n#04772044',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('articolo_indeterminato','n#04772044',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('labda','n#05118784',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lambda','n#05118784',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disinfezione','n#00454901 n#00163198',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('surnia_ulula','n#01146135',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ulula','n#01146135',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aragosta','n#01494756 n#01496801 n#05827135',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('i.r.i.','n#N0002470',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('istituto_per_la_ricostruzione_industriale','n#N0002470',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iri','n#N0002470',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prioria','n#03174037',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mercato_al_rialzo','n#06017793',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mercato_dei_toro','n#06017793',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('identikit','n#02848205',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trentina','n#N0002161',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bertolli','n#N0002484',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iris_foetidissima','n#08715661',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giaggiolo_puzzolente','n#08715661',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tecnico','n#07633507',NULL,'a#01060035 a#02610113',NULL);
INSERT INTO italian_index VALUES ('didattica','n#N0000560 n#N0000559',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perfusione','n#00209307',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tenia','n#01441021',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('glottide','n#04114802',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aspettativa','n#10392226 n#04564355 n#10864475',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attesa','n#10392226 n#10970463 n#04564355 n#00688424',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ebanite','n#10770130',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cardinalato','n#00388186',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clangula_hyemalis','n#01370627',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moretta_codona','n#01370627',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sentiero','n#03096023 n#03584882',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('via','n#03096023 n#00112808 n#05086526 n#03426236 n#03243979',NULL,NULL,'r#00189796 r#00229375');
INSERT INTO italian_index VALUES ('viottolo','n#03096023',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teglia','n#N0002083',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('studio_oculistico','n#06003023',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('formaggera','n#N0000764',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('formaggiera','n#N0000764',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('luminare','n#07384250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('notabile','n#07384250',NULL,'a#00589115',NULL);
INSERT INTO italian_index VALUES ('notabilità','n#07384250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('personaggio_di_primo_piano','n#07384250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('praticante','n#07648153 n#07156542 n#07080687',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tirocinante','n#07648153 n#07080687',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('missile_teleguidato','n#02776739',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iniettore','n#N0000971',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('favella','n#04370255',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tiglio','n#08508037 n#09011616',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spiedino','n#03344475 n#05897501',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calystegia_sepium','n#09123419',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('campanelle','n#09123419',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vilucchio_bianco','n#09123419',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vilucchione','n#09123419',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acme','n#10045044 n#05520463',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apogeo','n#10045044 n#06267395 n#10983867',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('auge','n#10045044',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('top','n#10045044 n#03518480',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('presentazione','n#05156002 n#05359296 n#05391158 n#00336149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bingo','n#00324105',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tombola','n#00324105 n#00045686 n#00324290',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abilità_di_cavaliere','n#04360982',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('computer','n#02481557',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calcolatore','n#02481557 n#07135102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elaboratore','n#02481557',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calcolatore_elettronico','n#02481557',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cervello_elettronico','n#02481557',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('informatica','n#04663525 n#04669191',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attaccante','n#07275269 n#07616532 n#07090487',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avanti','n#07275269 n#00466114',NULL,NULL,'r#00072248 r#00058882');
INSERT INTO italian_index VALUES ('birreria','n#02335388 n#02178613',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fabbrica_di_birra','n#02335388',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('topografo','n#N0002122',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('redento','n#N0001685',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idrovolante','n#03293187',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('achille','n#06933291',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('persona_che_chiama','n#07135735',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canneroni_grandi','n#N0002356',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elefante','n#N0002356 n#01997527',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gigantoni','n#N0002356',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maniche','n#N0002356',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('occhi_di_bove','n#N0002356',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('occhi_di_elefante','n#N0002356',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tufoli','n#N0002356',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calciatore','n#07271874 n#N0000331 n#07353756',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giocatore_di_football_americano','n#07271874',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('auspicio','n#05435260 n#05435037 n#00787413',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immagazzinaggio','n#00239397',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immagazzinamento','n#00239397',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zappatura','n#N0000907',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nido','n#06845552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pesce','n#02005782 n#W0021181 n#05810856 n#07156174',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dama','n#07200414 n#03195765 n#07360983 n#00323017',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gentildonna','n#07200414',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('signora','n#07200414 n#07684780 n#07681693 n#W0021175 n#07361249 n#W0021177 n#07681186 n#W0021176',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accensione','n#02849030 n#09753841 n#00243625',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vandalo','n#07661340 n#07661237',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('telegramma','n#04967816',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fumarola','n#N0000793',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('istituto_superiore','n#06146495',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('istituto_universitario','n#06146495 n#06146304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('college','n#06146495 n#02470885 n#06146304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apparenza','n#00487065 n#05457551 n#03683012 n#03683672',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buca_del_suggeritore','n#03177733',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portascarpe','n#N0001543',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('econometria','n#04674879',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('econometrica','n#04674879',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('febbrone','n#10306292',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('febbre','n#10306292 n#10165886',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('titolo','n#09650851 n#04783598 n#00462982 n#10352475 n#04782793 n#04784828 n#09664211 n#04785265',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('titolo_di_credito','n#09650851',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calendola','n#08251077 n#08327826',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calendula','n#08251077 n#08327826',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calta','n#08251077',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immunità','n#10418829 n#N0000924',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('basilica_di_san_pietro','n#W0020900',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('san_pietro','n#W0020900 n#N0002315',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prenanthes_purpurea','n#08312450',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lattuga_montana','n#08312450',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('appoggio','n#04399253 n#00786967 n#02711144 n#00656795 n#03444976 n#00624734',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conferma','n#04399253 n#04486906',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tunica','n#04123138',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('atonalità','n#05136258',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dodecafonia','n#05136258',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bocciolo_di_rosa','n#07538334 n#07991443',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malizia','n#03795824 n#00111383 n#05613388',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buco_della_serratura','n#02887649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('serratura','n#02887649 n#02909019 n#02936009',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('toppa','n#02887649 n#03094749',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banderola','n#03601856 n#03603048 n#03105267',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banderuola','n#03601856 n#03603048 n#03105267 n#07445452',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compagno_di_scuola','n#07551158',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compagno_di_classe','n#07551158',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('demostene','n#07709742',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sinergia','n#09743770',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rifinitura','n#N0001713 n#N0000748 n#N0000749',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pira','n#05971194',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiancheggiamento','n#00786967',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('patrocinio','n#00786967 n#00787586',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('patronato','n#00786967 n#N0001402',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bulinista','n#02355492',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bulino','n#02355492',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rigenerazione','n#09697656',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ascoltatori','n#06104115 n#06103316',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('audience','n#06104115',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('annibale','n#07723723',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('noce_di_cocco','n#05808435',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cartismo','n#04571385',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('razionalismo','n#04577862 n#04583121 n#04694924',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fortran','n#05166631',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('primo_attore','n#07367301',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dentifricio','n#02555378 n#03518131',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('delinquente_minorenne','n#07207737',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cristo','n#N0000504 n#07731120',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mt','n#N0002423',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('matera','n#N0002423',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avallante','n#07303718',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fideiussore','n#07303718',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('garante','n#07303718',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mallevadore','n#07303718',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mallevatore','n#07303718',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('faccia','n#W0021164 n#04504775 n#03687137 n#06277648 n#03687456 n#06948078 n#W0021163 n#04340595',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arciduca','n#07230981',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('metacarpo','n#04334498',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fibula','n#04334810',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perone','n#04334810',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coagulo','n#04198040 n#05880817 n#10565306',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grumo','n#04198040',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('audiocassetta','n#02223451 n#02400775',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aderenza','n#07800957 n#10210377 n#03861527',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lavabottiglie','n#N0001031',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('regina','n#03195765 n#07515745 n#01815390 n#03195684 n#07516053 n#00966324',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gasterosteus_aculeatus','n#00981787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spinarello','n#00981787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sgombro','n#05816562 n#02114103 n#02113719',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sacerdotessa','n#07498013',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maori','n#05200805',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filamento','n#02677452 n#10663683',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buon_uomo','n#07569478',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buonuomo','n#07569478',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esasperazione','n#10337915 n#05589957 n#05589430 n#00271094 n#00240869',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colpo_di_calore','n#10208899',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affetto','n#05608483',NULL,'a#02421145',NULL);
INSERT INTO italian_index VALUES ('attaccamento','n#05608483 n#00786502 n#00095872 n#05608793',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bene','n#05608483 n#04019795 n#09528888 n#02476046 n#04005893',NULL,'a#00809143','r#00010099 r#00051724 r#00011647');
INSERT INTO italian_index VALUES ('autocoscienza','n#04387968',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rotocalco','n#05007325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rotocalcografia','n#05007325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fragilità','n#03935946 n#03864058 n#10431905 n#03937780',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carrozzino','n#03334360',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('motosidecar','n#03334360',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sidecar','n#03334360',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bagliore','n#03873344',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('balenio','n#03873344',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfolgorio','n#03873344 n#05516369',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vivezza','n#03873344 n#03655191',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reseda_luteola','n#08689120',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erba_guada','n#08689120',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reseda_biondella','n#08689120',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cicloide','n#10022811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trocoide','n#10022811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bollitura','n#09740233',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ebollizione','n#09740233',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ebullizione','n#09740233',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gas_nervino','n#10734853',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cordite','n#02500635 n#10291698',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comparsa','n#07597116 n#07672089 n#05457551',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('figurante','n#07597116',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('birra_scura','n#05915233',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('auditel','n#N0002560',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('società_per_la_raccolta_e_trasmissione_via_telefono_dei_dati_di_audience_televisiva','n#N0002560',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ankara','n#06591663',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gradinata','n#02698064 n#02298036 n#03400787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('saviezza','n#04350566 n#04349139',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scià','n#07568373',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('muda','n#09714251',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('muta','n#09714251 n#05989189 n#05982639',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impresa_di_assicurazione_vita','n#N0002696',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sanzione','n#05013621',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('old_economy','n#W0020866',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ultracentrifuga','n#03558300',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('recrudescenza','n#05531771',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('occupazione','n#00734472 n#00381958 n#10063469 n#00382316 n#00052883',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maiolica','n#02960811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salvelinus_fontinalis','n#02030691',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salmerino_di_fontana','n#02030691',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salmerino_di_fonte','n#02030691',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interazione','n#00022878 n#07840572 n#00023032',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giaccone','n#N0000836',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mensilità','n#N0001159',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mese','n#N0001159 n#W0021108 n#10919146 n#10922179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incisore','n#07243986',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intagliatore','n#07243986 n#07686686 n#07514893',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attaché','n#07090320',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dinosauro','n#01220530',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riempimento','n#00258215',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('luna-park','n#06266543',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('luna_park','n#06266543',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parco_dei_divertimenti','n#06266543',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bell''esemplare_d''epoca','n#03108136',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mago','n#07387193 n#07241790 n#07386755 n#07593404 n#07387307 n#07059467',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comprendonio','n#04350992',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intelligenza','n#04350992 n#05075890 n#04351370 n#04353391 n#04353158',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bancomat','n#N0000218 n#N0000219 n#09641408',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inquinante','n#10656784 n#10634101',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sostanza_inquinante','n#10656784',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stricnina','n#10550034',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('truppe_d''assalto','n#06143506',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aristocrazia','n#06206723 n#03775722 n#06205909',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nobiltà','n#06206723 n#10354378 n#06207059 n#06205909 n#03815621',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baviera','n#06444320',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('everest','n#06712573',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('investimento','n#09599330 n#00712429',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('craniologo','n#07474479',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frenologo','n#07474479',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filatoio','n#03384290 n#03384572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filiera','n#03384290',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iconoclastia','n#04586863',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('generosità','n#03787376 n#03788315 n#03788167 n#03788005',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('munificenza','n#03787376 n#03788167 n#03788005 n#00703445',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('durata','n#10859852 n#03943113 n#10859737',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cappuccino','n#05940941 n#01986122',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cappuccio','n#05940941 n#02380969',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('proibizionismo','n#04910954 n#10986610',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cane_di_prateria_dalla_coda_nera','n#01860755',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('entità','n#00001740 n#10045533',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ribes_nero','n#09104135 n#05780773',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ribes_nigrum','n#09104135',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nazionalizzazione','n#00746627',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('statalizzazione','n#00746627',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('statizzazione','n#00746627',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carpello','n#07993277',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radioisotopo','n#10472365',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('minuetto','n#05290226',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indaco','n#03885222 n#10754680 n#08836790',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pendaglio_da_forca','n#07283957',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vanificazione','n#00175342',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scuro','n#06367601 n#03332110',NULL,'a#00499767 a#00380983 a#00268709 a#00358571 a#01088903',NULL);
INSERT INTO italian_index VALUES ('boccaccia','n#05147387 n#07206606',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gestaccio','n#05147387',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('smorfia','n#05147387',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('versaccio','n#05147387 n#05332420',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ortoclasio','n#10662086',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ortose','n#10662086',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ortosio','n#10662086',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scala_di_corda','n#03253379',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('azero','n#07040908',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('didelphis_virginiana','n#01391318',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('opossum','n#01391318 n#01390933',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nomade','n#07433746 n#07672456',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coincidenza','n#05453327 n#00204953 n#03963322',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('combinazione','n#05453327 n#06197501 n#05971411',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acronimo','n#05306196',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sigla','n#05306196 n#05112048',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('appropriazione_indebita','n#00496188',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giberna','n#N0000840',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dictafono','n#02567771',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dittafono','n#02567771',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esperimento','n#00503375 n#04468129 n#00507777 n#00418704',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cediglia','n#05111092',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fontana','n#02717804 n#02718013 n#02717915',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('domino','n#00320194 n#02588630',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammoniacato','n#N0000052',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('danaus_plexippus','n#01782730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('farfalla_monarca','n#01782730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aster_linosyris','n#08241934',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('astro_spillo_d''oro','n#08241934',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('circonferenza','n#03979620 n#03979533',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('circuito','n#03979620 n#03199633 n#03199185 n#05544480 n#00721822',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiavetta','n#03619060 n#02377666 n#02506790 n#03420751',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corona_di_carica','n#03619060',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forsythia','n#08606544',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('otalgia','n#10282246',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pastore','n#07569918 n#07569027 n#07493768',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('neotoma_floridana','n#01841682',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lepomis_gibbosus','n#02053805',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('persico_sole','n#02053805',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('garetta','n#02776090',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('garitta','n#02776090',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guardiola','n#02776090',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canzone','n#05284501',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canzonetta','n#05284501',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('farmacologo','n#07472303',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catalogna','n#06585050',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sottoscala','n#N0001943 n#N0001944',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('resurrezione','n#00678641',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risurrezione','n#00678641',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('navicella','n#02385109 n#N0001273',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contesa','n#05369177 n#00758712',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disputa','n#05369177 n#05369860 n#05369415 n#05046324',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polemica','n#05369177 n#05369415',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('litigio','n#05369177 n#05369860 n#05369518',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('microsecondo','n#10945155',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zend','n#05229624',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coltrone','n#03196324',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imbottita','n#03196324',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strapunto','n#03196324',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fosfato','n#10751084',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capra_selvatica','n#01914127',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acqua_marina','n#10587894 n#03884705',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acquamarina','n#10587894 n#03884705',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deutsche_bank','n#W0020828',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scarpiera','n#N0001809',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eufemia','n#04954577',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eufemismo','n#04954577',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sonagliera','n#N0001924',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ceneraio','n#02216341',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cenerario','n#02216341',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cercopithecus_aethiops_pygerythrus','n#01979730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cercopiteco_verde','n#01979730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('botrychium_lunaria','n#09257534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('botrichio_lunaria','n#09257534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('kamikaze','n#02883364',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barlume','n#05516944',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiarore','n#05516944',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spiraglio','n#05516944',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alessia','n#10145692',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('demone','n#06893775',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('demonio','n#06893775 n#07418621 n#07059467',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('logico','n#07379907',NULL,'a#01373247 a#02379915',NULL);
INSERT INTO italian_index VALUES ('gambetto','n#00109013',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('modestia','n#03837747 n#03829724 n#05581180',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pudicizia','n#03837747',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pudore','n#03837747',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('verecondia','n#03837747',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imposta_relativa_agli_esercizi','n#N0002787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clarinetto','n#02446535',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clarino','n#02446535',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('verifica','n#00092615 n#04486906',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comicità','n#N0000412 n#N0000413',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ridicolo','n#N0000412',NULL,'a#01737913 a#02447138 a#00717534',NULL);
INSERT INTO italian_index VALUES ('acinesia','n#10137363',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('massicciata','n#02274031 n#03244591',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('infinitesimo','n#N0000966',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autodisciplina','n#03824129',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arbitrio','n#04371730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('volere','n#04371730','v#W0021094 v#00479841 v#01792695 v#00466852 v#W0021095 v#01245362 v#00479719 v#00545347',NULL,NULL);
INSERT INTO italian_index VALUES ('volontà','n#04371730 n#03809479 n#04589152',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricsciò','n#02877807',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risciò','n#02877807',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ponderatezza','n#03673891 n#04348442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riflessività','n#03673891',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('australiano','n#07006421 n#05202592',NULL,'a#02797712',NULL);
INSERT INTO italian_index VALUES ('zafferanone','n#08253732',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('light_pen','n#02925646',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('penna_luminosa','n#02925646',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('penna_ottica','n#02925646',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sala_macchine','n#02640186',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scarroccio','n#N0001810',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scacchiere','n#06369402',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('miopia','n#10435819',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dipartimento','n#06302563 n#06049069',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('effetto_doppler','n#07838216',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pastosità','n#03898172',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('loira','n#06823639',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dallas','n#06641632',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antisettico','n#02198087',NULL,'a#02040775',NULL);
INSERT INTO italian_index VALUES ('spolverata','n#N0001974 n#N0001975',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sveglia','n#02177460 n#00818293',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capra','n#01913145 n#03537559',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cordato','n#00990770',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tritone','n#01151783',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('egotismo','n#05581714',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ego','n#05581714 n#04347158',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('turdus_pilaris','n#01080820',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cesena','n#01080820 n#N0002406',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('metodo','n#04376254 n#00792210 n#04376863',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sistema','n#04376254 n#06239374 n#04423455 n#03459836 n#04067206 n#04536899 n#10750189 n#04377619',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gymnocarpium_robertianum','n#09482417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('felce_del_calcare','n#09482417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('civismo','n#N0000393',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autopubblica','n#02361877',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tassì','n#02361877',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('taxi','n#02361877',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buon_umore','n#10337064',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buonumore','n#10337064',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('propellente','n#10530871',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indecisione','n#03813132 n#04403239',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('irresolutezza','n#03813132 n#03812825',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('irresoluzione','n#03813132 n#04403239 n#03812825',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('irrisolutezza','n#03813132 n#03812825',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('irrisoluzione','n#03813132 n#04403239 n#03812825',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tentennamento','n#03813132 n#04403483',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tira_e_molla','n#03813132',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tiremmolla','n#03813132',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('titubanza','n#03813132 n#04403239',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amministrazione_fiduciaria','n#09620272',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pattinaggio_sul_ghiaccio','n#00284464',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pellegrinaggio','n#00202033',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caustico','n#10776541',NULL,'a#01730738 a#02000611 a#00553998',NULL);
INSERT INTO italian_index VALUES ('prodotto_caustico','n#10776541',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sostanza_caustica','n#10776541',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cronometro','n#02438052 n#03421005',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scala_celsius','n#09872259',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zampa','n#04308509 n#01935893 n#01661550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('messe','n#07767899 n#08448511 n#08450110',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavità_orale','n#04115581',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavo_orale','n#04115581',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('credit_suisse','n#W0020871',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nucleotide','n#10736751',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sterlina_cipriota','n#09855787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crudezza','n#03798131 n#03659222',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('epitelioma','n#10235638',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banditore','n#06940836 n#07645707',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bromuro','n#10603533',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('altorilievo','n#10013401',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cristianità','n#06024128',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agitatore','n#07068120 n#07506138 n#07548574 n#07208189',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arruffapopoli','n#07068120 n#07208189',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arruffapopolo','n#07068120',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('causatore','n#07068120',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eccitatore','n#07068120',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fomentatore','n#07068120 n#07340973',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perturbatore','n#07068120',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('provocatore','n#07068120',NULL,'a#01796064',NULL);
INSERT INTO italian_index VALUES ('sobillatore','n#07068120 n#07340973',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sovversivo','n#07068120 n#07532433',NULL,'a#02695147',NULL);
INSERT INTO italian_index VALUES ('rotula','n#04096637',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('basco','n#02282730 n#07007284 n#05224591',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bonetto','n#02282730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fibrina','n#10782977',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cosmotrone','n#02505415',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lattazione','n#09714786',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('digramma','n#05117158',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mantenimento','n#09625216 n#09624494 n#00517535 n#00788240 n#09560155',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ovariectomia','n#00442509',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contratto_a_premio_coperto','n#00048920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giovedì','n#10883253',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('terra_bruciata','n#W0021049',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apatura_iris','n#01781738',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('allodola','n#01050325 n#01050625',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('segretario','n#07556672 n#07556911 n#07525615',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('segretaria','n#07556672',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interlocutore','n#07341904',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammutinato','n#07341493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frondista','n#07341493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('insorto','n#07341493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ribelle','n#07341493',NULL,'a#01555193',NULL);
INSERT INTO italian_index VALUES ('sedizioso','n#07341493',NULL,'a#02695147',NULL);
INSERT INTO italian_index VALUES ('cattivo_funzionamento','n#05454384',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mezza_manica','n#07467546',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mezzamanica','n#07467546',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scribacchino','n#07467546 n#07306853',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imposta_sugli_acquisti','n#N0002792',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('emigrazione','n#05451289 n#00727594 n#00031327',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paganesimo','n#04716523',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scavatore','n#07216040',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('facoltà_di_giurisprudenza','n#06149385',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('facoltà_di_legge','n#06149385',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coperchio','n#02920866 n#03518706',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impatto','n#05468032 n#00102821 n#07768053',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cirsium_arvense','n#08261826',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cardo_campestre','n#08261826',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scardaccione','n#08261826',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stoppione','n#08261826 n#08251864',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('collina_morenica','n#06694860',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('georgia','n#06608879',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('drive_esterno','n#02654850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brulicame','n#05990071 n#06083600',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nugolo','n#05990071 n#06081960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sciame','n#05990071 n#06081960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('simpatizzante','n#07627913',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('supporter','n#07627913',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('uomo_rana','n#07219602',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ossido-riduzione','n#09685377',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ossidoriduzione','n#09685377',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stufa','n#02627706 n#03422792',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stufa_elettrica','n#02627706',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('algorismo','n#04502720 n#04598322',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('algoritmo','n#04502720 n#04598322',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ailanto','n#09016685 n#09016837',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('flatting','n#03315446',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('costola','n#04097129 n#04065902',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('uno_degli_adetti_ai_lavori','n#07340383',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('potamogale_velox','n#01410836',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orientamento','n#00681366 n#04388824 n#06390652',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orientazione','n#00681366',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('statuto_dei_lavoratori','n#W0005497',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ruminante','n#01896238',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pendolarismo','n#00204459',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pendolarità','n#00204459',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perdente','n#07381938',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vinto','n#07381938 n#07381843',NULL,'a#00659233',NULL);
INSERT INTO italian_index VALUES ('fucina','n#02714505',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('officina_del_fabbro','n#02714505',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('musetta','n#03044874',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sacchetta','n#03044874',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('privativa','n#03510886',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tabaccaio','n#03510886',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tabaccheria','n#03510886',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tabacchino','n#03510886',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('occhio_nero','n#10259923',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giocatore','n#07480903 n#07284131',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('usbecco','n#05190612 n#07042018',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('usbeco','n#05190612 n#07042018',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gamella','n#N0000815 n#02989609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gavetta','n#N0000815',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portavivande','n#N0000815',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('civetta','n#01143120 n#01144032 n#07184121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gufo','n#01143120',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('epiglottide','n#04114991',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('servizio_da_tavola','n#03303697',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('passivo','n#09941109 n#09655306 n#09656133',NULL,'a#00043399',NULL);
INSERT INTO italian_index VALUES ('appetibilità','n#03691562 n#04005625',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avvenenza','n#03691562',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('estetica','n#03691562 n#04680421 n#03689966',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pisello','n#08860492 n#08860821 n#04280037',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dermatologo','n#07211749',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('commutazione','n#04915649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ablazione','n#09691329 n#00252436',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antitossina','n#10785642',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ardesia','n#10537243',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lavagna','n#10537243 n#02294665',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tv','n#04745188 n#N0002456',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tivvù','n#04745188',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tivù','n#04745188',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('espressionismo','n#02653538 n#06253539',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buffata','n#07827653',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buffo','n#07827653',NULL,'a#02738909 a#01847441',NULL);
INSERT INTO italian_index VALUES ('riviera','n#03597250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anacoreta','n#07526997',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contemplativo','n#07526997',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('romito','n#07526997',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('debugging','n#N0002280',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marabù','n#01515214',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('silicato','n#10790792',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('posto_di_comando','n#02475506',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('termite','n#01726999',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caldirola','n#N0002488',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caldirola_spa','n#N0002488',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('destriere','n#01879301 n#01879091 n#01879397',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('destriero','n#01879301 n#01879091 n#01879397',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('afrodite','n#06902559',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('figi','n#06448913 n#06448380',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bison_bonasus','n#01907656',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bisonte','n#01907656 n#01907269',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('uro','n#01907656 n#01902076',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('optional','n#N0001326',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('faggio_rosso','n#08565985',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('non_pertinenza','n#09934755',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('metallo','n#10476248',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dattiloscritto','n#04817493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decolonizzazione','n#00700959',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antistaminico','n#02195275',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bushel','n#09792857 n#09791137',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('staio','n#09792857 n#02357289',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bicromia','n#N0000155 n#N0000156',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('litografia','n#05008461 n#05007911 n#02932722',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('offset','n#05008461',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stampa_offset','n#05008461',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stampa_in_offset','n#05008461',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scopata','n#00161640 n#00543107',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scopatura','n#00161640 n#10656657',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erpetologo','n#07317902',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carcharhinus_limbatus','n#01013683',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pinna_nera_minore','n#01013683',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('squalo_orlato','n#01013683',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('squalo_pinne_nere','n#01013683',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inclinazione','n#03956088 n#03956710 n#03866867 n#10008091 n#05573609 n#03955797 n#03867407 n#06724958',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pendenza','n#03956088 n#06724958',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bilancio_di_verifica','n#09659783',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raganella','n#01165723 n#01171370',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('checca','n#07254887',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frocio','n#07254887',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('culattone','n#07254887',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('astigmatismo','n#10043771 n#10436192',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agriturismo','n#N0000035 n#N0000036 n#N0000034',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intraducibilità','n#N0000997',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panonychus_ulmi','n#01301197',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ragnetto_rosso','n#01301197',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carta_da_giornale','n#10735031',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cinquantenario','n#N0000378',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asteria','n#01819703',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stella_di_mare','n#01819703',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stella_marina','n#01819703',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('petasites_hybridus','n#08309891',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('farfaraccio','n#08309891',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('farfaraccio_maggiore','n#08309891',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pinus_mugo','n#07929890',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pino_mugo','n#07929890',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('propugnazione','n#00787171',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decagramma','n#09880546',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tossina','n#10788297',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leandro','n#08084960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oleandro','n#08084960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filo_di_scozia','n#02932115',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colibrì','n#01350661',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accasciamento','n#10392521',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('demoralizzazione','n#10392521 n#05603599',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sconforto','n#10392521 n#05606636',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scoraggiamento','n#10392521',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('specificità','n#03740382',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('genio','n#07629692 n#06895394 n#07288630 n#04355649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ingegno','n#07629692 n#03718929 n#07288630 n#07411717',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('combinazione_di_colori','n#05971736',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prosodia','n#04685863',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tavola_rotonda','n#05344413',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orecchio','n#04374489 n#04128276 n#04130612',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scapellotto','n#00086311',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aranciata','n#05945862 n#05944417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lamento_funebre','n#05286621',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nenia','n#05286621',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('requiem','n#05286621 n#05274336',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dardo','n#02545362',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malus_sylvestris','n#08934791',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('melo_selvatico','n#08934791 n#08934045',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piccolo_tamburo','n#03360643',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spazio_bianco','n#04817735',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reticolato','n#02771524 n#02249871',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('egoismo','n#03789602 n#03789939',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('settore','n#05973622 n#10410497 n#04596100 n#04506101',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('onnipresenza','n#10057352',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ubiquità','n#10057352',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('flauto_diritto','n#02682842',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('flauto_dolce','n#02682842',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('argilla','n#10627806 n#10626993',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ufo','n#04533027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disco_volante','n#04533027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oggetto_volante_non_identificato','n#04533027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aureola','n#03872604 n#07776903',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nimbo','n#03872604 n#07821579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('epilettico','n#07246436',NULL,'a#02716367',NULL);
INSERT INTO italian_index VALUES ('estraneo','n#07614356',NULL,'a#00341899',NULL);
INSERT INTO italian_index VALUES ('forestiero','n#07614356 n#07273101',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imparziale','n#07614356',NULL,'a#00280426 a#01660176',NULL);
INSERT INTO italian_index VALUES ('sconosciuto','n#07614356',NULL,'a#01322204',NULL);
INSERT INTO italian_index VALUES ('strano','n#07614356',NULL,'a#00918134 a#00457241 a#00918492 a#00458015 a#00919283 a#01519719',NULL);
INSERT INTO italian_index VALUES ('enigma','n#05081391 n#04394091 n#05081767',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('enimma','n#05081391 n#04394091 n#05081767',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rebus','n#05081391 n#05082579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rompicapo','n#05081391 n#05081767',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bibliografo','n#07111109',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('limitazione','n#04021804 n#00516738',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('restrizione','n#04021804 n#00516738 n#04502083 n#00742557',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idealista','n#07332965',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antenna','n#03796381 n#02074920 n#02191609 n#03638767',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('montacarichi','n#02721841',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('montacarico','n#02721841',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ghiaccia','n#05669346',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('glassa','n#05669346',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aeroscivolante','n#02839735',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('hovercraft','n#02839735',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lasagne','n#05898026 n#05741553',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lasagne_al_forno','n#05898026',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inventario','n#04873270 n#00652628 n#04434354',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ginnastica','n#00606005 n#00275488 n#04440787',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavalcatore','n#07533426',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavallerizzo','n#07533426 n#07533674 n#07325845',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bambola','n#07200169 n#02586827',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gonnella','n#07200169 n#03346396',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('segretezza','n#03667302 n#10344121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('freno','n#02292928 n#00743021 n#02329003',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imboccatura','n#02292928 n#03020602 n#06700117 n#03020865',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('morso','n#02292928 n#10259328 n#02873754 n#05631794 n#10259038 n#10284412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('poncho','n#03155538',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('poncio','n#03155538',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marchesa','n#07395772 n#07395646',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('serraforme','n#03197898',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esalazione','n#10643916 n#00814731',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gas_di_scarico','n#10643916',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pennini','n#N0001610',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('claudicazione','n#10433722',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zoppia','n#10433722',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('categoria','n#04496335 n#05991008 n#06116890 n#07594053',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diapside','n#01182899',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calcolo_integrale','n#04605354',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leggenda','n#04803389 n#04585317 n#04828090',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aorta','n#04139323',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giuliani','n#N0002517',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tremolo','n#10089131 n#09033407',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giuliano_amato','n#W0020875',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amato','n#W0020875 n#07109169',NULL,'a#01401505 a#01401996',NULL);
INSERT INTO italian_index VALUES ('dottor_sottile','n#W0020875',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incrociatore_da_battaglia','n#02266924',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricevente','n#06954382',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giradito','n#10194574',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panareccio','n#10194574',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panereccio','n#10194574',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paronichia','n#10194574',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('patereccio','n#10194574',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('meraviglioso','n#05436975',NULL,'a#01617066 a#00167697',NULL);
INSERT INTO italian_index VALUES ('portento','n#05436975',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prodigio','n#05436975 n#05436522 n#07503661',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barbiturico','n#02251083',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teosofo','n#07639496',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camembert','n#05883361',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbinata','n#00326559',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accoppiata','n#00326559',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('limite','n#09908161 n#06279059 n#06336706 n#10018921 n#03992325 n#06337331 n#10967721 n#03976413',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imposta_di_consumo','n#09586943',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imposta_sulle_vendite','n#09586943',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('meschinità','n#04704180 n#03789185 n#03986337',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiato','n#10646827 n#03929725',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ptialismo','n#09718344',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scialorrea','n#09718344',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canna_da_pesca','n#02689940',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ferro','n#10489934 n#02895021 n#02542418 n#02867016 n#03457380',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biada','n#05835162 n#05834839 n#08416870',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foraggio','n#05835162 n#05834839',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piante_foraggere','n#05835162',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('belorusso','n#07009627 n#05206598',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bielorusso','n#07009627 n#05206598',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiostra','n#02638575 n#09995724',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rinchiuso','n#02638575',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('recinzione','n#02638575 n#02670460',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bilinguismo','n#N0000161',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radioelettricità','n#N0001659',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('boato','n#05503005 n#05493195 n#05329393',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('borbogliamento','n#05503005',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brontolamento','n#05503005 n#05387722',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fragore','n#05503005 n#05493195',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mormorio','n#05503005 n#05503161',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rimbombo','n#05503005 n#05493195',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rombo','n#05503005 n#10002071 n#05493195 n#05500925',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rumoreggiamento','n#05503005',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rumorio','n#05503005',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anca','n#04304395 n#01959166 n#04300182 n#04336372 n#04304542',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('virata','n#00224499 n#N0002260 n#00224643',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chi_prende_in_prestito','n#07121607',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('detective','n#07214003 n#07501398 n#07213831',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('investigatore','n#07214003 n#07213831 n#07344414',NULL,'a#00835722',NULL);
INSERT INTO italian_index VALUES ('investigatore_privato','n#07214003 n#07501398',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('database_ad_oggetti','n#04980232',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immodestia','n#03839267',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inverecondia','n#03839267 n#03807992',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brivido','n#00557607 n#00223779 n#05591021 n#10291206 n#00819088',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fremito','n#00557607 n#00223779 n#05591021 n#05503161 n#10291206',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tremarella','n#00557607',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tremito','n#00557607 n#10088916',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('legume','n#08059029 n#09427836 n#08058531 n#05747902',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amigdala','n#04259865',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cucirino','n#03497295',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filato','n#03497295',NULL,'a#00562039',NULL);
INSERT INTO italian_index VALUES ('filo','n#03497295 n#09919371 n#02894026 n#02417043 n#03428889',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('refe','n#03497295',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciac','n#02446386',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parquet','n#03090018',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ululato','n#05498432 n#05498595 n#05332522',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perforatore','n#N0001433 n#N0001435 n#03187654 n#N0001434',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camion_della_nettezza_urbana','n#02738607',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camion_della_spazzatura','n#02738607',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assestamento','n#00217325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assesto','n#00217325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assettamento','n#00217325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('regolazione','n#00217325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riassestamento','n#00217325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rimpasto','n#00217325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riordinazione','n#00217325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cestino','n#02259850 n#03592687',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paniere','n#02259850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cestino_della_spesa','n#02259850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cucurbita_maxima','n#08467623 n#08466935',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lattante','n#07437537 n#00866982',NULL,'a#02418188',NULL);
INSERT INTO italian_index VALUES ('pompeo','n#07748746',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('smeriglio','n#10518134 n#01134424 n#01007608',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('la_maiella','n#N0002342',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maiella','n#N0002342',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('targa','n#02920706 n#02331144 n#03029236',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ghiacciolo','n#05663952 n#10703624',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dicotomia','n#05956044 n#04428259',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cestino_per_la_cartaccia','n#03592687',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bacchetto','n#03247107',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stelo','n#03247107 n#09418962',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('onniscienza','n#10373771',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('priamo','n#07749317',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acceleramento','n#03950360',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lastra','n#03141236 n#03203507 n#03140308 n#06746903 n#03348184',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vetro_piano','n#03141236',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clamore','n#05328790 n#05498689 n#10070121 n#05329674 n#00361442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grido','n#05328790 n#05329225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strillata','n#05328790 n#05034645 n#05329225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('urlata','n#05328790 n#05034645',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apostolo','n#07079266 n#07079534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('voltastomaco','n#05578076',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incarnazione','n#07470212 n#00597895 n#05085604 n#00597654',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ade','n#06327598 n#06914986',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('endoplasma','n#04219156',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cotone','n#02507188 n#10665909',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('racket','n#00495586',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riverbero','n#03914040 n#03914178',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbazia','n#02156522 n#02156602 n#02156441',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('badia','n#02156522 n#02156602 n#02156441',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monastero','n#02156522 n#03227696 n#02494445 n#06105666 n#03010416 n#02156441',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seme_di_soia','n#08832903',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soia','n#08832903',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esiliato','n#07252035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esule','n#07252035 n#07252140',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('proscritto','n#07252035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('handicappato','n#07308708',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disabile','n#07308708 n#05960711',NULL,'a#00967283',NULL);
INSERT INTO italian_index VALUES ('diverso','n#07308708 n#07324791',NULL,'a#02158584 a#01986829 a#01354886 a#01354496 a#01992026 a#01354054',NULL);
INSERT INTO italian_index VALUES ('andicappato','n#07308708',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('misurino','n#02976065',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banca_di_credito_ordinario_puro','n#N0002737',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ava','n#07075658',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bianchezza','n#03877535',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('candore','n#03877535 n#03666367 n#10078596 n#03817332',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pallidezza','n#03877535',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radice','n#04753852 n#05458618 n#09886750 n#04119905 n#09415516',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pelosità','n#03689652',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('villosità','n#03689652',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavità','n#06728884 n#04116121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affossamento','n#06728884 n#05483217',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavernosità','n#06728884 n#03957279 n#10024561',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aborto_spontaneo','n#00149696',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avvezione','n#09740100',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agrostemma_githago','n#08116221',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gittaione_comune','n#08116221',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('posticcio','n#02784258',NULL,'a#01691661',NULL);
INSERT INTO italian_index VALUES ('toupet','n#02784258 n#03522398',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cimasa','n#02807103 n#02541032 n#03009795',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iddio','n#06888992',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dio','n#06888992 n#06861622',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idrogenazione','n#N0000913',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('galeone','n#02733957',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autografo','n#04829114 n#04827466',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pianta_erbacea','n#08510637',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('qualità','n#03717355 n#03741160 n#03714294 n#03897405 n#04504076 n#04504455 n#04496504',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nuotatore','n#07626469 n#07626282',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('costo_della_sostituzione','n#09576343',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impressionista','n#07336361',NULL,'a#02578079',NULL);
INSERT INTO italian_index VALUES ('dollaro_dello_zimbabwe','n#09837433',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risolutezza','n#03810995 n#03809479 n#03811466',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('centrista','n#07146411 n#06223906',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moderato','n#07146411',NULL,'a#01467790 a#01434385',NULL);
INSERT INTO italian_index VALUES ('esoftalmo','n#10274175',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sostegno','n#05570308 n#00786193 n#00788240',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carrubo','n#08794248 n#05651204',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carubo','n#08794248 n#05651204',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('suono_vocalico','n#05322484',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiammifero','n#02972349 n#02971928',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chenopodium_bonus-henricus','n#08139414',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('farinello_buon-enrico','n#08139414',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parsimonia','n#03832645 n#03832817 n#03832514',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risparmio','n#03832645 n#00126393 n#09619452',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('due_punti','n#05125700',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mazzolo','n#02962091',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mazzuolo','n#02962091',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('citazione','n#05068012 n#04922423 n#04922905 n#05029189 n#04960176',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gotazza','n#N0001788',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gottazza','n#N0001788',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sassola','n#N0001788',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sessola','n#N0001788',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('liposcelis_divinatorius','n#01764591',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('liposcele','n#01764591',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mangano','n#02963302 n#02403318',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tachigrafo','n#03464018',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mussola','n#03026603',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mussolina','n#03026603',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mussolino','n#03026603',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mussolo','n#03026603',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('metrica','n#05307062',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ritmica','n#05307062 n#N0001730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('primo_ministro_israeliano','n#W0020891',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('linea_del_partito','n#04994425',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('villo','n#01416934',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immortalità','n#03946718',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lunghezza','n#03999338 n#03943113 n#03995742',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teoria_dei_giochi','n#04674702',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('servizio','n#00062420 n#00371920 n#09593730 n#00379388 n#00384296 n#00461585 n#06084772',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cubatura','n#09923970',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('volume','n#09923970 n#03898867 n#03977751 n#04833552 n#02313137',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moloc','n#06873868 n#01209775 n#07492258',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('terzina','n#N0002101 n#N0002102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('saccata','n#09916303',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pensile','n#03587578',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ballata','n#05285769 n#04808339 n#04808246',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compenetrazione','n#09737023',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('saturazione','n#09737023 n#10043389',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('botto','n#05505766 n#05492247',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tonfo','n#05505766 n#05501383',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orizzonte','n#06330606 n#03994627',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('multiprocessore','n#03024032',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nitrocellulosa','n#10612114',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('offerta_di_acquisto','n#05358049',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cagnotto','n#07086477',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scherano','n#07086477',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sicario','n#07086477 n#07305252',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assistito','n#07461272 n#07197725',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('degente','n#07461272 n#07339831',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paziente','n#07461272',NULL,'a#01672718',NULL);
INSERT INTO italian_index VALUES ('bomba','n#05684838 n#02310834 n#05442734 n#05685113',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bombolone','n#05684838',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cancer_irroratus','n#01490596',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zircone','n#10841120',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leptone','n#06678027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pozzo_artesiano','n#02213789',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parcheggio','n#00109535 n#06348048 n#06348159',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('otturatore','n#02310462 n#03332246 n#02334416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fenolo','n#10612924',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ossibenzene','n#10612924',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amarena','n#05793753',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('facoltà_di_medicina','n#06149514',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mobilitazione','n#00749110',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barattolo','n#02374411 n#02376052 n#09914955 n#02873027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bussolotto','n#02374411 n#02566876',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lattina','n#02374411 n#N0001027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('circostanza','n#10046803 n#10391300 n#10409482 n#04485138',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('congiuntura','n#10046803 n#10391300 n#02882195',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('curbasciata','n#00752563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('flagellamento','n#00752563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('flagellazione','n#00752563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frustata','n#00752563 n#00087268 n#05412919',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fustigazione','n#00752563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nerbata','n#00752563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scudisciata','n#00752563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sferzata','n#00752563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('staffilamento','n#00752563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('staffilata','n#00752563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ugonotto','n#07329622',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veronica','n#09187801',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('jack','n#02870030',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('presa_di_corrente','n#02870030 n#03150944 n#03587268',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sacerdozio','n#N0001756',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('afflusso','n#09742299',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ribes','n#09103720 n#09103947',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salvia_verbenaca','n#09164804',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salvia_minore','n#09164804',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lathyrus_sylvestris','n#08842550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cicerchia_silvestre','n#08842550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cicerchione','n#08842550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coglitore','n#07475683',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bombarolo','n#N0000183',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('occhio_di_gatto','n#10619659',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contrattempo','n#04396796',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intralcio','n#04396796 n#00695341 n#04396152',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('blusa','n#02617507 n#03069114 n#02301305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camiciotto','n#02617507',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spolverina','n#02617507',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spolverino','n#02617507',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bizzarria','n#03763994 n#03764483 n#03764875',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dirizzatura','n#N0001841',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('discriminatura','n#N0001841',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('drizzatura','n#N0001841',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scriminatura','n#N0001841',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spartitura','n#N0001841',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maggiore','n#07265412 n#07236559 n#07388270',NULL,'a#01330402 a#01159358 a#00231136 a#01330301 a#01411220 a#01412244 a#01339584',NULL);
INSERT INTO italian_index VALUES ('primogenito','n#07265412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biomassa','n#10526454 n#03923743',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bimestre','n#10918067',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricarica','n#09742155',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incoraggiamento','n#05412801 n#00785108',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('firma','n#10359356 n#04827181 n#00738696',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nome','n#10359356 n#04768298 n#04779986 n#07426815 n#04778525 n#05976721',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cuoio_non_conciato','n#10580559',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('budget','n#09668771 n#09668437',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('massacro','n#00145676 n#00808655 n#05452645 n#10384515',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carneficina','n#00145676 n#00808655 n#05452645 n#00141434',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eccidio','n#00145676 n#00808655',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scempio','n#00145676',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strage','n#00145676 n#00808655',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tagliamento','n#00145676 n#N0002295',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tagliata','n#00145676',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quota','n#09771510 n#09606854 n#09561632 n#03998008',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('xantoma','n#10225841',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('collo_del_piede','n#04321059',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('libertà_di_parola','n#04037335',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('libertà_di_espressione','n#04037335',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strozzascotte','n#N0002027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('renault','n#N0002547',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('era_geologica','n#10954662',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inadeguatezza','n#03712692 n#03713123 n#03761231',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incongruità','n#03712692',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('espediente','n#00115902 n#04539178 n#00111383',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ripiego','n#00115902 n#00116303',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ritrovato','n#00115902 n#05389592 n#02865563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giravolta','n#09992072',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('svolta','n#09992072 n#05520652 n#05476949',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('legislazione','n#04906199 n#06243906 n#00729291',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('animale','n#00008019',NULL,'a#00110364',NULL);
INSERT INTO italian_index VALUES ('bestia','n#00008019 n#07105886 n#07271334 n#01667395',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bestiola','n#00008019',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interrogazione','n#05379050 n#05376578',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orale','n#05379050',NULL,'a#02172639',NULL);
INSERT INTO italian_index VALUES ('stecconata','n#03117538',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rettifilo','n#03423493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rettilineo','n#03423493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accidente','n#05138515 n#10135570 n#05443572 n#05452288 n#05443380',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bramino','n#06165655 n#07124559',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('adenocarcinoma','n#10232738',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prezzo_del_greggio','n#W0005493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prezzo_del_petrolio','n#W0005493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('evoluzionismo','n#N0000687',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maturità','n#05378665 n#10874257 n#10349488 n#10350062',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('istituto_centrale_delle_banche_popolari','n#N0002732',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('istpopolbank','n#N0002732',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contatore','n#02990606 n#02508575',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ulmus_laevis','n#08709933',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('olmo_bianco','n#08709933',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('adulterio','n#00545187',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fornicazione','n#00545187 n#00545412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('infedeltà','n#00545187 n#03822197',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prodizione','n#00545187',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bordura','n#02622389 n#02317372 n#02815349',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('makaira_nigricans','n#02121040',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marlin_azzurro','n#02121040',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('visitatore','n#N0002261 n#07135598 n#07668613',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('meccanismo','n#00062253 n#02979815 n#06757099',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('culturista','n#07117729',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bodybuilder','n#07117729',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('body_builder','n#07117729',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('certezza','n#03734468 n#04401608 n#04402162',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sicurezza','n#03734468 n#10426280 n#04401836 n#10425881',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gaviale','n#01220374',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('c','n#10979332 n#09871620',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ci','n#10979332',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('velocità_della_luce','n#10979332',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elaborazione','n#00160599 n#09712272',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('settimo','n#09892243 n#09976262',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chimera','n#06854663 n#04449659 n#01005294',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('refugium_peccatorum','n#N0001686',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bomba_h','n#02843965',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bomba_all''idrogeno','n#02843965',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amalgama','n#10551471 n#05971597',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inquadramento','n#00650412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ordinamento','n#00650412 n#10399952 n#00651563 n#04377619',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rassettamento','n#00650412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rassetto','n#00650412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ravviamento','n#00650412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ravviata','n#00650412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canale_di_trasmissione','n#04733874',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nastro_del_cappello','n#02803054',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mercato_estero','n#W0021038',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barn','n#09784795',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ambizione','n#05564290 n#03790984',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aspirazione','n#05564290 n#05326236 n#07841727 n#00540731 n#00536863',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('siracusa','n#06465159',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('neurofisiologia','n#04639395',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rorippa_islandica','n#08203280',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crescione_islandico','n#08203280',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anatomico','n#07075284',NULL,'a#02678395 a#02678243',NULL);
INSERT INTO italian_index VALUES ('anatomista','n#07075284',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('notomista','n#07075284',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accessorio','n#02159867 n#02160048',NULL,'a#01782330',NULL);
INSERT INTO italian_index VALUES ('ernia_del_disco','n#10264412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ernia_al_disco','n#10264412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ernia_discale','n#10264412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spratto','n#02025649 n#05833110',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('laborismo','n#06134226',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('laburismo','n#06134226',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assorbimento','n#09735650 n#09754552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fattore_rh','n#10788969',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cordame','n#03240788',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caprifico','n#08669343',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('valvola_di_sicurezza','n#03268622',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nervo','n#04244555 n#04110255',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assoide','n#04330886',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('boxer','n#01617901',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maschiaccio','n#07643843',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dappocaggine','n#04368468',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('insipienza','n#04368468',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('espianto','n#N0000665',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('complementarità','n#09972014 n#09983072',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('plantago_lanceolata','n#08899256',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lingua_di_cane','n#08899256',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piantaggine_minore','n#08899256',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spincervino','n#08899256 n#09071560 n#09428892',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incubazione','n#00430676 n#09701633 n#10986817',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('condotto','n#03130263 n#02486167 n#03129019 n#04077287 n#02613638',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carta_da_lettere','n#10838918',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('batteriologo','n#07096627',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('patrono','n#07463139',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spruzzatura','n#05088890',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('galium_aparine','n#08965920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asperella','n#08965920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asprella','n#08965920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attaccamani','n#08965920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attaccaveste','n#08965920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attaccavesti','n#08965920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caglio_asprello','n#08965920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('utopista','n#07659569',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ingranamento','n#05467682',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perditore','n#07381843',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sconfitto','n#07381843',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_di_suriname','n#09842934',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antropologia_culturale','n#04673338',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('infreddatura','n#10174608',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raffreddore','n#10174608',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fuoripista','n#N0000798',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('romboide','n#10002215',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('menta','n#09153414 n#05656790 n#09154462',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elettromotrice','n#02627992',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('locomotore','n#02627992',NULL,'a#02756172',NULL);
INSERT INTO italian_index VALUES ('locomotrice','n#02627992',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baraccone','n#N0000145',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decennale','n#N0000526',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bilione','n#09903469 n#09903149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bollettario','n#N0000180',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pachistano','n#07032698',NULL,'a#02838194',NULL);
INSERT INTO italian_index VALUES ('pakistano','n#07032698',NULL,'a#02838194',NULL);
INSERT INTO italian_index VALUES ('carboneria','n#N0000291',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('myrmecobius_fasciatus','n#01401472',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moffetta','n#01941581 n#01942072',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('puzzola','n#01941581 n#01939013',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('skunk','n#01941581',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('verbascum_lychnitis','n#09186948',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('verbasco_licnite','n#09186948',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiocciata','n#05985779',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('covata','n#05985779',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brokeraggio','n#06014906',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vocazione','n#04355442 n#00382624',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baccano','n#05498689 n#05502027 n#05329674',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bailamme','n#05498689 n#10070121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baraonda','n#05498689 n#10068579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bolgia','n#05498689',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bordello','n#05498689 n#03615214',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buriana','n#05498689 n#10070121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caciara','n#05498689',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cagnara','n#05498689 n#10070121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canea','n#05498689',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fracasso','n#05498689 n#05502027 n#05493076',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frastuono','n#05498689 n#05493076',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gazzarra','n#05498689 n#05502027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parapiglia','n#05498689 n#10070121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sarabanda','n#05498689',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('schiamazzo','n#05498689 n#05502027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('congedo_straordinario','n#10864999',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('isterico','n#N0001003 n#N0001002',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vb','n#N0002460',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('verbania','n#N0002460',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('treccia','n#04083416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('organizzazione_sindacale','n#06112041',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sindacato','n#06112041',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ametista','n#10555934',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ibridazione','n#00546649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incrociamento','n#00546649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aurora_astrale','n#07777303',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spiritual','n#05275552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('selene_setapinnis','n#02068362',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pesce_ascia','n#02068362',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spazzolino_da_denti','n#03517995',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('letto','n#02273239 n#W0021132 n#06780036 n#06694516 n#W0021133 n#02274436 n#W0021134',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arazzo','n#03472088 n#03472233',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gobelin','n#03472088',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('midollo','n#04256631 n#09388702 n#04259503 n#04102587',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cervello','n#04345975 n#04351370 n#07288630 n#04348023 n#04249425 n#07411717 n#05697028',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compito_in_classe','n#05378329',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esame','n#05378329',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('test','n#05378329 n#04469208 n#00649604 n#00507777',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('classicista','n#07159459 n#07159340',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('borlotto','n#05764392',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fagiolo_comune','n#05764392 n#08857485 n#08857214',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('omero','n#04334112 n#07728505',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('naturismo','n#00454197 n#00666314',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tredici','n#09898882',NULL,'a#02100114',NULL);
INSERT INTO italian_index VALUES ('tasto_di_controllo','n#02493047',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('segretario_generale','n#W0020792',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conoscente','n#07060310',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amsterdam','n#06537161',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affondamento','n#05483331 n#05484396',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inabissamento','n#05483331',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sommersione','n#05483331',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('toponimo','n#04783039',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('premonizione','n#05395603',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('presagio','n#05395603 n#05435037',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aspirina','n#02216937',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ora_di_pranzo','n#10884851',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iperplasia','n#10309376',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('holmio','n#10488479',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('olmio','n#10488479',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alinea','n#04824115',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capoverso','n#04824115 n#04817917',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paragrafo','n#04824115',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiaroveggente','n#07159042',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veggente','n#07159042 n#07506812',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('addiaccio','n#03102571 n#02708549',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agghiaccio','n#03102571 n#02708549',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ritratto','n#03160624',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('glicogeno','n#10612523',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quartina','n#04813699',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quarto_di_secolo','n#Y0005575',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vacanza','n#10863279 n#10863595',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('umbone','n#04131064',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('yuppie','n#07692323',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('insistenza','n#05375316 n#03848510',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('balla','n#05063740 n#02240596',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panzana','n#05063740',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panzanata','n#05063740',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lemma','n#04754148 n#04751911 n#05059457',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camiceria','n#N0000249 n#N0000248',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('effeminatezza','n#03679383',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('effemminatezza','n#03679383',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('svenevolezza','n#03679383',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stanca','n#05510801',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intasamento','n#00695483 n#00695341 n#02300099 n#06082959',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ostruzione','n#00695483 n#00367201 n#02300099 n#00367083 n#04396152',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affettatrice','n#03351323',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('credulità','n#03834151 n#03823649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dabbenaggine','n#03834151 n#03823649 n#03823790',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calca','n#06082852 n#06082225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pigia_pigia','n#06082852',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ressa','n#06082852',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lontra','n#01940685 n#01941037',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banditismo','n#N0000144',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ago','n#03035225 n#03151315 n#09443827',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sonnambolismo','n#00184505',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sonnambulismo','n#00184505',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('steatite','n#10794506',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anastrofe','n#05313156',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inversione','n#05313156 n#00216116 n#00222304 n#00216009',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sud-ovest','n#09965562',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eupatorium_cannabinum','n#08275952',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canapa_acquatica','n#08275952 n#08248433',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ex','n#07220086 n#07331628',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avvertimento','n#04822335 n#05003120 n#05395080',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('isagoge','n#04822335',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prefazione','n#04822335',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('proemio','n#04822335',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prolusione','n#04822335',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('limaccia','n#01458682',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lumaca','n#01458682 n#01457825 n#07482106 n#05817584',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lumacone','n#01458682 n#07482106',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tursiops_truncatus','n#01581563',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tornitura','n#N0002127 n#06688152',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seteria','n#N0001870',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('setificio','n#N0001870',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autorespiratore','n#02203878 n#02334077',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elettorato','n#06069224',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clinica','n#06002732',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contratto_aleatorio','n#04895835',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fascio','n#05086966 n#07777807 n#02353159',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pomellato','n#03878877',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('doppio','n#00308640 n#07655681 n#00308543',NULL,'a#02114353',NULL);
INSERT INTO italian_index VALUES ('spesa_sanitaria','n#09554141 n#W0020918',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salinità','n#04417426 n#03901268',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salso','n#04417426',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sapore_salato','n#04417426',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riflesso','n#07831313 n#00554907',NULL,'a#01937628',NULL);
INSERT INTO italian_index VALUES ('ripercussione','n#07831313 n#07768969 n#03914178',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prosciugamento','n#09739112',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammonimento','n#05036035 n#05003120 n#05033972',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammonizione','n#05036035 n#05003120 n#05033972',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ottimizzazione','n#N0001344',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('senegalese','n#07037126',NULL,'a#02853933',NULL);
INSERT INTO italian_index VALUES ('penne_rigate','n#N0002362',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diritto_alla_privacy','n#04035643',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('passerotto','n#N0001396',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('isoletta','n#06743549',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('isolotto','n#06743549',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ossalato','n#10741785',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gasdotto','n#02744380',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camerun','n#06413595',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stampaggio','n#N0001987 n#N0001988',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('creatore','n#06944789',NULL,'a#00606821',NULL);
INSERT INTO italian_index VALUES ('artefice','n#06944789 n#07191544',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fattore','n#06944789 n#09767402 n#05460817 n#04515709 n#07256794',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stoma','n#07995079',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbonamento','n#09557875 n#04893172',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bei','n#07110730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maoista','n#07394914',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tratto_distintivo','n#03719538',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caratteristica','n#03719538 n#03741160 n#04505614 n#04504076 n#03770915 n#05102576 n#04504455',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cia','n#06057154',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('genetista','n#07288316',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iniziativa','n#03790844 n#00156102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intraprendenza','n#03790844 n#03807895 n#03792240',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giuramento','n#05011384',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rachitismo','n#10206955',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('californio','n#10482320',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('annuario','n#04843097 n#04842908',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agit-prop','n#07506138',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('divulgatore','n#07506138',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('propagandista','n#07506138',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rial','n#09860681 n#09858908 n#09860311',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rial_saudita','n#09860681',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zolfanello','n#02971928',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incapacità','n#04015096 n#04051880 n#04365652',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incompetenza','n#04015096',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pieris_brassicae','n#01783867',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pieridae_cavolaia_maggiore','n#01783867',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sacrestano','n#07568112',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sacrista','n#07568112',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sagrestano','n#07568112',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sagrista','n#07568112',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scaccino','n#07568112',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('battifiacca','n#07295019',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buono_a_nulla','n#07295019',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fannullone','n#07295019 n#07333550 n#07199951',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perditempo','n#07295019 n#07333550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scansafatiche','n#07295019 n#07333550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('schivafatiche','n#07295019',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfacendato','n#07295019',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colorante','n#10753149 n#05623076',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tinta','n#10753149 n#03078466 n#03876333',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tintura','n#10753149 n#03507629 n#00176936',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banco_di_sabbia','n#06739486',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tenente','n#07372681',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deposito_in_cassette_di_sicurezza','n#03266694',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('taccuino','n#04835086',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carnet','n#04835086',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lattosio','n#10712328',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('preziosità','n#04005342 n#03757270',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fotocellula','n#03112982',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clinopodium_vulgare','n#09142329',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clinopodio_dei_boschi','n#09142329',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radicando','n#N0001652',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palio','n#N0001366',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('battello_faro','n#02925835',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aristotelico','n#07083239',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cammino','n#00383688 n#00202953',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cammello','n#01933103 n#02370969 n#01933446',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ceratitis_capitata','n#01701542',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mosca_mediterranea','n#01701542',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veletta','n#02806427',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('restauratore','n#07524212',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impennaggio','n#03465129',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caccia','n#00287066 n#00604336 n#01661356 n#00410109 n#02676348 n#02558580 n#00206677',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corona_solare','n#07776903',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbattighiaccio','n#02465354',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scotitoio','n#02465354',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scuotitoio','n#02465354',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('shaker','n#02465354',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eliografo','n#02814432',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pattinatore','n#07580876',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('librettino','n#04833775',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('opuscolo','n#04833775',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('opuscoletto','n#04833775',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stampato','n#04833775 n#04818790',NULL,'a#00438935',NULL);
INSERT INTO italian_index VALUES ('bonus_malus','n#N0000186',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('georgiano','n#05233284 n#07035684',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decongestionante','n#02550460',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canterale','n#02428247 n#02429626',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canterano','n#02428247 n#02429626',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cassettiera','n#02428247',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cassettone','n#02428247 n#02467173',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comò','n#02428247 n#02429626',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('devalutazione','n#00515372',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sovrapproduzione','n#00587087',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('superproduzione','n#00587087',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mummificazione','n#00525047',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sciabolata','n#N0001824',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('martini','n#05937410 n#N0002529',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lotta_di_classe','n#00615583',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('distrazione','n#00337166 n#00272358 n#00274048 n#00332306 n#00131327 n#04404718 n#03676822 n#04408740',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diversivo','n#00337166 n#00272358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cilicio','n#02784651 n#10285502',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erbario','n#N0000651 n#N0000652',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spettacolo_di_rievocazione_storica','n#00578215',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salix_cinerea','n#09028450',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salice_cinereo','n#09028450',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salice_grigio','n#09028450',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('socialdemocrazia','n#04711303',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('costruttore_navale','n#07570581',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prunus_dulcis','n#08944991',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mandorlo','n#08944991 n#08944719',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('telefono_a_gettoni','n#03098451',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('otaria','n#01588046 n#01589108',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sinapis_arvensis','n#08204530',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('senape_selvatica','n#08204530',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('setaria_viridis','n#08441649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pabbio_comune','n#08441649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panico_falso','n#08441649',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stradario','n#N0002020',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carta_velina','n#10814391',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('antropometria','n#00645260',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('somatometria','n#00645260',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('resultato','n#05440251 n#05438613 n#07766144',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biscottiera','n#N0000171 n#N0000170',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('annali','n#04949026 n#04890615',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('metatesi','n#09720135 n#09687591',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acidimetria','n#00644524',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('desiderabilità','n#04005625',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erodium_cicutarium','n#08988602',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('becco_di_gru_comune','n#08988602',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cicutaria','n#08988602',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affermativa','n#05382303',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capellone','n#07320948 n#07105998',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contestatore','n#07320948',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('hippy','n#07320948',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('silenzio','n#03893757 n#03893540 n#03667153',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palmeto','n#N0001368',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('blocchetto','n#02313477 n#10743763',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('infruttuosità','n#04023579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('allevamento','n#00731545 n#00588183 n#02666240',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cieco','n#07115645 n#04288593',NULL,'a#02076031',NULL);
INSERT INTO italian_index VALUES ('orbo','n#07115645',NULL,'a#02076031',NULL);
INSERT INTO italian_index VALUES ('cappella','n#02422521 n#07852759 n#06087156',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attivismo','n#04536252',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spilla','n#02342772',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riserbo','n#03667509',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('silenziosità','n#03667509 n#03894093',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iud','n#N0001014',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dispositivo_intrauterino','n#N0001014',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammezzato','n#02994077',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mezzanino','n#02994077',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arma_antiaerea','n#02192030',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cannone_antiaereo','n#02192030',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sintagma','n#N0001904',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contatto','n#00023118 n#05432221 n#02489931',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dinamismo','n#03932475 n#10119788 n#03656123',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carbonaio','n#07163118',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amicone','n#07128451',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arma','n#06091419 n#03601056 n#05408794 n#02462414',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camerata','n#N0000417 n#02592099 n#07128110',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('commilitone','n#N0000417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('q.i.','n#09955110',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quoziente_d''intelligenza','n#09955110',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disattenzione','n#04409237 n#00043865 n#00043956 n#04404718 n#04408740',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('satanasso','n#07418621 n#07315860',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('didone','n#06904889',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vicia_villosa','n#08877208',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veccia_pelosa','n#08877208',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reggente','n#07524845',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('missione','n#00623965 n#06214058 n#00471060 n#06213619',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('addolcimento','n#00227941 n#00159063',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mitigazione','n#00227941',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('confusisone','n#10401718',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disordine','n#10401718 n#10402014 n#00361901 n#03835504',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compartimento','n#06304618 n#02478646',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comprensorio','n#06304618',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('distretto','n#06304618',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mandamento','n#06304618 n#06264585',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('plaga','n#06304618',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('regione','n#06304618 n#W0020882 n#06395720 n#06297080 n#06359477 n#06268839 n#04059885',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banalità','n#05351337 n#05351480 n#04369347 n#03777707 n#03542392',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cliché','n#05351337 n#03141069 n#04551112',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('luogo_comune','n#05351337',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affiatamento','n#03707811 n#03649078 n#10065762',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sintonia','n#03707811 n#03649078',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ora','n#10856821 n#10952516 n#10938559 n#10938063 n#10847142',NULL,NULL,'r#00048006 r#00047077 r#00047341 r#00047675');
INSERT INTO italian_index VALUES ('udienza','n#00777684 n#10391014',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cofto','n#06998799 n#05244018',NULL,'a#02806832',NULL);
INSERT INTO italian_index VALUES ('copto','n#06998799 n#05244018',NULL,'a#02806832',NULL);
INSERT INTO italian_index VALUES ('nemesi','n#06912621',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavaliere','n#07358345 n#07325845 n#07288873',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sottodominante','n#05130778',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vaniglia','n#08393769 n#05861441',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('hylobates_syndactylus','n#01977936',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prezzo','n#09576753 n#04022516 n#04008333',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banchiglia','n#06847843',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banchisa','n#06847843',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ice_field','n#06847843',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pack','n#06847843',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfogliatella_alle_mele','n#05672199',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('schnauzer','n#01607233',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idrografia','n#04657116',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macaca_mulatta','n#01981727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reso','n#01981727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('philips','n#N0002542',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vitalità','n#10119788 n#03654412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('junior','n#N0000897 n#07352182',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bolsaggine','n#10243758 n#03935080',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fabianesimo','n#04713979',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('distilleria','n#02581693',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rosso','n#07523636 n#07118379 n#05873050 n#00989609 n#03879230 n#07589006 n#05917325',NULL,'a#00373564 a#00369643 a#00362449 a#00372041',NULL);
INSERT INTO italian_index VALUES ('ovis_musimon','n#01912459',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('muflone','n#01912459',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sistema_nervoso_centrale','n#04249171',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giavellotto','n#02873625 n#05553955',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fitta','n#05571888 n#04422485',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('internazionale','n#05276583 n#06193477',NULL,'a#01512129 a#00986718',NULL);
INSERT INTO italian_index VALUES ('infrazione','n#00492547',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trasgressione','n#00492547',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sterlina_egiziana','n#09856163',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('postazione','n#02637625',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moneta_di_scarso_valore','n#09634855',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cala','n#06795196 n#02388614',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('manicheismo','n#N0001121 n#N0001122',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guardalinee','n#07375956',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guardialinee','n#07375956',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('segnalinee','n#07375956',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('architetto_del_paesaggio','n#07363373',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pessimista','n#07470823',NULL,'a#01605516',NULL);
INSERT INTO italian_index VALUES ('bodino','n#05665366',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('budino','n#05665366',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbadessa','n#07053378',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('badessa','n#07053378',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('priora','n#07053378',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('superiora','n#07053378',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('patteggiamento','n#04927073',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('torneo_di_whist','n#05539530 n#06131059',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbondanza','n#03987266 n#03987430 n#03986878',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dovizia','n#03987266 n#03986878',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carrozziere','n#N0000301 n#N0000302',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moschus_moschiferus','n#01931197',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mosco','n#01931197',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('valico','n#06708950',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colle','n#06708950 n#06723275',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pannocchia','n#06299088 n#09422534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('detrito_alluvionale','n#06695274',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('materiale_alluvionale','n#06695274',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pentimento','n#05602279 n#05601647 n#05602852',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rincrescimento','n#05602279',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indocilità','n#03842880 n#03842359',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spirito_di_ribellione','n#03842880',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('condanna','n#00770012 n#00793932 n#05032286',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macchina_da_cucire','n#03306962',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clorofilla','n#00925109',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('angolo_retto','n#10010121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bignè','n#05675471',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('subaffitto','n#09532697',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sublocazione','n#09532697',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricorso','n#05471329 n#00783240 n#00767259',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guru','n#07305712 n#06950891',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apatico','n#07367121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brindellone','n#07367121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indolente','n#07367121',NULL,'a#00290443',NULL);
INSERT INTO italian_index VALUES ('mollaccione','n#07367121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pigro','n#07367121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pigrone','n#07367121 n#07585698',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scaldaseggiole','n#07367121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('svogliato','n#07367121',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stoviglie','n#03463399',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stoviglie_da_tavola','n#03463399',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('libertà_di_pensiero','n#04036022',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calore','n#10111948 n#03651126 n#05561864 n#05609617 n#05616909 n#04422689 n#07805780 n#10278539 n#03917468',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foia','n#10111948',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fregola','n#10111948 n#05568539',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sala_di_comando','n#02493727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sala_di_regia','n#02493727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sala_regia','n#02493727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amaranthus_albus','n#08133878',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amaranthus_graecizans','n#08133878',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amaranto_bianco','n#08133878',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amaranto_blito-minore','n#08133878',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('visionario','n#07668085',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prostituto','n#N0001593',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decilitro','n#09794283 n#09794734',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dl','n#09794283 n#09794734',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mafioso','n#N0001102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('noè','n#07744827',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brefotrofio','n#03063980',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orfanelli','n#03063980',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orfanotrofio','n#03063980',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('obliterazione','n#10146265',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tennis','n#00307617',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tennis_sull''erba','n#00307617',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pallacorda','n#00307617',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_afgana','n#09825680',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soda_caustica','n#10776835',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('duralluminio','n#10645503',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gengivite','n#10134734',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ulite','n#10134734',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('la_maggior_parte','n#09759719',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sonettista','n#07593000',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gibilterra','n#06585482',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('globulina','n#10781846',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bagliore_del_fuoco','n#07799104',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('budello','n#02833815 n#04286746 n#02179253 n#02404832',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('manichetta','n#02833815',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tubo_di_gomma','n#02833815',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elicottero','n#02814163',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asplenium_adiantum-nigrum','n#09465476',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asplenio_adianto_nero','n#09465476',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paranthropus','n#01971728',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dipolo','n#06690568 n#02574824',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abilitazione','n#03711014',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('qualifica','n#03711014',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('domenica','n#10883776 n#10883605',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bulbo','n#04063459 n#02923710 n#09422963',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('limnodromus_scolopaceus','n#01545088',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piro_piro_petto_rossiccio','n#01545088',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piro_piro_pettorossiccio','n#01545088',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coetaneo','n#06196326',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mangostano','n#05799591 n#08669965',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sistema_di_preallarme','n#02619761',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lavanderia','n#02911253',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frapposizione','n#00681250 n#00694910',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interposizione','n#00681250',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('presbitero','n#N0001571 n#07497477',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('entroterra','n#N0000644',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('retroterra','n#N0000644',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('boletus_edulis','n#09350626',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ceppatello','n#09350626',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('porcino','n#09350626',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pan_grattato','n#05670703',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pangrattato','n#05670703',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mantovana','n#02503372',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('confettura','n#05688964 n#05688463 n#05688055',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marmellata','n#05688964 n#05688463 n#05688055',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asportazione','n#00252436 n#00433627 n#00251311',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('escissione','n#00252436',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('actinia','n#01428933',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attinia','n#01428933',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('borsellino','n#03190105',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('borsello','n#03190105',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portamonete','n#03190105',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abusivismo','n#N0000011',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pedicello','n#09421659',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('melissa_officinalis','n#09152972',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cedronella','n#09152972',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('citronella','n#09152972',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erba_limona','n#09152972',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('melissa','n#09152972 n#05851547',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('melissa_vera','n#09152972',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('adulatore','n#07267947',NULL,'a#00862067',NULL);
INSERT INTO italian_index VALUES ('incensatore','n#07267947',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leccatore','n#07267947',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lusingatore','n#07267947',NULL,'a#00862067',NULL);
INSERT INTO italian_index VALUES ('piaggiatore','n#07267947',NULL,'a#00862067',NULL);
INSERT INTO italian_index VALUES ('struscione','n#07267947 n#07080086 n#07627301',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ungitore','n#07267947',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vestigia','n#04984599 n#03261457',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vestigio','n#04984599 n#03227440',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prefica','n#07676636',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('editore','n#07511548 n#06009454 n#07234892',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scherzo','n#00331800 n#00331680 n#05283743 n#00331225 n#05077026',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('beffa','n#00331800 n#00331381',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('burla','n#00331800 n#00331225 n#00331381',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('burletta','n#00331800 n#00331225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('celia','n#00331800',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('legazione','n#00391153 n#06213780',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vagito','n#N0002215',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammollamento','n#00178640',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('docente','n#07632177 n#07504465',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('istruttore','n#07632177',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cerambice','n#01674150',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('duello','n#00506044 n#00760027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interesse_netto','n#N0002828',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inanità','n#04012751',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inutilità','n#04012751',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vanità','n#04012751 n#03828045 n#04005196 n#03828199 n#05581850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acrocephalus_schoenobaenus','n#01088106',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forapaglia','n#01088106',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('forapaglie','n#01088106',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('argutezza','n#04352743 n#05075890',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aereo','n#02170808 n#02191609 n#02174460',NULL,'a#02353332 a#01327490',NULL);
INSERT INTO italian_index VALUES ('aeromobile','n#02170808 n#02173838',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aeroplano','n#02170808 n#02174460',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('areoplano','n#02170808 n#02174460',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('neonazista','n#N0001282',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('figura_retorica','n#05317127',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('facile_bersaglio','n#07580501',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grazia','n#10373357 n#03908392 n#03794441 n#03691262 n#00811226 n#03659570 n#03908541',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ora_locale','n#10846536',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ora_ufficiale','n#10846536',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('karma','n#05462548',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('confraternita','n#06019148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fratellanza','n#06019148 n#06113359',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fraternità','n#06019148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moneta_da_sei_penny','n#09645305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sarmento','n#N0001781 n#N0001782',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piatto_delle_elemosine','n#03140692',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_vietnamita','n#09837532',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tiralinee','n#N0002112',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interesse_su_cct','n#N0002831',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fanciullo','n#07153837 n#07389783',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marmocchio','n#07153837 n#07154377',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mimmo','n#07153837',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moccioso','n#07153837',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pargolo','n#07153837',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('figlio','n#07153837 n#07592357 n#07154377',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giovane','n#07153837 n#05959071 n#07290496 n#07691951',NULL,'a#01587804',NULL);
INSERT INTO italian_index VALUES ('oggetto_naturale','n#00010123',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('festino','n#N0000730 n#N0000731 n#05631002',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accostamento','n#05450024',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avvicinamento','n#05450024 n#00181376',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raccostamento','n#05450024 n#00181376',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ravvicinamento','n#05450024 n#00781305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spifferone','n#07631218 n#01542056',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spione','n#07631218',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mandorlato','n#N0001114',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('francescano','n#07680018',NULL,'a#02814968',NULL);
INSERT INTO italian_index VALUES ('dare','n#09655306','v#00055849 v#01526289 v#00507599 v#01507640 v#00718708 v#01464668 v#01529684 v#01131926 v#01583087 v#01120116 v#01185771 v#01119839 v#01505951 v#01548161 v#01583295',NULL,NULL);
INSERT INTO italian_index VALUES ('addebito','n#09655306 n#05045982 n#05401516 n#05404012',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('addebitamento','n#09655306',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piccolo_galoppo','n#00187091',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arricchito','n#07657832',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arrivato','n#07657832',NULL,'a#01575491',NULL);
INSERT INTO italian_index VALUES ('parvenu','n#07657832',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anemone_dei_boschi','n#08037112 n#08036960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panificatore','n#07097771 n#07097868',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('donnola','n#01937841 n#01938471',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biglietto_del_treno','n#04893692',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assorbente','n#10458204',NULL,'a#00007608',NULL);
INSERT INTO italian_index VALUES ('mugil_cephalus','n#02091509',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cefalo_mazzone','n#02091509',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dissolvenza_in_chiusura','n#N0000588 n#05466461',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abito_da_sposa','n#02336470',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vestito_da_sposa','n#02336470',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intelaiatura','n#03860008 n#02217607 n#03343262',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cartella','n#09612224 n#02338425 n#02678015 n#02708651 n#03159967 n#03275700 n#09664211',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('titolo_a_reddito_fisso','n#09612224',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ingresso_degli_artisti','n#03398024',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_dell''angola','n#09846318',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dalmata','n#07200060 n#01619862',NULL,'a#02809209',NULL);
INSERT INTO italian_index VALUES ('canorità','n#03894766',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('melodia','n#03894766 n#05270417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cc','n#09793893',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('centimetro_cubo','n#09793893',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ml','n#09793893',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('millilitro','n#09793893',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prugnolo','n#08938548 n#08949530 n#08926996',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gruppo_sanguigno','n#06046149',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perimetro','n#09993826 n#03979387',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('servomeccanismo','n#03304491',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ardire','n#05399907 n#03805961 n#03807361 n#03848510',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfida','n#05399907 n#10039715 n#05399705',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imbattibilità','n#03929027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('invincibilità','n#03929027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scompartimento','n#02478646',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veglione','n#06127449',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('luscinia_luscinia','n#01082796',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('usignolo_maggiore','n#01082796',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lastricato','n#10747954 n#N0001021',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('selciatura','n#10747954 n#03097185',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assennatezza','n#04348442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buon_senso','n#04348442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buonsenso','n#04348442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('discernimento','n#04348442 n#03830684',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ponderazione','n#04348442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('senno','n#04348442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sensatezza','n#04348442',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nylon','n#03049073 n#10737937',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crepuscolo','n#10888065 n#10074204',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imbrunire','n#10888065',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('hyaena_hyaena','n#01626721',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iena','n#01626721 n#01626344',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('topo_d''acqua','n#01836567',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aggregazione','n#00700147 n#05963394',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cirio','n#N0002491',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indice_dei_prezzi_al_consumo','n#04982561 n#04982330',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contorsione','n#00259853',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sussidio','n#09571263 n#09546905 n#00782440',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('motoslitta','n#03362611',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gatto_delle_nevi','n#03362611',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veicolo_da_neve','n#03362611',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('semaforo','n#05144580',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quaresima','n#10950231',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('copisteria','n#N0000470',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('hi-fi','n#02817419',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impianto_hi-fi','n#02817419',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiaba','n#05393724 n#05063391',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brenna','n#01879572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bucefalo','n#01879572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ronzino','n#01879572 n#01882416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('secondo','n#07399842 n#10944012 n#10953688',NULL,'a#00964638 a#00996053 a#02104904 a#00964123','r#00099672');
INSERT INTO italian_index VALUES ('la','n#05139941',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esteriorizzazione','n#00597368 n#04427955',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autopsia','n#00092400',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dissezione','n#00092400',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('necropsia','n#00092400',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('necroscopia','n#00092400',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('semiasse','n#02606242',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('epilessia','n#10137704',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mal_caduco','n#10137704',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malcaduco','n#10137704',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('psicopatico','n#07510347',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cecoslovacchia','n#06436794',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('semicerchio','n#09996004',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('semicircolo','n#09996004',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diapheromera_femorata','n#01735320',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riso_selvatico','n#05838353 n#08451879',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riso_nero','n#05838353',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riso_canadese','n#05838353',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immaginario','n#04448372',NULL,'a#01867858 a#00591091',NULL);
INSERT INTO italian_index VALUES ('immaginazione','n#04448372 n#04356524 n#04357833',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alacrità','n#03949879 n#03655835 n#03654105',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prontezza','n#03949879 n#03949507',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sollecitudine','n#03949879',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sveltezza','n#03949879 n#04352214',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aratura','n#00589929',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('catodo','n#02405602 n#02637497',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('supplì','n#N0002043',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lanuggine','n#01412402',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lanugine','n#01412402',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('peluria','n#01412402',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ribaditrice','n#03243526',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rivettatrice','n#03243526',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('batteria','n#02737158 n#02890425 n#05965070 n#06207838 n#02265902',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brusca','n#02535919',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('striglia','n#02535919',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piallatura','n#N0001455',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('choc','n#05583116',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ridarella','n#05333102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riderella','n#05333102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risarella','n#05333102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('superfecondazione','n#05533524',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indice','n#04313265 n#04981133 n#04871504 n#04984365',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('costolatura','n#03237528',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vincita','n#09541448',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impulso','n#00785238 n#05522821 n#05448312 n#06661163 n#03932233 n#00065905',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spinta_propulsiva','n#00785238',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('phleum_pratense','n#08437301',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('codolina_comune','n#08437301',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bacheca','n#02350716 n#02397742',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('serigrafia','n#00600613',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('centigramma','n#N0000348',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('centigrammo','n#N0000348',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cg','n#N0000348',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('procellaria','n#01572527',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('laccamuffa','n#10721472',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tornasole','n#10721472',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quarantennio','n#N0001631',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('preistoria','n#10958608',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colorante_alimentare','n#05623076',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('peseta','n#09852930',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('peseta_spagnola','n#09852930',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gelidezza','n#03917029',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esperienza','n#04468129 n#04589992 n#04441868 n#05434281',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sperimentazione','n#04468129',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('motonautica','n#N0001242',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compasso_a_punte_fisse','n#02584212',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bastone','n#03412867 n#02375901 n#03397031 n#03546198',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ente_nazionale_aeronatuco_e_spaziale','n#06057400',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('n.a.s.a.','n#06057400',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vinco','n#09025107',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('la_rocca_e_il_fuso','n#10410850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('matronimico','n#04779552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('libro_di_ricette','n#04833225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bechamel','n#05869527',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('besciamella','n#05869527',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ambientalismo','n#N0000048 n#N0000049',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cenere','n#10588962',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('genesi','n#05458618',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('origine','n#05458618 n#06037572 n#06277452 n#05459242 n#04600488 n#03852754 n#06275359 n#05460141',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bananiera','n#02245116',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prosegretario','n#N0002247',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vicesegretario','n#N0002247',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('effluente','n#10656527',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sottotenente','n#07556118',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decimale','n#09890527 n#09761806',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paramedico','n#07455998',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('manovella','n#02516418',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('isomorfismo','n#03728209',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anello','n#09387915 n#03241823 n#03495284 n#02829005 n#03241409 n#07775154',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_cinese','n#09867249',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('roditore','n#01831351',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coccarda','n#03254133 n#05424763 n#02463882',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rosetta','n#03254133 n#05424763',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('microfiche','n#02994687',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('microscheda','n#02994687',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('linguaggio_dei_muti','n#05145873',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('castratura','n#00179384 n#00434336',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('castrazione','n#00179384 n#00179647 n#00434336',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('emasculazione','n#00179384',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('restituzione','n#00054744 n#00801627',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riconsegna','n#00054744',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impresa_controllata','n#N0002693',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rappresentatività','n#N0001675',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pastorale','n#05423906 n#01957491 n#05281597',NULL,'a#02675993 a#02649313',NULL);
INSERT INTO italian_index VALUES ('portone','n#N0001550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cappotto','n#02460986 n#05557758',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tendine_di_achille','n#04322678',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gemmologia','n#N0000825',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contro','n#04986392',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eccitazione','n#00819282 n#10111097 n#00818927 n#00547740',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('infiammazione','n#00819282 n#10287872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sorella','n#W0021148 n#07579639 n#07579443 n#07579801 n#W0021147',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbaraglino','n#00322887',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tric-trac','n#00322887',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('murena','n#02020036',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attinometro','n#02164296',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conto_di_risparmio','n#09623616',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pompa_per_l''aria','n#02175434',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('manifestino','n#05411950',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('volantino','n#05411950',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('volantino_pubblicitario','n#05411950',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('depliant','n#05411950',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dépliant','n#05411950',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pieghevole','n#05411950',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pastello_a_cera','n#02517338',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('emissario','n#07239996 n#04167133',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('artrite','n#10198035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calidris_canutus','n#01540702',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piovanello_maggiore','n#01540702',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('beuta','n#02645516',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sconfinamento','n#N0001836 n#00472484',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciotto','n#02463102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('codolo','n#02463102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cementite','n#10620809',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfondamento','n#N0001878 n#00628140 n#N0001879',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prodotto_chimico','n#10622194',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('breeding','n#00587652',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('selettocoltura','n#00587652',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carduelis_spinus','n#01054148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lucarino','n#01054148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lucherino','n#01054148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lugarino','n#01054148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lugaro','n#01054148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stiratoio','n#N0002008',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('determinista','n#07258025',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fatalista','n#07258025',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pancone','n#03630034',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banco_da_lavoro','n#03630034',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polipo','n#01424198 n#10226335',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('merceologia','n#N0001161',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incursione','n#00472651 n#00627831 n#00629095 n#00505430',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('domani','n#10964560 n#10849807 n#10877003',NULL,NULL,'r#00473486');
INSERT INTO italian_index VALUES ('demanio','n#N0000534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elemento_chimico','n#10473879',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('centaurea','n#08594958',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soldato','n#01711727 n#07591125',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mnemonica','n#04377381',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mnemotecnica','n#04377381',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('devoluzione','n#09537452',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_boliviana','n#09853057',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parola_d''_ordine','n#05004524',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('password','n#05004524',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('epitelio','n#04069355',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('performance','n#00359430 n#00061811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('po','n#06828569 n#N0002438',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caffettiera_elettrica','n#02466230',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('implorazione','n#05371877 n#05374056',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('supplica','n#05371877',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricco','n#07066715 n#07394492',NULL,'a#01950464 a#00589115',NULL);
INSERT INTO italian_index VALUES ('olio_di_colza','n#08187902',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imperialismo','n#04994987',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dì','n#10883946',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('città','n#06287351 n#06296380 n#06382213 n#06106897',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('metropoli','n#06287351',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lava','n#10713535',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iraniano','n#07024154',NULL,'a#02821652',NULL);
INSERT INTO italian_index VALUES ('persiano','n#07024154 n#10585696 n#05229792 n#01632210',NULL,'a#02821652',NULL);
INSERT INTO italian_index VALUES ('neurastenico','n#07302887 n#07430316',NULL,'a#02834191',NULL);
INSERT INTO italian_index VALUES ('nevrastenico','n#07302887 n#07430316',NULL,'a#02834191',NULL);
INSERT INTO italian_index VALUES ('schnauzer_gigante','n#01607607',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('record','n#00036443 n#09769589',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('suolo','n#10647622',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arrampicatore','n#07588664 n#07421243 n#07160864',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('arrivista','n#07588664',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('social_climber','n#07588664',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bagnaiolo','n#07373907',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bagnante','n#07373907',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bagnino','n#07373907',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('triumvirato','n#05983594',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('triunvirato','n#05983594',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('passaggio_pedonale','n#03100320',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monte_miletto','n#N0002347',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capreolus_capreolus','n#01929531',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capriolo','n#01929531 n#01929714',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scaglione','n#01929531',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affronto','n#00794619 n#05036589',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ingiuria','n#00794619 n#05036589',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('insulto','n#00794619 n#05036589',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('offesa','n#00794619 n#05036589 n#00630513',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oltraggio','n#00794619 n#05036589',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capovolgimento','n#05478068 n#00152824 n#00223506',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rovesciamento','n#05478068',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('genzianella','n#08598332',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cagliaritano','n#N0000232',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('timo','n#04136240 n#09168475',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pompelmo','n#05785955 n#09009380',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ultimogenito','n#N0002195',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('favoreggiatore','n#07057568',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nizzardo','n#N0001289',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('derivato','n#04758399 n#02361643',NULL,'a#00665796 a#00663810',NULL);
INSERT INTO italian_index VALUES ('amelia','n#10379021',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gommapiuma','n#10668114',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disperso','n#N0000581',NULL,'a#00506274',NULL);
INSERT INTO italian_index VALUES ('missing','n#N0000581',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('collaboratrice','n#07164888',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compagno','n#07164888 n#07174252 n#07172243 n#07128110',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cooperatore','n#07164888',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('partner','n#07164888',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('socio','n#07164888 n#07087841',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mondariso','n#N0001214',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mondina','n#N0001214',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risaiolo','n#N0001214',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sente','n#09850128',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sente_del_lesotho','n#09850128',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('borro','n#02596825',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accontentamento','n#05599694',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('appagamento','n#05599694 n#10075968',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contentamento','n#05599694',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contentatura','n#05599694',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('godibilità','n#05599694',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soddisfacimento','n#05599694 n#10075968',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imposta_municipale','n#N0002778',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carrista','n#07630406',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deviatore','n#07575759 n#07627103',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pony_delle_shetland','n#01882796',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impresa_commerciale','n#06011240',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('laringite','n#10295861',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contrappello','n#N0000459',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avvenimento','n#05447746 n#05538537 n#05432762',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amputazione','n#00433627 n#04844766',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('franco_del_lussemburgo','n#09841069',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('estone','n#05217277',NULL,'a#02731077',NULL);
INSERT INTO italian_index VALUES ('wolframite','n#10837083',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cotonatura','n#N0000494',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scisma','n#00248000',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scissione','n#00248000 n#09714561 n#09703403',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malaysia','n#06546136',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malesia','n#06546136',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('servizi_segreti','n#06182763',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('transizione','n#05480908 n#05303065 n#05519358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gruccione','n#01345872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('merope','n#01345872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vespiere','n#01345872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cast','n#06114774',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carcharhinus_plumbeus','n#01013472',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('squalo_grigio','n#01013472',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dollaro_australiano','n#09834813',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eczema','n#10222950',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esantema','n#10222950',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfacchinata','n#00024789',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tour_de_force','n#00024789',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esoticità','n#03765404',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fotocompositore','n#N0000769',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cancerologo','n#07443929',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('oncologo','n#07443929',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('olivina','n#10525982',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('peridoto','n#10525982 n#10749415',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imboscato','n#07583177',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lazzarone','n#07583177',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lazzerone','n#07583177',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pelandrone','n#07583177 n#07333550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scossa_di_assestamento','n#05526897',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('servosterzo','n#03168366',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('media_armonica','n#04611083',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('retrobottega','n#N0001698',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reattore','n#03046989 n#03215867 n#02875044 n#02875211',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reattore_nucleare','n#03046989',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('match_point','n#09780978',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gaudio','n#05596218',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gioia','n#05596218 n#02875598 n#07348247 n#04490585 n#05596105 n#05596527',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('letizia','n#05596218',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('hydrochoerus_hydrochaeris','n#01866573',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capibara','n#01866573',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capivara','n#01866573',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foro_di_proiettile','n#06737304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trascrizione','n#04787843 n#04787636 n#04882005',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('traslitterazione','n#04787843',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esercito','n#06082744 n#06082453 n#06089493 n#06091847',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tanaro','n#N0002287',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accettazione','n#05364555 n#04696956 n#00117820 n#09637543 n#00055481',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('adesione','n#05364555 n#00117820 n#00786193 n#05364269 n#03861527',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('governo_d''alema','n#W0020776',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tirapugni','n#02331862',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pattinatoio','n#03242176',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pista_di_pattinaggio','n#03242176',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giardino_zoologico','n#02985143',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zoo','n#02985143',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bronzatura','n#N0000204 n#N0000205',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('testa_di_serie','n#07561913',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deltaplano','n#00196652 n#02797233',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elevamento','n#05488391',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('elevazione','n#05488391 n#05492038 n#00074216 n#06692424',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('innalzamento','n#05488391',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rialzamento','n#05488391',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rialzo','n#05488391 n#03956465 n#00234220',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carboniera','n#03484730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tender','n#03484730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mausoleo','n#02974845',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('callo','n#10305854 n#10305672 n#09382701',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ipotesi','n#05079860 n#04528260 n#04526699 n#05355820 n#05060508',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('supposizione','n#05079860 n#04455915 n#04528519',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('financial_times','n#W0020819',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('novità','n#04982831 n#03766226 n#03855074 n#04358717',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nuova','n#04982831 n#04983034',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('novella','n#04982831 n#05392977 n#04803505',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trascuratezza','n#10402014 n#03677496 n#00476598 n#10348672',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('molo','n#03120538 n#03608465 n#03195486',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giocosità','n#03665167 n#03665047',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carattere_giocoso','n#03665167',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('demonizzazione','n#N0000537',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alzata','n#03243117 n#02635355',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frontalino','n#03243117',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('persona_indesiderabile','n#07655806',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scaglionamento','n#N0001799',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rarefazione','n#05521666',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('allergologo','n#07070659',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('latifondo','n#N0001024',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gros-grain','n#02774023',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giurato','n#07352838',NULL,'a#02260093',NULL);
INSERT INTO italian_index VALUES ('pielonefrite','n#10444692',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiazza','n#03689246 n#03696915 n#03696712',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macchia','n#03689246 n#03696524 n#03696915 n#03696712 n#06241700 n#00043135',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('patacca','n#03689246',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piazzata','n#03689246',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('screziatura','n#03689246',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tempi_della_scuola','n#10871018',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cartone','n#10615963 n#02394238',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lago_d''isea','n#N0002307',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coramella','n#03431453',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lussemburgo','n#06544984 n#06544663',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inganno','n#00486766 n#03686637 n#04495302 n#00485108 n#00111383 n#00498592 n#00486495 n#04898507',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sarong','n#03274970',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inconscio','n#04347243',NULL,'a#00538832',NULL);
INSERT INTO italian_index VALUES ('tic','n#05506384 n#10303785',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tic_tac','n#05506384 n#05506524',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ticche','n#05506384 n#05506524',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ticchettio','n#05506384',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cencioso','n#07487791',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disgraziato','n#07487791 n#07688887',NULL,'a#00863871',NULL);
INSERT INTO italian_index VALUES ('meschino','n#07487791',NULL,'a#00281802 a#00109260 a#00601207',NULL);
INSERT INTO italian_index VALUES ('miserabile','n#07487791 n#07666308 n#07688887',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('poveraccio','n#07487791',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfortunato','n#07487791',NULL,'a#01407688',NULL);
INSERT INTO italian_index VALUES ('sventurato','n#07487791',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fotometro','n#03114614',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('campagnolo','n#07464618 n#07464910 n#07188669',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('provinciale','n#07464618',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alto_rielievo','n#03227532',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rilievo','n#03227532 n#10356373 n#10356224',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('appassionato_di_teatro','n#07481333',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fohn','n#07788096',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foehn','n#07788096',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('analizzatore','n#03279906 n#02187303 n#07074308',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scanner','n#03279906',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('senecione','n#08319419 n#08319561',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crostino_al_formaggio','n#05907474',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('barella','n#03428143',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lettiga','n#03428143 n#02932973',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fiera','n#06218045 n#06217283',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clemenza','n#10415852 n#03785586 n#00693354 n#03786100',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mitezza','n#10415852 n#03669235',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('smerigliatrice','n#02611152',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('minzione','n#09717059',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orinata','n#09717059',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orinazione','n#09717059',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('urinata','n#09717059',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('urinazione','n#09717059',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indonesia','n#06512746',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radiobussola','n#03203353',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tetraggine','n#10418027 n#05614606 n#03660911',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('icona','n#05425814 n#02847928',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('traumatologo','n#N0002151',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abolizione','n#00148356',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soppressione','n#00148356 n#00145467',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assegno_in_bianco','n#09639078',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giardino','n#03638970 n#02738912 n#02739225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lobotomia','n#00440784',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vegetazione','n#06240750 n#06241562 n#09440702',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ministero_della_difesa','n#06058911',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buona_grazia','n#03846037',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buonagrazia','n#03846037',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('civiltà','n#03846037 n#06046883 n#03847083 n#03846287',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compiacenza','n#03846037 n#03794578',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contegno','n#03846037 n#00792210',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cortesia','n#03846037 n#05036276 n#00795713 n#00796730 n#03793754 n#00020804',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('creanza','n#03846037',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('garbatezza','n#03846037 n#03846287',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('garbo','n#03846037 n#00796865 n#03908392 n#03775722',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gentilezza','n#03846037 n#00795713 n#00796730 n#00796572 n#03793754 n#00020804 n#03669235',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salvia','n#09164175 n#09162920',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('kochia_scoparia','n#08142303',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('belvedere','n#08142303 n#02280937',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('granata_comune','n#08142303',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veicolo_ferroviario','n#W0005542',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('consumatore','n#06943718',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fruitore','n#06943718',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('utente','n#06943718 n#07658488',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('utilizzatore','n#06943718',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('muratura','n#00401664 n#02970128',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('burriera','n#02359531',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('portaburro','n#02359531',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indice_di_paasche','n#N0002662',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('genealogia','n#06037387 n#06037992',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pedigree','n#06037387 n#03852918',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('toscano','n#07026404 n#05223063',NULL,'a#02736771',NULL);
INSERT INTO italian_index VALUES ('idra','n#01426297',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('hyoscyamus_niger','n#09202048',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giusquiamo_nero','n#09202048',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('taglia','n#03974960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('toluene','n#10814807',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cisterna','n#02444973 n#04273371 n#03468579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sud-est','n#09964545',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('visconte','n#07667486',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('savoiardo','n#N0001790',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imposta_a_aliquote_superiori','n#N0002755',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buona_fede','n#03816889 n#05595498',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buonafede','n#03816889 n#05595498',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orma','n#04984123 n#06710209',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pedata','n#04984123 n#00088506',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pesta','n#04984123',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anidride','n#10587565',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('andirivieni','n#N0000057',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ferraccio','n#10780647',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ferraglia','n#10780647',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corruzione','n#00495869 n#10441111 n#00104146',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('neofascista','n#N0001279',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('squadrista','n#N0001279',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('play','n#N0001492',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('playmaker','n#N0001492',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palato','n#04374716 n#04121211',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orione','n#06916083 n#06774941',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imboschimento','n#00256511',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricerca','n#00604336 n#00605314 n#00419681 n#04467719 n#04450363',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pelle_scamosciata','n#10584467',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pizzicorino','n#00093873',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vellicamento','n#00093873',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quadrato_latino','n#06140110',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('signorino','n#N0001897',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sucre','n#09865073',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sucre_ecuadoriano','n#09865073',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pelobate','n#01170479',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('discorsività','n#N0000576',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gruppuscolo','n#N0000879',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scopolamina','n#03284561',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('linea_telefonica','n#03479277 n#03480098',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammissibilità','n#03760593 n#03760768',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tollerabilità','n#03760593',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('c.d.','n#02478312',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cd','n#02478312',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compact_disc','n#02478312',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diluente','n#10796986',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('solvente','n#10796986',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macinacaffè','n#02466377',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macinino','n#02466377 n#03106485 n#02356871',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cespite','n#09538207',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reddito','n#09538207 n#09542885',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('utile','n#09538207 n#09540718 n#09537885',NULL,'a#01145952 a#01227156 a#02376473',NULL);
INSERT INTO italian_index VALUES ('mammola','n#07573872 n#08692491 n#08691021',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('timido','n#07573872',NULL,'a#00248588',NULL);
INSERT INTO italian_index VALUES ('rugby','n#00300322',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palla_ovale','n#00300322 n#02709998',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pallovale','n#00300322',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('centro_di_una_zona_urbana','n#06298782',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iperbole','n#05317607',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lira','n#04810130 n#02949126 n#09848825 n#01068172 n#09857332 n#09849554',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lirica','n#04810130 n#05268918',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('borsa','n#02338425 n#03326341 n#02237285 n#02236984 n#02236345 n#03417221',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('massaggiatore','n#07398450 n#07398285',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sardegna','n#06465864',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acquedotto','n#03598721 n#03599820 n#02204526 n#06085245',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('privato','n#N0001583 n#N0001582',NULL,'a#01787580',NULL);
INSERT INTO italian_index VALUES ('commercio_ambulante','n#00724183',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acciuga','n#05818740 n#02026565',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alice','n#05818740 n#02026565',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giudice','n#07350806 n#07249386',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('magistrato','n#07350806 n#07440234',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pretore','n#07350806 n#07493086',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('edificazione','n#00585093 n#04591283',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erezione','n#00585093 n#10111869 n#00585424',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('messaggeria','n#05994373',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assertività','n#04024921',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ecu','n#N0000693',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('european_currency_unit','n#N0000693',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cotonato','n#N0000493 n#02507085',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cetriolino','n#05794345 n#05756902',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caprera','n#N0002326',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capricorno','n#01915643 n#06773002',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calcolo','n#04470977 n#00558391 n#04467150 n#06673021 n#00426345',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('computo','n#04470977 n#00558391 n#00426345',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conteggio','n#04470977 n#00426345',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soprapprezzo','n#03984543',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sovrapprezzo','n#03984543',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('surcharge','n#03984543',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guado','n#06792238 n#00193005 n#08197976',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pedana','n#02710673 n#03391054 n#02710822',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tasmania','n#06480153 n#06480276',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ostruzionista','n#07428627',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('espero','n#07848617 n#09966059',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('favonio','n#07848617',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ponente','n#07848617 n#09966059',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zeffiro','n#07848617 n#07780411',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zefiro','n#07848617 n#07780411',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frangivento','n#03618764',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piccola_impresa','n#N0002708',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anaglifo','n#02186418 n#02186316',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anaglipto','n#02186418 n#02186316',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ministero_del_tesoro','n#06054116',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tesoreria','n#06054116',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('odobenus_rosmarus','n#01592957',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tricheco','n#01592957 n#01592730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tribuna','n#02766495',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lato_positivo','n#05570509',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eden','n#06313641 n#06313922',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giardino_dell''eden','n#06313641',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paradiso_terrestre','n#06313641',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incuria','n#03677496 n#10348672',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('negligenza','n#03677496 n#00476598 n#03676822',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vetturina','n#08062034',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('peeling','n#N0001412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('triestino','n#N0002166',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iran','n#06514401',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('so','n#N0002450',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sondrio','n#N0002450',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('baffo','n#03696524 n#01417234 n#04085355',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gastralgia','n#10282077',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mal_di_stomaco','n#10282077',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coma','n#04390553 n#03437074',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_dello_sri_lanka','n#09862839',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ascendente','n#10361817 n#07075378',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('algeria','n#06407281',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bos_grunniens','n#01902277',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('yak','n#01902277',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gru_a_braccio','n#W0007450',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attricetta','n#07607518',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('starlet','n#07607518',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stellina','n#07607518',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('discesa_libera','n#W0020959',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bruciamento','n#00243251',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contralto','n#07181373 n#07071833 n#05143390 n#03897030',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('solidità','n#03928898',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fr','n#N0002407',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frosinone','n#N0002407',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corsa_agli_armamenti','n#05556273',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('annesso','n#02190772',NULL,'a#01596805',NULL);
INSERT INTO italian_index VALUES ('tariffa_per_riga','n#09594793',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impenitenza','n#03810510',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amoerre','n#03008726',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('amoerro','n#03008726',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mohair','n#03008726',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('refrigerio','n#05570696',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sollievo','n#05570696 n#10364817',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('obbligazione','n#05074715 n#09603212 n#09665083',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('protezionismo','n#04993125',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interesse_con_andamento_a_gradino','n#N0002816',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fucile','n#07572840 n#03239566',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bisboccione','n#07531759',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('festaiolo','n#07531759',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('blindata','n#N0000174',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('approdo','n#02903727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banchina','n#02903727 n#06800223 n#03608465 n#03195486 n#03142589',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scalo','n#02903727 n#06362599 n#03600761',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guardarobiere','n#N0000882 n#07328132',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eruttamento','n#00075113',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eruttazione','n#00075113',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('flato','n#00075113',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rutto','n#00075113',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scopritore','n#07217968 n#07263701',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('camelina_sativa','n#08188648',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dorella_coltivata','n#08188648',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('basenji','n#01620327',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cane_del_congo','n#01620327',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capo_dell''olp','n#Y0005585',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('supinazione','n#00221595',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('banca_d''italia','n#N0002579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bankitalia','n#N0002579',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mal_volere','n#03795640',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malvolere','n#03795640',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malevolenza','n#03795640',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('testicolo','n#04278963',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coglione','n#04278963',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palla','n#04278963 n#10016225 n#W0021149 n#05063177 n#01918890 n#W0021150 n#07121483 n#W0021153 n#02350564 n#02240791 n#W0021151 n#W0021152',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('corbello','n#04278963',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('didimo','n#04278963',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abigeato','n#00620598',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gemmazione','n#09703808',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intemerata','n#05035599',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pistolotto','n#05035599',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('predicozzo','n#05035599',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sermoncino','n#05035599',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sermone','n#05035599 n#05407766',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carborundo','n#10615844',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carborundum','n#10615844',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('farmacopea','n#N0000712',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('farmacopea_ufficiale','n#N0000712',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nartece','n#03031158',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('album_di_ritagli','n#03285705',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfruttamento','n#00606479',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clio','n#06911796',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('repressione','n#09723333 n#10083617',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('discofilo','n#N0000571',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('singolo','n#00085814 n#07337458',NULL,'a#02110583 a#00693130 a#00460992',NULL);
INSERT INTO italian_index VALUES ('norna','n#06924869',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sterna','n#01554751',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spazzola','n#02343835',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pennello','n#02343835 n#03078949',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prossimità','n#03968750 n#06363890',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vicinanza','n#03968750 n#06363890',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('domenica_di_quadragesima','n#10909223',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('quadragesima','n#10909223',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('epistolario','n#N0000650',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('flotta','n#06154774 n#06154620 n#06155115',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('flotta_auto','n#06154774',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parco_macchine','n#06154774',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anima','n#07594286 n#06949059 n#05561386 n#00004123',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('psiche','n#07594286',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('treccina','n#03372822',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('display','n#02580665',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('video','n#02580665 n#03576706 n#03286767',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capo_spirituale','n#06861412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leader_spirituale','n#06861412',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carbammide','n#10822102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('urea','n#10822102',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('andata_e_ritorno','n#00199917',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('viaggio_di_andata_e_ritorno','n#00199917',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('singhiozzo','n#05334343',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clipeo','n#01418861',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nubifragio','n#07830909',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dentro','n#06333091 n#06333215',NULL,NULL,'r#00226617 r#00108036 r#00108318');
INSERT INTO italian_index VALUES ('di_dentro','n#06333091 n#06333215',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('didentro','n#06333091 n#06333215',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asparageto','n#02216571',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('asparagiaia','n#02216571',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leoncino','n#01638227 n#00866673',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('americanizzazione','n#00699688',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pagamento_eccessivo','n#09556039',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tribordo','n#03402811',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lente_di_fresnel','n#02723265',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acciaccata','n#10259769',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammaccamento','n#10259769',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammaccatura','n#10259769',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('battuta','n#10259769 n#00216657 n#05070442 n#05136601 n#00371920 n#05259958 n#00752384',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contusione','n#10259769 n#10212725',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ecchimosi','n#10259769',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('livido','n#10259769',NULL,'a#00119743',NULL);
INSERT INTO italian_index VALUES ('lividura','n#10259769',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trafugamento','n#N0002138',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('javanthropus','n#01968558',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cotta','n#05608223 n#02417403 n#03449611 n#00158465',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('infatuazione_giovanile','n#05608223',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capo','n#06950891 n#00012704 n#04290247 n#07273905 n#03424890 n#03148546 n#06314878 n#06746227 n#00863895 n#07311393',NULL,'a#01224413',NULL);
INSERT INTO italian_index VALUES ('leader','n#06950891 n#N0002707',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capintesta','n#06950891',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('console','n#02489305 n#07180418',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('il_saper_far_di_conto','n#04361663',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('celioscopia','n#00440179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('laparoscopia','n#00440179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbadiglio','n#00537182',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('interstizio','n#02864974',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('no','n#09966534 n#N0002425 n#05383289',NULL,NULL,'r#00022819');
INSERT INTO italian_index VALUES ('nord-ovest','n#09966534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nordovest','n#09966534',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eufuismo','n#04800206',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marmitta','n#03337486 n#02967886 n#02368898 n#05640599',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('silenziatore','n#03337486',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fumaiolo','n#02430555 n#03358889',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('secchio_del_carbone','n#03291074',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spergiuro','n#00493430 n#07469196',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avitaminosi','n#10205636',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disvitaminosi','n#10205636',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ipovitaminosi','n#10205636',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('becco','n#01913506 n#02355821 n#01278388 n#03020865 n#03389835 n#04115406 n#07195968',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capro','n#01913506',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caprone','n#01913506',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('irco','n#01913506',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agrimonia_eupatoria','n#08922954',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agrimonia_comune','n#08922954',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eupatoria','n#08922954',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diffidenza','n#03834482 n#03834330 n#04402984',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sospettosità','n#03834482',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('illusione','n#04561043 n#04531761',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('controprova','n#N0000465',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riscontro','n#N0000465 n#04486906',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cystophora_cristata','n#01592232',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foca_dal_cappucio','n#01592232',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fresco','n#03917363 n#03917136',NULL,'a#01014707 a#02407953',NULL);
INSERT INTO italian_index VALUES ('frescura','n#03917363 n#03917136',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bordino','n#03540622 n#02693940',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guarnizione','n#03540622 n#05670070 n#02741671 n#02550579 n#02744152',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('microclima','n#N0001184',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('settuagenario','n#07565305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('francesismo','n#05298941',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gallicismo','n#05298941',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marcia_di_protesta','n#00763586',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('altezza','n#03998479 n#07320004 n#09967534 n#03907531 n#03895810 n#04002418 n#04002199 n#03815621',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('livello_delle_acque','n#03998479',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bubbone','n#10275325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agropyron_repens','n#08412372',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gramigna','n#08412372',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gramigna_comune','n#08412372',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maniero','n#02402089',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('paese_arabo','n#W0020843',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mielina','n#10732531',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giacobino','n#07346582',NULL,'a#02822477',NULL);
INSERT INTO italian_index VALUES ('polinomio','n#04511577',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bandista','n#07100166',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('musicante','n#07100166',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cane_delle_praterie','n#01860523',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cinomio','n#01860523',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parte_del_discorso','n#04766538',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calce_spenta','n#10717059',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calcina','n#10717059 n#10731399',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('idrossido_di_calcio','n#10717059',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coryphaena_hippurus','n#02072266',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lampuca','n#02072266',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lampuga','n#02072266',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('superlativo','n#04770664',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('importunità','n#03714036',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inopportunità','n#03714036',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stonamento','n#03714036',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polemista','n#N0001509 n#N0001508',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('petroliere','n#N0001450 n#07441892',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('manioca','n#09224515 n#09224191',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('configurazionismo','n#04668664',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gestaltismo','n#04668664',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('larice','n#07936641 n#07936366',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('astuzia','n#03820832 n#04353829 n#03820577 n#00111383 n#04353391 n#04353291',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('furberia','n#03820832 n#04353829 n#03820577',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fuggi_fuggi','n#00727893',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fuggifuggi','n#00727893',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vuoto','n#02637740 n#10024042',NULL,'a#01034130 a#01437546',NULL);
INSERT INTO italian_index VALUES ('collimatore','n#02471931 n#02471693 n#03480963',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fondina','n#03372157 n#02825203',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piatto_fondo','n#03372157',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scodella','n#03372157 n#02321913',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('celebrità','n#07145223 n#07607210 n#10359466 n#10358202 n#10359681',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vergine','n#07667236',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raccozzamento','n#00781305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rappacificamento','n#00781305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rappacificazione','n#00781305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riavvicinamento','n#00781305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riconciliazione','n#00781305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riunione','n#00781305 n#06166238 n#05979656 n#00798100 n#06071059 n#05978845',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('susina_regina_claudia','n#05787780',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sionismo','n#04996622',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bisezione','n#00247828',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cervino','n#N0002333 n#06720532',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gladiolo','n#08719255',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prospettore','n#07507820',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fibrillazione_atriale','n#10304064',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scala_graduata','n#03279411',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marcatore','n#N0001128 n#07553014',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prometeo','n#06919650 n#10498261',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ibis','n#01517741',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gerber','n#N0002516',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ozono','n#10743437',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('drenaggio','n#00253857',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orbita','n#06373430 n#04102305 n#03993027 n#06345096',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parochetto','n#01338503 n#02714421',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parrocchetto','n#01338503 n#02714421',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brandello','n#03206762 n#06687090',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brindello','n#03206762',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbrindello','n#03206762',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lathyrus_nissolia','n#08841392',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cicerchia_semplice','n#08841392',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('odio','n#05609785 n#05577810',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('beduina','n#03059051',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('levitico','n#04848367',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scatola_di_colori','n#03078829',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pistaiolo','n#N0001484',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pistard','n#N0001484',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cuoio','n#10580335 n#10580693',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pellame','n#10580335',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pelle','n#10580335 n#01411738 n#10580693 n#05774945 n#04068217',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('unità_monetaria_argentina','n#09826031',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cartoleria','n#N0000308',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('righello','n#03261562',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('righino','n#03261562',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cardiologo','n#07139318',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zannichellia_palustris','n#08918202',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zannichellia','n#08918202',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tonno','n#05815870 n#02116293',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('semifinalista','n#07563576',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('melo','n#08933472',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falsopiano','n#N0000706',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mimetismo','n#00659588',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mimetizzazione','n#00659588',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strada_laterale','n#03553342',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lago_maggiore','n#N0002303',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('erpete','n#10165461 n#00875334',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('herpes','n#10165461 n#00875334',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sipario','n#02608114',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('telone','n#02608114 n#03473307',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rettangolo','n#10002392',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('suite','n#05283837 n#03439283',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vespula_maculifrons','n#01717843',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('romano','n#07025774 n#N0001739',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marciapiede','n#03335176',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marciapiedi','n#03335176',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('doppiofondo','n#N0000608 n#N0000609',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('claque','n#06104407',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fedelissimi','n#06104407',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sapore_piccante','n#03900814',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coltello','n#02893681 n#02893138 n#02295763',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('builder','n#10831619',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ilmenite','n#10521630',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ufficio_italiano_dei_cambi','n#N0002676',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fialetta_puzzolente','n#03414977',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('domenica_di_passione','n#10908418',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('burnus','n#02355969',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assalto','n#00625655 n#05447302 n#00627012 n#00628970',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pennichella','n#00551029 n#00550869',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pisolino','n#00551029 n#00550869',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('siesta','n#00551029',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stoppa','n#N0002013',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cucurbita_pepo','n#08464304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cocuzza','n#08464304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cucurbita','n#08464304 n#08463546',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cucuzza','n#08464304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zucchette','n#08464304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zucchini','n#08464304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mentalità','n#04697607',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('drappello','n#06096872 n#06100095',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('plotone','n#06096872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('soggolo','n#03618204',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frigobar','n#03002650',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cerebroleso','n#N0000343',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dono','n#09545388 n#09548218',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ragalo','n#09545388',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('regalo','n#09545388',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stenografo','n#07609921',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('editoria','n#00713952',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agonizzante','n#N0001233 n#N0001231',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('moribondo','n#N0001233 n#N0001231',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ritualista','n#07535447',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciliati','n#00922148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autoinganno','n#04531344',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('termoregolatore','n#03494781',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('termostato','n#03494781',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bistecchiera','n#02341754 n#02771906 n#02771201',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('griglia','n#02341754 n#02771906 n#02772072 n#02771201 n#02771323',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frantoio','n#02528299',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frantumatore','n#02528299',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('granitrice','n#02528299',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('granulatore','n#02528299',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pistrino','n#02528299',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('campo','n#06304468 n#07798336 n#W0021124 n#04557315 n#00710890 n#03993027 n#06317328 n#06317549 n#10410497 n#06258431 n#05995397 n#04594727 n#02372560 n#06378285 n#06727012 n#06318048',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('posta_ordinaria','n#04968585',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pachiderma','n#01948883',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pachidermo','n#01948883',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perplessità','n#04393934',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('emendamento','n#00811685 n#00811999 n#05041525',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coprimozzo','n#02840331',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cassia','n#08792874 n#08016612',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spigolo','n#02621337',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pastinaca_sativa','n#09238805',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pastinaca','n#09238805',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pastinaca_comune','n#09238805',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cuscino_gonfiabile','n#02171532',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('memoria_virtuale','n#03580131',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mossa','n#00796865 n#00107819 n#00108013 n#00213518',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mortificazione','n#05580938',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('feticismo','n#10111578 n#00675207',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('programmazione_logica','n#00595942',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chemisier','n#03321595 n#03320964',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cicerone','n#07706187 n#07157042',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ottavo','n#09892325 n#03975597',NULL,'a#02105827',NULL);
INSERT INTO italian_index VALUES ('bromo','n#10481572',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('miracolato','n#N0001196',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bicipite','n#04323035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('internista','n#N0000990',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiudenda','n#03332110',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chiudendola','n#03332110',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('persiana','n#03332110 n#02872351',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fm','n#04747736',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('modulazione_di_frequenza','n#04747736',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('persecutore','n#07644570',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deprecazione','n#05032127',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disapprovazione','n#05032127 n#00791599 n#04700409 n#05577411',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riprovazione','n#05032127 n#00791599 n#05032520 n#04700706 n#05577411',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('blasone','n#10354378 n#02462414',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bongustaio','n#07177748 n#07245979',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buongustaio','n#07177748 n#07245979',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conoscitore','n#07177748',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('estimatore','n#07177748',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gustatore','n#07177748',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intenditore','n#07177748',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riguardatore','n#07177748',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tazzina','n#02554304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tazzina_da_caffè','n#02554304',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pentola_a_pressione','n#03171208',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('inflazione','n#09727083',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cacao','n#05790861 n#08506700 n#05790671',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('streptomicina','n#03427745',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ku_klux_klan','n#06215782',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agente_immobiliare','n#07521354',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polo_nord','n#06344902',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pr','n#N0002428',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parma','n#N0002428',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acchiappamosche','n#07333550 n#07199951 n#03453313',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciondolone','n#07333550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('infingardo','n#07333550 n#07585698',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('michelaccio','n#07333550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ozioso','n#07333550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('poltrone','n#07333550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('poltroniere','n#07333550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('poltroniero','n#07333550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scioperato','n#07333550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfaccendato','n#07333550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sfaticato','n#07333550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vitellone','n#07333550',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mondo_dei_sogni','n#06297506 n#06344270',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reostato','n#02571784 n#03237030',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immaginativa','n#04356524',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lc','n#N0002415',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lecco','n#N0002415',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diaproiettore','n#03352193',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('proiettore_per_diapositive','n#03352193',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('patto','n#05073174 n#05074858 n#05072418',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('titanio','n#10505231',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diciottesimo','n#09977394',NULL,'a#02107031',NULL);
INSERT INTO italian_index VALUES ('spazzola_per_capelli','n#02783676',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('naturopata','n#07428232',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giuba','n#03550561',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giubba','n#03550561',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gondwana','n#06842401',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riscossione','n#N0001727 n#00656313',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('parto','n#09701762',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fascetta','n#N0000713 n#02829005',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disobbedienza','n#03843872 n#00764013',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disubbidienza','n#03843872 n#00764013',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nairobi','n#06523703',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('anaconda','n#01263578',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caposcuola','n#07108901',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tonsura','n#00163474 n#04291260',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('brassica_oleracea','n#08183736 n#08183904',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cavolo_comune','n#08183736 n#08183904',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nettezza','n#03701157 n#03779450',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nitidezza','n#03701157 n#03779450',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avello','n#02768416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sepolcro','n#02768416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tomba','n#02768416',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piombaggine','n#08405622 n#10613395 n#08405743',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('atleta','n#07089646',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giudicato','n#04480350',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('phoca_vitulina','n#01591030',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foca','n#01591030 n#01587481 n#10586464',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foca_vitulina','n#01591030',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vicepresidente','n#07664428 n#07664782',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trombone','n#07652419 n#07285942 n#08723548 n#03543147',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trombonista','n#07652419',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orticaria','n#10278645',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('urticaria','n#10278645',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grilletto','n#02780362',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ampolla','n#03257705 n#02185656 n#04079811 n#02527262',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('matraccio','n#03257705',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sv','n#N0002448',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('savona','n#N0002448',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ammanco','n#09649064',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deficit','n#09649064 n#03986577 n#10377440',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disavanzo','n#09649064 n#03986577',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sbilancio','n#09649064',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('newton','n#09812200',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ovile','n#02708549',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stazzo','n#02708549',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('xilene','n#10839553',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stampigliatura','n#N0001990 n#05128899',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('confine','n#06279059 n#06336706 n#06279444 n#10019535',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trapasso','n#04914308 n#00556773',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tabellone_segnapunti','n#03284884',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pensionato','n#07467651 n#02825467',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gallio','n#10486962',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rossore','n#10119971 n#10287872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leggibilità','n#03779347 n#03778983',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('insalubrità','n#03758904 n#03759969',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('abbassamento','n#00227277 n#03985255 n#00225760',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accondiscendenza','n#03660241',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('condiscendenza','n#03660241',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('correntezza','n#03660241',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('obbedienza','n#03660241',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('remissività','n#03660241 n#10342197 n#03841705',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capolavoro','n#00021866 n#02971335',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avo','n#09852730 n#07075378 n#07272755 n#07299261',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avo_di_macao','n#09852730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('analgesia','n#10435148',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('astronavigazione','n#00521727',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lampada_da_notte','n#N0001080',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lumino','n#N0001080',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('veilleuse','n#N0001080',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fumeria_d''oppio','n#03059944',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spiritismo','n#04569072',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('correlazione','n#09972198 n#09973673 n#04617294',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('associato','n#07087841 n#07088196',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('consociato','n#07087841',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('membro_aggregato','n#07087841',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('socio_aggregato','n#07087841',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cachi','n#09070197 n#09069999 n#05782382',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('kaki','n#09070197 n#09069999 n#05782382',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('viverra','n#01643848',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zibetto','n#01643848',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('porno','n#00481584',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pornografia','n#00481584',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strada','n#00112808 n#00266805 n#03426236 n#06389665 n#03243979 n#03092396',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('materialista','n#07400426 n#07400558',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autostrada','n#02653712 n#02227565',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('superstrada','n#02653712',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cadra_cautella','n#01793192',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tignola_dei_fichi_secchi','n#01793192',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('samson','n#N0002552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('samson_srl','n#N0002552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('santiago','n#06417096',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affievolimento','n#05455528 n#05455349',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('evanescenza','n#05455528',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('saprofita','n#09414897',NULL,'a#02777326',NULL);
INSERT INTO italian_index VALUES ('saprofito','n#09414897',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('citostoma','n#00984443',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('massimalismo','n#N0001145',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('facchinata','n#00409199',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('norcino','n#07488351',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salsicciaio','n#07488351',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('digitalis_lutea','n#09181007',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('digitale_gialla_piccola','n#09181007',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salmo_salar','n#02028269',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filetti_di_salmone_svedesi','n#02028269',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salmo','n#02028269 n#04857558',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salmone','n#02028269 n#02027484 n#05830086',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salmone_atlantico','n#02028269',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salmone_del_reno','n#02028269',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salmone_kipper','n#02028269',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('binario','n#02927421 n#03526208',NULL,'a#02521946',NULL);
INSERT INTO italian_index VALUES ('linea_ferroviaria','n#02927421',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zampirone','n#N0000905',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canna','n#03062930 n#08443317 n#02375901 n#02253986 n#02523262 n#02878553',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('samurai','n#06207492 n#07544547',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raddobbo','n#00749712',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('meretricio','n#00482009',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prostituzione','n#00482009',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pastificio','n#N0001398',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polimerizzazione','n#09687284',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('museo','n#03024989',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('animosità','n#05611157',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eterosessualità','n#00550276',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gonna_pantalone','n#02532788',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('comunardo','n#07532433',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eversore','n#07532433',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rivoluzionario','n#07532433',NULL,'a#01583589',NULL);
INSERT INTO italian_index VALUES ('sovvertitore','n#07532433',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stringatezza','n#05303718',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contratto_a_premio_del_venditore','n#00049251',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contratto_a_premio_pour_livrer','n#00049251',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contratto_a_premio_put','n#00049251',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('traccia','n#04488073 n#04984365',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fanfara','n#06123663 n#05129846 n#06123540',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('francesco_de_gregori','n#W0020995',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('risalto','n#10031624',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orcadi','n#06539677',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cineromanzo','n#N0000774',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fotoromanzo','n#N0000774',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('travestito','n#07649671',NULL,'a#02010891',NULL);
INSERT INTO italian_index VALUES ('quadrica','n#10018783',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carter','n#03441316',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('copricatena','n#03441316',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cenobita','n#07527126',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ne','n#09963574',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nord-est','n#09963574',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nordest','n#09963574',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cannone','n#10017486 n#02376829 n#02376667 n#07059467',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colpo_di_rimbalzo','n#00372660',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lebbra','n#10168619',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('indumenti_per_la_notte','n#03040638',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avvitamento','n#00198358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immanentismo','n#N0000923',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dravida','n#06992055',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('multa_per_sosta_vietata','n#04923314',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piattaforma','n#03142093 n#04879303',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macedone','n#05207532 n#07029233',NULL,'a#02827204',NULL);
INSERT INTO italian_index VALUES ('cavillatore','n#07516979',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assodamento','n#09671986',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('solidificazione','n#09671986',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('naturalizzazione','n#00768576',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('plenipotenziario','n#07481975',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('consonante','n#05324819 n#05325089',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('reginetta','n#N0001689',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('boccio','n#09449734 n#07991350',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bottone','n#09449734 n#02360329 n#07991350',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gemma','n#09449734 n#02875598 n#07348247',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('occhio','n#09449734 n#04122028 n#04348269',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('virgolette','n#05127132',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incisione','n#00602550 n#03470688 n#00584453 n#00248910 n#00439010 n#00600227 n#10258725 n#02396166 n#02640877',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('castagna_d''acqua','n#08651537 n#08651761',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('runa','n#05123724',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autorevolezza','n#04045518 n#10357033',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('potestà','n#04045518',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('precorrimento','n#04454423',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prefigurazione','n#04454423',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('decadentista','n#N0000524',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciprinide','n#00965655',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lavoratore_socialmente_utile','n#W0020935',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alzacristallo','n#N0000047',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('poseidone','n#06913790',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('apnea','n#10309796',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('legatore','n#07119896',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rilegatore','n#07119896',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fantaccino','n#07337801',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fante','n#07337801 n#02869683',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pomo','n#02895592 n#05775435',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acer_negundo','n#09054389',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acero_americano','n#09054389',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gruppo_di_coetanei','n#06196890',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('legno_duro','n#10834399',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('otto','n#09896866',NULL,'a#02099599',NULL);
INSERT INTO italian_index VALUES ('saturno','n#06755026',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calcatura','n#N0001472',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pigiatura','n#N0001472',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ricalco','n#N0001472',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ministero_dell''industria','n#Y0005556',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aspiratore','n#02651248 n#02216828',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acetato','n#10459887 n#02162219',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bollettino','n#04862026 n#05009680 n#05009963',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bullettino','n#04862026 n#05009963',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('formulario','n#04862026',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('modulo','n#04862026',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pleura','n#04187915',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impresa_di_trasporti','n#05994494',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affluenza','n#06082225 n#05983828 n#00800915',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('affollamento','n#06082225 n#10047921 n#10048096 n#06081960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agglomeramento','n#06082225 n#05968319',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('agglomerazione','n#06082225 n#05968319',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assembramento','n#06082225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assiepamento','n#06082225 n#10047921',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attruppamento','n#06082225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('folla','n#06082225 n#06081960',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piena','n#06082225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pigia-pigia','n#06082225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('torma','n#06082225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('novero','n#00017954',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tangenza','n#10346581 n#03998791 n#03998897',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gommosità','n#N0000869 n#03861671',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('componimento','n#05277178 n#04831003',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('composizione','n#05277178 n#05006587 n#03860186 n#05365792 n#03962359',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lavina','n#05512009 n#N0001035 n#05512262',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sottotenente_di_vascello','n#07619242',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capsella_bursa-pastoris','n#08189046',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('borsapastore_comune','n#08189046',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pisano','n#N0001482',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sopraornato','n#02641490',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('critico_musicale','n#07424295',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pernio','n#10047472 n#03134267',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('perno','n#10047472 n#03134267',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accarezzamento','n#05019872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('adulazione','n#05019872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('blandizia','n#05019872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('blandizie','n#05019872 n#05019992',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cortigianeria','n#05019872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incensamento','n#05019872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incensata','n#05019872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('insaponata','n#05019872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('leccatura','n#05019872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lisciamento','n#05019872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lisciata','n#05019872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lisciatura','n#05019872 n#00379645',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lusinga','n#05019872 n#04400576 n#00103541',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piacenteria','n#05019872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piaggeria','n#05019872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piaggiamento','n#05019872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strusciamento','n#05019872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sviolinata','n#05019872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('violinata','n#05019872',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('eschrichtius_gibbosus','n#01577786',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('balena-grigia','n#01577786',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('letteratura','n#04685374 n#04798830 n#04798932',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tomo','n#04833465',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('metafora','n#05317845',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('traslato','n#05317845',NULL,'a#01362532',NULL);
INSERT INTO italian_index VALUES ('tropo','n#05317845',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sverzino','n#03612113',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lana','n#03629073',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('daucus_carota','n#09234417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('carota_selvatica','n#09234417',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('patologia','n#10209571',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mercantilismo','n#06194424',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('allestimento','n#05256907 n#00740981',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fen','n#09867640',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fen_cinese','n#09867640',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cassaforma','n#02715089',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('armeggio','n#04540345',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intrallazzo','n#04540345',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intrigo','n#04540345 n#10038478 n#04804401 n#04540003 n#04898507 n#04540636',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intruglio','n#04540345',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lavorio','n#04540345 n#N0001036',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macchinamento','n#04540345',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macchinazione','n#04540345',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tresca','n#04540345 n#10038478',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('c_/_c','n#09619552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conto_bancario','n#09619552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conto_corrente','n#09619552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conto_corrente_bancario','n#09619552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conto_in_banca','n#09619552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('congenialità','n#03707707',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('safena','n#04180679',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gambia','n#06534556',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fondo_chiuso','n#06015810',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fondo_comune_d''investimento_chiuso','n#06015810',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fondo_comune_di_investimento','n#06015810',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('società_di_investimento','n#06015810',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salamelecco','n#05430010',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('coniglia','n#N0000443',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('calamità_naturale','n#05452923',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('american_bison','n#01907458',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bufalo','n#01907458 n#01905198 n#01904728',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('memoria','n#04443434 n#04479404 n#04370761 n#04557633 n#03227440 n#02984419 n#04882660 n#04444701 n#02884672 n#04557437 n#04444887',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('membro_di_un_clan','n#07404949',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('presalario','n#N0001570',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vasodilatatore','n#03568460',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fungo','n#09288624 n#09293451',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('micete','n#09288624',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('epiciclo','n#10023294',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('plaid','n#N0001490',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('floricoltura','n#00591437',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('floricultura','n#00591437',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chi_aspetta','n#07671833',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('germania_dell''est','n#06443099',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('improduttività','n#04010984',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('attivazione','n#09755052',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('garza','n#02749079 n#03449068',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malawi','n#06545698',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('repubblica_centrafricana','n#06414692',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('macchina_truccata','n#02836803',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malva_neglecta','n#08476775',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malva_domestica','n#08476775',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('odore','n#04414709 n#03891990 n#04415043',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('monitor','n#03011151',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('autogamia','n#05533971',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('strudel','n#05674730',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('garzetta','n#01520719 n#01521430',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pennino','n#01520719',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lamella','n#04132166 n#09306827',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('juncus_effusus','n#08054877',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giunco_comune','n#08054877',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('speronamento','n#N0001961',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('terra_cotta','n#02620398',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('terracotta','n#02620398',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lycopersicon_esculentum','n#09203529',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pomodoro','n#09203529 n#05770815',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('locomozione','n#03747122',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('giuntatrice','n#03386478',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fidatezza','n#03679549',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('hydrobates_pelagicus','n#01572855',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('uccello_delle_tempeste','n#01572855',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vetreria','n#02756545 n#02756728',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('osa','n#06077390',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('organizzazione_degli_stati_americani','n#06077390',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disciplina','n#03823941 n#03285173 n#04594727 n#04378256',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('campagnola','n#02874141',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fuoristrada','n#02874141',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('jeep','n#02874141 n#N0000251',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lotta_al_terrorismo','n#Y0005566',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('astrolabio','n#02218825',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('verificatore','n#07249913',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ninive','n#06518544',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('punto_geografico','n#06324198',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('avversione','n#05577970 n#05577305',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disgusto','n#05577970 n#05577305 n#05577676',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orrore','n#05577970 n#05591212 n#05577810 n#02832377',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('raccapriccio','n#05577970',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('repugnanza','n#05577970 n#05577305 n#05577676',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('repulsione','n#05577970 n#07776750',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ribrezzo','n#05577970 n#05577676',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ripugnanza','n#05577970 n#05577305 n#05577676',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ripulsione','n#05577970',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('schifo','n#05577970',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sgomento','n#05577970',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tovaglietta_da_tè','n#03475381',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('organo_vocale','n#04117913',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lettera_aperta','n#04970178',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('numero_reale','n#09885099',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nipote','n#07298646 n#07430196 n#07299656',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('patio','n#03096419',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('terrazza','n#03096419',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('terrazzo','n#03096419 n#02239875',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('imperativo','n#09940115',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stradino','n#07536354',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grandiloquenza','n#05295741',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('magniloquenza','n#05295741',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('retorica','n#05295741',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('grimaldello','n#N0000876',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pennarello','n#N0001421',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('etere','n#04730302 n#02648279',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palimpsesto','n#04829471',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('palinsesto','n#04829471',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pisa','n#06465038',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pi','n#06465038',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ananas','n#05789084 n#08907523',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gru_a_derrick','n#02556959',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pelame','n#10584548',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('convenzione','n#05074858 n#04381416 n#05072418 n#05075369 n#04699267',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trattato','n#05074858 n#04830105',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ingrosso','n#N0000970',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foglietto','n#03353273',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciclope','n#06852302',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciclopo','n#06852302',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sessione','n#05345420 n#00799933 n#10935663',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('seduta','n#05345420',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mutandoni','n#02940558',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('romano_prodi','n#W0020803',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prodi','n#W0020803',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('situazione_esplosiva','n#10428460 n#03166802',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('centinaio','n#09901877',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cento','n#09901877',NULL,'a#02102426',NULL);
INSERT INTO italian_index VALUES ('100','n#09901877',NULL,'a#02102426',NULL);
INSERT INTO italian_index VALUES ('cavolo_nero','n#05752477',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pragmatica','n#04688596',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('millesimo','n#09892690 n#10866466',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('teorico','n#07639374',NULL,'a#00819481',NULL);
INSERT INTO italian_index VALUES ('hyphantria_cunea','n#01811132',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bruco_americano','n#01811132',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('gambale','n#02916661 n#02317138',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disconoscimento','n#05383849',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ripudio','n#05383849 n#05385235',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sconfessione','n#05383849',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sconoscimento','n#05383849',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('toponomastica','n#N0002124 n#N0002123',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intenzione','n#04588436 n#04588033',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('flottiglia','n#02701744',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dryopteris_filix-mas','n#09478765',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('felce_maschio','n#09478765',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('visconti','n#W0020924',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('luchino_visconti','n#W0020924',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('linea_di_galleggiamento','n#06388716',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dominante','n#05130881',NULL,'a#00753744',NULL);
INSERT INTO italian_index VALUES ('iattura','n#10384027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iella','n#10384027 n#07777626',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('iettatura','n#10384027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('malasorte','n#10384027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('jettatura','n#10384027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mala_sorte','n#10384027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pegola','n#10384027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scalogna','n#10384027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('guigne','n#10384027',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('boutique','n#02320393',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cassa_armonica','n#03370398',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cassa_di_risonanza','n#03370398',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('molla','n#03390661',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('creosoto','n#10636820',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crosoto','n#10636820',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('papaver_rhoeas','n#08209856',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('papavero','n#08209856 n#08208225',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('papavero_comune','n#08209856',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rosolaccio','n#08209856',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aerazione','n#00171095 n#09672311 n#03571190 n#00131456',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aereazione','n#00171095 n#09672311 n#03571190 n#00131456',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('areazione','n#00171095',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('videoleso','n#N0002251',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mare','n#06765341 n#06667120 n#09922052 n#07845203 n#06781925',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caramella_mou','n#05652493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('toffee','n#05652493',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('adultera','n#07064761',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('franco_della_costa_d''avorio','n#09840922',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('c.e.r.n.','n#N0000358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('consiglio_europeo_per_le_ricerche_nucleari','n#N0000358',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ergoterapia','n#00432483',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('prassiterapia','n#00432483',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('allarmista','n#07069269',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('secrétaire','n#03296615',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('triage','n#00656642',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sombrero','n#03368969',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('maiale','n#01892492 n#01892895',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biblioteconomia','n#04686230',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scienziato','n#07551670',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rublo','n#09861035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rublo_russo','n#09861035',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mezz''ala','n#N0001176',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mezzala','n#N0001176',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dinamite','n#02618916',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clematide','n#08040603',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('vitalba','n#08040603 n#08042552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('neurochirurgia','n#00443915',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clitoride','n#04278195',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('confusione','n#05502027 n#00043311 n#10402349 n#05581054 n#04392842 n#04393348 n#05580420 n#00361442 n#05499597 n#10067954',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('trambusto','n#05502027 n#00362507',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incoordinazione','n#04363184',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('matassia','n#04363184',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capacità_d''assorbimento','n#03865164',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('incidente','n#10069677 n#05444050 n#05443572',NULL,'a#02839039',NULL);
INSERT INTO italian_index VALUES ('fermentazione_alcolica','n#09690047',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ribollimento','n#09690047 n#05586494',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disinformazione','n#04977724',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('poetessa','n#07484283',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('modem','n#03007781',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falce','n#03333468 n#03291320 n#10013694',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falcetto','n#03333468',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('falciola','n#03333468',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('roncola','n#03333468',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caschetto','n#04083860',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pettinatura_alla_paggetto','n#04083860',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('salvacondotto','n#05016483 n#04916758',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ciotola','n#09912878 n#02321913',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scodellata','n#09912878',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('turco','n#05190037 n#07040504',NULL,'a#02780089',NULL);
INSERT INTO italian_index VALUES ('buona_notte','n#04976259',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('buonanotte','n#04976259',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('novocaina','n#03175352',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('alizarina','n#10754210',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('laminatura','n#00461161',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cerniera','n#02819675 n#03351953',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ganghero','n#02819675',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tiro_con_l''arco','n#00283407',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pioggia','n#03938934 n#07830260 n#10770918',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nonagenario','n#N0001292',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('novantenne','n#N0001292',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sofferenza','n#10366977 n#10280125 n#05572909',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ferula','n#02672248 n#03386712',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('biancheria_intima','n#03560325',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frutto_proibito','n#04400200',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nome_falso','n#04780613',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('confcommercio','n#N0002465',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('confederazione_generale_italiana_del_commercio_e_del_turismo','n#N0002465',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tecnigrafo','n#02596428',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('polystichum_lonchitis','n#09485353',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('felce_lonchite','n#09485353',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('canguro','n#01393140',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('clematis_vitalba','n#08042552',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('orso_bruno','n#01640797',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('atout','n#03546009',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('briscola','n#03546009',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('equatore','n#09995862 n#06316408',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('caseggiato','n#02299702 n#02199760',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panicum_miliaceum','n#08434322',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('panico_coltivato','n#08434322',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('radiochimica','n#04641683',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('messicano','n#07030353',NULL,'a#02782661',NULL);
INSERT INTO italian_index VALUES ('bozzima','n#10542655',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('colla','n#10542655 n#10539758',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assistenza','n#00800467 n#00705199 n#00783978 n#04015637 n#00428745 n#00736161 n#00782440',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('frequenza','n#00800467 n#10975635 n#09954914',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('presenza','n#00800467 n#10056790 n#06364655',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bega','n#05368498 n#00758712',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contestazione','n#05368498 n#00758712 n#05386838 n#00768438',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('contrasto','n#05368498 n#04412804 n#00758712 n#09982023 n#04435179 n#10071502',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dissidio','n#05368498',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('nova','n#06764756',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('infermiera','n#07436855',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fisiologia','n#04639241',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('rapa_svedese','n#08185997 n#05772700',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('microscopio','n#02995903',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('riloga','n#N0001718',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('implosione','n#05325725 n#05484992',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cateto','n#N0000320',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('angiopatia','n#10130462',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('d.d.t.','n#N0000618',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diclorodifeniltricloroetano','n#N0000618',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mentha_suaveolens','n#09154850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('menta_a_foglie_rotonde','n#09154850',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lince_comune','n#01636007',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lynx_lynx','n#01636007',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('infiltrazione','n#05529123 n#00628795',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('mica','n#10524293',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('ferretto','n#01682320',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crepa','n#10021740 n#06699238',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('crepaccio','n#10021740 n#06735638',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('spaccatura','n#10021740 n#06699238',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aggettivo','n#04769821 n#04767497',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tito_livio','n#N0002188',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('marziano','n#06851811',NULL,'a#02711734',NULL);
INSERT INTO italian_index VALUES ('arenile','n#06801748',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('piaggia','n#06801748',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cane_da_caccia','n#01597993 n#01608999',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('chenopodium_album','n#08139018',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('farinello_comune','n#08139018',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bene_immobile','n#09530734',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('beni_immobili','n#09530734',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('immobile','n#09530734',NULL,'a#01508428',NULL);
INSERT INTO italian_index VALUES ('mammona','n#06852796 n#10396932',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('deformità','n#05530444 n#10214191 n#03694588',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('conseguenza','n#05439829 n#05438613 n#07766144',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('drappo_funebre','n#03081020',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sudario','n#03081020',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('capopattuglia','n#N0000276',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('francoforte','n#06445174',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compera','n#00047517',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('compra','n#00047517',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tuia','n#07960860',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('defibrillatore','n#02552179',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('aragona','n#06584473',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zabaglione','n#05669949',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('zabaione','n#05669949',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('lecitina','n#10522879',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('adempimento','n#00035970 n#00729882',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('assolvimento','n#00035970',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('videoscrittura','n#09752142',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('word_processing','n#09752142',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('stucco','n#10806971 n#10540432',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('intrattenitore','n#06946373',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('microcita','n#04231094',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('microcito','n#04231094',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('dolly','n#02587238 n#02587333',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('limulus_polyphemus','n#01306041',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('granchio_a_ferro_di_cavallo','n#01306041',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('bulldog','n#01618484',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('foglia','n#09440011 n#02708161',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('filodiffusione','n#04744856',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('esibizione','n#00336676 n#05156358 n#00336519 n#00679011',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cinema','n#04735661 n#02442077',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('cinematografia','n#04735661',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('film','n#04735661 n#02679651 n#02679248 n#04960631',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('callista','n#07155160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('pedicure','n#07155160',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disagguaglianza','n#03733407',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('diseguaglianza','n#03733407',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disparità','n#03733407 n#03733698',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('disuguaglianza','n#03733407',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('sperequazione','n#03733407',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accecatoio','n#02509071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('accecatore','n#02509071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('acciecatore','n#02509071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('allargatore','n#02509071',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('operatore','n#09927920 n#07444753 n#07444889 n#07444457 n#07136186 n#07066862',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('francia','n#06524612',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('tentazione','n#05564760 n#04400046',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('argine','n#00527713 n#02636122',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('likuta','n#09867958',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('likuta_dello_zaire','n#09867958',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('fagotto','n#02262010',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('scafo','n#02840815',NULL,NULL,NULL);
INSERT INTO italian_index VALUES ('impresa','n#06004580 n#00021392 n#00503611 n#00503108',NULL,NULL,NULL);
INSERT INTO italian_index VALUES (