# Host: 	  Database: 	  Date: 
# ---------------------------------------------------------
#

DROP TABLE IF EXISTS hebrew_synonyms;
CREATE TABLE hebrew_synonyms (num INT(7) NOT NULL PRIMARY KEY ,lemma VARCHAR(200) NOT NULL,pos CHECK(pos IN ("n","v","a","s","r")) NOT NULL,syn CHAR(8) NOT NULL,ev VARCHAR(5) NOT NULL,bidict VARCHAR(20),bisense VARCHAR(120),monodict VARCHAR(20),monosense VARCHAR(120),tgr VARCHAR(5),gloss TEXT,teqs TEXT,uso VARCHAR(20),ex TEXT,stat VARCHAR(20),comment TEXT,history TEXT,idmorpho int(10) DEFAULT "0" not null,modify DATE not null);
CREATE INDEX lemma ON hebrew_synonyms(lemma);
CREATE INDEX pos ON hebrew_synonyms(pos);
CREATE INDEX syn ON hebrew_synonyms(syn);
CREATE INDEX ev ON hebrew_synonyms(ev);
CREATE INDEX idmorpho ON hebrew_synonyms(idmorpho);
CREATE INDEX modify ON hebrew_synonyms(modify);

INSERT INTO hebrew_synonyms VALUES (6,"בַּיִת","n","02837386","yy","morfix","1.1","rav-milim","1.1",NULL,NULL,"house",NULL,"החדרים בבית שלנו מאד קטנים",NULL,"MZ: house, home (RM-1.1)\r\n#IE","eyal-11 Aug 2005, web-11 Dec 2002, web-05 Dec 2002, web-03 Dec 2002",90801,"2005-08-11");
INSERT INTO hebrew_synonyms VALUES (7,"בַּיִת","n","06070449","yy","morfix","1.1",NULL,NULL,NULL,NULL,"house",NULL,"הפרלמנט הבריטי מורכב משני בתים: בית עליון ובית תחתון",NULL,"MZ: not listed specifically in RM but it is in a way a subset of RM 1.5:  (בצירופים כגון \'בית חולים\', \'בית אבות\', \'בית קולנוע\' וכד\') מבנה המיועד למטרה מסוימת, ובעיקר לצרכים רשמיים, עסקיים או ציבוריים. But of course, the PWN synset is a lot more specific.\r\n#IE","eyal-11 Aug 2005, web-11 Dec 2002",90801,"2005-08-11");
INSERT INTO hebrew_synonyms VALUES (8,"בַּיִת","n","02838086","yy","morfix","1.1","none",NULL,NULL,NULL,"house",NULL,"כדי לחנך את הדור הצעיר לאהבת הים הוקם בקיבוץ בית-סירות ומועדון צלילה על חוף הים",NULL,"MZ: not listed in RM as a separate meaning\r\n#IE","eyal-11 Aug 2005, web-11 Dec 2002, web-05 Dec 2002, web-03 Dec 2002",90801,"2005-08-11");
INSERT INTO hebrew_synonyms VALUES (9,"בַּיִת","n","06021037","yy","melingo","1.4","rav-milim","1.3",NULL,NULL,"family",NULL,NULL,NULL,"MZ: (RM-1.3)\r\n#IE","eyal-22 Jun 2005, web-11 Dec 2002, web-05 Dec 2002, web-03 Dec 2002",90801,"2005-06-22");
INSERT INTO hebrew_synonyms VALUES (10,"בַּיִת","n","03491295","nn",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"MZ\r\n#IE does not exist in Hebrew","eyal-15 May 2005, web-11 Dec 2002, web-03 Dec 2002",0,"2005-05-15");
INSERT INTO hebrew_synonyms VALUES (11,"בַּיִת","n","06104236","ng",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"MZ: It\'s a GAP assuming PWN is right that this is a separate meaning of house and not a synonym for the synset of audience.","web-03 Dec 2002",90801,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (12,"בַּיִת","n","06393436","yy","morfix","1.1","rav-milim","1.10",NULL,"אסטרולוגיה כל אחד משנים עשר קטעי גלגל המזלות, המכוון לסימן מזל מסוים. ","house, planetary_house",NULL,NULL,NULL,"MZ: (RM-1.10) The PWN I think is wrong. House and Sign of the zodiac are not synonyms. ","web-11 Dec 2002",90801,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (13,"בַּיִת","n","00273030","nn",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"MZ: sb ima ve-aba; also it looks like it is an error in WN - unit is play house\r\n","web-03 Dec 2002",90801,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (14,"בַּיִת","n","06105815","n",NULL,NULL,"rav-milim","1.4",NULL,"אסכולה, קבוצת תלמידים ההולכת בשיטת המורה שלהם.",NULL,NULL,"בחילוקי הדעות בין שתי הקבוצות של חכמי המשנה, בית הלל ובית שמאי, ההלכה היא בדרך כלל על-פי בית הלל.\r\n",NULL,"MZ:  Did Beit Shamai live together? Needs to be discussed. There could be a connection between this PWN meaning and RM 1.4 but I made this u because I am not familiar with the PWN meaning of house.\r\n","web-03 Dec 2002",90801,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (15,"בַּיִת","n","04813281","yy","morfix","1.2","rav-milim","1.2",NULL,"שירה: חלק של שיר שיש בו כמה שורות. לעיתים קרובות יש לבתים משקל דומה וחריזה דומה. ","stanza",NULL,"המורה למוזיקה לימדה אותנו שיר שיש בו שלושה בתים ","checked","MZ: (RM-1.2)\r\n","web-10 Feb 2003, web-11 Dec 2002, web-05 Dec 2002, web-03 Dec 2002",90801,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (26,"bayit","n","06007316","ng",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"MZ: A decision was made to ignore RM 1.5 (see Hebrew sheet) because bayit is never alone in this sense but only a part of a compound and anyway it is not needed as all teh children may be mapped to other WN concepts. This could have also been viewed as a denotation difference. The Hebrew synset for RM 1.5 is more general than this. ","web-27 Nov 2002",90802,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (18,"אִמָּא_וְאַבָּא","n","00273030","yc",NULL,NULL,NULL,NULL,NULL,NULL,"house",NULL,"כשהיינו קטנים, אחי ואני אהבנו לשחק באמא ואבא",NULL,"MZ: it looks like it is an error in WN - unit is play house and not just house. I couldn\'t find any evidence of \r\n#IE I think it can stand as a collocation","eyal-23 Jun 2005, web-05 Dec 2002",90803,"2005-06-23");
INSERT INTO hebrew_synonyms VALUES (25,"בַּיִת","n","06110607","nn","morfix","1.5","rav-milim","1.7",NULL," ספורט מסגרת של כמה קבוצות המתחרות ביניהן כשהקבוצה המנצחת בבית מתחרה נגד הקבוצות המנצחות בבתים אחרים וכן הלאה.",NULL,NULL,"הקבוצה הראשונה בבית תעלה למשחק חצי הגמר.",NULL,"MZ: (RM-1.7) This is a mistake in Rav-Milim. The proper English translation should be - division","web-05 Dec 2002",90801,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (27,"בַּיִת","n","05976484","yy","morfix","1.4","rav-milim","1.6",NULL,"משפחה חשובה, בייחוד משפחת האצולה או משפחה מלכותית; שושלת. ","house",NULL,"אנרי הרביעי מלך צרפת היה הראשון למלכי בית בורבון.\r\n",NULL,"MZ: (RM-1.6)","web-11 Dec 2002, web-05 Dec 2002, web-03 Dec 2002",90801,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (28,"בַּיְט","n","09796150","yy","morfix","2.1","rav-milim","2.1",NULL,"מחשבים קבוצת סיבּיות (לרוב שמונה) המהווה יחידת אחסון בסיסית השקולה לתו אחד של מידע, יחידה בסיסית של תוכנה או של חומרה. בעברית: בַּיִת.","byte",NULL,NULL,"checked","MZ","web-10 Feb 2003, web-11 Dec 2002, web-05 Dec 2002",90804,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (29,"בֵּית_אָבוֹת","n","02825467","yy","morfix","2.1","rav-milim","2.1",NULL,"מוסד המותאם לצורכיהם של אנשים זקנים שקשה להם לטפל בעצמם או שאינם רוצים לחיות לבד. בית האבות מספק להם דיור, מזון, טיפול רפואי וסיעודי, פעילות תרבותית ועוד."," home, nursing_home, rest_home",NULL,NULL,NULL,"MZ: (RM-2.1). RM has other entries which are missing from WN: old folks-apostrophe home, eldrely citizens-apostrophe home","web-11 Dec 2002, web-10 Dec 2002, web-05 Dec 2002",90805,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (31,"פִּיל","n","01997527","yy","morfix","1.1","rav-milim","1.1",NULL,"בעל חיים גדול וכבד בעל עור עבה, חדק ארוך וגמיש, אוזניים רחבות וזוג שנהבים ארוכים.","elephant",NULL,"הפיל שוכן בעדרים ביערות בארצות אפריקה ואסיה וניזון מעלים. משמש בהמת משא וניצוד בשל השנהב יקר הערך שלו.\r\n",NULL,"MZ: RM-1.1","web-05 Dec 2002, web-03 Dec 2002",90806,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (34,"תֵּאַטְרוֹן","n","03491295","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"theater",NULL,"בעיר הבירה יש תאטרון פתוח המכיל 900 מקומות",NULL,"MZ\r\n#IE","eyal-15 May 2005, web-11 Dec 2002, web-05 Dec 2002, web-03 Dec 2002",90807,"2005-05-15");
INSERT INTO hebrew_synonyms VALUES (37,"GAP!","n","06105815","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"MZ: But should check the meaning of RM 1.4 to be sure there is no relation.  # NO See card קהילה","shuly-07 Jan 2004",90808,"2004-01-07");
INSERT INTO hebrew_synonyms VALUES (35,"GAP!","n","06104236","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"MZ: It is a GAP assuming PWN is right that this is indeed a separate synset rather than a synonym of audience.","web-03 Dec 2002",90808,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (38,"גִ\'ירָפָה","n","01934997","yy","morfix","1.1","rav-milim","1.1",NULL,NULL,"גִ\'ירָף",NULL,NULL,"revised","MZ","ordan-10 Aug 2004, web-05 Dec 2002, web-03 Dec 2002",90809,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (39,"גִ\'ירָף","n","01934997","yy","morfix","1.1","rav-milim","1.1",NULL,NULL,"גִ\'ירָפָה",NULL,NULL,"revised","MZ","ordan-10 Aug 2004, web-05 Dec 2002, web-03 Dec 2002",90810,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (40,"בַּיִת","n","09796150","yy","morfix","1.6","rav-milim","1.11",NULL,"מחשבים- החלופה העברית לבַּיְט ","byte",NULL,NULL,"checked","MZ: (RM-1.11)","web-10 Feb 2003",90801,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (41,"בַּיִת","n","06116890","y","morfix","1.5","rav-milim","1.7",NULL,"ספורט -מסגרת של כמה קבוצות המתחרות ביניהן כשהקבוצה המנצחת בבית מתחרה נגד הקבוצות המנצחות בבתים אחרים וכן הלאה.","division",NULL,"הקבוצה הראשונה בבית תעלה למשחק חצי הגמר",NULL,"MZ: (RM-1.7); Morfix and RM have league which is wrong. The WN sysnset for Sport-division is not strictly the  same either but close. Need to check how to do this better.","web-15 Jan 2003",90801,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (42,"ד''ש","n","04974383","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"regards",NULL,NULL,"revised","MZ #IE abbreviation for ''drishat shalom''","eyal-22 Mar 2004, web-11 Dec 2002",90811,"2004-03-22");
INSERT INTO hebrew_synonyms VALUES (6548,"אִחוּל","n","04974383","yy","melingo","1","rav-milim","1.1",NULL,NULL,"wish, greeting",NULL,"קבל את איחולי הכנים להצלחה בעסק החדש","checked","#IE usually plural; could also correspond with RM 1.2","eyal-22 Mar 2004",90812,"2004-03-22");
INSERT INTO hebrew_synonyms VALUES (43,"דְּרִישַׁת-שָׁלוֹם","n","04974383","yy","melingo","1","rav-milim","1.1",NULL,NULL,"regards",NULL,"הוא מסר לו דרישת שלום דרך הרדיו",NULL,"MZ #IE","eyal-22 Mar 2004",90813,"2004-03-22");
INSERT INTO hebrew_synonyms VALUES (44,"מִשְׁכָּן","n","02618194","n","morfix","1.2","rav-milim","1.2",NULL,"ספרותית -  בית, מעון, מקום מגורים",NULL,NULL,"הקרֶמלין של מוסקבה שימש בעבר משכן הצארים",NULL,"MZ\r\n#IE this synset refers only to the physical struture in which one lives","eyal-11 Aug 2005, web-10 Dec 2002",0,"2005-08-11");
INSERT INTO hebrew_synonyms VALUES (45,"בֵּית-מְגוּרִים","n","02618194","yy","morfix","1.1","rav-milim","1.1",NULL,NULL,"dwelling_house",NULL,"הם אספו כסף על מנת לבנות בתי מגורים למוחסרי הדיור",NULL,"MZ: DWELLING by itself is not listed in RM as an entry (only dwelling house, residence) but BEYT_MEGURIM appears in translation of DWELLING.\r\n#IE","eyal-11 Aug 2005, web-11 Dec 2002",90815,"2005-08-11");
INSERT INTO hebrew_synonyms VALUES (46,"בֵּית-דִּירוֹת","n","02199760","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"apartment_building",NULL,NULL,"checked","MZ\r\n#IE","eyal-30 Jun 2005, web-10 Dec 2002",90816,"2005-06-30");
INSERT INTO hebrew_synonyms VALUES (47,"דִּיּוּר","n","02839091","yy","morfix","1.1","rav-milim","1.1.A",NULL,"מקום מגורים","housing",NULL,"משרד השיכון מנסה לעזור למשפחות חסרות דיור",NULL,"MZ: (RM-1.1.A) The RM definition has an OR: a place where people live OR the living conditions. Only the former is applicable here.","web-10 Dec 2002",90817,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (48,"מִבְנֶה","n","03431817","yy","morfix","1.2","rav-milim","1.1",NULL,"דבר בנוי (מלבנים, מבטון, מעץ, מאבן וכד\')","structure",NULL,"מבנים רבים נהרסו ברעידת האדמה, בהם בנייני מגורים ומבני תעשייה",NULL,"MZ: (RM-1.1) Even though the RM and Morfix translation in 1.1 is building rather than structure, this is the right sense based on the definition. But review this.\r\n","web-11 Dec 2002",90818,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (49,"מִבְנֶה","n","03858780","yy","morfix","1.2","rav-milim","1.2",NULL,"תבנית, הצורה שבה משהו עשוי או בנוי; האופן שבו החלקים השונים של מכלול ערוכים, מסודרים או מאורגנים","structure",NULL,"למרימי משקולות יש מבנה גוף רחב",NULL,"MZ: RM includes in 1.2 several PWN synsets - the definition pertains to this synset but the examples are from several.","web-10 Dec 2002",90818,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (50,"מִבְנֶה","n","04423204","yy","morfix","1.2","rav-milim","1.2",NULL,NULL,"structure",NULL,"מבקר הקולנוע הצביע על פגמים במבנה העלילה של הסרט",NULL,"MZ: the RM definition pertains to a different synset of structure but one of its example sfits here.","web-10 Dec 2002",90818,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (51,"מִבְנֶה","n","04062157","yy","morfix","1.2","rav-milim","1.2",NULL,NULL,"structure",NULL,NULL,NULL,"MZ: RM doesn\'t list this as a separate meaning","web-10 Dec 2002",90818,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (52,"מִבְנֶה","n","06199619","yy","morfix","1.2","rav-milim","1.2",NULL,NULL,"structure",NULL,NULL,NULL,"MZ: RM doesn\'t list this as a separate meaning.","web-10 Dec 2002",90818,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (53,"בִּיֵּת","v","00208796","yy","morfix","3.1","rav-milim","3.1",NULL,NULL,"domesticate",NULL,NULL,"checked","MZ: RM doesn\'t distinguish the three meanings of domesticate in PWN.\r\n","web-10 Feb 2003, web-04 Feb 2003, web-10 Dec 2002",90819,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (54,"בִּיֵּת","v","00138537","yy","morfix","3.1","rav-milim","3.1",NULL,NULL,"domesticate",NULL,NULL,"checked","MZ: BIYET (PIEL). RM doesn\'t distinguish the three meanings of domesticate in PWN.","web-10 Feb 2003, web-11 Dec 2002",90819,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (55,"בִּיֵּת","v","00208649","yy","morfix","1.1","rav-milim","3.1",NULL,"סיגל בעל חיים לחיים בקרבת האדם, לתועלת האדם",NULL,NULL,"לפני כארבעת אלפים שנה ביית האדם את הסוס, ומאז הוא משמש אותו ברכיבה ובהובלת משאות","checked","MZ: RM doesn\'t distinguish the three PWN meanings but this synset is the one RM uses.","web-10 Feb 2003, web-10 Dec 2002",90819,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (56,"אִלֵּף","v","00138537","y","none",NULL,"rav-milim","3.1.B",NULL," אימן בעל חיים והרגיל אותו לחיי בית","domesticate",NULL,NULL,"checked","MZ: ILEF (PIEL) Doesn\'t appear in Hebrew-English Morfix or RM (only the English-Hebrew one). RM defines ILEF as train-tame as well as domesticate all in one defintion. The second part of the defintion which pertains to house training is the one that fits here. PWN by the way has no appropriate synstes for training animals and taming animals.","web-10 Feb 2003, web-11 Dec 2002",90820,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (57,"אֶתְמוֹל","n","10877300","yy","none",NULL,"none",NULL,NULL,NULL,"yesterday",NULL,NULL,"checked","MZ: Actually, neither Morfix nor RM list ETMOL as a noun at all in the sense of the day before today. Only as an adverb.","web-10 Feb 2003, web-10 Dec 2002",90821,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (58,"אֶתְמוֹל","r","00504351","yy","morfix","1.1","rav-milim","1.1",NULL,NULL,"yesterday",NULL,"אתמול אמרת לי \'היום\' והיום אתה אומר לי \'מחר\'!","checked","MZ\r\n#NO","ordan-14 Feb 2004",90822,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (59,"אֶתְמוֹל","n","10963940","yy","morfix","1.1","rav-milim","2.1",NULL,"הזמן שעבר, בייחוד הזמן האחרון","yesterday",NULL,"צריך לצעוד לעבר העתיד, אך אל לנו לשכוח את האתמול","checked","MZ","web-10 Feb 2003, web-10 Dec 2002",90821,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (60,"אֶתְמוֹל","r","00504454","yy","morfix","1.1","rav-milim","2.1",NULL,NULL,"yesterday",NULL,"לא נולדתי אתמול!","checked","MZ: RM doesn\'t list this sense of ETMOL as an adverb only as a noun.","ordan-14 Feb 2004",90822,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (61,"מְדִינָה","n","06079469","yy","morfix","1.1","rav-milim","1.2",NULL,"כלל רשויות השלטון בארץ מסוימת, ובייחוד השלטון האזרחי החילוני להבדיל משלטון הדת","state",NULL,"המדינה הגישה נגדו תביעה על עבירות בטחוניות",NULL,"MZ","web-10 Dec 2002",90823,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (62,"מְדִינָה","n","06374245","yy","morfix","1.1","rav-milim","1.3",NULL,"כל אחד מן האזורים שיש להם שלטון עצמי חלקי, והמאורגנים יחד במסגרת של פדרציה","state",NULL,"ארצות הברית היא פדרציה המורכבת מחמישים ואחת מדינות",NULL,"MZ","web-10 Dec 2002",90823,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (63,"מְדִינָה","n","06074189","yy","morfix","1.1","rav-milim","1.1",NULL,"ארץ בעלת גבולות ידועים שיש בה שלטון עצמאי מרכזי יחיד","state, country",NULL,"לאחר אלפיים שנות גלות זכה עם ישראל למדינה משלו","revised","MZ: Synset 3 and synset 6 are not distinguished in RM.\r\n#NO","ordan-12 Feb 2004, web-10 Dec 2002",90823,"2004-02-12");
INSERT INTO hebrew_synonyms VALUES (64,"מְדִינָה","n","06299747","yy","morfix","1.1","rav-milim","1.1.A",NULL,"ארץ בעלת גבולות ידועים","state, country",NULL,"מצרים, ירדן וסוריה הן מדינות ערביות",NULL,"MZ: RM doesn\'t distinguish this sense from the one of synset #3. The first part of the definition pertians to both synset 3 and synset 6.","web-10 Dec 2002",90823,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (65,"מַצָּב","n","00016185","yy","morfix","1.1","rav-milim","1.2",NULL,"מכלול הנסיבות והתנאים שבהם נמצאים אדם, מדינה, עם וכד\', בעיקר בתחום הכלכלי, החברתי והמדיני","state",NULL,"לאחר שלוש שנות בצורת רצופות החמיר מצבה הכלכלי של המדינה",NULL,"MZ: PWN distinguishes state and condition, with the latter being a hyponym of the former. Hebrew doesn\'t make this distinction.  ","web-10 Dec 2002",90824,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (67,"מַצָּב","n","10032130","yy","melingo","1.1","rav-milim","1.3",NULL,NULL,"condition, status",NULL,"המצב הנוכחי של המשא ומתן אינו מעודד","revised","MZ\r\n#IE","eyal-26 Dec 2004, web-10 Dec 2002",90824,"2004-12-26");
INSERT INTO hebrew_synonyms VALUES (68,"מַצָּב","n","10031939","yy","morfix","1.1","rav-milim","1.1",NULL,"מצבו של מישהו בריאותו, הרגשתו הכללית, כושרו (הגופני והנפשי).","condition",NULL,"מצבו של הפצוע יציב",NULL,"MZ: this RM meaning is perhaps not exactly the same as the synset. If so then there is an English GAP for this meaning from RM. Need to review. ","web-10 Dec 2002",90824,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (69,"מַצָּב","n","10034299","yy","morfix","1.2",NULL,NULL,NULL,NULL,"position",NULL,NULL,NULL,"MZ: This sense does not appear in RM.","web-10 Dec 2002",90824,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (70,"מַצָּב","n","03960878","yy","morfix","1.2","rav-milim","1.5",NULL," האופן שבו דבר או אדם ממוקמים במרחב, מיקומם ביחס למה שמסביבם; אחת העמדות האפשריות שבהן יכולים להימצא ידית, מתג וכד\'","position",NULL,"ממצב הכלים על לוח השחמט היה ניתן להסיק בבירור שהמשחק הוכרע",NULL,"MZ","web-11 Dec 2002, web-10 Dec 2002",90824,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (71,"מֻצָּב","n","02997499","yy","morfix","2.1","rav-milim","3.1",NULL,"צבא שטח מוגבל המשמש לתצפית, להתגוננות, למיקום מפקדה וכד\' לאחר שהוכשר לכך בביצורים ובציוד מתאימים","post, military_post",NULL,"החיילים במוצב התצפית הקדמי דיווחו על תנועות כוחות במערך האויב",NULL,"MZ","web-11 Dec 2002, web-10 Dec 2002",90825,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (72,"סְטָטוּס","n","10048803","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"status",NULL,"בזמן שירותו הצבאי הוא נהנה מסטטוס של ספורטאי מצטיין","revised","MZ: RM doesn\'t distinguish the two senses of status that PWN lists. I separated the RM definition into two. \r\n#IE RM\'s definition cannot be seperated into two since there is only one meaning","eyal-26 Dec 2004, web-11 Dec 2002",90826,"2004-12-26");
INSERT INTO hebrew_synonyms VALUES (73,"מִצָּב","n","10048803","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"status",NULL,NULL,"revised","MZ\r\n#IE","eyal-26 Dec 2004, web-11 Dec 2002",90827,"2004-12-26");
INSERT INTO hebrew_synonyms VALUES (74,"סְטָטוּס","n","10032130","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"status",NULL,"מהו הסטטוס הנוכחי של הסכמי אוסלו?","revised","MZ: RM doesn\'t distinguish the two senses of STATUS that PWN lists. I separated the RM definition.\r\n#IE I don\'t think RM\'s definition can be divided into two. I think the word סטטוס can definitely fit to this synset, although RM\'s definition does not correspond with WN\'s definition","eyal-26 Dec 2004, web-11 Dec 2002",90826,"2004-12-26");
INSERT INTO hebrew_synonyms VALUES (75,"מַעֲמָד_חֶבְרָתִי","n","10049681","yy",NULL,NULL,NULL,NULL,NULL,NULL,"social_status",NULL,NULL,NULL,"MZ: This collocation is not in RM.","web-11 Dec 2002",90828,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (76,"צָב","n","01183829","u","melingo","1.1","rav-milim","1.1",NULL,NULL,"turtle",NULL,NULL,"revised","MZ: Morfix and RM translate צב as tortoise without mentioning turtle (though Morfix from English to Hebrew also translates turtle as צב). RM is wrong. Tortoise is צַב יָם and Turtle is צַב \r\n#IE actually RM is right. Tortoise is צב and turtle is צב ים","eyal-13 Jan 2005, web-11 Dec 2002",0,"2005-01-13");
INSERT INTO hebrew_synonyms VALUES (8015,"צַב-יָם","n","01183829","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"turtle",NULL,NULL,"checked","#IE","eyal-13 Jan 2005",94149,"2005-01-13");
INSERT INTO hebrew_synonyms VALUES (77,"צַב_יָם","n","01191090","u","none",NULL,"rav-milim","1.1",NULL,"צב השוכן בים ולו שריון שטוח וגפיים דמויות משוטי חתירה שטוחים. בארץ מצוי בעיקר הסוג הנקרא \'צב הים החום\'","tortoise",NULL,NULL,"revised","MZ: RM is wrong about this. It translates CAV YAM as turtle and Cav as tortoise, while it should be the other way around according to PWN. Morfix doesn\'t have CAV YAM. \r\n#IE actually RM is right. Tortoise is צב and turtle is צב ים","eyal-13 Jan 2005, web-11 Dec 2002",0,"2005-01-13");
INSERT INTO hebrew_synonyms VALUES (78,"בֻּיַּת","v","00138537","y","morfix","4.1","rav-milim","4.1",NULL,"בייתו אותו. צורת הסביל של בִּיֵּת","domesticate",NULL,NULL,"checked","MZ: BUYAT (PUAL) is the passive form of BIYET (PIEL)","web-10 Feb 2003, web-11 Dec 2002",90831,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (79,"בֻּיַּת","v","00208649","y","morfix","4.1","rav-milim","4.1",NULL,"בייתו אותו. צורת הסביל של בִּיֵּת ","domesticate",NULL,"תרנגול הבית בוית לפני אלפי שנים מתרנגול הבר","checked","MZ: BUYAT is the passive form of BIYET","web-10 Feb 2003, web-11 Dec 2002",90831,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (80,"בֻּיַּת","v","00208796","y","morfix","4.1","rav-milim","4.1",NULL,NULL,"domesticate",NULL,NULL,"checked","MZ: BUYAT is the passive form of BIYET","web-10 Feb 2003, web-11 Dec 2002",90831,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (81,"אֻלַּף","v","00138537","y",NULL,NULL,"rav-milim","4.1",NULL,"אילפו אותו. צורת הסביל של אִלֵּף","domesticate",NULL,NULL,"checked","MZ: ULAF (PUAL) is the passive form of ILEF (PIEL)\r\nMorfix doesn\'t list this meaning for ULAF","web-10 Feb 2003",90832,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (82,"הִצִּיב","v","01026409","nn","morfix","1.1","rav-milim","1.1",NULL,NULL,"place",NULL,"בכניסה למוזיאון הציבו פסל יפה",NULL,"MZ: HICIV (HIF^IL). \r\n#NO","ordan-09 Sep 2005, web-11 Dec 2002",90833,"2005-09-09");
INSERT INTO hebrew_synonyms VALUES (83,"הֻצַּב","v","01026409","nn","morfix","1.1","rav-milim","1.1",NULL,"הציבו אותו. צורת הסביל של הִצִּיב","place",NULL,"פֶּסל מרשים הוצב בכיכר העיר",NULL,"MZ: HUCAV (HUF^AL) is the passive of HECIV (HIF^IL). \r\n#NO","ordan-09 Sep 2005, web-11 Dec 2002",90834,"2005-09-09");
INSERT INTO hebrew_synonyms VALUES (84,"חֹק","n","06243906","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"web-11 Dec 2002",90835,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (88,"!אֲמִירָה","n","05320427","y","morfix","1.1","rav-milim","1.1","tg1","דיבור, דבר שאומרים;","saying_expression_utterance",NULL,NULL,"checked","#MZ@- Morfix and RM do not distinguish the two synsets (1. saying, expression, 2. utterance). In addition there is another potential synset for AMIRA (see the ''saying, expression, locution'' entry for AMIRA for the comment.","eyal-26 Jun 2005, web-15 Feb 2003, web-10 Feb 2003",0,"2005-06-26");
INSERT INTO hebrew_synonyms VALUES (89,"!אֲמִירָה","n","05349662","y","morfix","1.1","rav-milim","1.1","tg1","דיבור, דבר שאומרים; פעולת ההשמעה של דיבור","saying_expression_utterance",NULL,"האיש הזה מצטיין באמירות רמות שאין מאחריהן מעשים.","checked","#MZ@-Morfix & RM collapses two synsets into one sense (1. saying, expression 2. utterance). In addition, RM in the examples for AMIRA lists another sense without separating it. AMIRA should potentially be added to the formulation, expression synset as well","eyal-26 Jun 2005, web-15 Feb 2003, web-10 Feb 2003",0,"2005-06-26");
INSERT INTO hebrew_synonyms VALUES (90,"אֶמִיר","n","07239856","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"emir",NULL,NULL,"checked","#MZ@-OK\r\n#IE","eyal-26 Jun 2005, web-15 Feb 2003",90837,"2005-06-26");
INSERT INTO hebrew_synonyms VALUES (8703,"אִכָּר","n","H0003979","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"farmer",NULL,"האיכר ערם את החציר לערימות גדולות\r\n","checked","#IE","eyal-26 Jun 2005",91285,"2005-06-26");
INSERT INTO hebrew_synonyms VALUES (94,"אָמִיר","n","09417961","yy","melingo","1.1","rav-milim","1.1","tg1","literary","tree_top",NULL,NULL,"checked","#MZ@-OK\r\n#IE","eyal-30 Jun 2005, web-15 Feb 2003, assign-13 Dec 2002",90838,"2005-06-30");
INSERT INTO hebrew_synonyms VALUES (8719,"נוֹף","n","09417961","yy","melingo","2.1","rav-milim","2.1",NULL,NULL,"treetop",NULL,NULL,"checked","#IE","eyal-30 Jun 2005",95167,"2005-06-30");
INSERT INTO hebrew_synonyms VALUES (95,"אָמַר","v","00506398","yw","morfix","1.1","rav-milim","1.1","tg1",NULL,"to_say",NULL,NULL,"checked","#MZ@-a different sense of say was intended in Morfix (though say is also part of this sense) - the right one is state say tell\r\n(Factotum) express an idea, etc. in words; ''He said that he wanted to marry her''; ''tell me what is bothering you''; ''state your opinion''","web-15 Feb 2003",90839,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (96,"אָמַר","v","00682542","yy","morfix","1","rav-milim","1.1","tg1",NULL,"say, tell",NULL,"הוא אמר שהוא רוצה לשאת אותה לאישה","revised","#MZ@-this is ok but RM and Morfix mix several senses into one. #IE","eyal-28 Mar 2004, web-15 Feb 2003",90839,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (97,"אָמַר","v","00506398","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"tell",NULL,"אמרתי לך לא לגעת בזה!","checked","#MZ@-ok \r\n#IE","eyal-30 Jun 2005, web-15 Feb 2003",90839,"2005-06-30");
INSERT INTO hebrew_synonyms VALUES (99,"!אֹמֶר","n","05320427","y","morfix","2.1","rav-milim","2.1","tg1","מליצית דיבור, מילה, דבר מה שאומרים (בעיקר בצירופים כגון \'בלי אומר\', \'אמרי נועם\', \'אמרי שפר\').","utterance_word_saying",NULL,NULL,"checked","#MZ@-this is probbaly OK but should be reviewed when UTTERANCE is checked more thoroughly.","eyal-26 Jun 2005, web-15 Feb 2003, web-10 Feb 2003, assign-13 Dec 2002",0,"2005-06-26");
INSERT INTO hebrew_synonyms VALUES (100,"!אֹמֶר","n","05349662","yw","morfix","2.1","rav-milim","2.1","tg1","מליצית דיבור, מילה, דבר מה שאומרים (בעיקר בצירופים כגון \'בלי אומר\', \'אמרי נועם\', \'אמרי שפר\').","utterance_word_saying",NULL,NULL,"checked","#MZ@-not this synset - need to look for the right synset","eyal-26 Jun 2005, web-15 Feb 2003, web-10 Feb 2003",0,"2005-06-26");
INSERT INTO hebrew_synonyms VALUES (104,"בֵּית","n","05120394","y","morfix","2.1","rav-milim","2.1","tg1","שמה של האות השנייה (ב) באלף-בית העברי. נכתב לרוב: בי''ת.","Beth",NULL,NULL,"checked","#MZ@-ok","web-15 Feb 2003",90841,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (105,"בֵּית","n","02668605","yy","morfix","1.2","rav-milim","1.2","tg1",NULL,"fatigues",NULL,"לפני שניקה את השירותים בבסיס, החליף לבית","checked","#MZ@-ok\r\n#NO","ordan-08 Apr 2004",90841,"2004-04-08");
INSERT INTO hebrew_synonyms VALUES (106,"בַּיִת","n","02618194","n","morfix","1.1",NULL,NULL,"tg1",NULL,"house_home",NULL,NULL,"checked","#MZ@-it seems WN is wrong not to include house in this synset. Need to look at this closer.\r\n#IE the word בית is too general","eyal-11 Aug 2005, web-02 Mar 2003, web-15 Feb 2003, assign-13 Dec 2002",0,"2005-08-11");
INSERT INTO hebrew_synonyms VALUES (6366,"עִיר-הָאָבוֹת","n","H0003044","yy",NULL,NULL,"rav-milim","1",NULL,NULL,"Hebron",NULL,NULL,"revised","# IE","eyal-23 Aug 2004, shuly-08 Jan 2004",90842,"2004-08-23");
INSERT INTO hebrew_synonyms VALUES (109,"שׁוֹשֶׁלֶת","n","05976600","yy","morfix","1.1","rav-milim","1.1","tg1",NULL,"dynasty",NULL,"לאחר עריפת ראשו של לואי ה-16, נדמה היה שהשושלת המלוכנית בצרפת באה אל קיצה ","revised","#MZ@- there is a better synset for this - house \r\ngloss: aristocratic family line; ''the House of York","ordan-20 Mar 2004, web-15 Feb 2003",90843,"2004-03-20");
INSERT INTO hebrew_synonyms VALUES (110,"בַּיִת","n","06021037","yw","milingo","1.4",NULL,NULL,"tg1",NULL,"dynasty_family",NULL,NULL,"checked","#MZ (nn) -this is not strictly wrong because this is the ''family'' WN Synset. The problem is that Morfix mixes two senses of bayit in one entry while RM distinguishes them. # EP yw is the correct eval for what MZ means","eyal-22 Jun 2005, shuly-08 Jan 2004",0,"2005-06-22");
INSERT INTO hebrew_synonyms VALUES (111,"בַּיִת","n","06110607","yw","milingo","1.5",NULL,NULL,"tg1","(sport)","league",NULL,NULL,"checked","#MZ@-wrong sense","web-15 Feb 2003",90801,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (113,"גִּיד","n","04110255","yy","morfix","1.1","rav-milim","1.1","tg1",NULL,"tendon",NULL,"הגיד בכף רגלו של הכדורגלן נקרע מרוב מאמץ, והוא נאלץ לעזוב את המשחק.","checked","#MZ@-ok #IE","eyal-24 Feb 2004",90845,"2004-02-24");
INSERT INTO hebrew_synonyms VALUES (114,"גִּיד","n","04279799","yy","melingo","2","rav-milim","1.2","tg1","(euphemism)","penis",NULL,NULL,"revised","#MZ@-ok #IE","eyal-22 Mar 2004, web-15 Feb 2003",90845,"2004-03-22");
INSERT INTO hebrew_synonyms VALUES (115,"גִּלָּה","v","00632077","yy","morfix","1","rav-milim","1.2","tg1",NULL,"to_reveal_to_discover",NULL,"השחקנית לא היתה מוכנה לגלות את גילה","revised","#MZ@-ok #IE","eyal-22 Mar 2004, web-15 Feb 2003, assign-13 Dec 2002",90846,"2004-03-22");
INSERT INTO hebrew_synonyms VALUES (116,"!גִּלָּה","v","01467069","y","morfix","2.1","rav-milim","2.4","tg1","הראה (יחס, גישה, התנהגות וכד\'), הביא אותם לידי ביטוי.","to_reveal_to_discover",NULL,"הנבחן גילה בקיאות מדהימה בחומר.","checked","#MZ@- this needs to be reviewed as the usage is not exactly parallel","eyal-06 Jul 2005, web-15 Feb 2003",0,"2005-07-06");
INSERT INTO hebrew_synonyms VALUES (117,"!גִּלָּה","v","01467644","y","morfix","2.1","rav-milim","2.4","tg1","הראה (יחס, גישה, התנהגות וכד\'), הביא אותם לידי ביטוי.","to_reveal_to_discover",NULL,"הנבחן גילה בקיאות מדהימה בחומר.","checked","#MZ@-need to check what is the difference between this synset and the \r\n\'uncover bring_out unveil reveal\' one - meanwhile the Hebrew word is linked to both - RM doesn\'t distinguish the senses","eyal-06 Jul 2005, web-15 Feb 2003, assign-13 Dec 2002",0,"2005-07-06");
INSERT INTO hebrew_synonyms VALUES (118,"גָּאלָה","n","00333978","y","morfix","1.1","rav-milim","1.1","tg1"," ","gala",NULL,NULL,"revised","#MZ@-ok #IE","eyal-22 Mar 2004, web-18 Feb 2003, assign-13 Dec 2002",90848,"2004-03-22");
INSERT INTO hebrew_synonyms VALUES (119,"גָּאלָה","n","05157784","u","morfix","2","rav-milim","1.2","tg1",NULL,"premiere",NULL,NULL,"revised","#MZ@-ok-though this needs to be checked - is gala really premiere? #IE it appears only in RM - since we have other alternatives, I prefer to use them","eyal-22 Mar 2004, web-18 Feb 2003, assign-13 Dec 2002",90848,"2004-03-22");
INSERT INTO hebrew_synonyms VALUES (120,"גֻּלָּה","n","02895368","yy","morfix","1","sapir","1.5","tg1",NULL,"knob",NULL,NULL,"revised","#MZ@-I think knob is too specific #IE Sapir\'s definition refers to a handle of a stick, which has the shape of a small ball","eyal-28 Mar 2004, eyal-22 Mar 2004, web-18 Feb 2003, assign-13 Dec 2002",90849,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (121,"גֻּלָּה","n","02895469","yy","morfix","1","sapir","1.7","tg1",NULL,"knob",NULL,NULL,"revised","#MZ@-ok #IE","eyal-22 Mar 2004, web-18 Feb 2003, assign-13 Dec 2002",90849,"2004-03-22");
INSERT INTO hebrew_synonyms VALUES (6543,"GAP!","n","02966529","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE In Hebrew we say ''pesel shayish'' (sculpture made of marble). The word ''shayish'' alone does not describe, in any case, a sculpture.","eyal-22 Mar 2004",90808,"2004-03-22");
INSERT INTO hebrew_synonyms VALUES (122,"גֻּלָּה","n","02895592","nn","none",NULL,"none",NULL,"tg1",NULL,"knob, pommel",NULL,NULL,"revised","#MZ@-too specific \r\n#IE ","eyal-12 Aug 2004, eyal-28 Mar 2004, web-18 Feb 2003, assign-13 Dec 2002",90849,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (7146,"GAP!","n","02895592","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE this specific term does not exist in Hebrew","eyal-12 Aug 2004",90808,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (123,"!גֻּלָּה","n","10012749","y","milingo","5.1","rav-milim","5.1","tg1","גוף כדורי קטן; כל דבר דמוי כדור קטנטן","small_ball_small_sphere_knob",NULL,"לסבי יש מקל הליכה מעוצב יפה שבראשו גולת כסף","checked","#MZ@-ok\r\n#IE too general, need to check","eyal-06 Jul 2005, web-18 Feb 2003, assign-13 Dec 2002",0,"2005-07-06");
INSERT INTO hebrew_synonyms VALUES (124,"גֻּלָּה","n","02966407","yy","morfix","2","rav-milim","1.2","tg1",NULL,"marble",NULL,"יותר מכל הוא אהב לשחק בגולות","revised","#MZ@- same as Jula #IE","eyal-22 Mar 2004, web-18 Feb 2003, assign-13 Dec 2002",90849,"2004-03-22");
INSERT INTO hebrew_synonyms VALUES (125,"גֻּלָּה","n","02966529","nn","morfix","5.2",NULL,NULL,"tg1","((game of marbles))","marble",NULL,NULL,"revised","#MZ@- wrong sense of marble #IE has nothing to do with the game of marbles","eyal-22 Mar 2004, web-18 Feb 2003, assign-13 Dec 2002",0,"2004-03-22");
INSERT INTO hebrew_synonyms VALUES (126,"גֻּלָּה","n","10725638","nn","morfix","5.2",NULL,NULL,"tg1","((game of marbles))","marble",NULL,NULL,"revised","#MZ@-wrong sense of marble #IE has nothing to do with the game of marbles","eyal-22 Mar 2004, web-18 Feb 2003, assign-13 Dec 2002",90851,"2004-03-22");
INSERT INTO hebrew_synonyms VALUES (127,"דִּבֵּר","n","05360712","u","melingo","2.1","rav-milim","2.1","tg1",NULL,"commandment",NULL,NULL,"checked","#MZ@-ok\r\n#IE this word is too specific in the Hebrew language","eyal-07 Jul 2005, eyal-06 Jul 2005, web-18 Feb 2003, assign-13 Dec 2002",0,"2005-07-07");
INSERT INTO hebrew_synonyms VALUES (8789,"מִצְוָה","n","05360712","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"commandment",NULL,NULL,"checked","#IE RM 1.2 can also fit","eyal-07 Jul 2005",95192,"2005-07-07");
INSERT INTO hebrew_synonyms VALUES (128,"דִּבֵּר","v","00638109","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"speak, talk",NULL,"היא מדברת המון שטויות","checked","#MZ@-ok\r\n#IE","eyal-07 Jul 2005, web-18 Feb 2003, assign-13 Dec 2002",90853,"2005-07-07");
INSERT INTO hebrew_synonyms VALUES (129,"דִּבֵּר","v","00651246","y","morfix","3.1","rav-milim","3.2","tg1","שוחח (עם מישהו על משהו), דן.","to_speak to_talk",NULL,"אתה מוכרח לדבר איתו, לא ייתכן שהוא ימשיך להתנהג כך.\r\n","checked","#MZ@-need to recheck which RM sense was matched with which synset","web-18 Feb 2003",90853,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (130,"דִּבֵּר","v","00652168","n","morfix","3.1","rav-milim","3.1","tg1","אמר מילים, הביע בקול.","to_speak_to_talk",NULL,"המורה דיבר בקול רם כדי שכל הילדים יוכלו לשמוע אותו","checked","#MZ@-what is the difference between this synset and the \r\ntalk speak utter mouth verbalize one\r\n#IE in this sense, we use only the present tense\r\n","eyal-07 Jul 2005, web-18 Feb 2003",0,"2005-07-07");
INSERT INTO hebrew_synonyms VALUES (131,"דֵּעָה","n","04492484","nn","morfix","1.1","rav-milim","1.1","tg1",NULL,"idea_opinion_thought",NULL,NULL,"revised","#MZ@ - wrong synset because of bad translation - it should only be opinion\r\n#NO","ordan-17 Dec 2004, web-18 Feb 2003, assign-13 Dec 2002",90854,"2004-12-17");
INSERT INTO hebrew_synonyms VALUES (132,"דֵּעָה","n","04564824","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"opinion_thought",NULL,"מה דעתך על משה? ; דעתי שונה מדעתך","checked","#MZ@-there are several senses in RM for opinion - need to check\r\n#IE","eyal-06 Jul 2005, web-18 Feb 2003",90854,"2005-07-06");
INSERT INTO hebrew_synonyms VALUES (133,"דָּבָר","n","05432762","u","morfix","1.2",NULL,NULL,"tg1",NULL,"event_occurrence_happening",NULL,NULL,"checked","#MZ@-bad translation in morfix -RM doesn\'t have this sense (though it has the same bad translation)\r\n#IE I\'m not sure it fits\r\n","eyal-07 Jul 2005, web-18 Feb 2003, assign-13 Dec 2002",0,"2005-07-07");
INSERT INTO hebrew_synonyms VALUES (134,"הִגִּיד","v","00506398","yy","melingo","1.1","sapir","1.2","tg1",NULL,"tell, say",NULL,"תגיד לו שיתרחק ממנה!","checked","#MZ@-there one sense of HIGID (but only in the future and imperative) means to order as in this synset. RM and Morfix mix in with this other synsets as if they were the same (e.g inform)\r\n#IE","eyal-30 Jun 2005, web-15 Feb 2003",90856,"2005-06-30");
INSERT INTO hebrew_synonyms VALUES (135,"הִגִּיד","v","00682542","yy","morfix","1","rav-milim","1.1","tg1",NULL,"say, tell",NULL,"תגיד לי מה מה מטריד אותך","revised","#MZ@- RM and Morfix mix several senses into one. #IE much more common in the future or the imperative forms; in the past form the word that is used is ''amar'' (אמר)","eyal-28 Mar 2004, web-15 Feb 2003",90856,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (136,"הֵמִיר","v","00111031","yy","morfix","1","rav-milim","1.1","tg1",NULL,"change, exchange, convert",NULL,"האם תוכל להמיר את כספי מדולרים לשקלים","revised","#MZ@-ok - RM and morfix appear to have two senses for translation: to change, to exchange ; to convert but RM doesn\'t distinguish the two in Hebrew. Seems WN also has one synset. But check. #IE\r\n","eyal-28 Mar 2004, web-18 Feb 2003",90857,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (137,"הוֹרֶה","n","07456981","yy","morfix","2","rav-milim","1.1","tg1",NULL,"parent",NULL,"לטיול השנתי חייב להצטרף לפחות הורה מלווה אחד","revised","#MZ@-ok #IE in Hebrew the word ''hore'' (הורה) is usually used for both male and female","eyal-28 Mar 2004, web-18 Feb 2003, assign-13 Dec 2002",90858,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (138,"הוֹרָה","v","00506398","yy","melingo","1.1","rav-milim","1.1","tg1","נתן הוראה","order",NULL,"המורה הורתה לתלמידים להכנס לכיתה","checked","#MZ@\r\n#IE","eyal-30 Jun 2005, web-15 Feb 2003",90859,"2005-06-30");
INSERT INTO hebrew_synonyms VALUES (139,"חִבֵּר","v","00881541","u","morfix","4.1","none",NULL,"tg1",NULL,"to_join_to_connect_to_attach",NULL,NULL,"revised","#MZ@-wrong sense of attach\r\n#IE I think the verb התחבר fits better","eyal-24 Nov 2004, web-23 Feb 2003",0,"2004-11-24");
INSERT INTO hebrew_synonyms VALUES (140,"חִבֵּר","v","00881672","yw","morfix","4.1",NULL,NULL,"tg1",NULL,"to_join to_connect to_attach",NULL,NULL,"checked","#MZ@-wrong binyan","web-23 Feb 2003, web-18 Feb 2003, assign-13 Dec 2002",90860,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (141,"חִבֵּר","v","00885494","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"attach",NULL,"היא חיברה את המוצץ לחולצתו של התינוק בשרוך","revised","#MZ@-ok but check other synstes and RM entries\r\n#IE\r\n","eyal-24 Nov 2004, web-23 Feb 2003",90860,"2004-11-24");
INSERT INTO hebrew_synonyms VALUES (7616,"הִצְמִיד","v","00885494","yy","melingo","1.2","rav-milim","1.2",NULL,NULL,"attach",NULL,"לאחר הלידה מצמידה האחות סרט לזרועותיהם של האם והילוד","checked","#IE","eyal-24 Nov 2004",93761,"2004-11-24");
INSERT INTO hebrew_synonyms VALUES (142,"חִבֵּר","v","01554470","nn","morfix","4.1",NULL,NULL,"tg1",NULL,"to_join_to_connect_to_attach",NULL,NULL,"revised","#MZ@-wrong synset- there is no morfix 6.1 (which was the original bisense number)\r\n#IE","eyal-24 Nov 2004, web-18 Feb 2003",0,"2004-11-24");
INSERT INTO hebrew_synonyms VALUES (143,"חִבֵּר","v","01789163","nn","morfix","4.1","none",NULL,"tg1",NULL,"to_join_to_connect_to_attach",NULL,NULL,"revised","#MZ@-this is intransitive - wrong binyan\r\n#IE fits better to התחבר","eyal-24 Nov 2004, web-23 Feb 2003, web-18 Feb 2003, assign-13 Dec 2002",0,"2004-11-24");
INSERT INTO hebrew_synonyms VALUES (144,"חִבֵּר","v","00642843","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"sum, add_up",NULL,"אם נחבר את מספר האנשים בשכונה שלנו למספר האנשים בשכונה הקרובה, נגיע למספר משמעותי ביותר","revised","#MZ@-ok \r\n#IE refers to the first part of RM\'s definition (calculating the sum)","eyal-24 Nov 2004, web-23 Feb 2003",90860,"2004-11-24");
INSERT INTO hebrew_synonyms VALUES (145,"חִבֵּר","v","01164896","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"compose, write",NULL,"למרות גילו הצעיר, הוא הספיק לחבר ארבעה מאמרים שהופיעו בכתבי עת מדעיים חשובים","revised","#MZ@-ok but have to consider this is light of the fact that XIBER is also good for composing music\r\n#IE","eyal-24 Nov 2004, web-23 Feb 2003",90860,"2004-11-24");
INSERT INTO hebrew_synonyms VALUES (146,"חִבֵּר","v","01169420","u","morfix","4.3","rav-milim","4.3","tg1",NULL,"to_compose_to_write",NULL,NULL,"revised","#MZ@-ok but take a look at the other write compose pen synset\r\n#IE WN distinguishes between ''writing music'' and ''writing literary works''. RM does not. Since the word חיבר is already assigned to another synset (''write, compose, pen, indite'') I chose the word הלחין","eyal-24 Nov 2004, web-23 Feb 2003",0,"2004-11-24");
INSERT INTO hebrew_synonyms VALUES (147,"חֶבְרָה","n","05973283","y","morfix","1.1","rav-milim","1.1","tg1","קבוצה גדולה של בני אדם במקום מסוים בעלי מנהגים וחוקים משותפים, תרבות אחת, סדר חברתי ועוד.","society",NULL,"בחברה האסלאמית הנשים נוהגות ללבוש בגדים ארוכים וצנועים ולכסות את הראש ואת הפנים","checked","#MZ@-ok","web-26 Feb 2003",90861,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (148,"חֶבְרָה","n","06107600","y","morfix","1.1","none",NULL,"tg1",NULL,"society",NULL,NULL,"checked","#MZ@-RM doesn\'t really list this sense explicitly","web-26 Feb 2003",90861,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (149,"חֶבְרָה","n","06206464","nn","morfix","1.1",NULL,NULL,"tg1",NULL,"society",NULL,NULL,"revised","#MZ@-not really in Hebrew\r\n#IE","eyal-22 Aug 2004, web-26 Feb 2003, web-18 Feb 2003, assign-13 Dec 2002",90861,"2004-08-22");
INSERT INTO hebrew_synonyms VALUES (150,"חֶבְרָה","n","10037091","yy","morfix","1.1","rav-milim","1.3","tg1",NULL,"society",NULL,"הבוקר ביליתי בחברת אחי","checked","#MZ@-RM doesn\'t distinguish the different senses of society that WN does\r\n#NO This sense does appear in RM, but only in סמיכות, in the form of בחברת, consider also בְּצַוְתָּא","ordan-22 Jun 2004",90861,"2004-06-22");
INSERT INTO hebrew_synonyms VALUES (6869,"חֶשְׁבּוֹן-בַּנְק","n","09619552","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-24 Jun 2004",90862,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (6866,"GAP!","n","06824418","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#NO American geography","ordan-22 Jun 2004",90808,"2004-06-22");
INSERT INTO hebrew_synonyms VALUES (8849,"בֶּן-לְוָיָה","n","07058255","yy","none",NULL,"rav-milim","1.1",NULL,NULL,"companion",NULL,NULL,"checked","#IE appears in the Mellingo English-Hebrew dectionary; WN restricts the meaning to a paid companion, while RM does not ","eyal-20 Jul 2005",95211,"2005-07-20");
INSERT INTO hebrew_synonyms VALUES (155,"חָבֵר","n","07060310","nn","morfix","1.1","rav-milim","1.1","tg1","אדם אהוב שנהנים להיות איתו.","friend_companion",NULL,"יעל וענת הן חברות טובות - תמיד הן נמצאות ביחד","revised","#MZ@-ok but check other synsets\r\n#IE fits better to n#07280379","eyal-23 Nov 2004, web-23 Feb 2003",0,"2004-11-23");
INSERT INTO hebrew_synonyms VALUES (156,"חָבֵר","n","07070950","n","morfix","1.1","rav-milim","1.1","tg1","אדם אהוב שנהנים להיות איתו.","friend_companion",NULL,"הזמנתי למסיבת יום ההולדת שלי את כל החברים מהכיתה.","checked","#MZ@-ok but RM doesn\'t distinguish this synset from others\r\n#IE","eyal-20 Jul 2005, web-23 Feb 2003",0,"2005-07-20");
INSERT INTO hebrew_synonyms VALUES (8854,"חָבֵר","n","H0004069","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"friend",NULL,"לכל ילד כדאי שיהיה לפחות חבר טוב אחד","checked","#IE","eyal-20 Jul 2005",90863,"2005-07-20");
INSERT INTO hebrew_synonyms VALUES (8851,"GAP!","n","07172472","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE","eyal-20 Jul 2005",90808,"2005-07-20");
INSERT INTO hebrew_synonyms VALUES (159,"חָבֵר","n","07280379","n","morfix","1.1","rav-milim","1.1","tg1","אדם אהוב שנהנים להיות איתו","friend_companion",NULL,"יעל וענת הן חברות טובות - תמיד הן נמצאות ביחד","checked","#MZ@-oj but need to look at all synsets and RM meanings\r\n#IE gender","eyal-20 Jul 2005, web-26 Feb 2003",0,"2005-07-20");
INSERT INTO hebrew_synonyms VALUES (160,"חָבֵר","n","07623193","yw","morfix","1.1",NULL,NULL,"tg1",NULL,"friend companion",NULL,NULL,"checked","#MZ@-no","web-26 Feb 2003, web-18 Feb 2003, assign-13 Dec 2002",90863,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (161,"חָבֵר","n","07058255","n","morfix","1.2",NULL,NULL,"tg1","((slang))","partner_companion_steady",NULL,NULL,"checked","#MZ@-wrong\r\n#IE","eyal-20 Jul 2005, web-23 Feb 2003",0,"2005-07-20");
INSERT INTO hebrew_synonyms VALUES (162,"חָבֵר","n","07172243","y","melingo","1.1","none",NULL,"tg1",NULL,"companion",NULL,"האם שחקן פוקר, שרגיל לא לחייך מול חבריו למשחק, נמנע גם מחיוכים לחבריו מחוץ למשחק?","checked","#MZ@- Morfix distinguishes two senses that RM doesn\'t - but check for other potential synsets\r\n#IE although this sense does not appear in RM nor in Sapir, I decided to add it since there are many examples to support it: חברים לנשק, חבר למשחק meaning someone you spend time with periodically in your life, but he is not necessarily your friend","eyal-20 Jul 2005, web-23 Feb 2003",90863,"2005-07-20");
INSERT INTO hebrew_synonyms VALUES (163,"חָבֵר","n","07172472","n","morfix","1.2",NULL,NULL,"tg1","((slang))","partner_companion_steady",NULL,NULL,"checked","#MZ@-no such specific sense\r\n#IE the only equivalent I could think of, is חבר למסע, which may as well be part of   n#07172243","eyal-20 Jul 2005, web-26 Feb 2003, web-18 Feb 2003, assign-13 Dec 2002",0,"2005-07-20");
INSERT INTO hebrew_synonyms VALUES (164,"חָבֵר","n","07626109","y","morfix","1.2","rav-milim","1.2","tg1","בן-זוג, מישהו שיוצאים איתו באופן קבוע","partner companion steady",NULL,"אין לה חבר - היא תשמח להכיר מישהו","checked","#MZ@","web-26 Feb 2003",90863,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (165,"חָבֵר","n","05021232","n","morfix","1.4",NULL,NULL,"tg1",NULL,"associate",NULL,NULL,"checked","#MZ@-wrong sense of associate\r\n#IE no equivalent in Hebrew","eyal-20 Jul 2005, web-26 Feb 2003, web-18 Feb 2003, assign-13 Dec 2002",0,"2005-07-20");
INSERT INTO hebrew_synonyms VALUES (166,"חָבֵר","n","05433744","n","morfix","1.4",NULL,NULL,"tg1",NULL,"associate",NULL,NULL,"checked","#MZ@-wrong sense of associate\r\n#IE no equivalent in Hebrew","eyal-20 Jul 2005, web-26 Feb 2003, web-18 Feb 2003, assign-13 Dec 2002",0,"2005-07-20");
INSERT INTO hebrew_synonyms VALUES (167,"חָבֵר","n","07087841","y","morfix","1.4","rav-milim","1.5","tg1","מי ששייך לחברה, לארגון, למוסד וכד\' והוא חלק מהם","associate",NULL,"הכניסה למועדון מותרת לחברים בלבד","checked","#MZ@-ok","web-26 Feb 2003",90863,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (8853,"GAP!","n","07280379","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE gender","eyal-20 Jul 2005",90808,"2005-07-20");
INSERT INTO hebrew_synonyms VALUES (169,"חָבֵר","n","07128110","yy","melingo","1.5","rav-milim","1.8","tg2",NULL,"Comrade",NULL,"חברים, אני מבקש להתחיל באסיפה","checked","#MZ@-ok but need to make some order in XAVER RM senses and WN synsets\r\n#IE","eyal-20 Jul 2005, web-26 Feb 2003, web-18 Feb 2003, assign-13 Dec 2002",90863,"2005-07-20");
INSERT INTO hebrew_synonyms VALUES (8858,"פְּרִימִיטִיבִי","a","00779258","yy","melingo","1.1","rav-milim","1.3",NULL,NULL,"primitive",NULL,"תושבי הכפר חיים בתנאים פרימיטיביים למדי, ללא חשמל או מים זורמים","checked","#IE","eyal-01 Aug 2005",95214,"2005-08-01");
INSERT INTO hebrew_synonyms VALUES (171,"חָבֵר","n","07174252","n","morfix","1.5","rav-milim","1.8","tg2","(בעיקר ביידוע: החבר) כינוי שנהוג להוסיף בחברות סוציאליות וקומוניסטיות (בארץ - בעיקר בקיבוצים) לפני שמו של אדם (במקום \'מר\' או \'אדון\') כאות לרעיון השוויוניות המעמדית. בקיצור: ח\', הח\'.","Comrade",NULL,"את האסיפה יפתח החבר ליבוביץ\', יו''ר מועצת הפועלים המקומית","checked","#MZ@-RM doesn\'t distinguish this sense from the brother comrade\r\nsense\r\n#IE and therefore it should be a gap","eyal-20 Jul 2005, web-26 Feb 2003, web-18 Feb 2003, assign-13 Dec 2002",0,"2005-07-20");
INSERT INTO hebrew_synonyms VALUES (172,"לֹא","r","00022819","y","morfix","1.1","rav-milim","1","tg1",NULL,"no not",NULL,NULL,"checked","#MZ@-RM makes many distinctions; there are 23 ''meanings'', which can be viewed really different uses; but revisit","web-27 Feb 2003, web-18 Feb 2003, assign-13 Dec 2002",90865,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (173,"לֹא","r","00023074","yy","morfix","1.1","rav-milim","1.3","tg1",NULL,"no",NULL,"רוצה סיגריה? לא, אינני מעשן","checked","#MZ@\r\n#NO","ordan-04 Aug 2004",90865,"2004-08-04");
INSERT INTO hebrew_synonyms VALUES (174,"לֹא","r","00023305","y","morfix","1.1","rav-milim","1","tg1",NULL,"no not",NULL,NULL,"checked","#MZ@-RM has 23 senses for no","web-27 Feb 2003, web-18 Feb 2003, assign-13 Dec 2002",90865,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (175,"לֹא","r","00049246","y","morfix","1.1","rav-milim","1","tg1",NULL,"no not",NULL,NULL,"checked","#MZ@-RM has 23 senses","web-27 Feb 2003, web-18 Feb 2003, assign-13 Dec 2002",90865,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (176,"לֹא","r","00115773","nn","morfix","1.3",NULL,NULL,"tg1",NULL,"no_matter",NULL,NULL,"checked","#MZ@-Morfix is wrong, I think","web-27 Feb 2003, web-18 Feb 2003, assign-13 Dec 2002",90865,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (177,"מִנָּה","v","01598583","nn","morfix","3.1",NULL,NULL,"tg1",NULL,"to_appoint",NULL,NULL,"revised","#MZ@-wrong sense of appoint\r\n#IE","eyal-17 Nov 2004, web-02 Mar 2003, web-18 Feb 2003, assign-13 Dec 2002",0,"2004-11-17");
INSERT INTO hebrew_synonyms VALUES (178,"מִנָּה","v","01632168","u","morfix","1.1","rav-milim","1.1","tg1",NULL,"appoint, nominate",NULL,"המנהל החדש מונה לתפקיד רק חודשיים אחרי פיטורי קודמו","checked","#MZ@\r\n#NO compare other sysnets of \'nominate\'","ordan-18 Jul 2004",90866,"2004-07-18");
INSERT INTO hebrew_synonyms VALUES (179,"מִנָּה","v","01686884","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"appoint",NULL,"הוא מונה לסגן המנהל של המפעל","revised","#MZ@-not clear how this WN synset is different from the appoint name nominate constitute synset. RM doesn\'t distinguish.\r\n#IE","eyal-17 Nov 2004, web-02 Mar 2003",90867,"2004-11-17");
INSERT INTO hebrew_synonyms VALUES (180,"מָנָה","n","00702886","u","morfix","1.1","rav-milim","1.1","tg1","כמות מזון המיועדת והמוגשת לאדם אחד; חלק מארוחה. בדרך כלל יש שלוש מנות בארוחה: מנה ראשונה (סלט, מרק וכד\'), מנה עיקרית (בשר, ירקות וכד\') ומנה אחרונה (לפתן, עוגה וכד\').","portion",NULL,"אפשר לקבל מנה נוספת של עוף?","revised","#MZ@-need to consider RM 1.2 also\r\n#NO i tend to agree, need to be considered, although i don\'t like the above example","ordan-24 May 2004, web-01 Mar 2003, web-18 Feb 2003, assign-13 Dec 2002",90868,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (181,"מָנָה","n","09561632","nn","morfix","1.1","rav-milim","1.2","tg1","כמות מסוימת או מוגבלת של משהו.","portion",NULL,NULL,"revised","#MZ@-in RM it should be 1.2 (not 1.1) though both 1.1 and 1.2 in Morfix is OK\r\n#NO to my mind it\'s too general","ordan-24 May 2004, web-01 Mar 2003",90868,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (6757,"קָמֵעַ","n","02185947","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"amulet, talisman",NULL,"הצבע הכחול רווח בקמעות המופצים במזרח התיכון","checked","#NO","ordan-24 May 2004",90869,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (183,"מָנָה","n","02592220","u","morfix","1.2","rav-milim","1.2","tg1",NULL,"dose_share_unit_ration",NULL,NULL,"revised","#MZ@\r\n#IE מנה can be a dose of anything, not specifically of a medicine","eyal-17 Nov 2004, web-01 Mar 2003",0,"2004-11-17");
INSERT INTO hebrew_synonyms VALUES (184,"מָנָה","n","05621640","y","morfix","1.2","rav-milim","1.2","tg1","כמות מסוימת או מוגבלת של משהו.","dose share unit ration",NULL,NULL,"checked","#MZ@-RM doesn\'t distinguish this meaning","web-01 Mar 2003",90868,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (186,"מָנָה","n","09562389","y","morfix","1.2","rav-milim","1.2","tg1","כמות מסוימת או מוגבלת של משהו.","dose share unit ration",NULL,NULL,"checked","#MZ@-RM doesn\'t distinguish","web-01 Mar 2003, web-27 Feb 2003, assign-13 Dec 2002",90868,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (187,"מָנָה","n","09918604","u","morfix","1.2","rav-milim","1.2","tg1","כמות מסוימת או מוגבלת של משהו.","dose_share_unit_ration",NULL,NULL,"revised","#MZ@-RM doesn\'t disntinguish\r\n#IE מינון fits better","eyal-17 Nov 2004, web-01 Mar 2003",0,"2004-11-17");
INSERT INTO hebrew_synonyms VALUES (188,"מָנָה","n","04512950","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"quotient",NULL,NULL,"revised","#MZ@\r\n#IE","eyal-17 Nov 2004, web-01 Mar 2003, assign-13 Dec 2002",90868,"2004-11-17");
INSERT INTO hebrew_synonyms VALUES (189,"מָנָה","n","09957148","y","morfix","1.3","rav-milim","1.3","tg1","מתמטיקה תוצאה של פעולת חילוק; המספר המתקבל מחלוקה של מספר במספר אחר.","quotient",NULL,"בתרגיל 3=24:8, המנה היא שלוש.","checked","#MZ@-RM doesn\'t distinguish the two quotient senses in WN","web-01 Mar 2003",90868,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (190,"מָנָה","n","05033972","y","morfix","1.4","rav-milim","1.4","tg1","slang","rebuke",NULL,"נתן לו מנה","checked","#MZ@ #IE ","eyal-09 Mar 2004",90868,"2004-03-09");
INSERT INTO hebrew_synonyms VALUES (191,"מָנָה","v","00642112","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"count",NULL,"המורה מנה את הילדים שעלו להסעה בבוקר","revised","#MZ@\r\n#IE refers to the second part of RM\'s definition","eyal-17 Nov 2004, web-02 Mar 2003",90870,"2004-11-17");
INSERT INTO hebrew_synonyms VALUES (7544,"GAP!","v","01598583","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE the exact meaning of ''ריהט'' and much less common than ''furnish''","eyal-17 Nov 2004",90931,"2004-11-17");
INSERT INTO hebrew_synonyms VALUES (7545,"מֹרַת-רוּחַ","n","05605389","yy","oxford","1.1","rav-milim","1.1",NULL,NULL,"displeasure",NULL,"הוא התקשה להסתיר את מורת רוחו מהשאלות שהופנו אליו בראיון","checked","#IE","eyal-17 Nov 2004",93710,"2004-11-17");
INSERT INTO hebrew_synonyms VALUES (193,"מָנָה","v","00641064","yy","melingo","2.3","rav-milim","2.3","tg1",NULL,"enumerate",NULL,"היא מנתה את המכשולים הרבים אותם היתה צריכה לעבור בדרך לפסגה","revised","#MZ@\r\n#IE","eyal-17 Nov 2004, web-02 Mar 2003",90870,"2004-11-17");
INSERT INTO hebrew_synonyms VALUES (7543,"סָפַר","v","00641935","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"count",NULL,"הילד יודע כבר לספור עד 100","checked","#IE","eyal-17 Nov 2004",90873,"2004-11-17");
INSERT INTO hebrew_synonyms VALUES (195,"סִפֵּר","v","00645379","y","morfix","5.1","rav-milim","5.2","tg1","הביע בעל-פה או בכתב דבר שהיה, שקרה וכד\'","to_read_aloud to_relate to_tell",NULL,NULL,"checked","#MZ@-RM distinguishes 4 senses here. But the overlap with WN synsets is not good. The first sense RM shows is poorly written because SIPER doesn\'t mean KARA. Will need to make some order in this in second pass.\r\n","web-02 Mar 2003",90871,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (196,"סַפָּר","n","07101261","y","morfix","3.1","rav-milim","3.1","tg1","אדם שמקצועו גזיזת שיער ועיצוב תספורות ותסרוקות.","barber hairdresser",NULL,"השיער שלך כבר ארוך, אתה צריך ללכת לספר","checked","#MZ@-Hebrew dosn\'t distinguish barber from hairdresser","web-02 Mar 2003",90872,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (197,"סַפָּר","n","07307341","y","morfix","3.1","rav-milim","3.1","tg1","אדם שמקצועו גזיזת שיער ועיצוב תספורות ותסרוקות","barber hairdresser",NULL,"השיער שלך כבר ארוך, אתה צריך ללכת לספר.","checked","#MZ@-Hebrew doesn\'t distinguish barber and hairdresser","web-02 Mar 2003, assign-13 Dec 2002",90872,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (198,"סָפַר","v","00642112","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"count",NULL,"תספור בבקשה את הספרים על המדף","revised","#MZ@-two RM senses are the same synset, I think.\r\n#IE","eyal-17 Nov 2004, web-02 Mar 2003",90873,"2004-11-17");
INSERT INTO hebrew_synonyms VALUES (8137,"GAP!","n","07207213","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-03 Feb 2005",90808,"2005-02-03");
INSERT INTO hebrew_synonyms VALUES (8136,"שָׁלָל","n","09543577","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"loot, boot",NULL,NULL,"checked","#NO","ordan-03 Feb 2005",94383,"2005-02-03");
INSERT INTO hebrew_synonyms VALUES (8138,"סָנֵגוֹר","n","H0003583","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-03 Feb 2005",94387,"2005-02-03");
INSERT INTO hebrew_synonyms VALUES (204,"פְּרָס","n","00053585","nn","morfix","5.2","none",NULL,"tg1",NULL,"award",NULL,NULL,"revised","#MZ@-different sense of award #IE not the right word","eyal-19 Apr 2004, web-04 Mar 2003",90874,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (205,"פְּרָס","n","05020360","y","morfix","5.2","rav-milim","5.2","tg1","תואר של כבוד והערכה הניתן למצטיין בתחום מסוים או למי שראוי לשבח על עבודתו, על פועלו וכד\'.","award",NULL,NULL,"checked","#MZ@","web-04 Mar 2003, web-27 Feb 2003, assign-13 Dec 2002",90874,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (8140,"פְּקַק-שַׁעַם","n","10635013","yy","none",NULL,"none",NULL,NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-03 Feb 2005",94391,"2005-02-03");
INSERT INTO hebrew_synonyms VALUES (207,"פְּרָס","n","00791294","y","morfix","5.3","rav-milim","5.3","tg1","גמול, שכר, סכום כסף או דבר ערך אחר המובטח למישהו תמורת מידע, שירות, מעשה או מאמץ שהוא משקיע במשהו.","reward",NULL,NULL,"checked","#MZ@","web-04 Mar 2003, web-27 Feb 2003, assign-13 Dec 2002",90874,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (208,"פְּרָס","n","05358552","y","morfix","5.3","rav-milim","5.3","tg1","גמול, שכר, סכום כסף או דבר ערך אחר המובטח למישהו תמורת מידע, שירות, מעשה או מאמץ שהוא משקיע במשהו.","reward",NULL,NULL,"checked","#MZ@","web-04 Mar 2003",90874,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (209,"פְּרָס","n","05441142","y","morfix","5.3","rav-milim","5.3","tg1","גמול, שכר, סכום כסף או דבר ערך אחר המובטח למישהו תמורת מידע, שירות, מעשה או מאמץ שהוא משקיע במשהו","reward",NULL,NULL,"checked","#MZ@","web-04 Mar 2003",90874,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (210,"פְּרָס","n","09560299","y","morfix","5.3","rav-milim","5.3","tg1","גמול, שכר, סכום כסף או דבר ערך אחר המובטח למישהו תמורת מידע, שירות, מעשה או מאמץ שהוא משקיע במשהו","reward",NULL,NULL,"checked","#MZ@","web-04 Mar 2003, web-27 Feb 2003, assign-13 Dec 2002",90874,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (211,"פִּרְסֵם","v","00646076","y","morfix","1.1","rav-milim","1.1","tg1","הודיע ברבים, הביא לידיעת הציבור.","to_publicize",NULL,NULL,"checked","#MZ@","web-04 Mar 2003",90875,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (212,"פִּרְסֵם","v","00660910","y","morfix","1.1","rav-milim","1.1","tg1",NULL,"to_publicize",NULL,NULL,"checked","#MZ@","web-04 Mar 2003, web-27 Feb 2003, assign-13 Dec 2002",90875,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (213,"פִּרְסֵם","v","00660910","y","morfix","1.2","rav-milim","1.1","tg1","הודיע ברבים, הביא לידיעת הציבור","to_advertise",NULL,NULL,"checked","#MZ@","web-04 Mar 2003, web-27 Feb 2003, assign-13 Dec 2002",90875,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (214,"פִּרְסֵם","v","00655737","y","morfix","1.3","rav-milim","1.3","tg1","הוציא לאור, הדפיס עותקים של ספר, עיתון, מאמר וכד\'; הפיק דבר דפוס למכירה או לחלוקה, הביא להפקתו של דבר בדפוס.","to_publish",NULL,NULL,"checked","#MZ@","web-04 Mar 2003, assign-13 Dec 2002",90875,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (215,"פִּרְסֵם","v","01192426","y","morfix","1.3","rav-milim","1.3","tg1"," הוציא לאור, הדפיס עותקים של ספר, עיתון, מאמר וכד\'; הפיק דבר דפוס למכירה או לחלוקה, הביא להפקתו של דבר בדפוס.","to_publish",NULL,NULL,"checked","#MZ@","web-04 Mar 2003, web-27 Feb 2003, assign-13 Dec 2002",90875,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (216,"פִּרְסֵם","v","01193001","y","morfix","1.3","rav-milim","1.3","tg1"," הוציא לאור, הדפיס עותקים של ספר, עיתון, מאמר וכד\'; הפיק דבר דפוס למכירה או לחלוקה, הביא להפקתו של דבר בדפוס.","to_publish",NULL,NULL,"checked","#MZ@","web-04 Mar 2003",90875,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (217,"פָּרַס","v","00762959","yw","morfix","3.1",NULL,NULL,"tg1","((bread, cheese, salami))","to_slice to_cut",NULL,NULL,"checked","#MZ@-wrong sense of slice","web-04 Mar 2003, web-27 Feb 2003, assign-13 Dec 2002",90876,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (218,"פָּרַס","v","00855714","y","morfix","2.1","rav-milim","2.1","tg1","חתך לחם, גבינה, נקניק וכד\' לפרוסות, חתך לחתיכות שטוחות בעזרת סכין.","to_slice to_cut",NULL,NULL,"checked","#MZ@","web-04 Mar 2003, web-27 Feb 2003, assign-13 Dec 2002",90876,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (219,"פָּרַס","v","00965965","yw","morfix","3.1",NULL,NULL,"tg1","((bread, cheese, salami))","to_slice to_cut",NULL,NULL,"checked","#MZ@","web-04 Mar 2003, web-27 Feb 2003",90876,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (220,"פָּרַס","v","01074448","yw","morfix","2.1",NULL,NULL,"tg1","((bread, cheese, salami))","to_slice to_cut",NULL,NULL,"checked","#MZ@","web-04 Mar 2003",90876,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (221,"פָּרַס","v","00781082","yy","morfix","2.2","rav-milim","2.2","tg1",NULL,"deploy",NULL,"הצבא פרס את כוחותיו לאורך הגבול","revised","#MZ@\r\n#NO","ordan-08 Feb 2005, web-04 Mar 2003",90876,"2005-02-08");
INSERT INTO hebrew_synonyms VALUES (222,"שִׁנָּה","v","00082064","y","morfix","3.1","rav-milim","3","tg1",NULL,"to_change to_alter",NULL,NULL,"checked","#MZ@-RM has several senses that correspond to this","web-27 Feb 2003, assign-13 Dec 2002",90877,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (223,"שִׁנָּה","v","00083947","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"change, alter",NULL,"הדיון שינה את אופן חשיבתי בנוגע לנושא הרגיש הזה","revised","#MZ@-I don\'t see what is the difference between the two WN synsets\r\n#IE","eyal-01 Mar 2005, web-27 Feb 2003, assign-13 Dec 2002",92427,"2005-03-01");
INSERT INTO hebrew_synonyms VALUES (224,"שִׁנָּה","v","00385513","u","morfix","3.1","rav-milim","3","tg1",NULL,"to_change_to_alter",NULL,NULL,"revised","#MZ@-RM has several senses that are the same here\r\n#IE החליף fits better\r\n","eyal-21 Dec 2004, web-27 Feb 2003, assign-13 Dec 2002",0,"2004-12-21");
INSERT INTO hebrew_synonyms VALUES (7846,"הֶחְלִיף","v","00385513","yy","melingo","1.2","rav-milim","1.2",NULL,NULL,"change",NULL,"לאחרונה החלפנו כמה מכשירי חשמל בבית","checked","#IE","eyal-21 Dec 2004",93899,"2004-12-21");
INSERT INTO hebrew_synonyms VALUES (226,"שֵׁנָה","n","10060454","nn","morfix","2.1","none",NULL,"tg1",NULL,"sleep_slumber",NULL,NULL,"revised","#MZ@-Hebrew doesn\'t have this sense of sleep\r\n#IE","eyal-01 Mar 2005, web-27 Feb 2003, assign-13 Dec 2002",0,"2005-03-01");
INSERT INTO hebrew_synonyms VALUES (227,"שֵׁנָה","n","10094888","yw","morfix","2.1",NULL,NULL,"tg1",NULL,"sleep slumber",NULL,NULL,"checked","#MZ@-not in RM - look at corpora because maybe it is OK","web-27 Feb 2003, assign-13 Dec 2002",90878,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (228,"שֵׁנָה","n","10102311","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"sleep, slumber",NULL,"נהניתי משינה רצופה נטולת חלומות","revised","#MZ@-\r\n#IE","eyal-01 Mar 2005, web-27 Feb 2003, assign-13 Dec 2002",90878,"2005-03-01");
INSERT INTO hebrew_synonyms VALUES (229,"שֵׁנָה","n","10103438","yw","morfix","2.1",NULL,NULL,"tg1",NULL,"sleep slumber",NULL,NULL,"checked","#MZ@-not in RM - need to look at corpora\r\n","web-27 Feb 2003, assign-13 Dec 2002",90878,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (230,"שֵׁנָה","n","10971856","y","morfix","2.1","rav-milim","2.1","tg1","מצב של חוסר עֵרות שחלה בו האטה בפעילות המוח והשרירים הרצוניים. השינה נחלקת לכמה שלבים, והצורך בה מתעורר במחזוריות (בכל לילה).","sleep slumber",NULL,"נרדמתי מייד ושקעתי בשינה עמוקה.","checked","#MZ@-RM doesn\'t distinguish the two synsets (sleep slumber and sleep nap)","web-27 Feb 2003, assign-13 Dec 2002",90878,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (231,"שָׁנָה","n","06115587","nn","morfix","1.1","rav-milim","1.4","tg1",NULL,"year",NULL,NULL,"revised","#MZ@-no exactly - review against other Wn synsets\r\n#IE\r\n","eyal-28 Feb 2005, web-27 Feb 2003",0,"2005-02-28");
INSERT INTO hebrew_synonyms VALUES (232,"שָׁנָה","n","10915598","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"year",NULL,"שנה של מאדים אורכת 687 יום","revised","#MZ@-RM doesn\'t list this meaning but I assume this is same as earth year meaning\r\n#IE","eyal-01 Mar 2005, web-27 Feb 2003, assign-13 Dec 2002",90879,"2005-03-01");
INSERT INTO hebrew_synonyms VALUES (233,"שָׁנָה","n","10917509","yy","melingo","1.1","rav-milim","1.3","tg1",NULL,"year",NULL,"אנחנו נשואים כבר חמש עשרה שנים","revised","#MZ@-ok\r\n#IE","eyal-01 Mar 2005, web-18 Feb 2003, assign-13 Dec 2002",90879,"2005-03-01");
INSERT INTO hebrew_synonyms VALUES (234,"שָׁנָה","n","10917791","y","morfix","1.1, 1.2","rav-milim","1.2, 1.3, 1.4","tg1",". תקופה באורך זה בקירוב, על-פי לוח מסוים, המחולקת לשנים עשר חודשים.","year",NULL,NULL,"checked","#MZ@-RM distinguishes two senses here that WN collapses, and rightly so, I think","web-18 Feb 2003",90879,"0000-00-00");
INSERT INTO hebrew_synonyms VALUES (235,"שָׁנָה","n","10917283","yy","melingo","1.2","rav-milim","1.4","tg1",NULL,"school_year",NULL,"המורה שלנו יצאה לחופשת לידה חודשיים לפני סיום השנה","revised","#MZ@\r\n#IE","eyal-01 Mar 2005, web-27 Feb 2003",90879,"2005-03-01");
INSERT INTO hebrew_synonyms VALUES (236,"בֵּי''ת","n","05120394","yy",NULL,NULL,"rav-milim","2.1",NULL,NULL,"Beth",NULL,NULL,"revised","MZ-another way to write BET","ordan-08 Apr 2004, web-15 Feb 2003",90880,"2004-04-08");
INSERT INTO hebrew_synonyms VALUES (237,"ג\'וּלָה","n","02966407","yy","morfix","2","rav-milim","1.1",NULL,"(from Arabic)","marble",NULL,NULL,"revised","#IE","eyal-22 Mar 2004, web-18 Feb 2003",90881,"2004-03-22");
INSERT INTO hebrew_synonyms VALUES (238,"!אֲגַף","n","06302563","y","melingo","1","rav-milim",NULL,"tg1",NULL,"department, branch",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (239,"אֲגַף","n","06049069","yy","melingo","1","rav-milim","1.1","tg1",NULL,"department, branch",NULL,"אגף הכלכלה מרכז את הפעילות הכלכלית בהתאחדות התעשיינים","revised","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@ #IE","eyal-16 Nov 2004, eyal-18 Feb 2004, shuly-11 Jan 2004",90882,"2004-11-16");
INSERT INTO hebrew_synonyms VALUES (241,"אֲגַף","n","06261108","yy","melingo","3","rav-milim","1.3","tg1","((military))","flank",NULL,"הם תקפו את האגף הימני של האויב","revised","#ASSIGN:65.0=[gnd=1.0E+01,flc(dic)=49.0,bt(dir)=6.0] #MZ@ #IE","eyal-18 Feb 2004, shuly-12 Jan 2004, assign-6 Nov 2003",90882,"2004-02-18");
INSERT INTO hebrew_synonyms VALUES (242,"!אֲתָר","n","06371658","y","melingo","1","rav-milim",NULL,"tg1",NULL,"site",NULL,NULL,"assigned","#ASSIGN:41.0=[gnd=2.0E+01,bt(dir)=21.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (243,"!אֲתָר","n","06353805","y","melingo","1","rav-milim",NULL,"tg1",NULL,"site",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (8841,"GAP!","n","07591125","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE gender","eyal-18 Jul 2005",90808,"2005-07-18");
INSERT INTO hebrew_synonyms VALUES (246,"אִי","n","09904832","yy","melingo","0","rav-milim",NULL,"tg1",NULL,"E",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-11 Feb 2004",90884,"2004-02-11");
INSERT INTO hebrew_synonyms VALUES (247,"גּוּף","n","04774665","yy","none",NULL,"rav-milim","1.7","tg1",NULL,"person",NULL,"סלבדור דאלי היה נוהג לדבר על עצמו בגוף שלישי","revised","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","ordan-10 Aug 2004, eyal-26 Jan 2004, assign-6 Nov 2003",90885,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (249,"אִישׁ","n","00004123","yy","melingo","1","rav-milim","1","tg1",NULL,"person, adult",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@ #IE","eyal-04 Feb 2004, assign-6 Nov 2003",90886,"2004-02-04");
INSERT INTO hebrew_synonyms VALUES (251,"!אִישׁ","n","07602853","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"husband, spouse",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=2.0E+01,bt(dir)=9.0] #MZ@\r\n#IE","eyal-11 Apr 2005, assign-6 Nov 2003",0,"2005-04-11");
INSERT INTO hebrew_synonyms VALUES (252,"אִישׁ","n","07331418","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"husband, spouse",NULL,"אישי ואני נשואים כבר 14 שנים","checked","#ASSIGN:43.0=[gnd=39.0,bt(dir)=4.0] #MZ@ #IE","eyal-09 May 2004, eyal-09 Feb 2004, assign-6 Nov 2003",90886,"2004-05-09");
INSERT INTO hebrew_synonyms VALUES (253,"אִמּוּן","n","00574902","yy","melingo","1","rav-milim","1","tg1",NULL,"training, exercise, practice",NULL,"לאחר אימונים רבים, הצליח הילד לנגן את היצירה בכינור","checked","#ASSIGN:50=[gnd=8.0,gnd=8.0,si=9.0,bt(dir)=8.0,bt(dir)=8.0,dfl=9.0] #MZ@ #IE","eyal-08 Feb 2004, assign-6 Nov 2003",90887,"2004-02-08");
INSERT INTO hebrew_synonyms VALUES (254,"אִפְשֵׁר","v","01649126","yy","melingo","1","rav-milim","1","tg1",NULL,"permit, allow",NULL,"דלת אטומה זו לא תאפשר למים לרדת למרתף","checked","#ASSIGN:27.0=[gnd=13.0,gnd=4.0,si=1.0E+01] #MZ@ #IE","eyal-08 Feb 2004, assign-6 Nov 2003",90888,"2004-02-08");
INSERT INTO hebrew_synonyms VALUES (255,"!אִפְשֵׁר","v","00545801","y","melingo","1","rav-milim",NULL,"tg1",NULL,"permit, allow",NULL,NULL,"assigned","#ASSIGN:27.0=[gnd=13.0,gnd=4.0,si=1.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (256,"אִפְשֵׁר","v","00545347","yy","melingo","1","rav-milim","1","tg1",NULL,"permit, allow",NULL,"הוא לא איפשר לי לראות את הבחינה","checked","#ASSIGN:27.0=[gnd=13.0,gnd=4.0,si=1.0E+01] #MZ@ #IE","eyal-08 Feb 2004, assign-6 Nov 2003",90888,"2004-02-08");
INSERT INTO hebrew_synonyms VALUES (257,"אִפְשֵׁר","v","00357077","yy","melingo","2","rav-milim","1","tg1",NULL,"enable",NULL,"ההתמחות הזו תאפשר לך למצוא עבודה בבורסה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-08 Feb 2004, assign-6 Nov 2003",90888,"2004-02-08");
INSERT INTO hebrew_synonyms VALUES (258,"!אִרְגּוּן","n","04423455","u","melingo","1","rav-milim",NULL,"tg1",NULL,"organization",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=6.0,bt(dir)=5.0,bt(dir)=5.0,bt(crs)=1.0E+01] #MZ@\r\n#IN","ordan-07 Jul 2004, assign-6 Nov 2003",0,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (259,"!אִרְגּוּן","n","00650412","undef","melingo","1","rav-milim",NULL,"tg1",NULL,"organization",NULL,NULL,"checked","#ASSIGN:28.0=[gnd=6.0,bt(dir)=6.0,bt(dir)=5.0,bt(crs)=11.0] #MZ@\r\n#NO","ordan-16 Mar 2004, assign-6 Nov 2003",0,"2004-03-16");
INSERT INTO hebrew_synonyms VALUES (260,"אִשּׁוּר","n","04987262","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"corroboration",NULL,"בעקבות שיחה עם המחנכת, מצאתי אישור לכך כי על בני עוברת תקופה קשה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-24 Jun 2004",90889,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (261,"אֵבֶל","n","10077974","y","melingo","1","rav-milim","1","tg1",NULL,"mourning, bereavement",NULL,"ימי האבל על אביו נמשכו שלושים יום","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO ","shuly-10 Jan 2004",90890,"2004-01-10");
INSERT INTO hebrew_synonyms VALUES (262,"!אֵזוֹר","n","06395720","y","melingo","1","rav-milim",NULL,"tg1",NULL,"region, area, zone",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (263,"!אֵזוֹר","n","06297080","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"region, area, zone",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#IN אזור is too general","ordan-07 Jul 2004",0,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (264,"אֵזוֹר","n","06276601","yy","melingo","1","rav-milim","1","tg1",NULL,"region, area, zone",NULL,"אנחנו גרים באיזור גבוה וקריר","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-11 Feb 2004",90891,"2004-02-11");
INSERT INTO hebrew_synonyms VALUES (265,"!אֵזוֹר","n","06268839","y","melingo","1","rav-milim",NULL,"tg1",NULL,"region, area, zone",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=7.0,bt(dir)=7.0,bt(dir)=9.0,bt(crs)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (266,"!אֵזוֹר","n","04059885","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"region, area, zone",NULL,NULL,"checked","#ASSIGN:68.0=[gnd=8.0,gnd=7.0,si=8.0,bt(dir)=6.0,bt(dir)=9.0,bt(crs)=15.0,bt(dir)=6.0,bt(dir)=9.0] #MZ@\r\n#IN we use אזור but it doesn\'t justify such a specific definition","ordan-07 Jul 2004, assign-6 Nov 2003",0,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (267,"אֵזוֹר","n","06369402","yy","melingo","2","rav-milim","2","tg1","((military))","Sector",NULL,NULL,"checked","#ASSIGN:56.0=[gnd=7.0,flc(dic)=49.0] #MZ@ #IE","eyal-11 Feb 2004, assign-6 Nov 2003",90891,"2004-02-11");
INSERT INTO hebrew_synonyms VALUES (268,"אֵירוֹפִּי","a","02734993","yy","melingo","1","rav-milim","2","tg1",NULL,"European",NULL,"קהילה אירופית","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-10 Feb 2004, assign-6 Nov 2003",90892,"2004-02-10");
INSERT INTO hebrew_synonyms VALUES (269,"אֵירוֹפִּי","n","07002675","nn","melingo","1","rav-milim","1","tg1",NULL,"European",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE gender","eyal-27 Feb 2005, eyal-10 Feb 2004, assign-6 Nov 2003",0,"2005-02-27");
INSERT INTO hebrew_synonyms VALUES (270,"אֵל","n","06888992","yy","melingo","1","rav-milim","1","tg1",NULL,"God, the_Lord",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-10 Feb 2004, assign-6 Nov 2003",90894,"2004-02-10");
INSERT INTO hebrew_synonyms VALUES (271,"אֵלָה","n","09060979","yy","melingo","1","rav-milim","1","tg1",NULL,"terebinth",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ IE","eyal-10 Feb 2004, assign-6 Nov 2003",90895,"2004-02-10");
INSERT INTO hebrew_synonyms VALUES (272,"אֵלָה","n","06888584","yy","melingo","1","rav-milim","1","tg2",NULL,"goddess",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-10 Feb 2004, assign-6 Nov 2003",90895,"2004-02-10");
INSERT INTO hebrew_synonyms VALUES (273,"מְאֹרָע","n","05432762","u","melingo","1","rav-milim","1","tg1",NULL,"happening, occurrence",NULL,"לידת בנה היה המאורע החשוב בחייה","checked","#ASSIGN:52.0=[gnd=39.0,bt(dir)=13.0] #MZ@ #IE מאורע seems to be related to something (usually important) specific that happans","eyal-07 Jul 2005, eyal-11 Feb 2004, assign-6 Nov 2003",0,"2005-07-07");
INSERT INTO hebrew_synonyms VALUES (275,"אֵרוּעַ","n","07796465","yy","melingo","1","none",NULL,"tg1",NULL,"event",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-11 Feb 2004",90897,"2004-02-11");
INSERT INTO hebrew_synonyms VALUES (276,"אֵרוּעַ","n","00017297","yy","melingo","1","rav-milim","1","tg1",NULL,"event",NULL,"במשחקי כדורגל מתרחשים אירועים אלימים כמעט מדי משחק","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-11 Feb 2004",90897,"2004-02-11");
INSERT INTO hebrew_synonyms VALUES (277,"לַהַט","n","05561864","yy","melingo","2","rav-milim","2","tg1",NULL,"ardor, fervor",NULL,"הוא דיבר בלהט רב","checked","#ASSIGN:45.0=[gnd=39.0,bt(dir)=6.0] #MZ@ #IE","eyal-10 Feb 2004, assign-6 Nov 2003",90898,"2004-02-10");
INSERT INTO hebrew_synonyms VALUES (278,"פַּסְיוֹן","n","10280858","yy","melingo","2","rav-milim","1","tg1",NULL,"Passion",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-10 Feb 2004, assign-6 Nov 2003",90899,"2004-02-10");
INSERT INTO hebrew_synonyms VALUES (279,"אֶזְרָח","n","07157546","n","melingo","1.1","rav-milim","1.1","tg1",NULL,"citizen",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO\r\n#IE gender","eyal-26 Jun 2005, ordan-13 Feb 2004",0,"2005-06-26");
INSERT INTO hebrew_synonyms VALUES (280,"אֶזְרָח","n","07158529","n","melingo","1.2","rav-milim","1.2","tg1",NULL,"civilian",NULL,"למעלית נכנסו שני חיילים ושלושה אזרחים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO\r\n#IE gender","eyal-26 Jun 2005, ordan-13 Feb 2004",0,"2005-06-26");
INSERT INTO hebrew_synonyms VALUES (6435,"אִשּׁוּר","n","04860581","yy",NULL,NULL,"rav-milim","1",NULL,NULL,"certificate, certification",NULL,"סוף סוף קיבלתי אישור על סיום לימודי במכללה","checked","#IE","eyal-10 Feb 2004",90889,"2004-02-10");
INSERT INTO hebrew_synonyms VALUES (282,"אֶזְרָחִי","a","02546684","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"civil",NULL,"מרי אזרחי","checked","#ASSIGN:27.0=[gnd=7.0,flc(dic)=12.0,bt(dir)=8.0] #MZ@\r\n#NO","ordan-07 Jul 2004",90901,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (283,"אֶזְרָחִי","a","02546488","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"civil, civic",NULL,"חובה אזרחית","checked","#ASSIGN:27.0=[gnd=7.0,flc(dic)=12.0,bt(dir)=8.0] #MZ@\r\n#IE refers to the first past of RM\'s definition (1.1)","ordan-07 Jul 2004, assign-6 Nov 2003",90901,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (284,"אֶזְרָחִי","n","02445507","yy","melingo","1","rav-milim","1.3","tg1","((military slang))","civies, civvies",NULL,"זה היה תענוג לפשוט את המדים ולעבור לאזרחי אחרי חודש שלם בבסיס","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-09 Feb 2004",90902,"2004-02-09");
INSERT INTO hebrew_synonyms VALUES (285,"לִיטֶר","n","09794447","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"liter, litre",NULL,"בקיץ צריך לשתות לפחות שני ליטרים מים","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-13 Feb 2004",90903,"2004-02-13");
INSERT INTO hebrew_synonyms VALUES (286,"אֶלֶף","n","09902316","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"thousand",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-14 Feb 2004, assign-6 Nov 2003",90904,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (288,"מֻתָּר","a","01696697","yy","melingo","2","rav-milim","1","tg1",NULL,"permitted, allowable",NULL,"מידה כזו של קירבה מותרת בין חברים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-17 Feb 2004, assign-6 Nov 2003",90905,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (289,"אֶרֶץ","n","06299747","yy","melingo","1","rav-milim","1.1","tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:47.0=[gnd=4.0,gnd=8.0,si=8.0,bt(dir)=6.0,bt(dir)=3.0,bt(crs)=9.0,bt(dir)=6.0,bt(dir)=3.0] #MZ@\r\n#NO","ordan-12 Feb 2004, assign-6 Nov 2003",90906,"2004-02-12");
INSERT INTO hebrew_synonyms VALUES (290,"!אֶרֶץ","n","06074189","u","melingo","1","rav-milim",NULL,"tg1",NULL,"land, country",NULL,NULL,"checked","#ASSIGN:47.0=[gnd=4.0,gnd=8.0,si=8.0,bt(dir)=6.0,bt(dir)=3.0,bt(crs)=9.0,bt(dir)=6.0,bt(dir)=3.0] #MZ@","ordan-12 Feb 2004, assign-6 Nov 2003",0,"2004-02-12");
INSERT INTO hebrew_synonyms VALUES (291,"אֶרֶץ","n","06073126","yy","none",NULL,"rav-milim","1.2","tg1",NULL,"nation, nationality, land, country, a_people",NULL,NULL,"checked","#ASSIGN:53.0=[gnd=4.0,gnd=8.0,si=8.0,bt(dir)=3.0,bt(dir)=8.0,bt(crs)=11.0,bt(dir)=3.0,bt(dir)=8.0] #MZ@\r\n#NO","ordan-12 Feb 2004, assign-6 Nov 2003",90906,"2004-02-12");
INSERT INTO hebrew_synonyms VALUES (292,"אֶרֶץ","n","06753779","yy","melingo","1","rav-milim","1.3","tg1",NULL,"earth, world",NULL,"מדי שנה משלימה הארץ סיבוב סביב השמש","checked","#ASSIGN:33.0=[gnd=2.0E+01,gnd=5.0,si=8.0] #MZ@\r\n#NO","ordan-12 Feb 2004, assign-6 Nov 2003",90906,"2004-02-12");
INSERT INTO hebrew_synonyms VALUES (293,"!אֶתְמוֹל","r","00504454","u","melingo","1","rav-milim",NULL,"tg1",NULL,"yesterday",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","ordan-14 Feb 2004, assign-6 Nov 2003",0,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (294,"!אֶתְמוֹל","r","00504351","u","melingo","1","rav-milim",NULL,"tg1",NULL,"yesterday",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","ordan-14 Feb 2004, assign-6 Nov 2003",0,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (6424,"עַרְבוּת","n","09614018","yy","melingo","1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO another form of nikkud to this word","ordan-05 Feb 2004",90907,"2004-02-05");
INSERT INTO hebrew_synonyms VALUES (297,"אַחֲרָיוּת","n","05012271","yy","melingo","1","rav-milim","1.3","tg1",NULL,"warranty",NULL,"הבעיה ברכישת מוצרים מחו''ל היא שלרוב אין עליהם אחריות אלא בארץ בה נרכשו ","checked","#ASSIGN:224.0=[gnd=39.0,gnd=13.0,si=16.0,bt(dir)=13.0,bt(dir)=39.0,bt(crs)=52.0,bt(dir)=13.0,bt(dir)=39.0] #MZ@\r\n#NO","ordan-05 Feb 2004",90908,"2004-02-05");
INSERT INTO hebrew_synonyms VALUES (298,"!אַחֲרָיוּת","n","10411732","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"responsibility, warranty, guarantee",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#NO","ordan-05 Feb 2004, assign-6 Nov 2003",0,"2004-02-05");
INSERT INTO hebrew_synonyms VALUES (299,"אַחֲרָיוּת","n","03679828","yy","melingo","1","rav-milim","1.1","tg1",NULL,"responsibility",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-03 Feb 2004",90908,"2004-02-03");
INSERT INTO hebrew_synonyms VALUES (300,"!אַחֲרָיוּת","n","00731811","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"responsibility, warranty, guarantee",NULL,NULL,"checked","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@\r\n#NO doens\'t accord with the senses appearing in RM, and rightly so. ","ordan-05 Feb 2004, assign-6 Nov 2003",0,"2004-02-05");
INSERT INTO hebrew_synonyms VALUES (301,"לְבַסּוֹף","r","00063279","yy","melingo","1.1","rav-milim","1.2a","tg1",NULL,"finally",NULL,"לבסוף, אני רוצה לדבר על ערכי המשפחה ","checked","#ASSIGN:41.0=[gnd=2.0E+01,bt(dir)=21.0] #MZ@ #IE the word ''levasof'' appears after the second definition of the word ''basof'' in RM. It does not have its own definition.","eyal-09 May 2004",90909,"2004-05-09");
INSERT INTO hebrew_synonyms VALUES (302,"לָאַחֲרוֹנָה","r","00063169","yy","melingo","1","rav-milim","1","tg1",NULL,"last",NULL,"ראיתי אותו לאחרונה בלונדון","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","shuly-14 Jan 2004, assign-6 Nov 2003",90910,"2004-01-14");
INSERT INTO hebrew_synonyms VALUES (303,"!אַחֵר","a","02386694","undef","melingo","1","rav-milim",NULL,"tg1",NULL,"different, varying",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO i would have considered nivdal or shone, maybe also acher. recheck. ","ordan-21 Jan 2004, assign-6 Nov 2003",0,"2004-01-21");
INSERT INTO hebrew_synonyms VALUES (304,"אַחֵר","a","01992026","yy","melingo","2","rav-milim","1","tg1",NULL,"another, different",NULL,"זה נושא אחר לגמרי","checked","#ASSIGN:50=[gnd=13.0,gnd=8.0,si=14.0,dfl=15.0] #MZ@ #IE","shuly-13 Jan 2004, assign-6 Nov 2003",90911,"2004-01-13");
INSERT INTO hebrew_synonyms VALUES (305,"אַיִן","n","09893278","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:108.0=[gnd=39.0,gnd=2.0E+01,si=49.0] #MZ@\r\n#NO","ordan-14 Feb 2004, assign-6 Nov 2003",90912,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (306,"!אַיִן","r","00023400","y","melingo","1","rav-milim",NULL,"tg1","((flowery))","none",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (307,"אַלָּה","n","02531456","yy","melingo","1","rav-milim","1.1","tg1",NULL,"cudgel",NULL,"השוטר הסתובב בין המפגינים חמוש באלה","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-31 Jan 2004, assign-6 Nov 2003",90913,"2004-01-31");
INSERT INTO hebrew_synonyms VALUES (308,"!אַלּוּף","n","07388553","y","melingo","1","rav-milim",NULL,"tg1",NULL,"major-general",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (309,"!אַלּוּף","n","07522531","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"champion, record-holder",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO in hebrew it\'s si\'an","ordan-01 Feb 2004, assign-6 Nov 2003",0,"2004-02-01");
INSERT INTO hebrew_synonyms VALUES (6412,"GAP!","n","00489929","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked",NULL,"ordan-02 Feb 2004",90808,"2004-02-02");
INSERT INTO hebrew_synonyms VALUES (311,"אַרְגּוֹן","n","10479212","yy","melingo","1","rav-milim","1.1","tg1",NULL,"argon",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-05 Feb 2004, assign-6 Nov 2003",90914,"2004-02-05");
INSERT INTO hebrew_synonyms VALUES (312,"אָב","n","07258194","yy","melingo","1","rav-milim","1","tg1",NULL,"father",NULL,"האב הוריש את רכושו לשלושת בניו","checked","#ASSIGN:51.0=[gnd=39.0,bt(dir)=12.0] #MZ@\r\n#SW: changed teqs from male_parent to father; added example\r\n\r\n#NO: changed bidict","shuly-08 Jan 2004, shuly-06 Jan 2004, assign-6 Nov 2003",90915,"2004-01-08");
INSERT INTO hebrew_synonyms VALUES (313,"אָב","n","07272604","yy","melingo","3","rav-milim","1.3","tg1",NULL,"forefather",NULL,"אבי האומה","checked","#ASSIGN:32.0=[gnd=2.0E+01,bt(dir)=12.0] #MZ@ # IE","shuly-08 Jan 2004",90915,"2004-01-08");
INSERT INTO hebrew_synonyms VALUES (314,"אָב_קַדְמוֹן","n","07075378","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"ancestor, antecedent, ascendent",NULL,"אברהם אבינו נחשב האב הקדמון של העם היהודי","revised","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO i gave this example because Abraham is a point of filial reference for the Jewish people\r\n\r\n#NO I changed it from Av to Av Kadmon in order to distinguish it from n#07272604 which is extremely close. This is confirmed by Rav Milim as well. ","ordan-11 Mar 2004, shuly-10 Jan 2004",90916,"2004-03-11");
INSERT INTO hebrew_synonyms VALUES (316,"אָבֵל","n","07421559","yy","melingo","1","rav-milim","1","tg1",NULL,"mourner",NULL,"הנשיא בא לבקר את המשפחה האבלה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-27 Jan 2004, assign-6 Nov 2003",90917,"2004-01-27");
INSERT INTO hebrew_synonyms VALUES (6422,"אָסַר","v","01699803","yy",NULL,NULL,"rav-milim","1",NULL,NULL,"imprison",NULL,"אסרו את הפושע לתקופה ארוכה מאד בבית הסוהר","checked","#IE","eyal-05 Feb 2004",90918,"2004-02-05");
INSERT INTO hebrew_synonyms VALUES (321,"הָאָדָם","n","01967203","yy","melingo","1","rav-milim","2b","tg1",NULL,"man, homo, human_being",NULL,"הכלב הינו חברו הטוב ביותר של האדם","checked","#ASSIGN:5.0E+01=[gnd=4.0,gnd=39.0,si=7.0] #MZ@ #IE","eyal-04 Feb 2004, assign-6 Nov 2003",90919,"2004-02-04");
INSERT INTO hebrew_synonyms VALUES (6409,"אַכְסַנְיָה","n","02835429","yy",NULL,NULL,"rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-31 Jan 2004",90920,"2004-01-31");
INSERT INTO hebrew_synonyms VALUES (323,"אָדָם","n","00004123","yy","melingo","2","rav-milim","1","tg1",NULL,"person",NULL,"זה היה יותר מדי עבודה לאדם אחד","checked","#ASSIGN:202.0=[gnd=39.0,gnd=39.0,si=98.0,bt(dir)=13.0,bt(dir)=13.0] #MZ@ #IE","eyal-04 Feb 2004",90921,"2004-02-04");
INSERT INTO hebrew_synonyms VALUES (324,"נַעֲרָץ","a","01401729","yy","melingo","1","rav-milim","1","tg1",NULL,"admired",NULL,"השחקן הנערץ זכה למחיאות כפיים חזקות במיוחד","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-26 Jan 2004",90922,"2004-01-26");
INSERT INTO hebrew_synonyms VALUES (6407,"הַבְחָנָה","n","04434578","yy","none",NULL,"rav-milim","1.3",NULL,NULL,"discrimination",NULL,NULL,"checked","#NO almost congurent, but recheck (not to be confused with ''distinction'', which is fairly poor in WN)","ordan-29 Jan 2004",90923,"2004-01-29");
INSERT INTO hebrew_synonyms VALUES (6408,"מֶלֶךְ-הַחַיּוֹת","n","01637880","yy",NULL,NULL,"rav-milim",NULL,NULL,NULL,NULL,NULL,NULL,"revised","#NO","eyal-30 Mar 2004, ordan-31 Jan 2004",90924,"2004-03-30");
INSERT INTO hebrew_synonyms VALUES (330,"אָז","r","00114832","yy","melingo","2","rav-milim","2","tg1",NULL,"then, followed_by",NULL,"קודם בא הברק, ואז הרעם","checked","#ASSIGN:31.0=[gnd=13.0,bt(dir)=18.0] #MZ@ #IE","eyal-28 Jan 2004, assign-6 Nov 2003",90925,"2004-01-28");
INSERT INTO hebrew_synonyms VALUES (331,"אֲחָאִים","n","07574321","yy","melingo","1","rav-milim","1.1","tg1",NULL,"siblings",NULL,NULL,"revised","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-21 Mar 2004, shuly-13 Jan 2004",90926,"2004-03-21");
INSERT INTO hebrew_synonyms VALUES (333,"אָח","n","07188374","yy","melingo","3","rav-milim","3","tg1",NULL,"compatriot, countryman",NULL,"עלינו לטפח את קשרינו עם אחינו היהודים שנותרו בגולה","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","shuly-13 Jan 2004, assign-6 Nov 2003",90927,"2004-01-13");
INSERT INTO hebrew_synonyms VALUES (334,"אָח","n","07128451","yy","melingo","4","sapir","6","tg1",NULL,"close_friend, buddy, pal",NULL,"אנחנו אחים עוד מהצבא","checked","#ASSIGN:2.0E+02=[gnd=39.0,gnd=39.0,si=98.0,bt(dir)=12.0,bt(dir)=12.0] #MZ@ #IE","eyal-04 Feb 2004, assign-6 Nov 2003",90927,"2004-02-04");
INSERT INTO hebrew_synonyms VALUES (335,"אָח","n","07127750","yy","melingo","5","rav-milim",NULL,"tg1","((Christianity))","Brother",NULL,"האח אשר קיבל את פנינו במנזר השתקנים היה חמור סבר במיוחד","checked","#ASSIGN:88.0=[gnd=39.0,flc(dic)=49.0] #MZ@ #IE","shuly-13 Jan 2004, assign-6 Nov 2003",90927,"2004-01-13");
INSERT INTO hebrew_synonyms VALUES (6364,"אָב","n","07276210","yy",NULL,NULL,"rav-milim","1.4",NULL,NULL,"father, founder, beginner",NULL,"איינשטיין הוא אבי תורת היחסות","checked","#NO the English sysnonyms are not really synonyms...","shuly-08 Jan 2004",90915,"2004-01-08");
INSERT INTO hebrew_synonyms VALUES (337,"מֻחְזָק","a","02879008","yy","melingo","1","rav-milim","1","tg1",NULL,"held",NULL,"השטח היה מוחזק בידי האויב","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-04 Feb 2004, assign-6 Nov 2003",90928,"2004-02-04");
INSERT INTO hebrew_synonyms VALUES (338,"אָחוּז","n","09952143","yy","melingo","1","rav-milim","1","tg1",NULL,"percentage",NULL,"מועמד מפלגת הירוקים קיבל 20 אחוז מהקולות","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-26 Jan 2004, assign-6 Nov 2003",90929,"2004-01-26");
INSERT INTO hebrew_synonyms VALUES (340,"אָכֵן","r","00037028","yy","melingo","1","rav-milim","1","tg1",NULL,"indeed, surely, truly",NULL,"אמרו לי שהמכונית תתקלקל, והיא אכן התקלקלה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-28 Jan 2004, assign-6 Nov 2003",90930,"2004-01-28");
INSERT INTO hebrew_synonyms VALUES (341,"!אָכֵן","r","00036883","y","melingo","1","rav-milim",NULL,"tg1",NULL,"indeed, surely, truly",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6627,"GAP!","v","00511577","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#NO Hebrew does not diffrentiate between \'request\' v#00510998 and this (according to collins, nor does English).","ordan-18 Apr 2004",90931,"2004-04-18");
INSERT INTO hebrew_synonyms VALUES (343,"אָלֶף","n","05120286","yy","melingo","1","rav-milim","1","tg1",NULL,"Aleph",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-22 Jan 2004, assign-6 Nov 2003",90932,"2004-01-22");
INSERT INTO hebrew_synonyms VALUES (6919,"מְאֵרָה","n","05331503","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-07 Jul 2004",90933,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (346,"אָמַן","v","01731610","yw","melingo","1","rav-milim","1.1","tg1","((biblical))","nurture, bring_up",NULL,NULL,"checked","#ASSIGN:50=[gnd=13.0,gnd=5.0,si=1.0E+01,dfl=22.0] #MZ@ #IE","eyal-17 Mar 2004, eyal-17 Feb 2004",90934,"2004-03-17");
INSERT INTO hebrew_synonyms VALUES (347,"אָמָּן","n","07085533","n","melingo","1","sapir","1","tg1",NULL,"artist",NULL,NULL,"checked","#ASSIGN:78.0=[gnd=39.0,bt(dir)=39.0] #MZ@ #IE gender","eyal-23 Jun 2005, eyal-27 Jan 2004, assign-6 Nov 2003",0,"2005-06-23");
INSERT INTO hebrew_synonyms VALUES (348,"אָמָּן","n","06947056","n","melingo","2","rav-milim","2","tg1",NULL,"expert",NULL,"הוא ממש אומן בבישולים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE\r\n#IE gender","eyal-23 Jun 2005, eyal-27 Jan 2004, assign-6 Nov 2003",0,"2005-06-23");
INSERT INTO hebrew_synonyms VALUES (349,"אָמוּר","n","06815749","yy","melingo","1","rav-milim",NULL,"tg1",NULL,"Amur",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-21 Jan 2004, assign-6 Nov 2003",90936,"2004-01-21");
INSERT INTO hebrew_synonyms VALUES (6421,"שָׁבוּי","n","07500774","nn",NULL,NULL,"rav-milim","1",NULL,NULL,"prisoner, captive",NULL,"בזמן המלחמה נלקחו הרבה שבויים","checked","#IE gender","eyal-28 Feb 2005, eyal-04 Feb 2004",0,"2005-02-28");
INSERT INTO hebrew_synonyms VALUES (351,"אָסַר","v","00879090","yy","melingo","2","rav-milim","2","tg1",NULL,"tie_up, truss",NULL,"הוא אסר את השבויים באזיקים","checked","#ASSIGN:57.0=[gnd=2.0E+01,gnd=13.0,si=24.0] #MZ@ #IE","eyal-04 Feb 2004, assign-6 Nov 2003",90918,"2004-02-04");
INSERT INTO hebrew_synonyms VALUES (352,"אָסַר","v","00540739","yy","melingo","1","sapir","1","tg1",NULL,"forbid, prohibit",NULL,"אני אוסר עליך להתקשר אלי מאוחר בלילה","checked","#ASSIGN:108.0=[gnd=2.0E+01,gnd=39.0,si=49.0] #MZ@ #IE","eyal-04 Feb 2004, assign-6 Nov 2003",90918,"2004-02-04");
INSERT INTO hebrew_synonyms VALUES (353,"סִגְנוֹן","n","03856995","yy","melingo","1","rav-milim","1","tg1",NULL,"manner, mode, style",NULL,"סגנון חיים","checked","#ASSIGN:65.0=[gnd=8.0,bt(dir)=1.0E+01,bt(dir)=6.0,bt(dir)=3.0,bt(crs)=38.0] #MZ@ #IE","eyal-16 Feb 2004, assign-6 Nov 2003",90938,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (354,"!אֹפֶן","n","03858557","yy","melingo","1","rav-milim","1","tg1",NULL,"wise",NULL,NULL,"checked","#ASSIGN:67.0=[gnd=2.0E+01,bt(dir)=47.0] #MZ@ #IE","eyal-26 Jan 2005, eyal-16 Feb 2004, assign-6 Nov 2003",0,"2005-01-26");
INSERT INTO hebrew_synonyms VALUES (355,"!אוֹפַן","n","06842790","nn","melingo","2","rav-milim",NULL,"tg1","((theology))","Ophan, angel",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-13 Jan 2005, assign-6 Nov 2003",0,"2005-01-13");
INSERT INTO hebrew_synonyms VALUES (356,"אוֹצֵר","n","07196812","n","melingo","1","rav-milim","1","tg1",NULL,"curator",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ \r\n#IE gender","eyal-26 Jun 2005, eyal-12 Feb 2004, assign-6 Nov 2003",0,"2005-06-26");
INSERT INTO hebrew_synonyms VALUES (357,"מַטְמוֹן","n","09625689","yy","melingo","2","rav-milim","1","tg1",NULL,"hoard",NULL,"הפירטים ציירו מפה המתארת את מיקום המטמון הקבור במערה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-11 Feb 2004, assign-6 Nov 2003",90941,"2004-02-11");
INSERT INTO hebrew_synonyms VALUES (358,"דַּרְלִינג","n","06819534","yy","melingo","3","none",NULL,"tg1",NULL,"Darling",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-11 Feb 2004, assign-6 Nov 2003",90942,"2004-02-11");
INSERT INTO hebrew_synonyms VALUES (359,"יַקִּיר","n","07201633","yy",NULL,NULL,"rav-milim","1.1","tg1",NULL,"darling",NULL,"העבירי לי את המלח, יקירתי","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-21 Mar 2004, eyal-11 Feb 2004, assign-6 Nov 2003",90943,"2004-03-21");
INSERT INTO hebrew_synonyms VALUES (360,"אוֹצָר","n","04945821","nn","melingo","4","rav-milim","4","tg1",NULL,"anthology",NULL,"אוצר המעשיות היהודיות","revised","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE\r\n#NO","ordan-28 Jul 2004, eyal-11 Feb 2004, assign-6 Nov 2003",90944,"2004-07-28");
INSERT INTO hebrew_synonyms VALUES (361,"שֶׁמֶשׁ","n","07820384","yy","melingo","1","rav-milim","2","tg1",NULL,"sunlight, sunshine, sun",NULL,"התריסים היו דהויים מהשמש החזקה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-15 Feb 2004, assign-6 Nov 2003",90945,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (6460,"מְבוֹאָה","n","02191831","yy","melingo","1","rav-milim","1.1",NULL,NULL,"lobby, entrance_hall",NULL,"אורחי המלך נאספו במבואה ורק לאחר מכן פסעו אל תוך הארמון","checked","#IE","eyal-16 Mar 2004, eyal-15 Feb 2004",90946,"2004-03-16");
INSERT INTO hebrew_synonyms VALUES (6922,"צִיּוּן","n","05399540","yy","none",NULL,"rav-milim","1.3",NULL,NULL,"indication, indicating",NULL,"המדריך פתח בציון האתרים בהם נבקר במהלך הטיול","checked","#IN refers to the third part of the definition in RM","ordan-07 Jul 2004",90947,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (364,"אוֹת","n","05090749","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"sign",NULL,"אותות הלחץ נכרו על פניו","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IN","ordan-07 Jul 2004, assign-6 Nov 2003",90948,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (365,"!אוֹת","n","05435037","y","melingo","2","rav-milim",NULL,"tg1",NULL,"omen, sign, indication",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (366,"אוֹת","n","05115901","yy","melingo","1","sapir","2","tg1",NULL,"letter",NULL,"בשנתו הראשונה בבית הספר הילד למד בכל יום אות אחת מהאלפבית","checked","#ASSIGN:38.0=[gnd=1.0E+01,bt(dir)=1.0E+01,bt(dir)=4.0,bt(crs)=14.0] #MZ@ #IE","eyal-15 Feb 2004, assign-6 Nov 2003",90948,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (6517,"מְקֻלָּל","a","00631927","yy","melingo","1","rav-milim","1.2",NULL,NULL,"cursed",NULL,NULL,"checked","#IE","eyal-17 Mar 2004",90949,"2004-03-17");
INSERT INTO hebrew_synonyms VALUES (6518,"אָרוּר","a","00631927","yy","melingo","1","rav-milim","1.2",NULL,NULL,"cursed",NULL,"הטיפשות הארורה שלך הביאה אותנו למצב הזה","checked","#IE","eyal-17 Mar 2004",90950,"2004-03-17");
INSERT INTO hebrew_synonyms VALUES (368,"בְּדִיּוּק","r","00363408","yy","melingo","1.1","rav-milim","1.5","tg1",NULL,"exactly, precisely",NULL,"אני מאוד מרוצה, הכל יצא בדיוק כמו שתכננתי","checked","#ASSIGN:91.0=[gnd=13.0,gnd=13.0,si=33.0,bt(dir)=16.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-15 Apr 2004, assign-6 Nov 2003",90951,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (6619,"בִּמְדֻיָּק","r","00363032","yy","none",NULL,"rav-milim","1.1",NULL,NULL,"precisely, incisively, exactly",NULL,"היא תמיד מתבטאת במדויק, ולכן לא נגרמות לאחר מכן אי הבנות","checked","#NO the RM definition is nested in מְדֻיָּק","ordan-15 Apr 2004",90952,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (370,"בְּדִיּוּק","r","00154389","yy","melingo","1.1","rav-milim","1.4","tg1",NULL,"exactly, precisely",NULL,"הוא עשה בדיוק את מה שהיא אמרה לו לעשות","checked","#ASSIGN:91.0=[gnd=13.0,gnd=13.0,si=33.0,bt(dir)=16.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-15 Apr 2004, assign-6 Nov 2003",90951,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (371,"בְּדִיקָה","n","00419850","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"examination",NULL,"לאחר בדיקה של השטר הגיע המוכר למסקנה שמדובר בכסף מזויף ","checked","#ASSIGN:62.0=[gnd=8.0,bt(dir)=8.0,bt(dir)=19.0,bt(crs)=27.0] #MZ@\r\n#NO","ordan-07 Apr 2004, assign-6 Nov 2003",90953,"2004-04-07");
INSERT INTO hebrew_synonyms VALUES (372,"בְּחִינָה","n","04707108","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"point_of_view, viewpoint, stand, standpoint",NULL,NULL,"checked","#ASSIGN:58.0=[gnd=2.0E+01,spc=38.0] #MZ@\r\n#NO","ordan-05 May 2004, assign-6 Nov 2003",90954,"2004-05-05");
INSERT INTO hebrew_synonyms VALUES (373,"!בְּחִירָה","n","04463475","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"choice",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","ordan-28 Mar 2004, assign-6 Nov 2003",0,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (374,"!בְּחִירָה","n","04462889","y","melingo","1","rav-milim",NULL,"tg1",NULL,"choice",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6550,"שָׁלוֹם","n","10065207","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"peace",NULL,"לאחר שנות מלחמה ארוכות, שורר השלום באזור הבלקן","checked","#NO","ordan-28 Mar 2004",90955,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (376,"בְּחִירוֹת","n","00118873","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"election, elections",NULL,"מתוך 45 מפלגות שהעמידו עצמן לבחירות, נבחרו רק 20","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","ordan-28 Mar 2004, assign-6 Nov 2003",90956,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (377,"!בְּחִירָה","n","00118200","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"election",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO there\'s a distinction here between this and its hypernym {choice, selection, pick}, here is selecting SOMEONE (the example given is probably wrong)","ordan-05 May 2004, assign-6 Nov 2003",0,"2004-05-05");
INSERT INTO hebrew_synonyms VALUES (378,"!בְּמִקְרֶה","r","00160847","yy","melingo","1.1","none","1.3","tg1",NULL,"in_case",NULL,"במקרה שריפה יש להתקשר למכבי האש","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-21 Apr 2004",0,"2004-04-21");
INSERT INTO hebrew_synonyms VALUES (382,"!בְּעֶצֶם","r","00145000","y","melingo","1","rav-milim",NULL,"tg1",NULL,"in_fact, as_a_matter_of_fact, actually",NULL,NULL,"assigned","#ASSIGN:98.0=[gnd=39.0,gnd=39.0,si=2.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (383,"בְּעָיָה","n","10340761","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"problem",NULL,"מדובר בבעיות אורבניות, כמו צפיפות תנועה וזיהום אוויר","checked","#ASSIGN:47.0=[gnd=13.0,bt(dir)=13.0,bt(dir)=4.0,bt(crs)=17.0] #MZ@\r\n#NO","ordan-09 Apr 2004",90957,"2004-04-09");
INSERT INTO hebrew_synonyms VALUES (385,"!בְּעָיָה","n","04395081","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"problem",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","ordan-21 Jul 2004, assign-6 Nov 2003",0,"2004-07-21");
INSERT INTO hebrew_synonyms VALUES (386,"!בְּעוֹד","r","00117172","y","melingo","1","rav-milim",NULL,"tg1",NULL,"while, while_at_the_same_time, concurrently",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (387,"בְּרִיאוּת","n","10366424","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"health",NULL,"בריאות טובה תלויה בתזונה ובפעילות גופנית אך גם בתורשה","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-15 Apr 2004, assign-6 Nov 2003",90958,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (388,"בְּרִית","n","05074858","yy","melingo",">1.1","rav-milim","1.1","tg1",NULL,"treaty, pact, accord",NULL,NULL,"checked","#ASSIGN:78.0=[gnd=39.0,bt(dir)=39.0] #MZ@\r\n#NO","ordan-12 Apr 2004, assign-6 Nov 2003",90959,"2004-04-12");
INSERT INTO hebrew_synonyms VALUES (389,"!בְּרִית","n","05073898","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"treaty, alliance, covenant",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO almost identical to n#05074858 and they share the same hypernyms (x2). This one however fits better to אמנה","ordan-12 Apr 2004, assign-6 Nov 2003",0,"2004-04-12");
INSERT INTO hebrew_synonyms VALUES (390,"בְּרִית","n","04898850","yy","melingo","2.1","none",NULL,"tg1",NULL,"covenant",NULL,"ברית בין הבתרים","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO In English ''covenant'' has the specific biblical sense as a separate sense. Although ברית doesn\'t appear in RM (nor in Even Shushan) under this specific sense, I allocated ברית to this synset.","ordan-12 Apr 2004, assign-6 Nov 2003",90959,"2004-04-12");
INSERT INTO hebrew_synonyms VALUES (393,"!בִּטֵּל","v","01689077","y","melingo","2","rav-milim",NULL,"tg1",NULL,"neutralize, abrogate",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (394,"!בִּטּוּל","n","05384738","y","melingo","1","rav-milim",NULL,"tg1",NULL,"cancellation",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (395,"בִּטּוּל","n","00151154","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"cancellation",NULL,"הבוקר בוטל ראיון העבודה שנקבע לי למחר","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-03 Apr 2004, assign-6 Nov 2003",90960,"2004-04-03");
INSERT INTO hebrew_synonyms VALUES (396,"בִּטּוּל","n","00148356","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"abolition",NULL,"במאה ה-19 הוחלט על ביטול העבדות באמריקה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-03 Apr 2004, assign-6 Nov 2003",90960,"2004-04-03");
INSERT INTO hebrew_synonyms VALUES (397,"בִּכְלָל","r","00054968","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"at_all, in_the_least",NULL,"זה בכלל מעניין אותך, או שאתה מקשיב מתוך נימוס?","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-06 May 2004, assign-6 Nov 2003",90961,"2004-05-06");
INSERT INTO hebrew_synonyms VALUES (398,"בִּכְלָל","r","00039873","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-19 Apr 2004",90961,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (399,"בִּלְבַד","r","00007655","yy","melingo","1.1","rav-milim","1.3","tg1",NULL,"only, solely",NULL,"בזמנו תרגמתי בשביל הרבה חברות, היום אני עובד עבור חברה אחת בלבד","checked","#ASSIGN:59.0=[gnd=6.0,gnd=39.0,si=14.0] #MZ@\r\n#NO","ordan-21 Feb 2005, ordan-19 Apr 2004, assign-6 Nov 2003",90962,"2005-02-21");
INSERT INTO hebrew_synonyms VALUES (400,"בִּמְיֻחָד","r","00081536","yy","none",NULL,"none",NULL,"tg1",NULL,"mainly, in_particular, specially",NULL,"נסיבות מותו היו טרגיות במיוחד","checked","#ASSIGN:36.0=[gnd=2.0E+01,bt(dir)=16.0] #MZ@\r\n#NO","ordan-19 Apr 2004, assign-6 Nov 2003",90963,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (401,"בִּמְיֻחָד","r","00245145","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"particularly, in_particular",NULL,"אני מאוד אוהב את באך, בעיקר את הקנטאטות שלו","checked","#ASSIGN:55.0=[gnd=39.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-19 Apr 2004, assign-6 Nov 2003",90963,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (6645,"בְּעִקָּר","r","00071501","yy","none",NULL,"none",NULL,NULL,NULL,"chiefly, principally, primarily, mainly",NULL,"את המקום מילאו בעיקר בני נוער","checked","#NO","ordan-19 Apr 2004",90964,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (6646,"עַד-מְאֹד","r","00057204","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"a_lot, a_good_deal, a_great_deal, much, very_much",NULL,NULL,"checked","#NO","ordan-19 Apr 2004",90965,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (6651,"בִּגְנֵבָה","r","00189588","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"stealthily",NULL,"הילד הציץ בגנבה בטופס המבחן של חברו","checked","#NO","ordan-19 Apr 2004",90966,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (405,"!בִּנְיָן","n","00715519","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"building",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=1.0E+01,bt(dir)=6.0,bt(dir)=11.0,bt(crs)=17.0] #MZ@\r\n#NO denotes the action not the trade","ordan-04 Apr 2004, assign-6 Nov 2003",0,"2004-04-04");
INSERT INTO hebrew_synonyms VALUES (406,"בִּנְיָן","n","00585093","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:46.0=[gnd=1.0E+01,bt(dir)=6.0,bt(dir)=12.0,bt(crs)=18.0] #MZ@\r\n#NO","ordan-04 Apr 2004, assign-6 Nov 2003",90967,"2004-04-04");
INSERT INTO hebrew_synonyms VALUES (407,"!בִּנְיָן","n","09941551","nn","melingo","2","rav-milim",NULL,"tg1","((grammar))","conjugation",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=1.0E+01,flc(dic)=16.0] #MZ@\r\n#NO","ordan-15 Aug 2004, assign-6 Nov 2003",0,"2004-08-15");
INSERT INTO hebrew_synonyms VALUES (408,"!בִּנְיָן","n","05996676","nn","melingo","2","rav-milim",NULL,"tg1","((grammar))","conjugation",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=1.0E+01,flc(dic)=16.0] #MZ@","ordan-15 Aug 2004, assign-6 Nov 2003",0,"2004-08-15");
INSERT INTO hebrew_synonyms VALUES (409,"בִּנְיָן","n","05996567","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"conjugation",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=1.0E+01,flc(dic)=16.0] #MZ@\r\n#NO","ordan-08 Apr 2004, assign-6 Nov 2003",90967,"2004-04-08");
INSERT INTO hebrew_synonyms VALUES (410,"!בִּצֵּעַ","v","00338284","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"implement, carry_out",NULL,NULL,"checked","#ASSIGN:50=[gnd=13.0,gnd=8.0,si=14.0,dfl=15.0] #MZ@\r\n#NO not necessarily ''to a conclustion'' (cf. definition)","ordan-06 May 2004",0,"2004-05-06");
INSERT INTO hebrew_synonyms VALUES (6557,"הִתְבַּדְּחוּת","n","00331800","yy","none",NULL,"rav-milim","1.1",NULL,NULL,"jest, joke, jocularity",NULL,"ההתבדחויות החוזרות ונשנות מנעו מאיתנו לנהל שיחה רצינית","checked","#NO","ordan-28 Mar 2004",90968,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (412,"בִּצּוּעַ","n","00061811","yy","melingo","‚PD‚Q","rav-milim","‚PD‚S","tg1",NULL,"performance",NULL,"עכשיו כשהוא מתאמן בנגינה שש שעות ביום, הביצוע שלו השתפר פלאים","checked","#ASSIGN:98.0=[gnd=1.0E+01,gnd=2.0E+01,si=2.0E+01,bt(dir)=8.0,bt(dir)=8.0,bt(crs)=16.0,bt(dir)=8.0,bt(dir)=8.0] #MZ@\r\n#NO\r\n","ordan-28 Mar 2004",90969,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (6558,"הֲלָצָה","n","05077026","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-28 Mar 2004",90970,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (6554,"חוּץ","a","00986718","yy","none",NULL,"none",NULL,NULL,NULL,"external, international, outside",NULL,"בתקופת המלחמה קיבלה רואנדה סיוע חוץ ממדינות רבות","checked","#NO","ordan-28 Mar 2004",90971,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (6555,"בְּגִידָה","n","00500041","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"treason, high_treason",NULL,"הדעה הרווחת היתה שהסגרת סודות האטום הלאומיים היתה מעשה של בגידה","checked","#NO","ordan-28 Mar 2004",90972,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (6553,"בֵּין-לְאֻמִּי","a","01512129","yy",NULL,NULL,"rav-milim",NULL,NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-28 Mar 2004",90973,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (417,"!בִּצּוּעַ","n","00061322","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"implementation, execution, carrying_out",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IN","ordan-21 Jul 2004, assign-6 Nov 2003",0,"2004-07-21");
INSERT INTO hebrew_synonyms VALUES (419,"בִּקֵּר","v","00560756","yy","melingo","2.1","rav-milim","2.1","tg2",NULL,"criticize",NULL,"בביקורו בבית החולים, ביקר שר הבריאות בחומרה את מצב התברואה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-20 May 2004, assign-6 Nov 2003",90974,"2004-05-20");
INSERT INTO hebrew_synonyms VALUES (420,"!בִּקֵּשׁ","v","00726812","y","melingo","1","rav-milim",NULL,"tg1",NULL,"ask, request",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (421,"!בִּקֵּשׁ","v","00511577","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"ask, request",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO Hebrew does not diffrentiate between \'request\' v#00510998 and this (according to collins, nor does English).","ordan-18 Apr 2004, assign-6 Nov 2003",0,"2004-04-18");
INSERT INTO hebrew_synonyms VALUES (422,"בִּקֵּשׁ","v","00510998","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"request",NULL,"בקשתי מאבי שיעזור לי בשיעורי הבית","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-18 Apr 2004, assign-6 Nov 2003",90975,"2004-04-18");
INSERT INTO hebrew_synonyms VALUES (423,"!בֵּינְלְאֻמִּי","a","00986718","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"international",NULL,NULL,"checked","#ASSIGN:41.0=[gnd=2.0E+01,bt(dir)=21.0] #MZ@\r\n#NO","ordan-28 Mar 2004, assign-6 Nov 2003",0,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (424,"בֵּינְלְאֻמִּי","a","01512129","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"international",NULL,"לא רק שספריו נמכרו היטב בארצו, היתה להם תהודה בינלאומית","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-28 Mar 2004, assign-6 Nov 2003",90976,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (425,"!בֵּינְתַיִם","r","00062821","nn","none",NULL,"none",NULL,"tg1",NULL,"in_the_meantime, meanwhile",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO TE could be באותו זמן ב","ordan-19 Apr 2004",0,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (426,"בֵּינְתַיִם","r","00062583","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"meanwhile, meantime, in_the_meantime",NULL,"בינתיים, עד שאתפנה, אתה יכול לקרוא עיתון","checked","#ASSIGN:156.0=[gnd=39.0,gnd=2.0E+01,si=49.0,bt(dir)=24.0,bt(dir)=24.0] #MZ@\r\n#NO","ordan-19 Apr 2004",90977,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (427,"בֵּינְתַיִם","r","00052557","yy","none",NULL,"rav-milim","1.2","tg1",NULL,"for_the_moment, for_the_time_being",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-19 Apr 2004",90977,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (6641,"עַכְשָׁו","r","00047793","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"now",NULL,"התפוזים מאוד בזול עכשיו","checked","#NO","ordan-19 Apr 2004",90978,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (6642,"לְעֵת-עַתָּה","r","00052557","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,"לעת עתה נחנה פה, אחר כך נמשיך בדרך","checked","#NO","ordan-19 Apr 2004",90979,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (6577,"מַדֵּי-בֵּית","n","02668605","yy","none",NULL,"none",NULL,NULL,NULL,NULL,NULL,NULL,"checked","#NO RM calls it בגדי בית, they are wrong (i think)","ordan-08 Apr 2004",90980,"2004-04-08");
INSERT INTO hebrew_synonyms VALUES (431,"בֵּן","n","07592357","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"son",NULL,"יצחק הוא בנו של אברהם","checked","#ASSIGN:147.0=[gnd=39.0,bt(dir)=43.0,bt(dir)=11.0,bt(crs)=54.0] #MZ@\r\n#NO","ordan-13 Apr 2004, assign-6 Nov 2003",90981,"2004-04-13");
INSERT INTO hebrew_synonyms VALUES (432,"הַבֵּן","n","06889957","yy","none",NULL,"rav-milim","1.7.2","tg1",NULL,"Son, Word, Logos",NULL,"בשם האב, הבן ורוח הקודש","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-13 Apr 2004, assign-6 Nov 2003",90982,"2004-04-13");
INSERT INTO hebrew_synonyms VALUES (6598,"נוֹקֵד","n","07569027","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-13 Apr 2004",90983,"2004-04-13");
INSERT INTO hebrew_synonyms VALUES (434,"!בֵּן","n","06949518","y","melingo","4","rav-milim",NULL,"tg1",NULL,"native",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (435,"בֶּאֱמֶת","r","00037263","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"in_truth, really, truly",NULL,"זה באמת אחד הספרים היפים שקראתי","checked","#ASSIGN:54.0=[gnd=1.0E+01,bt(dir)=11.0,bt(dir)=11.0,bt(crs)=22.0] #MZ@\r\n#NO","ordan-15 Apr 2004, assign-6 Nov 2003",90984,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (436,"בֶּאֱמֶת","r","00036639","yy","melingo","1.1","rav-milim","1.3","tg1",NULL,"truly, really",NULL,"קיוויתי שזה לא באמת קרה, אך נתבדיתי","checked","#ASSIGN:54.0=[gnd=1.0E+01,bt(dir)=11.0,bt(dir)=11.0,bt(crs)=22.0] #MZ@\r\n#NO","ordan-15 Apr 2004",90984,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (6618,"אַשְׁכָּרָה","r","00037263","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-15 Apr 2004",90985,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (6568,"כִּלְכּוּל","n","00788511","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"upkeep, maintenance",NULL,NULL,"checked","#NO consider also כלכלה (RM 1.4). תמיכה is out of the question, it should be ''reserved'' for the hypernym of this synset.","ordan-04 Apr 2004",90986,"2004-04-04");
INSERT INTO hebrew_synonyms VALUES (440,"בֶּדֶק","n","00171721","u","melingo","1","rav-milim",NULL,"tg1",NULL,"repair, maintenance, upkeep",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=1.0E+01,gnd=2.0E+01,si=14.0] #MZ@\r\n#NO RM does have this meaning. However, it sounds awkward to me, i don\'t feel it reflects the way it is being used. ","ordan-03 Apr 2004",90987,"2004-04-03");
INSERT INTO hebrew_synonyms VALUES (6633,"סוּמְסוּם","n","09172696","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-18 Apr 2004",90988,"2004-04-18");
INSERT INTO hebrew_synonyms VALUES (6363,"מִשְׁפָּחָה","n","06021037","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"family",NULL,"אני מעדיף לבלות את החגים בחיק משפחתי","checked","#IE","eyal-22 Jun 2005, shuly-08 Jan 2004",90989,"2005-06-22");
INSERT INTO hebrew_synonyms VALUES (444,"!בַּיִת","n","05976600","nn","melingo","4","rav-milim",NULL,"tg1",NULL,"dynasty, family",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n\r\n#NO this will be matched to ''House''","ordan-20 Mar 2004, assign-6 Nov 2003",0,"2004-03-20");
INSERT INTO hebrew_synonyms VALUES (447,"!בַּעֲלוּת","n","10386828","u","melingo","1","rav-milim",NULL,"tg1",NULL,"ownership, proprietary_right, title",NULL,NULL,"reviewed","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO the Hebrew sense includes both this sense and this one - n#09525525","ordan-19 Mar 2004, assign-6 Nov 2003",0,"2004-03-19");
INSERT INTO hebrew_synonyms VALUES (449,"!בַּעֲלוּת","n","00517391","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"ownership, proprietary_right, title",NULL,NULL,"checked","#ASSIGN:61.0=[gnd=13.0,bt(dir)=11.0,bt(dir)=13.0,bt(crs)=24.0] #MZ@\r\n#NO i\'m not sure we have a work for the act itself, the words בעלות or חזקה correspond to the other synset of ''ownership'' (n#09525525)","ordan-19 Mar 2004",0,"2004-03-19");
INSERT INTO hebrew_synonyms VALUES (451,"!בַּעַל","n","07451666","nn","melingo","1","rav-milim",NULL,"tg2",NULL,"owner, possessor",NULL,NULL,"reviewed","#ASSIGN:156.0=[gnd=2.0E+01,gnd=39.0,si=49.0,bt(dir)=24.0,bt(dir)=24.0] #MZ@\r\n#NO see remarks in n#07451379","ordan-20 Mar 2004, assign-6 Nov 2003",0,"2004-03-20");
INSERT INTO hebrew_synonyms VALUES (452,"!בַּעַל","n","07451379","nn","melingo","1","rav-milim",NULL,"tg2",NULL,"owner, possessor",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO in singular - only in סמיכות","ordan-20 Mar 2004",0,"2004-03-20");
INSERT INTO hebrew_synonyms VALUES (453,"בַּעַל","n","06871364","yy","melingo","4.1","rav-milim","4.1","tg2",NULL,"Baal",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-20 Mar 2004, assign-6 Nov 2003",90990,"2004-03-20");
INSERT INTO hebrew_synonyms VALUES (454,"בַּעַת","n","10318432","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"phobia",NULL,"יש לו בעת ממקומות פתוחים ולכן כמעט אינו יוצא מהבית","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-14 Apr 2004",90991,"2004-04-14");
INSERT INTO hebrew_synonyms VALUES (455,"בַּקָּשָׁה","n","05370393","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"request",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-20 Mar 2004, assign-6 Nov 2003",90992,"2004-03-20");
INSERT INTO hebrew_synonyms VALUES (457,"בַּת","n","07202206","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"daughter",NULL,"הוא אב לשני בנים ובת","checked","#ASSIGN:141.0=[gnd=39.0,bt(dir)=43.0,bt(dir)=8.0,bt(crs)=51.0] #MZ@\r\n#NO","ordan-11 Apr 2004, assign-6 Nov 2003",90993,"2004-04-11");
INSERT INTO hebrew_synonyms VALUES (6588,"נִבְעָרוּת","n","04591530","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-12 Apr 2004",90994,"2004-04-12");
INSERT INTO hebrew_synonyms VALUES (459,"!בַּת","n","06949518","y","melingo","4","rav-milim",NULL,"tg1",NULL,"native",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (460,"!בָּא","a","01242110","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"next, nearest, coming",NULL,NULL,"checked","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@","ordan-21 Jul 2004, assign-6 Nov 2003",0,"2004-07-21");
INSERT INTO hebrew_synonyms VALUES (461,"סָמוּךְ","a","00416294","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"adjacent, next",NULL,"הוא גר סמוך לאביו וכך יכול היה להגיע אליו לעתים קרובות ולסייע לו","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-16 Feb 2004",90995,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (462,"בָּא","a","00130334","yy","melingo","1.2","rav-milim","2.1","tg1",NULL,"following, next",NULL,"בתחילת החודש הבא תיכנס לי משכורת ממקום העבודה החדש","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-16 Feb 2004",90996,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (463,"!בָּא","a","00414175","y","melingo","1","rav-milim",NULL,"tg1",NULL,"next, nearest, coming",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (464,"!בָּא","v","01404337","u","melingo","2","rav-milim",NULL,"tg1",NULL,"approach, come_near",NULL,NULL,"checked","#ASSIGN:37.0=[gnd=8.0,gnd=13.0,si=16.0] #MZ@\r\n#NO ''ba'' doesn\'t denote getting closer in physical terms in contrary to time (''pesach ba'')","ordan-16 Feb 2004",0,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (465,"בָּא","v","01263165","yy","none",NULL,"none",NULL,"tg1",NULL,"approach, come_near",NULL,"אביב הגיע, פסח בא","revised","#ASSIGN:37.0=[gnd=8.0,gnd=13.0,si=16.0] #MZ@\r\n#NO","eyal-10 May 2004, ordan-16 Feb 2004",90997,"2004-05-10");
INSERT INTO hebrew_synonyms VALUES (466,"נִסָּה","v","01726067","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"examine, test",NULL,"גישה זו נוסתה בעבר ותוצאותיה היו טובות","checked","#ASSIGN:50=[gnd=8.0,gnd=6.0,si=9.0,bt(dir)=5.0,bt(dir)=5.0,dfl=17.0] #MZ@\r\n#NO","ordan-18 Mar 2004, assign-6 Nov 2003",90998,"2004-03-18");
INSERT INTO hebrew_synonyms VALUES (467,"בָּחַר","v","00455018","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"choose, take, select, pick_out",NULL,"הילד סיים את הגן והוריו התלבטו איזה בית-ספר לבחור עבורו","checked","#ASSIGN:85.0=[gnd=13.0,gnd=39.0,si=33.0] #MZ@\r\n#NO","ordan-17 Feb 2004",90999,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (469,"בָּטוּחַ","a","01848451","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"for_sure",NULL,"מה שבטוח, אין לי כוונה להישאר בחור הזה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-17 Feb 2004, assign-6 Nov 2003",91000,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (470,"!בָּכִיר","a","01585161","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"senior",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-16 Feb 2004, assign-6 Nov 2003",0,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (471,"!בָּכִיר","a","00962311","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"senior",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","ordan-16 Feb 2004, assign-6 Nov 2003",0,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (472,"בָּכִיר","a","02025056","yy","melingo","2.1","rav-milim","1.1","tg1",NULL,"senior",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-16 Feb 2004, assign-6 Nov 2003",91001,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (6475,"סִוֵּג","v","00441099","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"classify",NULL,"לאיזו תקופה היית מסווג את כלי החרס האלה - האם הם פרהיסטוריים?","checked","#NO","ordan-17 Feb 2004",91002,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (6474,"בָּרָק","n","07812527","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"lightning",NULL,"פתאום האיר ברק את שמי הלילה ואחריו הִרְעִים הרעם","checked","#NO","ordan-17 Feb 2004",91003,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (476,"בָּסִיס","n","02256491","yy","melingo","1.2","rav-milim","1.6","tg1","((military))","base",NULL,"ארצות הברית הודיעה כי היא מתכוננת להקים בסיס קדמי לכוחותיה המיוחדים בצפון אפגניסטן","checked","#ASSIGN:54.0=[gnd=2.0,flc(dic)=49.0,bt(dir)=3.0] #MZ@\r\n#NO\r\n#IE refers to the latter part of RM\'s definition","eyal-24 Aug 2004",91004,"2004-08-24");
INSERT INTO hebrew_synonyms VALUES (477,"עָשָׂה-אַהֲבָה","v","00977560","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"make_love, sleep_with, have_sex, know, have_intercourse, lie_with",NULL,"לאחר ששכבה עם חברהּ נכנסה להריון","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-19 Mar 2004",91005,"2004-03-19");
INSERT INTO hebrew_synonyms VALUES (478,"בָּרַר","v","00455018","yy","melingo","1","rav-milim","1.1","tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:85.0=[gnd=39.0,gnd=13.0,si=33.0] #MZ@\r\n#NO","ordan-17 Feb 2004, assign-6 Nov 2003",91006,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (479,"!בָּרַר","v","00441099","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"sort, separate",NULL,NULL,"checked","#ASSIGN:3.0E+01=[gnd=2.0E+01,gnd=3.0,si=7.0] #MZ@\r\n#NO","ordan-17 Feb 2004, assign-6 Nov 2003",0,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (480,"!בָּרָק","n","03874115","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"sparkle, glint, gleam, shine",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-17 Feb 2004, assign-6 Nov 2003",0,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (481,"בּוּרְסָה","n","03417221","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"stock_exchange, stock_market",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-09 Apr 2004, assign-6 Nov 2003",91007,"2004-04-09");
INSERT INTO hebrew_synonyms VALUES (482,"גְּבוּל","n","10019175","yy","melingo","1","rav-milim","1.2","tg1",NULL,"border",NULL,"האיש סימן את גבולות חצרו בפס של אבני כורכר","checked","#ASSIGN:36.0=[gnd=8.0,bt(dir)=6.0,bt(dir)=8.0,bt(crs)=14.0] #MZ@ #IE","eyal-09 Mar 2004, assign-6 Nov 2003",91008,"2004-03-09");
INSERT INTO hebrew_synonyms VALUES (483,"קָצֶה","n","06314081","yy","melingo","1","rav-milim","1.1","tg1",NULL,"border, edge",NULL,"הספר היה מונח בקצה השולחן","checked","#ASSIGN:36.0=[gnd=8.0,bt(dir)=6.0,bt(dir)=8.0,bt(crs)=14.0] #MZ@ #IE","eyal-09 Mar 2004, assign-6 Nov 2003",91009,"2004-03-09");
INSERT INTO hebrew_synonyms VALUES (484,"קַו-גְּבוּל","n","06279444","yy","melingo","2","rav-milim","1.1","tg1",NULL,"borderline",NULL,"קו הגבול סומן במפה בצבע אדום","checked","#ASSIGN:50=[gnd=39.0,bt(dir)=8.0,dfl=3.0] #MZ@ #IE refers to definitions 1 & 2 in RM","eyal-09 Mar 2004, assign-6 Nov 2003",91010,"2004-03-09");
INSERT INTO hebrew_synonyms VALUES (485,"גְּבוּל","n","03992325","yy","melingo","3","rav-milim","1.4","tg1",NULL,"limit, bounds",NULL,"מה שהוא עשה היה מעבר לגבולות ההתנהגות המקובלת","checked","#ASSIGN:54.0=[gnd=7.0,gnd=2.0E+01,si=11.0,bt(dir)=8.0,bt(dir)=8.0] #MZ@ #IE","eyal-09 Mar 2004, assign-6 Nov 2003",91008,"2004-03-09");
INSERT INTO hebrew_synonyms VALUES (486,"גְּרָם","n","09879963","yy","melingo","1","none","1.1","tg1",NULL,"gram",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-18 Mar 2004, assign-6 Nov 2003",91011,"2004-03-18");
INSERT INTO hebrew_synonyms VALUES (487,"!גִּיֵּס","v","00743026","y","melingo","1","rav-milim",NULL,"tg1",NULL,"conscript, enlist_someone, induct_someone",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (488,"גִּישָׁה","n","02159544","nn","melingo","1","rav-milim","1.1","tg1",NULL,"approach, access",NULL,"ישנן שלוש דרכי גישה שונות לעיר","revised","#ASSIGN:59.0=[gnd=4.0,gnd=8.0,si=8.0,bt(dir)=9.0,bt(dir)=4.0,bt(crs)=13.0,bt(dir)=9.0,bt(dir)=4.0] #MZ@ #IE\r\n#IN","ordan-17 Aug 2004, eyal-02 Mar 2004, assign-6 Nov 2003",91012,"2004-08-17");
INSERT INTO hebrew_synonyms VALUES (6492,"גִּישָׁה","n","06266273","yy","melingo","1.3","rav-milim","1.3",NULL,"(aviation)","approach",NULL,NULL,"checked","#IE","eyal-11 Aug 2004, eyal-02 Mar 2004",91012,"2004-08-11");
INSERT INTO hebrew_synonyms VALUES (490,"גָּמַר","v","00337013","yy","melingo","1","rav-milim","1.1","tg1",NULL,"finish, complete",NULL,"הוא גמר את כל האוכל בצלחת","checked","#ASSIGN:50=[gnd=7.0,gnd=8.0,si=1.0E+01,bt(dir)=7.0,bt(dir)=7.0,dfl=11.0] #MZ@ #IE","eyal-21 Mar 2004",91013,"2004-03-21");
INSERT INTO hebrew_synonyms VALUES (491,"הִשְׁתַּלֵּט","v","01234562","yy",NULL,NULL,"rav-milim","1.6","tg1",NULL,"overpower, overcome, overwhelm",NULL,"הכעס השתלט עלי ולא יכולתי שלא לצעוק עליו","checked","#ASSIGN:58.0=[gnd=2.0E+01,gnd=1.0E+01,gnd=1.0E+01,si=18.0] #MZ@ #IE","eyal-21 Mar 2004, assign-6 Nov 2003",91014,"2004-03-21");
INSERT INTO hebrew_synonyms VALUES (492,"!גִּמֵּר","v","00752542","y","melingo","2","rav-milim",NULL,"tg1","((slang))","overpower, overcome, defeat, overwhelm",NULL,NULL,"assigned","#ASSIGN:42.0=[gnd=2.0E+01,gnd=1.0E+01,si=12.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (493,"הִתְגַּבֵּר","v","00750517","yy","melingo","1","rav-milim","1.1","tg1",NULL,"overcome",NULL,"הוא התגבר על ביישנותו והציע לה לרקוד איתו","checked","#ASSIGN:42.0=[gnd=1.0E+01,gnd=2.0E+01,si=12.0] #MZ@ #IE","eyal-21 Mar 2004, assign-6 Nov 2003",91015,"2004-03-21");
INSERT INTO hebrew_synonyms VALUES (494,"הִתְנַזֵּר","v","00813536","yy","melingo","1","rav-milim","1.1","tg1",NULL,"abstain",NULL,"החלטתי להתנזר ממשקאות חריפים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-21 Mar 2004, assign-6 Nov 2003",91016,"2004-03-21");
INSERT INTO hebrew_synonyms VALUES (495,"!גִּמֵּר","v","00245987","y","melingo","8","rav-milim",NULL,"tg1","((colloquial))","end_up",NULL,NULL,"assigned","#ASSIGN:28.0=[gnd=2.0E+01,bt(dir)=8.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (498,"גֶּבֶר","n","01310064","yy","melingo","1","rav-milim","2.1","tg2","((flowery))","cock, rooster",NULL,"קריאת הגבר","checked","#ASSIGN:73.0=[gnd=1.0E+01,gnd=39.0,si=24.0] #MZ@ #IE","eyal-01 Mar 2004, assign-6 Nov 2003",91017,"2004-03-01");
INSERT INTO hebrew_synonyms VALUES (499,"!גֶּן","n","04220839","y","melingo","1","rav-milim",NULL,"tg1",NULL,"gene",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (500,"עֲרֵמָה","n","09920124","yy","melingo","2","rav-milim","1.3","tg1","(slang)","pile, heap",NULL,"הם עשו בבורסה ערימות של כסף","checked","#ASSIGN:29.0=[gnd=5.0,gnd=13.0,si=11.0] #MZ@ #IE","eyal-04 Mar 2004, assign-6 Nov 2003",91018,"2004-03-04");
INSERT INTO hebrew_synonyms VALUES (501,"גַּל","n","05969773","yy","melingo","2","sapir","1.4","tg1",NULL,"pile, heap",NULL,"ויקימו עליו גל אבנים גדול (יהושע, פרק ז) ","checked","#ASSIGN:29.0=[gnd=5.0,gnd=13.0,si=11.0] #MZ@ #IE","eyal-04 Mar 2004",91019,"2004-03-04");
INSERT INTO hebrew_synonyms VALUES (502,"גַּל","n","03255317","yy","melingo","1","sapir","1.7","tg2","((mechanics))","shaft, rotating_shaft",NULL,NULL,"checked","#ASSIGN:52.0=[gnd=3.0,flc(dic)=49.0] #MZ@ #IE","eyal-04 Mar 2004, assign-6 Nov 2003",91019,"2004-03-04");
INSERT INTO hebrew_synonyms VALUES (503,"גַּם","r","00046022","yy","melingo","1","rav-milim","1.1","tg1",NULL,"also",NULL,"מלבד הביואיק, יש לו גם מרצדס","checked","#ASSIGN:143.0=[gnd=39.0,bt(dir)=19.0,bt(dir)=33.0,bt(crs)=52.0] #MZ@ #IE","eyal-18 Mar 2004",91020,"2004-03-18");
INSERT INTO hebrew_synonyms VALUES (504,"בְּנוֹסָף","r","00044621","yy","none",NULL,"rav-milim","1.2","tg1",NULL,"additionally",NULL,"בנוסף להיותו המנכ''ל, הוא מכהן גם כיושב ראש מועצת המנהלים","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-09 May 2004",91021,"2004-05-09");
INSERT INTO hebrew_synonyms VALUES (505,"יָתֵר-עַל-כֵּן","r","00028436","yy","melingo","1","rav-milim","1.1","tg1",NULL,"furthermore, indeed",NULL,"משחקי המחשב נעשים זולים משנה לשנה, יתר על כן, איכותם לא מפסיקה להשתפר","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-19 Jun 2004, eyal-18 Mar 2004, assign-6 Nov 2003",91022,"2004-06-19");
INSERT INTO hebrew_synonyms VALUES (506,"!גַּן","n","06242655","y","melingo","1","rav-milim",NULL,"tg1",NULL,"garden",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (507,"!גַּן","n","02739225","y","melingo","1","rav-milim",NULL,"tg1",NULL,"garden",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (509,"!גַּן","n","06220715","y","melingo","1","rav-milim",NULL,"tg2",NULL,"kindergarten, nursery_school",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (510,"!גַּן","n","06220586","y","melingo","1","rav-milim",NULL,"tg2",NULL,"kindergarten, nursery_school",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (511,"!גָּבַר","v","00745640","y","melingo","2","rav-milim",NULL,"tg1",NULL,"overpower, conquer, vanquish, defeat",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (512,"גָּדַל","v","01732007","yy","melingo","1","rav-milim","1.1","tg1",NULL,"grow_up, grow_older",NULL,"גדלת להיות בחורה כל כך יפה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-21 Mar 2004, assign-6 Nov 2003",91023,"2004-03-21");
INSERT INTO hebrew_synonyms VALUES (513,"רְחַב-לֵב","a","01065754","yy","melingo","1","rav-milim","1.1","tg1",NULL,"big, large, magnanimous",NULL,"הוא אדם רחב לב ושמח","checked","#ASSIGN:4.0E+01=[gnd=3.0,gnd=5.0,si=5.0,bt(dir)=3.0,bt(dir)=6.0,bt(crs)=9.0,bt(dir)=3.0,bt(dir)=6.0] #MZ@ #IE","eyal-23 Feb 2004, assign-6 Nov 2003",91024,"2004-02-23");
INSERT INTO hebrew_synonyms VALUES (514,"גָּדוֹל","a","00546266","yy","melingo","1.1","rav-milim","1.6","tg1",NULL,"big, large, prominent",NULL,"הוא איש גדול בתנועה","revised","#ASSIGN:37.0=[gnd=3.0,gnd=5.0,si=5.0,bt(dir)=3.0,bt(dir)=5.0,bt(crs)=8.0,bt(dir)=3.0,bt(dir)=5.0] #MZ@ #IE","ordan-10 Aug 2004, eyal-23 Feb 2004, assign-6 Nov 2003",91025,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (515,"!גָּדוֹל","a","00174431","n","melingo","1","rav-milim",NULL,"tg1",NULL,"big, large",NULL,NULL,"assigned","#ASSIGN:53.0=[gnd=3.0,gnd=5.0,si=5.0,bt(dir)=2.0,bt(dir)=4.0,bt(dir)=4.0,bt(crs)=2.0E+01,bt(dir)=2.0,bt(dir)=4.0,bt(dir)=4.0] #MZ@\r\n#IE","eyal-27 Jul 2005, assign-6 Nov 2003",0,"2005-07-27");
INSERT INTO hebrew_synonyms VALUES (516,"גָּדוֹל","a","01328712","yy","melingo","1","rav-milim","1.1","tg1",NULL,"big, large",NULL,"שמתי פעמי אל העיר הגדולה","checked","#ASSIGN:49.0=[gnd=3.0,gnd=5.0,si=5.0,bt(dir)=8.0,bt(dir)=4.0,bt(crs)=12.0,bt(dir)=8.0,bt(dir)=4.0] #MZ@ #IE","eyal-23 Feb 2004",91025,"2004-02-23");
INSERT INTO hebrew_synonyms VALUES (517,"גָּדוֹל","a","02078228","yy","melingo","3","rav-milim","1.4","tg1",NULL,"significant, important",NULL,"זוהי תרומה גדולה למאבקנו הצודק","checked","#ASSIGN:50=[gnd=1.0E+01,gnd=8.0,si=7.0,dfl=25.0] #MZ@ #IE","eyal-23 Feb 2004, assign-6 Nov 2003",91025,"2004-02-23");
INSERT INTO hebrew_synonyms VALUES (519,"רַב-הַשְׁפָּעָה","a","01758782","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"influential",NULL,"עיתון רב השפעה","revised","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE\r\n#NO","ordan-23 May 2004, eyal-23 Feb 2004, assign-6 Nov 2003",91026,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (520,"מְהֻלָּל","a","01321211","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"illustrious, celebrated",NULL,"מדען מהולל","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE\r\n#NO","ordan-26 Jun 2004",91027,"2004-06-26");
INSERT INTO hebrew_synonyms VALUES (521,"גָּדוֹל","a","01617066","yy","melingo","6","rav-milim","1.7","tg1","((slang))","wonderful, marvelous, superb, ''out_of_this_world''",NULL,"הסרט היה פשוט גדול","checked","#ASSIGN:72.0=[gnd=39.0,gnd=13.0,si=2.0E+01] #MZ@ #IE","eyal-23 Feb 2004, assign-6 Nov 2003",91025,"2004-02-23");
INSERT INTO hebrew_synonyms VALUES (522,"חָלַף","v","01402214","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"pass_by",NULL,"הוא חלף על פני המורה שלו במסדרון בית הספר","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-23 Aug 2004, eyal-22 Mar 2004, assign-6 Nov 2003",91028,"2004-08-23");
INSERT INTO hebrew_synonyms VALUES (523,"גָּרַם","v","01130277","yy","melingo","1","rav-milim","1.1","tg1",NULL,"cause",NULL,"בנהיגתו הפרועה הוא גרם לתאונת שרשרת","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-22 Mar 2004, assign-6 Nov 2003",91029,"2004-03-22");
INSERT INTO hebrew_synonyms VALUES (524,"!גָּרַם","v","00523422","y","melingo","1","rav-milim",NULL,"tg1",NULL,"cause, produce, result_in",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (525,"!גּוֹרֵם","n","09888197","y","melingo","3","rav-milim",NULL,"tg1","((mathematics))","factor",NULL,NULL,"assigned","#ASSIGN:42.0=[gnd=8.0,flc(dic)=24.0,bt(dir)=1.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (526,"גּוֹרֵם","n","09767402","yy","melingo","3","rav-milim","1.3","tg1","((mathematics))","factor",NULL,NULL,"checked","#ASSIGN:42.0=[gnd=8.0,flc(dic)=24.0,bt(dir)=1.0E+01] #MZ@ #IE","eyal-10 Mar 2004, assign-6 Nov 2003",91030,"2004-03-10");
INSERT INTO hebrew_synonyms VALUES (527,"מָקוֹר","n","05417541","yy","melingo","1","rav-milim","1.4","tg1",NULL,"source",NULL,"הוא בילה שעות בחיפוש אחר המקור של הציטטה המסוימת הזו","checked","#ASSIGN:3.0E+01=[gnd=6.0,flc(dic)=24.0] #MZ@ #IE","eyal-10 Mar 2004",91031,"2004-03-10");
INSERT INTO hebrew_synonyms VALUES (528,"גּוּר","n","00866210","yy","melingo","2","rav-milim","1.1","tg1",NULL,"cub, whelp, pup",NULL,NULL,"checked","#ASSIGN:79.0=[gnd=39.0,gnd=2.0E+01,si=2.0E+01] #MZ@ #IE the Hebrew sense is broader and includes all young mammals","eyal-15 Mar 2004, eyal-01 Mar 2004, assign-6 Nov 2003",91032,"2004-03-15");
INSERT INTO hebrew_synonyms VALUES (529,"!דְּמוּת","n","05317127","y","melingo","1","rav-milim",NULL,"tg1",NULL,"figure, image",NULL,NULL,"assigned","#ASSIGN:41.0=[gnd=3.0,gnd=6.0,si=5.0,bt(dir)=3.0,bt(dir)=6.0,bt(crs)=9.0,bt(dir)=3.0,bt(dir)=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (530,"!דְּמוּת","n","04055717","u","melingo","1","rav-milim",NULL,"tg1",NULL,"figure, image",NULL,NULL,"checked","#ASSIGN:27.0=[gnd=3.0,bt(dir)=2.0,bt(dir)=4.0,bt(dir)=2.0,bt(crs)=16.0] #MZ@\r\n#IE","eyal-26 Jan 2005, assign-6 Nov 2003",0,"2005-01-26");
INSERT INTO hebrew_synonyms VALUES (531,"!דְּרִישָׁה","n","10367157","y","melingo","1","rav-milim",NULL,"tg1",NULL,"demand, firm_request",NULL,NULL,"assigned","#ASSIGN:5.0E+01=[gnd=8.0,bt(dir)=12.0,bt(dir)=9.0,bt(crs)=21.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (8058,"דְּרִישַׁת-קְדָם","n","04528749","yf","none",NULL,"none",NULL,NULL,NULL,NULL,NULL,"שליטה בלטינית היא דרישת קדם לקבלה ללימודים במוסד זה","checked","#IE","eyal-27 Jan 2005",94234,"2005-01-27");
INSERT INTO hebrew_synonyms VALUES (533,"דְּרִישָׁה","n","04528955","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"requirement",NULL,"הדרישות הגבוהות של עבודתו השפיעו על בריאותו","checked","#ASSIGN:55.0=[gnd=13.0,bt(dir)=13.0,bt(dir)=8.0,bt(crs)=21.0] #MZ@\r\n#IE","eyal-27 Jan 2005, assign-6 Nov 2003",94233,"2005-01-27");
INSERT INTO hebrew_synonyms VALUES (534,"!דְּרִישָׁה","n","04528749","u","melingo","2","rav-milim",NULL,"tg1",NULL,"requirement",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-27 Jan 2005, assign-6 Nov 2003",0,"2005-01-27");
INSERT INTO hebrew_synonyms VALUES (8790,"GAP!","n","07207111","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE gender","eyal-07 Jul 2005",90808,"2005-07-07");
INSERT INTO hebrew_synonyms VALUES (8791,"תְּבוּסְתָן","n","H0004031","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"defeatist",NULL,NULL,"checked","#IE","eyal-07 Jul 2005",95101,"2005-07-07");
INSERT INTO hebrew_synonyms VALUES (8795,"מְדַבֵּר","v","00652168","yy","none",NULL,"rav-milim","1.1",NULL,NULL,NULL,NULL,"הם מדברים בניב מאד מוזר; הוא בקושי בן שנה והוא כבר מדבר!","checked","#IE appears in RM at the end of the ''דיבר'' definitions; used in the present tense only","eyal-07 Jul 2005",95195,"2005-07-07");
INSERT INTO hebrew_synonyms VALUES (537,"!דִּבֵּר","v","00651246","y","melingo","1","rav-milim",NULL,"tg1",NULL,"speak, talk",NULL,NULL,"assigned","#ASSIGN:43.0=[gnd=8.0,gnd=7.0,si=12.0,bt(dir)=8.0,bt(dir)=8.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (539,"!דִּיּוּן","n","05342032","y","melingo","1","rav-milim",NULL,"tg1",NULL,"consideration, deliberation, discussion",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (540,"!דִּיּוּן","n","05340429","y","melingo","1","rav-milim",NULL,"tg1",NULL,"consideration, deliberation, discussion",NULL,NULL,"assigned","#ASSIGN:41.0=[gnd=2.0E+01,bt(dir)=21.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (541,"!דִּין","n","04537256","y","melingo","2","rav-milim",NULL,"tg1",NULL,"legal_system",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (542,"!דִּין","n","07766144","y","melingo","10","rav-milim",NULL,"tg1",NULL,"consequence, effect",NULL,NULL,"assigned","#ASSIGN:50=[gnd=13.0,gnd=7.0,si=12.0,dfl=18.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6512,"גּוֹרָל","n","10381983","yy","melingo","1","rav-milim","1.1",NULL,NULL,"destiny, fate",NULL,"כנראה שנגזר גורלי לעבוד קשה כל חיי","checked","#IE","eyal-15 Mar 2004",91033,"2004-03-15");
INSERT INTO hebrew_synonyms VALUES (544,"!דִּין","n","06060223","y","melingo","12","rav-milim",NULL,"tg1","((biblical))","justice",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (545,"!דִּירָה","n","02199402","y","melingo","1","rav-milim",NULL,"tg1",NULL,"apartment, flat",NULL,NULL,"assigned","#ASSIGN:194.0=[gnd=39.0,gnd=6.0,si=14.0,bt(dir)=39.0,bt(dir)=6.0,bt(crs)=45.0,bt(dir)=39.0,bt(dir)=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (546,"!דֵּי","r","00141645","y","melingo","1","rav-milim",NULL,"tg1",NULL,"enough, sufficiently",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (547,"!דֵּי","r","00141865","y","melingo","1","rav-milim",NULL,"tg1",NULL,"enough, sufficiently",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (548,"!דֵּי","r","00280549","y","melingo","2","rav-milim",NULL,"tg1",NULL,"quite, fairly",NULL,NULL,"assigned","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (549,"!דֵּי","r","00103672","y","melingo","2","rav-milim",NULL,"tg1",NULL,"quite, fairly",NULL,NULL,"assigned","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (550,"!דֵּי","r","00035125","y","melingo","2","rav-milim",NULL,"tg1",NULL,"quite, fairly",NULL,NULL,"assigned","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (8792,"דֶּפֶטִיסְט","n","H0004031","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"defeatist",NULL,NULL,"checked","#IE","eyal-07 Jul 2005",95102,"2005-07-07");
INSERT INTO hebrew_synonyms VALUES (8793,"תְּבוּסְתָנִית","n","H0004032","yy","none",NULL,"none",NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE","eyal-07 Jul 2005",95193,"2005-07-07");
INSERT INTO hebrew_synonyms VALUES (552,"!דֵּעָה","n","04492484","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"idea, opinion, thought",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=8.0,gnd=1.0E+01,si=8.0] #MZ@\r\n#NO","ordan-17 Dec 2004, assign-6 Nov 2003",0,"2004-12-17");
INSERT INTO hebrew_synonyms VALUES (553,"דֶּבֶר","n","10169961","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"plague",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-26 Sep 2004",93423,"2004-09-26");
INSERT INTO hebrew_synonyms VALUES (554,"!דֶּלֶק","n","10669661","y","melingo","1","rav-milim",NULL,"tg1",NULL,"fuel",NULL,NULL,"assigned","#ASSIGN:82.0=[gnd=39.0,bt(dir)=43.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (555,"!דֶּלֶק","n","10528091","y","melingo","2","rav-milim",NULL,"tg1",NULL,"petrol, gas",NULL,NULL,"assigned","#ASSIGN:78.0=[gnd=39.0,gnd=7.0,si=16.0,bt(dir)=8.0,bt(dir)=8.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (7520,"מִגְדַּל-תַּצְפִּית","n","03593869","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"watch_tower",NULL,"השומר עמד במגדל התצפית ולא הסיר את עיניו מהאסירים שהתגודדו בחצר","checked","#IE","eyal-15 Nov 2004",93675,"2004-11-15");
INSERT INTO hebrew_synonyms VALUES (557,"!דֶּרֶךְ","n","00266805","y","melingo","1","rav-milim",NULL,"tg1",NULL,"road, path",NULL,NULL,"assigned","#ASSIGN:4.0E+01=[gnd=1.0E+01,bt(dir)=3.0,bt(dir)=12.0,bt(crs)=15.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (558,"!דֶּרֶךְ","n","03243979","y","melingo","1","rav-milim",NULL,"tg1",NULL,"road, path",NULL,NULL,"assigned","#ASSIGN:96.0=[gnd=2.0E+01,bt(dir)=19.0,bt(dir)=19.0,bt(crs)=38.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (559,"!דֶּרֶךְ","n","00112808","y","melingo","1","rav-milim",NULL,"tg1",NULL,"road, path",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (560,"!דֶּרֶךְ","n","06348591","u","melingo","2","rav-milim",NULL,"tg1",NULL,"route",NULL,NULL,"checked","#ASSIGN:78.0=[gnd=2.0E+01,bt(dir)=1.0E+01,bt(dir)=19.0,bt(crs)=29.0] #MZ@\r\n#IE ''derech'' is not ''an established line of travel''","eyal-14 Nov 2004, assign-6 Nov 2003",0,"2004-11-14");
INSERT INTO hebrew_synonyms VALUES (561,"!דֶּרֶךְ","n","03243979","y","melingo","2","rav-milim",NULL,"tg1",NULL,"route",NULL,NULL,"assigned","#ASSIGN:96.0=[gnd=2.0E+01,bt(dir)=19.0,bt(dir)=19.0,bt(crs)=38.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (562,"!דֶּרֶךְ","n","00266805","y","melingo","3","rav-milim",NULL,"tg1",NULL,"way",NULL,NULL,"assigned","#ASSIGN:33.0=[gnd=3.0,bt(dir)=3.0,bt(dir)=12.0,bt(crs)=15.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (563,"!דֶּרֶךְ","n","02653712","y","melingo","4","rav-milim",NULL,"tg1",NULL,"access, throughway",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (564,"!דֶּרֶךְ","n","00266805","y","melingo","5","rav-milim",NULL,"tg1",NULL,"method, way, technique",NULL,NULL,"assigned","#ASSIGN:33.0=[gnd=3.0,bt(dir)=3.0,bt(dir)=12.0,bt(crs)=15.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (565,"!דֶּרֶךְ","n","03858557","y","melingo","5","rav-milim",NULL,"tg1",NULL,"method, way, technique",NULL,NULL,"assigned","#ASSIGN:67.0=[gnd=2.0E+01,bt(dir)=47.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (566,"!דֶּרֶךְ","n","09939326","y","melingo","6","rav-milim",NULL,"tg1","((linguistics))","mode",NULL,NULL,"assigned","#ASSIGN:67.0=[gnd=8.0,flc(dic)=49.0,bt(dir)=1.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (567,"דֶּרֶךְ","n","03856995","yy","melingo","1.4","rav-milim","1.5","tg1","((linguistics))","mode",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=8.0,bt(dir)=6.0,bt(dir)=3.0,bt(crs)=9.0] #MZ@\r\n#NO","ordan-12 Aug 2004, assign-6 Nov 2003",0,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (568,"!דַּוְקָא","r","00039677","nn","melingo","1","rav-milim",NULL,"tg1","((colloquial))","specifically, precisely",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-23 Dec 2004, assign-6 Nov 2003",0,"2004-12-23");
INSERT INTO hebrew_synonyms VALUES (569,"!דַּוְקָא","r","00145000","y","melingo","2","rav-milim",NULL,"tg1","((colloquial))","in_fact, actually",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (570,"דַּקּוּת","n","04955518","yy","melingo","2","rav-milim","1.2","tg1",NULL,"nuance, subtlety",NULL,"הוא תמיד מסתכל על התמונה הכללית, הוא לא שם לב לדקויות","checked","#ASSIGN:108.0=[gnd=39.0,gnd=2.0E+01,si=49.0] #MZ@ #IE","eyal-04 Mar 2004",91034,"2004-03-04");
INSERT INTO hebrew_synonyms VALUES (572,"!דָּלָק","n","01945877","y","melingo","1","rav-milim",NULL,"tg1",NULL,"marten",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (573,"!דָּן","v","00613914","y","melingo","1","rav-milim",NULL,"tg2",NULL,"judge, sentence, sit_in_judgment",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (574,"!דָּרַךְ","v","01433087","y","melingo","1","rav-milim",NULL,"tg1",NULL,"step_on, walk_on",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (575,"דָּרַךְ","v","01432910","yy","oxford","1.1","rav-milim","1.1","tg1",NULL,"tread",NULL,"שימו לב היכן אתם דורכים שכן החוף כאן עמוס בקיפודי ים","checked","#ASSIGN:50=[gnd=7.0,bt(dir)=24.0,dfl=19.0] #MZ@\r\n#IE","eyal-01 Feb 2005, assign-6 Nov 2003",94356,"2005-02-01");
INSERT INTO hebrew_synonyms VALUES (576,"דָּרַשׁ","v","01792695","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"necessitate",NULL,"לימוד מתמטיקה דורש מאמץ רב","checked","#ASSIGN:41.0=[gnd=1.0E+01,gnd=7.0,si=12.0,bt(dir)=6.0,bt(dir)=6.0] #MZ@\r\n#NO","ordan-27 May 2004, assign-6 Nov 2003",91035,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (577,"!דָּרַשׁ","v","00808096","y","melingo","2","rav-milim",NULL,"tg1",NULL,"require, need",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=1.0E+01,gnd=7.0,si=12.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (578,"!דָּרַשׁ","v","00562059","y","melingo","2","rav-milim",NULL,"tg1",NULL,"sermonize, preach",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (579,"!דָּרוֹם","n","09965063","y","melingo","1","rav-milim",NULL,"tg1",NULL,"south",NULL,NULL,"assigned","#ASSIGN:78.0=[gnd=39.0,bt(dir)=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (580,"!דּוֹבֵר","n","07601647","y","melingo","1","rav-milim",NULL,"tg1",NULL,"spokesman",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (581,"!דּוּמָה","n","06265145","y","melingo","1","rav-milim",NULL,"tg1","((flowery))","grave, afterworld",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (582,"!דּוּר","n","10031143","y","melingo","1","rav-milim",NULL,"tg1","((botany))","whorl, verticil",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6841,"אַנְתְּרוֹפּוֹמוֹרְפִיזְם","n","04448080","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"anthropomorphism",NULL,NULL,"checked","#IE also RM 1.2","eyal-13 Jun 2004",91036,"2004-06-13");
INSERT INTO hebrew_synonyms VALUES (584,"!הֲגָנָה","n","06058911","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"defense",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-13 Jun 2004, assign-6 Nov 2003",0,"2004-06-13");
INSERT INTO hebrew_synonyms VALUES (585,"!הֲלִיךְ","n","00660588","y","melingo","1","rav-milim",NULL,"tg1","((law))","proceeding, procedure",NULL,NULL,"assigned","#ASSIGN:71.0=[gnd=1.0E+01,flc(dic)=49.0,bt(dir)=12.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (586,"הֲלִיךְ","n","00766856","yy","melingo","1.1","rav-milim","1.1","tg1","((law))","proceeding, procedure",NULL,"להליך הגישור יש כמה יתרונות בולטים לעומת ההליך המשפטי","checked","#ASSIGN:69.0=[gnd=2.0E+01,flc(dic)=49.0] #MZ@ #IE","eyal-04 May 2004, assign-6 Nov 2003",91037,"2004-05-04");
INSERT INTO hebrew_synonyms VALUES (587,"!הִבְהִיר","v","00191916","u","melingo","2","rav-milim",NULL,"tg1",NULL,"bleach, lighten, whiten",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE not necessarily turn white","eyal-29 Jul 2004, assign-6 Nov 2003",0,"2004-07-29");
INSERT INTO hebrew_synonyms VALUES (588,"!הִבְחִין","v","01501559","y","melingo","1","rav-milim",NULL,"tg1",NULL,"notice, discern, reveal",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (589,"הִבְטִיחַ","v","00603511","yy","melingo","2.1","rav-milim","2.1","tg2",NULL,"ensure",NULL,"ניצחונו בטורניר הבטיח את השתתפותו באולימפיאדה","checked","#ASSIGN:26.0=[gnd=2.0E+01,bt(dir)=6.0] #MZ@\r\n#IE RM definition is broader","eyal-30 May 2004, assign-6 Nov 2003",91038,"2004-05-30");
INSERT INTO hebrew_synonyms VALUES (590,"!הִבִּיעַ","v","00644607","u","melingo","1.1","rav-milim","1.2","tg1",NULL,"voice",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#IE the word ''hibi\'ah'' fits more to syn v#00631861","eyal-30 May 2004",0,"2004-05-30");
INSERT INTO hebrew_synonyms VALUES (591,"הִבִּיעַ","v","00631861","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"voice",NULL,"הוא הביע את דאגתו בפניה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-30 May 2004, assign-6 Nov 2003",91039,"2004-05-30");
INSERT INTO hebrew_synonyms VALUES (592,"!הִגִּישׁ","v","01568149","y","melingo","2","rav-milim",NULL,"tg1",NULL,"hand_over, give_to_someone",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (593,"!הִגִּישׁ","v","01568149","y","melingo","3","rav-milim",NULL,"tg1",NULL,"submit, hand_in, hand_over",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (594,"!הִדְגִּישׁ","v","00685448","y","melingo","1","rav-milim",NULL,"tg1",NULL,"emphasize, stress",NULL,NULL,"assigned","#ASSIGN:67.0=[gnd=13.0,gnd=1.0E+01,si=2.0E+01,bt(dir)=12.0,bt(dir)=12.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (595,"!הִדְגִּישׁ","v","00358494","u","melingo","1","rav-milim",NULL,"tg1",NULL,"emphasize, stress",NULL,NULL,"checked","#ASSIGN:63.0=[gnd=13.0,gnd=1.0E+01,si=2.0E+01,bt(dir)=1.0E+01,bt(dir)=1.0E+01] #MZ@\r\n#IE I think הדגיש fits better to v#00685448\r\n(although it is not unequivocal)","eyal-31 Jul 2004, assign-6 Nov 2003",0,"2004-07-31");
INSERT INTO hebrew_synonyms VALUES (596,"!הִדְגִּישׁ","v","00358208","y","melingo","2","rav-milim",NULL,"tg1",NULL,"highlight",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (597,"!הִזְדַּמְּנוּת","n","10390345","y","melingo","1","rav-milim",NULL,"tg1",NULL,"opportunity, occasion",NULL,NULL,"assigned","#ASSIGN:82.0=[gnd=39.0,bt(dir)=43.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (598,"הִכְרִיז","v","00654101","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"announce, declare",NULL,"הוא הכריז על הסרת מועמדותו מן המרוץ לנשיאות","checked","#ASSIGN:50=[gnd=1.0E+01,gnd=6.0,si=1.0E+01,dfl=24.0] #MZ@\r\n#IE","eyal-01 Aug 2004, assign-6 Nov 2003",91040,"2004-08-01");
INSERT INTO hebrew_synonyms VALUES (599,"!הִסְבִּיר","v","00636437","y","melingo","2","rav-milim",NULL,"tg1",NULL,"clarify, elucidate",NULL,NULL,"assigned","#ASSIGN:54.0=[gnd=1.0E+01,gnd=2.0E+01,si=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (600,"הִסְבִּיר","v","00420545","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"clarify, elucidate",NULL,"תסביר לי בבקשה את ההערות שכתבת במסמך","checked","#ASSIGN:54.0=[gnd=1.0E+01,gnd=2.0E+01,si=24.0] #MZ@ #IE","eyal-30 May 2004, assign-6 Nov 2003",91041,"2004-05-30");
INSERT INTO hebrew_synonyms VALUES (601,"!הִסְכִּים","v","01841740","y","melingo","1","rav-milim",NULL,"tg1",NULL,"agree",NULL,NULL,"assigned","#ASSIGN:50=[gnd=6.0,bt(dir)=24.0,dfl=2.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (602,"הִסְכִּים","v","00541962","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"consent",NULL,"הוא הסכים ללוות אותי למסיבה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-12 May 2004, assign-6 Nov 2003",91042,"2004-05-12");
INSERT INTO hebrew_synonyms VALUES (603,"!הִסְכִּים","v","00546534","y","melingo","4","rav-milim",NULL,"tg1",NULL,"permit, acquiesce",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (604,"הִסְפִּיק","v","01821274","yy","melingo","1.2","rav-milim","1.1, 1.3","tg1",NULL,"suffice",NULL,"הכסף לא הספיק לי; המכונית הזאת מספיקה לי בהחלט","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE a combination of RM 1.1 + 1.3 (RM 1.1 refers only to quantity)","eyal-12 May 2004",91043,"2004-05-12");
INSERT INTO hebrew_synonyms VALUES (605,"!הִפְגִּין","v","01467644","y","melingo","2","rav-milim",NULL,"tg1",NULL,"display, show",NULL,NULL,"assigned","#ASSIGN:49.0=[gnd=13.0,gnd=3.0,si=7.0,bt(dir)=13.0,bt(dir)=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (606,"!הִפְגִּין","v","01728504","y","melingo","2","rav-milim",NULL,"tg1",NULL,"display, show",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (607,"!הִפְגִּין","v","01464775","y","melingo","2","rav-milim",NULL,"tg1",NULL,"display, show",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (608,"הִפְסִיק","v","01829006","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"stop, discontinue",NULL,"הוא הפסיק לעבוד ושכב לנוח","checked","#ASSIGN:36.0=[gnd=4.0,gnd=13.0,si=9.0,bt(dir)=5.0,bt(dir)=5.0] #MZ@ #IE","eyal-12 May 2004, assign-6 Nov 2003",91044,"2004-05-12");
INSERT INTO hebrew_synonyms VALUES (609,"הִפְסִיק","v","00253202","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"stop, discontinue",NULL,"הוא הפסיק את הזרמת הכספים לפרוייקט","checked","#ASSIGN:36.0=[gnd=4.0,gnd=13.0,si=9.0,bt(dir)=5.0,bt(dir)=5.0] #MZ@ #IE","eyal-12 May 2004, assign-6 Nov 2003",91044,"2004-05-12");
INSERT INTO hebrew_synonyms VALUES (611,"!הִצִּיג","v","01470807","y","melingo","2","rav-milim",NULL,"tg1",NULL,"show, exhibit",NULL,NULL,"assigned","#ASSIGN:37.0=[gnd=3.0,gnd=1.0E+01,si=6.0,bt(dir)=3.0,bt(dir)=3.0,bt(crs)=6.0,bt(dir)=3.0,bt(dir)=3.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6708,"קָרָה","v","00235191","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"happen",NULL,NULL,"checked","#IE","eyal-16 May 2004",91045,"2004-05-16");
INSERT INTO hebrew_synonyms VALUES (613,"!הִצִּיג","v","01467644","y","melingo","2","rav-milim",NULL,"tg1",NULL,"show, exhibit",NULL,NULL,"assigned","#ASSIGN:35.0=[gnd=3.0,bt(dir)=13.0,bt(dir)=3.0,bt(crs)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (614,"!הִצִּיג","v","01728504","y","melingo","3","rav-milim",NULL,"tg1",NULL,"present, display",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (615,"!הִצִּיג","v","01467644","y","melingo","3","rav-milim",NULL,"tg1",NULL,"present, display",NULL,NULL,"assigned","#ASSIGN:45.0=[gnd=13.0,bt(dir)=13.0,bt(dir)=3.0,bt(crs)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (616,"!הִצִּיג","v","01464775","y","melingo","3","rav-milim",NULL,"tg1",NULL,"present, display",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (617,"הִצִּיעַ","v","00592804","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"advise, suggest",NULL,"הצענו להם לבוא לבקר בשבת","checked","#ASSIGN:32.0=[gnd=13.0,gnd=8.0,si=11.0] #MZ@\r\n#IE","eyal-01 Aug 2004, assign-6 Nov 2003",91046,"2004-08-01");
INSERT INTO hebrew_synonyms VALUES (618,"הִצִּיעַ","v","01571054","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"proffer",NULL,"הצעתי לו להצטרף אלינו לטיול, אבל הוא סירב","checked","#ASSIGN:50=[gnd=39.0,bt(dir)=4.0,dfl=7.0] #MZ@\r\n#NO","ordan-27 May 2004, assign-6 Nov 2003",91046,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (619,"הִרְגִּישׁ","v","01441871","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"feel, sense",NULL,"היא הרגישה במשהו זוחל על עורה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE RM definition is broader, and can match other English synsets, too.","eyal-17 Jun 2004, assign-6 Nov 2003",91047,"2004-06-17");
INSERT INTO hebrew_synonyms VALUES (620,"!הִשִּׂיג","v","01722366","y","melingo","2","rav-milim",NULL,"tg1",NULL,"succeed, achieve",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (621,"הִשִּׂיג","v","00560756","yy","melingo","1.6","rav-milim","1.7","tg1","((literary))","criticize",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE usually is followed by על, as in השיג על גזר הדין החמור","eyal-20 May 2004, assign-6 Nov 2003",91048,"2004-05-20");
INSERT INTO hebrew_synonyms VALUES (622,"!הִשְׁקִיעַ","v","00330961","y","melingo","2","rav-milim",NULL,"tg1","((chemistry))","precipitate",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=5.0,flc(dic)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (623,"הִשְׁקִיעַ","v","00330720","yy","melingo","1.2","rav-milim","1.2","tg1","((chemistry))","precipitate",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=5.0,flc(dic)=24.0] #MZ@ #IE","eyal-31 May 2004, assign-6 Nov 2003",91049,"2004-05-31");
INSERT INTO hebrew_synonyms VALUES (624,"!הִשְׁתַּתֵּף","v","00401413","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"share_(someone\'s_feelings), empathize",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-31 Jul 2004, assign-6 Nov 2003",0,"2004-07-31");
INSERT INTO hebrew_synonyms VALUES (625,"!הִתְאַחֲדוּת","n","00155072","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"unification, unionization",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE not the correct word","eyal-15 Apr 2004, assign-6 Nov 2003",0,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (626,"!הִתְחִיל","v","01133757","y","melingo","1","rav-milim",NULL,"tg1",NULL,"begin, start, commence",NULL,NULL,"assigned","#ASSIGN:33.0=[gnd=6.0,gnd=4.0,gnd=13.0,si=1.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (627,"!הִתְחִיל","v","00242403","y","melingo","1","rav-milim",NULL,"tg1",NULL,"begin, start, commence",NULL,NULL,"assigned","#ASSIGN:33.0=[gnd=6.0,gnd=4.0,gnd=13.0,si=1.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (628,"הִתְחִיל","v","00239960","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"begin, start, commence",NULL,"התחלנו לעבוד עם עלות השחר","checked","#ASSIGN:33.0=[gnd=6.0,gnd=4.0,gnd=13.0,si=1.0E+01] #MZ@ #IE","eyal-15 May 2004",91050,"2004-05-15");
INSERT INTO hebrew_synonyms VALUES (629,"הִתְמוֹדֵד","v","00727087","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"compete",NULL,"שניהם התמודדו על המקום הראשון בתחרות","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-16 May 2004, assign-6 Nov 2003",91051,"2004-05-16");
INSERT INTO hebrew_synonyms VALUES (630,"הִתְמוֹדֵד","v","01763911","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"contend_(with), cope",NULL,"הוא ניסה להתמודד עם העובדה שהפסיד בתחרות","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-16 May 2004, assign-6 Nov 2003",91051,"2004-05-16");
INSERT INTO hebrew_synonyms VALUES (631,"!הִתְנַגֵּד","v","00548744","y","melingo","1","rav-milim",NULL,"tg1",NULL,"object, oppose",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (632,"הִתְקַיֵּם","v","00235191","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"take_place",NULL,"הפגישה התקיימה ללא כל אירועים מיוחדים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-16 May 2004, assign-6 Nov 2003",91052,"2004-05-16");
INSERT INTO hebrew_synonyms VALUES (633,"הִתְקַיֵּם","v","01785787","u","melingo","1.4","rav-milim","1.3","tg1",NULL,"live, survive",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=7.0,gnd=1.0E+01,si=12.0] #MZ@\r\n#IE I think it fits better to v#01784619","eyal-01 Mar 2005, assign-6 Nov 2003",0,"2005-03-01");
INSERT INTO hebrew_synonyms VALUES (634,"הִתְקַיֵּם","v","01784619","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"live, survive",NULL,"הוא לא יכול היה להתקיים ללא אהבתה","checked","#ASSIGN:29.0=[gnd=7.0,gnd=1.0E+01,si=12.0] #MZ@ #IE","eyal-16 May 2004, assign-6 Nov 2003",91052,"2004-05-16");
INSERT INTO hebrew_synonyms VALUES (6709,"שָׂרַד","v","01785787","yy","melingo","1.1","rav-milim","1.2",NULL,NULL,"survive",NULL,"הוא שרד שלושה ימים ללא מזון ושתיה","checked","#IE","eyal-16 May 2004",91053,"2004-05-16");
INSERT INTO hebrew_synonyms VALUES (636,"הִתְרַחֵשׁ","v","00235191","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"occur, happen",NULL,"לא נשארה שום עדות למה שהתרחש פה לפני כמה דקות","checked","#ASSIGN:50=[gnd=1.0E+01,gnd=8.0,si=12.0,dfl=2.0E+01] #MZ@ #IE","eyal-16 May 2004",91054,"2004-05-16");
INSERT INTO hebrew_synonyms VALUES (637,"!הֵבִיא","v","00015408","y","melingo","10","rav-milim",NULL,"tg1",NULL,"bring_to",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (638,"!הֵבִיא","v","01722366","y","melingo","11","rav-milim",NULL,"tg1",NULL,"bring_oneself_to_do, achieve",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (640,"!הֵבִיא","v","01782390","y","melingo","13","rav-milim",NULL,"tg1","((biblical))","offer_up",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (641,"הֵגִיב","v","00554194","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"reply, answer",NULL,"העיתונאים שאלו אותו שאלות רבות, אך הוא סירב להגיב","checked","#ASSIGN:63.0=[gnd=39.0,gnd=4.0,si=1.0E+01,bt(dir)=5.0,bt(dir)=5.0] #MZ@\r\n#IE","eyal-31 Jul 2004",91055,"2004-07-31");
INSERT INTO hebrew_synonyms VALUES (642,"הֵגִיב","v","00485595","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"react, respond",NULL,"הוא הגיב בכעס לבקשתי להצטרף אליו","checked","#ASSIGN:50=[gnd=13.0,gnd=13.0,si=2.0E+01,dfl=4.0] #MZ@\r\n#IE","eyal-20 May 2004, assign-6 Nov 2003",91055,"2004-05-20");
INSERT INTO hebrew_synonyms VALUES (643,"!הֵלֶךְ","n","07433746","y","melingo","1","rav-milim",NULL,"tg1","((literary))","wanderer, nomad",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (644,"!הֵלֶךְ","n","07672456","y","melingo","1","rav-milim",NULL,"tg1","((literary))","wanderer, nomad",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6539,"הֵצִיף","v","01234562","yy",NULL,NULL,"rav-milim","1.3",NULL,NULL,"whelm",NULL,"רגש האהבה הציף אותי","checked","#IE the English definition was taken Babylon ","eyal-21 Mar 2004",91056,"2004-03-21");
INSERT INTO hebrew_synonyms VALUES (646,"!הֵקִים","v","01652417","u","melingo","2","rav-milim",NULL,"tg1",NULL,"establish, found",NULL,NULL,"checked","#ASSIGN:3.0E+01=[gnd=5.0,gnd=13.0,si=12.0] #MZ@ #IE I think יסד is more suitable","eyal-17 Jun 2004, assign-6 Nov 2003",0,"2004-06-17");
INSERT INTO hebrew_synonyms VALUES (647,"הֵקִים","v","01131591","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"establish, found",NULL,"הוא הקים מחלקה חדשה במפעל","checked","#ASSIGN:3.0E+01=[gnd=5.0,gnd=13.0,si=12.0] #MZ@ #IE","eyal-17 Jun 2004, assign-6 Nov 2003",91057,"2004-06-17");
INSERT INTO hebrew_synonyms VALUES (648,"!הֵקִים","v","00430666","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"establish, found",NULL,NULL,"checked","#ASSIGN:3.0E+01=[gnd=5.0,gnd=13.0,si=12.0] #MZ@ #IE","eyal-17 Jun 2004, assign-6 Nov 2003",0,"2004-06-17");
INSERT INTO hebrew_synonyms VALUES (649,"הֵקִים","v","01140839","yy","melingo","1.3","rav-milim","1.1","tg1",NULL,"erect, raise",NULL,"הקמנו את האסם בדיוק היכן שהיה לפני שכילתה אותו השריפה","checked","#ASSIGN:25.0=[gnd=2.0E+01,gnd=1.0,si=4.0] #MZ@ #IE","eyal-17 Jun 2004, assign-6 Nov 2003",91057,"2004-06-17");
INSERT INTO hebrew_synonyms VALUES (650,"הֵקִים","v","01064709","yy","melingo","1.5","rav-milim","1.3","tg1",NULL,"place_upright",NULL,"הוא היה כה כבד כך שלא עלה בידי להקימו על רגליו","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-17 Jun 2004, assign-6 Nov 2003",91057,"2004-06-17");
INSERT INTO hebrew_synonyms VALUES (651,"הֶאֱמִין_בְּ","v","00497762","yy","melingo","1.2","rav-milim","1.6","tg1",NULL,"believe_in",NULL,"אני מאמינה בתזונה דלת פחמימות","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ \r\n#IE corresponds with only part of RM definition","eyal-22 Nov 2004, eyal-30 May 2004",91058,"2004-11-22");
INSERT INTO hebrew_synonyms VALUES (7583,"אִמֵּן","v","00565367","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"train, coach",NULL,"הוא אימן את הנבחרת והביא אותה להשגים גדולים","checked","#IE","eyal-23 Nov 2004",93741,"2004-11-23");
INSERT INTO hebrew_synonyms VALUES (652,"הֵכִיל","v","01796995","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"comprise, consist_of",NULL,"בית הכלא הישן הכיל כמה עשרות תאים צפופים","checked","#ASSIGN:57.0=[gnd=13.0,gnd=2.0E+01,si=24.0] #MZ@ #IE","eyal-15 May 2004, assign-6 Nov 2003",91059,"2004-05-15");
INSERT INTO hebrew_synonyms VALUES (653,"!הֶחְזִיר","v","01652221","y","melingo","4","rav-milim",NULL,"tg1",NULL,"reinstate, restore",NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,gnd=8.0,si=16.0,dfl=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (654,"!הֶחְזִיר","v","00554194","nn","melingo","7","rav-milim",NULL,"tg1","((literary))","reply",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-31 Jul 2004, assign-6 Nov 2003",0,"2004-07-31");
INSERT INTO hebrew_synonyms VALUES (655,"!הֶחְלִיף","v","01545633","y","melingo","1","rav-milim",NULL,"tg1",NULL,"exchange, swap",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (656,"!הֶמְשֵׁךְ","n","00657384","u","melingo","1","rav-milim",NULL,"tg1",NULL,"continuation, continuance",NULL,NULL,"checked","#ASSIGN:57.0=[gnd=2.0E+01,gnd=13.0,si=24.0] #MZ@\r\n#IE","eyal-09 Nov 2004, assign-6 Nov 2003",0,"2004-11-09");
INSERT INTO hebrew_synonyms VALUES (657,"!הֶסְכֵּם","n","05074858","undef","melingo","1","rav-milim",NULL,"tg1",NULL,"agreement, accord, pact",NULL,NULL,"checked","#ASSIGN:207.0=[gnd=1.0E+01,gnd=39.0,si=11.0,bt(dir)=39.0,bt(dir)=1.0E+01,bt(crs)=49.0,bt(dir)=39.0,bt(dir)=1.0E+01] #MZ@\r\n#NO הסכם is too general in Hebrew (''as contract'') and usually appears in compounds in this sense like in  חוזה שלום","ordan-12 Apr 2004, assign-6 Nov 2003",0,"2004-04-12");
INSERT INTO hebrew_synonyms VALUES (658,"!הֶסְכֵּם","n","10065762","y","melingo","1","rav-milim",NULL,"tg1",NULL,"agreement, accord, pact",NULL,NULL,"assigned","#ASSIGN:79.0=[gnd=7.0,gnd=1.0E+01,si=11.0,bt(dir)=6.0,bt(dir)=11.0,bt(crs)=17.0,bt(dir)=6.0,bt(dir)=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (659,"!הֶסְכֵּם","n","04466733","y","melingo","1","rav-milim",NULL,"tg1",NULL,"agreement, accord, pact",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=7.0,bt(dir)=6.0,bt(dir)=5.0,bt(crs)=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (661,"!הֶעֱבִיר","v","01429473","y","melingo","1","rav-milim",NULL,"tg1",NULL,"remove, transfer",NULL,NULL,"assigned","#ASSIGN:50=[gnd=6.0,gnd=4.0,si=7.0,bt(dir)=5.0,bt(dir)=5.0,dfl=23.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (662,"הֶעֱבִיר","v","01526289","yy","melingo","1.3","rav-milim","1.4","tg1",NULL,"pass",NULL,"העבר לי את המלח, בבקשה","checked","#ASSIGN:50=[gnd=2.0,bt(dir)=24.0,dfl=24.0] #MZ@ #IE","eyal-17 May 2004, assign-6 Nov 2003",91060,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (663,"הֶעֱרִיךְ","v","00459984","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"appraise, evaluate",NULL,"הוא העריך את שווי הרכב בכמה אלפי שקלים יותר ממחירו במחירון","checked","#ASSIGN:124.0=[gnd=2.0E+01,gnd=39.0,si=49.0,bt(dir)=8.0,bt(dir)=8.0] #MZ@\r\n#IE","eyal-10 May 2005, assign-6 Nov 2003",91061,"2005-05-10");
INSERT INTO hebrew_synonyms VALUES (664,"הֶעֱרִיךְ","v","00469237","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"value, respect",NULL,"אני מעריכה את כנותך, למרות המילים הקשות שהשמעת","checked","#ASSIGN:92.0=[gnd=8.0,gnd=2.0E+01,si=1.0E+01,bt(dir)=7.0,bt(dir)=11.0,bt(crs)=18.0,bt(dir)=7.0,bt(dir)=11.0] #MZ@\r\n#IE","eyal-31 Jul 2004",91061,"2004-07-31");
INSERT INTO hebrew_synonyms VALUES (665,"!הֶעֱרִיךְ","v","01544040","y","melingo","3","rav-milim",NULL,"tg1",NULL,"appreciate, value, respect",NULL,NULL,"assigned","#ASSIGN:92.0=[gnd=8.0,gnd=8.0,si=1.0E+01,bt(dir)=14.0,bt(dir)=8.0,bt(crs)=22.0,bt(dir)=14.0,bt(dir)=8.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (666,"!הֶעֱרִיךְ","v","00445269","y","melingo","3","rav-milim",NULL,"tg1",NULL,"appreciate, value, respect",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=8.0,bt(dir)=1.0E+01,bt(dir)=8.0,bt(crs)=18.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (667,"הֶפֶךְ","n","09984290","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"opposite, contrary",NULL,"חשבנו שהיא המבוגרת והוא הצעיר, אבל ההפך הוא הנכון","checked","#ASSIGN:50=[gnd=1.0E+01,gnd=13.0,si=16.0,dfl=11.0] #MZ@ #IE","eyal-15 Jun 2004, assign-6 Nov 2003",91062,"2004-06-15");
INSERT INTO hebrew_synonyms VALUES (668,"הֶקֵּף","n","03979387","yy","melingo","1.1","rav-milim","1.1","tg1","geometry","perimeter, circumference",NULL,NULL,"checked","#ASSIGN:57.0=[gnd=13.0,gnd=2.0E+01,si=24.0] #MZ@ #IE","eyal-24 May 2004, assign-6 Nov 2003",91063,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (669,"הֶקֵּף","n","10045533","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"extent, scope",NULL,"היקף הנזק היה רחב מאד","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-24 May 2004, assign-6 Nov 2003",91063,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (670,"!הֶקֵּף","n","06667120","y","melingo","2","rav-milim",NULL,"tg1",NULL,"extent, scope",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (671,"!הֶקֵּף","n","03991813","y","melingo","2","rav-milim",NULL,"tg1",NULL,"extent, scope",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6772,"כּוֹחַ-הַכְּבִידָה","n","07804383","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-26 May 2004",91064,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (674,"הֶרְכֵּב","n","06086825","yy","melingo","1.4","rav-milim","1.3","tg1","((music))","ensemble",NULL,NULL,"checked","#ASSIGN:57.0=[gnd=8.0,flc(dic)=49.0] #MZ@ #IE","eyal-25 May 2004, assign-6 Nov 2003",91065,"2004-05-25");
INSERT INTO hebrew_synonyms VALUES (675,"הַיּוֹם","r","00203867","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"today",NULL,"לא אוכל להיפגש איתך היום, כדאי שנקבע למחר","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-17 May 2004, assign-6 Nov 2003",91066,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (677,"הַיּוֹם","r","00047077","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"now, currently",NULL,NULL,"checked","#ASSIGN:27.0=[gnd=6.0,bt(dir)=21.0] #MZ@\r\n#NO","ordan-29 Dec 2004, assign-6 Nov 2003",91066,"2004-12-29");
INSERT INTO hebrew_synonyms VALUES (678,"!הַיּוֹם","r","00046870","y","melingo","2","rav-milim",NULL,"tg1",NULL,"now, currently",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (679,"הַכְנָסָה","n","00207301","yy","melingo","1.3","rav-milim","1.1","tg1",NULL,"insertion",NULL,"אנא דאג להכנסת כל האנשים פנימה מפני הגשם","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-18 Apr 2004, assign-6 Nov 2003",91067,"2004-04-18");
INSERT INTO hebrew_synonyms VALUES (680,"!הַכְנָסָה","n","09542885","y","melingo","1","rav-milim",NULL,"tg2",NULL,"income, revenue",NULL,NULL,"assigned","#ASSIGN:106.0=[gnd=2.0E+01,bt(dir)=26.0,bt(dir)=17.0,bt(crs)=43.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6608,"פוֹבְּיָה","n","10318432","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-14 Apr 2004",91068,"2004-04-14");
INSERT INTO hebrew_synonyms VALUES (682,"הַכְנָסָה","n","09538207","yy","melingo","2.1","rav-milim","2.1","tg2",NULL,"income",NULL,"הכנסתו החודשית אינה מספיקה לפרנסת משפחתו","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE","eyal-18 Apr 2004, assign-6 Nov 2003",91067,"2004-04-18");
INSERT INTO hebrew_synonyms VALUES (683,"!הַנְהָלָה","n","06201180","y","melingo","1","rav-milim",NULL,"tg1",NULL,"management, administration",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (684,"!הַנְהָלָה","n","00734610","y","melingo","1","rav-milim",NULL,"tg1",NULL,"management, administration",NULL,NULL,"assigned","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (685,"!הַעֲרָכָה","n","04428566","u","melingo","2","rav-milim",NULL,"tg1",NULL,"evaluation",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE I think the word ''ha\'aracha'' is more suitable for the synset of ''estimation'', but I have doubts","eyal-02 May 2004, assign-6 Nov 2003",0,"2004-05-02");
INSERT INTO hebrew_synonyms VALUES (686,"!הַעֲרָכָה","n","00561814","y","melingo","2","rav-milim",NULL,"tg1",NULL,"evaluation",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (687,"!הַצָּגָה","n","05391158","y","melingo","3","rav-milim",NULL,"tg1",NULL,"presentation",NULL,NULL,"assigned","#ASSIGN:50=[gnd=7.0,bt(dir)=6.0,bt(dir)=6.0,bt(crs)=12.0,dfl=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (688,"הַצָּעָה","n","05355488","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"proposal",NULL,"הוא הגיש להם את ההצעה שלו לתכנון הבניין","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-26 Apr 2004, assign-6 Nov 2003",91069,"2004-04-26");
INSERT INTO hebrew_synonyms VALUES (689,"הַצָּעַת-נִשּׂוּאִין","n","05355200","yy","none",NULL,"none",NULL,"tg1",NULL,"proposal",NULL,"הצעת הנישואין שקיבלה היתה מרגשת במיוחד","checked","#ASSIGN:53.0=[gnd=13.0,bt(dir)=9.0,bt(dir)=11.0,bt(crs)=2.0E+01] #MZ@ #IE this combination of words did not appear in any dictionary, but since it is frequently used, I think it should appear as it is.","eyal-26 Apr 2004, assign-6 Nov 2003",91070,"2004-04-26");
INSERT INTO hebrew_synonyms VALUES (690,"הַצָּעָה","n","05355066","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"proposal",NULL,"הם הקשיבו בעניין רב להצעתה","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-26 Apr 2004, assign-6 Nov 2003",91069,"2004-04-26");
INSERT INTO hebrew_synonyms VALUES (691,"!הַצָּעָה","n","05370271","y","melingo","3","rav-milim",NULL,"tg1",NULL,"offer",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (692,"!הַצָּעָה","n","05357635","y","melingo","3","rav-milim",NULL,"tg1",NULL,"offer",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6673,"GAP!","n","00504966","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE I could not find any equivalent in Hebrew. ","eyal-26 Apr 2004",90808,"2004-04-26");
INSERT INTO hebrew_synonyms VALUES (694,"הַר","n","06711088","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"mountain",NULL,"הר מירון הוא ההר הגבוה ביותר בארץ ישראל","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE","eyal-26 May 2004, assign-6 Nov 2003",91071,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (7876,"סְפֶּצִיפִית","r","00039677","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"specifically",NULL,"הוא מתעניין ספציפית בנחשים ארסיים","checked","#IE","eyal-23 Dec 2004",93930,"2004-12-23");
INSERT INTO hebrew_synonyms VALUES (6648,"מְאוֹד-מְאוֹד","r","00057204","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,"זה היה מאוד מאוד מתחשב מצִּדה","checked","#NO","ordan-19 Apr 2004",91073,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (697,"הַשְׁקָעָה","n","09599330","yy","melingo","1.1","rav-milim","<1.1","tg1",NULL,"investment",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-04 May 2004, assign-6 Nov 2003",91074,"2004-05-04");
INSERT INTO hebrew_synonyms VALUES (698,"!הַשְׁקָעָה","n","00984974","y","melingo","1","rav-milim",NULL,"tg1",NULL,"investment",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (699,"הַשְׁקָעָה","n","00712429","yy","melingo","1.1","rav-milim","<1.1","tg1",NULL,"investment",NULL,"השקעה במחקר ופיתוח היא אבן יסוד לצמיחה כלכלית","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-04 May 2004",91074,"2004-05-04");
INSERT INTO hebrew_synonyms VALUES (700,"הַשְׁקָעָה","n","05484185","yy","melingo","2.1","sapir","1.2","tg2",NULL,"submerging",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE WN definition refers only to ''submerging in water'' whereas it should be any liquid.","eyal-04 May 2004",91074,"2004-05-04");
INSERT INTO hebrew_synonyms VALUES (701,"הָפַךְ","v","01791776","yy","melingo","1.3","rav-milim","1.4","tg1",NULL,"become",NULL,"המים הפכו לקרח","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-15 May 2004, assign-6 Nov 2003",91075,"2004-05-15");
INSERT INTO hebrew_synonyms VALUES (702,"!הוֹבִיל","v","00015408","y","melingo","2","rav-milim",NULL,"tg1",NULL,"lead_to, bring_to",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (703,"!הוֹדָעָה","n","04949838","y","melingo","1","rav-milim",NULL,"tg1",NULL,"notice_(noun), message, proclamation",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (704,"הוֹדָעָה","n","04729537","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"message",NULL,"הוא השאיר לי הודעה קצרה במשיבון","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-10 Jun 2004, assign-6 Nov 2003",91076,"2004-06-10");
INSERT INTO hebrew_synonyms VALUES (705,"!הוֹדָעָה","n","05043361","u","melingo","1","rav-milim",NULL,"tg1",NULL,"notice_(noun), message, proclamation",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE I think הכרזה fits more.","eyal-13 Jun 2004, assign-6 Nov 2003",0,"2004-06-13");
INSERT INTO hebrew_synonyms VALUES (706,"הוֹדָעָה","n","05388391","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"notification",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-23 Nov 2004, assign-6 Nov 2003",91076,"2004-11-23");
INSERT INTO hebrew_synonyms VALUES (707,"!הוֹדָעָה","n","05370646","u","melingo","2","rav-milim",NULL,"tg1",NULL,"notification",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE I think הודעה לתשלום fits more, although it does not exist in RM","eyal-13 Jun 2004, assign-6 Nov 2003",0,"2004-06-13");
INSERT INTO hebrew_synonyms VALUES (708,"!הוֹדָעָה","n","00768438","y","melingo","2","rav-milim",NULL,"tg1",NULL,"notification",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (709,"הוֹכִיחַ","v","00559552","u","melingo","1.1","rav-milim","1.1","tg1","((literary))","rebuke",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE I think הוכיח fits better to v#00559253 or v#00559117","eyal-01 Aug 2004",91077,"2004-08-01");
INSERT INTO hebrew_synonyms VALUES (710,"!הוֹפִיעַ","v","01368651","y","melingo","2","rav-milim",NULL,"tg1",NULL,"come, arrive, turn_up",NULL,NULL,"assigned","#ASSIGN:26.0=[gnd=2.0,gnd=2.0E+01,si=4.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (711,"!הוֹפָעָה","n","00487065","y","melingo","1","rav-milim",NULL,"tg1",NULL,"appearance, showing_up",NULL,NULL,"assigned","#ASSIGN:50=[gnd=7.0,bt(dir)=6.0,bt(dir)=9.0,bt(crs)=15.0,dfl=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (712,"!הוֹפָעָה","n","00487065","y","melingo","2","rav-milim",NULL,"tg1",NULL,"appearance, performance",NULL,NULL,"assigned","#ASSIGN:50=[gnd=7.0,bt(dir)=6.0,bt(dir)=9.0,bt(crs)=15.0,dfl=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (713,"!הוֹצִיא","v","01007120","y","melingo","2","rav-milim",NULL,"tg1",NULL,"expel, eject",NULL,NULL,"assigned","#ASSIGN:32.0=[gnd=8.0,gnd=1.0E+01,si=14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (714,"!הוֹצִיא","v","00071198","u","melingo","2","rav-milim",NULL,"tg1",NULL,"expel, eject",NULL,NULL,"checked","#ASSIGN:32.0=[gnd=8.0,gnd=1.0E+01,si=14.0] #MZ@\r\n#IE הוציא is too general","eyal-29 Jul 2004, assign-6 Nov 2003",0,"2004-07-29");
INSERT INTO hebrew_synonyms VALUES (715,"הוֹצָאָה","n","09552872","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"expenditure, outlay",NULL,"גידול ילדים כרוך בהוצאות עצומות","checked","#ASSIGN:79.0=[gnd=13.0,gnd=2.0E+01,si=14.0,bt(dir)=16.0,bt(dir)=16.0] #MZ@ #IE","eyal-19 Apr 2004, assign-6 Nov 2003",91078,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (716,"הוֹצָאָה","n","00726534","yy","melingo","1.2","none",NULL,"tg1",NULL,"expenditure",NULL,"נסיעה לחו''ל כרוכה בהוצאת כספים רבים","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE both Sapir and RM explain ''hotza\'ah'', not as the act of spending money, but rather as the money spent. The verb ''hotzi'', however, in its 7th meaning, is explained as to spend money.","eyal-19 Apr 2004, assign-6 Nov 2003",91078,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (717,"!הוֹצָאָה","n","00229211","y","melingo","2","rav-milim",NULL,"tg1",NULL,"expense, expenditure, outlay",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (718,"!הוֹצָאָה","n","09554991","y","melingo","2","rav-milim",NULL,"tg1",NULL,"expense, expenditure, outlay",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (719,"!הוֹצָאָה","n","09553033","y","melingo","2","rav-milim",NULL,"tg1",NULL,"expense, expenditure, outlay",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (720,"!הוֹצָאָה","n","05522555","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"expense, expenditure, outlay",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE not the correct word","eyal-19 Apr 2004, assign-6 Nov 2003",0,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (721,"הוֹצָאָה","n","06009454","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"publishing_house",NULL,"הספר יצא בהוצאת עם עובד","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE a common abbreviation for ''bet hotza\'ah)","eyal-19 Apr 2004",91078,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (722,"הוֹרִיד","v","00032369","yy","melingo","1.6","rav-milim","1.7","tg1","((colloquial))","lose_weight",NULL,"בזמן המחלה הוא הוריד 8 קילו ממשקלו","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-01 Jun 2004, assign-6 Nov 2003",91079,"2004-06-01");
INSERT INTO hebrew_synonyms VALUES (723,"הוֹרִיד","v","01527871","yy","melingo","1.8","rav-milim","1.9","tg1","((computing))","download",NULL,"הורדתי כמה משחקים מהאינטרנט","checked","#ASSIGN:88.0=[gnd=39.0,flc(dic)=49.0] #MZ@ #IE","eyal-01 Jun 2004, assign-6 Nov 2003",91079,"2004-06-01");
INSERT INTO hebrew_synonyms VALUES (724,"!הוֹרָאָה","n","00570118","y","melingo","1","rav-milim",NULL,"tg1",NULL,"teaching, instruction, pedagogy",NULL,NULL,"assigned","#ASSIGN:108.0=[gnd=13.0,gnd=1.0E+01,gnd=2.0E+01,si=29.0,bt(dir)=12.0,bt(dir)=12.0,bt(dir)=12.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (725,"!הוֹרָאָה","n","00567704","y","melingo","1","rav-milim",NULL,"tg1",NULL,"teaching, instruction, pedagogy",NULL,NULL,"assigned","#ASSIGN:96.0=[gnd=13.0,gnd=1.0E+01,gnd=2.0E+01,si=29.0,bt(dir)=8.0,bt(dir)=8.0,bt(dir)=8.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (726,"!הוֹרָאָה","n","04941372","y","melingo","2","rav-milim",NULL,"tg1",NULL,"order, command, instruction",NULL,NULL,"assigned","#ASSIGN:37.0=[gnd=6.0,gnd=1.0E+01,si=5.0,bt(dir)=8.0,bt(dir)=8.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (727,"וַעֲדָה","n","06172564","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"committee",NULL,"משרד החינוך מינה ועדה מיוחדת לעסוק בהישגים הנמוכים של תלמידי חטיבת הביניים","checked","#ASSIGN:98.0=[gnd=2.0E+01,gnd=4.0,si=5.0,bt(dir)=19.0,bt(dir)=4.0,bt(crs)=23.0,bt(dir)=19.0,bt(dir)=4.0] #MZ@\r\n#NO","ordan-07 May 2004, assign-6 Nov 2003",91080,"2004-05-07");
INSERT INTO hebrew_synonyms VALUES (728,"!וַעֲדָה","n","06173732","y","melingo","1","rav-milim",NULL,"tg1",NULL,"committee, board, commission",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (729,"וָתִיק","a","01585161","yy","melingo","1.1","rav-milim",">1.1","tg1",NULL,"aged, elderly, older, senior",NULL,"ותיקי המקום מספרים על השממה ששררה לפני שהתיישבו כאן","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO combining senses 1.1 and 1.3 in RM, also look at Even-Shushan 1.1","ordan-16 Feb 2004",91081,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (730,"!וָתִיק","a","00962311","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"senior, veteran",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","ordan-16 Feb 2004, assign-6 Nov 2003",0,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (731,"!וָתִיק","a","02025056","u","melingo","1","rav-milim",NULL,"tg1",NULL,"senior, veteran",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","ordan-16 Feb 2004, assign-6 Nov 2003",0,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (732,"!זְכוּת","n","04033272","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"right, prerogative",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,bt(dir)=5.0,dfl=6.0] #MZ@\r\n#NO too general","ordan-11 May 2004, assign-6 Nov 2003",0,"2004-05-11");
INSERT INTO hebrew_synonyms VALUES (733,"זְמַן","n","04776611","yy","melingo","1.3","rav-milim","1.7","tg1",NULL,"tense",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,flc(dic)=49.0] #MZ@\r\n#NO","ordan-13 May 2004, assign-6 Nov 2003",91082,"2004-05-13");
INSERT INTO hebrew_synonyms VALUES (734,"זֵכֶר","n","04984599","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"trace, vestige, shadow",NULL,"לאחר המלחמה לא נשאר זכר מהכפר בו נולדתי","checked","#ASSIGN:61.0=[gnd=8.0,gnd=39.0,si=14.0] #MZ@\r\n#NO","ordan-13 May 2004",91083,"2004-05-13");
INSERT INTO hebrew_synonyms VALUES (735,"זֵר","n","03634464","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"wreath, garland",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO \'bouquet\' is restricted for presents in WN, the Hebrew sense of זר subsumes both, and סידור פרחים should better be matched with \'flower-arrangement\'","ordan-10 May 2004",91084,"2004-05-10");
INSERT INTO hebrew_synonyms VALUES (6696,"בְּהִירוּת","n","03779450","yy","melingo",">1.2","rav-milim","1.3",NULL,NULL,"clarity, lucidity",NULL,"הבהירות של הסבריו ניכרה אפילו בתחומים קשים במיוחד להבנה","checked","#NO","ordan-11 May 2004",91085,"2004-05-11");
INSERT INTO hebrew_synonyms VALUES (6733,"לָקַח-בְּחֶשְׁבּוֹן","v","00490373","yy","none",NULL,"rav-milim","1.1",NULL,NULL,"allow, take_into_account",NULL,"התופרת לקחה בחשבון שהבגד יתכווץ ב-5 אחוזים לאחר הכביסה הראשונה","checked","#NO","ordan-22 May 2004",91086,"2004-05-22");
INSERT INTO hebrew_synonyms VALUES (6488,"גֶּבֶר","n","07391044","yy","melingo","2","rav-milim","1.1",NULL,NULL,"man",NULL,NULL,"checked","#IE","eyal-01 Mar 2004",91017,"2004-03-01");
INSERT INTO hebrew_synonyms VALUES (740,"!זָר","n","07273655","y","melingo","1","rav-milim",NULL,"tg1",NULL,"stranger, outsider",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (741,"!זָר","n","07614356","y","melingo","1","rav-milim",NULL,"tg1",NULL,"stranger, outsider",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6732,"אָלֶכְּסָנְדֶר-בֶּל","n","07700121","yy","none",NULL,"none",NULL,NULL,NULL,"Bell, Alexander_Bell, Alexander_Graham_Bell",NULL,NULL,"checked","#NO","ordan-22 May 2004",91087,"2004-05-22");
INSERT INTO hebrew_synonyms VALUES (743,"זוּג","n","09895669","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"pair",NULL,"זוג גרביים","checked","#ASSIGN:50=[gnd=1.0E+01,bt(dir)=8.0,bt(dir)=1.0E+01,bt(crs)=18.0,dfl=4.0] #MZ@\r\n#NO","ordan-21 May 2004",91088,"2004-05-21");
INSERT INTO hebrew_synonyms VALUES (745,"זוּג","n","05982753","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"couple",NULL,"הם כמו זוג משמיים, אוהבים אחד את השני ואף פעם לא רבים","checked","#ASSIGN:68.0=[gnd=8.0,gnd=2.0E+01,si=2.0E+01,bt(dir)=1.0E+01,bt(dir)=1.0E+01] #MZ@\r\n#NO","ordan-21 May 2004",91088,"2004-05-21");
INSERT INTO hebrew_synonyms VALUES (746,"חֲבֵרוּת","n","10038317","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"friendship",NULL,"למרות שהם מאוד שונים אחד מהשני, יש ביניהם חברות אמיצה העומדת במבחן הזמן","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-06 Jun 2004",91089,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (747,"!חֲבֵרוּת","n","05608483","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"affection, closeness",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-06 Jun 2004, assign-6 Nov 2003",0,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (748,"!חֲקִירָה","n","05376578","y","melingo","1","rav-milim",NULL,"tg1",NULL,"investigation, inquiry",NULL,NULL,"assigned","#ASSIGN:101.0=[gnd=13.0,bt(dir)=11.0,bt(dir)=33.0,bt(crs)=44.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (749,"!חֲקִירָה","n","04467719","y","melingo","1","rav-milim",NULL,"tg1",NULL,"investigation, inquiry",NULL,NULL,"assigned","#ASSIGN:81.0=[gnd=13.0,bt(dir)=13.0,bt(dir)=21.0,bt(crs)=34.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (750,"חֲקִירָה","n","00418126","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"inquiry",NULL,"החשוד נעצר על ידי המשטרה וישוחרר, כנראה, לאחר תום החקירה","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-07 Apr 2004, assign-6 Nov 2003",91090,"2004-04-07");
INSERT INTO hebrew_synonyms VALUES (751,"חֲקִירָה","n","04470360","yy","melingo","1.1","none",NULL,"tg1",NULL,"investigation",NULL,"לאחר המחדל האחרון, מינתה הממשלה ועדה חיצונית לחקירת העניין","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO Although it doesn\'t appear in RM, i think it justifies another sense in Hebrew, think especially of ועדת חקירה","ordan-23 May 2004",91090,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (752,"חֲקִירָה","n","00416938","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"investigation",NULL,"לאחר חקירה ראשונית נסגר התיק מחוסר ראיות","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-23 May 2004",91090,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (753,"!חֲקִירָה","n","04467719","y","melingo","2","rav-milim",NULL,"tg1",NULL,"research, analysis",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=2.0E+01,bt(dir)=13.0,bt(dir)=21.0,bt(crs)=34.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (755,"!חֲשָׁשׁ","n","05593817","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"fear, concern, worry",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO almost, but maybe better fits n#05594044","ordan-28 May 2004",0,"2004-05-28");
INSERT INTO hebrew_synonyms VALUES (756,"!חֲשָׁשׁ","n","04491326","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"fear, concern, worry",NULL,NULL,"checked","#ASSIGN:84.0=[gnd=8.0,gnd=2.0E+01,si=14.0,bt(dir)=21.0,bt(dir)=21.0] #MZ@\r\n#NO doesn\'t denote the ORIGIN of this condition","ordan-28 May 2004, assign-6 Nov 2003",0,"2004-05-28");
INSERT INTO hebrew_synonyms VALUES (757,"חֲשָׁשׁ","n","05594044","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"fear, concern",NULL,"הם השתיקו את העניין בשל חשש מתגובת הציבור","checked","#ASSIGN:42.0=[gnd=2.0E+01,gnd=8.0,si=14.0] #MZ@\r\n#NO","ordan-28 May 2004, assign-6 Nov 2003",91091,"2004-05-28");
INSERT INTO hebrew_synonyms VALUES (758,"חִיֵּב","v","01707058","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"coerce, pressure, force",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-27 May 2004, assign-6 Nov 2003",91092,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (6784,"הִצְרִיךְ","v","01792695","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-27 May 2004",91093,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (760,"חִיֵּב","v","01549907","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"debit",NULL,"חשבון הבנק שלי מחויב בהוראת קבע לתשלום הוצאות הטלפון","checked","#ASSIGN:63.0=[gnd=39.0,flc(dic)=24.0] #MZ@\r\n#NO","ordan-27 May 2004",91092,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (6781,"הִרְשִׁיעַ","v","00613686","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"convict",NULL,"בית המשפט הרשיע אותו וגזר עליו מאסר","checked","#NO","ordan-27 May 2004",91094,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (763,"חִלֵּק","v","01568792","yy","none",NULL,"rav-milim","1.4","tg1",NULL,"share, divvy_up, portion_out, apportion, deal",NULL,"טוב, ערבבת מספיק, אתה יכול לחלק את הקלפים","checked","#ASSIGN:28.0=[gnd=8.0,bt(dir)=7.0,bt(dir)=3.0,bt(crs)=1.0E+01] #MZ@\r\n#NO","ordan-27 May 2004, assign-6 Nov 2003",91095,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (764,"!חִנּוּךְ","n","06059102","y","melingo","1","rav-milim",NULL,"tg1",NULL,"education",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (765,"חִפֵּשׂ","v","00898737","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"search, seek, look_for",NULL,"כמה שלא חיפשתי את הארנק, לשווא, אי אפשר היה למצוא אותו","checked","#ASSIGN:50=[gnd=8.0,gnd=2.0E+01,si=16.0,dfl=6.0] #MZ@\r\n#NO","ordan-21 Jun 2004, assign-6 Nov 2003",91096,"2004-06-21");
INSERT INTO hebrew_synonyms VALUES (766,"מַזָּל","n","10381983","yy","melingo","2","rav-milim","1.2","tg1",NULL,"fortune, luck, lot",NULL,"בזמן האחרון מזלו לא האיר לו פנים","checked","#ASSIGN:31.0=[gnd=7.0,bt(dir)=6.0,bt(dir)=6.0,bt(crs)=12.0] #MZ@ #IE","eyal-15 Mar 2004, assign-6 Nov 2003",91097,"2004-03-15");
INSERT INTO hebrew_synonyms VALUES (767,"!חֵלֶק","n","09945970","y","melingo","1","rav-milim",NULL,"tg1",NULL,"part, portion",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=3.0,gnd=7.0,si=7.0,bt(dir)=3.0,bt(dir)=6.0,bt(crs)=9.0,bt(dir)=3.0,bt(dir)=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (768,"חֵלֶק","n","09561632","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"share, portion",NULL,"השודדים נאבקו על השלל, כל אחד תובע את חלקו","checked","#ASSIGN:167.0=[gnd=3.0,gnd=7.0,si=7.0,bt(dir)=7.0,bt(dir)=5.0,bt(dir)=3.0,bt(dir)=15.0,bt(crs)=9.0E+01,bt(dir)=7.0,bt(dir)=5.0,bt(dir)=3.0,bt(dir)=15.0] #MZ@\r\n#NO appear in RM in the end, in declension (חלקו)\r\n","ordan-24 May 2004",91098,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (769,"חֵלֶק","n","03090721","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"part, portion",NULL,"החלק האחורי של הבית","checked","#ASSIGN:47.0=[gnd=3.0,gnd=7.0,si=7.0,bt(dir)=4.0,bt(dir)=6.0,bt(crs)=1.0E+01,bt(dir)=4.0,bt(dir)=6.0] #MZ@\r\n#NO this is supposed to part of an artefact (as opposed to part of a natural object - n#06684175)","ordan-24 May 2004",91098,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (771,"חֵלֶק","n","00504440","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"contribution, part, share",NULL,"הוא עשה את חלקו במאמץ המשותף","checked","#ASSIGN:27.0=[gnd=3.0,bt(dir)=3.0,bt(dir)=9.0,bt(crs)=12.0] #MZ@\r\n#NO in RM it appear in the end, in the declension of חלקו","ordan-24 May 2004, assign-6 Nov 2003",91098,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (6865,"בְּצַוְתָּא","n","10037091","yy","none",NULL,"rav-milim","1.1",NULL,NULL,NULL,NULL,"הבוקר בילינו אחי ואני בצוותא","checked","#NO","ordan-22 Jun 2004",91099,"2004-06-22");
INSERT INTO hebrew_synonyms VALUES (6867,"חַמָּנִיָּה","n","08285778","yy","melingo","1.1","rav-milim","1.1",NULL,"colloquial",NULL,NULL,NULL,"revised","#NO","eyal-23 Aug 2004, ordan-24 Jun 2004",91100,"2004-08-23");
INSERT INTO hebrew_synonyms VALUES (775,"!חֶדֶר","n","04263179","y","melingo","3","rav-milim",NULL,"tg1","((anatomy))","ventricle",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,flc(dic)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (776,"חֶדֶר","n","04190682","yy","melingo","1.3","rav-milim","1.5","tg1",NULL,"ventricle",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,flc(dic)=24.0] #MZ@\r\n#NO","ordan-26 May 2004, assign-6 Nov 2003",91101,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (6765,"מָתֶמָטִיקָה","n","04597590","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"mathematics, math, maths",NULL,NULL,"checked","#NO","ordan-24 May 2004",91102,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (778,"חֶשְׁבּוֹן","n","04598167","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"arithmetic",NULL,"הילדים למדו את לוח הכפל בשיעור חשבון","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-24 May 2004",91103,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (779,"חֶשְׁבּוֹן","n","09619552","yy","melingo","1.4","rav-milim","1.4","tg1",NULL,"bank_account",NULL,"העברתי את חשבוני לבנק אחר, מאחר שהם הציעו לי תנאי משכנתא טובים יותר","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-24 Jun 2004",91103,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (780,"חַי","a","02170020","yy","melingo","2.2","rav-milim","2.2","tg1",NULL,"vivacious",NULL,NULL,"revised","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","eyal-14 Aug 2004, ordan-22 May 2004",91104,"2004-08-14");
INSERT INTO hebrew_synonyms VALUES (781,"חַי","n","00002086","yy","melingo","3.1","rav-milim","3.1","tg1",NULL,"life_form, organism, being, living_thing",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-22 May 2004, assign-6 Nov 2003",91105,"2004-05-22");
INSERT INTO hebrew_synonyms VALUES (6735,"בַּעַל-חַיִּים","n","00008019","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"animal",NULL,NULL,"revised","#NO","ordan-07 May 2005, eyal-15 Aug 2004, ordan-22 May 2004",91106,"2005-05-07");
INSERT INTO hebrew_synonyms VALUES (8541,"אַרְטִיפָקְט","n","00011937","yy","none",NULL,"none",NULL,NULL,NULL,"artifact, artefact",NULL,NULL,"checked","#NO many hits on google.co.il","ordan-07 May 2005",94939,"2005-05-07");
INSERT INTO hebrew_synonyms VALUES (783,"סִגְנוֹן-חַיִּים","n","03857935","yy","none",NULL,"none",NULL,"tg1",NULL,"life-style, lifestyle",NULL,"יש לו סגנון חיים פרוע וחסר אחריות, אבל אולי זה הגיל","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO note that it\'s not אורח חיים, which has more to do with the conditions under which people live","ordan-26 May 2004",91107,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (784,"!חַיָּב","a","01558954","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"obliged, required, bound",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO better apt for a#01558226, מצווה has the moral tone of \'duty-bound\'","ordan-23 May 2004, assign-6 Nov 2003",0,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (785,"!חַיָּב","a","00857047","nn","melingo","3","rav-milim",NULL,"tg1",NULL,"must",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO note, this is an adjective!","ordan-23 May 2004, assign-6 Nov 2003",0,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (6741,"מְגֻנֶּה","a","01268661","yy","none",NULL,"rav-milim","1.1",NULL,NULL,"blameworthy, blamable, blameable, blameful",NULL,"זו התנהגות מגונה, שמקומה לא יכירנה בחברה מהוגנת","checked","#NO RM puts a much too ''mild'' definition to this word","ordan-23 May 2004",91108,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (787,"חַיָּב","n","07205503","yy","melingo","3.1","rav-milim","3.1","tg1",NULL,"debtor",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-23 May 2004, assign-6 Nov 2003",91109,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (788,"!חַשָּׁב","n","07058678","y","melingo","1","rav-milim",NULL,"tg1",NULL,"accountant",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (789,"!חַתָּם","n","07344725","y","melingo","1","rav-milim",NULL,"tg1","((insurance))","underwriter",NULL,NULL,"assigned","#ASSIGN:63.0=[gnd=39.0,flc(dic)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (8857,"GAP!","a","00280184","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE the selction of lemmas is not logical: anti-semitic and anti-black cannot be in the same synset","-27 Jul 2005",91389,"2005-07-27");
INSERT INTO hebrew_synonyms VALUES (791,"!חָבֵר","n","06997421","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"friend, companion",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-14 Jul 2004, assign-6 Nov 2003",0,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (8856,"GAP!","a","00174431","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE no equivalent in Hebrew","eyal-27 Jul 2005",91389,"2005-07-27");
INSERT INTO hebrew_synonyms VALUES (793,"!חָבֵר","n","07626109","y","melingo","2","rav-milim",NULL,"tg1",NULL,"partner, companion, steady",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (8855,"חֲבֵרָה","n","H0004070","yy","none",NULL,"none",NULL,NULL,NULL,NULL,NULL,"החברות הטובות שלי יודעות עלי הכל","checked","#IE","eyal-20 Jul 2005",95213,"2005-07-20");
INSERT INTO hebrew_synonyms VALUES (8852,"GAP!","n","07174252","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE","eyal-20 Jul 2005",90808,"2005-07-20");
INSERT INTO hebrew_synonyms VALUES (796,"חָזַר","v","01180029","yy","melingo","1.4","rav-milim","1.4","tg1",NULL,"rehearse",NULL,"כדאי לך לחזור שוב על הנקודות העיקריות לפני הרצאתך","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-21 Jun 2004, assign-6 Nov 2003",91110,"2004-06-21");
INSERT INTO hebrew_synonyms VALUES (797,"חָזָק","r","00336979","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"forcefully",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-21 Jun 2004, assign-6 Nov 2003",91111,"2004-06-21");
INSERT INTO hebrew_synonyms VALUES (798,"חָלָק","a","00765440","yw","melingo","1.4","rav-milim","1.4","tg1",NULL,"straightforward, uncomplicated, uneventful",NULL,"הנסיעה היתה חלקה","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO although it appears in RM, I think that it\'s an adverb not an adjective in Hebrew. Try to a feminie declension, and see that it doesn\'t work","eyal-10 Jul 2005, ordan-24 Jun 2004, assign-6 Nov 2003",91112,"2005-07-10");
INSERT INTO hebrew_synonyms VALUES (799,"!חָלָק","a","00646675","y","melingo","5","rav-milim",NULL,"tg1",NULL,"unmarred, pristine, unspoiled",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (800,"חָלוּץ","n","07477849","n","melingo","1.1","rav-milim","1.1","tg1",NULL,"pioneer",NULL,"איינשטיין נחשב החשוב שבחלוצי הפיזיקה המודרנית","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO\r\n#IE gender","eyal-17 Jul 2005, ordan-23 May 2004",0,"2005-07-17");
INSERT INTO hebrew_synonyms VALUES (801,"חָלוּץ","n","07477623","n","melingo","1.1","rav-milim","1.3","tg1",NULL,"pioneer",NULL,"החלוצים שהגיעו לאמריקה ראו בתושבים הילידים של המקום אויבים","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO i disagree with RM\'s Israeli-exclusive interpretation of this word (for making it such, one has to use the definite article)\r\n#IE gender","eyal-17 Jul 2005, ordan-23 May 2004",0,"2005-07-17");
INSERT INTO hebrew_synonyms VALUES (802,"חֵיל-חָלוּץ","n","06097782","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"vanguard, van",NULL,NULL,"checked","#ASSIGN:62.0=[gnd=13.0,flc(dic)=49.0] #MZ@\r\n#NO","ordan-23 May 2004, assign-6 Nov 2003",91114,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (803,"!חָלוּץ","n","07275269","y","melingo","3","rav-milim",NULL,"tg1","((sport))","striker, forward",NULL,NULL,"assigned","#ASSIGN:68.0=[gnd=2.0E+01,flc(dic)=24.0,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (804,"!חָלוּץ","n","00466114","y","melingo","3","rav-milim",NULL,"tg1","((sport))","striker, forward",NULL,NULL,"assigned","#ASSIGN:68.0=[gnd=2.0E+01,flc(dic)=24.0,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (805,"!חָלוּץ","n","07616532","y","melingo","3","rav-milim",NULL,"tg1","((sport))","striker, forward",NULL,NULL,"assigned","#ASSIGN:59.0=[gnd=1.0E+01,flc(dic)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (806,"חָסֵר","a","01775769","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"missing",NULL,"גיבורי הרומן הזה שטחיים מדי, חסר בספר פיתוח של הדמויות","revised","#ASSIGN:64.0=[gnd=2.0E+01,gnd=2.0E+01,si=24.0] #MZ@\r\n#NO","eyal-12 Aug 2004, ordan-22 May 2004",91115,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (807,"חָסֵר","a","00053941","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"deficient, wanting, lacking",NULL,"הוא לוקח את עצמו ברצינות יתרה, חסר לו הומור עצמי","checked","#ASSIGN:9.0E+01=[gnd=13.0,gnd=2.0E+01,gnd=2.0E+01,si=37.0] #MZ@\r\n#NO","ordan-22 May 2004, assign-6 Nov 2003",91115,"2004-05-22");
INSERT INTO hebrew_synonyms VALUES (6734,"מִינוּס","a","01749437","yy",NULL,NULL,"rav-milim","2.4",NULL,NULL,"minus",NULL,"קר עכשיו בשיקגו, מינוס 20 מעלות","checked","#NO it seems that in English the meaning is more general; I have therefore narrowed down its definition","ordan-22 May 2004",91116,"2004-05-22");
INSERT INTO hebrew_synonyms VALUES (809,"!חָפְשִׁי","a","01359458","y","melingo","1","rav-milim",NULL,"tg1",NULL,"free, unrestricted, untrammeled",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (810,"חָפְשִׁי","a","01647723","yy","melingo","1.4","rav-milim","1.5","tg1",NULL,"costless, free, gratis",NULL,NULL,"checked","#ASSIGN:50=[gnd=3.0,gnd=13.0,si=7.0,bt(dir)=4.0,bt(dir)=4.0,dfl=19.0] #MZ@\r\n#NO","ordan-23 May 2004",91117,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (811,"חָפְשִׁי","a","01010992","yy","melingo","1.5","rav-milim","1.8","tg1",NULL,"free_of",NULL,"לאחר שסיים את חוק לימודיו, הרגיש חופשי מדאגות","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-24 Jun 2004, assign-6 Nov 2003",91117,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (812,"חָפְשִׁי","r","00207028","yy","melingo","1.9","rav-milim","1.11","tg1",NULL,"freely",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-23 May 2004, assign-6 Nov 2003",91118,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (813,"חָשַׁב","v","00695551","nn","melingo","1.2","rav-milim","1.2","tg1",NULL,"opine",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO חשב doesn\'t necessitate expressing the opinion","ordan-27 May 2004, assign-6 Nov 2003",91119,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (814,"חָשַׁב","v","00428091","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"assume, presume",NULL,NULL,"checked","#ASSIGN:54.0=[gnd=4.0,gnd=39.0,si=11.0] #MZ@\r\n#NO","ordan-27 May 2004, assign-6 Nov 2003",91119,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (815,"חָשַׁב","v","01123253","yy","melingo","1.8","rav-milim","1.9","tg1",NULL,"think_up",NULL,"הוא חשב על רעיון גאוני להתעשר","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-18 Dec 2004, ordan-27 May 2004, assign-6 Nov 2003",91119,"2004-12-18");
INSERT INTO hebrew_synonyms VALUES (817,"חָשׁוּב","a","01758782","yy","melingo","1.2","rav-milim",">1.2","tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-23 May 2004, assign-6 Nov 2003",91120,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (818,"חָתַם","v","00337013","y","melingo","3","rav-milim","1.4","tg1",NULL,"complete, finish",NULL,"הרץ האחרון הגיע לנקודת הסיום ובכך חתם את המירוץ","checked","#ASSIGN:50=[gnd=8.0,gnd=7.0,si=1.0E+01,dfl=25.0] #MZ@ #IE not frequently used","eyal-21 Mar 2004, assign-6 Nov 2003",91121,"2004-03-21");
INSERT INTO hebrew_synonyms VALUES (819,"חָתַם","v","01513073","yy","melingo","1.4","rav-milim","1.5","tg1",NULL,"subscribe",NULL,"חתמתי על מנוי לעיתון בוקר","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-27 May 2004, assign-6 Nov 2003",91121,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (820,"חֹדֶשׁ","n","10922179","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"month",NULL,"יש לה יום הולדת בחודש הבא","checked","#ASSIGN:41.0=[gnd=2.0E+01,bt(dir)=21.0] #MZ@\r\n#NO","ordan-17 May 2004, assign-6 Nov 2003",91122,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (821,"חֹדֶשׁ","n","10919146","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"month",NULL,"ניתנה לו ארכה של חודש להסדיר את הקנס","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-17 May 2004, assign-6 Nov 2003",91122,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (822,"חֹמֶר","n","04799150","yy","melingo","1.1","rav-milim","1.6","tg1",NULL,"material",NULL,"אנא, צלם גם לי את החומר לבחינה","checked","#ASSIGN:50=[gnd=7.0,bt(dir)=7.0,bt(dir)=7.0,bt(crs)=14.0,dfl=15.0] #MZ@\r\n#NO","ordan-20 Jun 2004, assign-6 Nov 2003",91123,"2004-06-20");
INSERT INTO hebrew_synonyms VALUES (823,"חֹמֶר","n","10457644","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"raw_material",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,bt(dir)=6.0,dfl=5.0] #MZ@\r\n#NO","ordan-20 Jun 2004, assign-6 Nov 2003",91123,"2004-06-20");
INSERT INTO hebrew_synonyms VALUES (825,"!חֹסֶר_","n","10367399","u","melingo","1","rav-milim",NULL,"tg1",NULL,"absence, lack",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO am not sure; doesn\'t come in accordance with either RM nor Even-Shushan","ordan-06 Jun 2004, assign-6 Nov 2003",0,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (6776,"מַחְסוֹר","n","10367751","u","none",NULL,"rav-milim","1.2",NULL,NULL,"dearth, famine, shortage",NULL,NULL,"checked","#NO maybe, not sure","ordan-26 May 2004",91124,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (6777,"רָעָב","n","10367751","yy","melingo","1.2","rav-milim","1.2",NULL,NULL,NULL,NULL,"וַיְהִי רָעָב בָּאָרֶץ; וַיֵּרֶד אַבְרָם מִצְרַיְמָה לָגוּר שָׁם, כִּי-כָבֵד הָרָעָב בָּאָרֶץ","checked","#NO","ordan-26 May 2004",91125,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (827,"!חֹסֶר","n","03986577","u","melingo","2","rav-milim",NULL,"tg1",NULL,"deficit, shortage",NULL,NULL,"checked","#ASSIGN:111.0=[gnd=2.0E+01,gnd=2.0E+01,si=33.0,bt(dir)=19.0,bt(dir)=19.0] #MZ@\r\n#NO according to RN it only appears in סמיכות, I\'m not sure","ordan-06 Jun 2004, assign-6 Nov 2003",0,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (828,"!חֹק","n","04927294","y","melingo","1","rav-milim",NULL,"tg1",NULL,"statute, law",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,bt(dir)=6.0,dfl=5.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (829,"!חוֹלֶה","n","07461272","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"patient, sick_person",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO this is the state of being sick, not the ''status'' in relation to the medical system","ordan-07 Jun 2004, assign-6 Nov 2003",0,"2004-06-07");
INSERT INTO hebrew_synonyms VALUES (830,"חוֹלֶה","n","07574722","n","melingo","1.1","rav-milim","1.1","tg1",NULL,"sick_person",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO\r\n#IE gender","eyal-18 Jul 2005, ordan-07 Jun 2004, assign-6 Nov 2003",0,"2005-07-18");
INSERT INTO hebrew_synonyms VALUES (831,"!חוֹקֵר","n","07530046","y","melingo","1","rav-milim",NULL,"tg1",NULL,"researcher",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (832,"!חוֹקֵר","n","07340274","y","melingo","2","rav-milim",NULL,"tg1",NULL,"investigator, interrogator",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (833,"חוּץ","n","00083719","yy","melingo","1.2","rav-milim","1.3","tg1","((ball games))","out",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE in Hebrew it is not restricted to Baseball","eyal-07 Aug 2005, assign-6 Nov 2003",95223,"2005-08-07");
INSERT INTO hebrew_synonyms VALUES (834,"!טֶכְנוֹלוֹגְיָה","n","04660658","nn","melingo",NULL,"rav-milim",NULL,"tg1",NULL,"technology",NULL,NULL,"checked","#ASSIGN:37.0=[gnd=2.0E+01,bt(dir)=17.0] #MZ@ #IE ''handasa'' fits much more","eyal-02 Jun 2004, eyal-02 May 2004, assign-6 Nov 2003",0,"2004-06-02");
INSERT INTO hebrew_synonyms VALUES (835,"טֶכְנוֹלוֹגְיָה","n","00607693","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"technology",NULL,"מנוע הדיזל בעל ההזרקה הישירה עושה שימוש בטכנולוגיה מתקדמת של יחידת הזרקה בלחץ גבוה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-02 May 2004",91127,"2004-05-02");
INSERT INTO hebrew_synonyms VALUES (836,"!טֶלֶוִיזְיָה","n","04745188","y","melingo","1","rav-milim",NULL,"tg1",NULL,"television",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (837,"טֶלֶוִיזְיָה","n","03482557","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"television",NULL,"הילדים צופים בטלוויזיה הרבה יותר מהזמן המומלץ","checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@ \r\n#IE","eyal-08 Jun 2004",91128,"2004-06-08");
INSERT INTO hebrew_synonyms VALUES (838,"טֶלֶוִיזְיָה","n","03481385","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"television",NULL,"הטלוויזיה הגיעה לארץ רק בתחילת שנות השבעים","checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#IE","eyal-08 Jun 2004, assign-6 Nov 2003",91128,"2004-06-08");
INSERT INTO hebrew_synonyms VALUES (839,"!טֶלֶפוֹן","n","04742034","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"telephone",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-08 Jun 2004, assign-6 Nov 2003",0,"2004-06-08");
INSERT INTO hebrew_synonyms VALUES (840,"טֶלֶפוֹן","n","03478277","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"telephone",NULL,"דיברתי איתו אתמול בטלפון","checked","#ASSIGN:41.0=[gnd=2.0E+01,bt(dir)=21.0] #MZ@ #IE","eyal-08 Jun 2004, assign-6 Nov 2003",91129,"2004-06-08");
INSERT INTO hebrew_synonyms VALUES (841,"טֶלֶפוֹן","n","04742189","yy","melingo","1.2","rav-milim","1.2","tg1","((colloquial))","telephone_call",NULL,"אני צריכה לעשות טלפון חשוב עכשיו","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-08 Jun 2004, assign-6 Nov 2003",91129,"2004-06-08");
INSERT INTO hebrew_synonyms VALUES (842,"!טַעֲנָה","n","04925009","y","melingo","3","rav-milim",NULL,"tg1","((law))","plea, argumentation",NULL,NULL,"assigned","#ASSIGN:37.0=[gnd=13.0,flc(dic)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (843,"!טַעֲנָה","n","00776560","y","melingo","3","rav-milim",NULL,"tg1","((law))","plea, argumentation",NULL,NULL,"assigned","#ASSIGN:37.0=[gnd=13.0,flc(dic)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (844,"!טַעֲנָה","n","04452090","y","melingo","3","rav-milim",NULL,"tg1","((law))","plea, argumentation",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (845,"טָעַן","v","01528065","yy","melingo","1.3","rav-milim","1.4","tg1","((computing))","upload",NULL,"חכה עד שהמחשב יגמור לטעון את התוכנה","checked","#ASSIGN:88.0=[gnd=39.0,flc(dic)=49.0] #MZ@ #IE","eyal-07 Jun 2004, assign-6 Nov 2003",91130,"2004-06-07");
INSERT INTO hebrew_synonyms VALUES (846,"!טָעָן","n","07610890","nn","melingo","1","rav-milim",NULL,"tg1","((military))","loader",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE ''loader'' in a military sense is a different thing","eyal-07 Jun 2004, assign-6 Nov 2003",0,"2004-06-07");
INSERT INTO hebrew_synonyms VALUES (847,"!טָעוּת","n","05071571","y","melingo","1","rav-milim",NULL,"tg1",NULL,"mistake, error",NULL,NULL,"assigned","#ASSIGN:91.0=[gnd=13.0,gnd=7.0,si=14.0,bt(dir)=6.0,bt(dir)=13.0,bt(crs)=19.0,bt(dir)=6.0,bt(dir)=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (848,"טָעוּת","n","00042411","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"mistake, error",NULL,"עשיתי טעות ששמעתי בקולו","checked","#ASSIGN:91.0=[gnd=13.0,gnd=7.0,si=14.0,bt(dir)=13.0,bt(dir)=6.0,bt(crs)=19.0,bt(dir)=13.0,bt(dir)=6.0] #MZ@\r\n#IE","eyal-09 Jun 2004, assign-6 Nov 2003",91131,"2004-06-09");
INSERT INTO hebrew_synonyms VALUES (849,"!טָעוּת","n","04531479","y","melingo","1","rav-milim",NULL,"tg1",NULL,"mistake, error",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (850,"טוֹב","a","02220016","yy","melingo","1.4","rav-milim","1.5","tg1",NULL,"successful",NULL,"העיסקה הזו היתה טובה במיוחד - כולם הרוויחו ממנה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-09 Jun 2004, assign-6 Nov 2003",91132,"2004-06-09");
INSERT INTO hebrew_synonyms VALUES (851,"טוֹב","a","01078193","yy","melingo","1.5","rav-milim","1.6","tg1",NULL,"well_behaved",NULL,"אם תהיה ילד טוב, תקבל סוכריה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-09 Jun 2004, assign-6 Nov 2003",91132,"2004-06-09");
INSERT INTO hebrew_synonyms VALUES (852,"טוֹב","r","00010099","yy","melingo","3.1","rav-milim","1.8","tg1","colloquial","well",NULL,"לא ישנתי כל כך טוב הלילה","checked","#ASSIGN:57.0=[gnd=3.0,bt(dir)=4.0,bt(dir)=23.0,bt(crs)=27.0] #MZ@\r\n#IE","eyal-09 Jun 2004, assign-6 Nov 2003",91133,"2004-06-09");
INSERT INTO hebrew_synonyms VALUES (6835,"טוֹב","n","04005893","yy","melingo","2.1","rav-milim","2.1",NULL,NULL,"good",NULL,"יש לשקול את הטוב לעומת הרע","checked","#IE","eyal-10 Jun 2004",91134,"2004-06-10");
INSERT INTO hebrew_synonyms VALUES (854,"טוּב","n","03800378","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"goodness",NULL,"לעתים קשה למצוא מעט טוב בבני האדם","checked","#ASSIGN:36.0=[gnd=2.0E+01,bt(dir)=16.0] #MZ@\r\n#IE","eyal-10 Jun 2004, assign-6 Nov 2003",91135,"2004-06-10");
INSERT INTO hebrew_synonyms VALUES (855,"!טוּב","n","04019795","y","melingo","1","rav-milim",NULL,"tg1",NULL,"good",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (856,"!טוּב","n","04005893","u","melingo","1","rav-milim",NULL,"tg1",NULL,"good",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE I think the word טוב fits more.","eyal-10 Jun 2004, assign-6 Nov 2003",0,"2004-06-10");
INSERT INTO hebrew_synonyms VALUES (858,"יְדִיעָה","n","04867981","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"news_item",NULL,"אתמול התפרסמה בעיתון ידיעה מרעישה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ \r\n#IE RM (and Hebrew, I think) does not distinguish between a news item in the newspaper and a news item in the radio or television. According to WN definition, this synset refers only to a newspaper. ","eyal-30 Jun 2004",91136,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (859,"יְהוּדִי","a","02697443","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"Jewish",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-30 Jun 2004, assign-6 Nov 2003",91137,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (860,"יְהוּדִי","n","06998898","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"Jew",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-27 Jun 2004",91138,"2004-06-27");
INSERT INTO hebrew_synonyms VALUES (6897,"GAP!","n","02781462","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#NO British specific","ordan-30 Jun 2004",90808,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (862,"!יְכֹלֶת","n","04349777","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"ability",NULL,NULL,"checked","#ASSIGN:66.0=[gnd=2.0E+01,bt(dir)=19.0,bt(dir)=4.0,bt(crs)=23.0] #MZ@\r\n#NO","ordan-13 Jul 2004, assign-6 Nov 2003",0,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (863,"יְכֹלֶת","n","04047716","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"ability",NULL,"זיכרונו המצוין מסייע לו בלימוד שפות זרות","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-13 Jul 2004",91139,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (864,"!יְצִירָה","n","04355888","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"creativity",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-14 Jul 2004, assign-6 Nov 2003",0,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (6567,"תַּחְזוּקָה","n","00171721","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"maintenance",NULL,"הוא מתפרנס מכתיבת מדריכים לתחזוקת רכב","checked","#NO","ordan-03 Apr 2004",91140,"2004-04-03");
INSERT INTO hebrew_synonyms VALUES (866,"יְרִידָה","n","05479408","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"decrease, diminution, lessening",NULL,"הדו''ח הנוכחי מראה ירידה חדה במכירות","checked","#ASSIGN:69.0=[gnd=1.0E+01,gnd=39.0,si=2.0E+01] #MZ@ #IE","eyal-30 Jun 2004, assign-6 Nov 2003",91141,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (867,"!יְרִידָה","n","00225760","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"decrease, diminution, lessening",NULL,NULL,"checked","#ASSIGN:5.0E+01=[gnd=1.0E+01,gnd=2.0E+01,si=2.0E+01] #MZ@ #IE","eyal-30 Jun 2004, assign-6 Nov 2003",0,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (868,"!יְרִידָה","n","05483545","nn","melingo","4","rav-milim",NULL,"tg1",NULL,"falling",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-30 Jun 2004, assign-6 Nov 2003",0,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (869,"!יְשִׁיבָה","n","06224833","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"sitting",NULL,NULL,"checked","#ASSIGN:50=[gnd=1.0E+01,bt(dir)=12.0,dfl=28.0] #MZ@\r\n#IE not s regular meeting","eyal-01 Jul 2004, assign-6 Nov 2003",0,"2004-07-01");
INSERT INTO hebrew_synonyms VALUES (870,"!יְשִׁיבָה","n","02618194","n","melingo","3","rav-milim",NULL,"tg1",NULL,"living, dwelling",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-11 Aug 2005, assign-6 Nov 2003",0,"2005-08-11");
INSERT INTO hebrew_synonyms VALUES (871,"!יְשִׁיבָה","n","07526600","y","melingo","1","rav-milim",NULL,"tg1","((Judaism))","religious, Talmudic_college",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (872,"יִצּוּר","n","00593550","yy","melingo","1.1","rav-milim","1.3","tg1",NULL,"manufacture",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-30 Jun 2004, assign-6 Nov 2003",91142,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (873,"יִצּוּר","n","00592801","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"industry",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#IE","eyal-30 Jun 2004, assign-6 Nov 2003",91142,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (6899,"GAP!","n","02522330","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE","eyal-01 Jul 2004",90808,"2004-07-01");
INSERT INTO hebrew_synonyms VALUES (875,"יִשְׂרְאֵלִי","a","02738489","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"Israeli",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-30 Jun 2004, assign-6 Nov 2003",91143,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (877,"יִשְׂרְאֵלִי","n","07025077","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"Israeli",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-30 Jun 2004",91144,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (880,"!יִתְרוֹן","n","09540718","nn","melingo","3","rav-milim",NULL,"tg1",NULL,"gain, profit",NULL,NULL,"checked","#ASSIGN:35.0=[gnd=2.0E+01,bt(dir)=15.0] #MZ@\r\n#NO","ordan-13 Jul 2004, assign-6 Nov 2003",0,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (881,"יִתְרוֹן","n","04017901","yy","melingo","1.3","rav-milim","1.4","tg1",NULL,"gain, profit",NULL,"עובדי אוניברסיטה נהנים מיתרונות רבים שאינם מגולמים בשכר","checked","#ASSIGN:137.0=[gnd=1.0E+01,gnd=2.0E+01,si=2.0E+01,bt(dir)=19.0,bt(dir)=1.0E+01,bt(crs)=29.0,bt(dir)=19.0,bt(dir)=1.0E+01] #MZ@\r\n#NO","ordan-13 Jul 2004",91145,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (882,"יִתָּכֵן","r","00294418","yy","melingo","1","rav-milim","1","tg1",NULL,"perhaps, it_may_be, it_is_possible_that, possibly",NULL,"יתכן שניתקל בהם בהופעה","checked","#ASSIGN:235.0=[gnd=39.0,gnd=1.0E+01,si=24.0,bt(dir)=11.0,bt(dir)=43.0,bt(crs)=54.0,bt(dir)=11.0,bt(dir)=43.0] #MZ@ #IE","eyal-15 Feb 2004, assign-6 Nov 2003",91146,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (883,"!יֵצֶר","n","04354143","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"inclination, tendency, instinct",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-14 Jul 2004, assign-6 Nov 2003",0,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (884,"!יֵשׁ","n","10054265","y","melingo","1","rav-milim",NULL,"tg1",NULL,"being, reality, existence",NULL,NULL,"assigned","#ASSIGN:54.0=[gnd=2.0E+01,gnd=2.0E+01,si=14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (885,"יֵשׁ","r","00020741","u","melingo","1.5","rav-milim","1.10","tg1",NULL,"sometimes",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO used only in limited contexts","ordan-04 Aug 2004",91147,"2004-08-04");
INSERT INTO hebrew_synonyms VALUES (888,"יֶלֶד","n","07389783","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"boy",NULL,"הילד אמר שכשיגדל הוא רוצה להיות כמו אבא","checked","#ASSIGN:44.0=[gnd=1.0E+01,bt(dir)=11.0,bt(dir)=6.0,bt(crs)=17.0] #MZ@\r\n#NO","ordan-14 Jul 2004",91148,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (6596,"רוֹעֶה","n","07317144","yy",NULL,NULL,"rav-milim","1.1",NULL,NULL,"herder, herdsman",NULL,"הרועה הוביל את העדר לאחו","checked","#NO","ordan-13 Apr 2004",91149,"2004-04-13");
INSERT INTO hebrew_synonyms VALUES (6975,"דַּרְדַּק","n","07389783","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-14 Jul 2004",91150,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (6976,"יַנּוּקָא","n","07389783","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-14 Jul 2004",91151,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (891,"יֶלֶד","n","07154377","yy","melingo","1.2","none",NULL,"tg1",NULL,"child",NULL,"יש להם שלושה ילדים - בן ושתי בנות","checked","#ASSIGN:39.0=[gnd=7.0,bt(dir)=6.0,bt(dir)=1.0E+01,bt(crs)=16.0] #MZ@\r\n#NO","ordan-14 Jul 2004, assign-6 Nov 2003",91148,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (892,"יֶלֶד","n","07153837","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"child, kid, youngster",NULL,"הילדים ששחקו בחצר הרעישו מאוד","checked","#ASSIGN:39.0=[gnd=7.0,bt(dir)=6.0,bt(dir)=1.0E+01,bt(crs)=16.0] #MZ@\r\n#NO","ordan-14 Jul 2004",91148,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (6977,"זוֹנַת-רְחוֹב","n","07615942","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"streetwalker, street_girl",NULL,NULL,"checked","#NO","ordan-14 Jul 2004",91152,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (896,"יֶן","n","09867130","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"yen",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-10 Jul 2004, assign-6 Nov 2003",91153,"2004-07-10");
INSERT INTO hebrew_synonyms VALUES (897,"!יֶן","n","05566100","y","melingo","1","rav-milim",NULL,"tg1",NULL,"yen",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (898,"יַחַס","n","09953487","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"ratio",NULL,"בין 50 ל-100 מתקיים יחס של 2 ל-1","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-15 Jul 2004",91154,"2004-07-15");
INSERT INTO hebrew_synonyms VALUES (899,"יַעַד","n","04587307","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"aim, objective, target",NULL,"החברה הגתה תוכנית יחודית להשגת יעדים","checked","#ASSIGN:143.0=[gnd=1.0E+01,gnd=2.0E+01,gnd=8.0,si=13.0,bt(dir)=8.0,bt(dir)=15.0,bt(crs)=23.0,bt(dir)=8.0,bt(dir)=15.0,bt(dir)=8.0,bt(dir)=15.0] #MZ@\r\n#IE","eyal-10 Jan 2005, assign-6 Nov 2003",91155,"2005-01-10");
INSERT INTO hebrew_synonyms VALUES (900,"!יַעַד","n","03050219","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"aim, purpose, objective, target",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-11 Jul 2004, assign-6 Nov 2003",0,"2004-07-11");
INSERT INTO hebrew_synonyms VALUES (901,"!יַעַד","n","04588033","u","melingo","1","rav-milim",NULL,"tg1",NULL,"aim, purpose, objective, target",NULL,NULL,"checked","#ASSIGN:48.0=[gnd=1.0E+01,gnd=13.0,si=9.0,bt(dir)=8.0,bt(dir)=8.0] #MZ@\r\n#IE I think the word ''objective'' fits better","eyal-19 Jul 2004, assign-6 Nov 2003",0,"2004-07-19");
INSERT INTO hebrew_synonyms VALUES (902,"יַעַד","n","06302863","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"destination",NULL,"לאחר הליכה של כמה שעות הגענו ליעדנו","checked","#ASSIGN:59.0=[gnd=13.0,bt(dir)=13.0,bt(dir)=1.0E+01,bt(crs)=23.0] #MZ@\r\n#NO","ordan-11 Jul 2004, assign-6 Nov 2003",91155,"2004-07-11");
INSERT INTO hebrew_synonyms VALUES (903,"!יַעַד","n","05083171","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"destination",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-11 Jul 2004, assign-6 Nov 2003",0,"2004-07-11");
INSERT INTO hebrew_synonyms VALUES (904,"!יַעַד","n","04587791","y","melingo","2","rav-milim",NULL,"tg1",NULL,"destination",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (905,"יַצְרָן","n","07394756","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"manufacturer",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO this refers only partly to RM\'s definition","ordan-13 Jul 2004, assign-6 Nov 2003",91156,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (906,"יַצְרָן","n","06007767","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"manufacturer",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#NO this refers only partly to RM\'s definition","ordan-13 Jul 2004",91156,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (907,"גַּפָּה-קִדְמִית","n","01960106","yy","none",NULL,"none",NULL,"tg1",NULL,"forelimb",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ \r\n#IE","eyal-01 Jul 2004",91157,"2004-07-01");
INSERT INTO hebrew_synonyms VALUES (908,"יָד","n","02231667","yy","melingo","1.7","rav-milim","1.7","tg1","((talmudic))","backrest",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-01 Jul 2004, assign-6 Nov 2003",91158,"2004-07-01");
INSERT INTO hebrew_synonyms VALUES (909,"!יָד","n","03331403","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"memorial, shrine",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE יד fits better to ''memorial''","eyal-01 Jul 2004, assign-6 Nov 2003",0,"2004-07-01");
INSERT INTO hebrew_synonyms VALUES (910,"יָדוּעַ","a","01321211","yy","melingo","1.1","none",NULL,"tg1",NULL,"celebrated, famed, famous, illustrious, notable, noted, renowned",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO According to RM it is better matched with a#01321996, but it could well belong to this sysnet as well","ordan-26 Jun 2004",91159,"2004-06-26");
INSERT INTO hebrew_synonyms VALUES (911,"!יָדוּעַ","a","01320533","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"known, famous",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO look especially at the examples","ordan-26 Jun 2004, assign-6 Nov 2003",0,"2004-06-26");
INSERT INTO hebrew_synonyms VALUES (912,"!יָדוּעַ","a","02311557","nn","melingo","6","rav-milim",NULL,"tg1",NULL,"known_as, famous_for",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO i think it refers only to names, therefore מְכֻנֶּה is the only true equivalent","ordan-26 Jun 2004, assign-6 Nov 2003",0,"2004-06-26");
INSERT INTO hebrew_synonyms VALUES (913,"יָחִיד","a","02111616","y","melingo","1.1","rav-milim","1.1","tg1",NULL,"only",NULL,"הוא הרופא היחיד בעיירה","assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-11 Aug 2005, assign-6 Nov 2003",95229,"2005-08-11");
INSERT INTO hebrew_synonyms VALUES (914,"!יָחִיד","a","01791800","y","melingo","1","rav-milim",NULL,"tg1",NULL,"alone, one, only",NULL,NULL,"assigned","#ASSIGN:79.0=[gnd=1.0E+01,gnd=2.0E+01,si=7.0,bt(dir)=21.0,bt(dir)=21.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (915,"יָחִיד","n","04753575","yy","melingo","1.2","rav-milim","1.3","tg1","((grammar))","singular",NULL,"המילה ספל היא היחיד של ספלים","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-29 Jun 2004, assign-6 Nov 2003",91160,"2004-06-29");
INSERT INTO hebrew_synonyms VALUES (916,"יָם","n","09922052","yy","melingo","1.1","rav-milim","1.4","tg1",NULL,"ocean, sea",NULL,"השמיים היו זרועים בים של כוכבים","checked","#ASSIGN:89.0=[gnd=2.0E+01,gnd=13.0,si=24.0,bt(dir)=16.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-09 Jul 2004",91161,"2004-07-09");
INSERT INTO hebrew_synonyms VALUES (918,"יָם","n","06781925","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"sea",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-30 Jun 2004",91161,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (919,"יָם","n","09966059","yy","none",NULL,"rav-milim","1.3","tg1","((biblical))","West",NULL,"השמש שוקעת במערב","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-09 Jul 2004, assign-6 Nov 2003",91161,"2004-07-09");
INSERT INTO hebrew_synonyms VALUES (920,"יָם","n","03987430","nn","melingo","1.3","rav-milim","1.4","tg1",NULL,"profusion",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO thought it fits better to n#09922052","ordan-09 Jul 2004",91161,"2004-07-09");
INSERT INTO hebrew_synonyms VALUES (921,"!יָם","n","03990044","nn","melingo","3","rav-milim",NULL,"tg1",NULL,"abundance, plethora, profusion",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-09 Jul 2004, assign-6 Nov 2003",0,"2004-07-09");
INSERT INTO hebrew_synonyms VALUES (923,"יָמִין","n","04311787","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"right_hand",NULL,"אם אשכחך ירושלים תשכח ימיני (תהילים קלז ה)","checked","#ASSIGN:50=[gnd=39.0,bt(dir)=6.0,dfl=5.0#MZ@\r\n#NO","ordan-09 Jul 2004",91162,"2004-07-09");
INSERT INTO hebrew_synonyms VALUES (924,"!יָעַד","v","00479979","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"designate, specify",NULL,NULL,"checked","#ASSIGN:50=[gnd=1.0E+01,gnd=6.0,si=1.0E+01,dfl=24.0] #MZ@\r\n#NO","ordan-18 Jul 2004, assign-6 Nov 2003",0,"2004-07-18");
INSERT INTO hebrew_synonyms VALUES (925,"!יָעַד","v","01632168","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"appoint, nominate, select",NULL,NULL,"checked","#ASSIGN:37.0=[gnd=13.0,gnd=1.0E+01,si=14.0] #MZ@\r\n#NO","ordan-18 Jul 2004, assign-6 Nov 2003",0,"2004-07-18");
INSERT INTO hebrew_synonyms VALUES (927,"!יָצָא","v","01419172","y","melingo","11","rav-milim",NULL,"tg1",NULL,"escape_from, overcome",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (928,"יָרַד","v","01341375","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"descend, go_down",NULL,"המחירים ירדו לאחרונה, ולפיכך עלה כוח הקנייה","checked","#ASSIGN:6.0E+01=[gnd=1.0E+01,gnd=5.0,si=9.0,bt(dir)=6.0,bt(dir)=6.0,bt(crs)=12.0,bt(dir)=6.0,bt(dir)=6.0] #MZ@ #NO","ordan-15 Jul 2004, assign-6 Nov 2003",91163,"2004-07-15");
INSERT INTO hebrew_synonyms VALUES (929,"יָרַד","v","00103366","yy","melingo",">1.2","rav-milim","1.2","tg1",NULL,"decrease, diminish, lessen, fall",NULL,"שיעור המתגייסים לצבא ירד בהרבה בשנים האחרונות","checked","#ASSIGN:57.0=[gnd=13.0,gnd=2.0E+01,si=24.0] #MZ@\r\n#NO","ordan-15 Jul 2004",91163,"2004-07-15");
INSERT INTO hebrew_synonyms VALUES (930,"!יָרַד","v","01347698","y","melingo","4","rav-milim",NULL,"tg1",NULL,"get_off_(train, get_out_(cab), alight",NULL,NULL,"assigned","#ASSIGN:28.0=[gnd=2.0E+01,bt(dir)=8.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (931,"!יָרַד","v","01347582","y","melingo","4","rav-milim",NULL,"tg1",NULL,"get_off_(train, get_out_(cab), alight",NULL,NULL,"assigned","#ASSIGN:26.0=[gnd=2.0E+01,bt(dir)=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6989,"הִצְטַמְצֵם","v","00103366","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-15 Jul 2004",91164,"2004-07-15");
INSERT INTO hebrew_synonyms VALUES (933,"יָשַׁב","v","01809405","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"dwell, shack, reside, live, inhabit, people, populate",NULL,"הוא יושב בחו''ל כבר שנים רבות","checked","#ASSIGN:50=[gnd=7.0,gnd=1.0E+01,si=11.0,dfl=22.0] #MZ@\r\n#NO","ordan-13 Jul 2004, assign-6 Nov 2003",91165,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (934,"!יו''ר","n","07496412","y","melingo","1","rav-milim",NULL,"tg1",NULL,"chairman, chairperson",NULL,NULL,"assigned","#ASSIGN:176.0=[gnd=39.0,gnd=39.0,si=98.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (935,"יוֹעֵץ","n","07065373","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"adviser, advisor, consultant",NULL,NULL,"checked","#ASSIGN:4.1E+02=[gnd=39.0,gnd=39.0,si=98.0,bt(dir)=39.0,bt(dir)=39.0,bt(crs)=78.0,bt(dir)=39.0,bt(dir)=39.0] #MZ@\r\n#NO","ordan-14 Jul 2004, assign-6 Nov 2003",91166,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (936,"!יוֹתֵר","r","00257938","y","melingo","1","rav-milim",NULL,"tg1",NULL,"more, more_than",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (937,"כִי","n","05119959","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"chi",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-22 Jul 2004, assign-6 Nov 2003",91167,"2004-07-22");
INSERT INTO hebrew_synonyms VALUES (938,"כְּבָר","r","00030867","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"already",NULL,"היא כבר סיימה את לימודי התואר השני","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE","eyal-25 Jul 2004, assign-6 Nov 2003",91168,"2004-07-25");
INSERT INTO hebrew_synonyms VALUES (939,"כְּבָר","r","00032928","yy","melingo","1.2","rav-milim","1.4","tg1","colloquial","soon",NULL,"תגיד לו שאני כבר בא","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-25 Jul 2004, assign-6 Nov 2003",91168,"2004-07-25");
INSERT INTO hebrew_synonyms VALUES (940,"!כְּלִי","n","02851548","y","melingo","1","rav-milim",NULL,"tg1",NULL,"tool, instrument, implement, utensil",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (941,"כְּלִי","n","00112599","yy","melingo","1.1","rav-milim","1.4","tg1",NULL,"tool, instrument",NULL,"המדע נתן לנו כלים חדשים למלחמה במחלות","checked","#ASSIGN:94.0=[gnd=1.0E+01,gnd=1.0E+01,si=11.0,bt(dir)=11.0,bt(dir)=1.0E+01,bt(crs)=21.0,bt(dir)=11.0,bt(dir)=1.0E+01] #MZ@\r\n#IE","eyal-19 Jul 2004, assign-6 Nov 2003",91169,"2004-07-19");
INSERT INTO hebrew_synonyms VALUES (942,"!כְּלִי","n","03563924","y","melingo","1","rav-milim",NULL,"tg1",NULL,"tool, instrument, implement, utensil",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (943,"כְּלִי","n","04111451","yy","melingo","1.2","rav-milim","1.2","tg1","((anatomy))","organ",NULL,NULL,"checked","#ASSIGN:56.0=[gnd=7.0,flc(dic)=49.0] #MZ@\r\n#IE","eyal-19 Jul 2004, assign-6 Nov 2003",91169,"2004-07-19");
INSERT INTO hebrew_synonyms VALUES (944,"כְּלִי","n","02740446","yy","melingo","1.5","rav-milim","1.7","tg1","((talmudic))","garment",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-19 Jul 2004, assign-6 Nov 2003",91169,"2004-07-19");
INSERT INTO hebrew_synonyms VALUES (945,"כְּלִי","n","03601056","yy","melingo","1.6","rav-milim","1.8","tg1","((biblical))","weapon, arm",NULL,NULL,"checked","#ASSIGN:50=[gnd=2.0E+01,gnd=7.0,si=14.0,dfl=9.0] #MZ@\r\n#IE","eyal-19 Jul 2004, assign-6 Nov 2003",91169,"2004-07-19");
INSERT INTO hebrew_synonyms VALUES (946,"כְּלָל","r","00054968","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-06 May 2004, assign-6 Nov 2003",91170,"2004-05-06");
INSERT INTO hebrew_synonyms VALUES (948,"!כְּנִיסָה","n","02748084","y","melingo","3","rav-milim",NULL,"tg1",NULL,"entrance, doorway, gateway, portal",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (949,"!כְּנִיסָה","n","02591205","y","melingo","3","rav-milim",NULL,"tg1",NULL,"entrance, doorway, gateway, portal",NULL,NULL,"assigned","#ASSIGN:47.0=[gnd=39.0,bt(dir)=8.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (950,"כְּנִיסָה","n","05527437","yy","melingo","1.3","rav-milim","1.1","tg1",NULL,"entrance, entering",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-10 Feb 2005, assign-6 Nov 2003",91171,"2005-02-10");
INSERT INTO hebrew_synonyms VALUES (8188,"מַחְצֵצָה","n","03518223","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"toothpick",NULL,NULL,"checked","#IE","eyal-10 Feb 2005",94472,"2005-02-10");
INSERT INTO hebrew_synonyms VALUES (952,"כְּנִיסָה","n","00026402","yy","melingo","1.3","rav-milim","1.1","tg1",NULL,"entrance",NULL,"היא ביצעה כניסה מרשימה","revised","#ASSIGN:53.0=[gnd=13.0,bt(dir)=14.0,bt(dir)=6.0,bt(crs)=2.0E+01] #MZ@\r\n#IE\r\n#NO overlap with n#00026402, but in fact RM\'s 1.1 defintion does allow for both. I\'m for","ordan-10 Feb 2005, eyal-11 Jul 2004, assign-6 Nov 2003",91171,"2005-02-10");
INSERT INTO hebrew_synonyms VALUES (953,"!כְּנִיסָה","n","10965545","nn","melingo","4","rav-milim",NULL,"tg1",NULL,"beginning, commencement, inauguration, inception",NULL,NULL,"checked","#ASSIGN:32.0=[gnd=8.0,gnd=13.0,si=11.0] #MZ@ #IE not the correct word","eyal-15 Apr 2004, assign-6 Nov 2003",0,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (954,"!כְּנִיסָה","n","00153241","nn","melingo","4","rav-milim",NULL,"tg1",NULL,"beginning, commencement, inauguration, inception",NULL,NULL,"checked","#ASSIGN:32.0=[gnd=8.0,gnd=13.0,si=11.0] #MZ@\r\n#IE not the correct word for this meaning of ''beginning''.","eyal-11 Jul 2004, assign-6 Nov 2003",0,"2004-07-11");
INSERT INTO hebrew_synonyms VALUES (955,"!כְּנִיסָה","n","05458618","y","melingo","4","rav-milim",NULL,"tg1",NULL,"beginning, commencement, inauguration, inception",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6940,"מַעַן","n","05083171","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"address, destination",NULL,"מאחר שהמען לא היה ידוע, המכתב חזר","checked","#NO","ordan-11 Jul 2004",91172,"2004-07-11");
INSERT INTO hebrew_synonyms VALUES (958,"כְּנֶסֶת","n","06169890","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"Knesset",NULL,"הכנסת מונה 120 חברים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-13 Jul 2004, assign-6 Nov 2003",91173,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (959,"!כְּנֶסֶת","n","00798100","y","melingo","1","rav-milim",NULL,"tg2",NULL,"assembly, assemblage",NULL,NULL,"assigned","#ASSIGN:5.0E+01=[gnd=8.0,gnd=1.0E+01,si=12.0,bt(dir)=1.0E+01,bt(dir)=1.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (960,"כְּתָב","n","04826409","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"handwriting",NULL,"הכתב שלו איום ונורא, אי אפשר להבין מילה ממה שהוא כותב!","checked","#ASSIGN:28.0=[gnd=2.0E+01,bt(dir)=8.0] #MZ@\r\n#IE","eyal-19 Jul 2004, assign-6 Nov 2003",91174,"2004-07-19");
INSERT INTO hebrew_synonyms VALUES (961,"כְּתָב","n","04788218","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"cursive",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-20 Jul 2004, assign-6 Nov 2003",91174,"2004-07-20");
INSERT INTO hebrew_synonyms VALUES (962,"כְּתָב","n","04919548","yy","melingo","1.4","rav-milim","1.4","tg1",NULL,"writ",NULL,"כתב אישום","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-20 Jul 2004, assign-6 Nov 2003",91174,"2004-07-20");
INSERT INTO hebrew_synonyms VALUES (963,"!כִּמְעַט","r","00156524","y","melingo","1","rav-milim",NULL,"tg1",NULL,"almost, not_quite, nearly",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (964,"כִּמְעַט","r","00070549","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"almost, not_quite, nearly",NULL,"כמעט התעלפתי כששמעתי את החדשות; התינוק כמעט נרדם כשנכנסנו לחדרו","checked","#ASSIGN:3.8E+02=[gnd=39.0,gnd=2.0E+01,si=49.0,bt(dir)=39.0,bt(dir)=17.0,bt(dir)=12.0,bt(crs)=136.0,bt(dir)=39.0,bt(dir)=17.0,bt(dir)=12.0] #MZ@\r\n#IE","eyal-26 Jul 2004, assign-6 Nov 2003",91175,"2004-07-26");
INSERT INTO hebrew_synonyms VALUES (965,"כֵּלִי","a","02621476","yy","melingo","1.1","rav-milim","1.1","tg1","((music))","instrumental",NULL,NULL,"checked","#ASSIGN:69.0=[gnd=2.0E+01,flc(dic)=49.0] #MZ@\r\n#IE","eyal-12 Jul 2004, assign-6 Nov 2003",91176,"2004-07-12");
INSERT INTO hebrew_synonyms VALUES (966,"כֵּן","r","00118084","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"so, thusly",NULL,NULL,"checked","#ASSIGN:54.0=[gnd=4.0,gnd=39.0,si=11.0] #MZ@\r\n#IE","eyal-12 Jul 2004, assign-6 Nov 2003",91177,"2004-07-12");
INSERT INTO hebrew_synonyms VALUES (967,"!כֶּבֶל","n","02672865","n","melingo","1","rav-milim",NULL,"tg1",NULL,"fetter, chain",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-04 Sep 2005, assign-6 Nov 2003",0,"2005-09-04");
INSERT INTO hebrew_synonyms VALUES (968,"!כֶּלֶא","n","02872007","y","melingo","1","rav-milim",NULL,"tg1",NULL,"jail, prison",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (969,"!כֶּסֶף","n","09639977","y","melingo","1","rav-milim",NULL,"tg1",NULL,"money",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (970,"!כֶּסֶף","n","09639711","y","melingo","1","rav-milim",NULL,"tg1",NULL,"money",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (971,"!כֶּסֶף","n","09534064","y","melingo","1","rav-milim",NULL,"tg1",NULL,"money",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (972,"כַּדּוּר","n","03123093","yy","melingo","2","rav-milim","1.2","tg1","((colloquial))","pill, tablet",NULL,NULL,"checked","#ASSIGN:50=[gnd=13.0,gnd=13.0,si=2.0E+01,dfl=4.0] #MZ@ #IE","eyal-03 Mar 2004, assign-6 Nov 2003",91178,"2004-03-03");
INSERT INTO hebrew_synonyms VALUES (973,"כַּדּוּרֶגֶל","n","00304700","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"soccer",NULL,"כדורגל משחקים 90 דקות","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE refers to the first part of RM\'s definition","eyal-13 Jul 2004",91179,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (974,"!כַּוָּנָה","n","04588436","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"intention",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE there is no specific term in Hebrew to denotes intentions towards a marriage proposals","eyal-19 Jul 2004, assign-6 Nov 2003",0,"2004-07-19");
INSERT INTO hebrew_synonyms VALUES (975,"כַּוָּנָה","n","04588033","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"intention",NULL,"כוונותיו היו ידועות לכל","checked","#ASSIGN:192.0=[gnd=2.0E+01,bt(dir)=9.0,bt(dir)=16.0,bt(dir)=14.0,bt(dir)=4.0,bt(crs)=129.0] #MZ@\r\n#IE","eyal-19 Jul 2004, assign-6 Nov 2003",91180,"2004-07-19");
INSERT INTO hebrew_synonyms VALUES (976,"כַּיּוֹם","r","00047077","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"nowadays, now, today",NULL,"כיום בקושי רואים סוסים ומרכבות ברחובות","checked","#ASSIGN:6.0E+01=[gnd=39.0,bt(dir)=21.0] #MZ@\r\n#NO","ordan-29 Dec 2004, assign-6 Nov 2003",0,"2004-12-29");
INSERT INTO hebrew_synonyms VALUES (977,"!כַּיּוֹם","r","00046870","y","melingo","1","rav-milim",NULL,"tg1",NULL,"currently, presently, nowadays",NULL,NULL,"assigned","#ASSIGN:1.9E+02=[gnd=39.0,gnd=2.0E+01,si=33.0,bt(dir)=49.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (978,"כַּן","n","02255918","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"base, pedestal",NULL,"למנורה היה כן מגולף מעץ","checked","#ASSIGN:50=[gnd=2.0,gnd=13.0,si=5.0,bt(dir)=3.0,bt(dir)=3.0,dfl=24.0] #MZ@\r\n#IE","eyal-04 Sep 2005, assign-6 Nov 2003",95237,"2005-09-04");
INSERT INTO hebrew_synonyms VALUES (979,"כַּנִּרְאֶה","r","00134549","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"probably, likely, in_all_likelihood",NULL,"הוא כנראה מחוץ לעיר","checked","#ASSIGN:135.0=[gnd=2.0E+01,gnd=39.0,gnd=39.0,si=37.0] #MZ@\r\n#IE","eyal-27 Jul 2004, assign-6 Nov 2003",91181,"2004-07-27");
INSERT INTO hebrew_synonyms VALUES (980,"כַּסְפִּי","a","02639054","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"financial",NULL,"למרות מצבו הכספי הגרוע, הוא המשיך לחיות בפזרנות","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE","eyal-12 Jul 2004, assign-6 Nov 2003",91182,"2004-07-12");
INSERT INTO hebrew_synonyms VALUES (981,"!כַּסְפִּי","a","00365148","u","melingo","1","rav-milim",NULL,"tg2",NULL,"metallic, silvery",NULL,NULL,"checked","#ASSIGN:25.0=[gnd=13.0,bt(dir)=12.0] #MZ@\r\n#IE the word כסוף fits better","eyal-12 Jul 2004, assign-6 Nov 2003",0,"2004-07-12");
INSERT INTO hebrew_synonyms VALUES (982,"כַּסְפִּי","a","00278090","yy","melingo","3.1","rav-milim","3.1","tg2",NULL,"silvery",NULL,"הליתיום הינו יסוד מתכתי בעל ברק כספי","checked","#ASSIGN:25.0=[gnd=13.0,bt(dir)=12.0] #MZ@\r\n#IE ","eyal-12 Jul 2004",91182,"2004-07-12");
INSERT INTO hebrew_synonyms VALUES (983,"!כַּסְפִּי","a","01464354","nn","melingo","1","rav-milim",NULL,"tg2",NULL,"metallic, silvery",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE the word מתכתי is the correct word for this synset","eyal-12 Jul 2004, assign-6 Nov 2003",0,"2004-07-12");
INSERT INTO hebrew_synonyms VALUES (984,"!כַּרְטִיס","n","04923025","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"ticket",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE not the correct word","eyal-20 Jul 2004, assign-6 Nov 2003",0,"2004-07-20");
INSERT INTO hebrew_synonyms VALUES (985,"כַּרְטִיס","n","04892853","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"ticket",NULL,"קניתי שני כרטיסים לסרט","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-20 Jul 2004, assign-6 Nov 2003",91183,"2004-07-20");
INSERT INTO hebrew_synonyms VALUES (986,"!כַּתָּב","n","07528776","y","melingo","1","rav-milim",NULL,"tg1",NULL,"journalist, correspondent, reporter",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (987,"!כַּתָּב","n","07185317","y","melingo","1","rav-milim",NULL,"tg1",NULL,"journalist, correspondent, reporter",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (988,"!כַּתָּב","n","07185179","y","melingo","1","rav-milim",NULL,"tg1",NULL,"journalist, correspondent, reporter",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (989,"כָּבוֹד","n","03827814","yy","melingo","1.3","rav-milim","1.5","tg1",NULL,"dignity, self-respect",NULL,"לא מכבודו היה לרמות","checked","#ASSIGN:68.0=[gnd=13.0,gnd=39.0,si=16.0] #MZ@\r\n#IE","eyal-18 Jul 2004, assign-6 Nov 2003",91184,"2004-07-18");
INSERT INTO hebrew_synonyms VALUES (990,"כָּלָא","v","01699803","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"imprison, put_in_jail, incarcerate",NULL,NULL,"checked","#ASSIGN:108.0=[gnd=2.0E+01,gnd=39.0,si=49.0] #MZ@\r\n#IE","eyal-30 Jun 2005, assign-6 Nov 2003",95169,"2005-06-30");
INSERT INTO hebrew_synonyms VALUES (991,"כָּמֵהַּ","a","01310388","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"yearning",NULL,"הוא ציפה לשובה בנפש כמהה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-12 Jul 2004, assign-6 Nov 2003",91185,"2004-07-12");
INSERT INTO hebrew_synonyms VALUES (992,"!כָּמַהּ","v","01247460","y","melingo","1","rav-milim",NULL,"tg1","((literary))","long_for, yearn",NULL,NULL,"assigned","#ASSIGN:37.0=[gnd=13.0,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (993,"!כָּמַהּ","v","01231785","y","melingo","1","rav-milim",NULL,"tg1","((literary))","long_for, yearn",NULL,NULL,"assigned","#ASSIGN:32.0=[gnd=13.0,bt(dir)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (994,"!כָּעֵת","r","00046870","y","melingo","1","rav-milim",NULL,"tg1",NULL,"now, currently, presently",NULL,NULL,"assigned","#ASSIGN:7.0E+01=[gnd=39.0,gnd=2.0E+01,si=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (995,"!כָּתַב","v","01168840","y","melingo","2","rav-milim",NULL,"tg1",NULL,"author, compose",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (997,"כֹּה","r","00118084","yy","melingo","1.2","rav-milim","1.1","tg1","((biblical))","thusly, thus",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-12 Jul 2004, assign-6 Nov 2003",91186,"2004-07-12");
INSERT INTO hebrew_synonyms VALUES (998,"!כּוֹחַ","n","06059369","y","melingo","1","rav-milim",NULL,"tg1",NULL,"energy, strength, resource",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (999,"כּוֹחַ","n","04349777","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"ability, power",NULL,NULL,"checked","#ASSIGN:34.0=[gnd=2.0E+01,gnd=4.0,si=1.0E+01] #MZ@\r\n#NO","ordan-13 Jul 2004, assign-6 Nov 2003",91187,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (1000,"כּוֹכָב","n","05115508","yy","melingo","1.2","rav-milim","1.7","tg1",NULL,"asterisk",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,bt(dir)=7.0,dfl=4.0] #MZ@\r\n#IE","eyal-22 Jul 2004",91188,"2004-07-22");
INSERT INTO hebrew_synonyms VALUES (1001,"!לְמַעֲשֶׂה","r","00145641","y","melingo","1","rav-milim",NULL,"tg1",NULL,"actually, in_fact",NULL,NULL,"assigned","#ASSIGN:56.0=[gnd=1.0E+01,bt(dir)=13.0,bt(dir)=1.0E+01,bt(crs)=23.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1002,"!לְמַעֲשֶׂה","r","00145000","y","melingo","1","rav-milim",NULL,"tg1",NULL,"actually, in_fact",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1003,"!לְמַעֲשֶׂה","r","00057975","y","melingo","2","rav-milim",NULL,"tg1",NULL,"in_practice, in_effect",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1004,"!לְמַעֲשֶׂה","r","00162626","y","melingo","2","rav-milim",NULL,"tg1",NULL,"in_practice, in_effect",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1005,"!לְשֶׁעָבַר","r","00058575","nn","melingo","2","rav-milim",NULL,"tg1","((talmudic))","in_the_past, previously",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-04 Aug 2004, assign-6 Nov 2003",0,"2004-08-04");
INSERT INTO hebrew_synonyms VALUES (1006,"!לִיגָה","n","09815737","y","melingo","1","rav-milim",NULL,"tg1",NULL,"league, association, organization",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1007,"לִיגָה","n","06164721","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"league",NULL,"\'הליגה נגד השמצה\' פועלת למען שמו הטוב של העם היהודי ","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-04 Aug 2004, ordan-03 Aug 2004, assign-6 Nov 2003",91189,"2004-08-04");
INSERT INTO hebrew_synonyms VALUES (1008,"לִיגָה","n","06110607","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"league",NULL,"לאחר שורה של הפסדים ירדה הקבוצה מהליגה הלאומית לארצית","checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#NO","ordan-20 Mar 2004",91189,"2004-03-20");
INSERT INTO hebrew_synonyms VALUES (1009,"לִיד","n","05287483","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"lied",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,flc(dic)=49.0] #MZ@\r\n#NO","ordan-28 Jul 2004, assign-6 Nov 2003",91190,"2004-07-28");
INSERT INTO hebrew_synonyms VALUES (1010,"!לִכּוּד","n","05491124","y","melingo","1","rav-milim",NULL,"tg1",NULL,"unification, consolidation",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1011,"!לִכּוּד","n","00803600","u","melingo","1","rav-milim",NULL,"tg1",NULL,"unification, consolidation",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO better matched with \'unification\'","ordan-20 Jul 2004, assign-6 Nov 2003",0,"2004-07-20");
INSERT INTO hebrew_synonyms VALUES (1012,"!לִמּוּד","n","04949512","y","melingo","1","rav-milim",NULL,"tg1",NULL,"studying, learning, acquiring_knowledge",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1013,"לֶב","n","09848270","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"lev",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-04 Aug 2004, assign-6 Nov 2003",91191,"2004-08-04");
INSERT INTO hebrew_synonyms VALUES (1014,"!לֶקַח","n","05678434","nn","melingo","1","rav-milim",NULL,"tg2","((Yiddish))","lekach\', sponge_cake",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-03 Aug 2004, assign-6 Nov 2003",0,"2004-08-03");
INSERT INTO hebrew_synonyms VALUES (1015,"!לַיְלָה","n","06906151","y","melingo","1","rav-milim",NULL,"tg1",NULL,"night",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6782,"אִלֵּץ","v","01707058","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-27 May 2004",91192,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (6783,"כָּפָה","v","01707058","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,"הוא כפה עליו לנהוג בניגוד לרצונו","checked","#NO","ordan-27 May 2004",91193,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (1017,"!לָחַץ","v","01759411","y","melingo","5","rav-milim",NULL,"tg1","((colloquial))","push, pressure, force",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1018,"לָקוֹחַ","n","07197309","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"client, customer",NULL,NULL,"checked","#ASSIGN:241.0=[gnd=13.0,gnd=39.0,si=33.0,bt(dir)=39.0,bt(dir)=13.0,bt(crs)=52.0,bt(dir)=39.0,bt(dir)=13.0] #MZ@\r\n#NO","ordan-03 Aug 2004",91194,"2004-08-03");
INSERT INTO hebrew_synonyms VALUES (1019,"!לָקוֹחַ","n","07197725","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"client, customer",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-03 Aug 2004, assign-6 Nov 2003",0,"2004-08-03");
INSERT INTO hebrew_synonyms VALUES (1020,"לָקוֹחַ","n","03042473","yy","melingo","1.1","none",NULL,"tg1",NULL,"client",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO I rely on Hod Ami\'s online dictionary for computer science terms http://www2.eitan.ac.il/milon/index.asp","ordan-28 Jul 2004, assign-6 Nov 2003",91194,"2004-07-28");
INSERT INTO hebrew_synonyms VALUES (1021,"!לֹא","r","00022819","y","melingo","1","rav-milim",NULL,"tg1",NULL,"no, not",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1022,"!לֹא","r","00049246","y","melingo","1","rav-milim",NULL,"tg1",NULL,"no, not",NULL,NULL,"assigned","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1023,"!לֹא","r","00023305","y","melingo","1","rav-milim",NULL,"tg1",NULL,"no, not",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1025,"!לֹא","r","00115773","y","melingo","3","rav-milim",NULL,"tg1",NULL,"no_matter",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1026,"!לֹא","r","00049246","y","melingo","1","rav-milim",NULL,"tg1","((Aramaic))","no",NULL,NULL,"assigned","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1027,"!לֹא","r","00023305","y","melingo","1","rav-milim",NULL,"tg1","((Aramaic))","no",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1029,"לֹבֶן","n","03877535","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"whiteness",NULL,"שערו השחור הדגיש את לובן פניו","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-29 Jul 2004, assign-6 Nov 2003",91195,"2004-07-29");
INSERT INTO hebrew_synonyms VALUES (1030,"!לֹבֶן","n","03613524","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"white",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-29 Jul 2004, assign-6 Nov 2003",0,"2004-07-29");
INSERT INTO hebrew_synonyms VALUES (1031,"!לֹבֶן","n","02694150","u","melingo","1","rav-milim",NULL,"tg1",NULL,"white",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO I guess it\'s any of the trousers made of this material","ordan-28 Jul 2004",0,"2004-07-28");
INSERT INTO hebrew_synonyms VALUES (1032,"!לֹבֶן","n","05872814","nn","melingo","3","rav-milim",NULL,"tg1","((colloquial))","egg_white",NULL,NULL,"checked","#ASSIGN:52.0=[gnd=39.0,bt(dir)=13.0] #MZ@\r\n#NO","ordan-29 Jul 2004, assign-6 Nov 2003",0,"2004-07-29");
INSERT INTO hebrew_synonyms VALUES (1033,"!לֹבֶן","n","02816318","nn","melingo","4","rav-milim",NULL,"tg1","((slang))","heroin",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-28 Jul 2004, assign-6 Nov 2003",0,"2004-07-28");
INSERT INTO hebrew_synonyms VALUES (1034,"לוּחַ","n","02294665","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"blackboard, chalkboard",NULL,"התלמידים נקראו אל הלוח לפתור את התרגילים בפני הכיתה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-29 Jul 2004, assign-6 Nov 2003",91196,"2004-07-29");
INSERT INTO hebrew_synonyms VALUES (1035,"לוּחַ","n","10836071","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"board, plank",NULL,NULL,"checked","#ASSIGN:38.0=[gnd=4.0,gnd=2.0E+01,si=4.0,bt(dir)=5.0,bt(dir)=5.0] #MZ@\r\n#NO","ordan-29 Jul 2004, assign-6 Nov 2003",91196,"2004-07-29");
INSERT INTO hebrew_synonyms VALUES (1036,"!לוּחַ","n","05621336","y","melingo","2","rav-milim",NULL,"tg1",NULL,"board, plank, slab, tablet, sheet",NULL,NULL,"assigned","#ASSIGN:28.0=[gnd=4.0,bt(dir)=5.0,bt(dir)=7.0,bt(crs)=12.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1037,"!לוּחַ","n","02572848","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"board, plank, slab, tablet, sheet",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=4.0,bt(dir)=6.0,bt(dir)=5.0,bt(crs)=11.0] #MZ@\r\n#NO","ordan-29 Jul 2004, assign-6 Nov 2003",0,"2004-07-29");
INSERT INTO hebrew_synonyms VALUES (1038,"!לוּחַ","n","03348184","y","melingo","2","rav-milim",NULL,"tg1",NULL,"board, plank, slab, tablet, sheet",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1039,"לוּחַ","n","02493245","yy","melingo","1.4","rav-milim","1.4","tg1",NULL,"control_panel",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,bt(dir)=4.0,dfl=7.0] #MZ@\r\n#NO","ordan-29 Jul 2004",91196,"2004-07-29");
INSERT INTO hebrew_synonyms VALUES (1040,"!לוּחַ","n","05621336","y","melingo","6","rav-milim",NULL,"tg1",NULL,"table, list",NULL,NULL,"assigned","#ASSIGN:50=[gnd=7.0,bt(dir)=5.0,bt(dir)=7.0,bt(crs)=12.0,dfl=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1041,"!מְאַמֵּן","n","07632177","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"trainer, coach, instructor",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-22 Nov 2004, assign-6 Nov 2003",0,"2004-11-22");
INSERT INTO hebrew_synonyms VALUES (1042,"!מְאוֹד","r","00054768","y","melingo","1","rav-milim",NULL,"tg1",NULL,"very, very_much, greatly",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1043,"!מְאוֹד","r","00507366","u","melingo","1","rav-milim",NULL,"tg1",NULL,"very, very_much, greatly",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE may possibly fit to ''ממש'', but there are other words (precisely, exactly) which fit better","eyal-08 Nov 2004, assign-6 Nov 2003",0,"2004-11-08");
INSERT INTO hebrew_synonyms VALUES (1044,"מְאוֹד","r","00031106","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"very",NULL,"היא פסנתרנית מאוד מוכשרת; העבודה הזו מאוד קשה לי","checked","#ASSIGN:43.0=[gnd=2.0E+01,bt(dir)=23.0] #MZ@\r\n#IE","eyal-08 Nov 2004, assign-6 Nov 2003",93601,"2004-11-08");
INSERT INTO hebrew_synonyms VALUES (1046,"מְדִינִיּוּת","n","04991678","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"policy",NULL,"התקיים דיון בנוגע למדיניות החדשה של הממשלה בנושא המסים","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-09 Jan 2005, assign-6 Nov 2003",94127,"2005-01-09");
INSERT INTO hebrew_synonyms VALUES (1047,"!מְדִינִיּוּת","n","04897248","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"policy",NULL,NULL,"checked","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@\r\n#IE","eyal-09 Jan 2005, assign-6 Nov 2003",0,"2005-01-09");
INSERT INTO hebrew_synonyms VALUES (1048,"מְדִינִיּוּת","n","04536028","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"policy",NULL,"המדיניות בחברה בה עבד היתה לקדם עובדים מצטיינים, ללא קשר לותק שלהם בחברה","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-10 Jan 2005, assign-6 Nov 2003",94127,"2005-01-10");
INSERT INTO hebrew_synonyms VALUES (6448,"נָתִין","n","06952517","yy","melingo","1.2","rav-milim","1.1",NULL,NULL,"national, subject",NULL,"המונארך מחויב לנתיניו","checked","#NO","ordan-12 Feb 2004",91197,"2004-02-12");
INSERT INTO hebrew_synonyms VALUES (1050,"!מְדִינָה","n","06074189","u","melingo","1","rav-milim",NULL,"tg1",NULL,"state, country",NULL,NULL,"checked","#ASSIGN:79.0=[gnd=6.0,gnd=8.0,si=9.0,bt(dir)=5.0,bt(dir)=6.0,bt(dir)=3.0,bt(crs)=28.0,bt(dir)=5.0,bt(dir)=6.0,bt(dir)=3.0] #MZ@","ordan-12 Feb 2004, assign-6 Nov 2003",0,"2004-02-12");
INSERT INTO hebrew_synonyms VALUES (1052,"!מְדִינָה","n","06060831","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"state, country",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-16 Nov 2004, assign-6 Nov 2003",0,"2004-11-16");
INSERT INTO hebrew_synonyms VALUES (1053,"מְהִירוּת","n","03948579","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"speed, swiftness",NULL,"הפרוייקט התקדם במהירות משביעת רצון","checked","#ASSIGN:50=[gnd=39.0,bt(dir)=1.0E+01,dfl=1.0] #MZ@\r\n#IE refers to the second part of RM\'s definition","eyal-09 Jan 2005, assign-6 Nov 2003",94119,"2005-01-09");
INSERT INTO hebrew_synonyms VALUES (1054,"!מְהוּמָה","n","00361442","y","melingo","1","rav-milim",NULL,"tg1",NULL,"commotion, tumult, hullabaloo",NULL,NULL,"assigned","#ASSIGN:42.0=[gnd=13.0,gnd=13.0,si=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1055,"!מְהוּמָה","n","00361901","y","melingo","1","rav-milim",NULL,"tg1",NULL,"commotion, tumult, hullabaloo",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1056,"!מְחַדֵּשׁ","n","07524212","n","melingo","2","rav-milim",NULL,"tg1",NULL,"renovator",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE gender","eyal-10 Oct 2005, assign-6 Nov 2003",0,"2005-10-10");
INSERT INTO hebrew_synonyms VALUES (1057,"מְכוֹנִית","n","02383458","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"car, automobile",NULL,"הגן נמצא במרחק הליכה, אין צורך לנסוע לשם במכונית","checked","#ASSIGN:85.0=[gnd=8.0,gnd=39.0,si=2.0E+01,bt(dir)=9.0,bt(dir)=9.0] #MZ@\r\n#IE","eyal-26 Sep 2004",93421,"2004-09-26");
INSERT INTO hebrew_synonyms VALUES (1058,"!מְסַפֵּר","n","07427770","n","melingo","1","rav-milim",NULL,"tg1",NULL,"narrator, storyteller",NULL,NULL,"assigned","#ASSIGN:108.0=[gnd=39.0,gnd=2.0E+01,si=49.0] #MZ@\r\n#IE gender","eyal-09 Oct 2005, assign-6 Nov 2003",0,"2005-10-09");
INSERT INTO hebrew_synonyms VALUES (1059,"מְעֹרָב","a","01272749","yy","melingo","1.3","rav-milim","1.4b","tg1",NULL,"coeducational",NULL,"דתיים אורתודוקסים אינם שולחים את ילדיהם לבתי ספר מעורבים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-21 Oct 2004, assign-6 Nov 2003",93521,"2004-10-21");
INSERT INTO hebrew_synonyms VALUES (1060,"!מְפַקֵּד","n","07168973","n","melingo","1","rav-milim",NULL,"tg1","((military))","commander, commanding_officer",NULL,NULL,"assigned","#ASSIGN:138.0=[gnd=1.0E+01,gnd=39.0,flc(dic)=16.0,flc(dic)=49.0,si=24.0] #MZ@\r\n#IE gender","eyal-19 Sep 2005, assign-6 Nov 2003",0,"2005-09-19");
INSERT INTO hebrew_synonyms VALUES (1061,"!מְפַקֵּד","n","07168653","y","melingo","1","rav-milim",NULL,"tg1","((military))","commander, commanding_officer",NULL,NULL,"assigned","#ASSIGN:26.0=[gnd=1.0E+01,flc(dic)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1062,"!מְפַקֵּד","n","07069167","n","melingo","1","rav-milim",NULL,"tg1","((military))","commander, commanding_officer",NULL,NULL,"assigned","#ASSIGN:26.0=[gnd=1.0E+01,flc(dic)=16.0] #MZ@\r\n#IE","eyal-18 Sep 2005, assign-6 Nov 2003",0,"2005-09-18");
INSERT INTO hebrew_synonyms VALUES (1063,"מְצָד","n","02354112","yy","melingo","1.1","rav-milim","1.1","tg1","((military))","bunker",NULL,NULL,"checked","#ASSIGN:69.0=[gnd=2.0E+01,flc(dic)=49.0] #MZ@\r\n#IE","eyal-08 Sep 2004",93252,"2004-09-08");
INSERT INTO hebrew_synonyms VALUES (1064,"!מְצָד","n","03431121","y","melingo","2","rav-milim",NULL,"tg1",NULL,"stronghold",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1065,"!מְרַכֵּז","n","07183159","n","melingo","1","rav-milim",NULL,"tg1",NULL,"coordinator",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE gender","eyal-20 Sep 2005, assign-6 Nov 2003",0,"2005-09-20");
INSERT INTO hebrew_synonyms VALUES (1066,"!מְשֻׁתָּף","a","02069778","y","melingo","1","rav-milim",NULL,"tg1",NULL,"common, shared, joint",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1067,"!מְשֻׁתָּף","a","00234849","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"common, shared, joint",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE ","eyal-30 Dec 2004, assign-6 Nov 2003",0,"2004-12-30");
INSERT INTO hebrew_synonyms VALUES (1068,"!מְשֻׁתָּף","a","02037068","y","melingo","1","rav-milim",NULL,"tg1",NULL,"common, shared, joint",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1069,"!מִגְרָשׁ","n","06318048","y","melingo","3","rav-milim",NULL,"tg1","((sports))","field, court",NULL,NULL,"assigned","#ASSIGN:28.0=[gnd=2.0,flc(dic)=24.0,bt(dir)=2.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1070,"!מִגְרָשׁ","n","05992155","y","melingo","3","rav-milim",NULL,"tg1","((sports))","field, court",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=2.0,flc(dic)=24.0,bt(dir)=3.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1071,"!מִגְרָשׁ","n","02511316","y","melingo","3","rav-milim",NULL,"tg1","((sports))","field, court",NULL,NULL,"assigned","#ASSIGN:53.0=[gnd=4.0,flc(dic)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1072,"מִדַּי","r","00045916","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"too, overly",NULL,"הבית הזה גדול מדי בשבילנו","checked","#ASSIGN:108.0=[gnd=2.0E+01,gnd=39.0,si=49.0] #MZ@\r\n#IE","eyal-09 Nov 2004, assign-6 Nov 2003",93607,"2004-11-09");
INSERT INTO hebrew_synonyms VALUES (1073,"מִדָּה","n","03972490","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"measurement",NULL,"אני זקוקה למידת נעליים גדולה יותר","checked","#ASSIGN:66.0=[gnd=2.0E+01,bt(dir)=4.0,bt(dir)=19.0,bt(crs)=23.0] #MZ@\r\n#IE","eyal-10 Aug 2004",91198,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (1074,"!מִדָּה","n","00643864","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"measurement",NULL,NULL,"checked","#ASSIGN:7.0E+01=[gnd=2.0E+01,bt(dir)=21.0,bt(dir)=4.0,bt(crs)=25.0] #MZ@\r\n#IE","eyal-03 Jan 2005, assign-6 Nov 2003",0,"2005-01-03");
INSERT INTO hebrew_synonyms VALUES (1075,"!מִדָּה","n","09953487","nn","melingo","3","rav-milim",NULL,"tg1",NULL,"ratio",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO not in math","ordan-15 Jul 2004, assign-6 Nov 2003",0,"2004-07-15");
INSERT INTO hebrew_synonyms VALUES (1076,"מִדָּה","n","10045533","yy","melingo","1.4","rav-milim","1.4","tg1",NULL,"extent",NULL,"מצבו הכלכלי השתפר במידה רבה","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-24 May 2004, assign-6 Nov 2003",91198,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (1077,"!מִדָּה","n","06667120","y","melingo","4","rav-milim",NULL,"tg1",NULL,"extent",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1078,"!מִדָּה","n","03991813","y","melingo","4","rav-milim",NULL,"tg1",NULL,"extent",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1079,"מִזְרָח","n","09964070","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"east",NULL,"האונייה פנתה לכיוון מזרח","checked","#ASSIGN:78.0=[gnd=39.0,bt(dir)=39.0] #MZ@\r\n#IE","eyal-18 Nov 2004, assign-6 Nov 2003",93716,"2004-11-18");
INSERT INTO hebrew_synonyms VALUES (1080,"מִחְזוּר","n","00607051","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"recycling",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-08 Aug 2004, assign-6 Nov 2003",0,"2004-08-08");
INSERT INTO hebrew_synonyms VALUES (1081,"מִי","n","05139537","yy","melingo","2.1","rav-milim","2.1","tg1","((music))","mi",NULL,NULL,"checked","#ASSIGN:59.0=[gnd=1.0E+01,flc(dic)=49.0] #MZ@\r\n#IE","eyal-02 Oct 2004, assign-6 Nov 2003",93430,"2004-10-02");
INSERT INTO hebrew_synonyms VALUES (1082,"מִי","n","05118893","yy","melingo","3.1","rav-milim","3.1","tg2",NULL,"mu, the_12th_letter_of_the_Greek_alphabet",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-02 Oct 2004, assign-6 Nov 2003",93430,"2004-10-02");
INSERT INTO hebrew_synonyms VALUES (1083,"!מִיָּד","r","00500428","y","melingo","1","rav-milim",NULL,"tg1",NULL,"promptly, immediately",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1084,"!מִיָּד","r","00500318","y","melingo","1","rav-milim",NULL,"tg1",NULL,"promptly, immediately",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1085,"מִיָּד","r","00047341","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"immediately",NULL,"קראתי לו והוא ענה מיד","checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#IE","eyal-15 May 2005, eyal-23 Dec 2004, assign-6 Nov 2003",93925,"2005-05-15");
INSERT INTO hebrew_synonyms VALUES (1086,"!מִיָּד","r","00102338","y","melingo","1","rav-milim",NULL,"tg1",NULL,"promptly, immediately",NULL,NULL,"assigned","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1087,"!מִיָּד","r","00102202","y","melingo","1","rav-milim",NULL,"tg1",NULL,"promptly, immediately",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1088,"!מִיָּד","r","00102070","y","melingo","1","rav-milim",NULL,"tg1",NULL,"promptly, immediately",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1089,"מִילְיוֹן","n","09902865","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"million",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE","eyal-11 Nov 2004, assign-6 Nov 2003",93652,"2004-11-11");
INSERT INTO hebrew_synonyms VALUES (1090,"מִישֶׁהוּ","n","00004123","yy","melingo","1","rav-milim","1","tg1",NULL,"someone, somebody",NULL,"מישהו דופק בדלת","checked","#ASSIGN:176.0=[gnd=39.0,gnd=39.0,si=98.0] #MZ@ #IE","eyal-04 Feb 2004, assign-6 Nov 2003",91199,"2004-02-04");
INSERT INTO hebrew_synonyms VALUES (1091,"מִלְחָמָה","n","00614914","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"battle, struggle",NULL,"המשטרה החליטה לצאת למלחמה בכנופיות הפשע","checked","#ASSIGN:38.0=[gnd=13.0,gnd=13.0,si=12.0] #MZ@\r\n#IE","eyal-01 Feb 2005, eyal-08 Aug 2004, assign-6 Nov 2003",92865,"2005-02-01");
INSERT INTO hebrew_synonyms VALUES (1092,"!מִלְחָמָה","n","00610417","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"battle, struggle, fight",NULL,NULL,"checked","#ASSIGN:33.0=[gnd=13.0,gnd=8.0,si=12.0] #MZ@\r\n#IE קרב is a part of מלחמה","eyal-08 Aug 2004, assign-6 Nov 2003",0,"2004-08-08");
INSERT INTO hebrew_synonyms VALUES (1093,"!מִלְחָמָה","n","00505798","u","melingo","2","rav-milim",NULL,"tg1",NULL,"battle, struggle, fight",NULL,NULL,"checked","#ASSIGN:38.0=[gnd=13.0,gnd=13.0,si=12.0] #MZ@\r\n#IE the gloss does not correspond with any of RM\'s definitions","eyal-08 Aug 2004, assign-6 Nov 2003",0,"2004-08-08");
INSERT INTO hebrew_synonyms VALUES (1094,"מִמְשָׁל","n","06000383","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"regime, government",NULL,NULL,"checked","#ASSIGN:74.0=[gnd=2.0E+01,gnd=1.0E+01,si=2.0E+01,bt(dir)=12.0,bt(dir)=12.0] #MZ@\r\n#IE","eyal-16 Nov 2004, assign-6 Nov 2003",93700,"2004-11-16");
INSERT INTO hebrew_synonyms VALUES (1095,"מִנּוּי","n","09557875","yy","melingo","1.1","rav-milim","1.1","tg2",NULL,"subscription",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE WN restricts the meaning of ''subscription'' to getting ''consecutive issues of a newspaper or magazine'', while RM refers to any regular supply of product or service","eyal-14 Nov 2004, assign-6 Nov 2003",93662,"2004-11-14");
INSERT INTO hebrew_synonyms VALUES (1096,"!מִנּוּי","n","05367055","y","melingo","1","rav-milim",NULL,"tg2",NULL,"subscription",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1097,"!מִנּוּי","n","00706704","y","melingo","1","rav-milim",NULL,"tg2",NULL,"subscription",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1098,"!מִסְגֶּרֶת","n","02720094","y","melingo","1","rav-milim",NULL,"tg1",NULL,"frame",NULL,NULL,"assigned","#ASSIGN:50=[gnd=7.0,bt(dir)=13.0,bt(dir)=6.0,bt(crs)=19.0,dfl=5.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1099,"!מִסְגֶּרֶת","n","04527384","y","melingo","2","rav-milim",NULL,"tg1",NULL,"framework",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1100,"שֶׁלֶד","n","03860008","yy","melingo","2","rav-milim","2","tg1",NULL,"framework",NULL,"השלד של הבנין היה רעוע","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-22 Jan 2004, assign-6 Nov 2003",91200,"2004-01-22");
INSERT INTO hebrew_synonyms VALUES (8401,"לִיפְּסְטִיק","n","02931334","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"lipstick",NULL,NULL,"checked","#IE","eyal-16 Mar 2005",94751,"2005-03-16");
INSERT INTO hebrew_synonyms VALUES (1102,"מִסְחֵר","v","00328216","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"commercialize",NULL,"כמה מבני האמיש מיסחרו את סגנון חייהם","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-08 Nov 2004, assign-6 Nov 2003",93595,"2004-11-08");
INSERT INTO hebrew_synonyms VALUES (1103,"!מִסְחָר","n","05340125","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"trade, commerce",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-18 Nov 2004, assign-6 Nov 2003",0,"2004-11-18");
INSERT INTO hebrew_synonyms VALUES (1104,"!מִסְחָר","n","00706993","y","melingo","1","rav-milim",NULL,"tg1",NULL,"trade, commerce",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1105,"!מִסְחָר","n","06058462","y","melingo","1","rav-milim",NULL,"tg1",NULL,"trade, commerce",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1106,"!מִסְמָךְ","n","04864239","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"certificate, diploma",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE too general","eyal-15 May 2005, eyal-10 Jan 2005, assign-6 Nov 2003",0,"2005-05-15");
INSERT INTO hebrew_synonyms VALUES (1107,"!מִסְפָּר","n","05097671","y","melingo","1","rav-milim",NULL,"tg1",NULL,"numeral, digit",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,bt(dir)=4.0,dfl=7.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1108,"!מִפְגָּשׁ","n","02716453","y","melingo","2","rav-milim",NULL,"tg1",NULL,"meeting_place",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1109,"מִפְלָגָה","n","06131180","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"political_party",NULL,"לא נתתי את קולי למפלגת השילטון בבחירות האחרונות","checked","#ASSIGN:50=[gnd=39.0,bt(dir)=9.0,dfl=2.0] #MZ@\r\n#IE","eyal-15 Nov 2004, assign-6 Nov 2003",93694,"2004-11-15");
INSERT INTO hebrew_synonyms VALUES (1110,"!מִפְעָל","n","02662271","y","melingo","1","rav-milim",NULL,"tg1",NULL,"factory, production_plant",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1111,"!מִפְעָל","n","00508925","y","melingo","2","rav-milim",NULL,"tg1",NULL,"undertaking, enterprise, project",NULL,NULL,"assigned","#ASSIGN:68.0=[gnd=39.0,gnd=13.0,si=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1112,"מִפְקָד","n","00427077","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"census",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-30 Aug 2004, eyal-08 Aug 2004, assign-6 Nov 2003",92862,"2004-08-30");
INSERT INTO hebrew_synonyms VALUES (1113,"מִקְרֶה","n","05432762","yy","melingo","1.1","sapir","1.2","tg1",NULL,"occurrence",NULL,"קרו כל מיני מקרים מוזרים בזמן האחרון","checked","#ASSIGN:33.0=[gnd=2.0E+01,bt(dir)=13.0] #MZ@\r\n#IE","eyal-07 Jul 2005, assign-6 Nov 2003",93971,"2005-07-07");
INSERT INTO hebrew_synonyms VALUES (1114,"מִקְרֶה","n","05448971","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"instance, case, example",NULL,"מקרה נוסף התרחש אתמול; יש את המקרה המפורסם של משפחת כהן","checked","#ASSIGN:34.0=[gnd=13.0,gnd=2.0,gnd=7.0,si=6.0,bt(dir)=2.0,bt(dir)=2.0,bt(dir)=2.0] #MZ@\r\n#IE","eyal-11 Jan 2005, assign-6 Nov 2003",93971,"2005-01-11");
INSERT INTO hebrew_synonyms VALUES (1115,"מִקְרֶה","n","10047274","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"case",NULL,"לפי התחזית עשוי לרדת גשם, במקרה כזה, הפיקניק יבוטל","checked","#ASSIGN:34.0=[gnd=2.0,bt(dir)=14.0,bt(dir)=2.0,bt(crs)=16.0] #MZ@\r\n#IE always precedes by ב","eyal-27 Dec 2004, assign-6 Nov 2003",93971,"2004-12-27");
INSERT INTO hebrew_synonyms VALUES (1116,"!מִרְכֵּז","v","01825948","u","melingo","1","rav-milim",NULL,"tg1","((graphic design))","center",NULL,NULL,"checked","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@\r\n#IE","eyal-08 Nov 2004, assign-6 Nov 2003",0,"2004-11-08");
INSERT INTO hebrew_synonyms VALUES (1117,"!מִרְכֵּז","v","01265527","y","melingo","1","rav-milim",NULL,"tg1","((graphic design))","center",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1118,"!מִרְכֵּז","v","00489333","u","melingo","1","rav-milim",NULL,"tg1","((graphic design))","center",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-08 Nov 2004, assign-6 Nov 2003",0,"2004-11-08");
INSERT INTO hebrew_synonyms VALUES (1119,"מִרְכֵּז","v","00281483","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"centralize",NULL,"הממשלה הרוסית החליטה למרכז את פעילות חלוקת המזון לנזקקים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE refers mainly to the first part of RM\'s definition","eyal-23 Dec 2004, assign-6 Nov 2003",0,"2004-12-23");
INSERT INTO hebrew_synonyms VALUES (1120,"מִשְׁטָרָה","n","06093563","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"police",NULL,"המשטרה באה לחפש אותך","checked","#ASSIGN:72.0=[gnd=39.0,bt(dir)=33.0] #MZ@\r\n#IE refers to the second part of RM\'s definition","eyal-13 Sep 2004",93284,"2004-09-13");
INSERT INTO hebrew_synonyms VALUES (1121,"מִשְׂחָק","n","00358063","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"acting",NULL,"המשחק של שחקנית המשנה היה טוב לאין ערוך מזה של השחקנית הראשית","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-04 Aug 2004, assign-6 Nov 2003",91201,"2004-08-04");
INSERT INTO hebrew_synonyms VALUES (1122,"!מִשְׂרָד","n","06182017","y","melingo","1","rav-milim",NULL,"tg1",NULL,"office",NULL,NULL,"assigned","#ASSIGN:50=[gnd=6.0,bt(dir)=11.0,bt(dir)=5.0,bt(crs)=16.0,dfl=12.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1123,"!מִשְׂרָד","n","06182017","y","melingo","2","rav-milim",NULL,"tg1",NULL,"bureau",NULL,NULL,"assigned","#ASSIGN:45.0=[gnd=13.0,bt(dir)=11.0,bt(dir)=5.0,bt(crs)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1124,"!מִשְׂרָד","n","02428247","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"bureau",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-17 May 2004",0,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (1125,"מֵבִין","a","01683181","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"understanding",NULL,"זה בסדר, הוא אדם מבין, אני בטוח שהוא יסלח לך על טעותך","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-26 Oct 2004, assign-6 Nov 2003",91202,"2004-10-26");
INSERT INTO hebrew_synonyms VALUES (1126,"מֵבִין","n","06947056","n","melingo","1","rav-milim","1","tg1",NULL,"expert",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ \r\n#IE gender","eyal-23 Jun 2005, eyal-27 Jan 2004, assign-6 Nov 2003",0,"2005-06-23");
INSERT INTO hebrew_synonyms VALUES (1127,"מֵחָדָשׁ","r","00110345","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"anew",NULL,"אני רוצה להתחיל את חיי מחדש במקום אחר","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-08 Nov 2004, assign-6 Nov 2003",93606,"2004-11-08");
INSERT INTO hebrew_synonyms VALUES (1128,"מֶדַלְיָה","n","05029668","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"decoration, laurel_wreath, medal, medallion",NULL,"המנצח ענד את מדליית הזהב בגאווה רבה","checked","#ASSIGN:176.0=[gnd=39.0,gnd=39.0,si=98.0] #MZ@\r\n#NO","ordan-12 Aug 2004",0,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (1129,"!מֶחְקָר","n","04467719","y","melingo","1","rav-milim",NULL,"tg1",NULL,"research, study",NULL,NULL,"assigned","#ASSIGN:41.0=[gnd=2.0E+01,bt(dir)=21.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1130,"מֶחְקָר","n","00417296","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"research",NULL,"ממחקרים עולה כי העברית לא היתה \'שפה מתה\' במשך אלפי שנים כפי שנהוג היה לחשוב בעבר","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-23 May 2004",91203,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (1131,"מֶטֶר","n","03470891","yy","melingo","1.2","rav-milim","1.2","tg1","((colloquial))","tape_measure",NULL,"הבאתי איתי מטר כדי למדוד את אורך השולחן","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-06 Jan 2005, assign-6 Nov 2003",92251,"2005-01-06");
INSERT INTO hebrew_synonyms VALUES (1132,"!מֶכֶר","n","02987655","y","melingo","2","rav-milim",NULL,"tg1","((biblical))","merchandise",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1133,"!מֶסֶר","n","04949838","y","melingo","1","rav-milim",NULL,"tg1",NULL,"message, theme",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1134,"מֶסֶר","n","04729537","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"message",NULL,"אל תעביר לי מסרים עם שליחים, אמור לי את שברצונך בפניי","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-10 Jun 2004, assign-6 Nov 2003",91204,"2004-06-10");
INSERT INTO hebrew_synonyms VALUES (1135,"מֶרְכָּז","n","06286659","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"center",NULL,"חנות הבגדים נמצאת במרכז העיר","checked","#ASSIGN:50=[gnd=2.0,bt(dir)=2.0,bt(dir)=8.0,bt(crs)=1.0E+01,dfl=28.0] #MZ@\r\n#IE","eyal-15 Nov 2004, assign-6 Nov 2003",93680,"2004-11-15");
INSERT INTO hebrew_synonyms VALUES (7523,"לֵב","n","06286659","yy","melingo","1.1","rav-milim","1.5",NULL,NULL,"heart",NULL,"המוזיאון ממוקם בלב המושבה","checked","#IE","eyal-15 Nov 2004",93205,"2004-11-15");
INSERT INTO hebrew_synonyms VALUES (1137,"מֶשֶׁךְ","n","10859852","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"duration",NULL,"מה משך ההרצאה?","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-09 Nov 2004, assign-6 Nov 2003",93611,"2004-11-09");
INSERT INTO hebrew_synonyms VALUES (1138,"!מֶשֶׁךְ","n","10859737","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"duration",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-23 Dec 2004, assign-6 Nov 2003",0,"2004-12-23");
INSERT INTO hebrew_synonyms VALUES (1139,"!מֶשֶׁךְ","n","03943113","y","melingo","1","rav-milim",NULL,"tg1",NULL,"duration",NULL,NULL,"assigned","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1140,"מֶשֶׁק","n","02666240","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"farm",NULL,NULL,"revised","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","eyal-22 Aug 2004, ordan-24 May 2004",91205,"2004-08-22");
INSERT INTO hebrew_synonyms VALUES (7535,"קִבּוּץ","n","06005150","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"kibbutz",NULL,"בעבר, ילדי הקיבוץ היו ישנים בבתי ילדים ולא בבית ההורים","checked","#IE","eyal-16 Nov 2004",93698,"2004-11-16");
INSERT INTO hebrew_synonyms VALUES (1143,"!מֶשֶׁק","n","06005150","u","melingo","3","rav-milim",NULL,"tg1","((colloquial))","kibbutz, agricultural_settlement",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-16 Nov 2004, assign-6 Nov 2003",0,"2004-11-16");
INSERT INTO hebrew_synonyms VALUES (1144,"מֶתָן","n","10728170","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"methane",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-09 Nov 2004, assign-6 Nov 2003",93613,"2004-11-09");
INSERT INTO hebrew_synonyms VALUES (1145,"מַאֲבָק","n","00614914","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"struggle",NULL,"מאבקו ברשויות סוף סוף נשא פרי","checked","#ASSIGN:67.0=[gnd=13.0,bt(dir)=13.0,bt(dir)=14.0,bt(crs)=27.0] #MZ@\r\n#IE","eyal-01 Feb 2005, eyal-08 Aug 2004, assign-6 Nov 2003",92864,"2005-02-01");
INSERT INTO hebrew_synonyms VALUES (1146,"מַאֲבָק","n","00505798","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"struggle",NULL,"מאבקו למען פתיחת כיתה נוספת בבית הספר היה צודק בהחלט","checked","#ASSIGN:69.0=[gnd=13.0,bt(dir)=14.0,bt(dir)=14.0,bt(crs)=28.0] #MZ@\r\n#IE","eyal-08 Aug 2004, assign-6 Nov 2003",0,"2004-08-08");
INSERT INTO hebrew_synonyms VALUES (1147,"!מַאֲבָק","n","00409719","y","melingo","1","rav-milim",NULL,"tg1",NULL,"struggle",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1148,"מַאֲבָק","n","07991644","yy","melingo","2.1","rav-milim","2.1","tg1","((botany))","anther",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,flc(dic)=49.0] #MZ@\r\n#IE","eyal-29 Dec 2004, assign-6 Nov 2003",92864,"2004-12-29");
INSERT INTO hebrew_synonyms VALUES (1149,"מַאֲמָץ","n","00409314","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"effort, exertion",NULL,"הוא קיבל ציון גבוה על העבודה שהגיש בעיקר בזכות המאמץ שהשקיע","checked","#ASSIGN:79.0=[gnd=1.0E+01,gnd=39.0,si=6.0,bt(dir)=12.0,bt(dir)=12.0] #MZ@\r\n#IE refers to the third part of RM\'s definition","eyal-15 Sep 2005, assign-6 Nov 2003",95297,"2005-09-15");
INSERT INTO hebrew_synonyms VALUES (1150,"מַאֲמָץ","n","00503611","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"effort",NULL,"הוא עשה מאמץ גדול לכסות את כל החומר","checked","#ASSIGN:66.0=[gnd=1.0E+01,bt(dir)=9.0,bt(dir)=19.0,bt(crs)=28.0] #MZ@\r\n#IE refers to the second part of RM\'s definition","eyal-15 Sep 2005, assign-6 Nov 2003",95297,"2005-09-15");
INSERT INTO hebrew_synonyms VALUES (1151,"!מַגָּע","n","05432221","y","melingo","1","rav-milim",NULL,"tg1",NULL,"touch",NULL,NULL,"assigned","#ASSIGN:50=[gnd=3.0,bt(dir)=5.0,bt(dir)=4.0,bt(crs)=9.0,dfl=29.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1152,"!מַגָּע","n","05432221","y","melingo","2","rav-milim",NULL,"tg1",NULL,"contact",NULL,NULL,"assigned","#ASSIGN:50=[gnd=5.0,bt(dir)=5.0,bt(dir)=4.0,bt(crs)=9.0,dfl=27.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1153,"מַדָּד","n","04982561","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"consumer_price_index",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-07 Sep 2004",93250,"2004-09-07");
INSERT INTO hebrew_synonyms VALUES (1154,"מַדָּע","n","04596907","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"science",NULL,"מדע הגנטיקה ביצע מספר פריצות דרך לאחרונה","checked","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@\r\n#IE","eyal-15 Sep 2005, assign-6 Nov 2003",95299,"2005-09-15");
INSERT INTO hebrew_synonyms VALUES (1155,"!מַדָּע","n","04596663","y","melingo","1","rav-milim",NULL,"tg1",NULL,"science",NULL,NULL,"assigned","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1156,"!מַדָּע","n","04359865","y","melingo","1","rav-milim",NULL,"tg1",NULL,"science",NULL,NULL,"assigned","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1157,"!מַחְזוֹר","n","05550105","nn","melingo","4","rav-milim",NULL,"tg1",NULL,"series",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-18 Aug 2004, assign-6 Nov 2003",0,"2004-08-18");
INSERT INTO hebrew_synonyms VALUES (1158,"מַחְזוֹר","n","10981933","yy","melingo","1.5","rav-milim","1.5","tg1",NULL,"menstrual_cycle",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,bt(dir)=6.0,dfl=5.0] #MZ@\r\n#IE abbreviation of ''מחזור חודשי''","eyal-09 Nov 2004, assign-6 Nov 2003",92484,"2004-11-09");
INSERT INTO hebrew_synonyms VALUES (1159,"!מַחְלָקָה","n","06302563","y","melingo","1","rav-milim",NULL,"tg1",NULL,"department, unit, ward",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1160,"מַחְלָקָה","n","06049069","yy","melingo","1","rav-milim","1.1","tg1",NULL,"department, unit, ward",NULL,"תוכל למצוא את מה שאתה מחפש במחלקת כלי בית","revised","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@ #IE","eyal-18 Feb 2004, shuly-11 Jan 2004, assign-6 Nov 2003",91206,"2004-02-18");
INSERT INTO hebrew_synonyms VALUES (6462,"תְּחוּם","n","04506274","yy","none",NULL,"rav-milim","1.2",NULL,NULL,"department",NULL,"מילונאות אינה התחום שלי","checked",NULL,"ordan-15 Feb 2004",91207,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (1162,"!מַחְלָקָה","n","06097081","u","melingo","2","rav-milim",NULL,"tg1","((military))","platoon",NULL,NULL,"checked","#ASSIGN:37.0=[gnd=13.0,flc(dic)=24.0] #MZ@\r\n#IE","eyal-11 Jan 2005, assign-6 Nov 2003",0,"2005-01-11");
INSERT INTO hebrew_synonyms VALUES (1163,"מַחְלָקָה","n","06096872","yy","melingo","1.2","rav-milim","1.2","tg1","((military))","platoon",NULL,NULL,"checked","#ASSIGN:37.0=[gnd=13.0,flc(dic)=24.0] #MZ@\r\n#IE","eyal-16 Nov 2004, assign-6 Nov 2003",91206,"2004-11-16");
INSERT INTO hebrew_synonyms VALUES (1164,"מַחְלָקָה","n","06039237","yy","melingo","1.3","rav-milim","1.3","tg1","((biology))","class",NULL,NULL,"checked","#ASSIGN:6.0E+01=[gnd=5.0,flc(dic)=49.0,bt(dir)=6.0] #MZ@\r\n#IE","eyal-04 Oct 2004, assign-6 Nov 2003",91206,"2004-10-04");
INSERT INTO hebrew_synonyms VALUES (1165,"!מַחְשֵׁב","n","07135102","y","melingo","1","rav-milim",NULL,"tg1",NULL,"computer",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1166,"מַחְשֵׁב","n","02481557","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"computer",NULL,"המחשב שברשותי כבר די מיושן, ואינו מסוגל להתמודד עם קבצים כבדים במיוחד","checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#IE","eyal-10 Aug 2004",92890,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (1167,"!מַחְשֵׁב","n","07135102","y","melingo","2","rav-milim",NULL,"tg1",NULL,"calculator",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1168,"!מַחֲלָה","n","10129713","y","melingo","1","rav-milim",NULL,"tg1",NULL,"sickness, illness, disease, ailment",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1169,"מַחֲלָה","n","10123988","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"sickness, illness",NULL,"כל מחלה שעשויה לעבור מאדם אחד לשני הינה מחלה מדבקת","checked","#ASSIGN:181.0=[gnd=2.0E+01,gnd=39.0,si=24.0,bt(dir)=49.0,bt(dir)=49.0] #MZ@\r\n#IE","eyal-14 Nov 2004, assign-6 Nov 2003",93657,"2004-11-14");
INSERT INTO hebrew_synonyms VALUES (1170,"!מַחֲלָה","n","10207260","y","melingo","1","rav-milim",NULL,"tg1",NULL,"sickness, illness, disease, ailment",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1171,"!מַחֲנֶה","n","02372560","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"camp, encampment",NULL,NULL,"checked","#ASSIGN:50=[gnd=6.0,gnd=13.0,si=11.0,bt(dir)=7.0,bt(dir)=7.0,dfl=6.0] #MZ@\r\n#IE too specific. RM does not distinguish between temporary living quarters built for the army and those which were built for other puprposes.","eyal-24 Aug 2004, assign-6 Nov 2003",0,"2004-08-24");
INSERT INTO hebrew_synonyms VALUES (1172,"מַחֲנֶה","n","02211356","yy","melingo","1.2","rav-milim","1.2","tg1","((military))","army_base",NULL,NULL,"checked","#ASSIGN:9.0E+01=[gnd=39.0,flc(dic)=49.0,bt(dir)=2.0] #MZ@\r\n#IE","eyal-24 Aug 2004",93130,"2004-08-24");
INSERT INTO hebrew_synonyms VALUES (1173,"!מַטָּרָה","n","04587307","u","melingo","1","rav-milim",NULL,"tg1",NULL,"purpose, goal, objective",NULL,NULL,"checked","#ASSIGN:107.0=[gnd=2.0E+01,bt(dir)=8.0,bt(dir)=15.0,bt(dir)=6.0,bt(crs)=58.0] #MZ@\r\n#IE although מטרה can perfectly fit to this synset, I decided to leave it out since it is already assigned to another synset","eyal-10 Jan 2005, assign-6 Nov 2003",0,"2005-01-10");
INSERT INTO hebrew_synonyms VALUES (1174,"!מַטָּרָה","n","03050219","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"purpose, goal, objective",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","ordan-11 Jul 2004, assign-6 Nov 2003",0,"2004-07-11");
INSERT INTO hebrew_synonyms VALUES (1175,"מַטָּרָה","n","04586952","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"goal, end",NULL,"המטרה מקדשת את האמצעים","checked","#ASSIGN:36.0=[gnd=1.0E+01,bt(dir)=1.0E+01,bt(dir)=3.0,bt(crs)=13.0] #MZ@\r\n#NO this refers mainly to the latter part of RM\'s 1.1 definition","ordan-11 Jul 2004, assign-6 Nov 2003",91208,"2004-07-11");
INSERT INTO hebrew_synonyms VALUES (1176,"!מַטָּרָה","n","04588033","u","melingo","1","rav-milim",NULL,"tg1",NULL,"purpose, goal, objective",NULL,NULL,"checked","#ASSIGN:106.0=[gnd=13.0,bt(dir)=9.0,bt(dir)=14.0,bt(dir)=8.0,bt(crs)=62.0] #MZ@\r\n#IE I think the word ''goal'' fits better","eyal-19 Jul 2004, assign-6 Nov 2003",0,"2004-07-19");
INSERT INTO hebrew_synonyms VALUES (1177,"!מַטָּרָה","n","04011535","u","melingo","1","rav-milim",NULL,"tg1",NULL,"purpose, goal, objective",NULL,NULL,"checked","#ASSIGN:43.0=[gnd=13.0,bt(dir)=1.0E+01,bt(dir)=5.0,bt(crs)=15.0] #MZ@\r\n#IE I think that there are other synsets which fit more to מטרה, although this synset is not altogether unsuitable","eyal-09 Jan 2005, assign-6 Nov 2003",0,"2005-01-09");
INSERT INTO hebrew_synonyms VALUES (1178,"!מַטָּרָה","n","03811208","y","melingo","1","rav-milim",NULL,"tg1",NULL,"purpose, goal, objective",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (7997,"תַּכְלִית","n","04587307","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"aim, object",NULL,"תכלית החברה היא לפעול על פי שיקולים עסקיים להשגת רווחיה","checked","#IE","eyal-10 Jan 2005",94128,"2005-01-10");
INSERT INTO hebrew_synonyms VALUES (1180,"!מַמָּשׁ","n","03738112","u","melingo","1","rav-milim",NULL,"tg1",NULL,"reality, substance, concreteness",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE not a quality but the reality itself","eyal-26 Dec 2004, assign-6 Nov 2003",0,"2004-12-26");
INSERT INTO hebrew_synonyms VALUES (1181,"מַמָּשׁ","r","00037263","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:34.0=[gnd=1.0E+01,gnd=1.0E+01,si=14.0] #MZ@\r\n#NO","ordan-15 Apr 2004, assign-6 Nov 2003",91209,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (1182,"!מַמָּשׁ","r","00036639","undef","melingo","1","rav-milim",NULL,"tg1",NULL,"really, truly, very",NULL,NULL,"checked","#ASSIGN:34.0=[gnd=1.0E+01,gnd=1.0E+01,si=14.0] #MZ@\r\n#NO better compare with other dictionaries","ordan-15 Apr 2004",0,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (1183,"מַמָּשׁ","r","00031106","u","melingo","1.1","rav-milim","1.1","tg1",NULL,"really, very",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=1.0E+01,gnd=2.0E+01,si=14.0] #MZ@\r\n#IE already assigned to r#00037263","eyal-08 Nov 2004, assign-6 Nov 2003",0,"2004-11-08");
INSERT INTO hebrew_synonyms VALUES (1184,"!מַמָּשׁ","r","00363408","y","melingo","2","rav-milim",NULL,"tg1",NULL,"precisely, exactly, specifically",NULL,NULL,"assigned","#ASSIGN:5.0E+01=[gnd=13.0,gnd=13.0,si=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1187,"!מַמָּשׁ","r","00039677","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"precisely, exactly, specifically",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-23 Dec 2004, assign-6 Nov 2003",0,"2004-12-23");
INSERT INTO hebrew_synonyms VALUES (1188,"!מַנְהִיג","n","06950891","n","melingo","1","rav-milim",NULL,"tg1",NULL,"leader",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE gender","eyal-18 Sep 2005, assign-6 Nov 2003",0,"2005-09-18");
INSERT INTO hebrew_synonyms VALUES (1189,"!מַנְהִיג","n","02598641","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"leader",NULL,NULL,"assigned","#ASSIGN:37.0=[gnd=2.0E+01,bt(dir)=17.0] #MZ@\r\n#IE","eyal-18 Sep 2005, assign-6 Nov 2003",0,"2005-09-18");
INSERT INTO hebrew_synonyms VALUES (1190,"מַס","n","09580808","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"tax",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE","eyal-14 Nov 2004, assign-6 Nov 2003",93661,"2004-11-14");
INSERT INTO hebrew_synonyms VALUES (1191,"מַסְלוּל","n","06709272","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"path, track, course",NULL,"סופת ההוריקן החריבה רחובות שלמים במסלולה ההרסני","checked","#ASSIGN:63.0=[gnd=1.0E+01,gnd=4.0,gnd=5.0,si=8.0,bt(dir)=4.0,bt(dir)=5.0,bt(crs)=9.0,bt(dir)=4.0,bt(dir)=5.0,bt(dir)=4.0,bt(dir)=5.0] #MZ@\r\n#IE","eyal-14 Nov 2004, assign-6 Nov 2003",93674,"2004-11-14");
INSERT INTO hebrew_synonyms VALUES (1192,"מַסְלוּל","n","03263282","yy","melingo","1.3","rav-milim","1.6","tg1",NULL,"runway",NULL,"המטוס קיבל אישור נחיתה על המסלול המערבי","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-06 Jan 2005, assign-6 Nov 2003",93674,"2005-01-06");
INSERT INTO hebrew_synonyms VALUES (1193,"!מַסָּע","n","10923619","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"hike, march, trek",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-04 Aug 2004, assign-6 Nov 2003",0,"2004-08-04");
INSERT INTO hebrew_synonyms VALUES (1194,"!מַסָּע","n","00198579","y","melingo","2","rav-milim",NULL,"tg1",NULL,"journey, voyage",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1195,"!מַעֲצָר","n","10085503","y","melingo","1","rav-milim",NULL,"tg1",NULL,"remand, detention, custody",NULL,NULL,"assigned","#ASSIGN:74.0=[gnd=13.0,gnd=13.0,si=16.0,bt(dir)=16.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1196,"!מַעֲצָר","n","00743956","y","melingo","1","rav-milim",NULL,"tg1",NULL,"remand, detention, custody",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1197,"!מַעֲצָר","n","00523653","y","melingo","1","rav-milim",NULL,"tg1",NULL,"remand, detention, custody",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1198,"!מַעֲצָר","n","00211896","y","melingo","1","rav-milim",NULL,"tg1",NULL,"remand, detention, custody",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1200,"מַעֲרֶכֶת","n","06009454","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"publishing_house",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-19 Apr 2004, assign-6 Nov 2003",91210,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (1201,"!מַעֲרֶכֶת","n","06102786","y","melingo","4","rav-milim",NULL,"tg1","((biology))","phylum, division",NULL,NULL,"assigned","#ASSIGN:27.0=[gnd=3.0,flc(dic)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1202,"!מַעֲרֶכֶת","n","06102348","u","melingo","4","rav-milim",NULL,"tg1","((biology))","phylum, division",NULL,NULL,"checked","#ASSIGN:27.0=[gnd=3.0,flc(dic)=24.0] #MZ@\r\n#IE RM does not distinguish between the taxonomic groups of plants or animals (see also n#06038109)","eyal-11 Jan 2005, assign-6 Nov 2003",0,"2005-01-11");
INSERT INTO hebrew_synonyms VALUES (1203,"מַעֲרֶכֶת","n","06038109","yy","melingo","1.4","rav-milim","1.9","tg1","((biology))","phylum",NULL,NULL,"checked","#ASSIGN:69.0=[gnd=2.0E+01,flc(dic)=49.0] #MZ@\r\n#IE","eyal-15 Nov 2004, assign-6 Nov 2003",91210,"2004-11-15");
INSERT INTO hebrew_synonyms VALUES (1204,"מַעֲרָב","n","09966059","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"west",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-09 Jul 2004, assign-6 Nov 2003",91211,"2004-07-09");
INSERT INTO hebrew_synonyms VALUES (1205,"מַעֲשֶׂה","n","00017487","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"act",NULL,"סוף מעשה במחשבה תחילה","checked","#ASSIGN:25.0=[gnd=7.0,bt(dir)=6.0,bt(dir)=3.0,bt(crs)=9.0] #MZ@\r\n#NO","ordan-08 Jan 2005, assign-6 Nov 2003",94106,"2005-01-08");
INSERT INTO hebrew_synonyms VALUES (7897,"GAP!","a","01029715","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#NO it seems to be agriculture specific, the closest is in the phrase אדמת בור","ordan-26 Dec 2004",91389,"2004-12-26");
INSERT INTO hebrew_synonyms VALUES (1207,"!מַצָּב","n","06060831","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"situation, condition, status, state",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-16 Nov 2004, assign-6 Nov 2003",0,"2004-11-16");
INSERT INTO hebrew_synonyms VALUES (1208,"מַשְׁבֵּר","n","10040291","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"crisis",NULL,"הם ירדו מנכסיהם בתקופת המשבר הכלכלי","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-10 Nov 2004, assign-6 Nov 2003",93622,"2004-11-10");
INSERT INTO hebrew_synonyms VALUES (7498,"עַמּוּד","n","10017100","yy","melingo","1.1","rav-milim","1.2",NULL,NULL,"pillar, column",NULL,"עמוד עשן דק התמר מעל המדורה והסגיר את מקום חנייתם","checked","#IE","eyal-10 Nov 2004",93623,"2004-11-10");
INSERT INTO hebrew_synonyms VALUES (1211,"מַשְׁבֵּר","n","05520463","yy","melingo","1.1","sapir","1.1","tg1",NULL,"crisis",NULL,"לאחר המשבר, החולה עלול למות, או לחילופין, להבריא","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-10 Nov 2004, assign-6 Nov 2003",93622,"2004-11-10");
INSERT INTO hebrew_synonyms VALUES (1212,"מַשְׁמָעוּתִי","a","02078228","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"significant, important",NULL,"החשיפה לגירויים רבים משמעותית מאוד להתפתחות התינוק","checked","#ASSIGN:6.0E+01=[gnd=1.0E+01,gnd=8.0,si=12.0,bt(dir)=15.0,bt(dir)=15.0] #MZ@\r\n#NO","ordan-23 May 2004",91212,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (1213,"!מַשְׁקִיעַ","n","07344878","n","melingo","1","rav-milim",NULL,"tg1",NULL,"investor",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE gender","eyal-06 Oct 2005, assign-6 Nov 2003",0,"2005-10-06");
INSERT INTO hebrew_synonyms VALUES (1214,"!מַשֶׁהוּ","n","00001740","u","melingo","1","rav-milim",NULL,"tg1",NULL,"something",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE too general","eyal-22 Jun 2005, assign-6 Nov 2003",0,"2005-06-22");
INSERT INTO hebrew_synonyms VALUES (1215,"!מַתָּן","n","00205732","y","melingo","1","rav-milim",NULL,"tg1","((literary))","giving, handing_over",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1216,"!מַתָּן","n","09545730","nn","melingo","2","rav-milim",NULL,"tg1","((biblical))","gift, dowry",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE the biblical usage is as a bride price, and not dowery","eyal-04 Aug 2004, assign-6 Nov 2003",0,"2004-08-04");
INSERT INTO hebrew_synonyms VALUES (1217,"מָדַד","v","00033525","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"try_on",NULL,"הוא מדד 10 חולצות עד שמצא את זו שמצאה חן בעיניו","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-08 Nov 2004, assign-6 Nov 2003",93600,"2004-11-08");
INSERT INTO hebrew_synonyms VALUES (1218,"!מָדַי","n","04734700","nn","melingo","1","rav-milim",NULL,"tg1","((biblical history))","Media",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-10 Jan 2005, assign-6 Nov 2003",0,"2005-01-10");
INSERT INTO hebrew_synonyms VALUES (1219,"מָהִיר","a","00928268","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"quick, speedy",NULL,"תגובתו המהירה מנעה תאונה חמורה","checked","#ASSIGN:49.0=[gnd=7.0,gnd=2.0E+01,si=6.0,bt(dir)=8.0,bt(dir)=8.0] #MZ@\r\n#IE","eyal-10 Oct 2004, assign-6 Nov 2003",93440,"2004-10-10");
INSERT INTO hebrew_synonyms VALUES (1220,"!מָהִיר","a","01218234","y","melingo","1","rav-milim",NULL,"tg1",NULL,"quick, swift, fast, speedy",NULL,NULL,"assigned","#ASSIGN:5.0E+01=[gnd=7.0,gnd=4.0,si=6.0,bt(dir)=7.0,bt(dir)=4.0,bt(crs)=11.0,bt(dir)=7.0,bt(dir)=4.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1221,"!מָהִיר","a","00926833","y","melingo","1","rav-milim",NULL,"tg1",NULL,"quick, swift, fast, speedy",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1222,"מָהִיר","a","00033527","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"nimble",NULL,"צעדיו היו כה מהירים, שבקושי רב הצלחתי להשיג אותו","checked","#ASSIGN:28.0=[gnd=2.0E+01,bt(dir)=8.0] #MZ@\r\n#IE","eyal-10 Oct 2004, assign-6 Nov 2003",93440,"2004-10-10");
INSERT INTO hebrew_synonyms VALUES (1223,"!מָוֶת","n","06851354","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"death",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-19 Aug 2004, assign-6 Nov 2003",0,"2004-08-19");
INSERT INTO hebrew_synonyms VALUES (1224,"מָחָר","n","10964560","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"tomorrow",NULL,"כולנו מקווים למחר טוב יותר","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-09 Nov 2004, assign-6 Nov 2003",93609,"2004-11-09");
INSERT INTO hebrew_synonyms VALUES (1225,"!מָחָר","n","10877003","y","melingo","1","rav-milim",NULL,"tg1",NULL,"tomorrow",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1226,"מָחָר","r","00473486","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"tomorrow",NULL,"מחר אני אלך לבקר אותו בבית החולים","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE","eyal-09 Nov 2004, assign-6 Nov 2003",93609,"2004-11-09");
INSERT INTO hebrew_synonyms VALUES (1227,"!מָחוֹז","n","09535912","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"district, state, province, territory, region",NULL,NULL,"checked","#ASSIGN:58.0=[gnd=13.0,gnd=13.0,si=6.0,bt(dir)=13.0,bt(dir)=13.0] #MZ@\r\n#IE","eyal-27 Dec 2004, assign-6 Nov 2003",0,"2004-12-27");
INSERT INTO hebrew_synonyms VALUES (1228,"מָחוֹז","n","06304618","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"district, territory",NULL,NULL,"checked","#ASSIGN:77.0=[gnd=2.0E+01,gnd=13.0,si=6.0,bt(dir)=19.0,bt(dir)=19.0] #MZ@\r\n#IE","eyal-27 Dec 2004, assign-6 Nov 2003",93976,"2004-12-27");
INSERT INTO hebrew_synonyms VALUES (1229,"!מָחוֹז","n","10411732","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"district, state, province, territory, region",NULL,NULL,"checked","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@\r\n#NO","ordan-05 Feb 2004",0,"2004-02-05");
INSERT INTO hebrew_synonyms VALUES (1230,"!מָחוֹז","n","06374245","y","melingo","1","rav-milim",NULL,"tg1",NULL,"district, state, province, territory, region",NULL,NULL,"assigned","#ASSIGN:51.0=[gnd=6.0,gnd=13.0,si=6.0,bt(dir)=13.0,bt(dir)=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1231,"!מָחוֹז","n","06060831","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"district, state, province, territory, region",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-16 Nov 2004, assign-6 Nov 2003",0,"2004-11-16");
INSERT INTO hebrew_synonyms VALUES (1232,"מָטוֹס","n","02174460","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,NULL,NULL,"הטיסה עוכבה בשעל בעיה במנוע המטוס","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-14 Feb 2004, assign-6 Nov 2003",91213,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (1233,"!מָטוֹס","n","02875044","u","melingo","1","rav-milim",NULL,"tg1",NULL,"jet_plane, airplane",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-04 Jan 2005, assign-6 Nov 2003",0,"2005-01-04");
INSERT INTO hebrew_synonyms VALUES (1234,"מָכַר","v","00579423","yy","melingo","1.2","rav-milim","1.4","tg1","colloquial","deceive",NULL,"במשך שנים הוא מכר לה את זה שהוא אוהב אותה, והיא האמינה לו","checked","#ASSIGN:50=[gnd=7.0,gnd=2.0E+01,si=14.0,dfl=9.0] #MZ@\r\n#IE","eyal-21 Feb 2005, eyal-23 Dec 2004, assign-6 Nov 2003",93921,"2005-02-21");
INSERT INTO hebrew_synonyms VALUES (1235,"!מָלֵא","a","00481645","y","melingo","1","rav-milim",NULL,"tg1",NULL,"full",NULL,NULL,"assigned","#ASSIGN:50=[gnd=4.0,bt(dir)=9.0,bt(dir)=5.0,bt(crs)=14.0,dfl=18.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1236,"!מָלֵא","a","01123172","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"complete, whole",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-12 Oct 2004, assign-6 Nov 2003",0,"2004-10-12");
INSERT INTO hebrew_synonyms VALUES (1237,"!מָלֵא","a","00484924","u","melingo","2","rav-milim",NULL,"tg1",NULL,"complete, whole",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-12 Oct 2004, assign-6 Nov 2003",0,"2004-10-12");
INSERT INTO hebrew_synonyms VALUES (1238,"מָלֵא","a","00481167","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"whole",NULL,"אני מבקש את תשומת לבך המלאה","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-30 Dec 2004, assign-6 Nov 2003",93479,"2004-12-30");
INSERT INTO hebrew_synonyms VALUES (1239,"מָלֵא","a","01999564","u","melingo","1.4","rav-milim",NULL,"tg1","((colloquial))","satiated",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE fits better to a#02189742","eyal-12 Oct 2004, assign-6 Nov 2003",93479,"2004-10-12");
INSERT INTO hebrew_synonyms VALUES (1240,"מָלֵא","a","01488913","yy","melingo","1.5","rav-milim","1.8","tg1","((colloquial))","many",NULL,"יש לי מלא בגדים לתת לך","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-12 Oct 2004, assign-6 Nov 2003",93479,"2004-10-12");
INSERT INTO hebrew_synonyms VALUES (1241,"מָלֶה","n","06547707","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"Male",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-14 Nov 2004, assign-6 Nov 2003",93673,"2004-11-14");
INSERT INTO hebrew_synonyms VALUES (1242,"!מָנוּי","n","07620008","y","melingo","1","rav-milim",NULL,"tg1",NULL,"subscriber, member",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1243,"!מָנוּי","n","07619854","n","melingo","1","rav-milim",NULL,"tg1",NULL,"subscriber, member",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE gender","eyal-02 Nov 2005, assign-6 Nov 2003",0,"2005-11-02");
INSERT INTO hebrew_synonyms VALUES (1244,"!מָנוּי","n","07619717","y","melingo","1","rav-milim",NULL,"tg1",NULL,"subscriber, member",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1246,"מָסַר","v","01526289","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"give",NULL,"המטפלת מסרה את הילד להוריו","checked","#ASSIGN:26.0=[gnd=2.0,bt(dir)=24.0] #MZ@ #IE","eyal-17 May 2004, assign-6 Nov 2003",91214,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (1247,"מָסַר","v","00591857","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"notify",NULL,"מסרתי לו שהגיע הזמן לשלם את שכר הדירה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-08 Nov 2004, assign-6 Nov 2003",91214,"2004-11-08");
INSERT INTO hebrew_synonyms VALUES (1248,"!מָסַר","v","01526132","y","melingo","4","rav-milim",NULL,"tg1",NULL,"transmit, hand_down",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1249,"!מָעֳמָד","n","07136302","y","melingo","1","rav-milim",NULL,"tg1",NULL,"candidate, nominee, contender",NULL,NULL,"assigned","#ASSIGN:1.4E+02=[gnd=2.0E+01,gnd=39.0,si=33.0,bt(dir)=24.0,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1250,"מָעֳמָד","n","06940455","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"candidate",NULL,"הוא היה מועמד רציני ביותר לקבלת פרס נובל","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE refers to the first part of RM\'s definition","eyal-11 Jan 2005, assign-6 Nov 2003",94145,"2005-01-11");
INSERT INTO hebrew_synonyms VALUES (1251,"!מָעֳמָד","n","07535673","y","melingo","1","rav-milim",NULL,"tg1",NULL,"candidate, nominee, contender",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1252,"מָעַל","v","01567643","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"embezzle, misappropriate",NULL,"הפקידה מעלה בכספי הלקוחות אותם הכירה זמן רב כל כך","checked","#ASSIGN:176.0=[gnd=39.0,gnd=39.0,si=98.0] #MZ@\r\n#IE","eyal-07 Nov 2004, assign-6 Nov 2003",93594,"2004-11-07");
INSERT INTO hebrew_synonyms VALUES (1253,"!מָקוֹם","n","00385376","y","melingo","3","rav-milim",NULL,"tg1",NULL,"spot, position",NULL,NULL,"assigned","#ASSIGN:50=[gnd=3.0,gnd=3.0,si=4.0,bt(dir)=2.0,bt(dir)=2.0,bt(crs)=4.0,bt(dir)=2.0,bt(dir)=2.0,dfl=28.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1254,"מָקוֹר","n","06275359","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"source, origin",NULL,"מקור הנהר אוהיו הינו פיטסבורג","checked","#ASSIGN:50=[gnd=6.0,bt(dir)=9.0,bt(dir)=6.0,bt(crs)=15.0,dfl=14.0] #MZ@ #IE","eyal-15 Apr 2004, assign-6 Nov 2003",91031,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (6621,"מוֹצָא","n","06275359","yy","melingo","1.2","rav-milim","1.2",NULL,NULL,"origin",NULL,"מוצא האדם מן הקוף","checked","#IE","eyal-15 Apr 2004",91215,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (1256,"מָשַׁךְ","v","01579864","yy","melingo","1.5","rav-milim","1.13","tg1","((banking))","withdraw",NULL,"היא משכה 2000 שקלים מחשבונה בבנק","checked","#ASSIGN:28.0=[gnd=4.0,flc(dic)=24.0] #MZ@\r\n#IE","eyal-07 Nov 2004, assign-6 Nov 2003",93593,"2004-11-07");
INSERT INTO hebrew_synonyms VALUES (1257,"מוֹל","n","09880332","yy","melingo","1.1","rav-milim","1.1","tg1","((chemistry))","mol, mole",NULL,NULL,"checked","#ASSIGN:62.0=[gnd=39.0,gnd=7.0,si=16.0] #MZ@\r\n#IE","eyal-11 Nov 2004, assign-6 Nov 2003",93654,"2004-11-11");
INSERT INTO hebrew_synonyms VALUES (1258,"!מוֹסָד","n","06217164","y","melingo","1","rav-milim",NULL,"tg1",NULL,"institution, institute",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1259,"מוֹסָד","n","06002286","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"institution",NULL,NULL,"checked","#ASSIGN:42.0=[gnd=1.0E+01,bt(dir)=1.0E+01,bt(dir)=6.0,bt(crs)=16.0] #MZ@\r\n#IE","eyal-16 Nov 2004, assign-6 Nov 2003",93699,"2004-11-16");
INSERT INTO hebrew_synonyms VALUES (1260,"!מוֹעֲדוֹן","n","02458761","y","melingo","2","rav-milim",NULL,"tg1",NULL,"clubhouse, cultural_hall",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,bt(dir)=8.0,dfl=3.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1261,"מוֹעָצָה","n","06167708","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"council",NULL,"מועצת העירייה הינה גורם שבידיו הסמכות והיכולת לאשר נושאים ועניינים שהוגדרו בחוק","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-15 Nov 2004, assign-6 Nov 2003",93693,"2004-11-15");
INSERT INTO hebrew_synonyms VALUES (1262,"!מוֹעָצָה","n","06167560","y","melingo","1","rav-milim",NULL,"tg1",NULL,"council",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1263,"!מוֹרֶה","n","07632177","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"teacher, instructor, educator",NULL,NULL,"checked","#ASSIGN:1.4E+02=[gnd=2.0E+01,gnd=39.0,si=33.0,bt(dir)=24.0,bt(dir)=24.0] #MZ@\r\n#NO","ordan-18 Feb 2005, assign-6 Nov 2003",0,"2005-02-18");
INSERT INTO hebrew_synonyms VALUES (1264,"!מוֹרֶה","n","04507240","y","melingo","1","rav-milim",NULL,"tg1",NULL,"teacher, instructor, educator",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1265,"!מוֹרֶה","n","07235322","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"teacher, instructor, educator",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-18 Feb 2005, assign-6 Nov 2003",0,"2005-02-18");
INSERT INTO hebrew_synonyms VALUES (1266,"מוּזֵאוֹן","n","03024989","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"museum",NULL,"בשבת האחרונה ביקרנו במוזיאון טבע והיסטוריה קטן וחביב","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE","eyal-10 Aug 2004",92893,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (6884,"מֻכָּר","a","01320533","yy","melingo","1.1","rav-milim","1.2",NULL,NULL,"known",NULL,"העבריין הזה מוכר למשטרה","checked","#NO","ordan-26 Jun 2004",91216,"2004-06-26");
INSERT INTO hebrew_synonyms VALUES (1268,"!מנכ''ל","n","07153122","y","melingo","1","rav-milim",NULL,"tg1",NULL,"CEO, chief_executive_officer, general_manager, president, director-general",NULL,NULL,"assigned","#ASSIGN:9.0E+01=[gnd=39.0,gnd=39.0,si=12.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1269,"!מנכ''ל","n","07287045","y","melingo","1","rav-milim",NULL,"tg1",NULL,"CEO, chief_executive_officer, general_manager, president, director-general",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1270,"!נְקֻדָּה","n","05126526","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"period, full_stop",NULL,NULL,"checked","#ASSIGN:86.0=[gnd=4.0,gnd=39.0,si=11.0,bt(dir)=4.0,bt(dir)=1.0,bt(dir)=3.0,bt(crs)=16.0,bt(dir)=4.0,bt(dir)=1.0,bt(dir)=3.0] #MZ@\r\n#NO","ordan-17 Aug 2004, assign-6 Nov 2003",0,"2004-08-17");
INSERT INTO hebrew_synonyms VALUES (1271,"נְקֻדָּה","n","05101450","yy","melingo","1.5","rav-milim","1.5","tg1",NULL,"decimal_point",NULL,NULL,"checked","#ASSIGN:43.0=[gnd=39.0,bt(dir)=1.0,bt(dir)=1.0,bt(crs)=2.0] #MZ@\r\n#NO","ordan-12 Aug 2004",0,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (1272,"נְקֻדָּה","n","05126526","yy","melingo","2.1","rav-milim","1.2","tg1",NULL,"period, point, full_stop",NULL,"בסוף משפט זה יש נקודה.","checked","#ASSIGN:26.0=[gnd=2.0,bt(dir)=4.0,bt(dir)=1.0,bt(dir)=3.0,bt(crs)=16.0] #MZ@\r\n#NO","ordan-17 Aug 2004",92955,"2004-08-17");
INSERT INTO hebrew_synonyms VALUES (1273,"!נְקֻדָּה","n","10983365","u","melingo","7","rav-milim",NULL,"tg1",NULL,"stage, phase",NULL,NULL,"checked","#ASSIGN:50=[gnd=5.0,gnd=1.0E+01,si=9.0,dfl=26.0] #MZ@\r\n#IE I think it matches n#10044643 more","eyal-17 Mar 2005, assign-6 Nov 2003",0,"2005-03-17");
INSERT INTO hebrew_synonyms VALUES (1274,"נְשִׂיאוּת","n","00388267","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"chairmanship",NULL,"עם התפטרותו מהתפקיד, עברה נשיאות הועדה לידי ממלא מקומו","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-23 Feb 2005, assign-6 Nov 2003",94606,"2005-02-23");
INSERT INTO hebrew_synonyms VALUES (1275,"!נְשִׂיאוּת","n","06200783","u","melingo","3","rav-milim",NULL,"tg1",NULL,"directorate",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE I am not sure נשיאות is similar to דירקטוריון","eyal-03 Dec 2005, assign-6 Nov 2003",0,"2005-12-03");
INSERT INTO hebrew_synonyms VALUES (1276,"!נִבְחֶרֶת","n","06023189","n","melingo","1","rav-milim",NULL,"tg1",NULL,"first_team, top_team",NULL,NULL,"assigned","#ASSIGN:58.0=[gnd=39.0,bt(dir)=19.0] #MZ@\r\n#IE","eyal-03 Dec 2005, assign-6 Nov 2003",0,"2005-12-03");
INSERT INTO hebrew_synonyms VALUES (1277,"!נִבְחָר","a","00806061","y","melingo","2","rav-milim",NULL,"tg1",NULL,"chosen, elected",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1278,"!נִבְחָר","a","02047878","y","melingo","2","rav-milim",NULL,"tg1",NULL,"chosen, elected",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1279,"!נִהוּל","v","01656373","y","melingo","1","rav-milim",NULL,"tg1",NULL,"manage, administrate, organize",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1280,"!נִכְנַס","v","01133757","y","melingo","2","rav-milim",NULL,"tg1",NULL,"begin, commence, start",NULL,NULL,"assigned","#ASSIGN:33.0=[gnd=6.0,gnd=13.0,gnd=4.0,si=1.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1281,"!נִכְנַס","v","00242403","y","melingo","2","rav-milim",NULL,"tg1",NULL,"begin, commence, start",NULL,NULL,"assigned","#ASSIGN:33.0=[gnd=6.0,gnd=13.0,gnd=4.0,si=1.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1282,"!נִכְנַס","v","00239960","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"begin, commence, start",NULL,NULL,"checked","#ASSIGN:33.0=[gnd=6.0,gnd=13.0,gnd=4.0,si=1.0E+01] #MZ@ #IE should not be a part of the sunset","eyal-15 May 2004, assign-6 Nov 2003",0,"2004-05-15");
INSERT INTO hebrew_synonyms VALUES (1283,"נִכְנַס","v","00845185","yy","melingo","1.4","rav-milim","1.6","tg1","((colloquial))","hit, bump_into",NULL,"תסתכל לאן אתה הולך! כמעט נכנסת בי!","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO\r\n#IE","eyal-10 Jul 2005, ordan-22 Aug 2004, assign-6 Nov 2003",93119,"2005-07-10");
INSERT INTO hebrew_synonyms VALUES (1284,"!נִמְנָע","a","00334532","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"avoidable",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-06 Dec 2004, assign-6 Nov 2003",0,"2004-12-06");
INSERT INTO hebrew_synonyms VALUES (1285,"נִסָּיוֹן","n","00503611","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"try, attempt",NULL,"רק בניסיון השלישי היא הצליחה לסיים את כל המסלול","checked","#ASSIGN:269.0=[gnd=2.0E+01,gnd=2.0E+01,si=49.0,bt(dir)=17.0,bt(dir)=9.0,bt(dir)=19.0,bt(crs)=9.0E+01,bt(dir)=17.0,bt(dir)=9.0,bt(dir)=19.0] #MZ@\r\n#IE","eyal-15 Sep 2005, assign-6 Nov 2003",95298,"2005-09-15");
INSERT INTO hebrew_synonyms VALUES (1286,"!נִסָּיוֹן","n","00494444","y","melingo","1","rav-milim",NULL,"tg1",NULL,"try, attempt",NULL,NULL,"assigned","#ASSIGN:41.0=[gnd=2.0E+01,bt(dir)=21.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1287,"!נִסָּיוֹן","n","05434281","y","melingo","3","rav-milim",NULL,"tg1",NULL,"experience",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1288,"!נִסָּיוֹן","n","04589992","n","melingo","3","rav-milim",NULL,"tg1",NULL,"experience",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-30 Nov 2005, assign-6 Nov 2003",0,"2005-11-30");
INSERT INTO hebrew_synonyms VALUES (1289,"נִסָּיוֹן","n","04441868","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"experience",NULL,"הניסיון הוא המורה הטוב ביותר","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-30 Nov 2005, assign-6 Nov 2003",95298,"2005-11-30");
INSERT INTO hebrew_synonyms VALUES (1290,"נִצָּחוֹן","n","05556959","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"victory, triumph",NULL,"נצחון קבוצת הכדורסל גרם לאוהדים שמחה רבה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-04 Aug 2004, assign-6 Nov 2003",91217,"2004-08-04");
INSERT INTO hebrew_synonyms VALUES (1291,"!נִתָּן","a","01696697","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"allowed, permitted",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO ניתן is a verb\r\n","ordan-21 Aug 2004, assign-6 Nov 2003",0,"2004-08-21");
INSERT INTO hebrew_synonyms VALUES (1292,"נֵפְט","n","10749997","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"crude_oil",NULL,"קידוחי נפט","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-29 Aug 2004",93152,"2004-08-29");
INSERT INTO hebrew_synonyms VALUES (1293,"נֵפְט","n","10528487","yy","melingo","2","rav-milim","1.2","tg1",NULL,"kerosene",NULL,"כיום תנורי נפט אינם נפוצים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-29 Aug 2004",93152,"2004-08-29");
INSERT INTO hebrew_synonyms VALUES (1294,"!נֶעֱרַךְ","v","00186555","y","melingo","2","rav-milim",NULL,"tg1",NULL,"prepare_for, make_arrangements_for",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1295,"!נַגָּד","n","07434519","y","melingo","1","rav-milim",NULL,"tg1","((military))","NCO, non-commissioned_officer",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,flc(dic)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1296,"נַגָּד","n","03232583","yy","melingo","1.1","rav-milim","1.1","tg2","((electricity))","resistor",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,flc(dic)=49.0] #MZ@\r\n#IE","eyal-23 Nov 2005, assign-6 Nov 2003",95514,"2005-11-23");
INSERT INTO hebrew_synonyms VALUES (1297,"!נָגַד","v","00527203","y","melingo","1","rav-milim",NULL,"tg1",NULL,"oppose, contradict",NULL,NULL,"assigned","#ASSIGN:50=[gnd=7.0,gnd=1.0E+01,si=11.0,dfl=22.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1298,"!נָכוֹן","a","01807603","y","melingo","1","rav-milim",NULL,"tg1",NULL,"correct, true",NULL,NULL,"assigned","#ASSIGN:36.0=[gnd=1.0E+01,bt(dir)=1.0E+01,bt(dir)=3.0,bt(crs)=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1299,"!נָכוֹן","a","01807436","y","melingo","1","rav-milim",NULL,"tg1",NULL,"correct, true",NULL,NULL,"assigned","#ASSIGN:4.0E+01=[gnd=1.0E+01,bt(dir)=12.0,bt(dir)=3.0,bt(crs)=15.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1300,"!נָכוֹן","a","00597129","y","melingo","1","rav-milim",NULL,"tg1",NULL,"correct, true",NULL,NULL,"assigned","#ASSIGN:38.0=[gnd=1.0E+01,bt(dir)=3.0,bt(dir)=11.0,bt(crs)=14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1301,"נָכוֹן","a","00595353","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"correct, true",NULL,"זאת התשובה הנכונה","checked","#ASSIGN:42.0=[gnd=1.0E+01,bt(dir)=12.0,bt(dir)=4.0,bt(crs)=16.0] #MZ@\r\n#NO","ordan-06 Dec 2004, assign-6 Nov 2003",93455,"2004-12-06");
INSERT INTO hebrew_synonyms VALUES (1302,"!נָכוֹן","a","01807603","y","melingo","2","rav-milim",NULL,"tg1",NULL,"right, fitting, suitable, required",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=3.0,bt(dir)=1.0E+01,bt(dir)=3.0,bt(crs)=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1303,"!נָכוֹן","a","01807436","y","melingo","2","rav-milim",NULL,"tg1",NULL,"right, fitting, suitable, required",NULL,NULL,"assigned","#ASSIGN:33.0=[gnd=3.0,bt(dir)=12.0,bt(dir)=3.0,bt(crs)=15.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1304,"!נָכוֹן","a","00597129","y","melingo","2","rav-milim",NULL,"tg1",NULL,"right, fitting, suitable, required",NULL,NULL,"assigned","#ASSIGN:31.0=[gnd=3.0,bt(dir)=3.0,bt(dir)=11.0,bt(crs)=14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (7749,"מְכֻתָּב","n","07062359","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-07 Dec 2004",93838,"2004-12-07");
INSERT INTO hebrew_synonyms VALUES (1306,"!נָכוֹן","r","00180343","y","melingo","1","rav-milim",NULL,"tg1",NULL,"right, correct, true",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1307,"נָכוֹן","r","00200650","yy","melingo","2.1","rav-milim","1.2","tg1",NULL,"correctly, properly",NULL,"היא ענתה נכון על כל השאלות","checked","#ASSIGN:44.0=[gnd=39.0,bt(dir)=5.0] #MZ@\r\n#NO","ordan-17 Aug 2004",93001,"2004-08-17");
INSERT INTO hebrew_synonyms VALUES (1308,"!נָס","v","01420490","y","melingo","1","rav-milim",NULL,"tg1",NULL,"flee, escape",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1309,"!נָצִיג","n","07207615","y","melingo","1","rav-milim",NULL,"tg1",NULL,"representative, delegate",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1310,"!נָשִׂיא","n","07496412","y","melingo","2","rav-milim",NULL,"tg1",NULL,"chairman",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,bt(dir)=1.0E+01,dfl=1.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1311,"!נָתוּן","a","02052210","n","melingo","1","rav-milim",NULL,"tg1",NULL,"placed, situated",NULL,NULL,"assigned","#ASSIGN:108.0=[gnd=2.0E+01,gnd=39.0,si=49.0] #MZ@\r\n#IE","eyal-17 Nov 2005, assign-6 Nov 2003",0,"2005-11-17");
INSERT INTO hebrew_synonyms VALUES (1312,"נָתוּן","n","04480764","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"datum",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-17 Aug 2004",93008,"2004-08-17");
INSERT INTO hebrew_synonyms VALUES (1313,"!נוֹכְחִי","a","02843913","y","melingo","1","rav-milim",NULL,"tg1",NULL,"current, present, prevailing",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1314,"!נוֹכְחִי","a","01774407","y","melingo","1","rav-milim",NULL,"tg1",NULL,"current, present, prevailing",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1315,"!נוֹכְחִי","a","01667781","y","melingo","1","rav-milim",NULL,"tg1",NULL,"current, present, prevailing",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1316,"נוֹכְחִי","a","00628521","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"current",NULL,"לאור מצבי הכספי הנוכחי, אסתפק השנה בנופש קצר בארץ","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-09 Nov 2005, assign-6 Nov 2003",95501,"2005-11-09");
INSERT INTO hebrew_synonyms VALUES (1317,"!נוֹשֵׂא","n","04950638","y","melingo","1","rav-milim",NULL,"tg1",NULL,"topic, matter, issue, theme",NULL,NULL,"assigned","#ASSIGN:165.0=[gnd=2.0E+01,gnd=8.0,si=5.0,bt(dir)=6.0,bt(dir)=19.0,bt(dir)=8.0,bt(crs)=66.0,bt(dir)=6.0,bt(dir)=19.0,bt(dir)=8.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1318,"!נוֹשֵׂא","n","04479710","y","melingo","1","rav-milim",NULL,"tg1",NULL,"topic, matter, issue, theme",NULL,NULL,"assigned","#ASSIGN:224.0=[gnd=2.0E+01,gnd=7.0,gnd=4.0,si=7.0,bt(dir)=17.0,bt(dir)=5.0,bt(dir)=3.0,bt(dir)=6.0,bt(crs)=93.0,bt(dir)=17.0,bt(dir)=5.0,bt(dir)=3.0,bt(dir)=6.0,bt(dir)=17.0,bt(dir)=5.0,bt(dir)=3.0,bt(dir)=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1319,"!נוֹשֵׂא","n","04384343","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"topic, matter, issue, theme",NULL,NULL,"checked","#ASSIGN:73.0=[gnd=7.0,bt(dir)=6.0,bt(dir)=13.0,bt(dir)=3.0,bt(crs)=44.0] #MZ@\r\n#NO","ordan-14 Aug 2004, assign-6 Nov 2003",0,"2004-08-14");
INSERT INTO hebrew_synonyms VALUES (1320,"!נוֹשֵׂא","n","04950638","y","melingo","2","rav-milim",NULL,"tg1","((syntax))","subject",NULL,NULL,"assigned","#ASSIGN:105.0=[gnd=6.0,bt(dir)=6.0,bt(dir)=19.0,bt(dir)=8.0,bt(crs)=66.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1321,"!נוֹשֵׂא","n","04479710","y","melingo","2","rav-milim",NULL,"tg1","((syntax))","subject",NULL,NULL,"assigned","#ASSIGN:1.3E+02=[gnd=6.0,bt(dir)=17.0,bt(dir)=5.0,bt(dir)=3.0,bt(dir)=6.0,bt(crs)=93.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1322,"סְבִיבָה","n","06315687","yy","melingo",">1","rav-milim","1.5","tg1",NULL,"environment, environs, surroundings, surround",NULL,NULL,"checked","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@\r\n#NO","ordan-19 Aug 2004",92800,"2004-08-19");
INSERT INTO hebrew_synonyms VALUES (1324,"סְבִיבָה","n","10040804","yy","melingo","1.3","rav-milim","1.4","tg1",NULL,"environment",NULL,"הוא התגעגע לסביבת ביתו המוכרת לו","revised","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO\r\n#IE","eyal-24 Nov 2004, ordan-19 Aug 2004, assign-6 Nov 2003",92800,"2004-11-24");
INSERT INTO hebrew_synonyms VALUES (7214,"דִּיאָבֶּטִיס","n","10157458","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-19 Aug 2004",93064,"2004-08-19");
INSERT INTO hebrew_synonyms VALUES (6914,"GAP!","n","04059885","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IN just another of WN\'s inventions (cf. collins)","ordan-07 Jul 2004",90808,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (1327,"!סְכוּם","n","05968150","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"sum",NULL,NULL,"checked","#ASSIGN:51.0=[gnd=7.0,bt(dir)=7.0,bt(dir)=15.0,bt(crs)=22.0] #MZ@\r\n#NO","ordan-13 Aug 2004, assign-6 Nov 2003",0,"2004-08-13");
INSERT INTO hebrew_synonyms VALUES (1328,"סְכוּם","n","04511080","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"sum",NULL,"הסכום של 2 ועוד 2 שווה 4","checked","#ASSIGN:57.0=[gnd=7.0,bt(dir)=6.0,bt(dir)=19.0,bt(crs)=25.0] #MZ@","ordan-18 Aug 2004, ordan-13 Aug 2004",92962,"2004-08-18");
INSERT INTO hebrew_synonyms VALUES (1329,"!סְכוּם","n","03440994","y","melingo","1","rav-milim",NULL,"tg1",NULL,"sum",NULL,NULL,"assigned","#ASSIGN:57.0=[gnd=7.0,bt(dir)=6.0,bt(dir)=19.0,bt(crs)=25.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1331,"!סְכוּם","n","03440994","y","melingo","2","rav-milim",NULL,"tg1","((mathematics))","sum, total",NULL,NULL,"assigned","#ASSIGN:118.0=[gnd=7.0,gnd=2.0E+01,si=16.0,bt(dir)=6.0,bt(dir)=19.0,bt(crs)=25.0,bt(dir)=6.0,bt(dir)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1333,"סְפָרַדִּי","a","02727705","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"Spanish",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-10 Aug 2004, assign-6 Nov 2003",0,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (1334,"סְפָרַדִּי","n","07038257","nn","melingo","1.1","rav-milim","1.1","tg1",NULL,"Spaniard",NULL,NULL,"revised","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO\r\n#IE gender","eyal-27 Feb 2005, ordan-10 Aug 2004, assign-6 Nov 2003",0,"2005-02-27");
INSERT INTO hebrew_synonyms VALUES (7197,"עִלָּה","n","05051824","yy","melingo",">1.1","rav-milim","1.2",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-18 Aug 2004",93030,"2004-08-18");
INSERT INTO hebrew_synonyms VALUES (6770,"GAP!","n","01711727","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-26 May 2004",90808,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (1337,"!סִדְרָה","n","05550105","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"series, sequence, set",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-18 Aug 2004, assign-6 Nov 2003",0,"2004-08-18");
INSERT INTO hebrew_synonyms VALUES (1338,"סִדְרָה","n","06042229","yy","melingo","1.4","rav-milim","1.8","tg1",NULL,"order",NULL,NULL,"checked","#ASSIGN:53.0=[gnd=4.0,flc(dic)=49.0] #MZ@\r\n#NO","ordan-18 Aug 2004",92763,"2004-08-18");
INSERT INTO hebrew_synonyms VALUES (1339,"סִיֵּם","v","00337013","yy","melingo","1","rav-milim","1.1","tg1",NULL,"finish, complete",NULL,"היא סיימה את לימודי התואר השני בהצלחה","checked","#ASSIGN:7.0E+01=[gnd=7.0,gnd=8.0,si=1.0E+01,bt(dir)=8.0,bt(dir)=7.0,bt(crs)=15.0,bt(dir)=8.0,bt(dir)=7.0] #MZ@ #IE","eyal-21 Mar 2004, assign-6 Nov 2003",91218,"2004-03-21");
INSERT INTO hebrew_synonyms VALUES (1340,"!סִיֵּם","v","01779664","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"finish, complete",NULL,NULL,"checked","#ASSIGN:37.0=[gnd=7.0,bt(dir)=9.0,bt(dir)=6.0,bt(crs)=15.0] #MZ@ #IE ","eyal-12 May 2004, assign-6 Nov 2003",0,"2004-05-12");
INSERT INTO hebrew_synonyms VALUES (1341,"סִיֵּעַ","v","01737017","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"help, aid, assist",NULL,NULL,"checked","#ASSIGN:1.1E+02=[gnd=5.0,gnd=2.0E+01,gnd=13.0,si=15.0,bt(dir)=19.0,bt(dir)=19.0,bt(dir)=19.0] #MZ@\r\n#NO refers to the first part of RM 1.1","ordan-30 Dec 2004, assign-6 Nov 2003",94036,"2004-12-30");
INSERT INTO hebrew_synonyms VALUES (1342,"סִיֵּעַ","v","00056138","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"help, aid, assist",NULL,NULL,"checked","#ASSIGN:73.0=[gnd=5.0,gnd=2.0E+01,si=1.0E+01,bt(dir)=19.0,bt(dir)=19.0] #MZ@\r\n#NO","ordan-30 Dec 2004, assign-6 Nov 2003",94036,"2004-12-30");
INSERT INTO hebrew_synonyms VALUES (1343,"!סִיֵּעַ","v","01645167","nn","none","3","none",NULL,"tg1",NULL,"collaborate",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-30 Dec 2004, assign-6 Nov 2003",0,"2004-12-30");
INSERT INTO hebrew_synonyms VALUES (1344,"!סִיּוּם","n","10966797","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"end, finish, completion, conclusion",NULL,NULL,"checked","#ASSIGN:75.0=[gnd=8.0,gnd=4.0,si=3.0,bt(dir)=6.0,bt(dir)=4.0,bt(dir)=5.0,bt(crs)=3.0E+01,bt(dir)=6.0,bt(dir)=4.0,bt(dir)=5.0] #MZ@\r\n#NO","ordan-19 Aug 2004, assign-6 Nov 2003",0,"2004-08-19");
INSERT INTO hebrew_synonyms VALUES (1345,"!סִיּוּם","n","04822648","y","melingo","1","rav-milim",NULL,"tg1",NULL,"end, finish, completion, conclusion",NULL,NULL,"assigned","#ASSIGN:58.0=[gnd=3.0,gnd=4.0,si=3.0,bt(dir)=4.0,bt(dir)=2.0,bt(dir)=6.0,bt(crs)=24.0,bt(dir)=4.0,bt(dir)=2.0,bt(dir)=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1346,"סִיּוּם","n","00137299","yy","melingo","1.1","shushan","1.1","tg1",NULL,"termination, ending, conclusion",NULL,"בסיום העבודה נרים כוסית","revised","#ASSIGN:54.0=[gnd=4.0,bt(dir)=21.0,bt(dir)=4.0,bt(crs)=25.0] #MZ@\r\n#NO look especially at Even-Shushan\'s examples","eyal-15 Aug 2004, ordan-12 Aug 2004, assign-6 Nov 2003",92931,"2004-08-15");
INSERT INTO hebrew_synonyms VALUES (1347,"!סִיּוּם","n","00364042","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"end, finish, completion, conclusion",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#NO","ordan-12 Aug 2004, assign-6 Nov 2003",0,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (1348,"!סִיּוּם","n","00138106","y","melingo","1","rav-milim",NULL,"tg1",NULL,"end, finish, completion, conclusion",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1349,"!סִיּוּם","n","00035222","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"end, finish, completion, conclusion",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-12 Aug 2004, assign-6 Nov 2003",0,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (1350,"!סִיּוּם","n","05478207","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"end, finish, completion, conclusion",NULL,NULL,"checked","#ASSIGN:4.0E+01=[gnd=8.0,bt(dir)=9.0,bt(dir)=7.0,bt(crs)=16.0] #MZ@","ordan-12 Aug 2004, assign-6 Nov 2003",0,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (1351,"סִיּוּעַ","n","04015637","yy","melingo","1.1","none",NULL,"tg1",NULL,"aid, assistance",NULL,"סיוע כלכלי; ישראל הציעה סיוע רפואי לתורכיה בעקבות רעש האדמה","checked","#ASSIGN:135.0=[gnd=1.0E+01,gnd=2.0E+01,si=24.0,bt(dir)=8.0,bt(dir)=19.0,bt(crs)=27.0,bt(dir)=8.0,bt(dir)=19.0] #MZ@\r\n#NO I think RM missed this sense; cf. their 1.1 in the verb סייע which can be perfectly nominalized under the same meaning","ordan-27 Dec 2004, assign-6 Nov 2003",93986,"2004-12-27");
INSERT INTO hebrew_synonyms VALUES (1352,"!סִיּוּעַ","n","00782440","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"aid, assistance",NULL,NULL,"checked","#ASSIGN:138.0=[gnd=1.0E+01,gnd=2.0E+01,si=24.0,bt(dir)=9.0,bt(dir)=19.0,bt(crs)=28.0,bt(dir)=9.0,bt(dir)=19.0] #MZ@\r\n#NO","ordan-13 Aug 2004",0,"2004-08-13");
INSERT INTO hebrew_synonyms VALUES (7917,"אֵיבְרֵי-הַמִּין","n","04271545","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-27 Dec 2004",93988,"2004-12-27");
INSERT INTO hebrew_synonyms VALUES (7162,"עֵזֶר","n","00782440","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-13 Aug 2004",0,"2004-08-13");
INSERT INTO hebrew_synonyms VALUES (1355,"סִיבוּב","n","05535152","yy","melingo","1.1","rav-milim","1.1.1","tg1",NULL,"rotation, revolution, gyration",NULL,NULL,"checked","#ASSIGN:138.0=[gnd=2.0E+01,gnd=13.0,si=9.0,bt(dir)=19.0,bt(dir)=13.0,bt(crs)=32.0,bt(dir)=19.0,bt(dir)=13.0] #MZ@\r\n#NO","ordan-18 Aug 2004",92934,"2004-08-18");
INSERT INTO hebrew_synonyms VALUES (1356,"!סִיבוּב","n","05524865","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"circuit, rotation, revolution",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-12 Aug 2004, assign-6 Nov 2003",0,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (1357,"!סִיבוּב","n","00618075","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"circuit, rotation, revolution",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-12 Aug 2004, assign-6 Nov 2003",0,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (1358,"סִיבוּב","n","00219234","yy","melingo","1.1","rav-milim","1.1.2","tg1",NULL,"rotation",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-18 Aug 2004",92934,"2004-08-18");
INSERT INTO hebrew_synonyms VALUES (1359,"סִיבוּב","n","10959811","yy","melingo","1.3","sapir","1.3","tg1",NULL,"turn, bout, round",NULL,NULL,"checked","#ASSIGN:4.0E+01=[gnd=13.0,flc(dic)=24.0,bt(dir)=3.0] #MZ@\r\n#NO","ordan-18 Aug 2004, ordan-12 Aug 2004",92934,"2004-08-18");
INSERT INTO hebrew_synonyms VALUES (1360,"סִיבוּב","n","00283141","nn","melingo","1.4","rav-milim","1.5","tg1",NULL,"bout",NULL,NULL,"checked","#ASSIGN:37.0=[gnd=13.0,flc(dic)=24.0] #MZ@\r\n#NO  \'bout\' should not be confused with \'rounds\'. \'bout\' is the whole match, specifically in boxing. ","ordan-12 Aug 2004",0,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (1361,"!סִיבוּב","n","05535507","y","melingo","5","rav-milim",NULL,"tg1","((colloquial))","spin, short_ride",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1362,"!סִיבוּב","n","00219627","nn","melingo","5","rav-milim",NULL,"tg1","((colloquial))","spin, short_ride",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-12 Aug 2004, assign-6 Nov 2003",0,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (1363,"!סִיבוּב","n","00198358","nn","melingo","5","rav-milim",NULL,"tg1","((colloquial))","spin, short_ride",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-12 Aug 2004, assign-6 Nov 2003",0,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (1364,"סִידָן","n","10482003","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"calcium",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-21 Aug 2004",93075,"2004-08-21");
INSERT INTO hebrew_synonyms VALUES (1365,"סִכּוּי","n","03973089","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"probability, chance",NULL,"אין לו סיכוי לנצח במירוץ, הוא בדיוק חזר מפציעה","checked","#ASSIGN:32.0=[gnd=2.0E+01,bt(dir)=12.0] #MZ@\r\n#NO","ordan-14 Aug 2004, assign-6 Nov 2003",0,"2004-08-14");
INSERT INTO hebrew_synonyms VALUES (1366,"סִכּוּן","n","10428324","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,NULL,NULL,"עישון סיגריות מהווה סיכון בריאותי","checked","#ASSIGN:97.0=[gnd=2.0E+01,gnd=13.0,si=16.0,bt(dir)=24.0,bt(dir)=24.0] #MZ@\r\n#NO","ordan-12 Aug 2004",0,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (1367,"סִכּוּן","n","00512734","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"risk, danger, peril",NULL,"זה היה סיכון מיותר, ידענו שזה ייגמר ברע","checked","#ASSIGN:139.0=[gnd=2.0E+01,gnd=1.0E+01,gnd=13.0,si=24.0,bt(dir)=24.0,bt(dir)=24.0,bt(dir)=24.0] #MZ@\r\n#NO","ordan-12 Aug 2004, assign-6 Nov 2003",0,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (1368,"!סִפֵּק","v","01590833","y","melingo","1","rav-milim",NULL,"tg1",NULL,"supply, provide",NULL,NULL,"assigned","#ASSIGN:36.0=[gnd=1.0E+01,gnd=1.0E+01,si=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1369,"סִפֵּק","v","00804159","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"supply, provide",NULL,NULL,"checked","#ASSIGN:36.0=[gnd=1.0E+01,gnd=1.0E+01,si=16.0] #MZ@\r\n#NO","ordan-21 Aug 2004",93077,"2004-08-21");
INSERT INTO hebrew_synonyms VALUES (1370,"!סִפֵּק","v","01822979","y","melingo","1","rav-milim",NULL,"tg2",NULL,"satisfy, fulfill",NULL,NULL,"assigned","#ASSIGN:5.0E+01=[gnd=13.0,gnd=13.0,si=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1371,"!סִפֵּק","v","00804764","y","melingo","1","rav-milim",NULL,"tg2",NULL,"satisfy, fulfill",NULL,NULL,"assigned","#ASSIGN:5.0E+01=[gnd=13.0,gnd=13.0,si=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1372,"!סִפֵּר","n","05392977","nn","melingo","1","rav-milim",NULL,"tg1","((literature))","narrative",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,flc(dic)=49.0] #MZ@\r\n#NO","ordan-14 Aug 2004, assign-6 Nov 2003",0,"2004-08-14");
INSERT INTO hebrew_synonyms VALUES (1374,"!סִפּוּר","n","05063177","y","melingo","1","rav-milim",NULL,"tg1",NULL,"story, tale",NULL,NULL,"assigned","#ASSIGN:59.0=[gnd=7.0,gnd=2.0E+01,si=16.0,bt(dir)=8.0,bt(dir)=8.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1375,"!סִפּוּר","n","04384343","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"affair, matter",NULL,NULL,"checked","#ASSIGN:50=[gnd=13.0,gnd=7.0,si=12.0,dfl=18.0] #MZ@\r\n#NO","ordan-14 Aug 2004, assign-6 Nov 2003",0,"2004-08-14");
INSERT INTO hebrew_synonyms VALUES (1376,"סִפּוּר","n","05392977","yy","melingo","1.1","sapir","1.1","tg1",NULL,"narration, narrative, story, tale, yarn, recital",NULL,"לאחר ארוחת הערב סיפר האב סיפור לילדיו","checked","#ASSIGN:28.0=[gnd=2.0E+01,bt(dir)=8.0] #MZ@\r\n#NO","ordan-14 Aug 2004",92980,"2004-08-14");
INSERT INTO hebrew_synonyms VALUES (1377,"!סֵפֶר","n","04798536","y","melingo","2","rav-milim",NULL,"tg1",NULL,"literary_work",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1378,"סֵרֵב","v","01531148","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"refuse, reject, pass_up, turn_down, decline",NULL,"היא הציעה לו לצאת, אך הוא סירב בנימוס","checked","#ASSIGN:33.0=[gnd=8.0,gnd=7.0,gnd=7.0,si=11.0] #MZ@\r\n#NO refers to the latter part of RM\'s definition","ordan-19 Aug 2004",93061,"2004-08-19");
INSERT INTO hebrew_synonyms VALUES (1379,"סֶגֶן","n","07265711","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"first_lieutenant",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,flc(dic)=49.0] #MZ@\r\n#NO","ordan-19 Aug 2004",93060,"2004-08-19");
INSERT INTO hebrew_synonyms VALUES (1380,"!סֶקֶר","n","00421016","n","melingo","1","rav-milim",NULL,"tg1",NULL,"survey, study",NULL,NULL,"assigned","#ASSIGN:51.0=[gnd=13.0,gnd=4.0,si=8.0,bt(dir)=13.0,bt(dir)=13.0] #MZ@\r\n#IE","eyal-06 Dec 2005, assign-6 Nov 2003",0,"2005-12-06");
INSERT INTO hebrew_synonyms VALUES (1381,"!סֶקֶר","n","04859040","n","melingo","1","rav-milim",NULL,"tg1",NULL,"survey, study",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-06 Dec 2005, assign-6 Nov 2003",0,"2005-12-06");
INSERT INTO hebrew_synonyms VALUES (1382,"!סֶקֶר","n","00566440","n","melingo","1","rav-milim",NULL,"tg1",NULL,"survey, study",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-06 Dec 2005, assign-6 Nov 2003",0,"2005-12-06");
INSERT INTO hebrew_synonyms VALUES (1383,"סֶרֶט","n","04960631","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"movie, film, picture, moving_picture, motion_picture",NULL,NULL,"checked","#ASSIGN:79.0=[gnd=39.0,gnd=8.0,si=2.0E+01,bt(dir)=6.0,bt(dir)=6.0] #MZ@\r\n#NO","ordan-12 Aug 2004, assign-6 Nov 2003",0,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (1384,"!סֶרֶט","n","04735661","nn","melingo","2","rav-milim",NULL,"tg1","((cinema))","movie, film",NULL,NULL,"checked","#ASSIGN:67.0=[gnd=8.0,flc(dic)=49.0,bt(dir)=1.0E+01] #MZ@","ordan-12 Aug 2004, assign-6 Nov 2003",0,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (1385,"סֶרֶט","n","02679248","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"film, photographic_film",NULL,"שלחתי את הסרט לפיתוח, התמונות תהיינה מוכנות מחר","checked","#ASSIGN:65.0=[gnd=8.0,flc(dic)=49.0,bt(dir)=8.0] #MZ@\r\n#NO","ordan-12 Aug 2004",0,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (1386,"!סֶרֶט","n","05029668","nn","melingo","5","rav-milim",NULL,"tg1","((military))","decoration",NULL,NULL,"checked","#ASSIGN:62.0=[gnd=13.0,flc(dic)=49.0] #MZ@\r\n#NO","ordan-12 Aug 2004, assign-6 Nov 2003",0,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (1387,"סַדָּר","n","07173379","yy","melingo","1.1","rav-milim","1.1","tg1","((typesetting and printing))","typesetter, compositor",NULL,NULL,"checked","#ASSIGN:176.0=[gnd=39.0,gnd=39.0,si=98.0] #MZ@\r\n#IE","eyal-02 Dec 2004, assign-6 Nov 2003",93811,"2004-12-02");
INSERT INTO hebrew_synonyms VALUES (1388,"!סַם","n","02609065","y","melingo","1","rav-milim",NULL,"tg1",NULL,"drug, narcotic",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1389,"!סַם","n","03030428","y","melingo","1","rav-milim",NULL,"tg1",NULL,"drug, narcotic",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1390,"סַם","n","02981307","yy","melingo","1.3","rav-milim","1.4","tg1","((literary))","medicament, cure",NULL,NULL,"checked","#ASSIGN:52.0=[gnd=39.0,bt(dir)=13.0] #MZ@\r\n#IE","eyal-19 May 2005, assign-6 Nov 2003",94990,"2005-05-19");
INSERT INTO hebrew_synonyms VALUES (1391,"!סַם","n","03228145","y","melingo","3","rav-milim",NULL,"tg1","((literary))","medicament, cure",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1392,"!סַפָּק","n","07622841","n","melingo","1","rav-milim",NULL,"tg1",NULL,"supplier, provider",NULL,NULL,"assigned","#ASSIGN:282.0=[gnd=39.0,gnd=2.0E+01,si=49.0,bt(dir)=39.0,bt(dir)=19.0,bt(crs)=58.0,bt(dir)=39.0,bt(dir)=19.0] #MZ@\r\n#IE gender","eyal-21 Dec 2005, assign-6 Nov 2003",0,"2005-12-21");
INSERT INTO hebrew_synonyms VALUES (1393,"!סַפָּק","n","07508719","y","melingo","1","rav-milim",NULL,"tg1",NULL,"supplier, provider",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1394,"!סַפָּר","n","07307341","y","melingo","1","rav-milim",NULL,"tg1",NULL,"barber, hairdresser",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1395,"!סַפָּר","n","07101261","y","melingo","1","rav-milim",NULL,"tg1",NULL,"barber, hairdresser",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1396,"!סָבִיב","r","00068963","y","melingo","1","rav-milim",NULL,"tg1",NULL,"around",NULL,NULL,"assigned","#ASSIGN:50=[gnd=4.0,bt(dir)=43.0,dfl=3.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1397,"!סָבִיר","a","01858003","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"reasonable, logical",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-04 Aug 2004, assign-6 Nov 2003",0,"2004-08-04");
INSERT INTO hebrew_synonyms VALUES (1398,"סָבִיר","a","01468678","yy","melingo","1.1","rav-milim","1.3","tg1",NULL,"reasonable",NULL,"המשכורת שלו לא בשמיים, אבל בהחלט סבירה בהתחשב במצב השוק","checked","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@\r\n#NO the application of סביר in WN (1.3) is limited to prices, here it is a bit extented. ","ordan-04 Aug 2004",91219,"2004-08-04");
INSERT INTO hebrew_synonyms VALUES (1399,"!סָבִיר","a","01874606","y","melingo","1","rav-milim",NULL,"tg1",NULL,"reasonable, logical",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1400,"!סָךְ","n","04511080","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"sum, total",NULL,NULL,"checked","#ASSIGN:118.0=[gnd=7.0,gnd=2.0E+01,si=16.0,bt(dir)=6.0,bt(dir)=19.0,bt(crs)=25.0,bt(dir)=6.0,bt(dir)=19.0] #MZ@\r\n#NO","ordan-13 Aug 2004, assign-6 Nov 2003",0,"2004-08-13");
INSERT INTO hebrew_synonyms VALUES (1401,"!סָךְ","n","03440994","y","melingo","1","rav-milim",NULL,"tg1",NULL,"sum, total",NULL,NULL,"assigned","#ASSIGN:118.0=[gnd=7.0,gnd=2.0E+01,si=16.0,bt(dir)=6.0,bt(dir)=19.0,bt(crs)=25.0,bt(dir)=6.0,bt(dir)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1402,"סָךְ","n","05968150","yy","melingo","1.1","sapir","1.1","tg1",NULL,"sum",NULL,"סך כל צרותינו הוא כעין וכאפס לעומת הסבל שלהם","checked","#ASSIGN:51.0=[gnd=7.0,bt(dir)=7.0,bt(dir)=15.0,bt(crs)=22.0] #MZ@\r\n#NO","ordan-13 Aug 2004",0,"2004-08-13");
INSERT INTO hebrew_synonyms VALUES (1403,"סָךְ","v","00058325","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"anoint",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-30 Dec 2004, assign-6 Nov 2003",94039,"2004-12-30");
INSERT INTO hebrew_synonyms VALUES (1404,"!סָמוּךְ","a","00413658","u","melingo","1","rav-milim",NULL,"tg1",NULL,"adjacent, nearby",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO am not sure what\'s the difference between \'near\' and \'nearby\' in Heb; this word however seems a better match to \'near\'","ordan-04 Aug 2004, assign-6 Nov 2003",0,"2004-08-04");
INSERT INTO hebrew_synonyms VALUES (1405,"!סָמוּךְ","a","02241625","y","melingo","2","rav-milim",NULL,"tg1",NULL,"based_on, established_on",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1406,"סָפֵק","n","04402548","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"doubt, uncertainty",NULL,"אני בספק בנוגע להצלחת המיזם - נחיה ונראה","checked","#ASSIGN:111.0=[gnd=2.0E+01,gnd=2.0E+01,si=33.0,bt(dir)=19.0,bt(dir)=19.0] #MZ@\r\n#NO relates to the latter part of RM\'s definition","ordan-14 Aug 2004, assign-6 Nov 2003",0,"2004-08-14");
INSERT INTO hebrew_synonyms VALUES (1407,"סָפֵק","n","03736708","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"doubt, dubiousness, doubtfulness, question",NULL,"אין ספק בנוגע לאמיתות הטענה; הוא תמיד מטיל ספק בכל דבר, אף פעם אינו מאמין","checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#NO relates to the first part of RM\'s definition","ordan-14 Aug 2004",0,"2004-08-14");
INSERT INTO hebrew_synonyms VALUES (1408,"!סָקַר","v","01473651","y","melingo","1","rav-milim",NULL,"tg1",NULL,"survey, peruse",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1409,"!סָקַר","v","00681575","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"describe, summarize",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO i guess that\'s closer to \'review\'","ordan-21 Aug 2004, assign-6 Nov 2003",0,"2004-08-21");
INSERT INTO hebrew_synonyms VALUES (1410,"סוֹף","n","10966797","yy","melingo","1.2","rav-milim","1.4","tg1",NULL,"finish",NULL,"למרות שההצגה היתה משעממת, נשארתי לראות מה יקרה בסוף","checked","#ASSIGN:26.0=[gnd=8.0,bt(dir)=6.0,bt(dir)=3.0,bt(crs)=9.0] #MZ@\r\n#NO","ordan-19 Aug 2004",93051,"2004-08-19");
INSERT INTO hebrew_synonyms VALUES (1411,"!סוֹף","n","06851354","nn","melingo","3","rav-milim",NULL,"tg1",NULL,"death",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-19 Aug 2004, assign-6 Nov 2003",0,"2004-08-19");
INSERT INTO hebrew_synonyms VALUES (7163,"קָטֵגוֹרְיָה","n","05991008","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"class, category",NULL,"המספרים הזוגיים מהווים קטגוריה מספרית נפרדת, שכן הם חולקים תכונה אחת משותפת: הם מתחלקים בשתיים ללא שארית","checked","#NO","ordan-14 Aug 2004",92974,"2004-08-14");
INSERT INTO hebrew_synonyms VALUES (1413,"!סוּג","n","05991008","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"quality, category, class, _rank, level",NULL,NULL,"checked","#ASSIGN:37.0=[gnd=2.0E+01,gnd=5.0,si=4.0,bt(dir)=4.0,bt(dir)=4.0] #MZ@\r\n#NO","ordan-14 Aug 2004, assign-6 Nov 2003",0,"2004-08-14");
INSERT INTO hebrew_synonyms VALUES (1414,"סוּג","n","06043947","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"genus",NULL,NULL,"checked","#ASSIGN:69.0=[gnd=2.0E+01,flc(dic)=49.0] #MZ@\r\n#NO","ordan-14 Aug 2004",92971,"2004-08-14");
INSERT INTO hebrew_synonyms VALUES (1415,"!סוּף","n","07750744","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"reed, bulrush",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-19 Aug 2004, assign-6 Nov 2003",0,"2004-08-19");
INSERT INTO hebrew_synonyms VALUES (1416,"עֱלִי","n","07992572","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"pistil, gynoecium",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,flc(dic)=49.0] #MZ@\r\n#NO","ordan-19 Sep 2004",93378,"2004-09-19");
INSERT INTO hebrew_synonyms VALUES (1417,"עֲבוֹדָה","n","00383807","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"employment, job, work",NULL,"זאת עבודה מעניינת, אבל השכר נמוך","checked","#ASSIGN:50=[gnd=1.0E+01,gnd=4.0,si=6.0,bt(dir)=4.0,bt(dir)=5.0,bt(crs)=9.0,bt(dir)=4.0,bt(dir)=5.0,dfl=3.0] #MZ@\r\n#NO","ordan-18 Sep 2004",93334,"2004-09-18");
INSERT INTO hebrew_synonyms VALUES (1418,"עֲבוֹדָה","n","03631348","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"work",NULL,"הוא הגיע לעבודה מוקדם הבוקר","checked","#ASSIGN:50=[gnd=39.0,bt(dir)=7.0,dfl=4.0] #MZ@\r\n#NO","ordan-27 Dec 2004, assign-6 Nov 2003",93334,"2004-12-27");
INSERT INTO hebrew_synonyms VALUES (1419,"עֲבוֹדָה","n","00598038","u","melingo","1.5","rav-milim","1.5","tg1",NULL,"artistic_creation, art",NULL,"\'החמניות\' נחשבת לאחת מעבודותיו החשובות של ואן גוך","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-18 Sep 2004",93334,"2004-09-18");
INSERT INTO hebrew_synonyms VALUES (1420,"!עֲבוֹדָה","n","04360761","nn","melingo","6","rav-milim",NULL,"tg1",NULL,"workmanship, craftsmanship",NULL,NULL,"checked","#ASSIGN:176.0=[gnd=39.0,gnd=39.0,si=98.0] #MZ@\r\n#NO","ordan-27 Dec 2004, assign-6 Nov 2003",0,"2004-12-27");
INSERT INTO hebrew_synonyms VALUES (1421,"!עֲדַיִן","r","00026464","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"yet, still",NULL,NULL,"checked","#ASSIGN:83.0=[gnd=7.0,gnd=1.0E+01,si=12.0,bt(dir)=11.0,bt(dir)=7.0,bt(crs)=18.0,bt(dir)=11.0,bt(dir)=7.0] #MZ@\r\n#NO maybe in יכול להיות שאתה צודק, אבל עדיין הייתי מציע לך לחשוב על כך שנית","ordan-28 Dec 2004, assign-6 Nov 2003",0,"2004-12-28");
INSERT INTO hebrew_synonyms VALUES (1422,"!עֲדַיִן","r","00016468","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"yet, still",NULL,NULL,"checked","#ASSIGN:8.0E+01=[gnd=7.0,gnd=1.0E+01,si=12.0,bt(dir)=6.0,bt(dir)=11.0,bt(crs)=17.0,bt(dir)=6.0,bt(dir)=11.0] #MZ@\r\n#NO","ordan-28 Dec 2004, assign-6 Nov 2003",0,"2004-12-28");
INSERT INTO hebrew_synonyms VALUES (1423,"!עֲלִיָּה","n","06724958","nn","melingo","4","rav-milim",NULL,"tg1",NULL,"incline, slope",NULL,NULL,"checked","#ASSIGN:73.0=[gnd=2.0E+01,gnd=2.0E+01,si=33.0] #MZ@\r\n#NO","ordan-24 Aug 2004, assign-6 Nov 2003",0,"2004-08-24");
INSERT INTO hebrew_synonyms VALUES (1424,"!עֲלִיָּה","n","00182418","y","melingo","6","rav-milim",NULL,"tg1",NULL,"advance, advancement",NULL,NULL,"assigned","#ASSIGN:50=[gnd=7.0,gnd=13.0,si=12.0,dfl=18.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1425,"עֲלִיָּה","n","02938794","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"attic, garret",NULL,NULL,"checked","#ASSIGN:76.0=[gnd=13.0,gnd=39.0,si=24.0] #MZ@\r\n#NO","ordan-25 Aug 2004",93142,"2004-08-26");
INSERT INTO hebrew_synonyms VALUES (1426,"!עֲלִיָּה","n","05232474","nn","melingo","1","rav-milim",NULL,"tg1","((literary))","attic, garret",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-19 Sep 2004, assign-6 Nov 2003",0,"2004-09-19");
INSERT INTO hebrew_synonyms VALUES (1427,"עֲלִיָּה","n","04191921","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"atrium",NULL,NULL,"checked","#ASSIGN:69.0=[gnd=2.0E+01,flc(dic)=49.0] #MZ@\r\n#NO","ordan-19 Sep 2004",93142,"2004-09-19");
INSERT INTO hebrew_synonyms VALUES (1428,"חֲצִי-הָאִי-עֲרָב","n","06489489","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"Arabian_Peninsula",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-28 Dec 2004, assign-6 Nov 2003",93994,"2004-12-28");
INSERT INTO hebrew_synonyms VALUES (1429,"עִיר","n","06287351","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"city",NULL,NULL,"checked","#ASSIGN:94.0=[gnd=13.0,gnd=2.0E+01,si=33.0,bt(dir)=14.0,bt(dir)=14.0] #MZ@\r\n#NO","ordan-19 Sep 2004",93372,"2004-09-19");
INSERT INTO hebrew_synonyms VALUES (1430,"!עִיר","n","06106897","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"city, metropolis",NULL,NULL,"checked","#ASSIGN:98.0=[gnd=13.0,gnd=2.0E+01,si=33.0,bt(dir)=16.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-28 Dec 2004, assign-6 Nov 2003",0,"2004-12-28");
INSERT INTO hebrew_synonyms VALUES (1431,"!עִיר","n","06296380","y","melingo","1","rav-milim",NULL,"tg1",NULL,"city, metropolis",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1432,"!עִיר","n","06383382","y","melingo","2","rav-milim",NULL,"tg1",NULL,"town",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1433,"!עִיר","n","06382213","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"town",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-19 Sep 2004, assign-6 Nov 2003",0,"2004-09-19");
INSERT INTO hebrew_synonyms VALUES (1434,"!עִיר","n","06107058","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"town",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-28 Dec 2004, assign-6 Nov 2003",0,"2004-12-28");
INSERT INTO hebrew_synonyms VALUES (1435,"עִנְיֵן","v","01827745","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"interest, matter",NULL,"תפסיק, זה לא מעניין אותי!","checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#NO","ordan-29 Dec 2004, assign-6 Nov 2003",94014,"2004-12-29");
INSERT INTO hebrew_synonyms VALUES (1436,"עִנְיֵן","v","01242774","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"interest",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-29 Dec 2004, assign-6 Nov 2003",94014,"2004-12-29");
INSERT INTO hebrew_synonyms VALUES (1437,"!עִנְיָן","n","04479710","y","melingo","1","rav-milim",NULL,"tg1",NULL,"matter, issue",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=7.0,gnd=4.0,si=6.0,bt(dir)=6.0,bt(dir)=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1438,"עִנְיָן","n","04384343","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"matter, affair",NULL,"זה לא עניינך!; יש לנו כמה עניינים ללבן בינינו","checked","#ASSIGN:73.0=[gnd=7.0,bt(dir)=6.0,bt(dir)=13.0,bt(dir)=3.0,bt(crs)=44.0] #MZ@","ordan-14 Aug 2004",92979,"2004-08-14");
INSERT INTO hebrew_synonyms VALUES (1439,"!עִנְיָן","n","06008236","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"problem, concern",NULL,NULL,"checked","#ASSIGN:32.0=[gnd=8.0,bt(dir)=5.0,bt(dir)=7.0,bt(crs)=12.0] #MZ@\r\n#NO","ordan-19 Sep 2004, assign-6 Nov 2003",0,"2004-09-19");
INSERT INTO hebrew_synonyms VALUES (1440,"!עִקָּרִי","a","01450092","y","melingo","1","rav-milim",NULL,"tg1",NULL,"main, fundamental",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1441,"עִקָּרִי","a","01225152","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"chief, main, primary",NULL,"הדוגמה העיקרית","checked","#ASSIGN:83.0=[gnd=13.0,bt(dir)=21.0,bt(dir)=14.0,bt(crs)=35.0] #MZ@\r\n#NO","ordan-26 Dec 2004, assign-6 Nov 2003",93954,"2004-12-26");
INSERT INTO hebrew_synonyms VALUES (1442,"עִקָּרִי","a","00694273","yy","melingo","1.1","none",NULL,"tg1",NULL,"main",NULL,"משפט עיקרי ומשפט טפל","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-26 Dec 2004, assign-6 Nov 2003",93954,"2004-12-26");
INSERT INTO hebrew_synonyms VALUES (1443,"עִתּוֹן","n","06009637","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"newspaper",NULL,"שלוש העיתונים הגדולים בישראל נמצאים בבעלותן של שלוש משפחות","checked","#ASSIGN:42.0=[gnd=1.0E+01,bt(dir)=1.0E+01,bt(dir)=6.0,bt(crs)=16.0] #MZ@\r\n#NO","ordan-22 Dec 2004, assign-6 Nov 2003",93906,"2004-12-22");
INSERT INTO hebrew_synonyms VALUES (1444,"עִתּוֹן","n","04738466","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"newspaper",NULL,"עיתון ערב; הוא נוהג לקרוא את העיתון בעת ארוחת הבוקר","checked","#ASSIGN:44.0=[gnd=1.0E+01,bt(dir)=11.0,bt(dir)=6.0,bt(crs)=17.0] #MZ@\r\n#NO","ordan-22 Dec 2004, assign-6 Nov 2003",93906,"2004-12-22");
INSERT INTO hebrew_synonyms VALUES (1445,"עִתּוֹן","n","03039218","yy","melingo","1.1","none",NULL,"tg1",NULL,"newspaper",NULL,"הדגים בשוק היו עטופים עיתונים; הוא כיסה את ראשו בעיתון כהגנה מפני הגשם ","checked","#ASSIGN:46.0=[gnd=1.0E+01,bt(dir)=12.0,bt(dir)=6.0,bt(crs)=18.0] #MZ@\r\n#NO","ordan-22 Dec 2004, assign-6 Nov 2003",93906,"2004-12-22");
INSERT INTO hebrew_synonyms VALUES (1446,"עִתּוֹנָאִי","a","02823372","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"journalistic",NULL,"כתיבה עיתונאית","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-21 Dec 2005, assign-6 Nov 2003",95547,"2005-12-21");
INSERT INTO hebrew_synonyms VALUES (1447,"עֵסֶק","n","06008236","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"business",NULL,"עסק משפחתי","checked","#ASSIGN:50=[gnd=4.0,bt(dir)=5.0,bt(dir)=7.0,bt(crs)=12.0,dfl=22.0] #MZ@\r\n#NO","ordan-19 Sep 2004",93352,"2004-09-19");
INSERT INTO hebrew_synonyms VALUES (1448,"!עֵסֶק","n","10038885","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"matter, affair, duty",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-19 Sep 2004, assign-6 Nov 2003",0,"2004-09-19");
INSERT INTO hebrew_synonyms VALUES (7380,"אֵרוּעַ","n","05538537","yy","none",NULL,"rav-milim","1.2",NULL,NULL,"affair, occasion",NULL,"המסיבה הזאת יצאה ממש אירוע","checked","#NO","ordan-19 Sep 2004",90897,"2004-09-19");
INSERT INTO hebrew_synonyms VALUES (1450,"!עֵסֶק","n","04384343","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"matter, affair, duty",NULL,NULL,"checked","#ASSIGN:55.0=[gnd=7.0,gnd=13.0,si=9.0,bt(dir)=13.0,bt(dir)=13.0] #MZ@\r\n#NO","ordan-14 Aug 2004, assign-6 Nov 2003",0,"2004-08-14");
INSERT INTO hebrew_synonyms VALUES (1451,"!עֵסֶק","n","00717352","nn","melingo","3","rav-milim",NULL,"tg1","((colloquial))","deal, transaction, arrangement",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-19 Sep 2004, assign-6 Nov 2003",0,"2004-09-19");
INSERT INTO hebrew_synonyms VALUES (1452,"עֵרֶב","n","03628801","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"weft, woof",NULL,"שתי וערב","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-25 Dec 2004, assign-6 Nov 2003",93948,"2004-12-25");
INSERT INTO hebrew_synonyms VALUES (1453,"!עֵרֶךְ","n","09911766","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"value, worth",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","ordan-18 Sep 2004, assign-6 Nov 2003",0,"2004-09-18");
INSERT INTO hebrew_synonyms VALUES (1454,"עֵרֶךְ","n","04003047","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"worth",NULL,"אלה ספרים ישנים, אך ערכם סנטימנטלי בלבד, מחירם בשוק אינו רב","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-18 Sep 2004",93345,"2004-09-18");
INSERT INTO hebrew_synonyms VALUES (1456,"עֶזְרָה","n","00782440","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"aid, assistance, help",NULL,"הוא הגיש לי עזרה בנקיון הבית","checked","#ASSIGN:202.0=[gnd=1.0E+01,gnd=2.0E+01,si=24.0,bt(dir)=9.0,bt(dir)=19.0,bt(dir)=9.0,bt(crs)=74.0,bt(dir)=9.0,bt(dir)=19.0,bt(dir)=9.0] #MZ@\r\n#NO","ordan-13 Aug 2004",0,"2004-08-13");
INSERT INTO hebrew_synonyms VALUES (1457,"!עֶזְרָה","n","04015637","nn","melingo","1","rav-milim",NULL,"tg2",NULL,"help, assistance",NULL,NULL,"checked","#ASSIGN:194.0=[gnd=1.0E+01,gnd=2.0E+01,si=24.0,bt(dir)=8.0,bt(dir)=19.0,bt(dir)=8.0,bt(crs)=7.0E+01,bt(dir)=8.0,bt(dir)=19.0,bt(dir)=8.0] #MZ@\r\n#NO","ordan-27 Dec 2004, assign-6 Nov 2003",0,"2004-12-27");
INSERT INTO hebrew_synonyms VALUES (1459,"!עֶלְיוֹן","a","02321439","y","melingo","1","rav-milim",NULL,"tg1",NULL,"upper, uppermost, top",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1460,"עֶלְיוֹן","a","02229073","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"upper",NULL,"המעמד העליון","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-26 Dec 2004, assign-6 Nov 2003",93959,"2004-12-26");
INSERT INTO hebrew_synonyms VALUES (1461,"עֶלְיוֹן","a","01155248","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"upper",NULL,"צריך את הסולם, הספר נמצא במדף העליון","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-26 Dec 2004, assign-6 Nov 2003",93959,"2004-12-26");
INSERT INTO hebrew_synonyms VALUES (1462,"!עֶלְיוֹן","a","02321283","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"upper, uppermost, top",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-26 Dec 2004, assign-6 Nov 2003",0,"2004-12-26");
INSERT INTO hebrew_synonyms VALUES (1463,"!עֶמְדָּה","n","04707108","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"stance, standpoint, viewpoint, approach",NULL,NULL,"checked","#ASSIGN:75.0=[gnd=39.0,gnd=2.0E+01,si=8.0,bt(dir)=4.0,bt(dir)=4.0] #MZ@\r\n#NO fits better to ''approach''","ordan-05 May 2004, assign-6 Nov 2003",0,"2004-05-05");
INSERT INTO hebrew_synonyms VALUES (1464,"עֶמְדָּה","n","03966697","yy","melingo","1.1","sapir","1.6","tg1",NULL,"stance",NULL,"עמדת אגרוף","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO look at its hyponyms in order to understand the slight difference between this and \'standing\' (עמידה)","ordan-27 Dec 2004, assign-6 Nov 2003",93982,"2004-12-27");
INSERT INTO hebrew_synonyms VALUES (1465,"!עֶמְדָּה","n","03965003","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"position",NULL,NULL,"checked","#ASSIGN:50=[gnd=3.0,bt(dir)=3.0,bt(dir)=11.0,bt(crs)=14.0,dfl=19.0] #MZ@\r\n#NO","ordan-27 Dec 2004, assign-6 Nov 2003",0,"2004-12-27");
INSERT INTO hebrew_synonyms VALUES (1466,"!עֶמְדָּה","n","03632472","nn","melingo","3","rav-milim",NULL,"tg1",NULL,"work-station",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-27 Dec 2004, assign-6 Nov 2003",0,"2004-12-27");
INSERT INTO hebrew_synonyms VALUES (1467,"!עֶרֶב","n","06928357","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"eve",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-19 Sep 2004, assign-6 Nov 2003",0,"2004-09-19");
INSERT INTO hebrew_synonyms VALUES (1468,"!עֶרֶב","n","10888065","nn","melingo","3","rav-milim",NULL,"tg1",NULL,"nightfall",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-25 Dec 2004, assign-6 Nov 2003",0,"2004-12-25");
INSERT INTO hebrew_synonyms VALUES (1469,"עַז","a","01755567","yy","melingo","1","rav-milim","1.4","tg1",NULL,"mighty",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-21 Jan 2004, assign-6 Nov 2003",91220,"2004-01-21");
INSERT INTO hebrew_synonyms VALUES (1470,"!עַיִן","n","00564273","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"look, gaze, appearance",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-22 Dec 2004, assign-6 Nov 2003",0,"2004-12-22");
INSERT INTO hebrew_synonyms VALUES (1471,"עַיִן","n","05121901","yy","melingo","3.1","rav-milim","3.1","tg2",NULL,"Ayin",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-24 Aug 2004",93129,"2004-08-24");
INSERT INTO hebrew_synonyms VALUES (1472,"עַכְשָׁו","r","00047077","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"now",NULL,NULL,"checked","#ASSIGN:56.0=[gnd=6.0,gnd=39.0,si=11.0] #MZ@\r\n#NO refers to the second part of the definition","ordan-29 Dec 2004, assign-6 Nov 2003",90978,"2004-12-29");
INSERT INTO hebrew_synonyms VALUES (1473,"!עַכְשָׁו","r","00046870","y","melingo","1","rav-milim",NULL,"tg1",NULL,"now, currently, presently, nowadays",NULL,NULL,"assigned","#ASSIGN:7.0E+01=[gnd=39.0,gnd=2.0E+01,si=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1474,"!עַם","n","06079949","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"crowd, populace",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-28 Dec 2004, assign-6 Nov 2003",0,"2004-12-28");
INSERT INTO hebrew_synonyms VALUES (1475,"!עַתָּה","r","00046870","y","melingo","1","rav-milim",NULL,"tg1",NULL,"now, currently",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1476,"עָבַד","v","01048914","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"operate, function",NULL,"הטלוויזיה שוב לא עובדת, צריך למסור אותה לתיקון","checked","#ASSIGN:50=[gnd=6.0,gnd=13.0,si=11.0,bt(dir)=2.0,bt(dir)=2.0,dfl=16.0] #MZ@\r\n#NO","ordan-29 Dec 2004, assign-6 Nov 2003",93823,"2004-12-29");
INSERT INTO hebrew_synonyms VALUES (1477,"!עָבַד","v","00522671","nn","melingo","3","rav-milim",NULL,"tg1",NULL,"work_on, convince, improve",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-29 Dec 2004, assign-6 Nov 2003",0,"2004-12-29");
INSERT INTO hebrew_synonyms VALUES (1478,"עָבַר-עַל","v","01750236","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"violate, transgress, breach, break",NULL,"עבר על החוק","checked","#ASSIGN:65.0=[gnd=7.0,gnd=2.0E+01,gnd=2.0E+01,si=18.0] #MZ@\r\n#NO","ordan-30 Dec 2004, assign-6 Nov 2003",94032,"2004-12-30");
INSERT INTO hebrew_synonyms VALUES (1479,"עָבָר","n","10866655","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"past",NULL,"העיתונאים חיטטו בעברו של המועמד לנשיאות","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE RM and Sapir explain this sense of ''past'' as the former period in a person\'s life; WN adds a remark (in brackets) that it usually refers to a period one wishes to conceal","eyal-08 Mar 2005, assign-6 Nov 2003",93340,"2005-03-08");
INSERT INTO hebrew_synonyms VALUES (1480,"עָבָר","n","10849142","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"past",NULL,"בוא נשאיר את העבר מאחורינו","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-18 Sep 2004",93340,"2004-09-18");
INSERT INTO hebrew_synonyms VALUES (1481,"עָבָר","n","04777321","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"past, past_tense",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-18 Sep 2004",93340,"2004-09-18");
INSERT INTO hebrew_synonyms VALUES (7372,"זְמַן-עָבָר","n","04777321","yy","none",NULL,"none",NULL,NULL,NULL,"past_tense",NULL,NULL,"checked","#NO","ordan-18 Sep 2004",93341,"2004-09-18");
INSERT INTO hebrew_synonyms VALUES (1483,"עָבָר","n","04871813","yy","melingo","1.4","rav-milim","1.4","tg1",NULL,"criminal_record, record",NULL,NULL,"revised","#ASSIGN:50=[gnd=39.0,bt(dir)=6.0,dfl=5.0] #MZ@\r\n#NO","eyal-08 Mar 2005, ordan-18 Sep 2004, assign-6 Nov 2003",93340,"2005-03-08");
INSERT INTO hebrew_synonyms VALUES (1484,"!עָלֶה","n","09440011","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"leaf, frond",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO עלה is supposed to be \'leaf\', but here it is used collectively","ordan-14 Jul 2004",0,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (1485,"עָלֶה","n","04731596","yy","melingo",">1.1","rav-milim","1.4","tg1",NULL,"folio, leaf",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-15 Sep 2004",93307,"2004-09-15");
INSERT INTO hebrew_synonyms VALUES (1486,"!עָלֶה","n","02914669","y","melingo","1","rav-milim",NULL,"tg1",NULL,"leaf, frond",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1487,"!עָלֶה","n","09440981","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"leaf, frond",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-22 Dec 2004, assign-6 Nov 2003",0,"2004-12-22");
INSERT INTO hebrew_synonyms VALUES (7355,"בֵּית-הָעִירִיָּה","n","03524562","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"town_hall",NULL,NULL,"checked","#NO","ordan-15 Sep 2004",93308,"2004-09-15");
INSERT INTO hebrew_synonyms VALUES (7356,"הָעִירִיָּה","n","03524562","yy","none",NULL,"rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO refers to the latter part of RM\'s עירייה","ordan-15 Sep 2004",93309,"2004-09-15");
INSERT INTO hebrew_synonyms VALUES (1489,"!עָלֶה","n","04733046","nn","melingo","4","rav-milim",NULL,"tg1","((typography and printing))","folio",NULL,NULL,"checked","#ASSIGN:32.0=[gnd=2.0E+01,flc(dic)=12.0] #MZ@\r\n#NO","ordan-15 Sep 2004, assign-6 Nov 2003",0,"2004-09-15");
INSERT INTO hebrew_synonyms VALUES (1490,"עָלָה","v","01356820","yy","melingo","1.1","rav-milim","1.11","tg1",NULL,"rise",NULL,"הבעת כעס עלתה בפניו כששמע את סיפורי","checked","#ASSIGN:32.0=[gnd=2.0,bt(dir)=13.0,bt(dir)=2.0,bt(crs)=15.0] #MZ@\r\n#IE","eyal-29 Nov 2004, assign-6 Nov 2003",93795,"2004-11-29");
INSERT INTO hebrew_synonyms VALUES (1491,"עָלָה","v","01340367","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"ascend",NULL,"עלינו על ההר בשעת בוקר מוקדמת","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-29 Nov 2004, assign-6 Nov 2003",93795,"2004-11-29");
INSERT INTO hebrew_synonyms VALUES (1492,"עָמַד","v","01252269","yy","melingo","1.3","rav-milim","1.4","tg1",NULL,"stand_still",NULL,"עמד ללא ניע","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO refers to the first part of the definition","ordan-29 Dec 2004, assign-6 Nov 2003",94016,"2004-12-29");
INSERT INTO hebrew_synonyms VALUES (1493,"!עָנָף","n","09440981","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"branch, frond, sprig, spray",NULL,NULL,"reviewed","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-22 Dec 2004, assign-6 Nov 2003",0,"2004-12-22");
INSERT INTO hebrew_synonyms VALUES (1494,"!עָסַק","v","01644138","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"be_involved_with, work_at",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-29 Dec 2004, assign-6 Nov 2003",0,"2004-12-29");
INSERT INTO hebrew_synonyms VALUES (1495,"!עָצַר","n","03146454","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"stopper, stop",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-22 Dec 2004, assign-6 Nov 2003",0,"2004-12-22");
INSERT INTO hebrew_synonyms VALUES (1496,"עָצַר","v","01745445","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"stop, halt",NULL,NULL,"checked","#ASSIGN:28.0=[gnd=4.0,gnd=7.0,si=7.0,bt(dir)=5.0,bt(dir)=5.0] #MZ@\r\n#NO","ordan-30 Dec 2004, assign-6 Nov 2003",94017,"2004-12-30");
INSERT INTO hebrew_synonyms VALUES (1497,"עָצַר","v","01270990","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"stop, halt",NULL,NULL,"checked","#ASSIGN:28.0=[gnd=4.0,gnd=7.0,si=7.0,bt(dir)=5.0,bt(dir)=5.0] #MZ@\r\n#NO","ordan-29 Dec 2004, assign-6 Nov 2003",94017,"2004-12-29");
INSERT INTO hebrew_synonyms VALUES (1498,"עָקַב","v","01486353","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"attend, pay_attention",NULL,"התלמידים עקבו בדריכות אחר דברי המרצה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-23 Dec 2004, assign-6 Nov 2003",93943,"2004-12-23");
INSERT INTO hebrew_synonyms VALUES (1499,"!עָרֵב","n","00694512","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"pleasant, pleasing",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-27 Dec 2004, assign-6 Nov 2003",0,"2004-12-27");
INSERT INTO hebrew_synonyms VALUES (1500,"!עָרֵב","n","07303718","n","melingo","1","rav-milim",NULL,"tg1","((law))","guarantor",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE gender","eyal-21 Dec 2005, assign-6 Nov 2003",0,"2005-12-21");
INSERT INTO hebrew_synonyms VALUES (1502,"!עָרוּץ","n","06733540","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"ravine, gorge, canyon, wadi",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-14 Sep 2004, assign-6 Nov 2003",0,"2004-09-14");
INSERT INTO hebrew_synonyms VALUES (1503,"עָרוּץ","n","06732888","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"ravine",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IN","ordan-14 Sep 2004",93299,"2004-09-14");
INSERT INTO hebrew_synonyms VALUES (1504,"עָרוּץ","n","04734014","yy","melingo","1.4","rav-milim","1.4","tg1",NULL,"channel",NULL,NULL,"checked","#ASSIGN:37.0=[gnd=7.0,flc(dic)=24.0,bt(dir)=6.0] #MZ@\r\n#NO\r\n#NO","ordan-14 Sep 2004",93299,"2004-09-14");
INSERT INTO hebrew_synonyms VALUES (1505,"עָרוּץ","n","04733874","nn","melingo","1.4","rav-milim","1.5","tg1",NULL,"channel",NULL,NULL,"checked","#ASSIGN:37.0=[gnd=7.0,flc(dic)=24.0,bt(dir)=6.0] #MZ@\r\n#NO\r\n#NO rethought it after looking at the Heb Academy site","ordan-23 Dec 2004, assign-6 Nov 2003",93299,"2004-12-23");
INSERT INTO hebrew_synonyms VALUES (1506,"!עָרוּץ","n","04734266","nn","melingo","4","rav-milim",NULL,"tg1","((telecommunications, computing))","channel, band, frequency",NULL,NULL,"checked","#ASSIGN:53.0=[gnd=4.0,flc(dic)=49.0] #MZ@\r\n#NO","ordan-23 Dec 2004, assign-6 Nov 2003",0,"2004-12-23");
INSERT INTO hebrew_synonyms VALUES (1507,"!עָרוּץ","n","03371714","nn","melingo","5","rav-milim",NULL,"tg1","((music))","sound_track",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,flc(dic)=49.0] #MZ@\r\n#NO","ordan-14 Sep 2004, assign-6 Nov 2003",0,"2004-09-14");
INSERT INTO hebrew_synonyms VALUES (1508,"עָתִיד","n","10849807","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"future",NULL,"העתיד עוד לפנינו","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-18 Sep 2004",93346,"2004-09-18");
INSERT INTO hebrew_synonyms VALUES (1509,"עָתִיד","n","04777460","yy","melingo","1.1","rav-milim","1.3","tg1",NULL,"future, future_tense",NULL,"נטיית העתיד של הפעול הולך היא יֵלֵךְ","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-18 Sep 2004",93346,"2004-09-18");
INSERT INTO hebrew_synonyms VALUES (1510,"!עוֹבֵד","n","07240707","y","melingo","1","rav-milim",NULL,"tg1",NULL,"worker, employee",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1511,"!עוֹד","r","00096714","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"more, another",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-29 Dec 2004, assign-6 Nov 2003",0,"2004-12-29");
INSERT INTO hebrew_synonyms VALUES (1512,"!עוֹד","r","00096343","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"more, another",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-29 Dec 2004, assign-6 Nov 2003",0,"2004-12-29");
INSERT INTO hebrew_synonyms VALUES (1513,"!עוֹלֶה","n","07334599","u","melingo","1","rav-milim",NULL,"tg1",NULL,"immigrant",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE I added a new Hebrew synset for עולה since it is a unique word for Hebrew","eyal-28 Nov 2004, assign-6 Nov 2003",0,"2004-11-28");
INSERT INTO hebrew_synonyms VALUES (1514,"עוֹלָמִי","a","01512420","yy","melingo","1.1","rav-milim",">1.1","tg1",NULL,"world, worldwide, global",NULL,NULL,"checked","#ASSIGN:85.0=[gnd=39.0,gnd=13.0,si=33.0] #MZ@\r\n#NO","ordan-26 Dec 2004, assign-6 Nov 2003",93966,"2004-12-26");
INSERT INTO hebrew_synonyms VALUES (1515,"עוֹלָמִי","a","01617066","yy","melingo","1.2","rav-milim","1.3","tg1","((slang))","wonderful",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-02 Jan 2005, assign-6 Nov 2003",93966,"2005-01-02");
INSERT INTO hebrew_synonyms VALUES (1516,"עוֹנָה","n","10947841","yy","melingo","1.1","rav-milim",">1.3","tg1",NULL,"season",NULL,"עונת האבוקדו קרבה ובאה; את העונה החדשה בתיאטרון יפתח מחזה של שקספיר","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-19 Sep 2004",93371,"2004-09-19");
INSERT INTO hebrew_synonyms VALUES (1517,"עוֹנָה","n","10947554","yy","melingo","1.1","rav-milim","1.4","tg1",NULL,"season",NULL,"עונת החגים","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-19 Sep 2004",93371,"2004-09-19");
INSERT INTO hebrew_synonyms VALUES (1518,"עוֹנָה","n","10945309","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"season",NULL,"העונה האהובה עלי היא חורף","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-19 Sep 2004",93371,"2004-09-19");
INSERT INTO hebrew_synonyms VALUES (1519,"!עוֹרֵךְ","n","07234892","y","melingo","1","rav-milim",NULL,"tg1",NULL,"editor",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1520,"עוֹרֵךְ","n","04933998","yy","melingo","1.1","none",NULL,"tg1",NULL,"editor",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO taken from http://www.sivanbryce.co.il/milon/milon.asp?searchad1=editor","ordan-19 Sep 2004",93396,"2004-09-19");
INSERT INTO hebrew_synonyms VALUES (1521,"!פֶסְטִיבָל","n","10881782","y","melingo","1","rav-milim",NULL,"tg1",NULL,"festival",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1522,"פֶסְטִיבָל","n","00333254","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"festival",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-08 Jan 2005, assign-6 Nov 2003",94111,"2005-01-08");
INSERT INTO hebrew_synonyms VALUES (1523,"!פָה","n","05139664","y","melingo","1","rav-milim",NULL,"tg1","((music))","fa",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,flc(dic)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1524,"!פְּגִיעָה","n","00037139","nn","melingo","3","rav-milim",NULL,"tg1",NULL,"strike, hit",NULL,NULL,"checked","#ASSIGN:50=[gnd=7.0,gnd=7.0,si=9.0,dfl=27.0] #MZ@\r\n#NO","ordan-08 Jan 2005, assign-6 Nov 2003",0,"2005-01-08");
INSERT INTO hebrew_synonyms VALUES (1525,"פְּנִים","n","06333215","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"interior",NULL,"פנים הארץ","checked","#ASSIGN:121.0=[gnd=2.0E+01,gnd=2.0E+01,si=33.0,bt(dir)=24.0,bt(dir)=24.0] #MZ@\r\n#NO","ordan-30 Jan 2005, assign-6 Nov 2003",94325,"2005-01-30");
INSERT INTO hebrew_synonyms VALUES (1526,"פְּנִים","n","06333091","yy","melingo","1.1","rav-milim","1.3","tg1",NULL,"interior, inside",NULL,"פנים הבית היה נקי, אך חדר המדרגות היה מלוכלך","checked","#ASSIGN:121.0=[gnd=2.0E+01,gnd=2.0E+01,si=33.0,bt(dir)=24.0,bt(dir)=24.0] #MZ@\r\n#NO","ordan-30 Jan 2005, assign-6 Nov 2003",94325,"2005-01-30");
INSERT INTO hebrew_synonyms VALUES (1527,"!פְּנִים","n","06061034","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"inside, interior",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-30 Jan 2005, assign-6 Nov 2003",0,"2005-01-30");
INSERT INTO hebrew_synonyms VALUES (1528,"!פְּעִילוּת","n","10090167","y","melingo","1","rav-milim",NULL,"tg1",NULL,"activity, operation",NULL,NULL,"assigned","#ASSIGN:28.0=[gnd=6.0,bt(dir)=5.0,bt(dir)=6.0,bt(crs)=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1529,"פְּעֻלָּה","n","00017487","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"act",NULL,NULL,"checked","#ASSIGN:25.0=[gnd=7.0,bt(dir)=6.0,bt(dir)=3.0,bt(crs)=9.0] #MZ@\r\n#NO","ordan-08 Jan 2005, assign-6 Nov 2003",94105,"2005-01-08");
INSERT INTO hebrew_synonyms VALUES (1530,"!פְּרָטִי","a","01703258","y","melingo","2","rav-milim",NULL,"tg1",NULL,"individual",NULL,NULL,"assigned","#ASSIGN:50=[gnd=1.0E+01,bt(dir)=11.0,dfl=29.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1531,"פְּרָס","n","09547800","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"prize",NULL,"הפרס הראשון היה שבוע זוגי באירופה","checked","#ASSIGN:67.0=[gnd=13.0,bt(dir)=14.0,bt(dir)=13.0,bt(crs)=27.0] #MZ@\r\n#NO","ordan-03 Feb 2005, assign-6 Nov 2003",90874,"2005-02-03");
INSERT INTO hebrew_synonyms VALUES (1532,"!פְּרָס","n","09543577","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"prize",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-03 Feb 2005, assign-6 Nov 2003",0,"2005-02-03");
INSERT INTO hebrew_synonyms VALUES (1533,"!פְּרָס","n","03543694","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"prize",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","ordan-03 Feb 2005, assign-6 Nov 2003",0,"2005-02-03");
INSERT INTO hebrew_synonyms VALUES (1535,"!פְּרָס","n","05020360","y","melingo","2","rav-milim",NULL,"tg1",NULL,"award",NULL,NULL,"assigned","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6657,"הֵחָלְשׁוּת","n","05455349","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"weakening",NULL,"החלשות המערכת החיסונית בעקבות נטילה ממושכת של אנטיביוטיקה היא עובדה ידועה","checked","#IE","eyal-20 Apr 2004",91221,"2004-04-20");
INSERT INTO hebrew_synonyms VALUES (1537,"!פְּרוֹיֶקְט","n","04541674","y","melingo","1","rav-milim",NULL,"tg1",NULL,"project",NULL,NULL,"assigned","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1538,"!פְּרוֹיֶקְט","n","00508925","y","melingo","1","rav-milim",NULL,"tg1",NULL,"project",NULL,NULL,"assigned","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1539,"!פְּרוֹיֶקְט","n","00468909","y","melingo","1","rav-milim",NULL,"tg1",NULL,"project",NULL,NULL,"assigned","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1540,"!פְּתִיחָה","n","04822335","y","melingo","3","rav-milim",NULL,"tg1",NULL,"preface, introduction",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1541,"!פְּתִיחָה","n","05279046","y","melingo","4","rav-milim",NULL,"tg1","((music))","overture",NULL,NULL,"assigned","#ASSIGN:62.0=[gnd=13.0,flc(dic)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1543,"פִּי","n","05119853","yy","melingo","1","rav-milim",NULL,"tg2",NULL,"phi",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-29 Jan 2005, assign-6 Nov 2003",92745,"2005-01-29");
INSERT INTO hebrew_synonyms VALUES (1544,"פִּסְגָּה","n","10045044","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"height, peak",NULL,"פסגת שאיפותיו","checked","#ASSIGN:193.0=[gnd=1.0E+01,gnd=5.0,gnd=1.0E+01,si=12.0,bt(dir)=9.0,bt(dir)=5.0,bt(dir)=9.0,bt(dir)=3.0,bt(crs)=78.0,bt(dir)=9.0,bt(dir)=5.0,bt(dir)=9.0,bt(dir)=3.0,bt(dir)=9.0,bt(dir)=5.0,bt(dir)=9.0,bt(dir)=3.0] #MZ@\r\n#NO","ordan-30 Jan 2005, assign-6 Nov 2003",94321,"2005-01-30");
INSERT INTO hebrew_synonyms VALUES (1545,"!פִּסְגָּה","n","10019938","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"summit, peak, height",NULL,NULL,"checked","#ASSIGN:68.0=[gnd=1.0E+01,gnd=5.0,si=8.0,bt(dir)=5.0,bt(dir)=1.0E+01,bt(crs)=15.0,bt(dir)=5.0,bt(dir)=1.0E+01] #MZ@\r\n#IE","eyal-10 Mar 2005, assign-6 Nov 2003",0,"2005-03-10");
INSERT INTO hebrew_synonyms VALUES (1546,"!פִּסְגָּה","n","10018378","nn","none","1","none",NULL,"tg1",NULL,"summit, peak, height",NULL,NULL,"checked","#ASSIGN:27.0=[gnd=5.0,bt(dir)=7.0,bt(dir)=4.0,bt(crs)=11.0] #MZ@\r\n#NO","ordan-30 Jan 2005, assign-6 Nov 2003",0,"2005-01-30");
INSERT INTO hebrew_synonyms VALUES (1547,"פִּסְגָּה","n","06349777","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"summit, peak",NULL,"הנוף שראינו מראש האוורסט היה מדהים","checked","#ASSIGN:133.0=[gnd=1.0E+01,gnd=5.0,si=8.0,bt(dir)=4.0,bt(dir)=3.0,bt(dir)=6.0,bt(dir)=9.0,bt(crs)=66.0,bt(dir)=4.0,bt(dir)=3.0,bt(dir)=6.0,bt(dir)=9.0] #MZ@\r\n#NO","ordan-30 Jan 2005, assign-6 Nov 2003",94321,"2005-01-30");
INSERT INTO hebrew_synonyms VALUES (1548,"!פִּסְגָּה","n","06392752","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"zenith",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-30 Jan 2005, assign-6 Nov 2003",0,"2005-01-30");
INSERT INTO hebrew_synonyms VALUES (1549,"!פִּרְסוּם","n","05409803","y","melingo","1","rav-milim",NULL,"tg1",NULL,"publicity",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1550,"פִּרְסוּם","n","04944010","yy","melingo","1.2","rav-milim","1.5","tg1",NULL,"publication",NULL,"פרסומי המכון הישראלי לדמוקרטיה עוררו מחלוקת פוליטית","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-26 Jan 2005, assign-6 Nov 2003",94231,"2005-01-26");
INSERT INTO hebrew_synonyms VALUES (1551,"פִּרְסוּם","n","00715056","yy","melingo","1.2","rav-milim","1.4","tg1",NULL,"publication",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#NO","ordan-26 Jan 2005, assign-6 Nov 2003",94231,"2005-01-26");
INSERT INTO hebrew_synonyms VALUES (1552,"!פִּרְסוּם","n","00713952","y","melingo","2","rav-milim",NULL,"tg1",NULL,"publication",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1553,"!פִּתָּרוֹן","n","05053336","n","melingo","1","rav-milim",NULL,"tg1",NULL,"solution, answer",NULL,NULL,"assigned","#ASSIGN:50=[gnd=1.0E+01,gnd=8.0,si=12.0,bt(dir)=6.0,bt(dir)=6.0,dfl=8.0] #MZ@\r\n#IE nonstandard form","eyal-02 Jun 2005, assign-6 Nov 2003",0,"2005-06-02");
INSERT INTO hebrew_synonyms VALUES (1554,"פִּתּוּחַ","n","09745553","yy","melingo","1.1","rav-milim","1.6","tg1",NULL,"developing, development",NULL,"במעבדה החדשה מתחייבים על פיתוח תמונות תוך פחות משעה","checked","#ASSIGN:66.0=[gnd=39.0,gnd=5.0,si=12.0,bt(dir)=5.0,bt(dir)=5.0] #MZ@\r\n#NO","ordan-10 Feb 2005, assign-6 Nov 2003",94466,"2005-02-10");
INSERT INTO hebrew_synonyms VALUES (1555,"!פִּתּוּחַ","n","00591217","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"landscaping",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-26 Jan 2005, assign-6 Nov 2003",0,"2005-01-26");
INSERT INTO hebrew_synonyms VALUES (1556,"!פִּתּוּחַ","n","00600227","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"etching, engraving, openwork",NULL,NULL,"checked","#ASSIGN:42.0=[gnd=13.0,gnd=13.0,si=16.0] #MZ@\r\n#NO","ordan-26 Jan 2005, assign-6 Nov 2003",0,"2005-01-26");
INSERT INTO hebrew_synonyms VALUES (1557,"!פִּתּוּחַ","n","03058819","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"etching, engraving, openwork",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-10 Feb 2005, assign-6 Nov 2003",0,"2005-02-10");
INSERT INTO hebrew_synonyms VALUES (1558,"פֶּגַע","n","05465616","yy","melingo","1.3","rav-milim","1.2","tg1",NULL,"ravage",NULL,"פגעי הזמן; פגעי טבע","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-04 Feb 2005, assign-6 Nov 2003",94397,"2005-02-04");
INSERT INTO hebrew_synonyms VALUES (1559,"!פֶּה","n","04076503","y","melingo","2","rav-milim",NULL,"tg1",NULL,"opening, orifice, entrance",NULL,NULL,"assigned","#ASSIGN:50=[gnd=3.0,gnd=39.0,si=7.0,dfl=1.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1560,"פֶּחָה","n","07460301","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"pasha, pacha",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-29 Jan 2005, assign-6 Nov 2003",94292,"2005-01-29");
INSERT INTO hebrew_synonyms VALUES (1561,"פֶּנִי","n","09856513","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"penny",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-29 Jan 2005, assign-6 Nov 2003",94294,"2005-01-29");
INSERT INTO hebrew_synonyms VALUES (1562,"!פֶּנִי","n","09644617","y","melingo","1","rav-milim",NULL,"tg1",NULL,"penny",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1563,"פֶּרֶק","n","04335626","yy","melingo","1.4","rav-milim","1.7","tg1",NULL,"joint",NULL,NULL,"checked","#ASSIGN:64.0=[gnd=7.0,flc(dic)=49.0,bt(dir)=8.0] #MZ@\r\n#NO","ordan-28 Jan 2005, assign-6 Nov 2003",94276,"2005-01-28");
INSERT INTO hebrew_synonyms VALUES (1564,"!פֶּתַח","n","05527437","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"entrance",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-10 Feb 2005, assign-6 Nov 2003",0,"2005-02-10");
INSERT INTO hebrew_synonyms VALUES (1565,"פֶּתַח","n","02641840","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"entrance",NULL,NULL,"checked","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@\r\n#NO","ordan-10 Feb 2005, assign-6 Nov 2003",94467,"2005-02-10");
INSERT INTO hebrew_synonyms VALUES (1566,"!פֶּתַח","n","00026402","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"entrance",NULL,NULL,"checked","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@\r\n#IE פתח is not an action","eyal-11 Jul 2004, assign-6 Nov 2003",0,"2004-07-11");
INSERT INTO hebrew_synonyms VALUES (1567,"פַּעַם","r","00116080","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"once, formerly",NULL,"פעם, כשהייתי ילד, הייתי באמריקה","checked","#ASSIGN:94.0=[gnd=13.0,gnd=2.0E+01,si=33.0,bt(dir)=14.0,bt(dir)=14.0] #MZ@\r\n#NO","ordan-04 Aug 2004",91222,"2004-08-04");
INSERT INTO hebrew_synonyms VALUES (1568,"!פַּעַם","r","00177383","nn","melingo","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-10 Feb 2005, assign-6 Nov 2003",0,"2005-02-10");
INSERT INTO hebrew_synonyms VALUES (1569,"!פַּעַם","r","00115984","y","melingo","1","rav-milim",NULL,"tg1",NULL,"once, formerly",NULL,NULL,"assigned","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1570,"פָּגַע","v","00069684","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"harm",NULL,"המיתון הכלכלי לא פגע ברמת החיים של העשירון העליון","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO as an equivalent to הזיק RM offers ''damage''; therefore, the definition I came up with is far from being perfect","ordan-09 Feb 2005, assign-6 Nov 2003",94434,"2005-02-09");
INSERT INTO hebrew_synonyms VALUES (1571,"!פָּגַע","v","00575170","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"insult, hurt",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO try \'hurt\', v#01224189","ordan-09 Feb 2005, assign-6 Nov 2003",0,"2005-02-09");
INSERT INTO hebrew_synonyms VALUES (1572,"!פָּגַע","v","01562883","nn","melingo","3","rav-milim",NULL,"tg1","((biblical))","chance_upon",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-09 Feb 2005, assign-6 Nov 2003",0,"2005-02-09");
INSERT INTO hebrew_synonyms VALUES (1573,"!פָּגַע","v","00516262","nn","melingo","4","rav-milim",NULL,"tg1","((biblical))","entreat",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO too esoteric","ordan-09 Feb 2005, assign-6 Nov 2003",0,"2005-02-09");
INSERT INTO hebrew_synonyms VALUES (1574,"!פָּחוֹת","r","00258112","y","melingo","2","rav-milim",NULL,"tg1",NULL,"less_than, fewer_than",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1575,"פָּלֶשְׂתִּינִי","a","02739809","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"Palestinian",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-07 Jan 2005, assign-6 Nov 2003",0,"2005-01-07");
INSERT INTO hebrew_synonyms VALUES (1576,"פָּלֶשְׂתִּינִי","n","07023466","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"Palestinian",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-07 Jan 2005, assign-6 Nov 2003",94102,"2005-01-07");
INSERT INTO hebrew_synonyms VALUES (1577,"פָּלֶשְׂתִּינָאִי","a","02739809","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"Palestinian",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-07 Jan 2005, assign-6 Nov 2003",0,"2005-01-07");
INSERT INTO hebrew_synonyms VALUES (1578,"פָּלֶשְׂתִּינָאִי","n","07023466","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"Palestinian",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-07 Jan 2005, assign-6 Nov 2003",94101,"2005-01-07");
INSERT INTO hebrew_synonyms VALUES (1579,"!פָּעַל","v","01722366","y","melingo","1","rav-milim",NULL,"tg1",NULL,"do, achieve",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (8158,"הִקְטִין","v","00308251","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"lessen",NULL,"לאחרונה הקטין את צוות העובדים שלו","checked","#NO","ordan-08 Feb 2005",94426,"2005-02-08");
INSERT INTO hebrew_synonyms VALUES (1581,"!פָּרָשָׁה","n","10038885","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"matter, affair, issue",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-19 Sep 2004, assign-6 Nov 2003",0,"2004-09-19");
INSERT INTO hebrew_synonyms VALUES (1582,"!פָּרָשָׁה","n","05538537","u","melingo","1","rav-milim","1.1","tg1",NULL,"matter, affair, issue",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#NO","ordan-19 Sep 2004, assign-6 Nov 2003",0,"2004-09-19");
INSERT INTO hebrew_synonyms VALUES (1583,"!פָּרָשָׁה","n","04384343","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"matter, affair, issue",NULL,NULL,"checked","#ASSIGN:51.0=[gnd=7.0,gnd=13.0,si=5.0,bt(dir)=13.0,bt(dir)=13.0] #MZ@\r\n#NO","ordan-14 Aug 2004, assign-6 Nov 2003",0,"2004-08-14");
INSERT INTO hebrew_synonyms VALUES (1584,"!פָּשׁוּט","a","01375703","y","melingo","1","rav-milim",NULL,"tg1",NULL,"extended, stretched_out",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1585,"!פָּתַח","v","00877349","y","melingo","3","rav-milim",NULL,"tg1",NULL,"unwrap",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1586,"פֹּעַל","n","04767056","yy","melingo","1.1","none",NULL,"tg1",NULL,"verb",NULL,NULL,"checked","#ASSIGN:69.0=[gnd=2.0E+01,flc(dic)=49.0] #MZ@\r\n#NO I\'m assigning here a slightly different meaning from n#04769237","ordan-29 Jan 2005, assign-6 Nov 2003",94279,"2005-01-29");
INSERT INTO hebrew_synonyms VALUES (1587,"!פּוֹלִיטִי","a","02646845","y","melingo","1","rav-milim",NULL,"tg1",NULL,"political",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1588,"!פּוֹלִיטִי","a","02646683","y","melingo","1","rav-milim",NULL,"tg1",NULL,"political",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1589,"!פּוֹלִיטִי","a","01743546","y","melingo","1","rav-milim",NULL,"tg1",NULL,"political",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1590,"!פּוֹעֵל","n","07360164","y","melingo","1","rav-milim",NULL,"tg1",NULL,"worker, laborer",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1591,"!צְבָאִי","a","02586912","y","melingo","1","rav-milim",NULL,"tg1",NULL,"military",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1592,"צְבָאִי","a","01455377","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"military",NULL,"יש לו תספורת קצוצה בסגנון צבאי","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-17 Jan 2005, assign-6 Nov 2003",94161,"2005-01-17");
INSERT INTO hebrew_synonyms VALUES (1593,"צְבָאִי","a","01454237","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"military",NULL,"למשטרה צבאית אין סמכות לעצור אזרחים","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-17 Jan 2005, assign-6 Nov 2003",94161,"2005-01-17");
INSERT INTO hebrew_synonyms VALUES (1594,"צִבּוּר","n","06079949","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"public",NULL,"הוא הפך לגיבור בעיני הציבור","checked","#ASSIGN:41.0=[gnd=2.0E+01,bt(dir)=21.0] #MZ@\r\n#NO","ordan-28 Dec 2004, assign-6 Nov 2003",93990,"2004-12-28");
INSERT INTO hebrew_synonyms VALUES (1595,"!צִבּוּר","n","05972960","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"public, population",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-28 Dec 2004, assign-6 Nov 2003",0,"2004-12-28");
INSERT INTO hebrew_synonyms VALUES (1596,"!צִבּוּרִי","a","00460814","y","melingo","1","rav-milim",NULL,"tg1",NULL,"public, communal",NULL,NULL,"assigned","#ASSIGN:41.0=[gnd=2.0E+01,bt(dir)=21.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1597,"צִבּוּרִי","a","01790261","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"public",NULL,"אחת לשבוע אנו מחליפים ספרים בספרייה הציבורית","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-17 Jan 2005, assign-6 Nov 2003",94160,"2005-01-17");
INSERT INTO hebrew_synonyms VALUES (1598,"צִיֵּן","v","00689564","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"note, mention",NULL,"הרב ציין שצער בעלי חיים אסור מן התורה","checked","#ASSIGN:58.0=[gnd=1.0E+01,gnd=13.0,si=11.0,bt(dir)=12.0,bt(dir)=12.0] #MZ@\r\n#IE","eyal-31 Jan 2005, assign-6 Nov 2003",94346,"2005-01-31");
INSERT INTO hebrew_synonyms VALUES (1599,"!צִיֵּן","v","00439665","u","melingo","4","rav-milim",NULL,"tg1",NULL,"differentiate, distinguish",NULL,NULL,"checked","#ASSIGN:28.0=[gnd=8.0,gnd=8.0,si=12.0] #MZ@\r\n#IE","eyal-31 Jan 2005, assign-6 Nov 2003",0,"2005-01-31");
INSERT INTO hebrew_synonyms VALUES (1600,"!צִיֵּן","v","00438616","u","melingo","4","rav-milim",NULL,"tg1",NULL,"differentiate, distinguish",NULL,NULL,"checked","#ASSIGN:28.0=[gnd=8.0,gnd=8.0,si=12.0] #MZ@\r\n#IE","eyal-31 Jan 2005, assign-6 Nov 2003",0,"2005-01-31");
INSERT INTO hebrew_synonyms VALUES (1601,"!צֶוֶת","n","06093198","undef","melingo","1.1","rav-milim","1.1","tg1",NULL,"team",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-31 Jan 2005, assign-6 Nov 2003",0,"2005-01-31");
INSERT INTO hebrew_synonyms VALUES (1602,"!צֶוֶת","n","05982639","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"staff, team, crew",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-31 Jan 2005, assign-6 Nov 2003",0,"2005-01-31");
INSERT INTO hebrew_synonyms VALUES (1603,"צֶפִי","n","05058536","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"forecast",NULL,"קיים צפי לגידול של כעשרים אחוז במכירות משחקי המחשב בשנה הבאה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-30 Jan 2005, assign-6 Nov 2003",94301,"2005-01-30");
INSERT INTO hebrew_synonyms VALUES (1605,"צַעַד","n","05497366","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"footstep, footfall",NULL,"הוא שמע צעדים מכיוון המרפסת","checked","#ASSIGN:95.0=[gnd=13.0,gnd=39.0,si=33.0,bt(dir)=5.0,bt(dir)=5.0] #MZ@\r\n#IE","eyal-30 Jan 2005, assign-6 Nov 2003",94312,"2005-01-30");
INSERT INTO hebrew_synonyms VALUES (1606,"צַעַד","n","09907411","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"footstep",NULL,"רק כמה צעדים הפרידו ביני לבין קו הסיום","checked","#ASSIGN:33.0=[gnd=13.0,bt(dir)=6.0,bt(dir)=4.0,bt(crs)=1.0E+01] #MZ@\r\n#IE","eyal-30 Jan 2005, assign-6 Nov 2003",94312,"2005-01-30");
INSERT INTO hebrew_synonyms VALUES (1607,"צָבָא","n","06089493","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"army",NULL,"הצלבנים התבצרו במנזר אנטיפטרוס מפני צבאותיו של צלאח א-דין עד שנכנעו","checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#IE","eyal-31 Jan 2005, assign-6 Nov 2003",94330,"2005-01-31");
INSERT INTO hebrew_synonyms VALUES (1608,"!צָבָא","n","06082744","y","melingo","2","rav-milim",NULL,"tg1",NULL,"army",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1609,"!צָבָא","n","05725136","nn","melingo","3","rav-milim",NULL,"tg1",NULL,"host, multitude",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-17 Nov 2004, assign-6 Nov 2003",0,"2004-11-17");
INSERT INTO hebrew_synonyms VALUES (1610,"צָבָא","v","01382752","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"mass",NULL,"המונים צבאו על הארמון מבחוץ","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-31 Jan 2005, assign-6 Nov 2003",94353,"2005-01-31");
INSERT INTO hebrew_synonyms VALUES (1611,"צָעִיר","a","01587804","yy","melingo","1.1","rav-milim","1.1a","tg1",NULL,"young, immature",NULL,"בגילה הצעיר היא כבר אמא","checked","#ASSIGN:89.0=[gnd=2.0E+01,gnd=7.0,si=14.0,bt(dir)=24.0,bt(dir)=24.0] #MZ@\r\n#IE","eyal-18 Jan 2005, assign-6 Nov 2003",94165,"2005-01-18");
INSERT INTO hebrew_synonyms VALUES (1612,"!צָעִיר","a","00778835","y","melingo","1","rav-milim",NULL,"tg1",NULL,"young, immature",NULL,NULL,"assigned","#ASSIGN:41.0=[gnd=2.0E+01,bt(dir)=21.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1613,"!צָעִיר","a","01589874","y","melingo","3","rav-milim",NULL,"tg1",NULL,"youthful",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1614,"צָעִיר","n","07692038","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"youth, young_person",NULL,"האישה העידה כי הבחינה בצעיר מתרחק בריצה ממקום האירוע","checked","#ASSIGN:74.0=[gnd=7.0,gnd=39.0,si=16.0,bt(dir)=6.0,bt(dir)=6.0] #MZ@\r\n#IE","eyal-18 Jan 2005, assign-6 Nov 2003",94164,"2005-01-18");
INSERT INTO hebrew_synonyms VALUES (1615,"!צָעִיר","n","05959071","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"youth, young_person",NULL,NULL,"checked","#ASSIGN:67.0=[gnd=7.0,bt(dir)=23.0,bt(dir)=7.0,bt(crs)=3.0E+01] #MZ@\r\n#IE","eyal-18 Jan 2005, assign-6 Nov 2003",0,"2005-01-18");
INSERT INTO hebrew_synonyms VALUES (1616,"!צָעִיר","n","06950430","y","melingo","2","rav-milim",NULL,"tg1",NULL,"juvenile",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1618,"צָעַד","v","01316088","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"step",NULL,"הבא שאקרא בשמו, מתבקש לצעוד שני צעדים קדימה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-01 Feb 2005, assign-6 Nov 2003",94357,"2005-02-01");
INSERT INTO hebrew_synonyms VALUES (1619,"!צָעַד","v","01313443","y","melingo","3","rav-milim",NULL,"tg1",NULL,"parade",NULL,NULL,"assigned","#ASSIGN:28.0=[gnd=2.0E+01,bt(dir)=8.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1620,"!צָעַד","v","01345133","y","melingo","4","rav-milim",NULL,"tg1",NULL,"hike",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1621,"!צָעַד","v","01310684","y","melingo","4","rav-milim",NULL,"tg1",NULL,"hike",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1622,"!צָפוֹן","n","09963172","y","melingo","1","rav-milim",NULL,"tg1",NULL,"north",NULL,NULL,"assigned","#ASSIGN:37.0=[gnd=2.0E+01,bt(dir)=17.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1623,"צָפוֹן","n","09962919","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"north",NULL,"אם נמשיך ללכת לכיוון צפון, נגיע למחוז חפצנו","checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#IE","eyal-31 Jan 2005, assign-6 Nov 2003",94336,"2005-01-31");
INSERT INTO hebrew_synonyms VALUES (1624,"!צָפוּי","a","00882114","y","melingo","1","rav-milim",NULL,"tg1",NULL,"expected, anticipated, foreseen",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1625,"!צָפוּן","a","02396532","y","melingo","1","rav-milim",NULL,"tg1",NULL,"hidden, concealed, encrypted",NULL,NULL,"assigned","#ASSIGN:5.0E+01=[gnd=1.0E+01,gnd=2.0E+01,si=2.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1626,"צָרְפָתִי","a","02727539","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"French",NULL,"המטבח הצרפתי הינו מטבח מעודן ומתוחכם ביותר","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-19 Jan 2005, assign-6 Nov 2003",94171,"2005-01-19");
INSERT INTO hebrew_synonyms VALUES (1627,"!צָרְפָתִי","n","07019437","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"Frenchman",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE gender","eyal-27 Feb 2005, assign-6 Nov 2003",0,"2005-02-27");
INSERT INTO hebrew_synonyms VALUES (1628,"!צָרִיךְ","a","02463868","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"worthwhile, necessary, important",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-18 Jan 2005, assign-6 Nov 2003",0,"2005-01-18");
INSERT INTO hebrew_synonyms VALUES (6739,"חוֹבָה","a","00857047","yy","none",NULL,"none",NULL,NULL,NULL,"must",NULL,"זה ספר מדהים, פשוט חובה!","checked","#NO doesn\'t appear for some reason in the dictionaries","ordan-23 May 2004",91223,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (1630,"צֹרֶךְ","n","06846327","yy","melingo","1.2","rav-milim","1.1b","tg1",NULL,"necessity",NULL,"הוא הבטיח לדאוג לכל צרכיה","checked","#ASSIGN:31.0=[gnd=2.0E+01,bt(dir)=11.0] #MZ@\r\n#IE","eyal-26 Jan 2005, assign-6 Nov 2003",94224,"2005-01-26");
INSERT INTO hebrew_synonyms VALUES (1631,"!צֹרֶךְ","n","04528955","u","melingo","3","rav-milim",NULL,"tg1",NULL,"requirement",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#IE","eyal-27 Jan 2005, assign-6 Nov 2003",0,"2005-01-27");
INSERT INTO hebrew_synonyms VALUES (1632,"!צֹרֶךְ","n","04528749","u","melingo","3","rav-milim",NULL,"tg1",NULL,"requirement",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-27 Jan 2005, assign-6 Nov 2003",0,"2005-01-27");
INSERT INTO hebrew_synonyms VALUES (1633,"!צוּרָה","n","04055717","u","melingo","1","rav-milim",NULL,"tg1",NULL,"shape, form, figure, appearance",NULL,NULL,"checked","#ASSIGN:4.0E+01=[gnd=6.0,gnd=3.0,gnd=3.0,si=4.0,bt(dir)=2.0,bt(dir)=4.0,bt(crs)=6.0,bt(dir)=2.0,bt(dir)=4.0,bt(dir)=2.0,bt(dir)=4.0] #MZ@\r\n#IE","eyal-26 Jan 2005, assign-6 Nov 2003",0,"2005-01-26");
INSERT INTO hebrew_synonyms VALUES (1634,"!צוּרָה","n","03858557","y","melingo","3","rav-milim",NULL,"tg1",NULL,"way, method, type",NULL,NULL,"assigned","#ASSIGN:67.0=[gnd=2.0E+01,bt(dir)=47.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1635,"צוּרָה","n","03856995","yy","melingo","1.3","rav-milim","1.4","tg1",NULL,"way, method, type",NULL,NULL,"checked","#ASSIGN:6.0E+01=[gnd=3.0,bt(dir)=1.0E+01,bt(dir)=6.0,bt(dir)=3.0,bt(crs)=38.0] #MZ@\r\n#NO","ordan-12 Aug 2004",0,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (1636,"!קְבוּצָה","n","10473160","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"group",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-06 Feb 2005, assign-6 Nov 2003",0,"2005-02-06");
INSERT INTO hebrew_synonyms VALUES (1637,"קְבוּצָה","n","04606861","yy","melingo","1.1","rav-milim","1.4","tg1",NULL,"group",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#IE","eyal-06 Feb 2005, assign-6 Nov 2003",92975,"2005-02-06");
INSERT INTO hebrew_synonyms VALUES (1638,"קְבוּצָה","n","00017954","yy","melingo","1.1","rav-milim","1.4","tg1",NULL,"group",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO RM\'s is pure mathematical, but it shares the same basic idea","ordan-16 Sep 2005, assign-6 Nov 2003",92975,"2005-09-16");
INSERT INTO hebrew_synonyms VALUES (1639,"קְבוּצָה","n","06093198","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"team",NULL,"הקבוצה שלי השתתפה בכל משחקי הליגה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-31 Jan 2005, assign-6 Nov 2003",92975,"2005-01-31");
INSERT INTO hebrew_synonyms VALUES (1640,"!קְבוּצָה","n","05982639","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"team",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-31 Jan 2005, assign-6 Nov 2003",0,"2005-01-31");
INSERT INTO hebrew_synonyms VALUES (1641,"קְהִלָּה","n","05986276","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"congregation",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE WN restricts the meaning of ''congregation'' to the Christian world, and RM restricts it to the Jewish world. I think it fits both.","eyal-15 Feb 2005, assign-6 Nov 2003",92336,"2005-02-15");
INSERT INTO hebrew_synonyms VALUES (1642,"!קְהִלָּה","n","05979928","y","melingo","2","rav-milim",NULL,"tg1",NULL,"congregation",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1643,"!קְהִלָּה","n","00799654","y","melingo","2","rav-milim",NULL,"tg1",NULL,"congregation",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1644,"!קְרִיאָה","n","06500621","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"reading",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-11 Jan 2005, assign-6 Nov 2003",0,"2005-01-11");
INSERT INTO hebrew_synonyms VALUES (1645,"!קְרָב","n","00758807","y","melingo","1","rav-milim",NULL,"tg1",NULL,"battle, combat",NULL,NULL,"assigned","#ASSIGN:76.0=[gnd=2.0E+01,bt(dir)=9.0,bt(dir)=19.0,bt(crs)=28.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1646,"!קְרָב","n","00619159","y","melingo","1","rav-milim",NULL,"tg1",NULL,"battle, combat",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1648,"קְרָב","n","00610417","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"battle, combat",NULL,"הפנטזיות הרומנטיות שלו על מלחמה התפוגגו ברגע שנקלע לקרב אמיתי","checked","#ASSIGN:57.0=[gnd=13.0,bt(dir)=14.0,bt(dir)=8.0,bt(crs)=22.0] #MZ@\r\n#IE","eyal-01 Feb 2005, eyal-08 Aug 2004, assign-6 Nov 2003",92863,"2005-02-01");
INSERT INTO hebrew_synonyms VALUES (1650,"קְרָב","n","00614914","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"stuggle",NULL,"הנואם ניהל קרב מילולי עם שניים משומעיו","checked","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@\r\n#IE","eyal-01 Feb 2005, eyal-08 Aug 2004, assign-6 Nov 2003",92863,"2005-02-01");
INSERT INTO hebrew_synonyms VALUES (1651,"!קְרָב","n","00505798","u","melingo","2","rav-milim",NULL,"tg1",NULL,"struggle, race",NULL,NULL,"checked","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@\r\n#IE see !מלחמה","eyal-08 Aug 2004, assign-6 Nov 2003",0,"2004-08-08");
INSERT INTO hebrew_synonyms VALUES (1652,"!קִיֵּם","v","01860915","y","melingo","4","rav-milim",NULL,"tg1",NULL,"support, provide_for, sustain",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1653,"!קִיֵּם","v","00449252","y","melingo","5","rav-milim",NULL,"tg1","((law))","affirm, confirm, implement",NULL,NULL,"assigned","#ASSIGN:31.0=[gnd=13.0,gnd=8.0,si=1.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1654,"!קִיּוּם","n","00788511","undef","melingo","3","rav-milim",NULL,"tg1",NULL,"maintenance, sustenance, subsistence",NULL,NULL,"checked","#ASSIGN:58.0=[gnd=1.0E+01,gnd=13.0,si=11.0,bt(dir)=12.0,bt(dir)=12.0] #MZ@\r\n#NO it\'s not the act but rather the condition created by the act","ordan-04 Apr 2004",0,"2004-04-04");
INSERT INTO hebrew_synonyms VALUES (1655,"!קִיּוּם","n","00787796","nn","melingo","5","rav-milim",NULL,"tg1","((law))","approval, validation, ratification",NULL,NULL,"checked","#ASSIGN:34.0=[gnd=1.0E+01,flc(dic)=24.0] #MZ@\r\n#IE","eyal-09 Feb 2005, assign-6 Nov 2003",0,"2005-02-09");
INSERT INTO hebrew_synonyms VALUES (1656,"קִיּוּם","n","05367196","yy","melingo","1.5","rav-milim","1.7","tg1","((law))","ratification",NULL,"מנהלת בית הספר החליטה על קיום החלטתה של המורה בנוגע להשעייתו של התלמיד","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-09 Feb 2005, assign-6 Nov 2003",0,"2005-02-09");
INSERT INTO hebrew_synonyms VALUES (1657,"!קֶבַע","n","04084248","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"permanent",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-13 Feb 2005, assign-6 Nov 2003",0,"2005-02-13");
INSERT INTO hebrew_synonyms VALUES (1658,"קֶבַע","n","06209363","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"standing_army",NULL,"בזמן שירותי בקבע הצלחתי לחסוך מספיק כסף לטיול בארצות הברית","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-13 Feb 2005, assign-6 Nov 2003",94485,"2005-02-13");
INSERT INTO hebrew_synonyms VALUES (1659,"!קֶטַע","n","04514703","y","melingo","1","rav-milim",NULL,"tg1",NULL,"section, part",NULL,NULL,"assigned","#ASSIGN:28.0=[gnd=3.0,gnd=3.0,si=4.0,bt(dir)=3.0,bt(dir)=3.0,bt(crs)=6.0,bt(dir)=3.0,bt(dir)=3.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1660,"!קֶטַע","n","03296757","y","melingo","1","rav-milim",NULL,"tg1",NULL,"section, part",NULL,NULL,"assigned","#ASSIGN:51.0=[gnd=3.0,bt(dir)=3.0,bt(dir)=21.0,bt(crs)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1661,"!קֶטַע","n","06686223","y","melingo","2","rav-milim",NULL,"tg1",NULL,"segment",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1662,"!קֶטַע","n","03296757","y","melingo","2","rav-milim",NULL,"tg1",NULL,"segment",NULL,NULL,"assigned","#ASSIGN:68.0=[gnd=2.0E+01,bt(dir)=3.0,bt(dir)=21.0,bt(crs)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1663,"קֶלַע","n","02403444","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"slingshot, sling, catapult",NULL,NULL,"checked","#ASSIGN:94.0=[gnd=39.0,gnd=13.0,gnd=13.0,si=29.0] #MZ@\r\n#IE","eyal-10 Feb 2005, assign-6 Nov 2003",94446,"2005-02-10");
INSERT INTO hebrew_synonyms VALUES (1664,"קֶצֶב","n","03948875","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"pace",NULL,"הוא עובד בקצב מאד מהיר; האירועים התקדמו בקצב מסחרר","checked","#ASSIGN:50=[gnd=7.0,bt(dir)=8.0,bt(dir)=11.0,bt(crs)=19.0,dfl=5.0] #MZ@\r\n#IE","eyal-13 Feb 2005, assign-6 Nov 2003",94480,"2005-02-13");
INSERT INTO hebrew_synonyms VALUES (1665,"קֶצֶב","n","10978422","yy","melingo","1.1","rav-milim","1.6","tg1",NULL,"pace",NULL,NULL,"checked","#ASSIGN:28.0=[gnd=2.0E+01,bt(dir)=8.0] #MZ@\r\n#IE","eyal-13 Feb 2005, assign-6 Nov 2003",94480,"2005-02-13");
INSERT INTO hebrew_synonyms VALUES (1666,"קֶצֶב","n","10964831","yy","melingo","1.2","rav-milim","1.3","tg1","((music))","tempo",NULL,NULL,"checked","#ASSIGN:69.0=[gnd=2.0E+01,flc(dic)=49.0] #MZ@\r\n#IE","eyal-13 Feb 2005, assign-6 Nov 2003",94480,"2005-02-13");
INSERT INTO hebrew_synonyms VALUES (1667,"!קֶצֶר","n","05523281","y","melingo","1","rav-milim",NULL,"tg1","((electricity))","short_circuit",NULL,NULL,"assigned","#ASSIGN:57.0=[gnd=2.0E+01,flc(dic)=24.0,bt(dir)=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1668,"קֶצֶר","n","03326923","yy","melingo","1.1","rav-milim","1.1","tg1","((electricity))","short_circuit",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,flc(dic)=24.0] #MZ@\r\n#IE","eyal-13 Feb 2005, assign-6 Nov 2003",94474,"2005-02-13");
INSERT INTO hebrew_synonyms VALUES (1669,"!קֶרִי","n","04449561","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"wet_dream",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE קרי refers to the semen ejaculated, and not to the dream","eyal-13 Feb 2005, assign-6 Nov 2003",0,"2005-02-13");
INSERT INTO hebrew_synonyms VALUES (1670,"!קֶרֶב","n","06333215","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"interior, inside",NULL,NULL,"checked","#ASSIGN:73.0=[gnd=2.0E+01,gnd=2.0E+01,si=33.0] #MZ@\r\n#NO","ordan-30 Jan 2005, assign-6 Nov 2003",0,"2005-01-30");
INSERT INTO hebrew_synonyms VALUES (1671,"קֶרֶב","n","06333091","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"interior, inside",NULL,NULL,"revised","#ASSIGN:73.0=[gnd=2.0E+01,gnd=2.0E+01,si=33.0] #MZ@\r\n#NO","eyal-01 Feb 2005, ordan-30 Jan 2005, assign-6 Nov 2003",94326,"2005-02-01");
INSERT INTO hebrew_synonyms VALUES (1672,"!קֶרֶב","n","06061034","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"interior, inside",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-30 Jan 2005, assign-6 Nov 2003",0,"2005-01-30");
INSERT INTO hebrew_synonyms VALUES (1673,"!קֶרֶן","n","00869291","y","melingo","1","rav-milim",NULL,"tg1",NULL,"horn, antler",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1674,"קֶרֶן","n","00089520","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"free_kick",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,flc(dic)=49.0] #MZ@\r\n#NO","ordan-10 Feb 2005, assign-6 Nov 2003",94449,"2005-02-10");
INSERT INTO hebrew_synonyms VALUES (1675,"קֶרֶן","n","02722608","yy","melingo","2.1","rav-milim","2.1","tg1","((music))","French_horn, horn",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,flc(dic)=49.0] #MZ@\r\n#IE","eyal-10 Feb 2005, assign-6 Nov 2003",94449,"2005-02-10");
INSERT INTO hebrew_synonyms VALUES (8174,"קֶרֶן-צָרְפָתִית","n","02722608","yy","melingo","1.1","rav-milim","1.1",NULL,"music","French_horn",NULL,NULL,"checked","#IE","eyal-10 Feb 2005",94450,"2005-02-10");
INSERT INTO hebrew_synonyms VALUES (1677,"!קֶרֶן","n","02502829","u","melingo","2","rav-milim",NULL,"tg1","((music))","horn",NULL,NULL,"checked","#ASSIGN:28.0=[gnd=4.0,flc(dic)=24.0] #MZ@\r\n#IE","eyal-10 Feb 2005, assign-6 Nov 2003",0,"2005-02-10");
INSERT INTO hebrew_synonyms VALUES (1678,"!קֶרֶן","n","09625793","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"fund",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#IE","eyal-10 Feb 2005, assign-6 Nov 2003",0,"2005-02-10");
INSERT INTO hebrew_synonyms VALUES (1679,"קֶרֶן","n","09618851","yy","melingo","3.1","rav-milim","3.1","tg1",NULL,"fund",NULL,"לאחרונה הוקמו כמה קרנות לסיוע לנפגעי הצונאמי","checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#IE","eyal-10 Feb 2005, assign-6 Nov 2003",94449,"2005-02-10");
INSERT INTO hebrew_synonyms VALUES (1680,"!קֶרֶן","n","06015810","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"fund",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#IE","eyal-10 Feb 2005, assign-6 Nov 2003",0,"2005-02-10");
INSERT INTO hebrew_synonyms VALUES (1681,"קֶרֶן","n","07777807","yy","melingo","4.1","rav-milim","4.1","tg1",NULL,"ray, beam",NULL,NULL,"checked","#ASSIGN:50=[gnd=7.0,gnd=7.0,si=9.0,bt(dir)=8.0,bt(dir)=8.0,dfl=11.0] #MZ@\r\n#IE","eyal-10 Feb 2005, assign-6 Nov 2003",94449,"2005-02-10");
INSERT INTO hebrew_synonyms VALUES (1682,"!קֶשֶׁר","n","06942405","y","melingo","4","rav-milim",NULL,"tg1",NULL,"communicator, two-way_radio",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1683,"קַבָּלָה","n","04894307","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"receipt",NULL,"עליך לבקש קבלה על כל רכישה שאתה מבצע","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-06 Feb 2005, assign-6 Nov 2003",94416,"2005-02-06");
INSERT INTO hebrew_synonyms VALUES (1685,"קַבָּלָה","n","00055481","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"receiving",NULL,"קבלת התואר מותנית בקבלת ציון עובר במבחן המסכם","checked","#ASSIGN:63.0=[gnd=39.0,bt(dir)=24.0] #MZ@\r\n#IE","eyal-06 Feb 2005, assign-6 Nov 2003",94416,"2005-02-06");
INSERT INTO hebrew_synonyms VALUES (1686,"!קַבָּלָה","n","04974979","u","melingo","4","rav-milim",NULL,"tg1",NULL,"welcoming",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-06 Feb 2005, assign-6 Nov 2003",0,"2005-02-06");
INSERT INTO hebrew_synonyms VALUES (1687,"קַבָּלָה","n","03218660","yy","melingo","1.5","rav-milim","1.6","tg1",NULL,"reception_desk",NULL,"תוכלו לקבל מפתח לחדר בקבלה ","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-06 Feb 2005, assign-6 Nov 2003",94416,"2005-02-06");
INSERT INTO hebrew_synonyms VALUES (1688,"!קַבָּלָה","n","05004203","y","melingo","2","rav-milim",NULL,"tg1",NULL,"Kabbala, Jewish_mysticism",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1689,"!קַל","a","00715355","u","melingo","2","rav-milim",NULL,"tg1",NULL,"simple, easy, uncomplicated",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=3.0,gnd=2.0E+01,si=3.0] #MZ@\r\n#IE fits better to ''easy'' a#00714553","eyal-06 Feb 2005, assign-6 Nov 2003",0,"2005-02-06");
INSERT INTO hebrew_synonyms VALUES (1690,"קַל","a","01142598","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"soft, gentle",NULL,"רוח קלה דגדגה את עורפי","checked","#ASSIGN:50=[gnd=4.0,gnd=6.0,si=6.0,bt(dir)=3.0,bt(dir)=3.0,dfl=28.0] #MZ@\r\n#IE","eyal-02 Feb 2005, assign-6 Nov 2003",94381,"2005-02-02");
INSERT INTO hebrew_synonyms VALUES (1691,"!קַלָּע","n","07396733","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"marksman",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE gender","eyal-24 Feb 2005, assign-6 Nov 2003",0,"2005-02-24");
INSERT INTO hebrew_synonyms VALUES (1692,"!קַשָּׁר","n","07575603","n","melingo","1","rav-milim",NULL,"tg1","((military, sports))","signaler",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE gender","eyal-20 Oct 2005, assign-6 Nov 2003",0,"2005-10-20");
INSERT INTO hebrew_synonyms VALUES (1693,"!קָהָל","n","06079949","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"public",NULL,NULL,"checked","#ASSIGN:41.0=[gnd=2.0E+01,bt(dir)=21.0] #MZ@\r\n#NO","ordan-28 Dec 2004, assign-6 Nov 2003",0,"2004-12-28");
INSERT INTO hebrew_synonyms VALUES (1694,"קָהָל","n","05972960","yy","melingo","1.2","none",NULL,"tg1",NULL,"public",NULL,"קהל יעד; קהל קוראי ספרות הפנטזיה מורכב בעיקר מצעירים","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO it\'s close to RM 1.2, but not the same","ordan-28 Dec 2004, assign-6 Nov 2003",93991,"2004-12-28");
INSERT INTO hebrew_synonyms VALUES (1695,"!קָהָל","n","06212767","nn","melingo","3","rav-milim",NULL,"tg1",NULL,"clientele",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-14 Feb 2005, assign-6 Nov 2003",0,"2005-02-14");
INSERT INTO hebrew_synonyms VALUES (1697,"קָטַע","v","00855839","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"amputate",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE in Hebrew, not necessarily the surgical procedure","eyal-27 Jul 2004, assign-6 Nov 2003",91224,"2004-07-27");
INSERT INTO hebrew_synonyms VALUES (1698,"קָטָן","a","01589390","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"small, little",NULL,"היא נהנית לשחק עם אחותה הקטנה","checked","#ASSIGN:33.0=[gnd=3.0,gnd=4.0,si=5.0,bt(dir)=4.0,bt(dir)=3.0,bt(crs)=7.0,bt(dir)=4.0,bt(dir)=3.0] #MZ@\r\n#IE","eyal-02 Feb 2005, assign-6 Nov 2003",94370,"2005-02-02");
INSERT INTO hebrew_synonyms VALUES (1699,"קָטָן","a","01413178","yy","melingo","1.3","rav-milim","1.4","tg1",NULL,"insignificant",NULL,"הוא סתם פקיד קטן, אין לו שום השפעה","checked","#ASSIGN:33.0=[gnd=3.0,gnd=4.0,si=5.0,bt(dir)=4.0,bt(dir)=3.0,bt(crs)=7.0,bt(dir)=4.0,bt(dir)=3.0] #MZ@\r\n#IE","eyal-02 Feb 2005, assign-6 Nov 2003",94370,"2005-02-02");
INSERT INTO hebrew_synonyms VALUES (1700,"!קָטָן","a","01406876","u","melingo","1","rav-milim",NULL,"tg1",NULL,"small, little",NULL,NULL,"checked","#ASSIGN:33.0=[gnd=3.0,gnd=4.0,si=5.0,bt(dir)=4.0,bt(dir)=3.0,bt(crs)=7.0,bt(dir)=4.0,bt(dir)=3.0] #MZ@\r\n#IE in Hebrew we have אות קטנה as a noun, but we don\'t have a specific adjective for lowercase","eyal-02 Feb 2005, assign-6 Nov 2003",0,"2005-02-02");
INSERT INTO hebrew_synonyms VALUES (1701,"!קָטָן","a","01396363","y","melingo","1","rav-milim",NULL,"tg1",NULL,"small, little",NULL,NULL,"assigned","#ASSIGN:33.0=[gnd=3.0,gnd=4.0,si=5.0,bt(dir)=4.0,bt(dir)=3.0,bt(crs)=7.0,bt(dir)=4.0,bt(dir)=3.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1702,"!קָטָן","a","01065122","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"small, little",NULL,NULL,"checked","#ASSIGN:33.0=[gnd=3.0,gnd=4.0,si=5.0,bt(dir)=4.0,bt(dir)=3.0,bt(crs)=7.0,bt(dir)=4.0,bt(dir)=3.0] #MZ@\r\n#IE","eyal-02 Feb 2005, assign-6 Nov 2003",0,"2005-02-02");
INSERT INTO hebrew_synonyms VALUES (1703,"!קָטָן","a","00282562","u","melingo","1","rav-milim",NULL,"tg1",NULL,"small, little",NULL,NULL,"checked","#ASSIGN:33.0=[gnd=3.0,gnd=4.0,si=5.0,bt(dir)=4.0,bt(dir)=3.0,bt(crs)=7.0,bt(dir)=4.0,bt(dir)=3.0] #MZ@\r\n#IE","eyal-02 Feb 2005, assign-6 Nov 2003",0,"2005-02-02");
INSERT INTO hebrew_synonyms VALUES (1704,"קָטָן","a","01336443","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"small, little",NULL,"שולחן האוכל שלי קטן ולא יכיל את כל האורחים","checked","#ASSIGN:36.0=[gnd=3.0,gnd=4.0,si=5.0,bt(dir)=4.0,bt(dir)=4.0,bt(crs)=8.0,bt(dir)=4.0,bt(dir)=4.0] #MZ@\r\n#IE","eyal-02 Feb 2005, assign-6 Nov 2003",94370,"2005-02-02");
INSERT INTO hebrew_synonyms VALUES (1705,"!קָטָן","a","01337063","u","melingo","4","rav-milim",NULL,"tg1",NULL,"diminutive",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-02 Feb 2005, assign-6 Nov 2003",0,"2005-02-02");
INSERT INTO hebrew_synonyms VALUES (1706,"קָטָן","n","07643338","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"toddler",NULL,"תחליף בבקשה לקטנה את החיתול","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-02 Feb 2005, assign-6 Nov 2003",94361,"2005-02-02");
INSERT INTO hebrew_synonyms VALUES (1707,"קָלַע","v","01149581","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"braid, plait",NULL,"בשיעור מלאכה קלענו כמה סלי נצרים","checked","#ASSIGN:57.0=[gnd=13.0,gnd=2.0E+01,si=24.0] #MZ@\r\n#IE","eyal-20 Feb 2005, assign-6 Nov 2003",94565,"2005-02-20");
INSERT INTO hebrew_synonyms VALUES (1708,"!קָצִין","n","07485319","nn","melingo","1","rav-milim",NULL,"tg1","((military, police))","officer",NULL,NULL,"checked","#ASSIGN:57.0=[gnd=1.0E+01,flc(dic)=24.0,flc(dic)=12.0,bt(dir)=11.0] #MZ@\r\n#IE","eyal-25 Feb 2005, assign-6 Nov 2003",0,"2005-02-25");
INSERT INTO hebrew_synonyms VALUES (1709,"!קָצִין","n","07409838","nn","melingo","1","rav-milim",NULL,"tg1","((military, police))","officer",NULL,NULL,"checked","#ASSIGN:57.0=[gnd=1.0E+01,flc(dic)=24.0,flc(dic)=12.0,bt(dir)=11.0] #MZ@\r\n#IE gender","eyal-21 Feb 2005, assign-6 Nov 2003",0,"2005-02-21");
INSERT INTO hebrew_synonyms VALUES (1710,"!קָצִין","n","07451223","y","melingo","2","rav-milim",NULL,"tg1","((biblical))","leader, ruler, overseer",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1711,"!קָצַב","v","00490839","u","melingo","1","rav-milim",NULL,"tg1",NULL,"allot, budget",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE see הקציב","eyal-20 May 2004, assign-6 Nov 2003",0,"2004-05-20");
INSERT INTO hebrew_synonyms VALUES (1712,"קָצַר","v","00901473","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"harvest",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-20 Feb 2005, assign-6 Nov 2003",94562,"2005-02-20");
INSERT INTO hebrew_synonyms VALUES (1713,"!קָצָר","a","01384633","y","melingo","2","rav-milim",NULL,"tg1",NULL,"brief",NULL,NULL,"assigned","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1714,"!קָצָר","a","01379438","u","melingo","2","rav-milim",NULL,"tg1",NULL,"brief",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE Hebrew does not have a specific adjective for short clothings","eyal-02 Feb 2005, assign-6 Nov 2003",0,"2005-02-02");
INSERT INTO hebrew_synonyms VALUES (1715,"!קָצָר","a","00512552","y","melingo","2","rav-milim",NULL,"tg1",NULL,"brief",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1716,"קָרַב","v","01404337","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"approach, near, draw_near, come_near",NULL,NULL,"checked","#ASSIGN:61.0=[gnd=8.0,gnd=39.0,si=14.0] #MZ@\r\n#NO","ordan-16 Feb 2004",91225,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (1717,"!קָרָא","v","00537255","y","melingo","2","rav-milim",NULL,"tg1",NULL,"call_out_to, summons",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1718,"!קָרוֹב","a","01064552","y","melingo","1","rav-milim",NULL,"tg1",NULL,"close, nearby, near",NULL,NULL,"assigned","#ASSIGN:41.0=[gnd=3.0,gnd=6.0,si=5.0,bt(dir)=3.0,bt(dir)=6.0,bt(crs)=9.0,bt(dir)=3.0,bt(dir)=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1719,"קָרוֹב","a","00412848","yy","melingo","1.1","sapir","1.1+1.2","tg1",NULL,"close, near",NULL,"המסעדה קרובה מאד לפה, כדאי שנלך ברגל; היא כבר קרובה מאד לדמעות","checked","#ASSIGN:5.0E+01=[gnd=3.0,gnd=6.0,si=5.0,bt(dir)=9.0,bt(dir)=3.0,bt(crs)=12.0,bt(dir)=9.0,bt(dir)=3.0] #MZ@\r\n#IE","eyal-02 Feb 2005, assign-6 Nov 2003",94373,"2005-02-02");
INSERT INTO hebrew_synonyms VALUES (1720,"!קָרוֹב","a","00413658","u","melingo","1","rav-milim",NULL,"tg1",NULL,"close, nearby, near",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO am not sure what\'s the difference between \'near\' and \'nearby\' in Heb; this word however seems a better match to \'near\'","ordan-04 Aug 2004, assign-6 Nov 2003",0,"2004-08-04");
INSERT INTO hebrew_synonyms VALUES (1721,"קָרוֹב","r","00403897","yy","melingo","1.1","rav-milim","1.1+2","tg1",NULL,"close_to, near",NULL,"הוא עמד קרוב לדלת והאזין למה שהתרחש מעברה השני; הסוף כבר קרוב","checked","#ASSIGN:101.0=[gnd=13.0,bt(dir)=21.0,bt(dir)=23.0,bt(crs)=44.0] #MZ@\r\n#IE","eyal-02 Feb 2005, assign-6 Nov 2003",94372,"2005-02-02");
INSERT INTO hebrew_synonyms VALUES (1722,"!קָרוֹב","r","00070549","u","melingo","1","rav-milim",NULL,"tg1",NULL,"close_to, near",NULL,NULL,"checked","#ASSIGN:25.0=[gnd=13.0,bt(dir)=12.0] #MZ@\r\n#IE does not corrdespond with the gloss in WN","eyal-26 Jul 2004",0,"2004-07-26");
INSERT INTO hebrew_synonyms VALUES (6637,"כְּ","r","00006065","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-19 Apr 2004",91226,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (6636,"לְעֵרֶךְ","r","00006065","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-19 Apr 2004",91227,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (1727,"!קָשֶׁה","a","00797776","y","melingo","2","rav-milim",NULL,"tg1",NULL,"difficult",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1728,"קָשֶׁה","a","00710342","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"difficult",NULL,"זוהי משימה קשה במיוחד; האם זה כה קשה עבורך לשמור סוד?","checked","#ASSIGN:86.0=[gnd=2.0E+01,bt(dir)=29.0,bt(dir)=4.0,bt(crs)=33.0] #MZ@\r\n#IE","eyal-02 Feb 2005, assign-6 Nov 2003",94380,"2005-02-02");
INSERT INTO hebrew_synonyms VALUES (1729,"קָשֶׁה","a","01248007","yy","melingo","1.3","rav-milim","1.6","tg1",NULL,"strict, severe",NULL,"היא אישה מאד קשה, מפליא אותי שבעלה לא עזב אותה עד עכשיו","checked","#ASSIGN:50=[gnd=7.0,gnd=7.0,si=9.0,dfl=27.0] #MZ@\r\n#IE","eyal-06 Feb 2005, assign-6 Nov 2003",94380,"2005-02-06");
INSERT INTO hebrew_synonyms VALUES (1730,"קָשׁוּר","a","00251073","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"tied, fastened",NULL,"הצרור היה קשור היטב","checked","#ASSIGN:50=[gnd=8.0,gnd=1.0E+01,si=12.0,dfl=2.0E+01] #MZ@\r\n#IE","eyal-01 Feb 2005, assign-6 Nov 2003",94360,"2005-02-01");
INSERT INTO hebrew_synonyms VALUES (1731,"קֹדֶם","r","00058575","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"previously",NULL,"ההצעה זו טובה מכל אלה שהוצעו קודם","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO\r\n#NO","ordan-04 Aug 2004",91228,"2004-08-04");
INSERT INTO hebrew_synonyms VALUES (1732,"!קֹדֶם","r","00099935","u","melingo","2","rav-milim",NULL,"tg1",NULL,"first, initially",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-15 Feb 2005, assign-6 Nov 2003",0,"2005-02-15");
INSERT INTO hebrew_synonyms VALUES (1733,"קוֹדֵם","a","01666340","yy","melingo","1.1","rav-milim","1.1c","tg1",NULL,"previous",NULL,"המרצה הקודם היה מוצלח הרבה יותר","checked","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@\r\n#IE","eyal-18 Nov 2004, assign-6 Nov 2003",93719,"2004-11-18");
INSERT INTO hebrew_synonyms VALUES (1734,"!קוֹדֵם","a","00775727","y","melingo","1","rav-milim",NULL,"tg1",NULL,"preceding, previous, last",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1735,"קוֹדֵם","a","00129370","yy","melingo","1.1","rav-milim","1.1a+b","tg1",NULL,"previous",NULL,"הבית הקודם שלי היה הרבה יותר גדול","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-18 Nov 2004, assign-6 Nov 2003",93719,"2004-11-18");
INSERT INTO hebrew_synonyms VALUES (1736,"קוֹדֵם","n","07494167","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"predecessor",NULL,"קודמי בתפקיד השאיר לי משרד מסודר להפליא","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-18 Nov 2004, assign-6 Nov 2003",93715,"2004-11-18");
INSERT INTO hebrew_synonyms VALUES (1737,"!קוֹלְנוֹעַ","n","00582602","u","melingo","2","rav-milim",NULL,"tg1",NULL,"cinematography, film-making",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-09 Feb 2005, assign-6 Nov 2003",0,"2005-02-09");
INSERT INTO hebrew_synonyms VALUES (1738,"רְאִי","n","04447957","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"mirror",NULL,"העיניים הן ראי הנפש","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-13 Feb 2005, assign-6 Nov 2003",94503,"2005-02-13");
INSERT INTO hebrew_synonyms VALUES (1739,"רְאִי","n","03004534","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"mirror",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-13 Feb 2005, assign-6 Nov 2003",94503,"2005-02-13");
INSERT INTO hebrew_synonyms VALUES (8201,"מַרְאָה","n","03004534","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"mirror",NULL,NULL,"checked","#NO","ordan-13 Feb 2005",94504,"2005-02-13");
INSERT INTO hebrew_synonyms VALUES (1742,"!רְכִישָׁה","n","00051225","y","melingo","1","rav-milim",NULL,"tg1",NULL,"purchase, acquisition, procurement",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1743,"רְפוּאִי","a","02585051","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"medical",NULL,"טיפול רפואי","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-13 Feb 2005, assign-6 Nov 2003",94496,"2005-02-13");
INSERT INTO hebrew_synonyms VALUES (1744,"!רְפוּאִי","a","02475324","y","melingo","1","rav-milim",NULL,"tg1",NULL,"medical",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1745,"!רְפוּאִי","a","01120947","y","melingo","1","rav-milim",NULL,"tg1",NULL,"medical",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1746,"רְשׁוּת","n","05015182","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"permission",NULL,"הוא ביקש את רשותי לעזוב את החדר","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-23 Feb 2005, assign-6 Nov 2003",94608,"2005-02-23");
INSERT INTO hebrew_synonyms VALUES (1747,"רְשׁוּת","n","00738404","yy","melingo","1.1","rav-milim","1.3","tg1",NULL,"permission",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-23 Feb 2005, assign-6 Nov 2003",94608,"2005-02-23");
INSERT INTO hebrew_synonyms VALUES (1748,"!רִאשׁוֹן","a","00775042","y","melingo","1","rav-milim",NULL,"tg1",NULL,"earliest",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1749,"רִאשׁוֹן","n","02688619","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"first_gear, first",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=39.0,bt(dir)=5.0] #MZ@\r\n#NO","ordan-21 Feb 2005, assign-6 Nov 2003",0,"2005-02-21");
INSERT INTO hebrew_synonyms VALUES (1750,"רִשְׁמִי","a","00991360","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"ceremonial",NULL,"זהו מעמד רשמי, אנא נהג בהתאם","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-09 Jun 2004, assign-6 Nov 2003",91229,"2004-06-09");
INSERT INTO hebrew_synonyms VALUES (8280,"עִקָּר","n","03991218","yy","none",NULL,"none",NULL,NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-23 Feb 2005",94614,"2005-02-23");
INSERT INTO hebrew_synonyms VALUES (1752,"!רֶגֶל","n","05307231","y","melingo","4","rav-milim",NULL,"tg1","((prosody))","meter",NULL,NULL,"assigned","#ASSIGN:34.0=[gnd=1.0E+01,flc(dic)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1753,"!רֶגַע","n","10953688","y","melingo","1","rav-milim",NULL,"tg1",NULL,"moment",NULL,NULL,"assigned","#ASSIGN:35.0=[gnd=7.0,bt(dir)=7.0,bt(dir)=7.0,bt(crs)=14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1754,"!רֶגַע","n","10952516","y","melingo","1","rav-milim",NULL,"tg1",NULL,"moment",NULL,NULL,"assigned","#ASSIGN:33.0=[gnd=7.0,bt(dir)=7.0,bt(dir)=6.0,bt(crs)=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1755,"!רֶוַח","n","09540718","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"profit",NULL,NULL,"checked","#ASSIGN:35.0=[gnd=2.0E+01,bt(dir)=15.0] #MZ@\r\n#NO","ordan-13 Jul 2004, assign-6 Nov 2003",0,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (1756,"רֶוַח","n","04017901","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"profit",NULL,NULL,"checked","#ASSIGN:78.0=[gnd=2.0E+01,bt(dir)=19.0,bt(dir)=1.0E+01,bt(crs)=29.0] #MZ@\r\n#NO","ordan-13 Jul 2004, assign-6 Nov 2003",91230,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (6956,"טוֹבַת-הֲנָאָה","n","04017901","yy","none",NULL,"rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO according to RM, it is sometimes used negatively (think about the plitical context), but I think that at times it may be used neutrally. ","ordan-13 Jul 2004",91231,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (1758,"!רֶכֶב","n","02383458","u","melingo","1","rav-milim",NULL,"tg1",NULL,"vehicle, car",NULL,NULL,"checked","#ASSIGN:50=[gnd=8.0,bt(dir)=39.0,dfl=3.0] #MZ@\r\n#IE according to RM, רכב fits better to ''vehicle''","eyal-26 Sep 2004, assign-6 Nov 2003",0,"2004-09-26");
INSERT INTO hebrew_synonyms VALUES (1759,"!רֶכֶשׁ","n","00049855","u","melingo","1","rav-milim",NULL,"tg1",NULL,"purchasing, acquisitions",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE רכש has a slightly different meaning than this sense of קנייה","eyal-08 Feb 2005, assign-6 Nov 2003",0,"2005-02-08");
INSERT INTO hebrew_synonyms VALUES (1760,"!רֶפּוּבְּלִיקָאִי","n","07529555","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"republican",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-22 Feb 2005, assign-6 Nov 2003",0,"2005-02-22");
INSERT INTO hebrew_synonyms VALUES (8200,"בִּיזוֹן","n","01907269","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"bison",NULL,NULL,"checked","#NO","ordan-13 Feb 2005",94499,"2005-02-13");
INSERT INTO hebrew_synonyms VALUES (1762,"!רֶשֶׁת","n","03038207","y","melingo","1","rav-milim",NULL,"tg1",NULL,"net",NULL,NULL,"assigned","#ASSIGN:50=[gnd=7.0,bt(dir)=13.0,bt(dir)=6.0,bt(crs)=19.0,dfl=5.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1763,"!רֶשֶׁת","n","03038207","y","melingo","2","rav-milim",NULL,"tg1",NULL,"screen, netting, mesh",NULL,NULL,"assigned","#ASSIGN:50=[gnd=8.0,bt(dir)=13.0,bt(dir)=6.0,bt(crs)=19.0,dfl=4.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1764,"רֶשֶׁת","n","06239044","yy","melingo","1.3","rav-milim","1.5","tg1",NULL,"network, web",NULL,"רשת ריגול","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-18 Feb 2005, assign-6 Nov 2003",94552,"2005-02-18");
INSERT INTO hebrew_synonyms VALUES (1765,"רֶשֶׁת","n","03038461","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"network",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#NO","ordan-18 Feb 2005, assign-6 Nov 2003",94552,"2005-02-18");
INSERT INTO hebrew_synonyms VALUES (1766,"!רֶשֶׁת","n","03038207","y","melingo","3","rav-milim",NULL,"tg1",NULL,"network",NULL,NULL,"assigned","#ASSIGN:51.0=[gnd=13.0,bt(dir)=13.0,bt(dir)=6.0,bt(crs)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1767,"!רֶשֶׁת","n","02864326","nn","melingo","4","rav-milim",NULL,"tg1",NULL,"Internet",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO maybe הרשת","ordan-18 Feb 2005, assign-6 Nov 2003",0,"2005-02-18");
INSERT INTO hebrew_synonyms VALUES (1768,"רַב","a","01333157","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"vast",NULL,"הון רב","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-26 Dec 2004, assign-6 Nov 2003",93962,"2004-12-26");
INSERT INTO hebrew_synonyms VALUES (1769,"!רַב","a","01490743","y","melingo","1","rav-milim",NULL,"tg1",NULL,"much, great, vast",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1770,"!רַב","n","07517306","y","melingo","1","rav-milim",NULL,"tg1",NULL,"rabbi",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1771,"רַכָּב","n","07163025","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"coachman",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-17 Dec 2004, eyal-08 Dec 2004, assign-6 Nov 2003",93856,"2004-12-17");
INSERT INTO hebrew_synonyms VALUES (1772,"!רָאשִׁי","a","01450092","y","melingo","1","rav-milim",NULL,"tg1",NULL,"main",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1773,"רָאשִׁי","a","01225152","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,NULL,NULL,"עורק תחבורה ראשי","checked","#ASSIGN:83.0=[gnd=13.0,bt(dir)=21.0,bt(dir)=14.0,bt(crs)=35.0] #MZ@\r\n#NO","ordan-26 Dec 2004, assign-6 Nov 2003",93955,"2004-12-26");
INSERT INTO hebrew_synonyms VALUES (7896,"מֶלֶט","n","10731399","yy","oxford","1.1","rav-milim","1.1",NULL,NULL,"mortar",NULL,NULL,"checked","#IE refers to the second part of RM\'s definition","eyal-26 Dec 2004",93958,"2004-12-26");
INSERT INTO hebrew_synonyms VALUES (1776,"!רָאשִׁי","a","01224413","y","melingo","2","rav-milim",NULL,"tg1",NULL,"head, chief",NULL,NULL,"assigned","#ASSIGN:169.0=[gnd=2.0E+01,gnd=2.0E+01,si=33.0,bt(dir)=21.0,bt(dir)=11.0,bt(crs)=32.0,bt(dir)=21.0,bt(dir)=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1777,"!רָאשִׁי","a","01450092","y","melingo","1","rav-milim",NULL,"tg1",NULL,"main",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (7892,"מַמָּשִׁיּוּת","n","03738112","yy","none",NULL,"rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#IE","eyal-26 Dec 2004",93956,"2004-12-26");
INSERT INTO hebrew_synonyms VALUES (1779,"!רָאשִׁי","a","00694273","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"main",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","ordan-26 Dec 2004, assign-6 Nov 2003",0,"2004-12-26");
INSERT INTO hebrew_synonyms VALUES (7893,"GAP!","n","10851379","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE","eyal-26 Dec 2004",90808,"2004-12-26");
INSERT INTO hebrew_synonyms VALUES (1781,"!רָאשִׁי","a","01224413","y","melingo","2","rav-milim",NULL,"tg1",NULL,"head, chief",NULL,NULL,"assigned","#ASSIGN:169.0=[gnd=2.0E+01,gnd=2.0E+01,si=33.0,bt(dir)=21.0,bt(dir)=11.0,bt(crs)=32.0,bt(dir)=21.0,bt(dir)=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1782,"!רָגִיל","a","00921474","y","melingo","1","rav-milim",NULL,"tg1",NULL,"regular, usual, normal",NULL,NULL,"assigned","#ASSIGN:41.0=[gnd=2.0E+01,bt(dir)=21.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1783,"רָגִיל","a","00456499","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"usual",NULL,"הוא הגיע בשעה הרגילה; טמפרטורות רגילות לעונה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-21 Feb 2005, assign-6 Nov 2003",94568,"2005-02-21");
INSERT INTO hebrew_synonyms VALUES (1784,"רָגִיל","a","00025790","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"used_to",NULL,"הוא רגיל לעצור טרמפים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-21 Feb 2005, assign-6 Nov 2003",94568,"2005-02-21");
INSERT INTO hebrew_synonyms VALUES (1785,"!רָחַב","v","00377885","y","melingo","1","rav-milim",NULL,"tg1",NULL,"broaden, widen, spread_out",NULL,NULL,"assigned","#ASSIGN:50=[gnd=1.0E+01,gnd=1.0E+01,si=7.0,dfl=23.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1786,"!רָחָב","a","01330877","y","melingo","1","rav-milim",NULL,"tg1",NULL,"broad, wide",NULL,NULL,"assigned","#ASSIGN:48.0=[gnd=5.0,gnd=5.0,si=8.0,bt(dir)=5.0,bt(dir)=5.0,bt(crs)=1.0E+01,bt(dir)=5.0,bt(dir)=5.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1787,"!רָחָב","a","00492805","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"broad, wide",NULL,NULL,"checked","#ASSIGN:51.0=[gnd=5.0,gnd=5.0,si=8.0,bt(dir)=6.0,bt(dir)=5.0,bt(crs)=11.0,bt(dir)=6.0,bt(dir)=5.0] #MZ@\r\n#NO","ordan-21 Feb 2005, assign-6 Nov 2003",0,"2005-02-21");
INSERT INTO hebrew_synonyms VALUES (1788,"רָחָב","a","02436517","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"broad, wide",NULL,"כביש עם שוליים רחבים","checked","#ASSIGN:57.0=[gnd=5.0,gnd=5.0,si=8.0,bt(dir)=7.0,bt(dir)=6.0,bt(crs)=13.0,bt(dir)=7.0,bt(dir)=6.0] #MZ@\r\n#NO","ordan-21 Feb 2005, assign-6 Nov 2003",94576,"2005-02-21");
INSERT INTO hebrew_synonyms VALUES (1789,"!רָחוֹק","a","00411449","y","melingo","1","rav-milim",NULL,"tg1",NULL,"distant, far, faraway, remote",NULL,NULL,"assigned","#ASSIGN:43.0=[gnd=8.0,gnd=8.0,si=7.0,bt(dir)=1.0E+01,bt(dir)=1.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1790,"!רָחוֹק","a","00411239","y","melingo","1","rav-milim",NULL,"tg1",NULL,"distant, far, faraway, remote",NULL,NULL,"assigned","#ASSIGN:43.0=[gnd=8.0,gnd=8.0,si=7.0,bt(dir)=1.0E+01,bt(dir)=1.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1791,"!רָכַשׁ","v","01511279","y","melingo","1","rav-milim",NULL,"tg1",NULL,"buy, purchase",NULL,NULL,"assigned","#ASSIGN:165.0=[gnd=8.0,gnd=39.0,si=2.0E+01,bt(dir)=49.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1792,"!רָצוֹן","n","04912311","y","melingo","2","rav-milim",NULL,"tg1",NULL,"will, decision",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1793,"!רָצוֹן","n","04589152","y","melingo","2","rav-milim",NULL,"tg1",NULL,"will, decision",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1794,"רָצוֹן","n","04371730","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"will, volition",NULL,"הפער בין הרצון למימושו - הוא הוא מקור הסבל","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-23 Feb 2005, assign-6 Nov 2003",94620,"2005-02-23");
INSERT INTO hebrew_synonyms VALUES (1795,"!רָשׁוּת","n","00388267","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"chairmanship, leadership, presidency",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE wrong spelling","eyal-23 Feb 2005, assign-6 Nov 2003",0,"2005-02-23");
INSERT INTO hebrew_synonyms VALUES (1796,"!רֹאשׁ","n","07311393","y","melingo","1","rav-milim",NULL,"tg1",NULL,"head",NULL,NULL,"assigned","#ASSIGN:50=[gnd=1.0,bt(dir)=24.0,dfl=25.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1797,"!רֹאשׁ","n","07311393","y","melingo","3","rav-milim",NULL,"tg1",NULL,"chief",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1798,"!רֹאשׁ","n","07273905","y","melingo","3","rav-milim",NULL,"tg1",NULL,"chief",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1799,"!רֹאשׁ","n","09392482","y","melingo","1","rav-milim",NULL,"tg1","((biblical))","poisonous_plant",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1800,"רֹב","n","09759719","nn","melingo","1.1","rav-milim","1.1","tg1",NULL,"most",NULL,NULL,"reviewed","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO The closest is הכי, which is another POS","ordan-23 Feb 2005, assign-6 Nov 2003",92808,"2005-02-23");
INSERT INTO hebrew_synonyms VALUES (1801,"!רֹב","n","10873520","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"majority",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#NO","ordan-23 Feb 2005, assign-6 Nov 2003",0,"2005-02-23");
INSERT INTO hebrew_synonyms VALUES (1802,"רֹב","n","09760262","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"majority",NULL,"הרוב העדיף את המפלגה השמרנית","checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#NO","ordan-23 Feb 2005, assign-6 Nov 2003",92808,"2005-02-23");
INSERT INTO hebrew_synonyms VALUES (1803,"רֹב","n","03991218","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"majority, bulk",NULL,"סיימנו את רוב העבודה","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-23 Feb 2005, assign-6 Nov 2003",92808,"2005-02-23");
INSERT INTO hebrew_synonyms VALUES (1804,"!רֹב","n","09921720","y","melingo","3","rav-milim",NULL,"tg1","((biblical))","abundance, much",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1806,"!רֻפָּא","v","00383502","y","melingo","1","rav-milim",NULL,"tg1","((art))","be_restored",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (8265,"GAP!","n","07220340","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-22 Feb 2005",0,"2005-02-22");
INSERT INTO hebrew_synonyms VALUES (8266,"רוֹפֵא","n","H0003701","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-22 Feb 2005",94594,"2005-02-22");
INSERT INTO hebrew_synonyms VALUES (1808,"!רוֹפֵא","n","07220883","y","melingo","1","rav-milim",NULL,"tg1",NULL,"doctor, physician",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1809,"!רוּחַ","n","07780411","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"wind, breeze",NULL,NULL,"checked","#ASSIGN:53.0=[gnd=39.0,bt(dir)=4.0,bt(dir)=3.0,bt(crs)=7.0] #MZ@\r\n#NO","ordan-24 Feb 2005, assign-6 Nov 2003",0,"2005-02-24");
INSERT INTO hebrew_synonyms VALUES (1810,"!שְׁאֵלָה","n","05376578","y","melingo","1","rav-milim",NULL,"tg1",NULL,"question, query",NULL,NULL,"assigned","#ASSIGN:179.0=[gnd=7.0,gnd=39.0,si=16.0,bt(dir)=6.0,bt(dir)=33.0,bt(crs)=39.0,bt(dir)=6.0,bt(dir)=33.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1811,"!שְׁאֵלָה","n","10382904","nn","melingo","3","rav-milim",NULL,"tg1","((literary))","request, wish, boon",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-02 May 2005, assign-6 Nov 2003",0,"2005-05-02");
INSERT INTO hebrew_synonyms VALUES (8493,"GAP!","n","07356184","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE gender","eyal-12 Apr 2005",90808,"2005-04-12");
INSERT INTO hebrew_synonyms VALUES (8494,"שְׁאֵר","n","H0003901","yy","none",NULL,"rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#IE","eyal-12 Apr 2005",94879,"2005-04-12");
INSERT INTO hebrew_synonyms VALUES (1813,"!שְׁאֵר","n","07356184","n","melingo","2","rav-milim",NULL,"tg1","((sociology))","relative, _relation",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,gnd=8.0,si=16.0] #MZ@\r\n#IE gender","eyal-12 Apr 2005, assign-6 Nov 2003",0,"2005-04-12");
INSERT INTO hebrew_synonyms VALUES (1814,"!שְׁכוּנָה","n","09908553","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"neighborhood",NULL,NULL,"checked","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@\r\n#IE","eyal-06 Apr 2005, assign-6 Nov 2003",0,"2005-04-06");
INSERT INTO hebrew_synonyms VALUES (1815,"!שְׁכוּנָה","n","06363890","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"neighborhood",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-24 Nov 2004, assign-6 Nov 2003",0,"2004-11-24");
INSERT INTO hebrew_synonyms VALUES (1816,"שְׁכוּנָה","n","06106024","yy","melingo","1.1","sapir","1.3","tg1",NULL,"neighborhood",NULL,"כל השכונה שלי נרתמה לשפץ את המתנ''ס","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-06 Apr 2005, assign-6 Nov 2003",94838,"2005-04-06");
INSERT INTO hebrew_synonyms VALUES (1817,"!שְׁלַט","n","03228452","nn","melingo","1","rav-milim",NULL,"tg1","((colloquial))","remote_control",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE wrong form","eyal-17 Mar 2005, assign-6 Nov 2003",0,"2005-03-17");
INSERT INTO hebrew_synonyms VALUES (1818,"שִׁדּוּר","n","04967331","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"broadcast",NULL,"שידור התוכנית נקטע באמצע עקב תקלה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE refers to the first part of RM\'s definition","eyal-31 Mar 2005, assign-6 Nov 2003",94810,"2005-03-31");
INSERT INTO hebrew_synonyms VALUES (1819,"שִׁדּוּר","n","04964806","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"broadcast",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE refers to the second part of RM\'s definition","eyal-15 May 2005, eyal-31 Mar 2005, assign-6 Nov 2003",94810,"2005-05-15");
INSERT INTO hebrew_synonyms VALUES (8520,"אָקַצְיָה","n","08067245","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"acacia",NULL,NULL,"checked","#IE","eyal-14 Apr 2005",94899,"2005-04-14");
INSERT INTO hebrew_synonyms VALUES (1821,"שִׁטָּה","v","00577669","yy","melingo","1.1","rav-milim","1.1","tg1","((literary))","make_fun_of, poke_fun_at, ridicule",NULL,"התלמידים שיטו במורה הצעיר והגישו לו דפי מבחן ריקים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-10 May 2005, assign-6 Nov 2003",94950,"2005-05-10");
INSERT INTO hebrew_synonyms VALUES (1822,"שִׁיטָה","n","04376254","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"method",NULL,"אני מכירה שיטה קלה יותר לפתור את התרגיל הזה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-26 Jan 2005, assign-6 Nov 2003",94214,"2005-01-26");
INSERT INTO hebrew_synonyms VALUES (1823,"!שִׁיטָה","n","03858557","y","melingo","1","rav-milim",NULL,"tg1",NULL,"method, way",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1824,"שִׁיר","n","04807372","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"poem",NULL,"מגיל צעיר הוא כתב שירים למגירה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-28 Mar 2005, assign-6 Nov 2003",94803,"2005-03-28");
INSERT INTO hebrew_synonyms VALUES (1825,"שִׁמּוּשׁ","n","00605730","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"use, utilization",NULL,"המדרגות היו שחוקות משנים של שימוש","checked","#ASSIGN:92.0=[gnd=6.0,gnd=39.0,si=14.0,bt(dir)=5.0,bt(dir)=6.0,bt(crs)=11.0,bt(dir)=5.0,bt(dir)=6.0] #MZ@\r\n#IE","eyal-13 Mar 2005, assign-6 Nov 2003",94732,"2005-03-13");
INSERT INTO hebrew_synonyms VALUES (1826,"!שִׁתּוּף","n","00804778","u","melingo","1","rav-milim",NULL,"tg1",NULL,"participation, inclusion",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-15 Mar 2005, assign-6 Nov 2003",0,"2005-03-15");
INSERT INTO hebrew_synonyms VALUES (1827,"!שֵׁם","n","10359826","y","melingo","3","rav-milim",NULL,"tg1",NULL,"reputation",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1828,"!שֵׁם","n","10358851","y","melingo","3","rav-milim",NULL,"tg1",NULL,"reputation",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1829,"שֵׁם","n","04705103","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"reputation",NULL,"שמו יצא כרודף שמלות","checked","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@\r\n#IE","eyal-28 Mar 2005, assign-6 Nov 2003",94800,"2005-03-28");
INSERT INTO hebrew_synonyms VALUES (1830,"!שֵׁמַע","n","10358202","y","melingo","2","rav-milim",NULL,"tg1",NULL,"renown",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1831,"!שֵׁרוּת","n","04015637","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"help, assistance, favor",NULL,NULL,"checked","#ASSIGN:41.0=[gnd=1.0E+01,gnd=2.0E+01,si=11.0] #MZ@\r\n#NO","ordan-27 Dec 2004, assign-6 Nov 2003",0,"2004-12-27");
INSERT INTO hebrew_synonyms VALUES (1832,"!שֵׁרוּת","n","00782440","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"help, assistance, favor",NULL,NULL,"checked","#ASSIGN:41.0=[gnd=1.0E+01,gnd=2.0E+01,si=11.0] #MZ@\r\n#NO","ordan-13 Aug 2004, assign-6 Nov 2003",0,"2004-08-13");
INSERT INTO hebrew_synonyms VALUES (1833,"!שֶׁטַח","n","09535912","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"territory, land, area, plot, lot",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#IE","eyal-27 Dec 2004, assign-6 Nov 2003",0,"2004-12-27");
INSERT INTO hebrew_synonyms VALUES (1834,"!שֶׁטַח","n","06304618","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"territory, land, area, plot, lot",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#IE","eyal-27 Dec 2004, assign-6 Nov 2003",0,"2004-12-27");
INSERT INTO hebrew_synonyms VALUES (1835,"שֶׁטַח","n","04596256","yy","melingo","1.1","rav-milim","1.4","tg1",NULL,"territory",NULL,"לכל אדם יש שטח התעניינות יחודי לו","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-28 Mar 2005, assign-6 Nov 2003",94798,"2005-03-28");
INSERT INTO hebrew_synonyms VALUES (1836,"לוֹט","n","07382352","yy","none",NULL,"none",NULL,"tg1","(Bible)","Lot",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-10 Mar 2004",91232,"2004-03-10");
INSERT INTO hebrew_synonyms VALUES (1837,"!שֶׁלֶט","n","05087726","u","melingo","2","rav-milim",NULL,"tg1",NULL,"placard",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE שלט is too general","eyal-22 Jul 2004, assign-6 Nov 2003",0,"2004-07-22");
INSERT INTO hebrew_synonyms VALUES (1838,"שֶׁקֶל","n","09863808","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"shekel",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-21 Apr 2005, assign-6 Nov 2003",94905,"2005-04-21");
INSERT INTO hebrew_synonyms VALUES (1839,"שַׁבָּת","n","10883605","yy","melingo","1.1","rav-milim","1.3","tg1",NULL,"Sabbath",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-04 May 2005, assign-6 Nov 2003",94933,"2005-05-04");
INSERT INTO hebrew_synonyms VALUES (1840,"שַׁבָּת","n","10883469","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"Saturday",NULL,"בשבת הקרובה אנו מתכננים לטייל בגליל","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-04 May 2005, assign-6 Nov 2003",94933,"2005-05-04");
INSERT INTO hebrew_synonyms VALUES (1841,"!שַׁבָּת","n","10862782","n","melingo","4","rav-milim",NULL,"tg1",NULL,"sabbath, rest_day",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-04 May 2005, assign-6 Nov 2003",0,"2005-05-04");
INSERT INTO hebrew_synonyms VALUES (8540,"שֵׁנִית","r","00099672","yy","melingo","1.2","rav-milim","1.2",NULL,NULL,"secondly",NULL,"אני לא רוצה לאכול. ראשית - אני לא רעבה, ושנית - האוכל לא טעים","checked","#IE","eyal-04 May 2005",94937,"2005-05-04");
INSERT INTO hebrew_synonyms VALUES (1843,"שַׁלָּט","n","03228452","yy","melingo","1.1","rav-milim","1.1","tg1","((colloquial))","remote_control",NULL,"תביא כבר את השלט, אני רוצה להעביר תחנה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-17 Mar 2005, assign-6 Nov 2003",94758,"2005-03-17");
INSERT INTO hebrew_synonyms VALUES (1844,"!שַׁעַר","n","09540625","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"gate",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-16 Mar 2005, assign-6 Nov 2003",0,"2005-03-16");
INSERT INTO hebrew_synonyms VALUES (1845,"!שַׁעַר","n","02747511","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"gate",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-16 Mar 2005, assign-6 Nov 2003",0,"2005-03-16");
INSERT INTO hebrew_synonyms VALUES (1846,"שַׁעַר","n","02747160","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"gate",NULL,"ביקשנו מבעלי הבית שיתקינו שער בכניסה לחצר","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-10 Mar 2005, assign-6 Nov 2003",94714,"2005-03-10");
INSERT INTO hebrew_synonyms VALUES (1847,"שַׁעַר","n","02759209","yy","melingo","1.2","rav-milim","1.2","tg1","((sports))","goalpost",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-16 Mar 2005, assign-6 Nov 2003",94714,"2005-03-16");
INSERT INTO hebrew_synonyms VALUES (1848,"!שַׁעַר","n","00125430","nn","melingo","3","rav-milim",NULL,"tg1","((sports))","goal, basket",NULL,NULL,"checked","#ASSIGN:66.0=[gnd=1.0E+01,flc(dic)=49.0,bt(dir)=7.0] #MZ@\r\n#IE","eyal-10 Mar 2005, assign-6 Nov 2003",0,"2005-03-10");
INSERT INTO hebrew_synonyms VALUES (1849,"שַׁעַר","n","00123083","yy","melingo","1.3","rav-milim","1.3","tg1","((sports))","goal",NULL,"במשחק האחרון הובקעו בסך הכל חמישה שערים","checked","#ASSIGN:71.0=[gnd=1.0E+01,flc(dic)=49.0,bt(dir)=12.0] #MZ@\r\n#IE","eyal-10 Mar 2005, assign-6 Nov 2003",94714,"2005-03-10");
INSERT INTO hebrew_synonyms VALUES (1850,"!שַׁעַר","n","09594438","u","melingo","1","rav-milim",NULL,"tg1",NULL,"exchange_rate",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE does not match the definitions of RM and Sapir","eyal-16 Mar 2005, assign-6 Nov 2003",0,"2005-03-16");
INSERT INTO hebrew_synonyms VALUES (1851,"שָׁבוּעַ","n","10888430","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"week",NULL,"בעוד שבוע בדיוק מסתיימים הלימודים","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-04 May 2005, assign-6 Nov 2003",94930,"2005-05-04");
INSERT INTO hebrew_synonyms VALUES (1852,"שָׁבוּעַ","n","10862128","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"week",NULL,"אני עובדת רק יומיים בשבוע","checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#IE","eyal-04 May 2005, assign-6 Nov 2003",94930,"2005-05-04");
INSERT INTO hebrew_synonyms VALUES (1853,"!שָׁבוּעַ","n","10861977","n","melingo","1","rav-milim",NULL,"tg1",NULL,"week",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-04 May 2005, assign-6 Nov 2003",0,"2005-05-04");
INSERT INTO hebrew_synonyms VALUES (1854,"שָׁל","n","03311249","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"shawl",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-17 Mar 2005, assign-6 Nov 2003",94762,"2005-03-17");
INSERT INTO hebrew_synonyms VALUES (1855,"שָׁלֵם","a","01123172","yy","melingo","1.1","sapir","1.7","tg1",NULL,"whole",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-12 Oct 2004, assign-6 Nov 2003",93477,"2004-10-12");
INSERT INTO hebrew_synonyms VALUES (1856,"!שָׁלֵם","a","00484924","u","melingo","1","rav-milim",NULL,"tg1",NULL,"whole, complete",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-12 Oct 2004, assign-6 Nov 2003",0,"2004-10-12");
INSERT INTO hebrew_synonyms VALUES (1857,"שָׁלֵם","a","00481167","yy","melingo","1.1","rav-milim","1.1+1.2","tg1",NULL,"whole",NULL,"הוא אכל כיכר לחם שלמה לבדו","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-30 Dec 2004, assign-6 Nov 2003",93477,"2004-12-30");
INSERT INTO hebrew_synonyms VALUES (1858,"!שָׁלֵם","a","00481645","y","melingo","3","rav-milim",NULL,"tg1",NULL,"entire",NULL,NULL,"assigned","#ASSIGN:50=[gnd=1.0E+01,bt(dir)=9.0,bt(dir)=9.0,bt(crs)=18.0,dfl=4.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1859,"!שָׁלֵם","n","01877938","y","melingo","3","rav-milim",NULL,"tg1",NULL,"entire",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1860,"שָׁלַט","v","01763262","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"rule, govern",NULL,"צרפת שלטה באלג\'יריה במשך שנים רבות","checked","#ASSIGN:50=[gnd=6.0,gnd=13.0,si=6.0,bt(dir)=7.0,bt(dir)=7.0,dfl=11.0] #MZ@\r\n#IE","eyal-15 May 2005, assign-6 Nov 2003",94962,"2005-05-15");
INSERT INTO hebrew_synonyms VALUES (1861,"!שָׁלָב","n","03349027","y","melingo","2","rav-milim",NULL,"tg1",NULL,"slat, bar",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1862,"!שָׁלָב","n","02944345","y","melingo","3","rav-milim",NULL,"tg1",NULL,"louvre",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1863,"!שָׁלָב","n","02944079","nn","melingo","3","rav-milim",NULL,"tg1",NULL,"louvre",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE too general","eyal-17 Mar 2005, assign-6 Nov 2003",0,"2005-03-17");
INSERT INTO hebrew_synonyms VALUES (1864,"שָׁלָב","n","10983365","yy","melingo","1.4","rav-milim","1.3","tg1",NULL,"stage, phase",NULL,"אנחנו נמצאים כעת בשלב מעבר בפרוייקט, שבו יש צורך לעצור ולבחון את האפשרויות שעומדות בפנינו","checked","#ASSIGN:69.0=[gnd=5.0,gnd=1.0E+01,si=9.0,bt(dir)=1.0E+01,bt(dir)=5.0,bt(crs)=15.0,bt(dir)=1.0E+01,bt(dir)=5.0] #MZ@\r\n#IE refers to the second part of RM\'s definition","eyal-17 Mar 2005, assign-6 Nov 2003",94755,"2005-03-17");
INSERT INTO hebrew_synonyms VALUES (1865,"שָׁלָב","n","10044643","yy","melingo","1.4","rav-milim","1.3","tg1",NULL,"stage, phase",NULL,"באיזה שלב בחקירה נמצאת כרגע המשטרה?","checked","#ASSIGN:25.0=[gnd=5.0,bt(dir)=5.0,bt(dir)=5.0,bt(crs)=1.0E+01] #MZ@\r\n#IE refers to the first part of RM\'s definition","eyal-17 Mar 2005, assign-6 Nov 2003",94755,"2005-03-17");
INSERT INTO hebrew_synonyms VALUES (1866,"שָׁלוֹם","n","04973475","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"Goodbye",NULL,"אמרתי לו שלום וטרקתי את שפופרת הטלפון","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE the word שלום can be used either when you meet someone, or when you depart from him","eyal-31 Mar 2005, assign-6 Nov 2003",90955,"2005-03-31");
INSERT INTO hebrew_synonyms VALUES (1867,"!שָׁם","r","00106407","y","melingo","1","rav-milim",NULL,"tg1",NULL,"there",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1868,"!שָׁם","r","00106274","n","melingo","1","rav-milim",NULL,"tg1",NULL,"there",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-08 May 2005, assign-6 Nov 2003",0,"2005-05-08");
INSERT INTO hebrew_synonyms VALUES (1869,"שָׁם","r","00106088","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"there",NULL,"הם גרו שם במשך שנים","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-08 May 2005, assign-6 Nov 2003",94938,"2005-05-08");
INSERT INTO hebrew_synonyms VALUES (1870,"שָׁם","r","00251195","yy","melingo","1.3","rav-milim","1.5","tg1",NULL,"ibid.",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-04 May 2005, assign-6 Nov 2003",94938,"2005-05-04");
INSERT INTO hebrew_synonyms VALUES (1871,"שָׁם","v","00459984","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"assess, appraise",NULL,NULL,"checked","#ASSIGN:73.0=[gnd=2.0E+01,gnd=2.0E+01,si=33.0] #MZ@\r\n#IE","eyal-10 May 2005, assign-6 Nov 2003",94946,"2005-05-10");
INSERT INTO hebrew_synonyms VALUES (1872,"!שָׁנִי","n","03879856","y","melingo","1","rav-milim",NULL,"tg1","((literary))","scarlet, crimson",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1873,"!שָׁנִי","n","03880797","y","melingo","1","rav-milim",NULL,"tg1","((literary))","scarlet, crimson",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (8360,"שְׁנַת-הַלִּמּוּדִים","n","10917283","yy","oxford","1.1","rav-milim","1.1",NULL,NULL,"school_year, academic_year",NULL,NULL,"checked","#IE","eyal-01 Mar 2005",94669,"2005-03-01");
INSERT INTO hebrew_synonyms VALUES (1875,"שָׁעוֹן","n","02452507","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"clock",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE","eyal-15 Mar 2005, assign-6 Nov 2003",94743,"2005-03-15");
INSERT INTO hebrew_synonyms VALUES (1876,"!שָׁר","v","01457503","y","melingo","1","rav-milim",NULL,"tg2","((flowery))","behold, watch",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1877,"!שֹׁוִי","n","09911766","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"value, worth",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","ordan-18 Sep 2004, assign-6 Nov 2003",0,"2004-09-18");
INSERT INTO hebrew_synonyms VALUES (1878,"!שֹׁוִי","n","04003047","u","melingo","1","rav-milim",NULL,"tg1",NULL,"value, worth",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO isn\'t it like \'price\' (=מחיר)?","ordan-18 Sep 2004, assign-6 Nov 2003",0,"2004-09-18");
INSERT INTO hebrew_synonyms VALUES (1879,"!שֻׁתָּף","n","07602853","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"partner",NULL,NULL,"checked","#ASSIGN:37.0=[gnd=2.0E+01,bt(dir)=17.0] #MZ@\r\n#IE","eyal-11 Apr 2005, assign-6 Nov 2003",0,"2005-04-11");
INSERT INTO hebrew_synonyms VALUES (1880,"!שֻׁתָּף","n","07164888","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"partner",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE gender","eyal-11 Apr 2005, assign-6 Nov 2003",0,"2005-04-11");
INSERT INTO hebrew_synonyms VALUES (1881,"!שׁוֹחֵט","n","07132921","y","melingo","1","rav-milim",NULL,"tg1","((Jewish ritual))","slaughterer, butcher",NULL,NULL,"assigned","#ASSIGN:73.0=[gnd=39.0,gnd=1.0E+01,si=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1882,"שׁוֹטֵר","n","07485319","nn","melingo","1.1","rav-milim","1.1","tg1",NULL,"policeman",NULL,"הודות לעירנותם של השוטרים, נמנע הפיגוע","checked","#ASSIGN:5.0E+01=[gnd=39.0,bt(dir)=11.0] #MZ@\r\n#IE gender","eyal-27 Feb 2005, eyal-25 Feb 2005, assign-6 Nov 2003",0,"2005-02-27");
INSERT INTO hebrew_synonyms VALUES (1883,"!שׁוֹפֵט","n","07350806","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"judge",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#IE gender","eyal-11 Apr 2005, assign-6 Nov 2003",0,"2005-04-11");
INSERT INTO hebrew_synonyms VALUES (1884,"!שׁוֹפֵט","n","07249386","y","melingo","1","rav-milim",NULL,"tg1",NULL,"judge",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1885,"!שׁוֹפֵט","n","07523999","n","melingo","2","rav-milim",NULL,"tg1","((sports))","referee, umpire",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,flc(dic)=49.0] #MZ@\r\n#IE","eyal-12 Apr 2005, assign-6 Nov 2003",0,"2005-04-12");
INSERT INTO hebrew_synonyms VALUES (1886,"!שׁוֹפֵט","n","07523840","nn","melingo","2","rav-milim",NULL,"tg1","((sports))","referee, umpire",NULL,NULL,"checked","#ASSIGN:69.0=[gnd=2.0E+01,flc(dic)=49.0] #MZ@\r\n#IE gender","eyal-12 Apr 2005, assign-6 Nov 2003",0,"2005-04-12");
INSERT INTO hebrew_synonyms VALUES (1887,"!שׁוֹק","n","06369892","n","melingo","3","rav-milim",NULL,"tg1","((geometry))","side",NULL,NULL,"checked","#ASSIGN:52.0=[gnd=3.0,flc(dic)=49.0] #MZ@\r\n#IE","eyal-06 Apr 2005, assign-6 Nov 2003",0,"2005-04-06");
INSERT INTO hebrew_synonyms VALUES (1888,"שׁוּב","r","00039142","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"again",NULL,"אני מציעה לך לנסות שוב בקרוב","checked","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=2.0E+01,dfl=1.0E+01] #MZ@\r\n#IE","eyal-04 May 2005, assign-6 Nov 2003",94935,"2005-05-04");
INSERT INTO hebrew_synonyms VALUES (1889,"שׁוּק","n","00711063","yy","melingo","1.1","sapir","1.3","tg1",NULL,"market",NULL,"ללא תחרות השוק יגווע","checked","#ASSIGN:74.0=[gnd=1.0E+01,bt(dir)=11.0,bt(dir)=21.0,bt(crs)=32.0] #MZ@\r\n#IE","eyal-15 Mar 2005, assign-6 Nov 2003",94734,"2005-03-15");
INSERT INTO hebrew_synonyms VALUES (1890,"שׁוּק","n","02967394","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"marketplace",NULL,"רחובות השוק היו הומי אדם","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE refers to the second part of RM\'s definition","eyal-15 Mar 2005, assign-6 Nov 2003",94734,"2005-03-15");
INSERT INTO hebrew_synonyms VALUES (8396,"הִשְׁתַּתְּפוּת","n","00804778","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"participation",NULL,"המורה ניסה להגביר את השתתפות תלמידיו בפעילויות בית ספריות","checked","#IE","eyal-15 Mar 2005",94735,"2005-03-15");
INSERT INTO hebrew_synonyms VALUES (1892,"!שׁוּרָה","n","05550105","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"series",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-18 Aug 2004, assign-6 Nov 2003",0,"2004-08-18");
INSERT INTO hebrew_synonyms VALUES (1893,"שְׂרָף","n","10685306","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"resin",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-04 May 2005, assign-6 Nov 2003",94928,"2005-05-04");
INSERT INTO hebrew_synonyms VALUES (1894,"שִׂיא","n","10045044","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"peak",NULL,"שיא הקריירה","checked","#ASSIGN:109.0=[gnd=5.0,bt(dir)=9.0,bt(dir)=5.0,bt(dir)=9.0,bt(dir)=3.0,bt(crs)=78.0] #MZ@\r\n#NO","ordan-30 Jan 2005, assign-6 Nov 2003",94323,"2005-01-30");
INSERT INTO hebrew_synonyms VALUES (1895,"שִׂיא","n","10019938","yy","melingo","1.1","rav-milim","1.5","tg1",NULL,"peak",NULL,NULL,"checked","#ASSIGN:35.0=[gnd=5.0,bt(dir)=5.0,bt(dir)=1.0E+01,bt(crs)=15.0] #MZ@\r\n#IE","eyal-10 Mar 2005, assign-6 Nov 2003",94323,"2005-03-10");
INSERT INTO hebrew_synonyms VALUES (1896,"!שִׂיא","n","06349777","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"peak, zenith",NULL,NULL,"checked","#ASSIGN:53.0=[gnd=5.0,bt(dir)=4.0,bt(dir)=3.0,bt(dir)=9.0,bt(crs)=32.0] #MZ@\r\n#NO","ordan-30 Jan 2005, assign-6 Nov 2003",0,"2005-01-30");
INSERT INTO hebrew_synonyms VALUES (1897,"!שִׂיא","n","06392752","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"peak, zenith",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\nNO","ordan-30 Jan 2005, assign-6 Nov 2003",0,"2005-01-30");
INSERT INTO hebrew_synonyms VALUES (1898,"!שִׂיא","n","09769589","y","melingo","4","rav-milim",NULL,"tg1","((sports))","record",NULL,NULL,"assigned","#ASSIGN:35.0=[gnd=5.0,flc(dic)=24.0,bt(dir)=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1899,"שִׂיא","n","00036443","yy","melingo","1.4","rav-milim","1.3","tg1","((sports))","record",NULL,"הוא שבר את השיא האולימפי בריצת 100 מטר","checked","#ASSIGN:35.0=[gnd=5.0,flc(dic)=24.0,bt(dir)=6.0] #MZ@\r\n#IE","eyal-10 Mar 2005, assign-6 Nov 2003",94323,"2005-03-10");
INSERT INTO hebrew_synonyms VALUES (1900,"שִׂיחָה","n","05337255","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"conversation",NULL,"היתה לנו שיחה מאוד מעניינת","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-28 Mar 2005, assign-6 Nov 2003",91233,"2005-03-28");
INSERT INTO hebrew_synonyms VALUES (1901,"שִׂיחָה","n","04742189","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"telephone_call",NULL,"אל תעשי את השיחות האלה מהמשרד","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-08 Jun 2004, assign-6 Nov 2003",91233,"2004-06-08");
INSERT INTO hebrew_synonyms VALUES (1902,"שִׂיחָה","n","05347846","yy","melingo","1.4","rav-milim","1.5","tg1",NULL,"negotiation",NULL,"השיחות בין שני הצדדים הניבו הסכם שהיה מקובל על כולם","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE usually plural - שיחות","eyal-28 Mar 2005, assign-6 Nov 2003",91233,"2005-03-28");
INSERT INTO hebrew_synonyms VALUES (1903,"שֶׂכֶר","n","04896216","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"charter",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-28 Mar 2005, assign-6 Nov 2003",94807,"2005-03-28");
INSERT INTO hebrew_synonyms VALUES (1904,"!שֶׂכֶר","n","04860883","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"charter",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-28 Mar 2005, assign-6 Nov 2003",0,"2005-03-28");
INSERT INTO hebrew_synonyms VALUES (1905,"שַׂחְקָן","n","07480903","yy","melingo","1.1","sapir","1.2","tg1",NULL,"player",NULL,"המשחק הזה מיועד לשני שחקנים ומעלה","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-11 Apr 2005, assign-6 Nov 2003",94852,"2005-04-11");
INSERT INTO hebrew_synonyms VALUES (1906,"!שַׂחְקָן","n","07424573","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"player",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-11 Apr 2005, assign-6 Nov 2003",0,"2005-04-11");
INSERT INTO hebrew_synonyms VALUES (1908,"שַׂחְקָן","n","07061094","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"player, actor",NULL,"השחקן הראשי בהצגה עשה עבודה נפלאה בגילום הדמות","checked","#ASSIGN:33.0=[gnd=2.0E+01,bt(dir)=13.0] #MZ@\r\n#IE","eyal-11 Apr 2005, assign-6 Nov 2003",94852,"2005-04-11");
INSERT INTO hebrew_synonyms VALUES (1909,"שָׂבֵעַ","a","01999564","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"satiated",NULL,"אינני רוצה תוספת, אני כבר שבעה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-12 Oct 2004, assign-6 Nov 2003",93478,"2004-10-12");
INSERT INTO hebrew_synonyms VALUES (1910,"!שָׂבֵעַ","a","01999835","y","melingo","2","rav-milim",NULL,"tg1",NULL,"sated",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1911,"!שָׂבַע","v","00807803","y","melingo","1","rav-milim",NULL,"tg1",NULL,"be_satiated, be_full",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1912,"!שָׂבַע","v","00811762","y","melingo","2","rav-milim",NULL,"tg1",NULL,"sate",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1913,"!שָׂכַר","v","01676541","y","melingo","1","rav-milim",NULL,"tg1",NULL,"hire, rent",NULL,NULL,"assigned","#ASSIGN:75.0=[gnd=13.0,gnd=1.0E+01,si=2.0E+01,bt(dir)=16.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1914,"!שָׂכַר","v","01512144","y","melingo","1","rav-milim",NULL,"tg1",NULL,"hire, rent",NULL,NULL,"assigned","#ASSIGN:75.0=[gnd=13.0,gnd=1.0E+01,si=2.0E+01,bt(dir)=16.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1915,"שָׂכָר","n","09556237","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"wage, salary",NULL,"עבודה זו מבוצעת בהתנדבות, אינני מקבלת שכר כלל","checked","#ASSIGN:4.1E+02=[gnd=39.0,gnd=39.0,si=98.0,bt(dir)=39.0,bt(dir)=39.0,bt(crs)=78.0,bt(dir)=39.0,bt(dir)=39.0] #MZ@\r\n#IE","eyal-14 Nov 2004, assign-6 Nov 2003",93664,"2004-11-14");
INSERT INTO hebrew_synonyms VALUES (1916,"!שָׂרַף","v","00263602","y","melingo","2","rav-milim",NULL,"tg1",NULL,"incinerate",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1917,"שָׂרָף","n","06891976","yy","melingo","1.1","rav-milim","1.1","tg1","((flowery))","seraph",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-10 Apr 2005, assign-6 Nov 2003",94849,"2005-04-10");
INSERT INTO hebrew_synonyms VALUES (1918,"!תְּבִיעָה","n","06011094","y","melingo","3","rav-milim",NULL,"tg1","((law))","prosecution",NULL,NULL,"assigned","#ASSIGN:37.0=[gnd=13.0,flc(dic)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1919,"!תְּבִיעָה","n","00776884","y","melingo","3","rav-milim",NULL,"tg1","((law))","prosecution",NULL,NULL,"assigned","#ASSIGN:37.0=[gnd=13.0,flc(dic)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1920,"!תְּבִיעָה","n","00686953","y","melingo","4","rav-milim",NULL,"tg1","((insurance))","claim",NULL,NULL,"assigned","#ASSIGN:64.0=[gnd=7.0,flc(dic)=49.0,bt(dir)=8.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1922,"תְּגוּבָה","n","00551220","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"reaction",NULL,"יש לו תגובה חריפה מאוד לעקיצות יתושים","checked","#ASSIGN:50=[gnd=6.0,bt(dir)=6.0,bt(dir)=6.0,bt(crs)=12.0,dfl=2.0E+01] #MZ@\r\n#IE","eyal-22 May 2005, assign-6 Nov 2003",94994,"2005-05-22");
INSERT INTO hebrew_synonyms VALUES (1923,"תְּגוּבָה","n","09682678","yy","melingo","1.3","rav-milim","1.4","tg1",NULL,"chemical_reaction",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,bt(dir)=6.0,dfl=5.0] #MZ@\r\n#IE","eyal-22 May 2005, assign-6 Nov 2003",94994,"2005-05-22");
INSERT INTO hebrew_synonyms VALUES (1924,"תְּחִלָּה","r","00099935","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"at_first",NULL,"תחילה, ברצוני לפתוח בכמה מילות ברכה","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-15 Feb 2005, assign-6 Nov 2003",94535,"2005-02-15");
INSERT INTO hebrew_synonyms VALUES (1925,"!תְּחוּם","n","10410497","y","melingo","1","rav-milim",NULL,"tg1",NULL,"area, range, zone",NULL,NULL,"assigned","#ASSIGN:25.0=[gnd=7.0,bt(dir)=7.0,bt(dir)=2.0,bt(crs)=9.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1926,"!תְּחוּם","n","10410497","y","melingo","3","rav-milim",NULL,"tg1",NULL,"limit, domain",NULL,NULL,"assigned","#ASSIGN:26.0=[gnd=8.0,bt(dir)=7.0,bt(dir)=2.0,bt(crs)=9.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1927,"!תְּחוּם","n","06307482","y","melingo","3","rav-milim",NULL,"tg1",NULL,"limit, domain",NULL,NULL,"assigned","#ASSIGN:34.0=[gnd=8.0,bt(dir)=9.0,bt(dir)=4.0,bt(crs)=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1928,"!תְּחוּם","n","04595218","y","melingo","3","rav-milim",NULL,"tg1",NULL,"limit, domain",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=8.0,bt(dir)=9.0,bt(dir)=9.0,bt(crs)=18.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1929,"!תְּחוּשָׁה","n","04371175","n","melingo","1","rav-milim",NULL,"tg1","((physiology))","sensation",NULL,NULL,"assigned","#ASSIGN:59.0=[gnd=1.0E+01,flc(dic)=49.0] #MZ@\r\n#IE fits better to n#04413760","eyal-29 May 2005, assign-6 Nov 2003",0,"2005-05-29");
INSERT INTO hebrew_synonyms VALUES (1930,"!תְּמִיכָה","n","00750993","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"support, stabilization",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-13 Jul 2004, assign-6 Nov 2003",0,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (1931,"!תְּמִיכָה","n","04015637","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"relief, assistance",NULL,NULL,"checked","#ASSIGN:28.0=[gnd=2.0E+01,bt(dir)=8.0] #MZ@\r\n#NO","ordan-27 Dec 2004, assign-6 Nov 2003",0,"2004-12-27");
INSERT INTO hebrew_synonyms VALUES (1932,"!תְּמִיכָה","n","00782440","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"relief, assistance",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=2.0E+01,bt(dir)=9.0] #MZ@\r\n#NO","ordan-13 Aug 2004, assign-6 Nov 2003",0,"2004-08-13");
INSERT INTO hebrew_synonyms VALUES (1933,"תְּמוּנָה","n","03113185","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"photograph",NULL,"על שולחן העבודה שלו הוא הניח תמונה של ילדיו","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-24 May 2005, assign-6 Nov 2003",95023,"2005-05-24");
INSERT INTO hebrew_synonyms VALUES (1934,"תְּמוּנָה","n","05258594","yy","melingo","1.2","rav-milim","1.3","tg1","((theatre, cinema))","scene",NULL,NULL,"checked","#ASSIGN:53.0=[gnd=4.0,flc(dic)=49.0] #MZ@\r\n#IE","eyal-09 Jun 2005, assign-6 Nov 2003",95023,"2005-06-09");
INSERT INTO hebrew_synonyms VALUES (1935,"תְּנַאי","n","05062190","yy","melingo","1.1","sapir","1.4","tg1",NULL,"condition, stipulation",NULL,NULL,"checked","#ASSIGN:48.0=[gnd=6.0,gnd=2.0E+01,si=8.0,bt(dir)=7.0,bt(dir)=7.0] #MZ@\r\n#IE","eyal-02 Jun 2005, assign-6 Nov 2003",95082,"2005-06-02");
INSERT INTO hebrew_synonyms VALUES (1936,"תְּנַאי","n","05072928","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"term, condition",NULL,"בחוזה היו מצויינים תנאי השכירות","checked","#ASSIGN:33.0=[gnd=7.0,gnd=6.0,si=8.0,bt(dir)=6.0,bt(dir)=6.0] #MZ@\r\n#IE","eyal-09 Jun 2005, assign-6 Nov 2003",95082,"2005-06-09");
INSERT INTO hebrew_synonyms VALUES (1937,"!תְּנוּעָה","n","00213518","y","melingo","1","rav-milim",NULL,"tg1",NULL,"movement",NULL,NULL,"assigned","#ASSIGN:49.0=[gnd=4.0,bt(dir)=5.0,bt(dir)=3.0,bt(dir)=7.0,bt(crs)=3.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1938,"תְּנוּעָה","n","00180278","yy","melingo","1.1","rav-milim",">1.2","tg1",NULL,"movement",NULL,"המשטרה פיקחה על תנועת הקהל","checked","#ASSIGN:55.0=[gnd=4.0,bt(dir)=5.0,bt(dir)=4.0,bt(dir)=8.0,bt(crs)=34.0] #MZ@\r\n#IE","eyal-17 May 2005, assign-6 Nov 2003",94976,"2005-05-17");
INSERT INTO hebrew_synonyms VALUES (1939,"תְּנוּעָה","n","06231214","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"traffic",NULL,"יש עומס תנועה כבד עקב מופע רמזור קצר","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-16 May 2005, assign-6 Nov 2003",94976,"2005-05-16");
INSERT INTO hebrew_synonyms VALUES (1940,"!תְּנוּעָה","n","00722332","y","melingo","2","rav-milim",NULL,"tg1",NULL,"traffic",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1941,"!תְּנוּעָה","n","00023967","y","melingo","2","rav-milim",NULL,"tg1",NULL,"traffic",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1942,"!תְּנוּעָה","n","00213518","y","melingo","3","rav-milim",NULL,"tg1",NULL,"organization, party, movement",NULL,NULL,"assigned","#ASSIGN:49.0=[gnd=4.0,bt(dir)=5.0,bt(dir)=3.0,bt(dir)=7.0,bt(crs)=3.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1944,"תְּנוּעָה","n","00511256","yy","melingo","1.4","rav-milim","1.6","tg1",NULL,"youth_movement",NULL,"היום אחר הצהריים אני נפגש עם החבר\'ה מהתנועה","checked","#ASSIGN:50=[gnd=39.0,bt(dir)=4.0,dfl=7.0] #MZ@\r\n#IE","eyal-16 May 2005, assign-6 Nov 2003",94976,"2005-05-16");
INSERT INTO hebrew_synonyms VALUES (1945,"!תְּנוּעָה","n","07775426","y","melingo","5","rav-milim",NULL,"tg1","((physics))","motion",NULL,NULL,"assigned","#ASSIGN:73.0=[gnd=6.0,flc(dic)=49.0,bt(dir)=6.0,bt(dir)=3.0,bt(crs)=9.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1946,"!תְּנוּעָה","n","05449557","y","melingo","5","rav-milim",NULL,"tg1","((physics))","motion",NULL,NULL,"assigned","#ASSIGN:26.0=[gnd=6.0,bt(dir)=4.0,bt(dir)=6.0,bt(crs)=1.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1947,"!תְּנוּעָה","n","00213518","y","melingo","5","rav-milim",NULL,"tg1","((physics))","motion",NULL,NULL,"assigned","#ASSIGN:51.0=[gnd=6.0,bt(dir)=5.0,bt(dir)=3.0,bt(dir)=7.0,bt(crs)=3.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (8564,"מַעֲבָר","n","00180278","yy","melingo","1.3","rav-milim",">1.3",NULL,NULL,"move",NULL,"הרבה מאד משתנים משפיעים על חויית המעבר של ילד לארץ חדשה","checked","#IE RM\'s definition is broader than WN\'s","eyal-17 May 2005",94980,"2005-05-17");
INSERT INTO hebrew_synonyms VALUES (1949,"תְּנוּעָה","n","05322484","yy","melingo","1.6","rav-milim","1.8","tg1","((phonetics))","vowel",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,flc(dic)=24.0] #MZ@\r\n#IE","eyal-17 May 2005, assign-6 Nov 2003",94976,"2005-05-17");
INSERT INTO hebrew_synonyms VALUES (1950,"תְּקוּפָה","n","10955141","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"era",NULL,"בתקופת הרנסאנס החל המדע המודרני לפרוח","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO for תקופה as period, see RM 1.3","ordan-28 Dec 2004, assign-6 Nov 2003",94000,"2004-12-28");
INSERT INTO hebrew_synonyms VALUES (1951,"תְּקוּפָה","n","10954662","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"era",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-28 Dec 2004, assign-6 Nov 2003",94000,"2004-12-28");
INSERT INTO hebrew_synonyms VALUES (1952,"!תְּקוּפָה","n","10947841","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"season",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-19 Sep 2004, assign-6 Nov 2003",0,"2004-09-19");
INSERT INTO hebrew_synonyms VALUES (1953,"!תְּקוּפָה","n","10947554","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"season",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-19 Sep 2004, assign-6 Nov 2003",0,"2004-09-19");
INSERT INTO hebrew_synonyms VALUES (1954,"!תְּקוּפָה","n","10945309","nn","melingo","2","rav-milim",NULL,"tg1",NULL,"season",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-19 Sep 2004, assign-6 Nov 2003",0,"2004-09-19");
INSERT INTO hebrew_synonyms VALUES (1955,"תְּרוּפָה","n","02981307","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"medication, medicine",NULL,"הילד בלע את התרופה ברצון, לשמחתה של אימו","checked","#ASSIGN:202.0=[gnd=2.0E+01,gnd=1.0E+01,si=2.0E+01,bt(dir)=8.0,bt(dir)=17.0,bt(dir)=13.0,bt(crs)=76.0,bt(dir)=8.0,bt(dir)=17.0,bt(dir)=13.0] #MZ@\r\n#IE","eyal-19 May 2005, assign-6 Nov 2003",94989,"2005-05-19");
INSERT INTO hebrew_synonyms VALUES (1956,"!תְּרוּפָה","n","00445646","y","melingo","1","rav-milim",NULL,"tg1",NULL,"medication, medicine",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1957,"תְּשׁוּבָה","n","05053336","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"answer, solution",NULL,"התשובות הופיעו בפרק האחרון בספר","checked","#ASSIGN:41.0=[gnd=8.0,gnd=1.0E+01,si=11.0,bt(dir)=6.0,bt(dir)=6.0] #MZ@\r\n#IE","eyal-02 Jun 2005, assign-6 Nov 2003",95079,"2005-06-02");
INSERT INTO hebrew_synonyms VALUES (1958,"!תְּשׁוּבָה","n","05379686","y","melingo","1","rav-milim",NULL,"tg1",NULL,"answer, reply, solution",NULL,NULL,"assigned","#ASSIGN:28.0=[gnd=2.0E+01,bt(dir)=8.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1959,"תְּשׁוּבָה","n","05055491","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"answer, reply",NULL,"חיכיתי כמה ימים לתשובה ממנו","checked","#ASSIGN:84.0=[gnd=8.0,gnd=2.0E+01,si=11.0,bt(dir)=9.0,bt(dir)=6.0,bt(crs)=15.0,bt(dir)=9.0,bt(dir)=6.0] #MZ@\r\n#IE","eyal-02 Jun 2005, assign-6 Nov 2003",95079,"2005-06-02");
INSERT INTO hebrew_synonyms VALUES (1960,"תְּשׁוּבָה","n","05602852","yy","melingo","2.1","rav-milim","2.1","tg2",NULL,"repentance, penitence",NULL,NULL,"checked","#ASSIGN:176.0=[gnd=39.0,gnd=39.0,si=98.0] #MZ@\r\n#IE","eyal-02 Jun 2005, assign-6 Nov 2003",0,"2005-06-02");
INSERT INTO hebrew_synonyms VALUES (1961,"!תִּיכוֹן","n","06218671","yy","melingo","1.2","rav-milim","1.3","tg1","((colloquial))","high_school",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,gnd=39.0,bt(dir)=5.0,bt(dir)=5.0] #MZ@\r\n#IE","eyal-14 Jun 2005, assign-6 Nov 2003",95092,"2005-06-14");
INSERT INTO hebrew_synonyms VALUES (1962,"!תִּיק","n","03275700","n","melingo","1","rav-milim",NULL,"tg1",NULL,"bag, satchel",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE too general","eyal-25 May 2005, assign-6 Nov 2003",0,"2005-05-25");
INSERT INTO hebrew_synonyms VALUES (1963,"!תִּיק","n","03159967","n","melingo","3","rav-milim",NULL,"tg1",NULL,"portfolio",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE too general","eyal-25 May 2005, assign-6 Nov 2003",0,"2005-05-25");
INSERT INTO hebrew_synonyms VALUES (1964,"תִּיק","n","04491717","yy","melingo","1.6","rav-milim","1.6","tg1","((colloquial))","burden, onus",NULL,"איזה תיק הפילו עלי: אחותי רוצה שאני אשמור לה על הילדים כל הסופשבוע!","checked","#ASSIGN:65.0=[gnd=1.0E+01,gnd=39.0,si=16.0] #MZ@\r\n#IE","eyal-25 May 2005, assign-6 Nov 2003",0,"2005-05-25");
INSERT INTO hebrew_synonyms VALUES (1965,"!תִּקְשֹׁרֶת","n","09931984","y","melingo","1","rav-milim",NULL,"tg1",NULL,"communication",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1966,"תִּקְשֹׁרֶת","n","04728675","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"communication",NULL,"הבכי הוא אמצעי התקשורת החשוב ביותר אצל תינוקות","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-16 May 2005, assign-6 Nov 2003",94972,"2005-05-16");
INSERT INTO hebrew_synonyms VALUES (1967,"תִּקְשֹׁרֶת","n","00019671","yy","melingo","1","rav-milim",NULL,"tg1",NULL,"communication",NULL,"התקשרות ביניהם רוויה דברי עלבונות","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-23 Sep 2005, -23 Sep 2005, assign-6 Nov 2003",94972,"2005-09-23");
INSERT INTO hebrew_synonyms VALUES (1968,"!תִּקּוּן","n","10431107","y","melingo","1","rav-milim",NULL,"tg1",NULL,"repair",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1969,"!תִּקּוּן","n","06326331","y","melingo","1","rav-milim",NULL,"tg1",NULL,"repair",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1970,"תִּקּוּן","n","00171220","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"repair",NULL,"המכונאים עבדו שעות על תיקון המכונית","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-17 May 2005, assign-6 Nov 2003",94982,"2005-05-17");
INSERT INTO hebrew_synonyms VALUES (1971,"תִּקּוּן","n","05041525","yy","melingo","1.4","rav-milim","1.4","tg1","((law))","amendment",NULL,"תיקון 7א\' בחוק שוויון הזדמנויות בעבודה מתייחס להטרדה מינית במקום העבודה","checked","#ASSIGN:93.0=[gnd=2.0E+01,flc(dic)=49.0,bt(dir)=24.0] #MZ@\r\n#IE","eyal-01 Jun 2005, assign-6 Nov 2003",94982,"2005-06-01");
INSERT INTO hebrew_synonyms VALUES (1972,"!תִּקּוּן","n","00811685","y","melingo","4","rav-milim",NULL,"tg1","((law))","amendment",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1973,"תִּקּוּן","n","00510453","yy","melingo","1.5","rav-milim","1.5","tg1",NULL,"reform",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-17 May 2005, assign-6 Nov 2003",94982,"2005-05-17");
INSERT INTO hebrew_synonyms VALUES (1974,"!תִּקּוּן","n","00167762","y","melingo","5","rav-milim",NULL,"tg1",NULL,"reform",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1975,"!תִּקּוּן","n","00167178","y","melingo","5","rav-milim",NULL,"tg1",NULL,"reform",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1976,"תֵּאַטְרוֹן","n","05256340","yy","melingo","1.1","rav-milim","1.3","tg1",NULL,"theater",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#IE","eyal-09 Jun 2005, assign-6 Nov 2003",90807,"2005-06-09");
INSERT INTO hebrew_synonyms VALUES (1978,"תֵּאַטְרוֹן","n","06085732","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"company, troupe",NULL,"תיאטרון ''תמונע'' מורכב רובו ככולו משחקנים מתחילים","checked","#ASSIGN:54.0=[gnd=4.0,gnd=39.0,si=11.0] #MZ@\r\n#IE","eyal-09 Jun 2005, assign-6 Nov 2003",90807,"2005-06-09");
INSERT INTO hebrew_synonyms VALUES (1979,"!תֵּל","n","02355342","y","melingo","1","rav-milim",NULL,"tg1","((archeology))","barrow, man-made_hill_covering_the_remains_of_an_ancient_settlement",NULL,NULL,"assigned","#ASSIGN:62.0=[gnd=13.0,flc(dic)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1980,"תֵּל","n","06723626","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"mound, knoll, down",NULL,NULL,"checked","#ASSIGN:59.0=[gnd=8.0,gnd=39.0,si=12.0] #MZ@\r\n#NO\r\n#NO","ordan-14 Sep 2004",91235,"2004-09-14");
INSERT INTO hebrew_synonyms VALUES (1981,"הָמוֹן","n","09920124","yy","melingo","2","rav-milim","2.1","tg1","((colloquial))","good_deal, great_deal",NULL,"הוא עשה לה המון צרות","checked","#ASSIGN:29.0=[gnd=13.0,gnd=5.0,si=11.0] #MZ@ #IE","eyal-28 Mar 2004",91234,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (1982,"תֵּל","n","05969773","yy","melingo","3","rav-milim","1.3","tg1","((colloquial))","heap, pile",NULL,"השולחן שלו היה מלא תילי תילים של ספרים, מחברות וכוסות מלוכלכות","checked","#ASSIGN:29.0=[gnd=13.0,gnd=5.0,si=11.0] #MZ@ #IE","eyal-04 Mar 2004, assign-6 Nov 2003",91235,"2004-03-04");
INSERT INTO hebrew_synonyms VALUES (1983,"תֶּשֶׁר","n","09572926","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"tip, gratuity",NULL,"למרות עושרו הרב, הוא אינו נוהג להעניק תשר למלצרים","checked","#ASSIGN:64.0=[gnd=8.0,gnd=2.0E+01,si=16.0,bt(dir)=1.0E+01,bt(dir)=1.0E+01] #MZ@\r\n#IE","eyal-19 Jun 2005, assign-6 Nov 2003",95112,"2005-06-19");
INSERT INTO hebrew_synonyms VALUES (1984,"תַּחֲרוּת","n","05542799","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"competition",NULL,"בתחרות האירוויזיון האחרונה ישראל הגיעה למקום הרביעי המכובד","checked","#ASSIGN:68.0=[gnd=1.0E+01,bt(dir)=19.0,bt(dir)=1.0E+01,bt(crs)=29.0] #MZ@\r\n#IE","eyal-22 May 2005, assign-6 Nov 2003",94999,"2005-05-22");
INSERT INTO hebrew_synonyms VALUES (1985,"תַּחֲרוּת","n","00756855","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"rivalry",NULL,"היתה תחרות קשה מאוד על המקום הראשון","checked","#ASSIGN:51.0=[gnd=39.0,bt(dir)=12.0] #MZ@\r\n#IE","eyal-22 May 2005, assign-6 Nov 2003",94999,"2005-05-22");
INSERT INTO hebrew_synonyms VALUES (8573,"תַּנִּין","n","01217953","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"crocodile",NULL,NULL,"checked","#IE","eyal-22 May 2005",95001,"2005-05-22");
INSERT INTO hebrew_synonyms VALUES (1987,"!תַּחֲרוּת","n","00757193","y","melingo","2","rav-milim",NULL,"tg1",NULL,"contest, rivalry",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1988,"תַּחַת","n","04306560","yy","melingo","1.1","rav-milim","1.1","tg1","((slang))","bottom, buttocks, behind, ''arse''",NULL,"כואב לי התחת מרוב ישיבה!","checked","#ASSIGN:105.0=[gnd=6.0,gnd=39.0,gnd=39.0,si=21.0] #MZ@\r\n#IE","eyal-29 May 2005, assign-6 Nov 2003",95045,"2005-05-29");
INSERT INTO hebrew_synonyms VALUES (1989,"תַּלְמִיד","n","07617015","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"student, pupil",NULL,"פעם, כשהמורה היה נכנס לכיתה, התלמידים היו נעמדים","checked","#ASSIGN:105.0=[gnd=2.0E+01,gnd=13.0,si=24.0,bt(dir)=24.0,bt(dir)=24.0] #MZ@\r\n#IE","eyal-16 Jun 2005, assign-6 Nov 2003",95103,"2005-06-16");
INSERT INTO hebrew_synonyms VALUES (1990,"!תַּלְמִיד","n","07549738","n","melingo","1","rav-milim",NULL,"tg1",NULL,"student, pupil",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#IE","eyal-16 Jun 2005, assign-6 Nov 2003",0,"2005-06-16");
INSERT INTO hebrew_synonyms VALUES (1991,"תַּלְמִיד","n","07217388","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"disciple",NULL,"רבי שמעון בר יוחאי היה תלמידו של רבי עקיבא","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-16 Jun 2005, assign-6 Nov 2003",95103,"2005-06-16");
INSERT INTO hebrew_synonyms VALUES (1992,"תַּעֲרוּכָה","n","06217283","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"exhibition",NULL,"בתערוכה החדשה בגלריה מוצגות תמונות שמן של כמה אומנים מתחילים","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-19 May 2005, assign-6 Nov 2003",94987,"2005-05-19");
INSERT INTO hebrew_synonyms VALUES (1993,"!תַּעֲרוּכָה","n","00336519","y","melingo","1","rav-milim",NULL,"tg1",NULL,"exhibition",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1994,"!תַּעֲשִׂיָּה","n","06011363","y","melingo","1","rav-milim",NULL,"tg1",NULL,"industry",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1995,"!תַּעֲשִׂיָּה","n","03811831","y","melingo","1","rav-milim",NULL,"tg1",NULL,"industry",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (1996,"תַּעֲשִׂיָּה","n","00592801","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"industry",NULL,"התעשייה האמריקנית עושה שימוש נרחב במחשבים לצורך בקרה על הייצור","checked","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@ #IE","eyal-30 Jun 2004, assign-6 Nov 2003",91236,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (1997,"!תַּפְקִיד","n","09586410","y","melingo","1","rav-milim",NULL,"tg1",NULL,"duty, task, job",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6426,"חוֹבָה","n","00731811","u","melingo","1","rav-milim","1.1",NULL,NULL,"obligation",NULL,"חובתו של אדם לדאוג למשפחתו","checked","#NO this sense corresponds onlz 75% to the 1.1 Definition of RM, I didn\'t find a 100% hebrew equivalent. \r\n#IE","eyal-22 May 2005, ordan-05 Feb 2004",0,"2005-05-22");
INSERT INTO hebrew_synonyms VALUES (1999,"!תַּפְקִיד","n","00461585","y","melingo","1","rav-milim",NULL,"tg1",NULL,"duty, task, job",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2000,"!תַּפְקִיד","n","00461778","n","melingo","1","rav-milim",NULL,"tg1",NULL,"duty, task, job",NULL,NULL,"assigned","#ASSIGN:3.0E+01=[gnd=2.0E+01,gnd=4.0,si=6.0] #MZ@\r\n#IE","eyal-22 May 2005, assign-6 Nov 2003",0,"2005-05-22");
INSERT INTO hebrew_synonyms VALUES (8569,"מְחֻיָּבוּת","n","00731811","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"obligation, responsibility",NULL,"היא התלבטה קשות בין תחושת מחוייבות למשפחתה לבין הרצון למימוש עצמי","checked","#IE","eyal-22 May 2005",94992,"2005-05-22");
INSERT INTO hebrew_synonyms VALUES (2002,"תַּפְקִיד","n","04552661","yy","melingo","1.3","rav-milim","1.4","tg1",NULL,"part, role",NULL,"היא לוהקה לתפקיד דסדמונה","checked","#ASSIGN:53.0=[gnd=3.0,gnd=1.0E+01,si=7.0,bt(dir)=8.0,bt(dir)=3.0,bt(crs)=11.0,bt(dir)=8.0,bt(dir)=3.0] #MZ@\r\n#IE","eyal-22 May 2005, assign-6 Nov 2003",94121,"2005-05-22");
INSERT INTO hebrew_synonyms VALUES (2003,"תַּפְקִיד","n","00462318","yy","melingo","1.3","rav-milim","1.1","tg1",NULL,"part, role",NULL,"המשטרה לא ממלאת כראוי את תפקידה בהגנה על האזרח הפשוט","checked","#ASSIGN:56.0=[gnd=3.0,gnd=1.0E+01,si=7.0,bt(dir)=3.0,bt(dir)=9.0,bt(crs)=12.0,bt(dir)=3.0,bt(dir)=9.0] #MZ@\r\n#IE","eyal-22 May 2005, assign-6 Nov 2003",94121,"2005-05-22");
INSERT INTO hebrew_synonyms VALUES (2004,"תַּצְלוּם","n","03113185","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"photograph",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-24 May 2005, assign-6 Nov 2003",95024,"2005-05-24");
INSERT INTO hebrew_synonyms VALUES (2005,"תַּקְצִיב","n","09668771","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"budget",NULL,"יש לי תקציב מיוחד לחינוך הילדים","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-19 Jun 2005, assign-6 Nov 2003",95116,"2005-06-19");
INSERT INTO hebrew_synonyms VALUES (2006,"תַּקְצִיב","n","09668437","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"budget",NULL,"מפלגות האופוזיציה סרבו להצביע בעד הצעת תקציב המדינה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-19 Jun 2005, assign-6 Nov 2003",95116,"2005-06-19");
INSERT INTO hebrew_synonyms VALUES (2007,"תַּשְׁלוּם","n","09555462","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"payment",NULL,"התשלום שקיבלנו עבור העבודה שביצענו היה נמוך מדי","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE refers to the second part of RM\'s definition\r\n","eyal-19 May 2005, assign-6 Nov 2003",94991,"2005-05-19");
INSERT INTO hebrew_synonyms VALUES (2008,"תַּשְׁלוּם","n","00725730","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"payment",NULL,"הסחורה תתקבל במעמד התשלום בלבד","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-19 May 2005, assign-6 Nov 2003",94991,"2005-05-19");
INSERT INTO hebrew_synonyms VALUES (2009,"!תַּשְׁתִּית","n","04465690","nn","melingo","1","rav-milim",NULL,"tg1",NULL,"base, basis, foundation",NULL,NULL,"checked","#ASSIGN:36.0=[gnd=2.0,gnd=2.0E+01,gnd=7.0,si=7.0] #MZ@\r\n#NO","ordan-17 Feb 2004, assign-6 Nov 2003",0,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (2010,"!תַּשְׁתִּית","n","02855978","y","melingo","2","rav-milim",NULL,"tg1",NULL,"infrastructure",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2011,"תַּשְׁתִּית","n","02855587","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"infrastructure",NULL,"אהיה מוכנה לעבור לשכונה החדשה רק לאחר שעבודות התשתית תסתיימנה","checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#IE","eyal-24 May 2005, assign-6 Nov 2003",95009,"2005-05-24");
INSERT INTO hebrew_synonyms VALUES (2012,"נוּת","n","06867794","yy","dahan","1","rav-milim",NULL,"tg1",NULL,"nut",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","shuly-14 Jan 2004, assign-6 Nov 2003",91238,"2004-01-14");
INSERT INTO hebrew_synonyms VALUES (2013,"אֱלִיל","n","07333898","n","dahan","1","rav-milim","2","tg1",NULL,"idol",NULL,"אליל הנוער עמד בפתח האולפן וחילק חתימות למעריצים","checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@ #IE gender","eyal-30 Jun 2005, eyal-17 Feb 2004, assign-6 Nov 2003",0,"2005-06-30");
INSERT INTO hebrew_synonyms VALUES (6920,"מוֹפֵת","n","04549171","yy","none",NULL,"rav-milim","1.1",NULL,NULL,"paragon, idol",NULL,"תמונה זו היא מופת לרעיונות האסתטיים של הרנסאנס האיטלקי","checked","#NO","ordan-07 Jul 2004",91240,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (2015,"אֱלֹהִים","n","06888992","yy","dahan","1","rav-milim","1","tg1",NULL,"God",NULL,"בראשית ברא אלוהים את השמים ואת הארץ","checked","#ASSIGN:50=[gnd=13.0,bt(dir)=16.0,dfl=21.0] #MZ@ #IE","eyal-10 Feb 2004, assign-6 Nov 2003",91241,"2004-02-10");
INSERT INTO hebrew_synonyms VALUES (2016,"אֱלוּל","n","10929604","yy","dahan","1","rav-milim","1","tg1","(the twelfth month of the Hebrew calendar)","Elul",NULL,NULL,"checked","#ASSIGN:117.0=[gnd=39.0,glc=27.0,glc=18.0,glc=11.0,glc=14.0,glc=8.0] #MZ@ #IE","eyal-17 Feb 2004, assign-6 Nov 2003",91242,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (2017,"מָן","n","06502515","yy","dahan","1","rav-milim",NULL,"tg1",NULL,"Man, Isle_of_Man",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-26 Jan 2004, assign-6 Nov 2003",91243,"2004-01-26");
INSERT INTO hebrew_synonyms VALUES (2018,"אֲבֵלוּת","n","10077974","y","none",NULL,"rav-milim","1","tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","shuly-10 Jan 2004, assign-6 Nov 2003",91244,"2004-01-10");
INSERT INTO hebrew_synonyms VALUES (2019,"!אֲבַטִּיחַ","n","08469955","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"watermelon",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@","shuly-10 Jan 2004, assign-6 Nov 2003",0,"2004-01-10");
INSERT INTO hebrew_synonyms VALUES (2020,"אֲבַטִּיחַ","n","05792731","yy","melingo","1","rav-milim","1","tg1",NULL,"watermelon",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","shuly-10 Jan 2004, assign-6 Nov 2003",91245,"2004-01-10");
INSERT INTO hebrew_synonyms VALUES (6908,"GAP!","n","02288900","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IN the Heb לוח מודעות is better matched with ''bulletin/notice board''","ordan-07 Jul 2004",90808,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (2022,"!אֲגַם","n","10758043","y","dahan","1","rav-milim",NULL,"tg1",NULL,"lake",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2023,"!אֲגַם","n","10757941","y","dahan","1","rav-milim",NULL,"tg1",NULL,"lake",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2024,"אֲגַם","n","06787575","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"lake",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-16 Feb 2004, assign-6 Nov 2003",91246,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (2025,"אֲגַרְטָל","n","03567934","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"vase",NULL,"מיד כשקיבלה את הפרחים הכניסה אותם לאגרטל","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-14 Feb 2004, assign-6 Nov 2003",91247,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2026,"אֲגוּדָל","n","04313119","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"thumb, pollex",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-15 Feb 2004, assign-6 Nov 2003",91248,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (2027,"בֹּהֶן","n","04321796","yy","melingo","1.1","rav-milim","1.1","tg1","(of foot)","big_toe, great_toe",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,glc=3.0,dfl=8.0] #MZ@\r\n#NO","ordan-15 Feb 2004",91249,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (2028,"!אֲדִיקוּת","n","03783864","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"orthodoxy, devoutness",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO all the coordinate terms of this synset are kinds of ''piety'' adikut. this appears in all their glosses","ordan-16 Feb 2004, assign-6 Nov 2003",0,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (2029,"אָפַּתְיָה","n","03656931","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"indifference, apathy",NULL,"בניגוד לאפתיה המאפיינת אותו, הפגין התלהבות ושמחה רבה במסיבה","revised","#ASSIGN:74.0=[gnd=1.0E+01,gnd=2.0E+01,si=2.0E+01,bt(dir)=12.0,bt(dir)=12.0] #MZ@\r\n#NO ''adishut'' is the behavior itself not the trait (this is a compromise on the part of the Hebrew)","eyal-30 Mar 2004, ordan-14 Feb 2004",91250,"2004-03-30");
INSERT INTO hebrew_synonyms VALUES (2030,"אֲדָר","n","10928324","yy","melingo","1.1","rav-milim","1.1","tg1","(the sixth month of the Hebrew year)","Adar",NULL,NULL,"checked","#ASSIGN:91.0=[gnd=39.0,glc=14.0,glc=18.0,glc=11.0,glc=9.0] #MZ@\r\n#NO","ordan-16 Feb 2004, assign-6 Nov 2003",91251,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (2031,"אֲוִירִי","a","01327490","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"air",NULL,"כוח אווירי","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-14 Feb 2004",91252,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2032,"אֲוִירוֹן","n","02174460","yy","melingo","1.1","rav-milim","1.1","tg1","(US = airplane)","airplane, plane, aeroplane",NULL,NULL,"checked","#ASSIGN:50=[gnd=8.0,gnd=39.0,si=2.0E+01,bt(non)= -34.0,dfl=17.0] #MZ@","ordan-14 Feb 2004, assign-6 Nov 2003",91253,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2033,"אֲוָז","n","01372857","yw","melingo","1.1","rav-milim","1.1","tg1","(male goose)","gander",NULL,NULL,"checked","#ASSIGN:68.0=[gnd=39.0,glc=11.0,glc=18.0] #MZ@\r\n#NO","ordan-14 Feb 2004",91254,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2034,"אֲזִקִּים","n","02791525","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"handcuffs, cuffs",NULL,"הנאשם, כבול באזיקים, הוכנס לבית המשפט","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-14 Feb 2004, assign-6 Nov 2003",91255,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2035,"מְחוֹזִי","a","01057111","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"district",NULL,"בית משפט מחוזי","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-14 Feb 2004, assign-6 Nov 2003",91256,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2036,"שְׁלִיטָה","n","04044520","yy","dahan","1","rav-milim","1.2","tg1",NULL,"grasp, grip",NULL,"הוא היה תחת השליטה של כח חזק ממנו","checked","#ASSIGN:86.0=[gnd=1.0E+01,gnd=8.0,si=8.0,bt(dir)=9.0,bt(dir)=11.0,bt(crs)=2.0E+01,bt(dir)=9.0,bt(dir)=11.0] #MZ@ #IE","eyal-28 Feb 2005, eyal-17 Feb 2004, assign-6 Nov 2003",91257,"2005-02-28");
INSERT INTO hebrew_synonyms VALUES (2037,"אֲחִיזָה","n","00518769","yy","melingo","1","rav-milim","1.1","tg1",NULL,"grasp, hold, grip",NULL,"האחיזה שלה במעקה היתה חזקה מאד","checked","#ASSIGN:71.0=[gnd=1.0E+01,gnd=4.0,gnd=8.0,si=11.0,bt(non)= -5.0,bt(dir)=8.0,bt(dir)=7.0,bt(non)= -6.0,bt(crs)=15.0,bt(non)= -2.0,bt(dir)=8.0,bt(dir)=7.0,bt(non)= -4.0,bt(dir)=8.0,bt(dir)=7.0,bt(non)= -5.0] #MZ@ #IE","eyal-18 Feb 2004, eyal-17 Feb 2004, assign-6 Nov 2003",91258,"2004-02-18");
INSERT INTO hebrew_synonyms VALUES (2038,"!אֲחִיזָה","n","04474097","y","dahan","1","rav-milim",NULL,"tg1",NULL,"grasp, hold, grip",NULL,NULL,"assigned","#ASSIGN:37.0=[gnd=1.0E+01,gnd=4.0,si=8.0,bt(dir)=11.0,bt(non)= -7.0,bt(dir)=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2039,"אֲחָדִים","a","02158584","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"several",NULL,"הבוקר קיבלתי מכתבים אחדים","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-14 Feb 2004, assign-6 Nov 2003",91259,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2040,"!אֲחָדִים","a","01990138","u","dahan","1","rav-milim",NULL,"tg1",NULL,"some, several",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","ordan-14 Feb 2004, assign-6 Nov 2003",0,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2041,"!אֲטִימָה","n","00532187","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"sealing",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","ordan-07 Jul 2004, assign-6 Nov 2003",0,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (2042,"!אֲטִימוּת","n","03866602","nn","dahan","2","rav-milim",NULL,"tg1",NULL,"imperviousness",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO ''atimut'' doesn\'t refer only to liquids, as this synset (as well as all its coordinate terms) does. ","ordan-15 Feb 2004",0,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (2043,"אֲכִילָה","n","00537892","yy","melingo","1.1","rav-milim","1.1","tg1","(act)","eating",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,glc=4.0,dfl=7.0] #MZ@\r\n#NO","ordan-14 Feb 2004, assign-6 Nov 2003",91260,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2044,"אֲכִיפָה","n","00729616","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"enforcement",NULL,"אכיפת החוק האוסר על העתקת דיסקים קשה מאוד לביצוע","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-14 Feb 2004",91261,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2045,"אֲמִינוּת","n","03680488","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"reliability",NULL,"כבר תפסתי אותו בשלושה שקרים - אמינות אינה הצד החזק שלו","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-15 Feb 2004, assign-6 Nov 2003",91262,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (2046,"אֲמִתִּי","a","02342342","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"genuine",NULL,"המניע האמיתי שלה","checked","#ASSIGN:61.0=[gnd=13.0,gnd=4.0,si=4.0,bt(dir)=14.0,bt(non)= -9.0,bt(dir)=3.0,bt(crs)=17.0,bt(dir)=14.0,bt(non)= -2.0,bt(dir)=3.0] #MZ@\r\n#NO","ordan-14 Feb 2004",91263,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2047,"אֲמִתִּי","a","02095155","yy","melingo",">1.1","rav-milim","1.3","tg1",NULL,"true, genuine",NULL,"יש לי עניין אמיתי באנשים","checked","#ASSIGN:51.0=[gnd=2.0,gnd=13.0,si=4.0,bt(dir)=16.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-14 Feb 2004",91263,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2048,"אֲמִתִּי","a","01066794","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"genuine",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO rethiking: it could have been ''mekori'' (esp the examples) but then ''mekori'' fits mroe to ''original''. ","ordan-14 Feb 2004",91263,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2049,"!אֲמִתּוּת","n","03817073","u","dahan","1","rav-milim",NULL,"tg1",NULL,"truthfulness",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IN a rare expression, synonymous to יושר","ordan-07 Jul 2004, assign-6 Nov 2003",0,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (2050,"אֲנָכִי","a","01182362","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"vertical, perpendicular",NULL,"התורן נמצא אנכית לסירה","checked","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@\r\n#NO","ordan-14 Feb 2004",91264,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2051,"אֲנָנָס","n","08907523","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"pineapple",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#NO","ordan-15 Feb 2004, assign-6 Nov 2003",91265,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (2052,"אֲנָנָס","n","05789084","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"pineapple, ananas",NULL,"\r\n","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-15 Feb 2004",91265,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (2053,"אֲנָפָה","n","01519964","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"heron",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-14 Feb 2004, assign-6 Nov 2003",91266,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2054,"!אֲפֻדָּה","n","03454043","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"jumper, sweater",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO afuda is sleeveless","ordan-14 Feb 2004, assign-6 Nov 2003",0,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2055,"אֲרִיגָה","n","00583897","yy","none",NULL,"rav-milim","1.1","tg1","(act)","weaving",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,glc=2.0,dfl=9.0] #MZ@\r\n#NO","ordan-14 Feb 2004, assign-6 Nov 2003",91267,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2056,"!אֲרֻבָּה","n","02902622","u","dahan","1","rav-milim",NULL,"tg1",NULL,"chimney",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#NO ","ordan-14 Feb 2004, assign-6 Nov 2003",0,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2057,"אֲרֻבָּה","n","02430052","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"chimney",NULL,"מרחוק היתמר העשן בארובות","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-14 Feb 2004",91268,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2058,"אֲרוּחָה","n","05627549","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"meal",NULL,"בגלל שנישנש כל הבוקר, כבר לא היה רעב בארוחת הצהריים","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-15 Feb 2004, assign-6 Nov 2003",91269,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (2059,"תַּעֲרֹבֶת","n","05623572","yy","none",NULL,"rav-milim","1.5","tg1",NULL,"meal",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-15 Feb 2004, assign-6 Nov 2003",91270,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (2060,"אֳנִיָּה","n","03318070","yy","dahan","1","rav-milim","1","tg1",NULL,"ship",NULL,"בתערוכה נצפו דגמי אוניות ששמשו כאוניות נוסעים","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE","eyal-01 Feb 2004, assign-6 Nov 2003",91271,"2004-02-01");
INSERT INTO hebrew_synonyms VALUES (2061,"!אִבְחֵן","v","00436039","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2062,"אִבְחֵן","v","00435856","yy","dahan","1","rav-milim","1","tg1",NULL,"diagnose",NULL,"לאחר בדיקות דם הרופא איבחן אצלה אנמיה  ","checked","#ASSIGN:25.0=[gnd=2.0E+01,bt(dir)=19.0,bt(non)= -14.0] #MZ@ #IE","eyal-09 Feb 2004",91272,"2004-02-09");
INSERT INTO hebrew_synonyms VALUES (2063,"אִבְחוּן","n","00099234","yy","melingo","1","rav-milim","1.1","tg1","(med .)","diagnosis",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-02 Feb 2004, assign-6 Nov 2003",91273,"2004-02-02");
INSERT INTO hebrew_synonyms VALUES (2064,"אִוְרֵר","v","00340255","yy","dahan","1","rav-milim","1","tg1",NULL,"ventilate, air",NULL,"הוא פתח את החלונות ואיוורר את החדר הספוג עשן","checked","#ASSIGN:50=[gnd=7.0,gnd=2.0E+01,si=14.0,dfl=9.0] #MZ@ #IE","eyal-08 Feb 2004, assign-6 Nov 2003",91274,"2004-02-08");
INSERT INTO hebrew_synonyms VALUES (2065,"אִזְמֵל","n","02433142","yy","dahan","1","rav-milim","1","tg1",NULL,"chisel",NULL,"הפסל יצר את פסלו בעזרת איזמל בלבד","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-10 Feb 2004",91275,"2004-02-10");
INSERT INTO hebrew_synonyms VALUES (2066,"אִזְמֵל","n","03279791","yy","dahan","2","rav-milim","2","tg1","(med)","scalpel",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-10 Feb 2004, assign-6 Nov 2003",91275,"2004-02-10");
INSERT INTO hebrew_synonyms VALUES (2067,"אִחְסֵן","v","01559786","yy","dahan","1","rav-milim","1","tg1",NULL,"store",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-09 Feb 2004, assign-6 Nov 2003",91276,"2004-02-09");
INSERT INTO hebrew_synonyms VALUES (2068,"אָגַר","v","01559048","yy","dahan","1","rav-milim","1","tg1",NULL,"store, hive_away",NULL,"באיזור הזה לא ניתן לאגור מי גשמים ולנצלם לצרכים חקלאיים","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-11 Feb 2004, assign-6 Nov 2003",91277,"2004-02-11");
INSERT INTO hebrew_synonyms VALUES (2069,"אִחְסֵן","v","01025171","yy","dahan","1","rav-milim","1","tg1",NULL,"stow, store, garner",NULL,"הוא איחסן את בגדי החורף במדף העליון","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-08 Feb 2004, assign-6 Nov 2003",91276,"2004-02-08");
INSERT INTO hebrew_synonyms VALUES (2070,"אִחֵד","v","01682716","yy","dahan","1","rav-milim","2","tg1",NULL,"unite, unify",NULL,"איחד אותנו עיקרון אחד","checked","#ASSIGN:25.0=[gnd=8.0,gnd=1.0E+01,si=16.0,bt(non)= -9.0] #MZ@ #IE","eyal-08 Feb 2004, assign-6 Nov 2003",91278,"2004-02-08");
INSERT INTO hebrew_synonyms VALUES (2071,"הִתְאַחֵד","v","00257011","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"unify, unite, merge",NULL,"גרמניה התאחדה רשמית בשנת 1990","checked","#ASSIGN:25.0=[gnd=8.0,gnd=1.0E+01,si=16.0,bt(non)= -9.0] #MZ@ #IE","eyal-19 Jun 2004, eyal-08 Feb 2004, assign-6 Nov 2003",91279,"2004-06-19");
INSERT INTO hebrew_synonyms VALUES (2072,"אִחֵד","v","00166362","yy","dahan","1","rav-milim","1","tg1",NULL,"unite, unify, merge",NULL,"איחדנו את כוחותינו","checked","#ASSIGN:25.0=[gnd=8.0,gnd=1.0E+01,si=16.0,bt(non)= -9.0] #MZ@ #IE","eyal-08 Feb 2004",91278,"2004-02-08");
INSERT INTO hebrew_synonyms VALUES (2073,"אִחוּד","n","00245212","yy","dahan","1","rav-milim","1","tg1","(act)","unification",NULL,"הלהקה הותיקה החליטה על איחוד לקראת הופעה משותפת","checked","#ASSIGN:27.0=[gnd=2.0E+01,glc=2.0,bt(dir)=5.0] #MZ@ #IE","eyal-09 Feb 2004, assign-6 Nov 2003",91280,"2004-02-09");
INSERT INTO hebrew_synonyms VALUES (2074,"!אִחוּד","n","06598174","y","dahan","2","rav-milim",NULL,"tg1",NULL,"union",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2075,"אִי","n","06741251","yy","dahan","1","rav-milim","1","tg1",NULL,"island",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-11 Feb 2004, assign-6 Nov 2003",90884,"2004-02-11");
INSERT INTO hebrew_synonyms VALUES (6443,"אוֹת","n","06665028","yy",NULL,NULL,"rav-milim","3",NULL,NULL,"signal",NULL,"הניצחון היה האות להתחיל בחגיגות","checked","#IE","eyal-11 Feb 2004",90948,"2004-02-11");
INSERT INTO hebrew_synonyms VALUES (2077,"אִינְסְטֶלָטוֹר","n","07482774","yy","dahan","1","rav-milim","1","tg1",NULL,"plumber",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-09 Feb 2004, assign-6 Nov 2003",91281,"2004-02-09");
INSERT INTO hebrew_synonyms VALUES (2079,"אִישִׁיּוּת","n","07469416","yy","dahan","1","rav-milim","2","tg1",NULL,"personality",NULL,"הוא אישיות מוכרת מאד בהוליווד","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-08 Feb 2004, assign-6 Nov 2003",91282,"2004-02-08");
INSERT INTO hebrew_synonyms VALUES (2080,"אִישִׁיּוּת","n","03643456","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"personality",NULL,"לתנאים הקשים בהם גדל היה חלק עיקרי בעיצוב האישיות שלו","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-23 Jun 2005, eyal-08 Feb 2004, assign-6 Nov 2003",91282,"2005-06-23");
INSERT INTO hebrew_synonyms VALUES (2081,"אִישִׁית","r","00128086","yy","dahan","1","rav-milim","1","tg1",NULL,"personally, in_person",NULL,"אני אישית הלכתי לשם","checked","#ASSIGN:67.0=[gnd=8.0,gnd=39.0,si=2.0E+01] #MZ@ #IE","eyal-09 Feb 2004, assign-6 Nov 2003",91283,"2004-02-09");
INSERT INTO hebrew_synonyms VALUES (2082,"אִכְזֵב","v","01227336","yy","dahan","1","rav-milim","1","tg1",NULL,"disappoint, let_down",NULL,"המשחק הזה איכזב אותי - הייתי בטוח שהוא מעניין הרבה יותר","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-09 Feb 2004, assign-6 Nov 2003",91284,"2004-02-09");
INSERT INTO hebrew_synonyms VALUES (2083,"אִכָּר","n","07256794","n","dahan","1","rav-milim","1","tg1",NULL,"farmer",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE gender","eyal-26 Jun 2005, eyal-09 Feb 2004, assign-6 Nov 2003",0,"2005-06-26");
INSERT INTO hebrew_synonyms VALUES (2084,"אִלְתֵּר","v","01183358","yy","dahan","1","rav-milim","2","tg1",NULL,"improvise",NULL,"הנגנים לא התכוננו להופיע, אך הצליחו לאלתר קטע נגינה יפה במיוחד","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-09 Feb 2004, assign-6 Nov 2003",91286,"2004-02-09");
INSERT INTO hebrew_synonyms VALUES (2085,"אִלְתּוּר","n","00116556","yy","dahan","1","rav-milim","1","tg1",NULL,"improvisation",NULL,"מהותו של האילתור היא המצאה וחשיבה מהירה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE ","eyal-05 Feb 2004, assign-6 Nov 2003",91287,"2004-02-05");
INSERT INTO hebrew_synonyms VALUES (2086,"אִלְתּוּר","n","00062947","yy","dahan","1","rav-milim","2","tg1",NULL,"improvisation",NULL,"בחוג לדרמה הילדים התאמנו באלתורים על נושא היחסים בין מורה לתלמיד","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-05 Feb 2004, assign-6 Nov 2003",91287,"2004-02-05");
INSERT INTO hebrew_synonyms VALUES (2087,"אִלֵּף","v","00138377","yy","dahan","1","rav-milim","1","tg1",NULL,"tame",NULL,"הוא אילף את הכלב עד שנעשה צייתן וממושמע","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-11 Feb 2004",91288,"2004-02-11");
INSERT INTO hebrew_synonyms VALUES (2088,"אִמָּא","n","07385387","yy","dahan","2","rav-milim","2","tg1",NULL,"mum, mummy",NULL,"הילדה נראית בדיוק כמו אמא שלה","checked","#ASSIGN:57.0=[gnd=13.0,gnd=2.0E+01,si=24.0] #MZ@ #IE","eyal-09 Feb 2004, assign-6 Nov 2003",91289,"2004-02-09");
INSERT INTO hebrew_synonyms VALUES (2089,"אִמָּהִי","a","01672406","yy","dahan","1","rav-milim","1","tg1",NULL,"maternal, motherly",NULL,"הוא עורר בה את הרצון להעניק לו חיבוק אימהי חם","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-05 Feb 2004, assign-6 Nov 2003",91290,"2004-02-05");
INSERT INTO hebrew_synonyms VALUES (2090,"אִמָּהוּת","n","09949956","yy","dahan","1","rav-milim","1","tg1",NULL,"motherhood, maternity",NULL,"מאז שנולד בנה, האימהות ממלאת את כל עולמה","checked","#ASSIGN:176.0=[gnd=39.0,gnd=39.0,si=98.0] #MZ@ #IE","eyal-09 Feb 2004, assign-6 Nov 2003",91291,"2004-02-09");
INSERT INTO hebrew_synonyms VALUES (2091,"דֶּרֶךְ-אֶרֶץ","n","03851783","yy","melingo","5","rav-milim","1.1","tg1",NULL,"breeding",NULL,"בית הספר פועל למניעת אלימות, ושורר בו אקלים של דרך ארץ וכבוד הדדי","checked","#ASSIGN:25.0=[gnd=2.0E+01,bt(non)= -14.0,bt(dir)=19.0] #MZ@\r\n#IE it can match to ''courtesy'', so this decision is a bit arbitrary, however, ''courtesy'' can be easily solved with נימוסים, הליכות","ordan-16 Mar 2004",91292,"2004-03-16");
INSERT INTO hebrew_synonyms VALUES (2093,"!אִמּוּן","n","00173771","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"training, coaching",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE (we wouldn\'t say about an NBA coach that he\'s working in אימון but rather that he\'s a מאמן)","ordan-16 Mar 2004, assign-6 Nov 2003",0,"2004-03-16");
INSERT INTO hebrew_synonyms VALUES (2096,"הַכְשָׁרָה","n","00574678","yy","dahan","1","rav-milim","1","tg2",NULL,"training, preperation",NULL,"כל עובד חדש חייב לעבור את התוכנית להכשרת עובדים חדשים","checked","#ASSIGN:25.0=[gnd=2.0E+01,bt(dir)=19.0,bt(non)= -14.0] #MZ@ #IE","eyal-05 Feb 2004",91293,"2004-02-05");
INSERT INTO hebrew_synonyms VALUES (2097,"אִסּוּף","n","00654309","yy","dahan","1","rav-milim","1","tg1",NULL,"collecting, gathering",NULL,"הגננת ביקשה מהילדים לאסוף את כל הצעצועים הפזורים","checked","#ASSIGN:51.0=[gnd=39.0,bt(dir)=12.0] #MZ@ #IE","eyal-10 Feb 2004, assign-6 Nov 2003",91294,"2004-02-10");
INSERT INTO hebrew_synonyms VALUES (2098,"!אִסּוּר","n","04911144","y","dahan","1","rav-milim",NULL,"tg1",NULL,"ban, prohibition",NULL,NULL,"assigned","#ASSIGN:71.0=[gnd=13.0,gnd=1.0E+01,si=16.0,bt(dir)=16.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2100,"אִסּוּר","n","05414897","yy","dahan","1","rav-milim","1","tg1",NULL,"ban, prohibition",NULL,"חל איסור חמור לחנות בתחנות אוטובוס","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-09 Feb 2004, assign-6 Nov 2003",91295,"2004-02-09");
INSERT INTO hebrew_synonyms VALUES (2102,"אִפּוּר","n","02961095","yy","dahan","1","rav-milim","2","tg1",NULL,"make-up",NULL,"פניו של הליצן היו מכוסים באיפור צבעוני","checked","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=19.0,dfl=11.0] #MZ@ #IE","eyal-08 Feb 2004",91296,"2004-02-08");
INSERT INTO hebrew_synonyms VALUES (2103,"אִרְגּוּנִי","a","02678888","yy","dahan","1","rav-milim","1","tg1",NULL,"organizational",NULL,"מבנה אירגוני","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-10 Feb 2004, assign-6 Nov 2003",91297,"2004-02-10");
INSERT INTO hebrew_synonyms VALUES (2104,"עוֹזֶרֶת","n","07151308","yy","dahan","1","rav-milim","1","tg1",NULL,"cleaning_woman, cleaning_lady",NULL,"העוזרת שלי מגיעה בימי שלישי לנקות את הבית","checked","#ASSIGN:50=[gnd=1.0E+01,bt(dir)=9.0,bt(dir)=8.0,bt(crs)=17.0,dfl=6.0] #MZ@ #IE","eyal-11 Feb 2004, assign-6 Nov 2003",91298,"2004-02-11");
INSERT INTO hebrew_synonyms VALUES (2105,"אִשְׁפֵּז","v","01603822","yy","dahan","1","rav-milim","1","tg1",NULL,"hospitalize",NULL,"הרופא אישפז אותו עקב לחץ דם גבוה מאד","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-08 Feb 2004, assign-6 Nov 2003",91299,"2004-02-08");
INSERT INTO hebrew_synonyms VALUES (2106,"אִשְׁפּוּז","n","00430554","yy","dahan","1","rav-milim","1","tg1",NULL,"hospitalization",NULL,"לאחר הניתוח החולה היה זקוק לאשפוז ארוך","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-05 Feb 2004, assign-6 Nov 2003",91300,"2004-02-05");
INSERT INTO hebrew_synonyms VALUES (2107,"אִתּוּת","n","06665028","yy","dahan","1","rav-milim","2","tg2",NULL,"signal",NULL,"לא קיבלנו ממנו שום איתות להתחיל בפעולה","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-11 Feb 2004, assign-6 Nov 2003",91301,"2004-02-11");
INSERT INTO hebrew_synonyms VALUES (2109,"טְחָב","n","07857465","yy","dahan","1","rav-milim","1","tg1",NULL,"moss",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ #IE","eyal-11 Feb 2004, assign-6 Nov 2003",91302,"2004-02-11");
INSERT INTO hebrew_synonyms VALUES (2110,"אֵימָה","n","05591377","yy","dahan","1","rav-milim","1","tg1",NULL,"terror, panic",NULL,"הרצח זעזע את הקהילה והכה אותה בכאב ואימה","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-11 Feb 2004, assign-6 Nov 2003",91303,"2004-02-11");
INSERT INTO hebrew_synonyms VALUES (2111,"חֲשָׁשׁ","n","05591792","yy","oxford","1.1","sapir","1.2","tg1",NULL,"apprehension",NULL,"התלמידים הביטו בבחינות בחשש","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-22 Aug 2004, eyal-11 Feb 2004",91091,"2004-08-22");
INSERT INTO hebrew_synonyms VALUES (2112,"אֱלֹהִים","n","07293144","yy","dahan","1","rav-milim","2","tg1",NULL,"God",NULL,"הוא היה האלוהים שלה, היא לא עשתה צעד בלעדיו","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-10 Feb 2004, assign-6 Nov 2003",91241,"2004-02-10");
INSERT INTO hebrew_synonyms VALUES (2113,"אֵרֵח","v","00812388","yy","dahan","2","rav-milim","1","tg1",NULL,"host",NULL,"אשתי ואני ארחנו ארבעה זוגות לארוחת ערב אתמול","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-11 Feb 2004, assign-6 Nov 2003",91304,"2004-02-11");
INSERT INTO hebrew_synonyms VALUES (2114,"אֵשֶׁל","n","08689752","yy","dahan","1","rav-milim","1","tg1","(tree)","tamarisk",NULL,NULL,"checked","#ASSIGN:53.0=[gnd=39.0,glc=14.0] #MZ@ #IE","eyal-10 Feb 2004, assign-6 Nov 2003",91305,"2004-02-10");
INSERT INTO hebrew_synonyms VALUES (2115,"אֶבְיוֹן","n","07463556","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"pauper, poor_man",NULL,NULL,"checked","#ASSIGN:176.0=[gnd=39.0,gnd=39.0,si=98.0] #MZ@\r\n#NO","ordan-13 Feb 2004",91306,"2004-02-13");
INSERT INTO hebrew_synonyms VALUES (2116,"אֶבֶן","n","10534851","yy","melingo","1","rav-milim","1","tg1","(US = rock)","stone, rock",NULL,NULL,"checked","#ASSIGN:34.0=[gnd=6.0,bt(dir)=8.0,bt(dir)=6.0,bt(crs)=14.0] #MZ@\r\n#NO note the very fine difference between ''even'' and ''sela'' - it is not fairly demarcated in Rav Milim, check Even-Shushan - in English: stone is the material of which rocks are made, and rocks are the minerals that make up part of the Earth\'s curst. ","shuly-10 Jan 2004",91307,"2004-01-10");
INSERT INTO hebrew_synonyms VALUES (2117,"אֶבֶן","n","06669293","yy","melingo","1","rav-milim","1.2","tg1","(US = rock)","stone, rock",NULL,"הוא יידה בי את האבן!","checked","#ASSIGN:36.0=[gnd=6.0,bt(dir)=9.0,bt(dir)=6.0,bt(crs)=15.0] #MZ@\r\n#NO","shuly-10 Jan 2004, assign-6 Nov 2003",91307,"2004-01-10");
INSERT INTO hebrew_synonyms VALUES (2118,"אֶגְרוֹף","n","04311659","yy","melingo","1","rav-milim","1.1","tg1",NULL,"fist",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-12 Feb 2004, assign-6 Nov 2003",91308,"2004-02-12");
INSERT INTO hebrew_synonyms VALUES (2119,"אֶדֶן","n","03503032","yy","melingo","1","rav-milim","1.2","tg1","(of railway track)","tie, railroad_tie, sleeper",NULL,NULL,"checked","#ASSIGN:50=[gnd=1.0E+01,glc=27.0,glc=4.0,bt(non)= -7.0,dfl=16.0] #MZ@\r\n#NO","ordan-12 Feb 2004, assign-6 Nov 2003",91309,"2004-02-12");
INSERT INTO hebrew_synonyms VALUES (8687,"GAP!","n","07157546","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE gender","eyal-26 Jun 2005",90808,"2005-06-26");
INSERT INTO hebrew_synonyms VALUES (8688,"אֶזְרָח","n","H0003969","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"citizen",NULL,NULL,"checked","#IE","eyal-26 Jun 2005",90900,"2005-06-26");
INSERT INTO hebrew_synonyms VALUES (2122,"!אֶזְרָח","n","06952517","u","dahan","3","rav-milim",NULL,"tg1",NULL,"national",NULL,NULL,"checked","#ASSIGN:51.0=[gnd=39.0,bt(dir)=39.0,bt(non)= -27.0] #MZ@\r\n#NO it agrees roughly with RM 1.1, but whereas RM has only 2 senses, and i think that ''natin'' is more apporpriate to demarcate it from the two senses of ''ezrach''.","ordan-12 Feb 2004, assign-6 Nov 2003",0,"2004-02-12");
INSERT INTO hebrew_synonyms VALUES (6515,"GAP!","n","00173771","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE","ordan-16 Mar 2004",90808,"2004-03-16");
INSERT INTO hebrew_synonyms VALUES (2124,"אֶזְרָחִי","a","01454970","yy","melingo","1","rav-milim","1.1","tg1",NULL,"civilian",NULL,"המוסר האזרחי שונה מהמוסר הצבאי","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO referring to the latter part of RM\'s definition","ordan-07 Jul 2004, ordan-09 Feb 2004, assign-6 Nov 2003",90901,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (2125,"!אֶפֶס","n","09893668","nn","dahan","1","rav-milim",NULL,"tg1","(in football)","nil",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO this synset is american specific. ","ordan-14 Feb 2004, assign-6 Nov 2003",0,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (6451,"GAP!","n","09893668","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked",NULL,"ordan-14 Feb 2004",90808,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2129,"אֶפֶס","n","09894639","yy","melingo",">1.1","rav-milim","1.1","tg1",NULL,"zero, nought",NULL,NULL,"checked","#ASSIGN:25.0=[gnd=2.0E+01,bt(dir)=19.0,bt(non)= -14.0] #MZ@\r\n#NO","ordan-13 Feb 2004, assign-6 Nov 2003",91310,"2004-02-13");
INSERT INTO hebrew_synonyms VALUES (2130,"אֶפֶס","n","09893278","yy","melingo",">1","rav-milim","1.5A","tg1",NULL,"nothing, nil, nix, nada, aught, cipher, cypher, goose_egg, naught, zero, zilch, zip",NULL,"אפס - זה מה שנותר מכל פועלו","checked","#ASSIGN:73.0=[gnd=2.0E+01,bt(dir)=17.0,bt(non)= -11.0,bt(dir)=15.0,bt(crs)=32.0] #MZ@\r\n#NO in fact, maybe the only quivalent to this sysnet is ''shum-davar'' - reconsider","ordan-14 Feb 2004, assign-6 Nov 2003",91310,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (2131,"אֶצְבַּע","n","09817148","yy","none",NULL,"rav-milim","1.4","tg1",NULL,"finger, fingerbreadth, digit",NULL,NULL,"checked","#ASSIGN:50=[gnd=8.0,bt(dir)=7.0,bt(dir)=11.0,bt(crs)=18.0,dfl=6.0] #MZ@\r\n#NO","ordan-13 Feb 2004, assign-6 Nov 2003",91311,"2004-02-13");
INSERT INTO hebrew_synonyms VALUES (2132,"אֶקְדָּח","n","03131514","yy","melingo","1","rav-milim","1.1","tg1",NULL,"pistol, handgun",NULL,"אקדח קל יותר לנשיאה אך מדויק פחות מן הרובה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-12 Feb 2004, assign-6 Nov 2003",91312,"2004-02-12");
INSERT INTO hebrew_synonyms VALUES (2133,"!אֶרֶז","n","07947238","y","dahan","1","rav-milim",NULL,"tg1","(tree)","cedar",NULL,NULL,"assigned","#ASSIGN:34.0=[gnd=13.0,glc=8.0,bt(dir)=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2134,"אֶרֶז","n","07940800","yy","melingo","1.1","none",NULL,"tg1","(tree)","cedar, cedarwood",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-13 Feb 2004, assign-6 Nov 2003",91313,"2004-02-13");
INSERT INTO hebrew_synonyms VALUES (2135,"אֶרֶז","n","07940601","yy","melingo","1.1","rav-milim","1.1","tg1","(tree)","cedar, cedar_tree",NULL,NULL,"checked","#ASSIGN:32.0=[gnd=13.0,glc=8.0,bt(dir)=11.0] #MZ@\r\n#NO","ordan-13 Feb 2004, assign-6 Nov 2003",91313,"2004-02-13");
INSERT INTO hebrew_synonyms VALUES (2136,"אַבָּהוּת","n","09949831","yy","melingo","1","rav-milim","1.1","tg1",NULL,"paternity, fatherhood",NULL,"ככל שגדלו ילדיו התחזק רגש האבהות שחש כלפיהם","checked","#ASSIGN:142.0=[gnd=39.0,gnd=39.0,si=98.0,bt(non)= -34.0] #MZ@\r\n#NO","ordan-02 Feb 2004",91314,"2004-02-02");
INSERT INTO hebrew_synonyms VALUES (2137,"אַבְחָנָה","n","00099234","yy","melingo","1","none",NULL,"tg2","(med .)","diagnosis",NULL,"הילד, שנתקשה בלימודי הקריאה, נשלח לאבחון","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO doesn\'t appear in RM, but does in Even-Sushan (sense n.3). ","ordan-02 Feb 2004",91315,"2004-02-02");
INSERT INTO hebrew_synonyms VALUES (2138,"אַבְטָלָה","n","10063667","yy","melingo","1","rav-milim","1","tg1",NULL,"unemployment",NULL,"שיעור האבטלה הוא אמת-מידה לבריאות החברה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO Example taken from WordNet","shuly-10 Jan 2004, assign-6 Nov 2003",91316,"2004-01-10");
INSERT INTO hebrew_synonyms VALUES (2139,"אַבִּיר","n","07358345","yy","melingo","1","rav-milim",">1","tg1",NULL,"knight",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-09 Feb 2004",91317,"2004-02-09");
INSERT INTO hebrew_synonyms VALUES (2140,"אַבִּירוּת","n","06207397","yy","melingo","1","rav-milim","1.1","tg1",NULL,"knighthood",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-09 Feb 2004, assign-6 Nov 2003",91318,"2004-02-09");
INSERT INTO hebrew_synonyms VALUES (2141,"אַבָּא","n","07199293","yy","none",NULL,"rav-milim","2","tg1",NULL,"dad, dada, daddy, old_man, pa, papa, pappa, pater, pop",NULL,"אבא, מה תביא לי ליום-הולדת?","checked","#ASSIGN:374.0=[gnd=39.0,gnd=39.0,si=98.0,bt(dir)=33.0,bt(dir)=33.0,bt(crs)=66.0,bt(dir)=33.0,bt(dir)=33.0] #MZ@\r\n#NO I can\'t think about Hebrew synonyms, and in English there are so many. ","shuly-10 Jan 2004, assign-6 Nov 2003",91319,"2004-01-10");
INSERT INTO hebrew_synonyms VALUES (2142,"אַבּוּב","n","03050496","yy","melingo","1","rav-milim","1.1","tg1","(musical instrument)","oboe",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-01 Feb 2004, assign-6 Nov 2003",91320,"2004-02-01");
INSERT INTO hebrew_synonyms VALUES (2143,"!אַבּוּב","n","02858210","nn","dahan","2","rav-milim",NULL,"tg1","(of tyre)","inner_tube",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO doesn\'t appear in RM in this sense. Oboe has biblical meanings though","ordan-01 Feb 2004, assign-6 Nov 2003",0,"2004-02-01");
INSERT INTO hebrew_synonyms VALUES (2144,"אַגָּדִי","a","01867171","yy","melingo","1","rav-milim","1.1","tg1",NULL,"legendary",NULL,"דמותו האגדית של הגולם מפראג מככבת בסיפורים רבים","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-04 Feb 2004",91321,"2004-02-04");
INSERT INTO hebrew_synonyms VALUES (2145,"אַגָּדָתִי","a","01321645","yy","melingo","1","rav-milim","1.1","tg1",NULL,"legendary",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-03 Feb 2004, assign-6 Nov 2003",91322,"2004-02-03");
INSERT INTO hebrew_synonyms VALUES (2146,"אַגָּדָה","n","04803389","yy","dahan","1","rav-milim","1","tg1",NULL,"legend",NULL,"הילד אהב במיוחד לשמוע את האגדה על פינוקיו","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ # IE","shuly-11 Jan 2004",91323,"2004-01-11");
INSERT INTO hebrew_synonyms VALUES (2147,"מִקְרָא","n","04785610","nn","dahan","1","rav-milim","2","tg1",NULL,"legend",NULL,"המקרא במפה זו אינו ברור","revised","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE\r\n#NO ","ordan-07 Dec 2004, shuly-14 Jan 2004, assign-6 Nov 2003",91324,"2004-12-07");
INSERT INTO hebrew_synonyms VALUES (2148,"אַגָּס","n","08951407","yy","melingo","1","rav-milim","1.2","tg1","(tree and fruit)","pear, pear_tree, Pyrus_communis",NULL,NULL,"checked","#ASSIGN:79.0=[gnd=2.0E+01,glc=14.0,glc=8.0,glc=11.0,glc=7.0,bt(dir)=19.0] #MZ@\r\n#NO","ordan-01 Feb 2004, assign-6 Nov 2003",91325,"2004-02-01");
INSERT INTO hebrew_synonyms VALUES (2149,"אַגָּס","n","05803355","yy","melingo","1","rav-milim","1.1","tg1","(tree and fruit)","pear",NULL,NULL,"checked","#ASSIGN:62.0=[gnd=2.0E+01,glc=11.0,glc=7.0,bt(dir)=24.0] #MZ@\r\n#NO","ordan-01 Feb 2004, assign-6 Nov 2003",91325,"2004-02-01");
INSERT INTO hebrew_synonyms VALUES (2150,"אַדִּיר","a","01755567","y","melingo","1","rav-milim","1.1","tg1",NULL,"mighty",NULL,"במכה אדירה שבר את השולחן","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-21 Jan 2004",91326,"2004-01-21");
INSERT INTO hebrew_synonyms VALUES (2151,"!אַדֶּמֶת","n","10160247","y","dahan","1","rav-milim",NULL,"tg1",NULL,"measles, German_measles",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2152,"!אַדֶּמֶת","n","10160032","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"measles, German_measles",NULL,NULL,"revised","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO am not sure, it shares the same definition in RM with chatzevet, but they don\'t appear as synonyms\r\n#SW Measles is  חצבת, Iris claims\r\n","wintner-20 Sep 2004, ordan-01 Feb 2004",0,"2004-09-20");
INSERT INTO hebrew_synonyms VALUES (2153,"אַזְהָרָה","n","05395080","yy","melingo","1","rav-milim","1.2","tg1",NULL,"warning",NULL,"בשל אזהרה על מפולת שלגים צפויה, נסגר אתר הסקי לגולשים","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IN","ordan-07 Jul 2004",91327,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (2154,"אַזְהָרָה","n","05003120","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"admonition, warning",NULL,"הוא שעה לאזהרת הרופא והפסיק לעשן","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IN refers to the latter part of RM\'s definition ","ordan-07 Jul 2004",91327,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (2155,"אַחְיָן","n","07430196","yy","dahan","1","rav-milim","1.1","tg1",NULL,"nephew",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-01 Feb 2004",91328,"2004-02-01");
INSERT INTO hebrew_synonyms VALUES (2156,"אַחְיָנִית","n","07432658","yy","melingo","1","rav-milim","1.1","tg1",NULL,"niece",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-01 Feb 2004, assign-6 Nov 2003",91329,"2004-02-01");
INSERT INTO hebrew_synonyms VALUES (2157,"!אַחֲוָה","n","06019148","y","dahan","1","rav-milim",NULL,"tg1",NULL,"brotherhood, fraternity",NULL,NULL,"assigned","#ASSIGN:5.0E+01=[gnd=1.0E+01,gnd=2.0E+01,si=2.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2158,"אַחֶרֶת","r","00110511","yy","dahan","1","rav-milim","1","tg1",NULL,"otherwise, differently",NULL,"היא חשבה אחרת ממני","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-17 Feb 2004, assign-6 Nov 2003",91330,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (2159,"!אַחֶרֶת","r","00044456","y","dahan","1","rav-milim",NULL,"tg1",NULL,"otherwise",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2160,"אַיָּלָה","n","01927508","yy","none",NULL,"rav-milim","1.1","tg1","(female deer)","hind",NULL,NULL,"checked","#ASSIGN:118.0=[gnd=2.0E+01,glc=11.0,glc=54.0,glc=33.0] #MZ@\r\n#NO","ordan-31 Jan 2004, assign-6 Nov 2003",91331,"2004-01-31");
INSERT INTO hebrew_synonyms VALUES (2161,"אַכְזָבָה","n","05605549","yy","melingo","1","rav-milim","1.1","tg1",NULL,"disappointment",NULL,"עם ציפיות כה גבוהות ברור שנכונה לך אכזבה בסוף","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO watch out, there\'s another synset for disappointment!","ordan-21 Jan 2004",91332,"2004-01-21");
INSERT INTO hebrew_synonyms VALUES (2162,"!אַכְזָבָה","n","00040483","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"disappointment",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-21 Jan 2004, assign-6 Nov 2003",0,"2004-01-21");
INSERT INTO hebrew_synonyms VALUES (6395,"מַר","n","07414666","yy",NULL,NULL,"rav-milim","1",NULL,NULL,"mister",NULL,"מר כהן, גש בבקשה לקופה הראשית","checked","#IE","eyal-22 Jan 2004",91333,"2004-01-22");
INSERT INTO hebrew_synonyms VALUES (2164,"אַכְזָרִי","a","01211817","yy","melingo","1","rav-milim","1","tg1",NULL,"cruel, brutal, vicious",NULL,"השבויים עונו באכזריות","checked","#ASSIGN:36.0=[gnd=1.0E+01,gnd=13.0,si=24.0,bt(non)= -11.0] #MZ@\r\n#NO","ordan-21 Jan 2004, assign-6 Nov 2003",91334,"2004-01-21");
INSERT INTO hebrew_synonyms VALUES (2165,"אַכְסַנְיַת-נֹעַר","n","02835429","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"hostel, inn",NULL,"כשעברנו את הגבול בין צרפת לגרמניה נשארנו ללון באכסנייה","checked","#ASSIGN:25.0=[gnd=2.0E+01,bt(dir)=19.0,bt(non)= -14.0] #MZ@\r\n#NO","eyal-30 Mar 2004",91335,"2004-03-30");
INSERT INTO hebrew_synonyms VALUES (2166,"מְעוֹנוֹת","n","02835270","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"hostel, youth_hostel, student_lodging",NULL,NULL,"checked","#ASSIGN:37.0=[gnd=2.0E+01,bt(dir)=17.0] #MZ@\r\n#NO not under hypernym of ''tourist'' but rather under ''diyur'', note the gloss (/supervised/), therefore achsania is inappropriate. i go for ''me\'onot'' (dormitory in WN is only for students (in Hebrew the case is different) (also, there\'s me\'onot of na\'amat etc)","ordan-08 Feb 2004",91336,"2004-02-08");
INSERT INTO hebrew_synonyms VALUES (2167,"!אַלְמָן","a","01421595","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"widowed",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO there\'s no such adj, not ''sex neutral'' anyway","ordan-21 Jan 2004, assign-6 Nov 2003",0,"2004-01-21");
INSERT INTO hebrew_synonyms VALUES (2168,"אַלְמָן","n","07681060","yy","melingo","1","rav-milim","1.1","tg1",NULL,"widower",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-21 Jan 2004, assign-6 Nov 2003",91337,"2004-01-21");
INSERT INTO hebrew_synonyms VALUES (2169,"אַלְמָנָה","n","07680892","yy","melingo","1","rav-milim","1.1","tg1",NULL,"widow",NULL,"האלמנה מבקרת את קבר בעלה מדי שנה","checked","#ASSIGN:78.0=[gnd=39.0,bt(dir)=39.0] #MZ@\r\n#NO","ordan-01 Feb 2004",91338,"2004-02-01");
INSERT INTO hebrew_synonyms VALUES (2170,"!אַלִּימוּת","n","10070833","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"violence",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-08 Feb 2004, assign-6 Nov 2003",0,"2004-02-08");
INSERT INTO hebrew_synonyms VALUES (6912,"GAP!","n","03933665","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IN equivalents could be פראיות or פראות but this denotes a combination of ''cruelty'' and ''wildness'', does not exist in Heb","ordan-07 Jul 2004",90808,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (2172,"גִּבּוּי","n","00786967","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"backing",NULL,"הדרג המשפטי נתן גיבוי כמעט מלא לפעולותיו של הדרג המדיני והצבאי ","revised","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO consider חסות as well, especially to convey the nuance of ''patronage'' (however, that can be also matched to another ''patronage'' - n#00747710)","eyal-12 Aug 2004, ordan-16 Mar 2004",91339,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (2173,"אַלּוֹן","n","08572627","yy","melingo","1","rav-milim","1.1","tg1","(tree)","oak",NULL,NULL,"checked","#ASSIGN:34.0=[gnd=2.0E+01,glc=14.0] #MZ@\r\n#NO","ordan-03 Feb 2004, assign-6 Nov 2003",91340,"2004-02-03");
INSERT INTO hebrew_synonyms VALUES (2174,"אַלּוּף","n","07147536","n","melingo","1","rav-milim","1.2","tg1","(sport)","champion, champ",NULL,"שנים רבות החזיק בתואר אלוף העולם בקפיצה לרוחק","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO\r\n#IE gender","eyal-26 Jun 2005, ordan-01 Feb 2004",0,"2005-06-26");
INSERT INTO hebrew_synonyms VALUES (2175,"!אַלּוּף","n","07388553","y","dahan","2","rav-milim",NULL,"tg1","(mil)","major-general",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2176,"!אַלּוּף_מִשְׁנֶה","n","07166351","y","dahan","1","rav-milim",NULL,"tg1","(mil)","colonel",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2177,"אַמְבַּטְיָה","n","02263808","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"bathroom, bath",NULL,NULL,"revised","#ASSIGN:62.0=[gnd=8.0,bt(dir)=19.0,bt(dir)=8.0,bt(crs)=27.0] #MZ@\r\n#NO in rav-milim this meaining converges with the meaning of ''tub'' or ''ambatya'' denoting the room in which the tub is located (i beg to differ: in hebrew it\'s cheder ambatya)\r\n#IE refers to the second part of RM\'s definition","eyal-23 Jun 2005, eyal-30 Mar 2004, ordan-21 Jan 2004",91342,"2005-06-23");
INSERT INTO hebrew_synonyms VALUES (2179,"אַמְבַּטְיָה","n","00165598","yy","melingo","1","rav-milim","1.2","tg1","(US = bathtub)","bath",NULL,"אני עושה אמבטיה כל בוקר!","checked","#ASSIGN:72.0=[gnd=8.0,glc=54.0,bt(dir)=1.0E+01] #MZ@\r\n#NO","ordan-21 Jan 2004",91342,"2004-01-21");
INSERT INTO hebrew_synonyms VALUES (6387,"מְקֻלָּל","a","00632302","yy",NULL,NULL,"rav-milim","1",NULL,NULL,"accursed",NULL,"איש מאתנו אינו נולד מקולל","checked","#IE","eyal-21 Jan 2004",90949,"2004-01-21");
INSERT INTO hebrew_synonyms VALUES (2181,"אַמִּיץ","a","00258473","y","melingo","1","rav-milim","1","tg1",NULL,"brave, courageous",NULL,NULL,"checked","#ASSIGN:96.0=[gnd=13.0,gnd=39.0,si=12.0,bt(dir)=16.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-20 Jan 2004, assign-6 Nov 2003",91343,"2004-01-20");
INSERT INTO hebrew_synonyms VALUES (2182,"אַמִּיץ-לֵב","a","00246712","yy","melingo","1","rav-milim","1.1","tg1",NULL,"audacious, brave, dauntless, fearless, intrepid, unfearing",NULL,"הגיבורים אמיצי הלב יצאו לקרב","revised","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO more idiomatic, stressting the lack of fear, have a look at even-shusan, stresses its heroism","eyal-30 Mar 2004, ordan-22 Jan 2004",91344,"2004-03-30");
INSERT INTO hebrew_synonyms VALUES (2183,"אַנָּס","n","07519749","yy","melingo","1","rav-milim","1.1","tg1",NULL,"rapist, raper",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-01 Feb 2004",91345,"2004-02-01");
INSERT INTO hebrew_synonyms VALUES (2184,"אַסְפָּקָה","n","00684444","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"provision, providing, supplying",NULL,"האספקה לא תגיע היום ולכן נשתמש במה שנשאר","revised","#ASSIGN:50=[gnd=13.0,gnd=13.0,si=2.0E+01,bt(non)= -9.0,bt(non)= -9.0,dfl=22.0] #MZ@\r\n#NO doesn\'t appear in even-shushan nor in the cambridge dictionary, reconsider","eyal-30 Mar 2004, ordan-22 Jan 2004",91346,"2004-03-30");
INSERT INTO hebrew_synonyms VALUES (2185,"אַסְפָּקָה","n","09626009","yy","none",NULL,"rav-milim","1.2","tg1",NULL,"stores, supplies, provisions",NULL,"למרפאה מגיעה אספקת תרופות אחת לשבוע","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","eyal-30 Mar 2004",91346,"2004-03-30");
INSERT INTO hebrew_synonyms VALUES (2186,"!אַפְלָיָה","n","04434578","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"discrimination",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO ","ordan-29 Jan 2004, assign-6 Nov 2003",0,"2004-01-29");
INSERT INTO hebrew_synonyms VALUES (2187,"אַפְלָיָה","n","00747433","yy","melingo","1","rav-milim","1.1","tg1",NULL,"discrimination, favoritism, favouritism",NULL,"גם לאחר שנעשו תיקונים בחוק האמריקאי, נמשכה האפליה נגד השחורים","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-29 Jan 2004, assign-6 Nov 2003",91347,"2004-01-29");
INSERT INTO hebrew_synonyms VALUES (2188,"חֲסַר-עֵרֶךְ","a","02382678","yy","melingo","1","rav-milim","1.1","tg1",NULL,"worthless",NULL,"המטבע שלהם חסר ערך","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","eyal-30 Mar 2004",91348,"2004-03-30");
INSERT INTO hebrew_synonyms VALUES (2189,"!אַרְבֶּה","n","08796174","y","dahan","1","rav-milim",NULL,"tg1","(insect)","locust",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2190,"חָרוּב","n","08795921","yy","dahan","1","rav-milim","1","tg1",NULL,"locust",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@ #IE","eyal-17 Feb 2004, assign-6 Nov 2003",91349,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (2191,"אַרְבֶּה","n","01730494","yy","melingo","1","rav-milim","1.1","tg1","(insect)","locust",NULL,"בשנת 1955 עשה הארבה שמות בגידולים החקלאיים","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-31 Jan 2004",91350,"2004-01-31");
INSERT INTO hebrew_synonyms VALUES (2192,"!אַרְגָּז","n","09913824","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"crate, box, case",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO that\'s the content of the crate, i don\'t think we have it in hebrew. ''tchulat ha\'argaz''","ordan-03 Feb 2004, assign-6 Nov 2003",0,"2004-02-03");
INSERT INTO hebrew_synonyms VALUES (2193,"אַרְגָּז","n","02517015","yy","melingo","1","rav-milim","1.1","tg1",NULL,"crate",NULL,"הסחורה למשלוח נארזה בארגזים","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-31 Jan 2004",91351,"2004-01-31");
INSERT INTO hebrew_synonyms VALUES (2194,"!אַרְיֵה","n","07376683","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"lion",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#NO as far as i know, it doesn\'t exist in hebrew (and note that it\'s demarcated from ''celebrity'')","ordan-02 Feb 2004, assign-6 Nov 2003",0,"2004-02-02");
INSERT INTO hebrew_synonyms VALUES (2195,"אַרְיֵה","n","01637880","yy","melingo","1","rav-milim","1.1","tg1",NULL,"lion, king_of_beasts",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-31 Jan 2004",91352,"2004-01-31");
INSERT INTO hebrew_synonyms VALUES (2196,"!אַרְנֶבֶת","n","10585780","nn","dahan","1","rav-milim",NULL,"tg1","(female)","hare, rabbit",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","ordan-09 Feb 2004, assign-6 Nov 2003",0,"2004-02-09");
INSERT INTO hebrew_synonyms VALUES (2197,"!אַרְנֶבֶת","n","05709844","nn","dahan","1","rav-milim",NULL,"tg1","(female)","hare, rabbit",NULL,NULL,"checked","#ASSIGN:74.0=[gnd=2.0E+01,gnd=13.0,si=24.0,bt(dir)=13.0,bt(dir)=13.0,bt(non)= -9.0] #MZ@\r\n#NO we use a collocation ''besar arnevet''. ","ordan-09 Feb 2004, assign-6 Nov 2003",0,"2004-02-09");
INSERT INTO hebrew_synonyms VALUES (2198,"אַרְנָבוֹן","n","01826220","yy","melingo","1","rav-milim","1.1","tg1","(female)","rabbit",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO ''arnevet'' is a common mistake for this synset, compare what rave milim has to say about ''arnevet''","ordan-02 Feb 2004, assign-6 Nov 2003",91353,"2004-02-02");
INSERT INTO hebrew_synonyms VALUES (2199,"אַרְנָק","n","03587013","yy","melingo","1","rav-milim","1.1","tg1",NULL,"wallet",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-01 Feb 2004, assign-6 Nov 2003",91354,"2004-02-01");
INSERT INTO hebrew_synonyms VALUES (2200,"אַרְנוֹנָה","n","09583701","yy","melingo","1","rav-milim","1.1","tg1",NULL,"property_tax",NULL,"הארנונה המוטלת על המתגוררים באזור זה גבוהה מאוד","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-02 Feb 2004",91355,"2004-02-02");
INSERT INTO hebrew_synonyms VALUES (2201,"אַרְסִי","a","00222282","yy","none",NULL,"rav-milim","2","tg1",NULL,"vicious, poisonous, venomous",NULL,"ביקורת ארסית","checked","#ASSIGN:50=[gnd=13.0,gnd=13.0,si=2.0E+01,dfl=4.0] #MZ@\r\n#NO ","ordan-19 Jan 2004",91356,"2004-01-19");
INSERT INTO hebrew_synonyms VALUES (2202,"אַשּׁוּחַ","n","07938419","yy","melingo","1","sapir","1","tg1","(tree)","fir",NULL,NULL,"checked","#ASSIGN:34.0=[gnd=2.0E+01,glc=14.0] #MZ@\r\n#NO this sense is contained in the major entry of ash\'ach in sapir","ordan-02 Feb 2004, assign-6 Nov 2003",91357,"2004-02-02");
INSERT INTO hebrew_synonyms VALUES (2203,"אַשּׁוּחַ","n","07938180","yy","melingo","1","rav-milim","1.1","tg1","(tree)","fir, fir_tree",NULL,"בחג המולד קנינו אשוח וקישטנו אותו","checked","#ASSIGN:28.0=[gnd=2.0E+01,glc=8.0] #MZ@\r\n#NO\r\n","ordan-02 Feb 2004",91358,"2004-02-02");
INSERT INTO hebrew_synonyms VALUES (2204,"אַשְׁלְגָן","n","10497589","yy","melingo","1","rav-milim","1.1","tg1",NULL,"potassium",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-03 Feb 2004, assign-6 Nov 2003",91359,"2004-02-03");
INSERT INTO hebrew_synonyms VALUES (2205,"אַשְׁלָג","n","10763066","yy","melingo","1","rav-milim","1.1","tg1",NULL,"potash",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-01 Feb 2004, assign-6 Nov 2003",91360,"2004-02-01");
INSERT INTO hebrew_synonyms VALUES (2206,"אַשְׁמָה","n","10078983","yy","melingo","1","sapir","1.2","tg1",NULL,"guilt",NULL,"האשמה על ביצוע העבירה הוטלה עליו","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-03 Feb 2004",91361,"2004-02-03");
INSERT INTO hebrew_synonyms VALUES (2207,"אַשְׁמָה","n","05602697","yy","melingo","1","rav-milim","1.3","tg1",NULL,"guilt, guilty_conscience, guilt_feelings, guilt_trip",NULL,"האשמה שהרגיש הביאה אותו לחזור בו ולהתנצל על התפרצותו","checked","#ASSIGN:37.0=[gnd=2.0E+01,bt(dir)=17.0] #MZ@\r\n#NO ","ordan-03 Feb 2004",91361,"2004-02-03");
INSERT INTO hebrew_synonyms VALUES (2208,"אַשְׁמָה","n","05404012","yy","melingo","1","rav-milim","1.1","tg1",NULL,"incrimination",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO note that it\'s a hyponym of accusation: therefore, ha\'asham or ishum cannot be part of this synset. ","ordan-03 Feb 2004, assign-6 Nov 2003",91361,"2004-02-03");
INSERT INTO hebrew_synonyms VALUES (2209,"הַאֲשָׁמָה","n","05035457","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"blame",NULL,"ההאשמות הופנו לכולם, אבל אף אחד לא היה מוכן לקחת אחריות על המחדל","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO a hyponym of reproach ","ordan-09 Feb 2004",91362,"2004-02-09");
INSERT INTO hebrew_synonyms VALUES (2210,"אַשְׁפָּה","n","10656895","yy","melingo","1","rav-milim","1.1","tg1","(US = garbage)","rubbish, trash",NULL,"בשל שביתת עובדי הניקיון הצטברה הרבה אשפה ברחובות","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO note that this the material itself (''trash'')","ordan-02 Feb 2004",91363,"2004-02-02");
INSERT INTO hebrew_synonyms VALUES (2212,"אַשְׁרָה","n","05013928","yy","melingo","1","rav-milim","1.1","tg1",NULL,"visa",NULL,"כיום כבר אין צורך באשרה כשעוברים בין מדינות האיחוד האירופי","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-02 Feb 2004",91364,"2004-02-02");
INSERT INTO hebrew_synonyms VALUES (2213,"אָב","n","10929407","yy","melingo","1","rav-milim","2.1","tg2",NULL,"Av, Ab",NULL,NULL,"checked","#ASSIGN:104.0=[gnd=39.0,glc=27.0,glc=18.0,glc=11.0,glc=9.0] #MZ@\r\n#NO","shuly-10 Jan 2004, assign-6 Nov 2003",90915,"2004-01-10");
INSERT INTO hebrew_synonyms VALUES (2214,"מְטֻשְׁטָשׁ","a","00744544","yy","dahan","1","rav-milim","1","tg1",NULL,"hazy",NULL,"ללא המשקפיים האנשים סביבי נראו כדמויות מטושטשות","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-21 Jan 2004, assign-6 Nov 2003",91365,"2004-01-21");
INSERT INTO hebrew_synonyms VALUES (2215,"אָבִיךְ","a","00430514","yy","dahan","1","rav-milim","1","tg1",NULL,"hazy",NULL,"הראות היתה לקויה בשל מזג האויר האביך","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-21 Jan 2004, assign-6 Nov 2003",91366,"2004-01-21");
INSERT INTO hebrew_synonyms VALUES (6406,"אָסִיר","n","07182455","n",NULL,NULL,"rav-milim","1",NULL,NULL,"convict",NULL,NULL,"checked","#IE\r\n#IE gender","eyal-26 Jun 2005, eyal-27 Jan 2004",0,"2005-06-26");
INSERT INTO hebrew_synonyms VALUES (2217,"אָבָץ","n","10507783","yy","dahan","1","rav-milim","1","tg1",NULL,"zinc",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE","eyal-27 Jan 2004, assign-6 Nov 2003",91368,"2004-01-27");
INSERT INTO hebrew_synonyms VALUES (2218,"אָדִישׁ","a","01289497","yy","dahan","1","rav-milim","1","tg1",NULL,"indifferent, apathetic",NULL,"קהל אדיש","checked","#ASSIGN:50=[gnd=4.0,gnd=2.0E+01,si=9.0,bt(dir)=5.0,bt(dir)=5.0,dfl=7.0] #MZ@ #IE","eyal-22 Jan 2004, assign-6 Nov 2003",91369,"2004-01-22");
INSERT INTO hebrew_synonyms VALUES (2219,"סֶר","n","07578721","yy","dahan","3","rav-milim","1","tg1",NULL,"sir",NULL,"המלכה העניקה לחברי להקת החיפושיות את התואר סר","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-22 Jan 2004, assign-6 Nov 2003",91370,"2004-01-22");
INSERT INTO hebrew_synonyms VALUES (2220,"אָהִיל","n","02902895","yy","dahan","1","rav-milim","1","tg1",NULL,"lampshade",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-22 Jan 2004, assign-6 Nov 2003",91371,"2004-01-22");
INSERT INTO hebrew_synonyms VALUES (2222,"אָהוּב","a","01402474","yy","dahan","1","rav-milim","1","tg1",NULL,"favourite",NULL,"זו הפינה האהובה עלי","checked","#ASSIGN:25.0=[gnd=2.0E+01,bt(dir)=19.0,bt(non)= -14.0] #MZ@ #IE","eyal-25 Jan 2004, assign-6 Nov 2003",91372,"2004-01-25");
INSERT INTO hebrew_synonyms VALUES (2223,"אָוֶן","n","00480312","yy","dahan","1","rav-milim","1","tg1",NULL,"evil, iniquity",NULL,"למה תראני אוון ועמל תביט (חבקוק א )","checked","#ASSIGN:50=[gnd=13.0,gnd=13.0,si=2.0E+01,bt(non)= -11.0,dfl=15.0] #MZ@ #IE","eyal-22 Jan 2004, assign-6 Nov 2003",91373,"2004-01-22");
INSERT INTO hebrew_synonyms VALUES (2224,"אָז","r","00115244","yy","dahan","1","rav-milim","4","tg1",NULL,"then",NULL,"אם אתה לא לקחת את זה, אז מי לקח","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE in Hebrew this sense is colloquial","eyal-28 Jan 2004",90925,"2004-01-28");
INSERT INTO hebrew_synonyms VALUES (2225,"אָז","r","00115115","yy","dahan","1","rav-milim","1","tg1","(at that time)","then",NULL,"המחירים היו נמוכים אז","checked","#ASSIGN:33.0=[gnd=13.0,glc=4.0,bt(dir)=16.0] #MZ@ #IE","eyal-28 Jan 2004",90925,"2004-01-28");
INSERT INTO hebrew_synonyms VALUES (6913,"אִי-כְּשִׁירוּת","n","04015096","yy","none",NULL,"rav-milim","1.1",NULL,NULL,"incompetence, incompetency",NULL,"הוא שוחרר משירות צבאי בשל אי-כשירות פיזית","checked","#IN","ordan-07 Jul 2004",91374,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (6365,"חֶבְרוֹן","n","H0003044","yy",NULL,NULL,"rav-milim","1",NULL,NULL,"Hebron",NULL,NULL,"checked","# IE","shuly-08 Jan 2004",91375,"2004-01-08");
INSERT INTO hebrew_synonyms VALUES (2228,"הוֹמוֹגֶנִי","a","01150078","yy","melingo","1","rav-milim","1.1","tg1",NULL,"homogeneous",NULL,"בחירת בתי-הספר על-ידי ההורים נוטה ליצור\r\nבתי-ספר בעלי הרכב חברתי ותרבותי הומוגני","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-17 Mar 2004, eyal-26 Jan 2004, assign-6 Nov 2003",91376,"2004-03-17");
INSERT INTO hebrew_synonyms VALUES (2229,"אָחוֹת","n","07579639","yy","dahan","1","rav-milim","4","tg1",NULL,"sister",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-27 Jan 2004, assign-6 Nov 2003",91377,"2004-01-27");
INSERT INTO hebrew_synonyms VALUES (2230,"אָחוּ","n","06317924","yw","dahan","1","rav-milim",NULL,"tg1",NULL,"meadow",NULL,"הפרות רעו באחו","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-04 Feb 2004",91378,"2004-02-04");
INSERT INTO hebrew_synonyms VALUES (2232,"בִּלְתִּי-חָדִיר","a","01708553","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"impervious",NULL,"אפודי מגן בלתי חדירים לכדורים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-16 Mar 2004",91379,"2004-03-16");
INSERT INTO hebrew_synonyms VALUES (2233,"אָיֹם","a","01079225","yy","dahan","1","rav-milim","2","tg1",NULL,"awful",NULL,"יש לו כתב יד איום - ממש בלתי ניתן לקריאה","checked","#ASSIGN:68.0=[gnd=1.0E+01,gnd=13.0,gnd=8.0,si=18.0,bt(dir)=14.0,bt(non)= -7.0,bt(dir)=14.0,bt(non)= -1.0E+01,bt(dir)=14.0,bt(non)= -6.0] #MZ@ #IE","eyal-19 Jan 2004, assign-6 Nov 2003",91380,"2004-01-19");
INSERT INTO hebrew_synonyms VALUES (2234,"אָיֹם","a","00193648","yy","dahan","1","rav-milim","1","tg1",NULL,"terrible, dreadful, awful",NULL,"המכשפה הרעה הטילה קללה איומה על היפהפיה הנרדמת","checked","#ASSIGN:7.0E+01=[gnd=1.0E+01,gnd=13.0,gnd=8.0,si=18.0,bt(dir)=14.0,bt(non)= -7.0,bt(dir)=14.0,bt(non)= -9.0,bt(dir)=14.0,bt(non)= -5.0] #MZ@ #IE","eyal-19 Jan 2004, assign-6 Nov 2003",91380,"2004-01-19");
INSERT INTO hebrew_synonyms VALUES (6425,"אַחְרָיוּת","n","05012271","yy","melingo","1","rav-milim","1.3",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-05 Feb 2004",91381,"2004-02-05");
INSERT INTO hebrew_synonyms VALUES (2237,"אָמִין","a","00688247","yy","melingo","2","rav-milim","1.2","tg1",NULL,"reliable, dependable",NULL,"מקור מידע אמין","checked","#ASSIGN:75.0=[gnd=13.0,gnd=1.0E+01,si=2.0E+01,bt(dir)=16.0,bt(dir)=16.0] #MZ@ #IE","eyal-17 Mar 2004, eyal-04 Feb 2004, assign-6 Nov 2003",91382,"2004-03-17");
INSERT INTO hebrew_synonyms VALUES (2239,"!אָמָּנִית","n","07085533","n","dahan","1","rav-milim",NULL,"tg1","(fem)","artist",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE see seperate synset","eyal-23 Jun 2005, assign-6 Nov 2003",0,"2005-06-23");
INSERT INTO hebrew_synonyms VALUES (2240,"מֻכְרָז","a","00893638","yy","dahan","1","rav-milim","1","tg1",NULL,"declared",NULL,"הראשון אשר זכה בנקודה, מוכרז כמנצח","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-21 Jan 2004, assign-6 Nov 2003",91383,"2004-01-21");
INSERT INTO hebrew_synonyms VALUES (2241,"אָסִיר","n","07500774","nn","dahan","1","rav-milim","1","tg1",NULL,"prisoner, captive",NULL,"האסיר נכלא בצינוק למשך שבוע ימים","checked","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@ \r\n#IE gender","eyal-28 Feb 2005, eyal-04 Feb 2004, assign-6 Nov 2003",0,"2005-02-28");
INSERT INTO hebrew_synonyms VALUES (2242,"אָסוֹן","n","05452645","yy","melingo","1","rav-milim","1.1","tg1",NULL,"disaster, tragedy",NULL,"האמבולנסים מיהרו למקום האסון","checked","#ASSIGN:25.0=[gnd=13.0,gnd=2.0E+01,si=24.0,bt(non)= -9.0,bt(non)= -9.0,bt(non)= -14.0] #MZ@ #IE","eyal-17 Mar 2004, eyal-27 Jan 2004, assign-6 Nov 2003",91384,"2004-03-17");
INSERT INTO hebrew_synonyms VALUES (2243,"אָסוּר","a","01697122","yy","dahan","1","rav-milim","1","tg1",NULL,"forbidden, prohibited",NULL,"בבית שלנו אסור היה לרקוד ולשחק קלפים","checked","#ASSIGN:57.0=[gnd=39.0,gnd=2.0E+01,si=49.0,bt(non)= -34.0,bt(non)= -17.0] #MZ@ #IE","eyal-26 Jan 2004",91385,"2004-01-26");
INSERT INTO hebrew_synonyms VALUES (2244,"!אָסוּר","a","01346629","y","dahan","1","rav-milim",NULL,"tg1",NULL,"forbidden, prohibited, banned",NULL,NULL,"assigned","#ASSIGN:108.0=[gnd=2.0E+01,gnd=39.0,si=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2245,"אָפְיָנִי","a","00346121","yy","dahan","1","rav-milim","1","tg1",NULL,"characteristic",NULL,"אדום וזהב הם הצבעים האופיניים לסתיו","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE","eyal-19 Jan 2004, assign-6 Nov 2003",91386,"2004-01-19");
INSERT INTO hebrew_synonyms VALUES (2246,"עָכוּר","a","00402914","yy","dahan","2","rav-milim","1","tg1",NULL,"gloomy, murky",NULL,"המים היו עכורים לגמרי","checked","#ASSIGN:26.0=[gnd=2.0E+01,bt(non)= -15.0,bt(dir)=21.0] #MZ@ #IE","eyal-19 Jan 2004, assign-6 Nov 2003",91387,"2004-01-19");
INSERT INTO hebrew_synonyms VALUES (2247,"קוֹדֵר","a","00271928","yy","dahan","2","rav-milim","1","tg1",NULL,"gloomy, murky",NULL,"שמיים קודרים","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-19 Jan 2004, assign-6 Nov 2003",91388,"2004-01-19");
INSERT INTO hebrew_synonyms VALUES (2248,"!אָפֹר","a","01586508","nn","dahan","1","rav-milim",NULL,"tg1","(US = gray)","grey",NULL,NULL,"checked","#ASSIGN:38.0=[gnd=8.0,bt(dir)=7.0,bt(dir)=8.0,bt(crs)=15.0] #MZ@","ordan-16 Mar 2004, assign-6 Nov 2003",0,"2004-03-16");
INSERT INTO hebrew_synonyms VALUES (6381,"GAP!","a","01549077","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE taken from US history","eyal-21 Jan 2004",91389,"2004-01-21");
INSERT INTO hebrew_synonyms VALUES (2250,"אָפֹר","a","00963416","yy","dahan","1","rav-milim","3","tg1","(US = gray)","grey",NULL,"האיזור האפור בין החוקי לבין זה שאינו חוקי","checked","#ASSIGN:38.0=[gnd=8.0,bt(dir)=7.0,bt(dir)=8.0,bt(crs)=15.0] #MZ@ #IE","eyal-21 Jan 2004, assign-6 Nov 2003",91390,"2004-01-21");
INSERT INTO hebrew_synonyms VALUES (2251,"אָפֹר","a","00430862","yy","melingo","1","sapir","1.2","tg1","(US = gray)","grey",NULL,"אחר הצהריים היה אפור וגשום","checked","#ASSIGN:31.0=[gnd=8.0,bt(non)= -5.0,bt(dir)=7.0,bt(dir)=7.0,bt(crs)=14.0] #MZ@ #IE","eyal-16 Mar 2004, eyal-21 Jan 2004, assign-6 Nov 2003",91390,"2004-03-16");
INSERT INTO hebrew_synonyms VALUES (2252,"אָפֹר","a","00366117","yy","dahan","1","rav-milim","1b","tg1","(US = gray)","grey, gray",NULL,"חליפה אפורה, שיער אפור","checked","#ASSIGN:4.0E+01=[gnd=8.0,bt(dir)=8.0,bt(dir)=8.0,bt(crs)=16.0] #MZ@ #IE","eyal-21 Jan 2004",91390,"2004-01-21");
INSERT INTO hebrew_synonyms VALUES (2253,"אָרִיג","n","02656657","yy","dahan","1","rav-milim","1","tg1","(woven)","fabric, cloth",NULL,"האריג של החולצה עדין מאד","checked","#ASSIGN:139.0=[gnd=2.0E+01,gnd=13.0,si=49.0,bt(dir)=17.0,bt(non)= -12.0,bt(dir)=6.0,bt(crs)=23.0,bt(dir)=17.0,bt(dir)=6.0] #MZ@ #IE","eyal-22 Jan 2004, assign-6 Nov 2003",91391,"2004-01-22");
INSERT INTO hebrew_synonyms VALUES (2254,"מִבְנֶה","n","03860008","yy","dahan","1","rav-milim","2","tg1","(woven)","fabric",NULL,"המבנה של החברה בה אנו חיים","checked","#ASSIGN:26.0=[gnd=2.0E+01,bt(non)= -15.0,bt(dir)=21.0] #MZ@ #IE","eyal-22 Jan 2004, assign-6 Nov 2003",90818,"2004-01-22");
INSERT INTO hebrew_synonyms VALUES (2255,"רַעַף","n","10814033","yy","dahan","1","rav-milim","1","tg1",NULL,"roofing_tile",NULL,"גגות רעפים אדומים","checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@ #IE","eyal-27 Jan 2004, assign-6 Nov 2003",91392,"2004-01-27");
INSERT INTO hebrew_synonyms VALUES (2256,"אָרִיחַ","n","03504435","yy","dahan","1","rav-milim","1","tg1","(for floor)","tile",NULL,"בחרנו אריחי קרמיקה למטבח החדש","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-27 Jan 2004, assign-6 Nov 2003",91393,"2004-01-27");
INSERT INTO hebrew_synonyms VALUES (2257,"אָרָד","n","10552050","yy","dahan","1","rav-milim","1","tg1",NULL,"bronze",NULL,"מדלית ארד","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-22 Jan 2004, assign-6 Nov 2003",91394,"2004-01-22");
INSERT INTO hebrew_synonyms VALUES (6388,"GAP!","n","02342693","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE This concept does not exist in Hebrew","eyal-22 Jan 2004",90808,"2004-01-22");
INSERT INTO hebrew_synonyms VALUES (2259,"אָרוֹן","n","02534044","yy","dahan","1","rav-milim","1","tg1","(US = closet)","cupboard",NULL,"הארון היה עמוס בבגדים","reviewed","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-22 Jan 2004, assign-6 Nov 2003",91395,"2004-01-22");
INSERT INTO hebrew_synonyms VALUES (2260,"אָרוּר","a","00632302","yy","dahan","1","rav-milim","1","tg1",NULL,"accursed, cursed",NULL,"ארור תהיה לנצח","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-21 Jan 2004, assign-6 Nov 2003",90950,"2004-01-21");
INSERT INTO hebrew_synonyms VALUES (2261,"אֹבֶךְ","n","07805661","yy","dahan","1","rav-milim","1","tg1",NULL,"haze",NULL,"האובך הכבד לא איפשר לראות את המכונית שנסעה לפנינו","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-16 Feb 2004, assign-6 Nov 2003",91396,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (2262,"מְבוּכָה","n","04393348","yy","dahan","1","rav-milim","2","tg1",NULL,"haze, daze, fog",NULL,"האזעקה הפתאומית גרמה למבוכה רבה בכיתה","checked","#ASSIGN:25.0=[gnd=2.0E+01,bt(non)= -14.0,bt(dir)=19.0] #MZ@ #IE","eyal-16 Feb 2004, assign-6 Nov 2003",91397,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (2263,"אָדֹם","n","03879230","yy","dahan","1","rav-milim","2","tg1",NULL,"red, redness",NULL,"הצבע האדום הינו הצבע האהוב עלי","checked","#ASSIGN:47.0=[gnd=2.0E+01,gnd=2.0E+01,si=24.0,bt(non)= -17.0] #MZ@ #IE","shuly-12 Jan 2004, assign-6 Nov 2003",91398,"2004-01-12");
INSERT INTO hebrew_synonyms VALUES (6461,"GAP!","n","06829050","yy",NULL,NULL,NULL,NULL,NULL,NULL,"Red_River",NULL,NULL,"checked","#IE","eyal-15 Feb 2004",90808,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (2265,"אֹדֶם","n","02931334","yy","dahan","2","rav-milim",NULL,"tg1",NULL,"lipstick",NULL,"היא מרחה אודם בהיר על שפתותיה","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE","eyal-15 Feb 2004, assign-6 Nov 2003",91399,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (2266,"אֹהֶל","n","03486655","yy","dahan","1","rav-milim","1","tg1",NULL,"tent",NULL,"הוא הקים את האוהל ליד ערוץ הנחל","checked","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=21.0,dfl=9.0] #MZ@ #IE","eyal-15 Feb 2004, assign-6 Nov 2003",91400,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (2267,"אֹכֶל","n","00011575","yy","dahan","1","rav-milim",NULL,"tg1",NULL,"food",NULL,"אדם אינו יכול לשרוד זמן רב ללא אוכל","checked","#ASSIGN:50=[gnd=13.0,bt(dir)=16.0,dfl=21.0] #MZ@ #IE","eyal-15 Feb 2004, assign-6 Nov 2003",91401,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (2268,"!אֹמֶץ","n","05595229","y","dahan","1","rav-milim",NULL,"tg1",NULL,"courage, bravery",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2269,"אֹמֶץ","n","03805961","yy","dahan","1","rav-milim","1","tg1",NULL,"courage, bravery",NULL,"צריך הרבה אומץ להסתער ככה אל מול האויב","checked","#ASSIGN:282.0=[gnd=39.0,gnd=2.0E+01,si=49.0,bt(dir)=39.0,bt(dir)=19.0,bt(crs)=58.0,bt(dir)=39.0,bt(dir)=19.0] #MZ@ #IE","eyal-16 Feb 2004, assign-6 Nov 2003",91402,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (2270,"אֹרֶז","n","08432637","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"rice",NULL,"בסין יש שדות אורז עצומים","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE refers to the first part of RM\'s definition","eyal-23 Jun 2005, eyal-15 Feb 2004",91403,"2005-06-23");
INSERT INTO hebrew_synonyms VALUES (2271,"אֹרֶז","n","05837941","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"rice",NULL,"המאכל האהוב עליו היה אורז עם ברוקולי","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE refers to the second part of RM\'s definition","eyal-23 Jun 2005, eyal-15 Feb 2004, assign-6 Nov 2003",91403,"2005-06-23");
INSERT INTO hebrew_synonyms VALUES (2272,"אֹרֶן","n","07926500","yy","dahan","1","none",NULL,"tg1","(tree)","pine",NULL,"שולחן העבודה שלי עשוי מאורן","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-15 Feb 2004, assign-6 Nov 2003",91404,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (2273,"אֹרֶן","n","07925865","yy","dahan","1","rav-milim","1","tg1","(tree)","pine",NULL,"ליד ביתי יש חורשת אורנים קטנה","checked","#ASSIGN:59.0=[gnd=2.0E+01,glc=14.0,glc=8.0,bt(dir)=17.0] #MZ@ #IE","eyal-15 Feb 2004",91404,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (2274,"אֻגְדָּה","n","06095787","yy","dahan","1","rav-milim","1","tg1","(army)","division",NULL,"שתי אוגדות של חיל רגלים גויסו למילואים","checked","#ASSIGN:50=[gnd=3.0,glc=27.0,glc=16.0,dfl=4.0] #MZ@ #IE","eyal-16 Feb 2004, assign-6 Nov 2003",91405,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (6910,"דִּירַת-סְטוּדְיוֹ","n","03434438","yy","none",NULL,"none",NULL,NULL,NULL,"studio_apartment, studio",NULL,NULL,"checked","#IN","ordan-07 Jul 2004",91406,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (2276,"אֻלְפָּן","n","03434290","yy","dahan","2","rav-milim","1","tg1","(for broadcasting)","studio",NULL,"אחת לשבוע מגיע ראש העיר לאולפן הרדיו בעירו ועונה לשאלות מאזינים","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE also refers to defenition 3 in RM","eyal-17 Feb 2004",91407,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (2277,"אֻלְפָּן","n","03433996","yy","melingo","1.1","rav-milim","1.5","tg1",NULL,"studio",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-23 Jun 2005, eyal-17 Feb 2004, assign-6 Nov 2003",91407,"2005-06-23");
INSERT INTO hebrew_synonyms VALUES (2278,"עָלוּב","a","02235465","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"miserable, wretched",NULL,"בחלק הזה של העיר תנאי הדיור הם עלובים להחריד","revised","#ASSIGN:33.0=[gnd=7.0,gnd=1.0E+01,si=16.0] #MZ@ #IE","ordan-16 Mar 2004, eyal-16 Feb 2004, assign-6 Nov 2003",91408,"2004-03-16");
INSERT INTO hebrew_synonyms VALUES (2279,"!אֻמְלָל","a","00446516","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"miserable, wretched",NULL,NULL,"checked","#ASSIGN:33.0=[gnd=7.0,gnd=1.0E+01,si=16.0] #MZ@\r\n#NO it\'s restricted to physicality - non-existent in Hebrew","ordan-16 Mar 2004, assign-6 Nov 2003",0,"2004-03-16");
INSERT INTO hebrew_synonyms VALUES (6470,"GAP!","n","06164129","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE","eyal-17 Feb 2004",90808,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (2281,"!אֻמָּן","n","07191713","y","dahan","1","rav-milim",NULL,"tg1",NULL,"craftsman, skilled_worker",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2282,"!אֻמָּן","n","07191544","y","dahan","1","rav-milim",NULL,"tg1",NULL,"craftsman, skilled_worker",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2283,"אֻמָּן","n","07190858","n","dahan","1","rav-milim","1","tg1",NULL,"craftsman, artisan",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE gender","eyal-26 Jun 2005, eyal-17 Feb 2004, assign-6 Nov 2003",0,"2005-06-26");
INSERT INTO hebrew_synonyms VALUES (2284,"!אֻמָּן","n","07581578","y","dahan","1","rav-milim",NULL,"tg1",NULL,"craftsman, skilled_worker",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2285,"אֻרְוָה","n","03395783","yy","dahan","1","rav-milim","1","tg1",NULL,"stable",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE","eyal-16 Feb 2004, assign-6 Nov 2003",91410,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (2286,"אוֹגֵד","n","04861501","yy","dahan","1","rav-milim","1","tg1","(gram)","copula",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-15 Feb 2004, assign-6 Nov 2003",91411,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (2287,"אוֹגֵר","n","01844208","yy","dahan","1","rav-milim","1","tg1","(animal)","hamster",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-12 Feb 2004, assign-6 Nov 2003",91412,"2004-02-12");
INSERT INTO hebrew_synonyms VALUES (2288,"אוֹהֵב","a","01403478","yy","dahan","1","rav-milim","4","tg1",NULL,"loving",NULL,"היא תלתה בו זוג עיניים אוהבות","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-15 Feb 2004, assign-6 Nov 2003",91413,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (2289,"!אוֹלָר","n","03104933","u","dahan","1","rav-milim",NULL,"tg1",NULL,"penknife",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO more specific than ''pocket knife'', אולר","ordan-07 Jul 2004, assign-6 Nov 2003",0,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (2290,"אוֹפַנּוֹעַ","n","03017826","yy","dahan","1","rav-milim","1","tg1",NULL,"motorcycle",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-12 Feb 2004, assign-6 Nov 2003",91414,"2004-02-12");
INSERT INTO hebrew_synonyms VALUES (2291,"קַטְנוֹעַ","n","03002764","yy","dahan","1","rav-milim","1","tg1",NULL,"minibike, motorbike",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-12 Feb 2004, assign-6 Nov 2003",91415,"2004-02-12");
INSERT INTO hebrew_synonyms VALUES (6459,"אוּלָם","n","02786743","yy",NULL,NULL,"rav-milim","1",NULL,NULL,"hall",NULL,"אולם כנסים, אולם הרצאות","checked","#IE","eyal-15 Feb 2004",91416,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (2295,"מַארְק","n","04850278","yy","none",NULL,"none",NULL,"tg1",NULL,"Mark",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-15 Feb 2004, assign-6 Nov 2003",91417,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (2296,"אוּד","n","10835446","yy","dahan","1","rav-milim","1","tg1",NULL,"brand, firebrand",NULL,"בסוף חגיגת ל''ג בעומר, כל מה שנשאר מהמדורה היו כמה אודים עשנים","checked","#ASSIGN:50=[gnd=7.0,gnd=2.0E+01,si=14.0,dfl=9.0] #MZ@ #IE","eyal-12 Feb 2004",91418,"2004-02-12");
INSERT INTO hebrew_synonyms VALUES (2297,"אוּלַי","r","00294418","yy","dahan","1","rav-milim","1","tg1",NULL,"perhaps, possibly, maybe",NULL,"אולי היא תתקשר מחר","checked","#ASSIGN:426.0=[gnd=39.0,gnd=1.0E+01,gnd=2.0E+01,si=37.0,bt(dir)=9.0,bt(dir)=38.0,bt(dir)=17.0,bt(crs)=128.0,bt(dir)=9.0,bt(dir)=38.0,bt(dir)=17.0,bt(dir)=9.0,bt(dir)=38.0,bt(dir)=17.0] #MZ@ #IE","eyal-15 Feb 2004, assign-6 Nov 2003",91419,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (2298,"!אוּלָם","n","02224534","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"hall, auditorium",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IN better matched with ''hall''","ordan-07 Jul 2004, assign-6 Nov 2003",0,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (2299,"בְּגִידָה","n","00482966","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"treachery, betrayal, treason",NULL,"מעילתו בכספי הציבור היתה בגידה באמון שנתנו בו","checked","#ASSIGN:73.0=[gnd=2.0E+01,gnd=2.0E+01,si=33.0] #MZ@\r\n#NO","ordan-28 Mar 2004",90972,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (2300,"!בְּדִידוּת","n","03647110","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"loneliness, solitude",NULL,NULL,"checked","#ASSIGN:78.0=[gnd=13.0,gnd=13.0,si=2.0E+01,bt(dir)=16.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-09 Apr 2004, assign-6 Nov 2003",0,"2004-04-09");
INSERT INTO hebrew_synonyms VALUES (2301,"בְּדִידוּת","n","10343521","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"loneliness, solitariness",NULL,"בשנותיו הראשונות באמריקה סבל מבדידות והתגעגע לביתו","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-09 Apr 2004, assign-6 Nov 2003",91420,"2004-04-09");
INSERT INTO hebrew_synonyms VALUES (2302,"!בְּדִידוּת","n","05601181","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"loneliness, solitude",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-05 Aug 2004, assign-6 Nov 2003",0,"2004-08-05");
INSERT INTO hebrew_synonyms VALUES (2303,"!בְּדִיחָה","n","00331800","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"joke",NULL,NULL,"reviewed","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-28 Mar 2004, assign-6 Nov 2003",0,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (2305,"!בְּהֶחְלֵט","r","00036408","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"absolutely, definitely",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO it is translated differently according to the context; the only ''stable'' solution i could find is the idiom נעלה מכל ספק","ordan-19 Apr 2004, assign-6 Nov 2003",0,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (2306,"בְּוַדַּאי","r","00140819","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"surely, certainly, sure, for_sure, for_certain, sure_enough",NULL,"בוודאי שהוא יגיע בזמן, הוא אף פעם לא מאחר","checked","#ASSIGN:203.0=[gnd=39.0,bt(dir)=32.0,bt(dir)=5.0E+01,bt(crs)=82.0] #MZ@\r\n#NO","ordan-18 Apr 2004",91421,"2004-04-18");
INSERT INTO hebrew_synonyms VALUES (2307,"בְּחִילָה","n","10302574","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"nausea",NULL,"מהבוקר הוא חש בחילה אך אינו מצליח להקיא","checked","#ASSIGN:97.0=[gnd=2.0E+01,gnd=2.0E+01,si=33.0,bt(dir)=19.0,bt(dir)=19.0,bt(non)= -14.0] #MZ@\r\n#NO","ordan-12 Apr 2004",91422,"2004-04-12");
INSERT INTO hebrew_synonyms VALUES (2308,"בְּחִילָה","n","05578076","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"nausea",NULL,"ההתנהגות הברברית שלך עושה לי בחילה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-12 Apr 2004, assign-6 Nov 2003",91422,"2004-04-12");
INSERT INTO hebrew_synonyms VALUES (2309,"בְּחִינָה","n","05378329","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"exam, examination, test",NULL,"הבחינה נפסלה לאחר שנתברר שכמה תלמידים העתיקו את התשובות מחבריהם","checked","#ASSIGN:81.0=[gnd=8.0,gnd=8.0,gnd=6.0,si=13.0,bt(dir)=7.0,bt(dir)=7.0,bt(non)= -5.0,bt(crs)=14.0,bt(dir)=7.0,bt(dir)=7.0,bt(non)= -5.0,bt(dir)=7.0,bt(dir)=7.0] #MZ@\r\n#NO","ordan-06 May 2004",90954,"2004-05-06");
INSERT INTO hebrew_synonyms VALUES (2310,"!בְּחִירָה","n","04462889","y","dahan","2","rav-milim",NULL,"tg1",NULL,"choice",NULL,NULL,"assigned","#ASSIGN:4.0E+01=[gnd=13.0,bt(dir)=11.0,bt(non)= -9.0,bt(dir)=7.0,bt(crs)=18.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2311,"בְּחִירָה","n","00104850","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"choice",NULL,"מאחר שהועמדו בפניו כל כך הרבה אפשרויות, התקשה מאוד בבחירה","checked","#ASSIGN:44.0=[gnd=13.0,bt(dir)=13.0,bt(dir)=7.0,bt(non)= -9.0,bt(crs)=2.0E+01] #MZ@\r\n#NO","ordan-28 Mar 2004",91423,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (2312,"בְּחִישָׁה","n","00131987","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"meddling",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-28 Mar 2004, assign-6 Nov 2003",91424,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (2313,"!בְּיִחוּד","r","00499119","y","dahan","1","rav-milim",NULL,"tg1",NULL,"particularly, especially",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6650,"בֵּין_כֹּה_וָכֹה","r","00025661","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,"אתה יכול להגיע מאוחר יותר, בין כה וכה אין לי כוונות ללכת לישון לפני חצות","checked","#NO","ordan-10 May 2004, ordan-19 Apr 2004",91425,"2004-05-10");
INSERT INTO hebrew_synonyms VALUES (2315,"!בְּכוֹר","a","00959919","u","dahan","1","rav-milim",NULL,"tg1",NULL,"eldest",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO already defined as a nouns, RM doesn\'t offer it as an adjective. ","ordan-20 Mar 2004, assign-6 Nov 2003",0,"2004-03-20");
INSERT INTO hebrew_synonyms VALUES (2316,"הִתְבַּלְּטוּת","n","00261111","yy","none",NULL,"none",NULL,"tg1",NULL,"protrusion, projection",NULL,NULL,"checked","#ASSIGN:50=[gnd=2.0E+01,gnd=4.0,si=1.0E+01,dfl=16.0] #MZ@\r\n#NO cf Even-Shushan 1.1","ordan-07 Apr 2004, assign-6 Nov 2003",91426,"2004-04-07");
INSERT INTO hebrew_synonyms VALUES (2317,"!בְּלִימָה","n","02678745","y","dahan","1","rav-milim",NULL,"tg1",NULL,"braking, stopping",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2318,"בְּלַאי","n","09596000","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"depreciation, wear_and_tear",NULL,"נהיגה פרועה אינה רק מסוכנת, היא גם מאיצה את בלאי הרכב","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-15 Apr 2004",91427,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (2319,"!בְּלָאו_הָכִי","r","00026338","y","dahan","1","rav-milim",NULL,"tg1",NULL,"anyway, anyhow",NULL,NULL,"assigned","#ASSIGN:89.0=[gnd=2.0E+01,gnd=2.0E+01,si=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2320,"בְּלָאו_הָכֵי","r","00025661","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"anyway, anyhow",NULL,"אין לך מה לדבר איתו, בלאו הכי הוא אף לא מקשיב","checked","#ASSIGN:89.0=[gnd=2.0E+01,gnd=2.0E+01,si=49.0] #MZ@\r\n#NO","ordan-19 Apr 2004, assign-6 Nov 2003",91428,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (2321,"בְּמִתְכַּוֵּן","r","00059927","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"intentionally, deliberately, on_purpose, purposely",NULL,NULL,"checked","#ASSIGN:87.0=[gnd=2.0E+01,gnd=39.0,si=49.0,bt(non)= -21.0] #MZ@\r\n#NO","ordan-18 Apr 2004",91429,"2004-04-18");
INSERT INTO hebrew_synonyms VALUES (2322,"בְּנִיָּה","n","00715519","yy","melingo","1.1","none",NULL,"tg1",NULL,"building, construction",NULL,"הוא עובד בענף הבנייה","checked","#ASSIGN:35.0=[gnd=1.0E+01,gnd=6.0,si=11.0,bt(dir)=6.0,bt(dir)=6.0,bt(non)= -4.0] #MZ@\r\n#NO consider also בינוי although it doesn\'t agree with RM","ordan-04 Apr 2004",91430,"2004-04-04");
INSERT INTO hebrew_synonyms VALUES (2323,"בְּנִיָּה","n","00585093","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"building, construction",NULL,"בניית רב הקומות נמשכה זמן רב","checked","#ASSIGN:34.0=[gnd=1.0E+01,gnd=6.0,si=11.0,bt(dir)=6.0,bt(dir)=6.0,bt(non)= -5.0] #MZ@\r\n#NO","ordan-04 Apr 2004, assign-6 Nov 2003",91430,"2004-04-04");
INSERT INTO hebrew_synonyms VALUES (2324,"מַהוּתִי","a","02079609","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"fundamental",NULL,"למרות השינויים שנעשים מפעם לפעם בנושאי הלימוד בבית הספר, לרוב אין אלה שינויים מהותיים","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-20 Mar 2004",91431,"2004-03-20");
INSERT INTO hebrew_synonyms VALUES (2325,"יְסוֹדִי","a","01784854","yy","none",NULL,"rav-milim","1.3","tg1",NULL,"fundamental, rudimentary, underlying",NULL,"הפיזיקה התיאורטית עוסקת בחוקים היסודיים של היקום","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-20 Mar 2004, assign-6 Nov 2003",91432,"2004-03-20");
INSERT INTO hebrew_synonyms VALUES (2326,"בְּסִיסִי","a","00026848","yy","none",NULL,"rav-milim","3.1","tg1","(chem)","alkaline, alkalic",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-20 Mar 2004, assign-6 Nov 2003",91433,"2004-03-20");
INSERT INTO hebrew_synonyms VALUES (2327,"!בְּסֵדֶר","r","00014301","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"all_right, O.K.",NULL,NULL,"checked","#ASSIGN:85.0=[gnd=13.0,gnd=39.0,si=33.0] #MZ@\r\n#NO i\'m not sure בסדר can be used as an adverb. maybe in such sentences as הלך לי בסדר","ordan-19 Apr 2004, assign-6 Nov 2003",0,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (2328,"בְּעֶרֶךְ","r","00006065","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"approximately, roughly, about",NULL,"הוא צריך להיות בן 40 בערך, למרות שהוא נראה צעיר בהרבה","checked","#ASSIGN:73.0=[gnd=6.0,gnd=13.0,gnd=39.0,si=16.0,bt(non)= -4.0,bt(dir)=13.0,bt(non)= -9.0,bt(dir)=13.0,bt(non)= -27.0,bt(dir)=13.0] #MZ@\r\n#NO","ordan-19 Apr 2004, assign-6 Nov 2003",91434,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (2329,"בְּעַל-פֶּה","r","00151980","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"by_heart",NULL,"לפני שנים נהגו לשנן בבית הספר קטעים ארוכים מהתנ''ך בעל-פה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-19 Apr 2004, assign-6 Nov 2003",91435,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (2330,"בְּעָיָה","n","05080756","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"problem",NULL,"במבחן במתמטיקה נתבקשו התלמידים לפתור עשר בעיות","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO RM restricts it to math or logical problem, they may be right","ordan-09 Apr 2004, assign-6 Nov 2003",90957,"2004-04-09");
INSERT INTO hebrew_synonyms VALUES (7015,"GAP!","a","01242110","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#NO too specific","ordan-21 Jul 2004",91389,"2004-07-21");
INSERT INTO hebrew_synonyms VALUES (7016,"מִמּוּשׁ","n","00061322","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"implementation",NULL,"הרעיון היה פשוט, לשם מימושו היה עלינו לעבוד קשה","checked","#IN referring to the first part of RM\'s definition 1.1, the second part should be matched with \'realization\'","ordan-21 Jul 2004",91436,"2004-07-21");
INSERT INTO hebrew_synonyms VALUES (2333,"!בְּעָלִים","n","07451666","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"owner",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO in Hebrew the sense of בעלים fits better with n#07451379. ","ordan-20 Mar 2004, assign-6 Nov 2003",0,"2004-03-20");
INSERT INTO hebrew_synonyms VALUES (2334,"בְּעָלִים","n","07451379","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"owner",NULL,"הבעלים של המסעדה הזאת מתייחס אל עובדיו באופן הוגן","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO ","ordan-20 Mar 2004",91437,"2004-03-20");
INSERT INTO hebrew_synonyms VALUES (2335,"!בְּפֹעַל","r","00145000","y","dahan","1","rav-milim",NULL,"tg1",NULL,"in_fact, actually",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2336,"!בְּקִיאוּת","n","04362799","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"familiarity, expertness",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO RM does have this sense as PART of its definition but i think it relates only to scholarly or theoretical (עיוני) knowledge -have a look at their examples","ordan-09 Apr 2004, assign-6 Nov 2003",0,"2004-04-09");
INSERT INTO hebrew_synonyms VALUES (2337,"בְּרִיאַת_הָעוֹלָם","n","00154105","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"Creation",NULL,"בריאת העולם על ידי אלוהים נמשכה שישה ימים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO בריאת העולם appears inside the בריאה entry","ordan-03 Apr 2004, assign-6 Nov 2003",91438,"2004-04-03");
INSERT INTO hebrew_synonyms VALUES (2339,"מְנוּסָה","n","00032687","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"running_away, escape",NULL,"הגנבים נתפסו בשעת המנוסה ממקום הפשע","checked","#ASSIGN:25.0=[gnd=5.0,bt(dir)=5.0,bt(dir)=5.0,bt(crs)=1.0E+01] #MZ@\r\n#NO בריחה is matched to n#00032997","ordan-21 Mar 2004, assign-6 Nov 2003",91439,"2004-03-21");
INSERT INTO hebrew_synonyms VALUES (2340,"בְּרִיחָה","n","00032997","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"running_away",NULL,"מדי שנה נעשים מספר ניסיונות בריחה מבית הכלא","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-21 Mar 2004, assign-6 Nov 2003",91440,"2004-03-21");
INSERT INTO hebrew_synonyms VALUES (2341,"!בְּרֵרָה","n","04463475","nn","dahan","1","rav-milim",NULL,"tg1","(in negative sentence)","alternative, choice",NULL,NULL,"checked","#ASSIGN:169.0=[gnd=39.0,gnd=13.0,si=33.0,bt(dir)=14.0,bt(dir)=14.0,bt(crs)=28.0,bt(dir)=14.0,bt(dir)=14.0] #MZ@\r\n#NO","ordan-28 Mar 2004, assign-6 Nov 2003",0,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (2342,"בְּכַעַס","r","00223640","yy","melingo","1.1","none",NULL,"tg1",NULL,"angrily",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-21 Apr 2004",91441,"2004-04-21");
INSERT INTO hebrew_synonyms VALUES (2343,"בְּרוֹשׁ","n","07947710","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"cypress",NULL,NULL,"checked","#ASSIGN:28.0=[gnd=2.0E+01,glc=8.0] #MZ@\r\n#NO","ordan-15 Apr 2004, assign-6 Nov 2003",91442,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (2344,"בְּרוּטוֹ","n","09539173","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"gross",NULL,"זה שכרי ברוטו, אבל מס הכנסה מנכה מזה 30 אחוז","checked","#ASSIGN:28.0=[gnd=2.0E+01,glc=8.0] #MZ@\r\n#NO","ordan-14 Apr 2004, assign-6 Nov 2003",91443,"2004-04-14");
INSERT INTO hebrew_synonyms VALUES (2345,"בְּתוּלִים","n","10063030","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"virginity",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO RM keeps this sense only for females, I disagree, you may very easily use איבד את בתוליו","ordan-09 Apr 2004",91444,"2004-04-09");
INSERT INTO hebrew_synonyms VALUES (2346,"!בְּתוּלִים","n","06909450","y","dahan","2","rav-milim",NULL,"tg1","(med)","hymen",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2347,"בְּתוּלִים","n","04277222","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"hymen, maidenhead",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-09 Apr 2004, assign-6 Nov 2003",91444,"2004-04-09");
INSERT INTO hebrew_synonyms VALUES (2348,"!בְּתוּלָה","n","07667236","y","dahan","1","rav-milim",NULL,"tg1",NULL,"virgin",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2349,"בִּגּוּד","n","02456798","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"clothing, apparel",NULL,NULL,"checked","#ASSIGN:51.0=[gnd=39.0,bt(dir)=39.0,bt(non)= -27.0] #MZ@\r\n#NO","ordan-07 Apr 2004, assign-6 Nov 2003",91445,"2004-04-07");
INSERT INTO hebrew_synonyms VALUES (6569,"מְבוֹדֵד","n","10706467","yy","none",NULL,"rav-milim","1.1",NULL,NULL,"insulating_material, insulant",NULL,"עץ ידוע כמבודד חשמל","checked","#NO","ordan-04 Apr 2004",91446,"2004-04-04");
INSERT INTO hebrew_synonyms VALUES (2351,"!בִּדּוּד","n","10343743","y","dahan","2","rav-milim",NULL,"tg1","(thermal , electric)","insulation",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2352,"בִּדּוּד","n","00529661","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"insulation",NULL,"קירות שמצטיינים בבידוד חום חוסכים בעלויות החשמל בחורף","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-04 Apr 2004, assign-6 Nov 2003",91447,"2004-04-04");
INSERT INTO hebrew_synonyms VALUES (2353,"בִּדּוּר","n","00332306","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"entertainment",NULL,NULL,"checked","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@\r\n#NO","ordan-07 Apr 2004, assign-6 Nov 2003",91448,"2004-04-07");
INSERT INTO hebrew_synonyms VALUES (2354,"בִּזָּיוֹן","n","10360525","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"shame",NULL,NULL,"checked","#ASSIGN:50=[gnd=1.0E+01,gnd=39.0,si=33.0,bt(non)= -7.0,bt(non)= -3.0E+01,dfl=5.0] #MZ@\r\n#NO","ordan-15 Apr 2004, assign-6 Nov 2003",91449,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (2355,"!בִּזּוּר","n","00739841","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"devolution",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO this Heb sense is already assigned to \'decentralization\' and האצלת סמכויות is already the hypernym of this synset ","ordan-21 Jul 2004, assign-6 Nov 2003",0,"2004-07-21");
INSERT INTO hebrew_synonyms VALUES (2356,"בִּטֵּל","v","01652576","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"abolish",NULL,"במאה ה-19 בוטלה העבדות באמריקה וברוסיה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-15 Apr 2004, assign-6 Nov 2003",91450,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (2357,"!בִּטּוּחַ","n","10426769","y","dahan","1","rav-milim",NULL,"tg1",NULL,"insurance",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2358,"בִּטּוּחַ","n","09608739","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"insurance",NULL,"הביטוח על הטלפון הנייד אינו מכסה אובדן","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-15 Apr 2004, assign-6 Nov 2003",91451,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (2359,"בִּטּוּל","n","00150989","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"abrogation, repeal, annulment",NULL,"בעל הבית ואני הגענו להסכמה על ביטול החוזה בינינו","checked","#ASSIGN:108.0=[gnd=2.0E+01,gnd=39.0,si=49.0] #MZ@\r\n#NO","ordan-03 Apr 2004, assign-6 Nov 2003",90960,"2004-04-03");
INSERT INTO hebrew_synonyms VALUES (2360,"בִּיּוּב","n","10656399","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"sewage",NULL,NULL,"checked","#ASSIGN:96.0=[gnd=39.0,glc=3.0,glc=5.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-09 Apr 2004, assign-6 Nov 2003",91452,"2004-04-09");
INSERT INTO hebrew_synonyms VALUES (2361,"בִּיּוּב","n","03306252","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"sewer",NULL,NULL,"checked","#ASSIGN:74.0=[gnd=2.0E+01,glc=54.0] #MZ@\r\n#NO","ordan-09 Apr 2004, assign-6 Nov 2003",91452,"2004-04-09");
INSERT INTO hebrew_synonyms VALUES (2362,"!בִּיּוּם","n","05256907","undef","dahan","3","rav-milim",NULL,"tg1","(also fig)","staging",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO the closest would be if would nominalize the phrase הֶעֱלָה עַל הַבִּימָה (cf. RM)","ordan-12 Apr 2004, assign-6 Nov 2003",0,"2004-04-12");
INSERT INTO hebrew_synonyms VALUES (2363,"בִּיּוּץ","n","09698142","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"ovulation",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-14 Apr 2004, assign-6 Nov 2003",91453,"2004-04-14");
INSERT INTO hebrew_synonyms VALUES (2364,"בִּירָה","n","05913023","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"beer",NULL,"אחוז האלכוהול בבירה נמוך יחסית למשקאות אלכוהליים אחרים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-13 Apr 2004, assign-6 Nov 2003",91454,"2004-04-13");
INSERT INTO hebrew_synonyms VALUES (2365,"בִּירָה","n","06283013","yy","melingo","1.1","rav-milim","1.1","tg2",NULL,"capital",NULL,"וושינגטון היא בירת ארצות הברית","checked","#ASSIGN:50=[gnd=8.0,flc(pot)=5.0,glc=11.0,dfl=26.0] #MZ@\r\n#NO","ordan-13 Apr 2004, assign-6 Nov 2003",91454,"2004-04-13");
INSERT INTO hebrew_synonyms VALUES (2366,"בִּיתָן","n","03097378","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"pavilion",NULL,"ביריד הוקמו ביתנים רבים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-08 Apr 2004, assign-6 Nov 2003",91455,"2004-04-08");
INSERT INTO hebrew_synonyms VALUES (2367,"!בִּלְבֵּל","v","01138007","nn","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:27.0=[gnd=7.0,gnd=2.0E+01,si=14.0,bt(non)= -14.0] #MZ@\r\n#NO perhaps in the archaic meaning denoted in RM 1.5","ordan-18 Apr 2004, assign-6 Nov 2003",0,"2004-04-18");
INSERT INTO hebrew_synonyms VALUES (2368,"בִּלְבּוּל","n","00043311","yy","melingo","1.1","rav-milim","1.3","tg1",NULL,"confusion, mix_up",NULL,"בשל בלבול במשרד הוחלפו תיקים בין שני לקוחות","checked","#ASSIGN:1.1E+02=[gnd=1.0E+01,bt(dir)=11.0,bt(dir)=39.0,bt(crs)=5.0E+01] #MZ@\r\n#NO","ordan-21 Mar 2004, assign-6 Nov 2003",91456,"2004-03-21");
INSERT INTO hebrew_synonyms VALUES (2369,"!בִּלְעָדִי","a","01791543","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"exclusive",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO בלעדי is matched better to a different sense of ''exclusive'' (a#02070047). ","ordan-21 Mar 2004, assign-6 Nov 2003",0,"2004-03-21");
INSERT INTO hebrew_synonyms VALUES (2370,"!בִּלְעָדִיּוּת","n","03829588","y","dahan","1","rav-milim",NULL,"tg1",NULL,"exclusiveness",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2371,"בִּלּוּי","n","00272358","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"recreation",NULL,"קריאת ספרים הוא אופן הבילוי המועדף עלי","checked","#ASSIGN:50=[gnd=13.0,bt(dir)=16.0,dfl=21.0] #MZ@\r\n#NO","ordan-04 Apr 2004, assign-6 Nov 2003",91457,"2004-04-04");
INSERT INTO hebrew_synonyms VALUES (2372,"בִּנְיָן","n","02347413","yy","melingo","1.1","rav-milim","1.1","tg2",NULL,"building",NULL,"בשל יסודותיו האיתנים, לא נפגע בניין זה מרעידת האדמה","checked","#ASSIGN:31.0=[gnd=1.0E+01,glc=9.0,bt(dir)=12.0] #MZ@\r\n#NO","ordan-08 Apr 2004, assign-6 Nov 2003",90967,"2004-04-08");
INSERT INTO hebrew_synonyms VALUES (2373,"!בִּנּוּי","n","10963303","y","dahan","1","rav-milim",NULL,"tg1",NULL,"reconstruction",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2374,"בִּפְרָט","r","00245145","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-19 Apr 2004, assign-6 Nov 2003",91458,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (2375,"!בִּצָּה","n","06786830","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"swamp, marsh",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IN see \'swamp\'","ordan-05 Aug 2004, assign-6 Nov 2003",0,"2004-08-05");
INSERT INTO hebrew_synonyms VALUES (2376,"בִּצּוּעַ","n","00729882","y","melingo","1.1","rav-milim",NULL,"tg1",NULL,"implementation, execution, carrying_out",NULL,"התוכנית היתה פשוטה לכאורה, אבל ביצועהּ היה כרוך בהמון קשיים","checked","#ASSIGN:3.0E+01=[gnd=2.0E+01,bt(dir)=1.0E+01] #MZ@\r\n”NO","ordan-28 Mar 2004",90969,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (6551,"חֲלוּפָה","n","04463475","yy","melingo",">1.1","rav-milim","1.1",NULL,NULL,"option, alternative",NULL,"סימולציות ממוחשבות משמשות לא פעם כחלופה לניסויים בבעלי חיים","checked","#NO","ordan-28 Mar 2004",91459,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (6552,"אַלְטֶרְנָטִיבָה","n","04463475","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-28 Mar 2004",91460,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (2379,"בִּקְעָה","n","06730976","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"valley",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-13 Apr 2004, assign-6 Nov 2003",91461,"2004-04-13");
INSERT INTO hebrew_synonyms VALUES (2380,"בִּקּוּר","n","00683875","yy","none",NULL,"rav-milim","1.2","tg1",NULL,"visiting",NULL,"הביקור החודשי במוזיאון העירוני הפך לה להרגל","checked","#ASSIGN:50=[gnd=39.0,glc=2.0,dfl=9.0] #MZ@\r\n#NO","ordan-07 Apr 2004, assign-6 Nov 2003",91462,"2004-04-07");
INSERT INTO hebrew_synonyms VALUES (2381,"בִּקּוּשׁ","n","09725817","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"demand",NULL,"כשההיצע עולה על הביקוש המחירים יורדים","checked","#ASSIGN:50=[gnd=8.0,glc=18.0,dfl=24.0] #MZ@\r\n#NO","ordan-15 Apr 2004, assign-6 Nov 2003",91463,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (2382,"בִּשּׁוּל","n","05626343","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"cookery, cooking, cuisine",NULL,NULL,"checked","#ASSIGN:25.0=[gnd=2.0E+01,bt(dir)=19.0,bt(non)= -14.0] #MZ@\r\n#IN","ordan-05 Aug 2004, assign-6 Nov 2003",91464,"2004-08-05");
INSERT INTO hebrew_synonyms VALUES (6556,"בְּדִיחָה","n","05077026","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"joke",NULL,"הבדיחה עוררה צחוק בקרב השומעים","checked","#NO","ordan-28 Mar 2004",91465,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (2385,"בִּשּׁוּל","n","00157100","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"cookery, cooking",NULL,"סדנת הבישול התמקדה בהכנת מאכלים צמחוניים","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO ","ordan-28 Mar 2004",91464,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (6644,"בְּאֹפֶן-כְּלָלִי","r","00039873","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"generally, in_general",NULL,"באופן כללי אני מעדיף להימנע מאכילת ממתקים","checked","#NO its antonym בפרט (this is its distinguishing feature in opposition to the other ''in general'')","ordan-19 Apr 2004",91466,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (6643,"GAP!","r","00062821","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-19 Apr 2004",91467,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (2388,"!בֵּינַיִם","a","01693227","y","dahan","1","rav-milim",NULL,"tg1",NULL,"interim",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2389,"!בֵּינַיִם","a","00963005","y","dahan","2","rav-milim",NULL,"tg1",NULL,"intermediate",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2390,"בֵּינוֹנִי","n","04777587","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"participle",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-06 May 2004, assign-6 Nov 2003",91468,"2004-05-06");
INSERT INTO hebrew_synonyms VALUES (6603,"קוֹמִיקַאי","n","07168145","n","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO\r\n#IE gender","eyal-04 Jul 2005, ordan-14 Apr 2004",0,"2005-07-04");
INSERT INTO hebrew_synonyms VALUES (6597,"רוֹעֵה-צֹאן","n","07569027","yy","none",NULL,"rav-milim","1.1",NULL,NULL,"sheepherder, shepherd, sheepman",NULL,NULL,"checked","#NO","ordan-13 Apr 2004",91470,"2004-04-13");
INSERT INTO hebrew_synonyms VALUES (6601,"רוֹעֶה-בָּקָר","n","07189764","yy","none",NULL,"none",NULL,NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-13 Apr 2004",91471,"2004-04-13");
INSERT INTO hebrew_synonyms VALUES (2394,"!בֵּרוּר","n","00418126","undef","dahan","1","rav-milim",NULL,"tg2","(enquiry)","inquiry",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO Perhaps, but it feels ''softer'' in its seriousness. ","ordan-07 Apr 2004",0,"2004-04-07");
INSERT INTO hebrew_synonyms VALUES (2395,"בֶּטֶן","n","04304826","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"belly, abdomen, stomach",NULL,"אכלתי יותר מדי, כואבת לי הבטן","checked","#ASSIGN:1.5E+02=[gnd=13.0,gnd=39.0,si=2.0E+01,bt(dir)=13.0,bt(dir)=13.0,bt(crs)=26.0,bt(dir)=13.0,bt(dir)=13.0] #MZ@\r\n#NO","ordan-29 Mar 2004",91472,"2004-03-29");
INSERT INTO hebrew_synonyms VALUES (6561,"קֵבָה","n","04194181","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"stomach",NULL,"לאחר שכשל בכל הדיאטות החליט לעשות ניתוח לקיצור קיבה","checked","#NO","ordan-29 Mar 2004",91473,"2004-03-29");
INSERT INTO hebrew_synonyms VALUES (2397,"!בֶּטֶן","n","04304039","nn","dahan","1","rav-milim",NULL,"tg1","(med)","belly, tummy, abdomen",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO although the Hebrew word is כרס we do use בטן in slang to denote כרס: ראית איזה בטן יש לו","ordan-29 Mar 2004",0,"2004-03-29");
INSERT INTO hebrew_synonyms VALUES (2398,"!בֶּטֶן","n","01665080","nn","dahan","1","rav-milim",NULL,"tg1","(med)","belly, tummy, abdomen",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-29 Mar 2004, assign-6 Nov 2003",0,"2004-03-29");
INSERT INTO hebrew_synonyms VALUES (2399,"בֶּטַח","r","00140819","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:7.0E+01=[gnd=39.0,gnd=39.0,si=49.0,bt(non)= -35.0,bt(non)= -22.0] #MZ@\r\n#NO","ordan-18 Apr 2004, assign-6 Nov 2003",91474,"2004-04-18");
INSERT INTO hebrew_synonyms VALUES (2400,"בֶּטוֹן","n","10632664","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"concrete",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-15 Apr 2004, assign-6 Nov 2003",91475,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (2401,"בֶּכִי","n","00557729","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"crying",NULL,"בין האבלים נשמעו קולות בכי","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-28 Mar 2004, assign-6 Nov 2003",91476,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (2402,"בֶּקַע","n","10263905","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"hernia",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-18 Apr 2004, assign-6 Nov 2003",91477,"2004-04-18");
INSERT INTO hebrew_synonyms VALUES (2403,"בֶּרֶז","n","03595967","yy","melingo","1.1","rav-milim","1.1","tg1","(US = faucet)","tap",NULL,"סגור את הברז, האמבטיה כבר מלאה","checked","#ASSIGN:68.0=[gnd=6.0,bt(dir)=26.0,bt(dir)=5.0,bt(crs)=31.0] #MZ@\r\n#NO In Hebrew refers to gaz as well, and not just liquid as in English","ordan-29 Mar 2004",91478,"2004-03-29");
INSERT INTO hebrew_synonyms VALUES (2404,"בֶּרֶךְ","n","02892631","yy","melingo","1.1","rav-milim","1.3","tg1",NULL,"knee",NULL,"מכנסיו היו קרועות בברך","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-29 Mar 2004",91479,"2004-03-29");
INSERT INTO hebrew_synonyms VALUES (2405,"!בֶּרֶךְ","n","01959421","yy","dahan","1","rav-milim","1","tg1",NULL,"knee",NULL,NULL,NULL,"#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n","ordan-29 Mar 2004",0,"2004-03-29");
INSERT INTO hebrew_synonyms VALUES (2406,"בַּאֲדִישׁוּת","r","00367067","yy","none",NULL,"none",NULL,"tg1",NULL,"indifferently",NULL,"הילדים קפצו לקראתו בשמחה, אך הוא הגיב באדישות","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-19 Apr 2004, assign-6 Nov 2003",91480,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (2407,"בַּגְרוּת","n","10874257","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"adulthood, maturity",NULL,"לאחר השנים המבלבלות של התבגרותו, מצא נחת בבגרות","checked","#ASSIGN:57.0=[gnd=2.0E+01,gnd=13.0,si=24.0] #MZ@\r\n#NO","ordan-17 Apr 2004, assign-6 Nov 2003",91481,"2004-04-17");
INSERT INTO hebrew_synonyms VALUES (2408,"בַּד","n","02656657","yy","dahan","1","rav-milim","1","tg1","(material)","cloth",NULL,"בד משי יקר","checked","#ASSIGN:115.0=[gnd=13.0,bt(dir)=17.0,bt(dir)=11.0,bt(dir)=6.0,bt(crs)=68.0] #MZ@ #IE","eyal-22 Jan 2004, assign-6 Nov 2003",91482,"2004-01-22");
INSERT INTO hebrew_synonyms VALUES (2409,"קַנְבָס","n","02380046","nn","dahan","2","none",NULL,"tg1",NULL,"canvas",NULL," ","reviewed","#ASSIGN:50=[gnd=7.0,glc=14.0,dfl=29.0] #MZ@\r\n#NO this is the painting itself, canvas as in the fabric itself n#02379654","ordan-19 Mar 2004, assign-6 Nov 2003",91483,"2004-03-19");
INSERT INTO hebrew_synonyms VALUES (6602,"בַּדְרָן","n","07168145","n","melingo","1.2","rav-milim","1.1",NULL,NULL,"comedian, comic",NULL,NULL,"checked","#NO RM kind of defines it as to denote mostly ''show entertainers'', but it\'s been used as full equivalent of קומיקאי\r\n#IE gender","eyal-04 Jul 2005, ordan-14 Apr 2004",0,"2005-07-04");
INSERT INTO hebrew_synonyms VALUES (2411,"בַּדְרָן","n","06946373","n","melingo","1.1","rav-milim","1.2","tg1",NULL,"entertainer",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO this synset does not refer to a professional comedian - therefore it\'s 1.2 in RM, בדרן may be matched to ''comedian''\r\n#IE gender","eyal-04 Jul 2005, ordan-20 Mar 2004",0,"2005-07-04");
INSERT INTO hebrew_synonyms VALUES (2412,"בַּז","n","01133146","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"falcon",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-19 Mar 2004, assign-6 Nov 2003",91485,"2004-03-19");
INSERT INTO hebrew_synonyms VALUES (2413,"בַּזְבְּזָן","n","07599534","n","melingo","1.1","rav-milim","1.2","tg1",NULL,"spendthrift, spender",NULL,"הבזבזן הזה, לא מפסיק לשפוך כספים","checked","#ASSIGN:108.0=[gnd=2.0E+01,gnd=39.0,si=49.0] #MZ@\r\n#IN\r\n#IE gender","eyal-05 Jul 2005, ordan-05 Aug 2004",0,"2005-07-05");
INSERT INTO hebrew_synonyms VALUES (2414,"בַּזֶּלֶת","n","10592567","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"basalt",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-15 Apr 2004, assign-6 Nov 2003",91487,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (2415,"בַּחֲשַׁאי","r","00162722","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"secretly",NULL,"ראש הממשלה נפגש בחשאי עם מנהיגי האופוזיציה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-18 Apr 2004",91488,"2004-04-18");
INSERT INTO hebrew_synonyms VALUES (2416,"בַּטְלָן","n","07333550","n","melingo","1.1","rav-milim","1.1","tg1",NULL,"idler, loafer, do-nothing, layabout, bum",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO\r\n#IE gender","eyal-05 Jul 2005, ordan-14 Apr 2004",0,"2005-07-05");
INSERT INTO hebrew_synonyms VALUES (2417,"בַּלְשָׁן","n","07376418","n","melingo","1.1","rav-milim","1.1","tg1",NULL,"linguist",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#NO\r\n#IE gender","eyal-05 Jul 2005, ordan-12 Apr 2004, assign-6 Nov 2003",0,"2005-07-05");
INSERT INTO hebrew_synonyms VALUES (6592,"רַב-לְשׁוֹנִי","n","07376166","yy","melingo","1.1","rav-milim","1.2",NULL,NULL,"polyglot",NULL,NULL,"checked","#NO","ordan-12 Apr 2004",91491,"2004-04-12");
INSERT INTO hebrew_synonyms VALUES (6593,"פּוֹלִיגְלוֹט","n","07376166","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,"סבי היה פוליגלוט, בנוסף לשתי השפות שידע מהבית למד עוד חמש נוספות","checked","#NO","ordan-12 Apr 2004",91492,"2004-04-12");
INSERT INTO hebrew_synonyms VALUES (2419,"!בַּלָּאט","r","00189588","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"quietly, secretly, stealthily",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO fits better to r#00189588","ordan-19 Apr 2004, assign-6 Nov 2003",0,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (2420,"!בַּלָּם","n","07095815","y","dahan","1","rav-milim",NULL,"tg1","(in football)","back",NULL,NULL,"assigned","#ASSIGN:33.0=[gnd=4.0,glc=18.0,glc=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2421,"בַּלָּשׁ","n","07214003","n","melingo","1.1","rav-milim","1.2","tg1",NULL,"detective",NULL,"גשש-בלש בפעולה פותר כל תעלומה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO\r\n#IE gender","eyal-05 Jul 2005, ordan-11 Apr 2004, assign-6 Nov 2003",0,"2005-07-05");
INSERT INTO hebrew_synonyms VALUES (2422,"בַּלָּשׁ","n","07213831","n","melingo","1.1","rav-milim","1.1","tg1",NULL,"detective",NULL,"הוא עובד כבלש במחלק סמים במשטרה","checked","#ASSIGN:25.0=[gnd=2.0E+01,bt(dir)=17.0,bt(non)= -12.0] #MZ@\r\n#NO\r\n#IE gender","eyal-04 Jul 2005, ordan-11 Apr 2004",0,"2005-07-04");
INSERT INTO hebrew_synonyms VALUES (2423,"בַּלּוּטָה","n","04132803","y","melingo","1.1","rav-milim","1.1","tg1","(anat)","gland",NULL,NULL,"checked","#ASSIGN:78.0=[gnd=39.0,bt(dir)=39.0] #MZ@\r\n#NO","ordan-19 Mar 2004, assign-6 Nov 2003",91494,"2004-03-19");
INSERT INTO hebrew_synonyms VALUES (6566,"דֶּטֶרְגֶּנְט","n","10831619","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"detergent",NULL,NULL,"checked","#NO","ordan-03 Apr 2004",91495,"2004-04-03");
INSERT INTO hebrew_synonyms VALUES (2425,"!בַּנַּאי","n","07128703","y","dahan","1","rav-milim",NULL,"tg1",NULL,"builder, construction_worker",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2426,"!בַּעֲלַת_בַּיִת","n","07489798","y","dahan","1","rav-milim",NULL,"tg1",NULL,"proprietress",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2427,"!בַּעֲלוּת","n","10386828","y","dahan","1","rav-milim",NULL,"tg1",NULL,"ownership",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2428,"בַּעֲלוּת","n","09525525","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"ownership, possession",NULL,"לאחר שרוכשים רכב יש לגשת לדואר לבצע החלפת בעלות","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-19 Mar 2004, assign-6 Nov 2003",91496,"2004-03-19");
INSERT INTO hebrew_synonyms VALUES (2430,"בַּעֲקִיפִין","r","00056554","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"indirectly",NULL,"תפסיק לדבר בעקיפין, תגיד מה אתה חושב!","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-19 Apr 2004, assign-6 Nov 2003",91497,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (2431,"בַּעַל","n","07331418","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"husband",NULL,NULL,"checked","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=19.0,dfl=11.0] #MZ@\r\n#NO","ordan-20 Mar 2004, assign-6 Nov 2003",90990,"2004-03-20");
INSERT INTO hebrew_synonyms VALUES (6616,"יֹבֶשׁ","n","10952442","yy","none",NULL,"none",NULL,NULL,NULL,"drought",NULL,"לאחר תקופה ארוכה של יובש, כתב ספר חדש","checked","#NO","ordan-15 Apr 2004",91498,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (2433,"בַּצֹּרֶת","n","10425626","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"drought",NULL,"הבצורת פגעה קשות בחקלאות השנה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-15 Apr 2004, assign-6 Nov 2003",91499,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (2434,"בַּרְבּוּר","n","01375081","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"swan",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-19 Mar 2004, assign-6 Nov 2003",91500,"2004-03-19");
INSERT INTO hebrew_synonyms VALUES (2435,"בַּרְרָן","a","00932728","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"choosy",NULL,"היא כה בררנית - אף אחד מבני הזוג ששידכו לה לא מצא חן בעיניה","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO consider also selective and fastidious","ordan-19 Mar 2004",91501,"2004-03-19");
INSERT INTO hebrew_synonyms VALUES (2436,"בַּרְרָנוּת","n","03834766","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"fastidiousness",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-19 Mar 2004",91502,"2004-03-19");
INSERT INTO hebrew_synonyms VALUES (6587,"אֲמָנָה","n","05073898","yy","none",NULL,"rav-milim","1.1",NULL,NULL,"covenant, compact, concordat",NULL,"לפי אמנת ז\'נבה אסור לענות שבויי מלחמה","checked","#NO","ordan-12 Apr 2004",91503,"2004-04-12");
INSERT INTO hebrew_synonyms VALUES (2439,"בָּדוּי","a","01867344","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"fabricated, made-up",NULL,"הסרט צולם בסגנון דוקומנטרי, אך עלילתו בדויה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-17 Feb 2004, assign-6 Nov 2003",91504,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (2440,"בָּהוּל","a","00678779","yy","melingo","1.1","rav-milim","1.1","tg1","(mil)","pressing, urgent",NULL,"יש לשלוח מכתב בהול, אין מקום לעיכובים!","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-16 Feb 2004",91505,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (2441,"בָּז","v","01211520","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"contemn, despise, scorn, disdain",NULL,"מאז שמונה לפרופסור הוא בז למרבית עמיתיו.","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-18 Feb 2004",91506,"2004-02-18");
INSERT INTO hebrew_synonyms VALUES (2442,"!בָּזוּי","a","01532683","u","dahan","1","rav-milim",NULL,"tg1",NULL,"despicable, contemptible",NULL,NULL,"checked","#ASSIGN:73.0=[gnd=2.0E+01,gnd=2.0E+01,si=33.0] #MZ@\r\n#NO","ordan-17 Feb 2004",0,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (2443,"בָּטוּחַ","a","02163862","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"dependable, good, safe, secure",NULL,"אין לך מה לחשוש, זאת השקעה בטוחה.","checked","#ASSIGN:5.0E+01=[gnd=8.0,gnd=6.0,si=9.0,bt(non)= -5.0,bt(dir)=7.0,bt(dir)=5.0,bt(crs)=12.0,bt(non)= -4.0,bt(dir)=7.0,bt(dir)=5.0] #MZ@\r\n#NO only partly agrees with RM","ordan-17 Feb 2004, assign-6 Nov 2003",91000,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (6531,"שָׁכַב-עִם","v","00977560","yy","none",NULL,"rav-milim","1.4",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-19 Mar 2004",91507,"2004-03-19");
INSERT INTO hebrew_synonyms VALUES (6532,"הִזְדַּיֵּן","v","00977560","yy","none",NULL,"rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-19 Mar 2004",91508,"2004-03-19");
INSERT INTO hebrew_synonyms VALUES (2445,"בָּלַט","v","01853436","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"stick_out, protrude",NULL,NULL,"checked","#ASSIGN:73.0=[gnd=2.0E+01,gnd=39.0,si=49.0,bt(non)= -12.0,bt(non)= -23.0] #MZ@\r\n#NO v#01835411 is almost identical, I chose this one becuase it\'s richer in its connections. ","ordan-18 Mar 2004, assign-6 Nov 2003",91509,"2004-03-18");
INSERT INTO hebrew_synonyms VALUES (2447,"בָּסִיס","n","09930598","yy","melingo","1.1","rav-milim","1.2","tg1","(only sing)","basis, ground",NULL,"הוא מרוויח על בסיס עמלה","checked","#ASSIGN:27.0=[gnd=2.0E+01,bt(dir)=21.0,bt(non)= -14.0] #MZ@\r\n#NO","ordan-17 Feb 2004, assign-6 Nov 2003",91004,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (2448,"!בָּסִיס","n","04993010","nn","dahan","1","rav-milim",NULL,"tg2","(army , geom . , chem)","base",NULL,NULL,"checked","#ASSIGN:+inf=[gnd=2.0,glc= +inf,bt(non)= -2.0,bt(dir)=2.0] #MZ@\r\n#NO applies in the idiom שכר יסוד which may be implemented in the sysnet of \'minimum wage\'","ordan-21 Jul 2004, assign-6 Nov 2003",0,"2004-07-21");
INSERT INTO hebrew_synonyms VALUES (2449,"בָּסִיס","n","04465690","yy","melingo","1.2","rav-milim","1.3","tg2","(army , geom . , chem)","basis, foundation",NULL,"זאת טענה מעניינית אבל חסרת כל בסיס","checked","#ASSIGN:73.0=[gnd=2.0,bt(dir)=17.0,bt(dir)=2.0,bt(dir)=5.0,bt(non)= -1.0,bt(crs)=48.0] #MZ@\r\n#NO","ordan-17 Feb 2004",91004,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (2450,"בָּצָל","n","08734702","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"onion",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-19 Mar 2004, assign-6 Nov 2003",91510,"2004-03-19");
INSERT INTO hebrew_synonyms VALUES (2451,"בָּצָל","n","08734429","yy","none",NULL,"rav-milim","1.2","tg1",NULL,"onion",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#NO","ordan-19 Mar 2004, assign-6 Nov 2003",91510,"2004-03-19");
INSERT INTO hebrew_synonyms VALUES (2452,"!בָּצָל","n","05760066","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"onion",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IN","ordan-05 Aug 2004",0,"2004-08-05");
INSERT INTO hebrew_synonyms VALUES (2453,"בָּקִי","a","02389630","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"versed, knowledgeable",NULL,"אינני בקי בתחום, כדאי שתשאל מישהו אחר","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-17 Feb 2004, assign-6 Nov 2003",91511,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (2454,"בָּקָר","n","01899570","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"cattle",NULL,"האיכר הוציא את הבקר לאכול באחו","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-17 Feb 2004",91512,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (2455,"בָּרָד","n","07805321","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"hail",NULL,"סופת הברד פגעה קשה ביבולי האבוקדו השנה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","ordan-17 Feb 2004",91513,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (2456,"!בָּרָד","n","04974751","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"hail",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IN ","ordan-21 Jul 2004, assign-6 Nov 2003",0,"2004-07-21");
INSERT INTO hebrew_synonyms VALUES (2457,"בָּרָק","n","03874574","yy","none",NULL,"rav-milim","1.2","tg1",NULL,"shininess, sheen, luster, lustre",NULL,"הברק שהשתקף מהחלונות סינוור אותה","checked","#ASSIGN:76.0=[gnd=39.0,gnd=13.0,si=24.0] #MZ@\r\n#NO","ordan-17 Feb 2004",91003,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (2459,"מְפֹרָשׁ","a","00893241","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"explicit",NULL,"במקום ללכת סחור סחור, אולי תגיד משהו מפורש!","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-16 Feb 2004, assign-6 Nov 2003",91514,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (2460,"!בָּשָׂר","n","09425258","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"meat",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@#IN","ordan-05 Aug 2004, assign-6 Nov 2003",0,"2004-08-05");
INSERT INTO hebrew_synonyms VALUES (2461,"בָּשָׂר","n","05694720","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"meat",NULL,"צמחונים אינם אוכלים בשר","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-17 Feb 2004, assign-6 Nov 2003",91515,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (2462,"בָּשָׂר","n","09388596","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"pulp, flesh",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-17 Feb 2004, assign-6 Nov 2003",91515,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (2463,"בָּשָׂר","n","04088435","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"flesh",NULL,"החץ חדר את עורו ונכנס לבשר","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-17 Feb 2004",91515,"2004-02-17");
INSERT INTO hebrew_synonyms VALUES (2464,"!בֹּהֶן","n","04313119","u","dahan","1","rav-milim",NULL,"tg1",NULL,"thumb",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO RM doesn\'t demarcate (or somehow begs this issue awkwardly) between ''bohen'' and ''agudal''.","ordan-15 Feb 2004",0,"2004-02-15");
INSERT INTO hebrew_synonyms VALUES (2465,"!בֹּשֶׂם","n","04415246","undef","dahan","1","rav-milim",NULL,"tg1",NULL,"perfume, scent",NULL,NULL,"checked","#ASSIGN:105.0=[gnd=2.0E+01,gnd=13.0,si=24.0,bt(dir)=24.0,bt(dir)=24.0] #MZ@\r\n#NO RM 1.2 lists this sense for בושם , it sounds too weird to me. ","ordan-08 Apr 2004, assign-6 Nov 2003",0,"2004-04-08");
INSERT INTO hebrew_synonyms VALUES (2466,"בֹּשֶׂם","n","03107757","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"perfume",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-08 Apr 2004, assign-6 Nov 2003",91516,"2004-04-08");
INSERT INTO hebrew_synonyms VALUES (2467,"בֻּבָּה","n","02586827","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"doll",NULL,NULL,"checked","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@\r\n#NO","ordan-08 Apr 2004",91517,"2004-04-08");
INSERT INTO hebrew_synonyms VALUES (2468,"!בֻּבָּה","n","03189222","nn","dahan","2","rav-milim",NULL,"tg1",NULL,"puppet",NULL,NULL,"reviewed","#ASSIGN:117.0=[gnd=13.0,bt(dir)=13.0,bt(dir)=39.0,bt(crs)=52.0] #MZ@\r\n#NO ","ordan-08 Apr 2004, assign-6 Nov 2003",0,"2004-04-08");
INSERT INTO hebrew_synonyms VALUES (2469,"בֻּבָּה","n","03189020","yy","melingo","1.1","rav-milim","1.5.1","tg1",NULL,"puppet",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO consider בובת אצבע or בובת יד","ordan-08 Apr 2004, assign-6 Nov 2003",91517,"2004-04-08");
INSERT INTO hebrew_synonyms VALUES (2470,"בֻּכְנָה","n","03131951","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"piston",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-08 Apr 2004, assign-6 Nov 2003",91518,"2004-04-08");
INSERT INTO hebrew_synonyms VALUES (2471,"בּוֹ-זְמַנִּית","r","00117044","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"simultaneously, at_the_same_time",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-18 Apr 2004, assign-6 Nov 2003",91519,"2004-04-18");
INSERT INTO hebrew_synonyms VALUES (2472,"בּוֹגֵר","n","07071944","n","melingo","2.1","rav-milim",">2.1","tg1",NULL,"alumnus, alumna, alum, graduate, grad",NULL,"בקורות החיים ציין שהוא בוגר בית ספר תיכון לאמנויות ובוגר אוניברסיטה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO convergence of senses 2.1 and 2.3 in RM, perhaps deserves two separate ones in Hebrew\r\n#IE gender","eyal-04 Jul 2005, ordan-06 May 2004, assign-6 Nov 2003",0,"2005-07-04");
INSERT INTO hebrew_synonyms VALUES (2473,"בּוֹחֵן","n","07250089","n","melingo","1.1","rav-milim","1.1","tg1",NULL,"tester, examiner",NULL,"הבוחן השגיח על התלמידים שלא יעתיקו את התשובות","checked","#ASSIGN:56.0=[gnd=2.0E+01,gnd=2.0E+01,si=33.0,bt(non)= -17.0] #MZ@\r\n#NO\r\n#IE gender","eyal-05 Jul 2005, ordan-14 Apr 2004",0,"2005-07-05");
INSERT INTO hebrew_synonyms VALUES (2474,"בּוֹחֵר","n","07670539","n","melingo","1.1","rav-milim","1.1","tg1",NULL,"voter",NULL,"בשנת הבחירות האחרונה שיעור הבוחרים מהשמאל היה נמוך במיוחד","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE gender","eyal-05 Jul 2005, ordan-14 Apr 2004, assign-6 Nov 2003",0,"2005-07-05");
INSERT INTO hebrew_synonyms VALUES (2475,"בּוֹלֵט","a","01299804","yy","melingo",">1.1","rav-milim","1.1","tg1",NULL,"jutting, projected, projecting, protruding, sticking, sticking_out",NULL,"מתחתית ההר ראינו את צריחיה הבולטים של המצודה","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO ''salient'' may come in accordance with בולט 1.2 in RM","ordan-21 Mar 2004",91523,"2004-03-21");
INSERT INTO hebrew_synonyms VALUES (2476,"!בּוֹקֵר","n","07317144","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"cowboy, herdsman",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO בוקר refers only to בקר (cattle) whereas this sysnet is more general ","ordan-13 Apr 2004, assign-6 Nov 2003",0,"2004-04-13");
INSERT INTO hebrew_synonyms VALUES (2477,"בּוֹרֵר","n","07081299","n","melingo","1.1","rav-milim","1.1","tg1",NULL,"arbitrator",NULL,"הם מינו בורר שיישב את הסכסוך ביניהם","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO\r\n#IE gender","eyal-04 Jul 2005, ordan-14 Apr 2004",0,"2005-07-04");
INSERT INTO hebrew_synonyms VALUES (2478,"בּוּז","n","05577544","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"contempt, scorn",NULL,NULL,"checked","#ASSIGN:45.0=[gnd=1.0E+01,gnd=2.0E+01,gnd=2.0E+01,si=29.0,bt(non)= -17.0,bt(non)= -17.0] #MZ@\r\n#NO","ordan-12 Apr 2004, assign-6 Nov 2003",91525,"2004-04-12");
INSERT INTO hebrew_synonyms VALUES (2479,"!בּוּז","n","05037154","y","dahan","1","rav-milim",NULL,"tg1",NULL,"contempt, scorn, disdain",NULL,NULL,"assigned","#ASSIGN:33.0=[gnd=1.0E+01,gnd=2.0E+01,si=2.0E+01,bt(non)= -17.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2481,"בּוּעָה","n","06802591","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"bubble",NULL,"הילד הפריח בועות סבון באוויר","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-14 Apr 2004, assign-6 Nov 2003",91526,"2004-04-14");
INSERT INTO hebrew_synonyms VALUES (2482,"בּוּר","a","00791837","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"ignorant",NULL,"על אף ששני הוריו עובדים בתזמורת, הוא נשאר בור גמור בכל מה שנוגע למוזיקה","checked","#ASSIGN:29.0=[gnd=7.0,glc=27.0,bt(non)= -5.0] #MZ@\r\n#NO","ordan-20 Mar 2004",91527,"2004-03-20");
INSERT INTO hebrew_synonyms VALUES (2483,"!בּוּר","a","00539545","nn","dahan","1","rav-milim",NULL,"tg1","(lacking knowledge)","ignorant",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=7.0,glc=27.0,bt(non)= -5.0] #MZ@\r\n#NO cannot be applied to non-humans","ordan-05 May 2004, assign-6 Nov 2003",0,"2004-05-05");
INSERT INTO hebrew_synonyms VALUES (2484,"!בּוּר","a","02162798","nn","dahan","1","rav-milim",NULL,"tg1","(lacking knowledge)","ignorant",NULL,NULL,"checked","#ASSIGN:61.0=[gnd=7.0,glc=27.0,glc=27.0] #MZ@\r\n#NO","ordan-05 May 2004, assign-6 Nov 2003",0,"2004-05-05");
INSERT INTO hebrew_synonyms VALUES (2485,"חֲסר-יֶדַע","a","01255019","yy","none",NULL,"none",NULL,"tg1",NULL,"ignorant, unknowledgeable",NULL,NULL,"checked","#ASSIGN:61.0=[gnd=7.0,glc=27.0,glc=27.0] #MZ@\r\n#NO","ordan-04 Apr 2004, assign-6 Nov 2003",91528,"2004-04-04");
INSERT INTO hebrew_synonyms VALUES (2486,"בּוּר","a","00792028","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"ignorant",NULL,NULL,"checked","#ASSIGN:61.0=[gnd=7.0,glc=27.0,glc=27.0] #MZ@\r\n#NO refers to 1.1 in בור as a noun in RM (as opposed to the adjective)","ordan-20 Mar 2004, assign-6 Nov 2003",91527,"2004-03-20");
INSERT INTO hebrew_synonyms VALUES (2487,"לֹא-בָּקִי","a","02389816","yy","none",NULL,"none",NULL,"tg1",NULL,"unversed, ignorant",NULL,"הוא לא בקי בהלכות משפחה","checked","#ASSIGN:61.0=[gnd=7.0,glc=27.0,glc=27.0] #MZ@\r\n#NO","ordan-04 Apr 2004",91529,"2004-04-04");
INSERT INTO hebrew_synonyms VALUES (2488,"בּוּרוּת","n","04591530","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"ignorance",NULL,"אי ידיעת קרוא וכתוב נחשבת בורות במערב","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-12 Apr 2004",91530,"2004-04-12");
INSERT INTO hebrew_synonyms VALUES (2489,"בּוּשָׁה","n","10360525","yy","melingo","1.1","none",NULL,"tg1",NULL,"shame, disgrace",NULL,"הקיצוץ בקצבות הנכים - פשוט בושה","checked","#ASSIGN:232.0=[gnd=1.0E+01,gnd=39.0,si=33.0,bt(dir)=11.0,bt(dir)=39.0,bt(crs)=5.0E+01,bt(dir)=11.0,bt(dir)=39.0] #MZ@\r\n#NO RM converges this sense in 1.2 (בושה), consider especially their second example which doesn\'t fit their definition of this sense","ordan-15 Apr 2004",91531,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (2490,"גִ\'ינְגִ\'י","a","00371098","yy","melingo","1","rav-milim","1.2","tg1",NULL,"ginger",NULL,"יש לו שיער ג\'ינג\'י ועיניים כחולות","reviewed","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-24 Feb 2004, assign-6 Nov 2003",91532,"2004-02-24");
INSERT INTO hebrew_synonyms VALUES (2491,"!גּ\'וּק","n","01739872","y","dahan","1","rav-milim",NULL,"tg1","(insect)","bug",NULL,NULL,"assigned","#ASSIGN:50=[gnd=8.0,glc=27.0,dfl=15.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2492,"!גְּבִיָּה","n","04889243","y","dahan","1","rav-milim",NULL,"tg1","(of money due)","collection",NULL,NULL,"assigned","#ASSIGN:50=[gnd=1.0E+01,glc=11.0,dfl=29.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2493,"חֶלְמִית","n","08476962","yy","melingo","1","rav-milim","1.1","tg1",NULL,"mallow",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-10 Mar 2004, assign-6 Nov 2003",91533,"2004-03-10");
INSERT INTO hebrew_synonyms VALUES (2494,"גְּבִינָה","n","05881045","yy","melingo","1","rav-milim","1.1","tg1",NULL,"cheese",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-10 Mar 2004, assign-6 Nov 2003",91534,"2004-03-10");
INSERT INTO hebrew_synonyms VALUES (2495,"לֵיְדִּי","n","07200414","yy","melingo","2","rav-milim","1.3","tg1","(colloquial)","lady",NULL,"איך שהיא תמיד מטופחת ומסודרת - ממש ליידי","checked","#ASSIGN:50=[gnd=13.0,bt(dir)=19.0,dfl=18.0] #MZ@","eyal-08 Mar 2004",91535,"2004-03-08");
INSERT INTO hebrew_synonyms VALUES (2496,"מָדָם","n","07386233","yy","melingo","2","rav-milim","1.2","tg1",NULL,"madam",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-08 Mar 2004, assign-6 Nov 2003",91536,"2004-03-08");
INSERT INTO hebrew_synonyms VALUES (2497,"גְּבֶרֶת","n","07200414","yy","melingo","2","rav-milim","1.2","tg1",NULL,"madam",NULL,NULL,"checked","#ASSIGN:25.0=[gnd=2.0E+01,bt(dir)=19.0,bt(non)= -14.0] #MZ@ #IE","eyal-08 Mar 2004, assign-6 Nov 2003",91537,"2004-03-08");
INSERT INTO hebrew_synonyms VALUES (2498,"גְּבֶרֶת","n","07681693","yy","melingo","1","rav-milim","1.1","tg1","(a married woman)","Mrs",NULL,"שלום, גברת לוי, איך אפשר לעזור לך","checked","#ASSIGN:123.0=[gnd=39.0,glc=8.0,glc=5.0,glc=14.0,glc=8.0,bt(dir)=49.0] #MZ@ #IE","eyal-08 Mar 2004",91537,"2004-03-08");
INSERT INTO hebrew_synonyms VALUES (2499,"נַעֲרָה","n","07290496","yy","none",NULL,"rav-milim","1.2","tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:38.0=[gnd=2.0E+01,glc=14.0,bt(non)= -11.0,bt(dir)=15.0] #MZ@ #IE","eyal-09 May 2004",91538,"2004-05-09");
INSERT INTO hebrew_synonyms VALUES (2500,"!גְּבֶרֶת","n","05456179","y","dahan","5","rav-milim",NULL,"tg1","(unmarried woman)","Miss",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2501,"גְּבוּל","n","10019535","yy","melingo","1","rav-milim","1.1","tg1",NULL,"border, frontier",NULL,"הגבול בין ישראל למצרים עובר בטאבה","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-09 Mar 2004, assign-6 Nov 2003",91008,"2004-03-09");
INSERT INTO hebrew_synonyms VALUES (2502,"!גְּבוּל","n","06273824","y","dahan","1","rav-milim",NULL,"tg1",NULL,"border, frontier",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2503,"!גְּבוּל","n","04595466","y","dahan","1","rav-milim",NULL,"tg1",NULL,"border, frontier",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2504,"גְּבוּרָה","n","03806460","yy",NULL,NULL,"rav-milim","1.1","tg1",NULL,"heroism",NULL,"הוא קיבל מדליה עבור הגבורה שהפגין בקרב","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE","eyal-04 Mar 2004, assign-6 Nov 2003",91539,"2004-03-04");
INSERT INTO hebrew_synonyms VALUES (6491,"GAP!","n","10583496","yy",NULL,NULL,NULL,NULL,NULL,NULL,"kid, kidskin",NULL,NULL,"checked","#IE in Hebrew, we don\'t have a specific word for kidskin, only a free combination of words","eyal-02 Mar 2004",90808,"2004-03-02");
INSERT INTO hebrew_synonyms VALUES (2506,"גְּדִי","n","01913446","yy","melingo","1.1","rav-milim","1.1","tg1","(young goat)","kid",NULL,"לא תבשל גדי בחלב אימו (שמות ל''ד)","revised","#ASSIGN:6.0E+01=[gnd=1.0E+01,glc=11.0,glc=27.0,bt(dir)=12.0] #MZ@ #IE","ordan-10 Aug 2004, eyal-02 Mar 2004, assign-6 Nov 2003",91540,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (2507,"מַזַּל-גְּדִי","n","06395233","yy","melingo","1","rav-milim","1.1","tg1","(zodiac)","capricorn",NULL,NULL,"checked","#ASSIGN:63.0=[gnd=2.0E+01,glc=27.0,glc=16.0] #MZ@ #IE","eyal-02 Mar 2004, assign-6 Nov 2003",91541,"2004-03-02");
INSERT INTO hebrew_synonyms VALUES (2508,"גְּדוּד","n","06096346","yy","melingo","1","rav-milim","1.1","tg1",NULL,"regiment",NULL,"אחי משרת בגדוד של חטיבת הצנחנים","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-10 Mar 2004, assign-6 Nov 2003",91542,"2004-03-10");
INSERT INTO hebrew_synonyms VALUES (2509,"!גְּזַר_דִין","n","00772379","y","dahan","1","rav-milim",NULL,"tg1",NULL,"verdict",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2510,"חָלוּק","n","02764938","n","melingo","1","rav-milim",">1.1","tg1",NULL,"gown",NULL,"רופאים בחלוקים לבנים הקיפו את מיטתו","checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@ #IE the RM sense is broader and includes any garment that is worn during work to protect one\'s clothes","eyal-10 Jul 2005, eyal-03 Mar 2004",0,"2005-07-10");
INSERT INTO hebrew_synonyms VALUES (2511,"גְּלִימָה","n","02764776","yy","melingo","2","sapir","1.2","tg1",NULL,"cloak, gown",NULL,"השופטים התעטפו בגלימותיהם השחורות ונכנסו חמורי סבר לאולם","checked","#ASSIGN:81.0=[gnd=2.0E+01,gnd=13.0,si=16.0,bt(dir)=16.0,bt(dir)=16.0] #MZ@ #IE","eyal-03 Mar 2004, assign-6 Nov 2003",91544,"2004-03-03");
INSERT INTO hebrew_synonyms VALUES (2512,"שִׂמְלַת-עֶרֶב","n","02764599","yf","none","2","none","1.1","tg1",NULL,"gown",NULL,"הנשים הופיעו לאירוע הצדקה בשמלות ערב מפוארות","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE ''gown'' appears as ''שמלת ערב'' in melingo English-Hebrew dictionary","eyal-28 Feb 2005, eyal-03 Mar 2004, assign-6 Nov 2003",94661,"2005-02-28");
INSERT INTO hebrew_synonyms VALUES (2513,"גְּלָלִים","n","10654891","yy","melingo","1","rav-milim","1.1","tg1",NULL,"dung, droppings",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-18 Mar 2004, assign-6 Nov 2003",91546,"2004-03-18");
INSERT INTO hebrew_synonyms VALUES (2514,"גְּלוּיָה","n","04972377","yy","melingo","1","rav-milim","1.1","tg1",NULL,"postcard",NULL,"בעת שהותו בחו''ל, נהג הבן לשלוח לאימו גלויה אחת לשבוע","checked","#ASSIGN:50=[gnd=39.0,bt(dir)=3.0,dfl=8.0] #MZ@ #IE","eyal-08 Mar 2004, assign-6 Nov 2003",91547,"2004-03-08");
INSERT INTO hebrew_synonyms VALUES (2515,"גְּלוּיוֹת","r","00052077","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"openly",NULL,"אני רוצה לדבר איתך גלויות ולומר לך את אשר על ליבי","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-09 May 2004, eyal-18 Mar 2004, assign-6 Nov 2003",91548,"2004-05-09");
INSERT INTO hebrew_synonyms VALUES (2516,"!גְּלוּלָה","n","03123283","y","dahan","1","rav-milim",NULL,"tg1",NULL,"pill",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2517,"גְּלוּלָה","n","03123093","yy","melingo","1","rav-milim","1.1","tg1",NULL,"pill",NULL,"הרופא רשם לי גלולות נגד כאב הראש","checked","#ASSIGN:65.0=[gnd=13.0,bt(dir)=13.0,bt(dir)=13.0,bt(crs)=26.0] #MZ@ #IE","eyal-03 Mar 2004",91549,"2004-03-03");
INSERT INTO hebrew_synonyms VALUES (2518,"!גְּנִיחָה","n","05332420","y","dahan","1","rav-milim",NULL,"tg1",NULL,"groan",NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2519,"גְּנֵבָה","n","00499179","yy","melingo","1.1","rav-milim","1.1","tg2",NULL,"theft, stealing",NULL,"יש לצערינו גניבות רבות בשדה התעופה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","ordan-10 Aug 2004",91550,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (2520,"גְּעָרָה","n","05033972","yy","melingo","1","rav-milim","1.1","tg1",NULL,"reprimand",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-09 Mar 2004, assign-6 Nov 2003",91551,"2004-03-09");
INSERT INTO hebrew_synonyms VALUES (2521,"גְּרִימָה","n","00101562","yy","melingo","1.1","rav-milim","1.1","tg1","(act)","causing",NULL,"בעקבות הניתוח הואשם הצוות הרפואי בגרימת נזק בלתי הפיך לרגליו","checked","#ASSIGN:50=[gnd=39.0,glc=4.0,dfl=7.0] #MZ@ #IE\r\n#NO","ordan-10 Aug 2004",91552,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (2522,"גְּרִיסִים","n","05836741","yy",NULL,"1","rav-milim","1.1","tg1",NULL,"groats",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-08 Mar 2004, assign-6 Nov 2003",91553,"2004-03-08");
INSERT INTO hebrew_synonyms VALUES (2523,"גְּרִירָה","n","00073753","yy","melingo","1.2","rav-milim","1.2","tg1","(car etc)","tow",NULL,"המנוע התחמם כל כך במהלך הנסיעה, כך שנאלצתי לעצור את הרכב בצד ולהזמין שירות גרירה למוסך","revised","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","ordan-10 Aug 2004, eyal-29 Feb 2004, assign-6 Nov 2003",91554,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (2524,"!גְּרוּשָׁה","n","07219938","y","dahan","1","rav-milim",NULL,"tg1",NULL,"divorcee",NULL,NULL,"assigned","#ASSIGN:78.0=[gnd=39.0,bt(dir)=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2525,"גִּבְעָה","n","06723275","yy","melingo","1","rav-milim","1.1","tg1",NULL,"hill",NULL,"עלינו על הגבעה הקטנה על מנת לראות את הנוף","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-03 Mar 2004, assign-6 Nov 2003",91555,"2004-03-03");
INSERT INTO hebrew_synonyms VALUES (2526,"!גִּבְעָה","n","03019094","y","dahan","1","rav-milim",NULL,"tg1",NULL,"hill",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2527,"תֵּל","n","03018868","yy","dahan","1","sapir","1.2","tg1",NULL,"hill, mound",NULL,"בנינו תל קטן מכל האבנים שאספנו","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-03 Mar 2004",91235,"2004-03-03");
INSERT INTO hebrew_synonyms VALUES (2528,"גַּבְנוּן","n","10405722","yy","melingo","1","rav-milim","1.1","tg1",NULL,"hunchback, kyphosis",NULL,"לגיבן מנוטרדם היה גבנון ענקי שעיוות את גופו","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-24 Feb 2004, assign-6 Nov 2003",91556,"2004-02-24");
INSERT INTO hebrew_synonyms VALUES (2529,"גִּבֵּן","n","07330311","n","melingo","1","rav-milim","1.1","tg1","(person)","hunchback",NULL,"הגיבן מנוטרדם הוא דמות ספרותית ידועה","checked","#ASSIGN:53.0=[gnd=2.0E+01,glc=9.0,bt(dir)=24.0] #MZ@\r\n#IE gender","eyal-06 Jul 2005, eyal-24 Feb 2004, assign-6 Nov 2003",0,"2005-07-06");
INSERT INTO hebrew_synonyms VALUES (2530,"הִכְפִּישׁ","v","00574815","yy","melingo","2","rav-milim","1.1","tg1",NULL,"vilify, revile, vituperate",NULL,"הפרופוגנדה הנאצית הכפישה את היהודים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-24 Feb 2004",91558,"2004-02-24");
INSERT INTO hebrew_synonyms VALUES (2531,"!גִּדֵּל","v","00158819","y","dahan","1","rav-milim",NULL,"tg1","(plants , hair)",NULL,NULL,NULL,"assigned","#ASSIGN:+inf=[gnd=4.0,glc= +inf] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2532,"גִּדּוּל","n","10226609","yy",NULL,NULL,"rav-milim","1.5","tg1","(med)","tumour",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE I used Oxford dictionary for this definition since Melingo does not translate ''gidul'' as ''tumour''","eyal-18 Mar 2004",91559,"2004-03-18");
INSERT INTO hebrew_synonyms VALUES (2533,"גִּהֵץ","v","00953839","yy","melingo","1","rav-milim","1.1","tg1",NULL,"iron",NULL,"אנא גהץ את חולצותיך, הן מאד מקומטות","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-24 Feb 2004, assign-6 Nov 2003",91560,"2004-02-24");
INSERT INTO hebrew_synonyms VALUES (2534,"גִּהֵק","v","00002561","yy","melingo","1","rav-milim","1.1","tg1",NULL,"burp, bubble, belch",NULL,"בסין זה נחשב מנומס לגהק בשעת הארוחה","checked","#ASSIGN:57.0=[gnd=2.0E+01,gnd=39.0,si=49.0,bt(non)= -17.0,bt(non)= -34.0] #MZ@ #IE","eyal-24 Feb 2004, assign-6 Nov 2003",91561,"2004-02-24");
INSERT INTO hebrew_synonyms VALUES (2535,"גִּהוּץ","n","02867844","yy","melingo","1","rav-milim","1a","tg1","colloquial","ironing",NULL,"יש לי ערימה של גיהוץ - זה בטח יקח לי שעתיים לפחות","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-24 Feb 2004",91562,"2004-02-24");
INSERT INTO hebrew_synonyms VALUES (2536,"גִּהוּץ","n","00380753","yy","melingo","1","rav-milim","1.1","tg1","(act)","ironing",NULL,"מצעים העשויים מבד סינטטי אינם מתקמטים בזמן הכביסה ולכן אינם דורשים גיהוץ","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-24 Feb 2004, assign-6 Nov 2003",91562,"2004-02-24");
INSERT INTO hebrew_synonyms VALUES (2537,"גִּהוּק","n","00075113","yy","melingo","1","rav-milim","1.1","tg1",NULL,"belch, burp",NULL,"בסוף כל ארוחה יש להרים את התינוק לגיהוק","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-24 Feb 2004, assign-6 Nov 2003",91563,"2004-02-24");
INSERT INTO hebrew_synonyms VALUES (2538,"גִּזְבָּר","n","07650559","n","melingo","1","rav-milim","1.1","tg1",NULL,"treasurer",NULL,"גזבר המועצה התנגד לתוספת תקציב לבניית גני משחקים בישוב","checked","#ASSIGN:78.0=[gnd=39.0,bt(dir)=39.0] #MZ@ #IE gender","eyal-06 Jul 2005, eyal-24 Feb 2004, assign-6 Nov 2003",0,"2005-07-06");
INSERT INTO hebrew_synonyms VALUES (2539,"!גִּזְעִי","a","01834252","n","melingo","1.1","rav-milim","1.1","tg1","(animal)","pedigree",NULL,NULL,"checked","#ASSIGN:57.0=[gnd=39.0,glc=18.0] #MZ@ \r\n#IE it seems that גזעי fits better to ''purebred'', and this synset should be something like ''בעל שושלת יוחסין''","eyal-01 Aug 2005, eyal-06 Jul 2005, ordan-17 Aug 2004",0,"2005-08-01");
INSERT INTO hebrew_synonyms VALUES (2541,"!גִּזְעִי","a","02874344","nn","dahan","3","rav-milim",NULL,"tg1",NULL,"racial",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IN","ordan-17 Aug 2004, assign-6 Nov 2003",0,"2004-08-17");
INSERT INTO hebrew_synonyms VALUES (2542,"גִּזְעִי","a","01859739","yy","oxford","1.1","none",NULL,"tg1",NULL,"racial",NULL,"אפליה על רקע גזעי","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE derived from the word ''geza'' in Hebrew. There was no definition for ''giz\'ee'' in this sense in RM nor in Sapir","eyal-11 Aug 2004, eyal-29 Feb 2004",91565,"2004-08-11");
INSERT INTO hebrew_synonyms VALUES (2543,"גִּזְעָנִי","a","01860484","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"racist",NULL,"הוא השמיע הערות גזעניות בגנות השחורים באמריקה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE\r\n#NO","ordan-10 Aug 2004",91566,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (2544,"!גִּזְעָנִי","a","00280184","n","dahan","1","rav-milim",NULL,"tg1",NULL,"racist",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-27 Jul 2005, assign-6 Nov 2003",0,"2005-07-27");
INSERT INTO hebrew_synonyms VALUES (2545,"גִּזְעָנוּת","n","04702580","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"racism",NULL,"יותר מכל תנועה, מזוהה הנאציזם עם גזענות","revised","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","ordan-10 Aug 2004, eyal-01 Mar 2004, assign-6 Nov 2003",91567,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (2546,"גִּזְעָנוּת","n","00748682","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"racism",NULL,"גילויי הגזענות נגד השחורים בארה''ב בשנות ה-50 וה-60 של המאה העשרים היו מחרידים","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE refers to the second part of RM\'s definition","eyal-11 Aug 2004, eyal-01 Mar 2004, assign-6 Nov 2003",91567,"2004-08-11");
INSERT INTO hebrew_synonyms VALUES (2547,"גִּזְרָה","n","04436807","yy","none",NULL,"sapir","1.1","tg1","(of clothes)","cut",NULL,"השמלה הזו היא בעלת גזרה מסורתית","checked","#ASSIGN:50=[gnd=2.0,glc=33.0,dfl=15.0] #MZ@ #IE the definitions in RM and Sapir describe the dressmaking pattern and not the style. However, since ''cut'' is the closest word in RM to this meaning of ''gizra'', I left it as is","eyal-09 Mar 2004",91568,"2004-03-09");
INSERT INTO hebrew_synonyms VALUES (2548,"לַעַג","n","05037006","yy","melingo","1","rav-milim","1.1","tg1",NULL,"ridicule, derision",NULL,"דיבורו היה רווי בבוז ולעג","checked","#ASSIGN:111.0=[gnd=39.0,gnd=39.0,si=33.0] #MZ@ #IE","eyal-09 Mar 2004",91569,"2004-03-09");
INSERT INTO hebrew_synonyms VALUES (2549,"גִּיּוּס","n","00820277","yy","melingo","3","rav-milim","<1.1","tg1",NULL,"recruitment",NULL,"לצורך המשך פעילות החברה הוא נזקק לגיוס עובדים רבים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE this is more or less a combination between definitions 1 and 2 in RM","eyal-01 Mar 2004",91570,"2004-03-01");
INSERT INTO hebrew_synonyms VALUES (2550,"גִּיּוּס","n","00798373","yy","melingo","4","rav-milim","1.2","tg1",NULL,"mobilization",NULL,"יש צורך בגיוס תמיכה ציבורית חזקה לעניין זה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE ","eyal-01 Mar 2004, assign-6 Nov 2003",91570,"2004-03-01");
INSERT INTO hebrew_synonyms VALUES (2551,"גִּיּוּס","n","00749110","yy","melingo","1.2","rav-milim","<1.1","tg1","(in an emergency)","mobilization",NULL,"עקב המצב הבטחוני המתוח, כוחות המילואים קיבלו צו גיוס חירום מיוחד","checked","#ASSIGN:58.0=[gnd=2.0E+01,glc=14.0,bt(dir)=24.0] #MZ@ \r\n#IE refers to the second part of RM\'s definition","eyal-11 Aug 2004, eyal-01 Mar 2004",91570,"2004-08-11");
INSERT INTO hebrew_synonyms VALUES (2553,"גִּיר","n","10621972","yy","melingo","3","rav-milim","1.1","tg1",NULL,"chalk",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-24 Feb 2004, assign-6 Nov 2003",91571,"2004-02-24");
INSERT INTO hebrew_synonyms VALUES (2554,"!גִּיר","n","03878188","y","dahan","1","rav-milim",NULL,"tg1",NULL,"chalk",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2555,"גִּיר","n","02419477","yy","melingo","2","rav-milim","1.2","tg1",NULL,"chalk",NULL,"המורה תמיד כותב בגיר צבעוני על הלוח","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-24 Feb 2004, assign-6 Nov 2003",91571,"2004-02-24");
INSERT INTO hebrew_synonyms VALUES (2556,"גִּלּוּחַ","n","00163357","yy","melingo","1.1","rav-milim","1.1","tg1","(act)","shave",NULL,NULL,"revised","#ASSIGN:50=[gnd=39.0,glc=4.0,glc=2.0,dfl=5.0] #MZ@ #IE","ordan-10 Aug 2004, eyal-24 Feb 2004, assign-6 Nov 2003",91572,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (2557,"!גִּלּוּי","n","05389592","y","dahan","2","rav-milim",NULL,"tg1","(act)","discovery",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2558,"!גִּלּוּי","n","05389592","y","dahan","1","rav-milim",NULL,"tg1",NULL,"discovery",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2559,"גִּלּוּי","n","05388870","yy","melingo","2","rav-milim",">1.2","tg1",NULL,"revelation, disclosure",NULL,"חלק גדול מזמנו הקדיש העיתונאי לגילוי פרטים נוספים על הפרשה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE the RM definition is broader and includes, besides the act of revealing, the thing that was revealed","eyal-09 Mar 2004",91573,"2004-03-09");
INSERT INTO hebrew_synonyms VALUES (2560,"!גִּלּוּי","n","04475351","y","dahan","2","rav-milim",NULL,"tg1",NULL,"revelation",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6510,"GAP!","n","04854052","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE a concept from the New Testament","eyal-09 Mar 2004",90808,"2004-03-09");
INSERT INTO hebrew_synonyms VALUES (2562,"גִּמְגֵּם","v","00664326","yy","melingo","1","rav-milim","1.1","tg1",NULL,"stutter, stammer",NULL,"כששאלתי אותו למעשיו, הוא גימגם במבוכה","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE","eyal-24 Feb 2004, assign-6 Nov 2003",91574,"2004-02-24");
INSERT INTO hebrew_synonyms VALUES (2563,"גִּמְגּוּם","n","10334727","yy","melingo","1","rav-milim","1.1","tg1",NULL,"stammer, stutter",NULL,"הגמגום שלו היה בולט במיוחד כאשר נאלץ לעמוד מול קהל","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@IE","eyal-24 Feb 2004, assign-6 Nov 2003",91575,"2004-02-24");
INSERT INTO hebrew_synonyms VALUES (2564,"!גִּנָּה","n","06242655","y","dahan","1","rav-milim",NULL,"tg1",NULL,"garden",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2565,"!גִּנָּה","n","02739225","y","dahan","1","rav-milim",NULL,"tg1",NULL,"garden",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2566,"גִּנָּה","n","02738912","yy","melingo","1","rav-milim","1.1","tg1",NULL,"garden",NULL,"שתלנו בגינה שלנו כמה סוגי ירקות","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-02 Mar 2004, assign-6 Nov 2003",91576,"2004-03-02");
INSERT INTO hebrew_synonyms VALUES (2567,"גִּרְגֵּר","v","00718213","yy","melingo","1","rav-milim","1.2","tg1",NULL,"gargle",NULL,"החתול מגרגר כשמלטפים אותו","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-24 Feb 2004, assign-6 Nov 2003",91577,"2004-02-24");
INSERT INTO hebrew_synonyms VALUES (2568,"גִּרְגֵּר","v","00026214","yy","melingo","1","rav-milim","1.1","tg1",NULL,"gargle",NULL,"עליך לגרגר עם מי הפה שלוש פעמים ביום","checked","#ASSIGN:26.0=[gnd=2.0E+01,bt(dir)=21.0,bt(non)= -15.0] #MZ@ #IE","eyal-24 Feb 2004, assign-6 Nov 2003",91577,"2004-02-24");
INSERT INTO hebrew_synonyms VALUES (2569,"!גֵּאֶה","a","01231908","y","dahan","1","rav-milim",NULL,"tg1",NULL,"proud",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2570,"גֵּאֶה","a","01817423","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"proud",NULL,"הוא היה גאה מאד בהשגיו הלימודיים","revised","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","ordan-10 Aug 2004, eyal-29 Feb 2004, assign-6 Nov 2003",91578,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (2571,"גֵּאוּת","n","10395158","yy",NULL,NULL,"rav-milim","1.2","tg1","(economic)","boom",NULL,"הגיאות בתחום מכירת הדירות יצרה עליית מחירים תלולה","checked","#ASSIGN:50=[gnd=8.0,glc=11.0,glc=7.0,dfl=24.0] #MZ@ #IE I used Oxford dictionary for this definition","eyal-18 Mar 2004, assign-6 Nov 2003",91579,"2004-03-18");
INSERT INTO hebrew_synonyms VALUES (2572,"גֵּרוּשִׁין","n","00778442","yy","melingo","1","rav-milim","1.1","tg1",NULL,"divorce",NULL,"תהליך הגירושין היה טראומתי לשני בני הזוג","checked","#ASSIGN:55.0=[gnd=2.0E+01,glc=11.0,bt(dir)=24.0] #MZ@ #IE","eyal-01 Mar 2004, assign-6 Nov 2003",91580,"2004-03-01");
INSERT INTO hebrew_synonyms VALUES (2573,"!גֵּרוּשׁ","n","00230520","y","dahan","1","rav-milim",NULL,"tg1",NULL,"expulsion",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2574,"גֵּרוּשׁ","n","00135765","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"expulsion, ejection",NULL,"הילד היה עסוק בגירוש החתולים מהחצר","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","ordan-10 Aug 2004",91581,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (2575,"!גֵּרוּשׁ","n","00074431","y","dahan","1","rav-milim",NULL,"tg1",NULL,"expulsion",NULL,NULL,"assigned","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2576,"גֶּבֶס","n","10520893","yy","melingo","1","rav-milim","1.1","tg1",NULL,"gypsum",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-18 Mar 2004, assign-6 Nov 2003",91582,"2004-03-18");
INSERT INTO hebrew_synonyms VALUES (2577,"גֶּבֶס","n","10759377","yy","melingo","2","rav-milim","1.2","tg1",NULL,"plaster",NULL,"הילדים נהנו מאד ליצור פסלונים קטנים מגבס","checked","#ASSIGN:81.0=[gnd=1.0E+01,glc=54.0,glc=5.0,bt(dir)=12.0] #MZ@ #IE","eyal-18 Mar 2004",91582,"2004-03-18");
INSERT INTO hebrew_synonyms VALUES (6526,"גּוּמִי","n","02485388","yy","melingo","1.1","rav-milim","1.4",NULL,"(slang)","rubber",NULL,NULL,"checked","#IE","eyal-01 Feb 2005, eyal-18 Mar 2004",91583,"2005-02-01");
INSERT INTO hebrew_synonyms VALUES (2580,"מָאצ\'וֹ","n","07616904","yy","melingo","2","rav-milim","1.1","tg1",NULL,"he-man, stud, macho-man",NULL,"הוא תמיד מגלם בסרטיו דמות של מאצ\'ו שתלטן ואגרסיבי","checked","#ASSIGN:93.0=[gnd=39.0,glc=5.0,bt(dir)=49.0] #MZ@ #IE","eyal-01 Mar 2004, assign-6 Nov 2003",91584,"2004-03-01");
INSERT INTO hebrew_synonyms VALUES (2581,"גֶּזַע","n","09450405","yy","melingo","1","rav-milim","1.1","tg1","(of tree)","trunk",NULL,"את גילו של עץ ניתן לקבוע לפי מספר הטבעות שבגזעו","checked","#ASSIGN:3.0E+01=[gnd=8.0,glc=14.0,bt(dir)=8.0] #MZ@ #IE","eyal-18 Mar 2004, assign-6 Nov 2003",91585,"2004-03-18");
INSERT INTO hebrew_synonyms VALUES (2582,"מְטַפֵּס","n","09393003","yy",NULL,NULL,"rav-milim","1.1","tg1",NULL,"vine",NULL,"המטפס ששתלנו ליד הגדר כבר כיסה את רובה","checked","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@ #IE I used Oxford dictionary for this definition","eyal-18 Mar 2004",91586,"2004-03-18");
INSERT INTO hebrew_synonyms VALUES (2583,"שַׁרְווּל-רוּחַ","n","05416617","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"wind_sleeve",NULL,"שרוול הרוח חישב להיקרע מעוצמת הרוח","checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@ #IE","eyal-04 Mar 2004, assign-6 Nov 2003",91587,"2004-03-04");
INSERT INTO hebrew_synonyms VALUES (2584,"גֶּרֶב","n","03364657","yy","melingo","1","rav-milim","1.1","tg1",NULL,"sock",NULL,"לא נהוג לגרוב גרביים מתחת לסנדלים","revised","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","ordan-10 Aug 2004, eyal-04 Mar 2004, assign-6 Nov 2003",91588,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (2585,"!גֶּשֶׁם","n","10770918","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"rain",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE I chose to assign the word גשם to the other synset of ''rain'' due to its relation to weather","eyal-17 Mar 2004, assign-6 Nov 2003",0,"2004-03-17");
INSERT INTO hebrew_synonyms VALUES (2586,"גֶּשֶׁם","n","07830260","yy","melingo","1","rav-milim","1.1","tg1",NULL,"rain",NULL,"הגשם ירד במשך שלוש שעות ברציפות ויצר שלוליות ענק","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-17 Mar 2004, assign-6 Nov 2003",91589,"2004-03-17");
INSERT INTO hebrew_synonyms VALUES (2587,"גֶּשֶׁם","n","03938934","yy","melingo","2","rav-milim","1.2","tg1",NULL,"rain",NULL,"הוא המטיר עליו גשם של קללות","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-04 Mar 2004, assign-6 Nov 2003",91589,"2004-03-04");
INSERT INTO hebrew_synonyms VALUES (2588,"גַּאַוְתָן","a","01819704","yy","melingo","2","rav-milim","1.1","tg1",NULL,"conceited",NULL,"הוא גאוותן וגס רוח","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-29 Feb 2004, assign-6 Nov 2003",91590,"2004-02-29");
INSERT INTO hebrew_synonyms VALUES (2589,"גַּב","n","04306040","yy","melingo","1","rav-milim",">1.1","tg1","(of a person or animal)","back, dorsum",NULL,"הגב שלו היה שזוף להפליא","checked","#ASSIGN:27.0=[gnd=4.0,glc=18.0,bt(dir)=5.0] #MZ@ #IE a combination of definitions 1&2 in RM: the first refers to humans only, and the second to animals only","eyal-09 Mar 2004, assign-6 Nov 2003",91591,"2004-03-09");
INSERT INTO hebrew_synonyms VALUES (2590,"גַּבָּה","n","04123270","yy","melingo","1","rav-milim","1.1","tg1",NULL,"brow, eyebrow",NULL,NULL,"checked","#ASSIGN:241.0=[gnd=13.0,gnd=39.0,si=33.0,bt(dir)=39.0,bt(dir)=13.0,bt(crs)=52.0,bt(dir)=39.0,bt(dir)=13.0] #MZ@ #IE","eyal-05 Mar 2004, assign-6 Nov 2003",91592,"2004-03-05");
INSERT INTO hebrew_synonyms VALUES (6504,"GAP!","n","06329985","yy",NULL,NULL,NULL,NULL,NULL,NULL,"hilltop",NULL,NULL,"checked","#IE in Hebrew the translation is a free combination of words (Rosh Giv\'ah)","eyal-05 Mar 2004",90808,"2004-03-05");
INSERT INTO hebrew_synonyms VALUES (2592,"!גַּג","n","03250547","y","dahan","1","rav-milim",NULL,"tg1",NULL,"roof",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2593,"גַּג","n","03250224","yy","melingo","1","rav-milim","1.1","tg1",NULL,"roof",NULL,"בלילות קיץ חמים הילדים נהנים לישון על הגג","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-04 Mar 2004, assign-6 Nov 2003",91593,"2004-03-04");
INSERT INTO hebrew_synonyms VALUES (6513,"קְלוֹץ","n","07383205","yy",NULL,NULL,"rav-milim","1.1",NULL,NULL,"klutz",NULL,NULL,"revised","#IE","ordan-10 Aug 2004, eyal-15 Mar 2004",91594,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (2595,"גַּיִס","n","06095338","yy","melingo","1","rav-milim","1.1","tg1","(army)","corps",NULL,NULL,"checked","#ASSIGN:63.0=[gnd=2.0E+01,glc=27.0,glc=16.0] #MZ@ #IE","eyal-10 Mar 2004, assign-6 Nov 2003",91595,"2004-03-10");
INSERT INTO hebrew_synonyms VALUES (2596,"גַּלְעֵד","n","02984139","yy","melingo","1","rav-milim","1.1","tg1",NULL,"memorial, monument",NULL,NULL,"checked","#ASSIGN:50=[gnd=13.0,gnd=13.0,si=2.0E+01,bt(non)= -11.0,dfl=15.0] #MZ@ #IE","eyal-03 Mar 2004, assign-6 Nov 2003",91596,"2004-03-03");
INSERT INTO hebrew_synonyms VALUES (2597,"גַּלְשָׁן","n","03448363","yy","melingo","1","rav-milim","1.1","tg1",NULL,"surfboard",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE in Hebrew, this word refers to ''surfboard'' (galshan galim) and also to ''sailboard'' (galshan ruach). ''Sailboard'' was not found in WN","eyal-04 Mar 2004",91597,"2004-03-04");
INSERT INTO hebrew_synonyms VALUES (2598,"גַּמָּד","n","07232039","n","melingo","1","rav-milim","1.1","tg1",NULL,"dwarf",NULL,NULL,"checked","#ASSIGN:25.0=[gnd=2.0E+01,bt(dir)=19.0,bt(non)= -14.0] #MZ@ \r\n#IE gender","eyal-06 Jul 2005, eyal-15 Mar 2004, assign-6 Nov 2003",0,"2005-07-06");
INSERT INTO hebrew_synonyms VALUES (2599,"גַּמָּד","n","06893154","yy","melingo","2","sapir","2","tg1","(legendary)","dwarf",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-15 Mar 2004",91598,"2004-03-15");
INSERT INTO hebrew_synonyms VALUES (2600,"!גַּן","n","06242655","y","dahan","1","rav-milim",NULL,"tg1",NULL,"garden",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2601,"!גַּן","n","02739225","y","dahan","1","rav-milim",NULL,"tg1",NULL,"garden",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2602,"גַּן","n","02738912","yy","melingo","1","rav-milim","1.1","tg1",NULL,"garden",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-02 Mar 2004, assign-6 Nov 2003",91599,"2004-03-02");
INSERT INTO hebrew_synonyms VALUES (2603,"גַּנְדְּרָן","n","07200787","yy","melingo","1","rav-milim","1","tg1",NULL,"fop, dandy",NULL,"הגנדרן הזה עומד שעות מול המראה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-06 Jul 2005, eyal-15 Mar 2004, assign-6 Nov 2003",91600,"2005-07-06");
INSERT INTO hebrew_synonyms VALUES (2604,"גַּנְזַךְ","n","02206789","yy","melingo","1","rav-milim","1.1","tg1",NULL,"archive",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-02 Mar 2004, assign-6 Nov 2003",91601,"2004-03-02");
INSERT INTO hebrew_synonyms VALUES (2605,"גַּנָּב","n","07639852","n","melingo","1","rav-milim","1.1","tg1",NULL,"thief",NULL,"בילי הנער הינו בין הגנבים המפורסמים ביותר בעולם","checked","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@ \r\n#IE gender","eyal-06 Jul 2005, eyal-17 Mar 2004, assign-6 Nov 2003",0,"2005-07-06");
INSERT INTO hebrew_synonyms VALUES (2606,"!גַּס","a","02124533","y","dahan","1","rav-milim",NULL,"tg1",NULL,"rough",NULL,NULL,"assigned","#ASSIGN:50=[gnd=3.0,bt(dir)=8.0,bt(dir)=4.0,bt(crs)=12.0,dfl=23.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2607,"!גַּס","a","00779258","n","dahan","2","rav-milim",NULL,"tg1",NULL,"rude",NULL,NULL,"assigned","#ASSIGN:50=[gnd=8.0,bt(dir)=7.0,bt(dir)=9.0,bt(crs)=16.0,dfl=1.0E+01] #MZ@\r\n#IE","eyal-01 Aug 2005, assign-6 Nov 2003",0,"2005-08-01");
INSERT INTO hebrew_synonyms VALUES (2608,"גַּעְגּוּעִים","n","05565891","yy","melingo","1","rav-milim","1.1","tg1",NULL,"longing, yearning",NULL,"הוא חש געגועים עזים לארץ בה נולד ובה לא ביקר מזה עשור","checked","#ASSIGN:142.0=[gnd=39.0,gnd=39.0,si=98.0,bt(non)= -34.0] #MZ@ #IE","eyal-08 Mar 2004, assign-6 Nov 2003",91603,"2004-03-08");
INSERT INTO hebrew_synonyms VALUES (2609,"גַּרְזֶן","n","02229021","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"axe",NULL,NULL,"revised","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","ordan-10 Aug 2004, eyal-02 Mar 2004, assign-6 Nov 2003",91604,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (2610,"גַּרְעִין","n","06689681","yy","melingo","2","rav-milim","1.3","tg1","(of atom)","nucleus",NULL,NULL,"checked","#ASSIGN:50=[gnd=1.0E+01,glc=27.0,dfl=13.0] #MZ@ #IE a common abbreviation for ''atomic nucleus''","eyal-10 Mar 2004",91605,"2004-03-10");
INSERT INTO hebrew_synonyms VALUES (2611,"גַּרְעִינִים","n","08462710","yy",NULL,NULL,"rav-milim","following 1.7","tg1",NULL,"grain",NULL,NULL,"checked","#ASSIGN:50=[gnd=6.0,glc=27.0,dfl=17.0] #MZ@ #IE","eyal-10 Mar 2004, assign-6 Nov 2003",91606,"2004-03-10");
INSERT INTO hebrew_synonyms VALUES (2612,"גַּשָּׁשׁ","n","07646471","nn","melingo","1","rav-milim","1.1","tg1","(person)","tracker",NULL,"הגששים התחקו אחר עקבותיהם של המחבלים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ \r\n#IE gender","eyal-28 Feb 2005, eyal-17 Mar 2004, assign-6 Nov 2003",0,"2005-02-28");
INSERT INTO hebrew_synonyms VALUES (6495,"GAP!","n","07260752","yy",NULL,NULL,NULL,NULL,NULL,NULL,"fence",NULL,NULL,"checked","#IE exist in Hebrew only as a free combination of words - סוחר בסחורה גנובה","eyal-02 Mar 2004",90808,"2004-03-02");
INSERT INTO hebrew_synonyms VALUES (2614,"גָּדֵר","n","02670460","yy","melingo","1","rav-milim","1.1","tg1",NULL,"fence",NULL,"בזכות הגדר שהקמנו, נמנעת הכניסה של כלבים תועים לחצר שלנו","checked","#ASSIGN:25.0=[gnd=2.0E+01,bt(dir)=19.0,bt(non)= -14.0] #MZ@ #IE","eyal-02 Mar 2004, assign-6 Nov 2003",91608,"2004-03-02");
INSERT INTO hebrew_synonyms VALUES (6537,"גִּמֵּר","v","00863766","yy",NULL,NULL,"rav-milim","1.1",NULL,"(of furniture)","finish",NULL,NULL,"checked","#IE","eyal-21 Mar 2004",91609,"2004-03-21");
INSERT INTO hebrew_synonyms VALUES (2616,"גָּדַל","v","00107371","yy","melingo","4","rav-milim","1.4","tg1","(in amount , number)","increase",NULL,"בחודש האחרון כמות העבודה גדלה באופן משמעותי","checked","#ASSIGN:52.0=[gnd=2.0E+01,glc=8.0,bt(dir)=24.0] #MZ@ #IE","eyal-21 Mar 2004, assign-6 Nov 2003",91023,"2004-03-21");
INSERT INTO hebrew_synonyms VALUES (2617,"הֶעֱלָה","v","00104604","u","melingo","1.2","rav-milim","1.2","tg1","(in amount , number)","increased",NULL,"סוף סוף המנהל שלה העלה לה את המשכורת","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE העלה fits better to v#00108988","eyal-29 Nov 2004, eyal-21 Mar 2004, assign-6 Nov 2003",0,"2004-11-29");
INSERT INTO hebrew_synonyms VALUES (2618,"מְבֻגָּר","n","06938480","n","none",NULL,"rav-milim","1.1","tg1",NULL,"grown_up",NULL,"לכל טיול שנתי יש לצרף לפחות שלושה מבוגרים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ \r\n#IE gender","eyal-03 Jul 2005, eyal-09 May 2004, eyal-22 Feb 2004, assign-6 Nov 2003",0,"2005-07-03");
INSERT INTO hebrew_synonyms VALUES (2619,"מְעֹרָם","a","00504043","yy","melingo","1","rav-milim","1.1","tg1",NULL,"heaped, piled",NULL,"הספרים היו מעורמים על השולחן בחוסר סדר","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-25 Feb 2004, assign-6 Nov 2003",91612,"2004-02-25");
INSERT INTO hebrew_synonyms VALUES (2620,"גָּוֶן","n","03876333","yy","melingo","1","rav-milim","1.2","tg1","(of colour)","shade, tint",NULL,"אחרי נסיונות רבים הוא הצליח להגיע לגוון הורוד שהוא רצה","checked","#ASSIGN:34.0=[gnd=8.0,bt(dir)=9.0,bt(dir)=4.0,bt(crs)=13.0] #MZ@ #IE","eyal-04 Mar 2004, assign-6 Nov 2003",91613,"2004-03-04");
INSERT INTO hebrew_synonyms VALUES (2621,"גָּוֶן","n","04955518","yy","melingo","3","sapir","1.3","tg1",NULL,"nuance",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,bt(dir)=1.0E+01,dfl=1.0] #MZ@ #IE","eyal-04 Mar 2004, assign-6 Nov 2003",91613,"2004-03-04");
INSERT INTO hebrew_synonyms VALUES (2622,"גָּזַז","v","01075277","yy","melingo","1","sapir","1.1","tg1","(wool)","shear",NULL,"לקראת הקיץ גוזזים את צמרן של כל הכבשים בדיר","checked","#ASSIGN:50=[gnd=13.0,glc=18.0,dfl=19.0] #MZ@ #IE","eyal-22 Mar 2004, assign-6 Nov 2003",91614,"2004-03-22");
INSERT INTO hebrew_synonyms VALUES (2623,"גָּלְמִי","a","00388398","yy","melingo","1.1","none",NULL,"tg1",NULL,"crude, raw",NULL,"נתונים גולמיים","revised","#ASSIGN:29.0=[gnd=7.0,bt(dir)=7.0,bt(dir)=4.0,bt(crs)=11.0] #MZ@ #IE\r\n#IN ","ordan-17 Aug 2004, ordan-10 Aug 2004, ordan-18 Jul 2004, eyal-25 Feb 2004, assign-6 Nov 2003",91615,"2004-08-17");
INSERT INTO hebrew_synonyms VALUES (2624,"גָּלַשׁ","v","01321425","yy","melingo","2","rav-milim","1.2","tg1",NULL,"ski",NULL,"הוא גלש במדרון המושלג במהירות מסחררת","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE RM 1.3 also correponds with this definition, since WN does not distinct between ski on ice and ski on water, and RM does","eyal-22 Mar 2004",91616,"2004-03-22");
INSERT INTO hebrew_synonyms VALUES (2625,"גָּלַשׁ","v","00261817","yy","melingo","1","rav-milim","1.1","tg1",NULL,"boil_over, overboil",NULL,"שכחתי לכבות את האש מתחת למרק, והוא גלש ולכלך את הכיריים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-22 Mar 2004, assign-6 Nov 2003",91616,"2004-03-22");
INSERT INTO hebrew_synonyms VALUES (2626,"!גָּלוּת","n","07252140","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"exile",NULL,NULL,"revised","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-21 Sep 2004, wintner-20 Sep 2004",0,"2004-09-21");
INSERT INTO hebrew_synonyms VALUES (2627,"גּוֹלֶה","n","07252035","yy","melingo","1","rav-milim","1.1","tg1",NULL,"exile, deportee",NULL," בתקופה ההלניסטית נאחזו יהודים גולים באסיה\r\n הקטנה ובאיי הים, ביוון ובחופי אפריקה","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-29 Feb 2004",91617,"2004-02-29");
INSERT INTO hebrew_synonyms VALUES (2628,"הַגְלָיָה","n","00136174","yy","melingo","1.1","sapir","1.1","tg1",NULL,"exile, deportation, expatriation",NULL,"אלפרד דרייפוס הורד מדרגתו וקיבל גזר דין של הגליה לנצח לאי השדים","revised","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","ordan-10 Aug 2004, eyal-29 Feb 2004, assign-6 Nov 2003",91618,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (2629,"גָּמִישׁ","a","00975648","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"flexible, pliable",NULL,"אני מוכן להיות גמיש ולהוריד מעט את מחיר הדירה","revised","#ASSIGN:134.0=[gnd=8.0,gnd=2.0E+01,si=16.0,bt(dir)=21.0,bt(dir)=9.0,bt(crs)=3.0E+01,bt(dir)=21.0,bt(dir)=9.0] #MZ@ #IE","ordan-10 Aug 2004, eyal-29 Feb 2004",91619,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (2630,"גָּמִישׁ","a","00803427","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"elastic",NULL,"ענפי העץ היו רכים וגמישים","revised","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","ordan-10 Aug 2004, eyal-25 Feb 2004, assign-6 Nov 2003",91619,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (2631,"גָּמָל","n","01933103","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"camel",NULL,NULL,"revised","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE","ordan-10 Aug 2004, eyal-23 Feb 2004, assign-6 Nov 2003",91620,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (2632,"גָּפְרִית","n","10502703","yy","dahan","1","rav-milim","1.1","tg1","(US = sulfur)","sulphur",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-23 Feb 2004, assign-6 Nov 2003",91621,"2004-02-23");
INSERT INTO hebrew_synonyms VALUES (2633,"גָּפְרָה","n","10808144","yy","dahan","1","rav-milim","1.1","tg1",NULL,"sulphate",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-23 Feb 2004, assign-6 Nov 2003",91622,"2004-02-23");
INSERT INTO hebrew_synonyms VALUES (2634,"!גָּרוּשׁ","a","01421281","y","dahan","1","rav-milim",NULL,"tg1",NULL,"divorced",NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2635,"!גָּרוּשׁ","n","07219938","y","dahan","1","rav-milim",NULL,"tg1",NULL,"divorcee",NULL,NULL,"assigned","#ASSIGN:78.0=[gnd=39.0,bt(dir)=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2636,"רוּם","n","03998008","yy","melingo","1","rav-milim","1.1","tg1",NULL,"height, altitude",NULL,"רוב העננות היתה ברום של 800 רגל","checked","#ASSIGN:63.0=[gnd=1.0E+01,gnd=13.0,si=16.0,bt(dir)=12.0,bt(dir)=12.0] #MZ@ #IE","eyal-05 Mar 2004, assign-6 Nov 2003",91623,"2004-03-05");
INSERT INTO hebrew_synonyms VALUES (2637,"רוֹבּוֹט","n","02226816","yy","melingo","1","rav-milim","1.2","tg1",NULL,"robot",NULL,"נושא השימוש ברובוטים בחדרי ניתוח תופס תאוצה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-02 Mar 2004, assign-6 Nov 2003",91624,"2004-03-02");
INSERT INTO hebrew_synonyms VALUES (2638,"!גֹּלֶם","n","01815040","y","dahan","3","rav-milim",NULL,"tg1","(of batterfly)","chrysalis",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2639,"גּוֹאֵל","n","07547514","yy","melingo","1","rav-milim","1.1","tg1",NULL,"saviour",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-17 Mar 2004, assign-6 Nov 2003",91625,"2004-03-17");
INSERT INTO hebrew_synonyms VALUES (2640,"גּוֹזָל","n","01135737","yy","melingo","1","rav-milim","1.1","tg1",NULL,"young_bird",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-01 Mar 2004, assign-6 Nov 2003",91626,"2004-03-01");
INSERT INTO hebrew_synonyms VALUES (2641,"הַגּוֹרָל","n","06861200","yy","none",NULL,"none",NULL,"tg1",NULL,"Destiny, Fate",NULL,"אנו עומדים חסרי אונים מול הגורל","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-16 Sep 2005, assign-6 Nov 2003",0,"2005-09-16");
INSERT INTO hebrew_synonyms VALUES (2643,"גּוּמִי","n","10769087","yy","melingo","1","rav-milim","1.1","tg1","(subtance)","rubber",NULL,NULL,"checked","#ASSIGN:52.0=[gnd=1.0E+01,bt(dir)=8.0,bt(dir)=13.0,bt(crs)=21.0] #MZ@ #IE","eyal-18 Mar 2004, assign-6 Nov 2003",91583,"2004-03-18");
INSERT INTO hebrew_synonyms VALUES (2644,"!גּוּפָה","n","04056524","y","dahan","1","rav-milim",NULL,"tg1",NULL,"corpse",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,bt(dir)=33.0,bt(non)= -23.0,bt(non)= -23.0,dfl=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2645,"נָמוּךְ","a","02274731","yy","melingo","1","rav-milim","1.1","tg1","(in stature)","short",NULL,"הילד הנמוך בכיתה יושב תמיד בשורה הראשונה","checked","#ASSIGN:50=[gnd=3.0,glc=27.0,dfl=2.0E+01] #MZ@ #IE","eyal-24 Feb 2004, assign-6 Nov 2003",91627,"2004-02-24");
INSERT INTO hebrew_synonyms VALUES (2646,"!גּוּר","n","07195668","y","dahan","1","rav-milim",NULL,"tg1",NULL,"cub",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2647,"גּוּר","n","00866478","yy","melingo","1","rav-milim","<1.1","tg1",NULL,"cub",NULL,"הלביאה המליטה 3 גורים זכרים","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE the Hebrew sence is broader and includes all the young mammals","eyal-01 Mar 2004, assign-6 Nov 2003",91032,"2004-03-01");
INSERT INTO hebrew_synonyms VALUES (2648,"גֹּלֶם","n","07383205","yy","melingo","1.5","rav-milim","1.5","tg1","(person)","goon, oaf",NULL,"מה אתה יושב כמו גולם - קום ותזמין אותה לרקוד","revised","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=12.0,dfl=18.0] #MZ@ #IE","ordan-10 Aug 2004, eyal-15 Mar 2004, assign-6 Nov 2003",91628,"2004-08-10");
INSERT INTO hebrew_synonyms VALUES (2650,"!דְּאָגָה","n","04491326","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"worry, anxiety, concern",NULL,NULL,"checked","#ASSIGN:1.3E+02=[gnd=2.0E+01,gnd=8.0,si=12.0,bt(dir)=9.0,bt(dir)=21.0,bt(crs)=3.0E+01,bt(dir)=9.0,bt(dir)=21.0] #MZ@\r\n#NO doesn\'t denote the ORIGIN of this condition","ordan-28 May 2004, assign-6 Nov 2003",0,"2004-05-28");
INSERT INTO hebrew_synonyms VALUES (2651,"דְּאָגָה","n","05593817","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"distress, worry, trouble",NULL,"מרוב דאגות הוא לא מצליח לעשות את המוטל עליו","checked","#ASSIGN:27.0=[gnd=2.0E+01,bt(dir)=21.0,bt(non)= -14.0] #MZ@\r\n#NO","ordan-28 May 2004",91629,"2004-05-28");
INSERT INTO hebrew_synonyms VALUES (2652,"!דְּבַשׁ","n","05887861","y","dahan","1","rav-milim",NULL,"tg1",NULL,"honey",NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2653,"!דְּהִירָה","n","00187201","y","dahan","1","rav-milim",NULL,"tg1",NULL,"gallop",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2654,"!דְּחִיסָה","n","00229544","y","dahan","1","rav-milim",NULL,"tg1","(act)","compressing",NULL,NULL,"assigned","#ASSIGN:53.0=[gnd=39.0,glc=2.0,bt(dir)=12.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2655,"!דְּחִיסוּת","n","03863303","y","dahan","1","rav-milim",NULL,"tg1",NULL,"compressibility",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2656,"!דְּחִיפוּת","n","10368281","y","dahan","1","rav-milim",NULL,"tg1",NULL,"urgency",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2657,"!דְּחִיפוּת","n","04028238","y","dahan","1","rav-milim",NULL,"tg1",NULL,"urgency",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2658,"!דְּלִי","n","09913096","y","dahan","1","rav-milim",NULL,"tg1","(US = pail)","bucket",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2659,"!דְּלִי","n","02344831","y","dahan","1","rav-milim",NULL,"tg1","(US = pail)","bucket",NULL,NULL,"assigned","#ASSIGN:96.0=[gnd=2.0E+01,bt(dir)=19.0,bt(dir)=19.0,bt(crs)=38.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2660,"!דְּלִיפָה","n","05532335","y","dahan","1","rav-milim",NULL,"tg1",NULL,"leak",NULL,NULL,"assigned","#ASSIGN:53.0=[gnd=8.0,bt(non)= -5.0,bt(dir)=8.0,bt(dir)=17.0,bt(crs)=25.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2661,"!דְּלַעַת","n","08464304","y","dahan","1","rav-milim",NULL,"tg1",NULL,"pumpkin",NULL,NULL,"assigned","#ASSIGN:37.0=[gnd=2.0E+01,bt(dir)=17.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2662,"!דְּלַעַת","n","05772123","y","dahan","1","rav-milim",NULL,"tg1",NULL,"pumpkin",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2663,"!דְּקִירָה","n","00761046","y","dahan","1","rav-milim",NULL,"tg1",NULL,"stab",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (8059,"קוֹד","n","04792090","yy","melingo","1.1","rav-milim","1.2",NULL,NULL,"code",NULL,NULL,"checked","#IE","eyal-27 Jan 2005",94235,"2005-01-27");
INSERT INTO hebrew_synonyms VALUES (2666,"!דִּגְדּוּג","n","00093873","y","dahan","1","rav-milim",NULL,"tg1","(act)","tickling",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,glc=4.0,glc=2.0,dfl=5.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2667,"!דִּיּוּק","n","03768956","y","dahan","1","rav-milim",NULL,"tg1",NULL,"accuracy, precision",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2668,"!דִּישׁוֹן","n","01916377","y","dahan","1","rav-milim",NULL,"tg1","(animal)","antelope",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2669,"!דִּמְיוֹן","n","03730047","y","dahan","2","rav-milim",NULL,"tg1","(to)","resemblance",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2670,"!דִּמּוּי","n","05319077","y","dahan","1","rav-milim",NULL,"tg2",NULL,"metaphor, simile",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2671,"!דִּמּוּי","n","05317845","y","dahan","1","rav-milim",NULL,"tg2",NULL,"metaphor, simile",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2672,"!דִּקְלוּם","n","05407138","y","dahan","1","rav-milim",NULL,"tg1",NULL,"declamation",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2673,"!דִּקּוּר","n","00455463","y","dahan","1","rav-milim",NULL,"tg1","(med .)","acupuncture",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2674,"דֵּעָה","n","05079660","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"opinion",NULL,"דיעותיו הוצגו באופן קבוע במאמר המערכת","checked","#ASSIGN:27.0=[gnd=7.0,bt(dir)=6.0,bt(dir)=4.0,bt(crs)=1.0E+01] #MZ@\r\n#IE","eyal-06 Jul 2005, assign-6 Nov 2003",90854,"2005-07-06");
INSERT INTO hebrew_synonyms VALUES (7424,"וִילוֹן","n","02536246","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"curtain, drape",NULL,"הוא הסיט את הוילון כדי לתת לקרני השמש לחדור לחדר החשוך","checked","#IE","eyal-26 Sep 2004",93425,"2004-09-26");
INSERT INTO hebrew_synonyms VALUES (2676,"!דֶּרֶךְ","n","00266805","y","dahan","1","rav-milim",NULL,"tg1",NULL,"way",NULL,NULL,"assigned","#ASSIGN:50=[gnd=3.0,bt(dir)=3.0,bt(dir)=12.0,bt(crs)=15.0,dfl=17.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2677,"!דֶּשֶׁן","n","10657851","y","dahan","1","rav-milim",NULL,"tg1",NULL,"fertilizer",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2678,"!דַּבֶּשֶׁת","n","10012108","y","dahan","1","rav-milim",NULL,"tg1","(of camel)","hump",NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2679,"!דַּבּוּר","n","01717162","y","dahan","1","rav-milim",NULL,"tg1",NULL,"hornet",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2680,"!דַּוְשָׁה","n","05131232","y","dahan","1","rav-milim",NULL,"tg1",NULL,"pedal",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2681,"!דַּוְשָׁה","n","03099621","y","dahan","1","rav-milim",NULL,"tg1",NULL,"pedal",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2682,"!דַּחְלִיל","n","03280310","y","dahan","1","rav-milim",NULL,"tg1",NULL,"scarecrow",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2683,"!דַּחְפּוֹר","n","02350401","y","dahan","1","rav-milim",NULL,"tg1",NULL,"bulldozer",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2684,"!דַּיְסָה","n","05902479","y","dahan","1","rav-milim",NULL,"tg1",NULL,"porridge",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2685,"!דַּיִג","n","00288265","y","dahan","1","rav-milim",NULL,"tg1","(act)","fishing",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2686,"!דַּיִג","n","00288131","y","dahan","1","rav-milim",NULL,"tg1","(act)","fishing",NULL,NULL,"assigned","#ASSIGN:48.0=[gnd=2.0E+01,glc=4.0,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2687,"!דַּיִשׁ","n","00252246","y","dahan","1","rav-milim",NULL,"tg1","(act)","threshing",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2688,"!דַּיָּג","n","07266374","y","dahan","1","rav-milim",NULL,"tg1",NULL,"fisherman",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2689,"!דַּיֶּלֶת","n","07611457","y","dahan","1","rav-milim",NULL,"tg1",NULL,"stewardess, air_hostess",NULL,NULL,"assigned","#ASSIGN:308.0=[gnd=39.0,gnd=39.0,si=98.0,bt(dir)=33.0,bt(dir)=11.0,bt(crs)=44.0,bt(dir)=33.0,bt(dir)=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2690,"!דַּיָּר","n","07636278","y","dahan","1","rav-milim",NULL,"tg1",NULL,"tenant",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2691,"!דַּיָּר","n","07636191","y","dahan","1","rav-milim",NULL,"tg1",NULL,"tenant",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2692,"!דַּיָּר","n","07635964","y","dahan","1","rav-milim",NULL,"tg1",NULL,"tenant",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2693,"!דַּלְפוֹן","n","07463556","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"pauper",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO have a look at the comment of ''RASH'' card","ordan-13 Feb 2004",0,"2004-02-13");
INSERT INTO hebrew_synonyms VALUES (2694,"דַּלּוּת","n","10397144","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"poverty",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-22 Dec 2004, assign-6 Nov 2003",93909,"2004-12-22");
INSERT INTO hebrew_synonyms VALUES (2695,"!דַּפְנָה","n","08015110","y","dahan","1","rav-milim",NULL,"tg1",NULL,"bay, laurel",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2696,"!דַּפְנָה","n","08015534","y","dahan","1","rav-milim",NULL,"tg1",NULL,"bay, laurel",NULL,NULL,"assigned","#ASSIGN:98.0=[gnd=6.0,bt(dir)=23.0,bt(dir)=23.0,bt(crs)=46.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2697,"!דַּרְדַּר","n","08251864","y","dahan","1","rav-milim",NULL,"tg1","(wild plant)","thistle",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,glc=4.0,dfl=7.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2698,"!דַּשׁ","n","02907151","y","dahan","1","rav-milim",NULL,"tg1",NULL,"lapel",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2699,"!דָּאָה","v","01323578","y","dahan","1","rav-milim",NULL,"tg1","(through air)",NULL,NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2700,"!דָּאָה","v","01288913","y","dahan","1","rav-milim",NULL,"tg1","(through air)",NULL,NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2701,"!דָּאָה","v","01288660","y","dahan","1","rav-milim",NULL,"tg1","(through air)",NULL,NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2702,"!דָּאוֹן","n","02757129","y","dahan","1","rav-milim",NULL,"tg1",NULL,"glider",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2703,"!דָּג","v","00900840","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2704,"!דָּג","v","00775186","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2705,"!דָּג","v","00900840","y","dahan","1","rav-milim",NULL,"tg2",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2706,"!דָּג","v","00775186","y","dahan","1","rav-milim",NULL,"tg2",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2707,"!דָּגִיג","n","00969494","y","dahan","1","rav-milim",NULL,"tg1","(small fish)","minnow",NULL,NULL,"assigned","#ASSIGN:51.0=[gnd=39.0,glc=3.0,glc=9.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2708,"!דָּהַר","v","01334879","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2709,"!דָּהַר","v","01334516","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2710,"!דָּחוּס","a","00526734","u","dahan","2","rav-milim",NULL,"tg1",NULL,"crowded",NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@\r\n#IE see a#00527144 ","eyal-01 Aug 2005, assign-6 Nov 2003",0,"2005-08-01");
INSERT INTO hebrew_synonyms VALUES (2711,"דָּחוּף","a","00678779","yy","melingo","1.1","rav-milim","1.1A","tg1",NULL,"pressing, urgent",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-16 Feb 2004, assign-6 Nov 2003",91630,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (2712,"דָּלִיל","a","00507880","yy","melingo","1.1","rav-milim","1.1","tg1","(opp dense)","thin, sparse",NULL,"המכון מתיימר לעזור לבעלי שיער דליל לגדל רעמת שיער מפוארת","checked","#ASSIGN:50=[gnd=5.0,glc=11.0,bt(dir)=6.0,dfl=28.0] #MZ@\r\n#IE","eyal-01 Aug 2005, assign-6 Nov 2003",95215,"2005-08-01");
INSERT INTO hebrew_synonyms VALUES (2713,"!דָּלַף","v","00634658","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2714,"!דָּלַף","v","00633898","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2715,"!דָּלַף","v","00176221","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2716,"!דָּלַק","v","00295171","y","dahan","2","rav-milim",NULL,"tg1","(light)",NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2717,"!דָּרוֹם","n","09965063","y","dahan","1","rav-milim",NULL,"tg1",NULL,"south",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2718,"דָּת","n","06023733","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"religion",NULL,"הדת היהודית; הנצרות היא דת מיסיונרית","checked","#ASSIGN:8.0E+01=[gnd=2.0E+01,bt(dir)=21.0,bt(dir)=9.0,bt(crs)=3.0E+01] #MZ@\r\n#NO extending RM\'s 1.1","ordan-16 Sep 2005, assign-6 Nov 2003",95312,"2005-09-16");
INSERT INTO hebrew_synonyms VALUES (2719,"!דָּת","n","04565571","y","dahan","1","rav-milim",NULL,"tg1",NULL,"religion",NULL,NULL,"assigned","#ASSIGN:76.0=[gnd=2.0E+01,bt(dir)=19.0,bt(dir)=9.0,bt(crs)=28.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2720,"!דָּתִיּוּת","n","03783864","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"religiousness",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO that\'s too general, it\'s hypernym twice removed","ordan-16 Feb 2004",0,"2004-02-16");
INSERT INTO hebrew_synonyms VALUES (2721,"!דֹּאַר","n","04736420","y","dahan","2","rav-milim",NULL,"tg1","(US = also mail)","post",NULL,NULL,"assigned","#ASSIGN:50=[gnd=3.0,bt(dir)=7.0,bt(dir)=3.0,bt(crs)=1.0E+01,dfl=27.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2722,"!דֹּב","n","07105643","y","dahan","1","rav-milim",NULL,"tg1",NULL,"bear",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2723,"!דֹּב","n","01640332","y","dahan","1","rav-milim",NULL,"tg1",NULL,"bear",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2724,"!דֹּם","r","00109581","y","dahan","1","rav-milim",NULL,"tg1",NULL,"silently",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2725,"!דֻּגְמָה","n","05448971","u","dahan","1","rav-milim",NULL,"tg1",NULL,"example",NULL,NULL,"checked","#ASSIGN:41.0=[gnd=7.0,bt(non)= -4.0,bt(dir)=13.0,bt(dir)=6.0,bt(crs)=19.0] #MZ@\r\n#IE","eyal-11 Jan 2005, assign-6 Nov 2003",0,"2005-01-11");
INSERT INTO hebrew_synonyms VALUES (2726,"!דֻּגְמָה","n","04559362","y","dahan","1","rav-milim",NULL,"tg1",NULL,"example",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=7.0,bt(dir)=4.0,bt(dir)=7.0,bt(crs)=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2727,"!דֻּגְמָה","n","04549495","y","dahan","1","rav-milim",NULL,"tg1",NULL,"example",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=7.0,bt(dir)=6.0,bt(dir)=5.0,bt(crs)=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2728,"!דֻּגְמָה","n","04483764","y","dahan","1","rav-milim",NULL,"tg1",NULL,"example",NULL,NULL,"assigned","#ASSIGN:33.0=[gnd=7.0,bt(dir)=7.0,bt(non)= -4.0,bt(dir)=1.0E+01,bt(non)= -4.0,bt(crs)=17.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2729,"!דּוֹבֵר","n","07601647","y","dahan","1","rav-milim",NULL,"tg1",NULL,"spokesman, spokesperson",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2730,"!דּוֹדָה","n","07091771","y","dahan","1","rav-milim",NULL,"tg1",NULL,"aunt",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2731,"!דּוֹנַג","n","10828986","n","dahan","1","rav-milim",NULL,"tg1",NULL,"wax",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE see n#10829480","eyal-04 May 2005, assign-6 Nov 2003",0,"2005-05-04");
INSERT INTO hebrew_synonyms VALUES (2732,"!דּוּכִיפַת","n","01346765","y","dahan","1","rav-milim",NULL,"tg1","(bird)","hoopoe",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2733,"!דּוּמָם","r","00109581","y","dahan","1","rav-milim",NULL,"tg1",NULL,"silently",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2734,"!הֲבָאָה","n","00205135","nn","dahan","1","rav-milim",NULL,"tg1","(act)","bringing",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,glc=4.0,glc=2.0,dfl=5.0] #MZ@ #IE not the correct word","eyal-18 Apr 2004, assign-6 Nov 2003",0,"2004-04-18");
INSERT INTO hebrew_synonyms VALUES (2735,"הֲבָרָה","n","04755856","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"syllable",NULL,"במילה ''פיוס'' יש שתי הברות","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-20 May 2004, assign-6 Nov 2003",91631,"2004-05-20");
INSERT INTO hebrew_synonyms VALUES (2736,"הֲגִיָּה","n","05333921","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"pronunciation",NULL,"רובנו איננו מקפידים על הגייה מדוייקת של כל עיצור ועיצור","checked","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@\r\n#IE ''pronunciation'' appeared as ''hagiya'' on morfix English-Hebrew dictionary, but on the Hebrew-English dict. the word ''hagiya'' appeared as ''diction''.","eyal-24 May 2004, assign-6 Nov 2003",91632,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (2737,"הֲגִירָה-נִכְנֶסֶת","n","00031422","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"immigration",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE","eyal-25 Apr 2004, assign-6 Nov 2003",91633,"2004-04-25");
INSERT INTO hebrew_synonyms VALUES (2738,"הֲדִיפָה","n","00616711","yy",NULL,NULL,"none",NULL,"tg1","military","repulse",NULL,"בעקבות מלחמת ששת הימים ועם הדיפת הסורים\r\n מאיזור  \r\n \r\n\r\nהכנרת אל מעבר לרמת הגולן שב השקט לאיזור  ","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE Oxford translates ''hadifa'' as ''repulse''","eyal-02 May 2004",91634,"2004-05-02");
INSERT INTO hebrew_synonyms VALUES (2739,"!הֲדִיפָה","n","05385339","y","dahan","1","rav-milim",NULL,"tg1",NULL,"repulse, repelling",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2740,"!הֲדָדִי","a","02069607","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"mutual",NULL,NULL,"checked","#ASSIGN:25.0=[gnd=2.0E+01,bt(non)= -16.0,bt(dir)=21.0] #MZ@ #IE","eyal-31 Mar 2004, assign-6 Nov 2003",0,"2004-03-31");
INSERT INTO hebrew_synonyms VALUES (2741,"הֲדָדִי","a","01877861","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"mutual",NULL,"קיימת בינינו מערכת יחסים של אימון הדדי","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-31 Mar 2004",91635,"2004-03-31");
INSERT INTO hebrew_synonyms VALUES (2742,"!הֲזָזָה","n","00717034","nn","dahan","1","rav-milim",NULL,"tg1","(of sth from its place)","moving",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-03 May 2004, assign-6 Nov 2003",0,"2004-05-03");
INSERT INTO hebrew_synonyms VALUES (2743,"הֲזָיָה","n","10315277","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"hallucination",NULL,"בדרום אמריקה גדלות פטריות אשר אכילה מהן גורמת להזיות קשות","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE","eyal-27 May 2004, assign-6 Nov 2003",91636,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (2744,"הֲזָנָה","n","00684853","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"feeding, nourishing",NULL,"אין עוררין על כך שהנקה עדיפה על הזנה מבקבוק","checked","#ASSIGN:108.0=[gnd=2.0E+01,gnd=39.0,si=49.0] #MZ@ #IE","eyal-03 May 2004, assign-6 Nov 2003",91637,"2004-05-03");
INSERT INTO hebrew_synonyms VALUES (2745,"הֲטָלָה","n","09698815","yy","melingo","1.3","rav-milim","1.3","tg1","(eggs)","laying",NULL,"עונת ההטלה של העזנייה היא בחודשי החורף","checked","#ASSIGN:93.0=[gnd=39.0,glc=54.0] #MZ@ #IE","eyal-14 Jun 2004, assign-6 Nov 2003",91638,"2004-06-14");
INSERT INTO hebrew_synonyms VALUES (2746,"הֲמוֹנִי","a","01052403","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"mass",NULL,"נשק להשמדה המונית","checked","#ASSIGN:29.0=[gnd=2.0E+01,glc=9.0] #MZ@ #IE","eyal-31 Mar 2004, assign-6 Nov 2003",91639,"2004-03-31");
INSERT INTO hebrew_synonyms VALUES (2747,"!הֲסָבָה","n","00471513","y","dahan","1","rav-milim",NULL,"tg1",NULL,"reassignment",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2748,"הֲפֵכָה","n","00742390","yy","none",NULL,"sapir","1.2","tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE this punctuation is found only in Sapir","eyal-14 Apr 2004, assign-6 Nov 2003",91640,"2004-04-14");
INSERT INTO hebrew_synonyms VALUES (2749,"!הֲפֵכָה","n","00037744","y","dahan","1","rav-milim",NULL,"tg1",NULL,"coup",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2750,"הֲצָפָה","n","00450672","yy","none",NULL,"none",NULL,"tg1",NULL,"flooding",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-25 Apr 2004, assign-6 Nov 2003",91641,"2004-04-25");
INSERT INTO hebrew_synonyms VALUES (6679,"GAP!","n","05494176","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE Hebrew does not distinguish between the sound made by young birds and that made by adult birds. Both are ''tziyutz'', which is ''chirp'' in English.","eyal-02 May 2004",90808,"2004-05-02");
INSERT INTO hebrew_synonyms VALUES (2752,"הֲצָצָה","n","00564046","yy","melingo","1.1","sapir","1.2","tg1",NULL,"peep, peek",NULL,"הבחור הצעיר התישב בפינה והסתפק בהצצות חטופות לעבר הבחורה שישבה ליד הבר","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-02 May 2004, assign-6 Nov 2003",91642,"2004-05-02");
INSERT INTO hebrew_synonyms VALUES (2753,"הֲקָאָה","n","00075786","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"vomiting",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,glc=4.0,glc=2.0,dfl=5.0] #MZ@ #IE","eyal-01 Apr 2004, assign-6 Nov 2003",91643,"2004-04-01");
INSERT INTO hebrew_synonyms VALUES (2754,"!הֲרִיסָה","n","00811339","y","dahan","1","rav-milim",NULL,"tg1","(act)","demolition",NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,glc=4.0,glc=2.0,dfl=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2755,"הִבְהֵב","v","01888444","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"flicker",NULL,"הפנס הבהב מעט ואז כבה","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-12 May 2004, assign-6 Nov 2003",91644,"2004-05-12");
INSERT INTO hebrew_synonyms VALUES (2756,"הִבְהֵב","v","01478422","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"flicker",NULL,"כשהנורית האדומה מהבהבת, יש להחליף סוללה","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-12 May 2004, assign-6 Nov 2003",91644,"2004-05-12");
INSERT INTO hebrew_synonyms VALUES (2757,"הִבְהֵב","v","01282944","nn","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE other words fit better","eyal-12 May 2004, assign-6 Nov 2003",91645,"2004-05-12");
INSERT INTO hebrew_synonyms VALUES (2758,"הִגְזִים","v","01751567","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"exaggerate",NULL,"אתמול הוא הגזים במספר שכיבות הסמיכה שעשה, והיום כואבים לו שרירי הכתפיים","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-17 May 2004, assign-6 Nov 2003",91646,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (2759,"הִגְזִים","v","00569024","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"exaggerate",NULL,"הוא ידוע בנטייתו ליפות את המציאות, אבל הפעם הוא הגזים","checked","#ASSIGN:27.0=[gnd=2.0E+01,bt(dir)=21.0,bt(non)= -14.0] #MZ@ #IE","eyal-17 May 2004",91646,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (2760,"!הִגְעִיל","v","00134840","y","dahan","2","rav-milim",NULL,"tg1","(to render suitable for Passover)",NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2761,"הִגֵּר","v","00289068","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"emigrate",NULL,"הוא החליט להגר לאמריקה בתקווה ששם יבסס את מעמדו כשחקן","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE need to cinsider ''immigrate'' and ''migrate''","eyal-20 May 2004, assign-6 Nov 2003",91647,"2004-05-20");
INSERT INTO hebrew_synonyms VALUES (2762,"הִדְפִּיס","v","00679313","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"type",NULL,"המורה ביקשה מהתלמידים שידפיסו את העבודות ולא יגישו אותן כתובות בכתב יד","checked","#ASSIGN:74.0=[gnd=2.0E+01,glc=54.0] #MZ@ #IE","eyal-30 May 2004, assign-6 Nov 2003",91648,"2004-05-30");
INSERT INTO hebrew_synonyms VALUES (2763,"הִדַּרְדֵּר","v","01338825","yw","melingo","1.1","rav-milim","1.1","tg1",NULL,"roll_down",NULL,"הרכב הידרדר במדרון הקפוא","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE WN definition is restricted to snow only, but since there isn\'t any other synset who fits to this meaning of ''hiddarder'', I decided to leave it as is (also, I do think WN definition should be different, and not restricted to snow).","eyal-17 May 2004, assign-6 Nov 2003",91649,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (2764,"!הִדִּיחַ","v","01638892","y","dahan","1","rav-milim",NULL,"tg1","(from office)",NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,glc=8.0,glc=5.0,dfl=17.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2765,"הִדּוּק","n","00096215","yy","melingo","1.1","rav-milim","1.1","tg1","(act)","tightening",NULL,"יש לדאוג להידוק הבקרה התקציבית","checked","#ASSIGN:50=[gnd=39.0,glc=4.0,glc=2.0,dfl=5.0] #MZ@ #IE","eyal-14 Apr 2004, assign-6 Nov 2003",91650,"2004-04-14");
INSERT INTO hebrew_synonyms VALUES (2766,"!הִזְדַּוֵּג","v","00979971","y","dahan","1","rav-milim",NULL,"tg1","(animals)",NULL,NULL,NULL,"assigned","#ASSIGN:+inf=[gnd=13.0,glc= +inf,glc= +inf,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2767,"!הִזְדַּמְּנוּת","n","10390345","y","dahan","1","rav-milim",NULL,"tg1",NULL,"opportunity, chance, occasion",NULL,NULL,"assigned","#ASSIGN:137.0=[gnd=2.0E+01,gnd=1.0E+01,si=11.0,bt(dir)=21.0,bt(dir)=11.0,bt(crs)=32.0,bt(dir)=21.0,bt(dir)=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2768,"הֵזִּיעַ","v","00047342","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"sweat, perspire",NULL,"פעילות אירובית מאומצת גורמת לי להזיע מאד","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE","eyal-24 May 2004, assign-6 Nov 2003",91651,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (2769,"הִטְבִּיל","v","00695868","yy","melingo","1.3","rav-milim","1.3","tg1","Christianity","baptize",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-30 May 2004",91652,"2004-05-30");
INSERT INTO hebrew_synonyms VALUES (2770,"הִלְאִים","v","00285796","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"nationalize",NULL,"הנשיא מיטרן הלאים את הבנקים בצרפת","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-13 Jun 2004, assign-6 Nov 2003",91653,"2004-06-13");
INSERT INTO hebrew_synonyms VALUES (2771,"הִלְחִים","v","01098741","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"solder",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-30 May 2004, assign-6 Nov 2003",91654,"2004-05-30");
INSERT INTO hebrew_synonyms VALUES (2772,"!הִלֵּךְ","v","01303950","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2773,"הִלָּה","n","07821579","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"halo",NULL,NULL,"checked","#ASSIGN:35.0=[gnd=13.0,glc=5.0,glc=1.0,bt(dir)=16.0] #MZ@ #IE","eyal-26 May 2004, assign-6 Nov 2003",91655,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (2774,"!הִמְהוּם","n","00815376","y","dahan","1","rav-milim",NULL,"tg1","(act)","humming",NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,glc=4.0,glc=2.0,dfl=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2775,"!הִמְנוֹן","n","05275813","y","dahan","1","rav-milim",NULL,"tg1",NULL,"anthem",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2776,"!הִמְתִּיק","v","00613501","u","dahan","2","rav-milim",NULL,"tg1","(punishment)",NULL,NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE ''himtik'' is somehow related to this synset only as a part of the word combiation: ''המתיק את דינו'' which is more specific than this synset.","eyal-27 May 2004, assign-6 Nov 2003",0,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (2777,"הִמָּנְעוּת","n","00133654","yy","melingo","1","rav-milim","1.1","tg1",NULL,"avoidance",NULL,"הימנעות מחשיפה ממושכת לשמש תורמת לבריאותו של העור","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-15 Apr 2004",91656,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (2778,"!הִמּוּר","n","09607798","y","dahan","1","rav-milim",NULL,"tg1",NULL,"gamble",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2779,"הִמּוּר","n","00513119","yy","dahan","1.2","rav-milim","1.2","tg1",NULL,"gamble",NULL,"פתיחת סוכנות נסיעות חדשה בזמן מיתון עלולה להיות הימור מסוכן","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-28 Apr 2004, assign-6 Nov 2003",91657,"2004-04-28");
INSERT INTO hebrew_synonyms VALUES (2780,"!הִנְחָה","v","00812388","n","dahan","4","rav-milim",NULL,"tg1","(on TV)",NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-30 Jun 2005, assign-6 Nov 2003",0,"2005-06-30");
INSERT INTO hebrew_synonyms VALUES (2781,"הִנְצִיחַ","v","01807979","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"perpetuate",NULL,"הצעת החוק הנציחה את חוסר השיוויון בין גברים לבין נשים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE RM restricts its definition to negative phenomena only.","eyal-13 May 2004, assign-6 Nov 2003",91658,"2004-05-13");
INSERT INTO hebrew_synonyms VALUES (2782,"!הִסְבִּיר","v","00722994","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2783,"!הִסְבִּיר","v","00635987","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2784,"!הִסְפִּיד","v","00596971","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2785,"!הִסְרִיחַ","v","01824318","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2786,"הִסְרִיחַ","v","01453522","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"stink",NULL,"אחרי שעות של עבודה מאומצת, הוא ממש הסריח מזיעה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-10 May 2004, assign-6 Nov 2003",91659,"2004-05-10");
INSERT INTO hebrew_synonyms VALUES (2787,"!הִסְתַּבְּכוּת","n","03603464","y","dahan","1","rav-milim",NULL,"tg1","(also fig)","entanglement",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2788,"הִסְתַּגְּלוּת","n","09743067","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"adaptation",NULL,"הילד חווה קשיי הסתגלות לגן החדש","checked","#ASSIGN:50=[gnd=13.0,gnd=8.0,si=14.0,dfl=15.0] #MZ@\r\n#IE","eyal-15 Jun 2004, assign-6 Nov 2003",91660,"2004-06-15");
INSERT INTO hebrew_synonyms VALUES (2789,"!הִסְתַּיְּגוּת","n","05067166","y","dahan","1","rav-milim",NULL,"tg1","(about sth)","reservation",NULL,NULL,"assigned","#ASSIGN:50=[gnd=8.0,bt(dir)=16.0,dfl=26.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2790,"הִסְתַּיֵּם","v","01779664","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"end",NULL,"כשהסתיים הקונצרט, הקהל קם על רגליו והריע ממושכות","checked","#ASSIGN:7.0E+01=[gnd=8.0,gnd=7.0,si=1.0E+01,bt(dir)=9.0,bt(dir)=6.0,bt(crs)=15.0,bt(dir)=9.0,bt(dir)=6.0] #MZ@ #IE","eyal-12 May 2004, assign-6 Nov 2003",91661,"2004-05-12");
INSERT INTO hebrew_synonyms VALUES (2791,"!הִסְתַּכְּלוּת","n","00605096","y","dahan","1","rav-milim",NULL,"tg1","(act)","looking",NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,glc=4.0,dfl=26.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2792,"הִסְתַּלְּקוּת","n","00029100","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"going_away, leaving",NULL,"יש לודא הסתלקות מהירה מהשטח","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-14 Apr 2004, assign-6 Nov 2003",91662,"2004-04-14");
INSERT INTO hebrew_synonyms VALUES (2793,"!הִסְתַּנְּנוּת","n","00628795","y","dahan","1","rav-milim",NULL,"tg1",NULL,"infiltration",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2794,"!הִסֵּס","v","01803236","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:25.0=[gnd=2.0E+01,bt(dir)=19.0,bt(non)= -14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2795,"!הִסֵּס","v","01802820","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2796,"הִסּוּס","n","04403483","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"hesitation",NULL,"הוא צעד קדימה בביטחון, ללא כל היסוס","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE see also n#00687997","eyal-10 Jul 2005, eyal-04 May 2004, assign-6 Nov 2003",91663,"2005-07-10");
INSERT INTO hebrew_synonyms VALUES (2797,"!הִסּוּס","n","03663200","y","dahan","1","rav-milim",NULL,"tg1",NULL,"hesitation",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2798,"הִסּוּס","n","00687997","n","melingo","1.1","sapir",">1.1","tg1",NULL,"hesitation",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE ","eyal-10 Jul 2005, eyal-04 May 2004",0,"2005-07-10");
INSERT INTO hebrew_synonyms VALUES (2799,"!הִפְחִיד","v","01241470","y","dahan","2","rav-milim",NULL,"tg1","(by making threats)",NULL,NULL,NULL,"assigned","#ASSIGN:+inf=[gnd=2.0E+01,glc= +inf] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2800,"!הִפְרִיךְ","v","00553491","y","dahan","1","rav-milim",NULL,"tg1","(statement , argument)",NULL,NULL,NULL,"assigned","#ASSIGN:31.0=[gnd=2.0E+01,glc=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2801,"הִפְרִישׁ","v","00490924","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"set_aside",NULL,"כל חודש הוא מפריש לה חלק ממשכורתו","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-30 May 2004, assign-6 Nov 2003",91664,"2004-05-30");
INSERT INTO hebrew_synonyms VALUES (2802,"!הִפְשִׁיט","v","00035494","y","dahan","1","rav-milim",NULL,"tg1","(another person)",NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2803,"הִצְהִיב","v","00199381","yy","none",NULL,"rav-milim","1.1","tg1",NULL,NULL,NULL,"דפי הספר הצהיבו מיושן","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE the morfix teqs. is ''to become yellow''. ","eyal-24 May 2004, assign-6 Nov 2003",91665,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (2804,"הִצְטַמֵּק","v","00165232","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"shrivel",NULL,"כתוצאה מהחום הכבד, הפירות התייבשו והצטמקו","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-29 Jul 2004, assign-6 Nov 2003",91666,"2004-07-29");
INSERT INTO hebrew_synonyms VALUES (2805,"!הִצְנִיחַ","v","01339823","u","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE I think it doesn\'t belong here, but I\'m not sure.","eyal-16 May 2004, assign-6 Nov 2003",0,"2004-05-16");
INSERT INTO hebrew_synonyms VALUES (2806,"!הִקְצִיב","v","00490839","u","dahan","1","rav-milim",NULL,"tg1","(money)",NULL,NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ \r\n#IE Collins gives 3 definitions for the verb ''budget''. WN definition is one of them. The other two can fit הקציב and קצב. Since this is the only ''budget'' (the verb) in WN, I\'m not quite sure whether to include these two words, or leave them out.","eyal-15 May 2005, eyal-20 May 2004, assign-6 Nov 2003",0,"2005-05-15");
INSERT INTO hebrew_synonyms VALUES (2807,"!הִקְצָה","v","01528254","y","dahan","1","rav-milim",NULL,"tg1","(land , shares)",NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2808,"הִרְדִּים","v","00014590","yy","melingo","1.2","rav-milim","1.2","tg1","(med)","anesthetize",NULL,"הרופאים מיהרו להרדים את החולה על מנת למנוע ממנו סבל מיותר","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-25 May 2004, assign-6 Nov 2003",91667,"2004-05-25");
INSERT INTO hebrew_synonyms VALUES (2809,"הִרְוָה","v","00819436","yy","melingo","1.1","rav-milim","1.1","tg1","(one\'s thirst)","slake, quench",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-31 May 2004, assign-6 Nov 2003",91668,"2004-05-31");
INSERT INTO hebrew_synonyms VALUES (2810,"הִרְזָה","v","00032369","yy","none",NULL,"rav-milim","1.2","tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:1.0E+02=[gnd=39.0,gnd=39.0,si=98.0,bt(non)= -19.0,bt(non)= -19.0,bt(non)= -19.0,bt(non)= -19.0] #MZ@ #IE","eyal-01 Jun 2004, assign-6 Nov 2003",91669,"2004-06-01");
INSERT INTO hebrew_synonyms VALUES (2811,"!הִרְחִיק","v","01670331","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2812,"הִרְכִּיב","v","01052778","yy","none",NULL,"rav-milim","1.1","tg1","(plants)",NULL,NULL,"הוא הרכיב את עץ הדובדבן עם עץ השזיף","checked","#ASSIGN:+inf=[gnd=2.0E+01,glc= +inf,bt(dir)=24.0] #MZ@ #IE","eyal-14 Jun 2004",91670,"2004-06-14");
INSERT INTO hebrew_synonyms VALUES (2813,"!הִרְכִּיב","v","01052666","nn","dahan","3","rav-milim",NULL,"tg1","(plants)",NULL,NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE refers to plants only","eyal-14 Jun 2004, assign-6 Nov 2003",0,"2004-06-14");
INSERT INTO hebrew_synonyms VALUES (2814,"!הִשְׁמִיץ","v","00574026","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2815,"הִשְׁתִּיל","v","01052666","yy","melingo","1.1","rav-milim","1.1","tg1","(med)","transplant",NULL,NULL,"checked","#ASSIGN:50=[gnd=13.0,bt(dir)=24.0,dfl=13.0] #MZ@ #IE","eyal-14 Jun 2004, assign-6 Nov 2003",91671,"2004-06-14");
INSERT INTO hebrew_synonyms VALUES (2816,"הִשְׁתִּין","v","00050470","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"urinate",NULL,"החתולים שוב השתינו לנו בחצר","checked","#ASSIGN:50=[gnd=39.0,bt(non)= -21.0,bt(dir)=3.0E+01,dfl=2.0] #MZ@ #IE","eyal-17 May 2004",91672,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (2817,"!הִשְׁתַּזֵּף","v","00356023","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2818,"!הִשְׁתַּמְּטוּת","n","05066308","y","dahan","1","rav-milim",NULL,"tg1",NULL,"evasion",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2819,"!הִשְׁתַּמְּטוּת","n","00033153","u","dahan","1","rav-milim",NULL,"tg1",NULL,"evasion",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE there is\'nt any specific word in Hebrew which fits to this synset. השתמטות is too general","eyal-29 Jul 2004, assign-6 Nov 2003",0,"2004-07-29");
INSERT INTO hebrew_synonyms VALUES (2820,"הִשְׁתַּעֵל","v","00004183","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"cough",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE","eyal-20 May 2004, assign-6 Nov 2003",91673,"2004-05-20");
INSERT INTO hebrew_synonyms VALUES (2821,"!הִשְׁתַּקְּפוּת","n","03224208","y","dahan","1","rav-milim",NULL,"tg1","(sth reflected)","reflection",NULL,NULL,"assigned","#ASSIGN:6.0E+01=[gnd=6.0,glc=54.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2822,"הִשְׁתּוֹמְמוּת","n","05582358","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"amazement, astonishment",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-09 Jun 2005, assign-6 Nov 2003",95088,"2005-06-09");
INSERT INTO hebrew_synonyms VALUES (2823,"!הִשְׁתּוֹקְקוּת","n","05564936","y","dahan","1","rav-milim",NULL,"tg1","(act)","craving",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2824,"!הִשְׂתַּכֵּר","v","01565625","y","dahan","1","rav-milim",NULL,"tg1","(as wage)",NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=13.0,bt(dir)=16.0,dfl=21.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2825,"הִתְאַדָּה","v","00256707","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"evaporate",NULL,"יש לבשל את הבשר עד שכל הנוזלים שהופרשו ממנו התאדו","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-26 May 2004, assign-6 Nov 2003",91674,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (2826,"הִתְאַדּוּת","n","09738922","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"evaporation",NULL,NULL,"checked","#ASSIGN:73.0=[gnd=2.0E+01,gnd=2.0E+01,si=33.0] #MZ@ #IE","eyal-17 May 2004, assign-6 Nov 2003",91675,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (2827,"הִתְאַכְסֵן","v","01809924","u","none",NULL,"rav-milim","1.1","tg1",NULL,NULL,NULL,"כשביקרתי בלונדון התאכסנתי אצל בת דודתי","checked","#ASSIGN:50=[gnd=1.0E+01,glc=14.0,dfl=26.0] #MZ@ #IE after much consideration, I believe this synset should be איכסן (see its hypernym)","eyal-11 Jan 2005, eyal-12 May 2004, assign-6 Nov 2003",0,"2005-01-11");
INSERT INTO hebrew_synonyms VALUES (2828,"הֶאֱרִיךְ","v","00220504","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"lengthen",NULL,"תאריכי לי את החצאית בבקשה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-14 Jun 2004, assign-6 Nov 2003",91677,"2004-06-14");
INSERT INTO hebrew_synonyms VALUES (2829,"הִתְאָרֵךְ","v","00219507","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"lengthen",NULL,"באביב, הימים מתארכים","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-14 Jun 2004, assign-6 Nov 2003",91678,"2004-06-14");
INSERT INTO hebrew_synonyms VALUES (2830,"הִתְבַּדֵּחַ","v","00578703","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"joke, jest",NULL,"החולה התבדח עם רופאיו","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-17 May 2004, assign-6 Nov 2003",91679,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (2831,"הִתְבַּדֵּחַ","v","00071715","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"joke, jest",NULL,"אל תיקח אותו ברצינות, הוא רק מתבדח איתך","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-17 May 2004, assign-6 Nov 2003",91679,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (2832,"!הִתְגַּבְּרוּת","n","00240731","u","dahan","1","rav-milim",NULL,"tg1",NULL,"increase, intensification",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE the word ''hitgabrut'' means, according to both Sapir and RM, becoming stronger. Since the word ''intense'' has a broader meaning than the word ''storng'', I\'m not sure ''hitgabrut'' belongs to this synset.","eyal-20 Apr 2004, assign-6 Nov 2003",0,"2004-04-20");
INSERT INTO hebrew_synonyms VALUES (2833,"הִתְגַּבְּשׁוּת","n","07765923","yy","melingo","1.2","sapir","1.1","tg1",NULL,"crystallization",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-24 May 2004, assign-6 Nov 2003",91680,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (2834,"!הִתְגַּיֵּס","v","00742311","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2835,"!הִתְגַּלְּמוּת","n","07470212","y","dahan","1","rav-milim",NULL,"tg1",NULL,"embodiment",NULL,NULL,"assigned","#ASSIGN:50=[gnd=13.0,bt(dir)=24.0,dfl=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2836,"!הִתְגָּרוּת","n","00792860","y","dahan","1","rav-milim",NULL,"tg1",NULL,"provocation",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2837,"הִתְגּוֹנְנוּת","n","00528304","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"self-defence",NULL,"הוא הניח את ידיו על ראשו בניסיון התגוננות נואש","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-29 Apr 2004, assign-6 Nov 2003",91681,"2004-04-29");
INSERT INTO hebrew_synonyms VALUES (2838,"!הִתְדַּלְדֵּל","v","00182381","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2839,"הִתְהַוָּה","v","00252195","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"come_into_being",NULL,"קיימות מספר השערות לחידת התהוותו של כדור הארץ","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-19 May 2004, assign-6 Nov 2003",91682,"2004-05-19");
INSERT INTO hebrew_synonyms VALUES (2840,"הִתְחִיל","v","01778989","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"begin, start",NULL,"השטח שלי מתחיל פה; מחירי הבתים בשכונה זו מתחילים ב 250 אלף דולר","checked","#ASSIGN:26.0=[gnd=6.0,bt(dir)=6.0,bt(dir)=4.0,bt(crs)=1.0E+01] #MZ@ #IE","eyal-15 May 2004",91050,"2004-05-15");
INSERT INTO hebrew_synonyms VALUES (2841,"!הִתְחַיְּבוּת","n","10395519","y","dahan","1","rav-milim",NULL,"tg1",NULL,"commitment, obligation, pledge",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2842,"!הִתְחַיְּבוּת","n","05074715","y","dahan","1","rav-milim",NULL,"tg1",NULL,"commitment, obligation, pledge",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2843,"הִתְחַמְצֵן","v","00163821","yy","none",NULL,"rav-milim","1.1","tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE ","eyal-14 Jun 2004, assign-6 Nov 2003",91683,"2004-06-14");
INSERT INTO hebrew_synonyms VALUES (2844,"!הִתְחַנְחְנוּת","n","00330518","u","dahan","1","rav-milim",NULL,"tg1",NULL,"coquetry",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE I am not sure about this word since it usually does noy have a sexual connotation, but rather being ingratiating","eyal-25 Apr 2004, assign-6 Nov 2003",0,"2004-04-25");
INSERT INTO hebrew_synonyms VALUES (2845,"!הִתְחַפְּרוּת","n","02642566","y","dahan","1","rav-milim",NULL,"tg1","(mil)","entrenchment",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2846,"!הִתְחַקּוּת","n","00206842","y","dahan","1","rav-milim",NULL,"tg1","(act)","trailing",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,glc=2.0,dfl=9.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2847,"הִתְחָרָה","v","00727087","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,NULL,NULL,"שני הטייסים התחרו בינהם למי יהיו פגיעות מדויקות יותר במטרות","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE","eyal-16 May 2004, assign-6 Nov 2003",91684,"2004-05-16");
INSERT INTO hebrew_synonyms VALUES (2848,"הִתְיַבֵּשׁ","v","00149731","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"dry, dry_out",NULL,"הכביסה התייבשה בשמש","checked","#ASSIGN:36.0=[gnd=13.0,gnd=13.0,si=2.0E+01,bt(non)= -1.0E+01] #MZ@ #IE","eyal-17 May 2004, assign-6 Nov 2003",91685,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (2849,"!הִתְיַבֵּשׁ","v","00149082","nn","dahan","1","rav-milim",NULL,"tg1","(also fig)",NULL,NULL,NULL,"checked","#ASSIGN:34.0=[gnd=13.0,gnd=13.0,si=2.0E+01,bt(non)= -12.0] #MZ@ #IE","eyal-17 May 2004, assign-6 Nov 2003",0,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (2850,"הִתְיַעֲצוּת","n","05343797","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"consultation",NULL,"הוא קיים התייעצויות תכופות עם עורך דינו","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-13 Jun 2004, assign-6 Nov 2003",91686,"2004-06-13");
INSERT INTO hebrew_synonyms VALUES (2851,"!הִתְיַעֲצוּת","n","00820543","y","dahan","1","rav-milim",NULL,"tg1",NULL,"consultation",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2853,"!הִתְיַעֲצוּת","n","00820543","y","dahan","1","rav-milim",NULL,"tg2",NULL,"consultation",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2854,"הִתְיַפֵּחַ","v","00047059","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"sob",NULL,"הילדה התייפחה במשך שעה ארוכה לאחר שהבובה האהובה עליה נעלמה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-24 May 2004",91687,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (2855,"הִתְיַצְּבוּת","n","00750993","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"stabilization, stabilisation",NULL,"לאחר ההתאוששות מהאינפלציה נרשמה התייצבות מחירים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-13 Jul 2004",91688,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (2856,"!הִתְיָאֵשׁ","v","01235891","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2857,"!הִתְכַּחֵשׁ","v","01582621","nn","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE I think the word ''nishel'' fits better.","eyal-17 May 2004, assign-6 Nov 2003",0,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (2858,"!הִתְלַהֲבוּת","n","05616611","y","dahan","1","rav-milim",NULL,"tg1",NULL,"enthusiasm",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2859,"!הִתְלַהֲבוּת","n","04383528","y","dahan","1","rav-milim",NULL,"tg1",NULL,"enthusiasm",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2860,"!הִתְלַהֲבוּת","n","03655378","y","dahan","1","rav-milim",NULL,"tg1",NULL,"enthusiasm",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2861,"!הִתְמַזְּגוּת","n","00244665","nn","dahan","1","rav-milim",NULL,"tg1","(act)","blending",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=2.0E+01,glc=4.0,glc=2.0] #MZ@ #IE not the correct word","eyal-20 Apr 2004, assign-6 Nov 2003",0,"2004-04-20");
INSERT INTO hebrew_synonyms VALUES (2862,"!הִתְמַזְּגוּת","n","00244814","y","dahan","2","rav-milim",NULL,"tg1","(act)","merging",NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,glc=2.0,dfl=28.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2863,"!הִתְמוֹדֵד","v","00589434","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2864,"!הִתְנַגְּדוּת","n","05409439","y","dahan","1","rav-milim",NULL,"tg1",NULL,"objection",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2865,"!הִתְנַגְּדוּת","n","05385605","y","dahan","1","rav-milim",NULL,"tg1",NULL,"objection",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2866,"!הִתְנַגְּדוּת","n","00132311","y","dahan","2","rav-milim",NULL,"tg1","(by means of force)","resistance",NULL,NULL,"assigned","#ASSIGN:50=[gnd=4.0,bt(dir)=5.0,bt(dir)=6.0,bt(crs)=11.0,dfl=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2867,"!הִתְנַגֵּד","v","00548744","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2868,"רְצוֹנִי","a","02400805","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"voluntary",NULL,"אחד מהסימפטומים של המחלה הוא תנועות לא רצוניות בגפיים","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-31 Mar 2004, assign-6 Nov 2003",91689,"2004-03-31");
INSERT INTO hebrew_synonyms VALUES (2869,"הִתְנַדְּבוּתִי","a","02398582","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"voluntary",NULL,"ההשתתפות בתוכנית הסיוע לנזקקים היא על בסיס התנדבותי","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-31 Mar 2004, assign-6 Nov 2003",91690,"2004-03-31");
INSERT INTO hebrew_synonyms VALUES (2870,"הִתְנַדֵּף","v","00256707","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"evaporate",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-26 May 2004, assign-6 Nov 2003",91691,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (2871,"!הִתְנַהֵג","v","01717501","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2872,"הִתְנַמְנֵם","v","00010240","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"doze",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-14 Jun 2004, assign-6 Nov 2003",91692,"2004-06-14");
INSERT INTO hebrew_synonyms VALUES (2873,"!הִתְנַפְּלוּת","n","04406104","y","dahan","1","rav-milim",NULL,"tg1",NULL,"assault, attack",NULL,NULL,"assigned","#ASSIGN:50=[gnd=1.0E+01,gnd=5.0,si=9.0,dfl=26.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2874,"!הִתְעַוֵּת","v","00924489","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2875,"הִתְעַטְּשׁוּת","n","10274793","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"sneeze",NULL,"כל התקף אלרגיה שלה מלווה בהתעטשויות רבות","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-20 May 2004",91693,"2004-05-20");
INSERT INTO hebrew_synonyms VALUES (2876,"הִתְעַטֵּשׁ","v","00003595","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"sneeze",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE","eyal-26 May 2004, assign-6 Nov 2003",91694,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (2877,"הִתְעַלְּלוּת","n","00268796","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"abuse",NULL,"הילד עבר התעללות קשה לפני שהוצא מביתו על ידי רשויות הרווחה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-20 Apr 2004, assign-6 Nov 2003",91695,"2004-04-20");
INSERT INTO hebrew_synonyms VALUES (2878,"הִתְעַלֵּל","v","01715663","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"abuse",NULL,"היא טענה שהוריה התעללו בה כשהיתה קטנה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-15 May 2004, assign-6 Nov 2003",91696,"2004-05-15");
INSERT INTO hebrew_synonyms VALUES (2879,"הִתְעַלֵּף","v","00016435","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"faint",NULL,"מעוצמת המכה התעלפתי","checked","#ASSIGN:78.0=[gnd=39.0,bt(dir)=39.0] #MZ@\r\n#IE","eyal-26 May 2004",91697,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (2880,"הִתְעַמְּלוּת","n","00275488","yy","melingo","1","rav-milim","1.2","tg1",NULL,"gymnastics",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE","eyal-10 Apr 2004",91698,"2004-04-10");
INSERT INTO hebrew_synonyms VALUES (2881,"הִתְעַמְּלוּת","n","00411620","yy","melingo","1","rav-milim","1.1","tg1",NULL,"exercise",NULL,"הרופא המליץ לו על התעמלות יומיומית","checked","#ASSIGN:47.0=[gnd=39.0,bt(dir)=8.0] #MZ@ #IE","eyal-10 Apr 2004, assign-6 Nov 2003",91698,"2004-04-10");
INSERT INTO hebrew_synonyms VALUES (2882,"!הִתְעַשֵּׁת","v","00440790","nn","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE totally different meaning","eyal-30 May 2004, assign-6 Nov 2003",0,"2004-05-30");
INSERT INTO hebrew_synonyms VALUES (2883,"!הִתְעָרְבוּת","n","04995117","y","dahan","2","rav-milim",NULL,"tg1",NULL,"intervention",NULL,NULL,"assigned","#ASSIGN:3.0E+01=[gnd=2.0E+01,bt(dir)=1.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2884,"!הִתְעָרֵב","v","01730921","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:67.0=[gnd=13.0,bt(dir)=14.0,bt(dir)=13.0,bt(crs)=27.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2885,"!הִתְעָרֵב","v","01730921","y","dahan","2","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:67.0=[gnd=13.0,bt(dir)=14.0,bt(dir)=13.0,bt(crs)=27.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2886,"!הִתְעָרֵב","v","01670845","y","dahan","2","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2887,"!הִתְעוֹרְרוּת","n","00818293","y","dahan","1","rav-milim",NULL,"tg1","(act)","waking_up",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,glc=4.0,glc=2.0,dfl=5.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2888,"הִתְפִּיל","v","00371203","yy","melingo","1.1","rav-milim","1.1","tg1","water","desalinate",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-20 May 2004",91699,"2004-05-20");
INSERT INTO hebrew_synonyms VALUES (2889,"הִתְפַּטְּרוּת","n","05414101","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"resignation",NULL,"לאחר שלא קיבל את התפקיד לו ציפה, החליט להודיע על התפטרותו מהחברה","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-20 May 2004, assign-6 Nov 2003",91700,"2004-05-20");
INSERT INTO hebrew_synonyms VALUES (2890,"מִכְתָּב-הִתְפַּטְּרוּת","n","04887366","yy","none",NULL,"none",NULL,"tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-20 May 2004, assign-6 Nov 2003",91701,"2004-05-20");
INSERT INTO hebrew_synonyms VALUES (2891,"הִתְפַּלְסֵף","v","00427080","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"philosophize",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-19 May 2004, assign-6 Nov 2003",91702,"2004-05-19");
INSERT INTO hebrew_synonyms VALUES (2892,"!הִתְפַּלְפֵּל","v","00525851","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2893,"הִתְפַּלֵּא","v","00626227","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"wonder",NULL,"התפלאתי לראות את הסדר ששרר בחדר","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-14 Jun 2004, assign-6 Nov 2003",91703,"2004-06-14");
INSERT INTO hebrew_synonyms VALUES (2894,"הִתְפַּלֵּל","v","00516449","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"pray",NULL,"הוא נוהג להתפלל כל יום בבית הכנסת","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-20 May 2004, assign-6 Nov 2003",91704,"2004-05-20");
INSERT INTO hebrew_synonyms VALUES (2895,"!הִתְפַּשֵּׁר","v","00701844","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2896,"הִתְפַּשֵּׁר","v","00701304","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"compromise",NULL,"אף אחד לא יקבל בדיוק את מה שהוא רוצה, אנחנו כולנו נצטרך להתפשר","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-27 May 2004, assign-6 Nov 2003",91705,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (2897,"הִתְפַּשֵּׁר","v","00700989","yy","melingo","1.1","rav-milim","1.3","tg1",NULL,"compromise",NULL,"בסופו של דבר בני הזוג התפשרו בינהם על גובה דמי המזונות","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-27 May 2004, assign-6 Nov 2003",91705,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (2898,"הִתְפַּתְּחוּת","n","09724860","yy","melingo","1.1","rav-milim","1.3","tg1",NULL,"development",NULL,"התפתחותה של הציבילזציה היוונית","checked","#ASSIGN:59.0=[gnd=5.0,bt(dir)=6.0,bt(dir)=21.0,bt(crs)=27.0] #MZ@ #IE","eyal-17 Jun 2004, assign-6 Nov 2003",91706,"2004-06-17");
INSERT INTO hebrew_synonyms VALUES (2899,"!הִתְפַּתְּחוּת","n","06302980","y","dahan","1","rav-milim",NULL,"tg1","(being developed)","development",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=5.0,glc=18.0,bt(dir)=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2900,"!הִתְפַּתֵּל","v","01285061","y","dahan","1","rav-milim",NULL,"tg1","(river , road)",NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=5.0,glc=27.0,bt(non)= -3.0,bt(non)= -3.0,dfl=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2901,"!הִתְפָּרְעוּת","n","10069174","y","dahan","1","rav-milim",NULL,"tg1","(disorder)","riot",NULL,NULL,"assigned","#ASSIGN:33.0=[gnd=1.0E+01,glc=11.0,bt(dir)=12.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2902,"הִתְפָּרְצוּת","n","05261864","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"outburst",NULL,"גיל ההתבגרות מאופיין בהתפרצויות רגשיות תכופות","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-25 Apr 2004, assign-6 Nov 2003",91707,"2004-04-25");
INSERT INTO hebrew_synonyms VALUES (2903,"!הִתְפָּרְצוּת","n","00362034","y","dahan","2","rav-milim",NULL,"tg1","(of anger etc)","outburst",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2904,"הִתְפָּרְצוּת","n","05531291","yy","melingo","1.3","rav-milim","1.4","tg1",NULL,"outbreak",NULL,"חיסון האוכלוסיה בסיכון מונע את התפרצות המחלה","checked","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@ #IE","eyal-25 Apr 2004, assign-6 Nov 2003",91707,"2004-04-25");
INSERT INTO hebrew_synonyms VALUES (2905,"הִתְקַלְקֵל","v","00143719","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,NULL,NULL,"תכניס את הבשר למקרר לפני שהוא יתקלקל","checked","#ASSIGN:50=[gnd=6.0,gnd=39.0,si=8.0,bt(non)= -27.0,dfl=24.0] #MZ@ #IE","eyal-13 Jun 2004, assign-6 Nov 2003",91708,"2004-06-13");
INSERT INTO hebrew_synonyms VALUES (2906,"הִתְרַבְרֵב","v","00598488","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"brag, boast",NULL,"הוא התרברב ברווחים שעשה בבורסה","checked","#ASSIGN:56.0=[gnd=2.0E+01,gnd=39.0,si=33.0,bt(dir)=17.0,bt(non)= -12.0,bt(non)= -12.0,bt(dir)=17.0,bt(non)= -23.0,bt(non)= -23.0] #MZ@ #IE","eyal-30 May 2004, assign-6 Nov 2003",91709,"2004-05-30");
INSERT INTO hebrew_synonyms VALUES (2907,"הִתְרַחֲשׁוּת","n","05432762","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"happening",NULL,"הספר אכן מרתק - התרחשות רודפת התרחשות","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-24 May 2004, assign-6 Nov 2003",91710,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (2908,"!הִתְרַחֵק","v","01670331","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2909,"הִתְרַכְּכוּת","n","09671783","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"softening",NULL,"איחסון במקרר מונע את התרככות הפרי","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-15 Jun 2004, assign-6 Nov 2003",91711,"2004-06-15");
INSERT INTO hebrew_synonyms VALUES (2910,"הִתְרָה","v","00590442","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"caution",NULL,"אני מתרה בך: אם לא תתקן את דרכיך, תענש בחומרה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-19 Jun 2004, assign-6 Nov 2003",91712,"2004-06-19");
INSERT INTO hebrew_synonyms VALUES (2911,"הִתְרוֹשְׁשׁוּת","n","00745902","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"impoverishment",NULL,"הסתבכויותיו הפליליות הביאו אותו למצב של התרוששות","checked","#ASSIGN:50=[gnd=2.0E+01,glc=4.0,glc=2.0,dfl=24.0] #MZ@ #IE","eyal-04 May 2004, assign-6 Nov 2003",91713,"2004-05-04");
INSERT INTO hebrew_synonyms VALUES (2912,"הִתִּיךְ","v","01154430","yy","none",NULL,"rav-milim","1.1","tg1","(metal)",NULL,NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ \r\n#IE according to Oxford","eyal-19 Jun 2004, assign-6 Nov 2003",91714,"2004-06-19");
INSERT INTO hebrew_synonyms VALUES (2914,"הִתִּיר","v","00877495","yy","melingo","1.1","rav-milim","1.3","tg2",NULL,"untie",NULL,"הם התירו את האסיר מכבליו","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ \r\n#IE consider also RM 1.1","eyal-31 May 2004, assign-6 Nov 2003",91715,"2004-05-31");
INSERT INTO hebrew_synonyms VALUES (2915,"!הֵאִיץ","v","00306811","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:61.0=[gnd=2.0E+01,gnd=2.0E+01,si=49.0,bt(non)= -14.0,bt(non)= -14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2916,"!הֵאִיץ","v","00305843","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:61.0=[gnd=2.0E+01,gnd=2.0E+01,si=49.0,bt(non)= -14.0,bt(non)= -14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2917,"הֵבִין","v","00399152","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"understand",NULL,"עכשיו אני מבין את ההסבר שלך","checked","#ASSIGN:50=[gnd=8.0,gnd=2.0,si=4.0,bt(dir)=7.0,bt(non)= -6.0,bt(non)= -1.0,bt(dir)=7.0,dfl=29.0] #MZ@ #IE","eyal-27 May 2004, assign-6 Nov 2003",91716,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (2919,"!הֵגִיב","v","00311901","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2920,"!הֵדִיחַ","v","00017506","nn","dahan","1","rav-milim",NULL,"tg1","(dishes)",NULL,NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-29 Jul 2004, assign-6 Nov 2003",0,"2004-07-29");
INSERT INTO hebrew_synonyms VALUES (2921,"!הֵלֶךְ","n","06955549","y","dahan","1","rav-milim",NULL,"tg1",NULL,"traveller",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2922,"הֵעֵז","v","01735366","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"dare",NULL,"היא לא העזה להתקשר אליו","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-01 Jun 2004, assign-6 Nov 2003",91717,"2004-06-01");
INSERT INTO hebrew_synonyms VALUES (2923,"הֵעֵז","v","01617829","yy","melingo","1.1","rav-milim","1.3","tg1",NULL,"dare",NULL,"איך אתה מעז להתקשר אלי בשעה כזו","checked","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@ \r\n#IE","eyal-01 Jun 2004, assign-6 Nov 2003",91717,"2004-06-01");
INSERT INTO hebrew_synonyms VALUES (2924,"!הֵעֵז","v","00588515","nn","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE does not exixst in Hebrew","eyal-01 Aug 2004, assign-6 Nov 2003",0,"2004-08-01");
INSERT INTO hebrew_synonyms VALUES (2925,"!הֵעָרְכוּת","n","00741201","y","dahan","1","rav-milim",NULL,"tg1","(mil)","deployment",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2926,"הֵצִיץ","v","01482148","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"peek",NULL,"הוא הציץ לחדר הבנות מבעד לחור המנעול","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE","eyal-27 May 2004, assign-6 Nov 2003",91718,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (2927,"הֵצֵר","v","00210095","yy","melingo","1.2","rav-milim","1.1","tg1","(clothes)","take_in",NULL,"לאחר שרזיתי, הצרתי את כל בגדי","checked","#ASSIGN:56.0=[gnd=2.0,glc=54.0] #MZ@ \r\n#IE according to RM, the word ''hetzer'' means to make things narrower, and not necessarily clothes.","eyal-26 May 2004",91719,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (2928,"הֵקִיא","v","00053004","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"vomit",NULL,"אחרי הבירה הרביעית הוא רץ לשירותים להקיא","checked","#ASSIGN:1.0E+02=[gnd=39.0,gnd=39.0,si=98.0,bt(non)= -19.0,bt(non)= -19.0,bt(non)= -19.0,bt(non)= -19.0] #MZ@ #IE","eyal-29 May 2004, assign-6 Nov 2003",91720,"2004-05-29");
INSERT INTO hebrew_synonyms VALUES (2929,"הֵרָיוֹן","n","10117409","yy","melingo","1.1","sapir","1.1","tg1",NULL,"pregnancy",NULL,"היריון של אישה נמשך 40 שבועות","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-24 May 2004, assign-6 Nov 2003",91721,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (2930,"הֵשִׁיב","v","00554194","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"reply, respond",NULL,"הוא השיב לשאלתי בקצרה","checked","#ASSIGN:50=[gnd=4.0,bt(dir)=24.0,dfl=22.0] #MZ@\r\n#IE","eyal-31 Jul 2004, assign-6 Nov 2003",91722,"2004-07-31");
INSERT INTO hebrew_synonyms VALUES (2931,"!הֶאָטָה","n","00690838","u","dahan","1","rav-milim",NULL,"tg1","(act)","slowdown, slowing",NULL,NULL,"checked","#ASSIGN:45.0=[gnd=39.0,glc=4.0,glc=2.0] #MZ@ #IE the word ''he\'ata'' could be part of this synset, but it fits more to ''deceleration'', and I could not find a difference between ''decrease in velocity'' and ''the act of slowing down''. ","eyal-04 May 2004, assign-6 Nov 2003",0,"2004-05-04");
INSERT INTO hebrew_synonyms VALUES (2932,"הֶאָטָה","n","03950799","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"deceleration",NULL,"בכביש יש להקפיד על האטה במקומות המצויינים","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-04 May 2004, assign-6 Nov 2003",91723,"2004-05-04");
INSERT INTO hebrew_synonyms VALUES (2933,"!הֶגְלָה","v","01703298","u","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE the punctuation is fifferent from the one in RM","eyal-28 Jul 2004, assign-6 Nov 2003",0,"2004-07-28");
INSERT INTO hebrew_synonyms VALUES (2934,"הֶגְמוֹנְיָה","n","06191189","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"hegemony",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-24 May 2004, assign-6 Nov 2003",91724,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (2935,"!הֶגֶה","n","05321825","y","dahan","3","rav-milim",NULL,"tg1","(gram)","phoneme",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2936,"!הֶחְדִּיר","v","00974953","y","dahan","1","rav-milim",NULL,"tg1","(ideas , feelings etc)",NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2937,"הֶחֱיָה","v","00066451","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"resuscitate, revive",NULL,"באורח נס, הרופאים הצליחו להחיות אותו ממצב של מוות קליני","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-24 May 2004, assign-6 Nov 2003",91725,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (2938,"!הֶחְמִיר","v","00182841","u","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE החמיר is too general","eyal-30 Jul 2004, assign-6 Nov 2003",0,"2004-07-30");
INSERT INTO hebrew_synonyms VALUES (2939,"הֶחְנָה","v","01319179","yy","melingo","1.1","rav-milim","1.1","tg1","(vehicle)","park",NULL,"הוא החנה את המכונית מול בית הקולנוע","checked","#ASSIGN:50=[gnd=13.0,glc=27.0,dfl=1.0E+01] #MZ@ #IE","eyal-23 Aug 2004, eyal-10 Apr 2004, assign-6 Nov 2003",91726,"2004-08-23");
INSERT INTO hebrew_synonyms VALUES (2940,"!הֶסְבֵּר","n","05050688","y","dahan","1","rav-milim",NULL,"tg1",NULL,"explanation",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2941,"!הֶסְבֵּר","n","04465274","y","dahan","1","rav-milim",NULL,"tg1",NULL,"explanation",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2942,"!הֶעָרָה","n","05068616","y","dahan","1","rav-milim",NULL,"tg1",NULL,"comment",NULL,NULL,"assigned","#ASSIGN:79.0=[gnd=13.0,bt(dir)=19.0,bt(dir)=14.0,bt(crs)=33.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2943,"!הֶפְסֵד","n","05605777","nn","dahan","2","rav-milim",NULL,"tg1",NULL,"defeat",NULL,NULL,"checked","#ASSIGN:25.0=[gnd=2.0E+01,bt(non)= -14.0,bt(dir)=19.0] #MZ@ #IE","eyal-13 Jun 2004, assign-6 Nov 2003",0,"2004-06-13");
INSERT INTO hebrew_synonyms VALUES (2944,"הֶפְסֵד","n","05558471","yy","none",NULL,"rav-milim","1.3","tg1",NULL,"defeat",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-13 Jun 2004, assign-6 Nov 2003",91727,"2004-06-13");
INSERT INTO hebrew_synonyms VALUES (2945,"!הֶצֵּף","n","00723443","y","dahan","1","rav-milim",NULL,"tg1","(commerce)","dumping",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2946,"!הֶקֵּשׁ","n","04455499","y","dahan","1","rav-milim",NULL,"tg1",NULL,"syllogism",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2947,"!הֶרֶס","n","05465405","y","dahan","1","rav-milim",NULL,"tg1",NULL,"destruction",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2948,"!הֶרֶס","n","00141128","y","dahan","1","rav-milim",NULL,"tg1",NULL,"destruction",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2949,"הֶשֵּׂג","n","00020977","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"achievement, accomplishment",NULL,"לאחר שנה של השקעה מסיבית בלימודים הצלחת להגיע להישגים מרשימים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-31 Mar 2004, assign-6 Nov 2003",91728,"2004-03-31");
INSERT INTO hebrew_synonyms VALUES (2950,"!הַאֲנָשָׁה","n","04448080","u","dahan","1","rav-milim",NULL,"tg1","(of God)","anthropomorphism",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE I think the word ''personification'' fits better to האנשה","eyal-13 Jun 2004, assign-6 Nov 2003",0,"2004-06-13");
INSERT INTO hebrew_synonyms VALUES (2951,"הַאֲרָכָה","n","00657628","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"prolongation",NULL,"לאחר עשר שנים פג תוקפו של הדרכון ללא כל אפשרות הארכה","checked","#ASSIGN:50=[gnd=39.0,glc=4.0,glc=2.0,dfl=5.0] #MZ@ #IE","eyal-04 May 2004, assign-6 Nov 2003",91729,"2004-05-04");
INSERT INTO hebrew_synonyms VALUES (2952,"הַאֲרָקָה","n","00096864","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"earthing, grounding",NULL,"  יש לוודא שחשמלאי יבדוק שחיבור הארקה של הבית \r\nמחובר בצורה תקינה לאדמה ","checked","#ASSIGN:50=[gnd=39.0,glc=2.0,dfl=9.0] #MZ@ #IE","eyal-04 Apr 2004",91730,"2004-04-04");
INSERT INTO hebrew_synonyms VALUES (2953,"הַבְטָחָה","n","05396507","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"promise",NULL,"הוא הפר את הבטחת הנישואין שנתן לה בעבר","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-24 May 2004",91731,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (2954,"הַבְטָחָה","n","04568216","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"promise",NULL,"אין הבטחה להחלמה מהירה במקרה שלו","checked","#ASSIGN:27.0=[gnd=2.0E+01,bt(dir)=21.0,bt(non)= -14.0] #MZ@ #IE","eyal-24 May 2004, assign-6 Nov 2003",91731,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (2955,"!הַבְרָגָה","n","03288844","u","dahan","1","rav-milim",NULL,"tg2","(of screw)","thread",NULL,NULL,"checked","#ASSIGN:25.0=[gnd=1.0E+01,glc=5.0,bt(dir)=1.0E+01] #MZ@\r\n#IE ''havraga'' is the helical engraving into which the screw is entered","eyal-26 May 2004",0,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (2956,"הַבְרָחָה","n","00721552","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"smuggling",NULL,"רשויות המכס מנעו הברחה של משלוח גדול של פריטים העשויים משנהבי פילים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-04 May 2004, assign-6 Nov 2003",91732,"2004-05-04");
INSERT INTO hebrew_synonyms VALUES (2957,"!הַבְרָקָה","n","04467595","y","dahan","1","rav-milim",NULL,"tg2","(a sudden good idea)","inspiration",NULL,NULL,"assigned","#ASSIGN:50=[gnd=8.0,glc=27.0,dfl=15.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2958,"הַגְבָּלָה","n","04502083","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"limitation",NULL,"אני מוכן לקבל הגבלות מסוימות על תנועותי","checked","#ASSIGN:27.0=[gnd=8.0,gnd=1.0E+01,si=9.0] #MZ@ #IE","eyal-28 Apr 2004, assign-6 Nov 2003",91733,"2004-04-28");
INSERT INTO hebrew_synonyms VALUES (2959,"מִגְבָּלָה","n","04021804","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"limitation, restriction",NULL,"התוכנית הזו טובה אך יש לה כמה מגבלות","checked","#ASSIGN:27.0=[gnd=8.0,gnd=1.0E+01,si=9.0] #MZ@ #IE","eyal-28 Apr 2004, assign-6 Nov 2003",91734,"2004-04-28");
INSERT INTO hebrew_synonyms VALUES (2960,"הַגְבָּלָה","n","00516738","yy","melingo","1.2","rav-milim","1.3","tg1",NULL,"limitation, restriction",NULL,"קיימות הגבלות חמורות על פירסום מוצרי טבק","checked","#ASSIGN:27.0=[gnd=8.0,gnd=1.0E+01,si=9.0] #MZ@ #IE","eyal-28 Apr 2004",91733,"2004-04-28");
INSERT INTO hebrew_synonyms VALUES (2961,"הַגְבָּרָה","n","00240731","yy","oxford","1.2","rav-milim","1.1","tg1",NULL,"intensification",NULL,"קפאין גורם להגברת העירנות","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-20 Dec 2004, eyal-20 Apr 2004, assign-6 Nov 2003",91735,"2004-12-20");
INSERT INTO hebrew_synonyms VALUES (2962,"!הַגְדָּרָה","n","05054071","y","dahan","1","rav-milim",NULL,"tg1",NULL,"definition",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2963,"!הַגְדָּרָה","n","03701336","y","dahan","1","rav-milim",NULL,"tg1",NULL,"definition",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2964,"הַגְזָמָה","n","05064555","yy","melingo","1.1","sapir","1.1","tg1",NULL,"exaggeration",NULL,"הגזמה בחשיבות הניצחון וראיה בו חזות הכל מעודדים אלימות","checked","#ASSIGN:117.0=[gnd=13.0,gnd=39.0,si=33.0,bt(dir)=16.0,bt(dir)=16.0] #MZ@ #IE","eyal-20 Apr 2004",91736,"2004-04-20");
INSERT INTO hebrew_synonyms VALUES (2965,"הִיפֶּרְבּוֹלָה","n","05317607","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"exaggeration, hyperbole",NULL,NULL,"checked","#ASSIGN:117.0=[gnd=13.0,bt(dir)=39.0,bt(dir)=13.0,bt(crs)=52.0] #MZ@ #IE","eyal-20 Apr 2004, assign-6 Nov 2003",91737,"2004-04-20");
INSERT INTO hebrew_synonyms VALUES (2966,"הַגְזָמָה","n","00236516","yy","melingo","1","sapir","1.2","tg1",NULL,"exaggeration",NULL,"הריקוד כלל הגזמה מכוונת של הסירבול שלו","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-20 Apr 2004",91736,"2004-04-20");
INSERT INTO hebrew_synonyms VALUES (2967,"!הַדְגָּמָה","n","05149300","y","dahan","1","rav-milim",NULL,"tg1",NULL,"exemplification, illustration",NULL,NULL,"assigned","#ASSIGN:33.0=[gnd=2.0E+01,gnd=1.0E+01,si=2.0E+01,bt(non)= -17.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2968,"הַדְפָּסָה","n","04825639","yy","none",NULL,"rav-milim","1.3","tg1",NULL,NULL,NULL,"מהירות ההדפסה שלו מדהימה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-15 Jun 2004, assign-6 Nov 2003",91738,"2004-06-15");
INSERT INTO hebrew_synonyms VALUES (2969,"מְדֹרָג","a","01094898","yy",NULL,NULL,"rav-milim","1.1","tg1",NULL,"gradual",NULL,"גבולה הצפוני של העיר תחום ע''י רכס מדורג היורד \r\nמזרחה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-31 Mar 2004",91739,"2004-03-31");
INSERT INTO hebrew_synonyms VALUES (2970,"הַדְרָגָתִי","a","01093726","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"gradual",NULL,"עליה הדרגתית במחירים","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-31 Mar 2004, assign-6 Nov 2003",91740,"2004-03-31");
INSERT INTO hebrew_synonyms VALUES (2971,"הַדְרָכָה","n","00742277","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"guidance",NULL,"ההדרכה במסלולי הטיול תינתן על ידי מדריכים מקצועיים","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-28 Apr 2004, assign-6 Nov 2003",91741,"2004-04-28");
INSERT INTO hebrew_synonyms VALUES (2972,"!הַדְרָכָה","n","00521002","y","dahan","1","rav-milim",NULL,"tg1",NULL,"guidance",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2973,"הַדְרָן","n","00062816","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"encore",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-31 Mar 2004, assign-6 Nov 2003",91742,"2004-03-31");
INSERT INTO hebrew_synonyms VALUES (2974,"הַזְמָנָה","n","05371036","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"invitation",NULL,"שלחתי להם הזמנה לבר המצווה של בני","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-04 Apr 2004, assign-6 Nov 2003",91743,"2004-04-04");
INSERT INTO hebrew_synonyms VALUES (2975,"הַזְמָנָה","n","00103904","yy","melingo","1.1","rav-milim","1.4","tg1",NULL,"invitation",NULL,"ההתנהגות שלה היא הזמנה לצרות","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-04 Apr 2004, assign-6 Nov 2003",91743,"2004-04-04");
INSERT INTO hebrew_synonyms VALUES (2976,"הַזְרָעָה","n","00542336","yy","melingo","1.1","sapir","1.1","tg1",NULL,"insemination",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-29 Apr 2004, assign-6 Nov 2003",91744,"2004-04-29");
INSERT INTO hebrew_synonyms VALUES (2977,"הַחְיָאָה","n","00678772","yy","melingo","1.1","sapir","1.1","tg1",NULL,"resuscitation",NULL,"החולה הגיע במצב של מוות קליני והרופאים ביצעו בו החייאה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-03 May 2004, assign-6 Nov 2003",91745,"2004-05-03");
INSERT INTO hebrew_synonyms VALUES (2978,"הַחְלָמָה","n","09718984","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"recovery, recuperation",NULL,"לאחר תקופת החלמה ארוכה, היא שבה לעבודה סדירה","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-31 Mar 2004, assign-6 Nov 2003",91746,"2004-03-31");
INSERT INTO hebrew_synonyms VALUES (2979,"הִתְאוֹשְׁשׁוּת","n","05521978","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"recovery",NULL,"היער התאושש מהשריפה הגדולה במהירות מפתיעה","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-01 Apr 2004, assign-6 Nov 2003",91747,"2004-04-01");
INSERT INTO hebrew_synonyms VALUES (2980,"!הַחְלָמָה","n","00058314","y","dahan","1","rav-milim",NULL,"tg1",NULL,"recovery, getting_better",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2981,"הַחְלָשָׁה","n","00232935","yy","melingo","1.1","rav-milim","1.1","tg1","(act)","weakening",NULL,"החלשה של עוצמת הקול","checked","#ASSIGN:26.0=[gnd=2.0E+01,glc=4.0,glc=2.0] #MZ@ #IE","eyal-20 Apr 2004, assign-6 Nov 2003",91748,"2004-04-20");
INSERT INTO hebrew_synonyms VALUES (2982,"הַחְמָצָה","n","09735288","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"souring",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-15 Jun 2004, assign-6 Nov 2003",91749,"2004-06-15");
INSERT INTO hebrew_synonyms VALUES (2983,"!הַחְרָבָה","n","00141128","y","dahan","1","rav-milim",NULL,"tg1",NULL,"destruction, devastation",NULL,NULL,"assigned","#ASSIGN:50=[gnd=13.0,gnd=1.0E+01,si=16.0,bt(non)= -9.0,dfl=2.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2984,"הַחְרָמָה","n","00052209","yy","melingo","1.1","rav-milim","1.1","tg1","(of property)","confiscation",NULL,"בית המשפט רשאי להורות על החרמה של כל \r\nמכשיר שידור שהותקן או הופעל ללא רשיון","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-14 Apr 2004",91750,"2004-04-14");
INSERT INTO hebrew_synonyms VALUES (2985,"!הַטְבָּלָה","n","00671096","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"baptism, christening",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-03 May 2004, assign-6 Nov 2003",0,"2004-05-03");
INSERT INTO hebrew_synonyms VALUES (2986,"הַטְבָּלָה","n","00670476","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"baptism, christening",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-03 May 2004",91751,"2004-05-03");
INSERT INTO hebrew_synonyms VALUES (2987,"!הַטְרָדָה","n","00270946","y","dahan","1","rav-milim",NULL,"tg1",NULL,"bothering, troubling",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2988,"!הַטָּפָה","n","05407766","y","dahan","1","rav-milim",NULL,"tg1",NULL,"preaching, sermon",NULL,NULL,"assigned","#ASSIGN:89.0=[gnd=2.0E+01,gnd=2.0E+01,si=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2989,"!הַטָּפָה","n","05034327","y","dahan","1","rav-milim",NULL,"tg1",NULL,"preaching, sermon",NULL,NULL,"assigned","#ASSIGN:89.0=[gnd=2.0E+01,gnd=2.0E+01,si=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2990,"הַיְנוּ","r","00184935","yy","none",NULL,"rav-milim","1.1","tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE","eyal-17 May 2004, assign-6 Nov 2003",91752,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (2991,"הַכְלָלָה","n","04543301","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"generalization",NULL,"הגזענות תמיד חושבת בהכללות","checked","#ASSIGN:68.0=[gnd=1.0E+01,bt(dir)=1.0E+01,bt(dir)=19.0,bt(crs)=29.0] #MZ@\r\n#NO based more on reading in other English speaking dictioanries and on WN\'s example (rather than on the defintion)","ordan-17 Dec 2004, assign-6 Nov 2003",93861,"2004-12-17");
INSERT INTO hebrew_synonyms VALUES (2993,"הַכְתָּמָה","n","00177796","y","melingo","1.1","rav-milim","1.1","tg1","(act)","staining",NULL,"עישון מרובה גורם להכתמת השיניים בכתמי ניקוטין","checked","#ASSIGN:26.0=[gnd=2.0E+01,glc=4.0,glc=2.0]#MZ@ #IE","eyal-15 Apr 2004, assign-6 Nov 2003",91753,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (2994,"הַכְתָּרָה","n","05541618","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"coronation",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-20 May 2004, assign-6 Nov 2003",91754,"2004-05-20");
INSERT INTO hebrew_synonyms VALUES (2995,"!הַלְאָמָה","n","00746627","y","dahan","1","rav-milim",NULL,"tg1",NULL,"nationalization",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2996,"!הַלְוָאָה","n","00708190","y","dahan","1","rav-milim",NULL,"tg1","(money)","lending",NULL,NULL,"assigned","#ASSIGN:5.0E+01=[gnd=39.0,glc=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (2997,"הַלְוָאָה","n","09651550","yy","melingo","1.1","sapir","1.1","tg2",NULL,"loan",NULL,"ביקשתי ממנו הלוואה של אלף שקלים","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-04 May 2004, assign-6 Nov 2003",91755,"2004-05-04");
INSERT INTO hebrew_synonyms VALUES (2999,"הַלְוָיָה","n","05540129","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"funeral",NULL,"אלפים השתתפו בהלוויתו","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE","eyal-17 May 2004, assign-6 Nov 2003",91756,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (3000,"!הַלְחָמָה","n","00096699","y","dahan","1","rav-milim",NULL,"tg1","(act)","soldering",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,glc=2.0,dfl=9.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3001,"!הַלְקָאָה","n","00752563","y","dahan","1","rav-milim",NULL,"tg1","(act)","flogging",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,glc=2.0,dfl=9.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3002,"הַמְחָזָה","n","00577992","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"dramatization",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-02 May 2004, assign-6 Nov 2003",91757,"2004-05-02");
INSERT INTO hebrew_synonyms VALUES (3003,"!הַמְלָצָה","n","05018986","y","dahan","2","rav-milim",NULL,"tg1",NULL,"recommendation",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3004,"!הַמְלָצָה","n","05002823","y","dahan","2","rav-milim",NULL,"tg1",NULL,"recommendation",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3005,"הַמְצָאָה","n","00601160","yy","melingo","1.1","sapir","1.1","tg1",NULL,"invention",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-02 May 2004, assign-6 Nov 2003",91758,"2004-05-02");
INSERT INTO hebrew_synonyms VALUES (3006,"הַמְתָּקַת-דִּין","n","00227941","yy","melingo","1.1","rav-milim","1.1","tg1","(of sentence)","mitigation",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-18 Apr 2004, assign-6 Nov 2003",91759,"2004-04-18");
INSERT INTO hebrew_synonyms VALUES (3007,"הַנְדָּסָה","n","04660658","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"engineering",NULL,"הוא התלבט איזה ענף בהנדסה עליו ללמוד","checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@ #IE","eyal-02 May 2004, assign-6 Nov 2003",91760,"2004-05-02");
INSERT INTO hebrew_synonyms VALUES (3008,"חֲדַר-מְנוֹעִים","n","02640186","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"engine_room",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@ #IE","eyal-02 May 2004, assign-6 Nov 2003",91761,"2004-05-02");
INSERT INTO hebrew_synonyms VALUES (3009,"!הַנְדָּסָה","n","00607693","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"engineering",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE I think this word does not belong to this synset. The definition match ''technologia'' #2 in RM.","eyal-02 May 2004, assign-6 Nov 2003",0,"2004-05-02");
INSERT INTO hebrew_synonyms VALUES (3010,"הַנְדָּסָה","n","04598408","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"geometry",NULL,"בימי רביעי בבוקר יש לנו שיעור הנדסה","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE","eyal-02 May 2004, assign-6 Nov 2003",91760,"2004-05-02");
INSERT INTO hebrew_synonyms VALUES (3011,"!הַנְהָלָה","n","06201180","y","dahan","1","rav-milim",NULL,"tg1",NULL,"management",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3012,"!הַנְהָלָה","n","00734610","y","dahan","1","rav-milim",NULL,"tg1",NULL,"management",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3013,"הַנְחָיָה","n","00742277","yy","melingo","1.1","sapir","1.1","tg1",NULL,"guidance",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE ","eyal-28 Apr 2004, assign-6 Nov 2003",91762,"2004-04-28");
INSERT INTO hebrew_synonyms VALUES (3014,"!הַנְחָיָה","n","00521002","y","dahan","1","rav-milim",NULL,"tg1",NULL,"guidance",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3015,"!הַנְמָכָה","n","00227277","nn","dahan","1","rav-milim",NULL,"tg1","(act)","lowering",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=2.0E+01,glc=4.0,glc=2.0] #MZ@ #IE according to both Sapir and RM, the word ''hanmacha'' means to make something become lower, but not lesser. Therefore I left only ''horada''.","eyal-18 Apr 2004, assign-6 Nov 2003",0,"2004-04-18");
INSERT INTO hebrew_synonyms VALUES (3016,"הַנְמָכָה","n","00211411","yy","melingo","1.1","rav-milim","1.1","tg1","(act)","lowering",NULL,"התקנת המזגן כרוכה בהנמכת התקרה","checked","#ASSIGN:26.0=[gnd=2.0E+01,glc=4.0,glc=2.0] #MZ@ #IE ","eyal-18 Apr 2004",91763,"2004-04-18");
INSERT INTO hebrew_synonyms VALUES (3017,"!הַנְצָחָה","n","00657628","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"perpetuation",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE although in all the dictionaries I\'ve looked the word ''perpetuation'' means ''hantzacha'', I think this word should not be a part of this synset since it has a different meaning in Hebrew.","eyal-04 May 2004, assign-6 Nov 2003",0,"2004-05-04");
INSERT INTO hebrew_synonyms VALUES (3018,"נְשִׁימָה","n","00532749","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"respiration, breathing",NULL,"תהליך הפוטוסינתיזה הוא תהליך הנשימה של צמחים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-29 Apr 2004, assign-6 Nov 2003",91764,"2004-04-29");
INSERT INTO hebrew_synonyms VALUES (3020,"הַסְגָּרָה","n","00139574","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"extradition",NULL,"בין ישראל לארה''ב קיים הסכם הסגרה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE the Hebrew definition is broader than the English one, which refers only to extradition between states","eyal-15 Apr 2004",91765,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (3021,"!הַסְדָּרָה","n","05483217","y","dahan","1","rav-milim",NULL,"tg1",NULL,"arranging, settling",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3022,"עִבּוּד","n","00600921","yy","melingo","1.2","rav-milim","1.4","tg1",NULL,"arrangement",NULL,"השיר הישן זכה לעיבוד חדש ומאז הוא מושמע ברדיו ללא הפסק","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-02 May 2004, assign-6 Nov 2003",91766,"2004-05-02");
INSERT INTO hebrew_synonyms VALUES (3023,"!הַסְוָאָה","n","02372458","y","dahan","1","rav-milim",NULL,"tg1",NULL,"camouflage",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3024,"!הַסְלָמָה","n","00235973","y","dahan","1","rav-milim",NULL,"tg1",NULL,"escalation",NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3025,"!הַסְמָכָה","n","00107544","y","dahan","3","rav-milim",NULL,"tg1",NULL,"ordination",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3026,"!הַסָּעָה","n","06062754","y","dahan","1","rav-milim",NULL,"tg1","(by vehicle)","transportation",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3027,"הַעְתָּקָה","n","00658241","yy","melingo","1","sapir","1.1","tg1","(act)","copying",NULL,"התלמידים היו עסוקים בהעתקת התרגיל מהלוח","checked","#ASSIGN:50=[gnd=39.0,glc=4.0,glc=2.0,dfl=5.0] #MZ@ #IE","eyal-03 May 2004, assign-6 Nov 2003",91767,"2004-05-03");
INSERT INTO hebrew_synonyms VALUES (3028,"הַעְתָּקָה","n","00717034","yy","melingo","2.1","rav-milim","1.2","tg1",NULL,"moving",NULL,"מקום עבודתו החדש חייב את העתקת מקום מגוריו","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-03 May 2004, assign-6 Nov 2003",91767,"2004-05-03");
INSERT INTO hebrew_synonyms VALUES (3029,"!הַעֲמָקָה","n","09725201","y","dahan","1","rav-milim",NULL,"tg1","(act)","deepening",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3030,"!הַעֲנָקָה","n","00053585","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"granting, awarding",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE not the right word","eyal-19 Apr 2004, assign-6 Nov 2003",0,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (3031,"!הַפְחָדָה","n","00793474","y","dahan","1","rav-milim",NULL,"tg1","(act)","frightening",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,glc=2.0,dfl=9.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3032,"!הַפְנָיָה","n","05002955","y","dahan","1","rav-milim",NULL,"tg1",NULL,"referral",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3033,"!הַפְנָמָה","n","03646609","y","dahan","1","rav-milim",NULL,"tg1",NULL,"introversion",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3034,"!הַפְסָקָה","n","02678745","nn","dahan","1","rav-milim",NULL,"tg1","(act)","stopping",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-07 Dec 2004, assign-6 Nov 2003",0,"2004-12-07");
INSERT INTO hebrew_synonyms VALUES (3035,"הַפְצָצָה","n","00629628","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"bombing",NULL,"במלחמת העולם השניה ספגה ברלין הפצצות כבדות מידי בנות הברית","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-03 May 2004, assign-6 Nov 2003",91768,"2004-05-03");
INSERT INTO hebrew_synonyms VALUES (3036,"הַפְקָעָה","n","00052487","yy","melingo","1.1","rav-milim","1.1","tg1","(of property)","expropriation",NULL,"הקמת הפארק התאפשרה רק לאחר הפקעת הקרקעות הסמוכות מידי בעליהן החוקיים","checked","#ASSIGN:5.0E+01=[gnd=39.0,glc=11.0] #MZ@ #IE","eyal-14 Apr 2004, assign-6 Nov 2003",91769,"2004-04-14");
INSERT INTO hebrew_synonyms VALUES (3037,"!הַפְרָדָה","n","06200584","y","dahan","2","rav-milim",NULL,"tg1","(social)","segregation",NULL,NULL,"assigned","#ASSIGN:27.0=[gnd=2.0E+01,glc=7.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3038,"!הַפְשָׁרָה","n","07818171","y","dahan","2","rav-milim",NULL,"tg1","(snow etc)","thaw",NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,glc=11.0,dfl=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3039,"הַפְתָּעָה","n","05582875","yy","melingo","1","rav-milim","1.2","tg1",NULL,"surprise",NULL,"זו אכן הפתעה נעימה לפגוש אתכם כאן","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-10 Apr 2004, assign-6 Nov 2003",91770,"2004-04-10");
INSERT INTO hebrew_synonyms VALUES (3040,"הַפְתָּעָה","n","05442564","yy","melingo","1","rav-milim","1.1","tg1",NULL,"surprise",NULL,"הוא אף פעם לא ישכח את ההפתעה שהכנו לו ליום ההולדת","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-10 Apr 2004, assign-6 Nov 2003",91770,"2004-04-10");
INSERT INTO hebrew_synonyms VALUES (3041,"!הַפְתָּעָה","n","00361333","y","dahan","1","rav-milim",NULL,"tg1",NULL,"surprise",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3042,"!הַפָּלָה","n","05456093","y","dahan","1","rav-milim",NULL,"tg1","(intentionally)","abortion",NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3043,"!הַפָּלָה","n","05456093","y","dahan","2","rav-milim",NULL,"tg1",NULL,"miscarriage",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3044,"הַפָּלָה-טִבְעִית","n","00149696","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"miscarriage",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-04 Apr 2004, assign-6 Nov 2003",91771,"2004-04-04");
INSERT INTO hebrew_synonyms VALUES (3045,"!הַצָּבָה","n","00077753","y","dahan","2","rav-milim",NULL,"tg1","(act)","posting",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,glc=2.0,dfl=9.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3046,"!הַצָּעָה","n","05370271","y","dahan","2","rav-milim",NULL,"tg1","(job , sale , help etc)","offer",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3047,"!הַצָּעָה","n","05357635","y","dahan","2","rav-milim",NULL,"tg1","(job , sale , help etc)","offer",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3048,"!הַצָּתָה","n","00243460","y","dahan","1","rav-milim",NULL,"tg1",NULL,"arson",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3049,"!הַצָּתָה","n","09753841","y","dahan","1","rav-milim",NULL,"tg2","(of car)","ignition",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3050,"!הַצָּתָה","n","02849030","y","dahan","1","rav-milim",NULL,"tg2","(of car)","ignition",NULL,NULL,"assigned","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3051,"!הַקְטָנָה","n","04772608","y","dahan","2","rav-milim",NULL,"tg1","(gram)","diminutive",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3052,"!הַקְנָיָה","n","04729099","y","dahan","1","rav-milim",NULL,"tg1","(act)","imparting",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3053,"!הַקְפָּדָה","n","03681984","y","dahan","1","rav-milim",NULL,"tg1",NULL,"meticulousness",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3055,"!הַרְבֵּה","n","09922518","y","dahan","1","rav-milim",NULL,"tg1",NULL,"many, a_lot, lots",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6649,"סְחוֹר-סְחוֹר","r","00056554","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,"בהתחלה דיבר סחור סחור,אך לבסוף נגע בעצם העניין ואמר שהוא רוצה הלוואה","checked","#NO","ordan-19 Apr 2004",91772,"2004-04-19");
INSERT INTO hebrew_synonyms VALUES (3057,"!הַרְגָּעָה","n","00746155","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"calming, easing",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-27 Jan 2005, assign-6 Nov 2003",0,"2005-01-27");
INSERT INTO hebrew_synonyms VALUES (3058,"הַרְדּוּף","n","08084960","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"oleander",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-24 May 2004, assign-6 Nov 2003",91773,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (3059,"הַרְחָבָה","n","00261237","yy","melingo","1.1","rav-milim","1.1a","tg1","(act)","widening, broadening",NULL,"לאור הכמות הרבה של ילדים בשכונה, אנו דורשים את הרחבת גן המשחקים","checked","#ASSIGN:26.0=[gnd=2.0E+01,glc=4.0,glc=2.0] #MZ@ #IE","eyal-20 Apr 2004, assign-6 Nov 2003",91774,"2004-04-20");
INSERT INTO hebrew_synonyms VALUES (3060,"הַרְטָבָה","n","00178358","yy","melingo","1.1","rav-milim","1.1","tg1","(act)","wetting",NULL,"יש לדאוג להרטבת האדמה לפני שתילת הפרחים","checked","#ASSIGN:50=[gnd=2.0E+01,glc=4.0,glc=2.0,dfl=24.0] #MZ@ #IE","eyal-04 Apr 2004, assign-6 Nov 2003",91775,"2004-04-04");
INSERT INTO hebrew_synonyms VALUES (3061,"הַרְכָּבָה","n","00527847","yy","oxford","1.2","rav-milim","1.3","tg1",NULL,"inoculation",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-19 Dec 2004, eyal-29 Apr 2004, assign-6 Nov 2003",91776,"2004-12-19");
INSERT INTO hebrew_synonyms VALUES (3062,"הַרְמוֹן","n","02799373","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"harem",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE the word ''harmon'' in Hebrew is used to describe a ''female house'' in ancient times, whereas both WN and WR seem to refer to present times.","eyal-10 Apr 2004",91777,"2004-04-10");
INSERT INTO hebrew_synonyms VALUES (3063,"!הַרְסָנוּת","n","04023878","y","dahan","1","rav-milim",NULL,"tg1",NULL,"destructiveness",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3064,"הַרְפַּתְקָה","n","00509169","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"adventure",NULL,"כילד אהבתי לקרוא על הרפתקאותיו של רובינזון קרוזו","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-25 Apr 2004, assign-6 Nov 2003",91778,"2004-04-25");
INSERT INTO hebrew_synonyms VALUES (3065,"הַרְפַּתְקָנִי","a","00068206","yy","melingo","1","rav-milim","1.1","tg1",NULL,"adventurous",NULL,"היא תמיד עסקה בספורט הרפתקני","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-28 Mar 2004, assign-6 Nov 2003",91779,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (3066,"!הַרְפַּתְקָנוּת","n","03674564","y","dahan","1","rav-milim",NULL,"tg1",NULL,"adventurism",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3067,"הַרְצָאָה","n","05406019","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"lecture",NULL,"אתמול השתתפתי בהרצאה מרתקת בנושא טלקומוניקציה","checked","#ASSIGN:53.0=[gnd=13.0,bt(dir)=13.0,bt(dir)=7.0,bt(crs)=2.0E+01] #MZ@ #IE","eyal-29 Apr 2004, assign-6 Nov 2003",91780,"2004-04-29");
INSERT INTO hebrew_synonyms VALUES (3068,"!הַרְצָאָה","n","00573978","y","dahan","1","rav-milim",NULL,"tg1",NULL,"lecture",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3069,"הַרְשָׁמָה","n","00027235","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"registration, enrolment",NULL,"ההרשמה לקורס הסתיימה אתמול","checked","#ASSIGN:282.0=[gnd=2.0E+01,gnd=39.0,si=49.0,bt(dir)=19.0,bt(dir)=39.0,bt(crs)=58.0,bt(dir)=19.0,bt(dir)=39.0] #MZ@ #IE","eyal-31 Mar 2004",91781,"2004-03-31");
INSERT INTO hebrew_synonyms VALUES (3070,"!הַרְשָׁמָה","n","00646207","y","dahan","1","rav-milim",NULL,"tg1",NULL,"registration, enrolment",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3071,"!הַשְׁאָלָה","n","00708190","y","dahan","1","rav-milim",NULL,"tg1","(sth)","lending",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3072,"!הַשְׁאָלָה","n","05317845","y","dahan","2","rav-milim",NULL,"tg1",NULL,"metaphor",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3073,"!הַשְׁאָרָה","n","00029100","nn","dahan","1","rav-milim",NULL,"tg1","(in place)","leaving",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-14 Apr 2004, assign-6 Nov 2003",0,"2004-04-14");
INSERT INTO hebrew_synonyms VALUES (3074,"!הַשְׁגָּחָה","n","00735967","y","dahan","1","rav-milim",NULL,"tg1",NULL,"supervision",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3075,"הַשְׁוָאָה","n","00121287","yy","melingo","1.2","rav-milim","1.2","tg1","(make equal)","equalization",NULL," החוק מחייב השוואת תנאים של עובדי   \r\nכוח אדם לעובדים הקבועים","checked","#ASSIGN:50=[gnd=39.0,glc=9.0,dfl=2.0] #MZ@ #IE","eyal-04 Apr 2004",91782,"2004-04-04");
INSERT INTO hebrew_synonyms VALUES (3076,"!הַשְׁוָאָה","n","09980356","y","dahan","1","rav-milim",NULL,"tg2",NULL,"comparison",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3077,"הַשְׁוָאָה","n","00093090","yy","melingo","1.1","rav-milim","1.1","tg2",NULL,"comparison",NULL,"ערכנו השוואה בין הגישות השונות ביהדות","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-04 Apr 2004, assign-6 Nov 2003",91782,"2004-04-04");
INSERT INTO hebrew_synonyms VALUES (3078,"!הַשְׁחָתָה","n","00258970","y","dahan","1","rav-milim",NULL,"tg1","(the appearance)","defacement",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,glc=9.0,dfl=2.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3079,"!הַשְׁמָטָה","n","09720867","y","dahan","1","rav-milim",NULL,"tg1",NULL,"omission, deletion",NULL,NULL,"assigned","#ASSIGN:50=[gnd=1.0E+01,gnd=13.0,si=16.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3080,"!הַשְׁעָרָה","n","03792664","y","dahan","1","rav-milim",NULL,"tg1",NULL,"assumption",NULL,NULL,"assigned","#ASSIGN:34.0=[gnd=1.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6845,"אָדַפְּטַצְיָה","n","09743067","yy","melingo","1.1","rav-milim","1.2",NULL,NULL,"adaptation",NULL,NULL,"checked","#IE","eyal-15 Jun 2004",91783,"2004-06-15");
INSERT INTO hebrew_synonyms VALUES (3082,"!הַשְׁפָּלָה","n","10360768","y","dahan","1","rav-milim",NULL,"tg1",NULL,"humiliation",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3083,"!הַשְׁפָּלָה","n","05580938","y","dahan","1","rav-milim",NULL,"tg1",NULL,"humiliation",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3084,"!הַשְׁפָּלָה","n","00175673","y","dahan","1","rav-milim",NULL,"tg1",NULL,"humiliation",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3085,"הַשְׁתָּנָה","n","09717059","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"urination",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-17 May 2004, assign-6 Nov 2003",91784,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (3086,"!הַשְׂכָּרָה","n","00372370","y","dahan","2","rav-milim",NULL,"tg1","(act)","let",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3087,"!הַתְחָלָה","n","00153241","y","dahan","1","rav-milim",NULL,"tg1",NULL,"beginning, start",NULL,NULL,"assigned","#ASSIGN:35.0=[gnd=8.0,gnd=5.0,si=9.0,bt(dir)=9.0,bt(non)= -5.0,bt(dir)=9.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3088,"הַתְמָדָה","n","00659771","yy","melingo","1.1","sapir","1.2","tg1",NULL,"perseverance",NULL,"יותר מהכישרון חשובה ההתמדה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-03 May 2004, assign-6 Nov 2003",91785,"2004-05-03");
INSERT INTO hebrew_synonyms VALUES (3089,"הַתְפָּלָה","n","09688586","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"desalination",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-14 Jun 2004, assign-6 Nov 2003",91786,"2004-06-14");
INSERT INTO hebrew_synonyms VALUES (3090,"!הַתְרָאָה","n","05395080","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"warning",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO doesn\'t occur in RM in this meaning. ","ordan-08 Feb 2004, assign-6 Nov 2003",0,"2004-02-08");
INSERT INTO hebrew_synonyms VALUES (3091,"!הַתְרָאָה","n","05003120","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"warning",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IN too specific, exists only in Heb","ordan-07 Jul 2004, assign-6 Nov 2003",0,"2004-07-07");
INSERT INTO hebrew_synonyms VALUES (3092,"הָבִיל","a","02427824","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"muggy",NULL,"מזג האוויר ההביל הזה הוא פשוט בלתי נסבל","checked","#ASSIGN:52.0=[gnd=39.0,bt(dir)=43.0,bt(non)= -3.0E+01] #MZ@ #IE in Hebrew the word ''muggy'' (havil) is used only with reference to weather. WN does not specifically refer to weather","eyal-31 Mar 2004",91787,"2004-03-31");
INSERT INTO hebrew_synonyms VALUES (3093,"!הָמוֹן","n","09922518","y","dahan","1","rav-milim",NULL,"tg1",NULL,"lots, heaps",NULL,NULL,"assigned","#ASSIGN:176.0=[gnd=39.0,gnd=39.0,si=98.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3094,"הָפוּךְ","r","00216022","yy","melingo","1.3","rav-milim","1.3","tg1","colloquial","upside_down",NULL,"הקופסא היתה מונחת הפוכה על השטיח","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-17 Jun 2004",91788,"2004-06-17");
INSERT INTO hebrew_synonyms VALUES (3095,"!הָרוּג","n","07142917","y","dahan","1","rav-milim",NULL,"tg1","(killed)","casualty",NULL,NULL,"assigned","#ASSIGN:+inf=[gnd=1.0E+01,glc= +inf] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3096,"!הָרוּג","n","07142806","nn","dahan","1","rav-milim",NULL,"tg1","(killed)","casualty",NULL,NULL,"checked","#ASSIGN:+inf=[gnd=1.0E+01,glc= +inf] #MZ@\r\n#IE","eyal-24 May 2004, assign-6 Nov 2003",0,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (3097,"הֹדּוּ","n","06509050","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"India",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-17 May 2004, assign-6 Nov 2003",91789,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (3098,"הוֹמֶה","a","00036903","yy","melingo","1","rav-milim","1.1","tg1",NULL,"bustling",NULL,"הפארק היה הומה תיירים ומשפחות עם ילדים שבילו \r\n\r\nאת אחר הצהרים באוויר הצח ","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-14 Apr 2004",91790,"2004-04-14");
INSERT INTO hebrew_synonyms VALUES (3099,"!הוֹנָה","v","01753780","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3100,"הוֹרָדָה","n","00227277","yy","melingo","1.1","rav-milim","1.5","tg1","(act)","lowering",NULL,"שר האוצר הורה על הורדת שכר בשירות הציבורי","checked","#ASSIGN:26.0=[gnd=2.0E+01,glc=4.0,glc=2.0] #MZ@  #IE","eyal-18 Apr 2004, assign-6 Nov 2003",91791,"2004-04-18");
INSERT INTO hebrew_synonyms VALUES (3101,"הוֹרָדָה","n","00211411","yy","melingo","1.1","rav-milim","1.1","tg1","(act)","lowering",NULL,"אתה אחראי להורדת הצלחות מהמדף העליון","checked","#ASSIGN:26.0=[gnd=2.0E+01,glc=4.0,glc=2.0] #MZ@ #IE","eyal-18 Apr 2004, assign-6 Nov 2003",91791,"2004-04-18");
INSERT INTO hebrew_synonyms VALUES (3102,"הוֹרָה","n","07456981","y","none",NULL,"sapir","1.2","tg1","(mother)","parent",NULL,NULL,"checked","#ASSIGN:50=[gnd=13.0,glc=8.0,glc=5.0,dfl=24.0] #MZ@ #IE this word is hardly ever used","eyal-28 Mar 2004, assign-6 Nov 2003",91792,"2004-03-28");
INSERT INTO hebrew_synonyms VALUES (3103,"!הוּרַע","v","00182841","u","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE הורע is too general","eyal-30 Jul 2004, assign-6 Nov 2003",0,"2004-07-30");
INSERT INTO hebrew_synonyms VALUES (3104,"!וְעִידָה","n","06166581","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"conference, convention",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO ועידה is probably more political, cf RM","ordan-06 May 2004, assign-6 Nov 2003",0,"2004-05-06");
INSERT INTO hebrew_synonyms VALUES (3105,"!וְעִידָה","n","05343252","y","dahan","1","rav-milim",NULL,"tg1",NULL,"conference, convention",NULL,NULL,"assigned","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3106,"וְרִידִי","a","02503673","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"venous",NULL,NULL,"checked","#ASSIGN:+inf=[gnd=39.0,glc= +inf] #MZ@\r\n#NO","ordan-21 Apr 2004, assign-6 Nov 2003",91793,"2004-04-21");
INSERT INTO hebrew_synonyms VALUES (3107,"וִכּוּחַ","n","05342315","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"debate",NULL,"הוויכוח נמשך הלאה ועדיין אין הסכמה בין הצדדים","checked","#ASSIGN:50=[gnd=8.0,bt(dir)=24.0,dfl=18.0] #MZ@\r\n#NO","ordan-06 May 2004, assign-6 Nov 2003",91794,"2004-05-06");
INSERT INTO hebrew_synonyms VALUES (3108,"וִתּוּר","n","05390774","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"concession",NULL,"זה היה ויתור הכרחי בדרך להסכמה","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-06 May 2004, assign-6 Nov 2003",91795,"2004-05-06");
INSERT INTO hebrew_synonyms VALUES (3109,"וִתּוּר","n","05364726","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"concession, conceding, yielding",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-06 May 2004, assign-6 Nov 2003",91795,"2004-05-06");
INSERT INTO hebrew_synonyms VALUES (3110,"וֵשֶׁט","n","04286557","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"esophagus, gullet",NULL,"אין מסיחים בשעת הסעודה, פן יקדים קנה לוושת","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-21 Apr 2004, assign-6 Nov 2003",91796,"2004-04-21");
INSERT INTO hebrew_synonyms VALUES (3111,"וֶסֶת","n","09715092","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"menstruation, period",NULL,NULL,"checked","#ASSIGN:77.0=[gnd=39.0,gnd=4.0,si=11.0,bt(dir)=38.0,bt(non)= -23.0,bt(non)= -27.0,bt(dir)=38.0,bt(non)= -3.0] #MZ@\r\n#NO","ordan-21 Apr 2004, assign-6 Nov 2003",91797,"2004-04-21");
INSERT INTO hebrew_synonyms VALUES (3112,"וֶרֶד","n","08920236","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"rose",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-21 Apr 2004",91798,"2004-04-21");
INSERT INTO hebrew_synonyms VALUES (3113,"!וֶרֶד","n","03885875","nn","dahan","1","rav-milim",NULL,"tg1","(flower)","rose",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO The word ורד does not refer to a color in Hebrew","ordan-21 Apr 2004, assign-6 Nov 2003",0,"2004-04-21");
INSERT INTO hebrew_synonyms VALUES (3114,"וַיִּקְרָא","n","04848367","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"Leviticus",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,glc=5.0,dfl=6.0] #MZ@\r\n#NO","ordan-21 Apr 2004, assign-6 Nov 2003",91799,"2004-04-21");
INSERT INTO hebrew_synonyms VALUES (3115,"!וַעֲדָה","n","06173732","y","dahan","1","rav-milim",NULL,"tg1",NULL,"committee",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3117,"וָאדִי","n","06734778","yy","melingo","1","rav-milim","1.1","tg1",NULL,"wadi",NULL,"המדריך לקח אותנו לטייל בואדיות באיזור הכרמל","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-10 Mar 2004, assign-6 Nov 2003",91800,"2004-03-10");
INSERT INTO hebrew_synonyms VALUES (3118,"!זְאֵב","n","07684525","y","dahan","1","rav-milim",NULL,"tg1",NULL,"wolf",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3119,"זְאֵב","n","01623366","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"wolf",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-10 May 2004, assign-6 Nov 2003",91801,"2004-05-10");
INSERT INTO hebrew_synonyms VALUES (3120,"זְהִירוּת","n","04349454","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"caution",NULL,"תנהג בזהירות, הכבישים רטובים","checked","#ASSIGN:50=[gnd=7.0,bt(dir)=9.0,bt(non)= -4.0,bt(dir)=6.0,bt(crs)=15.0,dfl=17.0] #MZ@\r\n#NO","ordan-13 May 2004, assign-6 Nov 2003",91802,"2004-05-13");
INSERT INTO hebrew_synonyms VALUES (3121,"!זְמַנִּי","a","01038036","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"temporary",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=2.0E+01,bt(non)= -15.0,bt(dir)=21.0] #MZ@\r\n#NO again (as in a#00523173), this could be translated to זמני sometimes, but לא קבוע is much better","ordan-08 May 2004",0,"2004-05-08");
INSERT INTO hebrew_synonyms VALUES (3122,"זְמַנִּי","a","01691661","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"temporary",NULL,"עד שגמרנו לשפץ את הבית, גרנו באופן זמני אצל ההורים","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-08 May 2004, assign-6 Nov 2003",91803,"2004-05-08");
INSERT INTO hebrew_synonyms VALUES (3123,"!זְמַנִּי","a","00523173","nn","dahan","2","rav-milim",NULL,"tg1",NULL,"provisional",NULL,NULL,"checked","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@\r\n#NO could be translated as זמני under in certain contexts, however, טנטטיבי is much better","ordan-08 May 2004",0,"2004-05-08");
INSERT INTO hebrew_synonyms VALUES (3124,"זְנוּת","n","00482009","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"prostitution",NULL,"הזנות, כך נהוג לומר, היא המקצוע העתיק בהיסטוריה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-10 May 2004",91804,"2004-05-10");
INSERT INTO hebrew_synonyms VALUES (3125,"!זְרִימָה","n","09742299","y","dahan","2","rav-milim",NULL,"tg1",NULL,"influx",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3126,"זִבֵּל","v","01426574","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"manure",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-22 May 2004, assign-6 Nov 2003",91805,"2004-05-22");
INSERT INTO hebrew_synonyms VALUES (3127,"זִהוּם","n","10412503","yy","melingo","1.1","rav-milim","1.3","tg1",NULL,"pollution",NULL,"זיהום מערכות הניקוז סיכן את העובדים והביא לסגירה זמנית של המפעל","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-09 May 2004",91806,"2004-05-09");
INSERT INTO hebrew_synonyms VALUES (3128,"!זִהוּם","n","10401117","y","dahan","1","rav-milim",NULL,"tg1","(air , water)","pollution",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3129,"זִהוּם","n","00177916","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"contamination, pollution",NULL,"שביתת עובדי התברואה הביאה לזיהום בית החולים","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-09 May 2004",91806,"2004-05-09");
INSERT INTO hebrew_synonyms VALUES (3131,"זִיּוּף","n","02850375","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"forgery",NULL,"לעתים יכולים רק מומחים לאמנות להבחין בין תמונה מקורית לזיוף","checked","#ASSIGN:105.0=[gnd=2.0E+01,gnd=39.0,si=49.0,bt(non)= -14.0,bt(dir)=19.0,bt(non)= -27.0,bt(dir)=19.0] #MZ@\r\n#NO agree on with the latter part of RM definition ","ordan-10 May 2004",91807,"2004-05-10");
INSERT INTO hebrew_synonyms VALUES (3132,"זִיּוּף","n","00491849","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"forgery",NULL,"המשטרה פשטה על בית דפוס שעסק בזיוף שטרות כסף","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO agrees only partly with RM\'s definition, which doesn\'t distinguish between the product and the act of forgery","ordan-10 May 2004",91807,"2004-05-10");
INSERT INTO hebrew_synonyms VALUES (6693,"מִתְחַזֶּה","n","07336148","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"pretender",NULL,NULL,"checked","#NO","ordan-10 May 2004",91808,"2004-05-10");
INSERT INTO hebrew_synonyms VALUES (3134,"!זִיּוּף","n","02663528","y","dahan","3","rav-milim",NULL,"tg1","(story , work of art etc)","fake",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3135,"!זִלְזֵל","v","00573480","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:85.0=[gnd=39.0,gnd=13.0,si=33.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3136,"זִמְזוּם","n","05493549","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"buzz",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-10 May 2004, assign-6 Nov 2003",91809,"2004-05-10");
INSERT INTO hebrew_synonyms VALUES (3137,"!זִמְזוּם","n","00818472","y","dahan","1","rav-milim",NULL,"tg1",NULL,"buzz",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3138,"זִמָּה","n","03839481","yy","dahan","1","none",NULL,"tg1",NULL,"obscenity, lewdness",NULL,"שטוף זימה שכמותו, תמיד הוא מדבר על מין!","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-11 May 2004",91810,"2004-05-11");
INSERT INTO hebrew_synonyms VALUES (3139,"זִקְפָּה","n","10111869","yy","dahan","1.1","rav-milim","1.1","tg1",NULL,"erection",NULL,NULL,"checked","#ASSIGN:67.0=[gnd=13.0,glc=54.0] #MZ@\r\n#NO","ordan-22 May 2004, assign-6 Nov 2003",91811,"2004-05-22");
INSERT INTO hebrew_synonyms VALUES (3140,"זֵכֶר","n","04557437","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"memory",NULL,NULL,"checked","#ASSIGN:72.0=[gnd=8.0,glc=54.0,bt(dir)=1.0E+01] #MZ@\r\n#NO","ordan-13 May 2004",91083,"2004-05-13");
INSERT INTO hebrew_synonyms VALUES (6705,"זִכָּרוֹן","n","04443434","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"memory",NULL,"לסבי היה זיכרון מעולה, הוא זכר את כל התנ''ך בע''פ","checked","#NO","ordan-13 May 2004",91812,"2004-05-13");
INSERT INTO hebrew_synonyms VALUES (3142,"זֵעָה","n","04200725","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"perspiration, sweat",NULL,"כשחזר מריצת הבוקר היתה חולצתו רטובה מזיעה","checked","#ASSIGN:92.0=[gnd=1.0E+01,bt(dir)=33.0,bt(dir)=11.0,bt(non)= -6.0,bt(crs)=44.0] #MZ@\r\n#NO","ordan-11 May 2004, assign-6 Nov 2003",91813,"2004-05-11");
INSERT INTO hebrew_synonyms VALUES (3144,"!זֵרוּז","n","00787314","y","dahan","1","rav-milim",NULL,"tg1","(act)","urging",NULL,NULL,"assigned","#ASSIGN:26.0=[gnd=2.0E+01,glc=4.0,glc=2.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3145,"זֶבֶל","n","10656895","yy","melingo","1.2","rav-milim","1.2","tg1","(US = garbage)",NULL,NULL,NULL,"revised","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","eyal-11 Jul 2004, ordan-02 Feb 2004, assign-6 Nov 2003",91814,"2004-07-11");
INSERT INTO hebrew_synonyms VALUES (6411,"שְׁטֻיּוֹת","n","04959357","yy","none",NULL,"rav-milim","1.2",NULL,NULL,"folderol, rubbish, tripe, trumpery, trash, wish-wash, applesauce",NULL,"תפסיק לדבר שטויות!","checked","#NO","ordan-02 Feb 2004",91815,"2004-02-02");
INSERT INTO hebrew_synonyms VALUES (3147,"זֶפֶת","n","10700359","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"pitch, tar",NULL,"לאחר שחזרנו מהים, הסרנו את הזפת באמצעות נפט","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-21 May 2004, assign-6 Nov 2003",91816,"2004-05-21");
INSERT INTO hebrew_synonyms VALUES (3148,"!זֶפֶת","n","07396425","y","dahan","1","rav-milim",NULL,"tg1",NULL,"tar",NULL,NULL,"assigned","#ASSIGN:37.0=[gnd=2.0E+01,bt(dir)=17.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3149,"זֶרֶם","n","07788451","yy","melingo","1.2","rav-milim","1.4","tg1",NULL,"current",NULL,NULL,"checked","#ASSIGN:56.0=[gnd=13.0,glc=18.0,glc=11.0,bt(dir)=14.0] #MZ@\r\n#NO","ordan-22 May 2004, assign-6 Nov 2003",91817,"2004-05-22");
INSERT INTO hebrew_synonyms VALUES (3150,"זֶרֶם","n","06250108","yy","melingo","1.1","rav-milim","1.5","tg1",NULL,"current",NULL,"הסגנון הספרותי של תיאור רצף מחשבותיו של הגיבור נקרא \'זרם התודעה\' ","checked","#ASSIGN:91.0=[gnd=13.0,bt(dir)=8.0,bt(dir)=5.0,bt(dir)=13.0,bt(crs)=52.0] #MZ@\r\n#NO","ordan-22 May 2004, assign-6 Nov 2003",91817,"2004-05-22");
INSERT INTO hebrew_synonyms VALUES (3151,"זֶרֶם","n","05513139","yy","none",NULL,"rav-milim",">1.1","tg1",NULL,"current, stream",NULL,"הרפסודה שטה במורד הזרם של הנהר","checked","#ASSIGN:59.0=[gnd=13.0,bt(dir)=14.0,bt(dir)=9.0,bt(crs)=23.0] #MZ@\r\n#NO It is an approximate convergence of the three first senses listed in RM. Their glosses are not very convincing and I\'m not sure they justify separate entries. ","ordan-15 May 2004, assign-6 Nov 2003",91817,"2004-05-15");
INSERT INTO hebrew_synonyms VALUES (3152,"זֶרַע","n","04233304","yy","none",NULL,"rav-milim","1.3","tg1",NULL,"sperm, sperm_cell, spermatozoon",NULL,NULL,"checked","#ASSIGN:5.0E+01=[gnd=39.0,glc=11.0] #MZ@\r\n#NO","ordan-13 May 2004, assign-6 Nov 2003",91818,"2004-05-13");
INSERT INTO hebrew_synonyms VALUES (3153,"זַבָּנִית","n","07543728","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"salesgirl, saleswoman, saleslady",NULL,"הזבנית נתנה לילדים מסטיקים במקום עודף","checked","#ASSIGN:176.0=[gnd=39.0,gnd=39.0,si=98.0] #MZ@\r\n#NO","ordan-22 May 2004, assign-6 Nov 2003",91819,"2004-05-22");
INSERT INTO hebrew_synonyms VALUES (3154,"זַגָּג","n","07292260","n","melingo","1.1","rav-milim","1.1","tg1",NULL,"glazier",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO\r\n#IE gender","eyal-10 Jul 2005, ordan-21 May 2004, assign-6 Nov 2003",0,"2005-07-10");
INSERT INTO hebrew_synonyms VALUES (3155,"זַחַל","n","01813568","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"larva",NULL,NULL,"checked","#ASSIGN:93.0=[gnd=39.0,flc(pot)=5.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-10 May 2004",91821,"2004-05-10");
INSERT INTO hebrew_synonyms VALUES (3156,"!זַחַל","n","01811851","nn","dahan","1","rav-milim",NULL,"tg1","(of a butterfly)","caterpillar, larva",NULL,NULL,"checked","#ASSIGN:1.2E+02=[gnd=39.0,flc(pot)=5.0,glc=27.0,bt(dir)=49.0] #MZ@\r\n#NO according to RM, there is a different between זחל and תולעת in accordance with WN\'s distinction (n#01813568). Note that \'warm\' as a TE to תולעת doesn not exist in WN","ordan-10 May 2004, assign-6 Nov 2003",0,"2004-05-10");
INSERT INTO hebrew_synonyms VALUES (3157,"!זַיְפָן","n","07274848","y","dahan","1","rav-milim",NULL,"tg1",NULL,"forger",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3158,"זַיְפָן","n","07274727","n","melingo","1.1","rav-milim","1.1","tg1",NULL,"forger",NULL,"הטרגדיה של זייפני האמנות היא שאינם מסוגלים ליצור יצירות מקוריות משל עצמם","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO\r\n#IE gender","eyal-10 Jul 2005, ordan-21 May 2004",0,"2005-07-10");
INSERT INTO hebrew_synonyms VALUES (3159,"זַיִת","n","08604906","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"olive",NULL,NULL,"checked","#ASSIGN:32.0=[gnd=8.0,glc=14.0,bt(dir)=1.0E+01] #MZ@\r\n#NO","ordan-21 May 2004, assign-6 Nov 2003",91823,"2004-05-21");
INSERT INTO hebrew_synonyms VALUES (3160,"זַיִת","n","08604641","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"olive",NULL,NULL,"checked","#ASSIGN:4.0E+01=[gnd=8.0,glc=14.0,glc=8.0,bt(dir)=1.0E+01] #MZ@\r\n#NO","ordan-21 May 2004, assign-6 Nov 2003",91823,"2004-05-21");
INSERT INTO hebrew_synonyms VALUES (3161,"!זַיִת","n","08604499","y","dahan","1","rav-milim",NULL,"tg1","(tree)","olive",NULL,NULL,"assigned","#ASSIGN:32.0=[gnd=8.0,glc=14.0,bt(dir)=1.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3162,"!זַיִת","n","05802870","y","dahan","1","rav-milim",NULL,"tg1","(tree)","olive",NULL,NULL,"assigned","#ASSIGN:32.0=[gnd=8.0,glc=14.0,bt(dir)=1.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3163,"זַכַּאי","a","01267634","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"acquitted, not_guilty",NULL,"לאחר משפט ארוך, בהעדר ראיות חותכות, נקבע כי הוא זכאי","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO חף מפשע is innocent ","ordan-09 May 2004",91824,"2004-05-09");
INSERT INTO hebrew_synonyms VALUES (3164,"זַלְזַל","n","09449141","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"twig",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO Mrofix seems to mix up the English \'twig\'/\'branchlet\' (זלזל) with \'tendril\' (קנוקנת)","ordan-22 May 2004, assign-6 Nov 2003",91825,"2004-05-22");
INSERT INTO hebrew_synonyms VALUES (3165,"זַמְשׁ","n","10584467","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"suede",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-10 May 2004, assign-6 Nov 2003",91826,"2004-05-10");
INSERT INTO hebrew_synonyms VALUES (3166,"!זַמְשׁ","n","03438292","y","dahan","1","rav-milim",NULL,"tg1",NULL,"suede",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3167,"זַמָּר","n","07577957","n","melingo","1.1","rav-milim","1.1","tg1",NULL,"singer",NULL,NULL,"checked","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@\r\n#NO\r\n#IE gender","eyal-10 Jul 2005, ordan-22 May 2004, assign-6 Nov 2003",0,"2005-07-10");
INSERT INTO hebrew_synonyms VALUES (3168,"זַרְזִיר","n","01099177","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"starling",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,glc=5.0,dfl=6.0] #MZ@\r\n#NO","ordan-10 May 2004, assign-6 Nov 2003",91828,"2004-05-10");
INSERT INTO hebrew_synonyms VALUES (3169,"זַרְחָן","n","10496075","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"phosphorus",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-22 May 2004, assign-6 Nov 2003",91829,"2004-05-22");
INSERT INTO hebrew_synonyms VALUES (3170,"זַרְחָנִי","a","02841579","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"phosphorous, phosphoric",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-09 May 2004, assign-6 Nov 2003",91830,"2004-05-09");
INSERT INTO hebrew_synonyms VALUES (3171,"זַרְקוֹר","n","03293342","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"searchlight",NULL,"המדריך האיר באמצעות הזרקור את השמים והסביר על קבוצות הכוכבים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-10 May 2004",91831,"2004-05-10");
INSERT INTO hebrew_synonyms VALUES (3172,"!זָוִית","n","07014629","y","dahan","1","rav-milim",NULL,"tg1",NULL,"angle",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3173,"!זָחַל","v","01411779","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:86.0=[gnd=8.0,gnd=1.0E+01,si=14.0,bt(dir)=8.0,bt(dir)=1.0E+01,bt(crs)=18.0,bt(dir)=8.0,bt(dir)=1.0E+01] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3174,"זָחַל","v","01287363","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"crawl",NULL,"לאחר שפיתה את חווה לאכול מפרי עץ הדעת, נגזר על הנחש לזחול על גחונו","checked","#ASSIGN:86.0=[gnd=8.0,gnd=1.0E+01,si=14.0,bt(dir)=8.0,bt(dir)=1.0E+01,bt(crs)=18.0,bt(dir)=8.0,bt(dir)=1.0E+01] #MZ@\r\n#NO","ordan-22 May 2004, assign-6 Nov 2003",91832,"2004-05-22");
INSERT INTO hebrew_synonyms VALUES (3175,"זָכָר","n","04776306","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"masculine",NULL,"בעברית מציינת המלה \'הוא\' גוף שלישי יחיד בצורת הזכר","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-13 May 2004, assign-6 Nov 2003",91833,"2004-05-13");
INSERT INTO hebrew_synonyms VALUES (3176,"!זָר","n","07614356","y","dahan","1","rav-milim",NULL,"tg1",NULL,"stranger",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3177,"זָרוּעַ","a","01760779","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"sown, seeded",NULL,NULL,"checked","#ASSIGN:63.0=[gnd=39.0,gnd=8.0,si=16.0] #MZ@\r\n#NO it\'s not metaphorical","ordan-08 May 2004, assign-6 Nov 2003",91834,"2004-05-08");
INSERT INTO hebrew_synonyms VALUES (3178,"זָרוּעַ","a","00061781","yy","none",NULL,"rav-milim","1.3","tg1",NULL,"studded",NULL,"לילה זרוע כוכבים","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-08 May 2004, assign-6 Nov 2003",91834,"2004-05-08");
INSERT INTO hebrew_synonyms VALUES (3179,"זֹהַר","n","03691006","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"glamour",NULL,"רבים נמשכים לזוהר שאופף את השחקניות ההוליוודיות","checked","#ASSIGN:57.0=[gnd=39.0,glc=18.0] #MZ@\r\n#NO","ordan-11 May 2004",91835,"2004-05-11");
INSERT INTO hebrew_synonyms VALUES (3180,"!זֻהֲמָה","n","10399165","y","dahan","1","rav-milim",NULL,"tg1",NULL,"filth",NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3181,"זוֹנָה","n","07507944","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"prostitute",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-21 May 2004, assign-6 Nov 2003",91836,"2004-05-21");
INSERT INTO hebrew_synonyms VALUES (3184,"!זוּטָר","a","01589250","y","dahan","1","rav-milim",NULL,"tg1",NULL,"junior",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6692,"GAP!","a","00963916","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#NO American sepcific","ordan-09 May 2004",91389,"2004-05-09");
INSERT INTO hebrew_synonyms VALUES (3186,"זוּטָר","a","02025910","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"junior",NULL,"העובדים הזוטרים במפעל אינם מקבלים תנאים סוציאליים","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-09 May 2004",91837,"2004-05-09");
INSERT INTO hebrew_synonyms VALUES (3187,"חֲבִילָה","n","05997364","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"package, bundle",NULL,NULL,"checked","#ASSIGN:118.0=[gnd=1.0E+01,bt(dir)=17.0,bt(dir)=11.0,bt(dir)=8.0,bt(crs)=72.0] #MZ@\r\n#NO","ordan-24 May 2004, assign-6 Nov 2003",91838,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (3188,"חֲבִילָה","n","03074890","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"package, parcel",NULL,"הבוקר הגיעה בדואר חבילה מלאה דברים טובים ששלח הדוד מאמריקה","checked","#ASSIGN:68.0=[gnd=1.0E+01,bt(dir)=19.0,bt(dir)=1.0E+01,bt(crs)=29.0] #MZ@\r\n#NO","ordan-24 May 2004, assign-6 Nov 2003",91838,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (3189,"!חֲבֵרָה","n","06997421","nn","dahan","1","rav-milim",NULL,"tg1","(female)","friend",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-14 Jul 2004, assign-6 Nov 2003",0,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3191,"חֲבֵרוּת","n","10038677","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"membership",NULL,"ביטלנו את חברותנו במועדון הקשישים של גבעתיים, כבר אין שם פעילויות מעניינות","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-06 Jun 2004",91089,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (3192,"!חֲבֵרוּת","n","06212281","y","dahan","2","rav-milim",NULL,"tg1","(of organization)","membership",NULL,NULL,"assigned","#ASSIGN:35.0=[gnd=2.0E+01,glc=8.0,bt(dir)=21.0,bt(non)= -14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3193,"חֲבַצֶּלֶת","n","08727889","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"lily",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-25 Jun 2004, assign-6 Nov 2003",91839,"2004-06-25");
INSERT INTO hebrew_synonyms VALUES (3194,"!חֲבָטָה","n","05505766","y","dahan","1","rav-milim",NULL,"tg1","(the sound of a blow)","thud",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,glc=2.0,dfl=9.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3195,"!חֲדִירָה","n","09737023","y","dahan","1","rav-milim",NULL,"tg1","(by water)","permeation",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3196,"!חֲדִירוּת","n","03864989","y","dahan","1","rav-milim",NULL,"tg1",NULL,"penetrability",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3197,"חֲזִיז","n","02684570","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"firecracker, cracker, banger",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-24 May 2004",91840,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (3198,"חֲזִירָה","n","01893422","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"sow",NULL,NULL,"checked","#ASSIGN:5.0E+01=[gnd=39.0,glc=11.0] #MZ@\r\n#NO","ordan-24 Jun 2004, assign-6 Nov 2003",91841,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (3199,"חֲזֶרֶת","n","10169601","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"mumps",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-22 Jun 2004, assign-6 Nov 2003",91842,"2004-06-22");
INSERT INTO hebrew_synonyms VALUES (3200,"חֲזָרָה","n","00576606","yy","melingo","1.4","rav-milim","1.4","tg2",NULL,"rehearsal",NULL,"התזמורת מיעטה בחזרות, ולכן נעשו בקונצרט טעויות מביכות","checked","#ASSIGN:50=[gnd=39.0,glc=1.0,dfl=1.0E+01] #MZ@\r\n#NO","ordan-23 May 2004",91843,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3201,"!חֲטִיבָה","n","06096453","y","dahan","1","rav-milim",NULL,"tg1","(US = regiment)","brigade",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3202,"חֲטִיבָתִי","a","02848703","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"regimental",NULL,"התרגיל החטיבתי יערך היום בצהריים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-07 Aug 2005, assign-6 Nov 2003",95222,"2005-08-07");
INSERT INTO hebrew_synonyms VALUES (3203,"חֲטִיפָה","n","00495415","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"kidnapping",NULL,"לאחר חטיפת בן המיליונרים, דרשו החוטפים סכום כסף גדול עבור שחרורו","checked","#ASSIGN:50=[gnd=39.0,glc=4.0,glc=2.0,dfl=5.0] #MZ@\r\n#NO","ordan-23 May 2004",91844,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3204,"חֲטִיפָה","n","00500941","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"hijacking",NULL,"ארגון טרור בינלאומי לקח אחריות על חטיפת המטוס","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-23 May 2004",91844,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3205,"חֲלִיפוֹת","r","00133501","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"alternately",NULL,"הוא תואר בתארים שונים לסירוגין, פעם כמורה קפדן ופעם כמורה נוח ומסביר פנים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-21 Jun 2004",91845,"2004-06-21");
INSERT INTO hebrew_synonyms VALUES (3207,"!חֲלֻקָּה","n","03970012","y","dahan","2","rav-milim",NULL,"tg1","(distributing things)","distribution",NULL,NULL,"assigned","#ASSIGN:43.0=[gnd=1.0E+01,glc=33.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3208,"!חֲלֻקָּה","n","00701398","y","dahan","2","rav-milim",NULL,"tg1","(distributing things)","distribution",NULL,NULL,"assigned","#ASSIGN:+inf=[gnd=1.0E+01,glc= +inf] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3209,"חֲמִישִׁי","a","02105452","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"fifth",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-17 May 2004, assign-6 Nov 2003",91846,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (3210,"הַחֲמִשִּׁים","a","02108714","yy","none",NULL,"rav-milim",">1.2","tg1",NULL,"fiftieth",NULL,"אמי יצאה לפנסיה מוקדמת בשנתה החמישים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-23 May 2004, assign-6 Nov 2003",91847,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3211,"חֲמַצְמַץ","a","02258037","yy","dahan","1.1","rav-milim","1.1","tg1",NULL,"lemony, lemonlike, sourish, tangy, tart",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-23 May 2004, assign-6 Nov 2003",91848,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3212,"חֲנִינָה","n","04919295","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"amnesty",NULL,"חנינת אסירים מתבצעת בישראל אחת לשנה ביום העצמאות","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-23 May 2004",91849,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3213,"חֲנִינָה","n","00811226","nn","melingo","1.1","rav-milim","1.1","tg1",NULL,"amnesty",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#NO it doesn\'t fit as \'amnesty\' n#04919295","ordan-23 May 2004",91849,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3214,"!חֲנִיקָה","n","00146798","y","dahan","1","rav-milim",NULL,"tg1","(act)","strangling",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,glc=4.0,dfl=7.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3215,"!חֲנִית","n","03378225","y","dahan","1","rav-milim",NULL,"tg1",NULL,"spear",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3216,"חֲנִית","n","03378030","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"spear",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-24 May 2004, assign-6 Nov 2003",91850,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (3217,"חֲנוּת","n","03325022","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"shop, store",NULL,"לאחרונה יש פחות ופחות חנויות לאורך הרחוב, ותחת זאת יש פריחה של מרכזי קניות סגורים","checked","#ASSIGN:50=[gnd=1.0E+01,bt(dir)=11.0,bt(dir)=8.0,bt(crs)=19.0,dfl=2.0] #MZ@\r\n#NO","ordan-24 May 2004",91851,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (3218,"חֲסִידָה","n","01514085","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"stork",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-26 May 2004, assign-6 Nov 2003",91852,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (3219,"!חֲסִינוּת","n","10418829","y","dahan","1","rav-milim",NULL,"tg1",NULL,"immunity",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3220,"!חֲסִינוּת","n","03930302","y","dahan","1","rav-milim",NULL,"tg1",NULL,"immunity",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3221,"!חֲסִינוּת","n","00139905","y","dahan","1","rav-milim",NULL,"tg1",NULL,"immunity",NULL,NULL,"assigned","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3222,"חֲצִיל","n","09193516","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"eggplant, aubergine",NULL,NULL,"checked","#ASSIGN:37.0=[gnd=2.0E+01,bt(dir)=17.0] #MZ@\r\n#NO","ordan-25 Jun 2004, assign-6 Nov 2003",91853,"2004-06-25");
INSERT INTO hebrew_synonyms VALUES (3223,"חֲצִיל","n","05751363","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"aubergine, eggplant",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-25 Jun 2004, assign-6 Nov 2003",91853,"2004-06-25");
INSERT INTO hebrew_synonyms VALUES (3224,"חֲצוֹת","n","10887026","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"midnight",NULL,"בחצות מיהרה סינדרלה לביתה ושמטה את אחת מנעלי הזכוכית שלה ","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-21 Jun 2004, assign-6 Nov 2003",91854,"2004-06-21");
INSERT INTO hebrew_synonyms VALUES (3225,"!חֲרִיקָה","n","05495980","y","dahan","1","rav-milim",NULL,"tg1","(of door etc)","creak",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3226,"!חֲשִׁיבוּת","n","10356224","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"importance",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-20 Jun 2004, assign-6 Nov 2003",0,"2004-06-20");
INSERT INTO hebrew_synonyms VALUES (3227,"חֲשִׁיבוּת","n","04025511","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"importance",NULL,"אני מציע שתחשוב על כך שנית, לעניין חשיבות רבה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-20 Jun 2004, assign-6 Nov 2003",91855,"2004-06-20");
INSERT INTO hebrew_synonyms VALUES (6874,"שְׂפַת-סִימָנִים","n","05145873","yy","none",NULL,"rav-milim","1.1",NULL,NULL,"sign_language",NULL,NULL,"checked","#NO","ordan-24 Jun 2004",91856,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (3229,"חֲתִירָה","n","00373866","yy","melingo","2.5","rav-milim","2.5","tg1",NULL,"crawl, front_crawl, Australian_crawl",NULL,NULL,"checked","#ASSIGN:42.0=[gnd=13.0,glc=18.0,bt(dir)=11.0] #MZ@\r\n#NO","ordan-23 May 2004, assign-6 Nov 2003",91857,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (6749,"הִזְדַּחֲלוּת","n","00212689","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"crawl",NULL,NULL,"checked","#NO","ordan-23 May 2004",91858,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (6750,"זְחִילָה","n","00212689","yy","melingo","1.1","rav-milim","1.2",NULL,NULL,NULL,NULL,"הפקקים בכבישים היו ארוכים והתנועה התקדמה בזחילה","checked","#NO","ordan-23 May 2004",91859,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3231,"חֲתַלְתּוּל","n","01631790","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"kitten",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-20 Jun 2004, assign-6 Nov 2003",91860,"2004-06-20");
INSERT INTO hebrew_synonyms VALUES (3232,"!חֲתֻנָּה","n","06130826","y","dahan","1","rav-milim",NULL,"tg1",NULL,"wedding",NULL,NULL,"assigned","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3233,"חֲתֻנָּה","n","05540443","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"wedding",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#NO","ordan-07 Jun 2004, assign-6 Nov 2003",91861,"2004-06-07");
INSERT INTO hebrew_synonyms VALUES (3234,"חֳלִירַע","n","10163886","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"cholera",NULL,NULL,"checked","#ASSIGN:55.0=[gnd=39.0,glc=16.0] #MZ@\r\n#NO","ordan-06 Jun 2004, assign-6 Nov 2003",91862,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (3235,"חִבֵּל","v","01734511","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-27 May 2004, assign-6 Nov 2003",91863,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (3236,"חִבָּה","n","05608483","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"affection, affectionateness, fondness",NULL,NULL,"checked","#ASSIGN:31.0=[gnd=39.0,gnd=13.0,si=24.0,bt(non)= -34.0,bt(non)= -11.0] #MZ@\r\n#NO","ordan-06 Jun 2004",91864,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (3237,"חִבָּה","n","05573285","nn","none","1.1","none","1.1","tg1",NULL,"liking",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO it is a possible translation, as נטייה or הימשכות, but doesn\'t justify a sysnet in Hebrew","ordan-24 Jun 2004, assign-6 Nov 2003",91864,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (3238,"!חִבּוּק","n","00268334","y","dahan","1","rav-milim",NULL,"tg1",NULL,"hug, cuddle",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3239,"!חִבּוּק","n","00268460","y","dahan","1","rav-milim",NULL,"tg1",NULL,"hug, cuddle",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3240,"חִדּוּשׁ","n","00157011","yy","oxford","1.2","rav-milim","1.5","tg1",NULL,"resumption, recommencement",NULL,"לאחר הפסקה ארוכה, הוחלט על חידוש המשא ומתן","revised","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","eyal-15 Aug 2004, ordan-23 May 2004",91865,"2004-08-15");
INSERT INTO hebrew_synonyms VALUES (3241,"חִדּוּשׁ","n","02865563","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"innovation",NULL,"המאה ה-17 התאפיינה בחידושים מדעיים רבים","checked","#ASSIGN:50=[gnd=2.0E+01,bt(non)= -14.0,bt(dir)=19.0,dfl=25.0] #MZ@\r\n#NO","ordan-23 May 2004, assign-6 Nov 2003",91865,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3242,"חִזּוּי","n","05057929","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,NULL,NULL,"לפי החיזויים שהושמעו לאחרונה על ידי כלכלנים, האבטלה תרד בתחילת השנה הבאה ","revised","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO WN makes a distinction between the reasoning rather than the statement about the future (the difference between \'prediction\' n#04453620 and \'prediction\' n#05057929); RM doesn\'t. ","eyal-22 Aug 2004, ordan-20 Jun 2004",91866,"2004-08-22");
INSERT INTO hebrew_synonyms VALUES (3244,"!חִטָּה","n","08448511","y","dahan","1","rav-milim",NULL,"tg1",NULL,"wheat",NULL,NULL,"assigned","#ASSIGN:7.0E+01=[gnd=2.0E+01,bt(dir)=19.0,bt(dir)=6.0,bt(crs)=25.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3245,"חִטָּה","n","05837413","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"wheat",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-25 Jun 2004, assign-6 Nov 2003",91867,"2004-06-25");
INSERT INTO hebrew_synonyms VALUES (3246,"חִיֵּג","v","00536527","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,NULL,NULL,"חייגתי מספר שגוי כנראה, ענתה שם מישהי שאינה מדברת עברית","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-28 May 2004",91868,"2004-05-28");
INSERT INTO hebrew_synonyms VALUES (3247,"!חִיֵּג","v","00455913","nn","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO the only sense of חייג is that which appears in v#00536527","ordan-28 May 2004, assign-6 Nov 2003",0,"2004-05-28");
INSERT INTO hebrew_synonyms VALUES (3248,"חִיּוּךְ","n","05147735","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"smile",NULL,"חיוכו הצביע על כך שקיבל את הקִנטור ברוח טובה","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-20 Jun 2004",91869,"2004-06-20");
INSERT INTO hebrew_synonyms VALUES (3249,"חִיּוּנִי","a","01524177","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"essential, indispensable",NULL,"הוא עובד חיוני, איננו יכולים לוותר עליו","checked","#ASSIGN:51.0=[gnd=7.0,bt(dir)=8.0,bt(dir)=14.0,bt(crs)=22.0] #MZ@\r\n#NO","ordan-23 May 2004, assign-6 Nov 2003",91870,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3250,"!חִידוֹן","n","05379363","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"quiz",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO normally, ''quiz'' appears in the context of entertainment, in which case it is indeed חידון (the first sense that appears in Collins as opposed to the second). However, here it refers to something similar to בוחן. The first sense just doesn\'t appear in WN. ","ordan-20 Jun 2004",0,"2004-06-20");
INSERT INTO hebrew_synonyms VALUES (3251,"!חִיצוֹנִי","a","00905055","y","dahan","1","rav-milim",NULL,"tg1",NULL,"external, outside, exterior",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3252,"חִכּוּךְ","n","07800619","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"friction",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-23 May 2004, assign-6 Nov 2003",91871,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3253,"חִכּוּךְ","n","00456982","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"friction",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-23 May 2004, assign-6 Nov 2003",91871,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3254,"!חִלְחוּל","n","09737023","y","dahan","1","rav-milim",NULL,"tg1",NULL,"permeation",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3255,"חִמְצֵן","v","00163821","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"oxidize",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-14 Jun 2004, assign-6 Nov 2003",91872,"2004-06-14");
INSERT INTO hebrew_synonyms VALUES (3256,"חִמְצוּן","n","09684568","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"oxidization, oxidation",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-22 Jun 2004, assign-6 Nov 2003",91873,"2004-06-22");
INSERT INTO hebrew_synonyms VALUES (3257,"חִמּוּם","n","00742153","yy","melingo","1.3","rav-milim","1.4","tg1",NULL,"warm-up",NULL,"לפני שנכנס לבריכה עשה כמה תרגילי חימום","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","ordan-23 May 2004, assign-6 Nov 2003",91874,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3258,"חִסֵּן","v","00058927","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"immunize, innoculate, inoculate, vaccinate",NULL,"צריך לחסן את הכלבים נגד כלבת","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-21 Jun 2004, assign-6 Nov 2003",91875,"2004-06-21");
INSERT INTO hebrew_synonyms VALUES (3259,"חִסָּכוֹן","n","09619452","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"savings",NULL,"מדי חודש אני מפריש 10 אחוזים מהכנסותיי לחיסכון","checked","#ASSIGN:57.0=[gnd=39.0,glc=11.0,glc=7.0] #MZ@\r\n#NO","ordan-22 Jun 2004, assign-6 Nov 2003",91876,"2004-06-22");
INSERT INTO hebrew_synonyms VALUES (3260,"!חִסּוּן","n","00531161","y","dahan","1","rav-milim",NULL,"tg1","(med)","immunization",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3261,"חִפּוּשִׁית","n","01669942","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"beetle",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-26 May 2004, assign-6 Nov 2003",91877,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (3262,"חִשֵּׁל","v","00209319","yy","dahan","1.1","rav-milim","1.1","tg1",NULL,NULL,NULL,"כמאמר הקלישאה, מה שלא הורג אותך מחשל אותך","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-20 Jun 2004, assign-6 Nov 2003",91878,"2004-06-20");
INSERT INTO hebrew_synonyms VALUES (3263,"חִשּׁוּר","n","03387543","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"spoke",NULL,NULL,"checked","#ASSIGN:25.0=[gnd=2.0E+01,glc=5.0] #MZ@\r\n#NO","ordan-24 May 2004, assign-6 Nov 2003",91879,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (3264,"חִתּוּל","n","02564894","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"diaper, nappy, napkin",NULL,"למרות שכבר החל לשלוט בצרכיו, התעקש אודי הקטן להמשיך ללבוש חיתולים","checked","#ASSIGN:51.0=[gnd=39.0,bt(dir)=39.0,bt(non)= -27.0] #MZ@\r\n#NO","ordan-24 May 2004",91880,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (3265,"!חֵטְא","n","06876198","y","dahan","1","rav-milim",NULL,"tg1",NULL,"sin",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3266,"חֵךְ","n","04121211","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"palate",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-06 Jun 2004, assign-6 Nov 2003",91881,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (3267,"!חֵמָה","n","00489929","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"anger, wrath",NULL,NULL,"checked","#ASSIGN:57.0=[gnd=13.0,gnd=2.0E+01,si=24.0] #MZ@\r\n#NO christian connotation","ordan-02 Feb 2004, assign-6 Nov 2003",0,"2004-02-02");
INSERT INTO hebrew_synonyms VALUES (3268,"!חֵמָר","n","10731519","nn","dahan","2","rav-milim",NULL,"tg1",NULL,"clay",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-21 Jun 2004, assign-6 Nov 2003",0,"2004-06-21");
INSERT INTO hebrew_synonyms VALUES (3269,"חֵמָר","n","10626993","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"clay",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-21 Jun 2004, assign-6 Nov 2003",91882,"2004-06-21");
INSERT INTO hebrew_synonyms VALUES (6758,"קֶסֶם","n","03692429","yy","oxford","1.1","rav-milim","1.3.3",NULL,NULL,"appeal, appealingness, charm",NULL,"בהתחלה לא גילתה עניין בבלשנות, אך לאחר מכן נשבתה בקסמי המקצוע","revised","#NO","eyal-01 Feb 2005, ordan-24 May 2004",91883,"2005-02-01");
INSERT INTO hebrew_synonyms VALUES (6756,"סִימָן-טוֹב","n","02424438","yy","none",NULL,"rav-milim","1.1",NULL,NULL,"charm, good_luck_charm",NULL,"יש המאמינים כי התעטשות מעידה על סימן טוב לבאות","checked","#NO","ordan-24 May 2004",91884,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (3272,"חֵץ","n","02545362","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"dart",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO RM doesn\'t differentiate between \'dart\' and \'arrow\'","ordan-23 May 2004",91885,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3273,"!חֵץ","n","02545258","y","dahan","2","rav-milim",NULL,"tg1","(for a game)","dart",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3274,"חֵרְשׁוּת","n","10434472","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"deafness",NULL,"בשנותיו האחרונות סבל בטהובן מחרשות, ובכל זאת המשיך להלחין","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-21 Jun 2004, assign-6 Nov 2003",91886,"2004-06-21");
INSERT INTO hebrew_synonyms VALUES (3275,"!חֵרֵשׁ","a","01144852","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"deaf",NULL,NULL,"checked","#ASSIGN:27.0=[gnd=2.0E+01,bt(dir)=21.0,bt(non)= -14.0] #MZ@\r\n#NO that\'s what we call תרגומית; the proverb אטם את אוזניו is the TE","ordan-24 Jun 2004",0,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (3276,"חֵרֵשׁ","a","00647484","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"deaf",NULL,NULL,"revised","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","eyal-12 Aug 2004, ordan-22 May 2004, assign-6 Nov 2003",91887,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (3277,"חֵרֵשׁ","n","05960426","n","melingo","1.1","rav-milim","1.1","tg1",NULL,"deaf",NULL,"חרשים משתמשים בדרך כלל בשפת סימנים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE fits better to ''deaf person'' (n#07204757)","eyal-17 Jul 2005, ordan-22 May 2004, assign-6 Nov 2003",0,"2005-07-17");
INSERT INTO hebrew_synonyms VALUES (3278,"!חֵרֶם","n","04994165","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"embargo",NULL,NULL,"checked","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=19.0,dfl=11.0] #MZ@\r\n#NO","ordan-17 May 2004, assign-6 Nov 2003",0,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (3279,"חֵרֶם","n","00135310","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"boycott",NULL,"בעקבות גל הפיטורים, קרא אירגון העובדים לעשות חרם על המפעל ולא לקנות ממוצריו","revised","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@\r\n#NO","eyal-15 Aug 2004, ordan-17 May 2004",91889,"2004-08-15");
INSERT INTO hebrew_synonyms VALUES (6868,"GAP!","n","05573285","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#NO There are some translation equivalents (cf. the חיבה card) but no real sysnet match in Hebrew ","ordan-24 Jun 2004",90808,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (3282,"!חֶבֶל","n","03252883","y","dahan","1","rav-milim",NULL,"tg1",NULL,"rope",NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3283,"חֶלְבּוֹן","n","10560829","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"protein",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-21 Jun 2004, assign-6 Nov 2003",91890,"2004-06-21");
INSERT INTO hebrew_synonyms VALUES (3284,"חֶלְמוֹן","n","00989609","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"yolk",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-23 May 2004, assign-6 Nov 2003",91891,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3285,"!חֶמְאָה","n","07133531","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"butter",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO should have been matched to חמאה","ordan-07 Jun 2004, assign-6 Nov 2003",0,"2004-06-07");
INSERT INTO hebrew_synonyms VALUES (3286,"חֶמְאָה","n","05879421","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"butter",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-17 May 2004",91892,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (3287,"חֶמְלָה","n","03785836","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"compassion",NULL,NULL,"checked","#ASSIGN:33.0=[gnd=8.0,gnd=2.0E+01,si=24.0,bt(non)= -5.0,bt(non)= -14.0] #MZ@\r\n#NO","ordan-26 May 2004, assign-6 Nov 2003",91893,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (3288,"!חֶנְוָנִי","n","07572257","y","dahan","1","rav-milim",NULL,"tg1","(US = storekeeper)","shopkeeper",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3289,"!חֶנֶק","n","00146677","y","dahan","1","rav-milim",NULL,"tg1",NULL,"suffocation",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3290,"!חֶסֶד","n","10373357","nn","dahan","2","rav-milim",NULL,"tg1","(of God)","grace",NULL,NULL,"checked","#ASSIGN:25.0=[gnd=7.0,glc=18.0] #MZ@\r\n#NO Christian specific","ordan-20 Jun 2004, assign-6 Nov 2003",0,"2004-06-20");
INSERT INTO hebrew_synonyms VALUES (3291,"חֶסֶד","n","03794441","yy","melingo","1.2","rav-milim","1.4","tg1",NULL,"grace",NULL,"כי לעולם חסדו","revised","#ASSIGN:25.0=[gnd=7.0,glc=18.0] #MZ@\r\n#NO in principal this is a Christian term, but may be ''coordinated'' with the Hebrew very similar (at least for a non-religious person) חסד","eyal-22 Aug 2004, ordan-20 Jun 2004",91894,"2004-08-22");
INSERT INTO hebrew_synonyms VALUES (3292,"חֶרְמֵשׁ","n","03291320","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"scythe",NULL,NULL,"revised","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO RM mixes up \'scythe\' with \'sickle\', the first should be חרמש the second מגל (believe me, I grew up in a kibbutz)","eyal-22 Aug 2004, ordan-24 May 2004, assign-6 Nov 2003",91895,"2004-08-22");
INSERT INTO hebrew_synonyms VALUES (3293,"חֶרְפָּה","n","10360525","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"shame",NULL,NULL,"checked","#ASSIGN:50=[gnd=1.0E+01,bt(dir)=39.0,dfl=1.0] #MZ@\r\n#NO","ordan-15 Apr 2004, assign-6 Nov 2003",91896,"2004-04-15");
INSERT INTO hebrew_synonyms VALUES (3294,"חֶרֶב","n","03457380","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"sword",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,bt(dir)=33.0,bt(non)= -23.0,bt(non)= -23.0,dfl=24.0] #MZ@\r\n#NO","ordan-24 May 2004, assign-6 Nov 2003",91897,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (3295,"חֶרֶס","n","03165060","yy","melingo","1.2","rav-milim","1.2.2","tg1",NULL,"potsherd",NULL,"הארכיאולוגים אספו בזהירות חרסים עתיקים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-24 May 2004",91898,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (3296,"חֶשְׁבּוֹנִי","a","02796906","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"arithmetical, arithmetic",NULL,"סדרה חשבונית","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-23 May 2004, assign-6 Nov 2003",91899,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3297,"חֶשְׁבּוֹנָאוּת","n","00407290","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"accountancy",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-23 May 2004, assign-6 Nov 2003",91900,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3298,"!חַבְּלָן","n","07542125","y","dahan","2","rav-milim",NULL,"tg1","(commits sabotage)","saboteur",NULL,NULL,"assigned","#ASSIGN:+inf=[gnd=2.0E+01,glc= +inf,glc=27.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3299,"חַבּוּרָה","n","10259769","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"bruise, contusion",NULL,"היא נפלה מגובה שני מטרים, אך לבד מחבורות בברכיים לא נפגעה כלל","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-21 Jun 2004",91901,"2004-06-21");
INSERT INTO hebrew_synonyms VALUES (3300,"חַבּוּשׁ","n","08928849","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"quince",NULL,NULL,"checked","#ASSIGN:57.0=[gnd=2.0E+01,glc=11.0,glc=7.0,bt(dir)=19.0] #MZ@\r\n#NO","ordan-25 Jun 2004, assign-6 Nov 2003",91902,"2004-06-25");
INSERT INTO hebrew_synonyms VALUES (3301,"חַבּוּשׁ","n","05805084","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"quince",NULL,NULL,"checked","#ASSIGN:62.0=[gnd=2.0E+01,glc=11.0,glc=7.0,bt(dir)=24.0] #MZ@\r\n#NO","ordan-25 Jun 2004, assign-6 Nov 2003",91902,"2004-06-25");
INSERT INTO hebrew_synonyms VALUES (3302,"חַדְגּוֹנִיּוּת","n","03724711","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"monotony, sameness",NULL,"הוא מעולם לא הסתגל לחדגוניות של עבודתו","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-24 May 2004",91903,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (3303,"חַדְרָנִית","n","07147268","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"chambermaid",NULL,"בזמן שירדנו לבריכת המלון, ניקתה החדרנית את חדרנו","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-20 Jun 2004, assign-6 Nov 2003",91904,"2004-06-20");
INSERT INTO hebrew_synonyms VALUES (3304,"חַוָּה","n","02666240","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"farm",NULL,"בחופשת הקיץ יצא לעבוד בחווה של דודיו בכפר","revised","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","eyal-22 Aug 2004, ordan-24 May 2004",91905,"2004-08-22");
INSERT INTO hebrew_synonyms VALUES (3305,"חַזַּאי","n","07676367","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"weatherman, weather_forecaster",NULL,"בסוף החדשות בישר החזאי על הקלה בטמפרטורות","checked","#ASSIGN:176.0=[gnd=39.0,gnd=39.0,si=98.0] #MZ@\r\n#NO RM doesn\'t differentiate between ''meteorologist'' (a scientist)and ''forecaster'' (דני רופ)","ordan-20 Jun 2004",91906,"2004-06-20");
INSERT INTO hebrew_synonyms VALUES (3306,"חַזָּן","n","07137903","n","melingo","1.1","rav-milim","1.1","tg1",NULL,"hazan, cantor",NULL,NULL,"checked","#ASSIGN:93.0=[gnd=39.0,glc=54.0] #MZ@\r\n#NO\r\n#IE gender","eyal-17 Jul 2005, ordan-21 Jun 2004, assign-6 Nov 2003",0,"2005-07-17");
INSERT INTO hebrew_synonyms VALUES (3307,"!חַטְטָן","n","07233744","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"snooper",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO this sysnet is more technical for someone who eavesdrop (מצותת), Hebrew has the participle מצותת but only rarely can it be used as a noun","ordan-07 Jun 2004, assign-6 Nov 2003",0,"2004-06-07");
INSERT INTO hebrew_synonyms VALUES (3308,"חַי","a","00098090","yy","oxford","1.2","rav-milim","2.1","tg2",NULL,"live, living",NULL,"בעתיד ניתן יהיה לגדל במעבדה רקמות חיות מכל סוג נדרש","checked","#ASSIGN:50=[gnd=4.0,bt(dir)=4.0,bt(dir)=6.0,bt(crs)=1.0E+01,dfl=26.0] #MZ@\r\n#NO","eyal-12 Aug 2004",91104,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (3309,"!חַיִל","n","06095661","nn","dahan","1","rav-milim",NULL,"tg1","(mil)","corps",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO in Hebrew חיל is restricted to the military (n#06095338); the closest TE is סגלbut that would be better matched with ''staff''. ","ordan-20 Jun 2004",0,"2004-06-20");
INSERT INTO hebrew_synonyms VALUES (3310,"חַיִל","n","06095338","yy","melingo","1","rav-milim","1.1","tg1",NULL,"corps",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-10 Mar 2004, assign-6 Nov 2003",91908,"2004-03-10");
INSERT INTO hebrew_synonyms VALUES (3311,"!חַיָּט","n","07629479","y","dahan","1","rav-milim",NULL,"tg1",NULL,"tailor",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3312,"חַיָּל","n","07591125","n","melingo","1.1","rav-milim","1.1","tg1",NULL,"soldier",NULL,"החיילים עמדו דום והצדיעו למפקדם","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO\r\n#IE gender","eyal-18 Jul 2005, ordan-26 May 2004, assign-6 Nov 2003",0,"2005-07-18");
INSERT INTO hebrew_synonyms VALUES (3313,"!חַיָּל","n","01711727","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"soldier",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO better check with a zoologist","ordan-26 May 2004, assign-6 Nov 2003",0,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (3314,"חַיָּתִי","a","01212141","yy","oxford","1.1","rav-milim","1.1","tg1",NULL,"beastly, bestial, brute, brutish",NULL,"בניגוד לאמנת ז\'נבה, היחס אל האסירים היה חייתי","revised","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","eyal-12 Aug 2004, ordan-23 May 2004",91910,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (3315,"חַלָּמִישׁ","n","10666463","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"flint",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-28 May 2004, assign-6 Nov 2003",91911,"2004-05-28");
INSERT INTO hebrew_synonyms VALUES (3316,"חַמְצָן","n","10495237","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"oxygen, O",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-20 Jun 2004",91912,"2004-06-20");
INSERT INTO hebrew_synonyms VALUES (3317,"חַמָּנִית","n","08285778","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"sunflower",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-24 Jun 2004, assign-6 Nov 2003",91913,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (3318,"!חַנְיוֹן","n","06282697","y","dahan","1","rav-milim",NULL,"tg1",NULL,"campground",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3319,"חַנְקָה","n","10775251","yy","oxford","1.1","none",NULL,"tg1",NULL,"nitrate",NULL,NULL,"revised","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","eyal-23 Aug 2004, ordan-21 Jun 2004, assign-6 Nov 2003",91914,"2004-08-23");
INSERT INTO hebrew_synonyms VALUES (3320,"חַנְקָן","n","10494444","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"nitrogen, N",NULL,NULL,"checked","#ASSIGN:56.0=[gnd=39.0,flc(pot)=5.0,flc(pot)=5.0,glc=7.0] #MZ@\r\n#NO","ordan-21 Jun 2004, assign-6 Nov 2003",91915,"2004-06-21");
INSERT INTO hebrew_synonyms VALUES (3321,"חַנְקָנִי","a","02835011","yy","oxford","1.1","rav-milim","1.1","tg1",NULL,"nitric",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-07 Aug 2005, assign-6 Nov 2003",95221,"2005-08-07");
INSERT INTO hebrew_synonyms VALUES (3322,"חַסָּה","n","08293804","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"lettuce",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-25 Jun 2004, assign-6 Nov 2003",91916,"2004-06-25");
INSERT INTO hebrew_synonyms VALUES (3323,"חַסָּה","n","05761291","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"lettuce",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-25 Jun 2004, assign-6 Nov 2003",91916,"2004-06-25");
INSERT INTO hebrew_synonyms VALUES (3324,"חַפּוּת","n","10078249","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"innocence",NULL,"כבר לאחר השימוע הראשון שוכנע היועץ המשפט בחפותו","checked","#ASSIGN:50=[gnd=13.0,glc=18.0,dfl=19.0] #MZ@\r\n#NO","ordan-21 Jun 2004",91917,"2004-06-21");
INSERT INTO hebrew_synonyms VALUES (3325,"חַצֶּבֶת","n","10160032","yy","melingo","1","rav-milim","1.1","tg1","(med)","measles, rubeola",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-01 Feb 2004, assign-6 Nov 2003",91918,"2004-02-01");
INSERT INTO hebrew_synonyms VALUES (3326,"!חַקְיָן","n","07411603","y","dahan","1","rav-milim",NULL,"tg1",NULL,"mimic",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3327,"!חַקְלַאי","n","07256794","n","dahan","1","rav-milim",NULL,"tg1",NULL,"farmer",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE gender","eyal-26 Jun 2005, assign-6 Nov 2003",0,"2005-06-26");
INSERT INTO hebrew_synonyms VALUES (3328,"!חַקְלָאוּת","n","06058165","y","dahan","1","rav-milim",NULL,"tg1",NULL,"agriculture",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3329,"!חַרְגּוֹל","n","01729962","y","dahan","1","rav-milim",NULL,"tg1","(insect)","grasshopper",NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,glc=27.0,dfl=3.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3330,"חַרְדָּל","n","08186398","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"mustard",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-25 Jun 2004",91919,"2004-06-25");
INSERT INTO hebrew_synonyms VALUES (3331,"חַרְדָּל","n","05852339","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"mustard, table_mustard",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#NO","ordan-25 Jun 2004, assign-6 Nov 2003",91919,"2004-06-25");
INSERT INTO hebrew_synonyms VALUES (3332,"חַרְסִית","n","10515601","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"china_clay, kaolin",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-21 Jun 2004",91920,"2004-06-21");
INSERT INTO hebrew_synonyms VALUES (3333,"חַרְצִית","n","08258932","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"chrysanthemum",NULL,NULL,"checked","#ASSIGN:34.0=[gnd=2.0E+01,glc=14.0] #MZ@\r\n#NO","ordan-25 Jun 2004, assign-6 Nov 2003",91921,"2004-06-25");
INSERT INTO hebrew_synonyms VALUES (3334,"חַרְצִית","n","08258003","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"chrysanthemum",NULL,NULL,"checked","#ASSIGN:34.0=[gnd=2.0E+01,glc=14.0] #MZ@\r\n#NO","ordan-25 Jun 2004, assign-6 Nov 2003",91921,"2004-06-25");
INSERT INTO hebrew_synonyms VALUES (3335,"!חַשָּׁב","n","07058678","y","dahan","1","rav-milim",NULL,"tg1",NULL,"accountant",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3336,"חַשְׁדָנוּת","n","03834482","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"suspiciousness",NULL,"תפסיק עם החשדנות הזאת, אתה ממש פרנואיד!","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-26 May 2004",91922,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (3337,"!חַשְׁמַל","n","07793357","y","dahan","1","rav-milim",NULL,"tg1",NULL,"electricity",NULL,NULL,"assigned","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3338,"!חַשְׁמַל","n","07793035","y","dahan","1","rav-milim",NULL,"tg1",NULL,"electricity",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3339,"חַשְׁמַל","n","05586574","yy","none","1","none",NULL,"tg1",NULL,"electricity",NULL,"כשעלתה על הבמה אפשר היה להרגיש את החשמל באוויר","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n# didn\'t find a trace for that in the dictionaries; however, as a verb חישמל it does appear in RM, they probably forgot to present it as a noun. ","ordan-22 Jun 2004, assign-6 Nov 2003",91923,"2004-06-22");
INSERT INTO hebrew_synonyms VALUES (3340,"טָעוּן","a","02290994","yy","none",NULL,"rav-milim","1.4",NULL,NULL,"electric",NULL,"האווירה היתה טעונה, אף אחד לא פצה את פיו","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO note that \'charged\' (a#00814456) is better translated as \'רווי\'","ordan-23 May 2004",91924,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (6742,"מְחַשְׁמֵל","a","00874188","yy","none",NULL,"none",NULL,NULL,NULL,"electric, galvanic, galvanizing",NULL,"למנהיג היתה השפעה מחשמלת על הקהל","checked","#NO have a look at the verb חִשְׁמֵל in RM 1.3, same meaning","ordan-23 May 2004",91925,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3342,"חַשְׁמַלִּי","a","02622421","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"electric, electrical",NULL,"מעגל חשמלי","checked","#ASSIGN:91.0=[gnd=13.0,bt(dir)=16.0,bt(dir)=23.0,bt(crs)=39.0] #MZ@\r\n#NO","ordan-23 May 2004",91926,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3343,"!חַשְׂפָן","n","07616697","y","dahan","1","rav-milim",NULL,"tg1",NULL,"stripper",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3344,"!חַתְרָן","n","07532433","n","dahan","1","rav-milim",NULL,"tg1",NULL,"subversive",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE has a different meaning than מהפכן and cannot be, in my opinion, in the same synset","eyal-02 Nov 2005, assign-6 Nov 2003",0,"2005-11-02");
INSERT INTO hebrew_synonyms VALUES (3345,"חַתְרָנִי","a","00915013","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"subversive",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-23 May 2004, assign-6 Nov 2003",91927,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (6974,"קְוֶקֶר","n","06997421","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"Quaker",NULL,NULL,"checked","#NO","ordan-14 Jul 2004",91928,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3347,"חָבוּשׁ","a","01887084","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"bandaged",NULL,"הוא יצא מהמרפאה כשראשו חבוש","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-23 May 2004, assign-6 Nov 2003",91929,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3348,"!חָגְלָה","n","01325829","nn","dahan","1","rav-milim",NULL,"tg1","(bird)","rock_partridge",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-25 Jun 2004, assign-6 Nov 2003",0,"2004-06-25");
INSERT INTO hebrew_synonyms VALUES (3349,"!חָגַר","v","00406840","nn","dahan","2","rav-milim",NULL,"tg1","(equipment)",NULL,NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","ordan-21 Jun 2004, assign-6 Nov 2003",0,"2004-06-21");
INSERT INTO hebrew_synonyms VALUES (3350,"!חָגָב","n","01729962","y","dahan","1","rav-milim",NULL,"tg1","(insect)","grasshopper",NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,glc=27.0,dfl=3.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3351,"חָדִיר","a","01707060","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"permeable",NULL,"לקראת החורף הצטיידתי בנעליים שאינן חדירות למים","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-23 May 2004",91930,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3352,"חֲזִיָּה","n","02331715","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"brassiere, bra",NULL,"בשנות ה-60 שרפו פמיניסטיות חזיות לאות מחאה","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-23 May 2004, assign-6 Nov 2003",91931,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3353,"חָזֶה!","n","04301367","n","melingo","1.1","rav-milim","1.1","tg1",NULL,"chest, thorax",NULL,NULL,"revised","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO\r\n#IE matches better to n#04302029","eyal-22 Mar 2005, ordan-27 May 2004",0,"2005-03-22");
INSERT INTO hebrew_synonyms VALUES (3354,"!חָזֶה","n","02428247","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"chest",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-17 May 2004, assign-6 Nov 2003",0,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (3355,"!חָזֶה","n","02427713","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"chest",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-17 May 2004, assign-6 Nov 2003",0,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (3356,"חָטוּב","a","02062857","yy","oxford","1.2","rav-milim","1.1","tg1",NULL,"shapely",NULL,"לטובת המראה החטוב, משקיעים כיום צעירים עשרות שעות בשבוע בחדרי כושר","revised","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","eyal-14 Aug 2004, ordan-23 May 2004, assign-6 Nov 2003",91933,"2004-08-14");
INSERT INTO hebrew_synonyms VALUES (3357,"חָטוּף","a","00306683","yy","none",NULL,"rav-milim","1.3","tg1",NULL,"casual, cursory, passing",NULL,"מבט חטוף","revised","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","eyal-12 Aug 2004, ordan-22 May 2004, assign-6 Nov 2003",91934,"2004-08-12");
INSERT INTO hebrew_synonyms VALUES (3358,"!חָכוּר","a","00349471","n","dahan","1","rav-milim",NULL,"tg1","(land)","leased",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-01 Aug 2005, assign-6 Nov 2003",0,"2005-08-01");
INSERT INTO hebrew_synonyms VALUES (3359,"חָלָב","n","05876056","yy","melingo","1.1","rav-milim","1.3","tg1",NULL,"milk",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO Only the 2nd part of the definition (1.3) in RM","ordan-17 May 2004, assign-6 Nov 2003",91935,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (3360,"חָלָב","n","05875585","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"milk",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-17 May 2004",91935,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (3361,"חָלָב","n","04196379","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"milk",NULL,"הכבשה מיניקה את הטלה בחלב","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-17 May 2004",91935,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (3362,"!חָלָב","n","06824418","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"milk",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO American geography","ordan-22 Jun 2004, assign-6 Nov 2003",0,"2004-06-22");
INSERT INTO hebrew_synonyms VALUES (3363,"חָמְרָנוּת","n","10112814","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"materialism",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-20 Jun 2004, assign-6 Nov 2003",91936,"2004-06-20");
INSERT INTO hebrew_synonyms VALUES (3364,"!חָמְרָנוּת","n","04581754","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"materialism",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO חמרנות in Hebrew is reserved for the other sense of ''materialism'' n#10112814","ordan-20 Jun 2004, assign-6 Nov 2003",0,"2004-06-20");
INSERT INTO hebrew_synonyms VALUES (3365,"חָמַד","v","01246798","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,NULL,NULL,"לֹא-תַחְמֹד אֵשֶׁת רֵעֶךָ, וְעַבְדּוֹ וַאֲמָתוֹ וְשׁוֹרוֹ וַחֲמֹרוֹ, וְכֹל, אֲשֶׁר לְרֵעֶךָ (ספר שמות, פרק 20 פס\' 14)","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-27 May 2004",91937,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (3366,"חָמוּר","a","00614072","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"serious, grave",NULL,"זהו מקרה חמור מאד של דלקת ריאות","checked","#ASSIGN:124.0=[gnd=13.0,gnd=7.0,si=12.0,bt(non)= -8.0,bt(dir)=13.0,bt(dir)=7.0,bt(dir)=6.0,bt(crs)=52.0,bt(non)= -4.0,bt(dir)=13.0,bt(dir)=7.0,bt(dir)=6.0] #MZ@\r\n#IE","eyal-01 Aug 2005, assign-6 Nov 2003",95220,"2005-08-01");
INSERT INTO hebrew_synonyms VALUES (3367,"!חָמוּר","a","02044251","u","dahan","1","rav-milim",NULL,"tg1",NULL,"grave, severe",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-01 Aug 2005, assign-6 Nov 2003",0,"2005-08-01");
INSERT INTO hebrew_synonyms VALUES (3368,"!חָנִיךְ","n","07134776","nn","dahan","1","rav-milim",NULL,"tg1","(mil)","cadet",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE gender","eyal-27 Feb 2005, assign-6 Nov 2003",0,"2005-02-27");
INSERT INTO hebrew_synonyms VALUES (3369,"חָנַט","v","01523551","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"embalm",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO its troponym is ''mummify'' which is חנט as well. ","ordan-27 May 2004",91938,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (3370,"חָנַךְ","v","01651229","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:50=[gnd=13.0,glc=27.0,glc=1.0,dfl=9.0] #MZ@\r\n#NO","ordan-27 May 2004, assign-6 Nov 2003",91939,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (3371,"חָנַק","v","01081810","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"strangle",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-28 May 2004, assign-6 Nov 2003",91940,"2004-05-28");
INSERT INTO hebrew_synonyms VALUES (3372,"חָנָה","v","01319179","yy","melingo","1.1","rav-milim","1.1","tg1","(vehicle)","park",NULL,"אתה יכול לחנות את רכבך אצלי בחצר","checked","#ASSIGN:56.0=[gnd=13.0,glc=27.0,bt(dir)=16.0] #MZ@ #IE","eyal-23 Aug 2004, eyal-10 Apr 2004, assign-6 Nov 2003",91941,"2004-08-23");
INSERT INTO hebrew_synonyms VALUES (3373,"!חָנָה","v","01025543","y","dahan","1","rav-milim",NULL,"tg1","(vehicle)",NULL,NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3374,"חָנוּט","n","04056757","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"mummy",NULL,NULL,"checked","#ASSIGN:28.0=[gnd=2.0E+01,glc=5.0,glc=3.0] #MZ@\r\n#NO","ordan-26 May 2004, assign-6 Nov 2003",91942,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (3375,"!חָנוּק","a","01563078","y","dahan","1","rav-milim",NULL,"tg1",NULL,"choked",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3376,"חָסִין","a","01709139","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"proof",NULL,"חסין אש","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO cf especially the collocations given by RM","ordan-23 May 2004, assign-6 Nov 2003",91943,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3377,"חָפַף","v","00029432","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"shampoo",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-21 Jun 2004, assign-6 Nov 2003",91944,"2004-06-21");
INSERT INTO hebrew_synonyms VALUES (3378,"חָפוּז","a","01217941","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"hurried",NULL,"לאחר ביקור חפוז בבית הוריי, יצאתי במהרה להביא את בני מהגן","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-23 May 2004",91945,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3379,"חָצִיר","n","05835955","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"hay",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-25 Jun 2004, assign-6 Nov 2003",91946,"2004-06-25");
INSERT INTO hebrew_synonyms VALUES (3380,"חָצָה","v","00433781","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"halve",NULL,"אבא חצה את פרוסת העוגה האחרונה, וחילק אותה ביני לבין אחותי","checked","#ASSIGN:50=[gnd=2.0E+01,glc=8.0,dfl=22.0] #MZ@\r\n#NO","ordan-06 Jun 2004, assign-6 Nov 2003",91947,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (3381,"חָצָץ","n","10536256","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"gravel",NULL,NULL,"checked","#ASSIGN:78.0=[gnd=39.0,bt(dir)=39.0] #MZ@\r\n#NO","ordan-21 Jun 2004, assign-6 Nov 2003",91948,"2004-06-21");
INSERT INTO hebrew_synonyms VALUES (3382,"!חָצוּף","a","02169249","y","dahan","1","rav-milim",NULL,"tg1",NULL,"cheeky, impudent, impertinent",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3383,"!חָצוּף","a","01906636","y","dahan","1","rav-milim",NULL,"tg1",NULL,"cheeky, impudent, impertinent",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3384,"!חָצוּף","a","00205511","y","dahan","1","rav-milim",NULL,"tg1",NULL,"cheeky, impudent, impertinent",NULL,NULL,"assigned","#ASSIGN:127.0=[gnd=2.0E+01,gnd=13.0,si=2.0E+01,bt(non)= -13.0,bt(dir)=13.0,bt(dir)=19.0,bt(crs)=32.0,bt(non)= -9.0,bt(dir)=13.0,bt(dir)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3385,"!חָצוּף","a","01923659","y","dahan","1","rav-milim",NULL,"tg1",NULL,"cheeky, impudent, impertinent",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3386,"!חָצוּף","a","00204987","y","dahan","1","rav-milim",NULL,"tg1",NULL,"cheeky, impudent, impertinent",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3387,"חָקִי","n","02888127","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"khaki",NULL,"בחיל הים, בניגוד למדי החקי של מרבית החילות, משתמשים במדים אפורים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","ordan-24 May 2004, assign-6 Nov 2003",91949,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (3388,"חָקוּק","a","00311342","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"engraved",NULL,"תאריך לידתו ומותו היו חקוקים באבן השיש","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-22 May 2004",91950,"2004-05-22");
INSERT INTO hebrew_synonyms VALUES (3389,"חָרִיג","a","01541117","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"exceptional",NULL,"ילדים שניקודם נמוך במיוחד במבחני אינטליגנציה, מוגדרים כילדים חריגים","checked","#ASSIGN:50=[gnd=13.0,glc=27.0,dfl=1.0E+01] #MZ@\r\n#NO","ordan-23 May 2004",91951,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3390,"חָרִישׁ","n","00589929","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"plowing, ploughing",NULL,"בעבר נעשה חריש האדמה בעיקר באמצעות בעלי חיים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-23 May 2004, assign-6 Nov 2003",91952,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3391,"חָרַק","v","01486965","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"squeak, screech",NULL,"צריך לשמן את צירי הדלת, היא שוב חורקת","checked","#ASSIGN:95.0=[gnd=39.0,gnd=39.0,gnd=13.0,si=49.0,bt(non)= -34.0,bt(non)= -11.0] #MZ@\r\n#NO","ordan-21 Jun 2004, assign-6 Nov 2003",91953,"2004-06-21");
INSERT INTO hebrew_synonyms VALUES (3392,"!חָרָט","n","07653999","y","dahan","1","rav-milim",NULL,"tg1","(on lathe)","turner",NULL,NULL,"assigned","#ASSIGN:67.0=[gnd=13.0,glc=54.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3393,"חָרוּב","n","08794248","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"carob",NULL,NULL,"checked","#ASSIGN:27.0=[gnd=13.0,glc=14.0] #MZ@\r\n#NO","ordan-25 Jun 2004, assign-6 Nov 2003",91349,"2004-06-25");
INSERT INTO hebrew_synonyms VALUES (3394,"!חָרוּב","n","05651204","nn","dahan","1","rav-milim",NULL,"tg1","(tree and bean)","carob",NULL,NULL,"checked","#ASSIGN:27.0=[gnd=13.0,glc=14.0] #MZ@\r\n#NO this cannot stand for the powder","ordan-25 Jun 2004, assign-6 Nov 2003",0,"2004-06-25");
INSERT INTO hebrew_synonyms VALUES (3395,"חָרוּז","n","05309419","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"rhyme",NULL,NULL,"revised","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","eyal-22 Aug 2004, ordan-17 May 2004",91954,"2004-08-22");
INSERT INTO hebrew_synonyms VALUES (3396,"!חָרוּז","n","04811183","u","dahan","1","rav-milim",NULL,"tg1",NULL,"rhyme",NULL,NULL,"checked","#ASSIGN:84.0=[gnd=2.0E+01,bt(dir)=13.0,bt(dir)=19.0,bt(crs)=32.0] #MZ@\r\n#NO maybe, especially according to Even-Shushan 1.2; I suggest a neologism: שוריות or שורות-שיר","ordan-20 Jun 2004",0,"2004-06-20");
INSERT INTO hebrew_synonyms VALUES (3397,"חָרוּץ","a","00719289","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"hardworking, industrious",NULL,"הוא עובד חרוץ, תמיד מגיע בזמן ואף פעם לא מתבטל","checked","#ASSIGN:131.0=[gnd=2.0E+01,gnd=39.0,si=24.0,bt(dir)=24.0,bt(dir)=24.0] #MZ@\r\n#NO","ordan-24 Jun 2004, assign-6 Nov 2003",91955,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (3398,"!חָרוּץ","a","01673086","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"industrious, diligent, hardworking",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO try this similar synset a#00719289","ordan-24 Jun 2004",0,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (3399,"!חָרוּץ","a","00718804","u","dahan","1","rav-milim",NULL,"tg1",NULL,"industrious, diligent, hardworking",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO fits better to a#00719289","ordan-24 Jun 2004, assign-6 Nov 2003",0,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (3400,"!חָרוּץ","a","00841997","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"industrious, diligent, hardworking",NULL,NULL,"checked","#ASSIGN:25.0=[gnd=2.0E+01,bt(non)= -14.0,bt(dir)=19.0] #MZ@","ordan-24 Jun 2004, assign-6 Nov 2003",0,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (3401,"חָרוּשׁ","a","01761533","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"plowed, ploughed",NULL,"מבעד לחלון ראינו את הנתיבים הארוכים באדמת השדה החרוש","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-23 May 2004",91956,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3402,"חָרוּת","a","00311342","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"engraved",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-22 May 2004, assign-6 Nov 2003",91957,"2004-05-22");
INSERT INTO hebrew_synonyms VALUES (3403,"חָשׁוּד","n","07625454","n","melingo","1.3","rav-milim","1.3","tg1",NULL,"suspect",NULL,"שמות החשודים נאסרו לפרסום מתוך סוביודיצה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO\r\n#IE gender","eyal-18 Jul 2005, ordan-07 Jun 2004, assign-6 Nov 2003",0,"2005-07-18");
INSERT INTO hebrew_synonyms VALUES (6822,"נֶאֱשַׁם","n","07059160","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,"הנאשם, כבול באזיקים, הובל לתוך אולם בית המשפט","checked","#NO","ordan-07 Jun 2004",91959,"2004-06-07");
INSERT INTO hebrew_synonyms VALUES (3405,"חָשׂוּף","a","01814114","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"exposed",NULL,"ראשו היה חשוף מבעד לצריח הטנק","checked","#ASSIGN:25.0=[gnd=2.0E+01,bt(dir)=21.0,bt(non)= -16.0] #MZ@\r\n#NO","ordan-22 May 2004, assign-6 Nov 2003",91960,"2004-05-22");
INSERT INTO hebrew_synonyms VALUES (3406,"חָשׂוּף","a","00428328","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"exposed",NULL,"בשנות ה-80, נשים רבות הלכו בכתפיים חשופות","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-22 May 2004",91960,"2004-05-22");
INSERT INTO hebrew_synonyms VALUES (3407,"חָתַר","v","01326509","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"row",NULL,"חתרנו בכל כוחנו נגד הזרם, אך הסירה בקושי התקדמה","checked","#ASSIGN:+inf=[gnd=39.0,glc= +inf] #MZ@\r\n#NO","ordan-06 Jun 2004, assign-6 Nov 2003",91961,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (6821,"סַיָּס","n","07604764","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"stableman, groom",NULL,NULL,"checked","#NO","ordan-07 Jun 2004",91962,"2004-06-07");
INSERT INTO hebrew_synonyms VALUES (3409,"חָתָן","n","07302617","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"groom, bridegroom",NULL,"החתן הסתובב בין אורחי החתונה ולחץ את ידם","checked","#ASSIGN:77.0=[gnd=13.0,bt(dir)=13.0,bt(dir)=19.0,bt(crs)=32.0] #MZ@\r\n#NO","ordan-07 Jun 2004, assign-6 Nov 2003",91963,"2004-06-07");
INSERT INTO hebrew_synonyms VALUES (3410,"חָתָן","n","07302517","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"groom, bridegroom",NULL,"תכירו את החתן והכלה, רק לפני שבוע התחתנו","checked","#ASSIGN:77.0=[gnd=13.0,bt(dir)=13.0,bt(dir)=19.0,bt(crs)=32.0] #MZ@\r\n#NO agrees partly with RM1.1","ordan-07 Jun 2004",91963,"2004-06-07");
INSERT INTO hebrew_synonyms VALUES (3411,"חָתוּם","a","02008395","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"stamped",NULL,"המסמך הזה כבר חתום על ידי המנהל, אפשר לשלוח אותו","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-23 May 2004",91964,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (3412,"חָתוּם","n","07575902","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"signer, signatory",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-23 May 2004, assign-6 Nov 2003",91965,"2004-05-23");
INSERT INTO hebrew_synonyms VALUES (6724,"נוֹצַר","v","00252195","yy","none",NULL,"rav-milim","1.1",NULL,NULL,NULL,NULL,"כתמי העובש נוצרו בעקבות הרטיבות שיצר הגשם האחרון","checked","#IE","eyal-19 May 2004",91966,"2004-05-19");
INSERT INTO hebrew_synonyms VALUES (3415,"חֹם","n","04422689","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"warmth",NULL,"לאחר שלגם מהוויסקי הרגיש חום מתפשט בגופו","checked","#ASSIGN:35.0=[gnd=7.0,bt(dir)=6.0,bt(dir)=8.0,bt(crs)=14.0] #MZ@\r\n#NO","ordan-24 May 2004",91967,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (3416,"!חֹם","n","03651126","u","dahan","1","rav-milim",NULL,"tg1",NULL,"heat",NULL,NULL,"checked","#ASSIGN:35.0=[gnd=7.0,bt(dir)=6.0,bt(dir)=8.0,bt(crs)=14.0] #MZ@\r\n#NO maybe להט like in להט כעסו","ordan-24 May 2004, assign-6 Nov 2003",0,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (6763,"חַד-ְגּוֹנִיּוּת","n","03724711","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-24 May 2004",91968,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (3419,"!חֹמֶץ","n","10824042","y","dahan","1","rav-milim",NULL,"tg1",NULL,"vinegar",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3420,"חֹמֶץ","n","05861621","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"vinegar",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-27 May 2004, assign-6 Nov 2003",91969,"2004-05-27");
INSERT INTO hebrew_synonyms VALUES (6853,"GAP!","n","10373357","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#NO this synset is Christian-specific, have a look at all the 4 sub-definitions of ''grace'' in Collins (sense n. 8)","ordan-20 Jun 2004",90808,"2004-06-20");
INSERT INTO hebrew_synonyms VALUES (6817,"מַחְסוֹר","n","10367399","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"lack, deficiency, want",NULL,"בחברה שלנו יש מחסור במוחות יצירתיים, ולכן נתקע פיתוח המוצר","checked","#NO agrees with the first part of RM1.1, in Even Shushan (1.2) it enjoys a sense of itself","ordan-06 Jun 2004",91124,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (3424,"חֹקֶן","n","00446454","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"enema",NULL,NULL,"revised","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","eyal-15 Aug 2004, ordan-23 May 2004",91970,"2004-08-15");
INSERT INTO hebrew_synonyms VALUES (3425,"חֹרֶף","n","10946591","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"winter",NULL,"לקראת החורף הוצאנו את השמיכות החמות מהארון","checked","#ASSIGN:50=[gnd=2.0E+01,bt(dir)=24.0,dfl=6.0] #MZ@\r\n#NO","ordan-17 May 2004, assign-6 Nov 2003",91971,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (3426,"חֻלְיָה","n","04101439","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"vertebra",NULL,"לאחר שהאדם הזדקף על שתי רגליים נוצר עומס רב על החוליות, ולכן סובלים אנשים רבים מכאבי גב","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-24 Jun 2004, assign-6 Nov 2003",91972,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (3427,"חֻלְיָה","n","06100095","yy","none",NULL,"rav-milim","1.5","tg1",NULL,"squad",NULL,NULL,"checked","#ASSIGN:63.0=[gnd=2.0E+01,glc=27.0,glc=16.0] #MZ@\r\n#NO","ordan-24 Jun 2004",91972,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (3428,"חֻלְצָה","n","03320567","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"shirt",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-24 May 2004, assign-6 Nov 2003",91973,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (3429,"!חֻלְצָה","n","02301305","nn","dahan","2","rav-milim",NULL,"tg1","(for women)","blouse",NULL,NULL,"checked","#ASSIGN:+inf=[gnd=39.0,glc= +inf,glc= +inf,bt(dir)=49.0] #MZ@\r\n#NO Hebrew doesn\'t has a ''special shirt'' for women. ","ordan-24 May 2004, assign-6 Nov 2003",0,"2004-05-24");
INSERT INTO hebrew_synonyms VALUES (6815,"חִלּוֹנִיּוּת","n","04579197","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"secularism",NULL,NULL,"checked","#NO in principal חילוניות is more general usually, not necessarily a doctrine. Therefore this sense is actually missing in RM. ","ordan-06 Jun 2004",91974,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (6771,"כְּבִידָה","n","07804383","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"gravity, gravitation",NULL,"האגדה מספרת כי ניוטון חשב על כוח הכבידה לאחר שתפוח נפל מהעץ על ראשו","checked","#NO","ordan-26 May 2004",91975,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (3432,"!חֻמְרָה","n","05584266","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"gravity",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO this does not relate to the feeling but rather to the behavior or trait, as in \'solemnity\' n#03664203","ordan-24 Jun 2004, assign-6 Nov 2003",0,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (3433,"חֻמְרָה","n","03664048","yy","melingo","1.1","rav-milim","1.4","tg1",NULL,"gravity",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO does not come fully in agreement with RM","ordan-26 May 2004, assign-6 Nov 2003",91976,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (3434,"!חֻצְפָּה","n","05040252","y","dahan","1","rav-milim",NULL,"tg1",NULL,"cheek",NULL,NULL,"assigned","#ASSIGN:118.0=[gnd=1.0E+01,bt(dir)=17.0,bt(dir)=8.0,bt(dir)=11.0,bt(crs)=72.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3435,"חֻקִּיּוּת","n","03772982","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"legality",NULL,"במקומך לא הייתי מסתבך בעסק כזה, החוקיות שלו נראית לי מוטלת בספק","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-26 May 2004",91977,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (3436,"חוֹבָה","n","09655306","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"debit",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-24 Jun 2004, assign-6 Nov 2003",91237,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (3437,"!חוֹטֵא","n","07578399","y","dahan","1","rav-milim",NULL,"tg1",NULL,"sinner",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3438,"!חוֹטֵף","n","07353959","y","dahan","1","rav-milim",NULL,"tg1",NULL,"kidnapper",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3439,"!חוֹכֵר","n","07367609","n","dahan","1","rav-milim",NULL,"tg1","(of land)","lessee",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,glc=2.0,dfl=9.0] #MZ@\r\n#IE gender","eyal-12 Apr 2005, assign-6 Nov 2003",0,"2005-04-12");
INSERT INTO hebrew_synonyms VALUES (6816,"כוֹלֶרָה","n","10163886","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO","ordan-06 Jun 2004",91978,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (3441,"חוּט","n","03497295","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"thread",NULL,"לפני התפירה יש להשחיל את החוט במחט","checked","#ASSIGN:51.0=[gnd=1.0E+01,glc=11.0,glc=18.0,bt(dir)=12.0] #MZ@\r\n#NO","ordan-17 May 2004",91979,"2004-05-17");
INSERT INTO hebrew_synonyms VALUES (3442,"חוּט-חַשְׁמַל","n","03625791","yy","none",NULL,"none",NULL,"tg1",NULL,"wire",NULL,NULL,"checked","#ASSIGN:38.0=[gnd=1.0E+01,glc=18.0,bt(dir)=1.0E+01] #MZ@\r\n#NO WN doesn\'t specify this word, but make a mention of it in 1.2 (חוט) in brackets","ordan-26 May 2004, assign-6 Nov 2003",91980,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (3443,"חוּט","n","03625583","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"wire",NULL,NULL,"checked","#ASSIGN:4.0E+01=[gnd=1.0E+01,glc=18.0,bt(dir)=12.0] #MZ@\r\n#NO RM subsumes the two WN words (\'wire\', n#03625583; \'wire\', n#03625791) under this same definition of חוט","ordan-26 May 2004",91979,"2004-05-26");
INSERT INTO hebrew_synonyms VALUES (3444,"חוּשָׁנִיּוּת","n","05567730","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"sensuality",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-24 Jun 2004, assign-6 Nov 2003",91981,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (3445,"טְבִילָה","n","00670476","yy","melingo","1.4","rav-milim","1.4","tg1","(religion)","baptism",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-03 May 2004, assign-6 Nov 2003",91982,"2004-05-03");
INSERT INTO hebrew_synonyms VALUES (3446,"!טְבִיעָה","n","04439113","nn","dahan","3","rav-milim",NULL,"tg1","(act)","imprinting",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE the correct word is הטבעה","eyal-10 Jun 2004, assign-6 Nov 2003",0,"2004-06-10");
INSERT INTO hebrew_synonyms VALUES (3447,"טְוִיָּה","n","00583827","yy","melingo","1.1","rav-milim","1.1","tg1","(of thread)","spinning",NULL,"טווייה היא אומנות עממית פופולרית","checked","#ASSIGN:50=[gnd=39.0,glc=8.0,dfl=3.0] #MZ@\r\n#IE","eyal-06 Jun 2004, assign-6 Nov 2003",91983,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (3448,"!טְחִינָה","n","03000008","y","dahan","2","rav-milim",NULL,"tg1","(act)","milling",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3450,"טְרֶמְפּ","n","00200531","yy","melingo","1.1","rav-milim","1.1","tg1","(in vehicle)","lift",NULL,"איזה מזל! היה לי טרמפ עד הבית","checked","#ASSIGN:50=[gnd=6.0,glc=16.0,bt(dir)=7.0,dfl=21.0] #MZ@ #IE","eyal-07 Jun 2004",91984,"2004-06-07");
INSERT INTO hebrew_synonyms VALUES (3451,"טְרוֹמִי","a","00636353","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"prefabricated",NULL,"מבנה טרומי","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-08 Jun 2004",91985,"2004-06-08");
INSERT INTO hebrew_synonyms VALUES (3452,"טִאטוּא","n","00161640","yy","melingo","1.1","rav-milim","1.1","tg1","(act)","sweeping",NULL,"היום לא נשטוף את הרצפה, נסתפק בטאטוא בלבד","checked","#ASSIGN:50=[gnd=39.0,glc=4.0,glc=2.0,dfl=5.0] #MZ@ #IE","eyal-06 Jun 2004, assign-6 Nov 2003",91986,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (3453,"טִבְעוֹנִי","n","07661990","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"vegan",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-06 Jun 2004, assign-6 Nov 2003",91987,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (3454,"טִגּוּן","n","00157874","yy","melingo","1.1","rav-milim","1.1","tg1","(act)","frying",NULL,"בעת טיגון מומלץ להשתמש במחבת טפלון בה ניתן לטגן בכמות שמן מופחתת","checked","#ASSIGN:50=[gnd=39.0,glc=2.0,dfl=9.0] #MZ@\r\n#IE","eyal-07 Jun 2004, assign-6 Nov 2003",91988,"2004-06-07");
INSERT INTO hebrew_synonyms VALUES (3455,"טִהוּר","n","00162101","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"purification",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=2.0E+01,glc=4.0,glc=2.0] #MZ@ #IE","eyal-09 Jun 2004, assign-6 Nov 2003",91989,"2004-06-09");
INSERT INTO hebrew_synonyms VALUES (3456,"טִיּוּחַ","n","00461068","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"plastering",NULL,"לאחר שלב הטיוח מגיע שלב הצביעה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-07 Jun 2004, assign-6 Nov 2003",91990,"2004-06-07");
INSERT INTO hebrew_synonyms VALUES (3457,"!טִיּוּל","n","00202291","y","dahan","2","rav-milim",NULL,"tg1","(an organized trip)","excursion",NULL,NULL,"assigned","#ASSIGN:52.0=[gnd=2.0E+01,bt(dir)=17.0,bt(dir)=5.0,bt(non)= -12.0,bt(crs)=22.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3458,"!טִיּוּל","n","00201294","y","dahan","2","rav-milim",NULL,"tg1","(an organized trip)","excursion",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3459,"טִיחַ","n","10759087","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"plaster",NULL,NULL,"checked","#ASSIGN:+inf=[gnd=1.0E+01,glc= +inf,bt(dir)=12.0] #MZ@ #IE","eyal-07 Jun 2004, assign-6 Nov 2003",91991,"2004-06-07");
INSERT INTO hebrew_synonyms VALUES (3460,"טִיט","n","10722217","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"loam",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE 1. ''loam'' appears as טיט only in the English-Hebrew morfix dictionary. 2. I think the combination אדמת טיט can also be considered.","eyal-07 Jun 2004",91992,"2004-06-07");
INSERT INTO hebrew_synonyms VALUES (3461,"!טִיל","n","03176413","y","dahan","1","rav-milim",NULL,"tg1",NULL,"missile",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3462,"!טִיל","n","03004991","y","dahan","1","rav-milim",NULL,"tg1",NULL,"missile",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3463,"טִין","n","10792718","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"silt",NULL,NULL,"checked","#ASSIGN:66.0=[gnd=39.0,glc=27.0] #MZ@\r\n#IE","eyal-06 Jun 2004, assign-6 Nov 2003",91993,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (3464,"טִינָה","n","05612377","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"grudge",NULL,"אל תשמור לו טינה, הוא לא באמת התכוון למה שאמר","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-08 Jun 2004, assign-6 Nov 2003",91994,"2004-06-08");
INSERT INTO hebrew_synonyms VALUES (3465,"טִפְטֵף","v","01417339","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"drip",NULL,"הדם החל לטפטף מאפו לאחר המכה החזקה שקיבל","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-08 Jun 2004, assign-6 Nov 2003",91995,"2004-06-08");
INSERT INTO hebrew_synonyms VALUES (3466,"טִפְטֵף","v","01110335","yy","melingo","1.1","rav-milim","1.3","tg1",NULL,"drip",NULL,"יש לטפטף שמן בזהירות לתוך התערובת","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE","eyal-08 Jun 2004, assign-6 Nov 2003",91995,"2004-06-08");
INSERT INTO hebrew_synonyms VALUES (3467,"טִפְטֵף","v","01884408","yy","melingo","1.3","rav-milim","1.4","tg1","colloquial","drizzle",NULL,"איך מזג האוויר? לא נורא, רק קצת מטפטף","checked","#ASSIGN:66.0=[gnd=2.0E+01,glc=14.0,glc=8.0,bt(dir)=24.0] #MZ@ #IE","eyal-08 Jun 2004, assign-6 Nov 2003",91995,"2004-06-08");
INSERT INTO hebrew_synonyms VALUES (3468,"!טִפְטֵף","v","00942761","y","dahan","2","rav-milim",NULL,"tg1","(rain)",NULL,NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3469,"!טִפְטוּף","n","05716225","nn","dahan","1","rav-milim",NULL,"tg1","(act)","dripping",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ \r\n#IE a much more specific word is required","eyal-07 Jun 2004, assign-6 Nov 2003",0,"2004-06-07");
INSERT INTO hebrew_synonyms VALUES (3470,"טִפְטוּף","n","07831030","yy","melingo","1.3","rav-milim","1.3","tg1","colloquial","drizzle",NULL,"במשך כל היום ירד טיפטוף מרגיז שהפריע לנו להנות מהטיול","checked","#ASSIGN:53.0=[gnd=39.0,glc=14.0] #MZ@ #IE","eyal-07 Jun 2004",91996,"2004-06-07");
INSERT INTO hebrew_synonyms VALUES (3471,"טִפְּשִׁי","a","02446777","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"foolish",NULL,"ההערה שלך היתה טיפשית וחסרת התחשבות","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-04 Jun 2004",91997,"2004-06-04");
INSERT INTO hebrew_synonyms VALUES (3472,"!טִפְּשִׁי","a","00405649","n","dahan","1","rav-milim",NULL,"tg1",NULL,"silly, stupid, foolish",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","eyal-07 Aug 2005, assign-6 Nov 2003",0,"2005-08-07");
INSERT INTO hebrew_synonyms VALUES (3473,"!טִפְּשִׁי","a","01283121","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"silly, stupid, foolish",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-04 Jun 2004, assign-6 Nov 2003",0,"2004-06-04");
INSERT INTO hebrew_synonyms VALUES (3474,"!טִפְּשִׁי","a","00408403","y","dahan","1","rav-milim",NULL,"tg1",NULL,"silly, stupid, foolish",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3475,"!טִפֵּשׁ","a","00405649","n","dahan","1","rav-milim",NULL,"tg1",NULL,"stupid",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","eyal-07 Aug 2005, assign-6 Nov 2003",0,"2005-08-07");
INSERT INTO hebrew_synonyms VALUES (3476,"טִפֵּשׁ","a","01283121","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"stupid",NULL,"יש לו כוונות טובות, אבל הוא טיפש","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-04 Jun 2004, assign-6 Nov 2003",91998,"2004-06-04");
INSERT INTO hebrew_synonyms VALUES (3477,"!טִפֵּשׁ","a","00408403","y","dahan","1","rav-milim",NULL,"tg1",NULL,"stupid",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3478,"!טִפֵּשׁ","n","07347950","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"fool",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE ","eyal-02 Jun 2004, assign-6 Nov 2003",0,"2004-06-02");
INSERT INTO hebrew_synonyms VALUES (3479,"טִפֵּשׁ","n","07271334","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"fool",NULL,"אבן אחת שזרק טיפש לתוך הבאר 100 חכמים לא       \r\n\r\nיצליחו להוציא","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@ #IE","eyal-02 Jun 2004",91999,"2004-06-02");
INSERT INTO hebrew_synonyms VALUES (3480,"טִפּוּל","n","00735486","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"treatment",NULL,"הטיפול במערכת ההשקיה דורש מיומנות מיוחדת","checked","#ASSIGN:25.0=[gnd=13.0,bt(dir)=12.0] #MZ@\r\n#IE","eyal-09 Jun 2004, assign-6 Nov 2003",92000,"2004-06-09");
INSERT INTO hebrew_synonyms VALUES (3481,"!טִפּוּסִי","a","01538517","y","dahan","1","rav-milim",NULL,"tg1",NULL,"typical",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3482,"טִפּוּסִי","a","00346749","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"typical",NULL,"כמה טיפוסי לך ללגלג על החלשים ממך!","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE see also a#02349429 and a#01538517","eyal-07 Aug 2005, assign-6 Nov 2003",95224,"2005-08-07");
INSERT INTO hebrew_synonyms VALUES (3483,"!טִפּוּסִי","a","02349429","y","dahan","1","rav-milim",NULL,"tg1",NULL,"typical",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3484,"טִקְסִי","a","00991360","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"ceremonial",NULL,"לכבוד המעמד, הקצינים לבשו את בגדיהם הטקסיים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-09 Jun 2004, assign-6 Nov 2003",92001,"2004-06-09");
INSERT INTO hebrew_synonyms VALUES (3485,"טִקְסִיּוּת","n","03845335","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"ceremoniousness",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE ","eyal-10 Jun 2004, assign-6 Nov 2003",92002,"2004-06-10");
INSERT INTO hebrew_synonyms VALUES (3486,"!טִרְחָה","n","05489772","y","dahan","1","rav-milim",NULL,"tg1","(taken)","bother, trouble",NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0E+01,gnd=6.0,si=12.0,bt(dir)=6.0,bt(dir)=6.0,bt(non)= -4.0,dfl=4.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3487,"!טִרְטוּר","n","05494969","n","dahan","1","rav-milim",NULL,"tg1","(of machinery)","clatter",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-05 Apr 2005, assign-6 Nov 2003",0,"2005-04-05");
INSERT INTO hebrew_synonyms VALUES (3488,"טֵאוּט","n","00161640","yy","melingo","1.1","rav-milim","1.1","tg1","(act)","sweeping",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,glc=4.0,glc=2.0,dfl=5.0] #MZ@ #IE","eyal-06 Jun 2004, assign-6 Nov 2003",92003,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (3489,"טֶלֶבִיזְיָה","n","03482557","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"television",NULL,NULL,"checked","#ASSIGN:107.0=[gnd=13.0,gnd=39.0,si=33.0,bt(dir)=11.0,bt(dir)=11.0] #MZ@ #IE","eyal-08 Jun 2004, assign-6 Nov 2003",92004,"2004-06-08");
INSERT INTO hebrew_synonyms VALUES (3490,"טֶלֶבִיזְיָה","n","03481385","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"television",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#IE","eyal-08 Jun 2004, assign-6 Nov 2003",92004,"2004-06-08");
INSERT INTO hebrew_synonyms VALUES (3491,"טֶרֶף","n","01661246","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"prey",NULL,"לשחר לטרף","checked","#ASSIGN:25.0=[gnd=2.0E+01,bt(dir)=19.0,bt(non)= -14.0] #MZ@ #IE","eyal-09 Jun 2004, assign-6 Nov 2003",92005,"2004-06-09");
INSERT INTO hebrew_synonyms VALUES (3492,"!טַבָּח","n","07182710","n","dahan","1","rav-milim",NULL,"tg1",NULL,"cook",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE gender","eyal-19 Sep 2005, assign-6 Nov 2003",0,"2005-09-19");
INSERT INTO hebrew_synonyms VALUES (3493,"!טַבּוּר","n","06530219","y","dahan","2","rav-milim",NULL,"tg1",NULL,"centre",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3494,"!טַוָּס","n","01782015","y","dahan","1","rav-milim",NULL,"tg1",NULL,"peacock",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3495,"!טַוָּס","n","01323698","y","dahan","1","rav-milim",NULL,"tg1",NULL,"peacock",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3496,"!טַנְבּוּר","n","03467835","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"tambourine",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE according to RM definition, this is not the correct drum","eyal-06 Jun 2004, assign-6 Nov 2003",0,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (3497,"טַפִּיל","n","07367906","yy","melingo","1.2","rav-milim","1.3","tg1","slang","leech",NULL,"הטפיל הזה נדבק אלי מתחילת הערב","checked","#ASSIGN:25.0=[gnd=2.0E+01,bt(dir)=19.0,bt(non)= -14.0] #MZ@ #IE consider also RM 1.2","eyal-06 Jun 2004",92006,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (3498,"טַפִּיל","n","00912376","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"parasite",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-06 Jun 2004, assign-6 Nov 2003",92006,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (3499,"!טָבוּל","a","00967729","y","dahan","1","rav-milim",NULL,"tg1",NULL,"dipped",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3500,"טָבוּעַ","a","00080547","yy","melingo","1.1","rav-milim","2.2","tg1","(person)","drowned",NULL,"בשוך הסערה נפלטו גופות הטבועים אל החוף","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE the equivalent term in RM is a noun (see RM טבוע 1)","eyal-04 Jun 2004",92007,"2004-06-04");
INSERT INTO hebrew_synonyms VALUES (3501,"טָחוּב","a","02426601","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"damp, moist",NULL,"חולצתו היתה טחובה מזיעה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ \r\n#IE applies only to the second part of RM definition","eyal-06 Jun 2004",92008,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (3502,"טָחוּן","a","00284623","y","melingo","1.1","rav-milim","1.1","tg1",NULL,"ground",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE טחון does not fully comply with WN definition. I left it here since I could not find a more suitable word in WN.","eyal-06 Jun 2004, assign-6 Nov 2003",92009,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (3503,"טָמֵא","a","00397605","yy","melingo","1.1","rav-milim","1.1a","tg1","(ritually)","impure",NULL,NULL,"checked","#ASSIGN:57.0=[gnd=2.0E+01,glc=54.0,bt(non)= -17.0] #MZ@ #IE the example in WN implies that it can also fit RM 1.2 (impure animal)","eyal-04 Jun 2004, assign-6 Nov 2003",92010,"2004-06-04");
INSERT INTO hebrew_synonyms VALUES (3504,"!טָעִים","a","02282742","y","dahan","1","rav-milim",NULL,"tg1",NULL,"tasty",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3505,"טָעִים","a","00136205","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"tasty",NULL,"הפשטידה היתה טעימה להפליא","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-04 Jun 2004, assign-6 Nov 2003",92011,"2004-06-04");
INSERT INTO hebrew_synonyms VALUES (3506,"!טָעוּת","n","05071571","y","dahan","1","rav-milim",NULL,"tg1",NULL,"mistake",NULL,NULL,"assigned","#ASSIGN:51.0=[gnd=13.0,bt(dir)=6.0,bt(dir)=13.0,bt(crs)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3508,"טָרִי","a","01014707","yy","melingo","1.1","rav-milim",">1.1","tg1","(opp stale)","fresh",NULL,"במסעדה הזו מגישים לחמניות טריות שרק יצאו מהתנור","checked","#ASSIGN:50=[gnd=3.0,glc=14.0,bt(dir)=4.0,dfl=29.0] #MZ@ #IE RM definition is broader, and matches some more WN synsets.","eyal-07 Jun 2004, assign-6 Nov 2003",92012,"2004-06-07");
INSERT INTO hebrew_synonyms VALUES (3509,"טָרֶשֶׁת","n","10152408","yy","melingo","1.1","rav-milim","1.1","tg1","(med)","sclerosis",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-06 Jun 2004, assign-6 Nov 2003",92013,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (3510,"!טֻמְאָה","n","10400755","y","dahan","1","rav-milim",NULL,"tg1","(ritually)","impurity, uncleanness",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3511,"טוֹטֶפֶת","n","05129356","yy","none",NULL,"rav-milim","1.1","tg1","Judaism","phylactery",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ \r\n#IE the more common word is ''phylacteries'', which is תפילין, which is 2 טוטפות. ''phylacteries'' does not appear in WN.","eyal-07 Jun 2004",92014,"2004-06-07");
INSERT INTO hebrew_synonyms VALUES (3512,"!טוֹרְדָנִי","a","00714136","u","dahan","1","rav-milim",NULL,"tg1",NULL,"pestering, troublesome",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE I think מטריד fits more","eyal-08 Jun 2004, assign-6 Nov 2003",0,"2004-06-08");
INSERT INTO hebrew_synonyms VALUES (3513,"טוֹרְדָנִי","a","00092842","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"pestering",NULL,"הזמזום הטורדני הזה מפריע לי להתרכז","checked","#ASSIGN:39.0=[gnd=39.0] #MZ@ #IE","eyal-09 Jun 2004, assign-6 Nov 2003",92015,"2004-06-09");
INSERT INTO hebrew_synonyms VALUES (3514,"טוּרַאי","n","07501217","yy","melingo","1.1","rav-milim","1.1","tg1","(soldier)","private",NULL,NULL,"checked","#ASSIGN:77.0=[gnd=39.0,bt(dir)=38.0] #MZ@\r\n#IE","eyal-07 Jun 2004, assign-6 Nov 2003",92016,"2004-06-07");
INSERT INTO hebrew_synonyms VALUES (3515,"!יְבָבָה","n","05387614","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"whimper",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO this is a hypernym \'comlaint\', try קִטּוּר (but that\'s slang)","ordan-13 Jul 2004, assign-6 Nov 2003",0,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3516,"יְבוּל","n","09380644","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"crop",NULL,"יבול הענבים השנה היה מצוין","checked","#ASSIGN:59.0=[gnd=13.0,bt(dir)=13.0,bt(dir)=1.0E+01,bt(crs)=23.0] #MZ@\r\n#IE","eyal-01 Jul 2004, assign-6 Nov 2003",92017,"2004-07-01");
INSERT INTO hebrew_synonyms VALUES (3517,"!יְבוּל","n","02522330","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"yield, crop",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-01 Jul 2004",0,"2004-07-01");
INSERT INTO hebrew_synonyms VALUES (3518,"זֶפֶק","n","01486270","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"crop",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-01 Jul 2004, assign-6 Nov 2003",92018,"2004-07-01");
INSERT INTO hebrew_synonyms VALUES (3519,"!יְגִיעָה","n","00408411","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"toil, hard_work",NULL,NULL,"revised","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE not necessarily work done for wages\r\n#NO","ordan-22 Dec 2004, eyal-30 Jun 2004, assign-6 Nov 2003",0,"2004-12-22");
INSERT INTO hebrew_synonyms VALUES (3520,"יְדִידוּת","n","10038317","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"friendship",NULL,NULL,"checked","#ASSIGN:78.0=[gnd=39.0,bt(dir)=39.0] #MZ@\r\n#NO","ordan-06 Jun 2004, assign-6 Nov 2003",92019,"2004-06-06");
INSERT INTO hebrew_synonyms VALUES (6926,"קוֹגְנִיצְיָה","n","00013243","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"cognition",NULL,NULL,"checked","#NO","ordan-08 Jul 2004",92020,"2004-07-08");
INSERT INTO hebrew_synonyms VALUES (6927,"הַכָּרָה","n","00013243","u","none",NULL,"none",NULL,NULL,NULL,NULL,NULL,NULL,"checked","#NO does not appear in the dictionaries, although I think it\'s the right Heb word. ","ordan-08 Jul 2004",92021,"2004-07-08");
INSERT INTO hebrew_synonyms VALUES (3522,"!יְדָנִי","a","02434158","nn","dahan","1","rav-milim",NULL,"tg1","(opp mechanical)","manual",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-13 Jul 2004, assign-6 Nov 2003",0,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3523,"!יְדָנִי","a","02584677","nn","dahan","1","rav-milim",NULL,"tg1","(opp mechanical)","manual",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-13 Jul 2004, assign-6 Nov 2003",0,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3524,"יְדָנִי","a","00183402","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"manual",NULL,"התוכנה שהתקנתי לא הצליחה לטפל בווירוס שחיבל במחשב, ונאלצתי להסיר אותו בצורה ידנית","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-24 Jun 2004",92022,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (3525,"יְהִירוּת","n","03828648","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-13 Jul 2004, assign-6 Nov 2003",92023,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3528,"יְהוּדִיָּה","n","06999516","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"Jewess",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-14 Jul 2004, assign-6 Nov 2003",92024,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3529,"יְוָנִי","a","02773962","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"Greek, Grecian, Hellenic",NULL,"המיתולוגיה היוונית","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-30 Jun 2004, assign-6 Nov 2003",92025,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (3530,"יְוָנִי","n","07020791","nn","melingo","1.1","none","1.1","tg1",NULL,"Greek",NULL,NULL,"revised","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO\r\n#IE gender","eyal-27 Feb 2005, ordan-30 Jun 2004, assign-6 Nov 2003",0,"2005-02-27");
INSERT INTO hebrew_synonyms VALUES (3531,"!יְוָנִי","n","05231341","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"Greek",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#NO Doesn\'t refer to the language","ordan-10 Jul 2004, assign-6 Nov 2003",0,"2004-07-10");
INSERT INTO hebrew_synonyms VALUES (3532,"יְחָסִים","n","10036283","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"relationship",NULL,"לאחר חשיפת המרגל הצטננו היחסים בין המדינות","checked","#ASSIGN:31.0=[gnd=1.0E+01,glc=9.0,bt(dir)=12.0] #MZ@\r\n#NO look at the plural form, after יחס 1.3","ordan-18 Jul 2004",92027,"2004-07-18");
INSERT INTO hebrew_synonyms VALUES (3533,"יְחָסִים","n","10036039","yy","none",NULL,"rav-milim","1.2","tg1",NULL,"relationship",NULL,"הוא כבר לא משתף אותה בהכול, היחסים ביניהם לא מה שהיו פעם","checked","#ASSIGN:31.0=[gnd=1.0E+01,glc=9.0,bt(dir)=12.0] #MZ@\r\n#NO look at the plural form, after יחס 1.3","ordan-18 Jul 2004",92027,"2004-07-18");
INSERT INTO hebrew_synonyms VALUES (3534,"!יְחָסִים","n","09924828","y","dahan","2","rav-milim",NULL,"tg1",NULL,"relations",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6961,"כֹּשֶׁר","n","04349777","yy","melingo","1.1","rav-milim","1.2",NULL,NULL,NULL,NULL,"יש לו כושר ריכוז אדיר, הוא מסוגל לקרוא במשך שעות בלי לזוז ממקומו","checked","#NO","ordan-13 Jul 2004",92028,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3536,"יְלָלָה","n","05498595","yy","melingo","1.2","none",NULL,"tg1",NULL,"howl",NULL,"מרחוק נשמעו יללות התנים בוואדי","checked","#ASSIGN:43.0=[gnd=13.0,glc=14.0,bt(dir)=16.0] #MZ@\r\n#NO I rely especially on the very derivative of יללה, i.e., ילל, as it appears in RM 1.1 ","ordan-15 Jul 2004",92029,"2004-07-15");
INSERT INTO hebrew_synonyms VALUES (3537,"יְלָלָה","n","05498432","yy","melingo","1.2","sapir","1.1","tg1",NULL,"howl",NULL,"יללת הרוח נשמה בינות לבתים","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-15 Jul 2004, assign-6 Nov 2003",92029,"2004-07-15");
INSERT INTO hebrew_synonyms VALUES (3538,"יְלָלָה","n","05332522","u","melingo","1.1","sapir","1.2","tg1",NULL,"howl, howling",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO conflicts with other synsets of יללה","ordan-15 Jul 2004",92029,"2004-07-15");
INSERT INTO hebrew_synonyms VALUES (3539,"!יְלָלָה","n","05387878","nn","dahan","2","rav-milim",NULL,"tg1","(person , wind)","wail",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-15 Jul 2004, assign-6 Nov 2003",0,"2004-07-15");
INSERT INTO hebrew_synonyms VALUES (3540,"יְסוֹדִיּוּת","n","03682129","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"thoroughness",NULL,"היסודיות היא מתכונותיו הבולטות, אף פעם אינו מעלה טענה קודם שביסס אותה היטב","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-08 Jul 2004, assign-6 Nov 2003",92030,"2004-07-08");
INSERT INTO hebrew_synonyms VALUES (3542,"יְצוּא","n","02653164","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"export",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-27 Jun 2004",92031,"2004-06-27");
INSERT INTO hebrew_synonyms VALUES (3543,"יְצוּאָן","n","07253113","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"exporter",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-14 Jul 2004, assign-6 Nov 2003",92032,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3544,"!יְצוּר","n","07192170","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"creature",NULL,NULL,"checked","#ASSIGN:50=[gnd=13.0,bt(dir)=16.0,dfl=21.0] #MZ@\r\n#NO that\'s \'creature\' in the sense of any living organism","ordan-15 Jul 2004",0,"2004-07-15");
INSERT INTO hebrew_synonyms VALUES (3545,"!יְרִידָה","n","03985255","u","dahan","2","rav-milim",NULL,"tg1",NULL,"decline, drop",NULL,NULL,"checked","#ASSIGN:25.0=[gnd=5.0,bt(dir)=6.0,bt(dir)=4.0,bt(crs)=1.0E+01] #MZ@\r\n#IE I think the word נפילה fits better","eyal-30 Jun 2004, assign-6 Nov 2003",0,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (3546,"יְרִידָה","n","06725397","yy","melingo","1.1","rav-milim","1.3","tg1",NULL,"descent",NULL,"יש להאיט את מהירות המכונית בירידה","checked","#ASSIGN:38.0=[gnd=1.0E+01,bt(dir)=4.0,bt(dir)=1.0E+01,bt(crs)=14.0] #MZ@ #IE","eyal-30 Jun 2004, assign-6 Nov 2003",91141,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (3547,"!יְרִיעָה","n","02380134","nn","dahan","1","rav-milim",NULL,"tg1","(of tent etc)","canvas",NULL,NULL,"checked","#ASSIGN:50=[gnd=7.0,glc=27.0,dfl=16.0] #MZ@\r\n#NO could be replaced by a free collocation (which seems to be the case in Eng)","ordan-30 Jun 2004, assign-6 Nov 2003",0,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (3548,"יְרֵחִי","a","02583497","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"lunar",NULL,"לוח השני הירחי קצר מלוח השנה הנוהג לפי השמש","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-08 Jul 2004",92033,"2004-07-08");
INSERT INTO hebrew_synonyms VALUES (3549,"יְשִׁימוֹן","n","06273995","u","melingo","1.1","rav-milim","1.1","tg1",NULL,"desert",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO maybe, and myabe better matched with \'wilderness\'","ordan-14 Jul 2004",92034,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3550,"!יִבֵּב","v","00046267","y","dahan","1","rav-milim",NULL,"tg1",NULL,NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3551,"יִבּוּא","n","00721243","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"importing, importation",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-27 Jun 2004, assign-6 Nov 2003",92035,"2004-06-27");
INSERT INTO hebrew_synonyms VALUES (3552,"יִבּוּשׁ","n","09739112","yy","melingo","1.2","rav-milim","1.1","tg1",NULL,"drying_up",NULL,"יבוש ים המלח גורם נזק בלתי הפיך לסביבה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-14 Jul 2004",92036,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3553,"יִחֵס","v","00492345","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"ascribe, attribute",NULL,"העובדת הסוציאלית ייחסה את התנהגות הנאשם לילדות קשה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-15 Jul 2004, assign-6 Nov 2003",92037,"2004-07-15");
INSERT INTO hebrew_synonyms VALUES (3554,"יִחוּד","n","03740993","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"uniqueness",NULL,"הוא עובד חרוץ, אך אין לו כל ייחוד - בדיוק כמו כולם","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-11 Jul 2004, assign-6 Nov 2003",92038,"2004-07-11");
INSERT INTO hebrew_synonyms VALUES (3555,"יִידִישׁ","n","05212011","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"Yiddish",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-10 Jul 2004, assign-6 Nov 2003",92039,"2004-07-10");
INSERT INTO hebrew_synonyms VALUES (3556,"יִלֵּל","v","00709311","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"howl, ululate, wail",NULL,"מתחת למכונית יילל גור חתולים וסירב לצאת","checked","#ASSIGN:32.0=[gnd=2.0E+01,bt(dir)=12.0] #MZ@\r\n#NO","ordan-08 Jul 2004",92040,"2004-07-08");
INSERT INTO hebrew_synonyms VALUES (3557,"!יִלֵּל","v","00718430","y","dahan","3","rav-milim",NULL,"tg1","(cat)",NULL,NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3558,"יִלּוֹד","n","07430101","yy","dahan","1.1","sapir","1.1","tg1",NULL,"newborn",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-15 Jul 2004, assign-6 Nov 2003",92041,"2004-07-15");
INSERT INTO hebrew_synonyms VALUES (3559,"!יִעוּד","n","00382624","y","dahan","1","rav-milim",NULL,"tg1",NULL,"calling",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3560,"יִעוּר","n","00256511","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"afforestation",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-27 Jun 2004, assign-6 Nov 2003",92042,"2004-06-27");
INSERT INTO hebrew_synonyms VALUES (3561,"יִפּוּי","n","00167925","yy","melingo","1.1","rav-milim","1.1","tg1","(act)","beautification",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,glc=4.0,glc=2.0,dfl=5.0] #MZ@ #IE","eyal-30 Jun 2004, assign-6 Nov 2003",92043,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (3562,"יִצֵּא","v","01602063","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"export",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-27 Jun 2004",92044,"2004-06-27");
INSERT INTO hebrew_synonyms VALUES (3563,"יִצּוּא","n","02653164","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"export",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-27 Jun 2004, assign-6 Nov 2003",92045,"2004-06-27");
INSERT INTO hebrew_synonyms VALUES (3564,"יִצּוּב","n","00750993","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,NULL,NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-13 Jul 2004, assign-6 Nov 2003",92046,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3565,"יִצּוּר","n","00586701","yy","melingo","1.1","rav-milim","1.1","tg1","(of goods)","production",NULL,"הוא הציג שיטות ייצור יעילות יותר","checked","#ASSIGN:29.0=[gnd=8.0,glc=11.0,bt(dir)=1.0E+01] #MZ@ #IE","eyal-30 Jun 2004, assign-6 Nov 2003",91142,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (3566,"יִתְרוֹן","n","04016440","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"advantage",NULL,"ניסיונו הרב הקנה לו יתרון ביחס לעובדים האחרים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-13 Jul 2004",91145,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3567,"!יֵאוּשׁ","n","10392337","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"despair",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO in Hebrew (as well as in Eng in my opinion) it\'s mainly a feeling not a state. When can try to substitute it with מצב-של-יאוש or מיואשות","ordan-13 Jul 2004, assign-6 Nov 2003",0,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3568,"יֵאוּשׁ","n","05606636","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"despair",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-13 Jul 2004, assign-6 Nov 2003",92047,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3569,"!יֵרוּט","n","00091213","nn","dahan","1","rav-milim",NULL,"tg1","(airplane)","interception",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO not in Sport","ordan-08 Jul 2004, assign-6 Nov 2003",0,"2004-07-08");
INSERT INTO hebrew_synonyms VALUES (3570,"יֵשׁוּ","n","07731120","yy","none",NULL,"none",NULL,"tg1",NULL,"Jesus",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-10 Jul 2004, assign-6 Nov 2003",92048,"2004-07-10");
INSERT INTO hebrew_synonyms VALUES (3572,"יֶרִי","n","00078903","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"gunfire",NULL,"הירי סיכן עוברי אורח תמימים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-30 Jun 2004, assign-6 Nov 2003",92049,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (3573,"יֶרֶק","n","09440702","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"greenery",NULL,"אחרי הגשמים האזור כולו מתכסה ירק","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-14 Jul 2004, assign-6 Nov 2003",92050,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3574,"יַבֶּשֶׁת","n","06835944","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"continent",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-14 Jul 2004, assign-6 Nov 2003",92051,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3575,"!יַבֶּשֶׁת","n","06401522","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"continent",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@","ordan-14 Jul 2004, assign-6 Nov 2003",0,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3576,"!יַהֲדוּת","n","06032096","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"Judaism",NULL,"יהדות צרפת; יהדות גרמניה","checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#NO","ordan-10 Jul 2004",0,"2004-07-10");
INSERT INTO hebrew_synonyms VALUES (3577,"יַהֲדוּת","n","04722359","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"Judaism",NULL,"לפי היהדות, התורה ניתנה לעם ישראל במעמד הר סיני","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-10 Jul 2004, assign-6 Nov 2003",92052,"2004-07-10");
INSERT INTO hebrew_synonyms VALUES (3578,"יַזָּם","n","07245531","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"entrepreneur",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-15 Jul 2004, assign-6 Nov 2003",92053,"2004-07-15");
INSERT INTO hebrew_synonyms VALUES (3579,"!יַחֲסִי","a","00450284","u","dahan","1","rav-milim",NULL,"tg1","(opp absolute)","relative",NULL,NULL,"assigned","#ASSIGN:104.0=[gnd=2.0E+01,bt(dir)=21.0,bt(dir)=21.0,bt(crs)=42.0] #MZ@\r\n#IE I\'m not completely sure about this one(see also a#00007066)","eyal-11 Aug 2005, assign-6 Nov 2003",0,"2005-08-11");
INSERT INTO hebrew_synonyms VALUES (3580,"יַחֲסִי","a","00007066","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"relative",NULL,NULL,"checked","#ASSIGN:52.0=[gnd=2.0E+01,glc=8.0,bt(dir)=24.0] #MZ@\r\n#NO","ordan-24 Jun 2004, assign-6 Nov 2003",92054,"2004-06-24");
INSERT INTO hebrew_synonyms VALUES (3581,"!יַחֲסִיּוּת","n","04648621","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"relativity",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","ordan-14 Jul 2004, assign-6 Nov 2003",0,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3582,"יַחֲסִית","r","00156699","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"relatively",NULL,"יחסית לאתמול קריר היום","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-14 Jul 2004, assign-6 Nov 2003",92055,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3583,"יַלְדוּת","n","10870647","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"childhood",NULL,"שנות ילדותי עברו עלי בכפר","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-30 Nov 2004, assign-6 Nov 2003",0,"2004-11-30");
INSERT INTO hebrew_synonyms VALUES (3584,"!יַלְדוּת","n","10351040","y","dahan","1","rav-milim",NULL,"tg1",NULL,"childhood",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3585,"!יַלְדוּתִיּוּת","n","03856888","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"childishness",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO in Hebrew it\'s reserved for ''infantilism'' (see its two sysnets in WN). ","ordan-30 Jun 2004, assign-6 Nov 2003",0,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (3586,"!יַמִּי","a","00431947","y","dahan","1","rav-milim",NULL,"tg1",NULL,"marine, maritime",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3587,"!יַמִּי","a","02671223","y","dahan","1","rav-milim",NULL,"tg1",NULL,"marine, maritime",NULL,NULL,"assigned","#ASSIGN:146.0=[gnd=1.0E+01,gnd=2.0E+01,si=2.0E+01,bt(dir)=21.0,bt(dir)=11.0,bt(crs)=32.0,bt(dir)=21.0,bt(dir)=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3588,"יַמָּאוּת","n","04362028","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"seamanship",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO This refers only to the latter part of RM\'s definition. The word ספנות in hebrew refers only to the work of the sailor and not to the skill itself","ordan-09 Jul 2004",92056,"2004-07-09");
INSERT INTO hebrew_synonyms VALUES (3589,"יַנְשׁוּף","n","01143120","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"owl, bird_of_Minerva",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-27 Jun 2004",92057,"2004-06-27");
INSERT INTO hebrew_synonyms VALUES (3590,"יַסְמִין","n","08610160","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"Jasmine",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-09 Jul 2004, assign-6 Nov 2003",92058,"2004-07-09");
INSERT INTO hebrew_synonyms VALUES (3591,"!יַעֲרָה","n","02827065","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"honeycomb",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO the Heb חלת or יערת דבש does not refer a structure RESEMBLING ''honeycomb'' but rather to the thing itself (English does have two such senses, but WN defines only one). ","ordan-08 Jul 2004, assign-6 Nov 2003",0,"2004-07-08");
INSERT INTO hebrew_synonyms VALUES (3592,"יַעֲרָן","n","07274398","yy","melingo","1.2","rav-milim",">1.1","tg1",NULL,"forester",NULL,NULL,"checked","#ASSIGN:78.0=[gnd=39.0,bt(dir)=39.0] #MZ@\r\n#NO","ordan-14 Jul 2004, assign-6 Nov 2003",92059,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3593,"יַעֲרָנוּת","n","04634522","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"forestry",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-10 Jul 2004",92060,"2004-07-10");
INSERT INTO hebrew_synonyms VALUES (3594,"!יַצְאָנִית","n","07615942","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"streetwalker",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO יצאנית is not necessarily on the streets","ordan-14 Jul 2004, assign-6 Nov 2003",0,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (6967,"מַלְוֶה-בְּרִבִּית","n","07658922","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"usurer",NULL,NULL,"checked","#IE","eyal-13 Jul 2004",92061,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3597,"!יַצִּיבוּת","n","10065119","u","dahan","1","rav-milim",NULL,"tg1",NULL,"stability",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO when may use here the phrase יציבות שלטונית (look at the hypernym - ''order'')","ordan-13 Jul 2004, assign-6 Nov 2003",0,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3598,"יַצִּיבוּת","n","03750498","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"stability",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-13 Jul 2004, assign-6 Nov 2003",92062,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3599,"!יַצִּיבוּת","n","03724071","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"stability",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-13 Jul 2004, assign-6 Nov 2003",0,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3600,"יַרְבּוּעַ","n","01853157","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"jerboa",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-27 Jun 2004, assign-6 Nov 2003",92063,"2004-06-27");
INSERT INTO hebrew_synonyms VALUES (3601,"יַרְחוֹן","n","04947242","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"monthly",NULL,"הירחון מגיע לתיבת הדואר בתחילת כל חודש","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-10 Jul 2004",92064,"2004-07-10");
INSERT INTO hebrew_synonyms VALUES (3602,"יַרְקָן","n","07301688","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"greengrocer",NULL,"אל תשכח להביא עגבניות ומלפפונים מהירקן","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-14 Jul 2004, assign-6 Nov 2003",92065,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3603,"יַתּוּשׁ","n","01704520","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"mosquito",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE","eyal-01 Jul 2004, assign-6 Nov 2003",92066,"2004-07-01");
INSERT INTO hebrew_synonyms VALUES (3604,"יָאֶה","a","01807135","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"becoming",NULL,"זה אינו יאה לגבר בגילך לבקש כסף מההורים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-11 Aug 2005, assign-6 Nov 2003",95231,"2005-08-11");
INSERT INTO hebrew_synonyms VALUES (3605,"יָגֵעַ","a","02314002","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"weary",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-08 Jul 2004, assign-6 Nov 2003",92067,"2004-07-08");
INSERT INTO hebrew_synonyms VALUES (3606,"!יָדִיד","n","06997421","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"friend",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-14 Jul 2004, assign-6 Nov 2003",0,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3607,"יָדוּעַ","a","01321996","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"known, well-known",NULL,"כבר בצעירותו היה ידוע בכל רחבי הארץ בכשרונו הקומי","checked","#ASSIGN:58.0=[gnd=2.0E+01,bt(dir)=38.0] #MZ@\r\n#NO","ordan-26 Jun 2004, assign-6 Nov 2003",91159,"2004-06-26");
INSERT INTO hebrew_synonyms VALUES (3608,"!יָדוּעַ","a","00917550","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"known, well-known",NULL,NULL,"checked","#ASSIGN:58.0=[gnd=2.0E+01,bt(dir)=38.0] #MZ@\r\n#NO ","ordan-26 Jun 2004, assign-6 Nov 2003",0,"2004-06-26");
INSERT INTO hebrew_synonyms VALUES (3610,"יָהֳרָה","n","03828648","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"arrogance, haughtiness",NULL,"הוא אף פעם אינו נוהג ביהירות, ותמיד עוזר לתלמידים החלשים ממנו בסבלנות רבה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-13 Jul 2004",92068,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3611,"!יָהִיר","a","01819144","y","dahan","1","rav-milim",NULL,"tg1",NULL,"haughty",NULL,NULL,"assigned","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3612,"יָוָן","n","06449758","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"Greece",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-09 Jul 2004, assign-6 Nov 2003",92069,"2004-07-09");
INSERT INTO hebrew_synonyms VALUES (3613,"!יָחִיד","a","01791800","y","dahan","1","rav-milim",NULL,"tg1",NULL,"only, single",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3614,"יָחֵף","a","02073987","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"barefoot",NULL,"אל תצא יחף מהבית, המדרכה לוהטת עכשיו","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-06 Jul 2004, assign-6 Nov 2003",92070,"2004-07-06");
INSERT INTO hebrew_synonyms VALUES (3615,"יָחֵף","r","00273450","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"barefoot",NULL,"בילדותי נהגתי ללכת יחף על חוף הים","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-11 Jul 2004, assign-6 Nov 2003",92071,"2004-07-11");
INSERT INTO hebrew_synonyms VALUES (3616,"!יָלִיד","n","06949518","y","dahan","1","rav-milim",NULL,"tg1","(of country)","native",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6898,"GAP!","n","07845203","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#NO that\'s a gapped collective noun, נחשול or משבר are matched to ''billow''. It may replaced with the collocation ים סוער","ordan-30 Jun 2004",90808,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (3619,"יָנוּאָר","n","10922756","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"January",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@#NO","ordan-06 Jul 2004, assign-6 Nov 2003",92072,"2004-07-06");
INSERT INTO hebrew_synonyms VALUES (3620,"!יָעִיל","a","00476442","y","dahan","1","rav-milim",NULL,"tg1","(person and machine)","efficient",NULL,NULL,"assigned","#ASSIGN:82.0=[gnd=2.0E+01,bt(dir)=8.0,bt(dir)=23.0,bt(crs)=31.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3621,"יָעִיל","a","00800025","yy","melingo","1.1","sapir","1.1","tg1","(person and machine)","efficient",NULL,"מנועים יעילים חוסכים דלק","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-11 Aug 2005, assign-6 Nov 2003",95227,"2005-08-11");
INSERT INTO hebrew_synonyms VALUES (3622,"יָעֵן","n","01041904","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"ostrich",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-30 Jun 2004",92073,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (3623,"!יָעֶה","n","09914193","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"dustpan",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-01 Jul 2004, assign-6 Nov 2003",0,"2004-07-01");
INSERT INTO hebrew_synonyms VALUES (3624,"יָעֶה","n","02617730","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"dustpan",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-01 Jul 2004, assign-6 Nov 2003",92074,"2004-07-01");
INSERT INTO hebrew_synonyms VALUES (3625,"!יָפֶה","a","01729352","n","dahan","1","rav-milim",NULL,"tg1",NULL,"beautiful",NULL,NULL,"assigned","#ASSIGN:45.0=[gnd=13.0,bt(dir)=14.0,bt(dir)=2.0,bt(crs)=16.0] #MZ@\r\n#IE could be נאה, but נאה fits better to \r\na#00430055","eyal-11 Aug 2005, assign-6 Nov 2003",0,"2005-08-11");
INSERT INTO hebrew_synonyms VALUES (3626,"יָפֶה","a","00072478","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"beautiful",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-11 Jul 2004, assign-6 Nov 2003",92075,"2004-07-11");
INSERT INTO hebrew_synonyms VALUES (3627,"יָפֶה","a","00215099","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"beautiful",NULL,"זה רעיון יפה, כדאי לך להמשיך לעבוד עליו","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-11 Jul 2004, assign-6 Nov 2003",92075,"2004-07-11");
INSERT INTO hebrew_synonyms VALUES (3628,"יָצוּק","a","02067743","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"cast",NULL,NULL,"checked","#ASSIGN:57.0=[gnd=39.0,glc=18.0] #MZ@\r\n#NO","ordan-08 Jul 2004, assign-6 Nov 2003",92076,"2004-07-08");
INSERT INTO hebrew_synonyms VALUES (3629,"!יָקָר","a","01401996","y","dahan","2","rav-milim",NULL,"tg1","(loved , high in price)","dear",NULL,NULL,"assigned","#ASSIGN:57.0=[gnd=1.0E+01,glc=54.0,bt(non)= -7.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (6877,"מִתְחָרֶה","a","00478654","yy","none",NULL,"rav-milim","1.1",NULL,NULL,"competing, rival",NULL,"נבחרת ישראל הביסה את הקבוצה המתחרה","checked","#NO","ordan-25 Jun 2004",92077,"2004-06-25");
INSERT INTO hebrew_synonyms VALUES (3631,"יָרִיב","n","07445577","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"opponent",NULL,"בתחרות הג\'ודו הארצית, הכניע אלוף הארץ את מרבית יריביו תוך פחות משלוש דקות","checked","#ASSIGN:37.0=[gnd=13.0,bt(dir)=5.0,bt(dir)=11.0,bt(non)= -8.0,bt(crs)=16.0] #MZ@\r\n#NO","ordan-25 Jun 2004",92078,"2004-06-25");
INSERT INTO hebrew_synonyms VALUES (6876,"אוֹיֵב","n","07242378","nn","none","1.1","none",NULL,NULL,NULL,"enemy, foe, foeman",NULL,NULL,"checked","#NO According to Hebrew dictionaries, אויב is the adversary army, not the individuals who make it up. ","ordan-25 Jun 2004",92079,"2004-06-25");
INSERT INTO hebrew_synonyms VALUES (3633,"יָרִיב","n","07064973","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"adversary, antagonist, opponent",NULL,"הוא אדם שנוי במחלוקת, יש לו לא מעט יריבים","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-25 Jun 2004",92078,"2004-06-25");
INSERT INTO hebrew_synonyms VALUES (3634,"יָרֵךְ","n","05693545","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"thigh",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#NO","ordan-10 Jul 2004, assign-6 Nov 2003",92080,"2004-07-10");
INSERT INTO hebrew_synonyms VALUES (3635,"יָרֵךְ","n","04309035","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"thigh",NULL,"לאחר רכיבה מאומצת על אופניים כאבו לי שרירי הירכיים","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-10 Jul 2004, assign-6 Nov 2003",92080,"2004-07-10");
INSERT INTO hebrew_synonyms VALUES (6988,"קָטַן","v","00103366","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"diminish, lessen",NULL,NULL,"revised","#NO","eyal-01 Feb 2005, ordan-15 Jul 2004",92081,"2005-02-01");
INSERT INTO hebrew_synonyms VALUES (3637,"!יָשָׁר","a","01186048","n","dahan","2","rav-milim",NULL,"tg1","(without bend)","straight",NULL,NULL,"assigned","#ASSIGN:50=[gnd=2.0,bt(dir)=3.0,bt(dir)=8.0,bt(crs)=11.0,dfl=26.0] #MZ@\r\n#IE","eyal-11 Aug 2005, assign-6 Nov 2003",0,"2005-08-11");
INSERT INTO hebrew_synonyms VALUES (3638,"!יָתוֹם","n","07448764","y","dahan","1","rav-milim",NULL,"tg1",NULL,"orphan",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3639,"יֹבֶשׁ","n","10425272","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"dryness",NULL,"כדאי למרוח קרם לחות בכדי למנוע יובש בעור","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-14 Jul 2004, assign-6 Nov 2003",91498,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3640,"!יֹפִי","n","04549741","y","dahan","1","rav-milim",NULL,"tg1",NULL,"beauty",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3641,"יֹפִי","n","03689966","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"beauty",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-13 Jul 2004, assign-6 Nov 2003",92082,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3642,"!יֹשֶׁר","n","08199367","y","dahan","1","rav-milim",NULL,"tg1",NULL,"honesty, uprightness",NULL,NULL,"assigned","#ASSIGN:37.0=[gnd=2.0E+01,bt(dir)=17.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3643,"יֹשֶׁר","n","03816422","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"honesty, honestness",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-11 Jul 2004, assign-6 Nov 2003",92083,"2004-07-11");
INSERT INTO hebrew_synonyms VALUES (3644,"יָמְרָה","n","03757761","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"pretentiousness, pretension",NULL,"יש מקום לפרסם את המאמר, למרות שאין לו יומרה למקוריות רבה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO","ordan-08 Jul 2004",92084,"2004-07-08");
INSERT INTO hebrew_synonyms VALUES (3645,"!יֻמְרָה","n","03757650","u","dahan","1","rav-milim",NULL,"tg1",NULL,"pretension",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#NO not sure, it\'s supposed to be more like טענת שווא, cf. Collins (1.1, pretension)","ordan-08 Jul 2004",0,"2004-07-08");
INSERT INTO hebrew_synonyms VALUES (3646,"!יֻקְרָה","n","10357033","y","dahan","1","rav-milim",NULL,"tg1",NULL,"prestige",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3647,"!יוֹבֵל","n","10955913","nn","dahan","2","rav-milim",NULL,"tg1",NULL,"anniversary",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-14 Jul 2004, assign-6 Nov 2003",0,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3648,"!יוֹגֵב","n","07256794","n","dahan","1","rav-milim",NULL,"tg1",NULL,"farmer, landworker",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE gender","eyal-26 Jun 2005, assign-6 Nov 2003",0,"2005-06-26");
INSERT INTO hebrew_synonyms VALUES (3649,"יוֹזֵם","n","07340845","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"initiator",NULL,"היו היה היוזם של כל הרעיון, תן לו קצת קרדיט","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-15 Jul 2004, assign-6 Nov 2003",92085,"2004-07-15");
INSERT INTO hebrew_synonyms VALUES (3650,"יוֹנָה","n","01329440","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"pigeon",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@ #IE","eyal-30 Jun 2004, assign-6 Nov 2003",92086,"2004-06-30");
INSERT INTO hebrew_synonyms VALUES (3652,"!יוֹצֵא","a","01242820","y","dahan","1","rav-milim",NULL,"tg1",NULL,"departing",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3653,"!יוֹצֵר","n","06889275","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"creator",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@","ordan-14 Jul 2004, assign-6 Nov 2003",0,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3654,"יוֹצֵר","n","06944789","yy","melingo","1.1","rav-milim",">1.1","tg1",NULL,"creator",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO","ordan-14 Jul 2004, assign-6 Nov 2003",92087,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3655,"!יוֹרֵד","n","07239606","n","dahan","1","rav-milim",NULL,"tg1","(from Israel)","emigrant",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE specific to Israel","eyal-20 Sep 2005, assign-6 Nov 2003",0,"2005-09-20");
INSERT INTO hebrew_synonyms VALUES (3656,"יוֹרֶשֶׁת","n","07315588","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"heiress",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#NO","ordan-15 Jul 2004, assign-6 Nov 2003",92088,"2004-07-15");
INSERT INTO hebrew_synonyms VALUES (3657,"יוּטָה","n","10710391","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"jute",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO RM 1.1 includes both the material and the plant, this card refers to the latter part of the definition ","ordan-14 Jul 2004, assign-6 Nov 2003",92089,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3658,"!יוּטָה","n","07015118","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"Jute",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#NO it seems like a name of an old tribe, couldn\'t find in Heb monolingual dictionaries","ordan-14 Jul 2004, assign-6 Nov 2003",0,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3659,"יוּלִי","n","10924973","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"July",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-06 Jul 2004, assign-6 Nov 2003",92090,"2004-07-06");
INSERT INTO hebrew_synonyms VALUES (3660,"יוּנִי","n","10924593","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"June",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#NO","ordan-06 Jul 2004, assign-6 Nov 2003",92091,"2004-07-06");
INSERT INTO hebrew_synonyms VALUES (3661,"!כֵירוּרְג","n","07624027","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"surgeon",NULL,NULL,"checked","#ASSIGN:78.0=[gnd=39.0,bt(dir)=39.0] #MZ@\r\n#IE this punctuation could not be found neither in RM, Sapir nor in Oxford ","eyal-25 Jul 2004, assign-6 Nov 2003",0,"2004-07-25");
INSERT INTO hebrew_synonyms VALUES (3662,"!כְּאֵב","n","10279666","y","dahan","2","rav-milim",NULL,"tg1",NULL,"ache",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (7033,"בִּמְהֵרָה","r","00032928","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,"soon, shortly",NULL,"במהירה בימינו","checked","#IE","eyal-25 Jul 2004",92092,"2004-07-25");
INSERT INTO hebrew_synonyms VALUES (3664,"!כְּדַאי","a","02463868","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"worthwhile",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-18 Jan 2005, assign-6 Nov 2003",0,"2005-01-18");
INSERT INTO hebrew_synonyms VALUES (3665,"כְּדָאִי","a","02463868","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"worthwhile",NULL,"ההשקעה שלי בלימודים הייתה בהחלט כדאית","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-18 Jan 2005, assign-6 Nov 2003",94170,"2005-01-18");
INSERT INTO hebrew_synonyms VALUES (3666,"כְּדָאִיּוּת","n","04004113","yy","none",NULL,"rav-milim","1.1","tg1",NULL,"worthwhileness",NULL,"יש לבחון מחדש את הכדאיות של פתיחת העסק בשבת","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-19 Jul 2004, assign-6 Nov 2003",92093,"2004-07-19");
INSERT INTO hebrew_synonyms VALUES (3667,"!כְּוִיָּה","n","10260405","y","dahan","1","rav-milim",NULL,"tg1","(by hot liquid)","scald",NULL,NULL,"assigned","#ASSIGN:27.0=[gnd=2.0E+01,glc=2.0,glc=5.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (7002,"מַכְשִׁיר","n","00112599","yy","melingo","1.2","rav-milim","1.2",NULL,NULL,NULL,NULL,NULL,"checked","#IE","eyal-19 Jul 2004",92094,"2004-07-19");
INSERT INTO hebrew_synonyms VALUES (3669,"!כְּלוֹנָס","n","07034349","nn","dahan","1","rav-milim",NULL,"tg1","(piece of wood)","pole",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-22 Jul 2004, assign-6 Nov 2003",0,"2004-07-22");
INSERT INTO hebrew_synonyms VALUES (3670,"כְּלוֹר","n","10483675","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"chlorine",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-25 Jul 2004, assign-6 Nov 2003",92095,"2004-07-25");
INSERT INTO hebrew_synonyms VALUES (3671,"כְּמִיהָה","n","05565891","yy","melingo","1","rav-milim","1.1","tg1",NULL,"longing, yearning",NULL,"כמיהתו אליה היתה קשה מנשוא","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@ #IE","eyal-08 Mar 2004, assign-6 Nov 2003",92096,"2004-03-08");
INSERT INTO hebrew_synonyms VALUES (3672,"כְּמוּרָה","n","06066212","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"clergy",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-22 Jul 2004, assign-6 Nov 2003",92097,"2004-07-22");
INSERT INTO hebrew_synonyms VALUES (6941,"כְּתֹבֶת","n","05083171","yy","melingo","1.1","rav-milim","1.1",NULL,NULL,NULL,NULL,NULL,"checked","#NO refers only to the latter part of the definition","ordan-11 Jul 2004",92098,"2004-07-11");
INSERT INTO hebrew_synonyms VALUES (3676,"כְּנִיסָה","n","02641840","yy","melingo","1.3","rav-milim","1.3","tg1",NULL,"entrance",NULL,"בכניסה לכנסייה ישבו שני קבצנים וביקשו נדבות","checked","#ASSIGN:55.0=[gnd=13.0,bt(dir)=14.0,bt(dir)=7.0,bt(crs)=21.0] #MZ@\r\n#NO","ordan-10 Feb 2005, assign-6 Nov 2003",91171,"2005-02-10");
INSERT INTO hebrew_synonyms VALUES (3678,"!כְּנִיעָה","n","05359296","y","dahan","1","rav-milim",NULL,"tg1","(being submitted)","surrender, submission",NULL,NULL,"assigned","#ASSIGN:+inf=[gnd=2.0E+01,glc= +inf,bt(non)= -17.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3679,"כְּנֵסִיָּה","n","02438778","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"church",NULL,"אורות הכנסייה נצנצו למרחוק","checked","#ASSIGN:27.0=[gnd=13.0,bt(dir)=14.0] #MZ@\r\n#IE","eyal-13 Jul 2004, assign-6 Nov 2003",92099,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3680,"!כְּנֵסִיָּה","n","00666912","n","dahan","1","rav-milim",NULL,"tg1",NULL,"church",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-22 Aug 2005, assign-6 Nov 2003",0,"2005-08-22");
INSERT INTO hebrew_synonyms VALUES (3681,"כְּפִירָה","n","04708659","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"heresy",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","eyal-19 Jul 2004, assign-6 Nov 2003",92100,"2004-07-19");
INSERT INTO hebrew_synonyms VALUES (3682,"כְּפִירָה","n","04586741","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"heresy",NULL,"תיאוריית המפץ הגדול הינה פגיעה בציבור הדתי, משום שיש בה כפירה באמונה של בריאת העולם בידי אלוהים","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE RM\'s definition is a bit broader and includes also rejection of major principals in life, not necessarily religious","eyal-19 Jul 2004",92100,"2004-07-19");
INSERT INTO hebrew_synonyms VALUES (3683,"כְּפָפָה","n","02757746","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"glove",NULL,"לפני שאתה יוצא לשלג, אנא לבש כפפות","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-18 Jul 2004, assign-6 Nov 2003",92101,"2004-07-18");
INSERT INTO hebrew_synonyms VALUES (3684,"כְּפָפַת-אִגְרוּף","n","02325897","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"boxing_glove",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#IE","eyal-14 Jul 2004, assign-6 Nov 2003",92102,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3685,"!כְּפָפָה","n","02258309","n","dahan","1","rav-milim",NULL,"tg1",NULL,"glove",NULL,NULL,"assigned","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#IE","eyal-22 Aug 2005, assign-6 Nov 2003",0,"2005-08-22");
INSERT INTO hebrew_synonyms VALUES (3686,"!כְּפָר","n","06383813","y","dahan","1","rav-milim",NULL,"tg1",NULL,"village",NULL,NULL,"assigned","#ASSIGN:25.0=[gnd=2.0E+01,bt(dir)=19.0,bt(non)= -14.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3687,"!כְּפָר","n","06107243","y","dahan","1","rav-milim",NULL,"tg1",NULL,"village",NULL,NULL,"assigned","#ASSIGN:25.0=[gnd=2.0E+01,bt(dir)=17.0,bt(non)= -12.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3688,"!כְּפָר","n","06630722","n","dahan","1","rav-milim",NULL,"tg1",NULL,"village",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-04 Sep 2005, assign-6 Nov 2003",0,"2005-09-04");
INSERT INTO hebrew_synonyms VALUES (3689,"!כְּפוֹר","n","07717771","y","dahan","1","rav-milim",NULL,"tg1",NULL,"frost",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3690,"!כְּרַסְתָּן","a","00219555","u","dahan","1","rav-milim",NULL,"tg1",NULL,"big-bellied",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE WN has another synset with the same gloss (a#00934815 - potbellied). I chose to attach the other synset to כרסתן since it was RM\'s translation.","eyal-12 Jul 2004, assign-6 Nov 2003",0,"2004-07-12");
INSERT INTO hebrew_synonyms VALUES (3691,"כְּרָזָה","n","05087726","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"poster, placard",NULL,"בכל רחבי העיר נתלו כרזות הקוראות לצאת להפגנה","checked","#ASSIGN:7.0E+01=[gnd=39.0,bt(dir)=16.0,bt(dir)=28.0,bt(non)= -19.0,bt(non)= -19.0,bt(non)= -19.0,bt(crs)=44.0] #MZ@\r\n#IE","eyal-22 Jul 2004",92103,"2004-07-22");
INSERT INTO hebrew_synonyms VALUES (3692,"כְּרוּב","n","08183904","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"cabbage",NULL,NULL,"checked","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@\r\n#IE","eyal-04 Sep 2005, assign-6 Nov 2003",95239,"2005-09-04");
INSERT INTO hebrew_synonyms VALUES (3693,"!כְּרוּב","n","05752184","y","melingo","1.1","rav-milim","1.1","tg1",NULL,"cabbage",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-04 Sep 2005, assign-6 Nov 2003",0,"2005-09-04");
INSERT INTO hebrew_synonyms VALUES (3694,"כְּרוּבִית","n","08184847","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"cauliflower",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-22 Jul 2004, assign-6 Nov 2003",92104,"2004-07-22");
INSERT INTO hebrew_synonyms VALUES (3695,"!כְּרוּבִית","n","05753383","y","dahan","1","rav-milim",NULL,"tg1",NULL,"cauliflower",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3696,"כְּרוּכְיָה","n","01524724","yy","melingo","1.1","rav-milim","1.1","tg1","(bird)","crane",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=2.0E+01,glc=9.0] #MZ@\r\n#IE","eyal-13 Jul 2004, assign-6 Nov 2003",92105,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3697,"!כְּשִׁירוּת","n","04014903","y","dahan","1","rav-milim",NULL,"tg1","(physically fit)","fitness",NULL,NULL,"assigned","#ASSIGN:50=[gnd=1.0E+01,glc=33.0,dfl=7.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3698,"כְּתִיב","n","04790339","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"spelling",NULL,"הוא כותב נהדר, ללא שגיאת כתיב אחת!","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE","eyal-20 Jul 2004, assign-6 Nov 2003",92106,"2004-07-20");
INSERT INTO hebrew_synonyms VALUES (3699,"!כְּתִישָׁה","n","00697514","y","dahan","1","rav-milim",NULL,"tg1","(act)","crushing",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,glc=2.0,dfl=9.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3700,"כְּתֹבֶת","n","04828090","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"inscription",NULL,"מעל הקבר העתיק היתה חקוקה כתובת רומית","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-20 Jul 2004, assign-6 Nov 2003",92098,"2004-07-20");
INSERT INTO hebrew_synonyms VALUES (3701,"כְּתוּבִים","n","04852916","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"Hagiographa",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-20 Jul 2004, assign-6 Nov 2003",92107,"2004-07-20");
INSERT INTO hebrew_synonyms VALUES (3702,"כִּבְשָׂה","n","01908755","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"ewe",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE","eyal-14 Jul 2004, assign-6 Nov 2003",92108,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3703,"!כִּבְשָׂה","n","05250807","y","dahan","1","rav-milim",NULL,"tg1",NULL,"ewe",NULL,NULL,"assigned","#ASSIGN:39.0=[gnd=39.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3704,"כִּבּוּשׁ","n","00104245","yy","melingo","1.1","rav-milim","1.3","tg1",NULL,"conquest",NULL,"בספרו הוא מתאר את כיבושיו הרבים בתחום הרומנטי","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-13 Jul 2004, assign-6 Nov 2003",92109,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3705,"כִּבּוּשׁ","n","00054499","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"conquest",NULL,"כיבוש פולין, בספטמבר 1939, סימל את תחילתה של מלחמת העולם השניה","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE refers to the second part of RM\' definition","eyal-13 Jul 2004, assign-6 Nov 2003",92109,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3706,"כִּבּוּשׁ","n","00037624","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"conquest",NULL,"כיבוש החלל","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-13 Jul 2004, assign-6 Nov 2003",92109,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (6954,"פִּדְיוֹן","n","00061001","yy","none",NULL,"rav-milim","1.1a",NULL,NULL,"ransom",NULL,NULL,"checked","#IE","eyal-13 Jul 2004",92110,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3710,"כִּוְנוּן","n","00646064","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"tuning",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-13 Jul 2004, assign-6 Nov 2003",92111,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3711,"כִּיּוּל","n","00645793","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"calibration",NULL,"התרמומטר זקוק לכיול","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-13 Jul 2004, assign-6 Nov 2003",92112,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3712,"כִּיב","n","10212984","yy","melingo","1.1","rav-milim","1.1","tg1","(med)","ulcer",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-25 Jul 2004, assign-6 Nov 2003",92113,"2004-07-25");
INSERT INTO hebrew_synonyms VALUES (3713,"כִּידוֹן","n","02268139","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"bayonet",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-18 Jul 2004, assign-6 Nov 2003",92114,"2004-07-18");
INSERT INTO hebrew_synonyms VALUES (3714,"כִּילַי","n","07413689","yy","melingo","1.1","rav-milim","1.1","tg1","literary","miser",NULL,"שם כילי גדול יצא לו, שלא היה נותן למעשי צדקה אלא טיפין טיפין","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-25 Jul 2004",92115,"2004-07-25");
INSERT INTO hebrew_synonyms VALUES (3715,"כִּימְיָה","n","09971597","yy","melingo","1.1","rav-milim","1.2","tg1",NULL,"chemistry",NULL,"היתה ביניהם כימיה טובה מהרגע הראשון","checked","#ASSIGN:41.0=[gnd=2.0E+01,bt(dir)=21.0] #MZ@\r\n#IE in Hebrew we usually state the existence or non-existence of chemistry between two people","eyal-19 Jul 2004",92116,"2004-07-19");
INSERT INTO hebrew_synonyms VALUES (3716,"כִּימְיָה","n","04640400","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"chemistry",NULL,"יש לו תואר שני בכימיה","checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#IE","eyal-19 Jul 2004, assign-6 Nov 2003",92116,"2004-07-19");
INSERT INTO hebrew_synonyms VALUES (3717,"כִּימִי","a","02543733","yy","melingo","1.1","sapir","1.2","tg1",NULL,"chemical",NULL,"זבל כימי","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-12 Jul 2004, assign-6 Nov 2003",92117,"2004-07-12");
INSERT INTO hebrew_synonyms VALUES (3718,"כִּימִי","a","02543445","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"chemical",NULL,"הנדסה כימית","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-12 Jul 2004",92117,"2004-07-12");
INSERT INTO hebrew_synonyms VALUES (3719,"!כִּירַיִם","n","02495933","y","dahan","1","rav-milim",NULL,"tg1",NULL,"cooker",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3720,"כִּכָּר","n","05725764","yy","melingo","2.1","rav-milim","2.1","tg1","colloquial","loaf_of_bread",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE","eyal-22 Jul 2004, assign-6 Nov 2003",92118,"2004-07-22");
INSERT INTO hebrew_synonyms VALUES (3721,"כִּלְיָה","n","04136473","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"kidney",NULL,"הוא תרם אחת מכליותיו לבנו ובכך הציל את חייו","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE","eyal-19 Jul 2004, assign-6 Nov 2003",92119,"2004-07-19");
INSERT INTO hebrew_synonyms VALUES (3722,"כִּנּוֹר","n","03579422","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"violin",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-18 Jul 2004, assign-6 Nov 2003",92120,"2004-07-18");
INSERT INTO hebrew_synonyms VALUES (3723,"כִּנּוּי","n","04780372","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"nickname",NULL,"אימו סירבה לכנותו בכינוי שלו, ותמיד קראה לו בשמו המלא","checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE","eyal-19 Jul 2004, assign-6 Nov 2003",92121,"2004-07-19");
INSERT INTO hebrew_synonyms VALUES (3724,"כִּעוּר","n","03693789","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"ugliness",NULL,"למרות כיעורו, היתה לו הצלחה מדהימה עם נשים","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-18 Jul 2004, assign-6 Nov 2003",92122,"2004-07-18");
INSERT INTO hebrew_synonyms VALUES (3725,"!כִּפְלַיִם","r","00316651","y","dahan","1","rav-milim",NULL,"tg1",NULL,"double",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3726,"!כִּפְלַיִם","r","00316569","y","dahan","1","rav-milim",NULL,"tg1",NULL,"double",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3727,"!כִּפָּה","n","02588147","y","dahan","1","rav-milim",NULL,"tg1","(building)","dome",NULL,NULL,"assigned","#ASSIGN:37.0=[gnd=2.0E+01,bt(dir)=17.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3728,"כִּפָּה","n","02587986","yy","none",NULL,"rav-milim","1.2","tg1","(building)","dome",NULL,NULL,"checked","#ASSIGN:49.0=[gnd=2.0E+01,glc=5.0,bt(dir)=24.0] #MZ@\r\n#IE","eyal-18 Jul 2004, assign-6 Nov 2003",92123,"2004-07-18");
INSERT INTO hebrew_synonyms VALUES (3729,"כִּשְׁכֵּשׁ","v","01295618","yy","melingo","1.1","rav-milim","1.1","tg1","(tail)","wag",NULL,"הכלב כשכש בזנבו בשמחה","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-28 Jul 2004, assign-6 Nov 2003",92124,"2004-07-28");
INSERT INTO hebrew_synonyms VALUES (3730,"כִּתָּה","n","02447403","yy","melingo","1.2","rav-milim","1.2","tg1",NULL,"classroom",NULL,"תפקידם של התורנים הוא לסדר את הכיתה בסוף היום","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-18 Jul 2004, assign-6 Nov 2003",92125,"2004-07-18");
INSERT INTO hebrew_synonyms VALUES (3731,"כִּתָּה","n","06115327","yy","melingo","1.1","rav-milim","1.1","tg1","(US = grade)","class, grade",NULL,"הכיתה של הבוקר תמיד ישנונית","checked","#ASSIGN:50=[gnd=3.0,bt(dir)=4.0,bt(dir)=5.0,bt(crs)=9.0,dfl=29.0] #MZ@\r\n#IE","eyal-18 Jul 2004, assign-6 Nov 2003",92125,"2004-07-18");
INSERT INTO hebrew_synonyms VALUES (3732,"כִּתּוּר","n","00610851","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"encirclement",NULL,"החיילים החלו בכיתור הכפר ועריכת חיפוש בתוכו","checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-13 Jul 2004, assign-6 Nov 2003",92126,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3733,"!כֵּלַי","n","07413689","u","dahan","1","rav-milim",NULL,"tg1",NULL,"miser",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE this word was not found in either RM, Sapir, or Oxford","eyal-25 Jul 2004, assign-6 Nov 2003",0,"2004-07-25");
INSERT INTO hebrew_synonyms VALUES (3734,"!כֵּן","a","02043991","y","dahan","1","rav-milim",NULL,"tg1",NULL,"sincere",NULL,NULL,"assigned","#ASSIGN:26.0=[gnd=2.0E+01,bt(non)= -13.0,bt(dir)=19.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3735,"כֵּן","a","02094165","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"sincere",NULL,"אני רוצה שתהיי כנה איתי ותאמרי לי כל אשר על ליבך","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-22 Aug 2005, assign-6 Nov 2003",95233,"2005-08-22");
INSERT INTO hebrew_synonyms VALUES (3736,"!כֶּבֶשׁ","n","02737525","y","dahan","1","rav-milim",NULL,"tg1","(to ship , plane)","gangway",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3737,"כֶּבֶשׁ","n","02737262","yy","melingo","1.1","rav-milim","1.1","tg1","(to ship , plane)","gangway",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-04 Sep 2005, assign-6 Nov 2003",95236,"2005-09-04");
INSERT INTO hebrew_synonyms VALUES (3738,"!כֶּבֶשׁ","n","02176672","n","dahan","1","rav-milim",NULL,"tg1","(to ship , plane)","gangway",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-04 Sep 2005, assign-6 Nov 2003",0,"2005-09-04");
INSERT INTO hebrew_synonyms VALUES (3739,"!כֶּבֶשׂ","n","07569478","y","dahan","1","rav-milim",NULL,"tg1",NULL,"sheep",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3740,"!כֶּבֶשׂ","n","07569298","y","dahan","1","rav-milim",NULL,"tg1",NULL,"sheep",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3741,"כֶּבֶשׂ","n","01908461","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"sheep",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-14 Jul 2004, assign-6 Nov 2003",92127,"2004-07-14");
INSERT INTO hebrew_synonyms VALUES (3742,"כֶּנֶס","n","06166581","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"conference",NULL,"בכנס הישראלי לבלשנות השתתפו חוקרים מכל רחבי העולם","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-06 May 2004",92128,"2004-05-06");
INSERT INTO hebrew_synonyms VALUES (3743,"!כֶּנֶס","n","05343252","y","dahan","1","rav-milim",NULL,"tg1",NULL,"conference",NULL,NULL,"assigned","#ASSIGN:26.0=[gnd=13.0,bt(dir)=13.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3744,"כֶּסֶף","n","10501473","yy","melingo","2.1","rav-milim","2.1","tg1","(metal)","silver",NULL,"היא קיבלה ליום הולדתה עגילי כסף נאים","checked","#ASSIGN:51.0=[gnd=1.0E+01,glc=18.0,glc=11.0,bt(dir)=12.0] #MZ@\r\n#IE","eyal-25 Jul 2004, assign-6 Nov 2003",92129,"2004-07-25");
INSERT INTO hebrew_synonyms VALUES (3745,"כֶּסֶת","n","03196324","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"comforter",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-18 Jul 2004, assign-6 Nov 2003",92130,"2004-07-18");
INSERT INTO hebrew_synonyms VALUES (3746,"כֶּרֶם","n","03578669","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"vineyard",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE","eyal-18 Jul 2004, assign-6 Nov 2003",92131,"2004-07-18");
INSERT INTO hebrew_synonyms VALUES (3747,"כֶּתֶם","n","05088890","yy","melingo","1.1","rav-milim","1.4","tg1",NULL,"stain",NULL,"התנהגותו המחפירה של השר הטילה כתם על כל המפלגה","checked","#ASSIGN:3.0E+01=[gnd=8.0,bt(dir)=3.0,bt(dir)=8.0,bt(crs)=11.0] #MZ@\r\n#IE","eyal-22 Jul 2004, assign-6 Nov 2003",92132,"2004-07-22");
INSERT INTO hebrew_synonyms VALUES (3748,"!כַּד","n","09915071","y","dahan","1","rav-milim",NULL,"tg1",NULL,"jug",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3749,"!כַּד","n","02880403","y","dahan","1","rav-milim",NULL,"tg1",NULL,"jug",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3750,"כַּדּוּרְסַל","n","02260281","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"basketball",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@ #IE refers to the second part of RM\'s definition","eyal-13 Jul 2004, assign-6 Nov 2003",92133,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3751,"כַּדּוּרְסַל","n","00306597","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"basketball",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#IE refers to the first part of RM\'s definition","eyal-13 Jul 2004, assign-6 Nov 2003",92133,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3752,"כַּדּוּרְעָף","n","03581346","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"volleyball",NULL,NULL,"checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE refers to the second part of RM\'s definition","eyal-13 Jul 2004, assign-6 Nov 2003",92134,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3753,"כַּדּוּרְעָף","n","00305986","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"volleyball",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=2.0E+01,bt(dir)=19.0] #MZ@\r\n#IE refers to the first part of RM\'s definition","eyal-13 Jul 2004",92134,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3755,"!כַּדּוּרֶגֶל","n","02709998","y","dahan","1","rav-milim",NULL,"tg1",NULL,"football, soccer",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (8873,"GAP!","n","00299231","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE no collective term in Hebrew","eyal-04 Sep 2005",90808,"2005-09-04");
INSERT INTO hebrew_synonyms VALUES (3757,"!כַּדּוּרֶגֶל","n","02709998","y","dahan","2","rav-milim",NULL,"tg1","(ball)","football",NULL,NULL,"assigned","#ASSIGN:34.0=[gnd=13.0,glc=5.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3758,"!כַּדּוּרֶגֶל","n","00299231","n","dahan","2","rav-milim",NULL,"tg1","(ball)","football",NULL,NULL,"assigned","#ASSIGN:34.0=[gnd=13.0,glc=5.0,bt(dir)=16.0] #MZ@","eyal-04 Sep 2005, assign-6 Nov 2003",0,"2005-09-04");
INSERT INTO hebrew_synonyms VALUES (3759,"!כַּדּוּרַגְלָן","n","07271874","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"footballer",NULL,NULL,"checked","#ASSIGN:78.0=[gnd=39.0,bt(dir)=39.0] #MZ@\r\n#IE כדורגלן is ''soccer player'' (n#N0000331)","eyal-25 Jul 2004, assign-6 Nov 2003",0,"2004-07-25");
INSERT INTO hebrew_synonyms VALUES (3760,"!כַּהֲלָכָה","r","00501853","y","dahan","1","rav-milim",NULL,"tg1",NULL,"properly",NULL,NULL,"assigned","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3761,"כַּהֲלָכָה","r","00192828","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"properly",NULL,"הוא לא ביצע את עבודתו כהלכה","checked","#ASSIGN:26.0=[gnd=2.0E+01,bt(dir)=21.0,bt\r\n(non)= -15.0] #MZ@\r\n#IE","eyal-27 Jul 2004, assign-6 Nov 2003",92135,"2004-07-27");
INSERT INTO hebrew_synonyms VALUES (3762,"כַּוְרָן","n","07106714","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"beekeeper",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-22 Jul 2004, assign-6 Nov 2003",92136,"2004-07-22");
INSERT INTO hebrew_synonyms VALUES (3763,"כַּוְרָנוּת","n","00588610","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"beekeeping",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-13 Jul 2004, assign-6 Nov 2003",92137,"2004-07-13");
INSERT INTO hebrew_synonyms VALUES (3764,"!כַּוֶּרֶת","n","06845741","y","dahan","1","rav-milim",NULL,"tg1",NULL,"hive",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3765,"!כַּוֶּרֶת","n","06082383","y","dahan","1","rav-milim",NULL,"tg1",NULL,"hive",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3766,"!כַּוֶּרֶת","n","02276576","y","dahan","1","rav-milim",NULL,"tg1",NULL,"hive",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (7003,"GAP!","n","04588436","yy",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"checked","#IE see the note in כונה","eyal-19 Jul 2004",90808,"2004-07-19");
INSERT INTO hebrew_synonyms VALUES (3768,"כַּיָּס","n","07475990","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"pickpocket",NULL,NULL,"checked","#ASSIGN:51.0=[gnd=39.0,bt(dir)=39.0,bt(non)= -27.0] #MZ@\r\n#IE","eyal-25 Jul 2004, assign-6 Nov 2003",92138,"2004-07-25");
INSERT INTO hebrew_synonyms VALUES (3769,"כַּלְבָּה","n","01594789","yy","melingo","1.1","rav-milim","1.1","tg1","(a female dog)","bitch",NULL,NULL,"checked","#ASSIGN:50=[gnd=1.0E+01,flc(pot)=5.0,glc=11.0,glc=8.0,dfl=16.0] #MZ@\r\n#IE","eyal-22 Aug 2005, assign-6 Nov 2003",95234,"2005-08-22");
INSERT INTO hebrew_synonyms VALUES (3770,"כַּלְכְּלָן","n","07234388","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"economist",NULL,"כלכלנים רבים לא הצליחו לחזות את מועד יציאת המשק מהמיתון","checked","#ASSIGN:78.0=[gnd=39.0,bt(dir)=39.0] #MZ@\r\n#IE","eyal-25 Jul 2004",92139,"2004-07-25");
INSERT INTO hebrew_synonyms VALUES (3771,"כַּלְכָּלָה","n","04674380","yy","none",NULL,"rav-milim","1.2","tg1",NULL,NULL,NULL,"החוג לכלכלה הינו בין המבוקשים ביותר ע''י הנרשמים לאוניברסיטה ","checked","#ASSIGN:117.0=[gnd=39.0,bt(dir)=33.0,bt(dir)=6.0,bt(crs)=39.0] #MZ@\r\n#IE","eyal-19 Jul 2004, assign-6 Nov 2003",92140,"2004-07-19");
INSERT INTO hebrew_synonyms VALUES (3772,"!כַּלַּאי","n","07673310","y","dahan","1","rav-milim",NULL,"tg1",NULL,"warder",NULL,NULL,"assigned","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3773,"כַּלָּה","n","07126327","yy","melingo","1.1","sapir","1.2","tg1",NULL,"bride",NULL,"הכלה פסעה בצעדים נרגשים אל מתחת לחופה","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE","eyal-25 Jul 2004, assign-6 Nov 2003",92141,"2004-07-25");
INSERT INTO hebrew_synonyms VALUES (3774,"כַּלָּה","n","07126220","yy","melingo","1.1","rav-milim",">1.1","tg1",NULL,"bride",NULL,"החתן והכלה בילו את ירח הדבש שלהם בטיול מסביב לעולם","checked","#ASSIGN:44.0=[gnd=2.0E+01,bt(dir)=24.0] #MZ@\r\n#IE RM\'s definition consists of 3 parts. This synset corresponds with the third part.","eyal-25 Jul 2004",92141,"2004-07-25");
INSERT INTO hebrew_synonyms VALUES (3775,"!כַּלָּה","n","07702357","nn","dahan","1","rav-milim",NULL,"tg1",NULL,"bride",NULL,NULL,"checked","#ASSIGN:39.0=[gnd=39.0] #MZ@\r\n#IE","eyal-25 Jul 2004, assign-6 Nov 2003",0,"2004-07-25");
INSERT INTO hebrew_synonyms VALUES (3776,"כַּלָּנִית","n","08036172","yy","melingo","1.1","rav-milim","1.1","tg1","(flower)","anemone",NULL,NULL,"checked","#ASSIGN:50=[gnd=39.0,dfl=11.0] #MZ@\r\n#IE","eyal-25 Jul 2004, assign-6 Nov 2003",92142,"2004-07-25");
INSERT INTO hebrew_synonyms VALUES (3777,"כַּמָּה","a","02158584","yy","melingo","2.1","rav-milim","2.1","tg1",NULL,"several",NULL,NULL,"checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#NO","ordan-14 Feb 2004",92143,"2004-02-14");
INSERT INTO hebrew_synonyms VALUES (3778,"!כַּמָּה","a","01990138","y","dahan","1","rav-milim",NULL,"tg1",NULL,"several, some",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3779,"!כַּמָּה","a","00462055","y","dahan","1","rav-milim",NULL,"tg1",NULL,"several, some",NULL,NULL,"assigned","#ASSIGN:63.0=[gnd=13.0,bt(dir)=14.0,bt(dir)=11.0,bt(crs)=25.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3780,"כַּמּוּבָן","r","00037564","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"of_course",NULL,"אשאר לצידך, כמובן, בזמן הבדיקה","checked","#ASSIGN:50=[gnd=39.0,bt(dir)=9.0,bt(non)= -23.0,dfl=25.0] #MZ@\r\n#IE","eyal-26 Jul 2004, assign-6 Nov 2003",92144,"2004-07-26");
INSERT INTO hebrew_synonyms VALUES (3781,"!כַּמּוּת","n","04507519","y","dahan","1","rav-milim",NULL,"tg1",NULL,"quantity",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3782,"!כַּמּוּת","n","03983740","y","dahan","1","rav-milim",NULL,"tg1",NULL,"quantity",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3783,"!כַּמּוּת","n","00020056","y","dahan","1","rav-milim",NULL,"tg1",NULL,"quantity",NULL,NULL,"assigned","#ASSIGN:47.0=[gnd=13.0,bt(dir)=4.0,bt(dir)=13.0,bt(crs)=17.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3784,"כַּסְפִּית","n","10492641","yy","melingo","1.1","rav-milim","1.1","tg1",NULL,"mercury",NULL,NULL,"checked","#ASSIGN:88.0=[gnd=39.0,bt(dir)=49.0] #MZ@\r\n#IE","eyal-25 Jul 2004, assign-6 Nov 2003",92145,"2004-07-25");
INSERT INTO hebrew_synonyms VALUES (3785,"!כַּסֶּפֶת","n","03266553","y","dahan","1","rav-milim",NULL,"tg1","(for valuables)","safe",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3786,"!כַּסֶּפֶת","n","03266470","y","dahan","1","rav-milim",NULL,"tg1","(for valuables)","safe",NULL,NULL,"assigned","#ASSIGN:+inf=[gnd=13.0,glc= +inf,glc= +inf,bt(dir)=16.0] #MZ@","assign-6 Nov 2003",0,"2003-12-09");
INSERT INTO hebrew_synonyms VALUES (3787,"כַּף","n","09917014","yy","melingo","1.2","rav-milim","1.2","tg2",NULL,"spoon",NULL,"הוא אכל בתאווה את המרק, כף אחרי כף","checked","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@\r\n#IE","eyal-18 Jul 2004, assign-6 Nov 2003",92146,"2004-07-18");
INSERT INTO hebrew_synonyms VALUES (3788,"!כַּף","n","03388234","y","dahan","1","rav-milim",NULL,"tg2",NULL,"spoon",NULL,NULL,"assigned","#ASSIGN:29.0=[gnd=13.0,bt(dir)=16.0] #MZ@","ass