# Host: 	    Database: 	    Date: 
# ---------------------------------------------------------
#

DROP TABLE IF EXISTS hebrew_morpho;
CREATE TABLE hebrew_morpho (id INTEGER (10) not null PRIMARY KEY,lemma VARCHAR (200) NOT NULL,pos CHECK (pos IN ("n","v","a","s","r")) NOT NULL,irregular_forms VARCHAR (200),pronunciation VARCHAR (200), undotted VARCHAR(200), dotted_without_dots VARCHAR (200) NOT NULL, variants TEXT, translit_dotted VARCHAR (200), translit_undotted VARCHAR (200),miscellanea TEXT);
CREATE INDEX lemma ON hebrew_morpho(lemma);
CREATE INDEX pos ON hebrew_morpho(pos);
CREATE INDEX idx_dwd ON hebrew_morpho(dotted_without_dots);
CREATE INDEX pronunciation ON hebrew_morpho(pronunciation);

INSERT INTO hebrew_morpho VALUES (90801,"בַּיִת","n",NULL,"BAYIT","בית","בית",NULL,"BIT","BIT",NULL);
INSERT INTO hebrew_morpho VALUES (90803,"אִמָּא_וְאַבָּא","n",NULL,"IMA_VEABA","אמא_ואבא","אִמָּא_וְאַבָּא",NULL,"_","_",NULL);
INSERT INTO hebrew_morpho VALUES (90804,"בַּיְט","n",NULL,"BAYT","ביט","ביט",NULL,"BI@","BI@",NULL);
INSERT INTO hebrew_morpho VALUES (90805,"בֵּית_אָבוֹת","n",NULL,"BEYT_AVOT","בית_אבות","בית_אבות",NULL,"BIT_ABWT","BIT_ABWT",NULL);
INSERT INTO hebrew_morpho VALUES (90806,"פִּיל","n",NULL,"PIL","פיל","פיל",NULL,"PIL","PIL",NULL);
INSERT INTO hebrew_morpho VALUES (90807,"תֵּאַטְרוֹן","n",NULL,"TEATRON","תאטרון","תאטרון",NULL,"TA@RWN","TA@RWN",NULL);
INSERT INTO hebrew_morpho VALUES (90809,"גִ\'ירָפָה","n",NULL,"G\'IRAFA","ג\'יראפה_ג\'ירפה","ג\'ירפה",NULL,"G\'IRPH","G\'IRAPH_G\'IRPH",NULL);
INSERT INTO hebrew_morpho VALUES (90810,"גִ\'ירָף","n",NULL,"G\'IRAF","ג\'ירף","ג\'ירף",NULL,"G\'IRP","G\'IRP",NULL);
INSERT INTO hebrew_morpho VALUES (90811,"ד&quot;ש","n",NULL,"DASH","ד&quot;ש","ד&quot;ש",NULL,"D&quot;$","D&quot;$",NULL);
INSERT INTO hebrew_morpho VALUES (90812,"אִחוּל","n",NULL,"ICHUL","איחול","אחול",NULL,"AXWL","AIXWL",NULL);
INSERT INTO hebrew_morpho VALUES (90813,"דְּרִישַׁת-שָׁלוֹם","n",NULL,"DRISHAT-SHALOM","דרישת_שלום","דרישת-שלום",NULL,"DRI$T-$LWM","DRI$T_$LWM",NULL);
INSERT INTO hebrew_morpho VALUES (90814,"מִשְׁכָּן","n",NULL,"MI$KAN","משכן","משכן",NULL,"M$KN","M$KN",NULL);
INSERT INTO hebrew_morpho VALUES (90815,"בֵּית_מְגוּרִים","n",NULL,"BEYT_MEGURIM","בית_מגורים","בית_מגורים",NULL,"BIT_MGWRIM","BIT_MGWRIM",NULL);
INSERT INTO hebrew_morpho VALUES (90816,"בֵּית_דִּירוֹת","n",NULL,"BEYT_DIROT","בית_דירות","בית_דירות",NULL,"BIT_DIRWT","BIT_DIRWT",NULL);
INSERT INTO hebrew_morpho VALUES (90817,"דִּיּוּר","n",NULL,"DIYUR","דיור","דיור",NULL,"DIWR","DIWR",NULL);
INSERT INTO hebrew_morpho VALUES (90818,"מִבְנֶה","n",NULL,"MIVNE","מבנה","מבנה",NULL,"MBNH","MBNH",NULL);
INSERT INTO hebrew_morpho VALUES (90819,"בִּיֵּת","v",NULL,"BIYET","בית","בית",NULL,"BIT","BIT",NULL);
INSERT INTO hebrew_morpho VALUES (90820,"אִלֵּף","v",NULL,"ILEF","אלף","אלף",NULL,"ALP","ALP",NULL);
INSERT INTO hebrew_morpho VALUES (90821,"אֶתְמוֹל","n",NULL,"ETMOL","אתמול","אתמול",NULL,"ATMWL","ATMWL",NULL);
INSERT INTO hebrew_morpho VALUES (90822,"אֶתְמוֹל","r",NULL,"ETMOL","אתמול","אתמול",NULL,"ATMWL","ATMWL",NULL);
INSERT INTO hebrew_morpho VALUES (90823,"מְדִינָה","n",NULL,"MDINA","מדינה","מדינה",NULL,"MDINH","MDINH",NULL);
INSERT INTO hebrew_morpho VALUES (90824,"מַצָּב","n",NULL,"MATZAV","מצב","מצב",NULL,"MCB","MCB",NULL);
INSERT INTO hebrew_morpho VALUES (90825,"מֻצָּב","n",NULL,"MUCAV","מצב","מצב",NULL,"MCB","MCB",NULL);
INSERT INTO hebrew_morpho VALUES (90826,"סְטָטוּס","n",NULL,"STATUS","סטטוס","סטטוס",NULL,"S@@WS","S@@WS",NULL);
INSERT INTO hebrew_morpho VALUES (90827,"מִצָּב","n",NULL,"MITZAV","מיצב","מצב",NULL,"MCB","MICB",NULL);
INSERT INTO hebrew_morpho VALUES (90828,"מַעֲמָד_חֶבְרָתִי","n",NULL,"MAAMAD_XEVRATI","מעמד_חברתי","מעמד_חברתי",NULL,"M&MD_XBRTI","M&MD_XBRTI",NULL);
INSERT INTO hebrew_morpho VALUES (90829,"צָב","n",NULL,"TZAV","צב","צב",NULL,"CB","CB",NULL);
INSERT INTO hebrew_morpho VALUES (94150,"צִמְחִיָּה","n",NULL,"tzimchiya","צמחייה","צמחיה",NULL,"CMXIH","CMXIIH",NULL);
INSERT INTO hebrew_morpho VALUES (90831,"בֻּיַּת","v",NULL,"BUYAT","בית","בית",NULL,"BIT","BIT",NULL);
INSERT INTO hebrew_morpho VALUES (90832,"אֻלַּף","v",NULL,"ULAF","אלף","אלף",NULL,"ALP","ALP",NULL);
INSERT INTO hebrew_morpho VALUES (90833,"הִצִּיב","v",NULL,"HICIV","הצב","הציב",NULL,"HCIB","HCB",NULL);
INSERT INTO hebrew_morpho VALUES (90834,"הֻצַּב","v",NULL,"HUCAV","הצב","הצב",NULL,"HCB","HCB",NULL);
INSERT INTO hebrew_morpho VALUES (90835,"חֹק","n",NULL,"XOK","חוק","חק",NULL,"XQ","XWQ",NULL);
INSERT INTO hebrew_morpho VALUES (90836,"אֲמִירָה","n",NULL,"AMIRA","אמירה","אמירה",NULL,"AMIRH","AMIRH",NULL);
INSERT INTO hebrew_morpho VALUES (90837,"אֶמִיר","n",NULL,"EMIR","אמיר","אמיר",NULL,"AMIR","AMIR",NULL);
INSERT INTO hebrew_morpho VALUES (90838,"אָמִיר","n",NULL,"AMIR","AMIR","אמיר",NULL,"AMIR",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (90839,"אָמַר","v",NULL,"AMAR","אמר","אמר",NULL,"AMR","AMR",NULL);
INSERT INTO hebrew_morpho VALUES (90840,"אֹמֶר","n",NULL,"OMER","אמר","אמר",NULL,"AMR","AMR",NULL);
INSERT INTO hebrew_morpho VALUES (90841,"בֵּית","n",NULL,"BET","בית","בית",NULL,"BIT","BIT",NULL);
INSERT INTO hebrew_morpho VALUES (90842,"עִיר_הָאָבוֹת","n",NULL,NULL,"עיר_האבות","עיר_האבות",NULL,"&IR_HABWT","&IR_HABWT",NULL);
INSERT INTO hebrew_morpho VALUES (90843,"שׁוֹשֶׁלֶת","n",NULL,"SHOSHELET","שושלת","שושלת",NULL,"$W$LT","$W$LT",NULL);
INSERT INTO hebrew_morpho VALUES (90844,"בַּיִת","n",NULL,NULL,NULL,"בית",NULL,"BIT",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (90845,"גִּיד","n",NULL,"GID","גיד","גיד",NULL,"GID","GID",NULL);
INSERT INTO hebrew_morpho VALUES (90846,"גִּלָּה","v",NULL,"GILA","גילה","גלה",NULL,"GLH","GILH",NULL);
INSERT INTO hebrew_morpho VALUES (90847,"גִּלָּה","v",NULL,"GILA","גלה","גלה",NULL,"GLH","GLH",NULL);
INSERT INTO hebrew_morpho VALUES (90848,"גָּאלָה","n",NULL,"GALA","גאלה","גאלה",NULL,"GALH","GALH",NULL);
INSERT INTO hebrew_morpho VALUES (90849,"גֻּלָּה","n",NULL,"GULA","גולה","גלה",NULL,"GLH","GWLH",NULL);
INSERT INTO hebrew_morpho VALUES (95191,"גִּזְבָּרִית","n",NULL,"gizbarit","גזברית","גִּזְבָּרִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (90851,"גֻּלָּה","n",NULL,NULL,NULL,"גלה",NULL,"GLH",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (90852,"דִּבֵּר","n",NULL,"DIBER","דיבר","דִּבֵּר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (90853,"דִּבֵּר","v",NULL,"DIBER","דיבר","דִּבֵּר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (90854,"דֵּעָה","n",NULL,"DEA","דעה","דעה",NULL,"D&H","D&H",NULL);
INSERT INTO hebrew_morpho VALUES (90855,"דָּבָר","n",NULL,"DAVAR","דבר","דָּבָר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (90856,"הִגִּיד","v",NULL,"HIGID","הגיד","הגיד",NULL,"HGID","HGID",NULL);
INSERT INTO hebrew_morpho VALUES (90857,"הֵמִיר","v",NULL,"HEMIR","המיר","המיר",NULL,"HMIR","HMIR",NULL);
INSERT INTO hebrew_morpho VALUES (90858,"הוֹרֶה","n",NULL,"HORE","הורה","הורה",NULL,"HWRH","HWRH",NULL);
INSERT INTO hebrew_morpho VALUES (90859,"הוֹרָה","v",NULL,"HORA","הורה","הורה",NULL,"HWRH","HWRH",NULL);
INSERT INTO hebrew_morpho VALUES (90860,"חִבֵּר","v",NULL,"XIBER","חיבר","חבר",NULL,"XBR","XIBR",NULL);
INSERT INTO hebrew_morpho VALUES (90861,"חֶבְרָה","n",NULL,"XEVRA","חברה","חברה",NULL,"XBRH","XBRH",NULL);
INSERT INTO hebrew_morpho VALUES (90862,"חֶשְׁבּוֹן-בַּנְק","n",NULL,"CHESHBON BANK","חשבון-בנק","חשבון-בנק",NULL,"X$BWN-BNQ","X$BWN-BNQ",NULL);
INSERT INTO hebrew_morpho VALUES (90863,"חָבֵר","n",NULL,"XAVER","חבר","חבר",NULL,"XBR","XBR",NULL);
INSERT INTO hebrew_morpho VALUES (90864,"חָבֵר","n",NULL,NULL,NULL,"חבר",NULL,"XBR",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (90865,"לֹא","r",NULL,"LO","לא","לא",NULL,"LA","LA",NULL);
INSERT INTO hebrew_morpho VALUES (90866,"מִנָּה","v",NULL,"MINA","מנה","מנה",NULL,"MNH","MNH",NULL);
INSERT INTO hebrew_morpho VALUES (90867,"מִנָּה","v",NULL,"MINA","מינה","מנה",NULL,"MNH","MINH",NULL);
INSERT INTO hebrew_morpho VALUES (90868,"מָנָה","n",NULL,"MANA","מנה","מנה",NULL,"MNH","MNH",NULL);
INSERT INTO hebrew_morpho VALUES (90869,"קָמֵעַ","n",NULL,"KAME\'AH","קמע","קמע",NULL,"QM&","QM&",NULL);
INSERT INTO hebrew_morpho VALUES (90870,"מָנָה","v",NULL,"MANA","מנה","מנה",NULL,"MNH","MNH",NULL);
INSERT INTO hebrew_morpho VALUES (90871,"סִפֵּר","v",NULL,"SIPER","סיפר","ספר",NULL,"SPR","SIPR",NULL);
INSERT INTO hebrew_morpho VALUES (90872,"סַפָּר","n",NULL,"SAFAR","ספר","ספר",NULL,"SPR","SPR",NULL);
INSERT INTO hebrew_morpho VALUES (90873,"סָפַר","v",NULL,"SAFAR","ספר","ספר",NULL,"SPR","SPR",NULL);
INSERT INTO hebrew_morpho VALUES (90874,"פְּרָס","n",NULL,"PRAS","פרס","פרס",NULL,"PRS","PRS",NULL);
INSERT INTO hebrew_morpho VALUES (90875,"פִּרְסֵם","v",NULL,"PIRSEM","פרסם","פרסם",NULL,"PRSM","PRSM",NULL);
INSERT INTO hebrew_morpho VALUES (90876,"פָּרַס","v",NULL,"PARAS","פרס","פרס",NULL,"PRS","PRS",NULL);
INSERT INTO hebrew_morpho VALUES (90877,"שִׁנָּה","v",NULL,NULL,"שנה","שנה",NULL,"$NH","$NH",NULL);
INSERT INTO hebrew_morpho VALUES (90878,"שֵׁנָה","n",NULL,"sheina","שינה","שנה",NULL,"$NH","$INH",NULL);
INSERT INTO hebrew_morpho VALUES (90879,"שָׁנָה","n",NULL,"shana","שנה","שנה",NULL,"$NH","$NH",NULL);
INSERT INTO hebrew_morpho VALUES (90880,"בֵּי&quot;ת","n",NULL,"BET","בי&quot;ת","בי&quot;ת",NULL,"BI&quot;T","BI&quot;T",NULL);
INSERT INTO hebrew_morpho VALUES (90881,"ג\'וּלָה","n",NULL,"JULA","ג\'ולה","ג\'ולה",NULL,"G\'WLH","G\'WLH",NULL);
INSERT INTO hebrew_morpho VALUES (90882,"אֲגַף","n",NULL,NULL,"אגף","אגף",NULL,"AGP","AGP",NULL);
INSERT INTO hebrew_morpho VALUES (95209,"חַיֶּלֶת","n",NULL,"chayelet","חיילת","חַיֶּלֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (90884,"אִי","n",NULL,NULL,"אי","אי",NULL,"AI","AI",NULL);
INSERT INTO hebrew_morpho VALUES (90885,"גּוּף","n",NULL,NULL,"גוף","גּוּף",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (90886,"אִישׁ","n",NULL,NULL,"איש","איש",NULL,"AI$","AI$",NULL);
INSERT INTO hebrew_morpho VALUES (90887,"אִמּוּן","n",NULL,NULL,"אימון","אמון",NULL,"AMWN","AIMWN",NULL);
INSERT INTO hebrew_morpho VALUES (90888,"אִפְשֵׁר","v",NULL,NULL,"איפשר","אפשר",NULL,"AP$R","AIP$R",NULL);
INSERT INTO hebrew_morpho VALUES (90889,"אִשּׁוּר","n",NULL,"ISHUR","אישור","אשור",NULL,"A$WR","AI$WR",NULL);
INSERT INTO hebrew_morpho VALUES (90890,"אֵבֶל","n",NULL,"EVEL","אבל","אבל",NULL,"ABL","ABL",NULL);
INSERT INTO hebrew_morpho VALUES (90891,"אֵזוֹר","n",NULL,NULL,"איזור","אזור",NULL,"AZWR","AIZWR",NULL);
INSERT INTO hebrew_morpho VALUES (90892,"אֵירוֹפִּי","a",NULL,NULL,"אירופי","אירופי",NULL,"AIRWPI","AIRWPI",NULL);
INSERT INTO hebrew_morpho VALUES (90893,"אֵירוֹפִּי","n",NULL,"eiropi","אירופי","אירופי",NULL,"AIRWPI","AIRWPI","male");
INSERT INTO hebrew_morpho VALUES (90894,"אֵל","n",NULL,NULL,"אל","אל",NULL,"AL","AL",NULL);
INSERT INTO hebrew_morpho VALUES (90895,"אֵלָה","n",NULL,NULL,"אלה","אלה",NULL,"ALH","ALH",NULL);
INSERT INTO hebrew_morpho VALUES (90896,"מְאֹרָע","n",NULL,NULL,"מאורע","מארע",NULL,"MAR&","MAWR&",NULL);
INSERT INTO hebrew_morpho VALUES (90897,"אֵרוּעַ","n",NULL,"eru\'ah","אירוע","ארוע",NULL,"ARW&","AIRW&",NULL);
INSERT INTO hebrew_morpho VALUES (90898,"לַהַט","n",NULL,NULL,"להט","להט",NULL,"LH@","LH@",NULL);
INSERT INTO hebrew_morpho VALUES (90899,"פַּסְיוֹן","n",NULL,NULL,"פסיון","פסיון",NULL,"PSIWN","PSIWN",NULL);
INSERT INTO hebrew_morpho VALUES (90900,"אֶזְרָח","n",NULL,"EZRACH","אזרח","אזרח",NULL,"AZRX","AZRX",NULL);
INSERT INTO hebrew_morpho VALUES (90901,"אֶזְרָחִי","a",NULL,"EZRAXI","אזרחי","אזרחי",NULL,"AZRXI","AZRXI",NULL);
INSERT INTO hebrew_morpho VALUES (90902,"אֶזְרָחִי","n",NULL,"EZRACHI","אזרחי","אזרחי",NULL,"AZRXI","AZRXI",NULL);
INSERT INTO hebrew_morpho VALUES (90903,"לִיטֶר","n",NULL,"LITER","ליטר","ליטר",NULL,"LI@R","LI@R",NULL);
INSERT INTO hebrew_morpho VALUES (90904,"אֶלֶף","n",NULL,"ELEF","אלף","אלף",NULL,"ALP","ALP",NULL);
INSERT INTO hebrew_morpho VALUES (90905,"מֻתָּר","a",NULL,NULL,"מותר","מתר",NULL,"MTR","MWTR",NULL);
INSERT INTO hebrew_morpho VALUES (90906,"אֶרֶץ","n",NULL,NULL,"ארץ","ארץ",NULL,"ARC","ARC",NULL);
INSERT INTO hebrew_morpho VALUES (90907,"עַרְבוּת","n",NULL,"ARVUT","ערבות","ערבות",NULL,"&RBWT","&RBWT",NULL);
INSERT INTO hebrew_morpho VALUES (90908,"אַחֲרָיוּת","n",NULL,"ACHARAYUT","אחריות","אחריות",NULL,"AXRIWT","AXRIWT",NULL);
INSERT INTO hebrew_morpho VALUES (90909,"לְבַסּוֹף","r",NULL,"LEVASOF","לבסוף","לבסוף",NULL,"LBSWP","LBSWP",NULL);
INSERT INTO hebrew_morpho VALUES (90910,"לָאַחֲרוֹנָה","r",NULL,NULL,"לאחרונה","לאחרונה",NULL,"LAXRWNH","LAXRWNH",NULL);
INSERT INTO hebrew_morpho VALUES (90911,"אַחֵר","a",NULL,NULL,"אחר","אחר",NULL,"AXR","AXR",NULL);
INSERT INTO hebrew_morpho VALUES (90912,"אַיִן","n",NULL,NULL,"אין","אין",NULL,"AIN","AIN",NULL);
INSERT INTO hebrew_morpho VALUES (90913,"אַלָּה","n",NULL,"ALA","אלה","אלה",NULL,"ALH","ALH",NULL);
INSERT INTO hebrew_morpho VALUES (90914,"אַרְגּוֹן","n",NULL,"ARGON","ארגון","ארגון",NULL,"ARGWN","ARGWN",NULL);
INSERT INTO hebrew_morpho VALUES (90915,"אָב","n",NULL,"ABBA","אב","אב",NULL,"AB","AB",NULL);
INSERT INTO hebrew_morpho VALUES (90916,"אָב_קַדְמוֹן","n",NULL,"AV KADMON","אב_קדמון","אב_קדמון",NULL,"AB_QDMWN","AB_QDMWN",NULL);
INSERT INTO hebrew_morpho VALUES (90917,"אָבֵל","n",NULL,NULL,"אבל","אבל",NULL,"ABL","ABL",NULL);
INSERT INTO hebrew_morpho VALUES (90918,"אָסַר","v",NULL,"asar","אסר","אָסַר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (90919,"הָאָדָם","n",NULL,NULL,"האדם","האדם",NULL,"HADM","HADM",NULL);
INSERT INTO hebrew_morpho VALUES (90920,"אַכְסַנְיָה","n",NULL,NULL,"אכסניה","אכסניה",NULL,"AKSNIH","AKSNIH",NULL);
INSERT INTO hebrew_morpho VALUES (90921,"אָדָם","n",NULL,NULL,"אדם","אדם",NULL,"ADM","ADM",NULL);
INSERT INTO hebrew_morpho VALUES (90922,"נַעֲרָץ","a",NULL,NULL,"נערץ","נערץ",NULL,"N&RC","N&RC",NULL);
INSERT INTO hebrew_morpho VALUES (90923,"הַבְחָנָה","n",NULL,"HAVCHANA","הבחנה","הבחנה",NULL,"HBXNH","HBXNH",NULL);
INSERT INTO hebrew_morpho VALUES (90924,"מֶלֶךְ-הַחַיּוֹת","n",NULL,"MELECH HACHAYOT","מלך-החיות","מלך-החיות",NULL,"MLK-HXIWT","MLK-HXIWT",NULL);
INSERT INTO hebrew_morpho VALUES (90925,"אָז","r",NULL,NULL,"אז","אז",NULL,"AZ","AZ",NULL);
INSERT INTO hebrew_morpho VALUES (90926,"אֲחָאִים","n",NULL,"ACHA\'IM","אחאים","אחאים",NULL,"AXAIM","AXAIM",NULL);
INSERT INTO hebrew_morpho VALUES (90927,"אָח","n",NULL,NULL,"אח","אח",NULL,"AX","AX",NULL);
INSERT INTO hebrew_morpho VALUES (90928,"מֻחְזָק","a",NULL,NULL,"מוחזק","מחזק",NULL,"MXZQ","MWXZQ",NULL);
INSERT INTO hebrew_morpho VALUES (90929,"אָחוּז","n",NULL,NULL,"אחוז","אחוז",NULL,"AXWZ","AXWZ",NULL);
INSERT INTO hebrew_morpho VALUES (90930,"אָכֵן","r",NULL,NULL,"אכן","אכן",NULL,"AKN","AKN",NULL);
INSERT INTO hebrew_morpho VALUES (90932,"אָלֶף","n",NULL,NULL,"אלף","אלף",NULL,"ALP","ALP",NULL);
INSERT INTO hebrew_morpho VALUES (90933,"מְאֵרָה","n",NULL,"ME\'ERA","מארה","מארה",NULL,"MARH","MARH",NULL);
INSERT INTO hebrew_morpho VALUES (90934,"אָמַן","v",NULL,NULL,"אמן","אמן",NULL,"AMN","AMN",NULL);
INSERT INTO hebrew_morpho VALUES (90935,"אָמָּן","n",NULL,NULL,"אומן","אמן",NULL,"AMN","AWMN",NULL);
INSERT INTO hebrew_morpho VALUES (90936,"אָמוּר","n",NULL,NULL,"אמור","אמור",NULL,"AMWR","AMWR",NULL);
INSERT INTO hebrew_morpho VALUES (90937,"שָׁבוּי","n",NULL,"shavuy","שבוי","שבוי",NULL,"$BWI","$BWI","male");
INSERT INTO hebrew_morpho VALUES (90938,"סִגְנוֹן","n",NULL,NULL,"סגנון","סגנון",NULL,"SGNWN","SGNWN",NULL);
INSERT INTO hebrew_morpho VALUES (90939,"אֹפֶן","n",NULL,NULL,"אופן","אפן",NULL,"APN","AWPN",NULL);
INSERT INTO hebrew_morpho VALUES (90940,"אוֹצֵר","n",NULL,NULL,"אוצר","אוצר",NULL,"AWCR","AWCR",NULL);
INSERT INTO hebrew_morpho VALUES (90941,"מַטְמוֹן","n",NULL,NULL,"מטמון","מטמון",NULL,"M@MWN","M@MWN",NULL);
INSERT INTO hebrew_morpho VALUES (90942,"דַּרְלִינג","n",NULL,NULL,"דרלינג","דרלינג",NULL,"DRLING","DRLING",NULL);
INSERT INTO hebrew_morpho VALUES (90943,"יַקִּיר","n",NULL,"YAKIR","יקיר","יקיר",NULL,"IQIR","IQIR",NULL);
INSERT INTO hebrew_morpho VALUES (90944,"אוֹצָר","n",NULL,NULL,"אוצר","אוצר",NULL,"AWCR","AWCR",NULL);
INSERT INTO hebrew_morpho VALUES (90945,"שֶׁמֶשׁ","n",NULL,NULL,"שמש","שמש",NULL,"$M$","$M$",NULL);
INSERT INTO hebrew_morpho VALUES (90946,"מְבוֹאָה","n",NULL,"MEVO\'AH","מבואה","מבואה",NULL,"MBWAH","MBWAH",NULL);
INSERT INTO hebrew_morpho VALUES (90947,"צִיּוּן","n",NULL,"TSIYUN","ציון","ציון",NULL,"CIWN","CIWN",NULL);
INSERT INTO hebrew_morpho VALUES (90948,"אוֹת","n",NULL,"OT","אות","אות",NULL,"AWT","AWT",NULL);
INSERT INTO hebrew_morpho VALUES (90949,"מְקֻלָּל","a",NULL,"MEKULAL","מקולל","מקלל",NULL,"MQLL","MQWLL",NULL);
INSERT INTO hebrew_morpho VALUES (90950,"אָרוּר","a",NULL,"ARUR","ארור","ארור",NULL,"ARWR","ARWR",NULL);
INSERT INTO hebrew_morpho VALUES (90951,"בְּדִיּוּק","r",NULL,"BEDIYUK","בדיוק","בדיוק",NULL,"BDIWQ","BDIWQ",NULL);
INSERT INTO hebrew_morpho VALUES (90952,"בִּמְדֻיָּק","r",NULL,"BIMDUYAK","במדויק","במדיק",NULL,"BMDIQ","BMDWIQ",NULL);
INSERT INTO hebrew_morpho VALUES (90953,"בְּדִיקָה","n",NULL,"BDIKA","בדיקה","בדיקה",NULL,"BDIQH","BDIQH",NULL);
INSERT INTO hebrew_morpho VALUES (90954,"בְּחִינָה","n",NULL,"BCHINA","בחינה","בחינה",NULL,"BXINH","BXINH",NULL);
INSERT INTO hebrew_morpho VALUES (90955,"שָׁלוֹם","n",NULL,"SHALOM","שלום","שלום",NULL,"$LWM","$LWM",NULL);
INSERT INTO hebrew_morpho VALUES (90956,"בְּחִירוֹת","n",NULL,"BCHIROT","בחירות","בחירות",NULL,"BXIRWT","BXIRWT",NULL);
INSERT INTO hebrew_morpho VALUES (90957,"בְּעָיָה","n",NULL,"BE\'AYA","בעיה","בעיה",NULL,"B&IH","B&IH",NULL);
INSERT INTO hebrew_morpho VALUES (90958,"בְּרִיאוּת","n",NULL,"BRI\'UT","בריאות","בריאות",NULL,"BRIAWT","BRIAWT",NULL);
INSERT INTO hebrew_morpho VALUES (90959,"בְּרִית","n",NULL,"BRIT","ברית","ברית",NULL,"BRIT","BRIT",NULL);
INSERT INTO hebrew_morpho VALUES (90960,"בִּטּוּל","n",NULL,"BITUL","ביטול","בטול",NULL,"B@WL","BI@WL",NULL);
INSERT INTO hebrew_morpho VALUES (90961,"בִּכְלָל","r",NULL,"BICHLAL","בכלל","בכלל",NULL,"BKLL","BKLL",NULL);
INSERT INTO hebrew_morpho VALUES (90962,"בִּלְבַד","r",NULL,"BILVAD","בלבד","בלבד",NULL,"BLBD","BLBD",NULL);
INSERT INTO hebrew_morpho VALUES (90963,"בִּמְיֻחָד","r",NULL,"BIMYUCHAD","במיוחד","במיחד",NULL,"BMIXD","BMIWXD",NULL);
INSERT INTO hebrew_morpho VALUES (90964,"בְּעִקָּר","r",NULL,"BE\'IKAR","בעיקר","בעקר",NULL,"B&QR","B&IQR",NULL);
INSERT INTO hebrew_morpho VALUES (90965,"עַד-מְאֹד","r",NULL,"AD-ME\'OD","עד-מאוד","עד-מאד",NULL,"&D-MAD","&D-MAWD",NULL);
INSERT INTO hebrew_morpho VALUES (90966,"בִּגְנֵבָה","r",NULL,"BIGNEVA","בגנבה","בגנבה",NULL,"BGNBH","BGNBH",NULL);
INSERT INTO hebrew_morpho VALUES (90967,"בִּנְיָן","n",NULL,"BINYAN","בניין","בנין",NULL,"BNIN","BNIIN",NULL);
INSERT INTO hebrew_morpho VALUES (90968,"הִתְבַּדְּחוּת","n",NULL,"HITBADCHUT","התבדחות","התבדחות",NULL,"HTBDXWT","HTBDXWT",NULL);
INSERT INTO hebrew_morpho VALUES (90969,"בִּצּוּעַ","n",NULL,"BITSU\'AH","ביצוע","בצוע",NULL,"BCW&","BICW&",NULL);
INSERT INTO hebrew_morpho VALUES (90970,"הֲלָצָה","n",NULL,"HALATSA","הלצה","הלצה",NULL,"HLCH","HLCH",NULL);
INSERT INTO hebrew_morpho VALUES (90971,"חוּץ","a",NULL,"CHUTZ","חוץ","חוץ",NULL,"XWC","XWC",NULL);
INSERT INTO hebrew_morpho VALUES (90972,"בְּגִידָה","n",NULL,"BGIDA","בגידה","בגידה",NULL,"BGIDH","BGIDH",NULL);
INSERT INTO hebrew_morpho VALUES (90973,"בֵּין-לְאֻמִּי","a",NULL,"BEIN-LEUMI","בין-לאומי","בין-לאמי",NULL,"BIN-LAMI","BIN-LAWMI",NULL);
INSERT INTO hebrew_morpho VALUES (90974,"בִּקֵּר","v",NULL,"BIKER","ביקר","בקר",NULL,"BQR","BIQR",NULL);
INSERT INTO hebrew_morpho VALUES (90975,"בִּקֵּשׁ","v",NULL,"BIKESH","ביקש","בקש",NULL,"BQ$","BIQ$",NULL);
INSERT INTO hebrew_morpho VALUES (90976,"בֵּינְלְאֻמִּי","a",NULL,"BEINLEUMI","בינלאומי","בינלאמי",NULL,"BINLAMI","BINLAWMI",NULL);
INSERT INTO hebrew_morpho VALUES (90977,"בֵּינְתַיִם","r",NULL,"BEYNTAYIM","בינתיים","בינתים",NULL,"BINTIM","BINTIIM",NULL);
INSERT INTO hebrew_morpho VALUES (90978,"עַכְשָׁו","r",NULL,"ACHSHAV","עכשיו","עכשו",NULL,"&K$W","&K$IW",NULL);
INSERT INTO hebrew_morpho VALUES (90979,"לְעֵת-עַתָּה","r",NULL,"LE\'ET ATA","לעת-עתה","לעת-עתה",NULL,"L&T-&TH","L&T-&TH",NULL);
INSERT INTO hebrew_morpho VALUES (90980,"מַדֵּי-בֵּית","n",NULL,"MADEI-BET","מדי-בית","מדי-בית",NULL,"MDI-BIT","MDI-BIT",NULL);
INSERT INTO hebrew_morpho VALUES (90981,"בֵּן","n",NULL,"BEN","בן","בן",NULL,"BN","BN",NULL);
INSERT INTO hebrew_morpho VALUES (90982,"הַבֵּן","n",NULL,"HABEN","הבן","הבן",NULL,"HBN","HBN",NULL);
INSERT INTO hebrew_morpho VALUES (90983,"נוֹקֵד","n",NULL,"NOKED","נוקד","נוקד",NULL,"NWQD","NWQD",NULL);
INSERT INTO hebrew_morpho VALUES (90984,"בֶּאֱמֶת","r",NULL,"BE\'EMET","באמת","באמת",NULL,"BAMT","BAMT",NULL);
INSERT INTO hebrew_morpho VALUES (90985,"אַשְׁכָּרָה","r",NULL,"ASHKARA","אשכרה","אשכרה",NULL,"A$KRH","A$KRH",NULL);
INSERT INTO hebrew_morpho VALUES (90986,"כִּלְכּוּל","n",NULL,"KILKUL","כלכול","כלכול",NULL,"KLKWL","KLKWL",NULL);
INSERT INTO hebrew_morpho VALUES (90987,"בֶּדֶק","n",NULL,"BEDEK","בדק","בדק",NULL,"BDQ","BDQ",NULL);
INSERT INTO hebrew_morpho VALUES (90988,"סוּמְסוּם","n",NULL,"SUMSUM","סומסום","סומסום",NULL,"SWMSWM","SWMSWM",NULL);
INSERT INTO hebrew_morpho VALUES (90989,"מִשְׁפָּחָה","n",NULL,"mishpachah","משפחה","מִשְׁפָּחָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (90990,"בַּעַל","n",NULL,"BA\'AL","בעל","בעל",NULL,"B&L","B&L",NULL);
INSERT INTO hebrew_morpho VALUES (90991,"בַּעַת","n",NULL,"BA\'AT","בעת","בעת",NULL,"B&T","B&T",NULL);
INSERT INTO hebrew_morpho VALUES (90992,"בַּקָּשָׁה","n",NULL,"BAKASHA","בקשה","בקשה",NULL,"BQ$H","BQ$H",NULL);
INSERT INTO hebrew_morpho VALUES (90993,"בַּת","n",NULL,"BAT","בת","בת",NULL,"BT","BT",NULL);
INSERT INTO hebrew_morpho VALUES (90994,"נִבְעָרוּת","n",NULL,"NIV\'ARUT","נבערות","נבערות",NULL,"NB&RWT","NB&RWT",NULL);
INSERT INTO hebrew_morpho VALUES (90995,"סָמוּךְ","a",NULL,"SAMUCH","סמוך","סמוך",NULL,"SMWK","SMWK",NULL);
INSERT INTO hebrew_morpho VALUES (90996,"בָּא","a",NULL,"BA","בא","בא",NULL,"BA","BA",NULL);
INSERT INTO hebrew_morpho VALUES (90997,"בָּא","v",NULL,"BA","בא","בא",NULL,"BA","BA",NULL);
INSERT INTO hebrew_morpho VALUES (90998,"נִסָּה","v",NULL,"NISSA","ניסה","נסה",NULL,"NSH","NISH",NULL);
INSERT INTO hebrew_morpho VALUES (90999,"בָּחַר","v",NULL,"BACHAR","בחר","בחר",NULL,"BXR","BXR",NULL);
INSERT INTO hebrew_morpho VALUES (91000,"בָּטוּחַ","a",NULL,"BATU\'ACH","בטוח","בטוח",NULL,"B@WX","B@WX",NULL);
INSERT INTO hebrew_morpho VALUES (91001,"בָּכִיר","a",NULL,"BACHIR","בכיר","בכיר",NULL,"BKIR","BKIR",NULL);
INSERT INTO hebrew_morpho VALUES (91002,"סִוֵּג","v",NULL,"SIVEG","סיווג","סוג",NULL,"SWG","SIWWG",NULL);
INSERT INTO hebrew_morpho VALUES (91003,"בָּרָק","n",NULL,"BARAK","ברק","ברק",NULL,"BRQ","BRQ",NULL);
INSERT INTO hebrew_morpho VALUES (91004,"בָּסִיס","n",NULL,"BASIS","בסיס","בסיס",NULL,"BSIS","BSIS",NULL);
INSERT INTO hebrew_morpho VALUES (91005,"עָשָׂה-אַהֲבָה","v",NULL,"ASSA AHAVA","עשה-אהבה","עשה-אהבה",NULL,"&$H-AHBH","&$H-AHBH",NULL);
INSERT INTO hebrew_morpho VALUES (91006,"בָּרַר","v",NULL,"BARAR","ברר","ברר",NULL,"BRR","BRR",NULL);
INSERT INTO hebrew_morpho VALUES (91007,"בּוּרְסָה","n",NULL,"BURSA","בורסה","בורסה",NULL,"BWRSH","BWRSH",NULL);
INSERT INTO hebrew_morpho VALUES (91008,"גְּבוּל","n",NULL,"GVUL","גבול","גבול",NULL,"GBWL","GBWL",NULL);
INSERT INTO hebrew_morpho VALUES (91009,"קָצֶה","n",NULL,"KATZE","קצה","קצה",NULL,"QCH","QCH",NULL);
INSERT INTO hebrew_morpho VALUES (91010,"קַו-גְּבוּל","n",NULL,"KAV-GVUL","קו-גבול","קו-גבול",NULL,"QW-GBWL","QW-GBWL",NULL);
INSERT INTO hebrew_morpho VALUES (91011,"גְּרָם","n",NULL,"GRAM","גרם","גרם",NULL,"GRM","GRM",NULL);
INSERT INTO hebrew_morpho VALUES (91012,"גִּישָׁה","n",NULL,"GISHA","גישה","גישה",NULL,"GI$H","GI$H",NULL);
INSERT INTO hebrew_morpho VALUES (91013,"גָּמַר","v",NULL,"GAMAR","גמר","גמר",NULL,"GMR","GMR",NULL);
INSERT INTO hebrew_morpho VALUES (91014,"הִשְׁתַּלֵּט","v",NULL,"HISHTALET","השתלט","השתלט",NULL,"H$TL@","H$TL@",NULL);
INSERT INTO hebrew_morpho VALUES (91015,"הִתְגַּבֵּר","v",NULL,"hitgaber","התגבר","התגבר",NULL,"HTGBR","HTGBR",NULL);
INSERT INTO hebrew_morpho VALUES (91016,"הִתְנַזֵּר","v",NULL,"HITNAZER","התנזר","התנזר",NULL,"HTNZR","HTNZR",NULL);
INSERT INTO hebrew_morpho VALUES (91017,"גֶּבֶר","n",NULL,"GEVER","גבר","גבר",NULL,"GBR","GBR",NULL);
INSERT INTO hebrew_morpho VALUES (91018,"עֲרֵמָה","n",NULL,"AREMA","ערימה","ערמה",NULL,"&RMH","&RIMH",NULL);
INSERT INTO hebrew_morpho VALUES (91019,"גַּל","n",NULL,"GAL","גל","גל",NULL,"GL","GL",NULL);
INSERT INTO hebrew_morpho VALUES (91020,"גַּם","r",NULL,"GAM","גם","גם",NULL,"GM","GM",NULL);
INSERT INTO hebrew_morpho VALUES (91021,"בְּנוֹסָף","r",NULL,"BENOSAF","בנוסף","בנוסף",NULL,"BNWSP","BNWSP",NULL);
INSERT INTO hebrew_morpho VALUES (91022,"יָתֵר-עַל-כֵּן","r",NULL,"YATER-AL-KEN","יתר-על-כן","יתר-על-כן",NULL,"ITR-&L-KN","ITR-&L-KN",NULL);
INSERT INTO hebrew_morpho VALUES (91023,"גָּדַל","v",NULL,"GADAL","גדל","גדל",NULL,"GDL","GDL",NULL);
INSERT INTO hebrew_morpho VALUES (91024,"רְחַב-לֵב","a",NULL,NULL,"רחב-לב","רחב-לב",NULL,"RXB-LB","RXB-LB",NULL);
INSERT INTO hebrew_morpho VALUES (91025,"גָּדוֹל","a",NULL,"GADOL","גדול","גדול",NULL,"GDWL","GDWL",NULL);
INSERT INTO hebrew_morpho VALUES (91026,"רַב-הַשְׁפָּעָה","a",NULL,"RAV-HASHPA\'AH","רב-השפעה","רב-השפעה",NULL,"RB-H$P&H","RB-H$P&H",NULL);
INSERT INTO hebrew_morpho VALUES (91027,"מְהֻלָּל","a",NULL,"MEHULAL","מהולל","מהלל",NULL,"MHLL","MHWLL",NULL);
INSERT INTO hebrew_morpho VALUES (91028,"חָלַף","v",NULL,"CHALAF","חלף","חלף",NULL,"XLP","XLP",NULL);
INSERT INTO hebrew_morpho VALUES (91029,"גָּרַם","v",NULL,"GARAM","גרם","גרם",NULL,"GRM","GRM",NULL);
INSERT INTO hebrew_morpho VALUES (91030,"גּוֹרֵם","n",NULL,"GOREM","גורם","גורם",NULL,"GWRM","GWRM",NULL);
INSERT INTO hebrew_morpho VALUES (91031,"מָקוֹר","n",NULL,"MAKOR","מקור","מקור",NULL,"MQWR","MQWR",NULL);
INSERT INTO hebrew_morpho VALUES (91032,"גּוּר","n",NULL,"GOOR","גור","גור",NULL,"GWR","GWR",NULL);
INSERT INTO hebrew_morpho VALUES (91033,"גּוֹרָל","n",NULL,"GORAL","גורל","גורל",NULL,"GWRL","GWRL",NULL);
INSERT INTO hebrew_morpho VALUES (91034,"דַּקּוּת","n",NULL,"DAKUT","דקות","דקות",NULL,"DQWT","DQWT",NULL);
INSERT INTO hebrew_morpho VALUES (91035,"דָּרַשׁ","v",NULL,"DARASH","דרש","דרש",NULL,"DR$","DR$",NULL);
INSERT INTO hebrew_morpho VALUES (91036,"אַנְתְּרוֹפּוֹמוֹרְפִיזְם","n",NULL,"ANTROPOMORFIZM","אנתרופומורפיזם","אנתרופומורפיזם",NULL,"ANTRWPWMWRPIZM","ANTRWPWMWRPIZM",NULL);
INSERT INTO hebrew_morpho VALUES (91037,"הֲלִיךְ","n",NULL,"HALICH","הליך","הליך",NULL,"HLIK","HLIK",NULL);
INSERT INTO hebrew_morpho VALUES (91038,"הִבְטִיחַ","v",NULL,"HIVTI\'ACH","הבטיח","הבטיח",NULL,"HB@IX","HB@IX",NULL);
INSERT INTO hebrew_morpho VALUES (91039,"הִבִּיעַ","v",NULL,"HIBI\'AH","הביע","הביע",NULL,"HBI&","HBI&",NULL);
INSERT INTO hebrew_morpho VALUES (91040,"הִכְרִיז","v",NULL,"HICHRIZ","הכריז","הכריז",NULL,"HKRIZ","HKRIZ",NULL);
INSERT INTO hebrew_morpho VALUES (91041,"הִסְבִּיר","v",NULL,"HISBIR","הסביר","הסביר",NULL,"HSBIR","HSBIR",NULL);
INSERT INTO hebrew_morpho VALUES (91042,"הִסְכִּים","v",NULL,"HISKIM","הסכים","הסכים",NULL,"HSKIM","HSKIM",NULL);
INSERT INTO hebrew_morpho VALUES (91043,"הִסְפִּיק","v",NULL,"HISPIK","הספיק","הספיק",NULL,"HSPIQ","HSPIQ",NULL);
INSERT INTO hebrew_morpho VALUES (91044,"הִפְסִיק","v",NULL,"HIFSIK","הפסיק","הפסיק",NULL,"HPSIQ","HPSIQ",NULL);
INSERT INTO hebrew_morpho VALUES (91045,"קָרָה","v",NULL,"KARA","קרה","קרה",NULL,"QRH","QRH",NULL);
INSERT INTO hebrew_morpho VALUES (91046,"הִצִּיעַ","v",NULL,"HITZI\'AH","הציע","הציע",NULL,"HCI&","HCI&",NULL);
INSERT INTO hebrew_morpho VALUES (91047,"הִרְגִּישׁ","v",NULL,"HIRGISH","הרגיש","הרגיש",NULL,"HRGI$","HRGI$",NULL);
INSERT INTO hebrew_morpho VALUES (91048,"הִשִּׂיג","v",NULL,"HISSIG","הישיג","השיג",NULL,"H$IG","HI$IG",NULL);
INSERT INTO hebrew_morpho VALUES (91049,"הִשְׁקִיעַ","v",NULL,"HISHKI\'AH","השקיע","השקיע",NULL,"H$QI&","H$QI&",NULL);
INSERT INTO hebrew_morpho VALUES (91050,"הִתְחִיל","v",NULL,"HITCHIL","התחיל","התחיל",NULL,"HTXIL","HTXIL",NULL);
INSERT INTO hebrew_morpho VALUES (91051,"הִתְמוֹדֵד","v",NULL,"HITMODED","התמודד","התמודד",NULL,"HTMWDD","HTMWDD",NULL);
INSERT INTO hebrew_morpho VALUES (91052,"הִתְקַיֵּם","v",NULL,"HITKAYEM","התקיים","התקים",NULL,"HTQIM","HTQIIM",NULL);
INSERT INTO hebrew_morpho VALUES (91053,"שָׂרַד","v",NULL,"SARAD","שרד","שרד",NULL,"$RD","$RD",NULL);
INSERT INTO hebrew_morpho VALUES (91054,"הִתְרַחֵשׁ","v",NULL,"HITRACHESH","התרחש","התרחש",NULL,"HTRX$","HTRX$",NULL);
INSERT INTO hebrew_morpho VALUES (91055,"הֵגִיב","v",NULL,"HEGIV","הגיב","הגיב",NULL,"HGIB","HGIB",NULL);
INSERT INTO hebrew_morpho VALUES (91056,"הֵצִיף","v",NULL,"HETZIF","הציף","הציף",NULL,"HCIP","HCIP",NULL);
INSERT INTO hebrew_morpho VALUES (91057,"הֵקִים","v",NULL,"HEKIM","הקים","הקים",NULL,"HQIM","HQIM",NULL);
INSERT INTO hebrew_morpho VALUES (91058,"הֶאֱמִין_בְּ","v",NULL,"HE\'EMIN_BE","האמין_ב","האמין_ב",NULL,"HAMIN_B","HAMIN_B",NULL);
INSERT INTO hebrew_morpho VALUES (91059,"הֵכִיל","v",NULL,"HECHIL","הכיל","הכיל",NULL,"HKIL","HKIL",NULL);
INSERT INTO hebrew_morpho VALUES (91060,"הֶעֱבִיר","v",NULL,"HE\'EVIR","העביר","העביר",NULL,"H&BIR","H&BIR",NULL);
INSERT INTO hebrew_morpho VALUES (91061,"הֶעֱרִיךְ","v",NULL,"HE\'ERICH","העריך","העריך",NULL,"H&RIK","H&RIK",NULL);
INSERT INTO hebrew_morpho VALUES (91062,"הֶפֶךְ","n",NULL,"HEFECH","הפך","הפך",NULL,"HPK","HPK",NULL);
INSERT INTO hebrew_morpho VALUES (91063,"הֶקֵּף","n",NULL,"HEKEF","היקף","הקף",NULL,"HQP","HIQP",NULL);
INSERT INTO hebrew_morpho VALUES (91064,"כּוֹחַ-הַכְּבִידָה","n",NULL,"CO\'ACH HAKVIDA","כוח-הכבידה","כוח-הכבידה",NULL,"KWX-HKBIDH","KWX-HKBIDH",NULL);
INSERT INTO hebrew_morpho VALUES (91065,"הֶרְכֵּב","n",NULL,"HERKEV","הרכב","הרכב",NULL,"HRKB","HRKB",NULL);
INSERT INTO hebrew_morpho VALUES (91066,"הַיּוֹם","r",NULL,"HAYOM","היום","היום",NULL,"HIWM","HIWM",NULL);
INSERT INTO hebrew_morpho VALUES (91067,"הַכְנָסָה","n",NULL,"HACHNASA","הכנסה","הכנסה",NULL,"HKNSH","HKNSH",NULL);
INSERT INTO hebrew_morpho VALUES (91068,"פוֹבְּיָה","n",NULL,"FOBIA","פוביה","פוביה",NULL,"PWBIH","PWBIH",NULL);
INSERT INTO hebrew_morpho VALUES (91069,"הַצָּעָה","n",NULL,"HATZA\'AH","הצעה","הצעה",NULL,"HC&H","HC&H",NULL);
INSERT INTO hebrew_morpho VALUES (91070,"הַצָּעַת-נִשּׂוּאִין","n",NULL,"HATZA\'AT-NISU\'IN","הצעת-נישואין","הצעת-נשואין",NULL,"HC&T-N$WAIN","HC&T-NI$WAIN",NULL);
INSERT INTO hebrew_morpho VALUES (91071,"הַר","n",NULL,"HAR","הר","הר",NULL,"HR","HR",NULL);
INSERT INTO hebrew_morpho VALUES (91072,"בְּיוֹתֵר","r",NULL,"BEYOTER","ביותר","ביותר",NULL,"BIWTR","BIWTR",NULL);
INSERT INTO hebrew_morpho VALUES (91073,"מְאוֹד-מְאוֹד","r",NULL,"ME\'OD ME\'OD","מאוד-מאוד","מאוד-מאוד",NULL,"MAWD-MAWD","MAWD-MAWD",NULL);
INSERT INTO hebrew_morpho VALUES (91074,"הַשְׁקָעָה","n",NULL,"HASHKA\'AH","השקעה","השקעה",NULL,"H$Q&H","H$Q&H",NULL);
INSERT INTO hebrew_morpho VALUES (91075,"הָפַךְ","v",NULL,"HAFACH","הפך","הפך",NULL,"HPK","HPK",NULL);
INSERT INTO hebrew_morpho VALUES (91076,"הוֹדָעָה","n",NULL,"HODA\'AH","הודעה","הודעה",NULL,"HWD&H","HWD&H",NULL);
INSERT INTO hebrew_morpho VALUES (91077,"הוֹכִיחַ","v",NULL,"HOCHI\'ACH","הוכיח","הוכיח",NULL,"HWKIX","HWKIX",NULL);
INSERT INTO hebrew_morpho VALUES (91078,"הוֹצָאָה","n",NULL,"HOTZA\'AH","הוצאה","הוצאה",NULL,"HWCAH","HWCAH",NULL);
INSERT INTO hebrew_morpho VALUES (91079,"הוֹרִיד","v",NULL,"HORID","הוריד","הוריד",NULL,"HWRID","HWRID",NULL);
INSERT INTO hebrew_morpho VALUES (91080,"וַעֲדָה","n",NULL,"VA\'ADA","ועדה","ועדה",NULL,"W&DH","W&DH",NULL);
INSERT INTO hebrew_morpho VALUES (91081,"וָתִיק","a",NULL,"VATIK","ותיק","ותיק",NULL,"WTIQ","WTIQ",NULL);
INSERT INTO hebrew_morpho VALUES (91082,"זְמַן","n",NULL,"ZMAN","זמן","זמן",NULL,"ZMN","ZMN",NULL);
INSERT INTO hebrew_morpho VALUES (91083,"זֵכֶר","n",NULL,"ZECHER","זכר","זכר",NULL,"ZKR","ZKR",NULL);
INSERT INTO hebrew_morpho VALUES (91084,"זֵר","n",NULL,"ZER","זר","זר",NULL,"ZR","ZR",NULL);
INSERT INTO hebrew_morpho VALUES (91085,"בְּהִירוּת","n",NULL,"BEHIRUT","בהירות","בהירות",NULL,"BHIRWT","BHIRWT",NULL);
INSERT INTO hebrew_morpho VALUES (91086,"לָקַח-בְּחֶשְׁבּוֹן","v",NULL,"LAKACH BECHESHBON","לקח-בחשבון","לקח-בחשבון",NULL,"LQX-BX$BWN","LQX-BX$BWN",NULL);
INSERT INTO hebrew_morpho VALUES (91087,"אָלֶכְּסָנְדֶר-בֶּל","n",NULL,"ALEXANDER BEL","אלכסנדר-בל","אלכסנדר-בל",NULL,"ALKSNDR-BL","ALKSNDR-BL",NULL);
INSERT INTO hebrew_morpho VALUES (91088,"זוּג","n",NULL,"ZUG","זוג","זוג",NULL,"ZWG","ZWG",NULL);
INSERT INTO hebrew_morpho VALUES (91089,"חֲבֵרוּת","n",NULL,"CHAVERUT","חברות","חברות",NULL,"XBRWT","XBRWT",NULL);
INSERT INTO hebrew_morpho VALUES (91090,"חֲקִירָה","n",NULL,"CHAKIRA","חקירה","חקירה",NULL,"XQIRH","XQIRH",NULL);
INSERT INTO hebrew_morpho VALUES (91091,"חֲשָׁשׁ","n",NULL,"CHASHASH","חשש","חשש",NULL,"X$$","X$$",NULL);
INSERT INTO hebrew_morpho VALUES (91092,"חִיֵּב","v",NULL,"CHIYEV","חייב","חיב",NULL,"XIB","XIIB",NULL);
INSERT INTO hebrew_morpho VALUES (91093,"הִצְרִיךְ","v",NULL,"HITSRICH","הצריך","הצריך",NULL,"HCRIK","HCRIK",NULL);
INSERT INTO hebrew_morpho VALUES (91094,"הִרְשִׁיעַ","v",NULL,"HIRSHI\'AH","הרשיע","הרשיע",NULL,"HR$I&","HR$I&",NULL);
INSERT INTO hebrew_morpho VALUES (91095,"חִלֵּק","v",NULL,"CHILEK","חילק","חלק",NULL,"XLQ","XILQ",NULL);
INSERT INTO hebrew_morpho VALUES (91096,"חִפֵּשׂ","v",NULL,"CHIPES","חיפש","חפש",NULL,"XP$","XIP$",NULL);
INSERT INTO hebrew_morpho VALUES (91097,"מַזָּל","n",NULL,"MAZAL","מזל","מזל",NULL,"MZL","MZL",NULL);
INSERT INTO hebrew_morpho VALUES (91098,"חֵלֶק","n",NULL,"CHELEK","חלק","חלק",NULL,"XLQ","XLQ",NULL);
INSERT INTO hebrew_morpho VALUES (91099,"בְּצַוְתָּא","n",NULL,"BETSAVTA","בצוותא","בצותא",NULL,"BCWTA","BCWWTA",NULL);
INSERT INTO hebrew_morpho VALUES (91100,"חַמָּנִיָּה","n",NULL,"CHAMANIYA","חמניה","חמניה",NULL,"XMNIH","XMNIH",NULL);
INSERT INTO hebrew_morpho VALUES (91101,"חֶדֶר","n",NULL,"CHEDER","חדר","חדר",NULL,"XDR","XDR",NULL);
INSERT INTO hebrew_morpho VALUES (91102,"מָתֶמָטִיקָה","n",NULL,"MATEMATICA","מתמטיקה","מתמטיקה",NULL,"MTM@IQH","MTM@IQH",NULL);
INSERT INTO hebrew_morpho VALUES (91103,"חֶשְׁבּוֹן","n",NULL,"CHESHBON","חשבון","חשבון",NULL,"X$BWN","X$BWN",NULL);
INSERT INTO hebrew_morpho VALUES (91104,"חַי","a",NULL,"CHAI","חי","חי",NULL,"XI","XI",NULL);
INSERT INTO hebrew_morpho VALUES (91105,"חַי","n",NULL,"CHAI","חי","חי",NULL,"XI","XI",NULL);
INSERT INTO hebrew_morpho VALUES (91106,"בַּעַל-חַיִּים","n",NULL,"BA\'AL-CHAIM","בעל-חיים","בעל-חיים",NULL,"B&L-XIIM","B&L-XIIM",NULL);
INSERT INTO hebrew_morpho VALUES (91107,"סִגְנוֹן-חַיִּים","n",NULL,"SIGNON CHAYIM","סגנון-חיים","סגנון-חיים",NULL,"SGNWN-XIIM","SGNWN-XIIM",NULL);
INSERT INTO hebrew_morpho VALUES (91108,"מְגֻנֶּה","a",NULL,"MEGUNEH","מגונה","מגנה",NULL,"MGNH","MGWNH",NULL);
INSERT INTO hebrew_morpho VALUES (91109,"חַיָּב","n",NULL,"CHAYAV","חייב","חיב",NULL,"XIB","XIIB",NULL);
INSERT INTO hebrew_morpho VALUES (91110,"חָזַר","v",NULL,"CHAZAR","חזר","חזר",NULL,"XZR","XZR",NULL);
INSERT INTO hebrew_morpho VALUES (91111,"חָזָק","r",NULL,"CHAZAK","חזק","חזק",NULL,"XZQ","XZQ",NULL);
INSERT INTO hebrew_morpho VALUES (91112,"חָלָק","a",NULL,"CHALAK","חלק","חלק",NULL,"XLQ","XLQ",NULL);
INSERT INTO hebrew_morpho VALUES (91113,"חָלוּץ","n",NULL,"CHALUTZ","חלוץ","חלוץ",NULL,"XLWC","XLWC",NULL);
INSERT INTO hebrew_morpho VALUES (91114,"חֵיל-חָלוּץ","n",NULL,"CHEYL CHALUTZ","חיל-חלוץ","חיל-חלוץ",NULL,"XIL-XLWC","XIL-XLWC",NULL);
INSERT INTO hebrew_morpho VALUES (91115,"חָסֵר","a",NULL,"CHASSER","חסר","חסר",NULL,"XSR","XSR",NULL);
INSERT INTO hebrew_morpho VALUES (91116,"מִינוּס","a",NULL,"MINUS","מינוס","מינוס",NULL,"MINWS","MINWS",NULL);
INSERT INTO hebrew_morpho VALUES (91117,"חָפְשִׁי","a",NULL,"CHOFSHI","חופשי","חפשי",NULL,"XP$I","XWP$I",NULL);
INSERT INTO hebrew_morpho VALUES (91118,"חָפְשִׁי","r",NULL,"CHOFSHI","חופשי","חפשי",NULL,"XP$I","XWP$I",NULL);
INSERT INTO hebrew_morpho VALUES (91119,"חָשַׁב","v",NULL,"XASHAV","חשב","חשב",NULL,"X$B","X$B",NULL);
INSERT INTO hebrew_morpho VALUES (91120,"חָשׁוּב","a",NULL,"CHASHUV","חשוב","חשוב",NULL,"X$WB","X$WB",NULL);
INSERT INTO hebrew_morpho VALUES (91121,"חָתַם","v",NULL,"CHATAM","חתם","חתם",NULL,"XTM","XTM",NULL);
INSERT INTO hebrew_morpho VALUES (91122,"חֹדֶשׁ","n",NULL,"CHODESH","חודש","חדש",NULL,"XD$","XWD$",NULL);
INSERT INTO hebrew_morpho VALUES (91123,"חֹמֶר","n",NULL,"CHOMER","חומר","חמר",NULL,"XMR","XWMR",NULL);
INSERT INTO hebrew_morpho VALUES (91124,"מַחְסוֹר","n",NULL,"MACHSOR","מחסור","מחסור",NULL,"MXSWR","MXSWR",NULL);
INSERT INTO hebrew_morpho VALUES (91125,"רָעָב","n",NULL,"RA\'AV","רעב","רעב",NULL,"R&B","R&B",NULL);
INSERT INTO hebrew_morpho VALUES (91126,"חוֹלֶה","n",NULL,"CHOLEH","חולה","חולה",NULL,"XWLH","XWLH",NULL);
INSERT INTO hebrew_morpho VALUES (91127,"טֶכְנוֹלוֹגְיָה","n",NULL,"TECHNOLOGYA","טכנולוגיה","טכנולוגיה",NULL,"@KNWLWGIH","@KNWLWGIH",NULL);
INSERT INTO hebrew_morpho VALUES (91128,"טֶלֶוִיזְיָה","n",NULL,"TELEVIZYA","טלוויזיה","טלויזיה",NULL,"@LWIZIH","@LWWIZIH",NULL);
INSERT INTO hebrew_morpho VALUES (91129,"טֶלֶפוֹן","n",NULL,"TELEFON","טלפון","טלפון",NULL,"@LPWN","@LPWN",NULL);
INSERT INTO hebrew_morpho VALUES (91130,"טָעַן","v",NULL,"TA\'AN","טען","טען",NULL,"@&N","@&N",NULL);
INSERT INTO hebrew_morpho VALUES (91131,"טָעוּת","n",NULL,"TA\'UT","טעות","טעות",NULL,"@&WT","@&WT",NULL);
INSERT INTO hebrew_morpho VALUES (91132,"טוֹב","a",NULL,"TOV","טוב","טוב",NULL,"@WB","@WB",NULL);
INSERT INTO hebrew_morpho VALUES (91133,"טוֹב","r",NULL,"TOV","טוב","טוב",NULL,"@WB","@WB",NULL);
INSERT INTO hebrew_morpho VALUES (91134,"טוֹב","n",NULL,"TOV","טוב","טוב",NULL,"@WB","@WB",NULL);
INSERT INTO hebrew_morpho VALUES (91135,"טוּב","n",NULL,"TUV","טוב","טוב",NULL,"@WB","@WB",NULL);
INSERT INTO hebrew_morpho VALUES (91136,"יְדִיעָה","n",NULL,"YEDI\'AH","ידיעה","ידיעה",NULL,"IDI&H","IDI&H",NULL);
INSERT INTO hebrew_morpho VALUES (91137,"יְהוּדִי","a",NULL,"YEHUDI","יהודי","יהודי",NULL,"IHWDI","IHWDI",NULL);
INSERT INTO hebrew_morpho VALUES (91138,"יְהוּדִי","n",NULL,"YEHUDI","יהודי","יהודי",NULL,"IHWDI","IHWDI",NULL);
INSERT INTO hebrew_morpho VALUES (91139,"יְכֹלֶת","n",NULL,"YEXOLET","יכולת","יכלת",NULL,"IKLT","IKWLT",NULL);
INSERT INTO hebrew_morpho VALUES (91140,"תַּחְזוּקָה","n",NULL,"TACHZUKA","תחזוקה","תחזוקה",NULL,"TXZWQH","TXZWQH",NULL);
INSERT INTO hebrew_morpho VALUES (91141,"יְרִידָה","n",NULL,"YERIDA","ירידה","ירידה",NULL,"IRIDH","IRIDH",NULL);
INSERT INTO hebrew_morpho VALUES (91142,"יִצּוּר","n",NULL,"YITZUR","ייצור","יצור",NULL,"ICWR","IICWR",NULL);
INSERT INTO hebrew_morpho VALUES (91143,"יִשְׂרְאֵלִי","a",NULL,"YISRA\'ELI","ישראלי","ישראלי",NULL,"I$RALI","I$RALI",NULL);
INSERT INTO hebrew_morpho VALUES (91144,"יִשְׂרְאֵלִי","n",NULL,"YISRA\'ELI","ישראלי","ישראלי",NULL,"I$RALI","I$RALI",NULL);
INSERT INTO hebrew_morpho VALUES (91145,"יִתְרוֹן","n",NULL,"YITRON","יתרון","יתרון",NULL,"ITRWN","ITRWN",NULL);
INSERT INTO hebrew_morpho VALUES (91146,"יִתָּכֵן","r",NULL,NULL,"יתכן","יתכן",NULL,"ITKN","ITKN",NULL);
INSERT INTO hebrew_morpho VALUES (91147,"יֵשׁ","r",NULL,"YESH","יש","יש",NULL,"I$","I$",NULL);
INSERT INTO hebrew_morpho VALUES (91148,"יֶלֶד","n",NULL,"YELED","ילד","ילד",NULL,"ILD","ILD",NULL);
INSERT INTO hebrew_morpho VALUES (91149,"רוֹעֶה","n",NULL,"RO\'EH","רועה","רועה",NULL,"RW&H","RW&H",NULL);
INSERT INTO hebrew_morpho VALUES (91150,"דַּרְדַּק","n",NULL,"DARDAK","דרדק","דרדק",NULL,"DRDQ","DRDQ",NULL);
INSERT INTO hebrew_morpho VALUES (91151,"יַנּוּקָא","n",NULL,"YANUKA","ינוקא","ינוקא",NULL,"INWQA","INWQA",NULL);
INSERT INTO hebrew_morpho VALUES (91152,"זוֹנַת-רְחוֹב","n",NULL,"ZONAT-REXOV","זונת-רחוב","זונת-רחוב",NULL,"ZWNT-RXWB","ZWNT-RXWB",NULL);
INSERT INTO hebrew_morpho VALUES (91153,"יֶן","n",NULL,"YEN","ין","ין",NULL,"IN","IN",NULL);
INSERT INTO hebrew_morpho VALUES (91154,"יַחַס","n",NULL,"YAXAS","יחס","יחס",NULL,"IXS","IXS",NULL);
INSERT INTO hebrew_morpho VALUES (91155,"יַעַד","n",NULL,"YA\'AD","יעד","יעד",NULL,"I&D","I&D",NULL);
INSERT INTO hebrew_morpho VALUES (91156,"יַצְרָן","n",NULL,"YATZRAN","יצרן","יצרן",NULL,"ICRN","ICRN",NULL);
INSERT INTO hebrew_morpho VALUES (91157,"גַּפָּה-קִדְמִית","n",NULL,"GAPA-KIDMIT","גפה-קדמית","גפה-קדמית",NULL,"GPH-QDMIT","GPH-QDMIT",NULL);
INSERT INTO hebrew_morpho VALUES (91158,"יָד","n",NULL,"YAD","יד","יד",NULL,"ID","ID",NULL);
INSERT INTO hebrew_morpho VALUES (91159,"יָדוּעַ","a",NULL,"YADU\'AH","ידוע","ידוע",NULL,"IDW&","IDW&",NULL);
INSERT INTO hebrew_morpho VALUES (91160,"יָחִיד","n",NULL,"YACHID","יחיד","יחיד",NULL,"IXID","IXID",NULL);
INSERT INTO hebrew_morpho VALUES (91161,"יָם","n",NULL,"YAM","ים","ים",NULL,"IM","IM",NULL);
INSERT INTO hebrew_morpho VALUES (91162,"יָמִין","n",NULL,"YAMIN","ימין","ימין",NULL,"IMIN","IMIN",NULL);
INSERT INTO hebrew_morpho VALUES (91163,"יָרַד","v",NULL,"YARAD","ירד","ירד",NULL,"IRD","IRD",NULL);
INSERT INTO hebrew_morpho VALUES (91164,"הִצְטַמְצֵם","v",NULL,"HITZTAMTZEM","הצטמצם","הצטמצם",NULL,"HC@MCM","HC@MCM",NULL);
INSERT INTO hebrew_morpho VALUES (91165,"יָשַׁב","v",NULL,"YASHAV","ישב","ישב",NULL,"I$B","I$B",NULL);
INSERT INTO hebrew_morpho VALUES (91166,"יוֹעֵץ","n",NULL,"YO\'ETZ","יועץ","יועץ",NULL,"IW&C","IW&C",NULL);
INSERT INTO hebrew_morpho VALUES (91167,"כִי","n",NULL,"CHI","כי","כי",NULL,"KI","KI",NULL);
INSERT INTO hebrew_morpho VALUES (91168,"כְּבָר","r",NULL,"KVAR","כבר","כבר",NULL,"KBR","KBR",NULL);
INSERT INTO hebrew_morpho VALUES (91169,"כְּלִי","n",NULL,"KLI","כלי","כלי",NULL,"KLI","KLI",NULL);
INSERT INTO hebrew_morpho VALUES (91170,"כְּלָל","r",NULL,"KLAL","כלל","כלל",NULL,"KLL","KLL",NULL);
INSERT INTO hebrew_morpho VALUES (91171,"כְּנִיסָה","n",NULL,"KNISA","כניסה","כניסה",NULL,"KNISH","KNISH",NULL);
INSERT INTO hebrew_morpho VALUES (91172,"מַעַן","n",NULL,"MA\'AN","מען","מען",NULL,"M&N","M&N",NULL);
INSERT INTO hebrew_morpho VALUES (91173,"כְּנֶסֶת","n",NULL,"KNESET","כנסת","כנסת",NULL,"KNST","KNST",NULL);
INSERT INTO hebrew_morpho VALUES (91174,"כְּתָב","n",NULL,"KTAV","כתב","כתב",NULL,"KTB","KTB",NULL);
INSERT INTO hebrew_morpho VALUES (91175,"כִּמְעַט","r",NULL,"KIM\'AT","כמעט","כמעט",NULL,"KM&@","KM&@",NULL);
INSERT INTO hebrew_morpho VALUES (91176,"כֵּלִי","a",NULL,"KELI","כלי","כלי",NULL,"KLI","KLI",NULL);
INSERT INTO hebrew_morpho VALUES (91177,"כֵּן","r",NULL,"KEN","כן","כן",NULL,"KN","KN",NULL);
INSERT INTO hebrew_morpho VALUES (91178,"כַּדּוּר","n",NULL,"KADUR","כדור","כדור",NULL,"KDWR","KDWR",NULL);
INSERT INTO hebrew_morpho VALUES (91179,"כַּדּוּרֶגֶל","n",NULL,"KADUREGEL","כדורגל","כדורגל",NULL,"KDWRGL","KDWRGL",NULL);
INSERT INTO hebrew_morpho VALUES (91180,"כַּוָּנָה","n",NULL,"KAVANA","כוונה","כונה",NULL,"KWNH","KWWNH",NULL);
INSERT INTO hebrew_morpho VALUES (91181,"כַּנִּרְאֶה","r",NULL,"KANIR\'EH","כנראה","כנראה",NULL,"KNRAH","KNRAH",NULL);
INSERT INTO hebrew_morpho VALUES (91182,"כַּסְפִּי","a",NULL,"KASPI","כספי","כספי",NULL,"KSPI","KSPI",NULL);
INSERT INTO hebrew_morpho VALUES (91183,"כַּרְטִיס","n",NULL,"KARTIS","כרטיס","כרטיס",NULL,"KR@IS","KR@IS",NULL);
INSERT INTO hebrew_morpho VALUES (91184,"כָּבוֹד","n",NULL,"KAVOD","כבוד","כבוד",NULL,"KBWD","KBWD",NULL);
INSERT INTO hebrew_morpho VALUES (91185,"כָּמֵהַּ","a",NULL,"KAMEHA","כמה","כמה",NULL,"KMH","KMH",NULL);
INSERT INTO hebrew_morpho VALUES (91186,"כֹּה","r",NULL,"KOH","כה","כה",NULL,"KH","KH",NULL);
INSERT INTO hebrew_morpho VALUES (91187,"כּוֹחַ","n",NULL,"KO\'AX","כוח","כוח",NULL,"KWX","KWX",NULL);
INSERT INTO hebrew_morpho VALUES (91188,"כּוֹכָב","n",NULL,"KOCHAV","כוכב","כוכב",NULL,"KWKB","KWKB",NULL);
INSERT INTO hebrew_morpho VALUES (91189,"לִיגָה","n",NULL,"LIGA","ליגה","ליגה",NULL,"LIGH","LIGH",NULL);
INSERT INTO hebrew_morpho VALUES (91190,"לִיד","n",NULL,"LID","ליד","ליד",NULL,"LID","LID",NULL);
INSERT INTO hebrew_morpho VALUES (91191,"לֶב","n",NULL,"LEV","לב","לב",NULL,"LB","LB",NULL);
INSERT INTO hebrew_morpho VALUES (91192,"אִלֵּץ","v",NULL,"ILETZ","אילץ","אלץ",NULL,"ALC","AILC",NULL);
INSERT INTO hebrew_morpho VALUES (91193,"כָּפָה","v",NULL,"KAFA","כפה","כפה",NULL,"KPH","KPH",NULL);
INSERT INTO hebrew_morpho VALUES (91194,"לָקוֹחַ","n",NULL,"LAKO\'AX","לקוח","לקוח",NULL,"LQWX","LQWX",NULL);
INSERT INTO hebrew_morpho VALUES (91195,"לֹבֶן","n",NULL,"LOVEN","לובן","לבן",NULL,"LBN","LWBN",NULL);
INSERT INTO hebrew_morpho VALUES (91196,"לוּחַ","n",NULL,"LU\'AX","לוח","לוח",NULL,"LWX","LWX",NULL);
INSERT INTO hebrew_morpho VALUES (91197,"נָתִין","n",NULL,"NATIN","נתין","נתין",NULL,"NTIN","NTIN",NULL);
INSERT INTO hebrew_morpho VALUES (91198,"מִדָּה","n",NULL,"MIDA","מידה","מדה",NULL,"MDH","MIDH",NULL);
INSERT INTO hebrew_morpho VALUES (91199,"מִישֶׁהוּ","n",NULL,NULL,"מישהו","מישהו",NULL,"MI$HW","MI$HW",NULL);
INSERT INTO hebrew_morpho VALUES (91200,"שֶׁלֶד","n",NULL,NULL,"שלד","שלד",NULL,"$LD","$LD",NULL);
INSERT INTO hebrew_morpho VALUES (91201,"מִשְׂחָק","n",NULL,"MISCHAK","משחק","משחק",NULL,"M$XQ","M$XQ",NULL);
INSERT INTO hebrew_morpho VALUES (91202,"מֵבִין","n",NULL,"mevin","מבין","מבין",NULL,"MBIN","MBIN",NULL);
INSERT INTO hebrew_morpho VALUES (91203,"מֶחְקָר","n",NULL,"MECHKAR","מחקר","מחקר",NULL,"MXQR","MXQR",NULL);
INSERT INTO hebrew_morpho VALUES (91204,"מֶסֶר","n",NULL,"MESER","מסר","מסר",NULL,"MSR","MSR",NULL);
INSERT INTO hebrew_morpho VALUES (91205,"מֶשֶׁק","n",NULL,"MESHEK","משק","משק",NULL,"M$Q","M$Q",NULL);
INSERT INTO hebrew_morpho VALUES (91206,"מַחְלָקָה","n",NULL,"machlaka","מחלקה","מחלקה",NULL,"MXLQH","MXLQH",NULL);
INSERT INTO hebrew_morpho VALUES (91207,"תְּחוּם","n",NULL,"TCHUM","תחום","תחום",NULL,"TXWM","TXWM",NULL);
INSERT INTO hebrew_morpho VALUES (91208,"מַטָּרָה","n",NULL,"MATARA","מטרה","מטרה",NULL,"M@RH","M@RH",NULL);
INSERT INTO hebrew_morpho VALUES (91209,"מַמָּשׁ","r",NULL,"MAMASH","ממש","ממש",NULL,"MM$","MM$",NULL);
INSERT INTO hebrew_morpho VALUES (91210,"מַעֲרֶכֶת","n",NULL,"MA\'ARECHET","מערכת","מערכת",NULL,"M&RKT","M&RKT",NULL);
INSERT INTO hebrew_morpho VALUES (91211,"מַעֲרָב","n",NULL,"MA\'ARAV","מערב","מערב",NULL,"M&RB","M&RB",NULL);
INSERT INTO hebrew_morpho VALUES (91212,"מַשְׁמָעוּתִי","a",NULL,"MASHMA\'UTI","משמעותי","משמעותי",NULL,"M$M&WTI","M$M&WTI",NULL);
INSERT INTO hebrew_morpho VALUES (91213,"מָטוֹס","n",NULL,"MATOS","מטוס","מטוס",NULL,"M@WS","M@WS",NULL);
INSERT INTO hebrew_morpho VALUES (91214,"מָסַר","v",NULL,"MASAR","מסר","מסר",NULL,"MSR","MSR",NULL);
INSERT INTO hebrew_morpho VALUES (91215,"מוֹצָא","n",NULL,"MOTZA","מוצא","מוצא",NULL,"MWCA","MWCA",NULL);
INSERT INTO hebrew_morpho VALUES (91216,"מֻכָּר","a",NULL,"MUKAR","מוכר","מכר",NULL,"MKR","MWKR",NULL);
INSERT INTO hebrew_morpho VALUES (91217,"נִצָּחוֹן","n",NULL,"NITSAXON","ניצחון","נצחון",NULL,"NCXWN","NICXWN",NULL);
INSERT INTO hebrew_morpho VALUES (91218,"סִיֵּם","v",NULL,"SIYEM","סיים","סים",NULL,"SIM","SIIM",NULL);
INSERT INTO hebrew_morpho VALUES (91219,"סָבִיר","a",NULL,"SAVIR","סביר","סביר",NULL,"SBIR","SBIR",NULL);
INSERT INTO hebrew_morpho VALUES (91220,"עַז","a",NULL,"AZ","עז","עז",NULL,"&Z","&Z",NULL);
INSERT INTO hebrew_morpho VALUES (91221,"הֵחָלְשׁוּת","n",NULL,"HECHALSHUT","היחלשות","החלשות",NULL,"HXL$WT","HIXL$WT",NULL);
INSERT INTO hebrew_morpho VALUES (91222,"פַּעַם","r",NULL,"PA\'AM","פעם","פעם",NULL,"P&M","P&M",NULL);
INSERT INTO hebrew_morpho VALUES (91223,"חוֹבָה","a",NULL,"CHOVA","חובה","חובה",NULL,"XWBH","XWBH",NULL);
INSERT INTO hebrew_morpho VALUES (91224,"קָטַע","v",NULL,"KATA","קטע","קטע",NULL,"Q@&","Q@&",NULL);
INSERT INTO hebrew_morpho VALUES (91225,"קָרַב","v",NULL,"KARAV","קרב","קרב",NULL,"QRB","QRB",NULL);
INSERT INTO hebrew_morpho VALUES (91226,"כְּ","r",NULL,"KE","כ","כ",NULL,"K","K",NULL);
INSERT INTO hebrew_morpho VALUES (91227,"לְעֵרֶךְ","r",NULL,"LE\'ERECH","לערך","לערך",NULL,"L&RK","L&RK",NULL);
INSERT INTO hebrew_morpho VALUES (91228,"קֹדֶם","r",NULL,"KODEM","קודם","קדם",NULL,"QDM","QWDM",NULL);
INSERT INTO hebrew_morpho VALUES (91229,"רִשְׁמִי","a",NULL,"RISHMI","רישמי","רשמי",NULL,"R$MI","RI$MI",NULL);
INSERT INTO hebrew_morpho VALUES (91230,"רֶוַח","n",NULL,"REVACH","רווח","רוח",NULL,"RWX","RWWX",NULL);
INSERT INTO hebrew_morpho VALUES (91231,"טוֹבַת-הֲנָאָה","n",NULL,"TOVAT-HANA\'AH","טובת-הנאה","טובת-הנאה",NULL,"@WBT-HNAH","@WBT-HNAH",NULL);
INSERT INTO hebrew_morpho VALUES (91232,"לוֹט","n",NULL,"LOT","לוט","לוט",NULL,"LW@","LW@",NULL);
INSERT INTO hebrew_morpho VALUES (91233,"שִׂיחָה","n",NULL,"SICHA","שיחה","שיחה",NULL,"$IXH","$IXH",NULL);
INSERT INTO hebrew_morpho VALUES (91234,"הָמוֹן","n",NULL,"HAMON","המון","המון",NULL,"HMWN","HMWN",NULL);
INSERT INTO hebrew_morpho VALUES (91235,"תֵּל","n",NULL,"TEL","תל","תל",NULL,"TL","TL",NULL);
INSERT INTO hebrew_morpho VALUES (91236,"תַּעֲשִׂיָּה","n",NULL,"TA\'ASI\'YA","תעשייה","תעשיה",NULL,"T&$IH","T&$IIH",NULL);
INSERT INTO hebrew_morpho VALUES (91237,"חוֹבָה","n",NULL,"CHOVA","חובה","חובה",NULL,"XWBH","XWBH",NULL);
INSERT INTO hebrew_morpho VALUES (91238,"נוּת","n",NULL,NULL,"נות","נות",NULL,"NWT","NWT",NULL);
INSERT INTO hebrew_morpho VALUES (91239,"אֱלִיל","n",NULL,"elil","אליל","אֱלִיל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (91240,"מוֹפֵת","n",NULL,"MOFET","מופת","מופת",NULL,"MWPT","MWPT",NULL);
INSERT INTO hebrew_morpho VALUES (91241,"אֱלֹהִים","n",NULL,NULL,"אלוהים","אלהים",NULL,"ALHIM","ALWHIM",NULL);
INSERT INTO hebrew_morpho VALUES (91242,"אֱלוּל","n",NULL,NULL,"אלול","אלול",NULL,"ALWL","ALWL",NULL);
INSERT INTO hebrew_morpho VALUES (91243,"מָן","n",NULL,NULL,"מן","מן",NULL,"MN","MN",NULL);
INSERT INTO hebrew_morpho VALUES (91244,"אֲבֵלוּת","n",NULL,"AVELUT","אבלות","אבלות",NULL,"ABLWT","ABLWT",NULL);
INSERT INTO hebrew_morpho VALUES (91245,"אֲבַטִּיחַ","n",NULL,NULL,"אבטיח","אבטיח",NULL,"AB@IX","AB@IX",NULL);
INSERT INTO hebrew_morpho VALUES (91246,"אֲגַם","n",NULL,"AGAM","אגם","אגם",NULL,"AGM","AGM",NULL);
INSERT INTO hebrew_morpho VALUES (91247,"אֲגַרְטָל","n",NULL,"AGARTAL","אגרטל","אגרטל",NULL,"AGR@L","AGR@L",NULL);
INSERT INTO hebrew_morpho VALUES (91248,"אֲגוּדָל","n",NULL,"AGUDAL","אגודל","אגודל",NULL,"AGWDL","AGWDL",NULL);
INSERT INTO hebrew_morpho VALUES (91249,"בֹּהֶן","n",NULL,"BOHEN","בוהן","בהן",NULL,"BHN","BWHN",NULL);
INSERT INTO hebrew_morpho VALUES (91250,"אָפַּתְיָה","n",NULL,"APATIA","אפתיה","אפתיה",NULL,"APTIH","APTIH",NULL);
INSERT INTO hebrew_morpho VALUES (91251,"אֲדָר","n",NULL,"ADAR","אדר","אדר",NULL,"ADR","ADR",NULL);
INSERT INTO hebrew_morpho VALUES (91252,"אֲוִירִי","a",NULL,"AVIRI","אווירי","אוירי",NULL,"AWIRI","AWWIRI",NULL);
INSERT INTO hebrew_morpho VALUES (91253,"אֲוִירוֹן","n",NULL,"AVIRON","אווירון","אוירון",NULL,"AWIRWN","AWWIRWN",NULL);
INSERT INTO hebrew_morpho VALUES (91254,"אֲוָז","n",NULL,"AVAZ","אווז","אוז",NULL,"AWZ","AWWZ",NULL);
INSERT INTO hebrew_morpho VALUES (91255,"אֲזִקִּים","n",NULL,"AZIKIM","אזיקים","אזקים",NULL,"AZQIM","AZIQIM",NULL);
INSERT INTO hebrew_morpho VALUES (91256,"מְחוֹזִי","a",NULL,"MECHOZI","מחוזי","מחוזי",NULL,"MXWZI","MXWZI",NULL);
INSERT INTO hebrew_morpho VALUES (91257,"שְׁלִיטָה","n",NULL,NULL,"שליטה","שליטה",NULL,"$LI@H","$LI@H",NULL);
INSERT INTO hebrew_morpho VALUES (91258,"אֲחִיזָה","n",NULL,NULL,"אחיזה","אחיזה",NULL,"AXIZH","AXIZH",NULL);
INSERT INTO hebrew_morpho VALUES (91259,"אֲחָדִים","a",NULL,"ACHADIM","אחדים","אחדים",NULL,"AXDIM","AXDIM",NULL);
INSERT INTO hebrew_morpho VALUES (91260,"אֲכִילָה","n",NULL,"ACHILA","אכילה","אכילה",NULL,"AKILH","AKILH",NULL);
INSERT INTO hebrew_morpho VALUES (91261,"אֲכִיפָה","n",NULL,"ACHIFA","אכיפה","אכיפה",NULL,"AKIPH","AKIPH",NULL);
INSERT INTO hebrew_morpho VALUES (91262,"אֲמִינוּת","n",NULL,"AMINUT","אמינות","אמינות",NULL,"AMINWT","AMINWT",NULL);
INSERT INTO hebrew_morpho VALUES (91263,"אֲמִתִּי","a",NULL,"AMITI","אמיתי","אמתי",NULL,"AMTI","AMITI",NULL);
INSERT INTO hebrew_morpho VALUES (91264,"אֲנָכִי","a",NULL,"ANACHI","אנכי","אנכי",NULL,"ANKI","ANKI",NULL);
INSERT INTO hebrew_morpho VALUES (91265,"אֲנָנָס","n",NULL,NULL,"אננס","אננס",NULL,"ANNS","ANNS",NULL);
INSERT INTO hebrew_morpho VALUES (91266,"אֲנָפָה","n",NULL,"ANAFA","אנפה","אנפה",NULL,"ANPH","ANPH",NULL);
INSERT INTO hebrew_morpho VALUES (91267,"אֲרִיגָה","n",NULL,"ARIGA","אריגה","אריגה",NULL,"ARIGH","ARIGH",NULL);
INSERT INTO hebrew_morpho VALUES (91268,"אֲרֻבָּה","n",NULL,"ARUBA","ארובה","ארבה",NULL,"ARBH","ARWBH",NULL);
INSERT INTO hebrew_morpho VALUES (91269,"אֲרוּחָה","n",NULL,"ARUCHA","ארוחה","ארוחה",NULL,"ARWXH","ARWXH",NULL);
INSERT INTO hebrew_morpho VALUES (91270,"תַּעֲרֹבֶת","n",NULL,"TA\'AROVET","תערובת","תערבת",NULL,"T&RBT","T&RWBT",NULL);
INSERT INTO hebrew_morpho VALUES (91271,"אֳנִיָּה","n",NULL,NULL,"אוניה","אניה",NULL,"ANIH","AWNIH",NULL);
INSERT INTO hebrew_morpho VALUES (91272,"אִבְחֵן","v",NULL,NULL,"איבחן","אבחן",NULL,"ABXN","AIBXN",NULL);
INSERT INTO hebrew_morpho VALUES (91273,"אִבְחוּן","n",NULL,"IVCHUN","אבחון","אבחון",NULL,"ABXWN","ABXWN",NULL);
INSERT INTO hebrew_morpho VALUES (91274,"אִוְרֵר","v",NULL,NULL,"איוורר","אורר",NULL,"AWRR","AIWWRR",NULL);
INSERT INTO hebrew_morpho VALUES (91275,"אִזְמֵל","n",NULL,NULL,"איזמל","אזמל",NULL,"AZML","AIZML",NULL);
INSERT INTO hebrew_morpho VALUES (91276,"אִחְסֵן","v",NULL,NULL,"איחסן","אחסן",NULL,"AXSN","AIXSN",NULL);
INSERT INTO hebrew_morpho VALUES (91277,"אָגַר","v",NULL,NULL,"אגר","אגר",NULL,"AGR","AGR",NULL);
INSERT INTO hebrew_morpho VALUES (91278,"אִחֵד","v",NULL,NULL,"איחד","אחד",NULL,"AXD","AIXD",NULL);
INSERT INTO hebrew_morpho VALUES (91279,"הִתְאַחֵד","v",NULL,"HIT\'ACHED","התאחד","התאחד",NULL,"HTAXD","HTAXD",NULL);
INSERT INTO hebrew_morpho VALUES (91280,"אִחוּד","n",NULL,NULL,"איחוד","אחוד",NULL,"AXWD","AIXWD",NULL);
INSERT INTO hebrew_morpho VALUES (91281,"אִינְסְטֶלָטוֹר","n",NULL,NULL,"אינסטלטור","אינסטלטור",NULL,"AINS@L@WR","AINS@L@WR",NULL);
INSERT INTO hebrew_morpho VALUES (91282,"אִישִׁיּוּת","n",NULL,NULL,"אישיות","אישיות",NULL,"AI$IWT","AI$IWT",NULL);
INSERT INTO hebrew_morpho VALUES (91283,"אִישִׁית","r",NULL,NULL,"אישית","אישית",NULL,"AI$IT","AI$IT",NULL);
INSERT INTO hebrew_morpho VALUES (91284,"אִכְזֵב","v",NULL,NULL,"איכזב","אכזב",NULL,"AKZB","AIKZB",NULL);
INSERT INTO hebrew_morpho VALUES (91285,"אִכָּר","n",NULL,NULL,"איכר","אכר",NULL,"AKR","AIKR",NULL);
INSERT INTO hebrew_morpho VALUES (91286,"אִלְתֵּר","v",NULL,NULL,"אילתר","אלתר",NULL,"ALTR","AILTR",NULL);
INSERT INTO hebrew_morpho VALUES (91287,"אִלְתּוּר","n",NULL,NULL,"אילתור","אלתור",NULL,"ALTWR","AILTWR",NULL);
INSERT INTO hebrew_morpho VALUES (91288,"אִלֵּף","v",NULL,NULL,"אילף","אלף",NULL,"ALP","AILP",NULL);
INSERT INTO hebrew_morpho VALUES (91289,"אִמָּא","n",NULL,NULL,"אימא","אמא",NULL,"AMA","AIMA",NULL);
INSERT INTO hebrew_morpho VALUES (91290,"אִמָּהִי","a",NULL,NULL,"אימהי","אמהי",NULL,"AMHI","AIMHI",NULL);
INSERT INTO hebrew_morpho VALUES (91291,"אִמָּהוּת","n",NULL,NULL,"אימהות","אמהות",NULL,"AMHWT","AIMHWT",NULL);
INSERT INTO hebrew_morpho VALUES (91292,"דֶּרֶךְ-אֶרֶץ","n",NULL,"DERECH ERETZ","דרך-ארץ","דרך-ארץ",NULL,"DRK-ARC","DRK-ARC",NULL);
INSERT INTO hebrew_morpho VALUES (91293,"הַכְשָׁרָה","n",NULL,NULL,"הכשרה","הכשרה",NULL,"HK$RH","HK$RH",NULL);
INSERT INTO hebrew_morpho VALUES (91294,"אִסּוּף","n",NULL,NULL,"איסוף","אסוף",NULL,"ASWP","AISWP",NULL);
INSERT INTO hebrew_morpho VALUES (91295,"אִסּוּר","n",NULL,NULL,"איסור","אסור",NULL,"ASWR","AISWR",NULL);
INSERT INTO hebrew_morpho VALUES (91296,"אִפּוּר","n",NULL,NULL,"איפור","אפור",NULL,"APWR","AIPWR",NULL);
INSERT INTO hebrew_morpho VALUES (91297,"אִרְגּוּנִי","a",NULL,NULL,"אירגוני","ארגוני",NULL,"ARGWNI","AIRGWNI",NULL);
INSERT INTO hebrew_morpho VALUES (91298,"עוֹזֶרֶת","n",NULL,NULL,"עוזרת","עוזרת",NULL,"&WZRT","&WZRT",NULL);
INSERT INTO hebrew_morpho VALUES (91299,"אִשְׁפֵּז","v",NULL,NULL,"אישפז","אשפז",NULL,"A$PZ","AI$PZ",NULL);
INSERT INTO hebrew_morpho VALUES (91300,"אִשְׁפּוּז","n",NULL,NULL,"אישפוז","אשפוז",NULL,"A$PWZ","AI$PWZ",NULL);
INSERT INTO hebrew_morpho VALUES (91301,"אִתּוּת","n",NULL,NULL,"איתות","אתות",NULL,"ATWT","AITWT",NULL);
INSERT INTO hebrew_morpho VALUES (91302,"טְחָב","n",NULL,NULL,"טחב","טחב",NULL,"@XB","@XB",NULL);
INSERT INTO hebrew_morpho VALUES (91303,"אֵימָה","n",NULL,NULL,"אימה","אימה",NULL,"AIMH","AIMH",NULL);
INSERT INTO hebrew_morpho VALUES (91304,"אֵרֵח","v",NULL,NULL,"אירח","ארח",NULL,"ARX","AIRX",NULL);
INSERT INTO hebrew_morpho VALUES (91305,"אֵשֶׁל","n",NULL,NULL,"אשל","אשל",NULL,"A$L","A$L",NULL);
INSERT INTO hebrew_morpho VALUES (91306,"אֶבְיוֹן","n",NULL,"EVION","אביון","אביון",NULL,"ABIWN","ABIWN",NULL);
INSERT INTO hebrew_morpho VALUES (91307,"אֶבֶן","n",NULL,"EVEN","אבן","אבן",NULL,"ABN","ABN",NULL);
INSERT INTO hebrew_morpho VALUES (91308,"אֶגְרוֹף","n",NULL,"EGROF","אגרוף","אגרוף",NULL,"AGRWP","AGRWP",NULL);
INSERT INTO hebrew_morpho VALUES (91309,"אֶדֶן","n",NULL,"EDEN","אדן","אדן",NULL,"ADN","ADN",NULL);
INSERT INTO hebrew_morpho VALUES (91310,"אֶפֶס","n",NULL,"EFES","אפס","אפס",NULL,"APS","APS",NULL);
INSERT INTO hebrew_morpho VALUES (91311,"אֶצְבַּע","n",NULL,NULL,"אצבע","אצבע",NULL,"ACB&","ACB&",NULL);
INSERT INTO hebrew_morpho VALUES (91312,"אֶקְדָּח","n",NULL,"EKDACH","אקדח","אקדח",NULL,"AQDX","AQDX",NULL);
INSERT INTO hebrew_morpho VALUES (91313,"אֶרֶז","n",NULL,"EREZ","ארז","ארז",NULL,"ARZ","ARZ",NULL);
INSERT INTO hebrew_morpho VALUES (91314,"אַבָּהוּת","n",NULL,"ABAHUT","אבהות","אבהות",NULL,"ABHWT","ABHWT",NULL);
INSERT INTO hebrew_morpho VALUES (91315,"אַבְחָנָה","n",NULL,"AVCHANA","אבחנה","אבחנה",NULL,"ABXNH","ABXNH",NULL);
INSERT INTO hebrew_morpho VALUES (91316,"אַבְטָלָה","n",NULL,"AVTALA","אבטלה","אבטלה",NULL,"AB@LH","AB@LH",NULL);
INSERT INTO hebrew_morpho VALUES (91317,"אַבִּיר","n",NULL,"ABIR","אביר","אביר",NULL,"ABIR","ABIR",NULL);
INSERT INTO hebrew_morpho VALUES (91318,"אַבִּירוּת","n",NULL,"ABIRUT","אבירות","אבירות",NULL,"ABIRWT","ABIRWT",NULL);
INSERT INTO hebrew_morpho VALUES (91319,"אַבָּא","n",NULL,"ABBA","אבא","אבא",NULL,"ABA","ABA",NULL);
INSERT INTO hebrew_morpho VALUES (91320,"אַבּוּב","n",NULL,"ABUV","אבוב","אבוב",NULL,"ABWB","ABWB",NULL);
INSERT INTO hebrew_morpho VALUES (91321,"אַגָּדִי","a",NULL,"AGADI","אגדי","אגדי",NULL,"AGDI","AGDI",NULL);
INSERT INTO hebrew_morpho VALUES (91322,"אַגָּדָתִי","a",NULL,"AGADATI","אגדתי","אגדתי",NULL,"AGDTI","AGDTI",NULL);
INSERT INTO hebrew_morpho VALUES (91323,"אַגָּדָה","n",NULL,NULL,"אגדה","אגדה",NULL,"AGDH","AGDH",NULL);
INSERT INTO hebrew_morpho VALUES (91324,"מִקְרָא","n",NULL,NULL,"מקרא","מקרא",NULL,"MQRA","MQRA",NULL);
INSERT INTO hebrew_morpho VALUES (91325,"אַגָּס","n",NULL,"AGAS","אגס","אגס",NULL,"AGS","AGS",NULL);
INSERT INTO hebrew_morpho VALUES (91326,"אַדִּיר","a",NULL,"ADIR","אדיר","אדיר",NULL,"ADIR","ADIR",NULL);
INSERT INTO hebrew_morpho VALUES (91327,"אַזְהָרָה","n",NULL,"AZHARA","אזהרה","אזהרה",NULL,"AZHRH","AZHRH",NULL);
INSERT INTO hebrew_morpho VALUES (91328,"אַחְיָן","n",NULL,"ACHYAN","אחיין","אחין",NULL,"AXIN","AXIIN",NULL);
INSERT INTO hebrew_morpho VALUES (91329,"אַחְיָנִית","n",NULL,"ACHYANIT","אחיינית","אחינית",NULL,"AXINIT","AXIINIT",NULL);
INSERT INTO hebrew_morpho VALUES (91330,"אַחֶרֶת","r",NULL,NULL,"אחרת","אחרת",NULL,"AXRT","AXRT",NULL);
INSERT INTO hebrew_morpho VALUES (91331,"אַיָּלָה","n",NULL,"AYALA","איילה","אילה",NULL,"AILH","AIILH",NULL);
INSERT INTO hebrew_morpho VALUES (91332,"אַכְזָבָה","n",NULL,NULL,"אכזבה","אכזבה",NULL,"AKZBH","AKZBH",NULL);
INSERT INTO hebrew_morpho VALUES (91333,"מַר","n",NULL,NULL,"מר","מר",NULL,"MR","MR",NULL);
INSERT INTO hebrew_morpho VALUES (91334,"אַכְזָרִי","a",NULL,"ACHZARI","אכזרי","אכזרי",NULL,"AKZRI","AKZRI",NULL);
INSERT INTO hebrew_morpho VALUES (91335,"אַכְסַנְיַת-נֹעַר","n",NULL,NULL,"אכסניית-נוער","אכסנית-נער",NULL,"AKSNIT-N&R","AKSNIIT-NW&R",NULL);
INSERT INTO hebrew_morpho VALUES (91336,"מְעוֹנוֹת","n",NULL,"ME\'ONOT","מעונות","מעונות",NULL,"M&WNWT","M&WNWT",NULL);
INSERT INTO hebrew_morpho VALUES (91337,"אַלְמָן","n",NULL,"ALMAN","אלמן","אלמן",NULL,"ALMN","ALMN",NULL);
INSERT INTO hebrew_morpho VALUES (91338,"אַלְמָנָה","n",NULL,"ALMANA","אלמנה","אלמנה",NULL,"ALMNH","ALMNH",NULL);
INSERT INTO hebrew_morpho VALUES (91339,"גִּבּוּי","n",NULL,"GIBUY","גיבוי","גבוי",NULL,"GBWI","GIBWI",NULL);
INSERT INTO hebrew_morpho VALUES (91340,"אַלּוֹן","n",NULL,"ALON","אלון","אלון",NULL,"ALWN","ALWN",NULL);
INSERT INTO hebrew_morpho VALUES (91341,"אַלּוּף","n",NULL,"ALUF","אלוף","אלוף",NULL,"ALWP","ALWP",NULL);
INSERT INTO hebrew_morpho VALUES (91342,"אַמְבַּטְיָה","n",NULL,"AMBATYA","אמבטיה","אמבטיה",NULL,"AMB@IH","AMB@IH",NULL);
INSERT INTO hebrew_morpho VALUES (91343,"אַמִּיץ","a",NULL,"AMITZ","אמיץ","אמיץ",NULL,"AMIC","AMIC",NULL);
INSERT INTO hebrew_morpho VALUES (91344,"אַמִּיץ-לֵב","a",NULL,NULL,NULL,"אמיץ-לב",NULL,"AMIC-LB",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (91345,"אַנָּס","n",NULL,"ANAS","אנס","אנס",NULL,"ANS","ANS",NULL);
INSERT INTO hebrew_morpho VALUES (91346,"אַסְפָּקָה","n",NULL,"ASPAKA","אספקה","אספקה",NULL,"ASPQH","ASPQH",NULL);
INSERT INTO hebrew_morpho VALUES (91347,"אַפְלָיָה","n",NULL,"AFLAYA","אפליה","אפליה",NULL,"APLIH","APLIH",NULL);
INSERT INTO hebrew_morpho VALUES (91348,"חֲסַר-עֵרֶךְ","a",NULL,"CHASAR ERECH","חסר-ערך","חסר-ערך",NULL,"XSR-&RK","XSR-&RK",NULL);
INSERT INTO hebrew_morpho VALUES (91349,"חָרוּב","n",NULL,NULL,"חרוב","חרוב",NULL,"XRWB","XRWB",NULL);
INSERT INTO hebrew_morpho VALUES (91350,"אַרְבֶּה","n",NULL,"ARBE","ארבה","ארבה",NULL,"ARBH","ARBH",NULL);
INSERT INTO hebrew_morpho VALUES (91351,"אַרְגָּז","n",NULL,"ARGAZ","ארגז","ארגז",NULL,"ARGZ","ARGZ",NULL);
INSERT INTO hebrew_morpho VALUES (91352,"אַרְיֵה","n",NULL,"ARYE","אריה","אריה",NULL,"ARIH","ARIH",NULL);
INSERT INTO hebrew_morpho VALUES (91353,"אַרְנָבוֹן","n",NULL,"ARNAVON","ארנבון","ארנבון",NULL,"ARNBWN","ARNBWN",NULL);
INSERT INTO hebrew_morpho VALUES (91354,"אַרְנָק","n",NULL,"ARNAK","ארנק","ארנק",NULL,"ARNQ","ARNQ",NULL);
INSERT INTO hebrew_morpho VALUES (91355,"אַרְנוֹנָה","n",NULL,"ARNONA","ארנונה","ארנונה",NULL,"ARNWNH","ARNWNH",NULL);
INSERT INTO hebrew_morpho VALUES (91356,"אַרְסִי","a",NULL,"ARSI","ארסי","ארסי",NULL,"ARSI","ARSI",NULL);
INSERT INTO hebrew_morpho VALUES (91357,"אַשּׁוּחַ","n",NULL,"ASHU\'ACH","אשוח","אשוח",NULL,"A$WX","A$WX",NULL);
INSERT INTO hebrew_morpho VALUES (91358,"אַשּׁוּחַ","n",NULL,NULL,NULL,"אשוח",NULL,"A$WX",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (91359,"אַשְׁלְגָן","n",NULL,"ASHLEGAN","אשלגן","אשלגן",NULL,"A$LGN","A$LGN",NULL);
INSERT INTO hebrew_morpho VALUES (91360,"אַשְׁלָג","n",NULL,"ASHLAG","אשלג","אשלג",NULL,"A$LG","A$LG",NULL);
INSERT INTO hebrew_morpho VALUES (91361,"אַשְׁמָה","n",NULL,"ASHMA","אשמה","אשמה",NULL,"A$MH","A$MH",NULL);
INSERT INTO hebrew_morpho VALUES (91362,"הַאֲשָׁמָה","n",NULL,"HA\'ASHAMA","האשמה","האשמה",NULL,"HA$MH","HA$MH",NULL);
INSERT INTO hebrew_morpho VALUES (91363,"אַשְׁפָּה","n",NULL,"ASHPA","אשפה","אשפה",NULL,"A$PH","A$PH",NULL);
INSERT INTO hebrew_morpho VALUES (91364,"אַשְׁרָה","n",NULL,"ASHRA","אשרה","אשרה",NULL,"A$RH","A$RH",NULL);
INSERT INTO hebrew_morpho VALUES (91365,"מְטֻשְׁטָשׁ","a",NULL,NULL,"מטושטש","מטשטש",NULL,"M@$@$","M@W$@$",NULL);
INSERT INTO hebrew_morpho VALUES (91366,"אָבִיךְ","a",NULL,NULL,"אביך","אביך",NULL,"ABIK","ABIK",NULL);
INSERT INTO hebrew_morpho VALUES (91367,"אָסִיר","n",NULL,NULL,"אסיר","אסיר",NULL,"ASIR","ASIR",NULL);
INSERT INTO hebrew_morpho VALUES (91368,"אָבָץ","n",NULL,NULL,"אבץ","אבץ",NULL,"ABC","ABC",NULL);
INSERT INTO hebrew_morpho VALUES (91369,"אָדִישׁ","a",NULL,NULL,"אדיש","אדיש",NULL,"ADI$","ADI$",NULL);
INSERT INTO hebrew_morpho VALUES (91370,"סֶר","n",NULL,NULL,"סר","סר",NULL,"SR","SR",NULL);
INSERT INTO hebrew_morpho VALUES (91371,"אָהִיל","n",NULL,NULL,"אהיל","אהיל",NULL,"AHIL","AHIL",NULL);
INSERT INTO hebrew_morpho VALUES (91372,"אָהוּב","a",NULL,NULL,"אהוב","אהוב",NULL,"AHWB","AHWB",NULL);
INSERT INTO hebrew_morpho VALUES (91373,"אָוֶן","n",NULL,NULL,"אוון","און",NULL,"AWN","AWWN",NULL);
INSERT INTO hebrew_morpho VALUES (91374,"אִי-כְּשִׁירוּת","n",NULL,"E KSHIRUT","אי-כשירות","אי-כשירות",NULL,"AI-K$IRWT","AI-K$IRWT",NULL);
INSERT INTO hebrew_morpho VALUES (91375,"חֶבְרוֹן","n",NULL,"chevron","חברון","חברון",NULL,"XBRWN","XBRWN",NULL);
INSERT INTO hebrew_morpho VALUES (91376,"הוֹמוֹגֶנִי","a",NULL,"HOMOGENI","הומוגני","הומוגני",NULL,"HWMWGNI","HWMWGNI",NULL);
INSERT INTO hebrew_morpho VALUES (91377,"אָחוֹת","n",NULL,NULL,"אחות","אחות",NULL,"AXWT","AXWT",NULL);
INSERT INTO hebrew_morpho VALUES (91378,"אָחוּ","n",NULL,NULL,"אחו","אחו",NULL,"AXW","AXW",NULL);
INSERT INTO hebrew_morpho VALUES (91379,"בִּלְתִּי-חָדִיר","a",NULL,"BILTI CHADIR","בלתי-חדיר","בלתי-חדיר",NULL,"BLTI-XDIR","BLTI-XDIR",NULL);
INSERT INTO hebrew_morpho VALUES (91380,"אָיֹם","a",NULL,"ayom","איום","אָיֹם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (91381,"אַחְרָיוּת","n",NULL,"ACHRAYUT","אחריות","אחריות",NULL,"AXRIWT","AXRIWT",NULL);
INSERT INTO hebrew_morpho VALUES (91382,"אָמִין","a",NULL,NULL,"אמין","אמין",NULL,"AMIN","AMIN",NULL);
INSERT INTO hebrew_morpho VALUES (91383,"מֻכְרָז","a",NULL,NULL,"מוכרז","מכרז",NULL,"MKRZ","MWKRZ",NULL);
INSERT INTO hebrew_morpho VALUES (91384,"אָסוֹן","n",NULL,"ASON","אסון","אסון",NULL,"ASWN","ASWN",NULL);
INSERT INTO hebrew_morpho VALUES (91385,"אָסוּר","a",NULL,NULL,"אסור","אסור",NULL,"ASWR","ASWR",NULL);
INSERT INTO hebrew_morpho VALUES (91386,"אָפְיָנִי","a",NULL,NULL,"אופיני","אפיני",NULL,"APINI","AWPINI",NULL);
INSERT INTO hebrew_morpho VALUES (91387,"עָכוּר","a",NULL,NULL,"עכור","עכור",NULL,"&KWR","&KWR",NULL);
INSERT INTO hebrew_morpho VALUES (91388,"קוֹדֵר","a",NULL,"koder","קודר","קודר",NULL,"QWDR","QWDR",NULL);
INSERT INTO hebrew_morpho VALUES (91390,"אָפֹר","a",NULL,NULL,"אפור","אפר",NULL,"APR","APWR",NULL);
INSERT INTO hebrew_morpho VALUES (91391,"אָרִיג","n",NULL,NULL,"אריג","אריג",NULL,"ARIG","ARIG",NULL);
INSERT INTO hebrew_morpho VALUES (91392,"רַעַף","n",NULL,NULL,"רעף","רעף",NULL,"R&P","R&P",NULL);
INSERT INTO hebrew_morpho VALUES (91393,"אָרִיחַ","n",NULL,NULL,"אריח","אריח",NULL,"ARIX","ARIX",NULL);
INSERT INTO hebrew_morpho VALUES (91394,"אָרָד","n",NULL,NULL,"ארד","ארד",NULL,"ARD","ARD",NULL);
INSERT INTO hebrew_morpho VALUES (91395,"אָרוֹן","n",NULL,NULL,"ארון","ארון",NULL,"ARWN","ARWN",NULL);
INSERT INTO hebrew_morpho VALUES (91396,"אֹבֶךְ","n",NULL,NULL,"אובך","אבך",NULL,"ABK","AWBK",NULL);
INSERT INTO hebrew_morpho VALUES (91397,"מְבוּכָה","n",NULL,NULL,"מבוכה","מבוכה",NULL,"MBWKH","MBWKH",NULL);
INSERT INTO hebrew_morpho VALUES (91398,"אָדֹם","n",NULL,NULL,"אדום","אדם",NULL,"ADM","ADWM",NULL);
INSERT INTO hebrew_morpho VALUES (91399,"אֹדֶם","n",NULL,NULL,"אודם","אדם",NULL,"ADM","AWDM",NULL);
INSERT INTO hebrew_morpho VALUES (91400,"אֹהֶל","n",NULL,NULL,"אוהל","אהל",NULL,"AHL","AWHL",NULL);
INSERT INTO hebrew_morpho VALUES (91401,"אֹכֶל","n",NULL,NULL,"אוכל","אכל",NULL,"AKL","AWKL",NULL);
INSERT INTO hebrew_morpho VALUES (91402,"אֹמֶץ","n",NULL,NULL,"אומץ","אמץ",NULL,"AMC","AWMC",NULL);
INSERT INTO hebrew_morpho VALUES (91403,"אֹרֶז","n",NULL,NULL,"אורז","ארז",NULL,"ARZ","AWRZ",NULL);
INSERT INTO hebrew_morpho VALUES (91404,"אֹרֶן","n",NULL,NULL,"אורן","ארן",NULL,"ARN","AWRN",NULL);
INSERT INTO hebrew_morpho VALUES (91405,"אֻגְדָּה","n",NULL,NULL,"אוגדה","אגדה",NULL,"AGDH","AWGDH",NULL);
INSERT INTO hebrew_morpho VALUES (91406,"דִּירַת-סְטוּדְיוֹ","n",NULL,"DIRAT STUDYO","דירת-סטודיו","דירת-סטודיו",NULL,"DIRT-S@WDIW","DIRT-S@WDIW",NULL);
INSERT INTO hebrew_morpho VALUES (91407,"אֻלְפָּן","n",NULL,NULL,"אולפן","אלפן",NULL,"ALPN","AWLPN",NULL);
INSERT INTO hebrew_morpho VALUES (91408,"עָלוּב","a",NULL,NULL,"עלוב","עלוב",NULL,"&LWB","&LWB",NULL);
INSERT INTO hebrew_morpho VALUES (91409,"אֻמָּן","n",NULL,NULL,"אומן","אמן",NULL,"AMN","AWMN",NULL);
INSERT INTO hebrew_morpho VALUES (91410,"אֻרְוָה","n",NULL,NULL,"אורווה","ארוה",NULL,"ARWH","AWRWWH",NULL);
INSERT INTO hebrew_morpho VALUES (91411,"אוֹגֵד","n",NULL,NULL,"אוגד","אוגד",NULL,"AWGD","AWGD",NULL);
INSERT INTO hebrew_morpho VALUES (91412,"אוֹגֵר","n",NULL,NULL,"אוגר","אוגר",NULL,"AWGR","AWGR",NULL);
INSERT INTO hebrew_morpho VALUES (91413,"אוֹהֵב","a",NULL,NULL,"אוהב","אוהב",NULL,"AWHB","AWHB",NULL);
INSERT INTO hebrew_morpho VALUES (91414,"אוֹפַנּוֹעַ","n",NULL,NULL,"אופנוע","אופנוע",NULL,"AWPNW&","AWPNW&",NULL);
INSERT INTO hebrew_morpho VALUES (91415,"קַטְנוֹעַ","n",NULL,"katno\'a","קטנוע","קטנוע",NULL,"Q@NW&","Q@NW&",NULL);
INSERT INTO hebrew_morpho VALUES (91416,"אוּלָם","n",NULL,NULL,"אולם","אולם",NULL,"AWLM","AWLM",NULL);
INSERT INTO hebrew_morpho VALUES (91417,"מַארְק","n",NULL,NULL,"מארק","מארק",NULL,"MARQ","MARQ",NULL);
INSERT INTO hebrew_morpho VALUES (91418,"אוּד","n",NULL,NULL,"אוד","אוד",NULL,"AWD","AWD",NULL);
INSERT INTO hebrew_morpho VALUES (91419,"אוּלַי","r",NULL,NULL,"אולי","אולי",NULL,"AWLI","AWLI",NULL);
INSERT INTO hebrew_morpho VALUES (91420,"בְּדִידוּת","n",NULL,"BDIDUT","בדידות","בדידות",NULL,"BDIDWT","BDIDWT",NULL);
INSERT INTO hebrew_morpho VALUES (91421,"בְּוַדַּאי","r",NULL,"BEVADAI","בודאי","בודאי",NULL,"BWDAI","BWDAI",NULL);
INSERT INTO hebrew_morpho VALUES (91422,"בְּחִילָה","n",NULL,"BCHILA","בחילה","בחילה",NULL,"BXILH","BXILH",NULL);
INSERT INTO hebrew_morpho VALUES (91423,"בְּחִירָה","n",NULL,"BCHIRA","בחירה","בחירה",NULL,"BXIRH","BXIRH",NULL);
INSERT INTO hebrew_morpho VALUES (91424,"בְּחִישָׁה","n",NULL,"BCHISHA","בחישה","בחישה",NULL,"BXI$H","BXI$H",NULL);
INSERT INTO hebrew_morpho VALUES (91425,"בֵּין_כֹּה_וָכֹה","r",NULL,"BEYN KO VACHO","בין_כה_וכה","בין_כה_וכה",NULL,"BIN_KH_WKH","BIN_KH_WKH",NULL);
INSERT INTO hebrew_morpho VALUES (91426,"הִתְבַּלְּטוּת","n",NULL,"HITBALTUT","התבלטות","התבלטות",NULL,"HTBL@WT","HTBL@WT",NULL);
INSERT INTO hebrew_morpho VALUES (91427,"בְּלַאי","n",NULL,"BLAI","בלאי","בלאי",NULL,"BLAI","BLAI",NULL);
INSERT INTO hebrew_morpho VALUES (91428,"בְּלָאו_הָכֵי","r",NULL,"BELUV HECHEI","בלאו_הכי","בלאו_הכי",NULL,"BLAW_HKI","BLAW_HKI",NULL);
INSERT INTO hebrew_morpho VALUES (91429,"בְּמִתְכַּוֵּן","r",NULL,"BEMITKAVEN","במתכוון","במתכון",NULL,"BMTKWN","BMTKWWN",NULL);
INSERT INTO hebrew_morpho VALUES (91430,"בְּנִיָּה","n",NULL,"BNIYA","בנייה","בניה",NULL,"BNIH","BNIIH",NULL);
INSERT INTO hebrew_morpho VALUES (91431,"מַהוּתִי","a",NULL,"MAHUTI","מהותי","מהותי",NULL,"MHWTI","MHWTI",NULL);
INSERT INTO hebrew_morpho VALUES (91432,"יְסוֹדִי","a",NULL,"YESSODI","יסודי","יסודי",NULL,"ISWDI","ISWDI",NULL);
INSERT INTO hebrew_morpho VALUES (91433,"בְּסִיסִי","a",NULL,"BSSISSI","בסיסי","בסיסי",NULL,"BSISI","BSISI",NULL);
INSERT INTO hebrew_morpho VALUES (91434,"בְּעֶרֶךְ","r",NULL,"BE\'ERECH","בערך","בערך",NULL,"B&RK","B&RK",NULL);
INSERT INTO hebrew_morpho VALUES (91435,"בְּעַל-פֶּה","r",NULL,"BE\'AL PEH","בעל-פה","בעל-פה",NULL,"B&L-PH","B&L-PH",NULL);
INSERT INTO hebrew_morpho VALUES (91436,"מִמּוּשׁ","n",NULL,"MIMUSH","מימוש","ממוש",NULL,"MMW$","MIMW$",NULL);
INSERT INTO hebrew_morpho VALUES (91437,"בְּעָלִים","n",NULL,"BE\'ALIM","בעלים","בעלים",NULL,"B&LIM","B&LIM",NULL);
INSERT INTO hebrew_morpho VALUES (91438,"בְּרִיאַת_הָעוֹלָם","n",NULL,"BRI\'A\'T HA\'OLAM","בריאת_העולם","בריאת_העולם",NULL,"BRIAT_H&WLM","BRIAT_H&WLM",NULL);
INSERT INTO hebrew_morpho VALUES (91439,"מְנוּסָה","n",NULL,"MENUSSA","מנוסה","מנוסה",NULL,"MNWSH","MNWSH",NULL);
INSERT INTO hebrew_morpho VALUES (91440,"בְּרִיחָה","n",NULL,"BRICHA","בריחה","בריחה",NULL,"BRIXH","BRIXH",NULL);
INSERT INTO hebrew_morpho VALUES (91441,"בְּכַעַס","r",NULL,"BECHA\'AS","בכעס","בכעס",NULL,"BK&S","BK&S",NULL);
INSERT INTO hebrew_morpho VALUES (91442,"בְּרוֹשׁ","n",NULL,"BROSH","ברוש","ברוש",NULL,"BRW$","BRW$",NULL);
INSERT INTO hebrew_morpho VALUES (91443,"בְּרוּטוֹ","n",NULL,"BRUTO","ברוטו","ברוטו",NULL,"BRW@W","BRW@W",NULL);
INSERT INTO hebrew_morpho VALUES (91444,"בְּתוּלִים","n",NULL,"BETULIM","בתולים","בתולים",NULL,"BTWLIM","BTWLIM",NULL);
INSERT INTO hebrew_morpho VALUES (91445,"בִּגּוּד","n",NULL,"BIGUD","ביגוד","בגוד",NULL,"BGWD","BIGWD",NULL);
INSERT INTO hebrew_morpho VALUES (91446,"מְבוֹדֵד","n",NULL,"MEVODED","מבודד","מבודד",NULL,"MBWDD","MBWDD",NULL);
INSERT INTO hebrew_morpho VALUES (91447,"בִּדּוּד","n",NULL,"BIDUD","בידוד","בדוד",NULL,"BDWD","BIDWD",NULL);
INSERT INTO hebrew_morpho VALUES (91448,"בִּדּוּר","n",NULL,"BIDUR","בידור","בדור",NULL,"BDWR","BIDWR",NULL);
INSERT INTO hebrew_morpho VALUES (91449,"בִּזָּיוֹן","n",NULL,"BIZAYON","ביזיון","בזיון",NULL,"BZIWN","BIZIWN",NULL);
INSERT INTO hebrew_morpho VALUES (91450,"בִּטֵּל","v",NULL,"BITEL","ביטל","בטל",NULL,"B@L","BI@L",NULL);
INSERT INTO hebrew_morpho VALUES (91451,"בִּטּוּחַ","n",NULL,"BITU\'ACH","ביטוח","בטוח",NULL,"B@WX","BI@WX",NULL);
INSERT INTO hebrew_morpho VALUES (91452,"בִּיּוּב","n",NULL,"BIYUV","ביוב","ביוב",NULL,"BIWB","BIWB",NULL);
INSERT INTO hebrew_morpho VALUES (91453,"בִּיּוּץ","n",NULL,"BIYUTZ","ביוץ","ביוץ",NULL,"BIWC","BIWC",NULL);
INSERT INTO hebrew_morpho VALUES (91454,"בִּירָה","n",NULL,"BIRA","בירה","בירה",NULL,"BIRH","BIRH",NULL);
INSERT INTO hebrew_morpho VALUES (91455,"בִּיתָן","n",NULL,"BITAN","ביתן","ביתן",NULL,"BITN","BITN",NULL);
INSERT INTO hebrew_morpho VALUES (91456,"בִּלְבּוּל","n",NULL,"BILBUL","בלבול","בלבול",NULL,"BLBWL","BLBWL",NULL);
INSERT INTO hebrew_morpho VALUES (91457,"בִּלּוּי","n",NULL,"BILUY","בילוי","בלוי",NULL,"BLWI","BILWI",NULL);
INSERT INTO hebrew_morpho VALUES (91458,"בִּפְרָט","r",NULL,"BIFRAT","בפרט","בפרט",NULL,"BPR@","BPR@",NULL);
INSERT INTO hebrew_morpho VALUES (91459,"חֲלוּפָה","n",NULL,"CHALUFA","חלופה","חלופה",NULL,"XLWPH","XLWPH",NULL);
INSERT INTO hebrew_morpho VALUES (91460,"אַלְטֶרְנָטִיבָה","n",NULL,NULL,"אלטרנטיבה","אלטרנטיבה",NULL,"AL@RN@IBH","AL@RN@IBH",NULL);
INSERT INTO hebrew_morpho VALUES (91461,"בִּקְעָה","n",NULL,"BIK\'AH","בקעה","בקעה",NULL,"BQ&H","BQ&H",NULL);
INSERT INTO hebrew_morpho VALUES (91462,"בִּקּוּר","n",NULL,"BIKUR","ביקור","בקור",NULL,"BQWR","BIQWR",NULL);
INSERT INTO hebrew_morpho VALUES (91463,"בִּקּוּשׁ","n",NULL,"BIKUSH","ביקוש","בקוש",NULL,"BQW$","BIQW$",NULL);
INSERT INTO hebrew_morpho VALUES (91464,"בִּשּׁוּל","n",NULL,"BISHUL","בישול","בשול",NULL,"B$WL","BI$WL",NULL);
INSERT INTO hebrew_morpho VALUES (91465,"בְּדִיחָה","n",NULL,"BDICHA","בדיחה","בדיחה",NULL,"BDIXH","BDIXH",NULL);
INSERT INTO hebrew_morpho VALUES (91466,"בְּאֹפֶן-כְּלָלִי","r",NULL,"BE\'OFEN KLALI","באופן-כללי","באפן-כללי",NULL,"BAPN-KLLI","BAWPN-KLLI",NULL);
INSERT INTO hebrew_morpho VALUES (91468,"בֵּינוֹנִי","n",NULL,"BEINONI","בינוני","בינוני",NULL,"BINWNI","BINWNI",NULL);
INSERT INTO hebrew_morpho VALUES (91469,"קוֹמִיקַאי","n",NULL,"COMICAI","קומיקאי","קומיקאי",NULL,"QWMIQAI","QWMIQAI",NULL);
INSERT INTO hebrew_morpho VALUES (91470,"רוֹעֵה-צֹאן","n",NULL,"RO\'EH TSON","רועה-צאן","רועה-צאן",NULL,"RW&H-CAN","RW&H-CAN",NULL);
INSERT INTO hebrew_morpho VALUES (91471,"רוֹעֶה-בָּקָר","n",NULL,"RO\'EH BAKAR","רועה-בקר","רועה-בקר",NULL,"RW&H-BQR","RW&H-BQR",NULL);
INSERT INTO hebrew_morpho VALUES (91472,"בֶּטֶן","n",NULL,"BETEN","בטן","בטן",NULL,"B@N","B@N",NULL);
INSERT INTO hebrew_morpho VALUES (91473,"קֵבָה","n",NULL,"KEIVA","קיבה","קבה",NULL,"QBH","QIBH",NULL);
INSERT INTO hebrew_morpho VALUES (91474,"בֶּטַח","r",NULL,"BETACH","בטח","בטח",NULL,"B@X","B@X",NULL);
INSERT INTO hebrew_morpho VALUES (91475,"בֶּטוֹן","n",NULL,"BETON","בטון","בטון",NULL,"B@WN","B@WN",NULL);
INSERT INTO hebrew_morpho VALUES (91476,"בֶּכִי","n",NULL,"BECHI","בכי","בכי",NULL,"BKI","BKI",NULL);
INSERT INTO hebrew_morpho VALUES (91477,"בֶּקַע","n",NULL,"BEKA","בקע","בקע",NULL,"BQ&","BQ&",NULL);
INSERT INTO hebrew_morpho VALUES (91478,"בֶּרֶז","n",NULL,"BEREZ","ברז","ברז",NULL,"BRZ","BRZ",NULL);
INSERT INTO hebrew_morpho VALUES (91479,"בֶּרֶךְ","n",NULL,"BERECH","ברך","ברך",NULL,"BRK","BRK",NULL);
INSERT INTO hebrew_morpho VALUES (91480,"בַּאֲדִישׁוּת","r",NULL,"BE\'ADISHUT","באדישות","באדישות",NULL,"BADI$WT","BADI$WT",NULL);
INSERT INTO hebrew_morpho VALUES (91481,"בַּגְרוּת","n",NULL,"BAGRUT","בגרות","בגרות",NULL,"BGRWT","BGRWT",NULL);
INSERT INTO hebrew_morpho VALUES (91482,"בַּד","n",NULL,NULL,"בד","בד",NULL,"BD","BD",NULL);
INSERT INTO hebrew_morpho VALUES (91483,"קַנְבָס","n",NULL,"CANVAS","קנבס","קנבס",NULL,"QNBS","QNBS",NULL);
INSERT INTO hebrew_morpho VALUES (91484,"בַּדְרָן","n",NULL,"BADRAN","בדרן","בדרן",NULL,"BDRN","BDRN",NULL);
INSERT INTO hebrew_morpho VALUES (91485,"בַּז","n",NULL,"BAZ","בז","בז",NULL,"BZ","BZ",NULL);
INSERT INTO hebrew_morpho VALUES (91486,"בַּזְבְּזָן","n",NULL,"BAZBEZAN","בזבזן","בזבזן",NULL,"BZBZN","BZBZN",NULL);
INSERT INTO hebrew_morpho VALUES (91487,"בַּזֶּלֶת","n",NULL,"BAZELET","בזלת","בזלת",NULL,"BZLT","BZLT",NULL);
INSERT INTO hebrew_morpho VALUES (91488,"בַּחֲשַׁאי","r",NULL,"BECHASHAI","בחשאי","בחשאי",NULL,"BX$AI","BX$AI",NULL);
INSERT INTO hebrew_morpho VALUES (91489,"בַּטְלָן","n",NULL,"BATLAN","בטלן","בטלן",NULL,"B@LN","B@LN",NULL);
INSERT INTO hebrew_morpho VALUES (91490,"בַּלְשָׁן","n",NULL,"BALSHAN","בלשן","בלשן",NULL,"BL$N","BL$N",NULL);
INSERT INTO hebrew_morpho VALUES (91491,"רַב-לְשׁוֹנִי","n",NULL,"RAV-LESHONI","רב-לשוני","רב-לשוני",NULL,"RB-L$WNI","RB-L$WNI",NULL);
INSERT INTO hebrew_morpho VALUES (91492,"פּוֹלִיגְלוֹט","n",NULL,"POLYGLOT","פוליגלוט","פוליגלוט",NULL,"PWLIGLW@","PWLIGLW@",NULL);
INSERT INTO hebrew_morpho VALUES (91493,"בַּלָּשׁ","n",NULL,"BALASH","בלש","בלש",NULL,"BL$","BL$",NULL);
INSERT INTO hebrew_morpho VALUES (91494,"בַּלּוּטָה","n",NULL,"BALUTA","בלוטה","בלוטה",NULL,"BLW@H","BLW@H",NULL);
INSERT INTO hebrew_morpho VALUES (91495,"דֶּטֶרְגֶּנְט","n",NULL,"DETERGENT","דטרגנט","דטרגנט",NULL,"D@RGN@","D@RGN@",NULL);
INSERT INTO hebrew_morpho VALUES (91496,"בַּעֲלוּת","n",NULL,"BA\'ALUT","בעלות","בעלות",NULL,"B&LWT","B&LWT",NULL);
INSERT INTO hebrew_morpho VALUES (91497,"בַּעֲקִיפִין","r",NULL,"BE\'AKIFIN","בעקיפין","בעקיפין",NULL,"B&QIPIN","B&QIPIN",NULL);
INSERT INTO hebrew_morpho VALUES (91498,"יֹבֶשׁ","n",NULL,"YOVESH","יובש","יבש",NULL,"IB$","IWB$",NULL);
INSERT INTO hebrew_morpho VALUES (91499,"בַּצֹּרֶת","n",NULL,"BATSORET","בצורת","בצרת",NULL,"BCRT","BCWRT",NULL);
INSERT INTO hebrew_morpho VALUES (91500,"בַּרְבּוּר","n",NULL,"BARBUR","ברבור","ברבור",NULL,"BRBWR","BRBWR",NULL);
INSERT INTO hebrew_morpho VALUES (91501,"בַּרְרָן","a",NULL,"BARERAN","בררן","בררן",NULL,"BRRN","BRRN",NULL);
INSERT INTO hebrew_morpho VALUES (91502,"בַּרְרָנוּת","n",NULL,"BARERANUT","בררנות","בררנות",NULL,"BRRNWT","BRRNWT",NULL);
INSERT INTO hebrew_morpho VALUES (91503,"אֲמָנָה","n",NULL,"AMANA","אמנה","אמנה",NULL,"AMNH","AMNH",NULL);
INSERT INTO hebrew_morpho VALUES (91504,"בָּדוּי","a",NULL,"BADUI","בדוי","בדוי",NULL,"BDWI","BDWI",NULL);
INSERT INTO hebrew_morpho VALUES (91505,"בָּהוּל","a",NULL,"BAHUL","בהול","בהול",NULL,"BHWL","BHWL",NULL);
INSERT INTO hebrew_morpho VALUES (91506,"בָּז","v",NULL,"BAZ","בז","בז",NULL,"BZ","BZ",NULL);
INSERT INTO hebrew_morpho VALUES (91507,"שָׁכַב-עִם","v",NULL,"SHACHAV IM","שכב_עם","שכב-עם",NULL,"$KB-&M","$KB_&M",NULL);
INSERT INTO hebrew_morpho VALUES (91508,"הִזְדַּיֵּן","v",NULL,"HIZDAYEN","הזדיין","הזדין",NULL,"HZDIN","HZDIIN",NULL);
INSERT INTO hebrew_morpho VALUES (91509,"בָּלַט","v",NULL,"BALAT","בלט","בלט",NULL,"BL@","BL@",NULL);
INSERT INTO hebrew_morpho VALUES (91510,"בָּצָל","n",NULL,"BATSAL","בצל","בצל",NULL,"BCL","BCL",NULL);
INSERT INTO hebrew_morpho VALUES (91511,"בָּקִי","a",NULL,"BAKI","בקי","בקי",NULL,"BQI","BQI",NULL);
INSERT INTO hebrew_morpho VALUES (91512,"בָּקָר","n",NULL,"BAKAR","בקר","בקר",NULL,"BQR","BQR",NULL);
INSERT INTO hebrew_morpho VALUES (91513,"בָּרָד","n",NULL,NULL,"ברד","ברד",NULL,"BRD","BRD",NULL);
INSERT INTO hebrew_morpho VALUES (91514,"מְפֹרָשׁ","a",NULL,"MEFORASH","מפורש","מפרש",NULL,"MPR$","MPWR$",NULL);
INSERT INTO hebrew_morpho VALUES (91515,"בָּשָׂר","n",NULL,"BASSAR","בשר","בשר",NULL,"B$R","B$R",NULL);
INSERT INTO hebrew_morpho VALUES (91516,"בֹּשֶׂם","n",NULL,"BOSSEM","בושם","בשם",NULL,"B$M","BW$M",NULL);
INSERT INTO hebrew_morpho VALUES (91517,"בֻּבָּה","n",NULL,"BUBA","בובה","בבה",NULL,"BBH","BWBH",NULL);
INSERT INTO hebrew_morpho VALUES (91518,"בֻּכְנָה","n",NULL,"BUCHNA","בוכנה","בכנה",NULL,"BKNH","BWKNH",NULL);
INSERT INTO hebrew_morpho VALUES (91519,"בּוֹ-זְמַנִּית","r",NULL,"BO-ZMANIT","בו-זמנית","בו-זמנית",NULL,"BW-ZMNIT","BW-ZMNIT",NULL);
INSERT INTO hebrew_morpho VALUES (91520,"בּוֹגֵר","n",NULL,"BOGER","בוגר","בוגר",NULL,"BWGR","BWGR",NULL);
INSERT INTO hebrew_morpho VALUES (91521,"בּוֹחֵן","n",NULL,"BOCHEN","בוחן","בוחן",NULL,"BWXN","BWXN",NULL);
INSERT INTO hebrew_morpho VALUES (91522,"בּוֹחֵר","n",NULL,"BOCHER","בוחר","בוחר",NULL,"BWXR","BWXR",NULL);
INSERT INTO hebrew_morpho VALUES (91523,"בּוֹלֵט","a",NULL,"BOLET","בולט","בולט",NULL,"BWL@","BWL@",NULL);
INSERT INTO hebrew_morpho VALUES (91524,"בּוֹרֵר","n",NULL,"BORER","בורר","בורר",NULL,"BWRR","BWRR",NULL);
INSERT INTO hebrew_morpho VALUES (91525,"בּוּז","n",NULL,"BUZ","בוז","בוז",NULL,"BWZ","BWZ",NULL);
INSERT INTO hebrew_morpho VALUES (91526,"בּוּעָה","n",NULL,"BU\'AH","בועה","בועה",NULL,"BW&H","BW&H",NULL);
INSERT INTO hebrew_morpho VALUES (91527,"בּוּר","a",NULL,"BUR","בור","בור",NULL,"BWR","BWR",NULL);
INSERT INTO hebrew_morpho VALUES (91528,"חֲסר-יֶדַע","a",NULL,"CHASAR YEDA","חסר_ידע","חסר-ידע",NULL,"XSR-ID&","XSR_ID&",NULL);
INSERT INTO hebrew_morpho VALUES (91529,"לֹא-בָּקִי","a",NULL,"LO BAKI","לא_בקי","לא-בקי",NULL,"LA-BQI","LA_BQI",NULL);
INSERT INTO hebrew_morpho VALUES (91530,"בּוּרוּת","n",NULL,"BURUT","בורות","בורות",NULL,"BWRWT","BWRWT",NULL);
INSERT INTO hebrew_morpho VALUES (91531,"בּוּשָׁה","n",NULL,"BUSHA","בושה","בושה",NULL,"BW$H","BW$H",NULL);
INSERT INTO hebrew_morpho VALUES (91532,"גִ\'ינְגִ\'י","a",NULL,NULL,"ג\'ינג\'י","ג\'ינג\'י",NULL,"G\'ING\'I","G\'ING\'I",NULL);
INSERT INTO hebrew_morpho VALUES (91533,"חֶלְמִית","n",NULL,"HELMIT","חלמית","חלמית",NULL,"XLMIT","XLMIT",NULL);
INSERT INTO hebrew_morpho VALUES (91534,"גְּבִינָה","n",NULL,"GVINA","גבינה","גבינה",NULL,"GBINH","GBINH",NULL);
INSERT INTO hebrew_morpho VALUES (91535,"לֵיְדִּי","n",NULL,"LAYDI","ליידי","לידי",NULL,"LIDI","LIIDI",NULL);
INSERT INTO hebrew_morpho VALUES (91536,"מָדָם","n",NULL,"MADAM","מאדאפ","מדם",NULL,"MDM","MADAP",NULL);
INSERT INTO hebrew_morpho VALUES (91537,"גְּבֶרֶת","n",NULL,"GVERET","גברת","גברת",NULL,"GBRT","GBRT",NULL);
INSERT INTO hebrew_morpho VALUES (91538,"נַעֲרָה","n",NULL,"NA\'ARAH","נערה","נערה",NULL,"N&RH","N&RH",NULL);
INSERT INTO hebrew_morpho VALUES (91539,"גְּבוּרָה","n",NULL,"GVURA","גבורה","גבורה",NULL,"GBWRH","GBWRH",NULL);
INSERT INTO hebrew_morpho VALUES (91540,"גְּדִי","n",NULL,"GDI","גדי","גדי",NULL,"GDI","GDI",NULL);
INSERT INTO hebrew_morpho VALUES (91541,"מַזַּל-גְּדִי","n",NULL,"MAZAL-GDI","מזל-גדי","מזל-גדי",NULL,"MZL-GDI","MZL-GDI",NULL);
INSERT INTO hebrew_morpho VALUES (91542,"גְּדוּד","n",NULL,"GDUD","גדוד","גדוד",NULL,"GDWD","GDWD",NULL);
INSERT INTO hebrew_morpho VALUES (91543,"חָלוּק","n",NULL,"HALOOK","חלוק","חלוק",NULL,"XLWQ","XLWQ",NULL);
INSERT INTO hebrew_morpho VALUES (91544,"גְּלִימָה","n",NULL,"GLIMA","גלימה","גלימה",NULL,"GLIMH","GLIMH",NULL);
INSERT INTO hebrew_morpho VALUES (91545,"שִׂמְלָה","n",NULL,"SIMLA","שימלה","שמלה",NULL,"$MLH","$IMLH",NULL);
INSERT INTO hebrew_morpho VALUES (91546,"גְּלָלִים","n",NULL,"GLALIM","גללים","גללים",NULL,"GLLIM","GLLIM",NULL);
INSERT INTO hebrew_morpho VALUES (91547,"גְּלוּיָה","n",NULL,"GLUYA","גלויה","גלויה",NULL,"GLWIH","GLWIH",NULL);
INSERT INTO hebrew_morpho VALUES (91548,"גְּלוּיוֹת","r",NULL,"GLUYOT","גלויות","גלויות",NULL,"GLWIWT","GLWIWT",NULL);
INSERT INTO hebrew_morpho VALUES (91549,"גְּלוּלָה","n",NULL,"GLULA","גלולה","גלולה",NULL,"GLWLH","GLWLH",NULL);
INSERT INTO hebrew_morpho VALUES (91550,"גְּנֵבָה","n",NULL,"GNEVA","גניבה","גנבה",NULL,"GNBH","GNIBH",NULL);
INSERT INTO hebrew_morpho VALUES (91551,"גְּעָרָה","n",NULL,"GE\'ARAH","גערה","גערה",NULL,"G&RH","G&RH",NULL);
INSERT INTO hebrew_morpho VALUES (91552,"גְּרִימָה","n",NULL,"GRIMA","גרימה","גרימה",NULL,"GRIMH","GRIMH",NULL);
INSERT INTO hebrew_morpho VALUES (91553,"גְּרִיסִים","n",NULL,"GRISIM","גריסים","גריסים",NULL,"GRISIM","GRISIM",NULL);
INSERT INTO hebrew_morpho VALUES (91554,"גְּרִירָה","n",NULL,"GRIRA","גרירה","גרירה",NULL,"GRIRH","GRIRH",NULL);
INSERT INTO hebrew_morpho VALUES (91555,"גִּבְעָה","n",NULL,"GIV\'AH","גבעה","גבעה",NULL,"GB&H","GB&H",NULL);
INSERT INTO hebrew_morpho VALUES (91556,"גַּבְנוּן","n",NULL,"GAVNUN","גבנון","גבנון",NULL,"GBNWN","GBNWN",NULL);
INSERT INTO hebrew_morpho VALUES (91557,"גִּבֵּן","n",NULL,"GIBEN","גיבן","גבן",NULL,"GBN","GIBN",NULL);
INSERT INTO hebrew_morpho VALUES (91558,"הִכְפִּישׁ","v",NULL,"HICHPISH","הכפיש","הכפיש",NULL,"HKPI$","HKPI$",NULL);
INSERT INTO hebrew_morpho VALUES (91559,"גִּדּוּל","n",NULL,"GIDUL","גידול","גדול",NULL,"GDWL","GIDWL",NULL);
INSERT INTO hebrew_morpho VALUES (91560,"גִּהֵץ","v",NULL,"GIHETZ","גיהץ","גהץ",NULL,"GHC","GIHC",NULL);
INSERT INTO hebrew_morpho VALUES (91561,"גִּהֵק","v",NULL,"GIHEK","גיהק","גהק",NULL,"GHQ","GIHQ",NULL);
INSERT INTO hebrew_morpho VALUES (91562,"גִּהוּץ","n",NULL,NULL,"גיהוץ","גהוץ",NULL,"GHWC","GIHWC",NULL);
INSERT INTO hebrew_morpho VALUES (91563,"גִּהוּק","n",NULL,NULL,"גיהוק","גהוק",NULL,"GHWQ","GIHWQ",NULL);
INSERT INTO hebrew_morpho VALUES (91564,"גִּזְבָּר","n",NULL,"GIZBAR","גזבר","גזבר",NULL,"GZBR","GZBR",NULL);
INSERT INTO hebrew_morpho VALUES (91565,"גִּזְעִי","a",NULL,"GIZ\'EE","גזעי","גִּזְעִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (91566,"גִּזְעָנִי","a",NULL,"GIZ\'ANI","גזעני","גזעני",NULL,"GZ&NI","GZ&NI",NULL);
INSERT INTO hebrew_morpho VALUES (91567,"גִּזְעָנוּת","n",NULL,"GIZ\'ANUT","גזענות","גזענות",NULL,"GZ&NWT","GZ&NWT",NULL);
INSERT INTO hebrew_morpho VALUES (91568,"גִּזְרָה","n",NULL,"GIZRA","גזרה","גזרה",NULL,"GZRH","GZRH",NULL);
INSERT INTO hebrew_morpho VALUES (91569,"לַעַג","n",NULL,"LA\'AG","לעג","לעג",NULL,"L&G","L&G",NULL);
INSERT INTO hebrew_morpho VALUES (91570,"גִּיּוּס","n",NULL,"GIYUS","גיוס","גיוס",NULL,"GIWS","GIWS",NULL);
INSERT INTO hebrew_morpho VALUES (91571,"גִּיר","n",NULL,NULL,"גיר","גיר",NULL,"GIR","GIR",NULL);
INSERT INTO hebrew_morpho VALUES (91572,"גִּלּוּחַ","n",NULL,NULL,"גילוח","גלוח",NULL,"GLWX","GILWX",NULL);
INSERT INTO hebrew_morpho VALUES (91573,"גִּלּוּי","n",NULL,"GILUY","גילוי","גלוי",NULL,"GLWI","GILWI",NULL);
INSERT INTO hebrew_morpho VALUES (91574,"גִּמְגֵּם","v",NULL,"GIMGEM","גימגם","גמגם",NULL,"GMGM","GIMGM",NULL);
INSERT INTO hebrew_morpho VALUES (91575,"גִּמְגּוּם","n",NULL,"GIMGUM","גימגום","גמגום",NULL,"GMGWM","GIMGWM",NULL);
INSERT INTO hebrew_morpho VALUES (91576,"גִּנָּה","n",NULL,"GINA","גינה","גנה",NULL,"GNH","GINH",NULL);
INSERT INTO hebrew_morpho VALUES (91577,"גִּרְגֵּר","v",NULL,"GIRGER","גירגר","גרגר",NULL,"GRGR","GIRGR",NULL);
INSERT INTO hebrew_morpho VALUES (91578,"גֵּאֶה","a",NULL,"GE\'EH","גאה","גאה",NULL,"GAH","GAH",NULL);
INSERT INTO hebrew_morpho VALUES (91579,"גֵּאוּת","n",NULL,"GE\'UT","גיאות","גאות",NULL,"GAWT","GIAWT",NULL);
INSERT INTO hebrew_morpho VALUES (91580,"גֵּרוּשִׁין","n",NULL,"GERUSHIN","גירושין","גרושין",NULL,"GRW$IN","GIRW$IN",NULL);
INSERT INTO hebrew_morpho VALUES (91581,"גֵּרוּשׁ","n",NULL,"GERUSH","גירוש","גרוש",NULL,"GRW$","GIRW$",NULL);
INSERT INTO hebrew_morpho VALUES (91582,"גֶּבֶס","n",NULL,"GEVES","גבס","גבס",NULL,"GBS","GBS",NULL);
INSERT INTO hebrew_morpho VALUES (91583,"גּוּמִי","n",NULL,"GOOMI","גומי","גומי",NULL,"GWMI","GWMI",NULL);
INSERT INTO hebrew_morpho VALUES (91584,"מָאצ\'וֹ","n",NULL,"MACHO","מאצ\'ו","מאצ\'ו",NULL,"MAC\'W","MAC\'W",NULL);
INSERT INTO hebrew_morpho VALUES (91585,"גֶּזַע","n",NULL,"GEZA","גזע","גזע",NULL,"GZ&","GZ&",NULL);
INSERT INTO hebrew_morpho VALUES (91586,"מְטַפֵּס","n",NULL,"METAPES","מטפס","מטפס",NULL,"M@PS","M@PS",NULL);
INSERT INTO hebrew_morpho VALUES (91587,"שַׁרְווּל-רוּחַ","n",NULL,"SHARVUL-RUACH","שרוול-רוח","שרוול-רוח",NULL,"$RWWL-RWX","$RWWL-RWX",NULL);
INSERT INTO hebrew_morpho VALUES (91588,"גֶּרֶב","n",NULL,"GEREV","גרב","גרב",NULL,"GRB","GRB",NULL);
INSERT INTO hebrew_morpho VALUES (91589,"גֶּשֶׁם","n",NULL,"GESHEM","גשם","גשם",NULL,"G$M","G$M",NULL);
INSERT INTO hebrew_morpho VALUES (91590,"גַּאַוְתָן","a",NULL,"GA\'AVTAN","גאוותן","גאותן",NULL,"GAWTN","GAWWTN",NULL);
INSERT INTO hebrew_morpho VALUES (91591,"גַּב","n",NULL,"GAV","גב","גב",NULL,"GB","GB",NULL);
INSERT INTO hebrew_morpho VALUES (91592,"גַּבָּה","n",NULL,"GABAH","גבה","גבה",NULL,"GBH","GBH",NULL);
INSERT INTO hebrew_morpho VALUES (91593,"גַּג","n",NULL,"GAG","גג","גג",NULL,"GG","GG",NULL);
INSERT INTO hebrew_morpho VALUES (91594,"קְלוֹץ","n",NULL,"KLOTZ","קלוץ","קלוץ",NULL,"QLWC","QLWC",NULL);
INSERT INTO hebrew_morpho VALUES (91595,"גַּיִס","n",NULL,"GAYIS","גיס","גיס",NULL,"GIS","GIS",NULL);
INSERT INTO hebrew_morpho VALUES (91596,"גַּלְעֵד","n",NULL,"GAL\'ED","גלעד","גלעד",NULL,"GL&D","GL&D",NULL);
INSERT INTO hebrew_morpho VALUES (91597,"גַּלְשָׁן","n",NULL,"GALSHAN","גלשן","גלשן",NULL,"GL$N","GL$N",NULL);
INSERT INTO hebrew_morpho VALUES (91598,"גַּמָּד","n",NULL,"GAMAD","גמד","גמד",NULL,"GMD","GMD",NULL);
INSERT INTO hebrew_morpho VALUES (91599,"גַּן","n",NULL,"GAN","גן","גן",NULL,"GN","GN",NULL);
INSERT INTO hebrew_morpho VALUES (91600,"גַּנְדְּרָן","n",NULL,"GANDRAN","גנדרן","גנדרן",NULL,"GNDRN","GNDRN",NULL);
INSERT INTO hebrew_morpho VALUES (91601,"גַּנְזַךְ","n",NULL,"GANZACH","גנזך","גנזך",NULL,"GNZK","GNZK",NULL);
INSERT INTO hebrew_morpho VALUES (91602,"גַּנָּב","n",NULL,"GANAV","גנב","גנב",NULL,"GNB","GNB",NULL);
INSERT INTO hebrew_morpho VALUES (91603,"גַּעְגּוּעִים","n",NULL,"GA\'AGU\'IM","געגועים","געגועים",NULL,"G&GW&IM","G&GW&IM",NULL);
INSERT INTO hebrew_morpho VALUES (91604,"גַּרְזֶן","n",NULL,"GARZEN","גרזן","גרזן",NULL,"GRZN","GRZN",NULL);
INSERT INTO hebrew_morpho VALUES (91605,"גַּרְעִין","n",NULL,"GAR\'IN","גרעין","גרעין",NULL,"GR&IN","GR&IN",NULL);
INSERT INTO hebrew_morpho VALUES (91606,"גַּרְעִינִים","n",NULL,"GAR\'INIM","גרעינים","גרעינים",NULL,"GR&INIM","GR&INIM",NULL);
INSERT INTO hebrew_morpho VALUES (91607,"גַּשָּׁשׁ","n",NULL,"GASHASH","גשש","גשש",NULL,"G$$","G$$","male");
INSERT INTO hebrew_morpho VALUES (91608,"גָּדֵר","n",NULL,"GADER","גדר","גדר",NULL,"GDR","GDR",NULL);
INSERT INTO hebrew_morpho VALUES (91609,"גִּמֵּר","v",NULL,"GIMER","גימר","גמר",NULL,"GMR","GIMR",NULL);
INSERT INTO hebrew_morpho VALUES (91610,"הֶעֱלָה","v",NULL,"HE\'ELAH","העלה","העלה",NULL,"H&LH","H&LH",NULL);
INSERT INTO hebrew_morpho VALUES (91611,"מְבֻגָּר","n",NULL,"MEVUGAR","מבוגר","מבגר",NULL,"MBGR","MBWGR",NULL);
INSERT INTO hebrew_morpho VALUES (91612,"מְעֹרָם","a",NULL,"ME\'ORAM","מעורם","מערם",NULL,"M&RM","M&WRM",NULL);
INSERT INTO hebrew_morpho VALUES (91613,"גָּוֶן","n",NULL,"GAVEN","גוון","גון",NULL,"GWN","GWWN",NULL);
INSERT INTO hebrew_morpho VALUES (91614,"גָּזַז","v",NULL,"GAZAZ","גזז","גזז",NULL,"GZZ","GZZ",NULL);
INSERT INTO hebrew_morpho VALUES (91615,"גָּלְמִי","a",NULL,"GOLMI","גולמי","גלמי",NULL,"GLMI","GWLMI",NULL);
INSERT INTO hebrew_morpho VALUES (91616,"גָּלַשׁ","v",NULL,"GALASH","גלש","גלש",NULL,"GL$","GL$",NULL);
INSERT INTO hebrew_morpho VALUES (91617,"גּוֹלֶה","n",NULL,"GOLE","גולה","גולה",NULL,"GWLH","GWLH",NULL);
INSERT INTO hebrew_morpho VALUES (91618,"הַגְלָיָה","n",NULL,"HAGLAYA","הגליה","הגליה",NULL,"HGLIH","HGLIH",NULL);
INSERT INTO hebrew_morpho VALUES (91619,"גָּמִישׁ","a",NULL,"GAMISH","גמיש","גמיש",NULL,"GMI$","GMI$",NULL);
INSERT INTO hebrew_morpho VALUES (91620,"גָּמָל","n",NULL,"GAMAL","גמל","גמל",NULL,"GML","GML",NULL);
INSERT INTO hebrew_morpho VALUES (91621,"גָּפְרִית","n",NULL,"GOFRIT","גופרית","גפרית",NULL,"GPRIT","GWPRIT",NULL);
INSERT INTO hebrew_morpho VALUES (91622,"גָּפְרָה","n",NULL,"GOFRA","גופרה","גפרה",NULL,"GPRH","GWPRH",NULL);
INSERT INTO hebrew_morpho VALUES (91623,"רוּם","n",NULL,"ROOM","רום","רום",NULL,"RWM","RWM",NULL);
INSERT INTO hebrew_morpho VALUES (91624,"רוֹבּוֹט","n",NULL,"ROBOT","רובוט","רובוט",NULL,"RWBW@","RWBW@",NULL);
INSERT INTO hebrew_morpho VALUES (91625,"גּוֹאֵל","n",NULL,"GO\'EL","גואל","גואל",NULL,"GWAL","GWAL",NULL);
INSERT INTO hebrew_morpho VALUES (91626,"גּוֹזָל","n",NULL,"GOZAL","גוזל","גוזל",NULL,"GWZL","GWZL",NULL);
INSERT INTO hebrew_morpho VALUES (91627,"נָמוּךְ","a",NULL,"NAMUCH","נמוך","נמוך",NULL,"NMWK","NMWK",NULL);
INSERT INTO hebrew_morpho VALUES (91628,"גֹּלֶם","n",NULL,"GOLEM","גולם","גלם",NULL,"GLM","GWLM",NULL);
INSERT INTO hebrew_morpho VALUES (91629,"דְּאָגָה","n",NULL,"DE\'AGA","דאגה","דאגה",NULL,"DAGH","DAGH",NULL);
INSERT INTO hebrew_morpho VALUES (91630,"דָּחוּף","a",NULL,"DACHUF","דחוף","דחוף",NULL,"DXWP","DXWP",NULL);
INSERT INTO hebrew_morpho VALUES (91631,"הֲבָרָה","n",NULL,"HAVARA","הברה","הברה",NULL,"HBRH","HBRH",NULL);
INSERT INTO hebrew_morpho VALUES (91632,"הֲגִיָּה","n",NULL,"HAGIYA","הגייה","הגיה",NULL,"HGIH","HGIIH",NULL);
INSERT INTO hebrew_morpho VALUES (91633,"הֲגִירָה-נִכְנֶסֶת","n",NULL,"HAGIRA-NICHNESET","הגירה-נכנסת","הגירה-נכנסת",NULL,"HGIRH-NKNST","HGIRH-NKNST",NULL);
INSERT INTO hebrew_morpho VALUES (91634,"הֲדִיפָה","n",NULL,"HADIFA","הדיפה","הדיפה",NULL,"HDIPH","HDIPH",NULL);
INSERT INTO hebrew_morpho VALUES (91635,"הֲדָדִי","a",NULL,"HADADI","הדדי","הדדי",NULL,"HDDI","HDDI",NULL);
INSERT INTO hebrew_morpho VALUES (91636,"הֲזָיָה","n",NULL,"HAZAYA","הזיה","הזיה",NULL,"HZIH","HZIH",NULL);
INSERT INTO hebrew_morpho VALUES (91637,"הֲזָנָה","n",NULL,"HAZANA","הזנה","הזנה",NULL,"HZNH","HZNH",NULL);
INSERT INTO hebrew_morpho VALUES (91638,"הֲטָלָה","n",NULL,"HATALA","הטלה","הטלה",NULL,"H@LH","H@LH",NULL);
INSERT INTO hebrew_morpho VALUES (91639,"הֲמוֹנִי","a",NULL,"HAMONI","המוני","המוני",NULL,"HMWNI","HMWNI",NULL);
INSERT INTO hebrew_morpho VALUES (91640,"הֲפֵכָה","n",NULL,"HAFECHA","הפכה","הפכה",NULL,"HPKH","HPKH",NULL);
INSERT INTO hebrew_morpho VALUES (91641,"הֲצָפָה","n",NULL,"HATZAFA","הצפה","הצפה",NULL,"HCPH","HCPH",NULL);
INSERT INTO hebrew_morpho VALUES (91642,"הֲצָצָה","n",NULL,"HATZATZA","הצצה","הצצה",NULL,"HCCH","HCCH",NULL);
INSERT INTO hebrew_morpho VALUES (91643,"הֲקָאָה","n",NULL,"HAKA\'AH","הקאה","הקאה",NULL,"HQAH","HQAH",NULL);
INSERT INTO hebrew_morpho VALUES (91644,"הִבְהֵב","v",NULL,"HIVHEV","הבהב","הבהב",NULL,"HBHB","HBHB",NULL);
INSERT INTO hebrew_morpho VALUES (91645,"הִבְהֵב","v",NULL,NULL,NULL,"הבהב",NULL,"HBHB",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (91646,"הִגְזִים","v",NULL,"HIGZIM","הגזים","הגזים",NULL,"HGZIM","HGZIM",NULL);
INSERT INTO hebrew_morpho VALUES (91647,"הִגֵּר","v",NULL,"HIGER","היגר","הגר",NULL,"HGR","HIGR",NULL);
INSERT INTO hebrew_morpho VALUES (91648,"הִדְפִּיס","v",NULL,"HIDPIS","הדפיס","הדפיס",NULL,"HDPIS","HDPIS",NULL);
INSERT INTO hebrew_morpho VALUES (91649,"הִדַּרְדֵּר","v",NULL,"HIDDARDER","הידרדר","הדרדר",NULL,"HDRDR","HIDRDR",NULL);
INSERT INTO hebrew_morpho VALUES (91650,"הִדּוּק","n",NULL,"HIDUK","הידוק","הדוק",NULL,"HDWQ","HIDWQ",NULL);
INSERT INTO hebrew_morpho VALUES (91651,"הֵזִּיעַ","v",NULL,"HEZI\'A","הזיע","הזיע",NULL,"HZI&","HZI&",NULL);
INSERT INTO hebrew_morpho VALUES (91652,"הִטְבִּיל","v",NULL,"HITBIL","הטביל","הטביל",NULL,"H@BIL","H@BIL",NULL);
INSERT INTO hebrew_morpho VALUES (91653,"הִלְאִים","v",NULL,"HIL\'IM","הלאים","הלאים",NULL,"HLAIM","HLAIM",NULL);
INSERT INTO hebrew_morpho VALUES (91654,"הִלְחִים","v",NULL,"HILCHIM","הלחים","הלחים",NULL,"HLXIM","HLXIM",NULL);
INSERT INTO hebrew_morpho VALUES (91655,"הִלָּה","n",NULL,"HILA","הילה","הלה",NULL,"HLH","HILH",NULL);
INSERT INTO hebrew_morpho VALUES (91656,"הִמָּנְעוּת","n",NULL,"HIMAN\'UT","הימנעות","המנעות",NULL,"HMN&WT","HIMN&WT",NULL);
INSERT INTO hebrew_morpho VALUES (91657,"הִמּוּר","n",NULL,"HIMUR","הימור","המור",NULL,"HMWR","HIMWR",NULL);
INSERT INTO hebrew_morpho VALUES (91658,"הִנְצִיחַ","v",NULL,"HINTZI\'ACH","הנציח","הנציח",NULL,"HNCIX","HNCIX",NULL);
INSERT INTO hebrew_morpho VALUES (91659,"הִסְרִיחַ","v",NULL,"HISRI\'ACH","הסריח","הסריח",NULL,"HSRIX","HSRIX",NULL);
INSERT INTO hebrew_morpho VALUES (91660,"הִסְתַּגְּלוּת","n",NULL,"HISTAGLUT","הסתגלות","הסתגלות",NULL,"HSTGLWT","HSTGLWT",NULL);
INSERT INTO hebrew_morpho VALUES (91661,"הִסְתַּיֵּם","v",NULL,"HISTAYEM","הסתיים","הסתים",NULL,"HSTIM","HSTIIM",NULL);
INSERT INTO hebrew_morpho VALUES (91662,"הִסְתַּלְּקוּת","n",NULL,"HISTALKUT","הסתלקות","הסתלקות",NULL,"HSTLQWT","HSTLQWT",NULL);
INSERT INTO hebrew_morpho VALUES (91663,"הִסּוּס","n",NULL,"HISUS","היסוס","הסוס",NULL,"HSWS","HISWS",NULL);
INSERT INTO hebrew_morpho VALUES (91664,"הִפְרִישׁ","v",NULL,"HIFRISH","הפריש","הפריש",NULL,"HPRI$","HPRI$",NULL);
INSERT INTO hebrew_morpho VALUES (91665,"הִצְהִיב","v",NULL,"HITZHIV","הצהיב","הצהיב",NULL,"HCHIB","HCHIB",NULL);
INSERT INTO hebrew_morpho VALUES (91666,"הִצְטַמֵּק","v",NULL,"HITZTAMEK","הצטמק","הצטמק",NULL,"HC@MQ","HC@MQ",NULL);
INSERT INTO hebrew_morpho VALUES (91667,"הִרְדִּים","v",NULL,"HIRDIM","הרדים","הרדים",NULL,"HRDIM","HRDIM",NULL);
INSERT INTO hebrew_morpho VALUES (91668,"הִרְוָה","v",NULL,"HIRVA","הרווה","הרוה",NULL,"HRWH","HRWWH",NULL);
INSERT INTO hebrew_morpho VALUES (91669,"הִרְזָה","v",NULL,"HIRZA","הרזה","הרזה",NULL,"HRZH","HRZH",NULL);
INSERT INTO hebrew_morpho VALUES (91670,"הִרְכִּיב","v",NULL,"HIRKIV","הרכיב","הרכיב",NULL,"HRKIB","HRKIB",NULL);
INSERT INTO hebrew_morpho VALUES (91671,"הִשְׁתִּיל","v",NULL,"HISHTIL","השתיל","השתיל",NULL,"H$TIL","H$TIL",NULL);
INSERT INTO hebrew_morpho VALUES (91672,"הִשְׁתִּין","v",NULL,"HISHTIN","השתין","השתין",NULL,"H$TIN","H$TIN",NULL);
INSERT INTO hebrew_morpho VALUES (91673,"הִשְׁתַּעֵל","v",NULL,"HISHTA\'EL","השתעל","השתעל",NULL,"H$T&L","H$T&L",NULL);
INSERT INTO hebrew_morpho VALUES (91674,"הִתְאַדָּה","v",NULL,"HIT\'ADA","התאדה","התאדה",NULL,"HTADH","HTADH",NULL);
INSERT INTO hebrew_morpho VALUES (91675,"הִתְאַדּוּת","n",NULL,"HIT\'ADUT","התאדות","התאדות",NULL,"HTADWT","HTADWT",NULL);
INSERT INTO hebrew_morpho VALUES (91676,"הִתְאַכְסֵן","v",NULL,"HIT\'ACHSEN","התאכסן","התאכסן",NULL,"HTAKSN","HTAKSN",NULL);
INSERT INTO hebrew_morpho VALUES (91677,"הֶאֱרִיךְ","v",NULL,"HE\'ERICH","האריך","האריך",NULL,"HARIK","HARIK",NULL);
INSERT INTO hebrew_morpho VALUES (91678,"הִתְאָרֵךְ","v",NULL,"HIT\'ARECH","התארך","התארך",NULL,"HTARK","HTARK",NULL);
INSERT INTO hebrew_morpho VALUES (91679,"הִתְבַּדֵּחַ","v",NULL,"HITBADE\'ACH","התבדח","התבדח",NULL,"HTBDX","HTBDX",NULL);
INSERT INTO hebrew_morpho VALUES (91680,"הִתְגַּבְּשׁוּת","n",NULL,"HITGABSHUT","התגבשות","התגבשות",NULL,"HTGB$WT","HTGB$WT",NULL);
INSERT INTO hebrew_morpho VALUES (91681,"הִתְגּוֹנְנוּת","n",NULL,"HITGONENUT","התגוננות","התגוננות",NULL,"HTGWNNWT","HTGWNNWT",NULL);
INSERT INTO hebrew_morpho VALUES (91682,"הִתְהַוָּה","v",NULL,"HITHAVA","התהווה","התהוה",NULL,"HTHWH","HTHWWH",NULL);
INSERT INTO hebrew_morpho VALUES (91683,"הִתְחַמְצֵן","v",NULL,"HITCHAMTZEN","התחמצן","התחמצן",NULL,"HTXMCN","HTXMCN",NULL);
INSERT INTO hebrew_morpho VALUES (91684,"הִתְחָרָה","v",NULL,"HITCHARA","התחרה","התחרה",NULL,"HTXRH","HTXRH",NULL);
INSERT INTO hebrew_morpho VALUES (91685,"הִתְיַבֵּשׁ","v",NULL,"HITYABESH","התייבש","התיבש",NULL,"HTIB$","HTIIB$",NULL);
INSERT INTO hebrew_morpho VALUES (91686,"הִתְיַעֲצוּת","n",NULL,"HITYA\'ATZUT","התייעצות","התיעצות",NULL,"HTI&CWT","HTII&CWT",NULL);
INSERT INTO hebrew_morpho VALUES (91687,"הִתְיַפֵּחַ","v",NULL,"HITYAPE\'ACH","התייפח","התיפח",NULL,"HTIPX","HTIIPX",NULL);
INSERT INTO hebrew_morpho VALUES (91688,"הִתְיַצְּבוּת","n",NULL,"HITYATZVUT","התייצבות","התיצבות",NULL,"HTICBWT","HTIICBWT",NULL);
INSERT INTO hebrew_morpho VALUES (91689,"רְצוֹנִי","a",NULL,"RETZONI","רצוני","רצוני",NULL,"RCWNI","RCWNI",NULL);
INSERT INTO hebrew_morpho VALUES (91690,"הִתְנַדְּבוּתִי","a",NULL,"HITNADVUTI","התנדבותי","התנדבותי",NULL,"HTNDBWTI","HTNDBWTI",NULL);
INSERT INTO hebrew_morpho VALUES (91691,"הִתְנַדֵּף","v",NULL,"HITNADEF","התנדף","התנדף",NULL,"HTNDP","HTNDP",NULL);
INSERT INTO hebrew_morpho VALUES (91692,"הִתְנַמְנֵם","v",NULL,"HITNAMNEM","התנמנם","התנמנם",NULL,"HTNMNM","HTNMNM",NULL);
INSERT INTO hebrew_morpho VALUES (91693,"הִתְעַטְּשׁוּת","n",NULL,"HIT\'AT\'SHUT","התעטשות","התעטשות",NULL,"HT&@$WT","HT&@$WT",NULL);
INSERT INTO hebrew_morpho VALUES (91694,"הִתְעַטֵּשׁ","v",NULL,"HIT\'ATESH","התעטש","התעטש",NULL,"HT&@$","HT&@$",NULL);
INSERT INTO hebrew_morpho VALUES (91695,"הִתְעַלְּלוּת","n",NULL,"HIT\'ALELUT","התעללות","התעללות",NULL,"HT&LLWT","HT&LLWT",NULL);
INSERT INTO hebrew_morpho VALUES (91696,"הִתְעַלֵּל","v",NULL,"HIT\'ALEL","התעלל","התעלל",NULL,"HT&LL","HT&LL",NULL);
INSERT INTO hebrew_morpho VALUES (91697,"הִתְעַלֵּף","v",NULL,"HIT\'ALEF","התעלף","התעלף",NULL,"HT&LP","HT&LP",NULL);
INSERT INTO hebrew_morpho VALUES (91698,"הִתְעַמְּלוּת","n",NULL,"HIT\'AMLUT","התעמלות","התעמלות",NULL,"HT&MLWT","HT&MLWT",NULL);
INSERT INTO hebrew_morpho VALUES (91699,"הִתְפִּיל","v",NULL,"HITPIL","התפיל","התפיל",NULL,"HTPIL","HTPIL",NULL);
INSERT INTO hebrew_morpho VALUES (91700,"הִתְפַּטְּרוּת","n",NULL,"HITPATRUT","התפטרות","התפטרות",NULL,"HTP@RWT","HTP@RWT",NULL);
INSERT INTO hebrew_morpho VALUES (91701,"מִכְתָּב-הִתְפַּטְּרוּת","n",NULL,"MICHTAV-HITPATRUT","מכתב-התפטרות","מכתב-התפטרות",NULL,"MKTB-HTP@RWT","MKTB-HTP@RWT",NULL);
INSERT INTO hebrew_morpho VALUES (91702,"הִתְפַּלְסֵף","v",NULL,"HITPALSEF","התפלסף","התפלסף",NULL,"HTPLSP","HTPLSP",NULL);
INSERT INTO hebrew_morpho VALUES (91703,"הִתְפַּלֵּא","v",NULL,"HITPALE","התפלא","התפלא",NULL,"HTPLA","HTPLA",NULL);
INSERT INTO hebrew_morpho VALUES (91704,"הִתְפַּלֵּל","v",NULL,"HITPALEL","התפלל","התפלל",NULL,"HTPLL","HTPLL",NULL);
INSERT INTO hebrew_morpho VALUES (91705,"הִתְפַּשֵּׁר","v",NULL,"HITPASHER","התפשר","התפשר",NULL,"HTP$R","HTP$R",NULL);
INSERT INTO hebrew_morpho VALUES (91706,"הִתְפַּתְּחוּת","n",NULL,"HITPATCHUT","התפתחות","התפתחות",NULL,"HTPTXWT","HTPTXWT",NULL);
INSERT INTO hebrew_morpho VALUES (91707,"הִתְפָּרְצוּת","n",NULL,"HITPARTZUT","התפרצות","התפרצות",NULL,"HTPRCWT","HTPRCWT",NULL);
INSERT INTO hebrew_morpho VALUES (91708,"הִתְקַלְקֵל","v",NULL,"HITKALKEL","התקלקל","התקלקל",NULL,"HTQLQL","HTQLQL",NULL);
INSERT INTO hebrew_morpho VALUES (91709,"הִתְרַבְרֵב","v",NULL,"HITRAVREV","התרברב","התרברב",NULL,"HTRBRB","HTRBRB",NULL);
INSERT INTO hebrew_morpho VALUES (91710,"הִתְרַחֲשׁוּת","n",NULL,"HITRACHASHUT","התרחשות","התרחשות",NULL,"HTRX$WT","HTRX$WT",NULL);
INSERT INTO hebrew_morpho VALUES (91711,"הִתְרַכְּכוּת","n",NULL,"HITRAKCHUT","התרככות","התרככות",NULL,"HTRKKWT","HTRKKWT",NULL);
INSERT INTO hebrew_morpho VALUES (91712,"הִתְרָה","v",NULL,"HITRA","התרה","התרה",NULL,"HTRH","HTRH",NULL);
INSERT INTO hebrew_morpho VALUES (91713,"הִתְרוֹשְׁשׁוּת","n",NULL,"HITROSHESHUT","התרוששות","התרוששות",NULL,"HTRW$$WT","HTRW$$WT",NULL);
INSERT INTO hebrew_morpho VALUES (91714,"הִתִּיךְ","v",NULL,"HITICH","התיך","התיך",NULL,"HTIK","HTIK",NULL);
INSERT INTO hebrew_morpho VALUES (91715,"הִתִּיר","v",NULL,"HITIR","התיר","התיר",NULL,"HTIR","HTIR",NULL);
INSERT INTO hebrew_morpho VALUES (91716,"הֵבִין","v",NULL,"HEVIN","הבין","הבין",NULL,"HBIN","HBIN",NULL);
INSERT INTO hebrew_morpho VALUES (91717,"הֵעֵז","v",NULL,"HE\'EZ","העז","העז",NULL,"H&Z","H&Z",NULL);
INSERT INTO hebrew_morpho VALUES (91718,"הֵצִיץ","v",NULL,"HETZITZ","הציץ","הציץ",NULL,"HCIC","HCIC",NULL);
INSERT INTO hebrew_morpho VALUES (91719,"הֵצֵר","v",NULL,"HETZER","הצר","הצר",NULL,"HCR","HCR",NULL);
INSERT INTO hebrew_morpho VALUES (91720,"הֵקִיא","v",NULL,"HEKI","הקיא","הקיא",NULL,"HQIA","HQIA",NULL);
INSERT INTO hebrew_morpho VALUES (91721,"הֵרָיוֹן","n",NULL,"HERAYON","היריון","הריון",NULL,"HRIWN","HIRIWN",NULL);
INSERT INTO hebrew_morpho VALUES (91722,"הֵשִׁיב","v",NULL,"HESHIV","השיב","השיב",NULL,"H$IB","H$IB",NULL);
INSERT INTO hebrew_morpho VALUES (91723,"הֶאָטָה","n",NULL,"HE\'ATA","האטה","האטה",NULL,"HA@H","HA@H",NULL);
INSERT INTO hebrew_morpho VALUES (91724,"הֶגְמוֹנְיָה","n",NULL,"HEGMONYA","הגמוניה","הגמוניה",NULL,"HGMWNIH","HGMWNIH",NULL);
INSERT INTO hebrew_morpho VALUES (91725,"הֶחֱיָה","v",NULL,"HECHEYA","החיה","החיה",NULL,"HXIH","HXIH",NULL);
INSERT INTO hebrew_morpho VALUES (91726,"הֶחְנָה","v",NULL,"HECHNA","החנה","החנה",NULL,"HXNH","HXNH",NULL);
INSERT INTO hebrew_morpho VALUES (91727,"הֶפְסֵד","n",NULL,"HEFSED","הפסד","הפסד",NULL,"HPSD","HPSD",NULL);
INSERT INTO hebrew_morpho VALUES (91728,"הֶשֵּׂג","n",NULL,"HESEG","השג","השג",NULL,"H$G","H$G",NULL);
INSERT INTO hebrew_morpho VALUES (91729,"הַאֲרָכָה","n",NULL,"HA\'ARACHA","הארכה","הארכה",NULL,"HARKH","HARKH",NULL);
INSERT INTO hebrew_morpho VALUES (91730,"הַאֲרָקָה","n",NULL,"HA\'ARAKA","הארקה","הארקה",NULL,"HARQH","HARQH",NULL);
INSERT INTO hebrew_morpho VALUES (91731,"הַבְטָחָה","n",NULL,"HAVTACHA","הבטחה","הבטחה",NULL,"HB@XH","HB@XH",NULL);
INSERT INTO hebrew_morpho VALUES (91732,"הַבְרָחָה","n",NULL,"HAVRACHA","הברחה","הברחה",NULL,"HBRXH","HBRXH",NULL);
INSERT INTO hebrew_morpho VALUES (91733,"הַגְבָּלָה","n",NULL,"HAGBALA","הגבלה","הגבלה",NULL,"HGBLH","HGBLH",NULL);
INSERT INTO hebrew_morpho VALUES (91734,"מִגְבָּלָה","n",NULL,"MIGBALA","מגבלה","מגבלה",NULL,"MGBLH","MGBLH",NULL);
INSERT INTO hebrew_morpho VALUES (91735,"הַגְבָּרָה","n",NULL,"HAGBARA","הגברה","הגברה",NULL,"HGBRH","HGBRH",NULL);
INSERT INTO hebrew_morpho VALUES (91736,"הַגְזָמָה","n",NULL,"HAGZAMA","הגזמה","הגזמה",NULL,"HGZMH","HGZMH",NULL);
INSERT INTO hebrew_morpho VALUES (91737,"הִיפֶּרְבּוֹלָה","n",NULL,"HIPERBOLA","היפרבולה","היפרבולה",NULL,"HIPRBWLH","HIPRBWLH",NULL);
INSERT INTO hebrew_morpho VALUES (91738,"הַדְפָּסָה","n",NULL,"HADPASA","הדפסה","הדפסה",NULL,"HDPSH","HDPSH",NULL);
INSERT INTO hebrew_morpho VALUES (91739,"מְדֹרָג","a",NULL,"MEDORAG","מדורג","מדרג",NULL,"MDRG","MDWRG",NULL);
INSERT INTO hebrew_morpho VALUES (91740,"הַדְרָגָתִי","a",NULL,"HADRAGATI","הדרגתי","הדרגתי",NULL,"HDRGTI","HDRGTI",NULL);
INSERT INTO hebrew_morpho VALUES (91741,"הַדְרָכָה","n",NULL,"HADRACHA","הדרכה","הדרכה",NULL,"HDRKH","HDRKH",NULL);
INSERT INTO hebrew_morpho VALUES (91742,"הַדְרָן","n",NULL,"HADRAN","הדרן","הדרן",NULL,"HDRN","HDRN",NULL);
INSERT INTO hebrew_morpho VALUES (91743,"הַזְמָנָה","n",NULL,"HAZMANA","הזמנה","הזמנה",NULL,"HZMNH","HZMNH",NULL);
INSERT INTO hebrew_morpho VALUES (91744,"הַזְרָעָה","n",NULL,"HAZRA\'AH","הזרעה","הזרעה",NULL,"HZR&H","HZR&H",NULL);
INSERT INTO hebrew_morpho VALUES (91745,"הַחְיָאָה","n",NULL,"HACHYA\'AH","החייאה","החיאה",NULL,"HXIAH","HXIIAH",NULL);
INSERT INTO hebrew_morpho VALUES (91746,"הַחְלָמָה","n",NULL,"HACHLAMA","החלמה","החלמה",NULL,"HXLMH","HXLMH",NULL);
INSERT INTO hebrew_morpho VALUES (91747,"הִתְאוֹשְׁשׁוּת","n",NULL,"HITOSHESHUT","התאוששות","התאוששות",NULL,"HTAW$$WT","HTAW$$WT",NULL);
INSERT INTO hebrew_morpho VALUES (91748,"הַחְלָשָׁה","n",NULL,"HACHLASHA","החלשה","החלשה",NULL,"HXL$H","HXL$H",NULL);
INSERT INTO hebrew_morpho VALUES (91749,"הַחְמָצָה","n",NULL,"HACHMATZA","החמצה","החמצה",NULL,"HXMCH","HXMCH",NULL);
INSERT INTO hebrew_morpho VALUES (91750,"הַחְרָמָה","n",NULL,"HACHRAMA","החרמה","החרמה",NULL,"HXRMH","HXRMH",NULL);
INSERT INTO hebrew_morpho VALUES (91751,"הַטְבָּלָה","n",NULL,"HATBALA","הטבלה","הטבלה",NULL,"H@BLH","H@BLH",NULL);
INSERT INTO hebrew_morpho VALUES (91752,"הַיְנוּ","r",NULL,"HAYNU","היינו","הינו",NULL,"HINW","HIINW",NULL);
INSERT INTO hebrew_morpho VALUES (91753,"הַכְתָּמָה","n",NULL,"HACHTAMA","הכתמה","הכתמה",NULL,"HKTMH","HKTMH",NULL);
INSERT INTO hebrew_morpho VALUES (91754,"הַכְתָּרָה","n",NULL,"HACHTARA","הכתרה","הכתרה",NULL,"HKTRH","HKTRH",NULL);
INSERT INTO hebrew_morpho VALUES (91755,"הַלְוָאָה","n",NULL,"HALVA\'AH","הלוואה","הלואה",NULL,"HLWAH","HLWWAH",NULL);
INSERT INTO hebrew_morpho VALUES (91756,"הַלְוָיָה","n",NULL,"HALVAYA","הלוויה","הלויה",NULL,"HLWIH","HLWWIH",NULL);
INSERT INTO hebrew_morpho VALUES (91757,"הַמְחָזָה","n",NULL,"HAMCHAZA","המחזה","המחזה",NULL,"HMXZH","HMXZH",NULL);
INSERT INTO hebrew_morpho VALUES (91758,"הַמְצָאָה","n",NULL,"HAMTZA\'AH","המצאה","המצאה",NULL,"HMCAH","HMCAH",NULL);
INSERT INTO hebrew_morpho VALUES (91759,"הַמְתָּקַת-דִּין","n",NULL,"HAMTAKAT-DIN","המתקת-דין","המתקת-דין",NULL,"HMTQT-DIN","HMTQT-DIN",NULL);
INSERT INTO hebrew_morpho VALUES (91760,"הַנְדָּסָה","n",NULL,"HANDASA","הנדסה","הנדסה",NULL,"HNDSH","HNDSH",NULL);
INSERT INTO hebrew_morpho VALUES (91761,"חֲדַר-מְנוֹעִים","n",NULL,"CHADAR-MENO\'IM","חדר-מנועים","חדר-מנועים",NULL,"XDR-MNW&IM","XDR-MNW&IM",NULL);
INSERT INTO hebrew_morpho VALUES (91762,"הַנְחָיָה","n",NULL,"HANCHAYA","הנחיה","הנחיה",NULL,"HNXIH","HNXIH",NULL);
INSERT INTO hebrew_morpho VALUES (91763,"הַנְמָכָה","n",NULL,"HANMACHA","הנמכה","הנמכה",NULL,"HNMKH","HNMKH",NULL);
INSERT INTO hebrew_morpho VALUES (91764,"נְשִׁימָה","n",NULL,"NESHIMA","נשימה","נשימה",NULL,"N$IMH","N$IMH",NULL);
INSERT INTO hebrew_morpho VALUES (91765,"הַסְגָּרָה","n",NULL,"HASGARA","הסגרה","הסגרה",NULL,"HSGRH","HSGRH",NULL);
INSERT INTO hebrew_morpho VALUES (91766,"עִבּוּד","n",NULL,"IBUD","עיבוד","עבוד",NULL,"&BWD","&IBWD",NULL);
INSERT INTO hebrew_morpho VALUES (91767,"הַעְתָּקָה","n",NULL,"HA\'ATAKA","העתקה","העתקה",NULL,"H&TQH","H&TQH",NULL);
INSERT INTO hebrew_morpho VALUES (91768,"הַפְצָצָה","n",NULL,"HAFTZATZA","הפצצה","הפצצה",NULL,"HPCCH","HPCCH",NULL);
INSERT INTO hebrew_morpho VALUES (91769,"הַפְקָעָה","n",NULL,"HAFKA\'AH","הפקעה","הפקעה",NULL,"HPQ&H","HPQ&H",NULL);
INSERT INTO hebrew_morpho VALUES (91770,"הַפְתָּעָה","n",NULL,"HAFTA\'AH","הפתעה","הפתעה",NULL,"HPT&H","HPT&H",NULL);
INSERT INTO hebrew_morpho VALUES (91771,"הַפָּלָה-טִבְעִית","n",NULL,"HAPALA-TIV\'IT","הפלה-טבעית","הפלה-טבעית",NULL,"HPLH-@B&IT","HPLH-@B&IT",NULL);
INSERT INTO hebrew_morpho VALUES (91772,"סְחוֹר-סְחוֹר","r",NULL,"SCHOR SCHOR","סחור-סחור","סחור-סחור",NULL,"SXWR-SXWR","SXWR-SXWR",NULL);
INSERT INTO hebrew_morpho VALUES (91773,"הַרְדּוּף","n",NULL,"HARDUF","הרדוף","הרדוף",NULL,"HRDWP","HRDWP",NULL);
INSERT INTO hebrew_morpho VALUES (91774,"הַרְחָבָה","n",NULL,"HARCHAVA","הרחבה","הרחבה",NULL,"HRXBH","HRXBH",NULL);
INSERT INTO hebrew_morpho VALUES (91775,"הַרְטָבָה","n",NULL,"HARTAVA","הרטבה","הרטבה",NULL,"HR@BH","HR@BH",NULL);
INSERT INTO hebrew_morpho VALUES (91776,"הַרְכָּבָה","n",NULL,"HARKAVA","הרכבה","הרכבה",NULL,"HRKBH","HRKBH",NULL);
INSERT INTO hebrew_morpho VALUES (91777,"הַרְמוֹן","n",NULL,"HARMON","הרמון","הרמון",NULL,"HRMWN","HRMWN",NULL);
INSERT INTO hebrew_morpho VALUES (91778,"הַרְפַּתְקָה","n",NULL,"HARPATKA","הרפתקה","הרפתקה",NULL,"HRPTQH","HRPTQH",NULL);
INSERT INTO hebrew_morpho VALUES (91779,"הַרְפַּתְקָנִי","a",NULL,"HARPATKANI","הרפתקני","הרפתקני",NULL,"HRPTQNI","HRPTQNI",NULL);
INSERT INTO hebrew_morpho VALUES (91780,"הַרְצָאָה","n",NULL,"HARTZA\'AH","הרצאה","הרצאה",NULL,"HRCAH","HRCAH",NULL);
INSERT INTO hebrew_morpho VALUES (91781,"הַרְשָׁמָה","n",NULL,"HARSHAMA","הרשמה","הרשמה",NULL,"HR$MH","HR$MH",NULL);
INSERT INTO hebrew_morpho VALUES (91782,"הַשְׁוָאָה","n",NULL,"HASHVA\'AH","השוואה","השואה",NULL,"H$WAH","H$WWAH",NULL);
INSERT INTO hebrew_morpho VALUES (91783,"אָדַפְּטַצְיָה","n",NULL,"ADAPTATZYA","אדפטציה","אדפטציה",NULL,"ADP@CIH","ADP@CIH",NULL);
INSERT INTO hebrew_morpho VALUES (91784,"הַשְׁתָּנָה","n",NULL,"HASHTANA","השתנה","השתנה",NULL,"H$TNH","H$TNH",NULL);
INSERT INTO hebrew_morpho VALUES (91785,"הַתְמָדָה","n",NULL,"HATMADA","התמדה","התמדה",NULL,"HTMDH","HTMDH",NULL);
INSERT INTO hebrew_morpho VALUES (91786,"הַתְפָּלָה","n",NULL,"HATPALA","התפלה","התפלה",NULL,"HTPLH","HTPLH",NULL);
INSERT INTO hebrew_morpho VALUES (91787,"הָבִיל","a",NULL,"HAVIL","הביל","הביל",NULL,"HBIL","HBIL",NULL);
INSERT INTO hebrew_morpho VALUES (91788,"הָפוּךְ","r",NULL,"HAFUCH","הפוך","הפוך",NULL,"HPWK","HPWK",NULL);
INSERT INTO hebrew_morpho VALUES (91789,"הֹדּוּ","n",NULL,"HODU","הודו","הדו",NULL,"HDW","HWDW",NULL);
INSERT INTO hebrew_morpho VALUES (91790,"הוֹמֶה","a",NULL,"HOME","הומה","הומה",NULL,"HWMH","HWMH",NULL);
INSERT INTO hebrew_morpho VALUES (91791,"הוֹרָדָה","n",NULL,"HORADA","הורדה","הורדה",NULL,"HWRDH","HWRDH",NULL);
INSERT INTO hebrew_morpho VALUES (91792,"הוֹרָה","n",NULL,"HORA","הורה","הורה",NULL,"HWRH","HWRH",NULL);
INSERT INTO hebrew_morpho VALUES (91793,"וְרִידִי","a",NULL,"VRIDI","ורידי","ורידי",NULL,"WRIDI","WRIDI",NULL);
INSERT INTO hebrew_morpho VALUES (91794,"וִכּוּחַ","n",NULL,"VIKU\'ACH","ויכוח","וכוח",NULL,"WKWX","WIKWX",NULL);
INSERT INTO hebrew_morpho VALUES (91795,"וִתּוּר","n",NULL,"VITUR","ויתור","ותור",NULL,"WTWR","WITWR",NULL);
INSERT INTO hebrew_morpho VALUES (91796,"וֵשֶׁט","n",NULL,"VESHET","ושט","ושט",NULL,"W$@","W$@",NULL);
INSERT INTO hebrew_morpho VALUES (91797,"וֶסֶת","n",NULL,"VESET","וסת","וסת",NULL,"WST","WST",NULL);
INSERT INTO hebrew_morpho VALUES (91798,"וֶרֶד","n",NULL,"VERED","ורד","ורד",NULL,"WRD","WRD",NULL);
INSERT INTO hebrew_morpho VALUES (91799,"וַיִּקְרָא","n",NULL,"VAYIKRA","ויקרא","ויקרא",NULL,"WIQRA","WIQRA",NULL);
INSERT INTO hebrew_morpho VALUES (91800,"וָאדִי","n",NULL,"VADI","ואדי","ואדי",NULL,"WADI","WADI",NULL);
INSERT INTO hebrew_morpho VALUES (91801,"זְאֵב","n",NULL,"ZE\'EV","זאב","זאב",NULL,"ZAB","ZAB",NULL);
INSERT INTO hebrew_morpho VALUES (91802,"זְהִירוּת","n",NULL,"ZEHIRUT","זהירות","זהירות",NULL,"ZHIRWT","ZHIRWT",NULL);
INSERT INTO hebrew_morpho VALUES (91803,"זְמַנִּי","a",NULL,"ZMANI","זמני","זמני",NULL,"ZMNI","ZMNI",NULL);
INSERT INTO hebrew_morpho VALUES (91804,"זְנוּת","n",NULL,"ZNUT","זנות","זנות",NULL,"ZNWT","ZNWT",NULL);
INSERT INTO hebrew_morpho VALUES (91805,"זִבֵּל","v",NULL,"ZIBEL","זיבל","זבל",NULL,"ZBL","ZIBL",NULL);
INSERT INTO hebrew_morpho VALUES (91806,"זִהוּם","n",NULL,"ZIHUM","זיהום","זהום",NULL,"ZHWM","ZIHWM",NULL);
INSERT INTO hebrew_morpho VALUES (91807,"זִיּוּף","n",NULL,"ZIYUF","זיוף","זיוף",NULL,"ZIWP","ZIWP",NULL);
INSERT INTO hebrew_morpho VALUES (91808,"מִתְחַזֶּה","n",NULL,"MITCHAZEH","מתחזה","מתחזה",NULL,"MTXZH","MTXZH",NULL);
INSERT INTO hebrew_morpho VALUES (91809,"זִמְזוּם","n",NULL,"ZIMZUM","זמזום","זמזום",NULL,"ZMZWM","ZMZWM",NULL);
INSERT INTO hebrew_morpho VALUES (91810,"זִמָּה","n",NULL,"ZIMA","זימה","זמה",NULL,"ZMH","ZIMH",NULL);
INSERT INTO hebrew_morpho VALUES (91811,"זִקְפָּה","n",NULL,"ZIKPA","זקפה","זקפה",NULL,"ZQPH","ZQPH",NULL);
INSERT INTO hebrew_morpho VALUES (91812,"זִכָּרוֹן","n",NULL,"ZIKARON","זיכרון","זכרון",NULL,"ZKRWN","ZIKRWN",NULL);
INSERT INTO hebrew_morpho VALUES (91813,"זֵעָה","n",NULL,"ZE\'AH","זיעה","זעה",NULL,"Z&H","ZI&H",NULL);
INSERT INTO hebrew_morpho VALUES (91814,"זֶבֶל","n",NULL,"ZEVEL","זבל","זבל",NULL,"ZBL","ZBL",NULL);
INSERT INTO hebrew_morpho VALUES (91815,"שְׁטֻיּוֹת","n",NULL,"SHTUYOT","שטויות","שטיות",NULL,"$@IWT","$@WIWT",NULL);
INSERT INTO hebrew_morpho VALUES (91816,"זֶפֶת","n",NULL,"ZEFET","זפת","זפת",NULL,"ZPT","ZPT",NULL);
INSERT INTO hebrew_morpho VALUES (91817,"זֶרֶם","n",NULL,"ZEREM","זרם","זרם",NULL,"ZRM","ZRM",NULL);
INSERT INTO hebrew_morpho VALUES (91818,"זֶרַע","n",NULL,"ZERA","זרע","זרע",NULL,"ZR&","ZR&",NULL);
INSERT INTO hebrew_morpho VALUES (91819,"זַבָּנִית","n",NULL,"ZABANIT","זבנית","זבנית",NULL,"ZBNIT","ZBNIT",NULL);
INSERT INTO hebrew_morpho VALUES (91820,"זַגָּג","n",NULL,"ZAGAG","זגג","זגג",NULL,"ZGG","ZGG",NULL);
INSERT INTO hebrew_morpho VALUES (91821,"זַחַל","n",NULL,NULL,"זחל","זחל",NULL,"ZXL","ZXL",NULL);
INSERT INTO hebrew_morpho VALUES (91822,"זַיְפָן","n",NULL,"ZAIFAN","זייפן","זיפן",NULL,"ZIPN","ZIIPN",NULL);
INSERT INTO hebrew_morpho VALUES (91823,"זַיִת","n",NULL,"ZAIT","זית","זית",NULL,"ZIT","ZIT",NULL);
INSERT INTO hebrew_morpho VALUES (91824,"זַכַּאי","a",NULL,"ZAKAI","זכאי","זכאי",NULL,"ZKAI","ZKAI",NULL);
INSERT INTO hebrew_morpho VALUES (91825,"זַלְזַל","n",NULL,"ZALZAL","זלזל","זלזל",NULL,"ZLZL","ZLZL",NULL);
INSERT INTO hebrew_morpho VALUES (91826,"זַמְשׁ","n",NULL,"ZAMSH","זמש","זמש",NULL,"ZM$","ZM$",NULL);
INSERT INTO hebrew_morpho VALUES (91827,"זַמָּר","n",NULL,"ZAMAR","זמר","זמר",NULL,"ZMR","ZMR",NULL);
INSERT INTO hebrew_morpho VALUES (91828,"זַרְזִיר","n",NULL,"ZARZIR","זרזיר","זרזיר",NULL,"ZRZIR","ZRZIR",NULL);
INSERT INTO hebrew_morpho VALUES (91829,"זַרְחָן","n",NULL,"ZARCHAN","זרחן","זרחן",NULL,"ZRXN","ZRXN",NULL);
INSERT INTO hebrew_morpho VALUES (91830,"זַרְחָנִי","a",NULL,"ZARCHANI","זרחני","זרחני",NULL,"ZRXNI","ZRXNI",NULL);
INSERT INTO hebrew_morpho VALUES (91831,"זַרְקוֹר","n",NULL,"ZARKOR","זרקור","זרקור",NULL,"ZRQWR","ZRQWR",NULL);
INSERT INTO hebrew_morpho VALUES (91832,"זָחַל","v",NULL,"ZACHAL","זחל","זחל",NULL,"ZXL","ZXL",NULL);
INSERT INTO hebrew_morpho VALUES (91833,"זָכָר","n",NULL,"ZACHAR","זכר","זכר",NULL,"ZKR","ZKR",NULL);
INSERT INTO hebrew_morpho VALUES (91834,"זָרוּעַ","a",NULL,"ZARU\'A","זרוע","זרוע",NULL,"ZRW&","ZRW&",NULL);
INSERT INTO hebrew_morpho VALUES (91835,"זֹהַר","n",NULL,"ZOHAR","זוהר","זהר",NULL,"ZHR","ZWHR",NULL);
INSERT INTO hebrew_morpho VALUES (91836,"זוֹנָה","n",NULL,"ZONA","זונה","זונה",NULL,"ZWNH","ZWNH",NULL);
INSERT INTO hebrew_morpho VALUES (91837,"זוּטָר","a",NULL,"ZUTAR","זוטר","זוטר",NULL,"ZW@R","ZW@R",NULL);
INSERT INTO hebrew_morpho VALUES (91838,"חֲבִילָה","n",NULL,"CHAVILA","חבילה","חבילה",NULL,"XBILH","XBILH",NULL);
INSERT INTO hebrew_morpho VALUES (91839,"חֲבַצֶּלֶת","n",NULL,"CHAVATSELET","חבצלת","חבצלת",NULL,"XBCLT","XBCLT",NULL);
INSERT INTO hebrew_morpho VALUES (91840,"חֲזִיז","n",NULL,"CHAZIZ","חזיז","חזיז",NULL,"XZIZ","XZIZ",NULL);
INSERT INTO hebrew_morpho VALUES (91841,"חֲזִירָה","n",NULL,"CHAZIRA","חזירה","חזירה",NULL,"XZIRH","XZIRH",NULL);
INSERT INTO hebrew_morpho VALUES (91842,"חֲזֶרֶת","n",NULL,"CHAZERET","חזרת","חזרת",NULL,"XZRT","XZRT",NULL);
INSERT INTO hebrew_morpho VALUES (91843,"חֲזָרָה","n",NULL,"CHAZARA","חזרה","חזרה",NULL,"XZRH","XZRH",NULL);
INSERT INTO hebrew_morpho VALUES (91844,"חֲטִיפָה","n",NULL,"CHATIFA","חטיפה","חטיפה",NULL,"X@IPH","X@IPH",NULL);
INSERT INTO hebrew_morpho VALUES (91845,"חֲלִיפוֹת","r",NULL,"CHALIFOT","חליפות","חליפות",NULL,"XLIPWT","XLIPWT",NULL);
INSERT INTO hebrew_morpho VALUES (91846,"חֲמִישִׁי","a",NULL,"CHAMISHI","חמישי","חמישי",NULL,"XMI$I","XMI$I",NULL);
INSERT INTO hebrew_morpho VALUES (91847,"הַחֲמִשִּׁים","a",NULL,"HACHAMISHIM","החמישים","החמשים",NULL,"HXM$IM","HXMI$IM",NULL);
INSERT INTO hebrew_morpho VALUES (91848,"חֲמַצְמַץ","a",NULL,"CHAMATZMATZ","חמצמץ","חמצמץ",NULL,"XMCMC","XMCMC",NULL);
INSERT INTO hebrew_morpho VALUES (91849,"חֲנִינָה","n",NULL,"CHANINA","חנינה","חנינה",NULL,"XNINH","XNINH",NULL);
INSERT INTO hebrew_morpho VALUES (91850,"חֲנִית","n",NULL,"CHANIT","חנית","חנית",NULL,"XNIT","XNIT",NULL);
INSERT INTO hebrew_morpho VALUES (91851,"חֲנוּת","n",NULL,"CHANUT","חנות","חנות",NULL,"XNWT","XNWT",NULL);
INSERT INTO hebrew_morpho VALUES (91852,"חֲסִידָה","n",NULL,"CHASIDA","חסידה","חסידה",NULL,"XSIDH","XSIDH",NULL);
INSERT INTO hebrew_morpho VALUES (91853,"חֲצִיל","n",NULL,"CHATZIL","חציל","חציל",NULL,"XCIL","XCIL",NULL);
INSERT INTO hebrew_morpho VALUES (91854,"חֲצוֹת","n",NULL,"CHATSOT","חצות","חצות",NULL,"XCWT","XCWT",NULL);
INSERT INTO hebrew_morpho VALUES (91855,"חֲשִׁיבוּת","n",NULL,"CHASHIVUT","חשיבות","חשיבות",NULL,"X$IBWT","X$IBWT",NULL);
INSERT INTO hebrew_morpho VALUES (91856,"שְׂפַת-סִימָנִים","n",NULL,"SFAT-SIMANIM","שפת-סימנים","שפת-סימנים",NULL,"$PT-SIMNIM","$PT-SIMNIM",NULL);
INSERT INTO hebrew_morpho VALUES (91857,"חֲתִירָה","n",NULL,"CHATIRA","חתירה","חתירה",NULL,"XTIRH","XTIRH",NULL);
INSERT INTO hebrew_morpho VALUES (91858,"הִזְדַּחֲלוּת","n",NULL,"HIZDACHALUT","הזחלות","הזדחלות",NULL,"HZDXLWT","HZXLWT",NULL);
INSERT INTO hebrew_morpho VALUES (91859,"זְחִילָה","n",NULL,"ZCHILA","זחילה","זחילה",NULL,"ZXILH","ZXILH",NULL);
INSERT INTO hebrew_morpho VALUES (91860,"חֲתַלְתּוּל","n",NULL,"CHATALTUL","חתלתול","חתלתול",NULL,"XTLTWL","XTLTWL",NULL);
INSERT INTO hebrew_morpho VALUES (91861,"חֲתֻנָּה","n",NULL,"CHATUNA","חתונה","חתנה",NULL,"XTNH","XTWNH",NULL);
INSERT INTO hebrew_morpho VALUES (91862,"חֳלִירַע","n",NULL,"CHOLIRA","חולירע","חלירע",NULL,"XLIR&","XWLIR&",NULL);
INSERT INTO hebrew_morpho VALUES (91863,"חִבֵּל","v",NULL,"CHIBEL","חיבל","חבל",NULL,"XBL","XIBL",NULL);
INSERT INTO hebrew_morpho VALUES (91864,"חִבָּה","n",NULL,"CHIBA","חיבה","חבה",NULL,"XBH","XIBH",NULL);
INSERT INTO hebrew_morpho VALUES (91865,"חִדּוּשׁ","n",NULL,"CHIDUSH","חידוש","חדוש",NULL,"XDW$","XIDW$",NULL);
INSERT INTO hebrew_morpho VALUES (91866,"חִזּוּי","n",NULL,"CHIZUY","חיזוי","חזוי",NULL,"XZWI","XIZWI",NULL);
INSERT INTO hebrew_morpho VALUES (91867,"חִטָּה","n",NULL,"CHITTA","חיטה","חטה",NULL,"X@H","XI@H",NULL);
INSERT INTO hebrew_morpho VALUES (91868,"חִיֵּג","v",NULL,"CHIYEG","חייג","חיג",NULL,"XIG","XIIG",NULL);
INSERT INTO hebrew_morpho VALUES (91869,"חִיּוּךְ","n",NULL,"CHIYUCH","חיוך","חיוך",NULL,"XIWK","XIWK",NULL);
INSERT INTO hebrew_morpho VALUES (91870,"חִיּוּנִי","a",NULL,"CHIYUNI","חיוני","חיוני",NULL,"XIWNI","XIWNI",NULL);
INSERT INTO hebrew_morpho VALUES (91871,"חִכּוּךְ","n",NULL,"CHIKUCH","חיכוך","חכוך",NULL,"XKWK","XIKWK",NULL);
INSERT INTO hebrew_morpho VALUES (91872,"חִמְצֵן","v",NULL,"CHIMTZEN","חימצן","חמצן",NULL,"XMCN","XIMCN",NULL);
INSERT INTO hebrew_morpho VALUES (91873,"חִמְצוּן","n",NULL,"CHIMTSUN","חמצון","חמצון",NULL,"XMCWN","XMCWN",NULL);
INSERT INTO hebrew_morpho VALUES (91874,"חִמּוּם","n",NULL,"CHIMUM","חימום","חמום",NULL,"XMWM","XIMWM",NULL);
INSERT INTO hebrew_morpho VALUES (91875,"חִסֵּן","v",NULL,"CHISSEN","חיסן","חסן",NULL,"XSN","XISN",NULL);
INSERT INTO hebrew_morpho VALUES (91876,"חִסָּכוֹן","n",NULL,"CHISACHON","חיסכון","חסכון",NULL,"XSKWN","XISKWN",NULL);
INSERT INTO hebrew_morpho VALUES (91877,"חִפּוּשִׁית","n",NULL,"CHIPUSHIT","חיפושית","חפושית",NULL,"XPW$IT","XIPW$IT",NULL);
INSERT INTO hebrew_morpho VALUES (91878,"חִשֵּׁל","v",NULL,"CHISHEL","חישל","חשל",NULL,"X$L","XI$L",NULL);
INSERT INTO hebrew_morpho VALUES (91879,"חִשּׁוּר","n",NULL,"CHISHUR","חישור","חשור",NULL,"X$WR","XI$WR",NULL);
INSERT INTO hebrew_morpho VALUES (91880,"חִתּוּל","n",NULL,"CHITUL","חיתול","חתול",NULL,"XTWL","XITWL",NULL);
INSERT INTO hebrew_morpho VALUES (91881,"חֵךְ","n",NULL,"CHECH","חך","חך",NULL,"XK","XK",NULL);
INSERT INTO hebrew_morpho VALUES (91882,"חֵמָר","n",NULL,"CHEMAR","חמר","חמר",NULL,"XMR","XMR",NULL);
INSERT INTO hebrew_morpho VALUES (91883,"קֶסֶם","n",NULL,"KESSEM","קסם","קסם",NULL,"QSM","QSM",NULL);
INSERT INTO hebrew_morpho VALUES (91884,"סִימָן-טוֹב","n",NULL,"SIMAN TOV","סימן-טוב","סימן-טוב",NULL,"SIMN-@WB","SIMN-@WB",NULL);
INSERT INTO hebrew_morpho VALUES (91885,"חֵץ","n",NULL,"CHETZ","חץ","חץ",NULL,"XC","XC",NULL);
INSERT INTO hebrew_morpho VALUES (91886,"חֵרְשׁוּת","n",NULL,"CHERSHUT","חירשות","חרשות",NULL,"XR$WT","XIR$WT",NULL);
INSERT INTO hebrew_morpho VALUES (91887,"חֵרֵשׁ","a",NULL,"CHERESH","חרש","חרש",NULL,"XR$","XR$",NULL);
INSERT INTO hebrew_morpho VALUES (91888,"חֵרֵשׁ","n",NULL,"CHERESH","חרש","חרש",NULL,"XR$","XR$",NULL);
INSERT INTO hebrew_morpho VALUES (91889,"חֵרֶם","n",NULL,"CHEREM","חרם","חרם",NULL,"XRM","XRM",NULL);
INSERT INTO hebrew_morpho VALUES (91890,"חֶלְבּוֹן","n",NULL,"CHELBON","חלבון","חלבון",NULL,"XLBWN","XLBWN",NULL);
INSERT INTO hebrew_morpho VALUES (91891,"חֶלְמוֹן","n",NULL,"CHELMON","חלמון","חלמון",NULL,"XLMWN","XLMWN",NULL);
INSERT INTO hebrew_morpho VALUES (91892,"חֶמְאָה","n",NULL,"CHEM\'A","חמאה","חמאה",NULL,"XMAH","XMAH",NULL);
INSERT INTO hebrew_morpho VALUES (91893,"חֶמְלָה","n",NULL,"CHEMLA","חמלה","חמלה",NULL,"XMLH","XMLH",NULL);
INSERT INTO hebrew_morpho VALUES (91894,"חֶסֶד","n",NULL,"CHESSED","חסד","חסד",NULL,"XSD","XSD",NULL);
INSERT INTO hebrew_morpho VALUES (91895,"חֶרְמֵשׁ","n",NULL,"CHERMESH","חרמש","חרמש",NULL,"XRM$","XRM$",NULL);
INSERT INTO hebrew_morpho VALUES (91896,"חֶרְפָּה","n",NULL,"CHERPA","חרפה","חרפה",NULL,"XRPH","XRPH",NULL);
INSERT INTO hebrew_morpho VALUES (91897,"חֶרֶב","n",NULL,"CHEREV","חרב","חרב",NULL,"XRB","XRB",NULL);
INSERT INTO hebrew_morpho VALUES (91898,"חֶרֶס","n",NULL,"CHERES","חרס","חרס",NULL,"XRS","XRS",NULL);
INSERT INTO hebrew_morpho VALUES (91899,"חֶשְׁבּוֹנִי","a",NULL,"CHESHBONI","חשבוני","חשבוני",NULL,"X$BWNI","X$BWNI",NULL);
INSERT INTO hebrew_morpho VALUES (91900,"חֶשְׁבּוֹנָאוּת","n",NULL,"CHESHBONA\'UT","חשבונאות","חשבונאות",NULL,"X$BWNAWT","X$BWNAWT",NULL);
INSERT INTO hebrew_morpho VALUES (91901,"חַבּוּרָה","n",NULL,"CHABURA","חבורה","חבורה",NULL,"XBWRH","XBWRH",NULL);
INSERT INTO hebrew_morpho VALUES (91902,"חַבּוּשׁ","n",NULL,"CHABUSH","חבוש","חבוש",NULL,"XBW$","XBW$",NULL);
INSERT INTO hebrew_morpho VALUES (91903,"חַדְגּוֹנִיּוּת","n",NULL,"CHADGONIYUT","חדגוניות","חדגוניות",NULL,"XDGWNIWT","XDGWNIWT",NULL);
INSERT INTO hebrew_morpho VALUES (91904,"חַדְרָנִית","n",NULL,"CHADRANIT","חדרנית","חדרנית",NULL,"XDRNIT","XDRNIT",NULL);
INSERT INTO hebrew_morpho VALUES (91905,"חַוָּה","n",NULL,"CHAVA","חווה","חוה",NULL,"XWH","XWWH",NULL);
INSERT INTO hebrew_morpho VALUES (91906,"חַזַּאי","n",NULL,"CHAZAI","חזאי","חזאי",NULL,"XZAI","XZAI",NULL);
INSERT INTO hebrew_morpho VALUES (91907,"חַזָּן","n",NULL,"CHAZAN","חזן","חזן",NULL,"XZN","XZN",NULL);
INSERT INTO hebrew_morpho VALUES (91908,"חַיִל","n",NULL,"CHAYIL","חיל","חיל",NULL,"XIL","XIL",NULL);
INSERT INTO hebrew_morpho VALUES (91909,"חַיָּל","n",NULL,"CHAYAL","חייל","חיל",NULL,"XIL","XIIL",NULL);
INSERT INTO hebrew_morpho VALUES (91910,"חַיָּתִי","a",NULL,"CHAYATI","חייתי","חיתי",NULL,"XITI","XIITI",NULL);
INSERT INTO hebrew_morpho VALUES (91911,"חַלָּמִישׁ","n",NULL,"CHALAMISH","חלמיש","חלמיש",NULL,"XLMI$","XLMI$",NULL);
INSERT INTO hebrew_morpho VALUES (91912,"חַמְצָן","n",NULL,"CHAMTZAN","חמצן","חמצן",NULL,"XMCN","XMCN",NULL);
INSERT INTO hebrew_morpho VALUES (91913,"חַמָּנִית","n",NULL,"CHAMANIT","חמנית","חמנית",NULL,"XMNIT","XMNIT",NULL);
INSERT INTO hebrew_morpho VALUES (91914,"חַנְקָה","n",NULL,"CHANKA","חנקה","חנקה",NULL,"XNQH","XNQH",NULL);
INSERT INTO hebrew_morpho VALUES (91915,"חַנְקָן","n",NULL,"CHANKAN","חנקן","חנקן",NULL,"XNQN","XNQN",NULL);
INSERT INTO hebrew_morpho VALUES (91916,"חַסָּה","n",NULL,"CHASSA","חסה","חסה",NULL,"XSH","XSH",NULL);
INSERT INTO hebrew_morpho VALUES (91917,"חַפּוּת","n",NULL,"CHAPUT","חפות","חפות",NULL,"XPWT","XPWT",NULL);
INSERT INTO hebrew_morpho VALUES (91918,"חַצֶּבֶת","n",NULL,"CHATZEVET","חצבת","חצבת",NULL,"XCBT","XCBT",NULL);
INSERT INTO hebrew_morpho VALUES (91919,"חַרְדָּל","n",NULL,"CHARDAL","חרדל","חרדל",NULL,"XRDL","XRDL",NULL);
INSERT INTO hebrew_morpho VALUES (91920,"חַרְסִית","n",NULL,"CHARSIT","חרסית","חרסית",NULL,"XRSIT","XRSIT",NULL);
INSERT INTO hebrew_morpho VALUES (91921,"חַרְצִית","n",NULL,"CHARTZIT","חרצית","חרצית",NULL,"XRCIT","XRCIT",NULL);
INSERT INTO hebrew_morpho VALUES (91922,"חַשְׁדָנוּת","n",NULL,"CHASHDANUT","חשדנות","חשדנות",NULL,"X$DNWT","X$DNWT",NULL);
INSERT INTO hebrew_morpho VALUES (91923,"חַשְׁמַל","n",NULL,"CHASHMAL","חשמל","חשמל",NULL,"X$ML","X$ML",NULL);
INSERT INTO hebrew_morpho VALUES (91924,"טָעוּן","a",NULL,"TA\'UN","טעון","טעון",NULL,"@&WN","@&WN",NULL);
INSERT INTO hebrew_morpho VALUES (91925,"מְחַשְׁמֵל","a",NULL,"MECHASHMEL","מחשמל","מחשמל",NULL,"MX$ML","MX$ML",NULL);
INSERT INTO hebrew_morpho VALUES (91926,"חַשְׁמַלִּי","a",NULL,"CHASHMALI","חשמלי","חשמלי",NULL,"X$MLI","X$MLI",NULL);
INSERT INTO hebrew_morpho VALUES (91927,"חַתְרָנִי","a",NULL,"CHATRANI","חתרני","חתרני",NULL,"XTRNI","XTRNI",NULL);
INSERT INTO hebrew_morpho VALUES (91928,"קְוֶקֶר","n",NULL,"KVEKER","קווקר","קוקר",NULL,"QWQR","QWWQR",NULL);
INSERT INTO hebrew_morpho VALUES (91929,"חָבוּשׁ","a",NULL,"CHAVUSH","חבוש","חבוש",NULL,"XBW$","XBW$",NULL);
INSERT INTO hebrew_morpho VALUES (91930,"חָדִיר","a",NULL,"CHADIR","חדיר","חדיר",NULL,"XDIR","XDIR",NULL);
INSERT INTO hebrew_morpho VALUES (91931,"חֲזִיָּה","n",NULL,"CHAZIYA","חזייה","חזיה",NULL,"XZIH","XZIIH",NULL);
INSERT INTO hebrew_morpho VALUES (91932,"חָזֶה","n",NULL,"CHAZEH","חזה","חזה",NULL,"XZH","XZH",NULL);
INSERT INTO hebrew_morpho VALUES (91933,"חָטוּב","a",NULL,"CHATUV","חטוב","חטוב",NULL,"X@WB","X@WB",NULL);
INSERT INTO hebrew_morpho VALUES (91934,"חָטוּף","a",NULL,"CHATUF","חטוף","חטוף",NULL,"X@WP","X@WP",NULL);
INSERT INTO hebrew_morpho VALUES (91935,"חָלָב","n",NULL,"CHALAV","חלב","חלב",NULL,"XLB","XLB",NULL);
INSERT INTO hebrew_morpho VALUES (91936,"חָמְרָנוּת","n",NULL,"CHOMRANUT","חמרנות","חמרנות",NULL,"XMRNWT","XMRNWT",NULL);
INSERT INTO hebrew_morpho VALUES (91937,"חָמַד","v",NULL,"CHAMAD","חמד","חמד",NULL,"XMD","XMD",NULL);
INSERT INTO hebrew_morpho VALUES (91938,"חָנַט","v",NULL,"CHANAT","חנט","חנט",NULL,"XN@","XN@",NULL);
INSERT INTO hebrew_morpho VALUES (91939,"חָנַךְ","v",NULL,"CHANACH","חנך","חנך",NULL,"XNK","XNK",NULL);
INSERT INTO hebrew_morpho VALUES (91940,"חָנַק","v",NULL,"CHANAK","חנק","חנק",NULL,"XNQ","XNQ",NULL);
INSERT INTO hebrew_morpho VALUES (91941,"חָנָה","v",NULL,"CHANA","חנה","חנה",NULL,"XNH","XNH",NULL);
INSERT INTO hebrew_morpho VALUES (91942,"חָנוּט","n",NULL,"CHANUT","חנוט","חנוט",NULL,"XNW@","XNW@",NULL);
INSERT INTO hebrew_morpho VALUES (91943,"חָסִין","a",NULL,"CHASSIN","חסין","חסין",NULL,"XSIN","XSIN",NULL);
INSERT INTO hebrew_morpho VALUES (91944,"חָפַף","v",NULL,"CHAFAF","חפף","חפף",NULL,"XPP","XPP",NULL);
INSERT INTO hebrew_morpho VALUES (91945,"חָפוּז","a",NULL,"CHAFUZ","חפוז","חפוז",NULL,"XPWZ","XPWZ",NULL);
INSERT INTO hebrew_morpho VALUES (91946,"חָצִיר","n",NULL,"CHATZIR","חציר","חציר",NULL,"XCIR","XCIR",NULL);
INSERT INTO hebrew_morpho VALUES (91947,"חָצָה","v",NULL,"CHATSA","חצה","חצה",NULL,"XCH","XCH",NULL);
INSERT INTO hebrew_morpho VALUES (91948,"חָצָץ","n",NULL,"CHATZATZ","חצץ","חצץ",NULL,"XCC","XCC",NULL);
INSERT INTO hebrew_morpho VALUES (91949,"חָקִי","n",NULL,"CHAKI","חקי","חקי",NULL,"XQI","XQI",NULL);
INSERT INTO hebrew_morpho VALUES (91950,"חָקוּק","a",NULL,"CHAKUK","חקוק","חקוק",NULL,"XQWQ","XQWQ",NULL);
INSERT INTO hebrew_morpho VALUES (91951,"חָרִיג","a",NULL,"CHARIG","חריג","חריג",NULL,"XRIG","XRIG",NULL);
INSERT INTO hebrew_morpho VALUES (91952,"חָרִישׁ","n",NULL,"CHARISH","חריש","חריש",NULL,"XRI$","XRI$",NULL);
INSERT INTO hebrew_morpho VALUES (91953,"חָרַק","v",NULL,"CHARAK","חרק","חרק",NULL,"XRQ","XRQ",NULL);
INSERT INTO hebrew_morpho VALUES (91954,"חָרוּז","n",NULL,"CHARUZ","חרוז","חרוז",NULL,"XRWZ","XRWZ",NULL);
INSERT INTO hebrew_morpho VALUES (91955,"חָרוּץ","a",NULL,"CHARUTZ","חרוץ","חרוץ",NULL,"XRWC","XRWC",NULL);
INSERT INTO hebrew_morpho VALUES (91956,"חָרוּשׁ","a",NULL,"CHARUSH","חרוש","חרוש",NULL,"XRW$","XRW$",NULL);
INSERT INTO hebrew_morpho VALUES (91957,"חָרוּת","a",NULL,"CHARUT","חרות","חרות",NULL,"XRWT","XRWT",NULL);
INSERT INTO hebrew_morpho VALUES (91958,"חָשׁוּד","n",NULL,"CHASHUD","חשוד","חשוד",NULL,"X$WD","X$WD",NULL);
INSERT INTO hebrew_morpho VALUES (91959,"נֶאֱשַׁם","n",NULL,"NE\'ESHAM","נאשם","נאשם",NULL,"NA$M","NA$M",NULL);
INSERT INTO hebrew_morpho VALUES (91960,"חָשׂוּף","a",NULL,"CHASUF","חשוף","חשוף",NULL,"X$WP","X$WP",NULL);
INSERT INTO hebrew_morpho VALUES (91961,"חָתַר","v",NULL,"CHATAR","חתר","חתר",NULL,"XTR","XTR",NULL);
INSERT INTO hebrew_morpho VALUES (91962,"סַיָּס","n",NULL,"SAYAS","סייס","סיס",NULL,"SIS","SIIS",NULL);
INSERT INTO hebrew_morpho VALUES (91963,"חָתָן","n",NULL,"CHATAN","חתן","חתן",NULL,"XTN","XTN",NULL);
INSERT INTO hebrew_morpho VALUES (91964,"חָתוּם","a",NULL,"CHATUM","חתום","חתום",NULL,"XTWM","XTWM",NULL);
INSERT INTO hebrew_morpho VALUES (91965,"חָתוּם","n",NULL,"CHATUM","חתום","חתום",NULL,"XTWM","XTWM",NULL);
INSERT INTO hebrew_morpho VALUES (91966,"נוֹצַר","v",NULL,"NOTZAR","נוצר","נוצר",NULL,"NWCR","NWCR",NULL);
INSERT INTO hebrew_morpho VALUES (91967,"חֹם","n",NULL,"CHOM","חום","חם",NULL,"XM","XWM",NULL);
INSERT INTO hebrew_morpho VALUES (91968,"חַד-ְגּוֹנִיּוּת","n",NULL,"CHAD-GONIYUT","חד-גוניות","חד-גוניות",NULL,"XD-GWNIWT","XD-GWNIWT",NULL);
INSERT INTO hebrew_morpho VALUES (91969,"חֹמֶץ","n",NULL,"CHOMETZ","חומץ","חמץ",NULL,"XMC","XWMC",NULL);
INSERT INTO hebrew_morpho VALUES (91970,"חֹקֶן","n",NULL,"CHOKEN","חוקן","חקן",NULL,"XQN","XWQN",NULL);
INSERT INTO hebrew_morpho VALUES (91971,"חֹרֶף","n",NULL,"CHOREF","חורף","חרף",NULL,"XRP","XWRP",NULL);
INSERT INTO hebrew_morpho VALUES (91972,"חֻלְיָה","n",NULL,"CHULYA","חוליה","חליה",NULL,"XLIH","XWLIH",NULL);
INSERT INTO hebrew_morpho VALUES (91973,"חֻלְצָה","n",NULL,"CHULTSA","חולצה","חלצה",NULL,"XLCH","XWLCH",NULL);
INSERT INTO hebrew_morpho VALUES (91974,"חִלּוֹנִיּוּת","n",NULL,"CHILONIYUT","חילוניות","חלוניות",NULL,"XLWNIWT","XILWNIWT",NULL);
INSERT INTO hebrew_morpho VALUES (91975,"כְּבִידָה","n",NULL,"KVIDA","כבידה","כבידה",NULL,"KBIDH","KBIDH",NULL);
INSERT INTO hebrew_morpho VALUES (91976,"חֻמְרָה","n",NULL,"CHUMRA","חומרה","חמרה",NULL,"XMRH","XWMRH",NULL);
INSERT INTO hebrew_morpho VALUES (91977,"חֻקִּיּוּת","n",NULL,"CHUKIYUT","חוקיות","חקיות",NULL,"XQIWT","XWQIWT",NULL);
INSERT INTO hebrew_morpho VALUES (91978,"כוֹלֶרָה","n",NULL,"CHOLERA","כולרה","כולרה",NULL,"KWLRH","KWLRH",NULL);
INSERT INTO hebrew_morpho VALUES (91979,"חוּט","n",NULL,"CHUT","חוט","חוט",NULL,"XW@","XW@",NULL);
INSERT INTO hebrew_morpho VALUES (91980,"חוּט-חַשְׁמַל","n",NULL,"CHUT-CHASHMAL","חוט-חשמל","חוט-חשמל",NULL,"XW@-X$ML","XW@-X$ML",NULL);
INSERT INTO hebrew_morpho VALUES (91981,"חוּשָׁנִיּוּת","n",NULL,"CHUSHANIYUT","חושניות","חושניות",NULL,"XW$NIWT","XW$NIWT",NULL);
INSERT INTO hebrew_morpho VALUES (91982,"טְבִילָה","n",NULL,"TVILA","טבילה","טבילה",NULL,"@BILH","@BILH",NULL);
INSERT INTO hebrew_morpho VALUES (91983,"טְוִיָּה","n",NULL,"TVIYA","טווייה","טויה",NULL,"@WIH","@WWIIH",NULL);
INSERT INTO hebrew_morpho VALUES (91984,"טְרֶמְפּ","n",NULL,"TREMP","טרמפ","טרמפ",NULL,"@RMP","@RMP",NULL);
INSERT INTO hebrew_morpho VALUES (91985,"טְרוֹמִי","a",NULL,"TROMI","טרומי","טרומי",NULL,"@RWMI","@RWMI",NULL);
INSERT INTO hebrew_morpho VALUES (91986,"טִאטוּא","n",NULL,"TITU","טאטוא","טאטוא",NULL,"@A@WA","@A@WA",NULL);
INSERT INTO hebrew_morpho VALUES (91987,"טִבְעוֹנִי","n",NULL,"TIV\'ONI","טבעוני","טבעוני",NULL,"@B&WNI","@B&WNI",NULL);
INSERT INTO hebrew_morpho VALUES (91988,"טִגּוּן","n",NULL,"TIGUN","טיגון","טגון",NULL,"@GWN","@IGWN",NULL);
INSERT INTO hebrew_morpho VALUES (91989,"טִהוּר","n",NULL,"TIHUR","טיהור","טהור",NULL,"@HWR","@IHWR",NULL);
INSERT INTO hebrew_morpho VALUES (91990,"טִיּוּחַ","n",NULL,"TIYU\'ACH","טיוח","טיוח",NULL,"@IWX","@IWX",NULL);
INSERT INTO hebrew_morpho VALUES (91991,"טִיחַ","n",NULL,"TI\'ACH","טיח","טיח",NULL,"@IX","@IX",NULL);
INSERT INTO hebrew_morpho VALUES (91992,"טִיט","n",NULL,"TEET","טיט","טיט",NULL,"@I@","@I@",NULL);
INSERT INTO hebrew_morpho VALUES (91993,"טִין","n",NULL,"TIN","טין","טין",NULL,"@IN","@IN",NULL);
INSERT INTO hebrew_morpho VALUES (91994,"טִינָה","n",NULL,"TINA","טינה","טינה",NULL,"@INH","@INH",NULL);
INSERT INTO hebrew_morpho VALUES (91995,"טִפְטֵף","v",NULL,"TIFTEF","טיפטף","טפטף",NULL,"@P@P","@IP@P",NULL);
INSERT INTO hebrew_morpho VALUES (91996,"טִפְטוּף","n",NULL,"TIFTUF","טיפטוף","טפטוף",NULL,"@P@WP","@IP@WP",NULL);
INSERT INTO hebrew_morpho VALUES (91997,"טִפְּשִׁי","a",NULL,"TIPSHI","טיפשי","טפשי",NULL,"@P$I","@IP$I",NULL);
INSERT INTO hebrew_morpho VALUES (91998,"טִפֵּשׁ","a",NULL,"TIPESH","טיפש","טפש",NULL,"@P$","@IP$",NULL);
INSERT INTO hebrew_morpho VALUES (91999,"טִפֵּשׁ","n",NULL,"TIPESH","טיפש","טפש",NULL,"@P$","@IP$",NULL);
INSERT INTO hebrew_morpho VALUES (92000,"טִפּוּל","n",NULL,"TIPUL","טיפול","טפול",NULL,"@PWL","@IPWL",NULL);
INSERT INTO hebrew_morpho VALUES (92001,"טִקְסִי","a",NULL,"TIKSI","טקסי","טקסי",NULL,"@QSI","@QSI",NULL);
INSERT INTO hebrew_morpho VALUES (92002,"טִקְסִיּוּת","n",NULL,"TIKSIYUT","טקסיות","טקסיות",NULL,"@QSIWT","@QSIWT",NULL);
INSERT INTO hebrew_morpho VALUES (92003,"טֵאוּט","n",NULL,"TE\'UT","טיאוט","טאוט",NULL,"@AW@","@IAW@",NULL);
INSERT INTO hebrew_morpho VALUES (92004,"טֶלֶבִיזְיָה","n",NULL,"TELEVIZYA","טלביזיה","טלביזיה",NULL,"@LBIZIH","@LBIZIH",NULL);
INSERT INTO hebrew_morpho VALUES (92005,"טֶרֶף","n",NULL,"TEREF","טרף","טרף",NULL,"@RP","@RP",NULL);
INSERT INTO hebrew_morpho VALUES (92006,"טַפִּיל","n",NULL,"TAPIL","טפיל","טפיל",NULL,"@PIL","@PIL",NULL);
INSERT INTO hebrew_morpho VALUES (92007,"טָבוּעַ","a",NULL,"TAVU\'AH","טבוע","טבוע",NULL,"@BW&","@BW&",NULL);
INSERT INTO hebrew_morpho VALUES (92008,"טָחוּב","a",NULL,"TACHUV","טחוב","טחוב",NULL,"@XWB","@XWB",NULL);
INSERT INTO hebrew_morpho VALUES (92009,"טָחוּן","a",NULL,"TACHUN","טחון","טחון",NULL,"@XWN","@XWN",NULL);
INSERT INTO hebrew_morpho VALUES (92010,"טָמֵא","a",NULL,"TAME","טמא","טמא",NULL,"@MA","@MA",NULL);
INSERT INTO hebrew_morpho VALUES (92011,"טָעִים","a",NULL,"TA\'IM","טעים","טעים",NULL,"@&IM","@&IM",NULL);
INSERT INTO hebrew_morpho VALUES (92012,"טָרִי","a",NULL,"TARI","טרי","טרי",NULL,"@RI","@RI",NULL);
INSERT INTO hebrew_morpho VALUES (92013,"טָרֶשֶׁת","n",NULL,"TARESHET","טרשת","טרשת",NULL,"@R$T","@R$T",NULL);
INSERT INTO hebrew_morpho VALUES (92014,"טוֹטֶפֶת","n",NULL,"TOTEFET","טוטפת","טוטפת",NULL,"@W@PT","@W@PT",NULL);
INSERT INTO hebrew_morpho VALUES (92015,"טוֹרְדָנִי","a",NULL,"TORDANI","טורדני","טורדני",NULL,"@WRDNI","@WRDNI",NULL);
INSERT INTO hebrew_morpho VALUES (92016,"טוּרַאי","n",NULL,"TURAY","טוראי","טוראי",NULL,"@WRAI","@WRAI",NULL);
INSERT INTO hebrew_morpho VALUES (92017,"יְבוּל","n",NULL,"YEVUL","יבול","יבול",NULL,"IBWL","IBWL",NULL);
INSERT INTO hebrew_morpho VALUES (92018,"זֶפֶק","n",NULL,"ZEFEK","זפק","זפק",NULL,"ZPQ","ZPQ",NULL);
INSERT INTO hebrew_morpho VALUES (92019,"יְדִידוּת","n",NULL,"YEDIDUT","ידידות","ידידות",NULL,"IDIDWT","IDIDWT",NULL);
INSERT INTO hebrew_morpho VALUES (92020,"קוֹגְנִיצְיָה","n",NULL,"KOGNITSIA","קוגניציה","קוגניציה",NULL,"QWGNICIH","QWGNICIH",NULL);
INSERT INTO hebrew_morpho VALUES (92021,"הַכָּרָה","n",NULL,"HAKARA","הכרה","הכרה",NULL,"HKRH","HKRH",NULL);
INSERT INTO hebrew_morpho VALUES (92022,"יְדָנִי","a",NULL,"YADANI","ידני","ידני",NULL,"IDNI","IDNI",NULL);
INSERT INTO hebrew_morpho VALUES (92023,"יְהִירוּת","n",NULL,"YEHIRUT","יהירות","יהירות",NULL,"IHIRWT","IHIRWT",NULL);
INSERT INTO hebrew_morpho VALUES (92024,"יְהוּדִיָּה","n",NULL,"YEHUDIYA","יהודייה","יהודיה",NULL,"IHWDIH","IHWDIIH",NULL);
INSERT INTO hebrew_morpho VALUES (92025,"יְוָנִי","a",NULL,"YEVANI","יווני","יוני",NULL,"IWNI","IWWNI",NULL);
INSERT INTO hebrew_morpho VALUES (92026,"יְוָנִי","n",NULL,"YEVANI","יווני","יוני",NULL,"IWNI","IWWNI","male");
INSERT INTO hebrew_morpho VALUES (92027,"יְחָסִים","n",NULL,"YEXASIM","יחסים","יחסים",NULL,"IXSIM","IXSIM",NULL);
INSERT INTO hebrew_morpho VALUES (92028,"כֹּשֶׁר","n",NULL,"KOSHER","כושר","כשר",NULL,"K$R","KW$R",NULL);
INSERT INTO hebrew_morpho VALUES (92029,"יְלָלָה","n",NULL,"YELALA","יללה","יללה",NULL,"ILLH","ILLH",NULL);
INSERT INTO hebrew_morpho VALUES (92030,"יְסוֹדִיּוּת","n",NULL,"YESODIYUT","יסודיות","יסודיות",NULL,"ISWDIWT","ISWDIWT",NULL);
INSERT INTO hebrew_morpho VALUES (92031,"יְצוּא","n",NULL,"YETSU","יצוא","יצוא",NULL,"ICWA","ICWA",NULL);
INSERT INTO hebrew_morpho VALUES (92032,"יְצוּאָן","n",NULL,"YETZU\'AN","יצואן","יצואן",NULL,"ICWAN","ICWAN",NULL);
INSERT INTO hebrew_morpho VALUES (92033,"יְרֵחִי","a",NULL,"YEREXI","ירחי","ירחי",NULL,"IRXI","IRXI",NULL);
INSERT INTO hebrew_morpho VALUES (92034,"יְשִׁימוֹן","n",NULL,"YESHIMON","ישימון","ישימון",NULL,"I$IMWN","I$IMWN",NULL);
INSERT INTO hebrew_morpho VALUES (92035,"יִבּוּא","n",NULL,"YIBU","ייבוא","יבוא",NULL,"IBWA","IIBWA",NULL);
INSERT INTO hebrew_morpho VALUES (92036,"יִבּוּשׁ","n",NULL,"YIBUSH","ייבוש","יבוש",NULL,"IBW$","IIBW$",NULL);
INSERT INTO hebrew_morpho VALUES (92037,"יִחֵס","v",NULL,"YIXES","ייחס","יחס",NULL,"IXS","IIXS",NULL);
INSERT INTO hebrew_morpho VALUES (92038,"יִחוּד","n",NULL,"YICHUD","ייחוד","יחוד",NULL,"IXWD","IIXWD",NULL);
INSERT INTO hebrew_morpho VALUES (92039,"יִידִישׁ","n",NULL,"YIDISH","יידיש","יידיש",NULL,"IIDI$","IIDI$",NULL);
INSERT INTO hebrew_morpho VALUES (92040,"יִלֵּל","v",NULL,"YILEL","יילל","ילל",NULL,"ILL","IILL",NULL);
INSERT INTO hebrew_morpho VALUES (92041,"יִלּוֹד","n",NULL,"YILOD","יילוד","ילוד",NULL,"ILWD","IILWD",NULL);
INSERT INTO hebrew_morpho VALUES (92042,"יִעוּר","n",NULL,"YI\'UR","ייעור","יעור",NULL,"I&WR","II&WR",NULL);
INSERT INTO hebrew_morpho VALUES (92043,"יִפּוּי","n",NULL,"YIPUY","ייפוי","יפוי",NULL,"IPWI","IIPWI",NULL);
INSERT INTO hebrew_morpho VALUES (92044,"יִצֵּא","v",NULL,"YITSE","ייצא","יצא",NULL,"ICA","IICA",NULL);
INSERT INTO hebrew_morpho VALUES (92045,"יִצּוּא","n",NULL,"YITSU","ייצוא","יצוא",NULL,"ICWA","IICWA",NULL);
INSERT INTO hebrew_morpho VALUES (92046,"יִצּוּב","n",NULL,"YITZUV","ייצוב","יצוב",NULL,"ICWB","IICWB",NULL);
INSERT INTO hebrew_morpho VALUES (92047,"יֵאוּשׁ","n",NULL,"YE\'USH","ייאוש","יאוש",NULL,"IAW$","IIAW$",NULL);
INSERT INTO hebrew_morpho VALUES (92048,"יֵשׁוּ","n",NULL,"YESHU","ישו","ישו",NULL,"I$W","I$W",NULL);
INSERT INTO hebrew_morpho VALUES (92049,"יֶרִי","n",NULL,"YERI","ירי","ירי",NULL,"IRI","IRI",NULL);
INSERT INTO hebrew_morpho VALUES (92050,"יֶרֶק","n",NULL,"YEREK","ירק","ירק",NULL,"IRQ","IRQ",NULL);
INSERT INTO hebrew_morpho VALUES (92051,"יַבֶּשֶׁת","n",NULL,"YABESHET","יבשת","יבשת",NULL,"IB$T","IB$T",NULL);
INSERT INTO hebrew_morpho VALUES (92052,"יַהֲדוּת","n",NULL,"YAHADUT","יהדות","יהדות",NULL,"IHDWT","IHDWT",NULL);
INSERT INTO hebrew_morpho VALUES (92053,"יַזָּם","n",NULL,"YAZAM","יזם","יזם",NULL,"IZM","IZM",NULL);
INSERT INTO hebrew_morpho VALUES (92054,"יַחֲסִי","a",NULL,"YACHASSI","יחסי","יחסי",NULL,"IXSI","IXSI",NULL);
INSERT INTO hebrew_morpho VALUES (92055,"יַחֲסִית","r",NULL,"YAXASIT","יחסית","יחסית",NULL,"IXSIT","IXSIT",NULL);
INSERT INTO hebrew_morpho VALUES (92056,"יַמָּאוּת","n",NULL,"YAMA\'UT","ימאות","ימאות",NULL,"IMAWT","IMAWT",NULL);
INSERT INTO hebrew_morpho VALUES (92057,"יַנְשׁוּף","n",NULL,"YANSHUF","ינשוף","ינשוף",NULL,"IN$WP","IN$WP",NULL);
INSERT INTO hebrew_morpho VALUES (92058,"יַסְמִין","n",NULL,"YASMIN","יסמין","יסמין",NULL,"ISMIN","ISMIN",NULL);
INSERT INTO hebrew_morpho VALUES (92059,"יַעֲרָן","n",NULL,"YA\'ARAN","יערן","יערן",NULL,"I&RN","I&RN",NULL);
INSERT INTO hebrew_morpho VALUES (92060,"יַעֲרָנוּת","n",NULL,"YA\'ARANUT","יערנות","יערנות",NULL,"I&RNWT","I&RNWT",NULL);
INSERT INTO hebrew_morpho VALUES (92061,"מַלְוֶה-בְּרִבִּית","n",NULL,"MALVE-BERIBIT","מלווה-בריבית","מלוה-ברבית",NULL,"MLWH-BRBIT","MLWWH-BRIBIT",NULL);
INSERT INTO hebrew_morpho VALUES (92062,"יַצִּיבוּת","n",NULL,"YATZIVUT","יציבות","יציבות",NULL,"ICIBWT","ICIBWT",NULL);
INSERT INTO hebrew_morpho VALUES (92063,"יַרְבּוּעַ","n",NULL,"YARBU\'A","ירבוע","ירבוע",NULL,"IRBW&","IRBW&",NULL);
INSERT INTO hebrew_morpho VALUES (92064,"יַרְחוֹן","n",NULL,"YARCHON","ירחון","ירחון",NULL,"IRXWN","IRXWN",NULL);
INSERT INTO hebrew_morpho VALUES (92065,"יַרְקָן","n",NULL,"YARKAN","ירקן","ירקן",NULL,"IRQN","IRQN",NULL);
INSERT INTO hebrew_morpho VALUES (92066,"יַתּוּשׁ","n",NULL,"YATUSH","יתוש","יתוש",NULL,"ITW$","ITW$",NULL);
INSERT INTO hebrew_morpho VALUES (92067,"יָגֵעַ","a",NULL,"YAGE\'A","יגע","יגע",NULL,"IG&","IG&",NULL);
INSERT INTO hebrew_morpho VALUES (92068,"יָהֳרָה","n",NULL,"YOHARA","יהרה","יהרה",NULL,"IHRH","IHRH",NULL);
INSERT INTO hebrew_morpho VALUES (92069,"יָוָן","n",NULL,"YAVAN","יוון","יון",NULL,"IWN","IWWN",NULL);
INSERT INTO hebrew_morpho VALUES (92070,"יָחֵף","a",NULL,"YACHEF","יחף","יחף",NULL,"IXP","IXP",NULL);
INSERT INTO hebrew_morpho VALUES (92071,"יָחֵף","r",NULL,"YACHEF","יחף","יחף",NULL,"IXP","IXP",NULL);
INSERT INTO hebrew_morpho VALUES (92072,"יָנוּאָר","n",NULL,"YANUAR","ינואר","ינואר",NULL,"INWAR","INWAR",NULL);
INSERT INTO hebrew_morpho VALUES (92073,"יָעֵן","n",NULL,"YA\'EN","יען","יען",NULL,"I&N","I&N",NULL);
INSERT INTO hebrew_morpho VALUES (92074,"יָעֶה","n",NULL,"YA\'EH","יעה","יעה",NULL,"I&H","I&H",NULL);
INSERT INTO hebrew_morpho VALUES (92075,"יָפֶה","a",NULL,"YAFE","יפה","יפה",NULL,"IPH","IPH",NULL);
INSERT INTO hebrew_morpho VALUES (92076,"יָצוּק","a",NULL,"YATSUK","יצוק","יצוק",NULL,"ICWQ","ICWQ",NULL);
INSERT INTO hebrew_morpho VALUES (92077,"מִתְחָרֶה","a",NULL,"MITCHAREH","מתחרה","מתחרה",NULL,"MTXRH","MTXRH",NULL);
INSERT INTO hebrew_morpho VALUES (92078,"יָרִיב","n",NULL,"YARIV","יריב","יריב",NULL,"IRIB","IRIB",NULL);
INSERT INTO hebrew_morpho VALUES (92079,"אוֹיֵב","n",NULL,"OYEV","אויב","אויב",NULL,"AWIB","AWIB",NULL);
INSERT INTO hebrew_morpho VALUES (92080,"יָרֵךְ","n",NULL,"YARECH","ירך","ירך",NULL,"IRK","IRK",NULL);
INSERT INTO hebrew_morpho VALUES (92081,"קָטַן","v",NULL,"KATAN","קטן","קטן",NULL,"Q@N","Q@N",NULL);
INSERT INTO hebrew_morpho VALUES (92082,"יֹפִי","n",NULL,"YOFI","יופי","יפי",NULL,"IPI","IWPI",NULL);
INSERT INTO hebrew_morpho VALUES (92083,"יֹשֶׁר","n",NULL,"YOSHER","יושר","ישר",NULL,"I$R","IW$R",NULL);
INSERT INTO hebrew_morpho VALUES (92084,"יָמְרָה","n",NULL,"YOMRA","יומרה","ימרה",NULL,"IMRH","IWMRH",NULL);
INSERT INTO hebrew_morpho VALUES (92085,"יוֹזֵם","n",NULL,"YOZEM","יוזם","יוזם",NULL,"IWZM","IWZM",NULL);
INSERT INTO hebrew_morpho VALUES (92086,"יוֹנָה","n",NULL,"YONA","יונה","יונה",NULL,"IWNH","IWNH",NULL);
INSERT INTO hebrew_morpho VALUES (92087,"יוֹצֵר","n",NULL,"YOTZER","יוצר","יוצר",NULL,"IWCR","IWCR",NULL);
INSERT INTO hebrew_morpho VALUES (92088,"יוֹרֶשֶׁת","n",NULL,"YORESHET","יורשת","יורשת",NULL,"IWR$T","IWR$T",NULL);
INSERT INTO hebrew_morpho VALUES (92089,"יוּטָה","n",NULL,"YUTA","יוטה","יוטה",NULL,"IW@H","IW@H",NULL);
INSERT INTO hebrew_morpho VALUES (92090,"יוּלִי","n",NULL,"YULI","יולי","יולי",NULL,"IWLI","IWLI",NULL);
INSERT INTO hebrew_morpho VALUES (92091,"יוּנִי","n",NULL,"YUNI","יוני","יוני",NULL,"IWNI","IWNI",NULL);
INSERT INTO hebrew_morpho VALUES (92092,"בִּמְהֵרָה","r",NULL,"BIMHERA","במהרה","במהרה",NULL,"BMHRH","BMHRH",NULL);
INSERT INTO hebrew_morpho VALUES (92093,"כְּדָאִיּוּת","n",NULL,"KEDA\'IYUT","כדאיות","כדאיות",NULL,"KDAIWT","KDAIWT",NULL);
INSERT INTO hebrew_morpho VALUES (92094,"מַכְשִׁיר","n",NULL,"MACHSHIR","מכשיר","מכשיר",NULL,"MK$IR","MK$IR",NULL);
INSERT INTO hebrew_morpho VALUES (92095,"כְּלוֹר","n",NULL,"KLOR","כלור","כלור",NULL,"KLWR","KLWR",NULL);
INSERT INTO hebrew_morpho VALUES (92096,"כְּמִיהָה","n",NULL,"KMIHA","כמיהה","כמיהה",NULL,"KMIHH","KMIHH",NULL);
INSERT INTO hebrew_morpho VALUES (92097,"כְּמוּרָה","n",NULL,"KMURA","כמורה","כמורה",NULL,"KMWRH","KMWRH",NULL);
INSERT INTO hebrew_morpho VALUES (92098,"כְּתֹבֶת","n",NULL,"KTOVET","כתובת","כתבת",NULL,"KTBT","KTWBT",NULL);
INSERT INTO hebrew_morpho VALUES (92099,"כְּנֵסִיָּה","n",NULL,"KNESIYA","כנסייה","כנסיה",NULL,"KNSIH","KNSIIH",NULL);
INSERT INTO hebrew_morpho VALUES (92100,"כְּפִירָה","n",NULL,"KFIRA","כפירה","כפירה",NULL,"KPIRH","KPIRH",NULL);
INSERT INTO hebrew_morpho VALUES (92101,"כְּפָפָה","n",NULL,"KFAFA","כפפה","כפפה",NULL,"KPPH","KPPH",NULL);
INSERT INTO hebrew_morpho VALUES (92102,"כְּפָפַת-אִגְרוּף","n",NULL,"KFAFAT-IGRUF","כפפת-איגרוף","כפפת-אגרוף",NULL,"KPPT-AGRWP","KPPT-AIGRWP",NULL);
INSERT INTO hebrew_morpho VALUES (92103,"כְּרָזָה","n",NULL,"KRAZA","כרזה","כרזה",NULL,"KRZH","KRZH",NULL);
INSERT INTO hebrew_morpho VALUES (92104,"כְּרוּבִית","n",NULL,"KRUVIT","כרובית","כרובית",NULL,"KRWBIT","KRWBIT",NULL);
INSERT INTO hebrew_morpho VALUES (92105,"כְּרוּכְיָה","n",NULL,"KRUCHIYA","כרוכיה","כרוכיה",NULL,"KRWKIH","KRWKIH",NULL);
INSERT INTO hebrew_morpho VALUES (92106,"כְּתִיב","n",NULL,"KTIV","כתיב","כתיב",NULL,"KTIB","KTIB",NULL);
INSERT INTO hebrew_morpho VALUES (92107,"כְּתוּבִים","n",NULL,"KTUVIM","כתובים","כתובים",NULL,"KTWBIM","KTWBIM",NULL);
INSERT INTO hebrew_morpho VALUES (92108,"כִּבְשָׂה","n",NULL,"KIVSA","כבשה","כבשה",NULL,"KB$H","KB$H",NULL);
INSERT INTO hebrew_morpho VALUES (92109,"כִּבּוּשׁ","n",NULL,"KIBUSH","כיבוש","כבוש",NULL,"KBW$","KIBW$",NULL);
INSERT INTO hebrew_morpho VALUES (92110,"פִּדְיוֹן","n",NULL,"PIDYON","פידיון","פדיון",NULL,"PDIWN","PIDIWN",NULL);
INSERT INTO hebrew_morpho VALUES (92111,"כִּוְנוּן","n",NULL,"KIVNUN","כיוונון","כונון",NULL,"KWNWN","KIWWNWN",NULL);
INSERT INTO hebrew_morpho VALUES (92112,"כִּיּוּל","n",NULL,"KIYUL","כיול","כיול",NULL,"KIWL","KIWL",NULL);
INSERT INTO hebrew_morpho VALUES (92113,"כִּיב","n",NULL,"KIV","כיב","כיב",NULL,"KIB","KIB",NULL);
INSERT INTO hebrew_morpho VALUES (92114,"כִּידוֹן","n",NULL,"KIDON","כידון","כידון",NULL,"KIDWN","KIDWN",NULL);
INSERT INTO hebrew_morpho VALUES (92115,"כִּילַי","n",NULL,"KILAY","כיליי","כילי",NULL,"KILI","KILII",NULL);
INSERT INTO hebrew_morpho VALUES (92116,"כִּימְיָה","n",NULL,"KIMIYA","כימיה","כימיה",NULL,"KIMIH","KIMIH",NULL);
INSERT INTO hebrew_morpho VALUES (92117,"כִּימִי","a",NULL,"KIMI","כימי","כימי",NULL,"KIMI","KIMI",NULL);
INSERT INTO hebrew_morpho VALUES (92118,"כִּכָּר","n",NULL,"KIKAR","כיכר","ככר",NULL,"KKR","KIKR",NULL);
INSERT INTO hebrew_morpho VALUES (92119,"כִּלְיָה","n",NULL,"KILYA","כליה","כליה",NULL,"KLIH","KLIH",NULL);
INSERT INTO hebrew_morpho VALUES (92120,"כִּנּוֹר","n",NULL,"KINOR","כינור","כנור",NULL,"KNWR","KINWR",NULL);
INSERT INTO hebrew_morpho VALUES (92121,"כִּנּוּי","n",NULL,"KINUY","כינוי","כנוי",NULL,"KNWI","KINWI",NULL);
INSERT INTO hebrew_morpho VALUES (92122,"כִּעוּר","n",NULL,"KI\'UR","כיעור","כעור",NULL,"K&WR","KI&WR",NULL);
INSERT INTO hebrew_morpho VALUES (92123,"כִּפָּה","n",NULL,"KIPA","כיפה","כפה",NULL,"KPH","KIPH",NULL);
INSERT INTO hebrew_morpho VALUES (92124,"כִּשְׁכֵּשׁ","v",NULL,"KISHKESH","כישכש","כשכש",NULL,"K$K$","KI$K$",NULL);
INSERT INTO hebrew_morpho VALUES (92125,"כִּתָּה","n",NULL,"KITA","כיתה","כתה",NULL,"KTH","KITH",NULL);
INSERT INTO hebrew_morpho VALUES (92126,"כִּתּוּר","n",NULL,"KITUR","כיתור","כתור",NULL,"KTWR","KITWR",NULL);
INSERT INTO hebrew_morpho VALUES (92127,"כֶּבֶשׂ","n",NULL,"KEVES","כבש","כבש",NULL,"KB$","KB$",NULL);
INSERT INTO hebrew_morpho VALUES (92128,"כֶּנֶס","n",NULL,"KENES","כנס","כנס",NULL,"KNS","KNS",NULL);
INSERT INTO hebrew_morpho VALUES (92129,"כֶּסֶף","n",NULL,"KESEF","כסף","כסף",NULL,"KSP","KSP",NULL);
INSERT INTO hebrew_morpho VALUES (92130,"כֶּסֶת","n",NULL,"KESET","כסת","כסת",NULL,"KST","KST",NULL);
INSERT INTO hebrew_morpho VALUES (92131,"כֶּרֶם","n",NULL,"KEREM","כרם","כרם",NULL,"KRM","KRM",NULL);
INSERT INTO hebrew_morpho VALUES (92132,"כֶּתֶם","n",NULL,"KETEM","כתם","כתם",NULL,"KTM","KTM",NULL);
INSERT INTO hebrew_morpho VALUES (92133,"כַּדּוּרְסַל","n",NULL,"KADURSAL","כדורסל","כדורסל",NULL,"KDWRSL","KDWRSL",NULL);
INSERT INTO hebrew_morpho VALUES (92134,"כַּדּוּרְעָף","n",NULL,"KADUR\'AF","כדורעף","כדורעף",NULL,"KDWR&P","KDWR&P",NULL);
INSERT INTO hebrew_morpho VALUES (92135,"כַּהֲלָכָה","r",NULL,"KAHALACHA","כהלכה","כהלכה",NULL,"KHLKH","KHLKH",NULL);
INSERT INTO hebrew_morpho VALUES (92136,"כַּוְרָן","n",NULL,"KAVRAN","כוורן","כורן",NULL,"KWRN","KWWRN",NULL);
INSERT INTO hebrew_morpho VALUES (92137,"כַּוְרָנוּת","n",NULL,"KAVRANUT","כוורנות","כורנות",NULL,"KWRNWT","KWWRNWT",NULL);
INSERT INTO hebrew_morpho VALUES (92138,"כַּיָּס","n",NULL,"KAYAS","כייס","כיס",NULL,"KIS","KIIS",NULL);
INSERT INTO hebrew_morpho VALUES (92139,"כַּלְכְּלָן","n",NULL,"KALKELAN","כלכלן","כלכלן",NULL,"KLKLN","KLKLN",NULL);
INSERT INTO hebrew_morpho VALUES (92140,"כַּלְכָּלָה","n",NULL,"KALKALA","כלכלה","כלכלה",NULL,"KLKLH","KLKLH",NULL);
INSERT INTO hebrew_morpho VALUES (92141,"כַּלָּה","n",NULL,"KALA","כלה","כלה",NULL,"KLH","KLH",NULL);
INSERT INTO hebrew_morpho VALUES (92142,"כַּלָּנִית","n",NULL,"KALANIT","כלנית","כלנית",NULL,"KLNIT","KLNIT",NULL);
INSERT INTO hebrew_morpho VALUES (92143,"כַּמָּה","a",NULL,"KAMA","כמה","כמה",NULL,"KMH","KMH",NULL);
INSERT INTO hebrew_morpho VALUES (92144,"כַּמּוּבָן","r",NULL,"KAMUVAN","כמובן","כמובן",NULL,"KMWBN","KMWBN",NULL);
INSERT INTO hebrew_morpho VALUES (92145,"כַּסְפִּית","n",NULL,"KASPIT","כספית","כספית",NULL,"KSPIT","KSPIT",NULL);
INSERT INTO hebrew_morpho VALUES (92146,"כַּף","n",NULL,"KAF","כף","כף",NULL,"KP","KP",NULL);
INSERT INTO hebrew_morpho VALUES (92147,"כַּפִּית","n",NULL,"KAPIT","כפית","כפית",NULL,"KPIT","KPIT",NULL);
INSERT INTO hebrew_morpho VALUES (92148,"כַּפָּרָה","n",NULL,"KAPARA","כפרה","כפרה",NULL,"KPRH","KPRH",NULL);
INSERT INTO hebrew_morpho VALUES (92149,"כַּר","n",NULL,"KAR","כר","כר",NULL,"KR","KR",NULL);
INSERT INTO hebrew_morpho VALUES (92150,"דּוּחַ","n",NULL,"DU\'ACH","דוח","דוח",NULL,"DWX","DWX",NULL);
INSERT INTO hebrew_morpho VALUES (92151,"דו&quot;ח-תְּנוּעָה","n",NULL,"DOCH-TNU\'AH","דוח-תנועה","דו&quot;ח-תנועה",NULL,"DW&quot;X-TNW&H","DWX-TNW&H",NULL);
INSERT INTO hebrew_morpho VALUES (92152,"כַּרְכֹּם","n",NULL,"KARKOM","כרכום","כרכם",NULL,"KRKM","KRKWM",NULL);
INSERT INTO hebrew_morpho VALUES (92153,"כָּבֵד","n",NULL,"KAVED","כבד","כָּבֵד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92154,"כָּבַשׁ","v",NULL,"KAVASH","כבש","כבש",NULL,"KB$","KB$",NULL);
INSERT INTO hebrew_morpho VALUES (92155,"כָּבוּל","a",NULL,"KAVUL","כבול","כבול",NULL,"KBWL","KBWL",NULL);
INSERT INTO hebrew_morpho VALUES (92156,"כָּבוּל","n",NULL,"KAVUL","כבול","כבול",NULL,"KBWL","KBWL",NULL);
INSERT INTO hebrew_morpho VALUES (92157,"כָּבוּשׁ","a",NULL,"KAVUSH","כבוש","כבוש",NULL,"KBW$","KBW$",NULL);
INSERT INTO hebrew_morpho VALUES (92158,"כָּךְ","r",NULL,"KACH","כך","כך",NULL,"KK","KK",NULL);
INSERT INTO hebrew_morpho VALUES (92159,"כָּפוּל","a",NULL,"KAFUL","כפול","כפול",NULL,"KPWL","KPWL",NULL);
INSERT INTO hebrew_morpho VALUES (92160,"כָּרִיךְ","n",NULL,"KARICH","כריך","כריך",NULL,"KRIK","KRIK",NULL);
INSERT INTO hebrew_morpho VALUES (92161,"כָּרִישׁ","n",NULL,"KARISH","כריש","כריש",NULL,"KRI$","KRI$",NULL);
INSERT INTO hebrew_morpho VALUES (92162,"כָּרַת","v",NULL,"KARAT","כרת","כרת",NULL,"KRT","KRT",NULL);
INSERT INTO hebrew_morpho VALUES (92163,"כָּרָגִיל","r",NULL,"KARAGIL","כרגיל","כרגיל",NULL,"KRGIL","KRGIL",NULL);
INSERT INTO hebrew_morpho VALUES (92164,"כָּרָה","v",NULL,"KARA","כרה","כרה",NULL,"KRH","KRH",NULL);
INSERT INTO hebrew_morpho VALUES (92165,"כָּתֹם","a",NULL,"KATOM","כתום","כתם",NULL,"KTM","KTWM",NULL);
INSERT INTO hebrew_morpho VALUES (92166,"כֻּמְתָּה","n",NULL,"KUMTA","כומתה","כמתה",NULL,"KMTH","KWMTH",NULL);
INSERT INTO hebrew_morpho VALUES (92167,"כֻּרְסָה","n",NULL,"KURSA","כורסה","כרסה",NULL,"KRSH","KWRSH",NULL);
INSERT INTO hebrew_morpho VALUES (92168,"כּוֹבֵשׁ","n",NULL,"KOVESH","כובש","כובש",NULL,"KWB$","KWB$",NULL);
INSERT INTO hebrew_morpho VALUES (92169,"כּוֹלֶרָה","n",NULL,"KOLERA","כולרה","כולרה",NULL,"KWLRH","KWLRH",NULL);
INSERT INTO hebrew_morpho VALUES (92170,"כּוֹרֵךְ","n",NULL,"KORECH","כורך","כורך",NULL,"KWRK","KWRK",NULL);
INSERT INTO hebrew_morpho VALUES (92171,"כּוֹרֶה","n",NULL,"KORE","כורה","כורה",NULL,"KWRH","KWRH",NULL);
INSERT INTO hebrew_morpho VALUES (92172,"כּוֹתֶרֶת","n",NULL,"KOTERET","כותרת","כותרת",NULL,"KWTRT","KWTRT",NULL);
INSERT INTO hebrew_morpho VALUES (92173,"לְאַט","r",NULL,"LE\'AT","לאט","לאט",NULL,"LA@","LA@",NULL);
INSERT INTO hebrew_morpho VALUES (92174,"לְאֻמִּיּוּת","n",NULL,"LEU\'MIYUT","לאומיות","לאמיות",NULL,"LAMIWT","LAWMIWT",NULL);
INSERT INTO hebrew_morpho VALUES (92175,"לְבִיאָה","n",NULL,"LEVI\'A","לביאה","לביאה",NULL,"LBIAH","LBIAH",NULL);
INSERT INTO hebrew_morpho VALUES (92176,"לְבִיבָה","n",NULL,"LEVIVA","לביבה","לביבה",NULL,"LBIBH","LBIBH",NULL);
INSERT INTO hebrew_morpho VALUES (92177,"לְבֵנָה","n",NULL,"LEVENA","לבנה","לבנה",NULL,"LBNH","LBNH",NULL);
INSERT INTO hebrew_morpho VALUES (92178,"לְבָבִי","a",NULL,"LEVAVI","לבבי","לבבי",NULL,"LBBI","LBBI",NULL);
INSERT INTO hebrew_morpho VALUES (92179,"לְבָבִיּוּת","n",NULL,"LEVAVIYUT","לבביות","לבביות",NULL,"LBBIWT","LBBIWT",NULL);
INSERT INTO hebrew_morpho VALUES (92180,"לְבָנִים","n",NULL,"LEVANIM","לבנים","לבנים",NULL,"LBNIM","LBNIM",NULL);
INSERT INTO hebrew_morpho VALUES (92181,"לְגִימָה","n",NULL,"LEGIMA","לגימה","לגימה",NULL,"LGIMH","LGIMH",NULL);
INSERT INTO hebrew_morpho VALUES (92182,"לְגַמְרֵי","r",NULL,"LEGAMREI","לגמרי","לגמרי",NULL,"LGMRI","LGMRI",NULL);
INSERT INTO hebrew_morpho VALUES (92183,"רַק","r",NULL,"RAK","רק","רק",NULL,"RQ","RQ",NULL);
INSERT INTO hebrew_morpho VALUES (92184,"לְהִיטוּת","n",NULL,"LEHITUT","להיטות","להיטות",NULL,"LHI@WT","LHI@WT",NULL);
INSERT INTO hebrew_morpho VALUES (92185,"לְחוּד","r",NULL,"LEXUD","לחוד","לחוד",NULL,"LXWD","LXWD",NULL);
INSERT INTO hebrew_morpho VALUES (92186,"לְטִיפָה","n",NULL,"LETIFA","לטיפה","לטיפה",NULL,"L@IPH","L@IPH",NULL);
INSERT INTO hebrew_morpho VALUES (92187,"לְטָאָה","n",NULL,"LETA\'AH","לטאה","לטאה",NULL,"L@AH","L@AH",NULL);
INSERT INTO hebrew_morpho VALUES (92188,"לְמַדַּי","r",NULL,"LEMADAY","למדי","למדי",NULL,"LMDI","LMDI",NULL);
INSERT INTO hebrew_morpho VALUES (92189,"לְסֵרוּגִין","r",NULL,"LESERUGIN","לסירוגין","לסרוגין",NULL,"LSRWGIN","LSIRWGIN",NULL);
INSERT INTO hebrew_morpho VALUES (92190,"לְעִתִּים-קְרוֹבוֹת","r",NULL,"LE\'ITIM KROVOT","לעתים_קרובות","לעתים-קרובות",NULL,"L&TIM-QRWBWT","L&TIM_QRWBWT",NULL);
INSERT INTO hebrew_morpho VALUES (92191,"לְעִתִּים-רְחוֹקוֹת","r",NULL,"LE\'ITIM REXOKOT","לעתים-רחוקות","לעתים-רחוקות",NULL,"L&TIM-RXWQWT","L&TIM-RXWQWT",NULL);
INSERT INTO hebrew_morpho VALUES (92192,"לְפָנִים","r",NULL,"LEFANIM","לפנים","לפנים",NULL,"LPNIM","LPNIM",NULL);
INSERT INTO hebrew_morpho VALUES (92193,"לִבְנֶה","n",NULL,"LIVNEH","לבנה","לבנה",NULL,"LBNH","LBNH",NULL);
INSERT INTO hebrew_morpho VALUES (92194,"לִוְיָתָן","n",NULL,"LIVYATAN","לוויתן","לויתן",NULL,"LWITN","LWWITN",NULL);
INSERT INTO hebrew_morpho VALUES (92195,"לִטֵּשׁ","v",NULL,"LITESH","ליטש","לטש",NULL,"L@$","LI@$",NULL);
INSERT INTO hebrew_morpho VALUES (92196,"לִטּוּף","n",NULL,"LITUF","ליטוף","לטוף",NULL,"L@WP","LI@WP",NULL);
INSERT INTO hebrew_morpho VALUES (92197,"נְפִילָה","n",NULL,"NEFILA","נפילה","נפילה",NULL,"NPILH","NPILH",NULL);
INSERT INTO hebrew_morpho VALUES (92198,"לִילָךְ","n",NULL,"LILAX","לילך","לילך",NULL,"LILK","LILK",NULL);
INSERT INTO hebrew_morpho VALUES (92199,"מִדֵּי-פַּעַם","r",NULL,"MIDEI-PA\'AM","מדי-פעם","מדי-פעם",NULL,"MDI-P&M","MDI-P&M",NULL);
INSERT INTO hebrew_morpho VALUES (92200,"לִפְעָמִים","r",NULL,"LIF\'AMIM","לפעמים","לפעמים",NULL,"LP&MIM","LP&MIM",NULL);
INSERT INTO hebrew_morpho VALUES (92201,"לֵאוּת","n",NULL,"LE\'UT","לאות","לאות",NULL,"LAWT","LAWT",NULL);
INSERT INTO hebrew_morpho VALUES (92202,"לֵץ","n",NULL,NULL,NULL,"לץ",NULL,"LC",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92203,"לֵץ","n",NULL,"LETZ","לץ","לץ",NULL,"LC","LC",NULL);
INSERT INTO hebrew_morpho VALUES (92204,"לֶבֶד","n",NULL,"LEVED","לבד","לבד",NULL,"LBD","LBD",NULL);
INSERT INTO hebrew_morpho VALUES (92205,"לֶחֶם","n",NULL,"LECHEM","לחם","לחם",NULL,"LXM","LXM",NULL);
INSERT INTO hebrew_morpho VALUES (92206,"לֶפֶת","n",NULL,"LEFET","לפת","לפת",NULL,"LPT","LPT",NULL);
INSERT INTO hebrew_morpho VALUES (92207,"לֶקֶט","n",NULL,"LEKET","לקט","לקט",NULL,"LQ@","LQ@",NULL);
INSERT INTO hebrew_morpho VALUES (92208,"לֶשֶׁם","n",NULL,"LESHEM","לשם","לשם",NULL,"L$M","L$M",NULL);
INSERT INTO hebrew_morpho VALUES (92209,"לַבְלַב","n",NULL,"LAVLAV","לבלב","לבלב",NULL,"LBLB","LBLB",NULL);
INSERT INTO hebrew_morpho VALUES (92210,"לַבְקָן","n",NULL,"LAVKAN","לבקן","לבקן",NULL,"LBQN","LBQN",NULL);
INSERT INTO hebrew_morpho VALUES (92211,"לַהֲקָה","n",NULL,"LAHAKA","להקה","להקה",NULL,"LHQH","LHQH",NULL);
INSERT INTO hebrew_morpho VALUES (92212,"לַהַג","n",NULL,"LAHAG","להג","להג",NULL,"LHG","LHG",NULL);
INSERT INTO hebrew_morpho VALUES (92213,"לַוְיָן","n",NULL,"LAVYAN","לווין","לוין",NULL,"LWIN","LWWIN",NULL);
INSERT INTO hebrew_morpho VALUES (92214,"לַח","a",NULL,"LAX","לח","לח",NULL,"LX","LX",NULL);
INSERT INTO hebrew_morpho VALUES (92215,"לַחְלוּחִי","a",NULL,"LACHLUCHI","לחלוחי","לחלוחי",NULL,"LXLWXI","LXLWXI",NULL);
INSERT INTO hebrew_morpho VALUES (92216,"לַחְמָנִיָּה","n",NULL,"LAXMANIYA","לחמנייה","לחמניה",NULL,"LXMNIH","LXMNIIH",NULL);
INSERT INTO hebrew_morpho VALUES (92217,"לַחַן","n",NULL,"LAXAN","לחן","לחן",NULL,"LXN","LXN",NULL);
INSERT INTO hebrew_morpho VALUES (92218,"לַחַשׁ","n",NULL,"LAXASH","לחש","לחש",NULL,"LX$","LX$",NULL);
INSERT INTO hebrew_morpho VALUES (92219,"לַחוּת","n",NULL,"LAXUT","לחות","לחות",NULL,"LXWT","LXWT",NULL);
INSERT INTO hebrew_morpho VALUES (92220,"לַעֲנָה","n",NULL,"LA\'ANAH","לענה","לענה",NULL,"L&NH","L&NH",NULL);
INSERT INTO hebrew_morpho VALUES (92221,"לַשָּׁוְא","r",NULL,"LASHAV","לשווא","לשוא",NULL,"L$WA","L$WWA",NULL);
INSERT INTO hebrew_morpho VALUES (92222,"לָגַם","v",NULL,"LAGAM","לגם","לגם",NULL,"LGM","LGM",NULL);
INSERT INTO hebrew_morpho VALUES (92223,"לָחַשׁ","v",NULL,"LAXASH","לחש","לחש",NULL,"LX$","LX$",NULL);
INSERT INTO hebrew_morpho VALUES (92224,"לוֹחֵם","n",NULL,"LOXEM","לוחם","לוחם",NULL,"LWXM","LWXM",NULL);
INSERT INTO hebrew_morpho VALUES (92225,"לוּל","n",NULL,"LUL","לול","לול",NULL,"LWL","LWL",NULL);
INSERT INTO hebrew_morpho VALUES (92226,"לוּלְיָן","n",NULL,"LULYAN","לוליין","לולין",NULL,"LWLIN","LWLIIN",NULL);
INSERT INTO hebrew_morpho VALUES (92227,"לוּלָאָה","n",NULL,"LULA\'AH","לולאה","לולאה",NULL,"LWLAH","LWLAH",NULL);
INSERT INTO hebrew_morpho VALUES (92228,"אוֹלָר","n",NULL,NULL,"אולר","אולר",NULL,"AWLR","AWLR",NULL);
INSERT INTO hebrew_morpho VALUES (92229,"מְהֵימָן","a",NULL,NULL,"מהימן","מהימן",NULL,"MHIMN","MHIMN",NULL);
INSERT INTO hebrew_morpho VALUES (92230,"מְהֵימָנוּת","n",NULL,"MEHEYMANUT","מהימנות","מהימנות",NULL,"MHIMNWT","MHIMNWT",NULL);
INSERT INTO hebrew_morpho VALUES (92231,"קָאוּבּוֹי","n",NULL,"KAUBOI","קאובוי","קאובוי",NULL,"QAWBWI","QAWBWI",NULL);
INSERT INTO hebrew_morpho VALUES (92232,"בּוֹקֵר","n",NULL,"BOKER","בוקר","בוקר",NULL,"BWQR","BWQR",NULL);
INSERT INTO hebrew_morpho VALUES (92233,"מְנַתֵּחַ","n",NULL,"MENATE\'ACH","מנתח","מנתח",NULL,"MNTX","MNTX","male");
INSERT INTO hebrew_morpho VALUES (92234,"מְעַצְבֵּן","a",NULL,"ME\'ATZBEN","מעצבן","מעצבן",NULL,"M&CBN","M&CBN",NULL);
INSERT INTO hebrew_morpho VALUES (92235,"מְעֻרְפָּל","a",NULL,"ME\'URPAL","מעורפל","מערפל",NULL,"M&RPL","M&WRPL",NULL);
INSERT INTO hebrew_morpho VALUES (92236,"מְפֻרְסָם","a",NULL,"MEFURSAM","מפורסם","מפרסם",NULL,"MPRSM","MPWRSM",NULL);
INSERT INTO hebrew_morpho VALUES (92237,"מְצִיצָה","n",NULL,"METZITZA","מציצה","מציצה",NULL,"MCICH","MCICH",NULL);
INSERT INTO hebrew_morpho VALUES (92238,"מְשֻׁתָּף","a",NULL,"MESHUTAF","משותף","משתף",NULL,"M$TP","M$WTP",NULL);
INSERT INTO hebrew_morpho VALUES (92239,"מִדְבָּר","n",NULL,"MIDBAR","מדבר","מדבר",NULL,"MDBR","MDBR",NULL);
INSERT INTO hebrew_morpho VALUES (92240,"מִטְבָּח","n",NULL,"MITBAX","מטבח","מטבח",NULL,"M@BX","M@BX",NULL);
INSERT INTO hebrew_morpho VALUES (92241,"מִטְרִיָּה","n",NULL,"MITRIYA","מטרייה","מטריה",NULL,"M@RIH","M@RIIH",NULL);
INSERT INTO hebrew_morpho VALUES (92242,"מִסְפָּר","a",NULL,"MISPAR","מספר","מספר",NULL,"MSPR","MSPR",NULL);
INSERT INTO hebrew_morpho VALUES (92243,"מִצְמוּץ","n",NULL,"MITZMUTZ","מיצמוץ","מצמוץ",NULL,"MCMWC","MICMWC",NULL);
INSERT INTO hebrew_morpho VALUES (92244,"מִצְעָד","n",NULL,"MITZ\'AD","מצעד","מצעד",NULL,"MC&D","MC&D",NULL);
INSERT INTO hebrew_morpho VALUES (92245,"מִרְדָּף","n",NULL,"MIRDAF","מירדף","מרדף",NULL,"MRDP","MIRDP",NULL);
INSERT INTO hebrew_morpho VALUES (92246,"מִשְׁוָאָה","n",NULL,"MISHVA\'AH","משוואה","משואה",NULL,"M$WAH","M$WWAH",NULL);
INSERT INTO hebrew_morpho VALUES (92247,"הַאֲצָלַת-סַמְכֻיּוֹת","n",NULL,"HA\'ATZALAT SAMCHUYOT","האצלת-סמכויות","האצלת-סמכיות",NULL,"HACLT-SMKIWT","HACLT-SMKWIWT",NULL);
INSERT INTO hebrew_morpho VALUES (92248,"מֵנִיעַ","n",NULL,"MENI\'AH","מניע","מניע",NULL,"MNI&","MNI&",NULL);
INSERT INTO hebrew_morpho VALUES (92249,"מֵרוּק","n",NULL,"MERUK","מירוק","מרוק",NULL,"MRWQ","MIRWQ",NULL);
INSERT INTO hebrew_morpho VALUES (92250,"מֶחֱוָה","n",NULL,"MECHEVA","מחווה","מחוה",NULL,"MXWH","MXWWH",NULL);
INSERT INTO hebrew_morpho VALUES (92251,"מֶטֶר","n",NULL,"METER","מטר","מטר",NULL,"M@R","M@R",NULL);
INSERT INTO hebrew_morpho VALUES (92252,"מֶרְץ","n",NULL,"MERTZ","מרץ","מרץ",NULL,"MRC","MRC",NULL);
INSERT INTO hebrew_morpho VALUES (92253,"מַנְגִּינָה","n",NULL,"MANGINA","מנגינה","מנגינה",NULL,"MNGINH","MNGINH",NULL);
INSERT INTO hebrew_morpho VALUES (92254,"שֶׁפַע","n",NULL,"SHEFA","שפע","שפע",NULL,"$P&","$P&",NULL);
INSERT INTO hebrew_morpho VALUES (92255,"מַפָּלָה","n",NULL,"MAPALA","מפלה","מפלה",NULL,"MPLH","MPLH",NULL);
INSERT INTO hebrew_morpho VALUES (92256,"מַרְס","n",NULL,"MARS","מרס","מרס",NULL,"MRS","MRS",NULL);
INSERT INTO hebrew_morpho VALUES (92257,"מַרְצֶפֶת","n",NULL,NULL,"מרצפת","מרצפת",NULL,"MRCPT","MRCPT",NULL);
INSERT INTO hebrew_morpho VALUES (92258,"מַרְשֶׁה","n",NULL,"MARSHEH","מרשה","מרשה",NULL,"MR$H","MR$H",NULL);
INSERT INTO hebrew_morpho VALUES (92259,"אוֹר","n",NULL,NULL,"אור","אור",NULL,"AWR","AWR",NULL);
INSERT INTO hebrew_morpho VALUES (92260,"מֻמְחֶה","n",NULL,"mumche","מומחה","מֻמְחֶה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92261,"מֻצָּג","n",NULL,"MUTZAG","מוצג","מצג",NULL,"MCG","MWCG",NULL);
INSERT INTO hebrew_morpho VALUES (92262,"נְדוּנְיָה","n",NULL,"NEDUNYA","נדוניה","נדוניה",NULL,"NDWNIH","NDWNIH",NULL);
INSERT INTO hebrew_morpho VALUES (92263,"נְזִיפָה","n",NULL,"NEZIFA","נזיפה","נזיפה",NULL,"NZIPH","NZIPH",NULL);
INSERT INTO hebrew_morpho VALUES (92264,"נְמָלָה","n",NULL,"NEMALA","נמלה","נמלה",NULL,"NMLH","NMLH",NULL);
INSERT INTO hebrew_morpho VALUES (92265,"נְקֵבָה","n",NULL,"NEKEVA","נקבה","נקבה",NULL,"NQBH","NQBH",NULL);
INSERT INTO hebrew_morpho VALUES (92266,"נִגְמַר","v",NULL,"NIGMAR","נגמר","נגמר",NULL,"NGMR","NGMR",NULL);
INSERT INTO hebrew_morpho VALUES (92267,"נִהְיָה","v",NULL,"NIH\'YA","נהיה","נהיה",NULL,"NHIH","NHIH",NULL);
INSERT INTO hebrew_morpho VALUES (92268,"נִיב","n",NULL,"NIV","ניב","ניב",NULL,"NIB","NIB",NULL);
INSERT INTO hebrew_morpho VALUES (92269,"נִמְנֵם","v",NULL,"NIMNEM","נימנם","נמנם",NULL,"NMNM","NIMNM",NULL);
INSERT INTO hebrew_morpho VALUES (92270,"נִתְבָּע","n",NULL,"NITBA","נתבע","נתבע",NULL,"NTB&","NTB&",NULL);
INSERT INTO hebrew_morpho VALUES (92271,"נֵבֶל","n",NULL,"NEVEL","נבל","נבל",NULL,"NBL","NBL",NULL);
INSERT INTO hebrew_morpho VALUES (92272,"נֵץ","n",NULL,"NETS","נץ","נץ",NULL,"NC","NC",NULL);
INSERT INTO hebrew_morpho VALUES (92273,"נֵר","n",NULL,"NER","נר","נר",NULL,"NR","NR",NULL);
INSERT INTO hebrew_morpho VALUES (92274,"נַגָּר","n",NULL,"NAGAR","נגר","נגר",NULL,"NGR","NGR",NULL);
INSERT INTO hebrew_morpho VALUES (92275,"נַצְרוּת","n",NULL,"NATSRUT","נצרות","נצרות",NULL,"NCRWT","NCRWT",NULL);
INSERT INTO hebrew_morpho VALUES (92276,"נַתְרָן","n",NULL,"NATRAN","נתרן","נתרן",NULL,"NTRN","NTRN",NULL);
INSERT INTO hebrew_morpho VALUES (92277,"נָהָר","n",NULL,"NAHAR","נהר","נהר",NULL,"NHR","NHR",NULL);
INSERT INTO hebrew_morpho VALUES (92278,"נָחָשׁ","n",NULL,"NAXASH","נחש","נחש",NULL,"NX$","NX$",NULL);
INSERT INTO hebrew_morpho VALUES (92279,"נָמֵל","n",NULL,"NAMEL","נמל","נמל",NULL,"NML","NML",NULL);
INSERT INTO hebrew_morpho VALUES (92280,"נָמֵר","n",NULL,"NAMER","נמר","נמר",NULL,"NMR","NMR",NULL);
INSERT INTO hebrew_morpho VALUES (92281,"נֹגַהּ","n",NULL,"NOGA","נוגה","נגה",NULL,"NGH","NWGH",NULL);
INSERT INTO hebrew_morpho VALUES (92282,"נוֹצְרִי","a",NULL,"NOTSRI","נוצרי","נוצרי",NULL,"NWCRI","NWCRI",NULL);
INSERT INTO hebrew_morpho VALUES (92283,"נוֹצְרִי","n",NULL,"NOTSRI","נוצרי","נוצרי",NULL,"NWCRI","NWCRI",NULL);
INSERT INTO hebrew_morpho VALUES (92284,"הַעֲלָאַת-מִרְיָם","n",NULL,"HA\'ALA\'AT-MIRYAM","העלאת-מרים","העלאת-מרים",NULL,"H&LAT-MRIM","H&LAT-MRIM",NULL);
INSERT INTO hebrew_morpho VALUES (92285,"תְּרוּמָה","n",NULL,"TRUMA","תרומה","תרומה",NULL,"TRWMH","TRWMH",NULL);
INSERT INTO hebrew_morpho VALUES (92286,"סִפּוּרִי","a",NULL,"SIPURI","סיפורי","ספורי",NULL,"SPWRI","SIPWRI",NULL);
INSERT INTO hebrew_morpho VALUES (92287,"סַבְלָנִי","a",NULL,"SAVLANI","סבלני","סבלני",NULL,"SBLNI","SBLNI",NULL);
INSERT INTO hebrew_morpho VALUES (92288,"סַוָּר","n",NULL,"SAVAR","סוור","סור",NULL,"SWR","SWWR",NULL);
INSERT INTO hebrew_morpho VALUES (92289,"סַסְגּוֹנִי","a",NULL,"SASGONI","ססגוני","ססגוני",NULL,"SSGWNI","SSGWNI",NULL);
INSERT INTO hebrew_morpho VALUES (92290,"סָבִיל","a",NULL,"SAVIL","סביל","סביל",NULL,"SBIL","SBIL",NULL);
INSERT INTO hebrew_morpho VALUES (92291,"פָּסִיבִי","a",NULL,"PASSIVI","פסיבי","פסיבי",NULL,"PSIBI","PSIBI",NULL);
INSERT INTO hebrew_morpho VALUES (92292,"שָׁקוּל","a",NULL,"SHAKUL","שקול","שקול",NULL,"$QWL","$QWL",NULL);
INSERT INTO hebrew_morpho VALUES (92293,"סוֹאֵן","a",NULL,"SO\'EN","סואן","סואן",NULL,"SWAN","SWAN",NULL);
INSERT INTO hebrew_morpho VALUES (92294,"עֲזִיבָה","n",NULL,"AZIVA","עזיבה","עזיבה",NULL,"&ZIBH","&ZIBH",NULL);
INSERT INTO hebrew_morpho VALUES (92295,"עֲצוּמָה","n",NULL,"ATZUMA","עצומה","עצומה",NULL,"&CWMH","&CWMH",NULL);
INSERT INTO hebrew_morpho VALUES (92296,"הֲטָלַת-בֵּיצִים","n",NULL,"HATALAT-BEITZIM","הטלת-ביצים","הטלת-ביצים",NULL,"H@LT-BICIM","H@LT-BICIM",NULL);
INSERT INTO hebrew_morpho VALUES (92297,"עֲרֵבוּת","n",NULL,"AREVUT","ערבות","ערבות",NULL,"&RBWT","&RBWT",NULL);
INSERT INTO hebrew_morpho VALUES (92298,"עֲרֻבָּה","n",NULL,"ARUBA","ערובה","ערבה",NULL,"&RBH","&RWBH",NULL);
INSERT INTO hebrew_morpho VALUES (92299,"הַפְחָתָה","n",NULL,"HAFCHATA","הפחתה","הפחתה",NULL,"HPXTH","HPXTH",NULL);
INSERT INTO hebrew_morpho VALUES (92300,"עֵמֶק","n",NULL,"EMEK","עמק","עמק",NULL,"&MQ","&MQ",NULL);
INSERT INTO hebrew_morpho VALUES (92301,"עֶרְגָּה","n",NULL,"ERGA","ערגה","ערגה",NULL,"&RGH","&RGH",NULL);
INSERT INTO hebrew_morpho VALUES (92302,"עָגוּר","n",NULL,"AGUR","עגור","עגור",NULL,"&GWR","&GWR",NULL);
INSERT INTO hebrew_morpho VALUES (92303,"עַלְוָה","n",NULL,"ALVA","עלווה","עלוה",NULL,"&LWH","&LWWH",NULL);
INSERT INTO hebrew_morpho VALUES (92304,"עָנָה","v",NULL,"ANA","ענה","ענה",NULL,"&NH","&NH",NULL);
INSERT INTO hebrew_morpho VALUES (92305,"פְּרוּצָה","n",NULL,"PRUTSA","פרוצה","פרוצה",NULL,"PRWCH","PRWCH",NULL);
INSERT INTO hebrew_morpho VALUES (92306,"פְּתִילָה","n",NULL,"PTILA","פתילה","פתילה",NULL,"PTILH","PTILH",NULL);
INSERT INTO hebrew_morpho VALUES (92307,"פִּין","n",NULL,"PIN","פין","פין",NULL,"PIN","PIN",NULL);
INSERT INTO hebrew_morpho VALUES (92308,"פַּח","n",NULL,"PACH","פח","פח",NULL,"PX","PX",NULL);
INSERT INTO hebrew_morpho VALUES (92309,"צִחְצוּחַ","n",NULL,"TZICHTHU\'AH","צחצוח","צחצוח",NULL,"CXCWX","CXCWX",NULL);
INSERT INTO hebrew_morpho VALUES (92310,"צָנַח","v",NULL,"TZANACH","צנח","צנח",NULL,"CNX","CNX",NULL);
INSERT INTO hebrew_morpho VALUES (92311,"צֹר","n",NULL,"TSOR","צור","צר",NULL,"CR","CWR",NULL);
INSERT INTO hebrew_morpho VALUES (92312,"קַמְצָן","n",NULL,"KAMTZAN","קמצן","קמצן",NULL,"QMCN","QMCN",NULL);
INSERT INTO hebrew_morpho VALUES (92313,"קַרְדֹּם","n",NULL,"KARDOM","קרדום","קרדם",NULL,"QRDM","QRDWM",NULL);
INSERT INTO hebrew_morpho VALUES (92314,"הִתְקָרֵב","v",NULL,"HITKAREV","התקרב","התקרב",NULL,"HTQRB","HTQRB",NULL);
INSERT INTO hebrew_morpho VALUES (92315,"קֹדֶם-לָכֵן","r",NULL,"KODEM LAXEN","קודם-לכן","קדם-לכן",NULL,"QDM-LKN","QWDM-LKN",NULL);
INSERT INTO hebrew_morpho VALUES (92316,"אֵשׁ","n",NULL,NULL,"אש","אש",NULL,"A$","A$",NULL);
INSERT INTO hebrew_morpho VALUES (92317,"רָוָה","v",NULL,"RAVA","רווה","רוה",NULL,"RWH","RWWH",NULL);
INSERT INTO hebrew_morpho VALUES (92318,"רֵעוּת","n",NULL,"RE\'UT","רעות","רעות",NULL,"R&WT","R&WT",NULL);
INSERT INTO hebrew_morpho VALUES (92319,"רַבְגּוֹנִי","a",NULL,"RAVGONI","רבגוני","רבגוני",NULL,"RBGWNI","RBGWNI",NULL);
INSERT INTO hebrew_morpho VALUES (92320,"רַחֲמִים","n",NULL,"RACHAMIM","רחמים","רחמים",NULL,"RXMIM","RXMIM",NULL);
INSERT INTO hebrew_morpho VALUES (92321,"קְלָלָה","n",NULL,"KLALA","קללה","קללה",NULL,"QLLH","QLLH",NULL);
INSERT INTO hebrew_morpho VALUES (92322,"גִּדּוּף","n",NULL,"GIDUF","גידוף","גדוף",NULL,"GDWP","GIDWP",NULL);
INSERT INTO hebrew_morpho VALUES (92323,"שְׁפָכִים","n",NULL,"SHFACHIM","שפכים","שפכים",NULL,"$PKIM","$PKIM",NULL);
INSERT INTO hebrew_morpho VALUES (92324,"מֵי-שׁוֹפְכִין","n",NULL,"MEY-SHOFCHIN","מי-שופכין","מי-שופכין",NULL,"MI-$WPKIN","MI-$WPKIN",NULL);
INSERT INTO hebrew_morpho VALUES (92325,"הֶרְנְיָה","n",NULL,"HERNIA","הרניה","הרניה",NULL,"HRNIH","HRNIH",NULL);
INSERT INTO hebrew_morpho VALUES (92326,"שַׁחַת","n",NULL,"SHACHAT","שחת","שחת",NULL,"$XT","$XT",NULL);
INSERT INTO hebrew_morpho VALUES (92327,"שַׁיִט","n",NULL,"SHAYIT","שיט","שיט",NULL,"$I@","$I@",NULL);
INSERT INTO hebrew_morpho VALUES (92328,"שַׁיִשׁ","n",NULL,"SHAYISH","שיש","שיש",NULL,"$I$","$I$",NULL);
INSERT INTO hebrew_morpho VALUES (92329,"תּוֹלַעַת","n",NULL,"TOLA\'AT","תולעת","תולעת",NULL,"TWL&T","TWL&T",NULL);
INSERT INTO hebrew_morpho VALUES (92330,"שׁוֹאֵל","n",NULL,"SHO\'EL","שואל","שואל",NULL,"$WAL","$WAL",NULL);
INSERT INTO hebrew_morpho VALUES (92331,"שׁוֹפְכִין","n",NULL,"SHOFCHIN","שופכין","שופכין",NULL,"$WPKIN","$WPKIN",NULL);
INSERT INTO hebrew_morpho VALUES (92332,"שִׂמְלָה","n",NULL,"SIMLA","שמלה","שמלה",NULL,"$MLH","$MLH",NULL);
INSERT INTO hebrew_morpho VALUES (92333,"שֻׁמְשֹׁם","n",NULL,"SUMSUM","שומשום","שמשם",NULL,"$M$M","$WM$WM",NULL);
INSERT INTO hebrew_morpho VALUES (92334,"תְּבוּסָה","n",NULL,"TVUSA","תבוסה","תבוסה",NULL,"TBWSH","TBWSH",NULL);
INSERT INTO hebrew_morpho VALUES (92335,"יִבֵּב","v",NULL,"YIBEV","יבב","יבב",NULL,"IBB","IBB",NULL);
INSERT INTO hebrew_morpho VALUES (92336,"קְהִלָּה","n",NULL,"KEHILA","קהילה","קהלה",NULL,"QHLH","QHILH",NULL);
INSERT INTO hebrew_morpho VALUES (92337,"אַחֲרוֹן","a",NULL,"ACHARON","אחרון","אחרון",NULL,"AXRWN","AXRWN",NULL);
INSERT INTO hebrew_morpho VALUES (92338,"מִשְׁפָּחָה_גַּרְעִינִית","n",NULL,"MISCHPACHA GAR\'INIT","משפחה_גרעינית","משפחה_גרעינית",NULL,"M$PXH_GR&INIT","M$PXH_GR&INIT",NULL);
INSERT INTO hebrew_morpho VALUES (92339,"הַמִּשְׁפָּחָה_הַמֻּרְחֶבֶת","n",NULL,NULL,"המשפחה_המורחבת","המשפחה_המרחבת",NULL,"HM$PXH_HMRXBT","HM$PXH_HMWRXBT",NULL);
INSERT INTO hebrew_morpho VALUES (92340,"אֵם","n",NULL,"EM","אם","אם",NULL,"AM","AM",NULL);
INSERT INTO hebrew_morpho VALUES (92341,"מֶלוֹן_אַפְרִיקָנִי","n",NULL,NULL,"מלון_אפריקני","מלון_אפריקני",NULL,"MLWN_APRIQNI","MLWN_APRIQNI",NULL);
INSERT INTO hebrew_morpho VALUES (92342,"אֲגֻדָּה","n",NULL,NULL,"אגודה","אגדה",NULL,"AGDH","AGWDH",NULL);
INSERT INTO hebrew_morpho VALUES (92343,"אֱגוֹז","n",NULL,NULL,"אגוז","אגוז",NULL,"AGWZ","AGWZ",NULL);
INSERT INTO hebrew_morpho VALUES (92344,"צָבַר","v",NULL,"TZAVAR","צבר","צבר",NULL,"CBR","CBR",NULL);
INSERT INTO hebrew_morpho VALUES (92345,"אַגְרָה","n",NULL,NULL,"אגרה","אגרה",NULL,"AGRH","AGRH",NULL);
INSERT INTO hebrew_morpho VALUES (92346,"אָדֹם","a",NULL,NULL,"אדום","אדם",NULL,"ADM","ADWM",NULL);
INSERT INTO hebrew_morpho VALUES (92347,"שׁוֹנֶה","a",NULL,NULL,"שונה","שונה",NULL,"$WNH","$WNH",NULL);
INSERT INTO hebrew_morpho VALUES (92348,"צְרוֹר","n",NULL,NULL,"צרור","צרור",NULL,"CRWR","CRWR",NULL);
INSERT INTO hebrew_morpho VALUES (92349,"אָפֵל","a",NULL,NULL,"אפל","אפל",NULL,"APL","APL",NULL);
INSERT INTO hebrew_morpho VALUES (92350,"חָשׁוּךְ","a",NULL,NULL,"חשוך","חשוך",NULL,"X$WK","X$WK",NULL);
INSERT INTO hebrew_morpho VALUES (92351,"אַכְזָר","a",NULL,NULL,"אכזר","אכזר",NULL,"AKZR","AKZR",NULL);
INSERT INTO hebrew_morpho VALUES (92352,"רַב-עָצְמָה","a",NULL,"RAV OTZMA","רב_עוצמה","רב-עצמה",NULL,"RB-&CMH","RB_&WCMH",NULL);
INSERT INTO hebrew_morpho VALUES (92353,"עַז-נֶפֶשׁ","a",NULL,"AZ NEFESH","עז-נפש","עז-נפש",NULL,"&Z-NP$","&Z-NP$",NULL);
INSERT INTO hebrew_morpho VALUES (92354,"לְלֹא-חַת","a",NULL,"LELO CHAT","ללא_חת","ללא-חת",NULL,"LLA-XT","LLA_XT",NULL);
INSERT INTO hebrew_morpho VALUES (92355,"אָדוֹן","n",NULL,NULL,"אדון","אדון",NULL,"ADWN","ADWN",NULL);
INSERT INTO hebrew_morpho VALUES (92356,"אָטוּם","a",NULL,NULL,"אטום","אטום",NULL,"A@WM","A@WM",NULL);
INSERT INTO hebrew_morpho VALUES (92357,"אָהוּב","n",NULL,NULL,"אהוב","אהוב",NULL,"AHWB","AHWB",NULL);
INSERT INTO hebrew_morpho VALUES (92358,"אַפְסִי","a",NULL,"AFSI","אפסי","אפסי",NULL,"APSI","APSI",NULL);
INSERT INTO hebrew_morpho VALUES (92359,"חָבִיב","a",NULL,NULL,"חביב","חביב",NULL,"XBIB","XBIB",NULL);
INSERT INTO hebrew_morpho VALUES (92360,"כָּלוּא","a",NULL,"KALU","כלוא","כלוא",NULL,"KLWA","KLWA",NULL);
INSERT INTO hebrew_morpho VALUES (92361,"שִׂיאָן","n",NULL,"SI\'AN","שיאן","שיאן",NULL,"$IAN","$IAN","male");
INSERT INTO hebrew_morpho VALUES (92362,"אַבְהוּת","n",NULL,"AVHUT","אבהות","אבהות",NULL,"ABHWT","ABHWT",NULL);
INSERT INTO hebrew_morpho VALUES (92363,"וִיזָה","n",NULL,"VISA","ויזה","ויזה",NULL,"WIZH","WIZH",NULL);
INSERT INTO hebrew_morpho VALUES (92364,"רִגְשֵׁי_אָשָׁם","n",NULL,"RIGSHEI ASHMA","רגשי_אשמה","רגשי_אשם",NULL,"RG$I_A$M","RG$I_A$MH",NULL);
INSERT INTO hebrew_morpho VALUES (92365,"יִסּוּרֵי_מַצְפּוּן","n",NULL,"YISUREI MATZPUN","ייסורי_מצפון","יסורי_מצפון",NULL,"ISWRI_MCPWN","IISWRI_MCPWN",NULL);
INSERT INTO hebrew_morpho VALUES (92366,"מִיתוֹלוֹגִי","a",NULL,"MITOLOGI","מיתולוגי","מיתולוגי",NULL,"MITWLWGI","MITWLWGI",NULL);
INSERT INTO hebrew_morpho VALUES (92367,"פּוֹטַסְיוּם","n",NULL,"POTASIM","פוטסיום","פוטסיום",NULL,"PW@SIWM","PW@SIWM",NULL);
INSERT INTO hebrew_morpho VALUES (92368,"הֶלְיוּם","n",NULL,"HELYUM","הליום","הליום",NULL,"HLIWM","HLIWM",NULL);
INSERT INTO hebrew_morpho VALUES (92369,"אַלִּימוּת","n",NULL,"ALIMUT","אלימות","אלימות",NULL,"ALIMWT","ALIMWT",NULL);
INSERT INTO hebrew_morpho VALUES (92370,"אִרְגּוּן","n",NULL,NULL,"אירגון","ארגון",NULL,"ARGWN","AIRGWN",NULL);
INSERT INTO hebrew_morpho VALUES (92371,"אֵירוֹפֶּאִי","n",NULL,"eirope\'i","אירופאי","אירופאי",NULL,"AIRWPAI","AIRWPAI","male");
INSERT INTO hebrew_morpho VALUES (92372,"אֵירוֹפֶּאִי","a",NULL,NULL,"אירופאי","אירופאי",NULL,"AIRWPAI","AIRWPAI",NULL);
INSERT INTO hebrew_morpho VALUES (92373,"אֵזוֹב","n",NULL,NULL,"אזוב","אזוב",NULL,"AZWB","AZWB",NULL);
INSERT INTO hebrew_morpho VALUES (92374,"סְוֶדֶר","n",NULL,"SVEDER","סוודר","סודר",NULL,"SWDR","SWWDR",NULL);
INSERT INTO hebrew_morpho VALUES (92375,"אֲדִישׁוּת","n",NULL,"ADISHUT","אדישות","אדישות",NULL,"ADI$WT","ADI$WT",NULL);
INSERT INTO hebrew_morpho VALUES (92376,"דְּבֵקוּת","n",NULL,"DVEKUT","דבקות","דבקות",NULL,"DBQWT","DBQWT",NULL);
INSERT INTO hebrew_morpho VALUES (92377,"אֲדִיקוּת","n",NULL,"ADIKUT","אדיקות","אדיקות",NULL,"ADIQWT","ADIQWT",NULL);
INSERT INTO hebrew_morpho VALUES (92378,"אֻמְלָל","a",NULL,NULL,"אומלל","אמלל",NULL,"AMLL","AWMLL",NULL);
INSERT INTO hebrew_morpho VALUES (92379,"מְתֹעָב","a",NULL,"METO\'AV","מתועב","מתעב",NULL,"MT&B","MTW&B",NULL);
INSERT INTO hebrew_morpho VALUES (92380,"נִבְזֶה","a",NULL,"NIVZE","נבזה","נבזה",NULL,"NBZH","NBZH",NULL);
INSERT INTO hebrew_morpho VALUES (92381,"מֻמְצָא","a",NULL,"MUMTSA","מומצא","ממצא",NULL,"MMCA","MWMCA",NULL);
INSERT INTO hebrew_morpho VALUES (92382,"בָּקִיא","a",NULL,"BAKI","בקיא","בקיא",NULL,"BQIA","BQIA",NULL);
INSERT INTO hebrew_morpho VALUES (92383,"זִלְזֵל","v",NULL,"ZILZEL","זילזל","זלזל",NULL,"ZLZL","ZILZL",NULL);
INSERT INTO hebrew_morpho VALUES (92384,"נוֹרָא","a",NULL,"NORA","נורא","נורא",NULL,"NWRA","NWRA",NULL);
INSERT INTO hebrew_morpho VALUES (92385,"אַרְנֶבֶת","n",NULL,NULL,"ארנבת","ארנבת",NULL,"ARNBT","ARNBT",NULL);
INSERT INTO hebrew_morpho VALUES (92386,"נְמוּךְ-קוֹמָה","a",NULL,NULL,"נמוך-קומה","נמוך-קומה",NULL,"NMWK-QWMH","NMWK-QWMH",NULL);
INSERT INTO hebrew_morpho VALUES (92387,"גּוּץ","a",NULL,NULL,"גוץ","גוץ",NULL,"GWC","GWC",NULL);
INSERT INTO hebrew_morpho VALUES (92388,"ווּלְגָּרִי","a",NULL,"VULGARI","וולגרי","וולגרי",NULL,"WWLGRI","WWLGRI",NULL);
INSERT INTO hebrew_morpho VALUES (92389,"גַּס","a",NULL,"GASS","גס","גס",NULL,"GS","GS",NULL);
INSERT INTO hebrew_morpho VALUES (92390,"מְגֹרָשׁ","n",NULL,"MEGORASH","מגורש","מגרש",NULL,"MGR$","MGWR$",NULL);
INSERT INTO hebrew_morpho VALUES (92391,"תַּרְנְגוֹל","n",NULL,"TARNEGOL","תרנגול","תרנגול",NULL,"TRNGWL","TRNGWL",NULL);
INSERT INTO hebrew_morpho VALUES (92392,"אַרְכִיב","n",NULL,"ARCHIV","ארכיב","ארכיב",NULL,"ARKIB","ARKIB",NULL);
INSERT INTO hebrew_morpho VALUES (92393,"אַרְכִיּוֹן","n",NULL,"ARCHION","ארכיון","ארכיון",NULL,"ARKIWN","ARKIWN",NULL);
INSERT INTO hebrew_morpho VALUES (92394,"אַנְדַּרְטָה","n",NULL,"ANDARTA","אנדרטה","אנדרטה",NULL,"ANDR@H","ANDR@H",NULL);
INSERT INTO hebrew_morpho VALUES (92395,"מַצֵּבַת-זִכָּרוֹן","n",NULL,"MATZEVAT-ZIKARON","מצבת-זיכרון","מצבת-זכרון",NULL,"MCBT-ZKRWN","MCBT-ZIKRWN",NULL);
INSERT INTO hebrew_morpho VALUES (92396,"גְּלוּלָה-לִמְנִיעַת-הֵרָיוֹן","n",NULL,NULL,"גלולה-למניעת-היריון","גלולה-למניעת-הריון",NULL,"GLWLH-LMNI&T-HRIWN","GLWLH-LMNI&T-HIRIWN",NULL);
INSERT INTO hebrew_morpho VALUES (92397,"טַבְלִית","n",NULL,"TAVLIT","טבלית","טבלית",NULL,"@BLIT","@BLIT",NULL);
INSERT INTO hebrew_morpho VALUES (92398,"הֶרוֹאִיזְם","n",NULL,"HEROIZM","הרואיזם","הרואיזם",NULL,"HRWAIZM","HRWAIZM",NULL);
INSERT INTO hebrew_morpho VALUES (92399,"נְיוּאַנְס","n",NULL,NULL,"ניואנס","ניואנס",NULL,"NIWANS","NIWANS",NULL);
INSERT INTO hebrew_morpho VALUES (92400,"מָטָר","n",NULL,"MATAR","מטר","מטר",NULL,"M@R","M@R",NULL);
INSERT INTO hebrew_morpho VALUES (92401,"בַּחוּרָה","n",NULL,"BAHURA","בחורה","בחורה",NULL,"BXWRH","BXWRH",NULL);
INSERT INTO hebrew_morpho VALUES (92402,"הִשְׁתּוֹקְקוּת","n",NULL,"HISHTOKEKUT","השתוקקות","השתוקקות",NULL,"H$TWQQWT","H$TWQQWT",NULL);
INSERT INTO hebrew_morpho VALUES (92403,"כִּסּוּפִים","n",NULL,"KISUFIM","כיסופים","כסופים",NULL,"KSWPIM","KISWPIM",NULL);
INSERT INTO hebrew_morpho VALUES (92404,"שָׂפָה","n",NULL,"SAFA","שפה","שפה",NULL,"$PH","$PH",NULL);
INSERT INTO hebrew_morpho VALUES (92405,"גְּבוּלִי","a",NULL,"GVULI","גבולי","גבולי",NULL,"GBWLI","GBWLI",NULL);
INSERT INTO hebrew_morpho VALUES (92406,"גִּנּוּי","n",NULL,"GINUY","גינוי","גנוי",NULL,"GNWI","GINWI",NULL);
INSERT INTO hebrew_morpho VALUES (92407,"סִדּוּר","n",NULL,"SIDUR","סידור","סדור",NULL,"SDWR","SIDWR",NULL);
INSERT INTO hebrew_morpho VALUES (92408,"אֲרוֹן-מֵתִים","n",NULL,"ARON-METIM","ארון-מתים","ארון-מתים",NULL,"ARWN-MTIM","ARWN-MTIM",NULL);
INSERT INTO hebrew_morpho VALUES (92409,"גִּדֵּל","v",NULL,"GIDEL","גידל","גדל",NULL,"GDL","GIDL",NULL);
INSERT INTO hebrew_morpho VALUES (92410,"מוֹשִׁיעַ","n",NULL,"MOSHI\'A","מושיע","מושיע",NULL,"MW$I&","MW$I&",NULL);
INSERT INTO hebrew_morpho VALUES (92411,"גֶּפֶן","n",NULL,"GEFEN","גפן","גפן",NULL,"GPN","GPN",NULL);
INSERT INTO hebrew_morpho VALUES (92412,"בּוּם","n",NULL,"BOOM","בום","בום",NULL,"BWM","BWM",NULL);
INSERT INTO hebrew_morpho VALUES (92413,"קוֹנְדּוֹם","n",NULL,"KONDOM","קונדום","קונדום",NULL,"QWNDWM","QWNDWM",NULL);
INSERT INTO hebrew_morpho VALUES (92414,"כּוֹבָעוֹן","n",NULL,"KOVA\'ON","כובעון","כובעון",NULL,"KWB&WN","KWB&WN",NULL);
INSERT INTO hebrew_morpho VALUES (92415,"יְתֵרָה-מִזּוֹ","r",NULL,"YETERA-MIZO","יתרה-מזו","יתרה-מזו",NULL,"ITRH-MZW","ITRH-MZW",NULL);
INSERT INTO hebrew_morpho VALUES (92416,"בְּגָּלוּי","r",NULL,"BEGALUY","בגלוי","בגלוי",NULL,"BGLWI","BGLWI",NULL);
INSERT INTO hebrew_morpho VALUES (92417,"בּוּר","n",NULL,"BUR","בור","בור",NULL,"BWR","BWR",NULL);
INSERT INTO hebrew_morpho VALUES (92418,"בְּכוֹר","n",NULL,"BECHOR","בכור","בכור",NULL,"BKWR","BKWR",NULL);
INSERT INTO hebrew_morpho VALUES (92419,"אָחִיד","a",NULL,"ACHID","אחיד","אחיד",NULL,"AXID","AXID",NULL);
INSERT INTO hebrew_morpho VALUES (92420,"גָּבַר","v",NULL,"GAVAR","גבר","גבר",NULL,"GBR","GBR",NULL);
INSERT INTO hebrew_morpho VALUES (92421,"אֶקְסְקְלוּסִיבִי","a",NULL,"EXCLUSIVI","אקסקלוסיבי","אקסקלוסיבי",NULL,"AQSQLWSIBI","AQSQLWSIBI",NULL);
INSERT INTO hebrew_morpho VALUES (92422,"בִּלְעָדִי","a",NULL,"BIL\'ADI","בלעדי","בלעדי",NULL,"BL&DI","BL&DI",NULL);
INSERT INTO hebrew_morpho VALUES (92423,"אֵיבָר","n",NULL,"EIVAR","איבר","איבר",NULL,"AIBR","AIBR",NULL);
INSERT INTO hebrew_morpho VALUES (92424,"פְּרֶמְיֶרָה","n",NULL,"PREMYERA","פרמיירה","פרמירה",NULL,"PRMIRH","PRMIIRH",NULL);
INSERT INTO hebrew_morpho VALUES (92425,"הַצָּגַת-בְּכוֹרָה","n",NULL,"HATZAGAT-BECHORA","הצגת-בכורה","הצגת-בכורה",NULL,"HCGT-BKWRH","HCGT-BKWRH",NULL);
INSERT INTO hebrew_morpho VALUES (92426,"חָשַׂף","v",NULL,"CHASAF","חשף","חשף",NULL,"X$P","X$P",NULL);
INSERT INTO hebrew_morpho VALUES (92427,"שִׁנָּה","v",NULL,"SHINA","שינה","שנה",NULL,"$NH","$INH",NULL);
INSERT INTO hebrew_morpho VALUES (92428,"גָּחוֹן","n",NULL,"GACHON","גחון","גחון",NULL,"GXWN","GXWN",NULL);
INSERT INTO hebrew_morpho VALUES (92429,"כֶּרֶס","n",NULL,"KERES","כרס","כרס",NULL,"KRS","KRS",NULL);
INSERT INTO hebrew_morpho VALUES (92430,"רֶשַׁע","n",NULL,"RESHA","רשע","רשע",NULL,"R$&","R$&",NULL);
INSERT INTO hebrew_morpho VALUES (92431,"דִּיאַגְנוֹזָה","n",NULL,"DIAGNOZA","דיאגנוזה","דיאגנוזה",NULL,"DIAGNWZH","DIAGNWZH",NULL);
INSERT INTO hebrew_morpho VALUES (92432,"ווֹלוּנְטָרִי","a",NULL,"VOLUNTARY","וולונטרי","וולונטרי",NULL,"WWLWN@RI","WWLWN@RI",NULL);
INSERT INTO hebrew_morpho VALUES (92433,"הַפָּלָה","n",NULL,"HAPALA","הפלה","הפלה",NULL,"HPLH","HPLH",NULL);
INSERT INTO hebrew_morpho VALUES (92434,"פְּקִידָה","n",NULL,"PKIDA","פקידה","פקידה",NULL,"PQIDH","PQIDH",NULL);
INSERT INTO hebrew_morpho VALUES (92435,"מִפְגָּשׁ","n",NULL,"MIFGASH","מפגש","מפגש",NULL,"MPG$","MPG$",NULL);
INSERT INTO hebrew_morpho VALUES (92436,"מַרְיוֹנֶטָה","n",NULL,"MARIONETA","מריונטה","מריונטה",NULL,"MRIWN@H","MRIWN@H",NULL);
INSERT INTO hebrew_morpho VALUES (92437,"נִיחוֹחַ","n",NULL,"NICHO\'ACH","ניחוח","ניחוח",NULL,"NIXWX","NIXWX",NULL);
INSERT INTO hebrew_morpho VALUES (92438,"בִּיב","n",NULL,"BIV","ביב","ביב",NULL,"BIB","BIB",NULL);
INSERT INTO hebrew_morpho VALUES (92439,"הִתְבּוֹדְדוּת","n",NULL,"HITBODEDUT","התבודדות","התבודדות",NULL,"HTBWDDWT","HTBWDDWT",NULL);
INSERT INTO hebrew_morpho VALUES (92440,"גַּלְמוּדִיּוּת","n",NULL,"GALMUDIYUT","גלמודיות","גלמודיות",NULL,"GLMWDIWT","GLMWDIWT",NULL);
INSERT INTO hebrew_morpho VALUES (92441,"בְּתוּלִין","n",NULL,"BETULIN","בתולין","בתולין",NULL,"BTWLIN","BTWLIN",NULL);
INSERT INTO hebrew_morpho VALUES (92442,"קְרוּם-הַבְּתוּלִים","n",NULL,"KRUM HABETULIM","קרום-הבתולים","קרום-הבתולים",NULL,"QRWM-HBTWLIM","QRWM-HBTWLIM",NULL);
INSERT INTO hebrew_morpho VALUES (92443,"מֻמְחִיּוּת","n",NULL,"MUMCHIYUT","מומחיות","ממחיות",NULL,"MMXIWT","MWMXIWT",NULL);
INSERT INTO hebrew_morpho VALUES (92444,"חוֹקֵר-פְּרָטִי","n",NULL,"CHOKER PRATI","חוקר-פרטי","חוקר-פרטי",NULL,"XWQR-PR@I","XWQR-PR@I",NULL);
INSERT INTO hebrew_morpho VALUES (92445,"בַּעֲרוּת","n",NULL,"BA\'ARUT","בערות","בערות",NULL,"B&RWT","B&RWT",NULL);
INSERT INTO hebrew_morpho VALUES (92446,"זִילוּת","n",NULL,"ZILUT","זילות","זילות",NULL,"ZILWT","ZILWT",NULL);
INSERT INTO hebrew_morpho VALUES (92447,"קְבָס","n",NULL,"KEVAS","קבס","קבס",NULL,"QBS","QBS",NULL);
INSERT INTO hebrew_morpho VALUES (92448,"עִיר-בִּירָה","n",NULL,"IR-BIRA","עיר-בירה","עיר-בירה",NULL,"&IR-BIRH","&IR-BIRH",NULL);
INSERT INTO hebrew_morpho VALUES (92449,"גַּיְא","n",NULL,"GAI","גיא","גיא",NULL,"GIA","GIA",NULL);
INSERT INTO hebrew_morpho VALUES (92450,"עַצְלָן","n",NULL,"ATZLAN","עצלן","עצלן",NULL,"&CLN","&CLN",NULL);
INSERT INTO hebrew_morpho VALUES (92451,"עָצֵל","n",NULL,"ATZEL","עצל","עצל",NULL,"&CL","&CL",NULL);
INSERT INTO hebrew_morpho VALUES (92452,"הוֹלֵךְ-בָּטֵל","n",NULL,"HOLECH-BATEL","הולך-בטל","הולך-בטל",NULL,"HWLK-B@L","HWLK-B@L",NULL);
INSERT INTO hebrew_morpho VALUES (92453,"מַצְבִּיעַ","n",NULL,"MATZBI\'A","מצביע","מצביע",NULL,"MCBI&","MCBI&",NULL);
INSERT INTO hebrew_morpho VALUES (92454,"פּוּטְשׁ","n",NULL,"POOCH","פוטש","פוטש",NULL,"PW@$","PW@$",NULL);
INSERT INTO hebrew_morpho VALUES (92455,"הֲפִיכָה","n",NULL,"HAFICHA","הפיכה","הפיכה",NULL,"HPIKH","HPIKH",NULL);
INSERT INTO hebrew_morpho VALUES (92456,"חִלּוּט","n",NULL,"CHILUT","חילוט","חלוט",NULL,"XLW@","XILW@",NULL);
INSERT INTO hebrew_morpho VALUES (92457,"חִזּוּק","n",NULL,"CHIZUK","חיזוק","חזוק",NULL,"XZWQ","XIZWQ",NULL);
INSERT INTO hebrew_morpho VALUES (92458,"עֲצִירַת-גְּשָׁמִים","n",NULL,"ATSIRAT GSHAMIM","עצירת-גשמים","עצירת-גשמים",NULL,"&CIRT-G$MIM","&CIRT-G$MIM",NULL);
INSERT INTO hebrew_morpho VALUES (92459,"פְּחָת","n",NULL,"PCHAT","פחת","פחת",NULL,"PXT","PXT",NULL);
INSERT INTO hebrew_morpho VALUES (92460,"הַתְחָלָה","n",NULL,"HATCHALA","התחלה","התחלה",NULL,"HTXLH","HTXLH",NULL);
INSERT INTO hebrew_morpho VALUES (92461,"רֵאשִׁית","n",NULL,"RESHIT","ראשית","ראשית",NULL,"RA$IT","RA$IT",NULL);
INSERT INTO hebrew_morpho VALUES (92462,"הִתְאַגְּדוּת","n",NULL,"HITAGDUT","התאגדות","התאגדות",NULL,"HTAGDWT","HTAGDWT",NULL);
INSERT INTO hebrew_morpho VALUES (92463,"בְּכַוָּנָה","r",NULL,"BECHAVANA","בכוונה","בכונה",NULL,"BKWNH","BKWWNH",NULL);
INSERT INTO hebrew_morpho VALUES (92464,"בְּמַחְשָׁבָה-תְּחִלָּה","r",NULL,"BEMACHSHAVA TCHILA","במחשבה-תחילה","במחשבה-תחלה",NULL,"BMX$BH-TXLH","BMX$BH-TXILH",NULL);
INSERT INTO hebrew_morpho VALUES (92465,"בּוֹזְמַנִּית","r",NULL,"BOZMANIT","בוזמנית","בוזמנית",NULL,"BWZMNIT","BWZMNIT",NULL);
INSERT INTO hebrew_morpho VALUES (92466,"בְּמַקְבִּיל","r",NULL,"BEMAKBIL","במקביל","במקביל",NULL,"BMQBIL","BMQBIL",NULL);
INSERT INTO hebrew_morpho VALUES (92467,"בָּהּ-בָּעֵת","r",NULL,"BA BA\'ET","בה-בעת","בה-בעת",NULL,"BH-B&T","BH-B&T",NULL);
INSERT INTO hebrew_morpho VALUES (92468,"בַּד-בְּבַד","r",NULL," BAD BEVAD","בד-בבד","בד-בבד",NULL,"BD-BBD","BD-BBD",NULL);
INSERT INTO hebrew_morpho VALUES (92469,"מְסִירָה","n",NULL,"MESIRA","מסירה","מסירה",NULL,"MSIRH","MSIRH",NULL);
INSERT INTO hebrew_morpho VALUES (92470,"עִרְבֵּב","v",NULL,"IRBEV","ערבב","ערבב",NULL,"&RBB","&RBB",NULL);
INSERT INTO hebrew_morpho VALUES (92471,"פָּחוֹת-אוֹ-יוֹתֵר","r",NULL,"PACHOT O YOTER","פחות-או-יותר","פחות-או-יותר",NULL,"PXWT-AW-IWTR","PXWT-AW-IWTR",NULL);
INSERT INTO hebrew_morpho VALUES (92472,"מֵאָה-אָחוּז","r",NULL,"ME\'AH ACHUZ","מאה-אחוז","מאה-אחוז",NULL,"MAH-AXWZ","MAH-AXWZ",NULL);
INSERT INTO hebrew_morpho VALUES (92473,"עַל-פֶּה","r",NULL,"AL-PEH","על-פה","על-פה",NULL,"&L-PH","&L-PH",NULL);
INSERT INTO hebrew_morpho VALUES (92474,"מְחִיר","n",NULL,"MECHIR","מחיר","מחיר",NULL,"MXIR","MXIR",NULL);
INSERT INTO hebrew_morpho VALUES (92475,"הוֹצָאַת-סְפָרִים","n",NULL,"HOTZA\'AT-SFARIM","הוצאת-ספרים","הוצאת-ספרים",NULL,"HWCAT-SPRIM","HWCAT-SPRIM",NULL);
INSERT INTO hebrew_morpho VALUES (92476,"בֵּית-הוֹצָאָה","n",NULL,"BEIT-HOTZA\'AH","בית-הוצאה","בית-הוצאה",NULL,"BIT-HWCAH","BIT-HWCAH",NULL);
INSERT INTO hebrew_morpho VALUES (92477,"פְּסִיקַת-הוֹצָאוֹת","n",NULL,"PSIKAT-HOTZA\'OT","פסיקת-הוצאות","פסיקת-הוצאות",NULL,"PSIQT-HWCAWT","PSIQT-HWCAWT",NULL);
INSERT INTO hebrew_morpho VALUES (92478,"הַפְרָזָה","n",NULL,"HAFRAZA","הפרזה","הפרזה",NULL,"HPRZH","HPRZH",NULL);
INSERT INTO hebrew_morpho VALUES (92479,"אִינְטֶנְסִיפִיקַצְיָה","n",NULL,"INTENSIFIKATZYA","אינטנסיפיקציה","אינטנסיפיקציה",NULL,"AIN@NSIPIQCIH","AIN@NSIPIQCIH",NULL);
INSERT INTO hebrew_morpho VALUES (92480,"הַעֲצָמָה","n",NULL,"HA\'ATZAMA","העצמה","העצמה",NULL,"H&CMH","H&CMH",NULL);
INSERT INTO hebrew_morpho VALUES (92481,"עִרְבּוּב","n",NULL,"IRBUV","ערבוב","ערבוב",NULL,"&RBWB","&RBWB",NULL);
INSERT INTO hebrew_morpho VALUES (92482,"הִתְרַחֲבוּת","n",NULL,"HITRACHAVUT","התרחבות","התרחבות",NULL,"HTRXBWT","HTRXBWT",NULL);
INSERT INTO hebrew_morpho VALUES (92483,"בְּזַעַם","r",NULL,"BEZA\'AM","בזעם","בזעם",NULL,"BZ&M","BZ&M",NULL);
INSERT INTO hebrew_morpho VALUES (92484,"מַחְזוֹר","n",NULL,"machzor","מחזור","מחזור",NULL,"MXZWR","MXZWR",NULL);
INSERT INTO hebrew_morpho VALUES (92485,"מַחְזוֹר-חָדְשִׁי","n",NULL,"MACHZOR CHODSHI","מחזור-חודשי","מחזור-חדשי",NULL,"MXZWR-XD$I","MXZWR-XWD$I",NULL);
INSERT INTO hebrew_morpho VALUES (92486,"הֲגִירָה-יוֹצֵאת","n",NULL,"HAGIRA-YOTZET","הגירה-יוצאת","הגירה-יוצאת",NULL,"HGIRH-IWCAT","HGIRH-IWCAT",NULL);
INSERT INTO hebrew_morpho VALUES (92487,"מִטְרָד","n",NULL,"MITRAD","מטרד","מטרד",NULL,"M@RD","M@RD",NULL);
INSERT INTO hebrew_morpho VALUES (92488,"כְּאֵב-רֹאשׁ","n",NULL,"KE\'EV-ROSH","כאב-ראש","כאב-ראש",NULL,"KAB-RA$","KAB-RA$",NULL);
INSERT INTO hebrew_morpho VALUES (92489,"קוֹץ-בַּתַּחַת","n",NULL,"KOTZ-BATACHAT","קוץ-בתחת","קוץ-בתחת",NULL,"QWC-BTXT","QWC-BTXT",NULL);
INSERT INTO hebrew_morpho VALUES (92490,"פְלִרְטוּט","n",NULL,"FLIRTUT","פלירטוט","פלרטוט",NULL,"PLR@W@","PLIR@W@",NULL);
INSERT INTO hebrew_morpho VALUES (92491,"אֲהַבְהָבִים","n",NULL,"AHAVHAVIM","אהבהבים","אהבהבים",NULL,"AHBHBIM","AHBHBIM",NULL);
INSERT INTO hebrew_morpho VALUES (92492,"תַּרְכִּיב","n",NULL,"TARKIV","תרכיב","תרכיב",NULL,"TRKIB","TRKIB",NULL);
INSERT INTO hebrew_morpho VALUES (92493,"חִסּוּן","n",NULL,"CHISUN","חיסון","חסון",NULL,"XSWN","XISWN",NULL);
INSERT INTO hebrew_morpho VALUES (92494,"הֲגָנָה-עַצְמִית","n",NULL,"HAGANA-ATZMIT","הגנה-עצמית","הגנה-עצמית",NULL,"HGNH-&CMIT","HGNH-&CMIT",NULL);
INSERT INTO hebrew_morpho VALUES (92495,"שׁוּמָה","n",NULL,"SHUMA","שומה","שומה",NULL,"$WMH","$WMH",NULL);
INSERT INTO hebrew_morpho VALUES (92496,"דְּרָמָטִיזַצְיָה","n",NULL,"DRAMATIZATZYA","דרמטיזציה","דרמטיזציה",NULL,"DRM@IZCIH","DRM@IZCIH",NULL);
INSERT INTO hebrew_morpho VALUES (92497,"גֵּאוֹמֶטְרְיָה","n",NULL,"GE\'OMETRIYA","גיאומטריה","גאומטריה",NULL,"GAWM@RIH","GIAWM@RIH",NULL);
INSERT INTO hebrew_morpho VALUES (92498,"פִּגּוּר","n",NULL,"PIGUR","פיגור","פגור",NULL,"PGWR","PIGWR",NULL);
INSERT INTO hebrew_morpho VALUES (92499,"הֲלִיכִים-מִשְׁפָּטִיִּים","n",NULL,"HALICHIM-MISHPATI\'IM","הליכים-משפטיים","הליכים-משפטיים",NULL,"HLIKIM-M$P@IIM","HLIKIM-M$P@IIM",NULL);
INSERT INTO hebrew_morpho VALUES (92500,"מִלָּה-שְׁאוּלָה","n",NULL,"MILA-SHE\'ULA","מילה-שאולה","מלה-שאולה",NULL,"MLH-$AWLH","MILH-$AWLH",NULL);
INSERT INTO hebrew_morpho VALUES (92501,"נְקֻדַּת-מַבָּט","n",NULL,"NEKUDAT MABAT","נקודת-מבט","נקדת-מבט",NULL,"NQDT-MB@","NQWDT-MB@",NULL);
INSERT INTO hebrew_morpho VALUES (92502,"הִשְׁלִים","v",NULL,"HISHLIM","השלים","השלים",NULL,"H$LIM","H$LIM",NULL);
INSERT INTO hebrew_morpho VALUES (92503,"טֶנְטָטִיבִי","a",NULL,"TENTATIVI","טנטטיבי","טנטטיבי",NULL,"@N@@IBI","@N@@IBI",NULL);
INSERT INTO hebrew_morpho VALUES (92504,"לֹא-קָבוּעַ","a",NULL,NULL,"לא-קבוע","לא-קבוע",NULL,"LA-QBW&","LA-QBW&",NULL);
INSERT INTO hebrew_morpho VALUES (92505,"מִלְּבַד-זֹאת","r",NULL,"MILVAD-ZOT","מלבד-זאת","מלבד-זאת",NULL,"MLBD-ZAT","MLBD-ZAT",NULL);
INSERT INTO hebrew_morpho VALUES (92506,"הִצְחִין","v",NULL,"HITZCHIN","הצחין","הצחין",NULL,"HCXIN","HCXIN",NULL);
INSERT INTO hebrew_morpho VALUES (92507,"זְכוּת-יֶתֶר","n",NULL,"ZCHUT YETER","זכות-יתר","זכות-יתר",NULL,"ZKWT-ITR","ZKWT-ITR",NULL);
INSERT INTO hebrew_morpho VALUES (92508,"פְּרִיבִילֶגְיָה","n",NULL,"PRIVILEGIA","פריבילגיה","פריבילגיה",NULL,"PRIBILGIH","PRIBILGIH",NULL);
INSERT INTO hebrew_morpho VALUES (92509,"רִצֵּד","v",NULL,"RITZED","ריצד","רצד",NULL,"RCD","RICD",NULL);
INSERT INTO hebrew_morpho VALUES (92510,"רָטַט","v",NULL,"RATAT","רטט","רטט",NULL,"R@@","R@@",NULL);
INSERT INTO hebrew_morpho VALUES (92511,"הֵשִׁיב-בְּחִיּוּב","v",NULL,"HESHIV-BECHI\'YUV","השיב-בחיוב","השיב-בחיוב",NULL,"H$IB-BXIWB","H$IB-BXIWB",NULL);
INSERT INTO hebrew_morpho VALUES (92512,"חָדַל","v",NULL,"CHADAL","חדל","חדל",NULL,"XDL","XDL",NULL);
INSERT INTO hebrew_morpho VALUES (92513,"תָּא-זֶרַע","n",NULL,"TA ZERA","תא-זרע","תא-זרע",NULL,"TA-ZR&","TA-ZR&",NULL);
INSERT INTO hebrew_morpho VALUES (92514,"הֵחֵל","v",NULL,"HECHEL","החל","החל",NULL,"HXL","HXL",NULL);
INSERT INTO hebrew_morpho VALUES (92515,"נִפֵּחַ","v",NULL,"NIPE\'ACH","ניפח","נפח",NULL,"NPX","NIPX",NULL);
INSERT INTO hebrew_morpho VALUES (92516,"הִפְרִיז","v",NULL,"HIFRIZ","הפריז","הפריז",NULL,"HPRIZ","HPRIZ",NULL);
INSERT INTO hebrew_morpho VALUES (92517,"נִשֵּׁל","v",NULL,"NISHEL","נישל","נשל",NULL,"N$L","NI$L",NULL);
INSERT INTO hebrew_morpho VALUES (92518,"הֵטִיל-מַיִם","v",NULL,"HETIL-MAYIM","הטיל-מים","הטיל-מים",NULL,"H@IL-MIM","H@IL-MIM",NULL);
INSERT INTO hebrew_morpho VALUES (92519,"עָשָׂה-פִּיפִּי","v",NULL,"ASA-PIPI","עשה-פיפי","עשה-פיפי",NULL,"&$H-PIPI","&$H-PIPI",NULL);
INSERT INTO hebrew_morpho VALUES (92520,"יִבֵּשׁ","v",NULL,"YIBESH","ייבש","יבש",NULL,"IB$","IIB$",NULL);
INSERT INTO hebrew_morpho VALUES (92521,"אֶמְבַּרְגּוֹ","n",NULL,"EMBARGO","אמברגו","אמברגו",NULL,"AMBRGW","AMBRGW",NULL);
INSERT INTO hebrew_morpho VALUES (92522,"הִתְנַדְּפוּת","n",NULL,"HITNADFUT","התנדפות","התנדפות",NULL,"HTNDPWT","HTNDPWT",NULL);
INSERT INTO hebrew_morpho VALUES (92523,"שִׁדָּה","n",NULL,"SHIDA","שידה","שדה",NULL,"$DH","$IDH",NULL);
INSERT INTO hebrew_morpho VALUES (92524,"דְּהַיְנוּ","r",NULL,"DEHAYNU","דהיינו","דהינו",NULL,"DHINW","DHIINW",NULL);
INSERT INTO hebrew_morpho VALUES (92525,"תֵּבָה","n",NULL,"TEIVA","תיבה","תבה",NULL,"TBH","TIBH",NULL);
INSERT INTO hebrew_morpho VALUES (92526,"כְּלוֹמַר","r",NULL,"KELOMAR","כלומר","כלומר",NULL,"KLWMR","KLWMR",NULL);
INSERT INTO hebrew_morpho VALUES (92527,"צָחַק","v",NULL,"TZACHAK","צחק","צחק",NULL,"CXQ","CXQ",NULL);
INSERT INTO hebrew_morpho VALUES (92528,"פוֹנֶמָה","n",NULL,"FONEMA","פונמה","פונמה",NULL,"PWNMH","PWNMH",NULL);
INSERT INTO hebrew_morpho VALUES (92529,"תִּקְצֵב","v",NULL,"TIKTZEV","תיקצב","תקצב",NULL,"TQCB","TIQCB",NULL);
INSERT INTO hebrew_morpho VALUES (92530,"מָתַח-בִּקֹּרֶת","v",NULL,"MATACH-BIKORET","מתח-ביקורת","מתח-בקרת",NULL,"MTX-BQRT","MTX-BIQWRT",NULL);
INSERT INTO hebrew_morpho VALUES (92531,"הִמְתִּיק","v",NULL,"HIMTIK","המתיק","המתיק",NULL,"HMTIQ","HMTIQ",NULL);
INSERT INTO hebrew_morpho VALUES (92532,"עֲטִישָׁה","n",NULL,"ATISHA","עטישה","עטישה",NULL,"&@I$H","&@I$H",NULL);
INSERT INTO hebrew_morpho VALUES (92533,"עִטּוּשׁ","n",NULL,"ITUSH","עיטוש","עטוש",NULL,"&@W$","&I@W$",NULL);
INSERT INTO hebrew_morpho VALUES (92534,"הַמְלָכָה","n",NULL,"HAMLACHA","המלכה","המלכה",NULL,"HMLKH","HMLKH",NULL);
INSERT INTO hebrew_morpho VALUES (92535,"יַצְאָנִית","n",NULL,"YATS\'ANIT","יצאנית","יצאנית",NULL,"ICANIT","ICANIT",NULL);
INSERT INTO hebrew_morpho VALUES (92536,"חַיָּה","n",NULL,"CHAYA","חיה","חיה",NULL,"XIH","XIH",NULL);
INSERT INTO hebrew_morpho VALUES (92537,"שׁוֹפֵעַ-חַיִּים","a",NULL,"SHOFE\'A-CHAIM","שופע-חיים","שופע-חיים",NULL,"$WP&-XIIM","$WP&-XIIM",NULL);
INSERT INTO hebrew_morpho VALUES (92538,"לוֹוֶה","n",NULL,"LOVEH","לווה","לווה",NULL,"LWWH","LWWH",NULL);
INSERT INTO hebrew_morpho VALUES (92539,"מְצֻוֶּה","a",NULL,"METSUVEH","מצווה","מצוה",NULL,"MCWH","MCWWH",NULL);
INSERT INTO hebrew_morpho VALUES (92540,"בְּחָפְשִׁיּוּת","r",NULL,"BECHOFSHIYUT","בחופשיות","בחפשיות",NULL,"BXP$IWT","BXWP$IWT",NULL);
INSERT INTO hebrew_morpho VALUES (92541,"חִנָּם","a",NULL,"CHINAM","חינם","חנם",NULL,"XNM","XINM",NULL);
INSERT INTO hebrew_morpho VALUES (92542,"בַּהֲמִי","a",NULL,"BEHAMI","בהמי","בהמי",NULL,"BHMI","BHMI",NULL);
INSERT INTO hebrew_morpho VALUES (92543,"בְּהֵמִי","a",NULL,"BEHEMI","בהמי","בהמי",NULL,"BHMI","BHMI",NULL);
INSERT INTO hebrew_morpho VALUES (92544,"לִימוֹנִי","a",NULL,"LIMONI","לימוני","לימוני",NULL,"LIMWNI","LIMWNI",NULL);
INSERT INTO hebrew_morpho VALUES (92545,"שְׂחִיַּת-חֲתִירָה","n",NULL,"SCHIYAT CHATIRA","שחיית-חתירה","שחית-חתירה",NULL,"$XIT-XTIRH","$XIIT-XTIRH",NULL);
INSERT INTO hebrew_morpho VALUES (92546,"חֲרִישָׁה","n",NULL,"CHARISHA","חרישה","חרישה",NULL,"XRI$H","XRI$H",NULL);
INSERT INTO hebrew_morpho VALUES (92547,"הִגּוּי","n",NULL,"HIGUY","היגוי","הגוי",NULL,"HGWI","HIGWI",NULL);
INSERT INTO hebrew_morpho VALUES (92548,"נִפְגָּע","n",NULL,"NIFGA","נפגע","נפגע",NULL,"NPG&","NPG&",NULL);
INSERT INTO hebrew_morpho VALUES (92549,"סְפִינַת-חָלָל","n",NULL,"SFINAT CHALAL","ספינת-חלל","ספינת-חלל",NULL,"SPINT-XLL","SPINT-XLL",NULL);
INSERT INTO hebrew_morpho VALUES (92550,"מוֹנוֹטוֹנִיּוּת","n",NULL,"MONOTONIYUT","מונוטוניות","מונוטוניות",NULL,"MWNW@WNIWT","MWNW@WNIWT",NULL);
INSERT INTO hebrew_morpho VALUES (92551,"אָרִיתְמֶטִיקָה","n",NULL,"ARITMETICA","אריתמטיקה","אריתמטיקה",NULL,"ARITM@IQH","ARITM@IQH",NULL);
INSERT INTO hebrew_morpho VALUES (92552,"אִלְחֵשׁ","v",NULL,"ILCHESH","אילחש","אלחש",NULL,"ALX$","AILX$",NULL);
INSERT INTO hebrew_morpho VALUES (92553,"אַנְסַמְבְּל","n",NULL,"ANSAMBEL","אנסמבל","אנסמבל",NULL,"ANSMBL","ANSMBL",NULL);
INSERT INTO hebrew_morpho VALUES (92554,"סֶת","n",NULL,"SET","סת","סת",NULL,"ST","ST",NULL);
INSERT INTO hebrew_morpho VALUES (92555,"כּוֹחַ-הַמְּשִׁיכָה","n",NULL,"KO\'ACH HAMESCHICHA","כוח-המשיכה","כוח-המשיכה",NULL,"KWX-HM$IKH","KWX-HM$IKH",NULL);
INSERT INTO hebrew_morpho VALUES (92556,"גְּרָבִיטַצְיָה","n",NULL,"GRAVITATSIA","גרביטציה","גרביטציה",NULL,"GRBI@CIH","GRBI@CIH",NULL);
INSERT INTO hebrew_morpho VALUES (92557,"חַיִּים","n",NULL,"CHAYIM","חיים","חיים",NULL,"XIIM","XIIM",NULL);
INSERT INTO hebrew_morpho VALUES (92558,"מוּמְיָה","n",NULL,"MUMYA","מומיה","מומיה",NULL,"MWMIH","MWMIH",NULL);
INSERT INTO hebrew_morpho VALUES (92559,"חָזַר-לְסוּרוֹ","v",NULL,"CHAZAR-LESURO","חזר-לסורו","חזר-לסורו",NULL,"XZR-LSWRW","XZR-LSWRW",NULL);
INSERT INTO hebrew_morpho VALUES (92560,"תַּבְרִיג","n",NULL,"TAVRIG","תבריג","תבריג",NULL,"TBRIG","TBRIG",NULL);
INSERT INTO hebrew_morpho VALUES (92561,"הָלוּצִינַצְיָה","n",NULL,"HALUTZINATZYA","הלוצינציה","הלוצינציה",NULL,"HLWCINCIH","HLWCINCIH",NULL);
INSERT INTO hebrew_morpho VALUES (92562,"הִנִּיחַ","v",NULL,"HENI\'ACH","הניח","הניח",NULL,"HNIX","HNIX",NULL);
INSERT INTO hebrew_morpho VALUES (92563,"חִוָּה-דֵּעָה","v",NULL,"CHIVA DE\'AH","חיווה-דעה","חוה-דעה",NULL,"XWH-D&H","XIWWH-D&H",NULL);
INSERT INTO hebrew_morpho VALUES (92564,"הִפְחִית_","v",NULL,"HIFCHIT","הפחית","הפחית_",NULL,"HPXIT_","HPXIT",NULL);
INSERT INTO hebrew_morpho VALUES (92565,"הֵקֵל","v",NULL,"HEKEL","הקל","הקל",NULL,"HQL","HQL",NULL);
INSERT INTO hebrew_morpho VALUES (92566,"חֲלָלִית","n",NULL,"CHALALIT","חללית","חללית",NULL,"XLLIT","XLLIT",NULL);
INSERT INTO hebrew_morpho VALUES (92567,"רֶכֶב-חָלָל","n",NULL,"RECHEV-CHALAL","רכב-חלל","רכב-חלל",NULL,"RKB-XLL","RKB-XLL",NULL);
INSERT INTO hebrew_morpho VALUES (92568,"הִשְׁתַּחְצֵן","v",NULL,"HISHTACHTZEN","השתחצן","השתחצן",NULL,"H$TXCN","H$TXCN",NULL);
INSERT INTO hebrew_morpho VALUES (92569,"הִשְׁוִיץ","v",NULL,"HISHVITZ","השוויץ","השויץ",NULL,"H$WIC","H$WWIC",NULL);
INSERT INTO hebrew_morpho VALUES (92570,"הִבְהִיר","v",NULL,"HIVHIR","הבהיר","הבהיר",NULL,"HBHIR","HBHIR",NULL);
INSERT INTO hebrew_morpho VALUES (92571,"שָׁקַל_מֵחָדָשׁ","v",NULL,"SHAKAL_MECHADASH","שקל_מחדש","שקל_מחדש",NULL,"$QL_MXD$","$QL_MXD$",NULL);
INSERT INTO hebrew_morpho VALUES (92572,"עִיֵּן-מֵחָדָשׁ","v",NULL,"IYEN-MECHADASH","עיין-מחדש","עין-מחדש",NULL,"&IN-MXD$","&IIN-MXD$",NULL);
INSERT INTO hebrew_morpho VALUES (92573,"הִשְׁמִיעַ","v",NULL,"HISHMI\'AH","השמיע","השמיע",NULL,"H$MI&","H$MI&",NULL);
INSERT INTO hebrew_morpho VALUES (92574,"שִׁקֵּעַ","v",NULL,"SHIKE\'AH","שיקע","שקע",NULL,"$Q&","$IQ&",NULL);
INSERT INTO hebrew_morpho VALUES (92575,"רָזָה","v",NULL,"RAZA","רזה","רזה",NULL,"RZH","RZH",NULL);
INSERT INTO hebrew_morpho VALUES (92576,"יָרַד-בַּמִּשְׁקָל","v",NULL,"YARAD-BAMISHKAL","ירד-במשקל","ירד-במשקל",NULL,"IRD-BM$QL","IRD-BM$QL",NULL);
INSERT INTO hebrew_morpho VALUES (92577,"אִבֵּד-מִשְׁקָל","v",NULL,"IBED-MISHKAL","איבד-משקל","אבד-משקל",NULL,"ABD-M$QL","AIBD-M$QL",NULL);
INSERT INTO hebrew_morpho VALUES (92578,"לֵיצַן-הֶחָצֵר","n",NULL,"LEITZAN-HECHATZER","ליצן-החצר","ליצן-החצר",NULL,"LICN-HXCR","LICN-HXCR",NULL);
INSERT INTO hebrew_morpho VALUES (92579,"מְטֻפָּשׁ","a",NULL,"METUPASH","מטופש","מטפש",NULL,"M@P$","M@WP$",NULL);
INSERT INTO hebrew_morpho VALUES (92580,"מְרֻסָּק","a",NULL,"MERUSAK","מרוסק","מרסק",NULL,"MRSQ","MRWSQ",NULL);
INSERT INTO hebrew_morpho VALUES (92581,"סְקְלֶרוֹזִיס","n",NULL,"SKLEROZIS","סקלרוזיס","סקלרוזיס",NULL,"SQLRWZIS","SQLRWZIS",NULL);
INSERT INTO hebrew_morpho VALUES (92582,"עֲלוּקָה","n",NULL,"ALUKA","עלוקה","עלוקה",NULL,"&LWQH","&LWQH",NULL);
INSERT INTO hebrew_morpho VALUES (92583,"טַמְבּוּרִין","n",NULL,"TAMBURIN","טמבורין","טמבורין",NULL,"@MBWRIN","@MBWRIN",NULL);
INSERT INTO hebrew_morpho VALUES (92584,"תֹּף-מִרְיָם","n",NULL,"TOF-MIRYAM","תוף-מרים","תף-מרים",NULL,"TP-MRIM","TWP-MRIM",NULL);
INSERT INTO hebrew_morpho VALUES (92585,"חֶסֶר","n",NULL,"CHESER","חסר","חסר",NULL,"XSR","XSR",NULL);
INSERT INTO hebrew_morpho VALUES (92586,"מְטֻפָּל","n",NULL,"METUPAL","מטופל","מטפל",NULL,"M@PL","M@WPL",NULL);
INSERT INTO hebrew_morpho VALUES (92587,"פַּצְיֶנְט","n",NULL,"PATSYENT","פציינט","פצינט",NULL,"PCIN@","PCIIN@",NULL);
INSERT INTO hebrew_morpho VALUES (92588,"נְטִיפֵי-שֻׁמָּן","n",NULL,"NETIFEI-SHUMAN","נטיפי-שומן","נטיפי-שמן",NULL,"N@IPI-$MN","N@IPI-$WMN",NULL);
INSERT INTO hebrew_morpho VALUES (92589,"שִׂיחַת-טֶלֶפוֹן","n",NULL,"SICHAT-TELEFON","שיחת-טלפון","שיחת-טלפון",NULL,"$IXT-@LPWN","$IXT-@LPWN",NULL);
INSERT INTO hebrew_morpho VALUES (92590,"טֶלֶפוֹנְיָה","n",NULL,"TELEFONYA","טלפוניה","טלפוניה",NULL,"@LPWNIH","@LPWNIH",NULL);
INSERT INTO hebrew_morpho VALUES (92591,"הַמָּסָךְ-הַקָּטָן","n",NULL,"HAMASACH-HAKATAN","המסך-הקטן","המסך-הקטן",NULL,"HMSK-HQ@N","HMSK-HQ@N",NULL);
INSERT INTO hebrew_morpho VALUES (92592,"מַטְרִיד","a",NULL,"MATRID","מטריד","מטריד",NULL,"M@RID","M@RID",NULL);
INSERT INTO hebrew_morpho VALUES (92593,"מַרְגִּיז","a",NULL,"MARGIZ","מרגיז","מרגיז",NULL,"MRGIZ","MRGIZ",NULL);
INSERT INTO hebrew_morpho VALUES (92594,"מֵצִיק","a",NULL,"METZIK","מציק","מציק",NULL,"MCIQ","MCIQ",NULL);
INSERT INTO hebrew_morpho VALUES (92595,"הֵיטֵב","r",NULL,"HEITEV","היטב","היטב",NULL,"HI@B","HI@B",NULL);
INSERT INTO hebrew_morpho VALUES (92596,"הַטְבָּעָה","n",NULL,"HATBA\'AH","הטבעה","הטבעה",NULL,"H@B&H","H@B&H",NULL);
INSERT INTO hebrew_morpho VALUES (92597,"הַכְרָזָה","n",NULL,"HACHRAZA","הכרזה","הכרזה",NULL,"HKRZH","HKRZH",NULL);
INSERT INTO hebrew_morpho VALUES (92598,"הוֹדָעָת_תַּשְׁלוּם","n",NULL,"HODA\'AT_TASHLUM","הודעת_תשלום","הודעת_תשלום",NULL,"HWD&T_T$LWM","HWD&T_T$LWM",NULL);
INSERT INTO hebrew_morpho VALUES (92599,"תִּסְכּוּל","n",NULL,"TISKUL","תיסכול","תסכול",NULL,"TSKWL","TISKWL",NULL);
INSERT INTO hebrew_morpho VALUES (92600,"מַחְלֶקֶת-הַהֲגָנָה","n",NULL,"MACHLEKET-HAHAGANA","מחלקת-ההגנה","מחלקת-ההגנה",NULL,"MXLQT-HHGNH","MXLQT-HHGNH",NULL);
INSERT INTO hebrew_morpho VALUES (92601,"הַתְפָּלַת-מַיִם","n",NULL,"HATPALAT-MAYIM","התפלת_מים","התפלת-מים",NULL,"HTPLT-MIM","HTPLT_MIM",NULL);
INSERT INTO hebrew_morpho VALUES (92602,"בִּסֵּס","v",NULL,"BISES","ביסס","בסס",NULL,"BSS","BISS",NULL);
INSERT INTO hebrew_morpho VALUES (92603,"הֶעֱמִיד","v",NULL,"HE\'EMID","העמיד","העמיד",NULL,"H&MID","H&MID",NULL);
INSERT INTO hebrew_morpho VALUES (92604,"יִסֵּד","v",NULL,"YISED","ייסד","יסד",NULL,"ISD","IISD",NULL);
INSERT INTO hebrew_morpho VALUES (92605,"חָשׁ","v",NULL,"CHASH","חש","חש",NULL,"X$","X$",NULL);
INSERT INTO hebrew_morpho VALUES (92606,"מַעֲלָה","n",NULL,"MA\'ALA","מעלה","מעלה",NULL,"M&LH","M&LH",NULL);
INSERT INTO hebrew_morpho VALUES (92607,"חֹמֶר-גֶּלֶם","n",NULL,"CHOMER-GELEM","חומר-גלם","חמר-גלם",NULL,"XMR-GLM","XWMR-GLM",NULL);
INSERT INTO hebrew_morpho VALUES (92608,"מָטֶרְיָאלִיזְם","n",NULL,"MATERYALIZM","מטריאליזם","מטריאליזם",NULL,"M@RIALIZM","M@RIALIZM",NULL);
INSERT INTO hebrew_morpho VALUES (92609,"בֹּחַן","n",NULL,"BOCHAN","בוחן","בחן",NULL,"BXN","BWXN",NULL);
INSERT INTO hebrew_morpho VALUES (92610,"נִבּוּי","n",NULL,"NIBUY","ניבוי","נבוי",NULL,"NBWI","NIBWI",NULL);
INSERT INTO hebrew_morpho VALUES (92611,"בְּכֹחַ","r",NULL,"BECHO\'ACH","בכוח","בכח",NULL,"BKX","BKWX",NULL);
INSERT INTO hebrew_morpho VALUES (92612,"בֹּץ","n",NULL,"BOTZ","בוץ","בץ",NULL,"BC","BWC",NULL);
INSERT INTO hebrew_morpho VALUES (92613,"פְּרוֹטֶאִין","n",NULL,"PROTE\'IN","פרוטאין","פרוטאין",NULL,"PRW@AIN","PRW@AIN",NULL);
INSERT INTO hebrew_morpho VALUES (92614,"_קָאוֹלִין","n",NULL,"KAOLIN","קאולין","_קאולין",NULL,"_QAWLIN","QAWLIN",NULL);
INSERT INTO hebrew_morpho VALUES (92615,"שַׁקְדָן","a",NULL,"SHAKDAN","שקדן","שקדן",NULL,"$QDN","$QDN",NULL);
INSERT INTO hebrew_morpho VALUES (92616,"מַתְמִיד","a",NULL,"MATMID","מתמיד","מתמיד",NULL,"MTMID","MTMID",NULL);
INSERT INTO hebrew_morpho VALUES (92617,"אַבְקַת-חָרוּבִים","n",NULL,"AVKAT CHARUVIM","אבקת-חרובים","אבקת-חרובים",NULL,"ABQT-XRWBIM","ABQT-XRWBIM",NULL);
INSERT INTO hebrew_morpho VALUES (92618,"כְּרִיזַנְטֶמָה","n",NULL,"CHARIZENTEMA","כריזנטמה","כריזנטמה",NULL,"KRIZN@MH","KRIZN@MH",NULL);
INSERT INTO hebrew_morpho VALUES (92619,"שׁוֹשָׁן","n",NULL,"SHOSHAN","שושן","שושן",NULL,"$W$N","$W$N",NULL);
INSERT INTO hebrew_morpho VALUES (92620,"מְכֻנֶּה","a",NULL,"MEXUNEH","מכונה","מכנה",NULL,"MKNH","MKWNH",NULL);
INSERT INTO hebrew_morpho VALUES (92621,"יְבוּא","n",NULL,"YEVU","יבוא","יבוא",NULL,"IBWA","IBWA",NULL);
INSERT INTO hebrew_morpho VALUES (92622,"יִבֵּא","v",NULL,"YIBE","ייבא","יבא",NULL,"IBA","IIBA",NULL);
INSERT INTO hebrew_morpho VALUES (92623,"צְנִיחָה","n",NULL,"TZNICHA","צניחה","צניחה",NULL,"CNIXH","CNIXH",NULL);
INSERT INTO hebrew_morpho VALUES (92624,"תְּנוּבָה","n",NULL,"TNUVA","תנובה","תנובה",NULL,"TNWBH","TNWBH",NULL);
INSERT INTO hebrew_morpho VALUES (92625,"מִשְׁעֶנֶת","n",NULL,"MISH\'ENET","משענת","משענת",NULL,"M$&NT","M$&NT",NULL);
INSERT INTO hebrew_morpho VALUES (92626,"מָקוֹם-קָדוֹשׁ","n",NULL,"MAKOM-KADOSH","מקום-קדוש","מקום-קדוש",NULL,"MQWM-QDW$","MQWM-QDW$",NULL);
INSERT INTO hebrew_morpho VALUES (92627,"סִיאַנְס","n",NULL,"SI\'ANS","סיאנס","סיאנס",NULL,"SIANS","SIANS",NULL);
INSERT INTO hebrew_morpho VALUES (92628,"אוֹדִיטוֹרְיוּם","n",NULL,"ODITORIYUM","אודיטוריום","אודיטוריום",NULL,"AWDI@WRIWM","AWDI@WRIWM",NULL);
INSERT INTO hebrew_morpho VALUES (92629,"יֹשֶׁר-לֵב","n",NULL,"YOSHER LEV","יושר-לב","ישר-לב",NULL,"I$R-LB","IW$R-LB",NULL);
INSERT INTO hebrew_morpho VALUES (92630,"סֵדֶר","n",NULL,"SEDER","סדר","סדר",NULL,"SDR","SDR",NULL);
INSERT INTO hebrew_morpho VALUES (92631,"הַתְרָעָה","n",NULL,"HATRA\'A","התרעה","התרעה",NULL,"HTR&H","HTR&H",NULL);
INSERT INTO hebrew_morpho VALUES (92632,"סִימָן","n",NULL,"SIMAN","סימן","סימן",NULL,"SIMN","SIMN",NULL);
INSERT INTO hebrew_morpho VALUES (92633,"יַד-יָמִין","n",NULL,"YAD-YAMIN","יד-ימין","יד-ימין",NULL,"ID-IMIN","ID-IMIN",NULL);
INSERT INTO hebrew_morpho VALUES (92634,"גֹּדֶשׁ","n",NULL,"GODESH","גודש","גדש",NULL,"GD$","GWD$",NULL);
INSERT INTO hebrew_morpho VALUES (92635,"אִידִישׁ","n",NULL,"IDISH","אידיש","אידיש",NULL,"AIDI$","AIDI$",NULL);
INSERT INTO hebrew_morpho VALUES (92636,"שׁוֹק","n",NULL,"SHOK","שוק","שוק",NULL,"$WQ","$WQ",NULL);
INSERT INTO hebrew_morpho VALUES (92637,"פּוּלְקֶע","n",NULL,"PULKE","פולקע","פולקע",NULL,"PWLQ&","PWLQ&",NULL);
INSERT INTO hebrew_morpho VALUES (92638,"יֵשׁוּעַ","n",NULL,"YESHU\'A","ישוע","ישוע",NULL,"I$W&","I$W&",NULL);
INSERT INTO hebrew_morpho VALUES (92639,"הַנּוֹצְרִי","n",NULL,"HANOTZRI","הנוצרי","הנוצרי",NULL,"HNWCRI","HNWCRI",NULL);
INSERT INTO hebrew_morpho VALUES (92640,"הַצָּלוּב","n",NULL,"HATZALUV","הצלוב","הצלוב",NULL,"HCLWB","HCLWB",NULL);
INSERT INTO hebrew_morpho VALUES (92641,"יִחוּדִיּוּת","n",NULL,"YICHUDIYUT","ייחודיות","יחודיות",NULL,"IXWDIWT","IIXWDIWT",NULL);
INSERT INTO hebrew_morpho VALUES (92642,"מְיֻחָדוּת","n",NULL,"MEYUCHADUT","מיוחדות","מיחדות",NULL,"MIXDWT","MIWXDWT",NULL);
INSERT INTO hebrew_morpho VALUES (92643,"עַב-כָּרֶס","a",NULL,"AV-KARES","עב-כרס","עב-כרס",NULL,"&B-KRS","&B-KRS",NULL);
INSERT INTO hebrew_morpho VALUES (92644,"כְּרַסְתָּן","a",NULL,"KRASTAN","כרסתן","כרסתן",NULL,"KRSTN","KRSTN",NULL);
INSERT INTO hebrew_morpho VALUES (92645,"מֻכְסָף","a",NULL,"MUCHSAF","מוכסף","מכסף",NULL,"MKSP","MWKSP",NULL);
INSERT INTO hebrew_morpho VALUES (92646,"כָּסוּף","a",NULL,"KASUF","כסוף","כסוף",NULL,"KSWP","KSWP",NULL);
INSERT INTO hebrew_morpho VALUES (92647,"מַתַּכְתִּי","a",NULL,"MATACHTI","מתכתי","מתכתי",NULL,"MTKTI","MTKTI",NULL);
INSERT INTO hebrew_morpho VALUES (92648,"פִינַנְסִי","a",NULL,"FINANSI","פיננסי","פיננסי",NULL,"PINNSI","PINNSI",NULL);
INSERT INTO hebrew_morpho VALUES (92649,"נִכְחָד","a",NULL,"NICH\'CHAD","נכחד","נכחד",NULL,"NKXD","NKXD",NULL);
INSERT INTO hebrew_morpho VALUES (92650,"מֻחְמָץ","a",NULL,"MUCHMATZ","מוחמץ","מחמץ",NULL,"MXMC","MWXMC",NULL);
INSERT INTO hebrew_morpho VALUES (92651,"עוֹרֵג","a",NULL,"OREG","עורג","עורג",NULL,"&WRG","&WRG",NULL);
INSERT INTO hebrew_morpho VALUES (92652,"כָּכָה","r",NULL,"KACHA","ככה","ככה",NULL,"KKH","KKH",NULL);
INSERT INTO hebrew_morpho VALUES (92653,"אִינְסְטְרוּמֶנְטָלִי","a",NULL,"INSTRUMENTALI","אינסטרומנטלי","אינסטרומנטלי",NULL,"AINS@RWMN@LI","AINS@RWMN@LI",NULL);
INSERT INTO hebrew_morpho VALUES (92654,"קְבִיעוּת","n",NULL,"KVI\'UT","קביעות","קביעות",NULL,"QBI&WT","QBI&WT",NULL);
INSERT INTO hebrew_morpho VALUES (92655,"הַכְנָסָה-נֶטוֹ","n",NULL,"HAXNASA NETO","הכנסה-נטו","הכנסה-נטו",NULL,"HKNSH-N@W","HKNSH-N@W",NULL);
INSERT INTO hebrew_morpho VALUES (92656,"הַכְנָסָה-נְקִיָּה","n",NULL,"HAXNASA NEKIYA","הכנסה-נקייה","הכנסה-נקיה",NULL,"HKNSH-NQIH","HKNSH-NQIIH",NULL);
INSERT INTO hebrew_morpho VALUES (92657,"שְׂכַר-נֶטוֹ","n",NULL,"SXAR NETO","שכר-נטו","שכר-נטו",NULL,"$KR-N@W","$KR-N@W",NULL);
INSERT INTO hebrew_morpho VALUES (92658,"נֶטוֹ","n",NULL,"NETO","נטו","נטו",NULL,"N@W","N@W",NULL);
INSERT INTO hebrew_morpho VALUES (92659,"הִתְגּוֹרֵר","v",NULL,"HITGORER","התגורר","התגורר",NULL,"HTGWRR","HTGWRR",NULL);
INSERT INTO hebrew_morpho VALUES (92660,"חַי","v",NULL,"XAY","חי","חי",NULL,"XI","XI",NULL);
INSERT INTO hebrew_morpho VALUES (92661,"שָׁכַן","v",NULL,"SHAXAN","שכן","שכן",NULL,"$KN","$KN",NULL);
INSERT INTO hebrew_morpho VALUES (92662,"גָּר","v",NULL,"GAR","גר","גר",NULL,"GR","GR",NULL);
INSERT INTO hebrew_morpho VALUES (92663,"צִיָּה","n",NULL,"TSIYA","צייה","ציה",NULL,"CIH","CIIH",NULL);
INSERT INTO hebrew_morpho VALUES (92664,"יְצִירָתִיּוּת","n",NULL,"YETZIRATIYUT","יצירתיות","יצירתיות",NULL,"ICIRTIWT","ICIRTIWT",NULL);
INSERT INTO hebrew_morpho VALUES (92665,"קוֹנְטִינֶנְט","n",NULL,"KONTINENT","קונטיננט","קונטיננט",NULL,"QWN@INN@","QWN@INN@",NULL);
INSERT INTO hebrew_morpho VALUES (92666,"אִינְסְטִינְקְט","n",NULL,"INSTINKT","אינסטינקט","אינסטינקט",NULL,"AINS@INQ@","AINS@INQ@",NULL);
INSERT INTO hebrew_morpho VALUES (92667,"תּוֹרַת-הַיַּחֲסוּת","n",NULL,"TORAT-HAYAXASUT","תורת-היחסות","תורת-היחסות",NULL,"TWRT-HIXSWT","TWRT-HIXSWT",NULL);
INSERT INTO hebrew_morpho VALUES (92668,"אֱלֹהֵי-הַנּוֹצְרִים","n",NULL,"ELOHEI HANOTZRIM","אלוהי-הנוצרים","אלהי-הנוצרים",NULL,"ALHI-HNWCRIM","ALWHI-HNWCRIM",NULL);
INSERT INTO hebrew_morpho VALUES (92669,"יוֹם-הַשָּׁנָה","n",NULL,"YOM-HASHANA","יום-השנה","יום-השנה",NULL,"IWM-H$NH","IWM-H$NH",NULL);
INSERT INTO hebrew_morpho VALUES (92670,"בְּאֹפֶן-יַחֲסִי","r",NULL,"BEOFEN-YAXASI","באופן-יחסי","באפן-יחסי",NULL,"BAPN-IXSI","BAWPN-IXSI",NULL);
INSERT INTO hebrew_morpho VALUES (92671,"הָרַךְ-הַנּוֹלָד","n",NULL,"HARAX HANOLAD","הרך-הנולד","הרך-הנולד",NULL,"HRK-HNWLD","HRK-HNWLD",NULL);
INSERT INTO hebrew_morpho VALUES (92672,"יְצוּר-אֱנוֹשִׁי","n",NULL,"YETSUR-ENOSHI","יצור-אנושי","יצור-אנושי",NULL,"ICWR-ANW$I","ICWR-ANW$I",NULL);
INSERT INTO hebrew_morpho VALUES (92673,"בְּכִי-תַּמְרוּרִים","n",NULL,"BEXI TAMRURIM","בכי-תמרורים","בכי-תמרורים",NULL,"BKI-TMRWRIM","BKI-TMRWRIM",NULL);
INSERT INTO hebrew_morpho VALUES (92674,"נְהִי","n",NULL,"NEHI","נהי","נהי",NULL,"NHI","NHI",NULL);
INSERT INTO hebrew_morpho VALUES (92675,"תַּאֲנִיָּה-וַאֲנִיָּה","n",NULL,"TA\'ANIYA VA\'ANIYA","תאנייה-ואנייה","תאניה-ואניה",NULL,"TANIH-WANIH","TANIIH-WANIIH",NULL);
INSERT INTO hebrew_morpho VALUES (92676,"יְלָלוֹת","n",NULL,"YELALOT","יללות","יללות",NULL,"ILLWT","ILLWT",NULL);
INSERT INTO hebrew_morpho VALUES (92677,"קִטּוּרִים","n",NULL,"KITURIM","קיטורים","קטורים",NULL,"Q@WRIM","QI@WRIM",NULL);
INSERT INTO hebrew_morpho VALUES (92678,"נוֹעַד","v",NULL,"NO\'AD","נועד","נועד",NULL,"NW&D","NW&D",NULL);
INSERT INTO hebrew_morpho VALUES (92679,"קֶשֶׁר","n",NULL,"KESHER","קשר","קשר",NULL,"Q$R","Q$R",NULL);
INSERT INTO hebrew_morpho VALUES (92680,"בֶּרֶט","n",NULL,"BERET","ברט","ברט",NULL,"BR@","BR@",NULL);
INSERT INTO hebrew_morpho VALUES (92681,"שְׂמִיכַת-פּוּךְ","n",NULL,"SMICHAT-PUCH","שמיכת-פוך","שמיכת-פוך",NULL,"$MIKT-PWK","$MIKT-PWK",NULL);
INSERT INTO hebrew_morpho VALUES (92682,"כָּבוֹד-עַצְמִי","n",NULL,"KAVOD-ATZMI","כבוד-עצמי","כבוד-עצמי",NULL,"KBWD-&CMI","KBWD-&CMI",NULL);
INSERT INTO hebrew_morpho VALUES (92683,"מִינוּת","n",NULL,"MINUT","מינות","מינות",NULL,"MINWT","MINWT",NULL);
INSERT INTO hebrew_morpho VALUES (92684,"בֶּגֶד","n",NULL,"BEGED","בגד","בגד",NULL,"BGD","BGD",NULL);
INSERT INTO hebrew_morpho VALUES (92685,"כְּלִי-זַיִן","n",NULL,"KLI-ZAYIN","כלי-זין","כלי-זין",NULL,"KLI-ZIN","KLI-ZIN",NULL);
INSERT INTO hebrew_morpho VALUES (92686,"כְּלִי-נֶשֶׁק","n",NULL,"KLI-NESHEK","כלי-נשק","כלי-נשק",NULL,"KLI-N$Q","KLI-N$Q",NULL);
INSERT INTO hebrew_morpho VALUES (92687,"נֶשֶׁק","n",NULL,"NESHEK","נשק","נשק",NULL,"N$Q","N$Q",NULL);
INSERT INTO hebrew_morpho VALUES (92688,"אֶקוֹנוֹמְיָה","n",NULL,"ECONOMYA","אקונומיה","אקונומיה",NULL,"AQWNWMIH","AQWNWMIH",NULL);
INSERT INTO hebrew_morpho VALUES (92689,"כְּתַב-יָד","n",NULL,"KTAV-YAD","כתב-יד","כתב-יד",NULL,"KTB-ID","KTB-ID",NULL);
INSERT INTO hebrew_morpho VALUES (92690,"אוֹת-קַיִן","n",NULL,"OT-KAYIN","אות-קין","אות-קין",NULL,"AWT-QIN","AWT-QIN",NULL);
INSERT INTO hebrew_morpho VALUES (92691,"לַחֲלוּטִין","r",NULL,"LAXALUTIN","לחלוטין","לחלוטין",NULL,"LXLW@IN","LXLW@IN",NULL);
INSERT INTO hebrew_morpho VALUES (92692,"צָרָה","n",NULL,"TSARA","צרה","צרה",NULL,"CRH","CRH",NULL);
INSERT INTO hebrew_morpho VALUES (92693,"בִּמְלוֹאוֹ","r",NULL,"BIMLO\'OH","במלואו","במלואו",NULL,"BMLWAW","BMLWAW",NULL);
INSERT INTO hebrew_morpho VALUES (92694,"שְׁלוּק","n",NULL,"SHLUK","שלוק","שלוק",NULL,"$LWQ","$LWQ",NULL);
INSERT INTO hebrew_morpho VALUES (92695,"גִּבּוּשׁ","n",NULL,"GIBUSH","גיבוש","גבוש",NULL,"GBW$","GIBW$",NULL);
INSERT INTO hebrew_morpho VALUES (92696,"אַנְאַלְפָבֵּיתִי","a",NULL,"ANALFABETI","אנאלפביתי","אנאלפביתי",NULL,"ANALPBITI","ANALPBITI",NULL);
INSERT INTO hebrew_morpho VALUES (92697,"בִּזּוּר","n",NULL,"BIZUR","ביזור","בזור",NULL,"BZWR","BIZWR",NULL);
INSERT INTO hebrew_morpho VALUES (92698,"דֶּצֶנְטְרָלִיזַצְיָה","n",NULL,"DETSENTRALIZATSIA","דצנטרליזציה","דצנטרליזציה",NULL,"DCN@RLIZCIH","DCN@RLIZCIH",NULL);
INSERT INTO hebrew_morpho VALUES (92699,"רִצְפָּה","n",NULL,"RITSPA","רצפה","רצפה",NULL,"RCPH","RCPH",NULL);
INSERT INTO hebrew_morpho VALUES (92700,"תִּקְרָה","n",NULL,"TIKRA","תקרה","תקרה",NULL,"TQRH","TQRH",NULL);
INSERT INTO hebrew_morpho VALUES (92701,"רְבָב","n",NULL,"REVAV","רבב","רבב",NULL,"RBB","RBB",NULL);
INSERT INTO hebrew_morpho VALUES (92702,"אוֹת-קָלוֹן","n",NULL,"OT-KALON","אות-קלון","אות-קלון",NULL,"AWT-QLWN","AWT-QLWN",NULL);
INSERT INTO hebrew_morpho VALUES (92703,"כּוֹכָבִית","n",NULL,"KOCHAVIT","כוכבית","כוכבית",NULL,"KWKBIT","KWKBIT",NULL);
INSERT INTO hebrew_morpho VALUES (92704,"פּוֹסְטֶר","n",NULL,"POSTER","פוסטר","פוסטר",NULL,"PWS@R","PWS@R",NULL);
INSERT INTO hebrew_morpho VALUES (92705,"פְּלָקָט","n",NULL,"PLAKAT","פלקט","פלקט",NULL,"PLQ@","PLQ@",NULL);
INSERT INTO hebrew_morpho VALUES (92706,"כִּכַּר-לֶחֶם","n",NULL,"KIKAR-LECHEM","כיכר-לחם","ככר-לחם",NULL,"KKR-LXM","KIKR-LXM",NULL);
INSERT INTO hebrew_morpho VALUES (92707,"פּוֹלָנִי","n",NULL,"POLANI","פולני","פולני",NULL,"PWLNI","PWLNI","male");
INSERT INTO hebrew_morpho VALUES (92708,"שַׂחְקָן-פוּטְבּוֹל","n",NULL,"SACHKAN-FUTBOL","שחקן-פוטבול","שחקן-פוטבול",NULL,"$XQN-PW@BWL","$XQN-PW@BWL",NULL);
INSERT INTO hebrew_morpho VALUES (92709,"כַּדּוּרַגְלָן","n",NULL,"KADURAGLAN","כדורגלן","כדורגלן",NULL,"KDWRGLN","KDWRGLN",NULL);
INSERT INTO hebrew_morpho VALUES (92710,"כִירוּרְג","n",NULL,"XIRURG","כירורג","כירורג",NULL,"KIRWRG","KIRWRG","male");
INSERT INTO hebrew_morpho VALUES (92711,"רוֹפֵא-מְנַתֵּחַ","n",NULL,"ROFE-MENATE\'AX","רופא-מנתח","רופא-מנתח",NULL,"RWPA-MNTX","RWPA-MNTX","male");
INSERT INTO hebrew_morpho VALUES (92712,"בְּקָרוֹב","r",NULL,"BEKAROV","בקרוב","בקרוב",NULL,"BQRWB","BQRWB",NULL);
INSERT INTO hebrew_morpho VALUES (92713,"עוֹד-מְעַט","r",NULL,"OD-ME\'AT","עוד-מעט","עוד-מעט",NULL,"&WD-M&@","&WD-M&@",NULL);
INSERT INTO hebrew_morpho VALUES (92714,"קָרוֹב-לְוַדַּאי","r",NULL,"KAROV-LEVADAY","קרוב-לודאי","קרוב-לודאי",NULL,"QRWB-LWDAI","QRWB-LWDAI",NULL);
INSERT INTO hebrew_morpho VALUES (92715,"מִן-הַסְּתָם","r",NULL,"MIN-HASTAM","מן-הסתם","מן-הסתם",NULL,"MN-HSTM","MN-HSTM",NULL);
INSERT INTO hebrew_morpho VALUES (92716,"כַּיָּאוּת","r",NULL,"KAYA\'UT","כיאות","כיאות",NULL,"KIAWT","KIAWT",NULL);
INSERT INTO hebrew_morpho VALUES (92717,"כָּרָאוּי","r",NULL,"KARA\'UY","כראוי","כראוי",NULL,"KRAWI","KRAWI",NULL);
INSERT INTO hebrew_morpho VALUES (92718,"כַּהֹגֶן","r",NULL,"KAHOGEN","כהוגן","כהגן",NULL,"KHGN","KHWGN",NULL);
INSERT INTO hebrew_morpho VALUES (92719,"הֶחְמִיץ","v",NULL,"HECHMITZ","החמיץ","החמיץ",NULL,"HXMIC","HXMIC",NULL);
INSERT INTO hebrew_morpho VALUES (92720,"מִקֵּשׁ","v",NULL,"MIKESH","מיקש","מקש",NULL,"MQ$","MIQ$",NULL);
INSERT INTO hebrew_morpho VALUES (92721,"לַטְקֶס","n",NULL,"LATKES","לטקס","לטקס",NULL,"L@QS","L@QS",NULL);
INSERT INTO hebrew_morpho VALUES (92722,"לַאטְקֶעס","n",NULL,NULL,"לאטקעס","לאטקעס",NULL,"LA@Q&S","LA@Q&S",NULL);
INSERT INTO hebrew_morpho VALUES (92723,"אֹסֶף","n",NULL,"OSEF","אוסף","אסף",NULL,"ASP","AWSP",NULL);
INSERT INTO hebrew_morpho VALUES (92724,"בְּלוֹק","n",NULL,"BLOK","בלוק","בלוק",NULL,"BLWQ","BLWQ",NULL);
INSERT INTO hebrew_morpho VALUES (92725,"הַלְבָּשָׁה-תַּחְתּוֹנָה","n",NULL,"HALBASHA TAXTONA","הלבשה-תחתונה","הלבשה-תחתונה",NULL,"HLB$H-TXTWNH","HLB$H-TXTWNH",NULL);
INSERT INTO hebrew_morpho VALUES (92726,"הֶרוֹאִין","n",NULL,"HERO\'IN","הרואין","הרואין",NULL,"HRWAIN","HRWAIN",NULL);
INSERT INTO hebrew_morpho VALUES (92727,"לָבָן","n",NULL,"LAVAN","לבן","לבן",NULL,"LBN","LBN",NULL);
INSERT INTO hebrew_morpho VALUES (92728,"הִגְלָה","v",NULL,"HIGLA","הגלה","הגלה",NULL,"HGLH","HGLH",NULL);
INSERT INTO hebrew_morpho VALUES (92729,"הִשְׁתַּמְּטוּת","n",NULL,"HISHTAMTUT","השתמטות","השתמטות",NULL,"H$TM@WT","H$TM@WT",NULL);
INSERT INTO hebrew_morpho VALUES (92730,"הִתְחַמְּקוּת","n",NULL,"HITCHAMKUT","התחמקות","התחמקות",NULL,"HTXMQWT","HTXMQWT",NULL);
INSERT INTO hebrew_morpho VALUES (92731,"שֻׁלְחָן","n",NULL,"SHULXAN","שולחן","שלחן",NULL,"$LXN","$WLXN",NULL);
INSERT INTO hebrew_morpho VALUES (92732,"שֻׁלְחָן-אֹכֶל","n",NULL,"SHULXAN OXEL","שולחן-אוכל","שלחן-אכל",NULL,"$LXN-AKL","$WLXN-AWKL",NULL);
INSERT INTO hebrew_morpho VALUES (92733,"פָּלַט","v",NULL,"PALAT","פלט","פלט",NULL,"PL@","PL@",NULL);
INSERT INTO hebrew_morpho VALUES (92734,"הִלְבִּין","v",NULL,"HILBIN","הלבין","הלבין",NULL,"HLBIN","HLBIN",NULL);
INSERT INTO hebrew_morpho VALUES (92735,"שַׁרְשֶׁרֶת","n",NULL,NULL,NULL,"שרשרת",NULL,"$R$RT",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92736,"זַכּוּת","n",NULL,NULL,NULL,"זכות",NULL,"ZKWT",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92737,"זִיּוּף","n",NULL,NULL,NULL,"זיוף",NULL,"ZIWP",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92738,"זוּטָר","a",NULL,NULL,NULL,"זוטר",NULL,"ZW@R",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92739,"הַלְוָאָה","n",NULL,NULL,NULL,"הלואה",NULL,"HLWAH",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92740,"סִדּוּר","n",NULL,NULL,NULL,"סדור",NULL,"SDWR",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92741,"הֲצָצָה","n",NULL,NULL,NULL,"הצצה",NULL,"HCCH",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92742,"זֵכֶר","n",NULL,NULL,NULL,"זכר",NULL,"ZKR",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92743,"פַּעֲמוֹן","n",NULL,NULL,NULL,"פעמון",NULL,"P&MWN",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92744,"זוֹג","n",NULL,NULL,NULL,"זוג",NULL,"ZWG",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92745,"פִּי","n",NULL,"fi","פי","פי",NULL,"PI","PI",NULL);
INSERT INTO hebrew_morpho VALUES (92746,"זָכַר","v",NULL,NULL,NULL,"זכר",NULL,"ZKR",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92747,"חָסֵר","a",NULL,NULL,NULL,"חסר",NULL,"XSR",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92748,"חַי","n",NULL,NULL,NULL,"חי",NULL,"XI",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92749,"צָרִיךְ","a",NULL,NULL,NULL,"צריך",NULL,"CRIK",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92750,"חַיָּב","a",NULL,NULL,NULL,"חיב",NULL,"XIB",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92751,"חַשְׁמַלִּי","a",NULL,NULL,NULL,"חשמלי",NULL,"X$MLI",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92752,"חָשׁוּב","a",NULL,NULL,NULL,"חשוב",NULL,"X$WB",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92753,"חֲתִירָה","n",NULL,NULL,NULL,"חתירה",NULL,"XTIRH",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92754,"חֲקִירָה","n",NULL,NULL,NULL,"חקירה",NULL,"XQIRH",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92755,"סְלִיחָה","n",NULL,"slixa","סליחה","סליחה","  ","SLIXH","SLIXH",NULL);
INSERT INTO hebrew_morpho VALUES (92756,"חֵלֶק","n",NULL,NULL,NULL,"חלק",NULL,"XLQ",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92757,"חֵן","n",NULL,NULL,NULL,"חן",NULL,"XN",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92758,"כֻּתֹּנֶת","n",NULL,NULL,NULL,"כתנת",NULL,"KTNT",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92759,"חֶשְׁבּוֹן","n",NULL,NULL,NULL,"חשבון",NULL,"X$BWN",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92760,"הֶרְכֵּב","n",NULL,NULL,NULL,"הרכב",NULL,"HRKB",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92761,"מַעֲרֶכֶת","n",NULL,NULL,NULL,"מערכת",NULL,"M&RKT",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92762,"מַעֲרָכָה","n",NULL,"ma\'aracha","מערכה","מערכה",NULL,"M&RKH","M&RKH",NULL);
INSERT INTO hebrew_morpho VALUES (92763,"סִדְרָה","n",NULL,"sidra","סדרה","סדרה",NULL,"SDRH","SDRH",NULL);
INSERT INTO hebrew_morpho VALUES (92764,"חֻמְרָה","n",NULL,NULL,NULL,"חמרה",NULL,"XMRH",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92765,"חֹסֶר","n",NULL,NULL,NULL,"חסר",NULL,"XSR",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92766,"חִיֵּב","v",NULL,NULL,NULL,"חיב",NULL,"XIB",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92767,"לָחַץ","v",NULL,NULL,NULL,"לחץ",NULL,"LXC",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92768,"הֵבִיא","v",NULL,NULL,NULL,"הביא",NULL,"HBIA",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92769,"חִלֵּק","v",NULL,NULL,NULL,"חלק",NULL,"XLQ",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92770,"חֲלָלִית","n",NULL,NULL,NULL,"חללית",NULL,"XLLIT",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92771,"דְּאָגָה","n",NULL,NULL,NULL,"דאגה",NULL,"DAGH",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92772,"חֻלִּין","n",NULL,NULL,NULL,"חלין",NULL,"XLIN",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92773,"חוֹלִירַע","n",NULL,NULL,NULL,"חולירע",NULL,"XWLIR&",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92774,"חָתָן","n",NULL,NULL,NULL,"חתן",NULL,"XTN",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95211,"בֶּן-לְוָיָה","n",NULL,"ben-levayah","בן-לוויה","בֶּן-לְוָיָה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (92776,"טְחוֹרִים","n",NULL,NULL,NULL,"טחורים",NULL,"@XWRIM",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92777,"הֲגַנָּה","n",NULL,NULL,NULL,"הגנה",NULL,"HGNH",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92778,"הַנָּחָה","n",NULL,NULL,NULL,"הנחה",NULL,"HNXH",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92779,"עֲרִיכָה","n",NULL,"arixa","עריכה","עריכה",NULL,"&RIKH","&RIKH",NULL);
INSERT INTO hebrew_morpho VALUES (92780,"הַשְׁעָרָה","n",NULL,NULL,NULL,"השערה",NULL,"H$&RH",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92781,"סְבָרָה","n",NULL,NULL,NULL,"סברה",NULL,"SBRH",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92782,"מִבְדָּק","n",NULL,NULL,NULL,"מבדק",NULL,"MBDQ",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92783,"חִזּוּק","n",NULL,NULL,NULL,"חזוק",NULL,"XZWQ",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92784,"חֲתִימָה","n",NULL,"xatima","חתימה","חתימה","  ","XTIMH","XTIMH",NULL);
INSERT INTO hebrew_morpho VALUES (92785,"מִתְנַגֵּד","n",NULL,NULL,NULL,"מתנגד",NULL,"MTNGD",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92786,"יָרִיב","n",NULL,NULL,NULL,"יריב",NULL,"IRIB",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92787,"יָרִיב","a",NULL,NULL,NULL,"יריב",NULL,"IRIB",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92788,"מוּעָד","a",NULL,NULL,NULL,"מועד",NULL,"MW&D",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92789,"לִילִית","n",NULL,NULL,NULL,"לילית",NULL,"LILIT",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92790,"תִּנְשֶׁמֶת","n",NULL,NULL,NULL,"תנשמת",NULL,"TN$MT",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92791,"עִבְרִית","n",NULL,"ivrit","עברית","עברית",NULL,"&BRIT","&BRIT",NULL);
INSERT INTO hebrew_morpho VALUES (92792,"יִשְׂרְאֵלִי","n",NULL,NULL,NULL,"ישראלי",NULL,"I$RALI",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92793,"יְהוּדִי","n",NULL,NULL,NULL,"יהודי",NULL,"IHWDI",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92794,"יִשְׂרְאֵלִי","a",NULL,NULL,NULL,"ישראלי",NULL,"I$RALI",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92795,"יָם","n",NULL,NULL,NULL,"ים",NULL,"IM",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92796,"אֲגִירָה","n",NULL,NULL,NULL,"אגירה",NULL,"AGIRH",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92797,"אֻלְפָּן","n",NULL,NULL,NULL,"אלפן",NULL,"ALPN",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92798,"אַלִּימוּת","n",NULL,NULL,NULL,"אלימות",NULL,"ALIMWT",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92799,"אָזְלַת_יָד","n",NULL,NULL,NULL,"אזלת_יד",NULL,"AZLT_ID",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92800,"סְבִיבָה","n",NULL,"sviva","סביבה","סביבה",NULL,"SBIBH","SBIBH",NULL);
INSERT INTO hebrew_morpho VALUES (92801,"אָלָה","n",NULL,NULL,NULL,"אלה",NULL,"ALH",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92802,"שְׁבוּעָה","n",NULL,"shvu\'ah","שבועה","שְׁבוּעָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92804,"אוֹת","n",NULL,NULL,NULL,"אות",NULL,"AWT",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92805,"יֶדַע","n",NULL,NULL,NULL,"ידע",NULL,"ID&",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92806,"יְדִיעָה","n",NULL,NULL,NULL,"ידיעה",NULL,"IDI&H",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92807,"מוּצָק","a",NULL,NULL,NULL,"מוצק",NULL,"MWCQ",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92808,"רֹב","n",NULL,"rov","רוב","רב",NULL,"RB","RWB",NULL);
INSERT INTO hebrew_morpho VALUES (92809,"לְבוּשׁ","n",NULL,NULL,NULL,"לבוש",NULL,"LBW$",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92810,"פָּתַח-וְאָמַר","v",NULL,"PATACH-VE\'AMAR","פתח-ואמר","פתח-ואמר",NULL,"PTX-WAMR","PTX-WAMR",NULL);
INSERT INTO hebrew_morpho VALUES (92811,"הִבְלִיט","v",NULL,"HIVLIT","הבליט","הבליט",NULL,"HBLI@","HBLI@",NULL);
INSERT INTO hebrew_morpho VALUES (92812,"נָזַף","v",NULL,"NAZAF","נזף","נזף",NULL,"NZP","NZP",NULL);
INSERT INTO hebrew_morpho VALUES (92813,"גָּעַר","v",NULL,"GA\'AR","גער","גער",NULL,"G&R","G&R",NULL);
INSERT INTO hebrew_morpho VALUES (92814,"נָתַן-לוֹ-עַל-הָרֹאשׁ","v",NULL,"NATAN-LO-AL-HAROSH","נתן-לו-על-הראש","נתן-לו-על-הראש",NULL,"NTN-LW-&L-HRA$","NTN-LW-&L-HRA$",NULL);
INSERT INTO hebrew_morpho VALUES (92815,"שָׁטַף-אֶת","v",NULL,"SHATAF-ET","שטף-את","שטף-את",NULL,"$@P-AT","$@P-AT",NULL);
INSERT INTO hebrew_morpho VALUES (92816,"עִפְעוּף","n",NULL,"IF\'UF","עיפעוף","עפעוף",NULL,"&P&WP","&IP&WP",NULL);
INSERT INTO hebrew_morpho VALUES (92817,"הַצְלָפָה","n",NULL,"HATZLAFA","הצלפה","הצלפה",NULL,"HCLPH","HCLPH",NULL);
INSERT INTO hebrew_morpho VALUES (92818,"צְלִיפָה","n",NULL,"TZLIFA","צליפה","צליפה",NULL,"CLIPH","CLIPH",NULL);
INSERT INTO hebrew_morpho VALUES (92819,"אִבְקָה","n",NULL,"IVKA","אבקה","אבקה",NULL,"ABQH","ABQH",NULL);
INSERT INTO hebrew_morpho VALUES (92820,"פַּנְקְרֵאָס","n",NULL,"PANKRE\'AS","פנקריאס","פנקראס",NULL,"PNQRAS","PNQRIAS",NULL);
INSERT INTO hebrew_morpho VALUES (92821,"פּוֹלָנִית","n",NULL,"POLANIT","פולנית","פולנית",NULL,"PWLNIT","PWLNIT",NULL);
INSERT INTO hebrew_morpho VALUES (92822,"פַּטְרִיוֹטִיזְם","n",NULL,"PATRIYOTIZM","פטריוטיזם","פטריוטיזם",NULL,"P@RIW@IZM","P@RIW@IZM",NULL);
INSERT INTO hebrew_morpho VALUES (92823,"פַּטְרִיוֹטִיּוּת","n",NULL,"PATRIYOTIYUT","פטריוטיות","פטריוטיות",NULL,"P@RIW@IWT","P@RIW@IWT",NULL);
INSERT INTO hebrew_morpho VALUES (92824,"לְאֻמָּנוּת","n",NULL,"LE\'UMANUT","לאומנות","לאמנות",NULL,"LAMNWT","LAWMNWT",NULL);
INSERT INTO hebrew_morpho VALUES (92825,"דִּיאָלֶקְט","n",NULL,"DI\'ALEKT","דיאלקט","דיאלקט",NULL,"DIALQ@","DIALQ@",NULL);
INSERT INTO hebrew_morpho VALUES (92826,"רַחַשׁ","n",NULL,"RAXASH","רחש","רחש",NULL,"RX$","RX$",NULL);
INSERT INTO hebrew_morpho VALUES (92827,"רִשְׁרוּשׁ","n",NULL,"RISHRUSH","רשרוש","רשרוש",NULL,"R$RW$","R$RW$",NULL);
INSERT INTO hebrew_morpho VALUES (92828,"רַחְשׁוּשׁ","n",NULL,"RAXSHUSH","רחשוש","רחשוש",NULL,"RX$W$","RX$W$",NULL);
INSERT INTO hebrew_morpho VALUES (92829,"אַלְבִּינוֹ","n",NULL,"ALBINO","אלבינו","אלבינו",NULL,"ALBINW","ALBINW",NULL);
INSERT INTO hebrew_morpho VALUES (92830,"עוּגַת-סְפוֹג","n",NULL,"UGAT SFOG","עוגת-ספוג","עוגת-ספוג",NULL,"&WGT-SPWG","&WGT-SPWG",NULL);
INSERT INTO hebrew_morpho VALUES (92831,"לֻבְנָן","n",NULL,"LUVNAN","לובנן","לבנן",NULL,"LBNN","LWBNN",NULL);
INSERT INTO hebrew_morpho VALUES (92832,"עֲיֵפוּת","n",NULL,"AYEFUT","עייפות","עיפות",NULL,"&IPWT","&IIPWT",NULL);
INSERT INTO hebrew_morpho VALUES (92833,"אַקְרוֹבָּט","n",NULL,"AKROBAT","אקרובט","אקרובט",NULL,"AQRWB@","AQRWB@",NULL);
INSERT INTO hebrew_morpho VALUES (92834,"וֶנוּס","n",NULL,"VENUS","ונוס","ונוס",NULL,"WNWS","WNWS",NULL);
INSERT INTO hebrew_morpho VALUES (92835,"כּוֹכַב-הַשַּׁחַר","n",NULL,"KOXAV-HASHAXAR","כוכב-השחר","כוכב-השחר",NULL,"KWKB-H$XR","KWKB-H$XR",NULL);
INSERT INTO hebrew_morpho VALUES (92836,"כּוֹכַב-הָעֶרֶב","n",NULL,"KOXAV-HA\'EREV","כוכב-הערב","כוכב-הערב",NULL,"KWKB-H&RB","KWKB-H&RB",NULL);
INSERT INTO hebrew_morpho VALUES (92837,"אִישׁ-מִלְחָמָה","n",NULL,"ISH-MILXAMA","איש-מלחמה","איש-מלחמה",NULL,"AI$-MLXMH","AI$-MLXMH",NULL);
INSERT INTO hebrew_morpho VALUES (92838,"חָרַשׁ-עֵץ","n",NULL,"XARASH-ETS","חרש-עץ","חרש-עץ",NULL,"XR$-&C","XR$-&C",NULL);
INSERT INTO hebrew_morpho VALUES (92839,"קְלִיֶנְט","n",NULL,"KLIYENT","קליינט","קלינט",NULL,"QLIN@","QLIIN@",NULL);
INSERT INTO hebrew_morpho VALUES (92840,"לִפְרָקִים","r",NULL,"LIFRAKIM","לפרקים","לפרקים",NULL,"LPRQIM","LPRQIM",NULL);
INSERT INTO hebrew_morpho VALUES (92841,"הַפְלָגָה","n",NULL,"HAFLAGA","הפלגה","הפלגה",NULL,"HPLGH","HPLGH",NULL);
INSERT INTO hebrew_morpho VALUES (92842,"רְדִיפָה","n",NULL,"REDIFA","רדיפה","רדיפה",NULL,"RDIPH","RDIPH",NULL);
INSERT INTO hebrew_morpho VALUES (92843,"דְּלִיקָה","n",NULL,"DLIKA","דליקה","דליקה",NULL,"DLIQH","DLIQH",NULL);
INSERT INTO hebrew_morpho VALUES (92844,"דַּי","r",NULL,"DAY","די","די",NULL,"DI","DI",NULL);
INSERT INTO hebrew_morpho VALUES (92845,"לֶנְטוֹ","r",NULL,"LENTO","לנטו","לנטו",NULL,"LN@W","LN@W",NULL);
INSERT INTO hebrew_morpho VALUES (92846,"לְלֹא-הוֹעִיל","r",NULL,"LELO HO\'IL","ללא-הועיל","ללא-הועיל",NULL,"LLA-HW&IL","LLA-HW&IL",NULL);
INSERT INTO hebrew_morpho VALUES (92847,"בְּנִפְרָד","r",NULL,"BENIFRAD","בנפרד","בנפרד",NULL,"BNPRD","BNPRD",NULL);
INSERT INTO hebrew_morpho VALUES (92848,"לָאַט","v",NULL,"LA\'AT","לאט","לאט",NULL,"LA@","LA@",NULL);
INSERT INTO hebrew_morpho VALUES (92849,"הִבְרִיק","v",NULL,"HIVRIK","הבריק","הבריק",NULL,"HBRIQ","HBRIQ",NULL);
INSERT INTO hebrew_morpho VALUES (92850,"רַב-צִבְעִי","a",NULL,"RAV-TSIV\'I","רב-צבעי","רב-צבעי",NULL,"RB-CB&I","RB-CB&I",NULL);
INSERT INTO hebrew_morpho VALUES (92851,"רַב-גּוֹנִי","a",NULL,"RAV-GONI","רב-גוני","רב-גוני",NULL,"RB-GWNI","RB-GWNI",NULL);
INSERT INTO hebrew_morpho VALUES (92852,"בְּקִרְבַת-מָקוֹם","a",NULL,"BEKIRVAT MAKOM","בקרבת-מקום","בקרבת-מקום",NULL,"BQRBT-MQWM","BQRBT-MQWM",NULL);
INSERT INTO hebrew_morpho VALUES (92853,"מֻצָּג-מִשְׁפָּטִי","n",NULL,"MUTZAG-MISHPATI","מוצג-משפטי","מצג-משפטי",NULL,"MCG-M$P@I","MWCG-M$P@I",NULL);
INSERT INTO hebrew_morpho VALUES (92854,"קַנְדֶּלָה","n",NULL,"KANDELA","קנדלה","קנדלה",NULL,"QNDLH","QNDLH",NULL);
INSERT INTO hebrew_morpho VALUES (92855,"סוֹדְיוּם","n",NULL,"SODYUM","סודיום","סודיום",NULL,"SWDIWM","SWDIWM",NULL);
INSERT INTO hebrew_morpho VALUES (92856,"הַבְרָקָה","n",NULL,"HAVRAKA","הברקה","הברקה",NULL,"HBRQH","HBRQH",NULL);
INSERT INTO hebrew_morpho VALUES (92857,"בִּצָּה","n",NULL,"BITZA","ביצה","בצה",NULL,"BCH","BICH",NULL);
INSERT INTO hebrew_morpho VALUES (92858,"אַדְמַת-בִּצָּה","n",NULL,"ADMAT-BITSA","אדמת-ביצה","אדמת-בצה",NULL,"ADMT-BCH","ADMT-BICH",NULL);
INSERT INTO hebrew_morpho VALUES (92859,"פַּזְרָן","n",NULL,"PAZRAN","פזרן","פזרן",NULL,"PZRN","PZRN",NULL);
INSERT INTO hebrew_morpho VALUES (92860,"מַגְרֵפָה","n",NULL,NULL,"מגרפה","מגרפה",NULL,"MGRPH","MGRPH",NULL);
INSERT INTO hebrew_morpho VALUES (92861,"מְעִילָה","n",NULL,NULL,NULL,"מעילה",NULL,"M&ILH","M&ILH",NULL);
INSERT INTO hebrew_morpho VALUES (92862,"מִפְקָד","n",NULL,"mifkad","מיפקד","מפקד",NULL,"MPQD","MIPQD",NULL);
INSERT INTO hebrew_morpho VALUES (92863,"קְרָב","n",NULL,"krav","קרב","קרב",NULL,"QRB","QRB",NULL);
INSERT INTO hebrew_morpho VALUES (92864,"מַאֲבָק","n",NULL,"ma\'avak","מאבק","מאבק",NULL,"MABQ","MABQ",NULL);
INSERT INTO hebrew_morpho VALUES (92865,"מִלְחָמָה","n",NULL,"milchama","מלחמה","מלחמה",NULL,"MLXMH","MLXMH",NULL);
INSERT INTO hebrew_morpho VALUES (92866,"מַאֲפִיָּה","n",NULL,NULL,"מאפייה","מאפיה",NULL,"MAPIH","MAPIIH",NULL);
INSERT INTO hebrew_morpho VALUES (92867,"מַפְסֶלֶת","n",NULL,NULL,"מפסלת","מפסלת",NULL,"MPSLT","MPSLT",NULL);
INSERT INTO hebrew_morpho VALUES (92868,"מַרְצֵעַ","n",NULL,NULL,"מרצע","מרצע",NULL,"MRC&","MRC&",NULL);
INSERT INTO hebrew_morpho VALUES (92869,"מִחְזוּר","n",NULL,"michzur","מחזור","מחזור",NULL,"MXZWR","MXZWR",NULL);
INSERT INTO hebrew_morpho VALUES (92870,"מָצוֹד","n",NULL,"matzod","מצוד","מצוד",NULL,"MCWD","MCWD",NULL);
INSERT INTO hebrew_morpho VALUES (92871,"מִסְחוּר","n",NULL,"mischur","מסחור","מסחור",NULL,"MSXWR","MSXWR",NULL);
INSERT INTO hebrew_morpho VALUES (92872,"מַזְגָן","n",NULL,"mazgan","מזגן","מזגן",NULL,"MZGN","MZGN",NULL);
INSERT INTO hebrew_morpho VALUES (92873,"מִגְדָּלוֹר","n",NULL,"migdalor","מגדלור","מגדלור",NULL,"MGDLWR","MGDLWR",NULL);
INSERT INTO hebrew_morpho VALUES (92874,"נַגָּרוּת","n",NULL,"NAGARUT","נגרות","נגרות",NULL,"NGRWT","NGRWT",NULL);
INSERT INTO hebrew_morpho VALUES (92875,"נִתּוּחַ","n",NULL,"NITU\'AX","ניתוח","נתוח",NULL,"NTWX","NITWX",NULL);
INSERT INTO hebrew_morpho VALUES (92876,"נַחֲלִיאֵלִי","n",NULL,"NAXLI\'ELI","נחליאלי","נחליאלי"," נַחְלִיאֵלִי ","NXLIALI","NXLIALI",NULL);
INSERT INTO hebrew_morpho VALUES (92877,"׳ײ´׳©׳ײ°׳§ײ¸׳","n",NULL,"mishkal","׳׳©׳§׳","׳ײ´׳©׳ײ°׳§ײ¸׳","  ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92878,"נְעִילָה","n",NULL,"NE\'ILA","נעילה","נעילה",NULL,"N&ILH","N&ILH",NULL);
INSERT INTO hebrew_morpho VALUES (92879,"נְמִיָּה","n",NULL,"NEMIYA","נמיה","נמיה",NULL,"NMIH","NMIH",NULL);
INSERT INTO hebrew_morpho VALUES (92880,"נְחִירָה","n",NULL,"NEXIRA","נחירה","נחירה","  ","NXIRH","NXIRH",NULL);
INSERT INTO hebrew_morpho VALUES (92881,"נִבְרֶשֶׁת","n",NULL,"NIVRESHET","נברשת","נברשת",NULL,"NBR$T","NBR$T",NULL);
INSERT INTO hebrew_morpho VALUES (92882,"סִימָנִיָּה","n",NULL,"simaniya","סימנייה","סימניה","סימניה","SIMNIH","SIMNIIH",NULL);
INSERT INTO hebrew_morpho VALUES (92883,"סְנָאִי","n",NULL,"sna\'i","סנאי","סנאי",NULL,"SNAI","SNAI",NULL);
INSERT INTO hebrew_morpho VALUES (92884,"ספרנות","n",NULL,"safranut","ספרנות","ספרנות",NULL,"SPRNWT","SPRNWT",NULL);
INSERT INTO hebrew_morpho VALUES (92885,"סִיטוֹנוּת","n",NULL,"sitonut","סיטונות","סיטונות","סִיטוֹנָאוּת","SI@WNWT","SI@WNWT",NULL);
INSERT INTO hebrew_morpho VALUES (92886,"סַבְלָנוּת","n",NULL,"savlanut","סבלנות","סבלנות",NULL,"SBLNWT","SBLNWT",NULL);
INSERT INTO hebrew_morpho VALUES (92887,"סְרִיגָה","n",NULL,"sriga","סריגה","סריגה",NULL,"SRIGH","SRIGH",NULL);
INSERT INTO hebrew_morpho VALUES (92888,"מָצוֹר","n",NULL,"matzor","מצור","מצור",NULL,"MCWR","MCWR",NULL);
INSERT INTO hebrew_morpho VALUES (92889,"מְרִיצָה","n",NULL,"meritza","מריצה","מריצה",NULL,"MRICH","MRICH",NULL);
INSERT INTO hebrew_morpho VALUES (92890,"מַחְשֵׁב","n",NULL,"machshev","מחשב","מחשב",NULL,"MX$B","MX$B",NULL);
INSERT INTO hebrew_morpho VALUES (92891,"מַצְנֵחַ","n",NULL,"matzne\'ach","מצנח","מצנח",NULL,"MCNX","MCNX",NULL);
INSERT INTO hebrew_morpho VALUES (92892,"מַדִּים","n",NULL,"madim","מדים","מדים",NULL,"MDIM","MDIM",NULL);
INSERT INTO hebrew_morpho VALUES (92893,"מוּזֵאוֹן","n",NULL,"muze\'on","מוזיאון","מוזאון",NULL,"MWZAWN","MWZIAWN",NULL);
INSERT INTO hebrew_morpho VALUES (92894,"מְשֻׁלָּשׁ","n",NULL,"meshulash","משולש","משלש",NULL,"M$L$","M$WL$",NULL);
INSERT INTO hebrew_morpho VALUES (92895,"מִקּוּד","n",NULL,"mikud","מיקוד","מקוד",NULL,"MQWD","MIQWD",NULL);
INSERT INTO hebrew_morpho VALUES (92896,"מִכְבָּסָה","n",NULL,"michbasa","מכבסה","מכבסה",NULL,"MKBSH","MKBSH",NULL);
INSERT INTO hebrew_morpho VALUES (92897,"סְנוֹקֶרֶת","n",NULL,"snokeret","סנוקרת","סנוקרת",NULL,"SNWQRT","SNWQRT",NULL);
INSERT INTO hebrew_morpho VALUES (92898,"מַשְׁאֵבָה","n",NULL,"mash\'eva","משאבה","משאבה",NULL,"M$ABH","M$ABH",NULL);
INSERT INTO hebrew_morpho VALUES (92899,"סְטִיָּה","n",NULL,"stiya","סטייה","סטיה","סטיה","S@IH","S@IIH",NULL);
INSERT INTO hebrew_morpho VALUES (92900,"סִפְרוּתִי","a","סיפרותי","sifruti","ספרותי","ספרותי",NULL,"SPRWTI","SPRWTI",NULL);
INSERT INTO hebrew_morpho VALUES (92901,"שִׁמּוּן","n",NULL,"shimun","שימון","שמון",NULL,"$MWN","$IMWN",NULL);
INSERT INTO hebrew_morpho VALUES (92902,"סִיכָה","n",NULL,"sixa","סיכה","סיכה",NULL,"SIKH","SIKH",NULL);
INSERT INTO hebrew_morpho VALUES (92903,"סַנְדְּלָר","n",NULL,"sandlar","סנדלר","סנדלר",NULL,"SNDLR","SNDLR",NULL);
INSERT INTO hebrew_morpho VALUES (92904,"סְפָרַדִּי","n",NULL,"sfaradi","ספרדי","ספרדי",NULL,"SPRDI","SPRDI","male");
INSERT INTO hebrew_morpho VALUES (92905,"סְפִירָה","n",NULL,"sfira",NULL,"ספירה",NULL,"SPIRH","SPIRH",NULL);
INSERT INTO hebrew_morpho VALUES (92906,"סֶרֶן","n",NULL,"seren","סרן","סרן",NULL,"SRN","SRN",NULL);
INSERT INTO hebrew_morpho VALUES (92907,"צִיר","n",NULL,"tsir","ציר","ציר",NULL,"CIR","CIR",NULL);
INSERT INTO hebrew_morpho VALUES (92908,"מְרֻצָּף","a",NULL,"merutsaf","מרוצף","מרצף",NULL,"MRCP","MRWCP",NULL);
INSERT INTO hebrew_morpho VALUES (92909,"סָלוּל","a",NULL,"salul","סלול","סלול",NULL,"SLWL","SLWL",NULL);
INSERT INTO hebrew_morpho VALUES (92910,"נֶעֱדָר","a",NULL,"ne\'edar","נעדר","נעדר",NULL,"N&DR","N&DR",NULL);
INSERT INTO hebrew_morpho VALUES (92911,"סֻלָּם","n",NULL,"sulam","סולם","סלם",NULL,"SLM","SWLM",NULL);
INSERT INTO hebrew_morpho VALUES (92912,"סְיָח","n",NULL,"syax",NULL,"סיח",NULL,"SIX","SIIX",NULL);
INSERT INTO hebrew_morpho VALUES (92913,"סְנַפִּיר","n",NULL,"snapir","סנפיר","סנפיר",NULL,"SNPIR","SNPIR",NULL);
INSERT INTO hebrew_morpho VALUES (92914,"סֵמֶל","n",NULL,"semel",NULL,"סמל",NULL,"SML","SML",NULL);
INSERT INTO hebrew_morpho VALUES (92915,"סַרְטָנִי","a",NULL,"sartani","סרטני","סרטני",NULL,"SR@NI","SR@NI",NULL);
INSERT INTO hebrew_morpho VALUES (92916,"מִטְרִיָּה-אֲוִירִית","n",NULL,"mitriya-avirit","מטרייה-אווירית","מטריה-אוירית","  ","M@RIH-AWIRIT","M@RIIH-AWWIRIT",NULL);
INSERT INTO hebrew_morpho VALUES (92917,"גֵּא","a",NULL,"ge","גא","גא","  ","GA","GA",NULL);
INSERT INTO hebrew_morpho VALUES (92918,"גְּרֶפְּץ","n",NULL,"greptz","גרפץ","גרפץ","  ","GRPC","GRPC",NULL);
INSERT INTO hebrew_morpho VALUES (92919,"כְּרִיתוּת","n",NULL,"kritut","כריתות","כריתות","  ","KRITWT","KRITWT",NULL);
INSERT INTO hebrew_morpho VALUES (92920,"בּוֹקְס","n",NULL,"boks","בוקס","בוקס","  ","BWQS","BWQS",NULL);
INSERT INTO hebrew_morpho VALUES (92921,"סִיטוֹנָאוּת","n",NULL,"sitona\'ut","סיטונאות","סיטונאות","  ","SI@WNAWT","SI@WNAWT",NULL);
INSERT INTO hebrew_morpho VALUES (92922,"סְטִיָּה-מִינִית","n",NULL,"stiya minit","סטייה מינית","סטיה-מינית","  ","S@IH-MINIT","S@IIHMINIT",NULL);
INSERT INTO hebrew_morpho VALUES (92923,"צוּרָה","n",NULL,"tsura","צורה","צורה","  ","CWRH","CWRH",NULL);
INSERT INTO hebrew_morpho VALUES (92924,"דֶּרֶךְ","n",NULL,"derex","דרך","דרך","  ","DRK","DRK",NULL);
INSERT INTO hebrew_morpho VALUES (92925,"אֹרֶך-רוּחַ","n",NULL,"orex ru\'ax","אורך-רוח","ארך-רוח","  ","ARK-RWX","AWRK-RWX",NULL);
INSERT INTO hebrew_morpho VALUES (92926,"סִגְנוֹנִי","a",NULL,"signoni","סגנוני","סגנוני","  ","SGNWNI","SGNWNI",NULL);
INSERT INTO hebrew_morpho VALUES (92927,"סָרוּק","a",NULL,"saruk","סרוק","סרוק","  ","SRWQ","SRWQ",NULL);
INSERT INTO hebrew_morpho VALUES (92928,"מְסֹרָק","a",NULL,"mesorak","מסורק","מסרק","  ","MSRQ","MSWRQ",NULL);
INSERT INTO hebrew_morpho VALUES (92929,"הַשְׁלָמָה","n",NULL,"hashlama","השלמה","השלמה","  ","H$LMH","H$LMH",NULL);
INSERT INTO hebrew_morpho VALUES (92930,"הַשְׁלָמָה","n",NULL,"hashlama","השלמה","השלמה","  ","H$LMH","H$LMH",NULL);
INSERT INTO hebrew_morpho VALUES (92931,"סִיּוּם","n",NULL,"siyum","סיום","סיום","  ","SIWM","SIWM",NULL);
INSERT INTO hebrew_morpho VALUES (92932,"סִחְרוּר","n",NULL,"sixrur","סחרור","סחרור","  ","SXRWR","SXRWR",NULL);
INSERT INTO hebrew_morpho VALUES (92933,"מַהְפֵּכָה","n",NULL,"mahapexa","מהפכה","מהפכה","  ","MHPKH","MHPKH",NULL);
INSERT INTO hebrew_morpho VALUES (92934,"סִיבוּב","n",NULL,"sivuv","סיבוב","סיבוב","  ","SIBWB","SIBWB",NULL);
INSERT INTO hebrew_morpho VALUES (92935,"סוֹלִיטֶר","n",NULL,"soliter","סוליטר","סוליטר","  ","SWLI@R","SWLI@R",NULL);
INSERT INTO hebrew_morpho VALUES (92936,"סִיּוּף","n",NULL,"siyuf","סיוף","סיוף","  ","SIWP","SIWP",NULL);
INSERT INTO hebrew_morpho VALUES (92937,"סַכָּנָה","n",NULL,"sakana","סכנה","סכנה","  ","SKNH","SKNH",NULL);
INSERT INTO hebrew_morpho VALUES (92938,"סוֹכֵךְ","n",NULL,"soxex","סוכך","סוכך","  ","SWKK","SWKK",NULL);
INSERT INTO hebrew_morpho VALUES (92939,"גַּגּוֹן","n",NULL,"gagon","גגון","גגון","  ","GGWN","GGWN",NULL);
INSERT INTO hebrew_morpho VALUES (92940,"תַּעֲלוּל","n",NULL,"ta\'alul","תעלול","תעלול","  ","T&LWL","T&LWL",NULL);
INSERT INTO hebrew_morpho VALUES (92941,"מַעֲשֵׂה-קֻנְדָּס","n",NULL,"ma\'asseh kundas","מעשה-קונדס","מעשה-קנדס","  ","M&$H-QNDS","M&$H-QWNDS",NULL);
INSERT INTO hebrew_morpho VALUES (92942,"סוּסָה","n",NULL,"susa","סוסה","סוסה","  ","SWSH","SWSH",NULL);
INSERT INTO hebrew_morpho VALUES (92943,"סֶרֶט","n",NULL,"seret","סרט","סרט","  ","SR@","SR@",NULL);
INSERT INTO hebrew_morpho VALUES (92944,"סֶרֶט-צִלּוּם","n",NULL,"seret tsilum","סרט-צילום","סרט-צלום","  ","SR@-CLWM","SR@-CILWM",NULL);
INSERT INTO hebrew_morpho VALUES (92945,"נַחַר","n",NULL,"NAXAR","נחר","נחר","  ","NXR","NXR",NULL);
INSERT INTO hebrew_morpho VALUES (92946,"נַחֲרָה","n",NULL,"NAXARA","נחרה","נחרה","  ","NXRH","NXRH",NULL);
INSERT INTO hebrew_morpho VALUES (92947,"לוּסְטְרָה","n",NULL,"LUSTRA","לוסטרה","לוסטרה","  ","LWS@RH","LWS@RH",NULL);
INSERT INTO hebrew_morpho VALUES (92948,"קוֹלְנוֹעַ","n",NULL,"kolno\'a","קולנוע","קולנוע","  ","QWLNW&","QWLNW&",NULL);
INSERT INTO hebrew_morpho VALUES (92949,"נַטּוּף","n",NULL,"NATUF","נטוף","נטוף","  ","N@WP","N@WP",NULL);
INSERT INTO hebrew_morpho VALUES (92950,"נָטִיף","n",NULL,"NTIF","נטיף","נטיף","  ","N@IP","N@IP",NULL);
INSERT INTO hebrew_morpho VALUES (92951,"סְטָלַקְטִיט","n","סטאלקטיט; סטאלאקטיט; סטלאקטיט","STALAKTIT","סטלקטיט","סטלקטיט","  ","S@LQ@I@","S@LQ@I@",NULL);
INSERT INTO hebrew_morpho VALUES (92952,"סֶרֶט-קוֹלְנוֹעַ","n",NULL,"seret kolno\'a","סרט-קולנוע","סרט-קולנוע","  ","SR@-QWLNW&","SR@-QWLNW&",NULL);
INSERT INTO hebrew_morpho VALUES (92953,"מֶדַלְיָה","n",NULL,"medalia","מדליה","מדליה","  ","MDLIH","MDLIH",NULL);
INSERT INTO hebrew_morpho VALUES (92954,"נְקֻדָּה_עֶשְׂרוֹנִית","n",NULL,"NEKUDA_ESRONIT","נקודה_עשרונית","נקדה_עשרונית","  ","NQDH_&$RWNIT","NQWDH_&$RWNIT",NULL);
INSERT INTO hebrew_morpho VALUES (92955,"נְקֻדָּה","n",NULL,"NEKUDA","נקודה","נקדה",NULL,"NQDH","NQWDH",NULL);
INSERT INTO hebrew_morpho VALUES (92956,"סָרִיג","n",NULL,"sarig","סריג","סריג","  ","SRIG","SRIG",NULL);
INSERT INTO hebrew_morpho VALUES (92957,"שַׁלִּיט","n",NULL,"shalit","שליט","שליט",NULL,"$LI@","$LI@","male");
INSERT INTO hebrew_morpho VALUES (92958,"סַרְגֵּל","n",NULL,"sargel","סרגל","סרגל","  ","SRGL","SRGL",NULL);
INSERT INTO hebrew_morpho VALUES (92959,"עֶזְרָה","n",NULL,"ezra","עזרה","עזרה","  ","&ZRH","&ZRH",NULL);
INSERT INTO hebrew_morpho VALUES (92960,"עֵזֶר","n",NULL,"ezer","עזר","עזר","  ","&ZR","&ZR",NULL);
INSERT INTO hebrew_morpho VALUES (92961,"סַיֶּרֶת","n",NULL,"sayeret","סיירת","סירת","  ","SIRT","SIIRT",NULL);
INSERT INTO hebrew_morpho VALUES (92962,"סְכוּם","n",NULL,"sxum","סכום","סכום","  ","SKWM","SKWM",NULL);
INSERT INTO hebrew_morpho VALUES (92963,"סָךְ","n",NULL,"sax","סך","סך",NULL,"SK","SK",NULL);
INSERT INTO hebrew_morpho VALUES (92964,"סַנְדָּל","n",NULL,"sandal","סנדל","סנדל","  ","SNDL","SNDL",NULL);
INSERT INTO hebrew_morpho VALUES (92965,"סַפָּה","n",NULL,"sapa","ספה","ספה","  ","SPH","SPH",NULL);
INSERT INTO hebrew_morpho VALUES (92966,"סַד","n",NULL,"sad","סד","סד","  ","SD","SD",NULL);
INSERT INTO hebrew_morpho VALUES (92967,"סָפֵק","n",NULL,"safek","ספק","ספק","  ","SPQ","SPQ",NULL);
INSERT INTO hebrew_morpho VALUES (92968,"סְבִירוּת","n",NULL,"svirut","סבירות","סבירות","  ","SBIRWT","SBIRWT",NULL);
INSERT INTO hebrew_morpho VALUES (92969,"מְסֻבָּךְ","a",NULL,"mesubax","מסובך","מסבך","  ","MSBK","MSWBK",NULL);
INSERT INTO hebrew_morpho VALUES (92970,"סִכּוּי","n",NULL,"sikuy","סיכוי","סכוי","  ","SKWI","SIKWI",NULL);
INSERT INTO hebrew_morpho VALUES (92971,"סוּג","n",NULL,"sug","סוג","סוג","  ","SWG","SWG",NULL);
INSERT INTO hebrew_morpho VALUES (92972,"סוּג","n",NULL,"sug","סוג","סוג","  ","SWG","SWG",NULL);
INSERT INTO hebrew_morpho VALUES (92973,"מִין","n",NULL,"min","מין","מין","  ","MIN","MIN",NULL);
INSERT INTO hebrew_morpho VALUES (92974,"קָטֵגוֹרְיָה","n",NULL,"kategorya","קטגוריה","קטגוריה","  ","Q@GWRIH","Q@GWRIH",NULL);
INSERT INTO hebrew_morpho VALUES (92975,"קְבוּצָה","n",NULL,"kvutsa","קבוצה","קְבוּצָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92976,"סַנְטֵר","n",NULL,"santer","סנטר","סנטר","  ","SN@R","SN@R",NULL);
INSERT INTO hebrew_morpho VALUES (92977,"סְחוּס","n",NULL,"sxus","סחוס","סחוס","  ","SXWS","SXWS",NULL);
INSERT INTO hebrew_morpho VALUES (92978,"הִסְתַּעֲרוּת","n",NULL,"hista\'arut","הסתערות","הסתערות","  ","HST&RWT","HST&RWT",NULL);
INSERT INTO hebrew_morpho VALUES (92979,"עִנְיָן","n",NULL,"inyan","עניין","ענין","  ","&NIN","&NIIN",NULL);
INSERT INTO hebrew_morpho VALUES (92980,"סִפּוּר","n",NULL,"sipur","סיפור","ספור","  ","SPWR","SIPWR",NULL);
INSERT INTO hebrew_morpho VALUES (92981,"נְטִיַּת-הַפֹּעַל","n",NULL,"netiyat hapo\'al","נטיית_הפועל","נטית-הפעל",NULL,"N@IT-HP&L","N@IIT_HPW&L",NULL);
INSERT INTO hebrew_morpho VALUES (92982,"נְטִיּוֹת-הַפֹּעַל","n",NULL,"netiyot hapo\'al","נטיות-הפועל","נטיות-הפעל","  ","N@IWT-HP&L","N@IWT-HPW&L",NULL);
INSERT INTO hebrew_morpho VALUES (92983,"נְטִיַּת-הַשֵּׁם","n",NULL,"netiyat hashem","נטיית-השם","נטית-השם","  ","N@IT-H$M","N@IIT-H$M",NULL);
INSERT INTO hebrew_morpho VALUES (92984,"נְטִיּוֹת-הַשֵּׁם","n",NULL,"netiyot hashem","נטיות-השם","נטיות-השם","  ","N@IWT-H$M","N@IWT-H$M",NULL);
INSERT INTO hebrew_morpho VALUES (92985,"׳ ײ°׳˜ײ´׳™ײ¼ײ¸׳”","n",NULL,"netiya","׳ ׳˜׳™׳™׳”","׳ ײ°׳˜ײ´׳™ײ¼ײ¸׳”","  ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92986,"מִשְׁקָל","n",NULL,"mishkal","משקל","מִשְׁקָל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (92987,"נְטִיָּה","n",NULL,"netiya","נטייה","נטיה","  ","N@IH","N@IIH",NULL);
INSERT INTO hebrew_morpho VALUES (92988,"סַפְקָנוּת","n",NULL,"safkanut","ספקנות","ספקנות","  ","SPQNWT","SPQNWT",NULL);
INSERT INTO hebrew_morpho VALUES (92989,"סְקֶפְּטִיצִיזְם","n",NULL,"skeptitsizm","סקפטיציזם","סקפטיציזם","  ","SQP@ICIZM","SQP@ICIZM",NULL);
INSERT INTO hebrew_morpho VALUES (92990,"סִרָחוֹן","n",NULL,"siraxon","סירחון","סרחון","  ","SRXWN","SIRXWN",NULL);
INSERT INTO hebrew_morpho VALUES (92991,"צַחֲנָה","n",NULL,"tsaxana","צחנה","צחנה","  ","CXNH","CXNH",NULL);
INSERT INTO hebrew_morpho VALUES (92992,"עִפּוּשׁ","n",NULL,"ipush","עיפוש","עפוש","  ","&PW$","&IPW$",NULL);
INSERT INTO hebrew_morpho VALUES (92993,"סֵרָחוֹן","n",NULL,"seraxon","סירחון","סרחון","  ","SRXWN","SIRXWN",NULL);
INSERT INTO hebrew_morpho VALUES (92994,"סִיּוּט","n",NULL,"siyut","סיוט","סיוט","  ","SIW@","SIW@",NULL);
INSERT INTO hebrew_morpho VALUES (92995,"סוֹפִית","n",NULL,"sofit","סופית","סופית","  ","SWPIT","SWPIT",NULL);
INSERT INTO hebrew_morpho VALUES (92996,"סוּפִיקְס","n",NULL,"sufiks","סופיקס","סופיקס","  ","SWPIQS","SWPIQS",NULL);
INSERT INTO hebrew_morpho VALUES (92997,"סִיֹּמֶת","n",NULL,"siyomet","סיומת","סימת","  ","SIMT","SIWMT",NULL);
INSERT INTO hebrew_morpho VALUES (92998,"סִכּוּם","n",NULL,"sikum","סיכום","סכום","  ","SKWM","SIKWM",NULL);
INSERT INTO hebrew_morpho VALUES (92999,"תַּמְצִית","n",NULL,"tamtsit","תמצית","תמצית","  ","TMCIT","TMCIT",NULL);
INSERT INTO hebrew_morpho VALUES (93000,"גַּס-רוּחַ","a",NULL,"gass ru\'ax","גס-רוח","גס-רוח","  ","GS-RWX","GS-RWX",NULL);
INSERT INTO hebrew_morpho VALUES (93001,"נָכוֹן","r",NULL,"NAXON","נכון","נכון","  ","NKWN","NKWN",NULL);
INSERT INTO hebrew_morpho VALUES (93002,"נְכוֹנָה","r",NULL,"NEXONA","נכונה","נכונה","  ","NKWNH","NKWNH",NULL);
INSERT INTO hebrew_morpho VALUES (93003,"נָשִׁיר","a",NULL,"NASHIR","נשיר","נשיר","  ","N$IR","N$IR",NULL);
INSERT INTO hebrew_morpho VALUES (93004,"נָזוּף","a",NULL,"NAZUF","נזוף","נזוף","  ","NZWP","NZWP",NULL);
INSERT INTO hebrew_morpho VALUES (93005,"נָגִיף","n",NULL,"NAGIF","נגיף","נגיף","  ","NGIP","NGIP",NULL);
INSERT INTO hebrew_morpho VALUES (93006,"וִירוּס","n",NULL,"VIRUS","וירוס","וירוס","  ","WIRWS","WIRWS",NULL);
INSERT INTO hebrew_morpho VALUES (93007,"נְבִיטָה","n",NULL,"NEVITA","נביטה","נביטה",NULL,"NBI@H","NBI@H",NULL);
INSERT INTO hebrew_morpho VALUES (93008,"נָתוּן","n",NULL,"NATUN","נתון","נתון",NULL,"NTWN","NTWN",NULL);
INSERT INTO hebrew_morpho VALUES (93009,"נוּל","n",NULL,"NUL","נול","נול",NULL,"NWL","NWL",NULL);
INSERT INTO hebrew_morpho VALUES (93010,"סָלָמִי","n","סאלאמי;סלאמי","SALAMI","סלמי","סלמי",NULL,"SLMI","SLMI",NULL);
INSERT INTO hebrew_morpho VALUES (93011,"נֶכֶד","n",NULL,"NEXED","נכד","נכד",NULL,"NKD","NKD",NULL);
INSERT INTO hebrew_morpho VALUES (93012,"נֶכְדָּה","n",NULL,"NEXDA","נכדה","נכדה",NULL,"NKDH","NKDH",NULL);
INSERT INTO hebrew_morpho VALUES (93013,"נִמְשָׁל","n",NULL,"NIMSHAL","נימשל","נמשל",NULL,"NM$L","NIM$L",NULL);
INSERT INTO hebrew_morpho VALUES (93014,"מוּסַר-הַשְׂכֵּל","n",NULL,"MUSAR-HESKEL","מוסר-השכל","מוסר-השכל",NULL,"MWSR-H$KL","MWSR-H$KL",NULL);
INSERT INTO hebrew_morpho VALUES (93015,"לֶקַח","n",NULL,"LEKAX","לקח","לקח",NULL,"LQX","LQX",NULL);
INSERT INTO hebrew_morpho VALUES (93016,"נָסִיךְ","n",NULL,"NASIX","נסיך","נסיך",NULL,"NSIK","NSIK",NULL);
INSERT INTO hebrew_morpho VALUES (93017,"נֶבֶג","n",NULL,"NEVEG","נבג","נבג",NULL,"NBG","NBG",NULL);
INSERT INTO hebrew_morpho VALUES (93018,"נָזִיר","n",NULL,"NAZIR","נזיר","נזיר",NULL,"NZIR","NZIR",NULL);
INSERT INTO hebrew_morpho VALUES (93019,"נוּן","n",NULL,"NUN","נון","נון",NULL,"NWN","NWN",NULL);
INSERT INTO hebrew_morpho VALUES (93020,"נְזִירָה","n",NULL,"NEZIRA","נזירה","נזירה",NULL,"NZIRH","NZIRH",NULL);
INSERT INTO hebrew_morpho VALUES (93021,"נֶמֶק","n",NULL,"NEMEK","נמק","נמק",NULL,"NMQ","NMQ",NULL);
INSERT INTO hebrew_morpho VALUES (93022,"גַּנְגְּרֶנָה","n",NULL,"GANGRENA","גנגרנה","גנגרנה",NULL,"GNGRNH","GNGRNH",NULL);
INSERT INTO hebrew_morpho VALUES (93023,"נָהַג","v",NULL,"NAHAG","נהג","נהג",NULL,"NHG","NHG",NULL);
INSERT INTO hebrew_morpho VALUES (93024,"נָשַׁף","v",NULL,"NASHAF","נשף","נשף",NULL,"N$P","N$P",NULL);
INSERT INTO hebrew_morpho VALUES (93025,"נָפַח","v",NULL,"NAFAX","נפח","נפח",NULL,"NPX","NPX",NULL);
INSERT INTO hebrew_morpho VALUES (93026,"פְּסוּקִית","n",NULL,"psukit","פסוקית","פסוקית",NULL,"PSWQIT","PSWQIT",NULL);
INSERT INTO hebrew_morpho VALUES (93027,"סְעִיף","n",NULL,"se\'if","סעיף","סעיף",NULL,"S&IP","S&IP",NULL);
INSERT INTO hebrew_morpho VALUES (93028,"רוֹזֵן","n",NULL,"rozen","רוזן","רוזן",NULL,"RWZN","RWZN",NULL);
INSERT INTO hebrew_morpho VALUES (93029,"סִבָּה","n",NULL," sibba","סיבה","סבה",NULL,"SBH","SIBH",NULL);
INSERT INTO hebrew_morpho VALUES (93030,"עִלָּה","n",NULL,"illa","עילה","עלה",NULL,"&LH","&ILH",NULL);
INSERT INTO hebrew_morpho VALUES (93031,"סִין","n",NULL,"sin","סין","סין",NULL,"SIN","SIN",NULL);
INSERT INTO hebrew_morpho VALUES (93032,"סַחְלָב","n",NULL,"saxlav","סחלב","סחלב",NULL,"SXLB","SXLB",NULL);
INSERT INTO hebrew_morpho VALUES (93033,"סִינִית","n",NULL,"sinit","סינית","סינית",NULL,"SINIT","SINIT",NULL);
INSERT INTO hebrew_morpho VALUES (93034,"אוֹרְכִידֵאָה","n",NULL,"orxide\'a","אורכידיאה","אורכידאה",NULL,"AWRKIDAH","AWRKIDIAH",NULL);
INSERT INTO hebrew_morpho VALUES (93035,"סִיסְמָה","n",NULL,"sisma","סיסמה","סיסמה",NULL,"SISMH","SISMH",NULL);
INSERT INTO hebrew_morpho VALUES (93036,"מוֹטוֹ","n",NULL,"moto","מוטו","מוטו",NULL,"MW@W","MW@W",NULL);
INSERT INTO hebrew_morpho VALUES (93037,"סִכְסוּךְ","n",NULL,"sixsux","סכסוך","סכסוך",NULL,"SKSWK","SKSWK",NULL);
INSERT INTO hebrew_morpho VALUES (93038,"דִּין-וּדְבָרִים","n",NULL,"din udvarim","דין-ודברים","דין-ודברים",NULL,"DIN-WDBRIM","DIN-WDBRIM",NULL);
INSERT INTO hebrew_morpho VALUES (93039,"סִיֵּד","v",NULL,"siyed","סייד","סיד",NULL,"SID","SIID",NULL);
INSERT INTO hebrew_morpho VALUES (93040,"סְתָו","n",NULL,"stav","סתיו","סתו",NULL,"STW","STIW",NULL);
INSERT INTO hebrew_morpho VALUES (93041,"תְּקוּפַת-תִּשְׁרֵי","n",NULL,"tkufat tishrey","תקופת-תשרי","תקופת-תשרי",NULL,"TQWPT-T$RI","TQWPT-T$RI",NULL);
INSERT INTO hebrew_morpho VALUES (93042,"סָלָט","n",NULL,"salat","סלט","סלט",NULL,"SL@","SL@",NULL);
INSERT INTO hebrew_morpho VALUES (93043,"סָלַט-יְרָקוֹת","n",NULL,"salat yerakot","סלט-ירקות","סלט-ירקות",NULL,"SL@-IRQWT","SL@-IRQWT",NULL);
INSERT INTO hebrew_morpho VALUES (93044,"סֻבִּין","n",NULL,"subbin","סובין","סבין",NULL,"SBIN","SWBIN",NULL);
INSERT INTO hebrew_morpho VALUES (93045,"סֻכָּר","n",NULL,"sukkar","סוכר","סכר",NULL,"SKR","SWKR",NULL);
INSERT INTO hebrew_morpho VALUES (93046,"סֻכָּרִים","n",NULL,"sukkarim","סוכרים","סכרים",NULL,"SKRIM","SWKRIM",NULL);
INSERT INTO hebrew_morpho VALUES (93047,"סֵרוּב","n",NULL,"seruv","סירוב","סרוב",NULL,"SRWB","SIRWB",NULL);
INSERT INTO hebrew_morpho VALUES (93048,"מֵאוּן","n",NULL,"me\'un","מיאון","מאון",NULL,"MAWN","MIAWN",NULL);
INSERT INTO hebrew_morpho VALUES (93049,"סַרְסוּר","n",NULL,"sarsur","סרסור","סרסור",NULL,"SRSWR","SRSWR",NULL);
INSERT INTO hebrew_morpho VALUES (93050,"סוֹלְלָה","n",NULL,"solela","סוללה","סוללה",NULL,"SWLLH","SWLLH",NULL);
INSERT INTO hebrew_morpho VALUES (93051,"סוֹף","n",NULL,"sof","סוף","סוף",NULL,"SWP","SWP",NULL);
INSERT INTO hebrew_morpho VALUES (93052,"פִינָלֶה","n",NULL,"finale","פינאלה","פינלה",NULL,"PINLH","PINALH",NULL);
INSERT INTO hebrew_morpho VALUES (93053,"סִיטוֹנַאי","n",NULL,"sitonay","סיטונאי","סיטונאי",NULL,"SI@WNAI","SI@WNAI",NULL);
INSERT INTO hebrew_morpho VALUES (93054,"סָבָה","n",NULL,"sava","סבה","סבה",NULL,"SBH","SBH",NULL);
INSERT INTO hebrew_morpho VALUES (93055,"סָבָא","n",NULL,"sava","סבא","סבא",NULL,"SBA","SBA",NULL);
INSERT INTO hebrew_morpho VALUES (93056,"סַבָּא","n",NULL,"sabba","סבא","סבא",NULL,"SBA","SBA",NULL);
INSERT INTO hebrew_morpho VALUES (93057,"סָב","n",NULL,"sav","סב","סב",NULL,"SB","SB",NULL);
INSERT INTO hebrew_morpho VALUES (93058,"סִפְרָה-עֶשְׂרוֹנִית","n",NULL,"sifra esronit","ספרה-עשרונית","ספרה-עשרונית",NULL,"SPRH-&$RWNIT","SPRH-&$RWNIT",NULL);
INSERT INTO hebrew_morpho VALUES (93059,"סִפְרָה","n",NULL,"sifra","ספרה","ספרה",NULL,"SPRH","SPRH",NULL);
INSERT INTO hebrew_morpho VALUES (93060,"סֶגֶן","n",NULL,"segen","סגן","סגן",NULL,"SGN","SGN",NULL);
INSERT INTO hebrew_morpho VALUES (93061,"סֵרֵב","v",NULL,"serev","סירב","סרב",NULL,"SRB","SIRB",NULL);
INSERT INTO hebrew_morpho VALUES (93062,"מֵאֵן","v",NULL,"me\'en","מיאן","מאן",NULL,"MAN","MIAN",NULL);
INSERT INTO hebrew_morpho VALUES (93063,"סֻכֶּרֶת","n",NULL,"sukkeret","סוכרת","סכרת",NULL,"SKRT","SWKRT",NULL);
INSERT INTO hebrew_morpho VALUES (93064,"דִּיאָבֶּטִיס","n",NULL,"di\'abetis","דיאבטיס","דיאבטיס",NULL,"DIAB@IS","DIAB@IS",NULL);
INSERT INTO hebrew_morpho VALUES (93065,"נָכוּת","n",NULL,"NAXUT","נכות","נכות",NULL,"NKWT","NKWT",NULL);
INSERT INTO hebrew_morpho VALUES (93066,"מֻגְבָּלוּת","n",NULL,"MUGBALUT","מוגבלות","מגבלות",NULL,"MGBLWT","MWGBLWT",NULL);
INSERT INTO hebrew_morpho VALUES (93067,"נוֹשֶׁה","n",NULL,"NOSHE","נושה","נושה",NULL,"NW$H","NW$H",NULL);
INSERT INTO hebrew_morpho VALUES (93068,"תָּמָר","n",NULL,"TAMAr","תמר","תמר",NULL,"TMR","TMR",NULL);
INSERT INTO hebrew_morpho VALUES (93069,"נְסִיכָה","n",NULL,"NESIXA","נסיכה","נסיכה",NULL,"NSIKH","NSIKH",NULL);
INSERT INTO hebrew_morpho VALUES (93070,"בַּת-מֶלֶךְ","n",NULL,"bat-melech","בת-מלך","בת-מלך",NULL,"BT-MLK","BT-MLK",NULL);
INSERT INTO hebrew_morpho VALUES (93071,"בֶּן-מֶלֶךְ","n",NULL,"BEN_MELEX","בן-מלך","בן-מלך",NULL,"BN-MLK","BN-MLK",NULL);
INSERT INTO hebrew_morpho VALUES (93072,"נָבַט","v",NULL,"NAVAT","נבט","נבט",NULL,"NB@","NB@",NULL);
INSERT INTO hebrew_morpho VALUES (93073,"מַעֲגָן","n",NULL,"MA\'AGAN","מעגן","מעגן",NULL,"M&GN","M&GN",NULL);
INSERT INTO hebrew_morpho VALUES (93074,"סִיגְנָל","n",NULL,"signal","סיגנל","סיגנל",NULL,"SIGNL","SIGNL",NULL);
INSERT INTO hebrew_morpho VALUES (93075,"סִידָן","n",NULL,"sidan","סידן","סידן",NULL,"SIDN","SIDN",NULL);
INSERT INTO hebrew_morpho VALUES (93076,"בַּעַל-חוֹב","n",NULL,"BA\'AL-XOV","בעל-חוב","בעל-חוב",NULL,"B&L-XWB","B&L-XWB",NULL);
INSERT INTO hebrew_morpho VALUES (93077,"סִפֵּק","v",NULL,"sippek","סיפק","ספק",NULL,"SPQ","SIPQ",NULL);
INSERT INTO hebrew_morpho VALUES (93078,"סִיּוּר","n",NULL,"siyur","סיור","סיור"," סיור ","SIWR","SIWR",NULL);
INSERT INTO hebrew_morpho VALUES (93079,"סִכֵּם","v",NULL,"sikkem","סיכם","סכם",NULL,"SKM","SIKM",NULL);
INSERT INTO hebrew_morpho VALUES (93080,"סְעָרָה","n",NULL,"se\'ara","סערה","סערה",NULL,"S&RH","S&RH",NULL);
INSERT INTO hebrew_morpho VALUES (93081,"סוּפָה","n",NULL,"sufa","סופה","סופה",NULL,"SWPH","SWPH",NULL);
INSERT INTO hebrew_morpho VALUES (93082,"מְחַבֶּרֶת","n",NULL,"mexaberet","מחברת","מחברת",NULL,"MXBRT","MXBRT",NULL);
INSERT INTO hebrew_morpho VALUES (93083,"סוֹפֶרֶת","n",NULL,"soferet","סופרת","סופרת",NULL,"SWPRT","SWPRT",NULL);
INSERT INTO hebrew_morpho VALUES (93084,"סָרִיס","n",NULL,"saris","סריס","סריס",NULL,"SRIS","SRIS",NULL);
INSERT INTO hebrew_morpho VALUES (93085,"לוֹיָאלִי","a",NULL,"LOYALI","לויאלי","לויאלי",NULL,"LWIALI","LWIALI",NULL);
INSERT INTO hebrew_morpho VALUES (93086,"סְחִיפָה","n",NULL,"sxifa","סחיפה","סחיפה",NULL,"SXIPH","SXIPH",NULL);
INSERT INTO hebrew_morpho VALUES (93087,"אֶרוֹזְיָה","n",NULL,"erozia","ארוזיה","ארוזיה",NULL,"ARWZIH","ARWZIH",NULL);
INSERT INTO hebrew_morpho VALUES (93088,"שְׁחִיקָה","n",NULL,"shxika","שחיקה","שחיקה",NULL,"$XIQH","$XIQH",NULL);
INSERT INTO hebrew_morpho VALUES (93089,"סָמַךְ","v",NULL,"samax","סמך","סמך",NULL,"SMK","SMK",NULL);
INSERT INTO hebrew_morpho VALUES (93090,"סָחַט","v",NULL,"saxat","סחט","סחט",NULL,"SX@","SX@",NULL);
INSERT INTO hebrew_morpho VALUES (93091,"סִיב","n",NULL,"siv","סיב","סיב",NULL,"SIB","SIB",NULL);
INSERT INTO hebrew_morpho VALUES (93092,"עָרְלָה","n",NULL,"orla","ערלה","ערלה",NULL,"&RLH","&RLH",NULL);
INSERT INTO hebrew_morpho VALUES (93093,"עִסּוּי","n",NULL,"isuy","עיסוי","עסוי",NULL,"&SWI","&ISWI",NULL);
INSERT INTO hebrew_morpho VALUES (93094,"מָסָז\'","n",NULL,NULL,"מסז\'","מסז\'",NULL,"MSZ\'","MSZ\'",NULL);
INSERT INTO hebrew_morpho VALUES (93095,"נָחַר","v",NULL,"NAXAR","נחר","נחר",NULL,"NXR","NXR",NULL);
INSERT INTO hebrew_morpho VALUES (93096,"נֶעֱלַם","v",NULL,"NE\'ELAM","נעלם","נעלם",NULL,"N&LM","N&LM",NULL);
INSERT INTO hebrew_morpho VALUES (93097,"נֶעֱלַם-מֵהָעַיִן","v",NULL,"NE\'ELAM-MEHA\'AIN","נעלם-מהעין","נעלם-מהעין",NULL,"N&LM-MH&IN","N&LM-MH&IN",NULL);
INSERT INTO hebrew_morpho VALUES (93098,"נָגוֹז","v",NULL,"NAGOZ","נגוז","נגוז",NULL,"NGWZ","NGWZ",NULL);
INSERT INTO hebrew_morpho VALUES (93099,"אָבַד","v",NULL,"AVAD","אבד","אבד",NULL,"ABD","ABD",NULL);
INSERT INTO hebrew_morpho VALUES (93100,"הָלַךְ-לְאִבּוּד","v",NULL,"HALAX-LE\'IBUD","הלך-לאיבוד","הלך-לאבוד",NULL,"HLK-LABWD","HLK-LAIBWD",NULL);
INSERT INTO hebrew_morpho VALUES (93101,"פִּצּוּיִים","n",NULL,"PITSU\'IM","פצויים","פצויים",NULL,"PCWIIM","PCWIIM",NULL);
INSERT INTO hebrew_morpho VALUES (93102,"שִׁפּוּי","n",NULL,"SHIPU\'I","שיפוי","שפוי",NULL,"$PWI","$IPWI",NULL);
INSERT INTO hebrew_morpho VALUES (93103,"נִצָּב","n",NULL,"NITSAV","ניצב","נצב",NULL,"NCB","NICB",NULL);
INSERT INTO hebrew_morpho VALUES (93104,"סְטָטִיסְט","n",NULL,"STATIST","סטטיסט","סטטיסט",NULL,"S@@IS@","S@@IS@",NULL);
INSERT INTO hebrew_morpho VALUES (93105,"נוֹגְדָן","n",NULL,"NOGDAN","נוגדן","נוגדן",NULL,"NWGDN","NWGDN",NULL);
INSERT INTO hebrew_morpho VALUES (93106,"הַחֶבְרָה-הַגְּבוֹהָה","n",NULL,"hachevra-hagvoha","החברה-הגבוהה","החברה-הגבוהה",NULL,"HXBRH-HGBWHH","HXBRH-HGBWHH",NULL);
INSERT INTO hebrew_morpho VALUES (93107,"הַי-סוֹסָיֶטִי","n",NULL,"hay-sosayeti","הי-סוסיטי","הי-סוסיטי",NULL,"HI-SWSI@I","HI-SWSI@I",NULL);
INSERT INTO hebrew_morpho VALUES (93108,"עִדְכּוּן","n",NULL,"idkun","עדכון","עדכון",NULL,"&DKWN","&DKWN",NULL);
INSERT INTO hebrew_morpho VALUES (93109,"עֵירֹם","a",NULL,"erom","עירום","עירם",NULL,"&IRM","&IRWM",NULL);
INSERT INTO hebrew_morpho VALUES (93110,"עָרוּם","a",NULL,"arum","ערום","ערום",NULL,"&RWM","&RWM",NULL);
INSERT INTO hebrew_morpho VALUES (93111,"בִּלְבוּשׁ-חַוָּה","a",NULL,"bilvush xava","בלבוש-חוה","בלבוש-חוה",NULL,"BLBW$-XWH","BLBW$-XWH",NULL);
INSERT INTO hebrew_morpho VALUES (93112,"מְעֻרְטָל","a",NULL,"me\'urtal","מערטל","מערטל"," מעורטל ","M&R@L","M&R@L",NULL);
INSERT INTO hebrew_morpho VALUES (93113,"עַרְמוּמִי","a",NULL,"armumi","ערמומי","ערמומי",NULL,"&RMWMI","&RMWMI",NULL);
INSERT INTO hebrew_morpho VALUES (93114,"תַּחְבְּלָן","a",NULL,"taxbelan","תחבלן","תחבלן",NULL,"TXBLN","TXBLN",NULL);
INSERT INTO hebrew_morpho VALUES (93115,"עַצְלָן","a",NULL,"atzlan","עצלן","עצלן",NULL,"&CLN","&CLN",NULL);
INSERT INTO hebrew_morpho VALUES (93116,"עוֹנָתִי","a",NULL,"onati","עונתי","עונתי",NULL,"&WNTI","&WNTI",NULL);
INSERT INTO hebrew_morpho VALUES (93117,"כְּשׁוּת","n",NULL,"KSHUT","כשות","כשות",NULL,"K$WT","K$WT",NULL);
INSERT INTO hebrew_morpho VALUES (93118,"עֻבָּר","n",NULL,"ubbar","עובר","עבר",NULL,"&BR","&WBR",NULL);
INSERT INTO hebrew_morpho VALUES (93119,"נִכְנַס","v",NULL,"NIXNAS","נכנס","נכנס",NULL,"NKNS","NKNS",NULL);
INSERT INTO hebrew_morpho VALUES (93120,"הִתְנַגֵּשׁ","v",NULL,"hitnagesh","התנגש","התנגש",NULL,"HTNG$","HTNG$",NULL);
INSERT INTO hebrew_morpho VALUES (93121,"נִתְקַל","v",NULL,"nitkal","נתקל","נתקל",NULL,"NTQL","NTQL",NULL);
INSERT INTO hebrew_morpho VALUES (93122,"קָאוֹלִין","n",NULL,"kaolin","קאולין","קאולין",NULL,"QAWLIN","QAWLIN",NULL);
INSERT INTO hebrew_morpho VALUES (93123,"עִטּוּר","n",NULL,"ittur","עיטור","עטור",NULL,"&@WR","&I@WR",NULL);
INSERT INTO hebrew_morpho VALUES (93124,"קִשּׁוּט","n",NULL,"kishut","קישוט","קשוט",NULL,"Q$W@","QI$W@",NULL);
INSERT INTO hebrew_morpho VALUES (93125,"אוֹרְנָמֶנְט","n",NULL,"ornament","אורנמנט","אורנמנט",NULL,"AWRNMN@","AWRNMN@",NULL);
INSERT INTO hebrew_morpho VALUES (93126,"דֶּקוֹרַצְיָה","n",NULL,"dekoratsia","דקורציה","דקורציה",NULL,"DQWRCIH","DQWRCIH",NULL);
INSERT INTO hebrew_morpho VALUES (93127,"עִיּוּר","n",NULL,"iyur","עיור","עיור",NULL,"&IWR","&IWR",NULL);
INSERT INTO hebrew_morpho VALUES (93128,"אוּרְבָּנִיזַצְיָה","n",NULL,"urbanizatsia","אורבניזציה","אורבניזציה",NULL,"AWRBNIZCIH","AWRBNIZCIH",NULL);
INSERT INTO hebrew_morpho VALUES (93129,"עַיִן","n",NULL,"ayin","עין","עין",NULL,"&IN","&IN",NULL);
INSERT INTO hebrew_morpho VALUES (93130,"מַחֲנֶה","n",NULL,"machane","מחנה","מחנה",NULL,"MXNH","MXNH",NULL);
INSERT INTO hebrew_morpho VALUES (93131,"עוֹרֵב-שָׁחֹר","n",NULL,"orev shaxor","עורב-שחור","עורב-שחר",NULL,"&WRB-$XR","&WRB-$XWR",NULL);
INSERT INTO hebrew_morpho VALUES (93132,"עִרְעוּר","n",NULL,"ir\'ur","ערעור","ערעור",NULL,"&R&WR","&R&WR",NULL);
INSERT INTO hebrew_morpho VALUES (93133,"עֲרָר","n",NULL,"arar","ערר","ערר",NULL,"&RR","&RR",NULL);
INSERT INTO hebrew_morpho VALUES (93134,"עַרְמוֹנִי","a",NULL,"armoni","ערמוני","ערמוני",NULL,"&RMWNI","&RMWNI",NULL);
INSERT INTO hebrew_morpho VALUES (93135,"בָּסִיס-צְבָאִי","n",NULL,"basis-tzva\'ee","בסיס-צבאי","בסיס-צבאי",NULL,"BSIS-CBAI","BSIS-CBAI",NULL);
INSERT INTO hebrew_morpho VALUES (93136,"מַעֲלֶה","n",NULL,"ma\'aleh","מעלה","מעלה",NULL,"M&LH","M&LH",NULL);
INSERT INTO hebrew_morpho VALUES (93137,"עֲלִיַּת-גַּג","n",NULL,"aliyat-gag","עלית-גג","עלית-גג",NULL,"&LIT-GG","&LIT-GG",NULL);
INSERT INTO hebrew_morpho VALUES (93138,"עֲלִיַּת_גַּג","n",NULL,NULL,"עלית_גג","עלית_גג",NULL,"&LIT_GG","&LIT_GG",NULL);
INSERT INTO hebrew_morpho VALUES (93139,"פָּרָפִין","n",NULL,"PRAFIN","פרפין","פרפין",NULL,"PRPIN","PRPIN",NULL);
INSERT INTO hebrew_morpho VALUES (93140,"גֶ\'נְדֶר","n",NULL,"jender","ג\'נדר","ג\'נדר",NULL,"G\'NDR","G\'NDR",NULL);
INSERT INTO hebrew_morpho VALUES (93141,"מִגְדָּר","n",NULL,"migdar","מגדר","מגדר",NULL,"MGDR","MGDR",NULL);
INSERT INTO hebrew_morpho VALUES (93142,"עֲלִיָּה","n",NULL,"aliyah","עלייה","עליה",NULL,"&LIH","&LIIH",NULL);
INSERT INTO hebrew_morpho VALUES (93143,"הִתְמָרְדוּת","n",NULL,"hitmardut","התמרדות","התמרדות",NULL,"HTMRDWT","HTMRDWT",NULL);
INSERT INTO hebrew_morpho VALUES (93144,"מְרִידָה","n",NULL,"merida","מרידה","מרידה",NULL,"MRIDH","MRIDH",NULL);
INSERT INTO hebrew_morpho VALUES (93145,"מֶרֶד","n",NULL,"mered","מרד","מרד",NULL,"MRD","MRD",NULL);
INSERT INTO hebrew_morpho VALUES (93146,"הִתְקוֹמְמוּת","n",NULL,"hitkomemut","התקוממות","התקוממות",NULL,"HTQWMMWT","HTQWMMWT",NULL);
INSERT INTO hebrew_morpho VALUES (93147,"מֶרִי","n",NULL,"meri","מרי","מרי",NULL,"MRI","MRI",NULL);
INSERT INTO hebrew_morpho VALUES (93148,"דּוֹבְרָה","n",NULL,"dovra","דוברה","דוברה",NULL,"DWBRH","DWBRH",NULL);
INSERT INTO hebrew_morpho VALUES (93149,"יָצִיעַ","n",NULL,"yatzi\'aa","יציע","יציע",NULL,"ICI&","ICI&",NULL);
INSERT INTO hebrew_morpho VALUES (93150,"גָּרָז\'","n",NULL,"garaj","גרז\'","גרז\'",NULL,"GRZ\'","GRZ\'",NULL);
INSERT INTO hebrew_morpho VALUES (93151,"קֶרוֹסִין","n",NULL,"KEROSIN","קרוסין","קרוסין",NULL,"QRWSIN","QRWSIN",NULL);
INSERT INTO hebrew_morpho VALUES (93152,"נֵפְט","n",NULL,"NEFT","נפט","נפט",NULL,"NP@","NP@",NULL);
INSERT INTO hebrew_morpho VALUES (93153,"שֶׁמֶן-אֲדָמָה","n",NULL,"SHEMEN-ADAMA","שמן-אדמה","שמן-אדמה",NULL,"$MN-ADMH","$MN-ADMH",NULL);
INSERT INTO hebrew_morpho VALUES (93154,"הַזָּהָב-הַשָּׁחֹר","n",NULL,"HAZAHAV-HASHAXOR","הזהב-השחור","הזהב-השחר",NULL,"HZHB-H$XR","HZHB-H$XWR",NULL);
INSERT INTO hebrew_morpho VALUES (93155,"נֶצַח","n",NULL,"NETSAX","נצח","נצח"," נֵצַח ","NCX","NCX",NULL);
INSERT INTO hebrew_morpho VALUES (93156,"עַד","n",NULL,"AD","עד","עד",NULL,"&D","&D",NULL);
INSERT INTO hebrew_morpho VALUES (93157,"מְכֻתָּר","a",NULL,"MEXUTAR","מכותר","מכתר",NULL,"MKTR","MKWTR",NULL);
INSERT INTO hebrew_morpho VALUES (93158,"נַנָּסִי","a",NULL,"NANASI","ננסי","ננסי",NULL,"NNSI","NNSI",NULL);
INSERT INTO hebrew_morpho VALUES (93159,"גַּמָּדִי","a",NULL,"GAMADI","גמדי","גמדי",NULL,"GMDI","GMDI",NULL);
INSERT INTO hebrew_morpho VALUES (93160,"מַגְרֵסָה","n",NULL,"magresa","מגרסה","מגרסה",NULL,"MGRSH","MGRSH",NULL);
INSERT INTO hebrew_morpho VALUES (93161,"מִפְקַד-אֻכְלוּסִין","n",NULL,"mifkad-uchlusin","מיפקד-אוכלוסין","מפקד-אכלוסין",NULL,"MPQD-AKLWSIN","MIPQD-AWKLWSIN",NULL);
INSERT INTO hebrew_morpho VALUES (93162,"מִזְרוֹן","n",NULL,"mizron","מזרון","מזרון",NULL,"MZRWN","MZRWN",NULL);
INSERT INTO hebrew_morpho VALUES (93163,"מַעְדֵּר","n",NULL,"ma\'ader","מעדר","מעדר",NULL,"M&DR","M&DR",NULL);
INSERT INTO hebrew_morpho VALUES (93164,"מַקְפִּיא","n",NULL,"makpi","מקפיא","מקפיא",NULL,"MQPIA","MQPIA",NULL);
INSERT INTO hebrew_morpho VALUES (93165,"מַקְפֵּא","n",NULL,"makpe","מקפא","מקפא",NULL,"MQPA","MQPA",NULL);
INSERT INTO hebrew_morpho VALUES (93166,"דִּיפּ-פְרִיז","n",NULL,"dip-friz","דיפ-פריז","דיפ-פריז",NULL,"DIP-PRIZ","DIP-PRIZ",NULL);
INSERT INTO hebrew_morpho VALUES (93167,"מֵצַח","n",NULL,"metzach","מצח","מצח",NULL,"MCX","MCX",NULL);
INSERT INTO hebrew_morpho VALUES (93168,"מַגְנֵט","n",NULL,"magnet","מגנט","מגנט",NULL,"MGN@","MGN@",NULL);
INSERT INTO hebrew_morpho VALUES (93169,"מְטוּטֶלֶת","n",NULL,"metutelet","מטוטלת","מטוטלת",NULL,"M@W@LT","M@W@LT",NULL);
INSERT INTO hebrew_morpho VALUES (93170,"מַקְצוּעָה","n",NULL,"maktzu\'ah","מקצועה","מקצועה",NULL,"MQCW&H","MQCW&H",NULL);
INSERT INTO hebrew_morpho VALUES (93171,"מַסְנֵן","n",NULL,"masnen","מסנן","מסנן",NULL,"MSNN","MSNN",NULL);
INSERT INTO hebrew_morpho VALUES (93172,"פִילְטֶר","n",NULL,"filter","פילטר","פילטר",NULL,"PIL@R","PIL@R",NULL);
INSERT INTO hebrew_morpho VALUES (93173,"מְלוּנָה","n",NULL,"meluna","מלונה","מלונה",NULL,"MLWNH","MLWNH",NULL);
INSERT INTO hebrew_morpho VALUES (93174,"מוֹקֵשׁ","n",NULL,"mokesh","מוקש","מוקש",NULL,"MWQ$","MWQ$",NULL);
INSERT INTO hebrew_morpho VALUES (93175,"מִכְרֶה","n",NULL,"michre","מכרה","מכרה",NULL,"MKRH","MKRH",NULL);
INSERT INTO hebrew_morpho VALUES (93176,"מַבְרֵג","n",NULL,"mavreg","מברג","מברג",NULL,"MBRG","MBRG",NULL);
INSERT INTO hebrew_morpho VALUES (93177,"סְקְרוּדְּרַיְבֶר","n",NULL,"skrudraiver","סקרודרייבר","סקרודריבר",NULL,"SQRWDRIBR","SQRWDRIIBR",NULL);
INSERT INTO hebrew_morpho VALUES (93178,"מִרְפְּאַת-חוּץ","n",NULL,"mirpa\'at-chutz","מרפאת-חוץ","מרפאת-חוץ",NULL,"MRPAT-XWC","MRPAT-XWC",NULL);
INSERT INTO hebrew_morpho VALUES (93179,"מִרְפָּאָה","n",NULL,"mirpa\'ah","מרפאה","מרפאה",NULL,"MRPAH","MRPAH",NULL);
INSERT INTO hebrew_morpho VALUES (93180,"קְלִינִיקָה","n",NULL,"klinika","קליניקה","קליניקה",NULL,"QLINIQH","QLINIQH",NULL);
INSERT INTO hebrew_morpho VALUES (93181,"מְאַוְרֵר","n",NULL,"me\'avrer","מאוורר","מאורר",NULL,"MAWRR","MAWWRR",NULL);
INSERT INTO hebrew_morpho VALUES (93182,"וֶנְטִילָטוֹר","n",NULL,"ventilator","ונטילטור","ונטילטור",NULL,"WN@IL@WR","WN@IL@WR",NULL);
INSERT INTO hebrew_morpho VALUES (93183,"עִשּׁוּן","n",NULL,"ishun","עישון","עשון",NULL,"&$WN","&I$WN",NULL);
INSERT INTO hebrew_morpho VALUES (93184,"עָשָׁן","n",NULL,"ashan","עשן","עשן",NULL,"&$N","&$N",NULL);
INSERT INTO hebrew_morpho VALUES (93185,"עַשֶּׁשֶׁת","n",NULL,"asheshet","עששת","עששת",NULL,"&$$T","&$$T",NULL);
INSERT INTO hebrew_morpho VALUES (93186,"עֲשִׂירִי","a",NULL,"asiri","עשירי","עשירי",NULL,"&$IRI","&$IRI",NULL);
INSERT INTO hebrew_morpho VALUES (93187,"עָוֶל","n",NULL,"avel","עוול","עול",NULL,"&WL","&WWL",NULL);
INSERT INTO hebrew_morpho VALUES (93188,"עַוְלָה","n",NULL,"avla","עולה","עולה",NULL,"&WLH","&WLH",NULL);
INSERT INTO hebrew_morpho VALUES (93189,"אִי-צֶדֶק","n",NULL,"i-tsedek","אי-צדק","אי-צדק",NULL,"AI-CDQ","AI-CDQ",NULL);
INSERT INTO hebrew_morpho VALUES (93190,"עֲנִישָׁה","n",NULL,"anisha","ענישה","ענישה",NULL,"&NI$H","&NI$H",NULL);
INSERT INTO hebrew_morpho VALUES (93191,"הַעֲנָשָׁה","n",NULL,"ha\'anasha","הענשה","הענשה",NULL,"H&N$H","H&N$H",NULL);
INSERT INTO hebrew_morpho VALUES (93192,"עֶרְכָּה","n",NULL,"erka","ערכה","ערכה",NULL,"&RKH","&RKH",NULL);
INSERT INTO hebrew_morpho VALUES (93193,"קִיט","n",NULL,"kit","קיט","קיט",NULL,"QI@","QI@",NULL);
INSERT INTO hebrew_morpho VALUES (93194,"עֲטַלֵּף","n",NULL,"atalef","עטלף","עטלף",NULL,"&@LP","&@LP",NULL);
INSERT INTO hebrew_morpho VALUES (93195,"עַקְרָב","n",NULL,"akrav","עקרב","עקרב",NULL,"&QRB","&QRB",NULL);
INSERT INTO hebrew_morpho VALUES (93196,"עָשׁ","n",NULL,"ash","עש","עש",NULL,"&$","&$",NULL);
INSERT INTO hebrew_morpho VALUES (93197,"רְכִישָׁה","n",NULL,"REXISHA","רכישה","רכישה",NULL,"RKI$H","RKI$H",NULL);
INSERT INTO hebrew_morpho VALUES (93198,"הַשָּׂגָה","n",NULL,"HASAGAH","השגה","השגה",NULL,"H$GH","H$GH",NULL);
INSERT INTO hebrew_morpho VALUES (93199,"מָשׁוֹט","n",NULL,"mashot","משוט","משוט",NULL,"M$W@","M$W@",NULL);
INSERT INTO hebrew_morpho VALUES (93200,"מִכְחוֹל","n",NULL,"mich\'chol","מכחול","מכחול",NULL,"MKXWL","MKXWL",NULL);
INSERT INTO hebrew_morpho VALUES (93201,"!מַשְׁתִּיק","n",NULL,NULL,"!משתיק","!משתיק",NULL,"M$TIQ","M$TIQ",NULL);
INSERT INTO hebrew_morpho VALUES (93202,"קוֹל","n",NULL,NULL,"קול","קול",NULL,"QWL","QWL",NULL);
INSERT INTO hebrew_morpho VALUES (93203,"עַמָם-פְּלִיטָה","n",NULL,"amam-plita","עמם-פליטה","עמם-פליטה",NULL,"&MM-PLI@H","&MM-PLI@H",NULL);
INSERT INTO hebrew_morpho VALUES (93204,"!מוּג","n",NULL,NULL,"!מוג","!מוג",NULL,"MWG","MWG",NULL);
INSERT INTO hebrew_morpho VALUES (93205,"לֵב","n",NULL,"lev","לב","לב",NULL,"LB","LB",NULL);
INSERT INTO hebrew_morpho VALUES (93206,"פַּחְדָן","n",NULL,"pachdan","פחדן","פחדן",NULL,"PXDN","PXDN",NULL);
INSERT INTO hebrew_morpho VALUES (93207,"!מְחִיאוֹת","n",NULL,NULL,"!מחיאות","!מחיאות",NULL,"MXIAWT","MXIAWT",NULL);
INSERT INTO hebrew_morpho VALUES (93208,"כַּפַּיִם","n",NULL,"kapayim","כפיים","כַּפַּיִם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (93209,"מְחִיאוֹת-כַּפַּיִם","n",NULL,"mechi\'ot-kapayim","מחיאות-כפיים","מחיאות-כפים",NULL,"MXIAWT-KPIM","MXIAWT-KPIIM",NULL);
INSERT INTO hebrew_morpho VALUES (93210,"תְּשׁוּאוֹת","n",NULL,"teshu\'ot","תשואות","תשואות",NULL,"T$WAWT","T$WAWT",NULL);
INSERT INTO hebrew_morpho VALUES (93211,"מֶשִׁי","n",NULL,"meshi","משי","משי",NULL,"M$I","M$I",NULL);
INSERT INTO hebrew_morpho VALUES (93212,"מַדְחֹם","n",NULL,"madchom","מדחום","מדחם",NULL,"MDXM","MDXWM",NULL);
INSERT INTO hebrew_morpho VALUES (93213,"תֶּרְמוֹמֶטֶר","n",NULL,"termometer","תרמומטר","תרמומטר",NULL,"TRMWM@R","TRMWM@R",NULL);
INSERT INTO hebrew_morpho VALUES (93214,"הֶגֶה-הַשִּׁלְטוֹן","n",NULL,"hege-hashilton","הגה-השלטון","הגה-השלטון",NULL,"HGH-H$L@WN","HGH-H$L@WN",NULL);
INSERT INTO hebrew_morpho VALUES (93215,"רֶסֶן-הַשִּׁלְטוֹן","n",NULL,"resen-hashilton","רסן-השלטון","רסן-השלטון",NULL,"RSN-H$L@WN","RSN-H$L@WN",NULL);
INSERT INTO hebrew_morpho VALUES (93216,"מוֹסְרוֹת-הַשִּׁלְטוֹן","n",NULL,"mosrot-hashilton","מוסרות-השלטון","מוסרות-השלטון",NULL,"MWSRWT-H$L@WN","MWSRWT-H$L@WN",NULL);
INSERT INTO hebrew_morpho VALUES (93217,"מְשׂוּכוֹת","n",NULL,"mesuchot","משוכות","משוכות",NULL,"M$WKWT","M$WKWT",NULL);
INSERT INTO hebrew_morpho VALUES (93218,"רִיצַת-מְשׂוּכוֹת","n",NULL,"ritzat-mesuchot","ריצת-משוכות","ריצת-משוכות",NULL,"RICT-M$WKWT","RICT-M$WKWT",NULL);
INSERT INTO hebrew_morpho VALUES (93219,"מַחְבֵּט","n",NULL,"machbet","מחבט","מחבט",NULL,"MXB@","MXB@",NULL);
INSERT INTO hebrew_morpho VALUES (93220,"מִסְעָדָה","n",NULL,"mis\'ada","מסעדה","מסעדה",NULL,"MS&DH","MS&DH",NULL);
INSERT INTO hebrew_morpho VALUES (93221,"מַרְתֵּף-יֵינוֹת","n",NULL,"martef-yenot","מרתף-יינות","מרתף-יינות",NULL,"MRTP-IINWT","MRTP-IINWT",NULL);
INSERT INTO hebrew_morpho VALUES (93222,"מַרְגֵּמָה","n",NULL,"margema","מרגמה","מרגמה",NULL,"MRGMH","MRGMH",NULL);
INSERT INTO hebrew_morpho VALUES (93223,"מַכְתֵּשׁ","n",NULL,"machtesh","מכתש","מכתש",NULL,"MKT$","MKT$",NULL);
INSERT INTO hebrew_morpho VALUES (93224,"לעַ","n",NULL,"lo\'a","לוע","לע",NULL,"L&","LW&",NULL);
INSERT INTO hebrew_morpho VALUES (93225,"מַגֶּבֶת","n",NULL,"magevet","מגבת","מגבת",NULL,"MGBT","MGBT",NULL);
INSERT INTO hebrew_morpho VALUES (93226,"מַצֶּקֶת","n",NULL,"matzeket","מצקת","מצקת",NULL,"MCQT","MCQT",NULL);
INSERT INTO hebrew_morpho VALUES (93227,"מְחִצָּה","n",NULL,"mechitza","מחיצה","מחצה",NULL,"MXCH","MXICH",NULL);
INSERT INTO hebrew_morpho VALUES (93228,"מֶלַח","n",NULL,"melach","מלח","מלח",NULL,"MLX","MLX",NULL);
INSERT INTO hebrew_morpho VALUES (93229,"מַזְרֵק","n",NULL,"mazrek","מזרק","מזרק",NULL,"MZRQ","MZRQ",NULL);
INSERT INTO hebrew_morpho VALUES (93230,"מוּסָךְ","n",NULL,"musach","מוסך","מוסך",NULL,"MWSK","MWSK",NULL);
INSERT INTO hebrew_morpho VALUES (93231,"מַדְרֵגָה","n",NULL,"madrega","מדרגה","מדרגה",NULL,"MDRGH","MDRGH",NULL);
INSERT INTO hebrew_morpho VALUES (93232,"מִכְסֶה","n",NULL,"michse","מכסה","מכסה",NULL,"MKSH","MKSH",NULL);
INSERT INTO hebrew_morpho VALUES (93233,"מַחֲזֶמֶר","n",NULL,"machazemer","מחזמר","מחזמר",NULL,"MXZMR","MXZMR",NULL);
INSERT INTO hebrew_morpho VALUES (93234,"מְיוּזִיקְל","n",NULL,"miyuzikel","מיוזיקל","מיוזיקל",NULL,"MIWZIQL","MIWZIQL",NULL);
INSERT INTO hebrew_morpho VALUES (93235,"מַסּוֹק","n",NULL,"masok","מסוק","מסוק",NULL,"MSWQ","MSWQ",NULL);
INSERT INTO hebrew_morpho VALUES (93236,"הֶלִיקוֹפְּטֶר","n",NULL,"helikopter","הליקופטר","הליקופטר",NULL,"HLIQWP@R","HLIQWP@R",NULL);
INSERT INTO hebrew_morpho VALUES (93237,"מַכְסֵחַת-דֶּשֶׁא","n",NULL,"machsechat-deshe","מכסחת-דשא","מכסחת-דשא",NULL,"MKSXT-D$A","MKSXT-D$A",NULL);
INSERT INTO hebrew_morpho VALUES (93238,"מַפָּה","n",NULL,"mapa","מפה","מפה",NULL,"MPH","MPH",NULL);
INSERT INTO hebrew_morpho VALUES (93239,"הַתְאָמָה","n",NULL,"hat\'ama","התאמה","התאמה",NULL,"HTAMH","HTAMH",NULL);
INSERT INTO hebrew_morpho VALUES (93240,"מִיץ","n",NULL,"mitz","מיץ","מיץ",NULL,"MIC","MIC",NULL);
INSERT INTO hebrew_morpho VALUES (93241,"עָסִיס","n",NULL,"asis","עסיס","עסיס",NULL,"&SIS","&SIS",NULL);
INSERT INTO hebrew_morpho VALUES (93242,"מַגָּשׁ","n",NULL,"magash","מגש","מגש",NULL,"MG$","MG$",NULL);
INSERT INTO hebrew_morpho VALUES (93243,"טַס","n",NULL,"tas","טס","טס",NULL,"@S","@S",NULL);
INSERT INTO hebrew_morpho VALUES (93244,"מִזְמוֹר","n",NULL,"mizmor","מזמור","מזמור",NULL,"MZMWR","MZMWR",NULL);
INSERT INTO hebrew_morpho VALUES (93245,"מְתַרְגֵּם","n",NULL,"metargem","מתרגם","מתרגם",NULL,"MTRGM","MTRGM",NULL);
INSERT INTO hebrew_morpho VALUES (93246,"מְתֻרְגְּמָן","n",NULL,"meturgeman","מתרגמן","מתרגמן",NULL,"MTRGMN","MTRGMN",NULL);
INSERT INTO hebrew_morpho VALUES (93247,"מַמְטֵרָה","n",NULL,"mamtera","ממטרה","ממטרה",NULL,"MM@RH","MM@RH",NULL);
INSERT INTO hebrew_morpho VALUES (93248,"צִפֹּרֶן","n",NULL,"tziporen","ציפורן","צפרן",NULL,"CPRN","CIPWRN",NULL);
INSERT INTO hebrew_morpho VALUES (93249,"מַסְמֵר","n",NULL,"masmer","מסמר","מסמר",NULL,"MSMR","MSMR",NULL);
INSERT INTO hebrew_morpho VALUES (93250,"מַדָּד","n",NULL,"madad","מדד","מדד",NULL,"MDD","MDD",NULL);
INSERT INTO hebrew_morpho VALUES (93251,"מַדַּד-הַמְּחִירִים-לַצַּרְכָן","n",NULL,"madad-hamechirim-latzarchan","מדד-המחירים-לצרכן","מדד-המחירים-לצרכן",NULL,"MDD-HMXIRIM-LCRKN","MDD-HMXIRIM-LCRKN",NULL);
INSERT INTO hebrew_morpho VALUES (93252,"מְצָד","n",NULL,"metzad","מצד","מצד",NULL,"MCD","MCD",NULL);
INSERT INTO hebrew_morpho VALUES (93253,"בּוּנְקֶר","n",NULL,"bunker","בונקר","בונקר",NULL,"BWNQR","BWNQR",NULL);
INSERT INTO hebrew_morpho VALUES (93254,"כִּפַּת-הַשָּׁמַיִם","n",NULL,"kipat-hashamayim","כיפת-השמיים","כפת-השמים",NULL,"KPT-H$MIM","KIPT-H$MIIM",NULL);
INSERT INTO hebrew_morpho VALUES (93255,"רָקִיעַ","n",NULL,"raki\'a","רקיע","רקיע",NULL,"RQI&","RQI&",NULL);
INSERT INTO hebrew_morpho VALUES (93256,"רָדָאר","n",NULL,"radar","רדאר","רדאר",NULL,"RDAR","RDAR",NULL);
INSERT INTO hebrew_morpho VALUES (93257,"עַכְבָּר","n",NULL,"axbar","עכבר","עכבר",NULL,"&KBR","&KBR",NULL);
INSERT INTO hebrew_morpho VALUES (93258,"עָגִיל","n",NULL,"agil","עגיל","עגיל",NULL,"&GIL","&GIL",NULL);
INSERT INTO hebrew_morpho VALUES (93259,"מְיַלֶּדֶת","n",NULL,"meyaledet","מיילדת","מילדת",NULL,"MILDT","MIILDT",NULL);
INSERT INTO hebrew_morpho VALUES (93260,"עוּגָה","n",NULL,"ugga","עוגה","עוגה",NULL,"&WGH","&WGH",NULL);
INSERT INTO hebrew_morpho VALUES (93261,"עֶגְלָה","n",NULL,"egla","עגלה","עגלה",NULL,"&GLH","&GLH",NULL);
INSERT INTO hebrew_morpho VALUES (93262,"עֲגוּרָן","n",NULL,"aguran","עגורן","עגורן",NULL,"&GWRN","&GWRN",NULL);
INSERT INTO hebrew_morpho VALUES (93263,"מָנוֹף","n",NULL,"manof","מנוף","מנוף",NULL,"MNWP","MNWP",NULL);
INSERT INTO hebrew_morpho VALUES (93264,"עֹפֶר","n",NULL,"ofer","עופר","עפר",NULL,"&PR","&WPR",NULL);
INSERT INTO hebrew_morpho VALUES (93265,"מִתְאַבֵּק","n",NULL,"mit\'abek","מתאבק","מתאבק",NULL,"MTABQ","MTABQ",NULL);
INSERT INTO hebrew_morpho VALUES (93266,"מִעוּט","n",NULL,"mi\'ut","מיעוט","מעוט",NULL,"M&W@","MI&W@",NULL);
INSERT INTO hebrew_morpho VALUES (93267,"קְטִינוּת","n",NULL,"ktinut","קטינות","קטינות",NULL,"Q@INWT","Q@INWT",NULL);
INSERT INTO hebrew_morpho VALUES (93268,"לַמְדָנוּת","n",NULL,"lamdanut","למדנות","למדנות",NULL,"LMDNWT","LMDNWT",NULL);
INSERT INTO hebrew_morpho VALUES (93269,"יַדְעָנוּת","n",NULL,"yad\'anut","ידענות","ידענות",NULL,"ID&NWT","ID&NWT",NULL);
INSERT INTO hebrew_morpho VALUES (93270,"אֶרוּדִיצְיָה","n",NULL,"eruditzya","ארודיציה","ארודיציה",NULL,"ARWDICIH","ARWDICIH",NULL);
INSERT INTO hebrew_morpho VALUES (93271,"מִלְגָּה","n",NULL,"milga","מילגה","מלגה",NULL,"MLGH","MILGH",NULL);
INSERT INTO hebrew_morpho VALUES (93272,"מְדוּרָה","n",NULL,"medura","מדורה","מדורה",NULL,"MDWRH","MDWRH",NULL);
INSERT INTO hebrew_morpho VALUES (93273,"מַאי","n",NULL,"may","מאי","מאי",NULL,"MAI","MAI",NULL);
INSERT INTO hebrew_morpho VALUES (93274,"מְעָרָה","n",NULL,"me\'ara","מערה","מערה",NULL,"M&RH","M&RH",NULL);
INSERT INTO hebrew_morpho VALUES (93275,"מָשִׁיחַ","n",NULL,"mashi\'ach","משיח","משיח",NULL,"M$IX","M$IX",NULL);
INSERT INTO hebrew_morpho VALUES (93276,"מְשָׁרֵת","n",NULL,"mesharet","משרת","משרת",NULL,"M$RT","M$RT",NULL);
INSERT INTO hebrew_morpho VALUES (93277,"מִתְעַמֵּל","n",NULL,"mit\'amel","מתעמל","מתעמל",NULL,"MT&ML","MT&ML",NULL);
INSERT INTO hebrew_morpho VALUES (93278,"מְאַהֶבֶת","n",NULL,"me\'ahevet","מאהבת","מאהבת",NULL,"MAHBT","MAHBT",NULL);
INSERT INTO hebrew_morpho VALUES (93279,"פִּילֶגֶשׁ","n",NULL,"pilegesh","פילגש","פילגש",NULL,"PILG$","PILG$",NULL);
INSERT INTO hebrew_morpho VALUES (93280,"מַצִּיל","n",NULL,"matzil","מציל","מציל",NULL,"MCIL","MCIL",NULL);
INSERT INTO hebrew_morpho VALUES (93281,"מַפָּל","n",NULL,"mapal","מפל","מפל",NULL,"MPL","MPL",NULL);
INSERT INTO hebrew_morpho VALUES (93282,"אֶשֶׁד","n",NULL,"eshed","אשד","אשד",NULL,"A$D","A$D",NULL);
INSERT INTO hebrew_morpho VALUES (93283,"מַפַּל-מַיִם","n",NULL,"mapal-mayim","מפל-מים","מפל-מים",NULL,"MPL-MIM","MPL-MIM",NULL);
INSERT INTO hebrew_morpho VALUES (93284,"מִשְׁטָרָה","n",NULL,"mishtara","משטרה","משטרה",NULL,"M$@RH","M$@RH",NULL);
INSERT INTO hebrew_morpho VALUES (93285,"מַאְדִּים","n",NULL,"ma\'adim","מאדים","מאדים",NULL,"MADIM","MADIM",NULL);
INSERT INTO hebrew_morpho VALUES (93286,"מַדָּף","n",NULL,"madaf","מדף","מדף",NULL,"MDP","MDP",NULL);
INSERT INTO hebrew_morpho VALUES (93287,"מְתוֹפֵף","n",NULL,"metofef","מתופף","מתופף",NULL,"MTWPP","MTWPP",NULL);
INSERT INTO hebrew_morpho VALUES (93288,"מַחֲזַאי","n",NULL,"machazay","מחזאי","מחזאי",NULL,"MXZAI","MXZAI",NULL);
INSERT INTO hebrew_morpho VALUES (93289,"מְזֻמָּנִים","n",NULL,"mezumanim","מזומנים","מזמנים",NULL,"MZMNIM","MZWMNIM",NULL);
INSERT INTO hebrew_morpho VALUES (93290,"מְזֻמָּן","n",NULL,"mezuman","מזומן","מזמן",NULL,"MZMN","MZWMN",NULL);
INSERT INTO hebrew_morpho VALUES (93291,"תְּהוֹם","n",NULL,"tehom","תהום","תהום",NULL,"THWM","THWM",NULL);
INSERT INTO hebrew_morpho VALUES (93292,"מְאוּרָה","n",NULL,"me\'urah","מאורה","מאורה",NULL,"MAWRH","MAWRH",NULL);
INSERT INTO hebrew_morpho VALUES (93293,"מְהַפְנֵט","n",NULL,"mehafnet","מהפנט","מהפנט",NULL,"MHPN@","MHPN@",NULL);
INSERT INTO hebrew_morpho VALUES (93294,"מַלְחִין","n",NULL,"malchin","מלחין","מלחין",NULL,"MLXIN","MLXIN",NULL);
INSERT INTO hebrew_morpho VALUES (93295,"קוֹמְפּוֹזִיטוֹר","n",NULL,"kompozitor","קומפוזיטור","קומפוזיטור",NULL,"QWMPWZI@WR","QWMPWZI@WR",NULL);
INSERT INTO hebrew_morpho VALUES (93296,"מָצוֹף","n",NULL,"matzof","מצוף","מצוף",NULL,"MCWP","MCWP",NULL);
INSERT INTO hebrew_morpho VALUES (93297,"עֲדָשָׁה","n",NULL,"adasha","עדשה","עדשה",NULL,"&D$H","&D$H",NULL);
INSERT INTO hebrew_morpho VALUES (93298,"פַּסְקוֹל","n",NULL,"paskol","פסקול","פסקול",NULL,"PSQWL","PSQWL",NULL);
INSERT INTO hebrew_morpho VALUES (93299,"עָרוּץ","n",NULL,"arutz","ערוץ","ערוץ",NULL,"&RWC","&RWC",NULL);
INSERT INTO hebrew_morpho VALUES (93300,"עָרוּץ-תִּקְשֹׁרֶת","n",NULL,"arutz tikshoret","ערוץ-תקשורת","ערוץ-תקשרת",NULL,"&RWC-TQ$RT","&RWC-TQ$WRT",NULL);
INSERT INTO hebrew_morpho VALUES (93301,"קֶנְיוֹן","n",NULL,"kenyon","קניון","קניון",NULL,"QNIWN","QNIWN",NULL);
INSERT INTO hebrew_morpho VALUES (93302,"אוֹרְגָּן","n",NULL,"organ","אורגן","אורגן",NULL,"AWRGN","AWRGN",NULL);
INSERT INTO hebrew_morpho VALUES (93303,"עַרְסָל","n",NULL,"arsal","ערסל","ערסל",NULL,"&RSL","&RSL",NULL);
INSERT INTO hebrew_morpho VALUES (93304,"גִּבְעֹנֶת","n",NULL,"giv\'onet","גבעונת","גבענת",NULL,"GB&NT","GB&WNT",NULL);
INSERT INTO hebrew_morpho VALUES (93305,"עֲנִיבָה","n",NULL,"aniva","עניבה","עניבה",NULL,"&NIBH","&NIBH",NULL);
INSERT INTO hebrew_morpho VALUES (93306,"עִפָּרוֹן","n",NULL,"ipparon","עיפרון","עפרון",NULL,"&PRWN","&IPRWN",NULL);
INSERT INTO hebrew_morpho VALUES (93307,"עָלֶה","n",NULL,"aleh","עלה","עלה",NULL,"&LH","&LH",NULL);
INSERT INTO hebrew_morpho VALUES (93308,"בֵּית-הָעִירִיָּה","n",NULL,"beyt ha\'iriya","בית-העיריה","בית-העיריה",NULL,"BIT-H&IRIH","BIT-H&IRIH",NULL);
INSERT INTO hebrew_morpho VALUES (93309,"הָעִירִיָּה","n",NULL,"ha\'iriya","העיריה","העיריה",NULL,"H&IRIH","H&IRIH",NULL);
INSERT INTO hebrew_morpho VALUES (93310,"עַפְעַף","n",NULL,"af\'af","עפעף","עפעף",NULL,"&P&P","&P&P",NULL);
INSERT INTO hebrew_morpho VALUES (93311,"שְׁמוּרַת-עַיִן","n",NULL,"shmurat ayin","שמורת-עין","שמורת-עין",NULL,"$MWRT-&IN","$MWRT-&IN",NULL);
INSERT INTO hebrew_morpho VALUES (93312,"רוֹפֵא-מַרְדִּים","n",NULL,"rofe-mardim","רופא-מרדים","רופא-מרדים",NULL,"RWPA-MRDIM","RWPA-MRDIM",NULL);
INSERT INTO hebrew_morpho VALUES (93313,"מְשׁוֹרֵר","n",NULL,"meshorer","משורר","משורר",NULL,"M$WRR","M$WRR",NULL);
INSERT INTO hebrew_morpho VALUES (93314,"פַּיְטָן","n",NULL,"paytan","פייטן","פיטן",NULL,"PI@N","PII@N",NULL);
INSERT INTO hebrew_morpho VALUES (93315,"מְאֻבָּן","n",NULL,"me\'uban","מאובן","מאבן",NULL,"MABN","MAWBN",NULL);
INSERT INTO hebrew_morpho VALUES (93316,"מַרְצֶה","n",NULL,"martze","מרצה","מרצה",NULL,"MRCH","MRCH","male");
INSERT INTO hebrew_morpho VALUES (93317,"חָסִיד","n",NULL,NULL,"חסיד","חסיד",NULL,"XSID","XSID",NULL);
INSERT INTO hebrew_morpho VALUES (93318,"מַעֲרִיץ","n",NULL,"ma\'aritz","מעריץ","מעריץ",NULL,"M&RIC","M&RIC",NULL);
INSERT INTO hebrew_morpho VALUES (93319,"עִנְבָּל","n",NULL,"inbal","ענבל","ענבל",NULL,"&NBL","&NBL",NULL);
INSERT INTO hebrew_morpho VALUES (93320,"עֶצֶם","n",NULL,"etzem","עצם","עצם",NULL,"&CM","&CM",NULL);
INSERT INTO hebrew_morpho VALUES (93321,"גֶּרֶם","n",NULL,"gerem","גרם","גרם",NULL,"GRM","GRM",NULL);
INSERT INTO hebrew_morpho VALUES (93322,"עָדִיף","a",NULL,"adif","עדיף","עדיף",NULL,"&DIP","&DIP",NULL);
INSERT INTO hebrew_morpho VALUES (93323,"עֲגָלָה","n",NULL,"agala","עגלה","עגלה",NULL,"&GLH","&GLH",NULL);
INSERT INTO hebrew_morpho VALUES (93324,"עֶגְלַת-יְלָדִים","n",NULL,"eglat yeladim","עגלת-ילדים","עגלת-ילדים",NULL,"&GLT-ILDIM","&GLT-ILDIM",NULL);
INSERT INTO hebrew_morpho VALUES (93325,"עֶגְלַת-תִּינוֹקוֹת","n",NULL,"eglat tinokot","עגלת-תינוקות","עגלת-תינוקות",NULL,"&GLT-TINWQWT","&GLT-TINWQWT",NULL);
INSERT INTO hebrew_morpho VALUES (93326,"חַשְׁמַלִּית","n",NULL,"xashmalit","חשמלית","חשמלית",NULL,"X$MLIT","X$MLIT",NULL);
INSERT INTO hebrew_morpho VALUES (93327,"תִּיקָן","n",NULL,"tikan","תיקן","תיקן",NULL,"TIQN","TIQN",NULL);
INSERT INTO hebrew_morpho VALUES (93328,"ג\'וּק","n",NULL,"juk","ג\'וק","ג\'וק",NULL,"G\'WQ","G\'WQ",NULL);
INSERT INTO hebrew_morpho VALUES (93329,"מַקָּק","n",NULL,"makak","מקק","מקק",NULL,"MQQ","MQQ",NULL);
INSERT INTO hebrew_morpho VALUES (93330,"מָגֵן","n",NULL,"magen","מגן","מגן",NULL,"MGN","MGN",NULL);
INSERT INTO hebrew_morpho VALUES (93331,"מַגָּל","n",NULL,"magal","מגל","מגל",NULL,"MGL","MGL",NULL);
INSERT INTO hebrew_morpho VALUES (93332,"מְסַנֶּנֶת","n",NULL,"mesanenet","מסננת","מסננת",NULL,"MSNNT","MSNNT",NULL);
INSERT INTO hebrew_morpho VALUES (93333,"מִסְנֶנֶת","n",NULL,"misnenet","מסננת","מסננת",NULL,"MSNNT","MSNNT",NULL);
INSERT INTO hebrew_morpho VALUES (93334,"עֲבוֹדָה","n",NULL,"avoda","עבודה","עבודה",NULL,"&BWDH","&BWDH",NULL);
INSERT INTO hebrew_morpho VALUES (93335,"יְצִירָה","n",NULL,"yetzira","יצירה","יצירה",NULL,"ICIRH","ICIRH",NULL);
INSERT INTO hebrew_morpho VALUES (93336,"יְצִירַת-אָמָּנוּת","n",NULL,"yetzirat omanut","יצירת-אמנות","יצירת-אמנות",NULL,"ICIRT-AMNWT","ICIRT-AMNWT",NULL);
INSERT INTO hebrew_morpho VALUES (93337,"עִתּוּי","n",NULL,"ittuy","עיתוי","עתוי",NULL,"&TWI","&ITWI",NULL);
INSERT INTO hebrew_morpho VALUES (93338,"טַיְמִינְג","n",NULL,NULL,"טימינג","טימינג",NULL,"@IMING","@IMING",NULL);
INSERT INTO hebrew_morpho VALUES (93339,"עֹדֶף","n",NULL,"odef","עודף","עדף",NULL,"&DP","&WDP",NULL);
INSERT INTO hebrew_morpho VALUES (93340,"עָבָר","n",NULL,"avar","עבר","עבר",NULL,"&BR","&BR",NULL);
INSERT INTO hebrew_morpho VALUES (93341,"זְמַן-עָבָר","n",NULL,"zman avar","זמן-עבר","זמן-עבר",NULL,"ZMN-&BR","ZMN-&BR",NULL);
INSERT INTO hebrew_morpho VALUES (93342,"עָבָר-פְּלִילִי","n",NULL,"avar plili","עבר-פלילי","עבר-פלילי",NULL,"&BR-PLILI","&BR-PLILI",NULL);
INSERT INTO hebrew_morpho VALUES (93343,"עֹרֶף","n",NULL,"oref","עורף","ערף",NULL,"&RP","&WRP",NULL);
INSERT INTO hebrew_morpho VALUES (93344,"לְשׁוֹן-הַקֹּדֶשׁ","n",NULL,NULL,"לשון-הקדש","לשון-הקדש",NULL,"L$WN-HQD$","L$WN-HQD$",NULL);
INSERT INTO hebrew_morpho VALUES (93345,"עֵרֶךְ","n",NULL,"erex","ערך","ערך",NULL,"&RK","&RK",NULL);
INSERT INTO hebrew_morpho VALUES (93346,"עָתִיד","n",NULL,"atid","עתיד","עתיד",NULL,"&TID","&TID",NULL);
INSERT INTO hebrew_morpho VALUES (93347,"עַמְעָם","n",NULL,"am\'am","עמעם","עמעם",NULL,"&M&M","&M&M",NULL);
INSERT INTO hebrew_morpho VALUES (93348,"דִּימֶר","n",NULL,"dimer","דימר","דימר",NULL,"DIMR","DIMR",NULL);
INSERT INTO hebrew_morpho VALUES (93349,"וַסַּת-אוֹר","n",NULL,"vasat or","וסת-אור","וסת-אור",NULL,"WST-AWR","WST-AWR",NULL);
INSERT INTO hebrew_morpho VALUES (93350,"עִסְקָה","n",NULL,"iska","עסקה","עסקה"," עיסקה ","&SQH","&SQH",NULL);
INSERT INTO hebrew_morpho VALUES (93351,"טְרַנְסַקְצְיָה","n",NULL,"transaktzia","טרנסקציה","טרנסקציה",NULL,"@RNSQCIH","@RNSQCIH",NULL);
INSERT INTO hebrew_morpho VALUES (93352,"עֵסֶק","n",NULL,"esek","עסק","עסק",NULL,"&SQ","&SQ",NULL);
INSERT INTO hebrew_morpho VALUES (93353,"רוֹמָן","n",NULL,"roman","רומן","רומן",NULL,"RWMN","RWMN",NULL);
INSERT INTO hebrew_morpho VALUES (93354,"פַּרְשִׁיַּת-אֲהָבִים","n",NULL,"parshiyat ahavim","פרשית-אהבים","פרשית-אהבים",NULL,"PR$IT-AHBIM","PR$IT-AHBIM",NULL);
INSERT INTO hebrew_morpho VALUES (93355,"פָּרָשַׁת-אֲהָבִים","n",NULL,"parashat ahavim","פרשת-אהבים","פרשת-אהבים",NULL,"PR$T-AHBIM","PR$T-AHBIM",NULL);
INSERT INTO hebrew_morpho VALUES (93356,"עַרְפָּד","n",NULL,"arpad","ערפד","ערפד",NULL,"&RPD","&RPD",NULL);
INSERT INTO hebrew_morpho VALUES (93357,"עַגְבָנִיָּה","n",NULL,"agvaniya","עגבנייה","עגבניה",NULL,"&GBNIH","&GBNIIH",NULL);
INSERT INTO hebrew_morpho VALUES (93358,"בַּנְדּוֹרָה","n",NULL,"bandora","בנדורה","בנדורה",NULL,"BNDWRH","BNDWRH",NULL);
INSERT INTO hebrew_morpho VALUES (93359,"עוּגִיָּה","n",NULL,"ugiya","עוגייה","עוגיה",NULL,"&WGIH","&WGIIH",NULL);
INSERT INTO hebrew_morpho VALUES (93360,"בִּיסְקְוִיט","n",NULL,"biskvit","ביסקויט","ביסקויט",NULL,"BISQWI@","BISQWI@",NULL);
INSERT INTO hebrew_morpho VALUES (93361,"עוּגִית","n",NULL,"ugit","עוגית","עוגית",NULL,"&WGIT","&WGIT",NULL);
INSERT INTO hebrew_morpho VALUES (93362,"עָרִיק","n",NULL,"arik","עריק","עריק",NULL,"&RIQ","&RIQ","male");
INSERT INTO hebrew_morpho VALUES (93363,"מַלָּח","n",NULL,"malach","מלח","מלח",NULL,"MLX","MLX",NULL);
INSERT INTO hebrew_morpho VALUES (93364,"יַמַּאי","n",NULL,"yamay","ימאי","ימאי",NULL,"IMAI","IMAI",NULL);
INSERT INTO hebrew_morpho VALUES (93365,"סַפָּן","n",NULL,"sapan","ספן","ספן",NULL,"SPN","SPN",NULL);
INSERT INTO hebrew_morpho VALUES (93366,"יוֹרֵד-יָם","n",NULL,"yored-yam","יורד-ים","יורד-ים",NULL,"IWRD-IM","IWRD-IM",NULL);
INSERT INTO hebrew_morpho VALUES (93367,"כּוֹבַע-קַשׁ","n",NULL,"kova-kash","כובע-קש","כובע-קש",NULL,"KWB&-Q$","KWB&-Q$",NULL);
INSERT INTO hebrew_morpho VALUES (93368,"עַצְמָאוּת","n",NULL,"atzma\'ut","עצמאות","עצמאות",NULL,"&CMAWT","&CMAWT",NULL);
INSERT INTO hebrew_morpho VALUES (93369,"עִצּוּר","n",NULL,"itzur","עיצור","עצור",NULL,"&CWR","&ICWR",NULL);
INSERT INTO hebrew_morpho VALUES (93370,"קוֹנְסוֹנַנְט","n",NULL,"konsonant","קונסוננט","קונסוננט",NULL,"QWNSWNN@","QWNSWNN@",NULL);
INSERT INTO hebrew_morpho VALUES (93371,"עוֹנָה","n",NULL,"ona","עונה","עונה",NULL,"&WNH","&WNH",NULL);
INSERT INTO hebrew_morpho VALUES (93372,"עִיר","n",NULL,"ir","עיר","עיר",NULL,"&IR","&IR",NULL);
INSERT INTO hebrew_morpho VALUES (93373,"עֲיָרָה","n",NULL,"ayara","עיירה","עירה",NULL,"&IRH","&IIRH",NULL);
INSERT INTO hebrew_morpho VALUES (93374,"מֻגְלָה","n",NULL,"mugla","מוגלה","מגלה",NULL,"MGLH","MWGLH",NULL);
INSERT INTO hebrew_morpho VALUES (93375,"עֹצֶר","n",NULL,"otzer","עוצר","עצר",NULL,"&CR","&WCR",NULL);
INSERT INTO hebrew_morpho VALUES (93376,"מַטְאֲטֵא","n",NULL,"mat\'ate","מטאטא","מטאטא",NULL,"M@A@A","M@A@A",NULL);
INSERT INTO hebrew_morpho VALUES (93377,"עָגֹל","a",NULL,"agol","עגול","עגל",NULL,"&GL","&GWL",NULL);
INSERT INTO hebrew_morpho VALUES (93378,"עֱלִי","n",NULL,"eli","עלי","עלי",NULL,"&LI","&LI",NULL);
INSERT INTO hebrew_morpho VALUES (93379,"עֲרָבָה","n",NULL,"arava","ערבה","ערבה",NULL,"&RBH","&RBH",NULL);
INSERT INTO hebrew_morpho VALUES (93380,"!עֲקֶרֶת","n",NULL,NULL,"!עקרת","!עקרת",NULL,"&QRT","&QRT",NULL);
INSERT INTO hebrew_morpho VALUES (93381,"עֲקֶרֶת-בַּיִת","n",NULL,"akeret bayit","עקרת-בית","עקרת-בית",NULL,"&QRT-BIT","&QRT-BIT",NULL);
INSERT INTO hebrew_morpho VALUES (93382,"עַרְעָר","n",NULL,"ar\'ar","ערער","ערער",NULL,"&R&R","&R&R",NULL);
INSERT INTO hebrew_morpho VALUES (93383,"סִיפִילִיס","n",NULL,"sifilis","סיפיליס","סיפיליס",NULL,"SIPILIS","SIPILIS",NULL);
INSERT INTO hebrew_morpho VALUES (93384,"עַגֶּבֶת","n",NULL,"agevet","עגבת","עגבת",NULL,"&GBT","&GBT",NULL);
INSERT INTO hebrew_morpho VALUES (93385,"עִוָּרוֹן","n",NULL,"ivaron","עיוורון","עורון",NULL,"&WRWN","&IWWRWN",NULL);
INSERT INTO hebrew_morpho VALUES (93386,"סַמְיוּת-עֵינַיִם","n",NULL,"samyut eynayim","סמיות-עינים","סמיות-עינים",NULL,"SMIWT-&INIM","SMIWT-&INIM",NULL);
INSERT INTO hebrew_morpho VALUES (93387,"עִוְּרוּת","n",NULL,"ivrut","עורות","עורות",NULL,"&WRWT","&WRWT",NULL);
INSERT INTO hebrew_morpho VALUES (93388,"עִכּוּל","n",NULL,"ikkul","עיכול","עכול",NULL,"&KWL","&IKWL",NULL);
INSERT INTO hebrew_morpho VALUES (93389,"מַגְלֵשָׁה","n",NULL,"maglesha","מגלשה","מגלשה",NULL,"MGL$H","MGL$H",NULL);
INSERT INTO hebrew_morpho VALUES (93390,"מַרְזֵב","n",NULL,"marzev","מרזב","מרזב",NULL,"MRZB","MRZB",NULL);
INSERT INTO hebrew_morpho VALUES (93391,"מַחְרֵטָה","n",NULL,"machreta","מחרטה","מחרטה",NULL,"MXR@H","MXR@H",NULL);
INSERT INTO hebrew_morpho VALUES (93392,"נָשׂוּא","n",NULL,"nasu","נשוא","נשוא",NULL,"N$WA","N$WA",NULL);
INSERT INTO hebrew_morpho VALUES (93393,"דֶּרְמָטוֹלוֹגְיָה","n",NULL,"dermatologiah","דרמטולוגיה","דרמטולוגיה",NULL,"DRM@WLWGIH","DRM@WLWGIH",NULL);
INSERT INTO hebrew_morpho VALUES (93394,"רְפוּאַת-עוֹר","n",NULL,"refu\'at or","רפואת-עור","רפואת-עור",NULL,"RPWAT-&WR","RPWAT-&WR",NULL);
INSERT INTO hebrew_morpho VALUES (93395,"עוֹר","n",NULL,"or","עור","עור",NULL,"&WR","&WR",NULL);
INSERT INTO hebrew_morpho VALUES (93396,"עוֹרֵךְ","n",NULL,"orex","עורך","עורך",NULL,"&WRK","&WRK",NULL);
INSERT INTO hebrew_morpho VALUES (93397,"עֲתִירָה","n",NULL,"atira","עתירה","עתירה",NULL,"&TIRH","&TIRH",NULL);
INSERT INTO hebrew_morpho VALUES (93398,"עִמְלֵן","v",NULL,"imlen","עמלן","עמלן",NULL,"&MLN","&MLN",NULL);
INSERT INTO hebrew_morpho VALUES (93399,"עֲקָרוּת","n",NULL,"akarut","עקרות","עקרות",NULL,"&QRWT","&QRWT",NULL);
INSERT INTO hebrew_morpho VALUES (93400,"אִי-פּוֹרִיּוּת","n",NULL,"i-poriyut","אי-פוריות","אי-פוריות",NULL,"AI-PWRIWT","AI-PWRIWT",NULL);
INSERT INTO hebrew_morpho VALUES (93401,"מִילִיצְיָה","n",NULL,"militsiah","מיליציה","מיליציה",NULL,"MILICIH","MILICIH",NULL);
INSERT INTO hebrew_morpho VALUES (93402,"כּוֹחוֹת-מִּלּוּאִים","n",NULL,"koxot milu\'im","כוחות-מלואים","כוחות-מלואים",NULL,"KWXWT-MLWAIM","KWXWT-MLWAIM",NULL);
INSERT INTO hebrew_morpho VALUES (93403,"עֲתוּדוֹת","n",NULL,"atudot","עתודות","עתודות",NULL,"&TWDWT","&TWDWT",NULL);
INSERT INTO hebrew_morpho VALUES (93404,"גָּלוּת-מֵרָצוֹן","n",NULL,"galut-meratzon","גלות-מרצון","גלות-מרצון",NULL,"GLWT-MRCWN","GLWT-MRCWN",NULL);
INSERT INTO hebrew_morpho VALUES (93405,"אִישׁ-מַדָּע","n",NULL,"ish-mada","איש-מדע","איש-מדע",NULL,"AI$-MD&","AI$-MD&",NULL);
INSERT INTO hebrew_morpho VALUES (93406,"מַדְּעָן","n",NULL,"mad\'an","מדען","מדען",NULL,"MD&N","MD&N",NULL);
INSERT INTO hebrew_morpho VALUES (93407,"מַרְגָּרִינָה","n",NULL,"margarina","מרגרינה","מרגרינה",NULL,"MRGRINH","MRGRINH",NULL);
INSERT INTO hebrew_morpho VALUES (93408,"מִטְעָן","n",NULL,"mit\'an","מטען","מטען",NULL,"M@&N","M@&N",NULL);
INSERT INTO hebrew_morpho VALUES (93409,"מִזְוָד","n",NULL,"mizvad","מזוד","מזוד",NULL,"MZWD","MZWD",NULL);
INSERT INTO hebrew_morpho VALUES (93410,"מְאַיֵּד","n",NULL,"me\'ayed","מאייד","מאיד",NULL,"MAID","MAIID",NULL);
INSERT INTO hebrew_morpho VALUES (93411,"קַרְבּוּרָטוֹר","n",NULL,"karburator","קרבורטור","קרבורטור",NULL,"QRBWR@WR","QRBWR@WR",NULL);
INSERT INTO hebrew_morpho VALUES (93412,"מָחוֹךְ","n",NULL,"machoch","מחוך","מחוך",NULL,"MXWK","MXWK",NULL);
INSERT INTO hebrew_morpho VALUES (93413,"חֲגוֹרַת-בֶּטֶן","n",NULL,"chagorat-beten","חגורת-בטן","חגורת-בטן",NULL,"XGWRT-B@N","XGWRT-B@N",NULL);
INSERT INTO hebrew_morpho VALUES (93414,"מְלִיחוּת","n",NULL,"melichut","מליחות","מליחות",NULL,"MLIXWT","MLIXWT",NULL);
INSERT INTO hebrew_morpho VALUES (93415,"מָרָה","n",NULL,"mara","מרה","מרה",NULL,"MRH","MRH",NULL);
INSERT INTO hebrew_morpho VALUES (93416,"מִשְׁקֶפֶת","n",NULL,"mishkefet","משקפת","משקפת",NULL,"M$QPT","M$QPT",NULL);
INSERT INTO hebrew_morpho VALUES (93417,"מַחְצָבָה","n",NULL,"machtzava","מחצבה","מחצבה",NULL,"MXCBH","MXCBH",NULL);
INSERT INTO hebrew_morpho VALUES (93418,"מְקַדֵּם-מִתְאָם","n",NULL,"mekadem-mit\'am","מקדם-מיתאם","מקדם-מתאם",NULL,"MQDM-MTAM","MQDM-MITAM",NULL);
INSERT INTO hebrew_morpho VALUES (93419,"קוֹרֶלַצְיָה","n",NULL,"korelatzya","קורלציה","קורלציה",NULL,"QWRLCIH","QWRLCIH",NULL);
INSERT INTO hebrew_morpho VALUES (93420,"מִתְאָם","n",NULL,"mit\'am","מיתאם","מתאם",NULL,"MTAM","MITAM",NULL);
INSERT INTO hebrew_morpho VALUES (93421,"מְכוֹנִית","n",NULL,"mechonit","מכונית","מכונית",NULL,"MKWNIT","MKWNIT",NULL);
INSERT INTO hebrew_morpho VALUES (93422,"אוֹטוֹ","n",NULL,"oto","אוטו","אוטו",NULL,"AW@W","AW@W",NULL);
INSERT INTO hebrew_morpho VALUES (93423,"דֶּבֶר","n",NULL,"dever","דבר","דבר",NULL,"DBR","DBR",NULL);
INSERT INTO hebrew_morpho VALUES (93424,"מְלָאכוּתִיּוּת","n",NULL,"melachutiyut","מלאכותיות","מלאכותיות",NULL,"MLAKWTIWT","MLAKWTIWT",NULL);
INSERT INTO hebrew_morpho VALUES (93425,"וִילוֹן","n",NULL,"vilon","וילון","וילון",NULL,"WILWN","WILWN",NULL);
INSERT INTO hebrew_morpho VALUES (93426,"מָסָךְ","n",NULL,"masach","מסך","מסך",NULL,"MSK","MSK",NULL);
INSERT INTO hebrew_morpho VALUES (93427,"מְעִי","n",NULL,"me\'i","מעי","מעי",NULL,"M&I","M&I",NULL);
INSERT INTO hebrew_morpho VALUES (93428,"מַקָּף","n",NULL,"makaf","מקף","מקף",NULL,"MQP","MQP",NULL);
INSERT INTO hebrew_morpho VALUES (93429,"מַנְדָּרִין","n",NULL,"mandarin","מנדרין","מנדרין",NULL,"MNDRIN","MNDRIN",NULL);
INSERT INTO hebrew_morpho VALUES (93430,"מִי","n",NULL,"mi","מי","מי",NULL,"MI","MI",NULL);
INSERT INTO hebrew_morpho VALUES (93431,"מִתְקָן-סְחִיטָה","n",NULL,"mitkan-schitah","מתקן-סחיטה","מתקן-סחיטה",NULL,"MTQN-SXI@H","MTQN-SXI@H",NULL);
INSERT INTO hebrew_morpho VALUES (93432,"מַשְׁנֵק","n",NULL,"mashnek","משנק","משנק",NULL,"M$NQ","M$NQ",NULL);
INSERT INTO hebrew_morpho VALUES (93433,"צ\'וֹק","n",NULL,"chok","צ\'וק","צ\'וק",NULL,"C\'WQ","C\'WQ",NULL);
INSERT INTO hebrew_morpho VALUES (93434,"מַחְבֵּט-סְקְווֹשׁ","n",NULL,NULL,"מחבט-סקווש","מחבט-סקווש",NULL,"MXB@-SQWW$","MXB@-SQWW$",NULL);
INSERT INTO hebrew_morpho VALUES (93435,"מָסוֹף","n",NULL,"masof","מסוף","מסוף",NULL,"MSWP","MSWP",NULL);
INSERT INTO hebrew_morpho VALUES (93436,"מַזְכֶּרֶת","n",NULL,"mazkeret","מזכרת","מזכרת",NULL,"MZKRT","MZKRT",NULL);
INSERT INTO hebrew_morpho VALUES (93437,"סוּבֶנִיר","n",NULL,"suvenir","סובניר","סובניר",NULL,"SWBNIR","SWBNIR",NULL);
INSERT INTO hebrew_morpho VALUES (93438,"כָּאוֹס","n",NULL,"ka\'os","כאוס","כאוס",NULL,"KAWS","KAWS",NULL);
INSERT INTO hebrew_morpho VALUES (93439,"מִדְשָׁאָה","n",NULL,"mid\'sha\'ah","מדשאה","מדשאה",NULL,"MD$AH","MD$AH",NULL);
INSERT INTO hebrew_morpho VALUES (93440,"מָהִיר","a",NULL,"mahir","מהיר","מהיר",NULL,"MHIR","MHIR",NULL);
INSERT INTO hebrew_morpho VALUES (93441,"זָרִיז","a",NULL,"zariz","זריז","זריז",NULL,"ZRIZ","ZRIZ",NULL);
INSERT INTO hebrew_morpho VALUES (93442,"קַל-תְּנוּעָה","a",NULL,"kal-tnu\'ah","קל-תנועה","קל-תנועה",NULL,"QL-TNW&H","QL-TNW&H",NULL);
INSERT INTO hebrew_morpho VALUES (93443,"מִיָּדִי","a",NULL,"miyadi","מידי","מידי",NULL,"MIDI","MIDI",NULL);
INSERT INTO hebrew_morpho VALUES (93444,"מוּסָף","a",NULL,"musaf","מוסף","מוסף",NULL,"MWSP","MWSP",NULL);
INSERT INTO hebrew_morpho VALUES (93445,"מֻשָּׂגִי","a",NULL,"musagi","מושגי","משגי",NULL,"M$GI","MW$GI",NULL);
INSERT INTO hebrew_morpho VALUES (93446,"קוֹנְסֶפְּטוּאָלִי","a",NULL,"konseptuali","קונספטואלי","קונספטואלי",NULL,"QWNSP@WALI","QWNSP@WALI",NULL);
INSERT INTO hebrew_morpho VALUES (93447,"מְקֻשָּׁט","a",NULL,"mekushat","מקושט","מקשט",NULL,"MQ$@","MQW$@",NULL);
INSERT INTO hebrew_morpho VALUES (93448,"מֻמְלָץ","a",NULL,"mumlatz","מומלץ","ממלץ",NULL,"MMLC","MWMLC",NULL);
INSERT INTO hebrew_morpho VALUES (93449,"מֻצָּע","a",NULL,"mutza","מצע","מצע",NULL,"MC&","MC&",NULL);
INSERT INTO hebrew_morpho VALUES (93450,"מְזֻעֲזָע","a",NULL,"mezuaza","מזועזע","מזעזע",NULL,"MZ&Z&","MZW&Z&",NULL);
INSERT INTO hebrew_morpho VALUES (93451,"מְזֻעְזָע","a",NULL,NULL,"מזעזע","מזעזע",NULL,"MZ&Z&","MZ&Z&",NULL);
INSERT INTO hebrew_morpho VALUES (93452,"זוֹעֵם","a",NULL,"zo\'em","זועם","זועם",NULL,"ZW&M","ZW&M",NULL);
INSERT INTO hebrew_morpho VALUES (93453,"נִזְעָם","a",NULL,"niz\'am","נזעם","נזעם",NULL,"NZ&M","NZ&M",NULL);
INSERT INTO hebrew_morpho VALUES (93454,"מַתְאִים","a",NULL,"mat\'im","מתאים","מתאים",NULL,"MTAIM","MTAIM",NULL);
INSERT INTO hebrew_morpho VALUES (93455,"נָכוֹן","a",NULL,"nachon","נכון","נכון",NULL,"NKWN","NKWN",NULL);
INSERT INTO hebrew_morpho VALUES (93456,"יַשְׁנוּנִי","a",NULL,"yashnuni","ישנוני","ישנוני",NULL,"I$NWNI","I$NWNI",NULL);
INSERT INTO hebrew_morpho VALUES (93457,"מַקְרִיחַ","a",NULL,"makri\'ach","מקריח","מקריח",NULL,"MQRIX","MQRIX",NULL);
INSERT INTO hebrew_morpho VALUES (93458,"גְּרוֹטֶסְקִי","a",NULL,"groteski","גרוטסקי","גרוטסקי",NULL,"GRW@SQI","GRW@SQI",NULL);
INSERT INTO hebrew_morpho VALUES (93459,"מִפְלַצְתִּי","a",NULL,"miflatzti","מפלצתי","מפלצתי",NULL,"MPLCTI","MPLCTI",NULL);
INSERT INTO hebrew_morpho VALUES (93460,"מַמְאִיר","a",NULL,"mam\'ir","ממאיר","ממאיר",NULL,"MMAIR","MMAIR",NULL);
INSERT INTO hebrew_morpho VALUES (93461,"מְדַמֵּם","a",NULL,"medamem","מדמם","מדמם",NULL,"MDMM","MDMM",NULL);
INSERT INTO hebrew_morpho VALUES (93462,"מְהַבְהֵב","a",NULL,"mehavhev","מהבהב","מהבהב",NULL,"MHBHB","MHBHB",NULL);
INSERT INTO hebrew_morpho VALUES (93463,"מְעֻמְעָם","a",NULL,"me\'um\'am","מעומעם","מעמעם",NULL,"M&M&M","M&WM&M",NULL);
INSERT INTO hebrew_morpho VALUES (93464,"מוּעָם","a",NULL,"mu\'am","מועם","מועם",NULL,"MW&M","MW&M",NULL);
INSERT INTO hebrew_morpho VALUES (93465,"מְשֹׁעָר","a",NULL,"mesho\'ar","משוער","משער",NULL,"M$&R","M$W&R",NULL);
INSERT INTO hebrew_morpho VALUES (93466,"מֻזְנָח","a",NULL,"muznach","מוזנח","מזנח",NULL,"MZNX","MWZNX",NULL);
INSERT INTO hebrew_morpho VALUES (93467,"עָזוּב","a",NULL,"azuv","עזוב","עזוב",NULL,"&ZWB","&ZWB",NULL);
INSERT INTO hebrew_morpho VALUES (93468,"מְפֹרָט","a",NULL,"meforat","מפורט","מפרט",NULL,"MPR@","MPWR@",NULL);
INSERT INTO hebrew_morpho VALUES (93469,"עָרוּךְ","a",NULL,"aruch","ערוך","ערוך",NULL,"&RWK","&RWK",NULL);
INSERT INTO hebrew_morpho VALUES (93470,"מְנֻקֶּה","a",NULL,"menuke","מנוקה","מנקה",NULL,"MNQH","MNWQH",NULL);
INSERT INTO hebrew_morpho VALUES (93471,"מְעֻנָּן","a",NULL,"me\'unan","מעונן","מענן",NULL,"M&NN","M&WNN",NULL);
INSERT INTO hebrew_morpho VALUES (93472,"מִתְקַפֵּל","a",NULL,"mitkapel","מתקפל","מתקפל",NULL,"MTQPL","MTQPL",NULL);
INSERT INTO hebrew_morpho VALUES (93473,"מִתְלַקֵּחַ","a",NULL,"mitlake\'ach","מתלקח","מתלקח",NULL,"MTLQX","MTLQX",NULL);
INSERT INTO hebrew_morpho VALUES (93474,"בָּעִיר","a",NULL,"ba\'ir","בעיר","בעיר",NULL,"B&IR","B&IR",NULL);
INSERT INTO hebrew_morpho VALUES (93475,"דָּלִיק","a",NULL,"dalik","דליק","דליק",NULL,"DLIQ","DLIQ",NULL);
INSERT INTO hebrew_morpho VALUES (93476,"מְמֻסְחָר","a",NULL,"memuschar","ממוסחר","ממסחר",NULL,"MMSXR","MMWSXR",NULL);
INSERT INTO hebrew_morpho VALUES (93477,"שָׁלֵם","a",NULL,"shalem","שלם","שלם",NULL,"$LM","$LM",NULL);
INSERT INTO hebrew_morpho VALUES (93478,"שָׂבֵעַ","a",NULL,"save\'a","שבע","שבע",NULL,"$B&","$B&",NULL);
INSERT INTO hebrew_morpho VALUES (93479,"מָלֵא","a",NULL,"male","מלא","מלא",NULL,"MLA","MLA",NULL);
INSERT INTO hebrew_morpho VALUES (93480,"הַרְבֵּה","a",NULL,"harbe","הרבה","הרבה",NULL,"HRBH","HRBH",NULL);
INSERT INTO hebrew_morpho VALUES (93481,"מְמַצֶּה","a",NULL,"mematze","ממצה","ממצה",NULL,"MMCH","MMCH",NULL);
INSERT INTO hebrew_morpho VALUES (93482,"מָסָרְתִּי","a",NULL,"masorti","מסורתי","מסרתי",NULL,"MSRTI","MSWRTI",NULL);
INSERT INTO hebrew_morpho VALUES (93483,"מְטֻגָּן","a",NULL,"metugan","מטוגן","מטגן",NULL,"M@GN","M@WGN",NULL);
INSERT INTO hebrew_morpho VALUES (93484,"מְאֻדֶּה","a",NULL,"me\'ude","מאודה","מאדה",NULL,"MADH","MAWDH",NULL);
INSERT INTO hebrew_morpho VALUES (93485,"מְשַׁלְשֵׁל","a",NULL,"meshalshel","משלשל","משלשל",NULL,"M$L$L","M$L$L",NULL);
INSERT INTO hebrew_morpho VALUES (93486,"מְנֻמָּס","a",NULL,"menumas","מנומס","מנמס",NULL,"MNMS","MNWMS",NULL);
INSERT INTO hebrew_morpho VALUES (93487,"תְּלַת-מְמַדִּי","a",NULL,"tlat-meimadi","תלת-מימדי","תלת-ממדי",NULL,"TLT-MMDI","TLT-MIMDI",NULL);
INSERT INTO hebrew_morpho VALUES (93488,"מְעֻקָּב","a",NULL,"me\'ukav","מעוקב","מעקב",NULL,"M&QB","M&WQB",NULL);
INSERT INTO hebrew_morpho VALUES (93489,"מְגַמָּתִי","a",NULL,"megamati","מגמתי","מגמתי",NULL,"MGMTI","MGMTI",NULL);
INSERT INTO hebrew_morpho VALUES (93490,"מַרְשִׁים","a",NULL,"marshim","מרשים","מרשים",NULL,"MR$IM","MR$IM",NULL);
INSERT INTO hebrew_morpho VALUES (93491,"מַלְאֶה","a",NULL,"mal\'eh","מלאה","מלאה",NULL,"MLAH","MLAH",NULL);
INSERT INTO hebrew_morpho VALUES (93492,"מְיַגֵּעַ","a",NULL,NULL,"מיגע","מיגע",NULL,"MIG&","MIG&",NULL);
INSERT INTO hebrew_morpho VALUES (93493,"מְעַיֵּף","a",NULL,"me\'ayef","מעייף","מעיף",NULL,"M&IP","M&IIP",NULL);
INSERT INTO hebrew_morpho VALUES (93494,"מְפֻטָּר","a",NULL,"mefutar","מפוטר","מפטר",NULL,"MP@R","MPW@R",NULL);
INSERT INTO hebrew_morpho VALUES (93495,"מְהֻפְּנָט","a",NULL,"mehupnat","מהופנט","מהפנט",NULL,"MHPN@","MHWPN@",NULL);
INSERT INTO hebrew_morpho VALUES (93496,"שָׁבוּי-בְּקִסְמוֹ","a",NULL,NULL,"שבוי-בקסמו","שבוי-בקסמו",NULL,"$BWI-BQSMW","$BWI-BQSMW",NULL);
INSERT INTO hebrew_morpho VALUES (93497,"מְמֻשְׁכָּן","a",NULL,"memushkan","ממושכן","ממשכן",NULL,"MM$KN","MMW$KN",NULL);
INSERT INTO hebrew_morpho VALUES (93498,"מְתַסְכֵּל","a",NULL,"metaskel","מתסכל","מתסכל",NULL,"MTSKL","MTSKL",NULL);
INSERT INTO hebrew_morpho VALUES (93499,"מֻגְזָם","a",NULL,"mugzam","מוגזם","מגזם",NULL,"MGZM","MWGZM",NULL);
INSERT INTO hebrew_morpho VALUES (93500,"מְנֻפָּח","a",NULL,"menupach","מנופח","מנפח",NULL,"MNPX","MNWPX",NULL);
INSERT INTO hebrew_morpho VALUES (93501,"מֻפְרָז","a",NULL,"mufraz","מופרז","מפרז",NULL,"MPRZ","MWPRZ",NULL);
INSERT INTO hebrew_morpho VALUES (93502,"מָרוּט","a",NULL,"marut","מרוט","מרוט",NULL,"MRW@","MRW@",NULL);
INSERT INTO hebrew_morpho VALUES (93503,"מֻפְרֶה","a",NULL,"mufre","מופרה","מפרה",NULL,"MPRH","MWPRH",NULL);
INSERT INTO hebrew_morpho VALUES (93504,"מְסֻלְסָל","a",NULL,"mesulsal","מסולסל","מסלסל",NULL,"MSLSL","MSWLSL",NULL);
INSERT INTO hebrew_morpho VALUES (93505,"מְקֻרְזָל","a",NULL,"mekurzal","מקורזל","מקרזל",NULL,"MQRZL","MQWRZL",NULL);
INSERT INTO hebrew_morpho VALUES (93506,"מְגֻלְגָּל","a",NULL,"megulgal","מגולגל","מגלגל",NULL,"MGLGL","MGWLGL",NULL);
INSERT INTO hebrew_morpho VALUES (93507,"מְגוֹלָל","a",NULL,"megolal","מגולל","מגולל",NULL,"MGWLL","MGWLL",NULL);
INSERT INTO hebrew_morpho VALUES (93508,"גָּלוּל","a",NULL,"galul","גלול","גלול",NULL,"GLWL","GLWL",NULL);
INSERT INTO hebrew_morpho VALUES (93509,"מְשֻׁעְבָּד","a",NULL,"meshu\'abad","משועבד","משעבד",NULL,"M$&BD","M$W&BD",NULL);
INSERT INTO hebrew_morpho VALUES (93510,"מְעֻפָּשׁ","a",NULL,"me\'upash","מעופש","מעפש",NULL,"M&P$","M&WP$",NULL);
INSERT INTO hebrew_morpho VALUES (93511,"עָבֵשׁ","a",NULL,"avesh","עבש","עבש",NULL,"&B$","&B$",NULL);
INSERT INTO hebrew_morpho VALUES (93512,"מְעֻשָּׁן","a",NULL,"me\'ushan","מעושן","מעשן",NULL,"M&$N","M&W$N",NULL);
INSERT INTO hebrew_morpho VALUES (93513,"מֻפְקָע","a",NULL,"mufka","מופקע","מפקע",NULL,"MPQ&","MWPQ&",NULL);
INSERT INTO hebrew_morpho VALUES (93514,"מַדְאִיג","a",NULL,"mad\'ig","מדאיג","מדאיג",NULL,"MDAIG","MDAIG",NULL);
INSERT INTO hebrew_morpho VALUES (93515,"מַטְעֶה","a",NULL,"mat\'eh","מטעה","מטעה",NULL,"M@&H","M@&H",NULL);
INSERT INTO hebrew_morpho VALUES (93516,"מְחֻמָּם","a",NULL,"mechumam","מחומם","מחמם",NULL,"MXMM","MXWMM",NULL);
INSERT INTO hebrew_morpho VALUES (93517,"שָׁנוּן","a",NULL,"shanun","שנון","שנון",NULL,"$NWN","$NWN",NULL);
INSERT INTO hebrew_morpho VALUES (93518,"מְפֻלְפָּל","a",NULL,"mefulpal","מפולפל","מפלפל",NULL,"MPLPL","MPWLPL",NULL);
INSERT INTO hebrew_morpho VALUES (93519,"מְיֹעָד","a",NULL,"meyo\'ad","מיועד","מיעד",NULL,"MI&D","MIW&D",NULL);
INSERT INTO hebrew_morpho VALUES (93520,"מְאֻכְלָס","a",NULL,"me\'uchlas","מאוכלס","מאכלס",NULL,"MAKLS","MAWKLS",NULL);
INSERT INTO hebrew_morpho VALUES (93521,"מְעֹרָב","a",NULL,"me\'orav","מעורב","מערב",NULL,"M&RB","M&WRB",NULL);
INSERT INTO hebrew_morpho VALUES (93522,"מְעַנְיֵן","a",NULL,"me\'anyen","מעניין","מענין",NULL,"M&NIN","M&NIIN",NULL);
INSERT INTO hebrew_morpho VALUES (93523,"מְשַׁעֲמֵם","a",NULL,"mesha\'amem","משעמם","משעמם",NULL,"M$&MM","M$&MM",NULL);
INSERT INTO hebrew_morpho VALUES (93524,"מְגֹהָץ","a",NULL,"megohatz","מגוהץ","מגהץ",NULL,"MGHC","MGWHC",NULL);
INSERT INTO hebrew_morpho VALUES (93525,"מַחֲרִישׁ-אָזְנַיִם","a",NULL,"macharish-oznayim","מחריש-אוזניים","מחריש-אזנים",NULL,"MXRI$-AZNIM","MXRI$-AWZNIIM",NULL);
INSERT INTO hebrew_morpho VALUES (93526,"מְצֻיָּן","a",NULL,"metzuyan","מצוין","מצין",NULL,"MCIN","MCWIN",NULL);
INSERT INTO hebrew_morpho VALUES (93527,"מְעֻלֶּה","a",NULL,"me\'ule","מעולה","מעלה",NULL,"M&LH","M&WLH",NULL);
INSERT INTO hebrew_morpho VALUES (93528,"מְרַבִּי","a",NULL,"merabi","מרבי","מרבי",NULL,"MRBI","MRBI",NULL);
INSERT INTO hebrew_morpho VALUES (93529,"מַקְסִימָלִי","a",NULL,"maksimali","מקסימאלי","מקסימלי",NULL,"MQSIMLI","MQSIMALI",NULL);
INSERT INTO hebrew_morpho VALUES (93530,"מִזְעָרִי","a",NULL,"miz\'ari","מזערי","מזערי",NULL,"MZ&RI","MZ&RI",NULL);
INSERT INTO hebrew_morpho VALUES (93531,"מִינִימָלִי","a",NULL,"minimali","מינימאלי","מינימלי",NULL,"MINIMLI","MINIMALI",NULL);
INSERT INTO hebrew_morpho VALUES (93532,"כָּרוּי","a",NULL,"karuy","כרוי","כרוי",NULL,"KRWI","KRWI",NULL);
INSERT INTO hebrew_morpho VALUES (93533,"מֻתָּךְ","a",NULL,"mutach","מותך","מתך",NULL,"MTK","MWTK",NULL);
INSERT INTO hebrew_morpho VALUES (93534,"מָתוּן","a",NULL,"matun","מתון","מתון",NULL,"MTWN","MTWN",NULL);
INSERT INTO hebrew_morpho VALUES (93535,"מְמֻנָּע","a",NULL,"memuna","ממונע","ממנע",NULL,"MMN&","MMWN&",NULL);
INSERT INTO hebrew_morpho VALUES (93536,"מוֹטוֹרִי","a",NULL,"motori","מוטורי","מוטורי",NULL,"MW@WRI","MW@WRI",NULL);
INSERT INTO hebrew_morpho VALUES (93537,"מְיֻתָּר","a",NULL,"meyutar","מיותר","מיתר",NULL,"MITR","MIWTR",NULL);
INSERT INTO hebrew_morpho VALUES (93538,"מְלֻכְלָךְ","a",NULL,"meluchlach","מלוכלך","מלכלך",NULL,"MLKLK","MLWKLK",NULL);
INSERT INTO hebrew_morpho VALUES (93539,"מַגְעִיל","a",NULL,"mag\'il","מגעיל","מגעיל",NULL,"MG&IL","MG&IL",NULL);
INSERT INTO hebrew_morpho VALUES (93540,"אַרְכָאִי","a",NULL,"archa\'i","ארכאי","ארכאי",NULL,"ARKAI","ARKAI",NULL);
INSERT INTO hebrew_morpho VALUES (93541,"מִלִּפְנֵי-הַמַּבּוּל","a",NULL,NULL,"מלפני-המבול","מלפני-המבול",NULL,"MLPNI-HMBWL","MLPNI-HMBWL",NULL);
INSERT INTO hebrew_morpho VALUES (93542,"מְבֻטָּל","a",NULL,"mevutal","מבוטל","מבטל",NULL,"MB@L","MBW@L",NULL);
INSERT INTO hebrew_morpho VALUES (93543,"מֻקָּף","a",NULL,"mukaf","מוקף","מקף",NULL,"MQP","MWQP",NULL);
INSERT INTO hebrew_morpho VALUES (93544,"מְקֹרֶה","a",NULL,"mekore","מקורה","מקרה",NULL,"MQRH","MQWRH",NULL);
INSERT INTO hebrew_morpho VALUES (93545,"מְסֻיָּד","a",NULL,"mesuyad","מסויד","מסיד",NULL,"MSID","MSWID",NULL);
INSERT INTO hebrew_morpho VALUES (93546,"מְתֹאָר","a",NULL,"meto\'ar","מתואר","מתאר",NULL,"MTAR","MTWAR",NULL);
INSERT INTO hebrew_morpho VALUES (93547,"מְאֻלְתָּר","a",NULL,"me\'ultar","מאולתר","מאלתר",NULL,"MALTR","MAWLTR",NULL);
INSERT INTO hebrew_morpho VALUES (93548,"אִימְפְּרוֹבִיזוֹרִי","a",NULL,"improvizori","אימפרוביזורי","אימפרוביזורי",NULL,"AIMPRWBIZWRI","AIMPRWBIZWRI",NULL);
INSERT INTO hebrew_morpho VALUES (93549,"מְפֻסְפָּס","a",NULL,"mefuspas","מפוספס","מפספס",NULL,"MPSPS","MPWSPS",NULL);
INSERT INTO hebrew_morpho VALUES (93550,"מְשֻׁעְשָׁע","a",NULL,"meshu\'asha","משועשע","משעשע",NULL,"M$&$&","M$W&$&",NULL);
INSERT INTO hebrew_morpho VALUES (93551,"מְשָׁעֳשָׁע","a",NULL,"mesho\'asha","משועשע","משעשע",NULL,"M$&$&","M$W&$&",NULL);
INSERT INTO hebrew_morpho VALUES (93552,"מְבֻדָּר","a",NULL,"mevudar","מבודר","מבדר",NULL,"MBDR","MBWDR",NULL);
INSERT INTO hebrew_morpho VALUES (93553,"מְעוֹדָד","a",NULL,"me\'odad","מעודד","מעודד",NULL,"M&WDD","M&WDD",NULL);
INSERT INTO hebrew_morpho VALUES (93554,"מְנֻגָּד","a",NULL,"menugad","מנוגד","מנגד",NULL,"MNGD","MNWGD",NULL);
INSERT INTO hebrew_morpho VALUES (93555,"מֻכְשָׁר","a",NULL,"muchshar","מוכשר","מכשר",NULL,"MK$R","MWK$R",NULL);
INSERT INTO hebrew_morpho VALUES (93556,"כִּשְׁרוֹנִי","a",NULL,"kishroni","כשרוני","כשרוני",NULL,"K$RWNI","K$RWNI",NULL);
INSERT INTO hebrew_morpho VALUES (93557,"בַּעַל-כִּשָּׁרוֹן","a",NULL,"ba\'al-kisharon","בעל-כשרון","בעל-כשרון",NULL,"B&L-K$RWN","B&L-K$RWN",NULL);
INSERT INTO hebrew_morpho VALUES (93558,"בְּרוּךְ-כִּשָּׁרוֹן","a",NULL,"bruch-kisharon","ברוך-כשרון","ברוך-כשרון",NULL,"BRWK-K$RWN","BRWK-K$RWN",NULL);
INSERT INTO hebrew_morpho VALUES (93559,"מַעֲשִׂי","a",NULL,"ma\'asi","מעשי","מעשי",NULL,"M&$I","M&$I",NULL);
INSERT INTO hebrew_morpho VALUES (93560,"פְּרַקְטִי","a",NULL,"prakti","פרקטי","פרקטי",NULL,"PRQ@I","PRQ@I",NULL);
INSERT INTO hebrew_morpho VALUES (93561,"פְּרַגְמָטִי","a",NULL,"pragmati","פרגמטי","פרגמטי",NULL,"PRGM@I","PRGM@I",NULL);
INSERT INTO hebrew_morpho VALUES (93562,"תַּרְבּוּתִי","a",NULL,"tarbuti","תרבותי","תרבותי",NULL,"TRBWTI","TRBWTI",NULL);
INSERT INTO hebrew_morpho VALUES (93563,"מְתֻרְבָּת","a",NULL,"meturbat","מתורבת","מתרבת",NULL,"MTRBT","MTWRBT",NULL);
INSERT INTO hebrew_morpho VALUES (93564,"מְתֻקָּן","a",NULL,"metukan","מתוקן","מתקן",NULL,"MTQN","MTWQN",NULL);
INSERT INTO hebrew_morpho VALUES (93565,"מְשֻׁקָּם","a",NULL,"meshukam","משוקם","משקם",NULL,"M$QM","M$WQM",NULL);
INSERT INTO hebrew_morpho VALUES (93566,"מְחֻדָּשׁ","a",NULL,"mechudash","מחודש","מחדש",NULL,"MXD$","MXWD$",NULL);
INSERT INTO hebrew_morpho VALUES (93567,"מוּסָרִי","a",NULL,"musari","מוסרי","מוסרי",NULL,"MWSRI","MWSRI",NULL);
INSERT INTO hebrew_morpho VALUES (93568,"אֶתִי","a",NULL,"eti","אתי","אתי",NULL,"ATI","ATI",NULL);
INSERT INTO hebrew_morpho VALUES (93569,"מְקֻדָּשׁ","a",NULL,"mekudash","מקודש","מקדש",NULL,"MQD$","MQWD$",NULL);
INSERT INTO hebrew_morpho VALUES (93570,"מְסֻכָּן","a",NULL,"mesukan","מסוכן","מסכן",NULL,"MSKN","MSWKN",NULL);
INSERT INTO hebrew_morpho VALUES (93571,"מַדָּעִי","a",NULL,"mada\'i","מדעי","מדעי",NULL,"MD&I","MD&I",NULL);
INSERT INTO hebrew_morpho VALUES (93572,"מְבֻטָּח","a",NULL,"mevutach","מבוטח","מבטח",NULL,"MB@X","MBW@X",NULL);
INSERT INTO hebrew_morpho VALUES (93573,"מְגֻלָּח","a",NULL,"megulach","מגולח","מגלח",NULL,"MGLX","MGWLX",NULL);
INSERT INTO hebrew_morpho VALUES (93574,"מֻרְכָּב","a",NULL,"murkav","מורכב","מרכב",NULL,"MRKB","MWRKB",NULL);
INSERT INTO hebrew_morpho VALUES (93575,"מְיֻמָּן","a",NULL,"meyuman","מיומן","מימן",NULL,"MIMN","MIWMN",NULL);
INSERT INTO hebrew_morpho VALUES (93576,"מְשֻׁנָּן","a",NULL,"meshunan","משונן","משנן",NULL,"M$NN","M$WNN",NULL);
INSERT INTO hebrew_morpho VALUES (93577,"מְסֻקָּס","a",NULL,"mesukas","מסוקס","מסקס",NULL,"MSQS","MSWQS",NULL);
INSERT INTO hebrew_morpho VALUES (93578,"מֻפְתָּע","a",NULL,"mufta","מופתע","מפתע",NULL,"MPT&","MWPT&",NULL);
INSERT INTO hebrew_morpho VALUES (93579,"מַפְתִּיעַ","a",NULL,"mafti\'a","מפתיע","מפתיע",NULL,"MPTI&","MPTI&",NULL);
INSERT INTO hebrew_morpho VALUES (93580,"מַתְמִיהַּ","a",NULL,"matmi\'ah","מתמיה","מתמיה",NULL,"MTMIH","MTMIH",NULL);
INSERT INTO hebrew_morpho VALUES (93581,"מְחֻסָּן","a",NULL,"mechusan","מחוסן","מחסן",NULL,"MXSN","MXWSN",NULL);
INSERT INTO hebrew_morpho VALUES (93582,"מָלוּחַ","a",NULL,"malu\'ach","מלוח","מלוח",NULL,"MLWX","MLWX",NULL);
INSERT INTO hebrew_morpho VALUES (93583,"מְסֻדָּר","a",NULL,"mesudar","מסודר","מסדר",NULL,"MSDR","MSWDR",NULL);
INSERT INTO hebrew_morpho VALUES (93584,"מְאֻוְרָר","a",NULL,"me\'uvrar","מאוורר","מאורר",NULL,"MAWRR","MAWWRR",NULL);
INSERT INTO hebrew_morpho VALUES (93585,"מֻסְוֶה","a",NULL,"musve","מוסווה","מסוה",NULL,"MSWH","MWSWWH",NULL);
INSERT INTO hebrew_morpho VALUES (93586,"מְמֻזָּג","a",NULL,"memuzag","ממוזג","ממזג",NULL,"MMZG","MMWZG",NULL);
INSERT INTO hebrew_morpho VALUES (93587,"מְיֻזָּע","a",NULL,"meyuza","מיוזע","מיזע",NULL,"MIZ&","MIWZ&",NULL);
INSERT INTO hebrew_morpho VALUES (93588,"מְשִׁיחִי","a",NULL,"meshichi","משיחי","משיחי",NULL,"M$IXI","M$IXI",NULL);
INSERT INTO hebrew_morpho VALUES (93589,"מַחְלַקְתִּי","a",NULL,"machlakti","מחלקתי","מחלקתי",NULL,"MXLQTI","MXLQTI",NULL);
INSERT INTO hebrew_morpho VALUES (93590,"מְחֻמְצָן","a",NULL,"mechumtzan","מחומצן","מחמצן",NULL,"MXMCN","MXWMCN",NULL);
INSERT INTO hebrew_morpho VALUES (93591,"מְפֻסְטָר","a",NULL,"mefustar","מפוסטר","מפסטר",NULL,"MPS@R","MPWS@R",NULL);
INSERT INTO hebrew_morpho VALUES (93592,"מָעוּךְ","a",NULL,"ma\'uch","מעוך","מעוך",NULL,"M&WK","M&WK",NULL);
INSERT INTO hebrew_morpho VALUES (93593,"מָשַׁךְ","v",NULL,"mashach","משך","משך",NULL,"M$K","M$K",NULL);
INSERT INTO hebrew_morpho VALUES (93594,"מָעַל","v",NULL,"ma\'al","מעל","מעל",NULL,"M&L","M&L",NULL);
INSERT INTO hebrew_morpho VALUES (93595,"מִסְחֵר","v",NULL,"mischer","מיסחר","מסחר",NULL,"MSXR","MISXR",NULL);
INSERT INTO hebrew_morpho VALUES (93596,"הִתְרַכֵּז","v",NULL,"hitrakez","התרכז","התרכז",NULL,"HTRKZ","HTRKZ",NULL);
INSERT INTO hebrew_morpho VALUES (93597,"הִתְמַקֵּד","v",NULL,"hitmaked","התמקד","התמקד",NULL,"HTMQD","HTMQD",NULL);
INSERT INTO hebrew_morpho VALUES (93598,"מִקֵּד","v",NULL,"miked","מיקד","מקד",NULL,"MQD","MIQD",NULL);
INSERT INTO hebrew_morpho VALUES (93599,"רִכֵּז","v",NULL,"rikez","ריכז","רכז",NULL,"RKZ","RIKZ",NULL);
INSERT INTO hebrew_morpho VALUES (93600,"מָדַד","v",NULL,"madad","מדד","מדד",NULL,"MDD","MDD",NULL);
INSERT INTO hebrew_morpho VALUES (93601,"מְאוֹד","r",NULL,"me\'od","מאוד","מאוד",NULL,"MAWD","MAWD",NULL);
INSERT INTO hebrew_morpho VALUES (93602,"מַה-זֶּה","r",NULL,"ma-ze","מה-זה","מה-זה",NULL,"MH-ZH","MH-ZH",NULL);
INSERT INTO hebrew_morpho VALUES (93603,"נוֹרָא","r",NULL,"nora","נורא","נורא",NULL,"NWRA","NWRA",NULL);
INSERT INTO hebrew_morpho VALUES (93604,"מִזְרָחָה","r",NULL,"mizracha","מזרחה","מזרחה",NULL,"MZRXH","MZRXH",NULL);
INSERT INTO hebrew_morpho VALUES (93605,"בְּרִפְרוּף","r",NULL,"berifruf","בריפרוף","ברפרוף",NULL,"BRPRWP","BRIPRWP",NULL);
INSERT INTO hebrew_morpho VALUES (93606,"מֵחָדָשׁ","r",NULL,"mechadash","מחדש","מחדש",NULL,"MXD$","MXD$",NULL);
INSERT INTO hebrew_morpho VALUES (93607,"מִדַּי","r",NULL,"miday","מדי","מדי",NULL,"MDI","MDI",NULL);
INSERT INTO hebrew_morpho VALUES (93608,"מֵרֹאשׁ","r",NULL,"merosh","מראש","מראש",NULL,"MRA$","MRA$",NULL);
INSERT INTO hebrew_morpho VALUES (93609,"מָחָר","n",NULL,"machar","מחר","מחר",NULL,"MXR","MXR",NULL);
INSERT INTO hebrew_morpho VALUES (93610,"הַמְשָׁכָה","n",NULL,"hamshacha","המשכה","המשכה",NULL,"HM$KH","HM$KH",NULL);
INSERT INTO hebrew_morpho VALUES (93611,"מֶשֶׁךְ","n",NULL,"meshech","משך","משך",NULL,"M$K","M$K",NULL);
INSERT INTO hebrew_morpho VALUES (93612,"מֵמֵס","n",NULL,"memes","ממס","ממס",NULL,"MMS","MMS",NULL);
INSERT INTO hebrew_morpho VALUES (93613,"מֶתָן","n",NULL,"metan","מתן","מתן",NULL,"MTN","MTN",NULL);
INSERT INTO hebrew_morpho VALUES (93614,"מֶרֶק","n",NULL,"merek","מרק","מרק",NULL,"MRQ","MRQ",NULL);
INSERT INTO hebrew_morpho VALUES (93615,"מַחְצָב","n",NULL,"machtzav","מחצב","מחצב",NULL,"MXCB","MXCB",NULL);
INSERT INTO hebrew_morpho VALUES (93616,"מִינֶרָל","n",NULL,"mineral","מינרל","מינרל",NULL,"MINRL","MINRL",NULL);
INSERT INTO hebrew_morpho VALUES (93617,"מֵימָן","n",NULL,"meiman","מימן","מימן",NULL,"MIMN","MIMN",NULL);
INSERT INTO hebrew_morpho VALUES (93618,"מַתֶּכֶת","n",NULL,"matechet","מתכת","מתכת",NULL,"MTKT","MTKT",NULL);
INSERT INTO hebrew_morpho VALUES (93619,"עֵירֹם","n",NULL,"eirom","עירום","עירם",NULL,"&IRM","&IRWM",NULL);
INSERT INTO hebrew_morpho VALUES (93620,"מַעַר","n",NULL,"ma\'ar","מער","מער",NULL,"M&R","M&R",NULL);
INSERT INTO hebrew_morpho VALUES (93621,"לָמִינִיטִיס","n",NULL,NULL,"למיניטיס","למיניטיס",NULL,"LMINI@IS","LMINI@IS",NULL);
INSERT INTO hebrew_morpho VALUES (93622,"מַשְׁבֵּר","n",NULL,"mashber","משבר","משבר",NULL,"M$BR","M$BR",NULL);
INSERT INTO hebrew_morpho VALUES (93623,"עַמּוּד","n",NULL,"amud","עמוד","עמוד",NULL,"&MWD","&MWD",NULL);
INSERT INTO hebrew_morpho VALUES (93624,"מִגְדָּל","n",NULL,"migdal","מגדל","מגדל",NULL,"MGDL","MGDL",NULL);
INSERT INTO hebrew_morpho VALUES (93625,"מַלְבֵּן","n",NULL,"malben","מלבן","מלבן",NULL,"MLBN","MLBN",NULL);
INSERT INTO hebrew_morpho VALUES (93626,"מְעֻיָּן","n",NULL,"me\'uyan","מעוין","מעין",NULL,"M&IN","M&WIN",NULL);
INSERT INTO hebrew_morpho VALUES (93627,"רוֹמְבּוּס","n",NULL,"rombus","רומבוס","רומבוס",NULL,"RWMBWS","RWMBWS",NULL);
INSERT INTO hebrew_morpho VALUES (93628,"מְתֻמָּן","n",NULL,"metuman","מתומן","מתמן",NULL,"MTMN","MTWMN",NULL);
INSERT INTO hebrew_morpho VALUES (93629,"אוֹקְטָגוֹן","n",NULL,"oktagon","אוקטגון","אוקטגון",NULL,"AWQ@GWN","AWQ@GWN",NULL);
INSERT INTO hebrew_morpho VALUES (93630,"מְשֻׁשֶּׁה","n",NULL,"meshushe","משושה","מששה",NULL,"M$$H","M$W$H",NULL);
INSERT INTO hebrew_morpho VALUES (93631,"הֶקְסָגוֹן","n",NULL,"heksagon","הקסגון","הקסגון",NULL,"HQSGWN","HQSGWN",NULL);
INSERT INTO hebrew_morpho VALUES (93632,"מְחֻמָּשׁ","n",NULL,"mechumash","מחומש","מחמש",NULL,"MXM$","MXWM$",NULL);
INSERT INTO hebrew_morpho VALUES (93633,"פֶּנְטָגוֹן","n",NULL,"pentagon","פנטגון","פנטגון",NULL,"PN@GWN","PN@GWN",NULL);
INSERT INTO hebrew_morpho VALUES (93634,"מַקְבִּילִית","n",NULL,"makbilit","מקבילית","מקבילית",NULL,"MQBILIT","MQBILIT",NULL);
INSERT INTO hebrew_morpho VALUES (93635,"מְרֻבָּע","n",NULL,"meruba","מרובע","מרבע",NULL,"MRB&","MRWB&",NULL);
INSERT INTO hebrew_morpho VALUES (93636,"מְרֻבָּע","a",NULL,"meruba","מרובע","מרבע",NULL,"MRB&","MRWB&",NULL);
INSERT INTO hebrew_morpho VALUES (93637,"מְצֻלָּע","n",NULL,"metzula","מצולע","מצלע",NULL,"MCL&","MCWL&",NULL);
INSERT INTO hebrew_morpho VALUES (93638,"פּוֹלִיגוֹן","n",NULL,"poligon","פוליגון","פוליגון",NULL,"PWLIGWN","PWLIGWN",NULL);
INSERT INTO hebrew_morpho VALUES (93639,"מְשֻׁבָּע","n",NULL,"meshuba","משובע","משבע",NULL,"M$B&","M$WB&",NULL);
INSERT INTO hebrew_morpho VALUES (93640,"הֶפְּטָגוֹן","n",NULL,"heptagon","הפטגון","הפטגון",NULL,"HP@GWN","HP@GWN",NULL);
INSERT INTO hebrew_morpho VALUES (93641,"מְעֻשָּׂר","n",NULL,"me\'usar","מעושר","מעשר",NULL,"M&$R","M&W$R",NULL);
INSERT INTO hebrew_morpho VALUES (93642,"דֶּקָגוֹן","n",NULL,"dekagon","דקגון","דקגון",NULL,"DQGWN","DQGWN",NULL);
INSERT INTO hebrew_morpho VALUES (93643,"מְתֻשָׁע","n",NULL,"metusha","מתושע","מתשע",NULL,"MT$&","MTW$&",NULL);
INSERT INTO hebrew_morpho VALUES (93644,"מְצֻלָּע-קָמוּר","n",NULL,"metzula-kamur","מצולע-קמור","מצלע-קמור",NULL,"MCL&-QMWR","MCWL&-QMWR",NULL);
INSERT INTO hebrew_morpho VALUES (93645,"מְצֻלָּע-מְשֻׁכְלָל","n",NULL,"metzula-meshuchlal","מצולע-משכלל","מצלע-משכלל",NULL,"MCL&-M$KLL","MCWL&-M$KLL",NULL);
INSERT INTO hebrew_morpho VALUES (93646,"מְצֻלָּע-קָעוּר","n",NULL,"metzula-ka\'ur","מצולע-קעור","מצלע-קעור",NULL,"MCL&-Q&WR","MCWL&-Q&WR",NULL);
INSERT INTO hebrew_morpho VALUES (93647,"מֵאִית","n",NULL,"me\'it","מאית","מאית",NULL,"MAIT","MAIT",NULL);
INSERT INTO hebrew_morpho VALUES (93648,"שֶׁבֶר-פָּשׁוּט","n",NULL,"shever-pashut","שבר-פשוט","שבר-פשוט",NULL,"$BR-P$W@","$BR-P$W@",NULL);
INSERT INTO hebrew_morpho VALUES (93649,"שֶׁבֶר","n",NULL,"shever","שבר","שבר",NULL,"$BR","$BR",NULL);
INSERT INTO hebrew_morpho VALUES (93650,"רֶבַע","n",NULL,"reva","רבע","רבע",NULL,"RB&","RB&",NULL);
INSERT INTO hebrew_morpho VALUES (93651,"שְׁבִיעִית","n",NULL,"shvi\'it","שביעית","שביעית",NULL,"$BI&IT","$BI&IT",NULL);
INSERT INTO hebrew_morpho VALUES (93652,"מִילְיוֹן","n",NULL,"milyon","מיליון","מיליון",NULL,"MILIWN","MILIWN",NULL);
INSERT INTO hebrew_morpho VALUES (93653,"מֵאָה","n",NULL,"me\'ah","מאה","מאה",NULL,"MAH","MAH",NULL);
INSERT INTO hebrew_morpho VALUES (93654,"מוֹל","n",NULL,"mol","מול","מול",NULL,"MWL","MWL",NULL);
INSERT INTO hebrew_morpho VALUES (93655,"מַטְבֵּעַ","n",NULL,"matbe\'a","מטבע","מטבע",NULL,"M@B&","M@B&",NULL);
INSERT INTO hebrew_morpho VALUES (93656,"מוֹלִיךְ","n",NULL,"molich","מוליך","מוליך",NULL,"MWLIK","MWLIK",NULL);
INSERT INTO hebrew_morpho VALUES (93657,"מַחֲלָה","n",NULL,"machala","מחלה","מחלה",NULL,"MXLH","MXLH",NULL);
INSERT INTO hebrew_morpho VALUES (93658,"שִׁעְבּוּד","n",NULL,"shi\'ebud","שעבוד","שעבוד",NULL,"$&BWD","$&BWD",NULL);
INSERT INTO hebrew_morpho VALUES (93659,"מַשְׁכַּנְתָּה","n",NULL,"mashkanta","משכנתה","משכנתה",NULL,"M$KNTH","M$KNTH",NULL);
INSERT INTO hebrew_morpho VALUES (93660,"מַשְׁכַּנְתָּא","n",NULL,"mashkanta","משכנתא","משכנתא",NULL,"M$KNTA","M$KNTA",NULL);
INSERT INTO hebrew_morpho VALUES (93661,"מַס","n",NULL,"mas","מס","מס",NULL,"MS","MS",NULL);
INSERT INTO hebrew_morpho VALUES (93662,"מִנּוּי","n",NULL,"minuy","מינוי","מנוי",NULL,"MNWI","MINWI",NULL);
INSERT INTO hebrew_morpho VALUES (93663,"מַשְׂכֹּרֶת","n",NULL,"maskoret","משכורת","משכרת",NULL,"M$KRT","M$KWRT",NULL);
INSERT INTO hebrew_morpho VALUES (93664,"שָׂכָר","n",NULL,"sachar","שכר","שכר",NULL,"$KR","$KR",NULL);
INSERT INTO hebrew_morpho VALUES (93665,"מַצְלִיף","n",NULL,"matzlif","מצליף","מצליף",NULL,"MCLIP","MCLIP",NULL);
INSERT INTO hebrew_morpho VALUES (93666,"שׁוֹט","n",NULL,"shot","שוט","שוט",NULL,"$W@","$W@",NULL);
INSERT INTO hebrew_morpho VALUES (93667,"מֵצַר","n",NULL,"metzar","מצר","מצר",NULL,"MCR","MCR",NULL);
INSERT INTO hebrew_morpho VALUES (93668,"מֵצַר-יַבָּשה","n",NULL,NULL,"מצר-יבשה","מצר-יבשה",NULL,"MCR-IB$H","MCR-IB$H",NULL);
INSERT INTO hebrew_morpho VALUES (93669,"מֵצַר-יַבָּשָׁה","n",NULL,"metzar-yabasha","מצר-יבשה","מצר-יבשה",NULL,"MCR-IB$H","MCR-IB$H",NULL);
INSERT INTO hebrew_morpho VALUES (93670,"נָתִיב","n",NULL,"nativ","נתיב","נתיב",NULL,"NTIB","NTIB",NULL);
INSERT INTO hebrew_morpho VALUES (93671,"צוּק","n",NULL,"tzuk","צוק","צוק",NULL,"CWQ","CWQ",NULL);
INSERT INTO hebrew_morpho VALUES (93672,"מָצוּק","n",NULL,"matzuk","מצוק","מצוק",NULL,"MCWQ","MCWQ",NULL);
INSERT INTO hebrew_morpho VALUES (93673,"מָלֶה","n",NULL,"male","מלה","מלה",NULL,"MLH","MLH",NULL);
INSERT INTO hebrew_morpho VALUES (93674,"מַסְלוּל","n",NULL,"maslul","מסלול","מסלול",NULL,"MSLWL","MSLWL",NULL);
INSERT INTO hebrew_morpho VALUES (93675,"מִגְדַּל-תַּצְפִּית","n",NULL,"migdal-tatzpit","מגדל-תצפית","מגדל-תצפית",NULL,"MGDL-TCPIT","MGDL-TCPIT",NULL);
INSERT INTO hebrew_morpho VALUES (93676,"מִצְפֶּה","n",NULL,"mitzpe","מיצפה","מצפה",NULL,"MCPH","MICPH",NULL);
INSERT INTO hebrew_morpho VALUES (93677,"נְקֻדַּת-תַּצְפִּית","n",NULL,"nekudat-tatzpit","נקודת-תצפית","נקדת-תצפית",NULL,"NQDT-TCPIT","NQWDT-TCPIT",NULL);
INSERT INTO hebrew_morpho VALUES (93678,"מֶרְכָּז-הַמִּגְרָשׁ","n",NULL,NULL,"מרכז-המגרש","מרכז-המגרש",NULL,"MRKZ-HMGR$","MRKZ-HMGR$",NULL);
INSERT INTO hebrew_morpho VALUES (93679,"מֻבְלַעַת","n",NULL,"muvla\'at","מובלעת","מבלעת",NULL,"MBL&T","MWBL&T",NULL);
INSERT INTO hebrew_morpho VALUES (93680,"מֶרְכָּז","n",NULL,"merkaz","מרכז","מרכז",NULL,"MRKZ","MRKZ",NULL);
INSERT INTO hebrew_morpho VALUES (93681,"רְקִיעַ-הַשָּׁמַיִם","n",NULL,"reki\'a-hashamayim","רקיע-השמים","רקיע-השמים",NULL,"RQI&-H$MIM","RQI&-H$MIM",NULL);
INSERT INTO hebrew_morpho VALUES (93682,"כִּפַּת-הָרָקִיעַ","n",NULL,"kipat-haraki\'a","כפת-הרקיע","כפת-הרקיע",NULL,"KPT-HRQI&","KPT-HRQI&",NULL);
INSERT INTO hebrew_morpho VALUES (93683,"יִשְׂרָאֵל","n",NULL,"yisra\'el","ישראל","ישראל",NULL,"I$RAL","I$RAL",NULL);
INSERT INTO hebrew_morpho VALUES (93684,"מְדִינַת-יִשְׂרָאֵל","n",NULL,"medinat-yisra\'el","מדינת-ישראל","מדינת-ישראל",NULL,"MDINT-I$RAL","MDINT-I$RAL",NULL);
INSERT INTO hebrew_morpho VALUES (93685,"צִיּוֹן","n",NULL,"tziyon","ציון","ציון",NULL,"CIWN","CIWN",NULL);
INSERT INTO hebrew_morpho VALUES (93686,"אֶרֶץ-יִשְׂרָאֵל","n",NULL,"eretz-yisra\'el","ארץ-ישראל","ארץ-ישראל",NULL,"ARC-I$RAL","ARC-I$RAL",NULL);
INSERT INTO hebrew_morpho VALUES (93687,"מוֹלֶדֶת","n",NULL,"moledet","מולדת","מולדת",NULL,"MWLDT","MWLDT",NULL);
INSERT INTO hebrew_morpho VALUES (93688,"מְכוֹרָה","n",NULL,"mechora","מכורה","מכורה",NULL,"MKWRH","MKWRH",NULL);
INSERT INTO hebrew_morpho VALUES (93689,"אֶרֶץ-מוֹלֶדֶת","n",NULL,"eretz-moledet","ארץ-מולדת","ארץ-מולדת",NULL,"ARC-MWLDT","ARC-MWLDT",NULL);
INSERT INTO hebrew_morpho VALUES (93690,"אֶרֶץ-אָבוֹת","n",NULL,"eretz-avot","ארץ-אבות","ארץ-אבות",NULL,"ARC-ABWT","ARC-ABWT",NULL);
INSERT INTO hebrew_morpho VALUES (93691,"אֶרֶץ-מוֹצָא","n",NULL,"eretz-motza","ארץ-מוצא","ארץ-מוצא",NULL,"ARC-MWCA","ARC-MWCA",NULL);
INSERT INTO hebrew_morpho VALUES (93692,"מִשְׁלַחַת","n",NULL,"mishlachat","משלחת","משלחת",NULL,"M$LXT","M$LXT",NULL);
INSERT INTO hebrew_morpho VALUES (93693,"מוֹעָצָה","n",NULL,"moatza","מועצה","מועצה",NULL,"MW&CH","MW&CH",NULL);
INSERT INTO hebrew_morpho VALUES (93694,"מִפְלָגָה","n",NULL,"miflaga","מפלגה","מפלגה",NULL,"MPLGH","MPLGH",NULL);
INSERT INTO hebrew_morpho VALUES (93695,"מְאַסֵּף","n",NULL,"me\'asef","מאסף","מאסף",NULL,"MASP","MASP",NULL);
INSERT INTO hebrew_morpho VALUES (93696,"כּוֹחַ-מְאַסֵּף","n",NULL,"ko\'ach-me\'asef","כוח-מאסף","כוח-מאסף",NULL,"KWX-MASP","KWX-MASP",NULL);
INSERT INTO hebrew_morpho VALUES (93697,"מַחְלֶקֶת-הַמְּדִינָה","n",NULL,"machleket-hamedina","מחלקת-המדינה","מחלקת-המדינה",NULL,"MXLQT-HMDINH","MXLQT-HMDINH",NULL);
INSERT INTO hebrew_morpho VALUES (93698,"קִבּוּץ","n",NULL,"kibutz","קיבוץ","קבוץ",NULL,"QBWC","QIBWC",NULL);
INSERT INTO hebrew_morpho VALUES (93699,"מוֹסָד","n",NULL,"mosad","מוסד","מוסד",NULL,"MWSD","MWSD",NULL);
INSERT INTO hebrew_morpho VALUES (93700,"מִמְשָׁל","n",NULL,"mimshal","מימשל","ממשל",NULL,"MM$L","MIM$L",NULL);
INSERT INTO hebrew_morpho VALUES (93701,"שִׁלְטוֹן","n",NULL,"shilton","שילטון","שלטון",NULL,"$L@WN","$IL@WN",NULL);
INSERT INTO hebrew_morpho VALUES (93702,"רָשֻׁיּוֹת","n",NULL,"rashuyot","רשויות","רשיות",NULL,"R$IWT","R$WIWT",NULL);
INSERT INTO hebrew_morpho VALUES (93703,"מֶמְשָׁלָה","n",NULL,"memshala","ממשלה","ממשלה",NULL,"MM$LH","MM$LH",NULL);
INSERT INTO hebrew_morpho VALUES (93704,"מַהֲדוּרָה","n",NULL,"mahadura","מהדורה","מהדורה",NULL,"MHDWRH","MHDWRH",NULL);
INSERT INTO hebrew_morpho VALUES (93705,"מִסְפּוֹא","n",NULL,"mispo","מספוא","מספוא",NULL,"MSPWA","MSPWA",NULL);
INSERT INTO hebrew_morpho VALUES (93706,"לֶחֶם-הַקֹּדֶשׁ","n",NULL,"lechem-hakodesh","לחם-הקודש","לחם-הקדש",NULL,"LXM-HQD$","LXM-HQWD$",NULL);
INSERT INTO hebrew_morpho VALUES (93707,"מְתַאֲבֵן","n",NULL,"meta\'aven","מתאבן","מתאבן",NULL,"MTABN","MTABN",NULL);
INSERT INTO hebrew_morpho VALUES (93708,"דּוֹזָה","n",NULL,"doza","דוזה","דוזה",NULL,"DWZH","DWZH",NULL);
INSERT INTO hebrew_morpho VALUES (93709,"מִנּוּן","n",NULL,"minun","מינון","מנון",NULL,"MNWN","MINWN",NULL);
INSERT INTO hebrew_morpho VALUES (93710,"מֹרַת-רוּחַ","n",NULL,"morat-ru\'ach","מורת-רוח","מרת-רוח",NULL,"MRT-RWX","MWRT-RWX",NULL);
INSERT INTO hebrew_morpho VALUES (93711,"מַפֹּלֶת","n",NULL,"mapolet","מפולת","מפלת",NULL,"MPLT","MPWLT",NULL);
INSERT INTO hebrew_morpho VALUES (93712,"פִּרְסֹמֶת","n",NULL,"pirsomet","פרסומת","פרסמת",NULL,"PRSMT","PRSWMT",NULL);
INSERT INTO hebrew_morpho VALUES (93713,"מְחָאָה","n",NULL,"mecha\'ah","מחאה","מחאה",NULL,"MXAH","MXAH",NULL);
INSERT INTO hebrew_morpho VALUES (93714,"מִקּוּחַ","n",NULL,"miku\'ach","מיקוח","מקוח",NULL,"MQWX","MIQWX",NULL);
INSERT INTO hebrew_morpho VALUES (93715,"קוֹדֵם","n",NULL,"kodem","קודם","קודם",NULL,"QWDM","QWDM",NULL);
INSERT INTO hebrew_morpho VALUES (93716,"מִזְרָח","n",NULL,"mizrach","מזרח","מזרח",NULL,"MZRX","MZRX",NULL);
INSERT INTO hebrew_morpho VALUES (93717,"קֶדֶם","n",NULL,"kedem","קדם","קדם",NULL,"QDM","QDM",NULL);
INSERT INTO hebrew_morpho VALUES (93718,"מְקַדֵּם","n",NULL,"mekadem","מקדם","מקדם",NULL,"MQDM","MQDM",NULL);
INSERT INTO hebrew_morpho VALUES (93719,"קוֹדֵם","a",NULL,"kodem","קודם","קודם"," קודם ","QWDM","QWDM",NULL);
INSERT INTO hebrew_morpho VALUES (93720,"מִקְדָּמָה","n",NULL,"mikdama","מקדמה","מקדמה",NULL,"MQDMH","MQDMH",NULL);
INSERT INTO hebrew_morpho VALUES (93721,"הַעֲלָאָה-בְּדַרְגָּה","n",NULL,"ha\'ala\'ah-bedarga","העלאה-בדרגה","העלאה-בדרגה",NULL,"H&LAH-BDRGH","H&LAH-BDRGH",NULL);
INSERT INTO hebrew_morpho VALUES (93722,"קִדּוּם","n",NULL,"kidum","קדום","קדום",NULL,"QDWM","QDWM",NULL);
INSERT INTO hebrew_morpho VALUES (93723,"הִתְקַדְּמוּת","n",NULL,"hitkadmut","התקדמות","התקדמות",NULL,"HTQDMWT","HTQDMWT",NULL);
INSERT INTO hebrew_morpho VALUES (93724,"קְדִימוּת","n",NULL,"kdimut","קדימות","קדימות",NULL,"QDIMWT","QDIMWT",NULL);
INSERT INTO hebrew_morpho VALUES (93725,"קְדִימָה","n",NULL,"kdima","קדימה","קדימה",NULL,"QDIMH","QDIMH",NULL);
INSERT INTO hebrew_morpho VALUES (93726,"הַקְדָּמָה","n",NULL,"hakdama","הקדמה","הקדמה",NULL,"HQDMH","HQDMH",NULL);
INSERT INTO hebrew_morpho VALUES (93727,"פְּתִיחָה","n",NULL,"pticha","פתיחה","פתיחה",NULL,"PTIXH","PTIXH",NULL);
INSERT INTO hebrew_morpho VALUES (93728,"פָּתִיחַ","n",NULL,"pati\'ach","פתיח","פתיח",NULL,"PTIX","PTIX",NULL);
INSERT INTO hebrew_morpho VALUES (93729,"קָדַם","v",NULL,"kadam","קדם","קדם",NULL,"QDM","QDM",NULL);
INSERT INTO hebrew_morpho VALUES (93730,"קִדֵּם","v",NULL,"kidem","קידם","קדם",NULL,"QDM","QIDM",NULL);
INSERT INTO hebrew_morpho VALUES (93731,"קִדֵּם-בִּבְרָכָה","v",NULL,"kidem-bivracha","קידם-בברכה","קדם-בברכה",NULL,"QDM-BBRKH","QIDM-BBRKH",NULL);
INSERT INTO hebrew_morpho VALUES (93732,"קִבֵּל-אֶת-פָּנָיו","v",NULL,"kibel-et-panav","קיבל-את-פניו","קבל-את-פניו",NULL,"QBL-AT-PNIW","QIBL-AT-PNIW",NULL);
INSERT INTO hebrew_morpho VALUES (93733,"הִקְבִּיל-אֶת-פָּנָיו","v",NULL,"hikbil-et-panav","הקביל-את-פניו","הקביל-את-פניו",NULL,"HQBIL-AT-PNIW","HQBIL-AT-PNIW",NULL);
INSERT INTO hebrew_morpho VALUES (93734,"קִדֵּם-אֶת-פָּנָיו","v",NULL,"kidem-et-panav","קידם-את-פניו","קדם-את-פניו",NULL,"QDM-AT-PNIW","QIDM-AT-PNIW",NULL);
INSERT INTO hebrew_morpho VALUES (93735,"הִקְדִּים","v",NULL,"hikdim","הקדים","הקדים",NULL,"HQDIM","HQDIM",NULL);
INSERT INTO hebrew_morpho VALUES (93736,"הִתְקַדֵּם","v",NULL,"hitkadem","התקדם","התקדם",NULL,"HTQDM","HTQDM",NULL);
INSERT INTO hebrew_morpho VALUES (93737,"מְאַמֵּן","n",NULL,"me\'amen","מאמן","מאמן",NULL,"MAMN","MAMN",NULL);
INSERT INTO hebrew_morpho VALUES (93738,"תִּרְגּוּל","n",NULL,"tirgul","תירגול","תרגול",NULL,"TRGWL","TIRGWL",NULL);
INSERT INTO hebrew_morpho VALUES (93739,"הִתְאַמְּנוּת","n",NULL,"hit\'amnut","התאמנות","התאמנות",NULL,"HTAMNWT","HTAMNWT",NULL);
INSERT INTO hebrew_morpho VALUES (93740,"הֶאֱמִין","v",NULL,"he\'emin","האמין","האמין",NULL,"HAMIN","HAMIN",NULL);
INSERT INTO hebrew_morpho VALUES (93741,"אִמֵּן","v",NULL,"imen","אמן","אמן",NULL,"AMN","AMN",NULL);
INSERT INTO hebrew_morpho VALUES (93742,"הִתְאַמֵּן","v",NULL,"hit\'amen","התאמן","התאמן",NULL,"HTAMN","HTAMN",NULL);
INSERT INTO hebrew_morpho VALUES (93743,"תִּרְגֵּל","v",NULL,"tirgel","תירגל","תרגל",NULL,"TRGL","TIRGL",NULL);
INSERT INTO hebrew_morpho VALUES (93744,"מְיֻדָּע","n",NULL,"meyuda","מיודע","מידע",NULL,"MID&","MIWD&",NULL);
INSERT INTO hebrew_morpho VALUES (93745,"מַכָּר","n",NULL,"makar","מכר","מכר",NULL,"MKR","MKR",NULL);
INSERT INTO hebrew_morpho VALUES (93746,"מֵידָע","n",NULL,"meyda","מידע","מידע",NULL,"MID&","MID&",NULL);
INSERT INTO hebrew_morpho VALUES (93747,"אִינְפוֹרְמַצְיָה","n",NULL,"informatzya","אינפורמציה","אינפורמציה",NULL,"AINPWRMCIH","AINPWRMCIH",NULL);
INSERT INTO hebrew_morpho VALUES (93748,"יִדּוּעַ","n",NULL,"yidua","ידוע","ידוע",NULL,"IDW&","IDW&",NULL);
INSERT INTO hebrew_morpho VALUES (93749,"יַדְעָן","a",NULL,"yad\'an","ידען","ידען",NULL,"ID&N","ID&N",NULL);
INSERT INTO hebrew_morpho VALUES (93750,"יָדַע","v",NULL,"yada","ידע","ידע",NULL,"ID&","ID&",NULL);
INSERT INTO hebrew_morpho VALUES (93751,"נוֹדָע","a",NULL,"noda","נודע","נודע",NULL,"NWD&","NWD&",NULL);
INSERT INTO hebrew_morpho VALUES (93752,"הוֹדִיעַ","v",NULL,"hodi\'a","הודיע","הודיע",NULL,"HWDI&","HWDI&",NULL);
INSERT INTO hebrew_morpho VALUES (93753,"יִדֵּעַ","v",NULL,"yide\'a","ידע","ידע",NULL,"ID&","ID&",NULL);
INSERT INTO hebrew_morpho VALUES (93754,"הִתְוַדֵּעַ","v",NULL,"hitvade\'a","התוודע","התודע",NULL,"HTWD&","HTWWD&",NULL);
INSERT INTO hebrew_morpho VALUES (93755,"מְחַבֵּר","n",NULL,"mechaber","מחבר","מחבר",NULL,"MXBR","MXBR",NULL);
INSERT INTO hebrew_morpho VALUES (93756,"סוֹפֵר","n",NULL,"sofer","סופר","סופר",NULL,"SWPR","SWPR",NULL);
INSERT INTO hebrew_morpho VALUES (93757,"חִבּוּר","n",NULL,"chibur","חיבור","חבור",NULL,"XBWR","XIBWR",NULL);
INSERT INTO hebrew_morpho VALUES (93758,"כְּתִיבָה","n",NULL,"ktiva","כתיבה","כתיבה",NULL,"KTIBH","KTIBH",NULL);
INSERT INTO hebrew_morpho VALUES (93759,"חָבַר","v",NULL,"chavar","חבר","חבר",NULL,"XBR","XBR",NULL);
INSERT INTO hebrew_morpho VALUES (93760,"הִצְטָרֵף","v",NULL,"hitztaref","הצטרף","הצטרף",NULL,"HC@RP","HC@RP",NULL);
INSERT INTO hebrew_morpho VALUES (93761,"הִצְמִיד","v",NULL,"hitzmid","הצמיד","הצמיד",NULL,"HCMID","HCMID",NULL);
INSERT INTO hebrew_morpho VALUES (93762,"כָּתַב","v",NULL,"katav","כתב","כתב",NULL,"KTB","KTB",NULL);
INSERT INTO hebrew_morpho VALUES (93763,"הִלְחִין","v",NULL,"hilchin","הלחין","הלחין",NULL,"HLXIN","HLXIN",NULL);
INSERT INTO hebrew_morpho VALUES (93764,"קִשֵּׁר","v",NULL,"kisher","קישר","קשר",NULL,"Q$R","QI$R",NULL);
INSERT INTO hebrew_morpho VALUES (93765,"הִתְחַבֵּר","v",NULL,"hitchaber","התחבר","התחבר",NULL,"HTXBR","HTXBR",NULL);
INSERT INTO hebrew_morpho VALUES (93766,"הֶחְרִים","v",NULL,"hechrim","החרים","החרים",NULL,"HXRIM","HXRIM",NULL);
INSERT INTO hebrew_morpho VALUES (93767,"עִקֵּל","v",NULL,"ikel","עקל","עקל",NULL,"&QL","&QL",NULL);
INSERT INTO hebrew_morpho VALUES (93768,"חִלֵּט","v",NULL,NULL,"חלט","חלט",NULL,"XL@","XL@",NULL);
INSERT INTO hebrew_morpho VALUES (93769,"סוֹבֵב","n",NULL,"sovev","סובב","סובב",NULL,"SWBB","SWBB",NULL);
INSERT INTO hebrew_morpho VALUES (93770,"פִּתּוּל","n",NULL,"pitul","פיתול","פתול",NULL,"PTWL","PITWL",NULL);
INSERT INTO hebrew_morpho VALUES (93771,"עִקּוּל","n",NULL,"ikul","עיקול","עקול",NULL,"&QWL","&IQWL",NULL);
INSERT INTO hebrew_morpho VALUES (93772,"סֶבֶב","n",NULL,"sevev","סבב","סבב",NULL,"SBB","SBB",NULL);
INSERT INTO hebrew_morpho VALUES (93773,"רוֹטַצְיָה","n",NULL,"rotatzya","רוטציה","רוטציה",NULL,"RW@CIH","RW@CIH",NULL);
INSERT INTO hebrew_morpho VALUES (93774,"הִסְתּוֹבְבוּת","n",NULL,"histovevut","הסתובבות","הסתובבות",NULL,"HSTWBBWT","HSTWBBWT",NULL);
INSERT INTO hebrew_morpho VALUES (93775,"הִסְתּוֹבְבוּת","a",NULL,NULL,"הסתובבות","הסתובבות",NULL,"HSTWBBWT","HSTWBBWT",NULL);
INSERT INTO hebrew_morpho VALUES (93776,"הִסְתּוֹבֵב","v",NULL,"histovev","הסתובב","הסתובב",NULL,"HSTWBB","HSTWBB",NULL);
INSERT INTO hebrew_morpho VALUES (93777,"נָסַב","v",NULL,"nasav","נסב","נסב",NULL,"NSB","NSB",NULL);
INSERT INTO hebrew_morpho VALUES (93778,"סוֹבֵב","v",NULL,"sovev","סובב","סובב",NULL,"SWBB","SWBB",NULL);
INSERT INTO hebrew_morpho VALUES (93779,"שׁוֹטֵט","v",NULL,"shotet","שוטט","שוטט",NULL,"$W@@","$W@@",NULL);
INSERT INTO hebrew_morpho VALUES (93780,"סָבַב","v",NULL,"savav","סבב","סבב",NULL,"SBB","SBB",NULL);
INSERT INTO hebrew_morpho VALUES (93781,"גּוֹלֵל","v",NULL,"golel","גולל","גולל",NULL,"GWLL","GWLL",NULL);
INSERT INTO hebrew_morpho VALUES (93782,"לִפֵּף","v",NULL,"lipef","לפף","לפף",NULL,"LPP","LPP",NULL);
INSERT INTO hebrew_morpho VALUES (93783,"עוֹלֶה","n",NULL,"oleh","עולה","עולה",NULL,"&WLH","&WLH",NULL);
INSERT INTO hebrew_morpho VALUES (93784,"מַעְלָה","r",NULL,"ma\'lah","מעלה","מעלה",NULL,"M&LH","M&LH",NULL);
INSERT INTO hebrew_morpho VALUES (93785,"לְמַעְלָה","r",NULL,"lema\'lah","למעלה","למעלה",NULL,"LM&LH","LM&LH",NULL);
INSERT INTO hebrew_morpho VALUES (93786,"שָׁמַיִם","n",NULL,"shamayim","שמיים","שמים",NULL,"$MIM","$MIIM",NULL);
INSERT INTO hebrew_morpho VALUES (93787,"מַעְלָה","n",NULL,"ma\'lah","מעלה","מעלה",NULL,"M&LH","M&LH",NULL);
INSERT INTO hebrew_morpho VALUES (93788,"עֲלוּת","n",NULL,"alut","עלות","עלות",NULL,"&LWT","&LWT",NULL);
INSERT INTO hebrew_morpho VALUES (93789,"הִתְרוֹמְמוּת","n",NULL,"hitromemut","התרוממות","התרוממות",NULL,"HTRWMMWT","HTRWMMWT",NULL);
INSERT INTO hebrew_morpho VALUES (93790,"הַעֲלָאָה","n",NULL,"ha\'ala\'ah","העלאה","העלאה",NULL,"H&LAH","H&LAH",NULL);
INSERT INTO hebrew_morpho VALUES (93791,"הֲרָמָה","n",NULL,"harama","הרמה","הרמה",NULL,"HRMH","HRMH",NULL);
INSERT INTO hebrew_morpho VALUES (93792,"הִתְעַלּוּת","n",NULL,"hit\'alut","התעלות","התעלות",NULL,"HT&LWT","HT&LWT",NULL);
INSERT INTO hebrew_morpho VALUES (93793,"הִתְעַלּוּת-הַנֶּפֶשׁ","n",NULL,NULL,"התעלות-הנפש","התעלות-הנפש",NULL,"HT&LWT-HNP$","HT&LWT-HNP$",NULL);
INSERT INTO hebrew_morpho VALUES (93794,"הִתְרוֹמְמוּת-רוּחַ","n",NULL,NULL,"התרוממות-רוח","התרוממות-רוח",NULL,"HTRWMMWT-RWX","HTRWMMWT-RWX",NULL);
INSERT INTO hebrew_morpho VALUES (93795,"עָלָה","v",NULL,"ala","עלה","עלה",NULL,"&LH","&LH",NULL);
INSERT INTO hebrew_morpho VALUES (93796,"הִגְדִּיל","v",NULL,"higdil","הגדיל","הגדיל",NULL,"HGDIL","HGDIL",NULL);
INSERT INTO hebrew_morpho VALUES (93797,"הֵרִים","v",NULL,"herim","הרים","הרים",NULL,"HRIM","HRIM",NULL);
INSERT INTO hebrew_morpho VALUES (93798,"עוֹרֵר","v",NULL,"orer","עורר","עורר",NULL,"&WRR","&WRR",NULL);
INSERT INTO hebrew_morpho VALUES (93799,"תִּינוֹק","n",NULL,"tinok","תינוק","תינוק",NULL,"TINWQ","TINWQ",NULL);
INSERT INTO hebrew_morpho VALUES (93800,"רוֹפֵא-מְיַלֵּד","n",NULL,"rofe-meyaled","רופא-מיילד","רופא-מילד",NULL,"RWPA-MILD","RWPA-MIILD",NULL);
INSERT INTO hebrew_morpho VALUES (93801,"יַלְדוּת","n",NULL,"yaldut","ילדות","ילדות",NULL,"ILDWT","ILDWT",NULL);
INSERT INTO hebrew_morpho VALUES (93802,"מְיַלְּדוּת","n",NULL,"meyaldut","מיילדות","מילדות",NULL,"MILDWT","MIILDWT",NULL);
INSERT INTO hebrew_morpho VALUES (93803,"יִלּוּד","n",NULL,"yilud","יילוד","ילוד",NULL,"ILWD","IILWD",NULL);
INSERT INTO hebrew_morpho VALUES (93804,"הִפּוּךְ","n",NULL,"hipuch","היפוך","הפוך",NULL,"HPWK","HIPWK",NULL);
INSERT INTO hebrew_morpho VALUES (93805,"הִתְהַפְּכוּת","n",NULL,"hithapchut","התהפכות","התהפכות",NULL,"HTHPKWT","HTHPKWT",NULL);
INSERT INTO hebrew_morpho VALUES (93806,"בִּלְגֵּן","v",NULL,"bilgen","בילגן","בלגן",NULL,"BLGN","BILGN",NULL);
INSERT INTO hebrew_morpho VALUES (93807,"בִּרְדֵּק","v",NULL,"birdek","בירדק","ברדק",NULL,"BRDQ","BIRDQ",NULL);
INSERT INTO hebrew_morpho VALUES (93808,"נֶהֱפַךְ","v",NULL,"nehefach","נהפך","נהפך",NULL,"NHPK","NHPK",NULL);
INSERT INTO hebrew_morpho VALUES (93809,"נֶהְפַּךְ","v",NULL,"nehpach","נהפך","נהפך",NULL,"NHPK","NHPK",NULL);
INSERT INTO hebrew_morpho VALUES (93810,"הִתְהַפֵּךְ","v",NULL,"hithapech","התהפך","התהפך",NULL,"HTHPK","HTHPK",NULL);
INSERT INTO hebrew_morpho VALUES (93811,"סַדָּר","n",NULL,"sadar","סדר","סדר",NULL,"SDR","SDR",NULL);
INSERT INTO hebrew_morpho VALUES (93812,"סַדְרָן","n",NULL,"sadran","סדרן","סדרן",NULL,"SDRN","SDRN",NULL);
INSERT INTO hebrew_morpho VALUES (93813,"חָתוּל","n",NULL,"xatul","חתול","חתול",NULL,"XTWL","XTWL",NULL);
INSERT INTO hebrew_morpho VALUES (93814,"הֶסְדֵּר","n",NULL,"hesder","הסדר","הסדר",NULL,"HSDR","HSDR",NULL);
INSERT INTO hebrew_morpho VALUES (93815,"רֶגוּלַצְיָה","n",NULL,"regulatzya","רגולציה","רגולציה",NULL,"RGWLCIH","RGWLCIH",NULL);
INSERT INTO hebrew_morpho VALUES (93816,"הַסְדָּרָה","n",NULL,"hasdara","הסדרה","הסדרה",NULL,"HSDRH","HSDRH",NULL);
INSERT INTO hebrew_morpho VALUES (93817,"וִסּוּת","n",NULL,"visut","וסות","וסות",NULL,"WSWT","WSWT",NULL);
INSERT INTO hebrew_morpho VALUES (93818,"הִסְתַּדְּרוּת","n",NULL,"histadrut","הסתדרות","הסתדרות",NULL,"HSTDRWT","HSTDRWT",NULL);
INSERT INTO hebrew_morpho VALUES (93819,"אִגּוּד","n",NULL,"igud","איגוד","אגוד",NULL,"AGWD","AIGWD",NULL);
INSERT INTO hebrew_morpho VALUES (93820,"הִסְדִּיר","v",NULL,"hisdir","הסדיר","הסדיר",NULL,"HSDIR","HSDIR",NULL);
INSERT INTO hebrew_morpho VALUES (93821,"הִסְתַּדֵּר","v",NULL,"histader","הסתדר","הסתדר",NULL,"HSTDR","HSTDR",NULL);
INSERT INTO hebrew_morpho VALUES (93822,"סִדֵּר","v",NULL,"sider","סידר","סדר",NULL,"SDR","SIDR",NULL);
INSERT INTO hebrew_morpho VALUES (93823,"עָבַד","v",NULL,"avad","עבד","עבד",NULL,"&BD","&BD",NULL);
INSERT INTO hebrew_morpho VALUES (93824,"יִשֵּׁב","v",NULL,"yishev","ישב","ישב",NULL,"I$B","I$B",NULL);
INSERT INTO hebrew_morpho VALUES (93825,"פּוֹסֵק","n",NULL,"posek","פוסק","פוסק",NULL,"PWSQ","PWSQ",NULL);
INSERT INTO hebrew_morpho VALUES (93826,"נוֹרְמָטִיבִי","a",NULL,"normativi","נורמטיבי","נורמטיבי",NULL,"NWRM@IBI","NWRM@IBI",NULL);
INSERT INTO hebrew_morpho VALUES (93827,"פּוֹסְקָנִי","a",NULL,"poskani","פוסקני","פוסקני",NULL,"PWSQNI","PWSQNI",NULL);
INSERT INTO hebrew_morpho VALUES (93828,"פּוֹסֵק","a",NULL,"posek","פוסק","פוסק",NULL,"PWSQ","PWSQ",NULL);
INSERT INTO hebrew_morpho VALUES (93829,"אוֹרְדִּינָטָה","n",NULL,"ordinata","אורדינטה","אורדינטה",NULL,"AWRDIN@H","AWRDIN@H",NULL);
INSERT INTO hebrew_morpho VALUES (93830,"פִּסּוּק","n",NULL,"pisuk","פסוק","פסוק",NULL,"PSWQ","PSWQ",NULL);
INSERT INTO hebrew_morpho VALUES (93831,"פְּסִיקָה","n",NULL,"psika","פסיקה","פסיקה",NULL,"PSIQH","PSIQH",NULL);
INSERT INTO hebrew_morpho VALUES (93832,"נִמְעָן","n",NULL,"nim\'an","נמען","נמען",NULL,"NM&N","NM&N",NULL);
INSERT INTO hebrew_morpho VALUES (93833,"נָקוּב","a",NULL,"nakuv","נקוב","נקוב",NULL,"NQWB","NQWB",NULL);
INSERT INTO hebrew_morpho VALUES (93834,"הֶפְסֵק","n",NULL,"hefsek","הפסק","הפסק",NULL,"HPSQ","HPSQ",NULL);
INSERT INTO hebrew_morpho VALUES (93835,"דְּמִימָה","n",NULL,"dmima","דמימה","דמימה",NULL,"DMIMH","DMIMH",NULL);
INSERT INTO hebrew_morpho VALUES (93836,"מְנֻקָּב","a",NULL,NULL,"מנקב","מנקב",NULL,"MNQB","MNQB",NULL);
INSERT INTO hebrew_morpho VALUES (93837,"בַּר-מְנִיעָה","a",NULL,"bar meni\'ah","בר-מניעה","בר-מניעה",NULL,"BR-MNI&H","BR-MNI&H",NULL);
INSERT INTO hebrew_morpho VALUES (93838,"מְכֻתָּב","n",NULL,"mexutav","מכתב","מכתב",NULL,"MKTB","MKTB",NULL);
INSERT INTO hebrew_morpho VALUES (93839,"מִכְתָּב","n",NULL,"mixtav","מכתב","מכתב",NULL,"MKTB","MKTB",NULL);
INSERT INTO hebrew_morpho VALUES (93840,"מִכְתָּבָה","n",NULL,"mixtava","מכתבה","מכתבה",NULL,"MKTBH","MKTBH",NULL);
INSERT INTO hebrew_morpho VALUES (93841,"כִּתּוּב","n",NULL,"kituv","כתוב","כתוב",NULL,"KTWB","KTWB",NULL);
INSERT INTO hebrew_morpho VALUES (93842,"הַכְתָּבָה","n",NULL,"haxtava","הכתבה","הכתבה",NULL,"HKTBH","HKTBH",NULL);
INSERT INTO hebrew_morpho VALUES (93844,"הַפְסָקָה","n",NULL,"hafsaka","הפסקה","הפסקה",NULL,"HPSQH","HPSQH",NULL);
INSERT INTO hebrew_morpho VALUES (93845,"פּוּגָה","n",NULL,"puga","פוגה","פוגה",NULL,"PWGH","PWGH",NULL);
INSERT INTO hebrew_morpho VALUES (93846,"הֲפוּגָה","n",NULL,"hafuga","הפוגה","הפוגה",NULL,"HPWGH","HPWGH",NULL);
INSERT INTO hebrew_morpho VALUES (93847,"אֶתְנַחְתָּא","n",NULL,"etnachta","אתנחתא","אתנחתא",NULL,"ATNXTA","ATNXTA",NULL);
INSERT INTO hebrew_morpho VALUES (93848,"פֶּסֶק-זְמַן","n",NULL,"PESEK-ZMAN","פסק-זמן","פסק-זמן",NULL,"PSQ-ZMN","PSQ-ZMN",NULL);
INSERT INTO hebrew_morpho VALUES (93849,"הִתְכַּתְּבוּת","n",NULL,"hitkatvut","התכתבות","התכתבות",NULL,"HTKTBWT","HTKTBWT",NULL);
INSERT INTO hebrew_morpho VALUES (93850,"פָּסַק","v",NULL,"pasak","פסק","פסק",NULL,"PSQ","PSQ",NULL);
INSERT INTO hebrew_morpho VALUES (93851,"הִכְתִּיב","v",NULL,"hixtiv","הכתיב","הכתיב",NULL,"HKTIB","HKTIB",NULL);
INSERT INTO hebrew_morpho VALUES (93852,"הִתְכַּתֵּב","v",NULL,"hitkatev","התכתב","התכתב",NULL,"HTKTB","HTKTB",NULL);
INSERT INTO hebrew_morpho VALUES (93853,"כַּשְׁרוּת","n",NULL,"kashrut","כשרות","כשרות",NULL,"K$RWT","K$RWT",NULL);
INSERT INTO hebrew_morpho VALUES (93854,"נִפְסַק","v",NULL,"nifsak","נפסק","נפסק",NULL,"NPSQ","NPSQ",NULL);
INSERT INTO hebrew_morpho VALUES (93855,"פִּסֵּק","v",NULL,"pisek","פסק","פסק",NULL,"PSQ","PSQ",NULL);
INSERT INTO hebrew_morpho VALUES (93856,"רַכָּב","n",NULL,"rakav","רכב","רכב",NULL,"RKB","RKB",NULL);
INSERT INTO hebrew_morpho VALUES (93857,"רוֹכֵב","n",NULL,"rochev","רוכב","רוכב",NULL,"RWKB","RWKB",NULL);
INSERT INTO hebrew_morpho VALUES (93858,"כּוֹלֵל","n",NULL,"kolel","כולל","כולל",NULL,"KWLL","KWLL",NULL);
INSERT INTO hebrew_morpho VALUES (93859,"כּוֹלֵל","a",NULL,"kolel","כולל","כולל",NULL,"KWLL","KWLL",NULL);
INSERT INTO hebrew_morpho VALUES (93860,"מִכְלָלָה","n",NULL,"mixlala","מכללה","מכללה",NULL,"MKLLH","MKLLH",NULL);
INSERT INTO hebrew_morpho VALUES (93861,"הַכְלָלָה","n",NULL,"haxlala","הכללה","הכללה",NULL,"HKLLH","HKLLH",NULL);
INSERT INTO hebrew_morpho VALUES (93862,"כְּלִילָה","n",NULL,"klila","כלילה","כלילה",NULL,"KLILH","KLILH",NULL);
INSERT INTO hebrew_morpho VALUES (93863,"הִכָּלְלוּת","n",NULL,"hikalelut","היכללות","הכללות",NULL,"HKLLWT","HIKLLWT",NULL);
INSERT INTO hebrew_morpho VALUES (93864,"הִכְלִיל","v",NULL,"hixlil","הכליל","הכליל",NULL,"HKLIL","HKLIL",NULL);
INSERT INTO hebrew_morpho VALUES (93865,"מַחְשְׁבוֹן","n",NULL,"maxshevon","מחשבון","מחשבון",NULL,"MX$BWN","MX$BWN",NULL);
INSERT INTO hebrew_morpho VALUES (93866,"מַחְשָׁבָה","n",NULL,"maxshava","מחשבה","מחשבה",NULL,"MX$BH","MX$BH",NULL);
INSERT INTO hebrew_morpho VALUES (93867,"חֲשִׁיבָה","n",NULL,"xashiva","חשיבה","חשיבה",NULL,"X$IBH","X$IBH",NULL);
INSERT INTO hebrew_morpho VALUES (93868,"חִשּׁוּב","n",NULL,"xishuv","חישוב","חשוב",NULL,"X$WB","XI$WB",NULL);
INSERT INTO hebrew_morpho VALUES (93869,"הֶחְשִׁיב","v",NULL,"hexshiv","החשיב","החשיב",NULL,"HX$IB","HX$IB",NULL);
INSERT INTO hebrew_morpho VALUES (93870,"הִתְחַשְּׁבוּת","n",NULL,"hitxashvut","התחשבות","התחשבות",NULL,"HTX$BWT","HTX$BWT",NULL);
INSERT INTO hebrew_morpho VALUES (93871,"סָבַר","v",NULL,NULL,"סבר","סבר",NULL,"SBR","SBR",NULL);
INSERT INTO hebrew_morpho VALUES (93872,"רֶכֶב","n",NULL,"rechev","רכב","רכב",NULL,"RKB","RKB",NULL);
INSERT INTO hebrew_morpho VALUES (93873,"רְכִיבָה","n",NULL,"rechiva","רכיבה","רכיבה",NULL,"RKIBH","RKIBH",NULL);
INSERT INTO hebrew_morpho VALUES (93874,"רָכַב","v",NULL,"rachav","רכב","רכב",NULL,"RKB","RKB",NULL);
INSERT INTO hebrew_morpho VALUES (93875,"הִתְקִין","v",NULL,"hitkin","התקין","התקין",NULL,"HTQIN","HTQIN",NULL);
INSERT INTO hebrew_morpho VALUES (93876,"חִשֵּׁב","v",NULL,"xishev","חישב","חשב",NULL,"X$B","XI$B",NULL);
INSERT INTO hebrew_morpho VALUES (93877,"הִתְחַשֵּׁב","v",NULL,"hitxashev","התחשב","התחשב",NULL,"HTX$B","HTX$B",NULL);
INSERT INTO hebrew_morpho VALUES (93878,"חֲמִיצָה","n",NULL,"XAMITSA","חמיצה","חמיצה",NULL,"XMICH","XMICH",NULL);
INSERT INTO hebrew_morpho VALUES (93879,"בּוֹרְשְׁט","n",NULL,"borsht","בורשט","בורשט",NULL,"BWR$@","BWR$@",NULL);
INSERT INTO hebrew_morpho VALUES (93880,"חַלְפָן","n",NULL,"xalfan","חלפן","חלפן",NULL,"XLPN","XLPN",NULL);
INSERT INTO hebrew_morpho VALUES (93881,"מֶחְלָף","n",NULL,"mexlaf","מחלף","מחלף",NULL,"MXLP","MXLP",NULL);
INSERT INTO hebrew_morpho VALUES (93882,"מַגְבֵּר","n",NULL,"magber","מגבר","מגבר",NULL,"MGBR","MGBR",NULL);
INSERT INTO hebrew_morpho VALUES (93883,"אֶמְפְּלִיפָיֶר","n",NULL,"emplifayer","אמפליפייר","אמפליפיר",NULL,"AMPLIPIR","AMPLIPIIR",NULL);
INSERT INTO hebrew_morpho VALUES (93884,"גַּבְרִיּוּת","n",NULL,"gavriyut","גבריות","גבריות",NULL,"GBRIWT","GBRIWT",NULL);
INSERT INTO hebrew_morpho VALUES (93885,"גַּבְרוּת","n",NULL,"gavrut","גברות","גברות",NULL,"GBRWT","GBRWT",NULL);
INSERT INTO hebrew_morpho VALUES (93886,"הֶגְבֵּר","n",NULL,"hegber","הגבר","הגבר",NULL,"HGBR","HGBR",NULL);
INSERT INTO hebrew_morpho VALUES (93887,"הִתְגַּבְּרוּת","n",NULL,"hitgabrut","התגברות","התגברות",NULL,"HTGBRWT","HTGBRWT",NULL);
INSERT INTO hebrew_morpho VALUES (93888,"הִתְחַזְּקוּת","n",NULL,"hitchazkut","התחזקות","התחזקות",NULL,"HTXZQWT","HTXZQWT",NULL);
INSERT INTO hebrew_morpho VALUES (93889,"הִתְעַצְּמוּת","n",NULL,"hit\'atzmut","התעצמות","התעצמות",NULL,"HT&CMWT","HT&CMWT",NULL);
INSERT INTO hebrew_morpho VALUES (93890,"הִתְעַצֵּם","v",NULL,"hit\'atzem","התעצם","התעצם",NULL,"HT&CM","HT&CM",NULL);
INSERT INTO hebrew_morpho VALUES (93891,"הִתְחַזֵּק","v",NULL,"hitchazek","התחזק","התחזק",NULL,"HTXZQ","HTXZQ",NULL);
INSERT INTO hebrew_morpho VALUES (93892,"גִּבֵּר","v",NULL,"giber","גבר","גבר",NULL,"GBR","GBR",NULL);
INSERT INTO hebrew_morpho VALUES (93893,"חִזֵּק","v",NULL,"chizek","חזק","חזק",NULL,"XZQ","XZQ",NULL);
INSERT INTO hebrew_morpho VALUES (93894,"הִגְבִּיר","v",NULL,"higbir","הגביר","הגביר",NULL,"HGBIR","HGBIR",NULL);
INSERT INTO hebrew_morpho VALUES (93895,"מַחְלֵף","n",NULL,"machlef","מחלף","מחלף",NULL,"MXLP","MXLP",NULL);
INSERT INTO hebrew_morpho VALUES (93896,"חֲלִיפָה","n",NULL,"xalifa","חליפה","חליפה",NULL,"XLIPH","XLIPH",NULL);
INSERT INTO hebrew_morpho VALUES (93897,"הַחְלָפָה","n",NULL,"haxlafa","החלפה","החלפה",NULL,"HXLPH","HXLPH",NULL);
INSERT INTO hebrew_morpho VALUES (93898,"הִתְחַלֵּף","v",NULL,"hitchalef","התחלף","התחלף",NULL,"HTXLP","HTXLP",NULL);
INSERT INTO hebrew_morpho VALUES (93899,"הֶחְלִיף","v",NULL,"hechlif","החליף","החליף",NULL,"HXLIP","HXLIP",NULL);
INSERT INTO hebrew_morpho VALUES (93900,"הִשְׁתַּנָּה","v",NULL,"hishtana","השתנה","השתנה",NULL,"H$TNH","H$TNH",NULL);
INSERT INTO hebrew_morpho VALUES (93901,"הִשְׁתַּנּוּת","n",NULL,"hishtanut","השתנות","השתנות",NULL,"H$TNWT","H$TNWT",NULL);
INSERT INTO hebrew_morpho VALUES (93902,"הִתְחַלְּפוּת","n",NULL,"hitchalfut","התחלפות","התחלפות",NULL,"HTXLPWT","HTXLPWT",NULL);
INSERT INTO hebrew_morpho VALUES (93903,"חִלּוּף","n",NULL,"chiluf","חילוף","חלוף",NULL,"XLWP","XILWP",NULL);
INSERT INTO hebrew_morpho VALUES (93904,"עִכּוּב","n",NULL,"ikkuv","עיכוב","עכוב",NULL,"&KWB","&IKWB",NULL);
INSERT INTO hebrew_morpho VALUES (93905,"פְּקָק","n",NULL,"pkak","פקק","פקק",NULL,"PQQ","PQQ",NULL);
INSERT INTO hebrew_morpho VALUES (93906,"עִתּוֹן","n",NULL,"itton","עיתון","עתון",NULL,"&TWN","&ITWN",NULL);
INSERT INTO hebrew_morpho VALUES (93907,"עַמְלָה","n",NULL,"amla","עמלה","עמלה",NULL,"&MLH","&MLH",NULL);
INSERT INTO hebrew_morpho VALUES (93908,"קוֹמִיסְיוֹן","n",NULL,"komision","קומיסיון","קומיסיון",NULL,"QWMISIWN","QWMISIWN",NULL);
INSERT INTO hebrew_morpho VALUES (93909,"דַּלּוּת","n",NULL,"dalut","דלות","דלות",NULL,"DLWT","DLWT",NULL);
INSERT INTO hebrew_morpho VALUES (93910,"עֹנִי","n",NULL,"oni","עוני","עני",NULL,"&NI","&WNI",NULL);
INSERT INTO hebrew_morpho VALUES (93911,"עָלֶה-שָׁסוּעַ","n",NULL,"ale-shashu\'a","עלה-שסוע","עלה-שסוע",NULL,"&LH-$SW&","&LH-$SW&",NULL);
INSERT INTO hebrew_morpho VALUES (93912,"עֲצִירוּת","n",NULL,"atsirut","עצירות","עצירות",NULL,"&CIRWT","&CIRWT",NULL);
INSERT INTO hebrew_morpho VALUES (93913,"עַצְמִית","n",NULL,"atsmit","עצמית","עצמית",NULL,"&CMIT","&CMIT",NULL);
INSERT INTO hebrew_morpho VALUES (93914,"עֲבוֹדָה-פִיזִית","n",NULL,"avoda phizit","עבודה-פיזית","עבודה-פיזית",NULL,"&BWDH-PIZIT","&BWDH-PIZIT",NULL);
INSERT INTO hebrew_morpho VALUES (93915,"עִמְעֵם","v",NULL,"im\'em","עמעם","עמעם",NULL,"&M&M","&M&M",NULL);
INSERT INTO hebrew_morpho VALUES (93916,"עוֹרֵךְ-דִּין","n",NULL,"orex din","עורך-דין","עורך-דין",NULL,"&WRK-DIN","&WRK-DIN",NULL);
INSERT INTO hebrew_morpho VALUES (93917,"עוֹרֶכֶת-דִּין","n",NULL,"orexet din","עורכת-דין","עורכת-דין",NULL,"&WRKT-DIN","&WRKT-DIN",NULL);
INSERT INTO hebrew_morpho VALUES (93918,"עֲרָפֶל","n",NULL,"arafel","ערפל","ערפל",NULL,"&RPL","&RPL",NULL);
INSERT INTO hebrew_morpho VALUES (93919,"עֲרָכִים","n",NULL,"araxim","ערכים","ערכים",NULL,"&RKIM","&RKIM",NULL);
INSERT INTO hebrew_morpho VALUES (93920,"הוֹנָה","v",NULL,"hona","הונה","הונה",NULL,"HWNH","HWNH",NULL);
INSERT INTO hebrew_morpho VALUES (93921,"מָכַר","v",NULL,"machar","מכר","מכר",NULL,"MKR","MKR",NULL);
INSERT INTO hebrew_morpho VALUES (93922,"רִמָּה","v",NULL,"rima","רימה","רמה",NULL,"RMH","RIMH",NULL);
INSERT INTO hebrew_morpho VALUES (93923,"מָכַר-לוֹ-לוֹקְשִׁים","v",NULL,"machar-lo-lokshim","מכר-לו-לוקשים","מכר-לו-לוקשים",NULL,"MKR-LW-LWQ$IM","MKR-LW-LWQ$IM",NULL);
INSERT INTO hebrew_morpho VALUES (93924,"מִרְכֵּז","v",NULL,"mirkez","מירכז","מרכז",NULL,"MRKZ","MIRKZ",NULL);
INSERT INTO hebrew_morpho VALUES (93925,"מִיָּד","r",NULL,"miyad","מיד","מיד",NULL,"MID","MID",NULL);
INSERT INTO hebrew_morpho VALUES (93926,"מִיָּדִית","r",NULL,"miyadit","מידית","מידית",NULL,"MIDIT","MIDIT",NULL);
INSERT INTO hebrew_morpho VALUES (93927,"תֵּכֶף-וּמִיָּד","r",NULL,"techef-umiyad","תכף-ומיד","תֵּכֶף-וּמִיָּד",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (93928,"לְלֹא-דִּחוּי","r",NULL,"lelo-dichuy","ללא-דיחוי","ללא-דחוי",NULL,"LLA-DXWI","LLA-DIXWI",NULL);
INSERT INTO hebrew_morpho VALUES (93929,"מַעֲרָבָה","r",NULL,"ma\'arava","מערבה","מערבה",NULL,"M&RBH","M&RBH",NULL);
INSERT INTO hebrew_morpho VALUES (93930,"סְפֶּצִיפִית","r",NULL,"spetzifit","ספציפית","ספציפית",NULL,"SPCIPIT","SPCIPIT",NULL);
INSERT INTO hebrew_morpho VALUES (93931,"עֲדֶשֶׁת-אֱלֶקְטְרוֹנִים","n",NULL,"adeshet elektronim","עדשת-אלקטרונים","עדשת-אלקטרונים",NULL,"&D$T-ALQ@RWNIM","&D$T-ALQ@RWNIM",NULL);
INSERT INTO hebrew_morpho VALUES (93932,"עָרְמָה","n",NULL,"orma","ערמה","ערמה",NULL,"&RMH","&RMH",NULL);
INSERT INTO hebrew_morpho VALUES (93933,"עַרְמוּמִיּוּת","n",NULL,"armumiyut","ערמומיות","ערמומיות",NULL,"&RMWMIWT","&RMWMIWT",NULL);
INSERT INTO hebrew_morpho VALUES (93934,"תַּחְמָנוּת","n",NULL,"taxmanut","תחמנות","תחמנות",NULL,"TXMNWT","TXMNWT",NULL);
INSERT INTO hebrew_morpho VALUES (93935,"הִתְמַשְּׁכוּת","n",NULL,"hitmashchut","התמשכות","התמשכות",NULL,"HTM$KWT","HTM$KWT",NULL);
INSERT INTO hebrew_morpho VALUES (93936,"הִמָּשְׁכוּת","n",NULL,"himashchut","המשכות","המשכות",NULL,"HM$KWT","HM$KWT",NULL);
INSERT INTO hebrew_morpho VALUES (93937,"אָפִיק","n",NULL,"afik","אפיק","אפיק",NULL,"APIQ","APIQ",NULL);
INSERT INTO hebrew_morpho VALUES (93938,"אֲפִיק-תִּמְסֹרֶת","n",NULL,"afik timsoret","אפיק-תמסרת","אפיק-תמסרת",NULL,"APIQ-TMSRT","APIQ-TMSRT",NULL);
INSERT INTO hebrew_morpho VALUES (93939,"תְּחוּם-תְּדָרִים","n",NULL,"txum tedarim","תחום-תדרים","תחום-תדרים",NULL,"TXWM-TDRIM","TXWM-TDRIM",NULL);
INSERT INTO hebrew_morpho VALUES (93940,"עֲנָוָה","n",NULL,"anava","ענווה","ענוה",NULL,"&NWH","&NWWH",NULL);
INSERT INTO hebrew_morpho VALUES (93941,"עַנְוְתָנוּת","n",NULL,"anavtanut","ענותנות","ענותנות",NULL,"&NWTNWT","&NWTNWT",NULL);
INSERT INTO hebrew_morpho VALUES (93942,"עֲמִילָן","n",NULL,"amilan","עמילן","עמילן",NULL,"&MILN","&MILN",NULL);
INSERT INTO hebrew_morpho VALUES (93943,"עָקַב","v",NULL,"akav","עקב","עקב",NULL,"&QB","&QB",NULL);
INSERT INTO hebrew_morpho VALUES (93944,"עִדּוּד","n",NULL,"idud","עידוד","עדוד",NULL,"&DWD","&IDWD",NULL);
INSERT INTO hebrew_morpho VALUES (93945,"עָרַף","v",NULL,"araf","ערף","ערף",NULL,"&RP","&RP",NULL);
INSERT INTO hebrew_morpho VALUES (93946,"עִשֵּׁן","v",NULL,"ishen","עישן","עשן",NULL,"&$N","&I$N",NULL);
INSERT INTO hebrew_morpho VALUES (93947,"עָרַק","v",NULL,"arak","ערק","ערק",NULL,"&RQ","&RQ",NULL);
INSERT INTO hebrew_morpho VALUES (93948,"עֵרֶב","n",NULL,"erev","ערב","ערב",NULL,"&RB","&RB",NULL);
INSERT INTO hebrew_morpho VALUES (93949,"דִּמְדּוּמִים","n",NULL,"dimdumim","דמדומים","דמדומים",NULL,"DMDWMIM","DMDWMIM",NULL);
INSERT INTO hebrew_morpho VALUES (93950,"עַרְבַּיִם","n",NULL,"arbayim","ערביים","ערבים",NULL,"&RBIM","&RBIIM",NULL);
INSERT INTO hebrew_morpho VALUES (93951,"בֵּין-הָעַרְבַּיִם","n",NULL,"bein ha\'arbayim","בין-הערביים","בין-הערבים",NULL,"BIN-H&RBIM","BIN-H&RBIIM",NULL);
INSERT INTO hebrew_morpho VALUES (93952,"בֵּין-הַשְּׁמָשׁוֹת","n",NULL,"bein hashmashot","בין-השמשות","בין-השמשות",NULL,"BIN-H$M$WT","BIN-H$M$WT",NULL);
INSERT INTO hebrew_morpho VALUES (93953,"עֵרָנִי","a",NULL,"erani","ערני","ערני",NULL,"&RNI","&RNI",NULL);
INSERT INTO hebrew_morpho VALUES (93954,"עִקָּרִי","a",NULL,"ikari","עיקרי","עקרי",NULL,"&QRI","&IQRI",NULL);
INSERT INTO hebrew_morpho VALUES (93955,"רָאשִׁי","a",NULL,"rashi","ראשי","ראשי",NULL,"RA$I","RA$I",NULL);
INSERT INTO hebrew_morpho VALUES (93956,"מַמָּשִׁיּוּת","n",NULL,"mamashiyut","ממשיות","ממשיות",NULL,"MM$IWT","MM$IWT",NULL);
INSERT INTO hebrew_morpho VALUES (93957,"מוּחָשִׁיּוּת","n",NULL,"muchashiyut","מוחשיות","מוחשיות",NULL,"MWX$IWT","MWX$IWT",NULL);
INSERT INTO hebrew_morpho VALUES (93958,"מֶלֶט","n",NULL,"melet","מלט","מלט",NULL,"ML@","ML@",NULL);
INSERT INTO hebrew_morpho VALUES (93959,"עֶלְיוֹן","a",NULL,"elyon","עליון","עליון",NULL,"&LIWN","&LIWN",NULL);
INSERT INTO hebrew_morpho VALUES (93960,"הַגָּבוֹהַּ-בְּיוֹתֵר","a",NULL,"hagavoha beyoter","הגבוה-ביותר","הגבוה-ביותר",NULL,"HGBWH-BIWTR","HGBWH-BIWTR",NULL);
INSERT INTO hebrew_morpho VALUES (93961,"הָעֶלְיוֹן","a",NULL,"ha\'elyon","העליון","העליון",NULL,"H&LIWN","H&LIWN",NULL);
INSERT INTO hebrew_morpho VALUES (93962,"רַב","a",NULL,"rav","רב","רב",NULL,"RB","RB",NULL);
INSERT INTO hebrew_morpho VALUES (93963,"עֲנָק","a",NULL,"anak","ענק","ענק",NULL,"&NQ","&NQ",NULL);
INSERT INTO hebrew_morpho VALUES (93964,"עֲנָקִי","a",NULL,"anaki","ענקי","ענקי",NULL,"&NQI","&NQI",NULL);
INSERT INTO hebrew_morpho VALUES (93965,"שֶׁל-עֶקְרוֹנוֹת","a",NULL,"shel ekronot","של-עקרונות","של-עקרונות",NULL,"$L-&QRWNWT","$L-&QRWNWT",NULL);
INSERT INTO hebrew_morpho VALUES (93966,"עוֹלָמִי","a",NULL,"olami","עולמי","עולמי",NULL,"&WLMI","&WLMI",NULL);
INSERT INTO hebrew_morpho VALUES (93967,"כְּלַל-עוֹלָמִי","a",NULL,"klal olami","כלל-עולמי","כלל-עולמי",NULL,"KLL-&WLMI","KLL-&WLMI",NULL);
INSERT INTO hebrew_morpho VALUES (93968,"גְּלוֹבָּלִי","a",NULL,"globali","גלובלי","גלובלי",NULL,"GLWBLI","GLWBLI",NULL);
INSERT INTO hebrew_morpho VALUES (93969,"עַצְבָּנִי","a",NULL,"atzbani","עצבני","עצבני",NULL,"&CBNI","&CBNI",NULL);
INSERT INTO hebrew_morpho VALUES (93970,"הַחְזָקָה","n",NULL,"haxzaka","החזקה","החזקה",NULL,"HXZQH","HXZQH",NULL);
INSERT INTO hebrew_morpho VALUES (93971,"מִקְרֶה","n",NULL,"mikre","מקרה","מקרה",NULL,"MQRH","MQRH",NULL);
INSERT INTO hebrew_morpho VALUES (93972,"מִרְוָח","n",NULL,"mirvach","מירווח","מרוח",NULL,"MRWX","MIRWWX",NULL);
INSERT INTO hebrew_morpho VALUES (93973,"מְנִיעָה","n",NULL,"meni\'ah","מניעה","מניעה",NULL,"MNI&H","MNI&H",NULL);
INSERT INTO hebrew_morpho VALUES (93974,"מַעֲמָד","n",NULL,"ma\'amad","מעמד","מעמד",NULL,"M&MD","M&MD",NULL);
INSERT INTO hebrew_morpho VALUES (93975,"מֶכֶס","n",NULL,"meches","מכס","מכס",NULL,"MKS","MKS",NULL);
INSERT INTO hebrew_morpho VALUES (93976,"מָחוֹז","n",NULL,"machoz","מחוז","מחוז",NULL,"MXWZ","MXWZ",NULL);
INSERT INTO hebrew_morpho VALUES (93977,"טֶרִיטוֹרְיָה","n",NULL,"teritorya","טריטוריה","טריטוריה",NULL,"@RI@WRIH","@RI@WRIH",NULL);
INSERT INTO hebrew_morpho VALUES (93978,"הִתְפַּנְּקוּת","n",NULL,"hitpankut","התפנקות","התפנקות",NULL,"HTPNQWT","HTPNQWT",NULL);
INSERT INTO hebrew_morpho VALUES (93979,"מְקוֹם-עֲבוֹדָה","n",NULL,"mekom avoda","מקום-עבודה","מקום-עבודה",NULL,"MQWM-&BWDH","MQWM-&BWDH",NULL);
INSERT INTO hebrew_morpho VALUES (93980,"תַּחֲנַת-עֲבוֹדָה","n",NULL,"taxant avoda","תחנת-עבודה","תחנת-עבודה",NULL,"TXNT-&BWDH","TXNT-&BWDH",NULL);
INSERT INTO hebrew_morpho VALUES (93981,"תְּנוּחָה","n",NULL,"tnuxa","תנוחה","תנוחה",NULL,"TNWXH","TNWXH",NULL);
INSERT INTO hebrew_morpho VALUES (93982,"עֶמְדָּה","n",NULL,"emda","עמדה","עמדה",NULL,"&MDH","&MDH",NULL);
INSERT INTO hebrew_morpho VALUES (93983,"גְּרִימַת-עָוֶל","n",NULL,"girmat avel","גרימת_עוול","גרימת-עול",NULL,"GRIMT-&WL","GRIMT_&WWL",NULL);
INSERT INTO hebrew_morpho VALUES (93984,"עַקְשָׁנוּת","n",NULL,"akshanut","עקשנות","עקשנות",NULL,"&Q$NWT","&Q$NWT",NULL);
INSERT INTO hebrew_morpho VALUES (93985,"קַשְׁיוּת-עֹרֶף","n",NULL,"kashyut oref","קשיות-ערף","קשיות-ערף",NULL,"Q$IWT-&RP","Q$IWT-&RP",NULL);
INSERT INTO hebrew_morpho VALUES (93986,"סִיּוּעַ","n",NULL,"siyu\'a","סיוע","סיוע",NULL,"SIW&","SIW&",NULL);
INSERT INTO hebrew_morpho VALUES (93987,"עֶרְוָה","n",NULL,"erva","ערווה","ערוה",NULL,"&RWH","&RWWH",NULL);
INSERT INTO hebrew_morpho VALUES (93988,"אֵיבְרֵי-הַמִּין","n",NULL,"eivarei hamin","איברי-המין","איברי-המין",NULL,"AIBRI-HMIN","AIBRI-HMIN",NULL);
INSERT INTO hebrew_morpho VALUES (93989,"עֵצָה","n",NULL,"etza","עצה","עצה",NULL,"&CH","&CH",NULL);
INSERT INTO hebrew_morpho VALUES (93990,"צִבּוּר","n",NULL,"tsibur","ציבור","צבור",NULL,"CBWR","CIBWR",NULL);
INSERT INTO hebrew_morpho VALUES (93991,"קָהָל","n",NULL,"kahal","קהל","קהל",NULL,"QHL","QHL",NULL);
INSERT INTO hebrew_morpho VALUES (93992,"תּוֹשָׁבֵי-הָעִיר","n",NULL,"toshavei ha\'ir","תושבי-העיר","תושבי-העיר",NULL,"TW$BI-H&IR","TW$BI-H&IR",NULL);
INSERT INTO hebrew_morpho VALUES (93993,"תּוֹשָׁבֵי-הָעֲיָרָה","n",NULL,"toshavei ha\'ayara","תושבי-העיירה","תושבי-העירה",NULL,"TW$BI-H&IRH","TW$BI-H&IIRH",NULL);
INSERT INTO hebrew_morpho VALUES (93994,"חֲצִי-הָאִי-עֲרָב","n",NULL,"xatsi ha\'i arav","חצי-האי-ערב","חצי-האי-ערב",NULL,"XCI-HAI-&RB","XCI-HAI-&RB",NULL);
INSERT INTO hebrew_morpho VALUES (93995,"עֲרָב","n",NULL,"arav","ערב","ערב",NULL,"&RB","&RB",NULL);
INSERT INTO hebrew_morpho VALUES (93996,"עֶלְיוֹנוּת","n",NULL,"elyonut","עליונות","עליונות",NULL,"&LIWNWT","&LIWNWT",NULL);
INSERT INTO hebrew_morpho VALUES (93997,"עֲוִית","n",NULL,"avit","עווית","עוית",NULL,"&WIT","&WWIT",NULL);
INSERT INTO hebrew_morpho VALUES (93998,"פִּרְכּוּס","n",NULL,"pirkus","פרכוס","פרכוס",NULL,"PRKWS","PRKWS",NULL);
INSERT INTO hebrew_morpho VALUES (93999,"עֵץ","n",NULL,"etz","עץ","עץ",NULL,"&C","&C",NULL);
INSERT INTO hebrew_morpho VALUES (94000,"תְּקוּפָה","n",NULL,"tkufa","תקופה","תקופה",NULL,"TQWPH","TQWPH",NULL);
INSERT INTO hebrew_morpho VALUES (94001,"עִדָּן","n",NULL,"idan","עידן","עדן",NULL,"&DN","&IDN",NULL);
INSERT INTO hebrew_morpho VALUES (94002,"אֲפִלּוּ","r",NULL,"afilu","אפילו","אפלו",NULL,"APLW","APILW",NULL);
INSERT INTO hebrew_morpho VALUES (94003,"אַף","r",NULL,"af","אף","אף",NULL,"AP","AP",NULL);
INSERT INTO hebrew_morpho VALUES (94004,"עֲדַיִן","r",NULL,"adayin","עדיין","עדין",NULL,"&DIN","&DIIN",NULL);
INSERT INTO hebrew_morpho VALUES (94005,"לַמְרוֹת-זֹאת","r",NULL,"lamrot zot","למרות-זאת","למרות-זאת",NULL,"LMRWT-ZAT","LMRWT-ZAT",NULL);
INSERT INTO hebrew_morpho VALUES (94006,"אַף-עַל-פִּי-כֵן","r",NULL,"af al pi xen","אף-על-פי-כן","אף-על-פי-כן",NULL,"AP-&L-PI-KN","AP-&L-PI-KN",NULL);
INSERT INTO hebrew_morpho VALUES (94007,"בְּכָל-זֹאת","r",NULL,"bexol zot","בכל-זאת","בכל-זאת",NULL,"BKL-ZAT","BKL-ZAT",NULL);
INSERT INTO hebrew_morpho VALUES (94008,"כַּיּוֹם","r",NULL,"kayom","כיום","כיום",NULL,"KIWM","KIWM",NULL);
INSERT INTO hebrew_morpho VALUES (94009,"יוֹתֵר","r",NULL,"yoter","יותר","יותר",NULL,"IWTR","IWTR",NULL);
INSERT INTO hebrew_morpho VALUES (94010,"עָרַךְ","v",NULL,"arax","ערך","ערך",NULL,"&RK","&RK",NULL);
INSERT INTO hebrew_morpho VALUES (94011,"פָּעַל","v",NULL,"pa\'al","פעל","פעל",NULL,"P&L","P&L",NULL);
INSERT INTO hebrew_morpho VALUES (94012,"שִׁכְנֵעַ","v",NULL,"shixne\'a","שכנע","שכנע",NULL,"$KN&","$KN&",NULL);
INSERT INTO hebrew_morpho VALUES (94013,"עָדַר","v",NULL,"adar","עדר","עדר",NULL,"&DR","&DR",NULL);
INSERT INTO hebrew_morpho VALUES (94014,"עִנְיֵן","v",NULL,"inyen","עניין","ענין",NULL,"&NIN","&NIIN",NULL);
INSERT INTO hebrew_morpho VALUES (94015,"סִקְרֵן","v",NULL,"sikren","סקרן","סקרן",NULL,"SQRN","SQRN",NULL);
INSERT INTO hebrew_morpho VALUES (94016,"עָמַד","v",NULL,"amad","עמד","עמד",NULL,"&MD","&MD",NULL);
INSERT INTO hebrew_morpho VALUES (94017,"עָצַר","v",NULL,"atzar","עצר","עצר",NULL,"&CR","&CR",NULL);
INSERT INTO hebrew_morpho VALUES (94018,"נֶעֱצַר","v",NULL,"ne\'etsar","נעצר","נעצר",NULL,"N&CR","N&CR",NULL);
INSERT INTO hebrew_morpho VALUES (94019,"נֶעֱמַד","v",NULL,"ne\'emad","נעמד","נעמד",NULL,"N&MD","N&MD",NULL);
INSERT INTO hebrew_morpho VALUES (94020,"עָמַד-מִלֶּכֶת","v",NULL,NULL,"עמד-מלכת","עמד-מלכת",NULL,"&MD-MLKT","&MD-MLKT",NULL);
INSERT INTO hebrew_morpho VALUES (94021,"עָבַד-עַל","v",NULL,"avad al","עבד_על","עבד-על",NULL,"&BD-&L","&BD_&L",NULL);
INSERT INTO hebrew_morpho VALUES (94022,"מוּחָשִׁי","a",NULL,"muchashi","מוחשי","מוחשי",NULL,"MWX$I","MWX$I",NULL);
INSERT INTO hebrew_morpho VALUES (94023,"מוּחָשׁ","a",NULL,"muchash","מוחש","מוחש",NULL,"MWX$","MWX$",NULL);
INSERT INTO hebrew_morpho VALUES (94024,"קוֹנְקְרֶטִי","a",NULL,"konkreti","קונקרטי","קונקרטי",NULL,"QWNQR@I","QWNQR@I",NULL);
INSERT INTO hebrew_morpho VALUES (94025,"מַפְלֶה","a",NULL,"mafle","מפלה","מפלה",NULL,"MPLH","MPLH",NULL);
INSERT INTO hebrew_morpho VALUES (94026,"פְרַגְמֶנְטָרִי","a",NULL,"fragmentari","פרגמנטרי","פרגמנטרי",NULL,"PRGMN@RI","PRGMN@RI",NULL);
INSERT INTO hebrew_morpho VALUES (94027,"מָסוּר","a",NULL,"masur","מסור","מסור",NULL,"MSWR","MSWR",NULL);
INSERT INTO hebrew_morpho VALUES (94028,"מֻקְדָּשׁ","a",NULL,"mukdash","מקדש","מקדש",NULL,"MQD$","MQD$",NULL);
INSERT INTO hebrew_morpho VALUES (94029,"מְבֻשָּׁל","a",NULL,"mevushal","מבושל","מבשל",NULL,"MB$L","MBW$L",NULL);
INSERT INTO hebrew_morpho VALUES (94030,"יָגַע","v",NULL,"yaga","יגע","יגע",NULL,"IG&","IG&",NULL);
INSERT INTO hebrew_morpho VALUES (94031,"בָּלַם","v",NULL,"balam","בלם","בלם",NULL,"BLM","BLM",NULL);
INSERT INTO hebrew_morpho VALUES (94032,"עָבַר-עַל","v",NULL,"avar al","עבר_על","עבר-על",NULL,"&BR-&L","&BR_&L",NULL);
INSERT INTO hebrew_morpho VALUES (94033,"חָרַג","v",NULL,"xarag","חרג","חרג",NULL,"XRG","XRG",NULL);
INSERT INTO hebrew_morpho VALUES (94034,"הֵפֵר","v",NULL,"hefer","הפר","הפר",NULL,"HPR","HPR",NULL);
INSERT INTO hebrew_morpho VALUES (94035,"שִׁתֵּף-פְּעֻלָּה","v",NULL,"shitef pe\'ula","שיתף-פעלה","שתף-פעלה",NULL,"$TP-P&LH","$ITP-P&LH",NULL);
INSERT INTO hebrew_morpho VALUES (94036,"סִיֵּעַ","v",NULL,"si\'ye\'a","סייע","סיע",NULL,"SI&","SII&",NULL);
INSERT INTO hebrew_morpho VALUES (94037,"עָזַר","v",NULL,"azar","עזר","עזר",NULL,"&ZR","&ZR",NULL);
INSERT INTO hebrew_morpho VALUES (94038,"הִגִּישׁ-עֶזְרָה","v",NULL,"higish ezra","הגיש-עזרה","הגיש-עזרה",NULL,"HGI$-&ZRH","HGI$-&ZRH",NULL);
INSERT INTO hebrew_morpho VALUES (94039,"סָךְ","v",NULL,"sax","סך","סך",NULL,"SK","SK",NULL);
INSERT INTO hebrew_morpho VALUES (94040,"פּוֹזֵל","a",NULL,"pozel","פוזל","פוזל",NULL,"PWZL","PWZL",NULL);
INSERT INTO hebrew_morpho VALUES (94041,"כָּרוּת","a",NULL,"karut","כרות","כרות",NULL,"KRWT","KRWT",NULL);
INSERT INTO hebrew_morpho VALUES (94042,"אוֹרְיֶנְטָלִי","a",NULL,"oryentali","אוריינטלי","אורינטלי",NULL,"AWRIN@LI","AWRIIN@LI",NULL);
INSERT INTO hebrew_morpho VALUES (94043,"מִזְרָחִי","a",NULL,"mizrachi","מזרחי","מזרחי",NULL,"MZRXI","MZRXI",NULL);
INSERT INTO hebrew_morpho VALUES (94044,"מֻבְטָל","a",NULL,"muvtal","מובטל","מבטל",NULL,"MB@L","MWB@L",NULL);
INSERT INTO hebrew_morpho VALUES (94045,"פַנְטַסְטִי","a",NULL,"fantasti","פנטסטי","פנטסטי",NULL,"PN@S@I","PN@S@I",NULL);
INSERT INTO hebrew_morpho VALUES (94046,"נֶהְדָּר","a",NULL,"nehedar","נהדר","נהדר",NULL,"NHDR","NHDR",NULL);
INSERT INTO hebrew_morpho VALUES (94047,"נִפְלָא","a",NULL,"nifla","נפלא","נפלא",NULL,"NPLA","NPLA",NULL);
INSERT INTO hebrew_morpho VALUES (94048,"מַתִּירָנִי","a",NULL,"matirani","מתירני","מתירני",NULL,"MTIRNI","MTIRNI",NULL);
INSERT INTO hebrew_morpho VALUES (94049,"אֲפִיָּה","n",NULL,"afiya","אפייה","אפיה",NULL,"APIH","APIIH",NULL);
INSERT INTO hebrew_morpho VALUES (94050,"מְדִידָה","n",NULL,"medida","מדידה","מדידה",NULL,"MDIDH","MDIDH",NULL);
INSERT INTO hebrew_morpho VALUES (94051,"מִתְרָס","n",NULL,"mitras","מיתרס","מתרס",NULL,"MTRS","MITRS",NULL);
INSERT INTO hebrew_morpho VALUES (94052,"בָּרִיקָדָה","n",NULL,"barikada","בריקדה","בריקדה",NULL,"BRIQDH","BRIQDH",NULL);
INSERT INTO hebrew_morpho VALUES (94053,"מַדְחֵס","n",NULL,"madches","מדחס","מדחס",NULL,"MDXS","MDXS",NULL);
INSERT INTO hebrew_morpho VALUES (94054,"קוֹמְפְּרֶסוֹר","n",NULL,"compresor","קומפרסור","קומפרסור",NULL,"QWMPRSWR","QWMPRSWR",NULL);
INSERT INTO hebrew_morpho VALUES (94055,"מְכַרְסֵם","n",NULL,"mecharsem","מכרסם","מכרסם",NULL,"MKRSM","MKRSM",NULL);
INSERT INTO hebrew_morpho VALUES (94056,"מַקְפֵּצָה","n",NULL,"makpetza","מקפצה","מקפצה",NULL,"MQPCH","MQPCH",NULL);
INSERT INTO hebrew_morpho VALUES (94057,"מַשְׁחֶתֶת","n",NULL,"mashchetet","משחתת","משחתת",NULL,"M$XTT","M$XTT",NULL);
INSERT INTO hebrew_morpho VALUES (94058,"טַפְטֶפֶת","n",NULL,"taftefet","טפטפת","טפטפת",NULL,"@P@PT","@P@PT",NULL);
INSERT INTO hebrew_morpho VALUES (94059,"מַעֲלִית","n",NULL,"ma\'alit","מעלית","מעלית",NULL,"M&LIT","M&LIT",NULL);
INSERT INTO hebrew_morpho VALUES (94060,"מַרְעוֹם","n",NULL,"mar\'om","מרעום","מרעום",NULL,"MR&WM","MR&WM",NULL);
INSERT INTO hebrew_morpho VALUES (94061,"חֲמָמָה","n",NULL,"chamama","חממה","חממה",NULL,"XMMH","XMMH",NULL);
INSERT INTO hebrew_morpho VALUES (94062,"מִסְגָּד","n",NULL,"misgad","מסגד","מסגד",NULL,"MSGD","MSGD",NULL);
INSERT INTO hebrew_morpho VALUES (94063,"מְטוֹס-סִילוֹן","n",NULL,"metos-silon","מטוס-סילון","מטוס-סילון",NULL,"M@WS-SILWN","M@WS-SILWN",NULL);
INSERT INTO hebrew_morpho VALUES (94064,"אֶבֶן-הָרֹאשָׁה","n",NULL,"even-harosha","אבן-הראשה","אבן-הראשה",NULL,"ABN-HRA$H","ABN-HRA$H",NULL);
INSERT INTO hebrew_morpho VALUES (94065,"מַצֵּבָה","n",NULL,"matzeva","מצבה","מצבה",NULL,"MCBH","MCBH",NULL);
INSERT INTO hebrew_morpho VALUES (94066,"מַעְבֹּרֶת","n",NULL,"ma\'aboret","מעבורת","מעברת",NULL,"M&BRT","M&BWRT",NULL);
INSERT INTO hebrew_morpho VALUES (94067,"מִטְפַּחַת-רֹאשׁ","n",NULL,"mitpachat-rosh","מטפחת-ראש","מטפחת-ראש",NULL,"M@PXT-RA$","M@PXT-RA$",NULL);
INSERT INTO hebrew_morpho VALUES (94068,"מִטְפַּחַת","n",NULL,"mitpachat","מטפחת","מטפחת",NULL,"M@PXT","M@PXT",NULL);
INSERT INTO hebrew_morpho VALUES (94069,"מִטפַּחַת-אַף","n",NULL,"mitpachat-af","מטפחת-אף","מטפחת-אף",NULL,"M@PXT-AP","M@PXT-AP",NULL);
INSERT INTO hebrew_morpho VALUES (94070,"מִמְחָטָה","n",NULL,"mimchata","ממחטה","ממחטה",NULL,"MMX@H","MMX@H",NULL);
INSERT INTO hebrew_morpho VALUES (94071,"קוֹלָב","n",NULL,"kolav","קולב","קולב",NULL,"QWLB","QWLB",NULL);
INSERT INTO hebrew_morpho VALUES (94072,"מִתְלֶה","n",NULL,"mitle","מתלה","מתלה",NULL,"MTLH","MTLH",NULL);
INSERT INTO hebrew_morpho VALUES (94073,"סְפִינַת-מַעְבֹּרֶת","n",NULL,"sfinat-ma\'aboret","ספינת-מעברת","ספינת-מעברת",NULL,"SPINT-M&BRT","SPINT-M&BRT",NULL);
INSERT INTO hebrew_morpho VALUES (94074,"מַחְסוֹם","n",NULL,"machsom","מחסום","מחסום",NULL,"MXSWM","MXSWM",NULL);
INSERT INTO hebrew_morpho VALUES (94075,"כִּסּוּי-רֹאשׁ","n",NULL,"kisuy-rosh","כיסוי-ראש","כסוי-ראש",NULL,"KSWI-RA$","KISWI-RA$",NULL);
INSERT INTO hebrew_morpho VALUES (94076,"מָלוֹן","n",NULL,"malon","מלון","מלון",NULL,"MLWN","MLWN",NULL);
INSERT INTO hebrew_morpho VALUES (94077,"בֵּית-מָלוֹן","n",NULL,"beit-malon","בית-מלון","בית-מלון",NULL,"BIT-MLWN","BIT-MLWN",NULL);
INSERT INTO hebrew_morpho VALUES (94078,"זָ\'קֶט","n",NULL,NULL,"ז\'קט","ז\'קט",NULL,"Z\'Q@","Z\'Q@",NULL);
INSERT INTO hebrew_morpho VALUES (94079,"מִקְטֹרֶן","n",NULL,"miktoren","מקטורן","מקטרן",NULL,"MQ@RN","MQ@WRN",NULL);
INSERT INTO hebrew_morpho VALUES (94080,"מַעְבָּדָה","n",NULL,"ma\'abada","מעבדה","מעבדה",NULL,"M&BDH","M&BDH",NULL);
INSERT INTO hebrew_morpho VALUES (94081,"כְּבָסִים","n",NULL,"kvasim","כבסים","כבסים",NULL,"KBSIM","KBSIM",NULL);
INSERT INTO hebrew_morpho VALUES (94082,"כְּבִיסָה","n",NULL,"kvisa","כביסה","כביסה",NULL,"KBISH","KBISH",NULL);
INSERT INTO hebrew_morpho VALUES (94083,"מַגְבִּיר-קוֹל","n",NULL,"magbir-kol","מגביר-קול","מגביר-קול",NULL,"MGBIR-QWL","MGBIR-QWL",NULL);
INSERT INTO hebrew_morpho VALUES (94084,"מֶגָפוֹן","n",NULL,"megafon","מגפון","מגפון",NULL,"MGPWN","MGPWN",NULL);
INSERT INTO hebrew_morpho VALUES (94085,"מַפִּית","n",NULL,"mapit","מפית","מפית",NULL,"MPIT","MPIT",NULL);
INSERT INTO hebrew_morpho VALUES (94086,"מַחְרֹזֶת","n",NULL,"machrozet","מחרוזת","מחרזת",NULL,"MXRZT","MXRWZT",NULL);
INSERT INTO hebrew_morpho VALUES (94087,"נַעַל-סִירָה","n",NULL,"na\'al-sira","נעל-סירה","נעל-סירה",NULL,"N&L-SIRH","N&L-SIRH",NULL);
INSERT INTO hebrew_morpho VALUES (94088,"מְקָרֵר","n",NULL,"mekarer","מקרר","מקרר",NULL,"MQRR","MQRR",NULL);
INSERT INTO hebrew_morpho VALUES (94089,"פְרִיגִ\'ידֶר","n",NULL,"frijider","פריג\'ידר","פריג\'ידר",NULL,"PRIG\'IDR","PRIG\'IDR",NULL);
INSERT INTO hebrew_morpho VALUES (94090,"מִמְסָר","n",NULL,"mimsar","מימסר","ממסר",NULL,"MMSR","MIMSR",NULL);
INSERT INTO hebrew_morpho VALUES (94091,"מִסְלָעָה","n",NULL,"misla\'ah","מסלעה","מסלעה",NULL,"MSL&H","MSL&H",NULL);
INSERT INTO hebrew_morpho VALUES (94092,"מַחַק","n",NULL,"machak","מחק","מחק",NULL,"MXQ","MXQ",NULL);
INSERT INTO hebrew_morpho VALUES (94093,"סֶרֶט-מִדָּה","n",NULL,"seret-mida","סרט-מידה","סרט-מדה",NULL,"SR@-MDH","SR@-MIDH",NULL);
INSERT INTO hebrew_morpho VALUES (94094,"מַשְׁדֵּר","n",NULL,"mashder","משדר","משדר",NULL,"M$DR","M$DR",NULL);
INSERT INTO hebrew_morpho VALUES (94095,"מִנְהָרָה","n",NULL,"minhara","מנהרה","מנהרה",NULL,"MNHRH","MNHRH",NULL);
INSERT INTO hebrew_morpho VALUES (94096,"מֶזֶג","n",NULL,"mezeg","מזג","מזג",NULL,"MZG","MZG",NULL);
INSERT INTO hebrew_morpho VALUES (94097,"טֶמְפֶּרָמֶנְט","n",NULL,"temperament","טמפרמנט","טמפרמנט",NULL,"@MPRMN@","@MPRMN@",NULL);
INSERT INTO hebrew_morpho VALUES (94098,"מַתִּירָנוּת","n",NULL,"matiranut","מתירנות","מתירנות",NULL,"MTIRNWT","MTIRNWT",NULL);
INSERT INTO hebrew_morpho VALUES (94099,"מֻרְכָּבוּת","n",NULL,"murkavut","מורכבות","מרכבות",NULL,"MRKBWT","MWRKBWT",NULL);
INSERT INTO hebrew_morpho VALUES (94100,"פָּחוּס","a",NULL,"paxus","פחוס","פחוס",NULL,"PXWS","PXWS",NULL);
INSERT INTO hebrew_morpho VALUES (94101,"פָּלֶשְׂתִּינָאִי","n",NULL,"palestina\'i","פלשתינאי","פלשתינאי",NULL,"PL$TINAI","PL$TINAI",NULL);
INSERT INTO hebrew_morpho VALUES (94102,"פָּלֶשְׂתִּינִי","n",NULL,"palestini","פלשתיני","פלשתיני",NULL,"PL$TINI","PL$TINI",NULL);
INSERT INTO hebrew_morpho VALUES (94103,"פִּנּוּי","n",NULL,"pinuy","פינוי","פנוי",NULL,"PNWI","PINWI",NULL);
INSERT INTO hebrew_morpho VALUES (94104,"רִקּוּן","n",NULL,"rikkun","ריקון","רקון",NULL,"RQWN","RIQWN",NULL);
INSERT INTO hebrew_morpho VALUES (94105,"פְּעֻלָּה","n",NULL,"pe\'ula","פעולה","פעלה",NULL,"P&LH","P&WLH",NULL);
INSERT INTO hebrew_morpho VALUES (94106,"מַעֲשֶׂה","n",NULL,"ma\'asse","מעשה","מעשה",NULL,"M&$H","M&$H",NULL);
INSERT INTO hebrew_morpho VALUES (94107,"אַקְט","n",NULL,NULL,"אקט","אקט",NULL,"AQ@","AQ@",NULL);
INSERT INTO hebrew_morpho VALUES (94108,"פְּצִיעָה","n",NULL,"ptzi\'a","פציעה","פציעה",NULL,"PCI&H","PCI&H",NULL);
INSERT INTO hebrew_morpho VALUES (94109,"פֶּצַע","n",NULL,"petza","פצע","פצע",NULL,"PC&","PC&",NULL);
INSERT INTO hebrew_morpho VALUES (94110,"לָהִיט","n",NULL,"lahit","להיט","להיט",NULL,"LHI@","LHI@",NULL);
INSERT INTO hebrew_morpho VALUES (94111,"פֶסְטִיבָל","n",NULL,"festival","פסטיבל","פסטיבל",NULL,"PS@IBL","PS@IBL",NULL);
INSERT INTO hebrew_morpho VALUES (94112,"פִּזּוּר","n",NULL,"pizzur","פיזור","פזור",NULL,"PZWR","PIZWR",NULL);
INSERT INTO hebrew_morpho VALUES (94113,"פַּשְׁטָנִי","a",NULL,"pashtani","פשטני","פשטני",NULL,"P$@NI","P$@NI",NULL);
INSERT INTO hebrew_morpho VALUES (94114,"פְּשִׁיטָה","n",NULL,"pshita","פשיטה","פשיטה",NULL,"P$I@H","P$I@H",NULL);
INSERT INTO hebrew_morpho VALUES (94115,"פְּרָעוֹת","n",NULL,"pra\'ot","פרעות","פרעות",NULL,"PR&WT","PR&WT",NULL);
INSERT INTO hebrew_morpho VALUES (94116,"פּוֹגְרוֹם","n",NULL,"pogrom","פוגרום","פוגרום",NULL,"PWGRWM","PWGRWM",NULL);
INSERT INTO hebrew_morpho VALUES (94117,"יָזְמָה","n",NULL,"yozma","יוזמה","יזמה",NULL,"IZMH","IWZMH",NULL);
INSERT INTO hebrew_morpho VALUES (94118,"מִבְנֶה-גּוּף","n",NULL,"mivne-guf","מבנה-גוף","מבנה-גוף",NULL,"MBNH-GWP","MBNH-GWP",NULL);
INSERT INTO hebrew_morpho VALUES (94119,"מְהִירוּת","n",NULL,"mehirut","מהירות","מהירות",NULL,"MHIRWT","MHIRWT",NULL);
INSERT INTO hebrew_morpho VALUES (94120,"מֶרְכָּזִיּוּת","n",NULL,"merkaziyut","מרכזיות","מרכזיות",NULL,"MRKZIWT","MRKZIWT",NULL);
INSERT INTO hebrew_morpho VALUES (94121,"תַּפְקִיד","n",NULL,"tafkid","תפקיד","תפקיד",NULL,"TPQID","TPQID",NULL);
INSERT INTO hebrew_morpho VALUES (94122,"עֶצֶם-הַמֵּצַח","n",NULL,"etzem-hametzach","עצם-המצח","עצם-המצח",NULL,"&CM-HMCX","&CM-HMCX",NULL);
INSERT INTO hebrew_morpho VALUES (94123,"מְיֻמָּנוּת","n",NULL,"meyumanut","מיומנות","מימנות",NULL,"MIMNWT","MIWMNWT",NULL);
INSERT INTO hebrew_morpho VALUES (94124,"פְּרוֹפֶסְיוֹנָלִיּוּת","n",NULL,"profesyonaliyut","פרופסיונליות","פרופסיונליות",NULL,"PRWPSIWNLIWT","PRWPSIWNLIWT",NULL);
INSERT INTO hebrew_morpho VALUES (94125,"מֻשָּׂג","n",NULL,"musag","מושג","משג",NULL,"M$G","MW$G",NULL);
INSERT INTO hebrew_morpho VALUES (94126,"פּוֹלִיסָה","n",NULL,"polisa","פוליסה","פוליסה",NULL,"PWLISH","PWLISH",NULL);
INSERT INTO hebrew_morpho VALUES (94127,"מְדִינִיּוּת","n",NULL,"mediniyut","מדיניות","מדיניות",NULL,"MDINIWT","MDINIWT",NULL);
INSERT INTO hebrew_morpho VALUES (94128,"תַּכְלִית","n",NULL,"tachlit","תכלית","תכלית",NULL,"TKLIT","TKLIT",NULL);
INSERT INTO hebrew_morpho VALUES (94129,"מַשְׁמָעוּת","n",NULL,"mashma\'ut","משמעות","משמעות",NULL,"M$M&WT","M$M&WT",NULL);
INSERT INTO hebrew_morpho VALUES (94130,"מְגַמָּתִיּוּת","n",NULL,"megamatiyut","מגמתיות","מגמתיות",NULL,"MGMTIWT","MGMTIWT",NULL);
INSERT INTO hebrew_morpho VALUES (94131,"מֶדְיָה","n",NULL,"medya","מדיה","מדיה",NULL,"MDIH","MDIH",NULL);
INSERT INTO hebrew_morpho VALUES (94132,"מַסָּה","n",NULL,"masa","מסה","מסה",NULL,"MSH","MSH",NULL);
INSERT INTO hebrew_morpho VALUES (94133,"דִּיפְּלוֹמָה","n",NULL,"diploma","דיפלומה","דיפלומה",NULL,"DIPLWMH","DIPLWMH",NULL);
INSERT INTO hebrew_morpho VALUES (94134,"תְּעוּדָה","n",NULL,"te\'uda","תעודה","תעודה",NULL,"T&WDH","T&WDH",NULL);
INSERT INTO hebrew_morpho VALUES (94135,"פַּרְפַּר","n",NULL,"parpar","פרפר","פרפר",NULL,"PRPR","PRPR",NULL);
INSERT INTO hebrew_morpho VALUES (94136,"שְׂחִיַּת-פַּרְפַּר","n",NULL,"sxiyat parpar","שחיית-פרפר","שחית-פרפר",NULL,"$XIT-PRPR","$XIIT-PRPR",NULL);
INSERT INTO hebrew_morpho VALUES (94137,"פִּצּוּץ","n",NULL,"pitzutz","פיצוץ","פצוץ",NULL,"PCWC","PICWC",NULL);
INSERT INTO hebrew_morpho VALUES (94138,"פִּיצוּץ","n",NULL,"pitzutz","פיצוץ","פיצוץ",NULL,"PICWC","PICWC",NULL);
INSERT INTO hebrew_morpho VALUES (94139,"פְּרִיקָה","n",NULL,"prika","פריקה","פריקה",NULL,"PRIQH","PRIQH",NULL);
INSERT INTO hebrew_morpho VALUES (94140,"אִכְסֵן","v",NULL,"ichsen","איכסן","אכסן",NULL,"AKSN","AIKSN",NULL);
INSERT INTO hebrew_morpho VALUES (94141,"מָנִיפֶסְט","n",NULL,"manifest","מניפסט","מניפסט",NULL,"MNIPS@","MNIPS@",NULL);
INSERT INTO hebrew_morpho VALUES (94142,"מִנְשָׁר","n",NULL,"minshar","מנשר","מנשר",NULL,"MN$R","MN$R",NULL);
INSERT INTO hebrew_morpho VALUES (94143,"דִּיל","n",NULL,NULL,"דיל","דיל",NULL,"DIL","DIL",NULL);
INSERT INTO hebrew_morpho VALUES (94144,"רִידִינְג","n",NULL,NULL,"רידינג","רידינג",NULL,"RIDING","RIDING",NULL);
INSERT INTO hebrew_morpho VALUES (94145,"מָעֳמָד","n",NULL,"mo\'amad","מועמד","מעמד",NULL,"M&MD","MW&MD",NULL);
INSERT INTO hebrew_morpho VALUES (94146,"קַנְדִּידָט","n",NULL,"kandidat","קנדידט","קנדידט",NULL,"QNDID@","QNDID@",NULL);
INSERT INTO hebrew_morpho VALUES (94147,"מַפְּלֵי-אַנְחֵל","n",NULL,NULL,"מפלי-אנחל","מפלי-אנחל",NULL,"MPLI-ANXL","MPLI-ANXL",NULL);
INSERT INTO hebrew_morpho VALUES (94148,"מֵיטִיב","n",NULL,"meitiv","מיטיב","מיטיב",NULL,"MI@IB","MI@IB",NULL);
INSERT INTO hebrew_morpho VALUES (94149,"צַב-יָם","n",NULL,"tzav-yam","צב-ים","צב-ים",NULL,"CB-IM","CB-IM",NULL);
INSERT INTO hebrew_morpho VALUES (94151,"פְלוֹרָה","n",NULL,"flora","פלורה","פלורה",NULL,"PLWRH","PLWRH",NULL);
INSERT INTO hebrew_morpho VALUES (94152,"וֶגֶטַצְיָה","n",NULL,"vegetatzya","וגטציה","וגטציה",NULL,"WG@CIH","WG@CIH",NULL);
INSERT INTO hebrew_morpho VALUES (94153,"צֶמַח","n",NULL,"tzemach","צמח","צמח",NULL,"CMX","CMX",NULL);
INSERT INTO hebrew_morpho VALUES (94154,"מֵהַצַּד","a",NULL,"mehatzad","מהצד","מהצד",NULL,"MHCD","MHCD",NULL);
INSERT INTO hebrew_morpho VALUES (94155,"צְדָדִי","a",NULL,"tzdadi","צדדי","צדדי",NULL,"CDDI","CDDI",NULL);
INSERT INTO hebrew_morpho VALUES (94156,"צָרוּד","a",NULL,"tzarud","צרוד","צרוד",NULL,"CRWD","CRWD",NULL);
INSERT INTO hebrew_morpho VALUES (94157,"צִבְעוֹנִי","n",NULL,"tziv\'oni","צבעוני","צבעוני",NULL,"CB&WNI","CB&WNI",NULL);
INSERT INTO hebrew_morpho VALUES (94158,"צִבְעוֹנִי","a",NULL,"tziv\'oni","צבעוני","צבעוני",NULL,"CB&WNI","CB&WNI",NULL);
INSERT INTO hebrew_morpho VALUES (94159,"קְהִלָּתִי","a",NULL,"kehilati","קהילתי","קהלתי",NULL,"QHLTI","QHILTI",NULL);
INSERT INTO hebrew_morpho VALUES (94160,"צִבּוּרִי","a",NULL,"tziburi","ציבורי","צבורי",NULL,"CBWRI","CIBWRI",NULL);
INSERT INTO hebrew_morpho VALUES (94161,"צְבָאִי","a",NULL,"tzva\'ee","צבאי","צבאי",NULL,"CBAI","CBAI",NULL);
INSERT INTO hebrew_morpho VALUES (94162,"צַיְתָן","a",NULL,"tzaytan","צייתן","ציתן",NULL,"CITN","CIITN",NULL);
INSERT INTO hebrew_morpho VALUES (94163,"צְעִירִים","n",NULL,"tze\'irim","צעירים","צעירים",NULL,"C&IRIM","C&IRIM",NULL);
INSERT INTO hebrew_morpho VALUES (94164,"צָעִיר","n",NULL,"tza\'ir","צעיר","צעיר",NULL,"C&IR","C&IR",NULL);
INSERT INTO hebrew_morpho VALUES (94165,"צָעִיר","a",NULL,"tza\'ir","צעיר","צעיר",NULL,"C&IR","C&IR",NULL);
INSERT INTO hebrew_morpho VALUES (94166,"צָבוּעַ","a",NULL,"tzavu\'ah","צבוע","צבוע",NULL,"CBW&","CBW&",NULL);
INSERT INTO hebrew_morpho VALUES (94167,"צָבוּעַ","n",NULL,"tzavu\'ah","צבוע","צבוע",NULL,"CBW&","CBW&",NULL);
INSERT INTO hebrew_morpho VALUES (94168,"הִיפּוֹקְרִיטִי","a",NULL,"hipokriti","היפוקריטי","היפוקריטי",NULL,"HIPWQRI@I","HIPWQRI@I",NULL);
INSERT INTO hebrew_morpho VALUES (94169,"צִינִי","a",NULL,"tzini","ציני","ציני",NULL,"CINI","CINI",NULL);
INSERT INTO hebrew_morpho VALUES (94170,"כְּדָאִי","a",NULL,"keda\'i","כדאי","כדאי",NULL,"KDAI","KDAI",NULL);
INSERT INTO hebrew_morpho VALUES (94171,"צָרְפָתִי","a",NULL,"tzarfati","צרפתי","צרפתי",NULL,"CRPTI","CRPTI",NULL);
INSERT INTO hebrew_morpho VALUES (94172,"גָּאלִי","a",NULL,"gali","גאלי","גאלי",NULL,"GALI","GALI",NULL);
INSERT INTO hebrew_morpho VALUES (94173,"צֶנְזוּרָה","n",NULL,"tzenzura","צנזורה","צנזורה",NULL,"CNZWRH","CNZWRH",NULL);
INSERT INTO hebrew_morpho VALUES (94174,"צְלִילָה","n",NULL,"tzlila","צלילה","צלילה",NULL,"CLILH","CLILH",NULL);
INSERT INTO hebrew_morpho VALUES (94175,"תַּחֲרוּת-צְלִילָה","n",NULL,"tacharut-Tzlila","תחרות-צלילה","תחרות-צלילה",NULL,"TXRWT-CLILH","TXRWT-CLILH",NULL);
INSERT INTO hebrew_morpho VALUES (94176,"צַיִד","n",NULL,"tzayid","ציד","ציד",NULL,"CID","CID",NULL);
INSERT INTO hebrew_morpho VALUES (94177,"חִפּוּשׂ","n",NULL,"chipus","חיפוש","חפוש",NULL,"XPW$","XIPW$",NULL);
INSERT INTO hebrew_morpho VALUES (94178,"סְרִיקָה","n",NULL,"srika","סריקה","סריקה",NULL,"SRIQH","SRIQH",NULL);
INSERT INTO hebrew_morpho VALUES (94179,"צְרָצַר","n",NULL,"tzratzar","צרצר","צרצר",NULL,"CRCR","CRCR",NULL);
INSERT INTO hebrew_morpho VALUES (94180,"קְרִיקֶט","n",NULL,"kriket","קריקט","קריקט",NULL,"QRIQ@","QRIQ@",NULL);
INSERT INTO hebrew_morpho VALUES (94181,"שְׁרַבְרָבוּת","n",NULL,"shravravut","שרברבות","שרברבות",NULL,"$RBRBWT","$RBRBWT",NULL);
INSERT INTO hebrew_morpho VALUES (94182,"אִינְסְטֶלַצְיָה","n",NULL,"instelatzya","אינסטלציה","אינסטלציה",NULL,"AINS@LCIH","AINS@LCIH",NULL);
INSERT INTO hebrew_morpho VALUES (94183,"צַנֶּרֶת","n",NULL,"tzaneret","צנרת","צנרת",NULL,"CNRT","CNRT",NULL);
INSERT INTO hebrew_morpho VALUES (94184,"צִלּוּם","n",NULL,"tzilum","צילום","צלום",NULL,"CLWM","CILWM",NULL);
INSERT INTO hebrew_morpho VALUES (94185,"תַּצְפִּית","n",NULL,"tatzpit","תצפית","תצפית",NULL,"TCPIT","TCPIT",NULL);
INSERT INTO hebrew_morpho VALUES (94186,"הִתְבּוֹנְנוּת","n",NULL,"hitbonenut","התבוננות","התבוננות",NULL,"HTBWNNWT","HTBWNNWT",NULL);
INSERT INTO hebrew_morpho VALUES (94187,"צוֹם","n",NULL,"tzom","צום","צום",NULL,"CWM","CWM",NULL);
INSERT INTO hebrew_morpho VALUES (94188,"צִוּוּי","n",NULL,"tzivuy","ציווי","צווי",NULL,"CWWI","CIWWI",NULL);
INSERT INTO hebrew_morpho VALUES (94189,"אִימְפֶּרָטִיב","n",NULL,"imperativ","אימפרטיב","אימפרטיב",NULL,"AIMPR@IB","AIMPR@IB",NULL);
INSERT INTO hebrew_morpho VALUES (94190,"צַיְתָנוּת","n",NULL,"tzaytanut","צייתנות","ציתנות",NULL,"CITNWT","CIITNWT",NULL);
INSERT INTO hebrew_morpho VALUES (94191,"צֶפַע","n",NULL,"tzefa","צפע","צפע",NULL,"CP&","CP&",NULL);
INSERT INTO hebrew_morpho VALUES (94192,"צֶמֶר","n",NULL,"tzemer","צמר","צמר",NULL,"CMR","CMR",NULL);
INSERT INTO hebrew_morpho VALUES (94193,"פָּגוּם","a",NULL,"pagum","פגום","פגום",NULL,"PGWM","PGWM",NULL);
INSERT INTO hebrew_morpho VALUES (94194,"לָקוּי","a",NULL,"lakuy","לקוי","לקוי",NULL,"LQWI","LQWI",NULL);
INSERT INTO hebrew_morpho VALUES (94195,"פְּרִיצָה","n",NULL,"pritza","פריצה","פריצה",NULL,"PRICH","PRICH",NULL);
INSERT INTO hebrew_morpho VALUES (94196,"פִּהוּק","n",NULL,"pihuk","פיהוק","פהוק",NULL,"PHWQ","PIHWQ",NULL);
INSERT INTO hebrew_morpho VALUES (94197,"פְּנַאי","n",NULL,"pnay","פנאי","פנאי",NULL,"PNAI","PNAI",NULL);
INSERT INTO hebrew_morpho VALUES (94198,"צָבוֹעַ","n",NULL,"tzavo\'a","צבוע","צבוע",NULL,"CBW&","CBW&",NULL);
INSERT INTO hebrew_morpho VALUES (94199,"פּוּמָה","n",NULL,"puma","פומה","פומה",NULL,"PWMH","PWMH",NULL);
INSERT INTO hebrew_morpho VALUES (94200,"אַרְיֵה-הָרִים","n",NULL,"arye-harim","אריה-הרים","אריה-הרים",NULL,"ARIH-HRIM","ARIH-HRIM",NULL);
INSERT INTO hebrew_morpho VALUES (94201,"צַבָּע","n",NULL,"tzaba","צבע","צבע",NULL,"CB&","CB&",NULL);
INSERT INTO hebrew_morpho VALUES (94202,"צִרְעָה","n",NULL,"tzir\'ah","צרעה","צרעה",NULL,"CR&H","CR&H",NULL);
INSERT INTO hebrew_morpho VALUES (94203,"צְרִיף","n",NULL,"tzrif","צריף","צריף",NULL,"CRIP","CRIP",NULL);
INSERT INTO hebrew_morpho VALUES (94204,"בִּקְתָּה","n",NULL,"bikta","בקתה","בקתה",NULL,"BQTH","BQTH",NULL);
INSERT INTO hebrew_morpho VALUES (94205,"צִנְצֶנֶת","n",NULL,"tzintzenet","צנצנת","צנצנת",NULL,"CNCNT","CNCNT",NULL);
INSERT INTO hebrew_morpho VALUES (94206,"סֹמֶק","n",NULL,"somek","סומק","סמק",NULL,"SMQ","SWMQ",NULL);
INSERT INTO hebrew_morpho VALUES (94207,"רוּז\'","n",NULL,"ruj","רוז\'","רוז\'",NULL,"RWZ\'","RWZ\'",NULL);
INSERT INTO hebrew_morpho VALUES (94208,"צֶבַע","n",NULL,"tzeva","צבע","צבע",NULL,"CB&","CB&",NULL);
INSERT INTO hebrew_morpho VALUES (94209,"צָעִיף","n",NULL,"tza\'if","צעיף","צעיף",NULL,"C&IP","C&IP",NULL);
INSERT INTO hebrew_morpho VALUES (94210,"גְּדִיל","n",NULL,"gdil","גדיל","גדיל",NULL,"GDIL","GDIL",NULL);
INSERT INTO hebrew_morpho VALUES (94211,"צֶנַע","n",NULL,"tzena","צנע","צנע",NULL,"CN&","CN&",NULL);
INSERT INTO hebrew_morpho VALUES (94212,"סַגְפָנוּת","n",NULL,"sagfanut","סגפנות","סגפנות",NULL,"SGPNWT","SGPNWT",NULL);
INSERT INTO hebrew_morpho VALUES (94213,"פְּרִישׁוּת","n",NULL,"prishut","פרישות","פרישות",NULL,"PRI$WT","PRI$WT",NULL);
INSERT INTO hebrew_morpho VALUES (94214,"שִׁיטָה","n",NULL,"shita","שיטה","שיטה",NULL,"$I@H","$I@H",NULL);
INSERT INTO hebrew_morpho VALUES (94215,"צְמִיגוּת","n",NULL,"tzmigut","צמיגות","צמיגות",NULL,"CMIGWT","CMIGWT",NULL);
INSERT INTO hebrew_morpho VALUES (94216,"צָמָא","n",NULL,"tzama","צמא","צמא",NULL,"CMA","CMA",NULL);
INSERT INTO hebrew_morpho VALUES (94217,"צִמָּאוֹן","n",NULL,"tzima\'on","צימאון","צמאון",NULL,"CMAWN","CIMAWN",NULL);
INSERT INTO hebrew_morpho VALUES (94218,"צְרִידוּת","n",NULL,"tzridut","צרידות","צרידות",NULL,"CRIDWT","CRIDWT",NULL);
INSERT INTO hebrew_morpho VALUES (94219,"גּוּף-הָאָדָם","n",NULL,"guf-ha\'adam","גוף-האדם","גוף-האדם",NULL,"GWP-HADM","GWP-HADM",NULL);
INSERT INTO hebrew_morpho VALUES (94220,"צֶלַע","n",NULL,"tzela","צלע","צלע",NULL,"CL&","CL&",NULL);
INSERT INTO hebrew_morpho VALUES (94221,"צָלִי","n",NULL,"tzali","צלי","צלי",NULL,"CLI","CLI",NULL);
INSERT INTO hebrew_morpho VALUES (94222,"קְטִילָה","n",NULL,"ktila","קטילה","קטילה",NULL,"Q@ILH","Q@ILH",NULL);
INSERT INTO hebrew_morpho VALUES (94223,"כִּסּוּחַ","n",NULL,"kisu\'ach","כיסוח","כסוח",NULL,"KSWX","KISWX",NULL);
INSERT INTO hebrew_morpho VALUES (94224,"צֹרֶךְ","n",NULL,"tzorech","צורך","צרך",NULL,"CRK","CWRK",NULL);
INSERT INTO hebrew_morpho VALUES (94225,"פֶּשַׁע","n",NULL,"pesha","פשע","פשע",NULL,"P$&","P$&",NULL);
INSERT INTO hebrew_morpho VALUES (94226,"עֲבֵרָה","n",NULL,"avera","עברה","עברה",NULL,"&BRH","&BRH",NULL);
INSERT INTO hebrew_morpho VALUES (94227,"חִסּוּר","n",NULL,"xissur","חיסור","חסור",NULL,"XSWR","XISWR",NULL);
INSERT INTO hebrew_morpho VALUES (94228,"עִצּוּב-נוֹף","n",NULL,"itzuv nof","עיצוב-נוף","עצוב-נוף",NULL,"&CWB-NWP","&ICWB-NWP",NULL);
INSERT INTO hebrew_morpho VALUES (94229,"חֲקִיקָה","n",NULL,"xakika","חקיקה","חקיקה",NULL,"XQIQH","XQIQH",NULL);
INSERT INTO hebrew_morpho VALUES (94230,"עֲרִיכַת-רְשִׁימָה","n",NULL,"arixat reshima","עריכת-רשימה","עריכת-רשימה",NULL,"&RIKT-R$IMH","&RIKT-R$IMH",NULL);
INSERT INTO hebrew_morpho VALUES (94231,"פִּרְסוּם","n",NULL,"pirsum","פרסום","פרסום",NULL,"PRSWM","PRSWM",NULL);
INSERT INTO hebrew_morpho VALUES (94232,"הוֹצָאָה-לָאוֹר","n",NULL,"hotza\'ah la\'or","הוצאה-לאור","הוצאה-לאור",NULL,"HWCAH-LAWR","HWCAH-LAWR",NULL);
INSERT INTO hebrew_morpho VALUES (94233,"דְּרִישָׁה","n",NULL,"drisha","דרישה","דרישה",NULL,"DRI$H","DRI$H",NULL);
INSERT INTO hebrew_morpho VALUES (94234,"דְּרִישַׁת-קְדָם","n",NULL,"drishat-kdam","דרישת-קדם","דרישת-קדם",NULL,"DRI$T-QDM","DRI$T-QDM",NULL);
INSERT INTO hebrew_morpho VALUES (94235,"קוֹד","n",NULL,"kod","קוד","קוד",NULL,"QWD","QWD",NULL);
INSERT INTO hebrew_morpho VALUES (94236,"קוֹדִיפִיקַצְיָה","n",NULL,"kodifikatzya","קודיפיקציה","קודיפיקציה",NULL,"QWDIPIQCIH","QWDIPIQCIH",NULL);
INSERT INTO hebrew_morpho VALUES (94237,"קוֹדֵקְס","n",NULL,"kodeks","קודקס","קודקס",NULL,"QWDQS","QWDQS",NULL);
INSERT INTO hebrew_morpho VALUES (94238,"צֹפֶן","n",NULL,"tzofen","צופן","צפן",NULL,"CPN","CWPN",NULL);
INSERT INTO hebrew_morpho VALUES (94239,"פִּיּוּס","n",NULL,"piyus","פיוס","פיוס",NULL,"PIWS","PIWS",NULL);
INSERT INTO hebrew_morpho VALUES (94240,"הֲפָסָה","n",NULL,"hafasa","הפסה","הפסה",NULL,"HPSH","HPSH",NULL);
INSERT INTO hebrew_morpho VALUES (94241,"פַּרְעוֹשׁ","n",NULL,"par\'osh","פרעוש","פרעוש",NULL,"PR&W$","PR&W$",NULL);
INSERT INTO hebrew_morpho VALUES (94242,"קוֹבְּרָה","n",NULL,"kobra","קוברה","קוברה",NULL,"QWBRH","QWBRH",NULL);
INSERT INTO hebrew_morpho VALUES (94243,"פֶּרֶד","n",NULL,"pered","פרד","פרד",NULL,"PRD","PRD",NULL);
INSERT INTO hebrew_morpho VALUES (94244,"שׁוֹפִין","n",NULL,"shofin","שופין","שופין",NULL,"$WPIN","$WPIN",NULL);
INSERT INTO hebrew_morpho VALUES (94245,"מָשׁוֹף","n",NULL,"mashof","משוף","משוף",NULL,"M$WP","M$WP",NULL);
INSERT INTO hebrew_morpho VALUES (94246,"פְּצִירָה","n",NULL,"ptsira","פצירה","פצירה",NULL,"PCIRH","PCIRH",NULL);
INSERT INTO hebrew_morpho VALUES (94247,"פָּמוֹט","n",NULL,"pamot","פמוט","פמוט",NULL,"PMW@","PMW@",NULL);
INSERT INTO hebrew_morpho VALUES (94248,"פַּרְוָה","n",NULL,"parva","פרווה","פרוה",NULL,"PRWH","PRWWH",NULL);
INSERT INTO hebrew_morpho VALUES (94249,"פְּלָדָה","n",NULL,"plada","פלדה","פלדה",NULL,"PLDH","PLDH",NULL);
INSERT INTO hebrew_morpho VALUES (94250,"מַשְׁחֵז","n",NULL,"mashxez","משחז","משחז",NULL,"M$XZ","M$XZ",NULL);
INSERT INTO hebrew_morpho VALUES (94251,"מַשְׁחֵזָה","n",NULL,NULL,"משחזה","משחזה",NULL,"M$XZH","M$XZH",NULL);
INSERT INTO hebrew_morpho VALUES (94252,"פּוּמְפִּיָּה","n",NULL,"pumpiya","פומפייה","פומפיה",NULL,"PWMPIH","PWMPIIH",NULL);
INSERT INTO hebrew_morpho VALUES (94253,"פּוּךְ","n",NULL,"pux","פוך","פוך",NULL,"PWK","PWK",NULL);
INSERT INTO hebrew_morpho VALUES (94254,"שְׂמִיכַת.פּוּךְ","n",NULL,"smixat pux","שמיכת_פוך","שמיכת.פוך",NULL,"$MIKTPWK","$MIKT_PWK",NULL);
INSERT INTO hebrew_morpho VALUES (94255,"מוֹךְ","n",NULL,"mox","מוך","מוך",NULL,"MWK","MWK",NULL);
INSERT INTO hebrew_morpho VALUES (94256,"פָּגוֹשׁ","n",NULL,"pagosh","פגוש","פגוש",NULL,"PGW$","PGW$",NULL);
INSERT INTO hebrew_morpho VALUES (94257,"טַמְבּוֹן","n",NULL,"tambon","טמבון","טמבון",NULL,"@MBWN","@MBWN",NULL);
INSERT INTO hebrew_morpho VALUES (94258,"פְּיָאנוֹ","n",NULL,"pyano","פיאנו","פיאנו",NULL,"PIANW","PIANW",NULL);
INSERT INTO hebrew_morpho VALUES (94259,"פְּיָאנִיסִימוֹ","n",NULL,"pyanisimo","פיאניסימו","פיאניסימו",NULL,"PIANISIMW","PIANISIMW",NULL);
INSERT INTO hebrew_morpho VALUES (94260,"פְּסַנְתֵּר","n",NULL,"psanter","פסנתר","פסנתר",NULL,"PSNTR","PSNTR",NULL);
INSERT INTO hebrew_morpho VALUES (94261,"פִּטְמָה","n",NULL,"pitma","פטמה","פטמה",NULL,"P@MH","P@MH",NULL);
INSERT INTO hebrew_morpho VALUES (94262,"פֶּטֶל","n",NULL,"petel","פטל","פטל",NULL,"P@L","P@L",NULL);
INSERT INTO hebrew_morpho VALUES (94263,"רוּחַ-מִזְרָחִית","n",NULL,"ru\'ax mizraxit","רוח-מזרחית","רוח-מזרחית",NULL,"RWX-MZRXIT","RWX-MZRXIT",NULL);
INSERT INTO hebrew_morpho VALUES (94264,"פַּסְחָא","n",NULL,"pasxa","פסחא","פסחא",NULL,"PSXA","PSXA",NULL);
INSERT INTO hebrew_morpho VALUES (94265,"פִּשְׁתָּן","n",NULL,"pishtan","פשתן","פשתן",NULL,"P$TN","P$TN",NULL);
INSERT INTO hebrew_morpho VALUES (94266,"פָּנָס","n",NULL,"panas","פנס","פנס",NULL,"PNS","PNS",NULL);
INSERT INTO hebrew_morpho VALUES (94267,"פָּנַס-כִּיס","n",NULL,"panas kis","פנס-כיס","פנס-כיס",NULL,"PNS-KIS","PNS-KIS",NULL);
INSERT INTO hebrew_morpho VALUES (94268,"פִּקַּת-הַבֶּרֶךְ","n",NULL,"pikkat haberex","פקת-הברך","פקת-הברך",NULL,"PQT-HBRK","PQT-HBRK",NULL);
INSERT INTO hebrew_morpho VALUES (94269,"פִּתְקָה","n",NULL,"pitka","פתקה","פתקה",NULL,"PTQH","PTQH",NULL);
INSERT INTO hebrew_morpho VALUES (94270,"פֶּתֶק","n",NULL,"petek","פתק","פתק",NULL,"PTQ","PTQ",NULL);
INSERT INTO hebrew_morpho VALUES (94271,"פֶּחָם","n",NULL,"pexam","פחם","פחם",NULL,"PXM","PXM",NULL);
INSERT INTO hebrew_morpho VALUES (94272,"פַּחַם-עֵץ","n",NULL,"paxam etz","פחם-עץ","פחם-עץ",NULL,"PXM-&C","PXM-&C",NULL);
INSERT INTO hebrew_morpho VALUES (94273,"גַּחֶלֶת","n",NULL,"gaxelet","גחלת","גחלת",NULL,"GXLT","GXLT",NULL);
INSERT INTO hebrew_morpho VALUES (94274,"גַּחַל","n",NULL,"gaxal","גחל","גחל",NULL,"GXL","GXL",NULL);
INSERT INTO hebrew_morpho VALUES (94275,"רֶמֶץ","n",NULL,"remetz","רמץ","רמץ",NULL,"RMC","RMC",NULL);
INSERT INTO hebrew_morpho VALUES (94276,"פֶּרֶק","n",NULL,"perek","פרק","פֶּרֶק",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94277,"מִפְרָק","n",NULL,"mifrak","מפרק","מפרק",NULL,"MPRQ","MPRQ",NULL);
INSERT INTO hebrew_morpho VALUES (94278,"פְּרִי","n",NULL,"pri","פרי","פרי",NULL,"PRI","PRI",NULL);
INSERT INTO hebrew_morpho VALUES (94279,"פֹּעַל","n",NULL,"po\'al","פועל","פעל",NULL,"P&L","PW&L",NULL);
INSERT INTO hebrew_morpho VALUES (94280,"פִּסְלוֹן","n",NULL,"pislon","פסלון","פסלון",NULL,"PSLWN","PSLWN",NULL);
INSERT INTO hebrew_morpho VALUES (94281,"פַּרְבָר","n",NULL,"parvar","פרבר","פרבר",NULL,"PRBR","PRBR",NULL);
INSERT INTO hebrew_morpho VALUES (94282,"פַּרְוָר","n",NULL,"parvar","פרוור","פרור",NULL,"PRWR","PRWWR",NULL);
INSERT INTO hebrew_morpho VALUES (94283,"פִּקְחוּת","n",NULL,"pikxut","פקחות","פקחות",NULL,"PQXWT","PQXWT",NULL);
INSERT INTO hebrew_morpho VALUES (94284,"מִתְרוֹמֵם","n",NULL,"mitromem","מתרומם","מתרומם",NULL,"MTRWMM","MTRWMM",NULL);
INSERT INTO hebrew_morpho VALUES (94285,"פֵיָה","n",NULL,"feya","פיה","פיה",NULL,"PIH","PIH",NULL);
INSERT INTO hebrew_morpho VALUES (94286,"פִּתְגָּם","n",NULL,"pitgam","פתגם","פתגם",NULL,"PTGM","PTGM",NULL);
INSERT INTO hebrew_morpho VALUES (94287,"מֵימְרָה","n",NULL,"memra","מימרה","מימרה",NULL,"MIMRH","MIMRH",NULL);
INSERT INTO hebrew_morpho VALUES (94288,"פַּחַד","n",NULL,"paxad","פחד","פחד",NULL,"PXD","PXD",NULL);
INSERT INTO hebrew_morpho VALUES (94289,"פָּמַלְיָה","n",NULL,"pamalya","פמליה","פמליה",NULL,"PMLIH","PMLIH",NULL);
INSERT INTO hebrew_morpho VALUES (94290,"פְּצָצָה","n",NULL,"ptsatsa","פצצה","פצצה",NULL,"PCCH","PCCH",NULL);
INSERT INTO hebrew_morpho VALUES (94291,"קָלוֹרִימֶטֶר-פְּצָצָה","n",NULL,"kalorimeter ptsatsa","קלורימטר-פצצה","קלורימטר-פצצה",NULL,"QLWRIM@R-PCCH","QLWRIM@R-PCCH",NULL);
INSERT INTO hebrew_morpho VALUES (94292,"פֶּחָה","n",NULL,"pexa","פחה","פחה",NULL,"PXH","PXH",NULL);
INSERT INTO hebrew_morpho VALUES (94293,"פָּשָׁה","n",NULL,"pasha","פאשה","פשה",NULL,"P$H","PA$H",NULL);
INSERT INTO hebrew_morpho VALUES (94294,"פֶּנִי","n",NULL,"peni","פני","פני",NULL,"PNI","PNI",NULL);
INSERT INTO hebrew_morpho VALUES (94295,"פּוּלְמוּס","n",NULL,"pulmus","פולמוס","פולמוס",NULL,"PWLMWS","PWLMWS",NULL);
INSERT INTO hebrew_morpho VALUES (94296,"מַרְאֵה-מָקוֹם","n",NULL,"mar\'eh-makom","מראה-מקום","מראה-מקום",NULL,"MRAH-MQWM","MRAH-MQWM",NULL);
INSERT INTO hebrew_morpho VALUES (94297,"הַפְנָיָה","n",NULL,"hafnaya","הפניה","הפניה",NULL,"HPNIH","HPNIH",NULL);
INSERT INTO hebrew_morpho VALUES (94298,"אִזְכּוּר","n",NULL,"izkur","אזכור","אזכור",NULL,"AZKWR","AZKWR",NULL);
INSERT INTO hebrew_morpho VALUES (94299,"צִטּוּט","n",NULL,"tzitut","ציטוט","צטוט",NULL,"C@W@","CI@W@",NULL);
INSERT INTO hebrew_morpho VALUES (94300,"צִיטָטָה","n",NULL,"tzitata","ציטטה","ציטטה",NULL,"CI@@H","CI@@H",NULL);
INSERT INTO hebrew_morpho VALUES (94301,"צֶפִי","n",NULL,"tzefi","צפי","צפי",NULL,"CPI","CPI",NULL);
INSERT INTO hebrew_morpho VALUES (94302,"תַּחֲזִית","n",NULL,"tachazit","תחזית","תחזית",NULL,"TXZIT","TXZIT",NULL);
INSERT INTO hebrew_morpho VALUES (94303,"פְּרוֹגְנוֹזָה","n",NULL,"prognoza","פרוגנוזה","פרוגנוזה",NULL,"PRWGNWZH","PRWGNWZH",NULL);
INSERT INTO hebrew_morpho VALUES (94304,"צָרְפָתִית","n",NULL,"tzarfatit","צרפתית","צרפתית",NULL,"CRPTIT","CRPTIT",NULL);
INSERT INTO hebrew_morpho VALUES (94305,"צְרִיחָה","n",NULL,"tzricha","צריחה","צריחה",NULL,"CRIXH","CRIXH",NULL);
INSERT INTO hebrew_morpho VALUES (94306,"צְוָחָה","n",NULL,"tzvacha","צווחה","צוחה",NULL,"CWXH","CWWXH",NULL);
INSERT INTO hebrew_morpho VALUES (94307,"צְרָחָה","n",NULL,"tzracha","צרחה","צרחה",NULL,"CRXH","CRXH",NULL);
INSERT INTO hebrew_morpho VALUES (94308,"צְוִיחָה","n",NULL,"tzvicha","צויחה","צויחה",NULL,"CWIXH","CWIXH",NULL);
INSERT INTO hebrew_morpho VALUES (94309,"צִחְקוּק","n",NULL,"tzichkuk","צחקוק","צחקוק",NULL,"CXQWQ","CXQWQ",NULL);
INSERT INTO hebrew_morpho VALUES (94310,"הַצְּלִיבָה","n",NULL,"hatzliva","הצליבה","הצליבה",NULL,"HCLIBH","HCLIBH",NULL);
INSERT INTO hebrew_morpho VALUES (94311,"צִיּוּץ","n",NULL,"tziyutz","ציוץ","ציוץ",NULL,"CIWC","CIWC",NULL);
INSERT INTO hebrew_morpho VALUES (94312,"צַעַד","n",NULL,"tza\'ad","צעד","צעד",NULL,"C&D","C&D",NULL);
INSERT INTO hebrew_morpho VALUES (94313,"צָהֳלָה","n",NULL,"tzahala","צהלה","צהלה",NULL,"CHLH","CHLH",NULL);
INSERT INTO hebrew_morpho VALUES (94314,"צִמְחוֹנוּת","n",NULL,"tzimchonut","צמחונות","צמחונות",NULL,"CMXWNWT","CMXWNWT",NULL);
INSERT INTO hebrew_morpho VALUES (94315,"צוּף","n",NULL,"tzuf","צוף","צוף",NULL,"CWP","CWP",NULL);
INSERT INTO hebrew_morpho VALUES (94316,"נֶקְטָר","n",NULL,"nektar","נקטר","נקטר",NULL,"NQ@R","NQ@R",NULL);
INSERT INTO hebrew_morpho VALUES (94317,"זֶנִית","n",NULL,"zenit","זנית","זנית",NULL,"ZNIT","ZNIT",NULL);
INSERT INTO hebrew_morpho VALUES (94318,"נָדִיר","n",NULL,"nadir","נדיר","נדיר",NULL,"NDIR","NDIR",NULL);
INSERT INTO hebrew_morpho VALUES (94319,"חֹד","n",NULL,"חוד","חד","חד",NULL,"XD","XD",NULL);
INSERT INTO hebrew_morpho VALUES (94320,"שְׁפִּיץ","n",NULL,"shpitz","שפיץ","שפיץ",NULL,"$PIC","$PIC",NULL);
INSERT INTO hebrew_morpho VALUES (94321,"פִּסְגָּה","n",NULL,"pisga","פסגה","פסגה",NULL,"PSGH","PSGH",NULL);
INSERT INTO hebrew_morpho VALUES (94322,"רֹאשׁ-הַר","n",NULL,"rosh har","ראש-הר","ראש-הר",NULL,"RA$-HR","RA$-HR",NULL);
INSERT INTO hebrew_morpho VALUES (94323,"שִׂיא","n",NULL,"si","שיא","שיא",NULL,"$IA","$IA",NULL);
INSERT INTO hebrew_morpho VALUES (94324,"מִשְׂרַד-הַפְּנִים-הָאָמֶרִיקָאִי","n",NULL,"misrad hapnim ha\'amerika\'i","משרד-הפנים-האמריקאי","משרד-הפנים-האמריקאי",NULL,"M$RD-HPNIM-HAMRIQAI","M$RD-HPNIM-HAMRIQAI",NULL);
INSERT INTO hebrew_morpho VALUES (94325,"פְּנִים","n",NULL,"pnim","פנים","פנים",NULL,"PNIM","PNIM",NULL);
INSERT INTO hebrew_morpho VALUES (94326,"קֶרֶב","n",NULL,"kerev","קרב","קרב",NULL,"QRB","QRB",NULL);
INSERT INTO hebrew_morpho VALUES (94327,"תּוֹךְ","n",NULL,"tox","תוך","תוך",NULL,"TWK","TWK",NULL);
INSERT INTO hebrew_morpho VALUES (94328,"צְנִים","n",NULL,"tznim","צנים","צנים",NULL,"CNIM","CNIM",NULL);
INSERT INTO hebrew_morpho VALUES (94329,"צֶמֶד","n",NULL,"tzemed","צמד","צמד",NULL,"CMD","CMD",NULL);
INSERT INTO hebrew_morpho VALUES (94330,"צָבָא","n",NULL,"tzava","צבא","צבא",NULL,"CBA","CBA",NULL);
INSERT INTO hebrew_morpho VALUES (94331,"צֶוֶת","n",NULL,"tzevet","צוות","צות",NULL,"CWT","CWWT",NULL);
INSERT INTO hebrew_morpho VALUES (94332,"צָרְפַת","n",NULL,"tzarfat","צרפת","צרפת",NULL,"CRPT","CRPT",NULL);
INSERT INTO hebrew_morpho VALUES (94333,"צַרְכָן","n",NULL,"tzarchan","צרכן","צרכן",NULL,"CRKN","CRKN",NULL);
INSERT INTO hebrew_morpho VALUES (94334,"צַפְצָפָה","n",NULL,"tzaftzafa","צפצפה","צפצפה",NULL,"CPCPH","CPCPH",NULL);
INSERT INTO hebrew_morpho VALUES (94335,"קַקְטוּס","n",NULL,"kaktus","קקטוס","קקטוס",NULL,"QQ@WS","QQ@WS",NULL);
INSERT INTO hebrew_morpho VALUES (94336,"צָפוֹן","n",NULL,"tzafon","צפון","צפון",NULL,"CPWN","CPWN",NULL);
INSERT INTO hebrew_morpho VALUES (94337,"צָרַעַת","n",NULL,"tzara\'at","צרעת","צרעת",NULL,"CR&T","CR&T",NULL);
INSERT INTO hebrew_morpho VALUES (94338,"מַחֲלַת-הַנְסֶן","n",NULL,"machalat-hansen","מחלת-הנסן","מחלת-הנסן",NULL,"MXLT-HNSN","MXLT-HNSN",NULL);
INSERT INTO hebrew_morpho VALUES (94339,"צָרֶבֶת","n",NULL,"tzarevet","צרבת","צרבת",NULL,"CRBT","CRBT",NULL);
INSERT INTO hebrew_morpho VALUES (94340,"פֶּרֶשׁ","n",NULL,"peresh","פרש","פרש",NULL,"PR$","PR$",NULL);
INSERT INTO hebrew_morpho VALUES (94341,"צוֹאָה","n",NULL,"tzo\'ah","צואה","צואה",NULL,"CWAH","CWAH",NULL);
INSERT INTO hebrew_morpho VALUES (94342,"צָהֳרַיִם","n",NULL,"tzohorayim","צהריים","צהרים",NULL,"CHRIM","CHRIIM",NULL);
INSERT INTO hebrew_morpho VALUES (94343,"הִבְחִין","v",NULL,"hivchin","הבחין","הבחין",NULL,"HBXIN","HBXIN",NULL);
INSERT INTO hebrew_morpho VALUES (94344,"הִפְרִיד","v",NULL,"hifrid","הפריד","הפריד",NULL,"HPRID","HPRID",NULL);
INSERT INTO hebrew_morpho VALUES (94345,"הִבְדִּיל","v",NULL,"hivdil","הבדיל","הבדיל",NULL,"HBDIL","HBDIL",NULL);
INSERT INTO hebrew_morpho VALUES (94346,"צִיֵּן","v",NULL,"tziyen","ציין","צין",NULL,"CIN","CIIN",NULL);
INSERT INTO hebrew_morpho VALUES (94347,"צָרַח","v",NULL,"tzarach","צרח","צרח",NULL,"CRX","CRX",NULL);
INSERT INTO hebrew_morpho VALUES (94348,"צָעַק","v",NULL,"tza\'ak","צעק","צעק",NULL,"C&Q","C&Q",NULL);
INSERT INTO hebrew_morpho VALUES (94349,"הֵרִים-אֶת-קוֹלוֹ","v",NULL,"herim-et-kolo","הרים-את-קולו","הרים-את-קולו",NULL,"HRIM-AT-QWLW","HRIM-AT-QWLW",NULL);
INSERT INTO hebrew_morpho VALUES (94350,"צָד","v",NULL,"tzad","צד","צד",NULL,"CD","CD",NULL);
INSERT INTO hebrew_morpho VALUES (94351,"צָהַל","v",NULL,"tzahal","צהל","צהל",NULL,"CHL","CHL",NULL);
INSERT INTO hebrew_morpho VALUES (94352,"צָם","v",NULL,"tzam","צם","צם",NULL,"CM","CM",NULL);
INSERT INTO hebrew_morpho VALUES (94353,"צָבָא","v",NULL,"tzava","צבא","צבא",NULL,"CBA","CBA",NULL);
INSERT INTO hebrew_morpho VALUES (94354,"צִלֵּם","v",NULL,"tzilem","צילם","צלם",NULL,"CLM","CILM",NULL);
INSERT INTO hebrew_morpho VALUES (94355,"צָלַע","v",NULL,"tzala","צלע","צלע",NULL,"CL&","CL&",NULL);
INSERT INTO hebrew_morpho VALUES (94356,"דָּרַךְ","v",NULL,"darach","דרך","דרך",NULL,"DRK","DRK",NULL);
INSERT INTO hebrew_morpho VALUES (94357,"צָעַד","v",NULL,"tza\'ad","צעד","צעד",NULL,"C&D","C&D",NULL);
INSERT INTO hebrew_morpho VALUES (94358,"קֵדְמָה","r",NULL,"kedma","קדמה","קדמה",NULL,"QDMH","QDMH",NULL);
INSERT INTO hebrew_morpho VALUES (94359,"קַדַּחְתָּנִי","a",NULL,"kadachtani","קדחתני","קדחתני",NULL,"QDXTNI","QDXTNI",NULL);
INSERT INTO hebrew_morpho VALUES (94360,"קָשׁוּר","a",NULL,"kashur","קשור","קשור",NULL,"Q$WR","Q$WR",NULL);
INSERT INTO hebrew_morpho VALUES (94361,"קָטָן","n",NULL,"katan","קטן","קטן",NULL,"Q@N","Q@N",NULL);
INSERT INTO hebrew_morpho VALUES (94362,"פָּעוֹט","n",NULL,"pa\'ot","פעוט","פעוט",NULL,"P&W@","P&W@",NULL);
INSERT INTO hebrew_morpho VALUES (94363,"זַאֲטוּט","n",NULL,"za\'atut","זאטוט","זאטוט",NULL,"ZA@W@","ZA@W@",NULL);
INSERT INTO hebrew_morpho VALUES (94364,"קָטַנְצִ\'יק","n",NULL,"katanchik","קטנצ\'יק","קטנצ\'יק",NULL,"Q@NC\'IQ","Q@NC\'IQ",NULL);
INSERT INTO hebrew_morpho VALUES (94365,"יַלְדּוֹן","n",NULL,"yaldon","ילדון","ילדון",NULL,"ILDWN","ILDWN",NULL);
INSERT INTO hebrew_morpho VALUES (94366,"צוּצִיק","n",NULL,"tzutzik","צוציק","צוציק",NULL,"CWCIQ","CWCIQ",NULL);
INSERT INTO hebrew_morpho VALUES (94367,"פַסְפוּס","n",NULL,"fasfus","פספוס","פספוס",NULL,"PSPWS","PSPWS",NULL);
INSERT INTO hebrew_morpho VALUES (94368,"קַטְנוּנִי","a",NULL,"katnuni","קטנוני","קטנוני",NULL,"Q@NWNI","Q@NWNI",NULL);
INSERT INTO hebrew_morpho VALUES (94369,"קַמְצָנִי","a",NULL,"kamtzani","קמצני","קמצני",NULL,"QMCNI","QMCNI",NULL);
INSERT INTO hebrew_morpho VALUES (94370,"קָטָן","a",NULL,"katan","קטן","קטן",NULL,"Q@N","Q@N",NULL);
INSERT INTO hebrew_morpho VALUES (94371,"זָעִיר","a",NULL,"za\'ir","זעיר","זעיר",NULL,"Z&IR","Z&IR",NULL);
INSERT INTO hebrew_morpho VALUES (94372,"קָרוֹב","r",NULL,"karov","קרוב","קרוב",NULL,"QRWB","QRWB",NULL);
INSERT INTO hebrew_morpho VALUES (94373,"קָרוֹב","a",NULL,"karov","קרוב","קרוב",NULL,"QRWB","QRWB",NULL);
INSERT INTO hebrew_morpho VALUES (94374,"קְבוּצָתִי","a",NULL,"kvutzati","קבוצתי","קבוצתי",NULL,"QBWCTI","QBWCTI",NULL);
INSERT INTO hebrew_morpho VALUES (94375,"קָמוּר","a",NULL,"kamur","קמור","קמור",NULL,"QMWR","QMWR",NULL);
INSERT INTO hebrew_morpho VALUES (94376,"מְקֻמָּר","a",NULL,"mekumar","מקומר","מקמר",NULL,"MQMR","MQWMR",NULL);
INSERT INTO hebrew_morpho VALUES (94377,"חָתוּךְ","a",NULL,"chatuch","חתוך","חתוך",NULL,"XTWK","XTWK",NULL);
INSERT INTO hebrew_morpho VALUES (94378,"קָצוּץ","a",NULL,"katzutz","קצוץ","קצוץ",NULL,"QCWC","QCWC",NULL);
INSERT INTO hebrew_morpho VALUES (94379,"מְקֻצָּץ","a",NULL,"mekutzatz","מקוצץ","מקצץ",NULL,"MQCC","MQWCC",NULL);
INSERT INTO hebrew_morpho VALUES (94380,"קָשֶׁה","a",NULL,"kashe","קשה","קשה",NULL,"Q$H","Q$H",NULL);
INSERT INTO hebrew_morpho VALUES (94381,"קַל","a",NULL,"kal","קל","קַל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94382,"פְּסִילָה","n",NULL,"psila","פסילה","פסילה",NULL,"PSILH","PSILH",NULL);
INSERT INTO hebrew_morpho VALUES (94383,"שָׁלָל","n",NULL,"shalal","שלל","שלל",NULL,"$LL","$LL",NULL);
INSERT INTO hebrew_morpho VALUES (94384,"פֵּרוּק","n",NULL,"peruk","פירוק","פרוק",NULL,"PRWQ","PIRWQ",NULL);
INSERT INTO hebrew_morpho VALUES (94385,"פְּעִיָּה","n",NULL,"pe\'iya","פעייה","פעיה",NULL,"P&IH","P&IIH",NULL);
INSERT INTO hebrew_morpho VALUES (94386,"פָּרָג","n",NULL,"parag","פרג","פרג",NULL,"PRG","PRG",NULL);
INSERT INTO hebrew_morpho VALUES (94387,"סָנֵגוֹר","n",NULL,"sanegor","סנגור","סנגור",NULL,"SNGWR","SNGWR",NULL);
INSERT INTO hebrew_morpho VALUES (94388,"פִּטְרִיָּה","n",NULL,"pitriya","פטרייה","פטריה",NULL,"P@RIH","P@RIIH",NULL);
INSERT INTO hebrew_morpho VALUES (94389,"בְּדִיל","n",NULL,"bdil","בדיל","בדיל",NULL,"BDIL","BDIL",NULL);
INSERT INTO hebrew_morpho VALUES (94390,"פַּחִית","n",NULL,"paxit","פחית","פחית",NULL,"PXIT","PXIT",NULL);
INSERT INTO hebrew_morpho VALUES (94391,"פְּקַק-שַׁעַם","n",NULL,NULL,"פקק-שעם","פקק-שעם",NULL,"PQQ-$&M","PQQ-$&M",NULL);
INSERT INTO hebrew_morpho VALUES (94392,"סָנֵגוֹרִית","n",NULL,"sanegorit","סנגורית","סנגורית",NULL,"SNGWRIT","SNGWRIT",NULL);
INSERT INTO hebrew_morpho VALUES (94393,"מוֹתָרוֹת","n",NULL,"motarot","מותרות","מותרות",NULL,"MWTRWT","MWTRWT",NULL);
INSERT INTO hebrew_morpho VALUES (94394,"לוּקְסוּס","n",NULL,"luksus","לוקסוס","לוקסוס",NULL,"LWQSWS","LWQSWS",NULL);
INSERT INTO hebrew_morpho VALUES (94395,"חַיֵּי-מוֹתָרוֹת","n",NULL,"xayei motarot","חיי-מותרות","חיי-מותרות",NULL,"XII-MWTRWT","XII-MWTRWT",NULL);
INSERT INTO hebrew_morpho VALUES (94396,"פְּאֵר","n",NULL,"pe\'er","פאר","פאר",NULL,"PAR","PAR",NULL);
INSERT INTO hebrew_morpho VALUES (94397,"פֶּגַע","n",NULL,"pig\'ei","פגע","פגע",NULL,"PG&","PG&",NULL);
INSERT INTO hebrew_morpho VALUES (94398,"פֶבְּרוּאָר","n",NULL,"febru\'ar","פברואר","פברואר",NULL,"PBRWAR","PBRWAR",NULL);
INSERT INTO hebrew_morpho VALUES (94399,"פְּנִינָה","n",NULL,"pnina","פנינה","פנינה",NULL,"PNINH","PNINH",NULL);
INSERT INTO hebrew_morpho VALUES (94400,"פָּרַח","v",NULL,"parax","פרח","פרח",NULL,"PRX","PRX",NULL);
INSERT INTO hebrew_morpho VALUES (94401,"לִבְלֵב","v",NULL,"livlev","לבלב","לבלב",NULL,"LBLB","LBLB",NULL);
INSERT INTO hebrew_morpho VALUES (94402,"הֵנֵץ","v",NULL,NULL,"הנץ","הנץ",NULL,"HNC","HNC",NULL);
INSERT INTO hebrew_morpho VALUES (94403,"פִּטְפֵּט","v",NULL,"pitpet","פטפט","פטפט",NULL,"P@P@","P@P@",NULL);
INSERT INTO hebrew_morpho VALUES (94404,"פַּשְׁטִידָה","n",NULL,"pashtida","פשטידה","פשטידה",NULL,"P$@IDH","P$@IDH",NULL);
INSERT INTO hebrew_morpho VALUES (94405,"אֶלֶמֶנְטָרִי","a",NULL,"elementari","אלמנטרי","אלמנטרי",NULL,"ALMN@RI","ALMN@RI",NULL);
INSERT INTO hebrew_morpho VALUES (94406,"קָמוּץ","a",NULL,"kamutz","קמוץ","קמוץ",NULL,"QMWC","QMWC",NULL);
INSERT INTO hebrew_morpho VALUES (94407,"קִיקְיוֹנִי","a",NULL,"kikyoni","קיקיוני","קיקיוני",NULL,"QIQIWNI","QIQIWNI",NULL);
INSERT INTO hebrew_morpho VALUES (94408,"חוֹלֵף","a",NULL,"cholef","חולף","חולף",NULL,"XWLP","XWLP",NULL);
INSERT INTO hebrew_morpho VALUES (94409,"עוֹבֵר","a",NULL,"over","עובר","עובר",NULL,"&WBR","&WBR",NULL);
INSERT INTO hebrew_morpho VALUES (94410,"בַּר-חֲלוֹף","a",NULL,"bar-chalof","בר-חלוף","בר-חלוף",NULL,"BR-XLWP","BR-XLWP",NULL);
INSERT INTO hebrew_morpho VALUES (94411,"בֶּן-חֲלוֹף","a",NULL,"ben-chalof","בן-חלוף","בן-חלוף",NULL,"BN-XLWP","BN-XLWP",NULL);
INSERT INTO hebrew_morpho VALUES (94412,"קִמְעוֹנִי","a",NULL,"kim\'oni","קימעוני","קמעוני",NULL,"QM&WNI","QIM&WNI",NULL);
INSERT INTO hebrew_morpho VALUES (94413,"קִמְעוֹנָאִי","a",NULL,"kim\'ona\'i","קמעונאי","קמעונאי",NULL,"QM&WNAI","QM&WNAI",NULL);
INSERT INTO hebrew_morpho VALUES (94414,"רָדִיקָל","n",NULL,"radikal","רדיקל","רדיקל",NULL,"RDIQL","RDIQL",NULL);
INSERT INTO hebrew_morpho VALUES (94415,"דֶּלְפֵּק-קַבָּלָה","n",NULL,"delpek-kabala","דלפק-קבלה","דלפק-קבלה",NULL,"DLPQ-QBLH","DLPQ-QBLH",NULL);
INSERT INTO hebrew_morpho VALUES (94416,"קַבָּלָה","n",NULL,"kabala","קבלה","קבלה",NULL,"QBLH","QBLH",NULL);
INSERT INTO hebrew_morpho VALUES (94417,"קַבָּלַת-פָּנִים","n",NULL,"kabalat-panim","קבלת-פנים","קבלת-פנים",NULL,"QBLT-PNIM","QBLT-PNIM",NULL);
INSERT INTO hebrew_morpho VALUES (94418,"קְנִיָּה","n",NULL,"kniya","קנייה","קניה",NULL,"QNIH","QNIIH",NULL);
INSERT INTO hebrew_morpho VALUES (94419,"קְשִׁירָה","n",NULL,"kshira","קשירה","קשירה",NULL,"Q$IRH","Q$IRH",NULL);
INSERT INTO hebrew_morpho VALUES (94420,"קְרִיסָה","n",NULL,"krisa","קריסה","קריסה",NULL,"QRISH","QRISH",NULL);
INSERT INTO hebrew_morpho VALUES (94421,"קִצּוּר","n",NULL,"kitzur","קיצור","קצור",NULL,"QCWR","QICWR",NULL);
INSERT INTO hebrew_morpho VALUES (94422,"קִצּוּר-דֶּרֶךְ","n",NULL,"kitzur-derech","קיצור-דרך","קצור-דרך",NULL,"QCWR-DRK","QICWR-DRK",NULL);
INSERT INTO hebrew_morpho VALUES (94423,"פֶּנְסְיָה","n",NULL,"pensia","פנסיה","פנסיה",NULL,"PNSIH","PNSIH",NULL);
INSERT INTO hebrew_morpho VALUES (94424,"קִצְבַּת-זִקְנָה","n",NULL,"kitzbat zikna","קצבת-זקנה","קצבת-זקנה",NULL,"QCBT-ZQNH","QCBT-ZQNH",NULL);
INSERT INTO hebrew_morpho VALUES (94425,"פָּדָה","v",NULL,"pada","פדה","פדה",NULL,"PDH","PDH",NULL);
INSERT INTO hebrew_morpho VALUES (94426,"הִקְטִין","v",NULL,"hiktin","הקטין","הקטין",NULL,"HQ@IN","HQ@IN",NULL);
INSERT INTO hebrew_morpho VALUES (94427,"פִּנָּה","v",NULL,"pina","פינה","פנה",NULL,"PNH","PINH",NULL);
INSERT INTO hebrew_morpho VALUES (94428,"הַסְרָטָה","n",NULL,"hasrata","הסרטה","הסרטה",NULL,"HSR@H","HSR@H",NULL);
INSERT INTO hebrew_morpho VALUES (94429,"קִדּוּחַ","n",NULL,"kidu\'ach","קידוח","קדוח",NULL,"QDWX","QIDWX",NULL);
INSERT INTO hebrew_morpho VALUES (94430,"קְדִיחָה","n",NULL,"kdicha","קדיחה","קדיחה",NULL,"QDIXH","QDIXH",NULL);
INSERT INTO hebrew_morpho VALUES (94431,"פְּזִילָה","n",NULL,"pzila","פזילה","פזילה",NULL,"PZILH","PZILH",NULL);
INSERT INTO hebrew_morpho VALUES (94432,"פֶּסַח","n",NULL,"pesax","פסח","פסח",NULL,"PSX","PSX",NULL);
INSERT INTO hebrew_morpho VALUES (94433,"חַג-הַחֵרוּת","n",NULL,"xag haxerut","חג-החרות","חג-החרות",NULL,"XG-HXRWT","XG-HXRWT",NULL);
INSERT INTO hebrew_morpho VALUES (94434,"פָּגַע","v",NULL,"paga","פגע","פגע",NULL,"PG&","PG&",NULL);
INSERT INTO hebrew_morpho VALUES (94435,"הִתְחַנֵּן","v",NULL,"hitxanen","התחנן","התחנן",NULL,"HTXNN","HTXNN",NULL);
INSERT INTO hebrew_morpho VALUES (94436,"הִפְצִיר","v",NULL,"hiftsir","הפציר","הפציר",NULL,"HPCIR","HPCIR",NULL);
INSERT INTO hebrew_morpho VALUES (94437,"קִדּוּשׁ","n",NULL,"kidush","קידוש","קדוש",NULL,"QDW$","QIDW$",NULL);
INSERT INTO hebrew_morpho VALUES (94438,"אִשְׁרוּר","n",NULL,"ishrur","אשרור","אשרור",NULL,"A$RWR","A$RWR",NULL);
INSERT INTO hebrew_morpho VALUES (94439,"הֶעֱלִיב","v",NULL,"he\'eliv","העליב","העליב",NULL,"H&LIB","H&LIB",NULL);
INSERT INTO hebrew_morpho VALUES (94440,"קִצּוּב","n",NULL,"kitzuv","קיצוב","קצוב",NULL,"QCWB","QICWB",NULL);
INSERT INTO hebrew_morpho VALUES (94441,"קִמְעוֹנוּת","n",NULL,"kim\'onut","קמעונות","קמעונות",NULL,"QM&WNWT","QM&WNWT",NULL);
INSERT INTO hebrew_morpho VALUES (94442,"קִמְעוֹנָאוּת","n",NULL,"kin\'ona\'ut","קמעונאות","קמעונאות",NULL,"QM&WNAWT","QM&WNAWT",NULL);
INSERT INTO hebrew_morpho VALUES (94443,"קַרְפִּיּוֹן","n",NULL,"karpiyon","קרפיון","קרפיון",NULL,"QRPIWN","QRPIWN",NULL);
INSERT INTO hebrew_morpho VALUES (94444,"קֻרְקְבָן","n",NULL,"kurkevan","קורקבן","קרקבן",NULL,"QRQBN","QWRQBN",NULL);
INSERT INTO hebrew_morpho VALUES (94445,"קַרְנָף","n",NULL,"karnaf","קרנף","קרנף",NULL,"QRNP","QRNP",NULL);
INSERT INTO hebrew_morpho VALUES (94446,"קֶלַע","n",NULL,"kela","קלע","קלע",NULL,"QL&","QL&",NULL);
INSERT INTO hebrew_morpho VALUES (94447,"מִקְלַעַת","n",NULL,"mikla\'at","מקלעת","מקלעת",NULL,"MQL&T","MQL&T",NULL);
INSERT INTO hebrew_morpho VALUES (94448,"רוּגַטְקָה","n",NULL,"rugatka","רוגטקה","רוגטקה",NULL,"RWG@QH","RWG@QH",NULL);
INSERT INTO hebrew_morpho VALUES (94449,"קֶרֶן","n",NULL,"keren","קרן","קרן",NULL,"QRN","QRN",NULL);
INSERT INTO hebrew_morpho VALUES (94450,"קֶרֶן-צָרְפָתִית","n",NULL,"keren-tzarfatit","קרן-צרפתית","קרן-צרפתית",NULL,"QRN-CRPTIT","QRN-CRPTIT",NULL);
INSERT INTO hebrew_morpho VALUES (94451,"קֶרֶן-יַעַר","n",NULL,"keren-ya\'ar","קרן-יער","קרן-יער",NULL,"QRN-I&R","QRN-I&R",NULL);
INSERT INTO hebrew_morpho VALUES (94452,"חֲצוֹצְרָה","n",NULL,"chatzotzra","חצוצרה","חצוצרה",NULL,"XCWCRH","XCWCRH",NULL);
INSERT INTO hebrew_morpho VALUES (94453,"חֶבְרָה-לְהַשְׁקָעוֹת","n",NULL,"chevra-lehashka\'ot","חברה-להשקעות","חברה-להשקעות",NULL,"XBRH-LH$Q&WT","XBRH-LH$Q&WT",NULL);
INSERT INTO hebrew_morpho VALUES (94454,"קֶרֶן-אוֹר","n",NULL,"keren-or","קרן-אור","קרן-אור",NULL,"QRN-AWR","QRN-AWR",NULL);
INSERT INTO hebrew_morpho VALUES (94455,"אֲלֻמַּת-אוֹר","n",NULL,"alumat-or","אלומת-אור","אלמת-אור",NULL,"ALMT-AWR","ALWMT-AWR",NULL);
INSERT INTO hebrew_morpho VALUES (94456,"מְלַאי","n",NULL,"mlay","מלאי","מלאי",NULL,"MLAI","MLAI",NULL);
INSERT INTO hebrew_morpho VALUES (94457,"קוֹרָה","n",NULL,"kora","קורה","קורה",NULL,"QWRH","QWRH",NULL);
INSERT INTO hebrew_morpho VALUES (94458,"פִּיחַ","n",NULL,"pi\'ax","פיח","פיח",NULL,"PIX","PIX",NULL);
INSERT INTO hebrew_morpho VALUES (94459,"קֶבֶר","n",NULL,"kever","קבר","קבר",NULL,"QBR","QBR",NULL);
INSERT INTO hebrew_morpho VALUES (94460,"לִירָה","n",NULL,"lira","לירה","לירה",NULL,"LIRH","LIRH",NULL);
INSERT INTO hebrew_morpho VALUES (94461,"יְרִיעַת-פַּח","n",NULL,"yeri\'at pax","יריעת-פח","יריעת-פח",NULL,"IRI&T-PX","IRI&T-PX",NULL);
INSERT INTO hebrew_morpho VALUES (94462,"פַּסֶּלֶת","n",NULL,"passelet","פסלת","פסלת",NULL,"PSLT","PSLT",NULL);
INSERT INTO hebrew_morpho VALUES (94463,"גִּיטָרָה","n",NULL,"gitara","גיטרה","גיטרה",NULL,"GI@RH","GI@RH",NULL);
INSERT INTO hebrew_morpho VALUES (94464,"בְּרֶגַע-שֶׁ","r",NULL,"berega sheh","ברגע-ש","ברגע-ש",NULL,"BRG&-$","BRG&-$",NULL);
INSERT INTO hebrew_morpho VALUES (94465,"קְלַסְתֵּרוֹן","n",NULL,"klasteron","קלסתרון","קלסתרון",NULL,"QLSTRWN","QLSTRWN",NULL);
INSERT INTO hebrew_morpho VALUES (94466,"פִּתּוּחַ","n",NULL,"pitu\'ax","פיתוח","פתוח",NULL,"PTWX","PITWX",NULL);
INSERT INTO hebrew_morpho VALUES (94467,"פֶּתַח","n",NULL,"petax","פחת","פתח",NULL,"PTX","PXT",NULL);
INSERT INTO hebrew_morpho VALUES (94468,"רַבָּנִי","a",NULL,"rabbani","רבני","רבני",NULL,"RBNI","RBNI",NULL);
INSERT INTO hebrew_morpho VALUES (94469,"רַבָּתִי","a",NULL,"rabbati","רבתי","רבתי",NULL,"RBTI","RBTI",NULL);
INSERT INTO hebrew_morpho VALUES (94470,"קִלְשׁוֹן","n",NULL,"kilshon","קלשון","קלשון",NULL,"QL$WN","QL$WN",NULL);
INSERT INTO hebrew_morpho VALUES (94471,"קֵיסָם","n",NULL,"keisam","קיסם","קיסם",NULL,"QISM","QISM",NULL);
INSERT INTO hebrew_morpho VALUES (94472,"מַחְצֵצָה","n",NULL,"machtzetza","מחצצה","מחצצה",NULL,"MXCCH","MXCCH",NULL);
INSERT INTO hebrew_morpho VALUES (94473,"קֵיסַם-שִׁנַּיִם","n",NULL,"keisam-shinayim","קיסם-שיניים","קיסם-שנים",NULL,"QISM-$NIM","QISM-$INIIM",NULL);
INSERT INTO hebrew_morpho VALUES (94474,"קֶצֶר","n",NULL,"ketzer","קצר","קצר",NULL,"QCR","QCR",NULL);
INSERT INTO hebrew_morpho VALUES (94475,"קְטִיפָה","n",NULL,"ktifa","קטיפה","קטיפה",NULL,"Q@IPH","Q@IPH",NULL);
INSERT INTO hebrew_morpho VALUES (94476,"תּוֹקְפָנוּת","n",NULL,"tokfanut","תוקפנות","תוקפנות",NULL,"TWQPNWT","TWQPNWT",NULL);
INSERT INTO hebrew_morpho VALUES (94477,"אַגְרֶסִיבִיּוּת","n",NULL,"agresiviyut","אגרסיביות","אגרסיביות",NULL,"AGRSIBIWT","AGRSIBIWT",NULL);
INSERT INTO hebrew_morpho VALUES (94478,"קְדֻשָּׁה","n",NULL,"kdusha","קדושה","קדשה",NULL,"QD$H","QDW$H",NULL);
INSERT INTO hebrew_morpho VALUES (94479,"קֹדֶשׁ","n",NULL,"kodesh","קודש","קדש",NULL,"QD$","QWD$",NULL);
INSERT INTO hebrew_morpho VALUES (94480,"קֶצֶב","n",NULL,"ketzev","קצב","קצב",NULL,"QCB","QCB",NULL);
INSERT INTO hebrew_morpho VALUES (94481,"טֶמְפּוֹ","n",NULL,"tempo","טמפו","טמפו",NULL,"@MPW","@MPW",NULL);
INSERT INTO hebrew_morpho VALUES (94482,"מִפְעָם","n",NULL,"mif\'am","מפעם","מפעם",NULL,"MP&M","MP&M",NULL);
INSERT INTO hebrew_morpho VALUES (94483,"קֹטֶן","n",NULL,"koten","קוטן","קטן",NULL,"Q@N","QW@N",NULL);
INSERT INTO hebrew_morpho VALUES (94484,"קַטְנוּת","n",NULL,"katnut","קטנות","קטנות",NULL,"Q@NWT","Q@NWT",NULL);
INSERT INTO hebrew_morpho VALUES (94485,"קֶבַע","n",NULL,"keva","קבע","קבע",NULL,"QB&","QB&",NULL);
INSERT INTO hebrew_morpho VALUES (94486,"צְבָא-קֶבַע","n",NULL,"tzva-keva","צבא-קבע","צבא-קבע",NULL,"CBA-QB&","CBA-QB&",NULL);
INSERT INTO hebrew_morpho VALUES (94487,"פֶּרְמָנֶנְט","n",NULL,"permanent","פרמננט","פרמננט",NULL,"PRMNN@","PRMNN@",NULL);
INSERT INTO hebrew_morpho VALUES (94488,"קַרְנִית","n",NULL,"karnit","קרנית","קרנית",NULL,"QRNIT","QRNIT",NULL);
INSERT INTO hebrew_morpho VALUES (94489,"קַרְקֶפֶת","n",NULL,"karkefet","קרקפת","קרקפת",NULL,"QRQPT","QRQPT",NULL);
INSERT INTO hebrew_morpho VALUES (94490,"קַרְסֹל","n",NULL,"karsol","קרסול","קרסל",NULL,"QRSL","QRSWL",NULL);
INSERT INTO hebrew_morpho VALUES (94491,"חֲלוֹם-רָטוּב","n",NULL,"chalom-ratuv","חלום-רטוב","חלום-רטוב",NULL,"XLWM-R@WB","XLWM-R@WB",NULL);
INSERT INTO hebrew_morpho VALUES (94492,"פָנָטִיּוּת","n",NULL,"fanatiyut","פנטיות","פנטיות",NULL,"PN@IWT","PN@IWT",NULL);
INSERT INTO hebrew_morpho VALUES (94493,"קַנָּאוּת","n",NULL,"kana\'ut","קנאות","קנאות",NULL,"QNAWT","QNAWT",NULL);
INSERT INTO hebrew_morpho VALUES (94494,"קַצְרָנוּת","n",NULL,"katzranut","קצרנות","קצרנות",NULL,"QCRNWT","QCRNWT",NULL);
INSERT INTO hebrew_morpho VALUES (94495,"סְטֶנוֹגְרַפְיָה","n",NULL,"stenografya","סטנוגרפיה","סטנוגרפיה",NULL,"S@NWGRPIH","S@NWGRPIH",NULL);
INSERT INTO hebrew_morpho VALUES (94496,"רְפוּאִי","a",NULL,"refu\'i","רפואי","רפואי",NULL,"RPWAI","RPWAI",NULL);
INSERT INTO hebrew_morpho VALUES (94497,"רִתּוּךְ","n",NULL,"ritux","ריתוך","רתוך",NULL,"RTWK","RITWK",NULL);
INSERT INTO hebrew_morpho VALUES (94498,"רֶצַח","n",NULL,"retsax","רצח","רצח",NULL,"RCX","RCX",NULL);
INSERT INTO hebrew_morpho VALUES (94499,"בִּיזוֹן","n",NULL,"bizon","ביזון","ביזון",NULL,"BIZWN","BIZWN",NULL);
INSERT INTO hebrew_morpho VALUES (94500,"רַעֲמָה","n",NULL,"ra\'ama","רעמה","רעמה",NULL,"R&MH","R&MH",NULL);
INSERT INTO hebrew_morpho VALUES (94501,"רִשְׁתִּית","n",NULL,"rishtit","רשתית","רשתית",NULL,"R$TIT","R$TIT",NULL);
INSERT INTO hebrew_morpho VALUES (94502,"רֵאָה","n",NULL,"re\'a","ריאה","ראה",NULL,"RAH","RIAH",NULL);
INSERT INTO hebrew_morpho VALUES (94503,"רְאִי","n",NULL,"re\'i","ראי","ראי",NULL,"RAI","RAI",NULL);
INSERT INTO hebrew_morpho VALUES (94504,"מַרְאָה","n",NULL,"mar\'ah","מראה","מראה",NULL,"MRAH","MRAH",NULL);
INSERT INTO hebrew_morpho VALUES (94505,"רַחֶפֶת","n",NULL,"raxefet","רחפת","רחפת",NULL,"RXPT","RXPT",NULL);
INSERT INTO hebrew_morpho VALUES (94506,"רֶפֶת","n",NULL,"refet","רפת","רפת",NULL,"RPT","RPT",NULL);
INSERT INTO hebrew_morpho VALUES (94507,"רַעַל","n",NULL,"ra\'al","רעל","רעל",NULL,"R&L","R&L",NULL);
INSERT INTO hebrew_morpho VALUES (94508,"רַקֶּפֶת","n",NULL,"rakefet","רקפת","רקפת",NULL,"RQPT","RQPT",NULL);
INSERT INTO hebrew_morpho VALUES (94509,"רְשַׁמְקוֹל","n",NULL,"reshamkol","רשמקול","רשמקול",NULL,"R$MQWL","R$MQWL",NULL);
INSERT INTO hebrew_morpho VALUES (94510,"טֵיְפּ","n",NULL,"teyp","טייפ","טיפ",NULL,"@IP","@IIP",NULL);
INSERT INTO hebrew_morpho VALUES (94511,"פִּסְקָה","n",NULL,"piska","פיסקה","פסקה",NULL,"PSQH","PISQH",NULL);
INSERT INTO hebrew_morpho VALUES (94512,"קִרְקוּר","n",NULL,"kirkur","קירקור","קרקור",NULL,"QRQWR","QIRQWR",NULL);
INSERT INTO hebrew_morpho VALUES (94513,"שְׂבִיעוּת-רָצוֹן","n",NULL,"svi\'ut-ratzon","שביעות-רצון","שביעות-רצון",NULL,"$BI&WT-RCWN","$BI&WT-RCWN",NULL);
INSERT INTO hebrew_morpho VALUES (94514,"קֶמַח","n",NULL,"kemach","קמח","קמח",NULL,"QMX","QMX",NULL);
INSERT INTO hebrew_morpho VALUES (94515,"קַבְּצָנוּת","n",NULL,"kabtzanut","קבצנות","קבצנות",NULL,"QBCNWT","QBCNWT",NULL);
INSERT INTO hebrew_morpho VALUES (94516,"פְּשִׁיטַת-יָד","n",NULL,"pshitat-yad","פשיטת-יד","פשיטת-יד",NULL,"P$I@T-ID","P$I@T-ID",NULL);
INSERT INTO hebrew_morpho VALUES (94517,"קְלִיֶנְטוּרָה","n",NULL,"kliyentura","קליינטורה","קלינטורה",NULL,"QLIN@WRH","QLIIN@WRH",NULL);
INSERT INTO hebrew_morpho VALUES (94518,"קֶלַח","n",NULL,"kelach","קלח","קלח",NULL,"QLX","QLX",NULL);
INSERT INTO hebrew_morpho VALUES (94519,"קַשָּׁת","n",NULL,"kashat","קשת","קשת",NULL,"Q$T","Q$T",NULL);
INSERT INTO hebrew_morpho VALUES (94520,"מַזַּל-קַשָּׁת","n",NULL,"mazal-kashat","מזל-קשת","מזל-קשת",NULL,"MZL-Q$T","MZL-Q$T",NULL);
INSERT INTO hebrew_morpho VALUES (94521,"הַר-קֶרַח","n",NULL,"har-kerach","הר-קרח","הר-קרח",NULL,"HR-QRX","HR-QRX",NULL);
INSERT INTO hebrew_morpho VALUES (94522,"קַרְחוֹן","n",NULL,"karchon","קרחון","קרחון",NULL,"QRXWN","QRXWN",NULL);
INSERT INTO hebrew_morpho VALUES (94523,"קִטֵּעַ","n",NULL,"kite\'a","קיטע","קטע",NULL,"Q@&","QI@&",NULL);
INSERT INTO hebrew_morpho VALUES (94524,"קִיסוֹס","n",NULL,"kisos","קיסוס","קיסוס",NULL,"QISWS","QISWS",NULL);
INSERT INTO hebrew_morpho VALUES (94525,"קְנוֹקֶנֶת","n",NULL,"knokenet","קנוקנת","קנוקנת",NULL,"QNWQNT","QNWQNT",NULL);
INSERT INTO hebrew_morpho VALUES (94526,"דְּמִיעָה","n",NULL,"dmi\'ah","דמיעה","דמיעה",NULL,"DMI&H","DMI&H",NULL);
INSERT INTO hebrew_morpho VALUES (94527,"קַדַּחַת","n",NULL,"kadachat","קדחת","קדחת",NULL,"QDXT","QDXT",NULL);
INSERT INTO hebrew_morpho VALUES (94528,"קַדַּחַת-הַבִּצּוֹת","n",NULL,"kadachat-habitzot","קדחת-הביצות","קדחת-הבצות",NULL,"QDXT-HBCWT","QDXT-HBICWT",NULL);
INSERT INTO hebrew_morpho VALUES (94529,"מָלַרְיָה","n",NULL,"malaryah","מלריה","מלריה",NULL,"MLRIH","MLRIH",NULL);
INSERT INTO hebrew_morpho VALUES (94530,"קַצֶּרֶת","n",NULL,"katzeret","קצרת","קצרת",NULL,"QCRT","QCRT",NULL);
INSERT INTO hebrew_morpho VALUES (94531,"אַסְתְּמָה","n",NULL,"astmah","אסתמה","אסתמה",NULL,"ASTMH","ASTMH",NULL);
INSERT INTO hebrew_morpho VALUES (94532,"גַּנַּחַת","n",NULL,"ganachat","גנחת","גנחת",NULL,"GNXT","GNXT",NULL);
INSERT INTO hebrew_morpho VALUES (94533,"שִׁדָּפוֹן","n",NULL,"shidafon","שידפון","שדפון",NULL,"$DPWN","$IDPWN",NULL);
INSERT INTO hebrew_morpho VALUES (94534,"קַרְטוֹן","n",NULL,"karton","קרטון","קרטון",NULL,"QR@WN","QR@WN",NULL);
INSERT INTO hebrew_morpho VALUES (94535,"תְּחִלָּה","r",NULL,"tchila","תחילה","תחלה",NULL,"TXLH","TXILH",NULL);
INSERT INTO hebrew_morpho VALUES (94536,"בַּתְּחִלָּה","r",NULL,"batchila","בתחילה","בתחלה",NULL,"BTXLH","BTXILH",NULL);
INSERT INTO hebrew_morpho VALUES (94537,"אִישׁ-מִקְצוֹעַ","n",NULL,"ish miktso\'a","איש-מקצוע","איש-מקצוע",NULL,"AI$-MQCW&","AI$-MQCW&","male");
INSERT INTO hebrew_morpho VALUES (94538,"אֵשֶׁת-מִקְצוֹעַ","n",NULL,"eshet miktso\'a","אשת-מקצוע","אשת-מקצוע",NULL,"A$T-MQCW&","A$T-MQCW&","female");
INSERT INTO hebrew_morpho VALUES (94539,"מְחַנֵּךְ","n",NULL,"mexanex","מחנך","מחנך",NULL,"MXNK","MXNK","male");
INSERT INTO hebrew_morpho VALUES (94540,"פֶּדָגוֹג","n",NULL,"pedagog","פדגוג","פדגוג",NULL,"PDGWG","PDGWG","male");
INSERT INTO hebrew_morpho VALUES (94541,"פֶּדָגוֹגִית","n",NULL,"pedagogit","פדגוגית","פדגוגית",NULL,"PDGWGIT","PDGWGIT","female");
INSERT INTO hebrew_morpho VALUES (94542,"מְחַנֶּכֶת","n",NULL,"mexanexet","מחנכת","מחנכת",NULL,"MXNKT","MXNKT","female");
INSERT INTO hebrew_morpho VALUES (94543,"מַרְצָה","n",NULL,"martza","מרצה","מרצה",NULL,"MRCH","MRCH","female");
INSERT INTO hebrew_morpho VALUES (94544,"סַפְרָן","n",NULL,"safran","ספרן","ספרן",NULL,"SPRN","SPRN","neutral");
INSERT INTO hebrew_morpho VALUES (94545,"סַפְרָנִית","n",NULL,"safranit","ספרנית","ספרנית",NULL,"SPRNIT","SPRNIT","female");
INSERT INTO hebrew_morpho VALUES (94546,"מוֹרֶה","n",NULL,"moreh","מורה","מורה",NULL,"MWRH","MWRH","male");
INSERT INTO hebrew_morpho VALUES (94547,"מוֹרָה","n",NULL,"mora","מורה","מורה",NULL,"MWRH","MWRH","female");
INSERT INTO hebrew_morpho VALUES (94548,"חמורת_סבר","n",NULL,NULL,"חמורת_סבר","חמורת_סבר",NULL,"XMWRT_SBR","XMWRT_SBR","female");
INSERT INTO hebrew_morpho VALUES (94549,"אִינְטֶרְנֶט","n",NULL,"internet","אינטרנט","אינטרנט",NULL,"AIN@RN@","AIN@RN@",NULL);
INSERT INTO hebrew_morpho VALUES (94550,"רֶשֶׁת-הָאִינְטֶרְנֶט","n",NULL,"reshet ha\'internet","רשת-האינטרנט","רשת-האינטרנט",NULL,"R$T-HAIN@RN@","R$T-HAIN@RN@",NULL);
INSERT INTO hebrew_morpho VALUES (94551,"מִרְשֶׁתֶת","n",NULL,"mirshetet","מרשתת","מרשתת",NULL,"MR$TT","MR$TT",NULL);
INSERT INTO hebrew_morpho VALUES (94552,"רֶשֶׁת","n",NULL,"reshet","רשת","רשת",NULL,"R$T","R$T",NULL);
INSERT INTO hebrew_morpho VALUES (94553,"רֶשֶׁת-שִׁדּוּר","n",NULL,"reshet shidur","רשת-שדור","רשת-שדור",NULL,"R$T-$DWR","R$T-$DWR",NULL);
INSERT INTO hebrew_morpho VALUES (94554,"רוֹבֶה","n",NULL,"roveh","רובה","רובה",NULL,"RWBH","RWBH",NULL);
INSERT INTO hebrew_morpho VALUES (94555,"רְבִיעִי","a",NULL,"revi\'i","רביעי","רביעי",NULL,"RBI&I","RBI&I",NULL);
INSERT INTO hebrew_morpho VALUES (94556,"רִמּוֹן","n",NULL,"rimmon","רימון","רמון",NULL,"RMWN","RIMWN",NULL);
INSERT INTO hebrew_morpho VALUES (94557,"עֲרִיקָה","n",NULL,"arika","עריקה","עריקה",NULL,"&RIQH","&RIQH","female");
INSERT INTO hebrew_morpho VALUES (94558,"רַבְרְבָנוּת","n",NULL,"ravrevanut","רברבנות","רברבנות",NULL,"RBRBNWT","RBRBNWT",NULL);
INSERT INTO hebrew_morpho VALUES (94559,"רוֹמִית","n",NULL,"romit","רומית","רומית",NULL,"RWMIT","RWMIT",NULL);
INSERT INTO hebrew_morpho VALUES (94560,"לָטִינִית","n",NULL,"latinit","לטינית","לטינית",NULL,"L@INIT","L@INIT",NULL);
INSERT INTO hebrew_morpho VALUES (94561,"רִפּוּד","n",NULL,"rippud","ריפוד","רפוד",NULL,"RPWD","RIPWD",NULL);
INSERT INTO hebrew_morpho VALUES (94562,"קָצַר","v",NULL,"katzar","קצר","קצר",NULL,"QCR","QCR",NULL);
INSERT INTO hebrew_morpho VALUES (94563,"הֶעֱבִיר-אוֹתוֹ-מִיְּרֻשָּׁתוֹ","v",NULL,"he\'evir-oto-miyerushato","העביר-אותו-מירושתו","העביר-אותו-מירשתו",NULL,"H&BIR-AWTW-MIR$TW","H&BIR-AWTW-MIRW$TW",NULL);
INSERT INTO hebrew_morpho VALUES (94564,"הִדִּיר-אוֹתוֹ-מִנְּכָסָיו","v",NULL,NULL,"הדיר-אותו-מנכסיו","הדיר-אותו-מנכסיו",NULL,"HDIR-AWTW-MNKSIW","HDIR-AWTW-MNKSIW",NULL);
INSERT INTO hebrew_morpho VALUES (94565,"קָלַע","v",NULL,"kala","קלע","קלע",NULL,"QL&","QL&",NULL);
INSERT INTO hebrew_morpho VALUES (94566,"מַכָּ&quot;ם","n",NULL,"makam","מכ&quot;ם","מכ&quot;ם",NULL,"MK&quot;M","MK&quot;M",NULL);
INSERT INTO hebrew_morpho VALUES (94567,"מַרְדִּים","n",NULL,"mardim","מרדים","מרדים",NULL,"MRDIM","MRDIM",NULL);
INSERT INTO hebrew_morpho VALUES (94568,"רָגִיל","a",NULL,"ragil","רגיל","רגיל",NULL,"RGIL","RGIL",NULL);
INSERT INTO hebrew_morpho VALUES (94569,"רוֹכְלוּת","n",NULL,"roxlut","רוכלות","רוכלות",NULL,"RWKLWT","RWKLWT",NULL);
INSERT INTO hebrew_morpho VALUES (94570,"רִשְׁמִיּוּת","n",NULL,"rishmiyut","רשמיות","רשמיות",NULL,"R$MIWT","R$MIWT",NULL);
INSERT INTO hebrew_morpho VALUES (94571,"רַקְדָן","n",NULL,"rakdan","רקדן","רקדן",NULL,"RQDN","RQDN","male");
INSERT INTO hebrew_morpho VALUES (94572,"רַקְדָנִית","n",NULL,"rakdanit","רקדנית","רקדנית",NULL,"RQDNIT","RQDNIT","female");
INSERT INTO hebrew_morpho VALUES (94573,"רָזֶה","a",NULL,"razeh","רזה","רזה",NULL,"RZH","RZH",NULL);
INSERT INTO hebrew_morpho VALUES (94574,"כָּחוּשׁ","a",NULL,"kaxush","כחוש","כחוש",NULL,"KXW$","KXW$",NULL);
INSERT INTO hebrew_morpho VALUES (94575,"גָּרוּם","a",NULL,NULL,"גרום","גרום",NULL,"GRWM","GRWM",NULL);
INSERT INTO hebrew_morpho VALUES (94576,"רָחָב","a",NULL,"raxav","רחב","רחב",NULL,"RXB","RXB",NULL);
INSERT INTO hebrew_morpho VALUES (94577,"רִאשׁוֹן","n",NULL,"rishon","ראשון","ראשון",NULL,"RA$WN","RA$WN",NULL);
INSERT INTO hebrew_morpho VALUES (94578,"הִלּוּךְ-רִאשׁוֹן","n",NULL,"hilux rishon","הלוך-ראשון","הלוך-ראשון",NULL,"HLWK-RA$WN","HLWK-RA$WN",NULL);
INSERT INTO hebrew_morpho VALUES (94579,"רֵיחָנִי","a",NULL,"rexani","ריחני","ריחני",NULL,"RIXNI","RIXNI",NULL);
INSERT INTO hebrew_morpho VALUES (94580,"רֶחֶם","n",NULL,"rexem","רחם","רחם",NULL,"RXM","RXM",NULL);
INSERT INTO hebrew_morpho VALUES (94581,"קָצִין","n",NULL,"katzin","קצין","קצין",NULL,"QCIN","QCIN","male");
INSERT INTO hebrew_morpho VALUES (94582,"קְצִינָה","n",NULL,"ktzina","קצינה","קצינה",NULL,"QCINH","QCINH","female");
INSERT INTO hebrew_morpho VALUES (94583,"קַבְּצָן","n",NULL,"kabtzan","קבצן","קבצן",NULL,"QBCN","QBCN","male");
INSERT INTO hebrew_morpho VALUES (94584,"קַבְּצָנִית","n",NULL,"kabtzanit","קבצנית","קבצנית",NULL,"QBCNIT","QBCNIT","female");
INSERT INTO hebrew_morpho VALUES (94585,"רַעַם","n",NULL,"ra\'am","רעם","רעם",NULL,"R&M","R&M",NULL);
INSERT INTO hebrew_morpho VALUES (94586,"רְפוּאָה","n",NULL,"refu\'ah","רפואה","רפואה",NULL,"RPWAH","RPWAH",NULL);
INSERT INTO hebrew_morpho VALUES (94587,"רַעַשׁ","n",NULL,"ra\'ash","רעש","רעש",NULL,"R&$","R&$",NULL);
INSERT INTO hebrew_morpho VALUES (94588,"רַשְׁלָנוּת","n",NULL,"rashlanut","רשלנות","רשלנות",NULL,"R$LNWT","R$LNWT",NULL);
INSERT INTO hebrew_morpho VALUES (94589,"רֶפּוּבְּלִיקָנִי","n",NULL,"republikani","רפובליקני","רפובליקני",NULL,"RPWBLIQNI","RPWBLIQNI","male");
INSERT INTO hebrew_morpho VALUES (94590,"רֶפּוּבְּלִיקָאִי","n",NULL,"republikai","רפובליקאי","רפובליקאי",NULL,"RPWBLIQAI","RPWBLIQAI","male");
INSERT INTO hebrew_morpho VALUES (94591,"רֶפּוּבְּלִיקָנִית","n",NULL,"republikanit","רפובליקנית","רפובליקנית",NULL,"RPWBLIQNIT","RPWBLIQNIT","female");
INSERT INTO hebrew_morpho VALUES (94592,"רֶפּוּבְּלִיקָאִית","n",NULL,"republikait","רפובליקאית","רפובליקאית",NULL,"RPWBLIQAIT","RPWBLIQAIT","female");
INSERT INTO hebrew_morpho VALUES (94593,"רַקְבּוּבִית","n",NULL,"rakbuvit","רקבובית","רקבובית",NULL,"RQBWBIT","RQBWBIT",NULL);
INSERT INTO hebrew_morpho VALUES (94594,"רוֹפֵא","n",NULL,"rofeh","רופא","רופא",NULL,"RWPA","RWPA","male");
INSERT INTO hebrew_morpho VALUES (94595,"דּוֹקְטוֹר","n",NULL,"doktor","דוקטור","דוקטור",NULL,"DWQ@WR","DWQ@WR","female");
INSERT INTO hebrew_morpho VALUES (94596,"רוֹפְאָה","n",NULL,"rof\'ah","רופאה","רופאה",NULL,"RWPAH","RWPAH","female");
INSERT INTO hebrew_morpho VALUES (94597,"דּוֹקְטוֹר","n",NULL,"doktor","דוקטור","דוקטור",NULL,"DWQ@WR","DWQ@WR","male");
INSERT INTO hebrew_morpho VALUES (94598,"מְנַתַּחַת","n",NULL,"menataxat","מנתחת","מנתחת",NULL,"MNTXT","MNTXT","female");
INSERT INTO hebrew_morpho VALUES (94599,"רוֹפְאָה-מְנַתַּחַת","n",NULL,"rof\'ah menataxat","רופאה-מנתחת","רופאה-מנתחת",NULL,"RWPAH-MNTXT","RWPAH-MNTXT","female");
INSERT INTO hebrew_morpho VALUES (94600,"כִירוּרְגִית","n",NULL,"xirurgit","כירורגית","כירורגית",NULL,"KIRWRGIT","KIRWRGIT","female");
INSERT INTO hebrew_morpho VALUES (94601,"רִיצָה","n",NULL,"ritza","ריצה","ריצה",NULL,"RICH","RICH",NULL);
INSERT INTO hebrew_morpho VALUES (94602,"נִפּוּץ","n",NULL,"niputz","ניפוץ","נפוץ",NULL,"NPWC","NIPWC",NULL);
INSERT INTO hebrew_morpho VALUES (94603,"נִתּוּץ","n",NULL,"nitutz","ניתוץ","נתוץ",NULL,"NTWC","NITWC",NULL);
INSERT INTO hebrew_morpho VALUES (94604,"רִיצוּץ","n",NULL,"ritzutz","ריצוץ","ריצוץ",NULL,"RICWC","RICWC",NULL);
INSERT INTO hebrew_morpho VALUES (94605,"רִסּוּק","n",NULL,"risuk","ריסוק","רסוק",NULL,"RSWQ","RISWQ",NULL);
INSERT INTO hebrew_morpho VALUES (94606,"נְשִׂיאוּת","n",NULL,"nesi\'ut","נשיאות","נשיאות",NULL,"N$IAWT","N$IAWT",NULL);
INSERT INTO hebrew_morpho VALUES (94607,"רָאשׁוּת","n",NULL,"rashut","ראשות","ראשות",NULL,"RA$WT","RA$WT",NULL);
INSERT INTO hebrew_morpho VALUES (94608,"רְשׁוּת","n",NULL,"reshut","רשות","רשות",NULL,"R$WT","R$WT",NULL);
INSERT INTO hebrew_morpho VALUES (94609,"הֶתֵּר","n",NULL,"heter","היתר","התר",NULL,"HTR","HITR",NULL);
INSERT INTO hebrew_morpho VALUES (94610,"רָץ","n",NULL,"ratz","רץ","רץ",NULL,"RC","RC",NULL);
INSERT INTO hebrew_morpho VALUES (94611,"רִקְמָה","n",NULL,"rikma","ריקמה","רקמה",NULL,"RQMH","RIQMH",NULL);
INSERT INTO hebrew_morpho VALUES (94612,"רִתְמָה","n",NULL,"ritmah","ריתמה","רתמה",NULL,"RTMH","RITMH",NULL);
INSERT INTO hebrew_morpho VALUES (94613,"רְכוּשָׁנוּת","n",NULL,"rechushanut","רכושנות","רכושנות",NULL,"RKW$NWT","RKW$NWT",NULL);
INSERT INTO hebrew_morpho VALUES (94614,"עִקָּר","n",NULL,"ikkar","עיקר","עקר",NULL,"&QR","&IQR",NULL);
INSERT INTO hebrew_morpho VALUES (94615,"רֹב-מֻחְלָט","n",NULL,"rov muxlat","רוב-מחלט","רב-מחלט",NULL,"RB-MXL@","RWB-MXL@",NULL);
INSERT INTO hebrew_morpho VALUES (94616,"בְּגִירוּת","n",NULL,"bgirut","בגירות","בגירות",NULL,"BGIRWT","BGIRWT",NULL);
INSERT INTO hebrew_morpho VALUES (94617,"כָּפָן","n",NULL,"kafan","כפן","כפן",NULL,"KPN","KPN",NULL);
INSERT INTO hebrew_morpho VALUES (94618,"רִכֵל","v",NULL,"rixel","ריכל","רכל",NULL,"RKL","RIKL",NULL);
INSERT INTO hebrew_morpho VALUES (94619,"רִשָּׁיוֹן","n",NULL,"rishayon","רישיון","רשיון",NULL,"R$IWN","RI$IWN",NULL);
INSERT INTO hebrew_morpho VALUES (94620,"רָצוֹן","n",NULL,"ratzon","רצון","רצון",NULL,"RCWN","RCWN",NULL);
INSERT INTO hebrew_morpho VALUES (94621,"רַבִּים","n",NULL,"rabbim","רבים","רבים",NULL,"RBIM","RBIM",NULL);
INSERT INTO hebrew_morpho VALUES (94622,"רַבּוֹת","n",NULL,"rabbot","רבות","רבות",NULL,"RBWT","RBWT",NULL);
INSERT INTO hebrew_morpho VALUES (94623,"קַלָּע","n",NULL,"kala","קלע","קלע",NULL,"QL&","QL&","male");
INSERT INTO hebrew_morpho VALUES (94624,"קַלָּעִית","n",NULL,"kala\'it","קלעית","קלעית",NULL,"QL&IT","QL&IT","female");
INSERT INTO hebrew_morpho VALUES (94625,"תּוֹבֵעַ","n",NULL,"tove\'a","תובע","תובע",NULL,"TWB&","TWB&","male");
INSERT INTO hebrew_morpho VALUES (94626,"קָטֵגוֹר","n",NULL,"kategor","קטיגור","קטגור",NULL,"Q@GWR","Q@IGWR","male");
INSERT INTO hebrew_morpho VALUES (94627,"תּוֹבַעַת","n",NULL,"tova\'at","תובעת","תובעת",NULL,"TWB&T","TWB&T","female");
INSERT INTO hebrew_morpho VALUES (94628,"קָטֵגוֹרִית","n",NULL,"kategorit","קטיגורית","קטגורית",NULL,"Q@GWRIT","Q@IGWRIT","female");
INSERT INTO hebrew_morpho VALUES (94629,"רְשִׁימָה","n",NULL,"reshima","רשימה","רשימה",NULL,"R$IMH","R$IMH",NULL);
INSERT INTO hebrew_morpho VALUES (94630,"בְּרִיזָה","n",NULL,"briza","בריזה","בריזה",NULL,"BRIZH","BRIZH",NULL);
INSERT INTO hebrew_morpho VALUES (94631,"רוּחַ_קַלָּה","n",NULL,"ru\'ax kala","רוח-קלה","רוח_קלה",NULL,"RWX_QLH","RWX-QLH",NULL);
INSERT INTO hebrew_morpho VALUES (94632,"שׁוֹטֵר","n",NULL,"shoter","שוטר","שוטר",NULL,"$W@R","$W@R","male");
INSERT INTO hebrew_morpho VALUES (94633,"שׁוֹטֶרֶת","n",NULL,"shoteret","שוטרת","שוטרת",NULL,"$W@RT","$W@RT","female");
INSERT INTO hebrew_morpho VALUES (94634,"קַצְרָן","n",NULL,"katzran","קצרן","קצרן",NULL,"QCRN","QCRN","male");
INSERT INTO hebrew_morpho VALUES (94635,"קַצְרָנִית","n",NULL,"katzranit","קצרנית","קצרנית",NULL,"QCRNIT","QCRNIT","female");
INSERT INTO hebrew_morpho VALUES (94636,"קִמְעוֹנַאי","n",NULL,"kim\'onay","קימעונאי","קמעונאי",NULL,"QM&WNAI","QIM&WNAI","male");
INSERT INTO hebrew_morpho VALUES (94637,"קִמְעוֹנָאִית","n",NULL,"kim\'ona\'it","קימעונאית","קמעונאית",NULL,"QM&WNAIT","QIM&WNAIT","female");
INSERT INTO hebrew_morpho VALUES (94638,"צָרְפָתִי","n",NULL,"tzarfati","צרפתי","צרפתי",NULL,"CRPTI","CRPTI","male");
INSERT INTO hebrew_morpho VALUES (94639,"צָרְפָתִיָּה","n",NULL,"tzarfatiya","צרפתיה","צרפתיה",NULL,"CRPTIH","CRPTIH","female");
INSERT INTO hebrew_morpho VALUES (94640,"אֵירוֹפִּית","n",NULL,"eiropit","אירופית","אירופית",NULL,"AIRWPIT","AIRWPIT","female");
INSERT INTO hebrew_morpho VALUES (94641,"אֵירוֹפֶּאִית","n",NULL,"eirope\'it","אירופאית","אירופאית",NULL,"AIRWPAIT","AIRWPAIT","female");
INSERT INTO hebrew_morpho VALUES (94642,"יְוָנִיָּה","n",NULL,"yevaniya","יוונייה","יוניה",NULL,"IWNIH","IWWNIIH","female");
INSERT INTO hebrew_morpho VALUES (94643,"פּוֹלָנִיָּה","n",NULL,"polaniya","פולנייה","פולניה",NULL,"PWLNIH","PWLNIIH","female");
INSERT INTO hebrew_morpho VALUES (94644,"סְפָרַדִּיָּה","n",NULL,"sfaradiyah","ספרדייה","ספרדיה",NULL,"SPRDIH","SPRDIIH","female");
INSERT INTO hebrew_morpho VALUES (94645,"צוֹעֵר","n",NULL,"tzo\'er","צוער","צוער",NULL,"CW&R","CW&R","male");
INSERT INTO hebrew_morpho VALUES (94646,"חָנִיךְ","n",NULL,"chanich","חניך","חניך",NULL,"XNIK","XNIK","male");
INSERT INTO hebrew_morpho VALUES (94647,"שׁוֹחֵר","n",NULL,"shocher","שוחר","שוחר",NULL,"$WXR","$WXR","male");
INSERT INTO hebrew_morpho VALUES (94648,"קָדֶט","n",NULL,"kadet","קדט","קדט",NULL,"QD@","QD@","male");
INSERT INTO hebrew_morpho VALUES (94649,"צוֹעֶרֶת","n",NULL,"tzo\'eret","צוערת","צוערת",NULL,"CW&RT","CW&RT","female");
INSERT INTO hebrew_morpho VALUES (94650,"חֲנִיכָה","n",NULL,"chanicha","חניכה","חניכה",NULL,"XNIKH","XNIKH","female");
INSERT INTO hebrew_morpho VALUES (94651,"שׁוֹחֶרֶת","n",NULL,"shocheret","שוחרת","שוחרת",NULL,"$WXRT","$WXRT","female");
INSERT INTO hebrew_morpho VALUES (94652,"צוֹפֶה","n",NULL,"tzofe","צופה","צופה",NULL,"CWPH","CWPH","male");
INSERT INTO hebrew_morpho VALUES (94653,"צוֹפָה","n",NULL,"tzofa","צופה","צופה",NULL,"CWPH","CWPH","female");
INSERT INTO hebrew_morpho VALUES (94654,"צֶנְזוֹר","n",NULL,"tzenzor","צנזור","צנזור",NULL,"CNZWR","CNZWR","male");
INSERT INTO hebrew_morpho VALUES (94655,"צֶנְזוֹרִית","n",NULL,"tzenzorit","צנזורית","צנזורית",NULL,"CNZWRIT","CNZWRIT","female");
INSERT INTO hebrew_morpho VALUES (94656,"צוֹעֲנִי","n",NULL,"tzo\'ani","צועני","צועני",NULL,"CW&NI","CW&NI","male");
INSERT INTO hebrew_morpho VALUES (94657,"צוֹעֲנִיָּה","n",NULL,"tzo\'aniya","צוענייה","צועניה",NULL,"CW&NIH","CW&NIIH","female");
INSERT INTO hebrew_morpho VALUES (94658,"צַיָּד","n",NULL,"tzayad","צייד","ציד",NULL,"CID","CIID","male");
INSERT INTO hebrew_morpho VALUES (94659,"צַיֶּדֶת","n",NULL,"tzayedet","ציידת","צידת",NULL,"CIDT","CIIDT","female");
INSERT INTO hebrew_morpho VALUES (94660,"גַּשָּׁשִׁית","n",NULL,"gashashit","גששית","גששית",NULL,"G$$IT","G$$IT","female");
INSERT INTO hebrew_morpho VALUES (94661,"שִׂמְלַת-עֶרֶב","n",NULL,"simlat-erev","שמלת-ערב","שמלת-ערב",NULL,"$MLT-&RB","$MLT-&RB",NULL);
INSERT INTO hebrew_morpho VALUES (94662,"שִׁפּוּר","n",NULL,"shipur","שיפור","שפור",NULL,"$PWR","$IPWR",NULL);
INSERT INTO hebrew_morpho VALUES (94663,"שְׁבוּיָה","n",NULL,"shvuyah","שבוייה","שבויה",NULL,"$BWIH","$BWIIH","female");
INSERT INTO hebrew_morpho VALUES (94664,"שִׂיאָנִית","n",NULL,"si\'anit","שיאנית","שיאנית",NULL,"$IANIT","$IANIT","female");
INSERT INTO hebrew_morpho VALUES (94665,"שַׁלִּיטָה","n",NULL,"shalita","שליטה","שליטה",NULL,"$LI@H","$LI@H","female");
INSERT INTO hebrew_morpho VALUES (94666,"שְׁנַת-נֶצַח","n",NULL,"shnat-netzach","שנת-נצח","שנת-נצח",NULL,"$NT-NCX","$NT-NCX",NULL);
INSERT INTO hebrew_morpho VALUES (94667,"תַּרְדֵּמַת-נֶצַח","n",NULL,"tardemat-netzach","תרדמת-נצח","תרדמת-נצח",NULL,"TRDMT-NCX","TRDMT-NCX",NULL);
INSERT INTO hebrew_morpho VALUES (94668,"שְׁנַת-עוֹלָם","n",NULL,"shnat-olam","שנת-עולם","שנת-עולם",NULL,"$NT-&WLM","$NT-&WLM",NULL);
INSERT INTO hebrew_morpho VALUES (94669,"שְׁנַת-הַלִּמּוּדִים","n",NULL,"shnat-halimudim","שנת-הלמודים","שנת-הלמודים",NULL,"$NT-HLMWDIM","$NT-HLMWDIM",NULL);
INSERT INTO hebrew_morpho VALUES (94670,"שׁוֹפֵעַ","a",NULL,"shofe\'a","שופע","שופע",NULL,"$WP&","$WP&",NULL);
INSERT INTO hebrew_morpho VALUES (94671,"תַּיִשׁ","n",NULL,"tayish","תיש","תיש",NULL,"TI$","TI$","male");
INSERT INTO hebrew_morpho VALUES (94672,"שָׂעִיר","n",NULL,"sa\'ir","שעיר","שעיר",NULL,"$&IR","$&IR","male");
INSERT INTO hebrew_morpho VALUES (94673,"צָפִיר","n",NULL,"tzafir","צפיר","צפיר",NULL,"CPIR","CPIR","male");
INSERT INTO hebrew_morpho VALUES (94674,"שְׂעִיר-עִזִּים","n",NULL,"s\'ir-izim","שעיר-עזים","שעיר-עזים",NULL,"$&IR-&ZIM","$&IR-&ZIM","male");
INSERT INTO hebrew_morpho VALUES (94675,"שָׂעִיר","a",NULL,"sa\'ir","שעיר","שעיר",NULL,"$&IR","$&IR",NULL);
INSERT INTO hebrew_morpho VALUES (94676,"שָׁזוּף","a",NULL,"shazuf","שזוף","שזוף",NULL,"$ZWP","$ZWP",NULL);
INSERT INTO hebrew_morpho VALUES (94677,"קוֹלֶקְטִיבִי","a",NULL,"kolektivi","קולקטיבי","קולקטיבי",NULL,"QWLQ@IBI","QWLQ@IBI",NULL);
INSERT INTO hebrew_morpho VALUES (94678,"שִׁתּוּפִי","a",NULL,"shitufi","שיתופי","שתופי",NULL,"$TWPI","$ITWPI",NULL);
INSERT INTO hebrew_morpho VALUES (94679,"שְׁחַרְחַר","a",NULL,"shcharchar","שחרחר","שחרחר",NULL,"$XRXR","$XRXR",NULL);
INSERT INTO hebrew_morpho VALUES (94680,"שָׁכֵן","n",NULL,"shachen","שכן","שכן",NULL,"$KN","$KN","male");
INSERT INTO hebrew_morpho VALUES (94681,"שְׁכֵנָה","n",NULL,"shchena","שכנה","שכנה",NULL,"$KNH","$KNH","female");
INSERT INTO hebrew_morpho VALUES (94682,"שָׁכֵן","a",NULL,"shachen","שכן","שכן",NULL,"$KN","$KN",NULL);
INSERT INTO hebrew_morpho VALUES (94683,"שָׁבִיר","a",NULL,"shavir","שביר","שביר",NULL,"$BIR","$BIR",NULL);
INSERT INTO hebrew_morpho VALUES (94684,"עָדִין","a",NULL,"adin","עדין","עדין",NULL,"&DIN","&DIN",NULL);
INSERT INTO hebrew_morpho VALUES (94685,"שַׁבְרִירִי","a",NULL,"shavriri","שברירי","שברירי",NULL,"$BRIRI","$BRIRI",NULL);
INSERT INTO hebrew_morpho VALUES (94686,"שִׁוְיוֹנִי","a",NULL,"shivyoni","שוויוני","שויוני",NULL,"$WIWNI","$WWIWNI",NULL);
INSERT INTO hebrew_morpho VALUES (94687,"שְׁרִירוּתִי","a",NULL,"shriruti","שרירותי","שרירותי",NULL,"$RIRWTI","$RIRWTI",NULL);
INSERT INTO hebrew_morpho VALUES (94688,"שָׁוֶה","a",NULL,"shave","שווה","שוה",NULL,"$WH","$WWH",NULL);
INSERT INTO hebrew_morpho VALUES (94689,"שֶׁעָבַר","a",NULL,"she\'avar","שעבר","שעבר",NULL,"$&BR","$&BR",NULL);
INSERT INTO hebrew_morpho VALUES (94690,"שָׂנוּא","a",NULL,"sanu","שנוא","שנוא",NULL,"$NWA","$NWA",NULL);
INSERT INTO hebrew_morpho VALUES (94691,"שׁוּם","n",NULL,"shum","שום","שום",NULL,"$WM","$WM",NULL);
INSERT INTO hebrew_morpho VALUES (94692,"שׁוּם","a",NULL,"shum","שום","שום",NULL,"$WM","$WM",NULL);
INSERT INTO hebrew_morpho VALUES (94693,"שִׁיטָתִי","a",NULL,"shitati","שיטתי","שיטתי",NULL,"$I@TI","$I@TI",NULL);
INSERT INTO hebrew_morpho VALUES (94694,"מֶתוֹדִי","a",NULL,"metodi","מתודי","מתודי",NULL,"MTWDI","MTWDI",NULL);
INSERT INTO hebrew_morpho VALUES (94695,"שִׁגְרָתִי","a",NULL,"shigrati","שיגרתי","שגרתי",NULL,"$GRTI","$IGRTI",NULL);
INSERT INTO hebrew_morpho VALUES (94696,"רוּטִינִי","a",NULL,"rutini","רוטיני","רוטיני",NULL,"RW@INI","RW@INI",NULL);
INSERT INTO hebrew_morpho VALUES (94697,"יָדוּעַ-לְשִׁמְצָה","a",NULL,"yadu\'a-leshimtza","ידוע-לשמצה","ידוע-לשמצה",NULL,"IDW&-L$MCH","IDW&-L$MCH",NULL);
INSERT INTO hebrew_morpho VALUES (94698,"שְׂמֹאלָנִי","a",NULL,"smolani","שמאלני","שמאלני",NULL,"$MALNI","$MALNI",NULL);
INSERT INTO hebrew_morpho VALUES (94699,"שִׁשִּׁי","a",NULL,"shishi","שישי","ששי",NULL,"$$I","$I$I",NULL);
INSERT INTO hebrew_morpho VALUES (94700,"שְׁבִיעִי","a",NULL,"shvi\'i","שביעי","שביעי",NULL,"$BI&I","$BI&I",NULL);
INSERT INTO hebrew_morpho VALUES (94701,"שְׁמִינִי","a",NULL,"shmini","שמיני","שמיני",NULL,"$MINI","$MINI",NULL);
INSERT INTO hebrew_morpho VALUES (94702,"שָׁחוּק","a",NULL,"shachuk","שחוק","שחוק",NULL,"$XWQ","$XWQ",NULL);
INSERT INTO hebrew_morpho VALUES (94703,"מֻתָּשׁ","a",NULL,"mutash","מותש","מתש",NULL,"MT$","MWT$",NULL);
INSERT INTO hebrew_morpho VALUES (94704,"רָצוּץ","a",NULL,"ratzutz","רצוץ","רצוץ",NULL,"RCWC","RCWC",NULL);
INSERT INTO hebrew_morpho VALUES (94705,"הָרוּס","a",NULL,"harus","הרוס","הרוס",NULL,"HRWS","HRWS",NULL);
INSERT INTO hebrew_morpho VALUES (94706,"הָרוּג","a",NULL,"harug","הרוג","הרוג",NULL,"HRWG","HRWG",NULL);
INSERT INTO hebrew_morpho VALUES (94707,"קָרוּעַ","a",NULL,"karu\'a","קרוע","קרוע",NULL,"QRW&","QRW&",NULL);
INSERT INTO hebrew_morpho VALUES (94708,"שָׁפוּךְ","a",NULL,"shafuch","שפוך","שפוך",NULL,"$PWK","$PWK",NULL);
INSERT INTO hebrew_morpho VALUES (94709,"סָחוּט","a",NULL,"sachut","סחוט","סחוט",NULL,"SXW@","SXW@",NULL);
INSERT INTO hebrew_morpho VALUES (94710,"גָּמוּר","a",NULL,"gamur","גמור","גמור",NULL,"GMWR","GMWR",NULL);
INSERT INTO hebrew_morpho VALUES (94711,"שְׁנָתִי","a",NULL,"shnati","שנתי","שנתי",NULL,"$NTI","$NTI",NULL);
INSERT INTO hebrew_morpho VALUES (94712,"שְׁבוּעִי","a",NULL,"shvu\'i","שבועי","שבועי",NULL,"$BW&I","$BW&I",NULL);
INSERT INTO hebrew_morpho VALUES (94713,"שִׁחְרוּר","n",NULL,"shichrur","שחרור","שחרור",NULL,"$XRWR","$XRWR",NULL);
INSERT INTO hebrew_morpho VALUES (94714,"שַׁעַר","n",NULL,"sha\'ar","שער","שער",NULL,"$&R","$&R",NULL);
INSERT INTO hebrew_morpho VALUES (94715,"גּוֹל","n",NULL,"gol","גול","גול",NULL,"GWL","GWL",NULL);
INSERT INTO hebrew_morpho VALUES (94716,"סַל","n",NULL,"sal","סל","סל",NULL,"SL","SL",NULL);
INSERT INTO hebrew_morpho VALUES (94717,"בְּרוֹמִית-הַשִּׁיפוֹן","n",NULL,NULL,"ברומית-השיפון","ברומית-השיפון",NULL,"BRWMIT-H$IPWN","BRWMIT-H$IPWN",NULL);
INSERT INTO hebrew_morpho VALUES (94718,"מִשְׂחַק-הַמְּלָכִים","n",NULL,NULL,"משחק-המלכים","משחק-המלכים",NULL,"M$XQ-HMLKIM","M$XQ-HMLKIM",NULL);
INSERT INTO hebrew_morpho VALUES (94719,"שַׁחְמָט","n",NULL,"shachmat","שחמט","שחמט",NULL,"$XM@","$XM@",NULL);
INSERT INTO hebrew_morpho VALUES (94720,"אִשְׁקוּקָה","n",NULL,"ishkuka","אשקוקה","אשקוקה",NULL,"A$QWQH","A$QWQH",NULL);
INSERT INTO hebrew_morpho VALUES (94721,"שַׁח-מָט","n",NULL,"shach-mat","שח-מט","שח-מט",NULL,"$X-M@","$X-M@",NULL);
INSERT INTO hebrew_morpho VALUES (94722,"שַׁח","n",NULL,"shach","שח","שח",NULL,"$X","$X",NULL);
INSERT INTO hebrew_morpho VALUES (94723,"פִּיּוּט","n",NULL,"piyut","פיוט","פיוט",NULL,"PIW@","PIW@",NULL);
INSERT INTO hebrew_morpho VALUES (94724,"שִׁירָה","n",NULL,"shira","שירה","שירה",NULL,"$IRH","$IRH",NULL);
INSERT INTO hebrew_morpho VALUES (94725,"זִמְרָה","n",NULL,"zimrah","זמרה","זמרה",NULL,"ZMRH","ZMRH",NULL);
INSERT INTO hebrew_morpho VALUES (94726,"שִׁקּוּר","n",NULL,"shikur","שיקור","שקור",NULL,"$QWR","$IQWR",NULL);
INSERT INTO hebrew_morpho VALUES (94727,"בִּלּוּף","n",NULL,"biluf","בילוף","בלוף",NULL,"BLWP","BILWP",NULL);
INSERT INTO hebrew_morpho VALUES (94728,"שֹׁד","n",NULL,"shod","שוד","שד",NULL,"$D","$WD",NULL);
INSERT INTO hebrew_morpho VALUES (94729,"שְׁדִידָה","n",NULL,"shdidah","שדידה","שדידה",NULL,"$DIDH","$DIDH",NULL);
INSERT INTO hebrew_morpho VALUES (94730,"שִׁמּוּר","n",NULL,"shimur","שימור","שמור",NULL,"$MWR","$IMWR",NULL);
INSERT INTO hebrew_morpho VALUES (94731,"חֹק-שִׁמּוּר","n",NULL,"chok-shimur","חוק-שימור","חק-שמור",NULL,"XQ-$MWR","XWQ-$IMWR",NULL);
INSERT INTO hebrew_morpho VALUES (94732,"שִׁמּוּשׁ","n",NULL,"shimush","שימוש","שמוש",NULL,"$MW$","$IMW$",NULL);
INSERT INTO hebrew_morpho VALUES (94733,"שִׁכְפּוּל","n",NULL,"shichpul","שיכפול","שכפול",NULL,"$KPWL","$IKPWL",NULL);
INSERT INTO hebrew_morpho VALUES (94734,"שׁוּק","n",NULL,"shuk","שוק","שוק",NULL,"$WQ","$WQ",NULL);
INSERT INTO hebrew_morpho VALUES (94735,"הִשְׁתַּתְּפוּת","n",NULL,"hishtatfut","השתתפות","השתתפות",NULL,"H$TTPWT","H$TTPWT",NULL);
INSERT INTO hebrew_morpho VALUES (94736,"שְׂלָו","n",NULL,"slav","שליו","שלו",NULL,"$LW","$LIW",NULL);
INSERT INTO hebrew_morpho VALUES (94737,"שַׁלְדָּג","n",NULL,"shaldag","שלדג","שלדג",NULL,"$LDG","$LDG",NULL);
INSERT INTO hebrew_morpho VALUES (94738,"שַׁחַף","n",NULL,"shachaf","שחף","שחף",NULL,"$XP","$XP",NULL);
INSERT INTO hebrew_morpho VALUES (94739,"שׁוּעָל","n",NULL,"shu\'al","שועל","שועל",NULL,"$W&L","$W&L",NULL);
INSERT INTO hebrew_morpho VALUES (94740,"שַׁפִּירִית","n",NULL,"shapirit","שפירית","שפירית",NULL,"$PIRIT","$PIRIT",NULL);
INSERT INTO hebrew_morpho VALUES (94741,"שַׁרְבִיט","n",NULL,"sharvit","שרביט","שרביט",NULL,"$RBI@","$RBI@",NULL);
INSERT INTO hebrew_morpho VALUES (94742,"שׁוֹבָךְ","n",NULL,"shovach","שובך","שובך",NULL,"$WBK","$WBK",NULL);
INSERT INTO hebrew_morpho VALUES (94743,"שָׁעוֹן","n",NULL,"sha\'on","שעון","שעון",NULL,"$&WN","$&WN",NULL);
INSERT INTO hebrew_morpho VALUES (94744,"קוֹקָאִין","n",NULL,"koka\'in","קוקאין","קוקאין",NULL,"QWQAIN","QWQAIN",NULL);
INSERT INTO hebrew_morpho VALUES (94745,"קוֹק","n",NULL,"kok","קוק","קוק",NULL,"QWQ","QWQ",NULL);
INSERT INTO hebrew_morpho VALUES (94746,"שֶׁלֶג","n",NULL,"sheleg","שלג","שלג",NULL,"$LG","$LG",NULL);
INSERT INTO hebrew_morpho VALUES (94747,"שַׁגְרִירוּת","n",NULL,"shagrirut","שגרירות","שגרירות",NULL,"$GRIRWT","$GRIRWT",NULL);
INSERT INTO hebrew_morpho VALUES (94748,"מִקְטָע","n",NULL,"mikta","מקטע","מקטע",NULL,"MQ@&","MQ@&",NULL);
INSERT INTO hebrew_morpho VALUES (94749,"הֶעְתֵּק","n",NULL,"he\'etek","העתק","העתק",NULL,"H&TQ","H&TQ",NULL);
INSERT INTO hebrew_morpho VALUES (94750,"שְׂפָתוֹן","n",NULL,"sfaton","שפתון","שפתון",NULL,"$PTWN","$PTWN",NULL);
INSERT INTO hebrew_morpho VALUES (94751,"לִיפְּסְטִיק","n",NULL,"lipstik","ליפסטיק","ליפסטיק",NULL,"LIPS@IQ","LIPS@IQ",NULL);
INSERT INTO hebrew_morpho VALUES (94752,"שַׁעַר-הַחֲלִיפִין","n",NULL,NULL,"שער-החליפין","שער-החליפין",NULL,"$&R-HXLIPIN","$&R-HXLIPIN",NULL);
INSERT INTO hebrew_morpho VALUES (94753,"שַׁעַר-לוֹגִי","n",NULL,"sha\'ar-logi","שער-לוגי","שער-לוגי",NULL,"$&R-LWGI","$&R-LWGI",NULL);
INSERT INTO hebrew_morpho VALUES (94754,"רְפָפָה","n",NULL,"refafah","רפפה","רפפה",NULL,"RPPH","RPPH",NULL);
INSERT INTO hebrew_morpho VALUES (94755,"שָׁלָב","n",NULL,"shalav","שלב","שלב",NULL,"$LB","$LB",NULL);
INSERT INTO hebrew_morpho VALUES (94756,"פָזָה","n",NULL,"fazah","פזה","פזה",NULL,"PZH","PZH",NULL);
INSERT INTO hebrew_morpho VALUES (94757,"שִׁמְשִׁיָּה","n",NULL,"shimshiyah","שמשייה","שמשיה",NULL,"$M$IH","$M$IIH",NULL);
INSERT INTO hebrew_morpho VALUES (94758,"שַׁלָּט","n",NULL,"shalat","שלט","שלט",NULL,"$L@","$L@",NULL);
INSERT INTO hebrew_morpho VALUES (94759,"שַׁלַּט-רַחַק","n",NULL,"shalat-rachak","שלט-רחק","שלט-רחק",NULL,"$L@-RXQ","$L@-RXQ",NULL);
INSERT INTO hebrew_morpho VALUES (94760,"שָׁטִיחַ","n",NULL,"shati\'ach","שטיח","שטיח",NULL,"$@IX","$@IX",NULL);
INSERT INTO hebrew_morpho VALUES (94761,"מַרְבָד","n",NULL,"marvad","מרבד","מרבד",NULL,"MRBD","MRBD",NULL);
INSERT INTO hebrew_morpho VALUES (94762,"שָׁל","n",NULL,"shal","של","של",NULL,"$L","$L",NULL);
INSERT INTO hebrew_morpho VALUES (94763,"שְׂרוֹךְ-נַעַל","n",NULL,"sroch-na\'al","שרוך-נעל","שרוך-נעל",NULL,"$RWK-N&L","$RWK-N&L",NULL);
INSERT INTO hebrew_morpho VALUES (94764,"שַׁפּוּד","n",NULL,"shapud","שפוד","שפוד",NULL,"$PWD","$PWD",NULL);
INSERT INTO hebrew_morpho VALUES (94765,"שִׁפּוּד","n",NULL,"shipud","שיפוד","שפוד",NULL,"$PWD","$IPWD",NULL);
INSERT INTO hebrew_morpho VALUES (94766,"סִיח\'","n",NULL,NULL,"סיח\'","סיח\'",NULL,"SIX\'","SIX\'",NULL);
INSERT INTO hebrew_morpho VALUES (94767,"שַׁרְווּל","n",NULL,"sharvul","שרוול","שרוול",NULL,"$RWWL","$RWWL",NULL);
INSERT INTO hebrew_morpho VALUES (94768,"שַׁנַּאי","n",NULL,"shanay","שנאי","שנאי",NULL,"$NAI","$NAI",NULL);
INSERT INTO hebrew_morpho VALUES (94769,"טְרַנְסְפוֹרְמָטוֹר","n",NULL,"transformator","טרנספורמטור","טרנספורמטור",NULL,"@RNSPWRM@WR","@RNSPWRM@WR",NULL);
INSERT INTO hebrew_morpho VALUES (94770,"שְׁתִי","n",NULL,"shti","שתי","שתי",NULL,"$TI","$TI",NULL);
INSERT INTO hebrew_morpho VALUES (94771,"מָגֵן-רוּחַ","n",NULL,"magen-ru\'ach","מגן-רוח","מָגֵן-רוּחַ",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94772,"שָׂרִיד","n",NULL,"sarid","שריד","שָׂרִיד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94773,"שַׁתְקָנוּת","n",NULL,"shatkanut","שתקנות","שַׁתְקָנוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94774,"שְׁכֵנוּת-טוֹבָה","n",NULL,"shchenut-tova","שכנות-טובה","שְׁכֵנוּת-טוֹבָה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94775,"שִׁיטָתִיּוּת","n",NULL,"shitatiyut","שיטתיות","שִׁיטָתִיּוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94776,"שִׁפְלוּת","n",NULL,"shiflut","שיפלות","שִׁפְלוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94777,"נַוְלוּת","n",NULL,NULL,"נַוְלוּת","נַוְלוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94778,"נִבְזוּת","n",NULL,"nivzut","נבזות","נִבְזוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94779,"נִבְזִיּוּת","n",NULL,"nivziyut","נבזיות","נִבְזִיּוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94780,"שְׁאַפְתָּנוּת","n",NULL,"sh\'aftanut","שאפתנות","שְׁאַפְתָּנוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94781,"הֶשֵּׂגִיּוּת","n",NULL,"hesegiyut","הישגיות","הֶשֵּׂגִיּוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94782,"אַמְבִּיצְיָה","n",NULL,"ambitzyah","אמביציה","אַמְבִּיצְיָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94783,"פְּרִיכוּת","n",NULL,"prichut","פריכות","פְּרִיכוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94784,"שֻׁמָּן","n",NULL,"shuman","שומן","שֻׁמָּן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94785,"רִקְמַת-שֻׁמָּן","n",NULL,"rikmat-shuman","ריקמת-שומן","רִקְמַת-שֻׁמָּן",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94786,"שֹׁמֶן","n",NULL,"shomen","שומן","שֹׁמֶן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94787,"מִשְׁמַנִּים","n",NULL,"mishmanim","משמנים","מִשְׁמַנִּים",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94788,"שְׁרִיר","n",NULL,"shrir","שריר","שְׁרִיר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94789,"שִׁפּוּעַ","n",NULL,"shipu\'a","שיפוע","שִׁפּוּעַ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94790,"שָׂפָם","n",NULL,"safam","שפם","שָׂפָם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94791,"שָׁד","n",NULL,"shad","שד","שָׁד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94792,"צִיצִי","n",NULL,"tzitzi","ציצי","צִיצִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94793,"דַּד","n",NULL,"dad","דד","דַּד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94794,"בֵּית-הֶחָזֶה","n",NULL,"beit-hachaze","בית-החזה","בֵּית-הֶחָזֶה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94795,"שִׁיּוּךְ","n",NULL,"shiyuch","שיוך","שִׁיּוּךְ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94796,"יִחוּס","n",NULL,"yichus","יחוס","יִחוּס",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94797,"שִׁעְרוּךְ","n",NULL,"shi\'aruch","שיערוך","שִׁעְרוּךְ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94798,"שֶׁטַח","n",NULL,"shetach","שטח","שֶׁטַח",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94799,"מַשָּׂא-וּמַתָּן","n",NULL,"masa-u\'matan","מַשָּׂא-וּמַתָּן","מַשָּׂא-וּמַתָּן"," משא-ומתן ","-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94800,"שֵׁם","n",NULL,"shem","שם","שֵׁם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94801,"שַׁמְרָנוּת","n",NULL,"shamranut","שמרנות","שַׁמְרָנוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94802,"קוֹנְסֶרְבָטִיבִיּוּת","n",NULL,"konservativiyut","קונסרבטיביות","קוֹנְסֶרְבָטִיבִיּוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94803,"שִׁיר","n",NULL,"shir","שיר","שִׁיר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94804,"שָׁלִיחַ","n",NULL,"shali\'ach","שליח","שָׁלִיחַ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94805,"סֵפֶר-שָׁנָה","n",NULL,"sefer-shanah","ספר-שנה","סֵפֶר-שָׁנָה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94806,"שִׁכְתּוּב","n",NULL,"shichtuv","שכתוב","שִׁכְתּוּב",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94807,"שֶׂכֶר","n",NULL,"secher","שכר","שֶׂכֶר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94808,"צַ\'רְטֶר","n",NULL,"charter","צַ\'רְטֶר","צַ\'רְטֶר"," צ\'רטר ","\'","\'",NULL);
INSERT INTO hebrew_morpho VALUES (94809,"שְׁאֵלוֹן","n",NULL,"she\'elon","שאלון","שְׁאֵלוֹן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94810,"שִׁדּוּר","n",NULL,"shidur","שידור","שִׁדּוּר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94811,"תָּכְנִית","n",NULL,"tochnit","תוכנית","תָּכְנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94812,"מִשְׁדָּר","n",NULL,"mishdar","מישדר","מִשְׁדָּר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94813,"לְהִתְרָאוֹת","n",NULL,"le\'hitra\'ot","להתראות","לְהִתְרָאוֹת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94814,"בַּי","n",NULL,"bay","בי","בַּי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94815,"להת\'","n",NULL,"le\'hit","להת\'","להת\'",NULL,"\'","\'",NULL);
INSERT INTO hebrew_morpho VALUES (94816,"בַּי_בַּי","n",NULL,"bay bay","בי_בי","בַּי_בַּי",NULL,"_","_",NULL);
INSERT INTO hebrew_morpho VALUES (94817,"צָ\'אוּ","n",NULL,"chau","צ\'או","צָ\'אוּ",NULL,"\'","\'",NULL);
INSERT INTO hebrew_morpho VALUES (94818,"שֶׁבַח","n",NULL,"shevach","שבח","שֶׁבַח",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94819,"תִּשְׁבָּחָה","n",NULL,"tishbacha","תשבחה","תִּשְׁבָּחָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94820,"סֶפְּטִימָה","n",NULL,"septima","ספטימה","סֶפְּטִימָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94821,"שַׁעֲרוּרִיָּה","n",NULL,"sha\'aruriyah","שערורייה","שַׁעֲרוּרִיָּה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94822,"סְקַנְדָּל","n",NULL,"skandal","סקנדל","סְקַנְדָּל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94823,"שִׁקְשׁוּק","n",NULL,"shikshuk","שקשוק","שִׁקְשׁוּק",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94824,"שְׁאָגָה","n",NULL,"she\'agah","שאגה","שְׁאָגָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94825,"חֲלוֹם","n",NULL,"chalom","חלום","חֲלוֹם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94826,"שְׁאִיפָה","n",NULL,"she\'ifah","שאיפה","שְׁאִיפָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94827,"אַסְפִּירַצְיָה","n",NULL,"aspiratzyah","אספירצייה","אַסְפִּירַצְיָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94828,"תִּעוּב","n",NULL,"ti\'uv","תיעוב","תִּעוּב",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94829,"שַׁיָּכוּת","n",NULL,"shayachut","שייכות","שַׁיָּכוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94830,"רֶלֶוַנְטִיּוּת","n",NULL,"relevantiyut","רלוונטיות","רֶלֶוַנְטִיּוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94831,"שִׁעְמוּם","n",NULL,"shi\'emum","שיעמום","שִׁעְמוּם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94832,"שִעֲמוּם","n",NULL,"shi\'amum","שיעמום","שִעֲמוּם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94833,"שִׂנְאָה","n",NULL,"sin\'ah","שנאה","שִׂנְאָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94834,"מַשְׂטֵמָה","n",NULL,"mastemah","משטמה","מַשְׂטֵמָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94835,"אֵיבָה","n",NULL,"eivah","איבה","אֵיבָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94836,"שְׁזִיף","n",NULL,"shezif","שזיף","שְׁזִיף",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94837,"שֶׁסֶק","n",NULL,"shesek","שסק","שֶׁסֶק",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94838,"שְׁכוּנָה","n",NULL,"shchunah","שכונה","שְׁכוּנָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94839,"סְבִיבוֹת","n",NULL,"svivot","סביבות","סְבִיבוֹת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94840,"נְסֹרֶת","n",NULL,"nesoret","נסורת","נְסֹרֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94841,"שְׁבָב","n",NULL,"shvav","שבב","שְׁבָב",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94842,"שְׁפֵלָה","n",NULL,"shfelah","שפלה","שְׁפֵלָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94843,"שִׂרְטוֹן","n",NULL,"sirton","שירטון","שִׂרְטוֹן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94844,"שׁוּנִית","n",NULL,"shunit","שונית","שׁוּנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94845,"רִיף","n",NULL,"rif","ריף","רִיף",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94846,"שָׁבִיט","n",NULL,"shavit","שביט","שָׁבִיט",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94847,"כּוֹכַב-שָׁבִיט","n",NULL,"kochav-shavit","כוכב-שביט","כּוֹכַב-שָׁבִיט",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94848,"שֶׁפֶךְ","n",NULL,"shefech","שפך","שֶׁפֶךְ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94849,"שָׂרָף","n",NULL,"saraf","שרף","שָׂרָף",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94850,"שָׂטָן","n",NULL,"satan","שטן","שָׂטָן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94851,"שׁוֹבֶה","n",NULL,"shoveh","שובה","שׁוֹבֶה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94852,"שַׂחְקָן","n",NULL,"sachkan","שחקן","שַׂחְקָן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94853,"נַגָּן","n",NULL,"nagan","נגן","נַגָּן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94854,"מְנַגֵּן","n",NULL,"menagen","מנגן","מְנַגֵּן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94855,"שַׂחְקָנִית","n",NULL,"sachkanit","שחקנית","שַׂחְקָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94856,"שְׁמַרְטַף","n",NULL,"shmartaf","שמרטף","שְׁמַרְטַף",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94857,"שׁוֹמֵר-טַף","n",NULL,"shomer-taf","שומר-טף","שׁוֹמֵר-טַף",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94858,"בֵּיְבִּיסִיטֶר","n",NULL,"beybisiter","בייביסיטר","בֵּיְבִּיסִיטֶר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94859,"בֵּיְבִּי-סִיטֶר","n",NULL,"beybi-siter","בייבי-סיטר","בֵּיְבִּי-סִיטֶר",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94860,"שְׁמַרְטַפִּית","n",NULL,"shmartapit","שמרטפית","שְׁמַרְטַפִּית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94861,"שׁוֹשְׁבִינָה","n",NULL,"shoshvinah","שושבינה","שׁוֹשְׁבִינָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94862,"בֶּן-זוּג","n",NULL,"ben-zug","בן-זוג","בֶּן-זוּג",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94863,"בַּת-זוּג","n",NULL,"bat-zug","בת-זוג","בַּת-זוּג",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94864,"שֻׁתָּף","n",NULL,"shutaf","שותף","שֻׁתָּף",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94865,"שֻׁתְּפָה","n",NULL,"shutafah","שותפה","שֻׁתְּפָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94866,"שַׁמְרָן","n",NULL,"shamran","שמרן","שַׁמְרָן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94867,"שַׁמְרָנִית","n",NULL,"shamranit","שמרנית","שַׁמְרָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94868,"שׁוֹפֵט","n",NULL,"shofet","שופט","שׁוֹפֵט",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94869,"שׁוֹפֶטֶת","n",NULL,"shofetet","שופטת","שׁוֹפֶטֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94870,"אֶקְסְהִיבִּיצְיוֹנִיסְט","n",NULL,"exhibitzyonist","אקסהיביציוניסט","אֶקְסְהִיבִּיצְיוֹנִיסְט",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94871,"רַאַוְתָן","n",NULL,"ra\'avtan","ראוותן","רַאַוְתָן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94872,"אֶקְסְהִיבִּיצְיוֹנִיסְטִית","n",NULL,"exhibitzyonistit","אקסהיביציוניסטית","אֶקְסְהִיבִּיצְיוֹנִיסְטִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94873,"רַאַוְתָנִית","n",NULL,"ra\'avtanit","ראוותנית","רַאַוְתָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94874,"שׁוֹמֵעַ","n",NULL,"shome\'a","שומע","שׁוֹמֵעַ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94875,"מַאֲזִין","n",NULL,"ma\'azin","מאזין","מַאֲזִין",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94876,"שׁוֹמַעַת","n",NULL,"shoma\'at","שומעת","שׁוֹמַעַת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94877,"מַאֲזִינָה","n",NULL,"ma\'azinah","מאזינה","מַאֲזִינָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94878,"שׁוֹאֶלֶת","n",NULL,"sho\'elet","שואלת","שׁוֹאֶלֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94879,"שְׁאֵר","n",NULL,"sh\'er","שאר","שְׁאֵר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94880,"קָרוֹב","n",NULL,"karov","קרוב","קָרוֹב",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94881,"קְרוֹב-מִשְׁפָּחָה","n",NULL,"krov-mishpacha","קרוב-משפחה","קְרוֹב-מִשְׁפָּחָה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94882,"שְׁאֵרָה","n",NULL,"she\'erah","שארה","שְׁאֵרָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94883,"קְרוֹבָה","n",NULL,"krovah","קרובה","קְרוֹבָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94884,"קְרוֹבַת-מִשְׁפָּחָה","n",NULL,"krovat-mishpacha","קרובת-משפחה","קְרוֹבַת-מִשְׁפָּחָה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94885,"חוֹכֵר","n",NULL,"chocher","חוכר","חוֹכֵר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94886,"חוֹכֶרֶת","n",NULL,"chocheret","חוכרת","חוֹכֶרֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94887,"שַׁקְרָן","n",NULL,"shakran","שקרן","שַׁקְרָן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94888,"שַׁקְרָנִית","n",NULL,"shakranit","שקרנית","שַׁקְרָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94889,"שׁוֹדֵד","n",NULL,"shoded","שודד","שׁוֹדֵד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94890,"שׁוֹדֶדֶת","n",NULL,"shodedet","שודדת","שׁוֹדֶדֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94891,"שְׁרַבְרָב","n",NULL,"shravrav","שרברב","שְׁרַבְרָב",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94892,"שְׁבוּי-מִלְחָמָה","n",NULL,"shvuy-milchamah","שבוי-מלחמה","שְׁבוּי-מִלְחָמָה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94893,"שְׁבוּיַת-מִלְחָמָה","n",NULL,"shvuyat-milchamah","שבויית-מלחמה","שְׁבוּיַת-מִלְחָמָה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94894,"שַׂחְיָן","n",NULL,"sachyan","שחיין","שַׂחְיָן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94895,"שַׂחְיָנִית","n",NULL,"sachyanit","שחיינית","שַׂחְיָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94896,"שָׁרָךְ","n",NULL,"sharach","שרך","שָׁרָךְ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94897,"שְׁתִיל","n",NULL,"shtil","שתיל","שְׁתִיל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94898,"שִׁטָּה","n",NULL,"shitah","שיטה","שִׁטָּה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94899,"אָקַצְיָה","n",NULL,"akatzya","אקציה","אָקַצְיָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94900,"שִׁקְמָה","n",NULL,"shikmah","שקמה","שִׁקְמָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94901,"פִיקוּס-הַשִּׁקְמָה","n",NULL,"fikus-hashikmah","פיקוס-השקמה","פִיקוּס-הַשִּׁקְמָה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94902,"שְׁמָרִים","n",NULL,"shmarim","שמרים","שְׁמָרִים",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94903,"שֹׁחַד","n",NULL,"shochad","שוחד","שֹׁחַד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94904,"שַׁלְמוֹנִים","n",NULL,"shalmonim","שלמונים","שַׁלְמוֹנִים",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94905,"שֶׁקֶל","n",NULL,"shekel","שקל","שֶׁקֶל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94906,"שְׁיָר","n",NULL,"shyar","שייר","שְׁיָר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94907,"שְׁאֵרִית","n",NULL,"she\'erit","שארית","שְׁאֵרִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94908,"שִׁכָּרוֹן","n",NULL,"shikaron","שיכרון","שִׁכָּרוֹן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94909,"שִׁכְרוּת","n",NULL,"shichrut","שִׁכְרוּת","שִׁכְרוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94910,"שַׁפַּעַת","n",NULL,"shapa\'at","שפעת","שַׁפַּעַת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94911,"גְּרִיפָּה","n",NULL,"gripah","גריפה","גְּרִיפָּה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94912,"שַׁעֶלֶת","n",NULL,"sha\'elet","שעלת","שַׁעֶלֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94913,"שִׁזּוּף","n",NULL,"shizuf","שיזוף","שִׁזּוּף",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94914,"שִׁזָּפוֹן","n",NULL,"shizafon","שיזפון","שִׁזָּפוֹן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94915,"שִׁלְשׁוּל","n",NULL,"shilshul","שלשול","שִׁלְשׁוּל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94916,"שְׁפִיּוּת","n",NULL,"shfiyut","שפיות","שְׁפִיּוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94917,"שֹׂבַע","n",NULL,"sova","שובע","שֹׂבַע",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94918,"שָׂבְעָה","n",NULL,"sov\'ah","שובעה","שָׂבְעָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94919,"שְׂבִיעָה","n",NULL,"svi\'ah","שביעה","שְׂבִיעָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94920,"שְׂבֵעוּת","n",NULL,"sve\'ut","שבעות","שְׂבֵעוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94921,"בְּרָכָה","n",NULL,"brachah","ברכה","בְּרָכָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94922,"שִׁתּוּק","n",NULL,"shituk","שיתוק","שִׁתּוּק",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94923,"שֶׁנְהָב","n",NULL,"shenhav","שנהב","שֶׁנְהָב",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94924,"שֶׁתֶן","n",NULL,"sheten","שתן","שֶׁתֶן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94925,"פִּיפִּי","n",NULL,"pipi","פיפי","פִּיפִּי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94926,"מֵי-רַגְלַיִם","n",NULL,"mey-raglayim","מי-רגליים","מֵי-רַגְלַיִם",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94927,"צְרָכִים-קְטַנִּים","n",NULL,"tzrachim-ktanim","צרכים-קטנים","צְרָכִים-קְטַנִּים",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94928,"שְׂרָף","n",NULL,"sraf","שרף","שְׂרָף",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94929,"שַׁעֲוָה","n",NULL,"sha\'avah","שעווה","שַׁעֲוָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94930,"שָׁבוּעַ","n",NULL,"shavu\'a","שבוע","שָׁבוּעַ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94931,"שְׁבוּעַ-עֲבוֹדָה","n",NULL,"shvu\'a-avodah","שבוע-עבודה","שְׁבוּעַ-עֲבוֹדָה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94932,"יוֹם-מְנוּחָה","n",NULL,"yom-menucha","יום-מנוחה","יוֹם-מְנוּחָה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94933,"שַׁבָּת","n",NULL,"shabat","שבת","שַׁבָּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94934,"יוֹם-שַׁבָּת","n",NULL,"yom-shabat","יום-שבת","יוֹם-שַׁבָּת",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94935,"שׁוּב","r",NULL,"shuv","שוב","שׁוּב",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94936,"עוֹד-פַּעַם","r",NULL,"od-pa\'am","עוד-פעם","עוֹד-פַּעַם",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94937,"שֵׁנִית","r",NULL,"shenit","שנית","שֵׁנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94938,"שָׁם","r",NULL,"sham","שם","שָׁם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94939,"אַרְטִיפָקְט","n",NULL,"artifakt","אַרְטִיפָקְט","אַרְטִיפָקְט",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94940,"חֵפֶץ_מְלָאכוּתִי","n",NULL,"xefetz melaxuti","חֵפֶץ_מְלָאכוּתִי","חֵפֶץ_מְלָאכוּתִי"," חפץ מלאכותי ","_","_",NULL);
INSERT INTO hebrew_morpho VALUES (94941,"תְּכוּנָה","n",NULL,"txuna","תכונה","תְּכוּנָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95454,"מַגְנִיב","a",NULL,NULL,"מגניב","מַגְנִיב",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94942,"שָׁמָּה","r",NULL,"shamah","שמה","שָׁמָּה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94943,"לְשָׁם","r",NULL,"lesham","לשם","לְשָׁם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94944,"שִׁהֵק","v",NULL,"shihek","שיהק","שִׁהֵק",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94945,"שָׁאַף","v",NULL,"sha\'af","שאף","שָׁאַף",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94946,"שָׁם","v",NULL,"sham","שם","שָׁם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94947,"שִׁדֵּל","v",NULL,"shidel","שידל","שִׁדֵּל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94948,"דִּבֵּר-עַל-לִבּוֹ","v",NULL,"diber-al-libo","דיבר-על-ליבו","דִּבֵּר-עַל-לִבּוֹ",NULL,"--","--",NULL);
INSERT INTO hebrew_morpho VALUES (94949,"שָׁאַל","v",NULL,"sha\'al","שאל","שָׁאַל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94950,"שִׁטָּה","v",NULL,"shitah","שיטה","שִׁטָּה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94951,"עָשָׂה-מִמֶּנּוּ-צְחוֹק","v",NULL,"asa-mimenu-tzchok","עשה-ממנו-צחוק","עָשָׂה-מִמֶּנּוּ-צְחוֹק",NULL,"--","--",NULL);
INSERT INTO hebrew_morpho VALUES (94952,"הִתֵּל","v",NULL,"hitel","היתל","הִתֵּל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94953,"לָעַג","v",NULL,"la\'ag","לעג","לָעַג",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94954,"הִסְתַּלְבֵּט","v",NULL,"histalbet","הסתלבט","הִסְתַּלְבֵּט",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94955,"לִגְלֵג","v",NULL,"ligleg","לגלג","לִגְלֵג",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94956,"שִׂדֵּד","v",NULL,"shided","שידד","שִׂדֵּד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94957,"שָׂחָה","v",NULL,"sacha","שחה","שָׂחָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94958,"שִׁקְשֵׁק","v",NULL,"shikshek","שקשק","שִׁקְשֵׁק",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94959,"שִׁרְיֵן","v",NULL,"shiryen","שריין","שִׁרְיֵן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94960,"שִׁעְבֵּד","v",NULL,"shi\'ebed","שעבד","שִׁעְבֵּד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94961,"מִשְׁכֵּן","v",NULL,"mishken","משכן","מִשְׁכֵּן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94962,"שָׁלַט","v",NULL,"shalat","שלט","שָׁלַט",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94963,"תַּעֲנִית","n",NULL,"ta\'anit","תענית","תַּעֲנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94964,"תַּמְצִיתִי","a",NULL,"tamtziti","תמציתי","תַּמְצִיתִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94965,"מְתֻמְצָת","a",NULL,"metumtzat","מתומצת","מְתֻמְצָת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94966,"סִינְכְרוֹנִי","a",NULL,"sinchroni","סינכרוני","סִינְכְרוֹנִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94967,"תֵּאוּרִי","a",NULL,"te\'uri","תיאורי","תֵּאוּרִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94968,"דֶּסְקְרִיפְּטִיבִי","a",NULL,"deskriptivi","דסקריפטיבי","דֶּסְקְרִיפְּטִיבִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94969,"תַּכְסִיסִי","a",NULL,"tachsisi","תכסיסי","תַּכְסִיסִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94970,"טַקְטִי","a",NULL,"takti","טקטי","טַקְטִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94971,"תַּקְצִיבִי","a",NULL,"taktzivi","תקציבי","תַּקְצִיבִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94972,"תִּקְשֹׁרֶת","n",NULL,"tikshoret","תקשורת","תִּקְשֹׁרֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94973,"קוֹמוּנִיקַצְיָה","n",NULL,"komunikatzyah","קומוניקציה","קוֹמוּנִיקַצְיָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94974,"תִּבּוּל","n",NULL,"tibul","תיבול","תִּבּוּל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94975,"תִּבְלוּן","n",NULL,"tivlun","תיבלון","תִּבְלוּן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94976,"תְּנוּעָה","n",NULL,"tnu\'a","תנועה","תְּנוּעָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94977,"תְּנוּעַת-נֹעַר","n",NULL,"tnu\'at-no\'ar","תנועת-נוער","תְּנוּעַת-נֹעַר",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94978,"תַּעֲבוּרָה","n",NULL,"ta\'avurah","תעבורה","תַּעֲבוּרָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94979,"תְּזוּזָה","n",NULL,"tezuzah","תזוזה","תְּזוּזָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94980,"מַעֲבָר","n",NULL,"ma\'avar","מעבר","מַעֲבָר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94981,"רֶפוֹרְמָה","n",NULL,"reformah","רפורמה","רֶפוֹרְמָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94982,"תִּקּוּן","n",NULL,"tikun","תיקון","תִּקּוּן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94983,"בַּז-עֵצִים","n",NULL,"baz-etzim","בז-עצים","בַּז-עֵצִים",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94984,"תַּחְבִּיב","n",NULL,"tachbiv","תחביב","תַּחְבִּיב",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94985,"הוֹבִּי","n",NULL,"hobi","הובי","הוֹבִּי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94986,"קֶרלִינְג","n",NULL,"kerling","קרלינג","קֶרלִינְג",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94987,"תַּעֲרוּכָה","n",NULL,"ta\'aruchah","תערוכה","תַּעֲרוּכָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94988,"תִּפוּף","n",NULL,"tifuf","תיפוף","תִּפוּף",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94989,"תְּרוּפָה","n",NULL,"trufah","תרופה","תְּרוּפָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94990,"סַם","n",NULL,"sam","סם","סַם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94991,"תַּשְׁלוּם","n",NULL,"tashlum","תשלום","תַּשְׁלוּם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94992,"מְחֻיָּבוּת","n",NULL,"mechuyavut","מחויבות","מְחֻיָּבוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94993,"מְשִׂימָה","n",NULL,"mesimah","משימה","מְשִׂימָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94994,"תְּגוּבָה","n",NULL,"tguvah","תגובה","תְּגוּבָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94995,"תְּגוּבָה-כִּימִית","n",NULL,"tguvah-kimit","תגובה-כימית","תְּגוּבָה-כִּימִית",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (94996,"רֵאַקְצְיָה","n",NULL,"re\'aktzyah","ראקציה","רֵאַקְצְיָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94997,"תִּעוּשׂ","n",NULL,"ti\'us","תיעוש","תִּעוּשׂ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94998,"תְּלִיָּה","n",NULL,"tliyah","תלייה","תְּלִיָּה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (94999,"תַּחֲרוּת","n",NULL,"tacharut","תחרות","תַּחֲרוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95000,"תִּמְסָח","n",NULL,"timsach","תמסח","תִּמְסָח",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95001,"תַּנִּין","n",NULL,"tanin","תנין","תַּנִּין",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95002,"קְרוֹקוֹדִיל","n",NULL,"krokodil","קרוקודיל","קְרוֹקוֹדִיל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95003,"תַּרְנְגֹלֶת","n",NULL,"tarnegolet","תרנגולת","תַּרְנְגֹלֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95004,"תַּן","n",NULL,"tan","תן","תַּן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95005,"תִּרְכֹּבֶת","n",NULL,"tirkovet","תרכובת","תִּרְכֹּבֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95006,"תַּרְשִׁים","n",NULL,"tarshim","תרשים","תַּרְשִׁים",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95007,"תַּחְפֹּשֶׂת","n",NULL,"tachposet","תחפושת","תַּחְפֹּשֶׂת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95008,"תֶּלֶם","n",NULL,"telem","תלם","תֶּלֶם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95009,"תַּשְׁתִּית","n",NULL,"tashtit","תשתית","תַּשְׁתִּית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95010,"תַּכְשִׁיט","n",NULL,"tachshit","תכשיט","תַּכְשִׁיט",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95011,"אֶבֶן-חֵן","n",NULL,"even-chen","אבן-חן","אֶבֶן-חֵן",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95012,"אֶבֶן-יְקָרָה","n",NULL,"even-yekarah","אבן-יקרה","אֶבֶן-יְקָרָה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95013,"אֶבֶן-טוֹבָה","n",NULL,"even-tovah","אבן-טובה","אֶבֶן-טוֹבָה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95014,"תַּחֲרָה","n",NULL,"tacharah","תחרה","תַּחֲרָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95015,"מַחְתֶּרֶת","n",NULL,"machteret","מחתרת","מַחְתֶּרֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95016,"תַּחְתִּית","n",NULL,"tachtit","תחתית","תַּחְתִּית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95017,"רַכֶּבֶת_תַּחְתִּית","n",NULL,NULL,"רַכֶּבֶת_תַּחְתִּית","רַכֶּבֶת_תַּחְתִּית",NULL,"_","_",NULL);
INSERT INTO hebrew_morpho VALUES (95018,"רַכֶּבֶת-תַּחְתִּית","n",NULL,"rakevet-tachtit","רכבת-תחתית","רַכֶּבֶת-תַּחְתִּית",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95019,"מֶטְרוֹ","n",NULL,"metro","מטרו","מֶטְרוֹ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95020,"תִּזְמֹרֶת","n",NULL,"tizmoret","תזמורת","תִּזְמֹרֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95021,"תַּנּוּר","n",NULL,"tanur","תנור","תַּנּוּר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95022,"צִיּוּר","n",NULL,"tziyur","ציור","צִיּוּר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95023,"תְּמוּנָה","n",NULL,"tmunah","תמונה","תְּמוּנָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95024,"תַּצְלוּם","n",NULL,"tatzlum","תצלום","תַּצְלוּם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95025,"פוֹטוֹגְרָף","n",NULL,NULL,"פוֹטוֹגְרָף","פוֹטוֹגְרָף",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95026,"פּוֹרְטְפוֹלְיוֹ","n",NULL,"portfolyo","פורטפוליו","פּוֹרְטְפוֹלְיוֹ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95027,"יַלְקוּט","n",NULL,"yalkut","ילקוט","יַלְקוּט",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95028,"נֵטֶל","n",NULL,"netel","נטל","נֵטֶל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95029,"מַעֲמָסָה","n",NULL,"ma\'amasah","מעמסה","מַעֲמָסָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95030,"מַשָּׂא","n",NULL,"masa","משא","מַשָּׂא",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95031,"עֹל","n",NULL,"ol","עול","עֹל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95032,"עֹמֶס","n",NULL,"omes","עומס","עֹמֶס",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95033,"תִּיק","n",NULL,"tik","תיק","תִּיק",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95034,"תְּמִימוּת","n",NULL,"tmimut","תמימות","תְּמִימוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95035,"נָאִיבִיּוּת","n",NULL,"na\'iviyut","נאיביות","נָאִיבִיּוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95036,"תֶּנַע","n",NULL,"tena","תנע","תֶּנַע",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95037,"מוֹמֶנְטוּם","n",NULL,"momentum","מומנטום","מוֹמֶנְטוּם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95038,"תַּחְבִּיר","n",NULL,"tachbir","תחביר","תַּחְבִּיר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95039,"סִינְטַקְס","n",NULL,"sintax","סינטקס","סִינְטַקְס",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95040,"תְּנוּפָה","n",NULL,"tnufah","תנופה","תְּנוּפָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95041,"תְּמוּתָה","n",NULL,"tmutah","תמותה","תְּמוּתָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95042,"תְּלִילוּת","n",NULL,"tlilut","תלילות","תְּלִילוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95043,"תַּלְתַּל","n",NULL,"taltal","תלתל","תַּלְתַּל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95044,"אֻנָּה","n",NULL,"unah","אונה","אֻנָּה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95045,"תַּחַת","n",NULL,"tachat","תחת","תַּחַת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95046,"עַכּוּז","n",NULL,"akuz","עכוז","עַכּוּז",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95047,"יַשְׁבָן","n",NULL,"yashvan","ישבן","יַשְׁבָן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95048,"טוּסִיק","n",NULL,"tusik","טוסיק","טוּסִיק",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95049,"שֵׁת","n",NULL,"shet","שת","שֵׁת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95050,"עֲגָבוֹת","n",NULL,"agavot","עגבות","עֲגָבוֹת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95051,"אֲחוֹרַיִם","n",NULL,"achorayim","אחוריים","אֲחוֹרַיִם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95052,"חוּשׁ","n",NULL,"chush","חוש","חוּשׁ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95053,"תַּעֲלוּמָה","n",NULL,"ta\'alumah","תעלומה","תַּעֲלוּמָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95054,"מִסְתּוֹרִין","n",NULL,"mistorin","מסתורין","מִסְתּוֹרִין",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95055,"אֶנִיגְמָה","n",NULL,"enigmah","אניגמה","אֶנִיגְמָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95056,"חִידָה","n",NULL,"chidah","חידה","חִידָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95057,"תְּלוּשׁ","n",NULL,"tlush","תלוש","תְּלוּשׁ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95058,"וָאוּצֶ\'ר","n",NULL,"vaucher","ואוצ\'ר","וָאוּצֶ\'ר",NULL,"\'","\'",NULL);
INSERT INTO hebrew_morpho VALUES (95059,"שׁוֹבֵר","n",NULL,"shover","שובר","שׁוֹבֵר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95060,"קוּפּוֹן","n",NULL,"kupon","קופון","קוּפּוֹן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95061,"תְּחִלִּית","n",NULL,"tchilit","תחילית","תְּחִלִּית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95062,"פְּרֶפִיקְס","n",NULL,"prefix","פרפיקס","פְּרֶפִיקְס",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95063,"תַּעֲנוּג","n",NULL,"ta\'anug","תענוג","תַּעֲנוּג",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95064,"תֵּאוּר","n",NULL,"te\'ur","תיאור","תֵּאוּר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95065,"תַּלְמוּד","n",NULL,"talmud","תלמוד","תַּלְמוּד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95066,"גְּמָרָא","n",NULL,"gmara","גמרא","גְּמָרָא",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95067,"אַבְּסְטְרַקְט","n",NULL,"abstrakt","אבסטרקט","אַבְּסְטְרַקְט",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95068,"תַּקְצִיר","n",NULL,"taktzir","תקציר","תַּקְצִיר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95069,"סִינוֹפְּסִיס","n",NULL,"sinopsis","סינופסיס","סִינוֹפְּסִיס",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95070,"נְיַר-עֵרֶךְ","n",NULL,"niyar-erech","נייר-ערך","נְיַר-עֵרֶךְ",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95071,"תֹּכֶן","n",NULL,"tochen","תוכן","תֹּכֶן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95072,"תֹּכֶן_הָעִנְיָנִים","n",NULL,NULL,"תֹּכֶן_הָעִנְיָנִים","תֹּכֶן_הָעִנְיָנִים",NULL,"_","_",NULL);
INSERT INTO hebrew_morpho VALUES (95073,"תֹּכֶן-הָעִנְיָנִים","n",NULL,"tochen-ha\'inyanim","תוכן-העניינים","תֹּכֶן-הָעִנְיָנִים",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95074,"תַּעֲמוּלָה","n",NULL,"ta\'amulah","תעמולה","תַּעֲמוּלָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95075,"פְּרוֹפָּגַנְדָּה","n",NULL,"propagandah","פרופגנדה","פְּרוֹפָּגַנְדָּה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95076,"הַצְהָרָה-בִּשְׁבוּעָה","n",NULL,"hatzharah-bishvu\'ah","הצהרה-בשבועה","הַצְהָרָה-בִּשְׁבוּעָה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95077,"תַּצְהִיר","n",NULL,"tatzhir","תצהיר","תַּצְהִיר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95078,"תֵּרוּץ","n",NULL,"terutz","תירוץ","תֵּרוּץ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95079,"תְּשׁוּבָה","n",NULL,"tshuvah","תשובה","תְּשׁוּבָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95080,"מַעֲנֶה","n",NULL,"ma\'aneh","מענה","מַעֲנֶה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95081,"פִּתְרוֹן","n",NULL,"pitron","פתרון","פִּתְרוֹן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95082,"תְּנַאי","n",NULL,"tnay","תנאי","תְּנַאי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95083,"תַּשְׁבֵּץ","n",NULL,"tashbetz","תשבץ","תַּשְׁבֵּץ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95084,"סְצֶנָה","n",NULL,"stzenah","סצנה","סְצֶנָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95085,"תַּמְלִיל","n",NULL,"tamlil","תמליל","תַּמְלִיל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95086,"תַּחְקִיר","n",NULL,"tachkir","תחקיר","תַּחְקִיר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95087,"תִּמָּהוֹן","n",NULL,"timahon","תימהון","תִּמָּהוֹן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95088,"הִשְׁתּוֹמְמוּת","n",NULL,"hishtomemut","השתוממות","הִשְׁתּוֹמְמוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95089,"פְּלִיאָה","n",NULL,"pli\'ah","פליאה","פְּלִיאָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95090,"תְּמִיהָה","n",NULL,"tmihah","תמיהה","תְּמִיהָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95091,"הִשְׁתָּאוּת","n",NULL,"hishta\'ut","השתאות","הִשְׁתָּאוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95092,"תִּיכוֹן","n",NULL,"tichon","תיכון","תִּיכוֹן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95093,"תֶּרֶד","n",NULL,"tered","תרד","תֶּרֶד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95094,"עֲלֵי-תֶּרֶד","n",NULL,"aley-tered","עלי-תרד","עֲלֵי-תֶּרֶד",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95095,"תַּפּוּחַ","n",NULL,"tapuach","תפוח","תַּפּוּחַ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95096,"תַּפּוּז","n",NULL,"tapuz","תפוז","תַּפּוּז",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95097,"תַּפּוּחַ-זָהָב","n",NULL,"tapuach-zahav","תפוח-זהב","תַּפּוּחַ-זָהָב",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95098,"תְּאֵנָה","n",NULL,"te\'enah","תאנה","תְּאֵנָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95099,"תַּמְרִיץ","n",NULL,"tamritz","תמריץ","תַּמְרִיץ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95100,"בּוֹנוּס","n",NULL,"bonus","בונוס","בּוֹנוּס",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95101,"תְּבוּסְתָן","n",NULL,"tvustan","תבוסתן","תְּבוּסְתָן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95102,"דֶּפֶטִיסְט","n",NULL,"defetist","דפטיסט","דֶּפֶטִיסְט",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95103,"תַּלְמִיד","n",NULL,"talmid","תלמיד","תַּלְמִיד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95104,"סְטוּדֶנְט","n",NULL,"student","סטודנט","סְטוּדֶנְט",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95105,"מְלֻמָּד","n",NULL,"melumad","מלומד","מְלֻמָּד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95106,"תַּלְיָן","n",NULL,"talyan","תליין","תַּלְיָן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95107,"תַּעֲשִׂיָּן","n",NULL,"ta\'asiyan","תעשיין","תַּעֲשִׂיָּן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95108,"תַּסְרִיטַאי","n",NULL,"tasritay","תסריטאי","תַּסְרִיטַאי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95109,"תַּיָּר","n",NULL,"tayar","תייר","תַּיָּר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95110,"תַּיֶּרֶת","n",NULL,"tayeret","תיירת","תַּיֶּרֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95111,"תְּסִיסָה","n",NULL,"tsisah","תסיסה","תְּסִיסָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95112,"תֶּשֶׁר","n",NULL,"tesher","תשר","תֶּשֶׁר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95113,"טִיפּ","n",NULL,"tip","טיפ","טִיפּ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95114,"דְּמֵי-שְׁתִיָּה","n",NULL,"dmey-shtiyah","דמי-שתייה","דְּמֵי-שְׁתִיָּה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95115,"טוֹנָז\'","n",NULL,"tonaj","טונז\'","טוֹנָז\'",NULL,"\'","\'",NULL);
INSERT INTO hebrew_morpho VALUES (95116,"תַּקְצִיב","n",NULL,"taktziv","תקציב","תַּקְצִיב",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95117,"תְּזוּנָה","n",NULL,"tzunah","תזונה","תְּזוּנָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95118,"שְׁכִיחוּת-יַחֲסִית","n",NULL,"shchichut-yachasit","שכיחות-יחסית","שְׁכִיחוּת-יַחֲסִית",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95119,"שְׁכִיחוּת-מֻחְלֶטֶת","n",NULL,"shchichut-muchletet","שכיחות-מוחלטת","שְׁכִיחוּת-מֻחְלֶטֶת",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95120,"תְּדִירוּת","n",NULL,"tedirut","תדירות","תְּדִירוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95121,"תֶּדֶר","n",NULL,"teder","תדר","תֶּדֶר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95122,"תְּרֵיסָר","n",NULL,"treisar","תריסר","תְּרֵיסָר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95123,"שְׁנֵים-עָשָׂר","n",NULL,"shnem-asar","שנים-עשר","שְׁנֵים-עָשָׂר",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95124,"תַּרְדֵּמַת-חֹרֶף","n",NULL,"tardemat-choref","תרדמת-חורף","תַּרְדֵּמַת-חֹרֶף",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95125,"תַּרְדֵּמָה","n",NULL,"tardemah","תרדמה","תַּרְדֵּמָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95126,"תְּמִסָּה","n",NULL,"tmisah","תמיסה","תְּמִסָּה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95127,"תַּחְמֹצֶת","n",NULL,"tachmotzet","תחמוצת","תַּחְמֹצֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95128,"תִּדְרֵךְ","v",NULL,"tidrech","תידרך","תִּדְרֵךְ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95129,"תִּחְקֵר","v",NULL,"tichker","תיחקר","תִּחְקֵר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95130,"תִּכְנֵת","v",NULL,"tichnet","תיכנת","תִּכְנֵת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95131,"חָמוֹת","n",NULL,"chamot","חמות","חָמוֹת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95132,"נָעֳמִי","n",NULL,"no\'omi","נעמי","נָעֳמִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95133,"אֵם-פּוּנְדְקָאִית","n",NULL,"em-pundeka\'it","אם-פונדקאית","אֵם-פּוּנְדְקָאִית",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95134,"הַבְּתוּלָה-הַקְּדוֹשָׁה","n",NULL,"habetulah-hakdoshah","הבתולה-הקדושה","הַבְּתוּלָה-הַקְּדוֹשָׁה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95135,"הוֹרֶה-בִּיוֹלוֹגִי","n",NULL,"hore-biyologi","הורה-ביולוגי","הוֹרֶה-בִּיוֹלוֹגִי",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95136,"יֵשׁוּת","n",NULL,"yeshut","ישות","יֵשׁוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95137,"בֵּית-אָב","n",NULL,"beit-av","בית-אב","בֵּית-אָב",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95138,"מִשְׁפָּחָה-אוֹמֶנֶת","n",NULL,"mishpachah-omenet","משפחה-אומנת","מִשְׁפָּחָה-אוֹמֶנֶת",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95139,"גַּיִס-חֲמִישִׁי","n",NULL,"gayis-chamishi","גיס-חמישי","גַּיִס-חֲמִישִׁי",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95140,"סוּס-טְרוֹיָאנִי","n",NULL,"sus-troyani","סוס-טרויאני","סוּס-טְרוֹיָאנִי",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95141,"דֹּאַר-שָׁמוּר","n",NULL,"do\'ar-shamur","דואר-שמור","דֹּאַר-שָׁמוּר",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95142,"חֲדַר-רַחְצָה","n",NULL,"chadar-rachatzah","חדר-רחצה","חֲדַר-רַחְצָה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95143,"חֲדַר-אַמְבַּטְיָה","n",NULL,"chadar-ambatyah","חדר-אמבטיה","חֲדַר-אַמְבַּטְיָה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95144,"סְטוּדְיוֹ","n",NULL,"studyo","סטודיו","סְטוּדְיוֹ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95145,"לַבְקָנִית","n",NULL,"lavkanit","לבקנית","לַבְקָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95146,"אָמָּנִית","n",NULL,"omanit","אומנית","אָמָּנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95147,"מֻמְחִית","n",NULL,"mumchit","מומחית","מֻמְחִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95148,"מְבִינָה","n",NULL,"mevinah","מבינה","מְבִינָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95149,"לוּלְיָנִית","n",NULL,"lulyanit","לוליינית","לוּלְיָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95150,"אַקְרוֹבָּטִית","n",NULL,"akrobatit","אקרובטית","אַקְרוֹבָּטִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95151,"אֲהוּבָה","n",NULL,"ahuvah","אהובה","אֲהוּבָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95152,"אַלּוּפָה","n",NULL,"alufah","אלופה","אַלּוּפָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95153,"אֶזְרָחִית","n",NULL,"ezrachit","אזרחית","אֶזְרָחִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95154,"אֲסִירָה","n",NULL,"asirah","אסירה","אֲסִירָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95155,"אֻמָּנִית","n",NULL,"umanit","אומנית","אֻמָּנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95156,"אוֹצֶרֶת","n",NULL,"otzeret","אוצרת","אוֹצֶרֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95157,"פַלַּאח","n",NULL,"falach","פלאח","פַלַּאח",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95158,"יוֹגֵב","n",NULL,"yogev","יוגב","יוֹגֵב",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95159,"עוֹבֵד-אֲדָמָה","n",NULL,"oved-adamah","עובד-אדמה","עוֹבֵד-אֲדָמָה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95160,"חַקְלַאי","n",NULL,"chaklay","חקלאי","חַקְלַאי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95161,"אִישׁ-אֲדָמָה","n",NULL,"ish-adamah","איש-אדמה","אִישׁ-אֲדָמָה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95162,"אִכָּרָה","n",NULL,"ikarah","איכרה","אִכָּרָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95163,"פַלַּאחִית","n",NULL,"falachit","פלאחית","פַלַּאחִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95164,"חַקְלָאִית","n",NULL,"chakla\'it","חקלאית","חַקְלָאִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95165,"אֱלִילָה","n",NULL,"elilah","אלילה","אֱלִילָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95166,"לוֹחֶמֶת","n",NULL,"lochemet","לוחמת","לוֹחֶמֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95167,"נוֹף","n",NULL,"nof","נוף","נוֹף",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95168,"צַמֶּרֶת","n",NULL,"tzameret","צמרת","צַמֶּרֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95169,"כָּלָא","v",NULL,"kala","כלא","כָּלָא",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95170,"חָבַשׁ","v",NULL,"chavash","חבש","חָבַשׁ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95171,"בּוֹגֶרֶת","n",NULL,"bogeret","בוגרת","בּוֹגֶרֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95172,"מְבֻגֶּרֶת","n",NULL,"mevugeret","מבוגרת","מְבֻגֶּרֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95173,"בַּדְרָנִית","n",NULL,"badranit","בדרנית","בַּדְרָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95174,"בּוֹרֶרֶת","n",NULL,"boreret","בוררת","בּוֹרֶרֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95175,"קוֹמִיקָאִית","n",NULL,"komika\'it","קומיקאית","קוֹמִיקָאִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95176,"בַּלָּשִׁית","n",NULL,"balashit","בלשית","בַּלָּשִׁית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95177,"חוֹקֶרֶת-פְּרָטִית","n",NULL,"chokeret-pratit","חוקרת-פרטית","חוֹקֶרֶת-פְּרָטִית",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95178,"בּוֹחֶנֶת","n",NULL,"bochenet","בוחנת","בּוֹחֶנֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95179,"בְּכוֹרָה","n",NULL,"bechorah","בכורה","בְּכוֹרָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95180,"עַצְלָנִית","n",NULL,"atzlanit","עצלנית","עַצְלָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95181,"בַּטְלָנִית","n",NULL,"batlanit","בטלנית","בַּטְלָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95182,"בּוּרָה","n",NULL,"burah","בורה","בּוּרָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95183,"בַּלְשָׁנִית","n",NULL,"balshanit","בלשנית","בַּלְשָׁנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95184,"פַּזְרָנִית","n",NULL,"pazranit","פזרנית","פַּזְרָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95185,"בַּזְבְּזָנִית","n",NULL,"bazbezanit","בזבזנית","בַּזְבְּזָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95186,"בּוֹחֶרֶת","n",NULL,"bocheret","בוחרת","בּוֹחֶרֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95187,"מַצְבִּיעָה","n",NULL,"natzbi\'ah","מצביעה","מַצְבִּיעָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95188,"גַּמָּדָה","n",NULL,"gamadah","גמדה","גַּמָּדָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95189,"גִּבֶּנֶת","n",NULL,"gibenet","גיבנת","גִּבֶּנֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95190,"גַּנֶּבֶת","n",NULL,"ganevet","גנבת","גַּנֶּבֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95192,"מִצְוָה","n",NULL,"mitzvah","מצווה","מִצְוָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95193,"תְּבוּסְתָנִית","n",NULL,"tvustanit","תבוסתנית","תְּבוּסְתָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95194,"דֶּפֶטִיסְטִית","n",NULL,"defetistit","דפטיסטית","דֶּפֶטִיסְטִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95195,"מְדַבֵּר","v",NULL,"medaber","מדבר","מְדַבֵּר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95196,"אֵין-סְפֹר","a",NULL,"ein-sfor","אין-ספור","אֵין-סְפֹר",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95197,"אֵינְסוֹף","a",NULL,"einsof","אינסוף","אֵינְסוֹף",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95198,"זַיְפָנִית","n",NULL,"zayfanit","זייפנית","זַיְפָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95199,"זַגָּגִית","n",NULL,"zagagit","זגגית","זַגָּגִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95200,"זַמֶּרֶת","n",NULL,"zameret","זמרת","זַמֶּרֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95201,"חֵרֶשֶׁת","n",NULL,"chereshet","חרשת","חֵרֶשֶׁת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95202,"הַחֵרְשִׁים","n",NULL,"hachershim","החירשים","הַחֵרְשִׁים",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95203,"חַזָּנִית","n",NULL,"chazanit","חזנית","חַזָּנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95204,"נַגָּרִית","n",NULL,"nagarit","נגרית","נַגָּרִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95205,"חַלְפָנִית","n",NULL,"chalfanit","חלפנית","חַלְפָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95206,"מַעֲרִיצָה","n",NULL,"ma\'aritzah","מעריצה","מַעֲרִיצָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95207,"חֲלוּצָה","n",NULL,"chalutzah","חלוצה","חֲלוּצָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95208,"חוֹלָה","n",NULL,"cholah","חולה","חוֹלָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95210,"חֲשׁוּדָה","n",NULL,"chashudah","חשודה","חֲשׁוּדָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95212,"בַּעַל-בְּרִית","n",NULL,"ba\'al-brit","בעל-ברית","בַּעַל-בְּרִית",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95213,"חֲבֵרָה","n",NULL,"chaverah","חברה","חֲבֵרָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95214,"פְּרִימִיטִיבִי","a",NULL,"primitivi","פרימיטיבי","פְּרִימִיטִיבִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95215,"דָּלִיל","a",NULL,"dalil","דליל","דָּלִיל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95216,"עָמוּס","a",NULL,"amus","עמוס","עָמוּס",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95217,"צָפוּף","a",NULL,"tzafuf","צפוף","צָפוּף",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95218,"חֲמוּר-סֵבֶר","a",NULL,"chamur-sever","חמור-סבר","חֲמוּר-סֵבֶר",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95219,"רְצִינִי","a",NULL,"retzini","רציני","רְצִינִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95220,"חָמוּר","a",NULL,"chamur","חמור","חָמוּר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95221,"חַנְקָנִי","a",NULL,"chankani","חנקני","חַנְקָנִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95222,"חֲטִיבָתִי","a",NULL,"chativati","חטיבתי","חֲטִיבָתִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95223,"חוּץ","n",NULL,"chutz","חוץ","חוּץ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95224,"טִפּוּסִי","a",NULL,"tipusi","טיפוסי","טִפּוּסִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95225,"פְּרוֹפּוֹרְצְיוֹנָלִי","a",NULL,"proportzyonali","פרופורציונאלי","פְּרוֹפּוֹרְצְיוֹנָלִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95226,"פְּרוֹפּוֹרְצְיוֹנִי","a",NULL,"proportzyoni","פרופורציוני","פְּרוֹפּוֹרְצְיוֹנִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95227,"יָעִיל","a",NULL,"ya\'il","יעיל","יָעִיל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95228,"זָקוּף","a",NULL,"zakuf","זקוף","זָקוּף",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95229,"יָחִיד","a",NULL,"yachid","יחיד","יָחִיד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95230,"יְחִידִי","a",NULL,"yechidi","יחידי","יְחִידִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95231,"יָאֶה","a",NULL,"ya\'eh","יאה","יָאֶה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95232,"כָּלוּל","a",NULL,"kalul","כלול","כָּלוּל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95233,"כֵּן","a",NULL,"ken","כן","כֵּן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95234,"כַּלְבָּה","n",NULL,"kalba","כלבה","כַּלְבָּה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95235,"כֹּפֶר","n",NULL,"kofer","כופר","כֹּפֶר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95236,"כֶּבֶשׁ","n",NULL,"kevesh","כבש","כֶּבֶשׁ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95237,"כַּן","n",NULL,"kan","כן","כַּן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95238,"כַּרְטִיסִיָּה","n",NULL,"kartisiya","כרטיסייה","כַּרְטִיסִיָּה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95239,"כְּרוּב","n",NULL,"kruv","כרוב","כְּרוּב",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95240,"כּוּשִׁי","n",NULL,"kushi","כושי","כּוּשִׁי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95241,"שָׁחֹר","n",NULL,NULL,"שָׁחֹר","שָׁחֹר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95242,"לַהֲטוּטָן","n",NULL,"lahatutan","להטוטן","לַהֲטוּטָן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95243,"לַהֲטוּטָנִית","n",NULL,"lahatutanit","להטוטנית","לַהֲטוּטָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95244,"לע-הָאֲרִי","n",NULL,"lo\'a-ha\'ari","לוע-הארי","לע-הָאֲרִי",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95245,"מְרֻצֶּה","a",NULL,"merutze","מרוצה","מְרֻצֶּה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95246,"כִּוֵּן","v",NULL,"kiven","כִּוֵּן","כִּוֵּן"," כיוון ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95247,"הִתְבַּיֵּת","v",NULL,"hitbayet","הִתְבַּיֵּת","הִתְבַּיֵּת"," התביית ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95248,"הִפְנָה-שְׁאֵלָה","v",NULL,NULL,"הִפְנָה-שְׁאֵלָה","הִפְנָה-שְׁאֵלָה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95250,"הִפְנָה","v",NULL,NULL,"הִפְנָה","הִפְנָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95251,"מִקֵּם","v",NULL,NULL,"מִקֵּם","מִקֵּם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95252,"שָׂם","v",NULL,NULL,"שָׂם","שָׂם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95253,"הֵזִיז","v",NULL,NULL,"הֵזִיז","הֵזִיז",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95254,"חֵפֶץ","n",NULL,NULL,"חֵפֶץ","חֵפֶץ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95255,"אוֹבְּיֶקְט","n",NULL,NULL,"אוֹבְּיֶקְט","אוֹבְּיֶקְט"," אוביקט ; אובייקט ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95256,"מִקְלַחַת","n",NULL,NULL,"מִקְלַחַת","מִקְלַחַת"," מקלחת ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95257,"רֹאשׁ-מִקְלַחַת","n",NULL,NULL,"רֹאשׁ-מִקְלַחַת","רֹאשׁ-מִקְלַחַת"," ראש מקלחת ","-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95258,"מִקְלְחוֹן","n",NULL,NULL,"מִקְלְחוֹן","מִקְלְחוֹן"," מקלחון ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95259,"וִילוֹן-מִקְלַחַת","n",NULL,NULL,"וִילוֹן-מִקְלַחַת","וִילוֹן-מִקְלַחַת"," וילון מקלחת ","-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95260,"נָאֶה","a",NULL,"na\'eh","נאה","נָאֶה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95261,"נִכְבָּד","a",NULL,"nichbad","נכבד","נִכְבָּד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95262,"הָגוּן","a",NULL,"hagun","הגון","הָגוּן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95263,"מֻטְעֶה","a",NULL,"mut\'eh","מוטעה","מֻטְעֶה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95264,"מוּזָר","a",NULL,"muzar","מוזר","מוּזָר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95265,"מֻרְגָּשׁ","a",NULL,"murgash","מורגש","מֻרְגָּשׁ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95266,"מְפַגֵּר","a",NULL,"mefager","מפגר","מְפַגֵּר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95267,"מְבֻצָּר","a",NULL,"mevutzar","מבוצר","מְבֻצָּר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95268,"קַל-דַּעַת","a",NULL,"kal-da\'at","קל-דעת","קַל-דַּעַת",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95269,"מְעֻוָּת","a",NULL,"me\'uvat","מעוות","מְעֻוָּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95270,"חֶדֶר-אָקוּסְטִי","n",NULL,NULL,"חֶדֶר-אָקוּסְטִי","חֶדֶר-אָקוּסְטִי"," חדר אקוסטי ","-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95271,"אֲחוֹרֵי-הַקְּלָעִים","n",NULL,NULL,"אֲחוֹרֵי-הַקְּלָעִים","אֲחוֹרֵי-הַקְּלָעִים"," אחורי הקלעים ","-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95272,"אוּלַם-רִקּוּדִים","n",NULL,NULL,"אוּלַם-רִקּוּדִים","אוּלַם-רִקּוּדִים"," אולם ריקודים ","-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95273,"בָּר","n",NULL,NULL,"בָּר","בָּר"," בר ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95274,"חֲדַר-שֵׁנָה","n",NULL,NULL,"חֲדַר-שֵׁנָה","חֲדַר-שֵׁנָה"," חדר שינה ","-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95275,"מִגְדַּל-פַּעֲמוֹנִים","n",NULL,NULL,"מִגְדַּל-פַּעֲמוֹנִים","מִגְדַּל-פַּעֲמוֹנִים"," מגדל פעמונים ","-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95276,"חֲדַר-בִּילְיַארְד","n",NULL,NULL,"חֲדַר-בִּילְיַארְד","חֲדַר-בִּילְיַארְד"," חדר ביליארד ","-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95277,"חֲדַר-יְשִׁיבוֹת","n",NULL,NULL,"חֲדַר-יְשִׁיבוֹת","חֲדַר-יְשִׁיבוֹת"," חדר ישיבות ","-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95278,"תָּא","n",NULL,NULL,"תָּא","תָּא"," תא ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95279,"יֵשׁוּת-גּוֹרֶמֶת","n",NULL,NULL,"יֵשׁוּת-גּוֹרֶמֶת","יֵשׁוּת-גּוֹרֶמֶת"," ישות גורמת ","-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95280,"מִכְלוֹל","n",NULL,NULL,"מִכְלוֹל","מִכְלוֹל"," מכלול ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95281,"מָקוֹם-דִּמְיוֹנִי","n",NULL,NULL,"מָקוֹם-דִּמְיוֹנִי","מָקוֹם-דִּמְיוֹנִי"," מקום דמיוני ; מקום דימיוני ","-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95282,"יְחִידָה","n",NULL,NULL,"יְחִידָה","יְחִידָה"," יחידה ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95283,"דָּבָר-לֹא-הֶכְרֵחִי","n",NULL,NULL,"דָּבָר-לֹא-הֶכְרֵחִי","דָּבָר-לֹא-הֶכְרֵחִי"," דבר לא הכרחי ","--","--",NULL);
INSERT INTO hebrew_morpho VALUES (95284,"מִשְׁתַּנֶּה","n",NULL,NULL,"מִשְׁתַּנֶּה","מִשְׁתַּנֶּה"," משתנה ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95285,"מְבַשֵּׂר","n",NULL,NULL,"מְבַשֵּׂר","מְבַשֵּׂר"," מבשר ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95286,"מֻשָּׂא-תֵּאוּר","n",NULL,NULL,"מֻשָּׂא-תֵּאוּר","מֻשָּׂא-תֵּאוּר"," מושא תיאור ","-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95287,"חֲדַר-קְלָפִים","n",NULL,NULL,"חֲדַר-קְלָפִים","חֲדַר-קְלָפִים"," חדר קלפים ","-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95288,"תָּא-כֶּלֶא","n","תא כלא",NULL,"תָּא-כֶּלֶא","תָּא-כֶּלֶא",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95289,"לִשְׁכַּת-הַשּׁוֹפֵט","n",NULL,NULL,"לִשְׁכַּת-הַשּׁוֹפֵט","לִשְׁכַּת-הַשּׁוֹפֵט"," לשכת השופט ","-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95290,"מֶלְתָּחָה","n",NULL,NULL,"מֶלְתָּחָה","מֶלְתָּחָה"," מלתחה ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95291,"גַּרְדֶּרוֹבָּה","n",NULL,NULL,"גַּרְדֶּרוֹבָּה","גַּרְדֶּרוֹבָּה"," גרדרובה ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95292,"מָדוֹר","n",NULL,NULL,"מדור","מָדוֹר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95293,"חֲדַר-בַּקָּרָה","n",NULL,NULL,"חֲדַר-בַּקָּרָה","חֲדַר-בַּקָּרָה"," חדר בקרה ","-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95294,"אוּלָם-בֵּית-הַמִּשְׁפָּט","n",NULL,NULL,"אוּלָם-בֵּית-הַמִּשְׁפָּט","אוּלָם-בֵּית-הַמִּשְׁפָּט"," אולם בית המשפט ","--","--",NULL);
INSERT INTO hebrew_morpho VALUES (95295,"מֻצְלָח","a",NULL,"mutzlach","מוצלח","מֻצְלָח",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95296,"מְסַיֵּעַ","a",NULL,"mesaye\'a","מסייע","מְסַיֵּעַ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95297,"מַאֲמָץ","n",NULL,"ma\'amatz","מאמץ","מַאֲמָץ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95298,"נִסָּיוֹן","n",NULL,"nisayon","ניסיון","נִסָּיוֹן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95299,"מַדָּע","n",NULL,"mada","מדע","מַדָּע",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95300,"אִינְטֶלֶקְטוּאָל","n",NULL,"intelektual","אינטלקטואל","אִינְטֶלֶקְטוּאָל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95301,"אִינְטֶלֶקְטוּאָלִית","n",NULL,"intelektualit","אינטלקטואלית","אִינְטֶלֶקְטוּאָלִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95302,"עֶצֶם-טִבְעִי","n",NULL,NULL,"עֶצֶם-טִבְעִי","עֶצֶם-טִבְעִי"," עצם טבעי ","-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95303,"מִקּוּם","n",NULL,NULL,"מִקּוּם","מִקּוּם"," מיקום ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95304,"עוֹשֵׂה-הַפְּעֻלָּה","n",NULL,NULL,"עוֹשֵׂה-הַפְּעֻלָּה","עוֹשֵׂה-הַפְּעֻלָּה"," עושה הפעולה ","-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95305,"הַנִּסְתָּר","n",NULL,NULL,"הַנִּסְתָּר","הַנִּסְתָּר"," הנסתר ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95306,"הַגּוֹרָל","n",NULL,NULL,"הגורל","הַגּוֹרָל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95307,"יֵשׁוּת-עַל-טִבְעִית","n",NULL,NULL,"יֵשׁוּת-עַל-טִבְעִית","יֵשׁוּת-עַל-טִבְעִית",NULL,"--","--",NULL);
INSERT INTO hebrew_morpho VALUES (95308,"זָרָז","n",NULL,NULL,"זָרָז","זָרָז"," זרז ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95309,"דֶּאוּס-אֶקְס-מָכִינָה","n",NULL,NULL,"דֶּאוּס-אֶקְס-מָכִינָה","דֶּאוּס-אֶקְס-מָכִינָה"," דאוס אקס מכינה ","--","--",NULL);
INSERT INTO hebrew_morpho VALUES (95310,"הַסִּבָּה-הָעִלָּה-הָרִאשׁוֹנָה","n",NULL,NULL,"הַסִּבָּה-הָעִלָּה-הָרִאשׁוֹנָה","הַסִּבָּה-הָעִלָּה-הָרִאשׁוֹנָה",NULL,"--","--",NULL);
INSERT INTO hebrew_morpho VALUES (95311,"הַסִּבָּה-הָרִאשׁוֹנָה","n",NULL,NULL,"הסיבה_הראשונה","הַסִּבָּה-הָרִאשׁוֹנָה",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95312,"דָּת","n",NULL,NULL,"דת","דָּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95313,"קְבוּצָה-חֶבְרָתִית","n",NULL,NULL,"קבוצה_חברתית","קְבוּצָה-חֶבְרָתִית",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95314,"הַצְּלָב-הָאָדֹם","n",NULL,NULL,"הצלב_האדום","הַצְּלָב-הָאָדֹם",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95315,"כִּסֵּא","n",NULL,NULL,"כִּסֵּא","כִּסֵּא"," כיסא ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95316,"מוֹשָׁב","n",NULL,NULL,"מושב","מוֹשָׁב",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95317,"רָהִיט","n",NULL,NULL,"רהיט","רָהִיט",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95318,"רִהוּט","n",NULL,NULL,"ריהוט","רִהוּט",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95319,"מִכְשׁוּר","n",NULL,NULL,"מכשור","מִכְשׁוּר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95320,"בַּלְשָׁנוּת","n",NULL,NULL,"בלשנות","בַּלְשָׁנוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95321,"דִּיסְצִיפְּלִינָה","n",NULL,NULL,"דיסציפלינה","דִּיסְצִיפְּלִינָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95322,"מֵגֵן","n",NULL,"megen","מגן","מֵגֵן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95323,"מְגִנָּה","n",NULL,"megina","מגינה","מְגִנָּה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95324,"מַנְהִיג","n",NULL,"manhig","מנהיג","מַנְהִיג",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95325,"מַנְהִיגָה","n",NULL,"manhiga","מנהיגה","מַנְהִיגָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95326,"מְלַוֶּה","n",NULL,"melave","מלווה","מְלַוֶּה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95327,"מְלַוָּה","n",NULL,"melava","מלווה","מְלַוָּה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95328,"מְנַהֶלֶת","n",NULL,"menahelet","מנהלת","מְנַהֶלֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95329,"מְנַהֵל","n",NULL,"menahel","מנהל","מְנַהֵל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95330,"אַרְכִיטֶקְט","n",NULL,"architekt","ארכיטקט","אַרְכִיטֶקְט",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95331,"אַדְרִיכָל","n",NULL,"adrichal","אדריכל","אַדְרִיכָל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95332,"אַדְרִיכָלִית","n",NULL,"adrichalit","אדריכלית","אַדְרִיכָלִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95333,"אַרְכִיטֶקְטִית","n",NULL,"architektit","ארכיטקטית","אַרְכִיטֶקְטִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95334,"מְפַרְנֵס","n",NULL,"mefarnes","מפרנס","מְפַרְנֵס",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95335,"מְפַרְנֶסֶת","n",NULL,NULL,"מְפַרְנֶסֶת","מְפַרְנֶסֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95336,"לֵיצָן","n",NULL,"leitzan","ליצן","לֵיצָן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95337,"מוּקְיוֹן","n",NULL,"mukyon","מוקיון","מוּקְיוֹן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95338,"לֵיצָנִית","n",NULL,"leitzanit","ליצנית","לֵיצָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95339,"מְפַקֵּד","n",NULL,"mefaked","מפקד","מְפַקֵּד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95340,"מְפַקֶּדֶת","n",NULL,"mefakedet","מפקדת","מְפַקֶּדֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95341,"מוּמָר","n",NULL,"mumar","מומר","מוּמָר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95342,"מוּמֶרֶת","n",NULL,"mumeret","מומרת","מוּמֶרֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95343,"טַבָּח","n",NULL,"tabach","טבח","טַבָּח",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95344,"טַבָּחִית","n",NULL,"tabachit","טבחית","טַבָּחִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95345,"מְבַשֶּׁלֶת","n",NULL,"mevashelet","מבשלת","מְבַשֶּׁלֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95346,"מְרַכֵּז","n",NULL,"merakez","מרכז","מְרַכֵּז",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95347,"רַכָּז","n",NULL,"rakaz","רכז","רַכָּז",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95348,"מְתָאֵם","n",NULL,"meta\'em","מתאם","מְתָאֵם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95349,"מְרַכֶּזֶת","n",NULL,"merakezet","מרכזת","מְרַכֶּזֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95350,"רַכֶּזֶת","n",NULL,"rakezet","רכזת","רַכֶּזֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95351,"מְתָאֶמֶת","n",NULL,"meta\'emet","מתאמת","מְתָאֶמֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95352,"מַשְׁמִיצָן","n",NULL,"mashmitzan","משמיצן","מַשְׁמִיצָן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95353,"לַכְלְכָן","n",NULL,"lachlechan","לכלכן","לַכְלְכָן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95354,"מַשְׁמִיצָנִית","n",NULL,"mashmitzanit","משמיצנית","מַשְׁמִיצָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95355,"לַכְלְכָנִית","n",NULL,"lachlechanit","לכלכנית","לַכְלְכָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95356,"מַפְקִיד","n",NULL,"mafkid","מפקיד","מַפְקִיד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95357,"מַפְקִידָה","n",NULL,"mafkida","מפקידה","מַפְקִידָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95358,"מְהַגֵּר","n",NULL,"mehager","מהגר","מְהַגֵּר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95359,"אֶמִיגְרַנְט","n",NULL,"emigrant","אמיגרנט","אֶמִיגְרַנְט",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95360,"מְהַגֶּרֶת","n",NULL,"mehageret","מהגרת","מְהַגֶּרֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95361,"אֶמִיגְרַנְטִית","n",NULL,"emigrantit","אמיגרנטית","אֶמִיגְרַנְטִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95362,"אִימִיגְרַנְט","n",NULL,"imigrant","אימיגרנט","אִימִיגְרַנְט",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95363,"אִימִיגְרַנְטִית","n",NULL,"imigrantit","אימיגרנטית","אִימִיגְרַנְטִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95364,"מַעֲבִיד","n",NULL,"ma\'avid","מעביד","מַעֲבִיד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95365,"מַעֲסִיק","n",NULL,"ma\'asik","מעסיק","מַעֲסִיק",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95366,"מַעֲבִידָה","n",NULL,"ma\'avida","מעבידה","מַעֲבִידָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95367,"מַעֲסִיקָה","n",NULL,"ma\'asika","מעסיקה","מַעֲסִיקָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95368,"מְפֻנֶּה","n",NULL,"mefune","מפונה","מְפֻנֶּה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95369,"מְפֻנָּה","n",NULL,"mefuna","מפונה","מְפֻנָּה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95370,"מְנַצֵּל","n",NULL,"menatzel","מנצל","מְנַצֵּל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95371,"נַצְלָן","n",NULL,"natzlan","נצלן","נַצְלָן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95372,"מְנַצֶּלֶת","n",NULL,"menatzelet","מנצלת","מְנַצֶּלֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95373,"נַצְלָנִית","n",NULL,"natzlanit","נצלנית","נַצְלָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95374,"מְדַקְדֵּק","n",NULL,"medakdek","מדקדק","מְדַקְדֵּק",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95375,"מְדַקְדֶּקֶת","n",NULL,"medakdeket","מדקדקת","מְדַקְדֶּקֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95376,"מְטַיֵּל","n",NULL,"metayel","מטייל","מְטַיֵּל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95377,"טַיָּל","n",NULL,"tayal","טייל","טַיָּל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95378,"מְטַיֶּלֶת","n",NULL,"metayelet","מטיילת","מְטַיֶּלֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95379,"טַיֶּלֶת","n",NULL,"tayelet","טיילת","טַיֶּלֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95380,"מְאָרַחַת","n",NULL,"me\'arachat","מארחת","מְאָרַחַת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95381,"קֶטַע","n",NULL,"keta","קֶטַע","קֶטַע"," קטע ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95382,"חֹמֶר-כָּתוּב","n",NULL,"xomer katuf","חומר_כתוב","חֹמֶר-כָּתוּב",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95383,"תִּקְשֹׁרֶת-בִּכְתָב","n",NULL,"tikshoret bixtav","תקשורת_בכתב","תִּקְשֹׁרֶת-בִּכְתָב",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95384,"קֶשֶׁר-חֶבְרָתִי","n",NULL,"kesher xevrati","קשר_חברתי","קֶשֶׁר-חֶבְרָתִי",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95385,"הַפְשָׁטָה","n",NULL,"hafshata","הפשטה","הַפְשָׁטָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95386,"רְחוֹב-רָאשִׁי","n",NULL,"rexov rashi","רחוב_ראשי","רְחוֹב-רָאשִׁי",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95387,"מְפַקֵּחַ","n",NULL,"mefake\'ach","מפקח","מְפַקֵּחַ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95388,"מְפַקַּחַת","n",NULL,"mefakachat","מפקחת","מְפַקַּחַת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95389,"מְעַצֵּב-פְּנִים","n",NULL,"me\'atzev-pnim","מעצב-פנים","מְעַצֵּב-פְּנִים",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95390,"מְעַצֶּבֶת-פְּנִים","n",NULL,"me\'atzevet-pnim","מעצבת-פנים","מְעַצֶּבֶת-פְּנִים",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95391,"מִתְמַחֶה","n",NULL,"mitmache","מתמחה","מִתְמַחֶה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95392,"סְטָזֶ\'ר","n",NULL,"stajer","סטז\'ר","סְטָזֶ\'ר",NULL,"\'","\'",NULL);
INSERT INTO hebrew_morpho VALUES (95393,"סְטָזֶ\'רִית","n",NULL,"stajerit","סטז\'רית","סְטָזֶ\'רִית",NULL,"\'","\'",NULL);
INSERT INTO hebrew_morpho VALUES (95394,"מְרֻאְיָן","n",NULL,"meruayan","מרואיין","מְרֻאְיָן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95395,"מְרֻאְיֶנֶת","n",NULL,"meruayenet","מרואיינת","מְרֻאְיֶנֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95396,"מַמְצִיא","n",NULL,"mamtzi","ממציא","מַמְצִיא",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95397,"מַמְצִיאָה","n",NULL,"mamtzi\'ah","ממציאה","מַמְצִיאָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95398,"מַשְׁקִיעַ","n",NULL,"mashki\'a","משקיע","מַשְׁקִיעַ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95399,"מַשְׁקִיעָה","n",NULL,"mashki\'ah","משקיעה","מַשְׁקִיעָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95400,"מַלְוֶה","n",NULL,"malve","מלווה","מַלְוֶה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95401,"מַלְוָה","n",NULL,"malva","מלווה","מַלְוָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95402,"מְצֹרָע","n",NULL,"metzora","מצורע","מְצֹרָע",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95403,"מְצֹרַעַת","n",NULL,"metzora\'at","מצורעת","מְצֹרַעַת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95404,"רוֹצֵחַ","n",NULL,"rotze\'ach","רוצח","רוֹצֵחַ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95405,"רוֹצַחַת","n",NULL,"rotzachat","רוצחת","רוֹצַחַת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95406,"מְסַפֵּר","n",NULL,"mesaper","מספר","מְסַפֵּר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95407,"מְסַפֵּר-סִפּוּרִים","n",NULL,"mesaper-sipurim","מספר-סיפורים","מְסַפֵּר-סִפּוּרִים",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95408,"מְסַפֶּרֶת","n",NULL,"mesaperet","מספרת","מְסַפֶּרֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95409,"מְסַפֶּרֶת-סִפּוּרִים","n",NULL,"mesaperet-sipurim","מספרת-סיפורים","מְסַפֶּרֶת-סִפּוּרִים",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95410,"עֵז","n",NULL,"ez","עז","עֵז",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95411,"מְטַפֶּלֶת","n",NULL,"metapelet","מטפלת","מְטַפֶּלֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95412,"אוֹמֶנֶת","n",NULL,"omenet","אומנת","אוֹמֶנֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95413,"מְבַצֵּעַ","n",NULL,"mevatze\'a","מבצע","מְבַצֵּעַ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95414,"מְבַצַּעַת","n",NULL,"mevatza\'at","מבצעת","מְבַצַּעַת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95415,"מְתַכְנֵן","n",NULL,"metachnen","מתכנן","מְתַכְנֵן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95416,"מְתַכְנֶנֶת","n",NULL,"metachnenet","מתכננת","מְתַכְנֶנֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95417,"מְתַכְנֵת","n",NULL,"metachnet","מתכנת","מְתַכְנֵת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95418,"תָּכְנִיתָן","n",NULL,"tochnitan","תוכניתן","תָּכְנִיתָן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95419,"מְתַכְנֶתֶת","n",NULL,"metachnetet","מתכנתת","מְתַכְנֶתֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95420,"תָּכְנִיתָנִית","n",NULL,"tochnitanit","תוכניתנית","תָּכְנִיתָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95421,"מְחַדֵּשׁ","n",NULL,"mechadesh","מחדש","מְחַדֵּשׁ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95422,"מְחַדֶּשֶׁת","n",NULL,"mechadeshet","מחדשת","מְחַדֶּשֶׁת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95423,"כְּלַל-הַיֶּדַע","n",NULL,"klal hayeda","כלל_הידע","כְּלַל-הַיֶּדַע",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95424,"מַהוּת-פְּסִיכוֹלוֹגִית","n",NULL,NULL,"מהות_פסיכולוגית","מַהוּת-פְּסִיכוֹלוֹגִית",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95425,"הַרְגָּשָׁה","n",NULL,"hargasha","הרגשה","הַרְגָּשָׁה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95426,"יְכֹלֶת-קוֹגְנִיטִיבִית","n",NULL,NULL,"יכולת_קוגניטיבית","יְכֹלֶת-קוֹגְנִיטִיבִית",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95427,"כֹּשֶׁר-מֶנְטָלִי","n",NULL,NULL,"כושר_מנטלי","כֹּשֶׁר-מֶנְטָלִי",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95428,"כָּבֵד","a",NULL,NULL,"כָּבֵד","כָּבֵד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95429,"מִשְׁקָל-כָּבֵד","a",NULL,NULL,"משקל_כבד","מִשְׁקָל-כָּבֵד",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95430,"מָסִיבִי","a",NULL,NULL,"מסיבי","מָסִיבִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95431,"עִסָּתִי","a",NULL,NULL,"עיסתי","עִסָּתִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95432,"מִשְׁקָל-בֵּינוֹנִי","a",NULL,NULL,"משקל_בינוני","מִשְׁקָל-בֵּינוֹנִי",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95433,"מִשְׁקָל-חֲצִי-בֵּינוֹנִי","a",NULL,NULL,"משקל_חצי_בינוני","מִשְׁקָל-חֲצִי-בֵּינוֹנִי",NULL,"--","__",NULL);
INSERT INTO hebrew_morpho VALUES (95434,"אַוְרִירִי","a",NULL,NULL,"אוורירי","אַוְרִירִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95435,"מִשְׁקַל-תַּרְנְגוֹל","a",NULL,NULL,"משקל_תרנגול","מִשְׁקַל-תַּרְנְגוֹל",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95436,"נוֹצִי","a",NULL,NULL,"נוצי","נוֹצִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95437,"מִשְׁקַל-נוֹצָה","a",NULL,NULL,"משקל_נוצה","מִשְׁקַל-נוֹצָה",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95438,"מִשְׁקַל-זְבוּב","a",NULL,NULL,"משקל_זבוב","מִשְׁקַל-זְבוּב",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95439,"קַל-מִשְׁקָל","a",NULL,NULL,"קל_משקל","קַל-מִשְׁקָל",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95440,"מִשְׁקָל-קַל","a",NULL,NULL,"מִשְׁקָל-קַל","מִשְׁקָל-קַל",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95441,"קַר","a",NULL,NULL,"קַר","קַר"," קר ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95442,"טֶמְפֶּרָטוּרָה","n",NULL,NULL,"טמפרטורה","טֶמְפֶּרָטוּרָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95443,"חַם","a",NULL,NULL,"חם","חַם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95444,"קָפוּא","a",NULL,NULL,"קפוא","קָפוּא",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95445,"צוֹנֵן","a",NULL,NULL,"צונן","צוֹנֵן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95446,"מִתְיַשֵּׁב","n",NULL,"mityashev","מתיישב","מִתְיַשֵּׁב",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95447,"מִתְנַחֵל","n",NULL,"mitnachel","מתנחל","מִתְנַחֵל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95448,"מִתְיַשֶּׁבֶת","n",NULL,"mityashevet","מתיישבת","מִתְיַשֶּׁבֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95449,"מִתְנַחֶלֶת","n",NULL,"mitnachelet","מתנחלת","מִתְנַחֶלֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95450,"מְאוֹתֵת","n",NULL,"me\'otet","מאותת","מְאוֹתֵת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95451,"קַשָּׁר","n",NULL,"kashar","קשר","קַשָּׁר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95452,"מְאוֹתֶתֶת","n",NULL,"me\'otetet","מאותתת","מְאוֹתֶתֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95453,"בִּלְתִּי-מְחֻמָּם","a",NULL,NULL,"בלתי_מחומם","בִּלְתִּי-מְחֻמָּם",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95455,"פָּצָץ","a",NULL,NULL,"פצץ","פָּצָץ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95456,"סוֹף-הַדֶּרֶךְ","a",NULL,NULL,"סוף_הדרך","סוֹף-הַדֶּרֶךְ",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95457,"דֵּי-טוֹב","a",NULL,NULL,"דֵּי-טוֹב","דֵּי-טוֹב",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95458,"מְסַפֵּק","a",NULL,NULL,"מספק","מְסַפֵּק",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95459,"מַשְׂבִּיעַ-רָצוֹן","a",NULL,NULL,"משביע_רצון","מַשְׂבִּיעַ-רָצוֹן",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95460,"הוֹלֵם","a",NULL,NULL,"הולם","הוֹלֵם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95461,"רַע","a",NULL,NULL,"רע","רַע",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95462,"יֹפִי","a",NULL,NULL,"יֹפִי","יֹפִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95463,"יופי_של","a",NULL,"yofi shel",NULL,"יופי_של",NULL,"_",NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95464,"חֲסַר-תַּקָּנָה","a",NULL,"xasar takana","חסר_תקנה","חֲסַר-תַּקָּנָה",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95465,"מְחֻרְבָּן","a",NULL,"mexurban","מחורבן","מְחֻרְבָּן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95466,"מְתַקֵּן","n",NULL,"metaken","מתקן","מְתַקֵּן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95467,"רֶפוֹרְמָטוֹר","n",NULL,"reformator","רפורמטור","רֶפוֹרְמָטוֹר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95468,"מְתַקֶּנֶת","n",NULL,"metakenet","מתקנת","מְתַקֶּנֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95469,"מַהְפְּכָן","n",NULL,"mahapchan","מהפכן","מַהְפְּכָן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95470,"רֶבוֹלוּצְיוֹנֶר","n",NULL,"revolutzyoner","רבולוציונר","רֶבוֹלוּצְיוֹנֶר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95471,"מַהְפְּכָנִית","n",NULL,"mahapchanit","מהפכנית","מַהְפְּכָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95472,"רֶבוֹלוּצְיוֹנֶרִית","n",NULL,"revolutzyonerit","רבולוציונרית","רֶבוֹלוּצְיוֹנֶרִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95473,"מַבְרִיחַ","n",NULL,"mavri\'ach","מבריח","מַבְרִיחַ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95474,"מַבְרִיחָה","n",NULL,"mavricha","מבריחה","מַבְרִיחָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95475,"רוֹפֵא-מֻמְחֶה","n",NULL,"rofe-mumche","רופא-מומחה","רוֹפֵא-מֻמְחֶה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95476,"מָנוּי","n",NULL,"manuy","מנוי","מָנוּי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95477,"מְנוּיָה","n",NULL,"menuya","מנויה","מְנוּיָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95478,"חִיּוּבִי","a",NULL,"xiyuvi","חיובי","חִיּוּבִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95479,"שְׁלִילִי","a",NULL,"shlili","שלילי","שְׁלִילִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95480,"פּוֹזִיטִיבִי","a",NULL,"positivi","פוזיטיבי","פּוֹזִיטִיבִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95481,"נלהב","a",NULL,"nilhav",NULL,"נלהב",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95482,"קוֹנְסְטְרוּקְטִיבִי","a",NULL,"konstruktivi","קונסטרוקטיבי","קוֹנְסְטְרוּקְטִיבִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95483,"בּוֹנֶה","a",NULL,"boneh","בונה","בּוֹנֶה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95484,"נֵיטְרָלִי","a",NULL,"netrali","ניטרלי","נֵיטְרָלִי"," נייטרלי ; ניטראלי ; נייטראלי ",NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95485,"חֲסַר-דֵּעָה","a",NULL,NULL,"חֲסַר-דֵּעָה","חֲסַר-דֵּעָה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95486,"נגדי","a",NULL,"negdi",NULL,"נגדי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95487,"לֹא","a",NULL,NULL,"לֹא","לֹא",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95488,"מְחַבֵּל","n",NULL,"mechabel","מחבל","מְחַבֵּל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95489,"טֶרוֹרִיסְט","n",NULL,"terorist","טרוריסט","טֶרוֹרִיסְט",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95490,"מְחַבֶּלֶת","n",NULL,"mechabelet","מחבלת","מְחַבֶּלֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95491,"טֶרוֹרִיסְטִית","n",NULL,"teroristit","טרוריסטית","טֶרוֹרִיסְטִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95492,"מִתְלַמֵּד","n",NULL,"mitlamed","מתלמד","מִתְלַמֵּד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95493,"מִתְלַמֶּדֶת","n",NULL,"mitlamedet","מתלמדת","מִתְלַמֶּדֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95494,"מִתְנַדֵּב","n",NULL,"mitnadev","מתנדב","מִתְנַדֵּב",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95495,"מִתְנַדֶּבֶת","n",NULL,"mitnadevet","מתנדבת","מִתְנַדֶּבֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95496,"שַׁמָּשׁ","n",NULL,"shamash","שמש","שַׁמָּשׁ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95497,"עוֹבֵד-צִבּוּר","n",NULL,"oved tsibur","עובד_ציבור","עוֹבֵד-צִבּוּר",NULL,"-","_",NULL);
INSERT INTO hebrew_morpho VALUES (95498,"עוֹבֵד","n",NULL,"oved","עובד","עוֹבֵד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95499,"מֶלְצַר","n",NULL,"meltzar","מלצר","מֶלְצַר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95500,"מֶלְצָרִית","n",NULL,"meltzarit","מלצרית","מֶלְצָרִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95501,"נוֹכְחִי","a",NULL,"nochechi","נוכחי","נוֹכְחִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95502,"נוֹתָר","a",NULL,"notar","נותר","נוֹתָר",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95503,"נִלְהָב","a",NULL,"nilhav","נלהב","נִלְהָב",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95504,"מֻגְבָּל","a",NULL,"mugbal","מוגבל","מֻגְבָּל",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95505,"נָטוּי","a",NULL,"natuy","נטוי","נָטוּי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95506,"מֻטֶּה","a",NULL,"mute","מוטה","מֻטֶּה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95507,"נָשִׁי","a",NULL,"nashi","נשי","נָשִׁי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95508,"נְבוּאִי","a",NULL,"nevu\'ee","נבואי","נְבוּאִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95509,"מְמֻקָּם","a",NULL,"memukam","ממוקם","מְמֻקָּם",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95510,"נִקָּיוֹן","n",NULL,"nikayon","ניקיון","נִקָּיוֹן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95511,"נִקּוּי","n",NULL,"nikuy","ניקוי","נִקּוּי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95512,"נְדִידָה","n",NULL,"nedida","נדידה","נְדִידָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95513,"נַיֶּרֶת","n",NULL,"nayeret","ניירת","נַיֶּרֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95514,"נַגָּד","n",NULL,"nagad","נגד","נַגָּד",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95515,"נְעִירָה","n",NULL,"ne\'ira","נעירה","נְעִירָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95516,"חֲוָיָה","n",NULL,"chavaya","חוויה","חֲוָיָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95517,"חַט","n",NULL,"chat","חט","חַט",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95518,"אֲרוּחָה-קַלָּה","n",NULL,"arucha-kala","ארוחה-קלה","אֲרוּחָה-קַלָּה",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95519,"נִשְׁנוּשׁ","n",NULL,"nishnush","נשנוש","נִשְׁנוּשׁ",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95520,"נְגִיסָה","n",NULL,"negisa","נגיסה","נְגִיסָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95521,"בִּיס","n",NULL,"bis","ביס","בִּיס",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95522,"הָעוֹלָם-הַנּוֹצְרִי","n",NULL,"ha\'olam-hanotzri","העולם-הנוצרי","הָעוֹלָם-הַנּוֹצְרִי",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95523,"נְסִיכוּת","n",NULL,"nesichut","נסיכות","נְסִיכוּת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95524,"דִּירֶקְטוֹרְיוֹן","n",NULL,"direktoryon","דירקטוריון","דִּירֶקְטוֹרְיוֹן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95525,"מוֹעֶצֶת-מְנַהֲלִים","n",NULL,"mo\'etzet-menahalim","מועצת-מנהלים","מוֹעֶצֶת-מְנַהֲלִים",NULL,"-","-",NULL);
INSERT INTO hebrew_morpho VALUES (95526,"נוֹאֵף","n",NULL,"no\'ef","נואף","נוֹאֵף",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95527,"נַפָּח","n",NULL,"napach","נפח","נַפָּח",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95528,"נַבְלָן","n",NULL,"navlan","נבלן","נַבְלָן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95529,"נַבְלַאי","n",NULL,"navlay","נבלאי","נַבְלַאי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95530,"אִימְפֶּרְסוֹנָלִי","a",NULL,"impersonali","אימפרסונאלי","אִימְפֶּרְסוֹנָלִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95531,"סְלִילִי","a",NULL,"slili","סלילי","סְלִילִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95532,"לוּלְיָנִי","a",NULL,"lulyani","לולייני","לוּלְיָנִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95533,"סְפִּירָלִי","a",NULL,"spirali","ספירלי","סְפִּירָלִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95534,"סָרוּג","a",NULL,"sarug","סרוג","סָרוּג",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95535,"סְקִירָה","n",NULL,"skira","סקירה","סְקִירָה",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95536,"סַיָּף","n",NULL,"sayaf","סייף","סַיָּף",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95537,"סַיֶּפֶת","n",NULL,"sayefet","סייפת","סַיֶּפֶת",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95538,"אוֹפּוֹרְטוּנִיסְט","n",NULL,"oportunist","אופורטוניסט","אוֹפּוֹרְטוּנִיסְט",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95539,"אוֹפּוֹרְטוּנִיסְטִית","n",NULL,"oportunistit","אופורטוניסטית","אוֹפּוֹרְטוּנִיסְטִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95540,"סוֹלָן","n",NULL,"solan","סולן","סוֹלָן",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95541,"סוֹלָנִית","n",NULL,"solanit","סולנית","סוֹלָנִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95542,"סוֹלִיסְטִית","n",NULL,"solistit","סוליסטית","סוֹלִיסְטִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95543,"סוֹלִיסְט","n",NULL,"solist","סוליסט","סוֹלִיסְט",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95544,"סַפָּק","n",NULL,"sapak","ספק","סַפָּק",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95545,"סַפָּקִית","n",NULL,"sapakit","ספקית","סַפָּקִית",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95546,"עִלִּי","a",NULL,"ili","עילי","עִלִּי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95547,"עִתּוֹנָאִי","a",NULL,"itona\'i","עיתונאי","עִתּוֹנָאִי",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95548,"עָרֵב","n",NULL,"arev","ערב","עָרֵב",NULL,NULL,NULL,NULL);
INSERT INTO hebrew_morpho VALUES (95549,"עֲרֵבָהּ","n",NULL,"areva","ערבה","עֲרֵבָהּ",NULL,NULL,NULL,NULL);
