import * as s3 from '@aws-cdk/aws-s3';
import * as cdk from '@aws-cdk/core';
export declare enum ReplicationDestinationStorageClass {
    DEEP_ARCHIVE = "DEEP_ARCHIVE",
    GLACIER = "GLACIER",
    INTELLIGENT_TIERING = "INTELLIGENT_TIERING",
    ONEZONE_IA = "ONEZONE_IA",
    OUTPOSTS = "OUTPOSTS",
    REDUCED_REDUNDANCY = "REDUCED_REDUNDANCY",
    STANDARD = "STANDARD",
    STANDARD_IA = "STANDARD_IA"
}
export declare enum ReplicationRuleStatus {
    DISABLED = "Disabled",
    ENABLED = "Enabled"
}
export interface ReplicationRulePropertyNoDestination {
    readonly status?: ReplicationRuleStatus;
    readonly deleteMarkerReplication?: cdk.IResolvable | s3.CfnBucket.DeleteMarkerReplicationProperty;
    readonly filter?: cdk.IResolvable | s3.CfnBucket.ReplicationRuleFilterProperty;
    readonly id?: string;
    readonly prefix?: string;
    readonly priority?: number;
    readonly sourceSelectionCriteria?: cdk.IResolvable | s3.CfnBucket.SourceSelectionCriteriaProperty;
}
export interface ReplicationDestinationPropertyNoBucket {
    readonly accessControlTranslation?: cdk.IResolvable | s3.CfnBucket.AccessControlTranslationProperty;
    readonly account?: string;
    readonly encryptionConfiguration?: cdk.IResolvable | s3.CfnBucket.EncryptionConfigurationProperty;
    readonly metrics?: cdk.IResolvable | s3.CfnBucket.MetricsProperty;
    readonly replicationTime?: cdk.IResolvable | s3.CfnBucket.ReplicationTimeProperty;
    readonly storageClass?: ReplicationDestinationStorageClass;
}
export interface BucketReplicationProps {
    readonly sourceBucket: s3.IBucket;
    readonly destinationBucket: s3.IBucket;
    readonly replicationRuleProperties?: ReplicationRulePropertyNoDestination;
    readonly replicationDestinationProperties?: ReplicationDestinationPropertyNoBucket;
}
export declare class BucketReplication extends cdk.Construct {
    constructor(scope: cdk.Construct, id: string, props: BucketReplicationProps);
}
