from asyncpg import Connection

from . import upgrade_table


@upgrade_table.register(description="Add index to reaction table")
async def upgrade_v5(conn: Connection):
    add_index_queries = [
        """
        ALTER TABLE reaction ADD COLUMN index INTEGER
        """,
        # Give everything an index based on row number
        """
        UPDATE reaction
           SET index = t.rownum
          FROM (SELECT mxid, mx_room, ROW_NUMBER() OVER () AS rownum
                  FROM reaction) t
         WHERE reaction.mxid = t.mxid
           AND reaction.mx_room = t.mx_room
        """,
        # Make the new column SERIAL
        """
        ALTER TABLE reaction ALTER COLUMN index SET NOT NULL
        """,
        """
        ALTER TABLE reaction ALTER COLUMN index ADD GENERATED BY DEFAULT AS IDENTITY
        """,
    ]

    for query in add_index_queries:
        await conn.execute(query)
