# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['hammurabi',
 'hammurabi.notifications',
 'hammurabi.preconditions',
 'hammurabi.reporters',
 'hammurabi.rules']

package_data = \
{'': ['*']}

install_requires = \
['github3.py>=1.3.0,<2.0.0',
 'gitpython>=3.0.5,<4.0.0',
 'pydantic>=1.4,<2.0',
 'toml>=0.10.1,<0.11.0',
 'typer>=0.3.1,<0.4.0']

extras_require = \
{'all': ['ruamel.yaml>=0.16.5,<0.17.0',
         'configupdater>=1.0.1,<2.0.0',
         'jinja2>=2.11.1,<3.0.0',
         'slack-webhook>=1.0.3,<2.0.0',
         'ujson>=1.35,<5.0'],
 'ini': ['configupdater>=1.0.1,<2.0.0'],
 'slack-notifications': ['slack-webhook>=1.0.3,<2.0.0'],
 'templating': ['jinja2>=2.11.1,<3.0.0'],
 'ujson': ['ujson>=1.35,<5.0'],
 'yaml': ['ruamel.yaml>=0.16.5,<0.17.0']}

entry_points = \
{'console_scripts': ['hammurabi = hammurabi.main:app']}

setup_kwargs = {
    'name': 'hammurabi',
    'version': '0.11.1',
    'description': 'Hammurabi is an extensible CLI tool responsible for enforcing user-defined rules on a git repository.',
    'long_description': 'Hammurabi\n*********\n\n.. image:: https://img.shields.io/pypi/v/hammurabi.svg\n    :target: https://pypi.python.org/pypi/hammurabi\n    :alt: PyPi Package\n\n.. image:: https://travis-ci.org/gabor-boros/hammurabi.svg?branch=master\n    :target: https://travis-ci.org/gabor-boros/hammurabi\n    :alt: Build Status\n\n.. image:: https://readthedocs.org/projects/hammurabi/badge/?version=latest\n    :target: https://hammurabi.readthedocs.io/en/latest/?badge=latest\n    :alt: Documentation Status\n\n.. image:: https://api.codeclimate.com/v1/badges/bcebab7105dfd82f358b/maintainability\n   :target: https://codeclimate.com/github/gabor-boros/hammurabi/maintainability\n   :alt: Maintainability\n\n.. image:: https://api.codeclimate.com/v1/badges/bcebab7105dfd82f358b/test_coverage\n    :target: https://codeclimate.com/github/gabor-boros/hammurabi/test_coverage\n    :alt: Test Coverage\n\n.. image:: https://img.shields.io/badge/code%20style-black-000000.svg\n    :target: https://github.com/ambv/black\n    :alt: Black Formatted\n\n.. image:: https://bestpractices.coreinfrastructure.org/projects/3587/badge\n    :target: https://bestpractices.coreinfrastructure.org/projects/3587\n    :alt: CII Best Practices\n\n\nMass changes made easy.\n\nHammurabi is an extensible CLI tool responsible for enforcing user-defined rules\non a git repository.\n\nFeatures\n========\n\nHammurabi integrates well with both git and Github to make sure that the\nexecution happens on a separate branch and the committed changes are pushed\nto the target repository. After pushing to the target repository, a pull\nrequest will be opened.\n\nHammurabi supports several operations (Rules) by default. These Rules can do\n\n* file and directory operations like copy, move, create or delete\n* manipulation of attributes like ownership or access permissions change\n* file and directory manipulations\n* piped rule execution (output of a rule is the input of the next rule)\n* children rule execution (output of a rule is the input of the upcoming rules)\n* creating files from Jinja2 templates\n* send notification on git push\n\nSupported file formats:\n\n* ``plain text``\n* ``ini``\n* ``json``\n* ``yaml`` (basic, single document operations)\n* ``toml``\n\nUpcoming file format support:\n\n* ``hocon``\n\nCommunity\n=========\n\nIf you need help or you would like to be part of the Hammurabi community, join us on discord_.\n\n.. _discord: https://discord.gg/dj8Myk5\n\nInstallation\n============\n\nHammurabi can be installed by running ``pip install hammurabi`` and it requires\nPython 3.7.0+ to run. This is the preferred method to install Hammurabi, as it\nwill always install the most recent stable release. If you don\'t have `pip`_\ninstalled, this `Python installation guide`_ can guide\nyou through the process.\n\n.. _pip: https://pip.pypa.io\n.. _Python installation guide: http://docs.python-guide.org/en/latest/starting/installation/\n\nInstalling extras\n-----------------\n\nHammurabi tries to be as tiny as its possible, hence some rules are requiring extra\ndependencies to be installed. Please check the documentation of the Rules to know\nwhich dependency is required to use the specific rule.\n\nTo install hammurabi with an extra package run ``pip install hammurabi[<EXTRA>]``,\nwhere ``<EXTRA>`` is the name of the extra option. To install multiple extra packages\nlist the extra names separated by comma as described in `pip\'s examples`_ section point\nnumber six.\n\n+---------------------+--------------------------------------------+\n| Extra               | Description                                |\n+=====================+============================================+\n| all                 | alias to install all the extras available  |\n+---------------------+--------------------------------------------+\n| ini                 | needed for ini/cfg based rules             |\n+---------------------+--------------------------------------------+\n| ujson               | install if you need faster json manipulat  |\n+---------------------+--------------------------------------------+\n| yaml                | needed for yaml based rules                |\n+---------------------+--------------------------------------------+\n| templating          | needed for rules which are using templates |\n+---------------------+--------------------------------------------+\n| slack-notifications | needed for slack webhook notifications     |\n+---------------------+--------------------------------------------+\n\n.. _`pip\'s examples`: https://pip.pypa.io/en/stable/reference/pip_install/#examples\n\nConfiguration\n=============\n\nFor configuration instructions, please visit the documentation_ site.\n\n.. _documentation: https://hammurabi.readthedocs.io/en/latest/config.html\n\nUsage examples\n==============\n\nIn every case, make sure that you clone the target repository prior using Hammurabi.\nAfter cloning the repository, always set the current working directory to the target\'s\npath. Hammurabi will not clone the target repository or change its execution directory.\n\nEnforce registered laws\n-----------------------\n\n.. code-block:: bash\n\n    $ hammurabi enforce\n    [INFO]  2020-14-07 16:31 - Checkout branch "hammurabi"\n    [INFO]  2020-14-07 16:31 - Executing law "L001"\n    [INFO]  2020-14-07 16:31 - Running task for "configure file exists"\n    [INFO]  2020-14-07 16:31 - Rule "configure file exists" finished successfully\n    [INFO]  2020-14-07 16:31 - Running task for "Minimum clang version is set"\n    [INFO]  2020-14-07 16:31 - Rule "Minimum clang version is set" finished successfully\n    [INFO]  2020-14-07 16:31 - Running task for "Minimum icc version is set"\n    [INFO]  2020-14-07 16:31 - Rule "Minimum icc version is set" finished successfully\n    [INFO]  2020-14-07 16:31 - Running task for "Minimum lessc version is set"\n    [INFO]  2020-14-07 16:31 - Rule "Minimum lessc version is set" finished successfully\n    [INFO]  2020-14-07 16:31 - Running task for "Maximum lessc version is set"\n    [INFO]  2020-14-07 16:31 - Rule "Maximum lessc version is set" finished successfully\n    [INFO]  2020-14-07 16:31 - Pushing changes\n    [INFO]  2020-14-07 16:35 - Checking for opened pull request\n    [INFO]  2020-14-07 16:35 - Opening pull request\n\nCustom Rules\n============\n\nAlthough the project aims to support as many general operations as it can,\nthe need for adding custom rules may arise.\n\nTo extend Hammurabi with custom rules, you will need to inherit a class\nfrom ``Rule`` and define its abstract methods.\n\nThe following example will show you how to create and use a custom rule.\nFor more reference please check how the existing rules are implemented.\n\n.. code-block:: python\n\n    # custom.py\n    import shutil\n    import logging\n    from hammurabi.mixins import GitMixin\n    from hammurabi.rules.base import Rule\n\n\n    class CustomOwnerChanged(Rule, GitMixin):\n        """\n        Change the ownership of a file or directory to <original user>:admin.\n        """\n\n        def __init__(self, name: str, path: Optional[Path] = None, **kwargs):\n            super().__init__(name, path, **kwargs)\n\n        def post_task_hook(self):\n            self.git_add(self.param)\n\n        def task(self) -> Path:\n            # Since ``Rule`` is setting its 2nd parameter to ``self.param``,\n            # we can use ``self.param`` to access the target file\'s path.\n            logging.debug(\'Changing group of "%s" to admin\', str(self.param))\n            shutil.chown(self.param, group="admin")\n            return self.param\n\nCustom Preconditions\n====================\n\nRule execution supports preconditions. The logic is simple: if all preconditions\npass, the rule is executed. Otherwise it will be skipped.\n\n.. code-block:: python\n\n    # custom.py\n    from hammurabi import IsLineExists\n\n\n    class IsPackage(IsLineExists):\n        def __init__(self, **kwargs):\n            super().__init__(path=Path("Jenkinsfile"), criteria="package", **kwargs)\n\nCommand line options\n====================\n\n.. code-block:: bash\n\n    Usage: hammurabi [OPTIONS] COMMAND [ARGS]...\n\n    Hammurabi is an extensible CLI tool responsible for enforcing user-defined\n    rules on a git repository.\n\n    Find more information at: https://hammurabi.readthedocs.io/latest/\n\n    Options:\n    -c, --config PATH               Set the configuration file.  [default:\n                                    pyproject.toml]\n\n    --repository TEXT               Set the remote repository. Required format:\n                                    owner/repository.  [default: ]\n\n    --token TEXT                    Set github access token.  [default: ]\n    --log-level [DEBUG|INFO|WARNING|ERROR]\n                                    Set logging level.  [default: INFO]\n    --install-completion [bash|zsh|fish|powershell|pwsh]\n                                    Install completion for the specified shell.\n    --show-completion [bash|zsh|fish|powershell|pwsh]\n                                    Show completion for the specified shell, to\n                                    copy it or customize the installation.\n\n    --help                          Show this message and exit.\n\n    Commands:\n    enforce  Execute registered laws.\n    version  Print hammurabi version.\n\nContributing\n============\n\nHurray, You reached this section, which means you are ready\nto contribute.\n\nPlease read our contibuting guideline_. This guideline will\nwalk you through how can you successfully contribute to\nHammurabi.\n\n.. _guideline: https://github.com/gabor-boros/hammurabi/blob/master/CONTRIBUTING.rst\n\nInstallation\n------------\n\nFor development you will need poetry_ and pre-commit_. After poetry installed,\nsimply run `poetry install -E all`. This command will both create the virtualenv\nand install all development dependencies for you.\n\n.. _poetry: https://python-poetry.org/docs/#installation\n.. _pre-commit: https://pre-commit.com/#install\n\n\nUseful make Commands\n--------------------\n\n+------------------+-------------------------------------+\n| Command          | Description                         |\n+==================+=====================================+\n| help             | Print available make commands       |\n+------------------+-------------------------------------+\n| clean            | Remove all artifacts                |\n+------------------+-------------------------------------+\n| clean-build      | Remove build artifacts              |\n+------------------+-------------------------------------+\n| clean-mypy       | Remove mypy artifacts               |\n+------------------+-------------------------------------+\n| clean-pyc        | Remove Python artifacts             |\n+------------------+-------------------------------------+\n| clean-test       | Remove test artifacts               |\n+------------------+-------------------------------------+\n| docs             | Generate Sphinx documentation       |\n+------------------+-------------------------------------+\n| format           | Run several formatters              |\n+------------------+-------------------------------------+\n| lint             | Run several linters after format    |\n+------------------+-------------------------------------+\n| test             | Run all tests with coverage         |\n+------------------+-------------------------------------+\n| test-unit        | Run unit tests with coverage        |\n+------------------+-------------------------------------+\n| test-integration | Run integration tests with coverage |\n+------------------+-------------------------------------+\n\nWhy Hammurabi?\n==============\n\nHammurabi was the sixth king in the Babylonian dynasty,\nwhich ruled in central Mesopotamia from c. 1894 to 1595 B.C.\n\nThe Code of Hammurabi was one of the earliest and most\ncomplete written legal codes and was proclaimed by the\nBabylonian king Hammurabi, who reigned from 1792 to 1750 B.C.\nHammurabi expanded the city-state of Babylon along the Euphrates\nRiver to unite all of southern Mesopotamia. The Hammurabi code\nof laws, a collection of 282 rules, established standards for\ncommercial interactions and set fines and punishments to meet\nthe requirements of justice. Hammurabi’s Code was carved onto\na massive, finger-shaped black stone stele (pillar) that was\nlooted by invaders and finally rediscovered in 1901.\n',
    'author': 'Gábor Boros',
    'author_email': 'gabor.brs@gmail.com',
    'maintainer': 'Gábor Boros',
    'maintainer_email': 'gabor.brs@gmail.com',
    'url': 'https://github.com/gabor-boros/hammurabi/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
