# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pulpcore.client.pulp_ansible.configuration import Configuration


class CollectionVersionCopyMove(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'collection_versions': 'list[str]',
        'destination_repositories': 'list[str]',
        'signing_service': 'str'
    }

    attribute_map = {
        'collection_versions': 'collection_versions',
        'destination_repositories': 'destination_repositories',
        'signing_service': 'signing_service'
    }

    def __init__(self, collection_versions=None, destination_repositories=None, signing_service=None, local_vars_configuration=None):  # noqa: E501
        """CollectionVersionCopyMove - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._collection_versions = None
        self._destination_repositories = None
        self._signing_service = None
        self.discriminator = None

        self.collection_versions = collection_versions
        self.destination_repositories = destination_repositories
        if signing_service is not None:
            self.signing_service = signing_service

    @property
    def collection_versions(self):
        """Gets the collection_versions of this CollectionVersionCopyMove.  # noqa: E501

        A list of collection versions to move or copy.  # noqa: E501

        :return: The collection_versions of this CollectionVersionCopyMove.  # noqa: E501
        :rtype: list[str]
        """
        return self._collection_versions

    @collection_versions.setter
    def collection_versions(self, collection_versions):
        """Sets the collection_versions of this CollectionVersionCopyMove.

        A list of collection versions to move or copy.  # noqa: E501

        :param collection_versions: The collection_versions of this CollectionVersionCopyMove.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and collection_versions is None:  # noqa: E501
            raise ValueError("Invalid value for `collection_versions`, must not be `None`")  # noqa: E501

        self._collection_versions = collection_versions

    @property
    def destination_repositories(self):
        """Gets the destination_repositories of this CollectionVersionCopyMove.  # noqa: E501

        List of repository HREFs to put content in.  # noqa: E501

        :return: The destination_repositories of this CollectionVersionCopyMove.  # noqa: E501
        :rtype: list[str]
        """
        return self._destination_repositories

    @destination_repositories.setter
    def destination_repositories(self, destination_repositories):
        """Sets the destination_repositories of this CollectionVersionCopyMove.

        List of repository HREFs to put content in.  # noqa: E501

        :param destination_repositories: The destination_repositories of this CollectionVersionCopyMove.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and destination_repositories is None:  # noqa: E501
            raise ValueError("Invalid value for `destination_repositories`, must not be `None`")  # noqa: E501

        self._destination_repositories = destination_repositories

    @property
    def signing_service(self):
        """Gets the signing_service of this CollectionVersionCopyMove.  # noqa: E501

        HREF for a signing service. This will be used to sign the collection before moving putting it in any new repositories.  # noqa: E501

        :return: The signing_service of this CollectionVersionCopyMove.  # noqa: E501
        :rtype: str
        """
        return self._signing_service

    @signing_service.setter
    def signing_service(self, signing_service):
        """Sets the signing_service of this CollectionVersionCopyMove.

        HREF for a signing service. This will be used to sign the collection before moving putting it in any new repositories.  # noqa: E501

        :param signing_service: The signing_service of this CollectionVersionCopyMove.  # noqa: E501
        :type: str
        """

        self._signing_service = signing_service

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CollectionVersionCopyMove):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CollectionVersionCopyMove):
            return True

        return self.to_dict() != other.to_dict()
