# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pulpcore.client.pulp_ansible.api_client import ApiClient
from pulpcore.client.pulp_ansible.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class PulpAnsibleApiV3PluginAnsibleSearchCollectionVersionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def list(self, path,  **kwargs):  # noqa: E501
        """list  # noqa: E501

        A viewset for cross-repo searches.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list(path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str path: (required)
        :param str dependency:
        :param bool deprecated:
        :param list[str] distribution: Filter collectionversions that are in these distrubtion ids.
        :param list[str] distribution_base_path: Filter collectionversions that are in these base paths.
        :param bool highest:
        :param bool is_deprecated:
        :param bool is_highest:
        :param bool is_signed:
        :param str keywords:
        :param int limit: Number of results to return per page.
        :param str name:
        :param str namespace:
        :param int offset: The initial index from which to return the results.
        :param list[str] order_by: Ordering  * `pulp_created` - by CV created * `-pulp_created` - by CV created (descending) * `namespace` - by CV namespace * `-namespace` - by CV namespace (descending) * `name` - by CV name * `-name` - by CV name (descending) * `version` - by CV version * `-version` - by CV version (descending)
        :param str q:
        :param list[str] repository: Filter collectionversions that are in these repository ids.
        :param str repository_label: Filter labels by search string
        :param list[str] repository_name: Filter collectionversions that are in these repositories.
        :param str repository_version:
        :param bool signed:
        :param str tags: Filter by comma separate list of tags that must all be matched
        :param str version:
        :param str version_range:
        :param list[str] fields: A list of fields to include in the response.
        :param list[str] exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PaginatedCollectionVersionSearchListResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_with_http_info(path,  **kwargs)  # noqa: E501

    def list_with_http_info(self, path,  **kwargs):  # noqa: E501
        """list  # noqa: E501

        A viewset for cross-repo searches.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_with_http_info(path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str path: (required)
        :param str dependency:
        :param bool deprecated:
        :param list[str] distribution: Filter collectionversions that are in these distrubtion ids.
        :param list[str] distribution_base_path: Filter collectionversions that are in these base paths.
        :param bool highest:
        :param bool is_deprecated:
        :param bool is_highest:
        :param bool is_signed:
        :param str keywords:
        :param int limit: Number of results to return per page.
        :param str name:
        :param str namespace:
        :param int offset: The initial index from which to return the results.
        :param list[str] order_by: Ordering  * `pulp_created` - by CV created * `-pulp_created` - by CV created (descending) * `namespace` - by CV namespace * `-namespace` - by CV namespace (descending) * `name` - by CV name * `-name` - by CV name (descending) * `version` - by CV version * `-version` - by CV version (descending)
        :param str q:
        :param list[str] repository: Filter collectionversions that are in these repository ids.
        :param str repository_label: Filter labels by search string
        :param list[str] repository_name: Filter collectionversions that are in these repositories.
        :param str repository_version:
        :param bool signed:
        :param str tags: Filter by comma separate list of tags that must all be matched
        :param str version:
        :param str version_range:
        :param list[str] fields: A list of fields to include in the response.
        :param list[str] exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PaginatedCollectionVersionSearchListResponseList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'path',
            'dependency',
            'deprecated',
            'distribution',
            'distribution_base_path',
            'highest',
            'is_deprecated',
            'is_highest',
            'is_signed',
            'keywords',
            'limit',
            'name',
            'namespace',
            'offset',
            'order_by',
            'q',
            'repository',
            'repository_label',
            'repository_name',
            'repository_version',
            'signed',
            'tags',
            'version',
            'version_range',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and ('path' not in local_var_params or  # noqa: E501
                                                        local_var_params['path'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `path` when calling `list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'path' in local_var_params:
            path_params['path'] = local_var_params['path']  # noqa: E501

        query_params = []
        if 'dependency' in local_var_params and local_var_params['dependency'] is not None:  # noqa: E501
            query_params.append(('dependency', local_var_params['dependency']))  # noqa: E501
        if 'deprecated' in local_var_params and local_var_params['deprecated'] is not None:  # noqa: E501
            query_params.append(('deprecated', local_var_params['deprecated']))  # noqa: E501
        if 'distribution' in local_var_params and local_var_params['distribution'] is not None:  # noqa: E501
            query_params.append(('distribution', local_var_params['distribution']))  # noqa: E501
            collection_formats['distribution'] = 'multi'  # noqa: E501
        if 'distribution_base_path' in local_var_params and local_var_params['distribution_base_path'] is not None:  # noqa: E501
            query_params.append(('distribution_base_path', local_var_params['distribution_base_path']))  # noqa: E501
            collection_formats['distribution_base_path'] = 'multi'  # noqa: E501
        if 'highest' in local_var_params and local_var_params['highest'] is not None:  # noqa: E501
            query_params.append(('highest', local_var_params['highest']))  # noqa: E501
        if 'is_deprecated' in local_var_params and local_var_params['is_deprecated'] is not None:  # noqa: E501
            query_params.append(('is_deprecated', local_var_params['is_deprecated']))  # noqa: E501
        if 'is_highest' in local_var_params and local_var_params['is_highest'] is not None:  # noqa: E501
            query_params.append(('is_highest', local_var_params['is_highest']))  # noqa: E501
        if 'is_signed' in local_var_params and local_var_params['is_signed'] is not None:  # noqa: E501
            query_params.append(('is_signed', local_var_params['is_signed']))  # noqa: E501
        if 'keywords' in local_var_params and local_var_params['keywords'] is not None:  # noqa: E501
            query_params.append(('keywords', local_var_params['keywords']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'namespace' in local_var_params and local_var_params['namespace'] is not None:  # noqa: E501
            query_params.append(('namespace', local_var_params['namespace']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'order_by' in local_var_params and local_var_params['order_by'] is not None:  # noqa: E501
            query_params.append(('order_by', local_var_params['order_by']))  # noqa: E501
            collection_formats['order_by'] = 'csv'  # noqa: E501
        if 'q' in local_var_params and local_var_params['q'] is not None:  # noqa: E501
            query_params.append(('q', local_var_params['q']))  # noqa: E501
        if 'repository' in local_var_params and local_var_params['repository'] is not None:  # noqa: E501
            query_params.append(('repository', local_var_params['repository']))  # noqa: E501
            collection_formats['repository'] = 'multi'  # noqa: E501
        if 'repository_label' in local_var_params and local_var_params['repository_label'] is not None:  # noqa: E501
            query_params.append(('repository_label', local_var_params['repository_label']))  # noqa: E501
        if 'repository_name' in local_var_params and local_var_params['repository_name'] is not None:  # noqa: E501
            query_params.append(('repository_name', local_var_params['repository_name']))  # noqa: E501
            collection_formats['repository_name'] = 'multi'  # noqa: E501
        if 'repository_version' in local_var_params and local_var_params['repository_version'] is not None:  # noqa: E501
            query_params.append(('repository_version', local_var_params['repository_version']))  # noqa: E501
        if 'signed' in local_var_params and local_var_params['signed'] is not None:  # noqa: E501
            query_params.append(('signed', local_var_params['signed']))  # noqa: E501
        if 'tags' in local_var_params and local_var_params['tags'] is not None:  # noqa: E501
            query_params.append(('tags', local_var_params['tags']))  # noqa: E501
        if 'version' in local_var_params and local_var_params['version'] is not None:  # noqa: E501
            query_params.append(('version', local_var_params['version']))  # noqa: E501
        if 'version_range' in local_var_params and local_var_params['version_range'] is not None:  # noqa: E501
            query_params.append(('version_range', local_var_params['version_range']))  # noqa: E501
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501
            collection_formats['exclude_fields'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/search/collection-versions/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginatedCollectionVersionSearchListResponseList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def rebuild(self, path, collection_version_search_list,  **kwargs):  # noqa: E501
        """rebuild  # noqa: E501

        A viewset for cross-repo searches.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rebuild(path, collection_version_search_list, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str path: (required)
        :param CollectionVersionSearchList collection_version_search_list: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionVersionSearchListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.rebuild_with_http_info(path, collection_version_search_list,  **kwargs)  # noqa: E501

    def rebuild_with_http_info(self, path, collection_version_search_list,  **kwargs):  # noqa: E501
        """rebuild  # noqa: E501

        A viewset for cross-repo searches.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rebuild_with_http_info(path, collection_version_search_list, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str path: (required)
        :param CollectionVersionSearchList collection_version_search_list: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionVersionSearchListResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'path',
            'collection_version_search_list'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rebuild" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and ('path' not in local_var_params or  # noqa: E501
                                                        local_var_params['path'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `path` when calling `rebuild`")  # noqa: E501
        # verify the required parameter 'collection_version_search_list' is set
        if self.api_client.client_side_validation and ('collection_version_search_list' not in local_var_params or  # noqa: E501
                                                        local_var_params['collection_version_search_list'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `collection_version_search_list` when calling `rebuild`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'path' in local_var_params:
            path_params['path'] = local_var_params['path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'collection_version_search_list' in local_var_params:
            body_params = local_var_params['collection_version_search_list']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/search/collection-versions/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CollectionVersionSearchListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
