# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pulpcore.client.pulp_ansible.api_client import ApiClient
from pulpcore.client.pulp_ansible.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class PulpAnsibleApiV3PluginAnsibleContentNamespacesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create(self, distro_base_path, path, name,  **kwargs):  # noqa: E501
        """create  # noqa: E501

        Provides the authentication and permission classes from settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create(distro_base_path, path, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str distro_base_path: (required)
        :param str path: (required)
        :param str name: Required named, only accepts lowercase, numbers and underscores. (required)
        :param str company: Optional namespace company owner.
        :param str email: Optional namespace contact email.
        :param str description: Optional short description.
        :param str resources: Optional resource page in markdown format.
        :param list[NamespaceLink] links: Labeled related links.
        :param file avatar: Optional avatar image for Namespace
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_with_http_info(distro_base_path, path, name,  **kwargs)  # noqa: E501

    def create_with_http_info(self, distro_base_path, path, name,  **kwargs):  # noqa: E501
        """create  # noqa: E501

        Provides the authentication and permission classes from settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_with_http_info(distro_base_path, path, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str distro_base_path: (required)
        :param str path: (required)
        :param str name: Required named, only accepts lowercase, numbers and underscores. (required)
        :param str company: Optional namespace company owner.
        :param str email: Optional namespace contact email.
        :param str description: Optional short description.
        :param str resources: Optional resource page in markdown format.
        :param list[NamespaceLink] links: Labeled related links.
        :param file avatar: Optional avatar image for Namespace
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'distro_base_path',
            'path',
            'name',
            'company',
            'email',
            'description',
            'resources',
            'links',
            'avatar'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'distro_base_path' is set
        if self.api_client.client_side_validation and ('distro_base_path' not in local_var_params or  # noqa: E501
                                                        local_var_params['distro_base_path'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `distro_base_path` when calling `create`")  # noqa: E501
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and ('path' not in local_var_params or  # noqa: E501
                                                        local_var_params['path'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `path` when calling `create`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `create`")  # noqa: E501

        if self.api_client.client_side_validation and ('name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['name']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `name` when calling `create`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['name']) < 3):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `name` when calling `create`, length must be greater than or equal to `3`")  # noqa: E501
        if self.api_client.client_side_validation and 'name' in local_var_params and not re.search(r'^(?!.*__)[a-z]+[0-9a-z_]*$', local_var_params['name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `name` when calling `create`, must conform to the pattern `/^(?!.*__)[a-z]+[0-9a-z_]*$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('company' in local_var_params and  # noqa: E501
                                                        len(local_var_params['company']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `company` when calling `create`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('email' in local_var_params and  # noqa: E501
                                                        len(local_var_params['email']) > 256):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `email` when calling `create`, length must be less than or equal to `256`")  # noqa: E501
        if self.api_client.client_side_validation and ('description' in local_var_params and  # noqa: E501
                                                        len(local_var_params['description']) > 256):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `description` when calling `create`, length must be less than or equal to `256`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'distro_base_path' in local_var_params:
            path_params['distro_base_path'] = local_var_params['distro_base_path']  # noqa: E501
        if 'path' in local_var_params:
            path_params['path'] = local_var_params['path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in local_var_params:
            form_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'company' in local_var_params:
            form_params.append(('company', local_var_params['company']))  # noqa: E501
        if 'email' in local_var_params:
            form_params.append(('email', local_var_params['email']))  # noqa: E501
        if 'description' in local_var_params:
            form_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'resources' in local_var_params:
            form_params.append(('resources', local_var_params['resources']))  # noqa: E501
        if 'links' in local_var_params:
            form_params.append(('links', local_var_params['links']))  # noqa: E501
            collection_formats['links'] = 'csv'  # noqa: E501
        if 'avatar' in local_var_params:
            local_var_files['avatar'] = local_var_params['avatar']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete(self, distro_base_path, name, path,  **kwargs):  # noqa: E501
        """delete  # noqa: E501

        Try to remove the Namespace if no Collections under Namespace are present.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete(distro_base_path, name, path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str distro_base_path: (required)
        :param str name: (required)
        :param str path: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_with_http_info(distro_base_path, name, path,  **kwargs)  # noqa: E501

    def delete_with_http_info(self, distro_base_path, name, path,  **kwargs):  # noqa: E501
        """delete  # noqa: E501

        Try to remove the Namespace if no Collections under Namespace are present.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_with_http_info(distro_base_path, name, path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str distro_base_path: (required)
        :param str name: (required)
        :param str path: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'distro_base_path',
            'name',
            'path'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'distro_base_path' is set
        if self.api_client.client_side_validation and ('distro_base_path' not in local_var_params or  # noqa: E501
                                                        local_var_params['distro_base_path'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `distro_base_path` when calling `delete`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `delete`")  # noqa: E501
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and ('path' not in local_var_params or  # noqa: E501
                                                        local_var_params['path'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `path` when calling `delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'distro_base_path' in local_var_params:
            path_params['distro_base_path'] = local_var_params['distro_base_path']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501
        if 'path' in local_var_params:
            path_params['path'] = local_var_params['path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/{name}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list(self, distro_base_path, path,  **kwargs):  # noqa: E501
        """list  # noqa: E501

        Provides the authentication and permission classes from settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list(distro_base_path, path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str distro_base_path: (required)
        :param str path: (required)
        :param str company: Filter results where company matches value
        :param str company__contains: Filter results where company contains value
        :param str company__icontains: Filter results where company contains value
        :param str company__iexact: Filter results where company matches value
        :param list[str] company__in: Filter results where company is in a comma-separated list of values
        :param str company__iregex: Filter results where company matches regex value
        :param str company__istartswith: Filter results where company starts with value
        :param str company__regex: Filter results where company matches regex value
        :param str company__startswith: Filter results where company starts with value
        :param int limit: Number of results to return per page.
        :param str metadata_sha256: Filter results where metadata_sha256 matches value
        :param list[str] metadata_sha256__in: Filter results where metadata_sha256 is in a comma-separated list of values
        :param str name: Filter results where name matches value
        :param str name__contains: Filter results where name contains value
        :param str name__icontains: Filter results where name contains value
        :param str name__iexact: Filter results where name matches value
        :param list[str] name__in: Filter results where name is in a comma-separated list of values
        :param str name__iregex: Filter results where name matches regex value
        :param str name__istartswith: Filter results where name starts with value
        :param str name__regex: Filter results where name matches regex value
        :param str name__startswith: Filter results where name starts with value
        :param int offset: The initial index from which to return the results.
        :param list[str] ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `name` - Name * `-name` - Name (descending) * `company` - Company * `-company` - Company (descending) * `email` - Email * `-email` - Email (descending) * `description` - Description * `-description` - Description (descending) * `resources` - Resources * `-resources` - Resources (descending) * `links` - Links * `-links` - Links (descending) * `avatar_sha256` - Avatar sha256 * `-avatar_sha256` - Avatar sha256 (descending) * `metadata_sha256` - Metadata sha256 * `-metadata_sha256` - Metadata sha256 (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :param list[str] pulp_href__in: Multiple values may be separated by commas.
        :param list[str] pulp_id__in: Multiple values may be separated by commas.
        :param str q:
        :param list[str] fields: A list of fields to include in the response.
        :param list[str] exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PaginatedansibleAnsibleNamespaceMetadataResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_with_http_info(distro_base_path, path,  **kwargs)  # noqa: E501

    def list_with_http_info(self, distro_base_path, path,  **kwargs):  # noqa: E501
        """list  # noqa: E501

        Provides the authentication and permission classes from settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_with_http_info(distro_base_path, path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str distro_base_path: (required)
        :param str path: (required)
        :param str company: Filter results where company matches value
        :param str company__contains: Filter results where company contains value
        :param str company__icontains: Filter results where company contains value
        :param str company__iexact: Filter results where company matches value
        :param list[str] company__in: Filter results where company is in a comma-separated list of values
        :param str company__iregex: Filter results where company matches regex value
        :param str company__istartswith: Filter results where company starts with value
        :param str company__regex: Filter results where company matches regex value
        :param str company__startswith: Filter results where company starts with value
        :param int limit: Number of results to return per page.
        :param str metadata_sha256: Filter results where metadata_sha256 matches value
        :param list[str] metadata_sha256__in: Filter results where metadata_sha256 is in a comma-separated list of values
        :param str name: Filter results where name matches value
        :param str name__contains: Filter results where name contains value
        :param str name__icontains: Filter results where name contains value
        :param str name__iexact: Filter results where name matches value
        :param list[str] name__in: Filter results where name is in a comma-separated list of values
        :param str name__iregex: Filter results where name matches regex value
        :param str name__istartswith: Filter results where name starts with value
        :param str name__regex: Filter results where name matches regex value
        :param str name__startswith: Filter results where name starts with value
        :param int offset: The initial index from which to return the results.
        :param list[str] ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `name` - Name * `-name` - Name (descending) * `company` - Company * `-company` - Company (descending) * `email` - Email * `-email` - Email (descending) * `description` - Description * `-description` - Description (descending) * `resources` - Resources * `-resources` - Resources (descending) * `links` - Links * `-links` - Links (descending) * `avatar_sha256` - Avatar sha256 * `-avatar_sha256` - Avatar sha256 (descending) * `metadata_sha256` - Metadata sha256 * `-metadata_sha256` - Metadata sha256 (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :param list[str] pulp_href__in: Multiple values may be separated by commas.
        :param list[str] pulp_id__in: Multiple values may be separated by commas.
        :param str q:
        :param list[str] fields: A list of fields to include in the response.
        :param list[str] exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PaginatedansibleAnsibleNamespaceMetadataResponseList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'distro_base_path',
            'path',
            'company',
            'company__contains',
            'company__icontains',
            'company__iexact',
            'company__in',
            'company__iregex',
            'company__istartswith',
            'company__regex',
            'company__startswith',
            'limit',
            'metadata_sha256',
            'metadata_sha256__in',
            'name',
            'name__contains',
            'name__icontains',
            'name__iexact',
            'name__in',
            'name__iregex',
            'name__istartswith',
            'name__regex',
            'name__startswith',
            'offset',
            'ordering',
            'pulp_href__in',
            'pulp_id__in',
            'q',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'distro_base_path' is set
        if self.api_client.client_side_validation and ('distro_base_path' not in local_var_params or  # noqa: E501
                                                        local_var_params['distro_base_path'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `distro_base_path` when calling `list`")  # noqa: E501
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and ('path' not in local_var_params or  # noqa: E501
                                                        local_var_params['path'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `path` when calling `list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'distro_base_path' in local_var_params:
            path_params['distro_base_path'] = local_var_params['distro_base_path']  # noqa: E501
        if 'path' in local_var_params:
            path_params['path'] = local_var_params['path']  # noqa: E501

        query_params = []
        if 'company' in local_var_params and local_var_params['company'] is not None:  # noqa: E501
            query_params.append(('company', local_var_params['company']))  # noqa: E501
        if 'company__contains' in local_var_params and local_var_params['company__contains'] is not None:  # noqa: E501
            query_params.append(('company__contains', local_var_params['company__contains']))  # noqa: E501
        if 'company__icontains' in local_var_params and local_var_params['company__icontains'] is not None:  # noqa: E501
            query_params.append(('company__icontains', local_var_params['company__icontains']))  # noqa: E501
        if 'company__iexact' in local_var_params and local_var_params['company__iexact'] is not None:  # noqa: E501
            query_params.append(('company__iexact', local_var_params['company__iexact']))  # noqa: E501
        if 'company__in' in local_var_params and local_var_params['company__in'] is not None:  # noqa: E501
            query_params.append(('company__in', local_var_params['company__in']))  # noqa: E501
            collection_formats['company__in'] = 'csv'  # noqa: E501
        if 'company__iregex' in local_var_params and local_var_params['company__iregex'] is not None:  # noqa: E501
            query_params.append(('company__iregex', local_var_params['company__iregex']))  # noqa: E501
        if 'company__istartswith' in local_var_params and local_var_params['company__istartswith'] is not None:  # noqa: E501
            query_params.append(('company__istartswith', local_var_params['company__istartswith']))  # noqa: E501
        if 'company__regex' in local_var_params and local_var_params['company__regex'] is not None:  # noqa: E501
            query_params.append(('company__regex', local_var_params['company__regex']))  # noqa: E501
        if 'company__startswith' in local_var_params and local_var_params['company__startswith'] is not None:  # noqa: E501
            query_params.append(('company__startswith', local_var_params['company__startswith']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'metadata_sha256' in local_var_params and local_var_params['metadata_sha256'] is not None:  # noqa: E501
            query_params.append(('metadata_sha256', local_var_params['metadata_sha256']))  # noqa: E501
        if 'metadata_sha256__in' in local_var_params and local_var_params['metadata_sha256__in'] is not None:  # noqa: E501
            query_params.append(('metadata_sha256__in', local_var_params['metadata_sha256__in']))  # noqa: E501
            collection_formats['metadata_sha256__in'] = 'csv'  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'name__contains' in local_var_params and local_var_params['name__contains'] is not None:  # noqa: E501
            query_params.append(('name__contains', local_var_params['name__contains']))  # noqa: E501
        if 'name__icontains' in local_var_params and local_var_params['name__icontains'] is not None:  # noqa: E501
            query_params.append(('name__icontains', local_var_params['name__icontains']))  # noqa: E501
        if 'name__iexact' in local_var_params and local_var_params['name__iexact'] is not None:  # noqa: E501
            query_params.append(('name__iexact', local_var_params['name__iexact']))  # noqa: E501
        if 'name__in' in local_var_params and local_var_params['name__in'] is not None:  # noqa: E501
            query_params.append(('name__in', local_var_params['name__in']))  # noqa: E501
            collection_formats['name__in'] = 'csv'  # noqa: E501
        if 'name__iregex' in local_var_params and local_var_params['name__iregex'] is not None:  # noqa: E501
            query_params.append(('name__iregex', local_var_params['name__iregex']))  # noqa: E501
        if 'name__istartswith' in local_var_params and local_var_params['name__istartswith'] is not None:  # noqa: E501
            query_params.append(('name__istartswith', local_var_params['name__istartswith']))  # noqa: E501
        if 'name__regex' in local_var_params and local_var_params['name__regex'] is not None:  # noqa: E501
            query_params.append(('name__regex', local_var_params['name__regex']))  # noqa: E501
        if 'name__startswith' in local_var_params and local_var_params['name__startswith'] is not None:  # noqa: E501
            query_params.append(('name__startswith', local_var_params['name__startswith']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'ordering' in local_var_params and local_var_params['ordering'] is not None:  # noqa: E501
            query_params.append(('ordering', local_var_params['ordering']))  # noqa: E501
            collection_formats['ordering'] = 'csv'  # noqa: E501
        if 'pulp_href__in' in local_var_params and local_var_params['pulp_href__in'] is not None:  # noqa: E501
            query_params.append(('pulp_href__in', local_var_params['pulp_href__in']))  # noqa: E501
            collection_formats['pulp_href__in'] = 'csv'  # noqa: E501
        if 'pulp_id__in' in local_var_params and local_var_params['pulp_id__in'] is not None:  # noqa: E501
            query_params.append(('pulp_id__in', local_var_params['pulp_id__in']))  # noqa: E501
            collection_formats['pulp_id__in'] = 'csv'  # noqa: E501
        if 'q' in local_var_params and local_var_params['q'] is not None:  # noqa: E501
            query_params.append(('q', local_var_params['q']))  # noqa: E501
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501
            collection_formats['exclude_fields'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginatedansibleAnsibleNamespaceMetadataResponseList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update(self, distro_base_path, name, path,  **kwargs):  # noqa: E501
        """partial_update  # noqa: E501

        Provides the authentication and permission classes from settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update(distro_base_path, name, path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str distro_base_path: (required)
        :param str name: (required)
        :param str path: (required)
        :param str name: Required named, only accepts lowercase, numbers and underscores.
        :param str company: Optional namespace company owner.
        :param str email: Optional namespace contact email.
        :param str description: Optional short description.
        :param str resources: Optional resource page in markdown format.
        :param list[NamespaceLink] links: Labeled related links.
        :param file avatar: Optional avatar image for Namespace
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.partial_update_with_http_info(distro_base_path, name, path,  **kwargs)  # noqa: E501

    def partial_update_with_http_info(self, distro_base_path, name, path,  **kwargs):  # noqa: E501
        """partial_update  # noqa: E501

        Provides the authentication and permission classes from settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_with_http_info(distro_base_path, name, path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str distro_base_path: (required)
        :param str name: (required)
        :param str path: (required)
        :param str name: Required named, only accepts lowercase, numbers and underscores.
        :param str company: Optional namespace company owner.
        :param str email: Optional namespace contact email.
        :param str description: Optional short description.
        :param str resources: Optional resource page in markdown format.
        :param list[NamespaceLink] links: Labeled related links.
        :param file avatar: Optional avatar image for Namespace
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'distro_base_path',
            'name',
            'path',
            'name',
            'company',
            'email',
            'description',
            'resources',
            'links',
            'avatar'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'distro_base_path' is set
        if self.api_client.client_side_validation and ('distro_base_path' not in local_var_params or  # noqa: E501
                                                        local_var_params['distro_base_path'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `distro_base_path` when calling `partial_update`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `partial_update`")  # noqa: E501
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and ('path' not in local_var_params or  # noqa: E501
                                                        local_var_params['path'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `path` when calling `partial_update`")  # noqa: E501

        if self.api_client.client_side_validation and ('name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['name']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `name` when calling `partial_update`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['name']) < 3):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `name` when calling `partial_update`, length must be greater than or equal to `3`")  # noqa: E501
        if self.api_client.client_side_validation and 'name' in local_var_params and not re.search(r'^(?!.*__)[a-z]+[0-9a-z_]*$', local_var_params['name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `name` when calling `partial_update`, must conform to the pattern `/^(?!.*__)[a-z]+[0-9a-z_]*$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('company' in local_var_params and  # noqa: E501
                                                        len(local_var_params['company']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `company` when calling `partial_update`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('email' in local_var_params and  # noqa: E501
                                                        len(local_var_params['email']) > 256):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `email` when calling `partial_update`, length must be less than or equal to `256`")  # noqa: E501
        if self.api_client.client_side_validation and ('description' in local_var_params and  # noqa: E501
                                                        len(local_var_params['description']) > 256):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `description` when calling `partial_update`, length must be less than or equal to `256`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'distro_base_path' in local_var_params:
            path_params['distro_base_path'] = local_var_params['distro_base_path']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501
        if 'path' in local_var_params:
            path_params['path'] = local_var_params['path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in local_var_params:
            form_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'company' in local_var_params:
            form_params.append(('company', local_var_params['company']))  # noqa: E501
        if 'email' in local_var_params:
            form_params.append(('email', local_var_params['email']))  # noqa: E501
        if 'description' in local_var_params:
            form_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'resources' in local_var_params:
            form_params.append(('resources', local_var_params['resources']))  # noqa: E501
        if 'links' in local_var_params:
            form_params.append(('links', local_var_params['links']))  # noqa: E501
            collection_formats['links'] = 'csv'  # noqa: E501
        if 'avatar' in local_var_params:
            local_var_files['avatar'] = local_var_params['avatar']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/{name}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def read(self, distro_base_path, name, path,  **kwargs):  # noqa: E501
        """read  # noqa: E501

        Provides the authentication and permission classes from settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read(distro_base_path, name, path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str distro_base_path: (required)
        :param str name: (required)
        :param str path: (required)
        :param list[str] fields: A list of fields to include in the response.
        :param list[str] exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AnsibleAnsibleNamespaceMetadataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.read_with_http_info(distro_base_path, name, path,  **kwargs)  # noqa: E501

    def read_with_http_info(self, distro_base_path, name, path,  **kwargs):  # noqa: E501
        """read  # noqa: E501

        Provides the authentication and permission classes from settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_with_http_info(distro_base_path, name, path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str distro_base_path: (required)
        :param str name: (required)
        :param str path: (required)
        :param list[str] fields: A list of fields to include in the response.
        :param list[str] exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AnsibleAnsibleNamespaceMetadataResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'distro_base_path',
            'name',
            'path',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'distro_base_path' is set
        if self.api_client.client_side_validation and ('distro_base_path' not in local_var_params or  # noqa: E501
                                                        local_var_params['distro_base_path'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `distro_base_path` when calling `read`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `read`")  # noqa: E501
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and ('path' not in local_var_params or  # noqa: E501
                                                        local_var_params['path'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `path` when calling `read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'distro_base_path' in local_var_params:
            path_params['distro_base_path'] = local_var_params['distro_base_path']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501
        if 'path' in local_var_params:
            path_params['path'] = local_var_params['path']  # noqa: E501

        query_params = []
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501
            collection_formats['exclude_fields'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/{name}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AnsibleAnsibleNamespaceMetadataResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
