# -*- coding: UTF-8 -*-

import requests
import json
import time

from fnirsLink.exception import CustomError


class WebRequest(object):
    timeout = 1

    @staticmethod
    def get(url, para, headers):
        try:
            r = requests.get(url, params=para, headers=headers, timeout=WebRequest.timeout)
            # print("获取返回的状态码", r.status_code)
            json_r = r.json()
            # print("json类型转化成python数据类型", json_r)
            return json_r
        except BaseException as e:
            # print("请求失败！", str(e))
            raise CustomError("请检查服务器是否运行或者ip地址是否正确！")

    @staticmethod
    def post(url, para, headers):
        start = time.time()
        try:
            r = requests.post(url, data=para, headers=headers, timeout=WebRequest.timeout)
            # print("获取返回的状态码", r.status_code)
            json_r = r.json()
            # print("json类型转化成python数据类型", json_r)
            return json_r
        except BaseException as e:
            # print("请求失败！", str(e))
            end = time.time()
            print(end - start)
            raise CustomError("请检查服务器是否运行或者ip地址是否正确！")

    @staticmethod
    def post_json(url, para, headers):
        try:
            data = para
            data = json.dumps(data)  # python数据类型转化为json数据类型
            r = requests.post(url, data=data, headers=headers, timeout=WebRequest.timeout)
            # print("获取返回的状态码", r.status_code)
            json_r = r.json()
            # print("json类型转化成python数据类型", json_r)
            return json_r
        except BaseException as e:
            # print("请求失败！", str(e))
            raise CustomError("请检查服务器是否运行或者ip地址是否正确！")


if __name__ == '__main__':
    print(1)
