"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkspaceBase = exports.Status = exports.SamlConfigurationStatuses = exports.PermissionTypes = exports.NotificationDestinations = exports.AuthenticationProviders = exports.AccountAccessType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Specifies whether the workspace can access AWS resources in this AWS account only, or whether it
 * can also access AWS resources in other accounts in the same organization. If this is
 * ORGANIZATION, the OrganizationalUnits parameter specifies which organizational units the
 * workspace can access.
 */
var AccountAccessType;
(function (AccountAccessType) {
    /**
     * Access is limited to the current AWS account only.
     */
    AccountAccessType["CURRENT_ACCOUNT"] = "CURRENT_ACCOUNT";
    /**
     * Access is extended to the entire AWS organization.
     */
    AccountAccessType["ORGANIZATION"] = "ORGANIZATION";
})(AccountAccessType || (exports.AccountAccessType = AccountAccessType = {}));
/**
 * Specifies whether this workspace uses SAML 2.0, AWS IAM Identity Center, or both to authenticate
 * users for using the Grafana console within a workspace.
 *
 * @see https://docs.aws.amazon.com/grafana/latest/APIReference/API_CreateWorkspace.html
 */
var AuthenticationProviders;
(function (AuthenticationProviders) {
    /**
     * AWS Single Sign-On authentication provider.
     */
    AuthenticationProviders["AWS_SSO"] = "AWS_SSO";
    /**
     * Security Assertion Markup Language (SAML) authentication provider.
     */
    AuthenticationProviders["SAML"] = "SAML";
})(AuthenticationProviders || (exports.AuthenticationProviders = AuthenticationProviders = {}));
/**
 * The AWS notification channels that Amazon Managed Grafana can automatically create IAM roles and
 * permissions for, to allow Amazon Managed Grafana to use these channels.
 */
var NotificationDestinations;
(function (NotificationDestinations) {
    /**
     * Amazon Simple Notification Service (SNS) as notification destination.
     */
    NotificationDestinations["SNS"] = "SNS";
})(NotificationDestinations || (exports.NotificationDestinations = NotificationDestinations = {}));
/**
 * If this is SERVICE_MANAGED, and the workplace was created through the Amazon Managed Grafana
 * console, then Amazon Managed Grafana automatically creates the IAM roles and provisions the
 * permissions that the workspace needs to use AWS data sources and notification channels.
 *
 * If this is CUSTOMER_MANAGED, you must manage those roles and permissions yourself.

 * If you are working with a workspace in a member account of an organization and that account is
 * not a delegated administrator account, and you want the workspace to access data sources in
 * other AWS accounts in the organization, this parameter must be set to CUSTOMER_MANAGED.
 */
var PermissionTypes;
(function (PermissionTypes) {
    /**
     * Customer-managed permissions where you manage user access to Grafana.
     */
    PermissionTypes["CUSTOMER_MANAGED"] = "CUSTOMER_MANAGED";
    /**
     * Service-managed permissions where AWS manages user access to Grafana.
     */
    PermissionTypes["SERVICE_MANAGED"] = "SERVICE_MANAGED";
})(PermissionTypes || (exports.PermissionTypes = PermissionTypes = {}));
/**
 * Status of SAML configuration for a Grafana workspace.
 */
var SamlConfigurationStatuses;
(function (SamlConfigurationStatuses) {
    /**
     * SAML is configured for the workspace.
     */
    SamlConfigurationStatuses["CONFIGURED"] = "CONFIGURED";
    /**
     * SAML is not configured for the workspace.
     */
    SamlConfigurationStatuses["NOT_CONFIGURED"] = "NOT_CONFIGURED";
})(SamlConfigurationStatuses || (exports.SamlConfigurationStatuses = SamlConfigurationStatuses = {}));
/**
 * Status of a Grafana workspace.
 */
var Status;
(function (Status) {
    /**
     * Workspace is active and ready to use.
     */
    Status["ACTIVE"] = "ACTIVE";
    /**
     * Workspace is being created.
     */
    Status["CREATING"] = "CREATING";
    /**
     * Workspace is being deleted.
     */
    Status["DELETING"] = "DELETING";
    /**
     * Workspace operation has failed.
     */
    Status["FAILED"] = "FAILED";
    /**
     * Workspace is being updated.
     */
    Status["UPDATING"] = "UPDATING";
    /**
     * Workspace is being upgraded.
     */
    Status["UPGRADING"] = "UPGRADING";
    /**
     * Workspace deletion has failed.
     */
    Status["DELETION_FAILED"] = "DELETION_FAILED";
    /**
     * Workspace creation has failed.
     */
    Status["CREATION_FAILED"] = "CREATION_FAILED";
    /**
     * Workspace update has failed.
     */
    Status["UPDATE_FAILED"] = "UPDATE_FAILED";
    /**
     * Workspace upgrade has failed.
     */
    Status["UPGRADE_FAILED"] = "UPGRADE_FAILED";
    /**
     * License removal has failed.
     */
    Status["LICENSE_REMOVAL_FAILED"] = "LICENSE_REMOVAL_FAILED";
})(Status || (exports.Status = Status = {}));
class WorkspaceBase extends aws_cdk_lib_1.Resource {
    getWorkspaceArn(workspaceId) {
        const stack = this.stack;
        return `arn:${stack.partition}:grafana:${stack.region}:${stack.account}:workspaces/${workspaceId}`;
    }
    getWorkspaceId(workspaceArn) {
        return workspaceArn.substring(workspaceArn.lastIndexOf('/') + 1);
    }
}
exports.WorkspaceBase = WorkspaceBase;
_a = JSII_RTTI_SYMBOL_1;
WorkspaceBase[_a] = { fqn: "@robhan-cdk-lib/aws_grafana.WorkspaceBase", version: "0.0.62" };
//# sourceMappingURL=data:application/json;base64,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