# OVOS PHAL PLUGIN WIFI SETUP
This PHAL plugin provides a central networking clients management interface.

### What is the Networking Client Management Interface ?
The network client management interface provides functionality and is responsible for handling registeration, deregisteration, activation and deactivation of supported network client phal plugins.

#### What is a network client PHAL Plugin ?
A networking client PHAL plugin is a networking provider that is responsible for talking to the designated networking system and handles all connectivity related events that range from connecting to networks, editing existing networks and deactivation of networks. Each client can be fine tuned for the platform it supports, this can be utilizing an existing networking stack or library and can also target different lower level networking libraries such as Network Manager or Systemd Networking. On platforms outside Linux this allows us to also target OS platforms like Windows / Mac OSX and their networking stack if need be.

###### Some examples of existing Network Client Plugins:
- OVOS PHAL Plugin Gui Network Client: This client plugin provides a GUI interface for wireless network setup and management using Network Manager and Plasma-NM - https://github.com/OpenVoiceOS/ovos-PHAL-plugin-gui-network-client
- OVOS PHAL Plugin Balena Wifi: This client plugin provides a Mobile interface for setting up wireless networks, this plugin optionally can also display GUI pages when a GUI capable screen is present - https://github.com/OpenVoiceOS/ovos-PHAL-plugin-balena-wifi

# Requirements
- The network client management interface has no external dependencies

# Install
`pip install ovos-PHAL-plugin-wifi-setup`

# Event Details:

##### Registeration of Networking PHAL Clients
Every networking PHAL client requires registeration to the network client management interface, the request for registeration is handled by clients on initialization

``` python
    # ovos.phal.wifi.plugin.register.client
    # type: Request
    # description: Register a client to the plugin (requested by the client)
    # data required:
        # client = A Client Plugin Name For Registeration
        # client_plugin_type = A Plugin type that defines whether the plugin provides an "onDevice" or "Remote" connection experience (supported values: "onDevice", "Remote")
        # client_plugin_display_text = A plugin display name to display on the selection screen in GUI
        # client_plugin_has_gui = True if the plugin provides a GUI interface, else False
        # client_plugin_requires_input = True if the plugin requires user input, else False
```

On unsuccessful registeration of device, the network client management interface will respond with the following event:
``` python
# ovos.phal.wifi.plugin.client.registration.failure
# type: Response
# description: Registration failed
# date provided:
    # error = An error message on why the registeration of a client failed
```

On successful registeration of device, the network client management interface will respond with the following event:
``` python
# ovos.phal.wifi.plugin.client.registered
# type: Response
# description: Registration successful
# data provided:
    # initial client registeration fields sent in data required
    # client_id: This is an autogenerated client ID assigned to all network clients and all bus events specific to the network client plugin will utilize this client ID as the target for activation and deactivation of the networking client
```

##### De-Registeration of Networking PHAL Clients
Network clients or platforms might have a requirment to deregister a network client after registeration at runtime, this can be handled with the following event:

``` python
# ovos.phal.wifi.plugin.deregister.client
# type: Request
# description: Deregister a client from the plugin (requested by the client)
# date required:
    # client_id: A client_id is issued to every client at the time of registeration, this is the client_id that needs to be passed back to the deregisteration event
```

on successful de-registeration of clients, the network client interface will respond with the following event:
``` python
# ovos.phal.wifi.plugin.client.deregistered
# type: Response
# description: Deregistration successful
# data provided:
    # client: The client plugin name used at the time of registeration
```

##### Client Activation
Network clients are required to be activated from the selection screen by the USER on device, Network clients can also be auto activated in non GUI environments, The following event outlines the activation operations of a network client
``` python
# ovos.phal.wifi.plugin.set.active.client
# type: Request
# description: Activate a client
# data required:
    # user_requested_client = Client Name as set by the client
    # user_requested_id = Client ID as set at the time of registeration
```

When a client has been set active by this central network client interface, the response generated by this interface provides the following event, after which the selected client assumes all responsibilities and operations

``` python
# ovos.phal.wifi.plugin.activate.{clientID}
# type: Response
# description: Inform the client that the activation was successful
# data provided: None
```

##### Client Deactivation
Network clients are deactivated when they have finished their operations, specifically when the connection has been successful or when the user wishes to exit the current network client and return to the selection page to use a different network client
``` python
# ovos.phal.wifi.plugin.remove.active.client
# type: Request
# description: Deactivate a client (requested by the client)
# data required: None
```

The central network client interface will provide a response for the following request, which a client utilizes to deactivate itself.
``` python
# ovos.phal.wifi.plugin.deactivate.{clientID}
# type: Response
# description: Inform the client that the deactivation was successful
```

##### Client Setup Failure
Network client are responsible for letting this central network client interface know when they are unable to configure or complete the user action and result in total failure, specially instances where they might not be able to restart their own client setup mode after multiple attempts.

``` python
# ovos.phal.wifi.plugin.client.setup.failure
# type: Request
# description: Inform the wifi plugin that the client setup completely failed
```

In response to complete failure this central network client management interface will deactivate the failing client
``` python
# ovos.phal.wifi.plugin.deactivate.{clientID}
# type: Response
# description: Inform the client that the deactivation was successful
```

##### GUI Interaction Events
This network client interface provides a GUI Interface for Client Selection on GUI Enabled and Input enable devices, The following events are user for interaction with this GUI interface

###### Selection and Activation of Network Client:
Request generated by the GUI interface when a network client is selected on screen:
``` python
# ovos.phal.wifi.plugin.client.select
# type: Request
# description: Inform the wifi plugin that a client was selected
# data required:
    # user_requested_client = Client Name as set by the client
    # user_requested_id = Client ID as set at the time of registeration
```

On selection of client via the GUI interface the following request is generated by the central network client management interface:
``` python
# ovos.phal.wifi.plugin.set.active.client
# details to this event are documented above
```

###### Skip Network Client Selection:
Request generated by the GUI interface when "Skip" is selected on screep:
``` python
# ovos.phal.wifi.plugin.skip.setup
# type: Request
# description: Inform the central network client management system that further setup is not needed
```

##### Start and Display the select client interface from external button such as drop down menu
Request generated by the GUI interface when "wifi setup" button has been clicked on screen, can come from drop down menu or any other button action on screen:
``` python
# ovos.phal.wifi.plugin.user.activated
# type: Request
# description: Inform the wifi plugin that the user has activated the client
```

##### Generic Messages (Plugin Actions)
These are some addtional generic action this PHAL Plugin performs

``` python
# ovos.phal.wifi.plugin.alive
# type: Response
# description: Inform the wifi clients that the plugin is alive on startup
```

``` python
# ovos.phal.wifi.plugin.status
# type: Request
# description: Request the wifi plugin to send the status of the plugin
```

``` python
# ovos.phal.wifi.plugin.stop.setup.event
# type: Response
# description: Inform the wifi clients to stop the setup event completely and clean up
```

``` python
# ovos.phal.wifi.plugin.setup.failed
# type: Response
# description: Inform the interested parties that the plugin itself failed
```
