"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NoopFeatureFlagProvider = void 0;
class NoopFeatureFlagProvider {
    getBoolean(featureName, options) {
        return this.getValue(featureName, options);
    }
    getString(featureName, options) {
        return this.getValue(featureName, options);
    }
    getNumber(featureName, options) {
        return this.getValue(featureName, options);
    }
    getObject() {
        throw new Error('Not implemented');
    }
    getValue(featureName, defaultValue) {
        if (defaultValue !== undefined) {
            return defaultValue;
        }
        throw new Error(`No value found for feature ${featureName}`);
    }
}
exports.NoopFeatureFlagProvider = NoopFeatureFlagProvider;
//# sourceMappingURL=FeatureFlags.js.map