BASE_URL = "https://api.twitch.tv/kraken/"
BASE_HELIX_URL = "https://api.twitch.tv/helix/"
BASE_OAUTH_URL = "https://id.twitch.tv/oauth2/"
VOD_FETCH_URL = "https://usher.ttvnw.net/"

CONFIG_FILE_PATH = "~/.twitch.cfg"

PERIOD_DAY = "day"
PERIOD_WEEK = "week"
PERIOD_MONTH = "month"
PERIOD_ALL = "all"
PERIODS = [PERIOD_DAY, PERIOD_WEEK, PERIOD_MONTH, PERIOD_ALL]

BROADCAST_TYPE_ARCHIVE = "archive"
BROADCAST_TYPE_HIGHLIGHT = "highlight"
BROADCAST_TYPE_UPLOAD = "upload"
BROADCAST_TYPE_ARCHIVE_UPLOAD = "archive,upload"
BROADCAST_TYPE_ARCHIVE_HIGHLIGHT = "archive,highlight"
BROADCAST_TYPE_HIGHLIGHT_UPLOAD = "highlight,upload"
BROADCAST_TYPE_ALL = ""

BROADCAST_TYPES = [
    BROADCAST_TYPE_ARCHIVE,
    BROADCAST_TYPE_HIGHLIGHT,
    BROADCAST_TYPE_UPLOAD,
    BROADCAST_TYPE_ARCHIVE_UPLOAD,
    BROADCAST_TYPE_ARCHIVE_HIGHLIGHT,
    BROADCAST_TYPE_HIGHLIGHT_UPLOAD,
    BROADCAST_TYPE_ALL,
]

VIDEO_SORT_TIME = "time"
VIDEO_SORT_TRENDING = "trending"
VIDEO_SORT_VIEWS = "views"
VIDEO_SORTS = [VIDEO_SORT_TIME, VIDEO_SORT_TRENDING, VIDEO_SORT_VIEWS]

USERS_SORT_BY_CREATED_AT = "created_at"
USERS_SORT_BY_LAST_BROADCAST = "last_broadcast"
USERS_SORT_BY_LOGIN = "login"
USERS_SORT_BY = [
    USERS_SORT_BY_CREATED_AT,
    USERS_SORT_BY_LAST_BROADCAST,
    USERS_SORT_BY_LOGIN,
]
MAX_FOLLOWS_LIMIT = 100

DIRECTION_ASC = "asc"
DIRECTION_DESC = "desc"
DIRECTIONS = [DIRECTION_ASC, DIRECTION_DESC]

STREAM_TYPE_LIVE = "live"
STREAM_TYPE_PLAYLIST = "playlist"
STREAM_TYPE_ALL = "all"
STREAM_TYPES = [STREAM_TYPE_LIVE, STREAM_TYPE_PLAYLIST, STREAM_TYPE_ALL]

VIDEO_TYPE_ALL = "all"
VIDEO_TYPE_UPLAOD = "upload"
VIDEO_TYPE_ARCHIVE = "archive"
VIDEO_TYPE_HIGHLIGHT = "highlight"
VIDEO_TYPES = [
    VIDEO_TYPE_ALL,
    VIDEO_TYPE_UPLAOD,
    VIDEO_TYPE_ARCHIVE,
    VIDEO_TYPE_HIGHLIGHT,
]

OAUTH_SCOPE_ANALYTICS_READ_EXTENSIONS = "analytics:read:extensions"
OAUTH_SCOPE_ANALYTICS_READ_GAMES = "analytics:read:games"
OAUTH_SCOPE_BITS_READ = "bits:read"
OAUTH_SCOPE_CHANNEL_EDIT_COMMERICAL = "channel:edit:commercial"
OAUTH_SCOPE_CHANNEL_MANAGE_BROADCAST = "channel:manage:broadcast"
OAUTH_SCOPE_CHANNEL_MANAGE_EXTENSION = "channel:manage:extension"
OAUTH_SCOPE_CHANNEL_READ_HYPE_TRAIN = "channel:read:hype_train"
OAUTH_SCOPE_CHANNEL_READ_STREAM_KEY = "channel:read:stream_key"
OAUTH_SCOPE_CHANNEL_READ_HYPE_SUBSCRIPTIONS = "channel:read:subscriptions"
OAUTH_SCOPE_CLIPS_EDIT = "clips:edit"
OAUTH_SCOPE_USER_EDIT = "user:edit"
OAUTH_SCOPE_USER_EDIT_FOLLOWS = "user:edit:follows"
OAUTH_SCOPE_USER_READ_BROADCAST = "user:read:broadcast"
OAUTH_SCOPE_USER_READ_EMAIL = "user:read:email"

OAUTH_SCOPES = [
    OAUTH_SCOPE_ANALYTICS_READ_EXTENSIONS,
    OAUTH_SCOPE_ANALYTICS_READ_GAMES,
    OAUTH_SCOPE_BITS_READ,
    OAUTH_SCOPE_CHANNEL_EDIT_COMMERICAL,
    OAUTH_SCOPE_CHANNEL_MANAGE_BROADCAST,
    OAUTH_SCOPE_CHANNEL_MANAGE_EXTENSION,
    OAUTH_SCOPE_CHANNEL_READ_HYPE_TRAIN,
    OAUTH_SCOPE_CHANNEL_READ_STREAM_KEY,
    OAUTH_SCOPE_CHANNEL_READ_HYPE_SUBSCRIPTIONS,
    OAUTH_SCOPE_CLIPS_EDIT,
    OAUTH_SCOPE_USER_EDIT_FOLLOWS,
    OAUTH_SCOPE_USER_READ_BROADCAST,
    OAUTH_SCOPE_USER_READ_EMAIL,
]
