import geopandas
import starepandas
import numpy

world = geopandas.read_file(geopandas.datasets.get_path('naturalearth_lowres'))
west = world[world['continent'].isin(['Europe', 'North America'])]
west = starepandas.STAREDataFrame(west, add_sids=True, resolution=4, add_trixels=False)

europe_sids = numpy.array([ 648518346341351428,  900719925474099204, 1044835113549955076,
       2760706571578114052, 2762958371391799300, 3503800510094245892,
       3530822107858468868, 3535325707485839364, 3537577507299524612,
       3548836506367950851, 3557843705622691844, 3560095505436377092,
       3564599105063747588, 3566850904877432836, 3638908498915360771,
       3659174697238528004, 3661426497052213252, 3668181896493268996,
       3731232291276455940, 3735735890903826436, 3783023686991216644,
       3785275486804901892, 3789779086432272388, 3792030886245957635,
       3805541685128069124, 3810045284755439619, 3819052484010180610,
       3866340280097570820, 3868592079911256068, 3870843879724941316,
       3875347479352311812, 3882102878793367555, 3891110078048108547,
       3900117277302849539, 3911376276371275780, 3913628076184961028,
       3915879875998646276, 3918131675812331524, 3922635275439702020,
       3924887075253387268, 3927138875067072514, 3981182070595518468,
       3999196469105000452, 4003700068732370948, 4005951868546056196,
       4017210867614482435, 4026218066869223428, 4028469866682908676,
       4071254063142928387, 4091520261466095620, 4093772061279780868,
       4096023861093466116, 4098275660907151363, 4251398048237748226,
       4287426845256712195, 4300937644138823684, 4318952042648305668,
       4539628424389459971, 4550887423457886212, 4553139223271571460,
       4555391023085256708, 4562146422526312452, 4566650022153682947])


def test_dissolve():
    dissolved = west.stare_dissolve(by='continent', aggfunc='sum')
    assert len(dissolved) == 2
    assert numpy.array_equal(dissolved.sids['Europe'], europe_sids)

