# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ProfileArgs', 'Profile']

@pulumi.input_type
class ProfileArgs:
    def __init__(__self__, *,
                 autoneg: Optional[pulumi.Input[bool]] = None,
                 dot1x_ctrl: Optional[pulumi.Input[str]] = None,
                 dot1x_idle_timeout: Optional[pulumi.Input[int]] = None,
                 egress_rate_limit_kbps: Optional[pulumi.Input[int]] = None,
                 egress_rate_limit_kbps_enabled: Optional[pulumi.Input[bool]] = None,
                 forward: Optional[pulumi.Input[str]] = None,
                 full_duplex: Optional[pulumi.Input[bool]] = None,
                 isolation: Optional[pulumi.Input[bool]] = None,
                 lldpmed_enabled: Optional[pulumi.Input[bool]] = None,
                 lldpmed_notify_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 native_networkconf_id: Optional[pulumi.Input[str]] = None,
                 op_mode: Optional[pulumi.Input[str]] = None,
                 poe_mode: Optional[pulumi.Input[str]] = None,
                 port_security_enabled: Optional[pulumi.Input[bool]] = None,
                 port_security_mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 priority_queue1_level: Optional[pulumi.Input[int]] = None,
                 priority_queue2_level: Optional[pulumi.Input[int]] = None,
                 priority_queue3_level: Optional[pulumi.Input[int]] = None,
                 priority_queue4_level: Optional[pulumi.Input[int]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 speed: Optional[pulumi.Input[int]] = None,
                 stormctrl_bcast_enabled: Optional[pulumi.Input[bool]] = None,
                 stormctrl_bcast_level: Optional[pulumi.Input[int]] = None,
                 stormctrl_bcast_rate: Optional[pulumi.Input[int]] = None,
                 stormctrl_mcast_enabled: Optional[pulumi.Input[bool]] = None,
                 stormctrl_mcast_level: Optional[pulumi.Input[int]] = None,
                 stormctrl_mcast_rate: Optional[pulumi.Input[int]] = None,
                 stormctrl_type: Optional[pulumi.Input[str]] = None,
                 stormctrl_ucast_enabled: Optional[pulumi.Input[bool]] = None,
                 stormctrl_ucast_level: Optional[pulumi.Input[int]] = None,
                 stormctrl_ucast_rate: Optional[pulumi.Input[int]] = None,
                 stp_port_mode: Optional[pulumi.Input[bool]] = None,
                 tagged_networkconf_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 voice_networkconf_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Profile resource.
        :param pulumi.Input[bool] autoneg: Enable link auto negotiation for the port profile. When set to `true` this overrides `speed`. Defaults to `true`.
        :param pulumi.Input[str] dot1x_ctrl: The type of 802.1X control to use. Can be `auto`, `force_authorized`, `force_unauthorized`, `mac_based` or `multi_host`. Defaults to `force_authorized`.
        :param pulumi.Input[int] dot1x_idle_timeout: The timeout, in seconds, to use when using the MAC Based 802.1X control. Can be between 0 and 65535 Defaults to `300`.
        :param pulumi.Input[int] egress_rate_limit_kbps: The egress rate limit, in kpbs, for the port profile. Can be between `64` and `9999999`.
        :param pulumi.Input[bool] egress_rate_limit_kbps_enabled: Enable egress rate limiting for the port profile. Defaults to `false`.
        :param pulumi.Input[str] forward: The type forwarding to use for the port profile. Can be `all`, `native`, `customize` or `disabled`. Defaults to `native`.
        :param pulumi.Input[bool] full_duplex: Enable full duplex for the port profile. Defaults to `false`.
        :param pulumi.Input[bool] isolation: Enable port isolation for the port profile. Defaults to `false`.
        :param pulumi.Input[bool] lldpmed_enabled: Enable LLDP-MED for the port profile. Defaults to `true`.
        :param pulumi.Input[bool] lldpmed_notify_enabled: Enable LLDP-MED topology change notifications for the port profile.
        :param pulumi.Input[str] name: The name of the port profile.
        :param pulumi.Input[str] native_networkconf_id: The ID of network to use as the main network on the port profile.
        :param pulumi.Input[str] op_mode: The operation mode for the port profile. Can only be `switch` Defaults to `switch`.
        :param pulumi.Input[str] poe_mode: The POE mode for the port profile. Can be one of `auto`, `passv24`, `passthrough` or `off`.
        :param pulumi.Input[bool] port_security_enabled: Enable port security for the port profile. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] port_security_mac_addresses: The MAC addresses associated with the port security for the port profile.
        :param pulumi.Input[int] priority_queue1_level: The priority queue 1 level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] priority_queue2_level: The priority queue 2 level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] priority_queue3_level: The priority queue 3 level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] priority_queue4_level: The priority queue 4 level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[str] site: The name of the site to associate the port profile with.
        :param pulumi.Input[int] speed: The link speed to set for the port profile. Can be one of `10`, `100`, `1000`, `2500`, `5000`, `10000`, `20000`, `25000`, `40000`, `50000` or `100000`
        :param pulumi.Input[bool] stormctrl_bcast_enabled: Enable broadcast Storm Control for the port profile. Defaults to `false`.
        :param pulumi.Input[int] stormctrl_bcast_level: The broadcast Storm Control level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] stormctrl_bcast_rate: The broadcast Storm Control rate for the port profile. Can be between 0 and 14880000.
        :param pulumi.Input[bool] stormctrl_mcast_enabled: Enable multicast Storm Control for the port profile. Defaults to `false`.
        :param pulumi.Input[int] stormctrl_mcast_level: The multicast Storm Control level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] stormctrl_mcast_rate: The multicast Storm Control rate for the port profile. Can be between 0 and 14880000.
        :param pulumi.Input[str] stormctrl_type: The type of Storm Control to use for the port profile. Can be one of `level` or `rate`.
        :param pulumi.Input[bool] stormctrl_ucast_enabled: Enable unknown unicast Storm Control for the port profile. Defaults to `false`.
        :param pulumi.Input[int] stormctrl_ucast_level: The unknown unicast Storm Control level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] stormctrl_ucast_rate: The unknown unicast Storm Control rate for the port profile. Can be between 0 and 14880000.
        :param pulumi.Input[bool] stp_port_mode: Enable spanning tree protocol on the port profile. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tagged_networkconf_ids: The IDs of networks to tag traffic with for the port profile.
        :param pulumi.Input[str] voice_networkconf_id: The ID of network to use as the voice network on the port profile.
        """
        if autoneg is not None:
            pulumi.set(__self__, "autoneg", autoneg)
        if dot1x_ctrl is not None:
            pulumi.set(__self__, "dot1x_ctrl", dot1x_ctrl)
        if dot1x_idle_timeout is not None:
            pulumi.set(__self__, "dot1x_idle_timeout", dot1x_idle_timeout)
        if egress_rate_limit_kbps is not None:
            pulumi.set(__self__, "egress_rate_limit_kbps", egress_rate_limit_kbps)
        if egress_rate_limit_kbps_enabled is not None:
            pulumi.set(__self__, "egress_rate_limit_kbps_enabled", egress_rate_limit_kbps_enabled)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)
        if full_duplex is not None:
            pulumi.set(__self__, "full_duplex", full_duplex)
        if isolation is not None:
            pulumi.set(__self__, "isolation", isolation)
        if lldpmed_enabled is not None:
            pulumi.set(__self__, "lldpmed_enabled", lldpmed_enabled)
        if lldpmed_notify_enabled is not None:
            pulumi.set(__self__, "lldpmed_notify_enabled", lldpmed_notify_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if native_networkconf_id is not None:
            pulumi.set(__self__, "native_networkconf_id", native_networkconf_id)
        if op_mode is not None:
            pulumi.set(__self__, "op_mode", op_mode)
        if poe_mode is not None:
            pulumi.set(__self__, "poe_mode", poe_mode)
        if port_security_enabled is not None:
            pulumi.set(__self__, "port_security_enabled", port_security_enabled)
        if port_security_mac_addresses is not None:
            pulumi.set(__self__, "port_security_mac_addresses", port_security_mac_addresses)
        if priority_queue1_level is not None:
            pulumi.set(__self__, "priority_queue1_level", priority_queue1_level)
        if priority_queue2_level is not None:
            pulumi.set(__self__, "priority_queue2_level", priority_queue2_level)
        if priority_queue3_level is not None:
            pulumi.set(__self__, "priority_queue3_level", priority_queue3_level)
        if priority_queue4_level is not None:
            pulumi.set(__self__, "priority_queue4_level", priority_queue4_level)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if speed is not None:
            pulumi.set(__self__, "speed", speed)
        if stormctrl_bcast_enabled is not None:
            pulumi.set(__self__, "stormctrl_bcast_enabled", stormctrl_bcast_enabled)
        if stormctrl_bcast_level is not None:
            pulumi.set(__self__, "stormctrl_bcast_level", stormctrl_bcast_level)
        if stormctrl_bcast_rate is not None:
            pulumi.set(__self__, "stormctrl_bcast_rate", stormctrl_bcast_rate)
        if stormctrl_mcast_enabled is not None:
            pulumi.set(__self__, "stormctrl_mcast_enabled", stormctrl_mcast_enabled)
        if stormctrl_mcast_level is not None:
            pulumi.set(__self__, "stormctrl_mcast_level", stormctrl_mcast_level)
        if stormctrl_mcast_rate is not None:
            pulumi.set(__self__, "stormctrl_mcast_rate", stormctrl_mcast_rate)
        if stormctrl_type is not None:
            pulumi.set(__self__, "stormctrl_type", stormctrl_type)
        if stormctrl_ucast_enabled is not None:
            pulumi.set(__self__, "stormctrl_ucast_enabled", stormctrl_ucast_enabled)
        if stormctrl_ucast_level is not None:
            pulumi.set(__self__, "stormctrl_ucast_level", stormctrl_ucast_level)
        if stormctrl_ucast_rate is not None:
            pulumi.set(__self__, "stormctrl_ucast_rate", stormctrl_ucast_rate)
        if stp_port_mode is not None:
            pulumi.set(__self__, "stp_port_mode", stp_port_mode)
        if tagged_networkconf_ids is not None:
            pulumi.set(__self__, "tagged_networkconf_ids", tagged_networkconf_ids)
        if voice_networkconf_id is not None:
            pulumi.set(__self__, "voice_networkconf_id", voice_networkconf_id)

    @property
    @pulumi.getter
    def autoneg(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable link auto negotiation for the port profile. When set to `true` this overrides `speed`. Defaults to `true`.
        """
        return pulumi.get(self, "autoneg")

    @autoneg.setter
    def autoneg(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autoneg", value)

    @property
    @pulumi.getter(name="dot1xCtrl")
    def dot1x_ctrl(self) -> Optional[pulumi.Input[str]]:
        """
        The type of 802.1X control to use. Can be `auto`, `force_authorized`, `force_unauthorized`, `mac_based` or `multi_host`. Defaults to `force_authorized`.
        """
        return pulumi.get(self, "dot1x_ctrl")

    @dot1x_ctrl.setter
    def dot1x_ctrl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dot1x_ctrl", value)

    @property
    @pulumi.getter(name="dot1xIdleTimeout")
    def dot1x_idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout, in seconds, to use when using the MAC Based 802.1X control. Can be between 0 and 65535 Defaults to `300`.
        """
        return pulumi.get(self, "dot1x_idle_timeout")

    @dot1x_idle_timeout.setter
    def dot1x_idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "dot1x_idle_timeout", value)

    @property
    @pulumi.getter(name="egressRateLimitKbps")
    def egress_rate_limit_kbps(self) -> Optional[pulumi.Input[int]]:
        """
        The egress rate limit, in kpbs, for the port profile. Can be between `64` and `9999999`.
        """
        return pulumi.get(self, "egress_rate_limit_kbps")

    @egress_rate_limit_kbps.setter
    def egress_rate_limit_kbps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "egress_rate_limit_kbps", value)

    @property
    @pulumi.getter(name="egressRateLimitKbpsEnabled")
    def egress_rate_limit_kbps_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable egress rate limiting for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "egress_rate_limit_kbps_enabled")

    @egress_rate_limit_kbps_enabled.setter
    def egress_rate_limit_kbps_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "egress_rate_limit_kbps_enabled", value)

    @property
    @pulumi.getter
    def forward(self) -> Optional[pulumi.Input[str]]:
        """
        The type forwarding to use for the port profile. Can be `all`, `native`, `customize` or `disabled`. Defaults to `native`.
        """
        return pulumi.get(self, "forward")

    @forward.setter
    def forward(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "forward", value)

    @property
    @pulumi.getter(name="fullDuplex")
    def full_duplex(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable full duplex for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "full_duplex")

    @full_duplex.setter
    def full_duplex(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "full_duplex", value)

    @property
    @pulumi.getter
    def isolation(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable port isolation for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "isolation")

    @isolation.setter
    def isolation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "isolation", value)

    @property
    @pulumi.getter(name="lldpmedEnabled")
    def lldpmed_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable LLDP-MED for the port profile. Defaults to `true`.
        """
        return pulumi.get(self, "lldpmed_enabled")

    @lldpmed_enabled.setter
    def lldpmed_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "lldpmed_enabled", value)

    @property
    @pulumi.getter(name="lldpmedNotifyEnabled")
    def lldpmed_notify_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable LLDP-MED topology change notifications for the port profile.
        """
        return pulumi.get(self, "lldpmed_notify_enabled")

    @lldpmed_notify_enabled.setter
    def lldpmed_notify_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "lldpmed_notify_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the port profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nativeNetworkconfId")
    def native_networkconf_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of network to use as the main network on the port profile.
        """
        return pulumi.get(self, "native_networkconf_id")

    @native_networkconf_id.setter
    def native_networkconf_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "native_networkconf_id", value)

    @property
    @pulumi.getter(name="opMode")
    def op_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The operation mode for the port profile. Can only be `switch` Defaults to `switch`.
        """
        return pulumi.get(self, "op_mode")

    @op_mode.setter
    def op_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "op_mode", value)

    @property
    @pulumi.getter(name="poeMode")
    def poe_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The POE mode for the port profile. Can be one of `auto`, `passv24`, `passthrough` or `off`.
        """
        return pulumi.get(self, "poe_mode")

    @poe_mode.setter
    def poe_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "poe_mode", value)

    @property
    @pulumi.getter(name="portSecurityEnabled")
    def port_security_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable port security for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "port_security_enabled")

    @port_security_enabled.setter
    def port_security_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "port_security_enabled", value)

    @property
    @pulumi.getter(name="portSecurityMacAddresses")
    def port_security_mac_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The MAC addresses associated with the port security for the port profile.
        """
        return pulumi.get(self, "port_security_mac_addresses")

    @port_security_mac_addresses.setter
    def port_security_mac_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "port_security_mac_addresses", value)

    @property
    @pulumi.getter(name="priorityQueue1Level")
    def priority_queue1_level(self) -> Optional[pulumi.Input[int]]:
        """
        The priority queue 1 level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "priority_queue1_level")

    @priority_queue1_level.setter
    def priority_queue1_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority_queue1_level", value)

    @property
    @pulumi.getter(name="priorityQueue2Level")
    def priority_queue2_level(self) -> Optional[pulumi.Input[int]]:
        """
        The priority queue 2 level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "priority_queue2_level")

    @priority_queue2_level.setter
    def priority_queue2_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority_queue2_level", value)

    @property
    @pulumi.getter(name="priorityQueue3Level")
    def priority_queue3_level(self) -> Optional[pulumi.Input[int]]:
        """
        The priority queue 3 level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "priority_queue3_level")

    @priority_queue3_level.setter
    def priority_queue3_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority_queue3_level", value)

    @property
    @pulumi.getter(name="priorityQueue4Level")
    def priority_queue4_level(self) -> Optional[pulumi.Input[int]]:
        """
        The priority queue 4 level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "priority_queue4_level")

    @priority_queue4_level.setter
    def priority_queue4_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority_queue4_level", value)

    @property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the site to associate the port profile with.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site", value)

    @property
    @pulumi.getter
    def speed(self) -> Optional[pulumi.Input[int]]:
        """
        The link speed to set for the port profile. Can be one of `10`, `100`, `1000`, `2500`, `5000`, `10000`, `20000`, `25000`, `40000`, `50000` or `100000`
        """
        return pulumi.get(self, "speed")

    @speed.setter
    def speed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "speed", value)

    @property
    @pulumi.getter(name="stormctrlBcastEnabled")
    def stormctrl_bcast_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable broadcast Storm Control for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "stormctrl_bcast_enabled")

    @stormctrl_bcast_enabled.setter
    def stormctrl_bcast_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stormctrl_bcast_enabled", value)

    @property
    @pulumi.getter(name="stormctrlBcastLevel")
    def stormctrl_bcast_level(self) -> Optional[pulumi.Input[int]]:
        """
        The broadcast Storm Control level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "stormctrl_bcast_level")

    @stormctrl_bcast_level.setter
    def stormctrl_bcast_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stormctrl_bcast_level", value)

    @property
    @pulumi.getter(name="stormctrlBcastRate")
    def stormctrl_bcast_rate(self) -> Optional[pulumi.Input[int]]:
        """
        The broadcast Storm Control rate for the port profile. Can be between 0 and 14880000.
        """
        return pulumi.get(self, "stormctrl_bcast_rate")

    @stormctrl_bcast_rate.setter
    def stormctrl_bcast_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stormctrl_bcast_rate", value)

    @property
    @pulumi.getter(name="stormctrlMcastEnabled")
    def stormctrl_mcast_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable multicast Storm Control for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "stormctrl_mcast_enabled")

    @stormctrl_mcast_enabled.setter
    def stormctrl_mcast_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stormctrl_mcast_enabled", value)

    @property
    @pulumi.getter(name="stormctrlMcastLevel")
    def stormctrl_mcast_level(self) -> Optional[pulumi.Input[int]]:
        """
        The multicast Storm Control level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "stormctrl_mcast_level")

    @stormctrl_mcast_level.setter
    def stormctrl_mcast_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stormctrl_mcast_level", value)

    @property
    @pulumi.getter(name="stormctrlMcastRate")
    def stormctrl_mcast_rate(self) -> Optional[pulumi.Input[int]]:
        """
        The multicast Storm Control rate for the port profile. Can be between 0 and 14880000.
        """
        return pulumi.get(self, "stormctrl_mcast_rate")

    @stormctrl_mcast_rate.setter
    def stormctrl_mcast_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stormctrl_mcast_rate", value)

    @property
    @pulumi.getter(name="stormctrlType")
    def stormctrl_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of Storm Control to use for the port profile. Can be one of `level` or `rate`.
        """
        return pulumi.get(self, "stormctrl_type")

    @stormctrl_type.setter
    def stormctrl_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stormctrl_type", value)

    @property
    @pulumi.getter(name="stormctrlUcastEnabled")
    def stormctrl_ucast_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable unknown unicast Storm Control for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "stormctrl_ucast_enabled")

    @stormctrl_ucast_enabled.setter
    def stormctrl_ucast_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stormctrl_ucast_enabled", value)

    @property
    @pulumi.getter(name="stormctrlUcastLevel")
    def stormctrl_ucast_level(self) -> Optional[pulumi.Input[int]]:
        """
        The unknown unicast Storm Control level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "stormctrl_ucast_level")

    @stormctrl_ucast_level.setter
    def stormctrl_ucast_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stormctrl_ucast_level", value)

    @property
    @pulumi.getter(name="stormctrlUcastRate")
    def stormctrl_ucast_rate(self) -> Optional[pulumi.Input[int]]:
        """
        The unknown unicast Storm Control rate for the port profile. Can be between 0 and 14880000.
        """
        return pulumi.get(self, "stormctrl_ucast_rate")

    @stormctrl_ucast_rate.setter
    def stormctrl_ucast_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stormctrl_ucast_rate", value)

    @property
    @pulumi.getter(name="stpPortMode")
    def stp_port_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable spanning tree protocol on the port profile. Defaults to `true`.
        """
        return pulumi.get(self, "stp_port_mode")

    @stp_port_mode.setter
    def stp_port_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stp_port_mode", value)

    @property
    @pulumi.getter(name="taggedNetworkconfIds")
    def tagged_networkconf_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IDs of networks to tag traffic with for the port profile.
        """
        return pulumi.get(self, "tagged_networkconf_ids")

    @tagged_networkconf_ids.setter
    def tagged_networkconf_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tagged_networkconf_ids", value)

    @property
    @pulumi.getter(name="voiceNetworkconfId")
    def voice_networkconf_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of network to use as the voice network on the port profile.
        """
        return pulumi.get(self, "voice_networkconf_id")

    @voice_networkconf_id.setter
    def voice_networkconf_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "voice_networkconf_id", value)


@pulumi.input_type
class _ProfileState:
    def __init__(__self__, *,
                 autoneg: Optional[pulumi.Input[bool]] = None,
                 dot1x_ctrl: Optional[pulumi.Input[str]] = None,
                 dot1x_idle_timeout: Optional[pulumi.Input[int]] = None,
                 egress_rate_limit_kbps: Optional[pulumi.Input[int]] = None,
                 egress_rate_limit_kbps_enabled: Optional[pulumi.Input[bool]] = None,
                 forward: Optional[pulumi.Input[str]] = None,
                 full_duplex: Optional[pulumi.Input[bool]] = None,
                 isolation: Optional[pulumi.Input[bool]] = None,
                 lldpmed_enabled: Optional[pulumi.Input[bool]] = None,
                 lldpmed_notify_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 native_networkconf_id: Optional[pulumi.Input[str]] = None,
                 op_mode: Optional[pulumi.Input[str]] = None,
                 poe_mode: Optional[pulumi.Input[str]] = None,
                 port_security_enabled: Optional[pulumi.Input[bool]] = None,
                 port_security_mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 priority_queue1_level: Optional[pulumi.Input[int]] = None,
                 priority_queue2_level: Optional[pulumi.Input[int]] = None,
                 priority_queue3_level: Optional[pulumi.Input[int]] = None,
                 priority_queue4_level: Optional[pulumi.Input[int]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 speed: Optional[pulumi.Input[int]] = None,
                 stormctrl_bcast_enabled: Optional[pulumi.Input[bool]] = None,
                 stormctrl_bcast_level: Optional[pulumi.Input[int]] = None,
                 stormctrl_bcast_rate: Optional[pulumi.Input[int]] = None,
                 stormctrl_mcast_enabled: Optional[pulumi.Input[bool]] = None,
                 stormctrl_mcast_level: Optional[pulumi.Input[int]] = None,
                 stormctrl_mcast_rate: Optional[pulumi.Input[int]] = None,
                 stormctrl_type: Optional[pulumi.Input[str]] = None,
                 stormctrl_ucast_enabled: Optional[pulumi.Input[bool]] = None,
                 stormctrl_ucast_level: Optional[pulumi.Input[int]] = None,
                 stormctrl_ucast_rate: Optional[pulumi.Input[int]] = None,
                 stp_port_mode: Optional[pulumi.Input[bool]] = None,
                 tagged_networkconf_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 voice_networkconf_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Profile resources.
        :param pulumi.Input[bool] autoneg: Enable link auto negotiation for the port profile. When set to `true` this overrides `speed`. Defaults to `true`.
        :param pulumi.Input[str] dot1x_ctrl: The type of 802.1X control to use. Can be `auto`, `force_authorized`, `force_unauthorized`, `mac_based` or `multi_host`. Defaults to `force_authorized`.
        :param pulumi.Input[int] dot1x_idle_timeout: The timeout, in seconds, to use when using the MAC Based 802.1X control. Can be between 0 and 65535 Defaults to `300`.
        :param pulumi.Input[int] egress_rate_limit_kbps: The egress rate limit, in kpbs, for the port profile. Can be between `64` and `9999999`.
        :param pulumi.Input[bool] egress_rate_limit_kbps_enabled: Enable egress rate limiting for the port profile. Defaults to `false`.
        :param pulumi.Input[str] forward: The type forwarding to use for the port profile. Can be `all`, `native`, `customize` or `disabled`. Defaults to `native`.
        :param pulumi.Input[bool] full_duplex: Enable full duplex for the port profile. Defaults to `false`.
        :param pulumi.Input[bool] isolation: Enable port isolation for the port profile. Defaults to `false`.
        :param pulumi.Input[bool] lldpmed_enabled: Enable LLDP-MED for the port profile. Defaults to `true`.
        :param pulumi.Input[bool] lldpmed_notify_enabled: Enable LLDP-MED topology change notifications for the port profile.
        :param pulumi.Input[str] name: The name of the port profile.
        :param pulumi.Input[str] native_networkconf_id: The ID of network to use as the main network on the port profile.
        :param pulumi.Input[str] op_mode: The operation mode for the port profile. Can only be `switch` Defaults to `switch`.
        :param pulumi.Input[str] poe_mode: The POE mode for the port profile. Can be one of `auto`, `passv24`, `passthrough` or `off`.
        :param pulumi.Input[bool] port_security_enabled: Enable port security for the port profile. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] port_security_mac_addresses: The MAC addresses associated with the port security for the port profile.
        :param pulumi.Input[int] priority_queue1_level: The priority queue 1 level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] priority_queue2_level: The priority queue 2 level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] priority_queue3_level: The priority queue 3 level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] priority_queue4_level: The priority queue 4 level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[str] site: The name of the site to associate the port profile with.
        :param pulumi.Input[int] speed: The link speed to set for the port profile. Can be one of `10`, `100`, `1000`, `2500`, `5000`, `10000`, `20000`, `25000`, `40000`, `50000` or `100000`
        :param pulumi.Input[bool] stormctrl_bcast_enabled: Enable broadcast Storm Control for the port profile. Defaults to `false`.
        :param pulumi.Input[int] stormctrl_bcast_level: The broadcast Storm Control level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] stormctrl_bcast_rate: The broadcast Storm Control rate for the port profile. Can be between 0 and 14880000.
        :param pulumi.Input[bool] stormctrl_mcast_enabled: Enable multicast Storm Control for the port profile. Defaults to `false`.
        :param pulumi.Input[int] stormctrl_mcast_level: The multicast Storm Control level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] stormctrl_mcast_rate: The multicast Storm Control rate for the port profile. Can be between 0 and 14880000.
        :param pulumi.Input[str] stormctrl_type: The type of Storm Control to use for the port profile. Can be one of `level` or `rate`.
        :param pulumi.Input[bool] stormctrl_ucast_enabled: Enable unknown unicast Storm Control for the port profile. Defaults to `false`.
        :param pulumi.Input[int] stormctrl_ucast_level: The unknown unicast Storm Control level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] stormctrl_ucast_rate: The unknown unicast Storm Control rate for the port profile. Can be between 0 and 14880000.
        :param pulumi.Input[bool] stp_port_mode: Enable spanning tree protocol on the port profile. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tagged_networkconf_ids: The IDs of networks to tag traffic with for the port profile.
        :param pulumi.Input[str] voice_networkconf_id: The ID of network to use as the voice network on the port profile.
        """
        if autoneg is not None:
            pulumi.set(__self__, "autoneg", autoneg)
        if dot1x_ctrl is not None:
            pulumi.set(__self__, "dot1x_ctrl", dot1x_ctrl)
        if dot1x_idle_timeout is not None:
            pulumi.set(__self__, "dot1x_idle_timeout", dot1x_idle_timeout)
        if egress_rate_limit_kbps is not None:
            pulumi.set(__self__, "egress_rate_limit_kbps", egress_rate_limit_kbps)
        if egress_rate_limit_kbps_enabled is not None:
            pulumi.set(__self__, "egress_rate_limit_kbps_enabled", egress_rate_limit_kbps_enabled)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)
        if full_duplex is not None:
            pulumi.set(__self__, "full_duplex", full_duplex)
        if isolation is not None:
            pulumi.set(__self__, "isolation", isolation)
        if lldpmed_enabled is not None:
            pulumi.set(__self__, "lldpmed_enabled", lldpmed_enabled)
        if lldpmed_notify_enabled is not None:
            pulumi.set(__self__, "lldpmed_notify_enabled", lldpmed_notify_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if native_networkconf_id is not None:
            pulumi.set(__self__, "native_networkconf_id", native_networkconf_id)
        if op_mode is not None:
            pulumi.set(__self__, "op_mode", op_mode)
        if poe_mode is not None:
            pulumi.set(__self__, "poe_mode", poe_mode)
        if port_security_enabled is not None:
            pulumi.set(__self__, "port_security_enabled", port_security_enabled)
        if port_security_mac_addresses is not None:
            pulumi.set(__self__, "port_security_mac_addresses", port_security_mac_addresses)
        if priority_queue1_level is not None:
            pulumi.set(__self__, "priority_queue1_level", priority_queue1_level)
        if priority_queue2_level is not None:
            pulumi.set(__self__, "priority_queue2_level", priority_queue2_level)
        if priority_queue3_level is not None:
            pulumi.set(__self__, "priority_queue3_level", priority_queue3_level)
        if priority_queue4_level is not None:
            pulumi.set(__self__, "priority_queue4_level", priority_queue4_level)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if speed is not None:
            pulumi.set(__self__, "speed", speed)
        if stormctrl_bcast_enabled is not None:
            pulumi.set(__self__, "stormctrl_bcast_enabled", stormctrl_bcast_enabled)
        if stormctrl_bcast_level is not None:
            pulumi.set(__self__, "stormctrl_bcast_level", stormctrl_bcast_level)
        if stormctrl_bcast_rate is not None:
            pulumi.set(__self__, "stormctrl_bcast_rate", stormctrl_bcast_rate)
        if stormctrl_mcast_enabled is not None:
            pulumi.set(__self__, "stormctrl_mcast_enabled", stormctrl_mcast_enabled)
        if stormctrl_mcast_level is not None:
            pulumi.set(__self__, "stormctrl_mcast_level", stormctrl_mcast_level)
        if stormctrl_mcast_rate is not None:
            pulumi.set(__self__, "stormctrl_mcast_rate", stormctrl_mcast_rate)
        if stormctrl_type is not None:
            pulumi.set(__self__, "stormctrl_type", stormctrl_type)
        if stormctrl_ucast_enabled is not None:
            pulumi.set(__self__, "stormctrl_ucast_enabled", stormctrl_ucast_enabled)
        if stormctrl_ucast_level is not None:
            pulumi.set(__self__, "stormctrl_ucast_level", stormctrl_ucast_level)
        if stormctrl_ucast_rate is not None:
            pulumi.set(__self__, "stormctrl_ucast_rate", stormctrl_ucast_rate)
        if stp_port_mode is not None:
            pulumi.set(__self__, "stp_port_mode", stp_port_mode)
        if tagged_networkconf_ids is not None:
            pulumi.set(__self__, "tagged_networkconf_ids", tagged_networkconf_ids)
        if voice_networkconf_id is not None:
            pulumi.set(__self__, "voice_networkconf_id", voice_networkconf_id)

    @property
    @pulumi.getter
    def autoneg(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable link auto negotiation for the port profile. When set to `true` this overrides `speed`. Defaults to `true`.
        """
        return pulumi.get(self, "autoneg")

    @autoneg.setter
    def autoneg(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autoneg", value)

    @property
    @pulumi.getter(name="dot1xCtrl")
    def dot1x_ctrl(self) -> Optional[pulumi.Input[str]]:
        """
        The type of 802.1X control to use. Can be `auto`, `force_authorized`, `force_unauthorized`, `mac_based` or `multi_host`. Defaults to `force_authorized`.
        """
        return pulumi.get(self, "dot1x_ctrl")

    @dot1x_ctrl.setter
    def dot1x_ctrl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dot1x_ctrl", value)

    @property
    @pulumi.getter(name="dot1xIdleTimeout")
    def dot1x_idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout, in seconds, to use when using the MAC Based 802.1X control. Can be between 0 and 65535 Defaults to `300`.
        """
        return pulumi.get(self, "dot1x_idle_timeout")

    @dot1x_idle_timeout.setter
    def dot1x_idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "dot1x_idle_timeout", value)

    @property
    @pulumi.getter(name="egressRateLimitKbps")
    def egress_rate_limit_kbps(self) -> Optional[pulumi.Input[int]]:
        """
        The egress rate limit, in kpbs, for the port profile. Can be between `64` and `9999999`.
        """
        return pulumi.get(self, "egress_rate_limit_kbps")

    @egress_rate_limit_kbps.setter
    def egress_rate_limit_kbps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "egress_rate_limit_kbps", value)

    @property
    @pulumi.getter(name="egressRateLimitKbpsEnabled")
    def egress_rate_limit_kbps_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable egress rate limiting for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "egress_rate_limit_kbps_enabled")

    @egress_rate_limit_kbps_enabled.setter
    def egress_rate_limit_kbps_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "egress_rate_limit_kbps_enabled", value)

    @property
    @pulumi.getter
    def forward(self) -> Optional[pulumi.Input[str]]:
        """
        The type forwarding to use for the port profile. Can be `all`, `native`, `customize` or `disabled`. Defaults to `native`.
        """
        return pulumi.get(self, "forward")

    @forward.setter
    def forward(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "forward", value)

    @property
    @pulumi.getter(name="fullDuplex")
    def full_duplex(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable full duplex for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "full_duplex")

    @full_duplex.setter
    def full_duplex(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "full_duplex", value)

    @property
    @pulumi.getter
    def isolation(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable port isolation for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "isolation")

    @isolation.setter
    def isolation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "isolation", value)

    @property
    @pulumi.getter(name="lldpmedEnabled")
    def lldpmed_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable LLDP-MED for the port profile. Defaults to `true`.
        """
        return pulumi.get(self, "lldpmed_enabled")

    @lldpmed_enabled.setter
    def lldpmed_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "lldpmed_enabled", value)

    @property
    @pulumi.getter(name="lldpmedNotifyEnabled")
    def lldpmed_notify_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable LLDP-MED topology change notifications for the port profile.
        """
        return pulumi.get(self, "lldpmed_notify_enabled")

    @lldpmed_notify_enabled.setter
    def lldpmed_notify_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "lldpmed_notify_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the port profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nativeNetworkconfId")
    def native_networkconf_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of network to use as the main network on the port profile.
        """
        return pulumi.get(self, "native_networkconf_id")

    @native_networkconf_id.setter
    def native_networkconf_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "native_networkconf_id", value)

    @property
    @pulumi.getter(name="opMode")
    def op_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The operation mode for the port profile. Can only be `switch` Defaults to `switch`.
        """
        return pulumi.get(self, "op_mode")

    @op_mode.setter
    def op_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "op_mode", value)

    @property
    @pulumi.getter(name="poeMode")
    def poe_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The POE mode for the port profile. Can be one of `auto`, `passv24`, `passthrough` or `off`.
        """
        return pulumi.get(self, "poe_mode")

    @poe_mode.setter
    def poe_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "poe_mode", value)

    @property
    @pulumi.getter(name="portSecurityEnabled")
    def port_security_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable port security for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "port_security_enabled")

    @port_security_enabled.setter
    def port_security_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "port_security_enabled", value)

    @property
    @pulumi.getter(name="portSecurityMacAddresses")
    def port_security_mac_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The MAC addresses associated with the port security for the port profile.
        """
        return pulumi.get(self, "port_security_mac_addresses")

    @port_security_mac_addresses.setter
    def port_security_mac_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "port_security_mac_addresses", value)

    @property
    @pulumi.getter(name="priorityQueue1Level")
    def priority_queue1_level(self) -> Optional[pulumi.Input[int]]:
        """
        The priority queue 1 level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "priority_queue1_level")

    @priority_queue1_level.setter
    def priority_queue1_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority_queue1_level", value)

    @property
    @pulumi.getter(name="priorityQueue2Level")
    def priority_queue2_level(self) -> Optional[pulumi.Input[int]]:
        """
        The priority queue 2 level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "priority_queue2_level")

    @priority_queue2_level.setter
    def priority_queue2_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority_queue2_level", value)

    @property
    @pulumi.getter(name="priorityQueue3Level")
    def priority_queue3_level(self) -> Optional[pulumi.Input[int]]:
        """
        The priority queue 3 level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "priority_queue3_level")

    @priority_queue3_level.setter
    def priority_queue3_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority_queue3_level", value)

    @property
    @pulumi.getter(name="priorityQueue4Level")
    def priority_queue4_level(self) -> Optional[pulumi.Input[int]]:
        """
        The priority queue 4 level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "priority_queue4_level")

    @priority_queue4_level.setter
    def priority_queue4_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority_queue4_level", value)

    @property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the site to associate the port profile with.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site", value)

    @property
    @pulumi.getter
    def speed(self) -> Optional[pulumi.Input[int]]:
        """
        The link speed to set for the port profile. Can be one of `10`, `100`, `1000`, `2500`, `5000`, `10000`, `20000`, `25000`, `40000`, `50000` or `100000`
        """
        return pulumi.get(self, "speed")

    @speed.setter
    def speed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "speed", value)

    @property
    @pulumi.getter(name="stormctrlBcastEnabled")
    def stormctrl_bcast_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable broadcast Storm Control for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "stormctrl_bcast_enabled")

    @stormctrl_bcast_enabled.setter
    def stormctrl_bcast_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stormctrl_bcast_enabled", value)

    @property
    @pulumi.getter(name="stormctrlBcastLevel")
    def stormctrl_bcast_level(self) -> Optional[pulumi.Input[int]]:
        """
        The broadcast Storm Control level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "stormctrl_bcast_level")

    @stormctrl_bcast_level.setter
    def stormctrl_bcast_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stormctrl_bcast_level", value)

    @property
    @pulumi.getter(name="stormctrlBcastRate")
    def stormctrl_bcast_rate(self) -> Optional[pulumi.Input[int]]:
        """
        The broadcast Storm Control rate for the port profile. Can be between 0 and 14880000.
        """
        return pulumi.get(self, "stormctrl_bcast_rate")

    @stormctrl_bcast_rate.setter
    def stormctrl_bcast_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stormctrl_bcast_rate", value)

    @property
    @pulumi.getter(name="stormctrlMcastEnabled")
    def stormctrl_mcast_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable multicast Storm Control for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "stormctrl_mcast_enabled")

    @stormctrl_mcast_enabled.setter
    def stormctrl_mcast_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stormctrl_mcast_enabled", value)

    @property
    @pulumi.getter(name="stormctrlMcastLevel")
    def stormctrl_mcast_level(self) -> Optional[pulumi.Input[int]]:
        """
        The multicast Storm Control level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "stormctrl_mcast_level")

    @stormctrl_mcast_level.setter
    def stormctrl_mcast_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stormctrl_mcast_level", value)

    @property
    @pulumi.getter(name="stormctrlMcastRate")
    def stormctrl_mcast_rate(self) -> Optional[pulumi.Input[int]]:
        """
        The multicast Storm Control rate for the port profile. Can be between 0 and 14880000.
        """
        return pulumi.get(self, "stormctrl_mcast_rate")

    @stormctrl_mcast_rate.setter
    def stormctrl_mcast_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stormctrl_mcast_rate", value)

    @property
    @pulumi.getter(name="stormctrlType")
    def stormctrl_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of Storm Control to use for the port profile. Can be one of `level` or `rate`.
        """
        return pulumi.get(self, "stormctrl_type")

    @stormctrl_type.setter
    def stormctrl_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stormctrl_type", value)

    @property
    @pulumi.getter(name="stormctrlUcastEnabled")
    def stormctrl_ucast_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable unknown unicast Storm Control for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "stormctrl_ucast_enabled")

    @stormctrl_ucast_enabled.setter
    def stormctrl_ucast_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stormctrl_ucast_enabled", value)

    @property
    @pulumi.getter(name="stormctrlUcastLevel")
    def stormctrl_ucast_level(self) -> Optional[pulumi.Input[int]]:
        """
        The unknown unicast Storm Control level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "stormctrl_ucast_level")

    @stormctrl_ucast_level.setter
    def stormctrl_ucast_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stormctrl_ucast_level", value)

    @property
    @pulumi.getter(name="stormctrlUcastRate")
    def stormctrl_ucast_rate(self) -> Optional[pulumi.Input[int]]:
        """
        The unknown unicast Storm Control rate for the port profile. Can be between 0 and 14880000.
        """
        return pulumi.get(self, "stormctrl_ucast_rate")

    @stormctrl_ucast_rate.setter
    def stormctrl_ucast_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stormctrl_ucast_rate", value)

    @property
    @pulumi.getter(name="stpPortMode")
    def stp_port_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable spanning tree protocol on the port profile. Defaults to `true`.
        """
        return pulumi.get(self, "stp_port_mode")

    @stp_port_mode.setter
    def stp_port_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stp_port_mode", value)

    @property
    @pulumi.getter(name="taggedNetworkconfIds")
    def tagged_networkconf_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IDs of networks to tag traffic with for the port profile.
        """
        return pulumi.get(self, "tagged_networkconf_ids")

    @tagged_networkconf_ids.setter
    def tagged_networkconf_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tagged_networkconf_ids", value)

    @property
    @pulumi.getter(name="voiceNetworkconfId")
    def voice_networkconf_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of network to use as the voice network on the port profile.
        """
        return pulumi.get(self, "voice_networkconf_id")

    @voice_networkconf_id.setter
    def voice_networkconf_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "voice_networkconf_id", value)


class Profile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoneg: Optional[pulumi.Input[bool]] = None,
                 dot1x_ctrl: Optional[pulumi.Input[str]] = None,
                 dot1x_idle_timeout: Optional[pulumi.Input[int]] = None,
                 egress_rate_limit_kbps: Optional[pulumi.Input[int]] = None,
                 egress_rate_limit_kbps_enabled: Optional[pulumi.Input[bool]] = None,
                 forward: Optional[pulumi.Input[str]] = None,
                 full_duplex: Optional[pulumi.Input[bool]] = None,
                 isolation: Optional[pulumi.Input[bool]] = None,
                 lldpmed_enabled: Optional[pulumi.Input[bool]] = None,
                 lldpmed_notify_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 native_networkconf_id: Optional[pulumi.Input[str]] = None,
                 op_mode: Optional[pulumi.Input[str]] = None,
                 poe_mode: Optional[pulumi.Input[str]] = None,
                 port_security_enabled: Optional[pulumi.Input[bool]] = None,
                 port_security_mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 priority_queue1_level: Optional[pulumi.Input[int]] = None,
                 priority_queue2_level: Optional[pulumi.Input[int]] = None,
                 priority_queue3_level: Optional[pulumi.Input[int]] = None,
                 priority_queue4_level: Optional[pulumi.Input[int]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 speed: Optional[pulumi.Input[int]] = None,
                 stormctrl_bcast_enabled: Optional[pulumi.Input[bool]] = None,
                 stormctrl_bcast_level: Optional[pulumi.Input[int]] = None,
                 stormctrl_bcast_rate: Optional[pulumi.Input[int]] = None,
                 stormctrl_mcast_enabled: Optional[pulumi.Input[bool]] = None,
                 stormctrl_mcast_level: Optional[pulumi.Input[int]] = None,
                 stormctrl_mcast_rate: Optional[pulumi.Input[int]] = None,
                 stormctrl_type: Optional[pulumi.Input[str]] = None,
                 stormctrl_ucast_enabled: Optional[pulumi.Input[bool]] = None,
                 stormctrl_ucast_level: Optional[pulumi.Input[int]] = None,
                 stormctrl_ucast_rate: Optional[pulumi.Input[int]] = None,
                 stp_port_mode: Optional[pulumi.Input[bool]] = None,
                 tagged_networkconf_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 voice_networkconf_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `port.Profile` manages a port profile for use on network switches.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_unifi as unifi

        config = pulumi.Config()
        vlan_id = config.get_float("vlanId")
        if vlan_id is None:
            vlan_id = 10
        vlan = unifi.Network("vlan",
            purpose="corporate",
            subnet="10.0.0.1/24",
            vlan_id=vlan_id,
            dhcp_start="10.0.0.6",
            dhcp_stop="10.0.0.254",
            dhcp_enabled=True)
        poe_disabled = unifi.port.Profile("poeDisabled",
            native_networkconf_id=vlan.id,
            poe_mode="off")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] autoneg: Enable link auto negotiation for the port profile. When set to `true` this overrides `speed`. Defaults to `true`.
        :param pulumi.Input[str] dot1x_ctrl: The type of 802.1X control to use. Can be `auto`, `force_authorized`, `force_unauthorized`, `mac_based` or `multi_host`. Defaults to `force_authorized`.
        :param pulumi.Input[int] dot1x_idle_timeout: The timeout, in seconds, to use when using the MAC Based 802.1X control. Can be between 0 and 65535 Defaults to `300`.
        :param pulumi.Input[int] egress_rate_limit_kbps: The egress rate limit, in kpbs, for the port profile. Can be between `64` and `9999999`.
        :param pulumi.Input[bool] egress_rate_limit_kbps_enabled: Enable egress rate limiting for the port profile. Defaults to `false`.
        :param pulumi.Input[str] forward: The type forwarding to use for the port profile. Can be `all`, `native`, `customize` or `disabled`. Defaults to `native`.
        :param pulumi.Input[bool] full_duplex: Enable full duplex for the port profile. Defaults to `false`.
        :param pulumi.Input[bool] isolation: Enable port isolation for the port profile. Defaults to `false`.
        :param pulumi.Input[bool] lldpmed_enabled: Enable LLDP-MED for the port profile. Defaults to `true`.
        :param pulumi.Input[bool] lldpmed_notify_enabled: Enable LLDP-MED topology change notifications for the port profile.
        :param pulumi.Input[str] name: The name of the port profile.
        :param pulumi.Input[str] native_networkconf_id: The ID of network to use as the main network on the port profile.
        :param pulumi.Input[str] op_mode: The operation mode for the port profile. Can only be `switch` Defaults to `switch`.
        :param pulumi.Input[str] poe_mode: The POE mode for the port profile. Can be one of `auto`, `passv24`, `passthrough` or `off`.
        :param pulumi.Input[bool] port_security_enabled: Enable port security for the port profile. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] port_security_mac_addresses: The MAC addresses associated with the port security for the port profile.
        :param pulumi.Input[int] priority_queue1_level: The priority queue 1 level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] priority_queue2_level: The priority queue 2 level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] priority_queue3_level: The priority queue 3 level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] priority_queue4_level: The priority queue 4 level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[str] site: The name of the site to associate the port profile with.
        :param pulumi.Input[int] speed: The link speed to set for the port profile. Can be one of `10`, `100`, `1000`, `2500`, `5000`, `10000`, `20000`, `25000`, `40000`, `50000` or `100000`
        :param pulumi.Input[bool] stormctrl_bcast_enabled: Enable broadcast Storm Control for the port profile. Defaults to `false`.
        :param pulumi.Input[int] stormctrl_bcast_level: The broadcast Storm Control level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] stormctrl_bcast_rate: The broadcast Storm Control rate for the port profile. Can be between 0 and 14880000.
        :param pulumi.Input[bool] stormctrl_mcast_enabled: Enable multicast Storm Control for the port profile. Defaults to `false`.
        :param pulumi.Input[int] stormctrl_mcast_level: The multicast Storm Control level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] stormctrl_mcast_rate: The multicast Storm Control rate for the port profile. Can be between 0 and 14880000.
        :param pulumi.Input[str] stormctrl_type: The type of Storm Control to use for the port profile. Can be one of `level` or `rate`.
        :param pulumi.Input[bool] stormctrl_ucast_enabled: Enable unknown unicast Storm Control for the port profile. Defaults to `false`.
        :param pulumi.Input[int] stormctrl_ucast_level: The unknown unicast Storm Control level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] stormctrl_ucast_rate: The unknown unicast Storm Control rate for the port profile. Can be between 0 and 14880000.
        :param pulumi.Input[bool] stp_port_mode: Enable spanning tree protocol on the port profile. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tagged_networkconf_ids: The IDs of networks to tag traffic with for the port profile.
        :param pulumi.Input[str] voice_networkconf_id: The ID of network to use as the voice network on the port profile.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProfileArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `port.Profile` manages a port profile for use on network switches.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_unifi as unifi

        config = pulumi.Config()
        vlan_id = config.get_float("vlanId")
        if vlan_id is None:
            vlan_id = 10
        vlan = unifi.Network("vlan",
            purpose="corporate",
            subnet="10.0.0.1/24",
            vlan_id=vlan_id,
            dhcp_start="10.0.0.6",
            dhcp_stop="10.0.0.254",
            dhcp_enabled=True)
        poe_disabled = unifi.port.Profile("poeDisabled",
            native_networkconf_id=vlan.id,
            poe_mode="off")
        ```

        :param str resource_name: The name of the resource.
        :param ProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoneg: Optional[pulumi.Input[bool]] = None,
                 dot1x_ctrl: Optional[pulumi.Input[str]] = None,
                 dot1x_idle_timeout: Optional[pulumi.Input[int]] = None,
                 egress_rate_limit_kbps: Optional[pulumi.Input[int]] = None,
                 egress_rate_limit_kbps_enabled: Optional[pulumi.Input[bool]] = None,
                 forward: Optional[pulumi.Input[str]] = None,
                 full_duplex: Optional[pulumi.Input[bool]] = None,
                 isolation: Optional[pulumi.Input[bool]] = None,
                 lldpmed_enabled: Optional[pulumi.Input[bool]] = None,
                 lldpmed_notify_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 native_networkconf_id: Optional[pulumi.Input[str]] = None,
                 op_mode: Optional[pulumi.Input[str]] = None,
                 poe_mode: Optional[pulumi.Input[str]] = None,
                 port_security_enabled: Optional[pulumi.Input[bool]] = None,
                 port_security_mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 priority_queue1_level: Optional[pulumi.Input[int]] = None,
                 priority_queue2_level: Optional[pulumi.Input[int]] = None,
                 priority_queue3_level: Optional[pulumi.Input[int]] = None,
                 priority_queue4_level: Optional[pulumi.Input[int]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 speed: Optional[pulumi.Input[int]] = None,
                 stormctrl_bcast_enabled: Optional[pulumi.Input[bool]] = None,
                 stormctrl_bcast_level: Optional[pulumi.Input[int]] = None,
                 stormctrl_bcast_rate: Optional[pulumi.Input[int]] = None,
                 stormctrl_mcast_enabled: Optional[pulumi.Input[bool]] = None,
                 stormctrl_mcast_level: Optional[pulumi.Input[int]] = None,
                 stormctrl_mcast_rate: Optional[pulumi.Input[int]] = None,
                 stormctrl_type: Optional[pulumi.Input[str]] = None,
                 stormctrl_ucast_enabled: Optional[pulumi.Input[bool]] = None,
                 stormctrl_ucast_level: Optional[pulumi.Input[int]] = None,
                 stormctrl_ucast_rate: Optional[pulumi.Input[int]] = None,
                 stp_port_mode: Optional[pulumi.Input[bool]] = None,
                 tagged_networkconf_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 voice_networkconf_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProfileArgs.__new__(ProfileArgs)

            __props__.__dict__["autoneg"] = autoneg
            __props__.__dict__["dot1x_ctrl"] = dot1x_ctrl
            __props__.__dict__["dot1x_idle_timeout"] = dot1x_idle_timeout
            __props__.__dict__["egress_rate_limit_kbps"] = egress_rate_limit_kbps
            __props__.__dict__["egress_rate_limit_kbps_enabled"] = egress_rate_limit_kbps_enabled
            __props__.__dict__["forward"] = forward
            __props__.__dict__["full_duplex"] = full_duplex
            __props__.__dict__["isolation"] = isolation
            __props__.__dict__["lldpmed_enabled"] = lldpmed_enabled
            __props__.__dict__["lldpmed_notify_enabled"] = lldpmed_notify_enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["native_networkconf_id"] = native_networkconf_id
            __props__.__dict__["op_mode"] = op_mode
            __props__.__dict__["poe_mode"] = poe_mode
            __props__.__dict__["port_security_enabled"] = port_security_enabled
            __props__.__dict__["port_security_mac_addresses"] = port_security_mac_addresses
            __props__.__dict__["priority_queue1_level"] = priority_queue1_level
            __props__.__dict__["priority_queue2_level"] = priority_queue2_level
            __props__.__dict__["priority_queue3_level"] = priority_queue3_level
            __props__.__dict__["priority_queue4_level"] = priority_queue4_level
            __props__.__dict__["site"] = site
            __props__.__dict__["speed"] = speed
            __props__.__dict__["stormctrl_bcast_enabled"] = stormctrl_bcast_enabled
            __props__.__dict__["stormctrl_bcast_level"] = stormctrl_bcast_level
            __props__.__dict__["stormctrl_bcast_rate"] = stormctrl_bcast_rate
            __props__.__dict__["stormctrl_mcast_enabled"] = stormctrl_mcast_enabled
            __props__.__dict__["stormctrl_mcast_level"] = stormctrl_mcast_level
            __props__.__dict__["stormctrl_mcast_rate"] = stormctrl_mcast_rate
            __props__.__dict__["stormctrl_type"] = stormctrl_type
            __props__.__dict__["stormctrl_ucast_enabled"] = stormctrl_ucast_enabled
            __props__.__dict__["stormctrl_ucast_level"] = stormctrl_ucast_level
            __props__.__dict__["stormctrl_ucast_rate"] = stormctrl_ucast_rate
            __props__.__dict__["stp_port_mode"] = stp_port_mode
            __props__.__dict__["tagged_networkconf_ids"] = tagged_networkconf_ids
            __props__.__dict__["voice_networkconf_id"] = voice_networkconf_id
        super(Profile, __self__).__init__(
            'unifi:port/profile:Profile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autoneg: Optional[pulumi.Input[bool]] = None,
            dot1x_ctrl: Optional[pulumi.Input[str]] = None,
            dot1x_idle_timeout: Optional[pulumi.Input[int]] = None,
            egress_rate_limit_kbps: Optional[pulumi.Input[int]] = None,
            egress_rate_limit_kbps_enabled: Optional[pulumi.Input[bool]] = None,
            forward: Optional[pulumi.Input[str]] = None,
            full_duplex: Optional[pulumi.Input[bool]] = None,
            isolation: Optional[pulumi.Input[bool]] = None,
            lldpmed_enabled: Optional[pulumi.Input[bool]] = None,
            lldpmed_notify_enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            native_networkconf_id: Optional[pulumi.Input[str]] = None,
            op_mode: Optional[pulumi.Input[str]] = None,
            poe_mode: Optional[pulumi.Input[str]] = None,
            port_security_enabled: Optional[pulumi.Input[bool]] = None,
            port_security_mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            priority_queue1_level: Optional[pulumi.Input[int]] = None,
            priority_queue2_level: Optional[pulumi.Input[int]] = None,
            priority_queue3_level: Optional[pulumi.Input[int]] = None,
            priority_queue4_level: Optional[pulumi.Input[int]] = None,
            site: Optional[pulumi.Input[str]] = None,
            speed: Optional[pulumi.Input[int]] = None,
            stormctrl_bcast_enabled: Optional[pulumi.Input[bool]] = None,
            stormctrl_bcast_level: Optional[pulumi.Input[int]] = None,
            stormctrl_bcast_rate: Optional[pulumi.Input[int]] = None,
            stormctrl_mcast_enabled: Optional[pulumi.Input[bool]] = None,
            stormctrl_mcast_level: Optional[pulumi.Input[int]] = None,
            stormctrl_mcast_rate: Optional[pulumi.Input[int]] = None,
            stormctrl_type: Optional[pulumi.Input[str]] = None,
            stormctrl_ucast_enabled: Optional[pulumi.Input[bool]] = None,
            stormctrl_ucast_level: Optional[pulumi.Input[int]] = None,
            stormctrl_ucast_rate: Optional[pulumi.Input[int]] = None,
            stp_port_mode: Optional[pulumi.Input[bool]] = None,
            tagged_networkconf_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            voice_networkconf_id: Optional[pulumi.Input[str]] = None) -> 'Profile':
        """
        Get an existing Profile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] autoneg: Enable link auto negotiation for the port profile. When set to `true` this overrides `speed`. Defaults to `true`.
        :param pulumi.Input[str] dot1x_ctrl: The type of 802.1X control to use. Can be `auto`, `force_authorized`, `force_unauthorized`, `mac_based` or `multi_host`. Defaults to `force_authorized`.
        :param pulumi.Input[int] dot1x_idle_timeout: The timeout, in seconds, to use when using the MAC Based 802.1X control. Can be between 0 and 65535 Defaults to `300`.
        :param pulumi.Input[int] egress_rate_limit_kbps: The egress rate limit, in kpbs, for the port profile. Can be between `64` and `9999999`.
        :param pulumi.Input[bool] egress_rate_limit_kbps_enabled: Enable egress rate limiting for the port profile. Defaults to `false`.
        :param pulumi.Input[str] forward: The type forwarding to use for the port profile. Can be `all`, `native`, `customize` or `disabled`. Defaults to `native`.
        :param pulumi.Input[bool] full_duplex: Enable full duplex for the port profile. Defaults to `false`.
        :param pulumi.Input[bool] isolation: Enable port isolation for the port profile. Defaults to `false`.
        :param pulumi.Input[bool] lldpmed_enabled: Enable LLDP-MED for the port profile. Defaults to `true`.
        :param pulumi.Input[bool] lldpmed_notify_enabled: Enable LLDP-MED topology change notifications for the port profile.
        :param pulumi.Input[str] name: The name of the port profile.
        :param pulumi.Input[str] native_networkconf_id: The ID of network to use as the main network on the port profile.
        :param pulumi.Input[str] op_mode: The operation mode for the port profile. Can only be `switch` Defaults to `switch`.
        :param pulumi.Input[str] poe_mode: The POE mode for the port profile. Can be one of `auto`, `passv24`, `passthrough` or `off`.
        :param pulumi.Input[bool] port_security_enabled: Enable port security for the port profile. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] port_security_mac_addresses: The MAC addresses associated with the port security for the port profile.
        :param pulumi.Input[int] priority_queue1_level: The priority queue 1 level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] priority_queue2_level: The priority queue 2 level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] priority_queue3_level: The priority queue 3 level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] priority_queue4_level: The priority queue 4 level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[str] site: The name of the site to associate the port profile with.
        :param pulumi.Input[int] speed: The link speed to set for the port profile. Can be one of `10`, `100`, `1000`, `2500`, `5000`, `10000`, `20000`, `25000`, `40000`, `50000` or `100000`
        :param pulumi.Input[bool] stormctrl_bcast_enabled: Enable broadcast Storm Control for the port profile. Defaults to `false`.
        :param pulumi.Input[int] stormctrl_bcast_level: The broadcast Storm Control level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] stormctrl_bcast_rate: The broadcast Storm Control rate for the port profile. Can be between 0 and 14880000.
        :param pulumi.Input[bool] stormctrl_mcast_enabled: Enable multicast Storm Control for the port profile. Defaults to `false`.
        :param pulumi.Input[int] stormctrl_mcast_level: The multicast Storm Control level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] stormctrl_mcast_rate: The multicast Storm Control rate for the port profile. Can be between 0 and 14880000.
        :param pulumi.Input[str] stormctrl_type: The type of Storm Control to use for the port profile. Can be one of `level` or `rate`.
        :param pulumi.Input[bool] stormctrl_ucast_enabled: Enable unknown unicast Storm Control for the port profile. Defaults to `false`.
        :param pulumi.Input[int] stormctrl_ucast_level: The unknown unicast Storm Control level for the port profile. Can be between 0 and 100.
        :param pulumi.Input[int] stormctrl_ucast_rate: The unknown unicast Storm Control rate for the port profile. Can be between 0 and 14880000.
        :param pulumi.Input[bool] stp_port_mode: Enable spanning tree protocol on the port profile. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tagged_networkconf_ids: The IDs of networks to tag traffic with for the port profile.
        :param pulumi.Input[str] voice_networkconf_id: The ID of network to use as the voice network on the port profile.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProfileState.__new__(_ProfileState)

        __props__.__dict__["autoneg"] = autoneg
        __props__.__dict__["dot1x_ctrl"] = dot1x_ctrl
        __props__.__dict__["dot1x_idle_timeout"] = dot1x_idle_timeout
        __props__.__dict__["egress_rate_limit_kbps"] = egress_rate_limit_kbps
        __props__.__dict__["egress_rate_limit_kbps_enabled"] = egress_rate_limit_kbps_enabled
        __props__.__dict__["forward"] = forward
        __props__.__dict__["full_duplex"] = full_duplex
        __props__.__dict__["isolation"] = isolation
        __props__.__dict__["lldpmed_enabled"] = lldpmed_enabled
        __props__.__dict__["lldpmed_notify_enabled"] = lldpmed_notify_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["native_networkconf_id"] = native_networkconf_id
        __props__.__dict__["op_mode"] = op_mode
        __props__.__dict__["poe_mode"] = poe_mode
        __props__.__dict__["port_security_enabled"] = port_security_enabled
        __props__.__dict__["port_security_mac_addresses"] = port_security_mac_addresses
        __props__.__dict__["priority_queue1_level"] = priority_queue1_level
        __props__.__dict__["priority_queue2_level"] = priority_queue2_level
        __props__.__dict__["priority_queue3_level"] = priority_queue3_level
        __props__.__dict__["priority_queue4_level"] = priority_queue4_level
        __props__.__dict__["site"] = site
        __props__.__dict__["speed"] = speed
        __props__.__dict__["stormctrl_bcast_enabled"] = stormctrl_bcast_enabled
        __props__.__dict__["stormctrl_bcast_level"] = stormctrl_bcast_level
        __props__.__dict__["stormctrl_bcast_rate"] = stormctrl_bcast_rate
        __props__.__dict__["stormctrl_mcast_enabled"] = stormctrl_mcast_enabled
        __props__.__dict__["stormctrl_mcast_level"] = stormctrl_mcast_level
        __props__.__dict__["stormctrl_mcast_rate"] = stormctrl_mcast_rate
        __props__.__dict__["stormctrl_type"] = stormctrl_type
        __props__.__dict__["stormctrl_ucast_enabled"] = stormctrl_ucast_enabled
        __props__.__dict__["stormctrl_ucast_level"] = stormctrl_ucast_level
        __props__.__dict__["stormctrl_ucast_rate"] = stormctrl_ucast_rate
        __props__.__dict__["stp_port_mode"] = stp_port_mode
        __props__.__dict__["tagged_networkconf_ids"] = tagged_networkconf_ids
        __props__.__dict__["voice_networkconf_id"] = voice_networkconf_id
        return Profile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def autoneg(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable link auto negotiation for the port profile. When set to `true` this overrides `speed`. Defaults to `true`.
        """
        return pulumi.get(self, "autoneg")

    @property
    @pulumi.getter(name="dot1xCtrl")
    def dot1x_ctrl(self) -> pulumi.Output[Optional[str]]:
        """
        The type of 802.1X control to use. Can be `auto`, `force_authorized`, `force_unauthorized`, `mac_based` or `multi_host`. Defaults to `force_authorized`.
        """
        return pulumi.get(self, "dot1x_ctrl")

    @property
    @pulumi.getter(name="dot1xIdleTimeout")
    def dot1x_idle_timeout(self) -> pulumi.Output[Optional[int]]:
        """
        The timeout, in seconds, to use when using the MAC Based 802.1X control. Can be between 0 and 65535 Defaults to `300`.
        """
        return pulumi.get(self, "dot1x_idle_timeout")

    @property
    @pulumi.getter(name="egressRateLimitKbps")
    def egress_rate_limit_kbps(self) -> pulumi.Output[Optional[int]]:
        """
        The egress rate limit, in kpbs, for the port profile. Can be between `64` and `9999999`.
        """
        return pulumi.get(self, "egress_rate_limit_kbps")

    @property
    @pulumi.getter(name="egressRateLimitKbpsEnabled")
    def egress_rate_limit_kbps_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable egress rate limiting for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "egress_rate_limit_kbps_enabled")

    @property
    @pulumi.getter
    def forward(self) -> pulumi.Output[Optional[str]]:
        """
        The type forwarding to use for the port profile. Can be `all`, `native`, `customize` or `disabled`. Defaults to `native`.
        """
        return pulumi.get(self, "forward")

    @property
    @pulumi.getter(name="fullDuplex")
    def full_duplex(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable full duplex for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "full_duplex")

    @property
    @pulumi.getter
    def isolation(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable port isolation for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "isolation")

    @property
    @pulumi.getter(name="lldpmedEnabled")
    def lldpmed_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable LLDP-MED for the port profile. Defaults to `true`.
        """
        return pulumi.get(self, "lldpmed_enabled")

    @property
    @pulumi.getter(name="lldpmedNotifyEnabled")
    def lldpmed_notify_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable LLDP-MED topology change notifications for the port profile.
        """
        return pulumi.get(self, "lldpmed_notify_enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the port profile.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nativeNetworkconfId")
    def native_networkconf_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of network to use as the main network on the port profile.
        """
        return pulumi.get(self, "native_networkconf_id")

    @property
    @pulumi.getter(name="opMode")
    def op_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The operation mode for the port profile. Can only be `switch` Defaults to `switch`.
        """
        return pulumi.get(self, "op_mode")

    @property
    @pulumi.getter(name="poeMode")
    def poe_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The POE mode for the port profile. Can be one of `auto`, `passv24`, `passthrough` or `off`.
        """
        return pulumi.get(self, "poe_mode")

    @property
    @pulumi.getter(name="portSecurityEnabled")
    def port_security_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable port security for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "port_security_enabled")

    @property
    @pulumi.getter(name="portSecurityMacAddresses")
    def port_security_mac_addresses(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The MAC addresses associated with the port security for the port profile.
        """
        return pulumi.get(self, "port_security_mac_addresses")

    @property
    @pulumi.getter(name="priorityQueue1Level")
    def priority_queue1_level(self) -> pulumi.Output[Optional[int]]:
        """
        The priority queue 1 level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "priority_queue1_level")

    @property
    @pulumi.getter(name="priorityQueue2Level")
    def priority_queue2_level(self) -> pulumi.Output[Optional[int]]:
        """
        The priority queue 2 level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "priority_queue2_level")

    @property
    @pulumi.getter(name="priorityQueue3Level")
    def priority_queue3_level(self) -> pulumi.Output[Optional[int]]:
        """
        The priority queue 3 level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "priority_queue3_level")

    @property
    @pulumi.getter(name="priorityQueue4Level")
    def priority_queue4_level(self) -> pulumi.Output[Optional[int]]:
        """
        The priority queue 4 level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "priority_queue4_level")

    @property
    @pulumi.getter
    def site(self) -> pulumi.Output[str]:
        """
        The name of the site to associate the port profile with.
        """
        return pulumi.get(self, "site")

    @property
    @pulumi.getter
    def speed(self) -> pulumi.Output[Optional[int]]:
        """
        The link speed to set for the port profile. Can be one of `10`, `100`, `1000`, `2500`, `5000`, `10000`, `20000`, `25000`, `40000`, `50000` or `100000`
        """
        return pulumi.get(self, "speed")

    @property
    @pulumi.getter(name="stormctrlBcastEnabled")
    def stormctrl_bcast_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable broadcast Storm Control for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "stormctrl_bcast_enabled")

    @property
    @pulumi.getter(name="stormctrlBcastLevel")
    def stormctrl_bcast_level(self) -> pulumi.Output[Optional[int]]:
        """
        The broadcast Storm Control level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "stormctrl_bcast_level")

    @property
    @pulumi.getter(name="stormctrlBcastRate")
    def stormctrl_bcast_rate(self) -> pulumi.Output[Optional[int]]:
        """
        The broadcast Storm Control rate for the port profile. Can be between 0 and 14880000.
        """
        return pulumi.get(self, "stormctrl_bcast_rate")

    @property
    @pulumi.getter(name="stormctrlMcastEnabled")
    def stormctrl_mcast_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable multicast Storm Control for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "stormctrl_mcast_enabled")

    @property
    @pulumi.getter(name="stormctrlMcastLevel")
    def stormctrl_mcast_level(self) -> pulumi.Output[Optional[int]]:
        """
        The multicast Storm Control level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "stormctrl_mcast_level")

    @property
    @pulumi.getter(name="stormctrlMcastRate")
    def stormctrl_mcast_rate(self) -> pulumi.Output[Optional[int]]:
        """
        The multicast Storm Control rate for the port profile. Can be between 0 and 14880000.
        """
        return pulumi.get(self, "stormctrl_mcast_rate")

    @property
    @pulumi.getter(name="stormctrlType")
    def stormctrl_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of Storm Control to use for the port profile. Can be one of `level` or `rate`.
        """
        return pulumi.get(self, "stormctrl_type")

    @property
    @pulumi.getter(name="stormctrlUcastEnabled")
    def stormctrl_ucast_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable unknown unicast Storm Control for the port profile. Defaults to `false`.
        """
        return pulumi.get(self, "stormctrl_ucast_enabled")

    @property
    @pulumi.getter(name="stormctrlUcastLevel")
    def stormctrl_ucast_level(self) -> pulumi.Output[Optional[int]]:
        """
        The unknown unicast Storm Control level for the port profile. Can be between 0 and 100.
        """
        return pulumi.get(self, "stormctrl_ucast_level")

    @property
    @pulumi.getter(name="stormctrlUcastRate")
    def stormctrl_ucast_rate(self) -> pulumi.Output[Optional[int]]:
        """
        The unknown unicast Storm Control rate for the port profile. Can be between 0 and 14880000.
        """
        return pulumi.get(self, "stormctrl_ucast_rate")

    @property
    @pulumi.getter(name="stpPortMode")
    def stp_port_mode(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable spanning tree protocol on the port profile. Defaults to `true`.
        """
        return pulumi.get(self, "stp_port_mode")

    @property
    @pulumi.getter(name="taggedNetworkconfIds")
    def tagged_networkconf_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The IDs of networks to tag traffic with for the port profile.
        """
        return pulumi.get(self, "tagged_networkconf_ids")

    @property
    @pulumi.getter(name="voiceNetworkconfId")
    def voice_networkconf_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of network to use as the voice network on the port profile.
        """
        return pulumi.get(self, "voice_networkconf_id")

