# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, blocked=None, dev_id_override=None, fixed_ip=None, hostname=None, id=None, ip=None, mac=None, name=None, network_id=None, note=None, site=None, user_group_id=None):
        if blocked and not isinstance(blocked, bool):
            raise TypeError("Expected argument 'blocked' to be a bool")
        pulumi.set(__self__, "blocked", blocked)
        if dev_id_override and not isinstance(dev_id_override, int):
            raise TypeError("Expected argument 'dev_id_override' to be a int")
        pulumi.set(__self__, "dev_id_override", dev_id_override)
        if fixed_ip and not isinstance(fixed_ip, str):
            raise TypeError("Expected argument 'fixed_ip' to be a str")
        pulumi.set(__self__, "fixed_ip", fixed_ip)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip and not isinstance(ip, str):
            raise TypeError("Expected argument 'ip' to be a str")
        pulumi.set(__self__, "ip", ip)
        if mac and not isinstance(mac, str):
            raise TypeError("Expected argument 'mac' to be a str")
        pulumi.set(__self__, "mac", mac)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if note and not isinstance(note, str):
            raise TypeError("Expected argument 'note' to be a str")
        pulumi.set(__self__, "note", note)
        if site and not isinstance(site, str):
            raise TypeError("Expected argument 'site' to be a str")
        pulumi.set(__self__, "site", site)
        if user_group_id and not isinstance(user_group_id, str):
            raise TypeError("Expected argument 'user_group_id' to be a str")
        pulumi.set(__self__, "user_group_id", user_group_id)

    @property
    @pulumi.getter
    def blocked(self) -> bool:
        """
        Specifies whether this user should be blocked from the network.
        """
        return pulumi.get(self, "blocked")

    @property
    @pulumi.getter(name="devIdOverride")
    def dev_id_override(self) -> int:
        """
        Override the device fingerprint.
        """
        return pulumi.get(self, "dev_id_override")

    @property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> str:
        """
        fixed IPv4 address set for this user.
        """
        return pulumi.get(self, "fixed_ip")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        The hostname of the user.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the user.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        The IP address of the user.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def mac(self) -> str:
        """
        The MAC address of the user.
        """
        return pulumi.get(self, "mac")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> str:
        """
        The network ID for this user.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def note(self) -> str:
        """
        A note with additional information for the user.
        """
        return pulumi.get(self, "note")

    @property
    @pulumi.getter
    def site(self) -> str:
        """
        The name of the site the user is associated with.
        """
        return pulumi.get(self, "site")

    @property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> str:
        """
        The user group ID for the user.
        """
        return pulumi.get(self, "user_group_id")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            blocked=self.blocked,
            dev_id_override=self.dev_id_override,
            fixed_ip=self.fixed_ip,
            hostname=self.hostname,
            id=self.id,
            ip=self.ip,
            mac=self.mac,
            name=self.name,
            network_id=self.network_id,
            note=self.note,
            site=self.site,
            user_group_id=self.user_group_id)


def get_user(mac: Optional[str] = None,
             site: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    `iam.User` retrieves properties of a user (or "client" in the UI) of the network by MAC address.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_unifi as unifi

    client = unifi.iam.get_user(mac="01:23:45:67:89:ab")
    ```


    :param str mac: The MAC address of the user.
    :param str site: The name of the site the user is associated with.
    """
    __args__ = dict()
    __args__['mac'] = mac
    __args__['site'] = site
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('unifi:iam/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        blocked=__ret__.blocked,
        dev_id_override=__ret__.dev_id_override,
        fixed_ip=__ret__.fixed_ip,
        hostname=__ret__.hostname,
        id=__ret__.id,
        ip=__ret__.ip,
        mac=__ret__.mac,
        name=__ret__.name,
        network_id=__ret__.network_id,
        note=__ret__.note,
        site=__ret__.site,
        user_group_id=__ret__.user_group_id)


@_utilities.lift_output_func(get_user)
def get_user_output(mac: Optional[pulumi.Input[str]] = None,
                    site: Optional[pulumi.Input[Optional[str]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserResult]:
    """
    `iam.User` retrieves properties of a user (or "client" in the UI) of the network by MAC address.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_unifi as unifi

    client = unifi.iam.get_user(mac="01:23:45:67:89:ab")
    ```


    :param str mac: The MAC address of the user.
    :param str site: The name of the site the user is associated with.
    """
    ...
