# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetRadiusProfileResult',
    'AwaitableGetRadiusProfileResult',
    'get_radius_profile',
    'get_radius_profile_output',
]

@pulumi.output_type
class GetRadiusProfileResult:
    """
    A collection of values returned by getRadiusProfile.
    """
    def __init__(__self__, id=None, name=None, site=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if site and not isinstance(site, str):
            raise TypeError("Expected argument 'site' to be a str")
        pulumi.set(__self__, "site", site)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of this AP group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the RADIUS profile to look up. Defaults to `Default`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def site(self) -> str:
        """
        The name of the site the radius profile is associated with.
        """
        return pulumi.get(self, "site")


class AwaitableGetRadiusProfileResult(GetRadiusProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRadiusProfileResult(
            id=self.id,
            name=self.name,
            site=self.site)


def get_radius_profile(name: Optional[str] = None,
                       site: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRadiusProfileResult:
    """
    `get_radius_profile` data source can be used to retrieve the ID for a RADIUS profile by name.


    :param str name: The name of the RADIUS profile to look up. Defaults to `Default`.
    :param str site: The name of the site the radius profile is associated with.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['site'] = site
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('unifi:index/getRadiusProfile:getRadiusProfile', __args__, opts=opts, typ=GetRadiusProfileResult).value

    return AwaitableGetRadiusProfileResult(
        id=__ret__.id,
        name=__ret__.name,
        site=__ret__.site)


@_utilities.lift_output_func(get_radius_profile)
def get_radius_profile_output(name: Optional[pulumi.Input[Optional[str]]] = None,
                              site: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRadiusProfileResult]:
    """
    `get_radius_profile` data source can be used to retrieve the ID for a RADIUS profile by name.


    :param str name: The name of the RADIUS profile to look up. Defaults to `Default`.
    :param str site: The name of the site the radius profile is associated with.
    """
    ...
