# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetApGroupResult',
    'AwaitableGetApGroupResult',
    'get_ap_group',
    'get_ap_group_output',
]

@pulumi.output_type
class GetApGroupResult:
    """
    A collection of values returned by getApGroup.
    """
    def __init__(__self__, id=None, name=None, site=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if site and not isinstance(site, str):
            raise TypeError("Expected argument 'site' to be a str")
        pulumi.set(__self__, "site", site)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of this AP group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the AP group to look up, leave blank to look up the default AP group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def site(self) -> str:
        """
        The name of the site the AP group is associated with.
        """
        return pulumi.get(self, "site")


class AwaitableGetApGroupResult(GetApGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApGroupResult(
            id=self.id,
            name=self.name,
            site=self.site)


def get_ap_group(name: Optional[str] = None,
                 site: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApGroupResult:
    """
    `get_ap_group` data source can be used to retrieve the ID for an AP group by name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_unifi as unifi

    default = unifi.get_ap_group()
    ```


    :param str name: The name of the AP group to look up, leave blank to look up the default AP group.
    :param str site: The name of the site the AP group is associated with.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['site'] = site
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('unifi:index/getApGroup:getApGroup', __args__, opts=opts, typ=GetApGroupResult).value

    return AwaitableGetApGroupResult(
        id=__ret__.id,
        name=__ret__.name,
        site=__ret__.site)


@_utilities.lift_output_func(get_ap_group)
def get_ap_group_output(name: Optional[pulumi.Input[Optional[str]]] = None,
                        site: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetApGroupResult]:
    """
    `get_ap_group` data source can be used to retrieve the ID for an AP group by name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_unifi as unifi

    default = unifi.get_ap_group()
    ```


    :param str name: The name of the AP group to look up, leave blank to look up the default AP group.
    :param str site: The name of the site the AP group is associated with.
    """
    ...
