"""Initialize all

Revision ID: b92797939348
Revises: 
Create Date: 2020-12-27 22:22:09.374933

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'b92797939348'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('offer',
    sa.Column('offer_id', sa.Integer(), nullable=False),
    sa.Column('created', sa.DateTime(), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=False),
    sa.Column('squeak_hash', sa.String(length=64), nullable=False),
    sa.Column('payment_hash', sa.String(length=64), nullable=False),
    sa.Column('nonce', sa.String(length=64), nullable=False),
    sa.Column('payment_point', sa.String(length=66), nullable=False),
    sa.Column('invoice_timestamp', sa.Integer(), nullable=False),
    sa.Column('invoice_expiry', sa.Integer(), nullable=False),
    sa.Column('price_msat', sa.Integer(), nullable=False),
    sa.Column('payment_request', sa.String(), nullable=False),
    sa.Column('destination', sa.String(length=66), nullable=False),
    sa.Column('node_host', sa.String(), nullable=False),
    sa.Column('node_port', sa.Integer(), nullable=False),
    sa.Column('peer_id', sa.Integer(), nullable=False),
    sa.PrimaryKeyConstraint('offer_id')
    )
    op.create_table('peer',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('created', sa.DateTime(), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=False),
    sa.Column('peer_name', sa.String(), nullable=True),
    sa.Column('server_host', sa.String(), nullable=False),
    sa.Column('server_port', sa.Integer(), nullable=False),
    sa.Column('uploading', sa.Boolean(), nullable=False),
    sa.Column('downloading', sa.Boolean(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('profile',
    sa.Column('profile_id', sa.Integer(), nullable=False),
    sa.Column('created', sa.DateTime(), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=False),
    sa.Column('profile_name', sa.String(), nullable=False),
    sa.Column('private_key', sa.Binary(), nullable=True),
    sa.Column('address', sa.String(length=35), nullable=False),
    sa.Column('sharing', sa.Boolean(), nullable=False),
    sa.Column('following', sa.Boolean(), nullable=False),
    sa.PrimaryKeyConstraint('profile_id'),
    sa.UniqueConstraint('address'),
    sa.UniqueConstraint('profile_name')
    )
    op.create_table('received_payment',
    sa.Column('received_payment_id', sa.Integer(), nullable=False),
    sa.Column('created', sa.DateTime(), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=False),
    sa.Column('squeak_hash', sa.String(length=64), nullable=False),
    sa.Column('payment_hash', sa.String(length=64), nullable=False),
    sa.Column('price_msat', sa.Integer(), nullable=False),
    sa.Column('settle_index', sa.Integer(), nullable=False),
    sa.Column('client_addr', sa.String(length=64), nullable=False),
    sa.PrimaryKeyConstraint('received_payment_id'),
    sa.UniqueConstraint('payment_hash')
    )
    op.create_table('sent_offer',
    sa.Column('sent_offer_id', sa.Integer(), nullable=False),
    sa.Column('created', sa.DateTime(), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=False),
    sa.Column('squeak_hash', sa.String(length=64), nullable=False),
    sa.Column('payment_hash', sa.String(length=64), nullable=False),
    sa.Column('secret_key', sa.String(length=64), nullable=False),
    sa.Column('nonce', sa.String(length=64), nullable=False),
    sa.Column('price_msat', sa.Integer(), nullable=False),
    sa.Column('payment_request', sa.String(), nullable=False),
    sa.Column('invoice_timestamp', sa.Integer(), nullable=False),
    sa.Column('invoice_expiry', sa.Integer(), nullable=False),
    sa.Column('client_addr', sa.String(length=64), nullable=False),
    sa.PrimaryKeyConstraint('sent_offer_id'),
    sa.UniqueConstraint('payment_hash')
    )
    op.create_table('sent_payment',
    sa.Column('sent_payment_id', sa.Integer(), nullable=False),
    sa.Column('created', sa.DateTime(), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=False),
    sa.Column('offer_id', sa.Integer(), nullable=False),
    sa.Column('peer_id', sa.Integer(), nullable=False),
    sa.Column('squeak_hash', sa.String(length=64), nullable=False),
    sa.Column('payment_hash', sa.String(length=64), nullable=False),
    sa.Column('secret_key', sa.String(length=64), nullable=False),
    sa.Column('price_msat', sa.Integer(), nullable=False),
    sa.Column('node_pubkey', sa.String(length=66), nullable=False),
    sa.PrimaryKeyConstraint('sent_payment_id')
    )
    op.create_table('squeak',
    sa.Column('hash', sa.String(length=64), nullable=False),
    sa.Column('created', sa.DateTime(), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=False),
    sa.Column('squeak', sa.Binary(), nullable=False),
    sa.Column('hash_reply_sqk', sa.String(length=64), nullable=False),
    sa.Column('hash_block', sa.String(length=64), nullable=False),
    sa.Column('n_block_height', sa.Integer(), nullable=False),
    sa.Column('n_time', sa.Integer(), nullable=False),
    sa.Column('author_address', sa.String(length=35), nullable=False),
    sa.Column('secret_key', sa.String(length=64), nullable=True),
    sa.Column('block_header', sa.Binary(), nullable=False),
    sa.PrimaryKeyConstraint('hash')
    )
    with op.batch_alter_table('squeak', schema=None) as batch_op:
        batch_op.create_index(batch_op.f('ix_squeak_author_address'), ['author_address'], unique=False)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('squeak', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('ix_squeak_author_address'))

    op.drop_table('squeak')
    op.drop_table('sent_payment')
    op.drop_table('sent_offer')
    op.drop_table('received_payment')
    op.drop_table('profile')
    op.drop_table('peer')
    op.drop_table('offer')
    # ### end Alembic commands ###
