import unittest
import os
import sys
import time
parentPath = os.path.abspath("..")
if parentPath not in sys.path:
    sys.path.insert(0, parentPath)

from pybtc.functions import *
from pybtc.transaction import *
from binascii import unhexlify
from pybtc import address_to_hash as address2hash160


def decode_block_tx(block):
    stream = get_stream(block)
    stream.seek(80)
    return {i: Transaction(stream, format="raw") for i in range(var_int_to_int(read_var_int(stream)))}


class TransactionDeserializeTests(unittest.TestCase):
    @classmethod
    def setUpClass(cls):
        print("\nTesting Transaction class deserialization:\n")

    def test_serialaize_and_perfomance(self):
        f = open(ROOT_DIR + '/test/raw_block.txt')
        fc = f.readline()
        qt = time.time()
        bt = decode_block_tx(fc[:-1])
        self.assertEqual(time.time() - qt < 1, 1)
        print("decode block tx count: %s time: %s" % (len(bt), time.time() - qt))
        for t in bt:
            raw_tx_legacy = bt[t].serialize(segwit=False)
            raw_tx_segwit = bt[t].serialize()
            bt[t] = bt[t].decode()
            # print(bt[t]["txId"], bt[t]["hash"], "segwit:",
            #       True if "segwit" in bt[t] else False, end = " ")
            self.assertEqual(bt[t].serialize(segwit=False), raw_tx_legacy)
            self.assertEqual(bt[t].serialize(), raw_tx_segwit)
            self.assertEqual(rh2s(double_sha256(bt[t].serialize())), bt[t]["hash"])
            self.assertEqual(rh2s(double_sha256(bt[t].serialize(segwit=False))), bt[t]["txId"])
            # print("OK")

    def test_segwit_deserialize(self):
        non_segwit_view = "020000000140d43a99926d43eb0e619bf0b3d83b4a31f60c176beecfb9d35bf45e54d0f7420" \
                          "100000017160014a4b4ca48de0b3fffc15404a1acdc8dbaae226955ffffffff0100e1f50500" \
                          "00000017a9144a1154d50b03292b3024370901711946cb7cccc38700000000"
        segwit_view = "0200000000010140d43a99926d43eb0e619bf0b3d83b4a31f60c176beecfb9d35bf45e54d0f7420" \
                      "100000017160014a4b4ca48de0b3fffc15404a1acdc8dbaae226955ffffffff0100e1f505000000" \
                      "0017a9144a1154d50b03292b3024370901711946cb7cccc387024830450221008604ef8f6d8afa8" \
                      "92dee0f31259b6ce02dd70c545cfcfed8148179971876c54a022076d771d6e91bed212783c9b06e" \
                      "0de600fab2d518fad6f15a2b191d7fbd262a3e0121039d25ab79f41f75ceaf882411fd41fa670a4" \
                      "c672c23ffaf0e361a969cde0692e800000000"
        print("Deserialize Segwit transaction")
        ns = Transaction(non_segwit_view)
        s = Transaction(segwit_view)
        self.assertEqual(s.serialize(segwit=False, hex = True), non_segwit_view)
        self.assertEqual(s.serialize(segwit=True, hex = True), segwit_view)
        self.assertEqual(ns.serialize(segwit=False, hex = True), non_segwit_view)

        non_segwit_view = "01000000060c02c24bbfefd94cdc4f58a3f83f93e05b14ad968ec6aba54190c3dcba6eef1b00" \
                          "000000da00483045022100f4dbf2ca7b5da97bd78818635d48004e6bf1a6f7e5e24bcecb7d93" \
                          "f554e49eaf02200a05025d93475b6372d14bd8fe8366fe10570ade772b19d124d3b0175b9f6e" \
                          "da0147304402202290feb53fc4cb077c5d3eed0ed5367fef4011ac708c1acaaa5003e4ed680d" \
                          "df022012c52160ae6b85fc59ceed80c7cacd5358b80712371733de7c76fef552114ee6014752" \
                          "2103ee30ea502d692ecfc79dfcb6fb2d6914fc70ba80db971beebacccdbaed40d7c52102f52d" \
                          "b885d04dc43ca8562471759dd621b899faf508caba70963d9228bfd2415e52ae00000000dab0" \
                          "20ee0a80a818e4d20a52aa7ba367a0a2d430d22c26ccb4572527e259e14a01000000d9004730" \
                          "44022064745ac8cae859bb19305a550981b8d39b69efec55b9a423dca645cd3b5c845502205c" \
                          "f375839d7f056235feb550a8138a03e75fa140503a2ce61fe239a3bfe4214501473044022072" \
                          "8b0393d5427d8abb56a608c6b1a0b14c5455f3abeb56ce8a5c7f70035af71d022052a99e4e38" \
                          "9790b364f6180caf1523d6da2b3daabe85952705023be2b5409b360147522103e296937dbdaf" \
                          "dae4d0a45b33d9a691b0c0e71d97bd2ffc82da895a251f74bd7e2103ead7ad0c398f928cbe85" \
                          "1a6b387a5e74d139487caf4d4ac3dc3d478254dbbb4452ae0000000067a6c2e2f14fc412b3f5" \
                          "627fafac2fe43009bc403ec680839579444df2ce042b00000000da00483045022100d3bdc055" \
                          "fa5dcce335a1d572b1c3ccb8cc9ba91960c6361c77e29ded716e233102200e7ebb43fd39fb98" \
                          "c714098d4fda32d94cdbefdd96c0c918b788aacc6164953c0147304402202f4338d2710edb19" \
                          "60dcf7136411f065a16bee4e44b86604d64c660315bc55040220238c1c3216feb31051f77982" \
                          "97317819da1dfa830d24a6a9e38a37367a68ebd101475221037b2987df626510ce25e6ce5fdb" \
                          "716705e23fecb7398b2cbb0a1c0af7ca5da717210345e358653b4580b5bd68d263089a0a2bf9" \
                          "fcc1e145fcf2a3d4b9ab5cd7e1a76752ae000000004f28d63103dfb86a5d92d2daf328bbb35d" \
                          "72239766a5853b7076a90d1745813200000000da00483045022100e89ac8215ee87186de284c" \
                          "419b2522ebfb2ecb8063d0f91942f2ad63f383d3d4022036485902bb1f2e0b2cc645aab8781d" \
                          "ef27f25e91d8256d48dd48d5cfca1a21c20147304402201449379f1d57f2b7ad1dc0882f5962" \
                          "7287a6c32180ffa7637941b0eaa666dd4b022028eb0eed77e1b92de046098c855834a5feeade" \
                          "a55d17160bc6d11d47184e8b51014752210283db605dc305201ab9be509a22d2c83b388002fb" \
                          "54ecd82d86efe83c0a1d35822103146f745eff0ae31fe899aafd27d51d2c0f5b0c03f2f47b3c" \
                          "65bb26ec7581ad8652ae0000000021cb3b00d1f22455e76e86872e00ef556578bcc112071e6a" \
                          "5b4ac02ab682fdb301000000232200206ea344e9a4a8f8a8983479af2ae3ed29fab153955af1" \
                          "4457780a304a6832b9c50000000016dcc4b40a514c43ed61d6c01a9006d7f21a6d30b99b3e58" \
                          "0d21578e35002502000000002322002049ea1f7c280b32fee0dce2e1801df2218df59d64614c" \
                          "4fe76c043ee2c80116700000000002005ed0b20000000017a91495c5c19257aa52bd4b702ba1" \
                          "a5e29b8d72a75a3a876d6b4e010000000017a91487b6255a5df746188f0bd22ed0194a40ec98" \
                          "f2de87be810700"
        segwit_view = "010000000001060c02c24bbfefd94cdc4f58a3f83f93e05b14ad968ec6aba54190c3dcba6eef1b00" \
                      "000000da00483045022100f4dbf2ca7b5da97bd78818635d48004e6bf1a6f7e5e24bcecb7d93f554" \
                      "e49eaf02200a05025d93475b6372d14bd8fe8366fe10570ade772b19d124d3b0175b9f6eda014730" \
                      "4402202290feb53fc4cb077c5d3eed0ed5367fef4011ac708c1acaaa5003e4ed680ddf022012c521" \
                      "60ae6b85fc59ceed80c7cacd5358b80712371733de7c76fef552114ee60147522103ee30ea502d69" \
                      "2ecfc79dfcb6fb2d6914fc70ba80db971beebacccdbaed40d7c52102f52db885d04dc43ca8562471" \
                      "759dd621b899faf508caba70963d9228bfd2415e52ae00000000dab020ee0a80a818e4d20a52aa7b" \
                      "a367a0a2d430d22c26ccb4572527e259e14a01000000d900473044022064745ac8cae859bb19305a" \
                      "550981b8d39b69efec55b9a423dca645cd3b5c845502205cf375839d7f056235feb550a8138a03e7" \
                      "5fa140503a2ce61fe239a3bfe42145014730440220728b0393d5427d8abb56a608c6b1a0b14c5455" \
                      "f3abeb56ce8a5c7f70035af71d022052a99e4e389790b364f6180caf1523d6da2b3daabe85952705" \
                      "023be2b5409b360147522103e296937dbdafdae4d0a45b33d9a691b0c0e71d97bd2ffc82da895a25" \
                      "1f74bd7e2103ead7ad0c398f928cbe851a6b387a5e74d139487caf4d4ac3dc3d478254dbbb4452ae" \
                      "0000000067a6c2e2f14fc412b3f5627fafac2fe43009bc403ec680839579444df2ce042b00000000" \
                      "da00483045022100d3bdc055fa5dcce335a1d572b1c3ccb8cc9ba91960c6361c77e29ded716e2331" \
                      "02200e7ebb43fd39fb98c714098d4fda32d94cdbefdd96c0c918b788aacc6164953c014730440220" \
                      "2f4338d2710edb1960dcf7136411f065a16bee4e44b86604d64c660315bc55040220238c1c3216fe" \
                      "b31051f7798297317819da1dfa830d24a6a9e38a37367a68ebd101475221037b2987df626510ce25" \
                      "e6ce5fdb716705e23fecb7398b2cbb0a1c0af7ca5da717210345e358653b4580b5bd68d263089a0a" \
                      "2bf9fcc1e145fcf2a3d4b9ab5cd7e1a76752ae000000004f28d63103dfb86a5d92d2daf328bbb35d" \
                      "72239766a5853b7076a90d1745813200000000da00483045022100e89ac8215ee87186de284c419b" \
                      "2522ebfb2ecb8063d0f91942f2ad63f383d3d4022036485902bb1f2e0b2cc645aab8781def27f25e" \
                      "91d8256d48dd48d5cfca1a21c20147304402201449379f1d57f2b7ad1dc0882f59627287a6c32180" \
                      "ffa7637941b0eaa666dd4b022028eb0eed77e1b92de046098c855834a5feeadea55d17160bc6d11d" \
                      "47184e8b51014752210283db605dc305201ab9be509a22d2c83b388002fb54ecd82d86efe83c0a1d" \
                      "35822103146f745eff0ae31fe899aafd27d51d2c0f5b0c03f2f47b3c65bb26ec7581ad8652ae0000" \
                      "000021cb3b00d1f22455e76e86872e00ef556578bcc112071e6a5b4ac02ab682fdb3010000002322" \
                      "00206ea344e9a4a8f8a8983479af2ae3ed29fab153955af14457780a304a6832b9c50000000016dc" \
                      "c4b40a514c43ed61d6c01a9006d7f21a6d30b99b3e580d21578e35002502000000002322002049ea" \
                      "1f7c280b32fee0dce2e1801df2218df59d64614c4fe76c043ee2c80116700000000002005ed0b200" \
                      "00000017a91495c5c19257aa52bd4b702ba1a5e29b8d72a75a3a876d6b4e010000000017a91487b6" \
                      "255a5df746188f0bd22ed0194a40ec98f2de87000000000400473044022100d0d2ded141c9369bcc" \
                      "99de23d3d41d1d99d6cff47126df1b0c4d4797f947eacf021f790f1c112b3425ebc3251d719aae6e" \
                      "f0f9830b688585275591a5353f1f973801483045022100bf06c762e6ab64258d2f2777a66fe32ddd" \
                      "8f36e232b80bf5afa6ff9b9aa73ee0022049caf991fce808e60a9b17499f5e0dc11f6163e3ef7bca" \
                      "8109b72b5695d674210147522103edd556806048b319d71f43466c4415001bb32d8afe3aac06532d" \
                      "3ac210fd0e86210215e16727cf1389b4ee377487385f3ec595841a6bb747eb9c3a5cd559e9b1c8dc" \
                      "52ae040047304402204e9cc87526e148d236d692fa70104d26b8df632f30f4e3be38a2e99cec76d0" \
                      "f80220354ae575c3537c0ad2399a6037a9164b0cb147b12f262efc906649ca7950e2eb0147304402" \
                      "203553bcd1565804ec71c997c87006bd91c639b74a004b19a239c7f551aab5635a0220753f74e065" \
                      "c0b7cdf67d16b00f6a20dda7159a49f20aa493a7889b2851b2fea30147522103b09ac1fa65a55fa4" \
                      "feadea57c4cf417d7490065d8b844ada60c242a441e0e3a42103c0625169b46dbbde3492db7c62f1" \
                      "be8f582131467620cef17335306bad7ef88a52aebe810700"
        print("Deserialize Segwit transaction 2")
        ns = Transaction(non_segwit_view)
        s = Transaction(segwit_view)
        self.assertEqual(s.serialize(segwit=False,hex = True), non_segwit_view)
        self.assertEqual(s.serialize(segwit=True, hex = True), segwit_view)
        self.assertEqual(ns.serialize(segwit=False, hex = True), non_segwit_view)

        tx = "01000000014cee27ba570d2cca50bb9b3f7374c7eb24ec16ffec0a077c84c1cc23b0161804010000008b48304" \
             "502200f1100f78596c8d46fb2f39c570ce6945956a3dd33c48fbdbe53af1c383182ed022100a85b528ea21ee7" \
             "f39b2ec1568ac19f26f4dd4fb9d3dbf70587986de3c2c90fa801410426e4d0890ad5272b2b9a10ca3f518f7e0" \
             "25932caa62f13467e444df89ed25f24f4fc5075cad32f468c8f7f913e30057449d65623726e7102f5eaa326d4" \
             "86ebf7ffffffff020010000000000000006020e908000000001976a914947236437233a71cb033a53932008db" \
             "fe346388e88ac00000000"
        Transaction(tx)
        tx = "01000000011e6c87805dad469ed72b42668b858df90e6b007c6410a7bde65bb1cf687d8409000000006b48304" \
             "502204f3353cf129bb805fb90315aeb6d5ab8e0937129c4b0f1422495e42b6bf0e928022100cbdd2811a4c943" \
             "97aa731c224ee0c7290fea6bc17a9b3ce5957d9937c60f4f97012103e2a0e6a91fa985ce4dda7f048fca5ec82" \
             "64292aed9290594321aa53d37fdea32ffffffff0160e3160000000000fdaf0563ff054effffffff4da3054672" \
             "6f6d2061336136316665663433333039623966623233323235646637393130623033616663353436356239204" \
             "d6f6e205365702031372030303a30303a303020323030310a46726f6d3a205361746f736869204e616b616d6f" \
             "746f203c7361746f7368696e40676d782e636f6d3e0a446174653a204d6f6e2c2031322041756720323031332" \
             "030323a32383a3032202d303230300a5375626a6563743a205b50415443485d2052656d6f7665202853494e47" \
             "4c457c444f55424c4529425954450a0a492072656d6f76656420746869732066726f6d20426974636f696e206" \
             "96e20663165316662346264656638373863386663313536346661343138643434653735343161376538330a69" \
             "6e2053657074203720323031302c20616c6d6f73742074687265652079656172732061676f2e2042652077617" \
             "26e6564207468617420492068617665206e6f740a61637475616c6c7920746573746564207468697320706174" \
             "63682e0a2d2d2d0a206261636b656e64732f626974636f696e642f646573657269616c697a652e7079207c202" \
             "0202038202b2d2d2d2d2d2d2d0a20312066696c65206368616e6765642c203120696e73657274696f6e282b29" \
             "2c20372064656c6574696f6e73282d290a0a64696666202d2d67697420612f6261636b656e64732f626974636" \
             "f696e642f646573657269616c697a652e707920622f6261636b656e64732f626974636f696e642f6465736572" \
             "69616c697a652e70790a696e64657820363632303538332e2e38396239623162203130303634340a2d2d2d206" \
             "12f6261636b656e64732f626974636f696e642f646573657269616c697a652e70790a2b2b2b20622f6261636b" \
             "656e64732f626974636f696e642f646573657269616c697a652e70790a4040202d3238302c3130202b3238302" \
             "c38204040206f70636f646573203d20456e756d65726174696f6e28224f70636f646573222c205b0a20202020" \
             "20224f505f57495448494e222c20224f505f524950454d44313630222c20224f505f53484131222c20224f505" \
             "f534841323536222c20224f505f48415348313630222c0a2020202020224f505f48415348323536222c20224f" \
             "505f434f4445534550415241544f52222c20224f505f434845434b534947222c20224f505f434845434b53494" \
             "7564552494659222c20224f505f434845434b4d554c5449534947222c0a2020202020224f505f434845434b4d" \
             "554c5449534947564552494659222c0a2d2020202028224f505f53494e474c45425954455f454e44222c20307" \
             "84630292c0a2d2020202028224f505f444f55424c45425954455f424547494e222c20307846303030292c0a20" \
             "20202020224f505f5055424b4559222c20224f505f5055424b455948415348222c0a2d2020202028224f505f4" \
             "94e56414c49444f50434f4445222c20307846464646292c0a2b2020202028224f505f494e56414c49444f5043" \
             "4f4445222c2030784646292c0a205d290a200a200a4040202d3239332c3130202b3239312c362040402064656" \
             "6207363726970745f4765744f70286279746573293a0a202020202020202020766368203d204e6f6e650a2020" \
             "202020202020206f70636f6465203d206f72642862797465735b695d290a20202020202020202069202b3d203" \
             "10a2d20202020202020206966206f70636f6465203e3d206f70636f6465732e4f505f53494e474c4542595445" \
             "5f454e4420616e642069203c206c656e286279746573293a0a2d2020202020202020202020206f70636f64652" \
             "03c3c3d20380a2d2020202020202020202020206f70636f6465207c3d206f72642862797465735b695d290a2d" \
             "20202020202020202020202069202b3d20310a200a2020202020202020206966206f70636f6465203c3d206f7" \
             "0636f6465732e4f505f5055534844415441343a0a202020202020202020202020206e53697a65203d206f7063" \
             "6f64650a2d2d200a312e372e392e340a0a6800000000"
        t=  Transaction(tx)
        tx = "0100000001c86c4ddc01f59b748e6a55a6d09c5bce7574fbdec721ca468768b5d6d9e3fb00000000006b48304" \
             "5022076b5504ad7aff614e32159ac055362a1197c9a5e50de48cf4f05c7547b39c0b5022100ea67efb2585aae" \
             "40a53363f48e3e38dfc7387b238f8716fa53a5f0ed51b7c314012102452928340bc618777d217a52f30d8e144" \
             "0d98f561c523a31834a1614106f3c15ffffffff025cf5352f0d0000001976a9141855d5890b8aec536ffc3e59" \
             "cb586e98b34b5b9288ac0bd32204000000001976a9146f3f6845da01e856a426c31dfeef188c06bf574d88ac0" \
             "0000000"
        # Transaction(tx)

        tx = "02000000000117096abdf1191fc4e1aa92e66b0dcc04241cd3949d7cb8f6e3f8b7d2867f9cf80900000000171" \
             "600146ec7cb98e540f2d0b39bed94511d44a24be7f2f0feffffff146e022c0a8b94bb0b38ae93a3cda7265db7" \
             "3d4f658d10634acb4816c4131fcb01000000171600141d48006f03cdc922da829c479feecf3d6bc7d4d8fefff" \
             "fff290d1b0ff9d2eb2c3e09c23f05eb1edce4493d0722b9c6d677692f749ab1b6a50000000017160014acb529" \
             "ba2f57150b6c52781bbd82d224fcda9a33feffffff3b1ad0e2198759c7157c837af79351161630e7b389f43bc" \
             "2db501781a1562a850000000017160014116ba1a4ffec3012cd009de84db9a10a88169ecdfeffffff3b7d62e6" \
             "750593892af6f2cd789db8db3b8d5ec40d3a604aa50ef17010a05e7200000000171600140a2ecd45ea98ff976" \
             "641f11cfd65b489c2931e2efeffffff52f17014e779d564173ecb38e5911e5b43f2d593529729a62cb4768f3d" \
             "4acc39eb0000001716001410c090b35e7d62334c0aab64fd9459e58d2aace1feffffff52f17014e779d564173" \
             "ecb38e5911e5b43f2d593529729a62cb4768f3d4acc396501000017160014eba3843f4d612cd5f73b44d2d2b2" \
             "0a14bc402afffeffffff52f17014e779d564173ecb38e5911e5b43f2d593529729a62cb4768f3d4acc397c010" \
             "00017160014436e3e8e328425e04929c7624534405a1a8ec87efeffffff7987375451a860c131f5661ecfd6ac" \
             "f2206b9eeba90f6d7e2e2bf828fc74000701000000171600149bc9b2c23b4d3aaee5c206de8eb88f64e37d8f8" \
             "cfeffffff867a8c3c48e7995d70b7d39c25cd7b21749b2756f0aa5b0140a32e545baa1f100100000017160014" \
             "8698b478bcd14c7f12d5f43f9f566ba6cfe44172feffffff9790a339ebd0a0caa802cb9168635d738e075032c" \
             "1619f556b7634b2985ee4ce0000000017160014770cc4796bab516455a6e1f3b75343888050f1b2feffffff9c" \
             "bc483b0e911190880e48cb0fad167a33c8e73ecdded9f63e5001a54e0d9c460300000017160014d02d35e9276" \
             "4caf590cb0b309f40bf6ee0673de5feffffffa219e1f09e7c168ed469a9948d88248d7d2561514f22d6e47661" \
             "9fce90876c4b01000000171600144c9d756273fa839887413d8e57429a09263f7757feffffffbb99d3c6a586e" \
             "40ed80e782a0584febb15daf1622e2717daaed4c71e224a5745000000001716001429a23327092f771825a0d4" \
             "3c7c2187865df4d01ffeffffffbf4932f21c4bee27918fa0e400e4fa5e53dbc7893b334980ea5dd9044c6baf6" \
             "d01000000171600144b7063ed9a8f3d7fd14f18a399269256c5e6cbc1feffffffcba7ccd697116c1a259f1292" \
             "0334ec62c54e42fab865ebc1cbcbbabe42d20ab2010000001716001432d881b6893d2360a6cb65732829cfe45" \
             "292d642feffffffddcd78811d2b73feca247c787105c362a23f32da01472fd504579cb0e64c70a70100000017" \
             "160014e4e03eba879ef2f13abb38647767b4e8cbc94356feffffffe9a166d7e4b8372886160893f376084b9f0" \
             "c5b289d06774315cf7a15a0b95cc80000000017160014f3f1e21efa1acc3c6ca1786fe6a38462a38b5855feff" \
             "fffff0707a5ad2c3e052badcc40236b12fb866d203b73b6b7df1e8d5a5a60eece8f9030000001716001416b40" \
             "0b1168b387284c2925c3789700027a83932fefffffff0ff68934c0cd40d10ba612346f26c72fa4a67ea0b0b84" \
             "578729dca540a285e731000000171600140afb8e8d46deabffaeffe3402fd57537a445fa57fefffffff0ff689" \
             "34c0cd40d10ba612346f26c72fa4a67ea0b0b84578729dca540a285e70302000017160014d29b4da896e24b81" \
             "980f3dc5319302a3dec6a6f4fefffffffb6e1c56c1243d038bfdcab451a701e8766baf787aa8d74e6aeb87713" \
             "f67c0120100000017160014725752b632549054dbf0bedaaa091e12dabcc8f0feffffffffaf40d3cfbeefdecf" \
             "14db8bd5ec7ae6f8d1e69c222f951600d6b514ebf3e9420100000017160014330624c35e0e371c15acdcc6325" \
             "7dae5b1930088feffffff021cb81c00000000001976a914ce5cd304c7ba6f89e96aa6c4e92b7455b5359e4e88" \
             "ac51420f00000000001976a9142c997b4e8951e7b3e863bbb439b1050bf0fcdd1d88ac0247304402201f4c1c9" \
             "0d25365fa146106edf11416459b02d4d6d5f4537b37fe5cc523f3a63002206748a144f4012e838705edb505a5" \
             "ef556ecc91df615cab12786369c3d8ab6d3c012102b4323697c2fa1ff13e696f6bc5fe5f67c989cb91b8755e1" \
             "1a7c37213c94e957902483045022100dfe620ca3167e75fac002448069fbface366ee7c57f7f86e9a77113127" \
             "7c91b20220108a436df211fc21909c450e270c765c2c20814643f3804173be88d6863d51260121032522bbee5" \
             "1b2ccad81c4255e2d4eb516ea7943aa8656eaa8ad7b7cd6abcc97370247304402206a4a1836d79004b3430bd6" \
             "1d73e938f0bcc1a56c655b52444d4e047464db0592022067bd8d4965d55e261d1e4e38462f20a8a2610f5ac78" \
             "d551fc95a522b7144589a0121026baf81f20d6a50e6262f433875651e7b192c304105c6911276541e45a67f96" \
             "9402473044022057741ff3470fa4b70b204d621ed737097d3f6cec4a2e43d39c5d6c650117b28d02205b6c3b2" \
             "c92ec047c1c4d3fd7b785474345a038f9842d6a30048737cd471117ea012102fbf1d98a34bd3f1283c9f258f8" \
             "7a6baff2b65710d4f3b77d5589dacc155b6f8d02483045022100bc07cccf6ac51626147ccb0c1ffd91d0bbedb" \
             "6e5df3c798fd8035112bc92070c022034eb7a9658d9ed7b56256155151f8280e871e00e3aefa9b6ea8ae35a27" \
             "0c3b8d0121032004240c860bd92ebcf6c834cdc1d9d28fefe757245d61fe86a02c04994697cd0248304502210" \
             "0c62ecdebd1728f18a746cf1575cdf29cdf6b03dd86d9b7ead96c9a7341c8ad1702205cd92ace00bf53254e1d" \
             "bed3d10f675540dc3a1b1b3dc353ffe3901508bbbb0101210242ff69abeaea31b6fc6e1ea1625179003b9d0d8" \
             "2c729ec78df8ef5fb378e6bc002473044022026217dec2bbc97afbfeba833cf9fa323206c26037a5dce5221cb" \
             "323af142cb1e02206e2ef15be6da7b99e50339a8924de232693494154f792018b6cca4f9f307192e012103ea5" \
             "0f77697dd3467f4876382a447372cd03e5ec567385152e4e91c573c54cf49024730440220256d9ab9ce4c8efb" \
             "7628f7f56e0a59b81c0f973d6c9b89b3ac5c018c54d61a58022064f7c7084c3fb30f118187956e624ce4d4eef" \
             "7acee81a52be1ccd5683e661f6c0121024d812e6254577bdf98d2b52b36d548dfcf03c994b159309839d30c38" \
             "73ec15d5024830450221009618e1427a53dc66e26178416afe6465feb6882d6c4b4a0a3f6b6ce70965a40f022" \
             "03d1b0bdee921bb733674d5b373244c4676982eec20c0f7069917b0e2c1d20f6c012103f8c70a3b0a1bdd9ab4" \
             "0770a1532a2d0f2eb046e4eb56434ba1a9b214e19ed47a0247304402205e8d08cdae61f6c8ba2d17a18b6575e" \
             "4d5e2511f491621d4fa1bebbe89b7794e02200c565ab9379b57b731821e0c9172c65e3339e5a83dbc24d3ecff" \
             "79dc8879edc0012102d4c245cb72bc520be55959df9faea82c470a51942907ad83339ae70c5e2a8efa0247304" \
             "402207bc8e60dbf3ed02d9b08df09572716cf486e1f49927467131b05487f376eede4022040fd95d42a11456a" \
             "2a49eda376edcb0b71baa21cdd562236162806ad9e5d4a4701210287cd827827140bbd304b5feaa9a8c9e36d4" \
             "f5a1da292e16e207039b1fadc488402473044022052e177e94353f03a2bb8aed3a3cbc14cb1095b36d972b356" \
             "dd2e9ef12a38cb95022055624ef65618144c4ffc9125bedfd625594f2926d5c14f5805cf26d278e802f101210" \
             "25493a9da73c46838c6bad1414d1497a8216fbc8e0f46d981167d004b2cc4a6b802483045022100c09f346d36" \
             "af2ab4915e96f1088f431cea41854e6a605dfb86b0f87764269203022000fb0354e7d3d6b42ca8b2c59736a0c" \
             "a9c3f2cc5263c056abc84c7be62bd6184012103f86036ceb2bd6a57b9f39f5aa986e7fc6a0dd1f379e9549396" \
             "2aaf88b228b0b70247304402205be7111758fa4670778571af558ad85c802b9292503df389cd47cd063936185" \
             "f0220481965e1ba34cbf6e7b548af01a34c6185921a6120f07cfe437f33071c83c625012102414eb9f4393b9a" \
             "5f30f9d4ab2612a9782b062ec0a6b13dbbc5037b185ad8f72002483045022100db73b46fd12fbb17663750417" \
             "8f0aa784749b9cd20e7cbfc23586ad7e06fe7fc022038512998ce23ed4b1aff7d07e1654344bc11720976ac0a" \
             "3aeece7018999a35ee01210292e1e3b2079ce6ef363f633cffa07f9a0d316e67c0c8d50eea2da026d3cfc6070" \
             "2473044022000cd297f5b9aaa94e40210bfc47d10d9156be8ba3db665741d7c77c29118f355022033aa9c328e" \
             "90a12bf701167659db4cddbb091af7bb8ae4dc83fd0833667123a4012103c45c84d80cd594a9d014935248622" \
             "a33b8ee1c597334586273aab9a9ef1784d502483045022100a152152ee871ac06bd0f0e385b0e281188504ae9" \
             "40f54c86760ca0bc1bde6e8902207578d03e42670d5172fb589974853402e00136d2e07c9285171ad79435a94" \
             "17e012102cbd3cfc675393c20d9acc51086d8faff48621a216531446ac7c388dcd88decc40247304402200e64" \
             "ece9d74242f638db43fa600af34df9289ce93d1756bc5c3be77973b28d7a02205608d5a304efd41c8024a60bc" \
             "0f1ed44413941fa80239d01a1e95f15499c2bca0121028447cfc8b84edc759eace6dfbbd6138ebeb470da7819" \
             "5a96caf192750487c0c30247304402207244b3a176cf0a7203fbcab9e0f3be5eea21b9ce701a07140b7d591ec" \
             "19234f302205e5c6cc861576a871d55609a52f0895710812cb6a2aaa1279a5e01f2d1874779012102bd77789c" \
             "af99127c39f22ff5432be6c285c9c5bbbebc86cb35d4f1d5f6fa652302483045022100dbad3f4038a81323d97" \
             "f6f6347e31739b7f8d6331ca1fce17ee46f1c9d0b97da022005678968ff1946e1e368a04e87e8954ff5606c42" \
             "57c9a114940d32f39f6fbd1f01210322f53e7d73d997c1875db26464875ad797c6cffe80ba548ff524c360495" \
             "78fae02473044022075aec794771d9d133e9de71bf89e24227c08bf58dec8cdfff0cd781fa3bf9bed02200d26" \
             "e2b9535b9ea8e6aed0ba41aff6dd9f0181418679305c67b5bb888e526df40121020eb887a39d202928ba2abf1" \
             "d16df73aaa17daf9922fd3a3bf6554e730f9c88eb02483045022100dd2d2187fd37e5bf333c1bf0b4dae9f42d" \
             "ef626458bc9283fe6bdf991e9abcab02207e1954eaadbeed240e577aa0f7d329d53b5934edd1da0320964aace" \
             "da09af35f012102ff5bdd1e69f2363d95d80eeeced34bc0de8fc5df9f819cce6ed1d6805beff8ec0247304402" \
             "205ec43c7d919216ad16ed85d75f9d98d1695dddc5810ad0c5635d96b47588eeda02201d71c85602169a109e9" \
             "0e558125033075237d9177553bac1d1d24d8610cb9d0a012103f50abc70096bb6f6f8742e73c5bf0f1bd4d475" \
             "9c1dd2e4486b6fec52b3c8eda6daf10700"

        tx = Transaction(tx)


