# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetRuleResult',
    'AwaitableGetRuleResult',
    'get_rule',
    'get_rule_output',
]

@pulumi.output_type
class GetRuleResult:
    def __init__(__self__, actions=None, function=None, name=None, publish_status=None, rule_arn=None, tags=None):
        if actions and not isinstance(actions, dict):
            raise TypeError("Expected argument 'actions' to be a dict")
        pulumi.set(__self__, "actions", actions)
        if function and not isinstance(function, str):
            raise TypeError("Expected argument 'function' to be a str")
        pulumi.set(__self__, "function", function)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if publish_status and not isinstance(publish_status, str):
            raise TypeError("Expected argument 'publish_status' to be a str")
        pulumi.set(__self__, "publish_status", publish_status)
        if rule_arn and not isinstance(rule_arn, str):
            raise TypeError("Expected argument 'rule_arn' to be a str")
        pulumi.set(__self__, "rule_arn", rule_arn)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def actions(self) -> Optional['outputs.RuleActions']:
        """
        The list of actions that will be executed when a rule is triggered.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def function(self) -> Optional[str]:
        """
        The conditions of a rule.
        """
        return pulumi.get(self, "function")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publishStatus")
    def publish_status(self) -> Optional['RulePublishStatus']:
        """
        The publish status of a rule, either draft or published.
        """
        return pulumi.get(self, "publish_status")

    @property
    @pulumi.getter(name="ruleArn")
    def rule_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the rule.
        """
        return pulumi.get(self, "rule_arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.RuleTag']]:
        """
        One or more tags.
        """
        return pulumi.get(self, "tags")


class AwaitableGetRuleResult(GetRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRuleResult(
            actions=self.actions,
            function=self.function,
            name=self.name,
            publish_status=self.publish_status,
            rule_arn=self.rule_arn,
            tags=self.tags)


def get_rule(rule_arn: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRuleResult:
    """
    Resource Type definition for AWS:Connect::Rule


    :param str rule_arn: The Amazon Resource Name (ARN) of the rule.
    """
    __args__ = dict()
    __args__['ruleArn'] = rule_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:connect:getRule', __args__, opts=opts, typ=GetRuleResult).value

    return AwaitableGetRuleResult(
        actions=__ret__.actions,
        function=__ret__.function,
        name=__ret__.name,
        publish_status=__ret__.publish_status,
        rule_arn=__ret__.rule_arn,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_rule)
def get_rule_output(rule_arn: Optional[pulumi.Input[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRuleResult]:
    """
    Resource Type definition for AWS:Connect::Rule


    :param str rule_arn: The Amazon Resource Name (ARN) of the rule.
    """
    ...
