# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetChannelResult',
    'AwaitableGetChannelResult',
    'get_channel',
    'get_channel_output',
]

@pulumi.output_type
class GetChannelResult:
    def __init__(__self__, channel_arn=None, destinations=None, name=None):
        if channel_arn and not isinstance(channel_arn, str):
            raise TypeError("Expected argument 'channel_arn' to be a str")
        pulumi.set(__self__, "channel_arn", channel_arn)
        if destinations and not isinstance(destinations, list):
            raise TypeError("Expected argument 'destinations' to be a list")
        pulumi.set(__self__, "destinations", destinations)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="channelArn")
    def channel_arn(self) -> Optional[str]:
        return pulumi.get(self, "channel_arn")

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence['outputs.ChannelDestination']]:
        """
        One or more resources to which events arriving through a channel are logged and stored.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")


class AwaitableGetChannelResult(GetChannelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetChannelResult(
            channel_arn=self.channel_arn,
            destinations=self.destinations,
            name=self.name)


def get_channel(channel_arn: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetChannelResult:
    """
    A channel receives events from a specific source (such as an on-premises storage solution or application, or a partner event data source), and delivers the events to one or more event data stores. You use channels to ingest events into CloudTrail from sources outside AWS.
    """
    __args__ = dict()
    __args__['channelArn'] = channel_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cloudtrail:getChannel', __args__, opts=opts, typ=GetChannelResult).value

    return AwaitableGetChannelResult(
        channel_arn=__ret__.channel_arn,
        destinations=__ret__.destinations,
        name=__ret__.name)


@_utilities.lift_output_func(get_channel)
def get_channel_output(channel_arn: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetChannelResult]:
    """
    A channel receives events from a specific source (such as an on-premises storage solution or application, or a partner event data source), and delivers the events to one or more event data stores. You use channels to ingest events into CloudTrail from sources outside AWS.
    """
    ...
